(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     42411,       1299]
NotebookOptionsPosition[     36707,       1109]
NotebookOutlinePosition[     38153,       1149]
CellTagsIndexPosition[     38067,       1144]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PlotRangePadding" :> 
          Documentation`HelpLookup["paclet:ref/PlotRangePadding"], 
          "ImageMargins" :> 
          Documentation`HelpLookup["paclet:ref/ImageMargins"], 
          "PlotRangeClipping" :> 
          Documentation`HelpLookup["paclet:ref/PlotRangeClipping"], 
          "SphericalRegion" :> 
          Documentation`HelpLookup["paclet:ref/SphericalRegion"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PlotRangePadding\"\>", 
       2->"\<\"ImageMargins\"\>", 3->"\<\"PlotRangeClipping\"\>", 
       4->"\<\"SphericalRegion\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Options & Styling" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsOptionsAndStyling"], 
          "Options & Styling for Interactive Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:guide/OptionsAndStylingForInteractiveManipulation"], 
          "Plotting and Image Regions" :> 
          Documentation`HelpLookup["paclet:guide/PlottingAndImageRegions"], 
          "New in 6.0: Graphics & Visualization Options" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Graphics Options & Styling\"\>", 
       2->"\<\"Options & Styling for Interactive Manipulation\"\>", 
       3->"\<\"Plotting and Image Regions\"\>", 
       4->"\<\"New in 6.0: Graphics & Visualization Options\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ImagePadding", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ImagePadding",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ImagePadding"]], "InlineFormula"],
     " \[LineSeparator]is an option for graphics functions that specifies \
what absolute extra padding should be left for extended objects such as thick \
lines and annotations such as tick and axis labels."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Settings for ",
 Cell[BoxData[
  ButtonBox["ImagePadding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImagePadding"]], "InlineFormula"],
 " are given in printer\[CloseCurlyQuote]s points. "
}], "Notes",
 CellID->29967],

Cell[TextData[{
 "Padding specified by ",
 Cell[BoxData[
  ButtonBox["ImagePadding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImagePadding"]], "InlineFormula"],
 " is left inside the region defined by ",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 ", but outside the region defined by ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PlotRangePadding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRangePadding"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->4683],

Cell[TextData[{
 "Possible settings for ",
 Cell[BoxData[
  ButtonBox["ImagePadding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImagePadding"]], "InlineFormula"],
 " are: "
}], "Notes",
 CellID->13460],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["leave no padding", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[
    "leave enough padding for all objects that are present ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["m", "TI"], Cell[
    "the same padding on all sides ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        StyleBox["left", "TI"], ",", 
        StyleBox["right", "TI"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["bottom", "TI"], ",", 
        StyleBox["top", "TI"]}], "}"}]}], "}"}], Cell[
    "different padding on different sides ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->1714],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PlotRangeClipping",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRangeClipping"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", objects such as thick lines are still clipped at the edge of the plot \
range region, even if image padding has been specified. Annotations such as \
tick and axis labels are not clipped in this case."
}], "Notes",
 CellID->68265793]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->197962757],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->40522096],

Cell["Leave no padding outside of the plot range:", "ExampleText",
 CellID->326774300],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Thickness", "[", ".3", "]"}], ",", "Pink", ",", 
     RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
   RowBox[{"ImagePadding", "\[Rule]", "None"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->146898665],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.5, 0.5], Thickness[0.3], CircleBox[{0, 0}]},
  Frame->True,
  ImagePadding->None]], "Output",
 ImageSize->{154, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->68609767]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->616186802],

Cell["Leave enough padding for all objects that are present:", "ExampleText",
 CellID->50922966],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", ".3", "]"}], ",", "Pink", ",", 
       RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
     RowBox[{"ImagePadding", "\[Rule]", "All"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"FrameMargins", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->272996428],

Cell[BoxData[
 FrameBox[
  GraphicsBox[
   {RGBColor[1, 0.5, 0.5], Thickness[0.3], CircleBox[{0, 0}]},
   Frame->True,
   ImagePadding->All],
  FrameMargins->0,
  StripOnInput->False]], "Output",
 ImageSize->{156, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->106432707]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->143523097],

Cell["Specify the same padding for all sides in printer's points:", \
"ExampleText",
 CellID->261359824],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{"Graphics", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Thickness", "[", ".3", "]"}], ",", "Pink", ",", 
      RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
    RowBox[{"ImagePadding", "\[Rule]", "40"}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->107430734],

Cell[BoxData[
 FrameBox[
  GraphicsBox[
   {RGBColor[1, 0.5, 0.5], Thickness[0.3], CircleBox[{0, 0}]},
   Frame->True,
   ImagePadding->40],
  StripOnInput->False]], "Output",
 ImageSize->{164, 162},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->22144315]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->238017468],

Cell["Specify different padding on each side:", "ExampleText",
 CellID->2513601],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{"Graphics", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Thickness", "[", ".2", "]"}], ",", "Pink", ",", 
      RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
    RowBox[{"ImagePadding", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"40", ",", "10"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "5"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->469066761],

Cell[BoxData[
 FrameBox[
  GraphicsBox[
   {RGBColor[1, 0.5, 0.5], Thickness[0.2], CircleBox[{0, 0}]},
   Frame->True,
   ImagePadding->{{40, 10}, {20, 5}}],
  StripOnInput->False]], "Output",
 ImageSize->{164, 137},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->110033886]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[TextData[{
 "Thick lines and labels outside of the bounding box can be clipped without \
",
 Cell[BoxData[
  ButtonBox["ImagePadding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImagePadding"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->26905627],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"EdgeForm", "[", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.1", "]"}], ",", "Pink"}], "]"}], "]"}],
        ",", 
       RowBox[{"Cuboid", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "\"\<z-axis\>\""}], "}"}]}], ",", 
     RowBox[{"ImagePadding", "\[Rule]", "None"}]}], "]"}], ",", 
   RowBox[{"FrameMargins", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->67221593],

Cell[BoxData[
 FrameBox[
  Graphics3DBox[
   {EdgeForm[{RGBColor[1, 0.5, 0.5], Thickness[0.1]}], CuboidBox[{0, 0, 0}]},
   Axes->True,
   AxesLabel->{
     FormBox["x", TraditionalForm], 
     FormBox["y", TraditionalForm], 
     FormBox["\"z-axis\"", TraditionalForm]},
   ImagePadding->None,
   ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]],
  FrameMargins->0,
  StripOnInput->False]], "Output",
 ImageSize->{156, 167},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->156615983]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25196821],

Cell["Leave enough padding for labels: ", "ExampleText",
 CellID->254549396],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"EdgeForm", "[", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.1", "]"}], ",", "Pink"}], "]"}], "]"}],
        ",", 
       RowBox[{"Cuboid", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "\"\<z-axis\>\""}], "}"}]}], ",", 
     RowBox[{"ImagePadding", "\[Rule]", "All"}]}], "]"}], ",", 
   RowBox[{"FrameMargins", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->352847106],

Cell[BoxData[
 FrameBox[
  Graphics3DBox[
   {EdgeForm[{RGBColor[1, 0.5, 0.5], Thickness[0.1]}], CuboidBox[{0, 0, 0}]},
   Axes->True,
   AxesLabel->{
     FormBox["x", TraditionalForm], 
     FormBox["y", TraditionalForm], 
     FormBox["\"z-axis\"", TraditionalForm]},
   ImagePadding->All,
   ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]],
  FrameMargins->0,
  StripOnInput->False]], "Output",
 ImageSize->{156, 162},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->253318931]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21667574],

Cell["Specify the same padding for all sides in printers' points:", \
"ExampleText",
 CellID->117888487],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"EdgeForm", "[", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.1", "]"}], ",", "Pink"}], "]"}], "]"}],
        ",", 
       RowBox[{"Cuboid", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"ImagePadding", "\[Rule]", "30"}]}], "]"}], ",", 
   RowBox[{"FrameMargins", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->46056034],

Cell[BoxData[
 FrameBox[
  Graphics3DBox[
   {EdgeForm[{RGBColor[1, 0.5, 0.5], Thickness[0.1]}], CuboidBox[{0, 0, 0}]},
   Axes->True,
   ImagePadding->30,
   ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzVmllvFEcQx4fpOez17noNtrDBx/rAODa+DQFsDidKojwgIJEQrxZaCR4i
IodXlG/BYyT4SPk+o6Srj9nq6urZWduQYNmzc3T/6l/V1T3dvX5y8u5177eT
d29enXR/Oj35/fWbV390f3x7Km+JS1EUfZB/f01H8vwfeab+PhRFIR988eNT
eRRSQAxXcFKonyiWpw9UiWfkiYBD0r+OoqOvohx4Cl5l5vMBisJLeUyK9+/v
q6sX8pjLq3vq6ld5zOSVstHr9eA0loe76um+oQmkIoJ4yr9JeZ7KkiAmljWF
PP9WPd/zNObEi7axCpyEsV6X00Qc7YWGyGMEeu7U5DSML3BrBDiJ5mhUXEFK
TYQaSAmQ4rebfyYeCTTdriBhTTkixjZGmhQllp6WdOT1gdN2uflMDE+YmOc1
GI+RBnVbS1B6Rm19UdbXOhPM21echyi+8Dkm66YD66oYRYcVGtpDcO6RFuow
dYVXd1fVvcb0g8KMI5cNNzHyrlhujjnFx1MUXU2d8XIg8e6MI9UCZYE0Ek1a
S47iWJpSRVF/2qltr0Wy5GrQhh/n7dpWGsTKNdaKYDypb2OE2JgN2vA92apt
JUVWgD7PWklYK5tObtmRm/bTRZaYMrHRvFWS58vB+r6iW4qwgnorKFhlCRmj
oF9fIAVrbP2cqb+h6i9DJJD9jcBIk7E+rCvGdEWPVSE2HN2rtgIWOI2af7VG
btBRe7vCiu/HNxduZ4R4A6dr57Lit+ooE7HPYcOP180qKxm+o9tdjYssv8H4
cNPJKttXqd4wz9e7qohLJtcHU8ZYyg2HUr4jJQHeEFssqcn4d2NINU1WzYqi
LJr+P5jSYjJyeUhGm/Gmz+CiwmdVm/VoySFhNbssZZxRcxaGr2RxSEqHUbJ4
hriEOV2mjfYCYw8Xlz6FerT/2SkxuV9NCUQlKZWUOqaY945dMambhgqPKsjE
x66iTHpjW17esW8zKP0/54pyCFZlD85NtWsw2nIXQy7v6Jkv6TN7QRs0w7pO
fthVmV7+WslAyz3ahJdrmrXAZCuM+GPnIsBsq830Gi5uC4oyT8YBiMuaoYCM
NNBz+7W50WjFEEAG7cVQjBv3XSL2aknSxg1thKHRN1E1bQHRmkysWkz7h2mz
KFYdhtYcijaD4tZSzz79bUedNEB3c0Oz55jRfQr5DexUorPCj+YYE835ksq1
9gQhjwbI3NzMJWO9HRRZaKc2Q42HprZIhC8HqNxcOExtEOqUpOYMlc7iq6kZ
ietMIK45k2NhqkBxBepcBdXNLc2ctcz+O4Z4vxQgZoOISGUT8VYDbcStYueC
xFFEXA8QuZV5mJgh4mbA5yRI7BTh/e2YWLPvW9sX9gLWuF0XbW2CWFFznNRZ
WYHtwuxWGa/uBOzETMadxQ7YuB9oi/PaoOMfvDkeVthyM7PCEln1+iMtXH8X
iFwk+ruJA1rHsSOMHWEy4XuGT/as5e9smWl45Qszo8TtwQGiv6eqiVU7NGUO
BaLgr440s84eg92ZiqvY6Lo+ufwmA5GOrYUUq7UtV59tc8S23eML4gq2HUu6
9z3IMNHQZNuOj0ise2Yv/LqTDTa/clQ7RrXtN0261joppaIvS8rf6Mj3oax3
i3itj4fmjeva2LRlScveNqUTMz/VkdkiXu+gUnnZV3eI7nVTChqzUdh32i5h
rSAWzPH1vsI+YS2gUsDSO1cbTG+z61KBbEwTJRtlnMMruXIENAquEJ3bAxlF
0R8pcB7a+ZpVc1CHBA9RT8mJmrsBhl1FMiMbkAjlqIKClVia3cu2nhw7rWJX
g5D9qc21nvpR362CxR9UDfgmDeZzP6urR/IItCfq6tiMEb+oK/jeLDQ3eK5K
HJEn/hvj2VdR7rBwxw7t3X/1PwfRpX8By76PLg==\
\>"]],
  FrameMargins->0,
  StripOnInput->False]], "Output",
 ImageSize->{156, 162},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->1048655362]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->916031387],

Cell["Specify different padding on different sides:", "ExampleText",
 CellID->140939525],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"EdgeForm", "[", 
        RowBox[{"Directive", "[", 
         RowBox[{
          RowBox[{"Thickness", "[", "0.1", "]"}], ",", "Pink"}], "]"}], "]"}],
        ",", 
       RowBox[{"Cuboid", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"ImagePadding", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"40", ",", "40"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"10", ",", "10"}], "}"}]}], "}"}]}]}], "]"}], ",", 
   RowBox[{"FrameMargins", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->120384357],

Cell[BoxData[
 FrameBox[
  Graphics3DBox[
   {EdgeForm[{RGBColor[1, 0.5, 0.5], Thickness[0.1]}], CuboidBox[{0, 0, 0}]},
   Axes->True,
   ImagePadding->{{40, 40}, {10, 10}},
   ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzVWE1vFDkQNe3uaWYyQMSiKCJ8hLAkISQkEAgECF8HkNACJ+5EaCQ4IFZZ
rtH+C+7wk/b/tBaXy9VTXS4PHkBIRDPdHsfvVdVzudrt5/sf347e739892Z/
8enB/t9v3735Z/HJhwPXZY8YYz657+t549r/u5b//tU0jXWNwt0NNBr/ZwrX
fAgN81z8x8KlHP825sFvMQ4ihah64Y7RffLXV6BCc3h43//aCSMsYzagkfv+
4do9N3LP992MbNXCm+PuUrrxgDV2NBq5tvuYe5n4mYC3Hg9IYxyLb97N5Ogz
Hyq4O4JiAr4K8QOuCrgaTAf/wT7g70zAc/s9FgP4XXzY+LdM8pH6dbiXzHu4
l4QuWzVDPLse/ziML31WHx7WNL5qxzObtz1mSZnxJqyCU8J+P4PvQqRJGfXM
MnWBb0aoAs1C/L6VzU55R5qfcOxWYy95FDvZ/EOmCvK6hrPhPqa1VXPu5vMB
0ynfEs9CWgFwPUVWOhEUzoyXs+28mW2pFprNTWWBcojqSyXmd15lsxHbDc+2
KbJ4IY22LdqP3Pb4DZG1Z1V8GVlH9HqD9ZDQ55XcrCLs9Vbp1FrynZR9IbKl
FLeI65pnX9Tnscd7MEcA86fC3Yv8/pnMcsVuTeKuJHeb42EladrUkf8TbdSx
/3C9pDAfjZg3fyazmM+rnWyhVVNQLUERjKZzP/ITua4ARwZ+EOE3WrzvR7j7
aLEMlFjWp8DPRNYRvRa8BxVW1NWqWb7SwfLIl1WO2Pq0DEPvxTie78J3PFhr
GUg95NBVyMFj/3T4yyICaK4o85fCn1PqHu0aed2zYX5zec+qzymsHYjEdbeq
cB4Tc/WLGW1bGHyupvnGOZ3ioz2pb/AkSXvZ0fLyBF5Wh5m3sHbrTF6ae9qz
8n3KRcczyMhCZFpV1tE5d5lxbSAo1TXcxYIHZwLGBozc98U1MG1/nnEd1SsK
Yx/zdFfjXNABwMOIZZDJcpL5AmzFl//8LqvLFj8hVsd8tk0fMyvYeo5NUyt+
MiLfiqLWUHAOEpzxczzN2WecfXc/rkY9DWPFcgoYT6qM8V5pzNit1VZEPZfm
YzowNrZihozndEK9KoupzzQ7n2AqRQVCpmXlaVAyvZbU+OL9tPfILDTpUxZt
T0zRL6tW4ncGtHJGsMcnIfjGZ/wRAv6BlTXVSvyeM5UVphvUjKsJ9Y3tvhdO
sNHdLYN6wg5M4rZiR7735seBOdCevThu9zGaDbnvz7UBPZZmpdV+m2YkZcFh
l9vMorfNZIZV7UoN66LlV88wkDnnjVnOwHacSSM8m8nntIriW6T4D/AWpDTz
97qYyekVoPmjlbsVFCim9q9qxk9vqmEQ+6aSC8gqTxxq4ct6QNqOLzfEqJUw
inYXmLk7bBSfiUU2GnZHWC1viSzG60IYW4Wx+J6zy+KE+xxjhEqBb7PXmvRu
uogszYZ5rAIHnqFsRRrzXSmvtwPhw+438U1Da1LOlxVcezlc4bFlDZ63UByP
EljaDdPZqOfBgm6KgH0yAcvtwm94cj/r6E47WcgtOO9+4f+Lp+UQUarWvPQj
7kexSS9e/Bbj9pruCsPozJGvFbHYeg==\
\>"]],
  FrameMargins->0,
  StripOnInput->False]], "Output",
 ImageSize->{156, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->352378205]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImagePadding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImagePadding"]], "InlineFormula"],
 " is defined within ",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->261838529],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Framed", "[", 
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Pink", ",", 
        RowBox[{"Disk", "[", "]"}]}], "}"}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"ImagePadding", "\[Rule]", "k"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "100"}], ",", 
      RowBox[{"FrameTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "None"}], "}"}], ",",
          
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "None"}], "}"}]}], 
        "}"}]}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "20", ",", "30"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->17799],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    GraphicsBox[
     {RGBColor[1, 0.5, 0.5], DiskBox[{0, 0}]},
     Frame->True,
     FrameTicks->{{{{-1, 
          FormBox[
           RowBox[{"-", "1"}], TraditionalForm]}, {1, 
          FormBox["1", TraditionalForm]}}, None}, {{{-1, 
          FormBox[
           RowBox[{"-", "1"}], TraditionalForm]}, {1, 
          FormBox["1", TraditionalForm]}}, None}},
     ImagePadding->10,
     ImageSize->100],
    StripOnInput->False], ",", 
   FrameBox[
    GraphicsBox[
     {RGBColor[1, 0.5, 0.5], DiskBox[{0, 0}]},
     Frame->True,
     FrameTicks->{{{{-1, 
          FormBox[
           RowBox[{"-", "1"}], TraditionalForm]}, {1, 
          FormBox["1", TraditionalForm]}}, None}, {{{-1, 
          FormBox[
           RowBox[{"-", "1"}], TraditionalForm]}, {1, 
          FormBox["1", TraditionalForm]}}, None}},
     ImagePadding->20,
     ImageSize->100],
    StripOnInput->False], ",", 
   FrameBox[
    GraphicsBox[
     {RGBColor[1, 0.5, 0.5], DiskBox[{0, 0}]},
     Frame->True,
     FrameTicks->{{{{-1, 
          FormBox[
           RowBox[{"-", "1"}], TraditionalForm]}, {1, 
          FormBox["1", TraditionalForm]}}, None}, {{{-1, 
          FormBox[
           RowBox[{"-", "1"}], TraditionalForm]}, {1, 
          FormBox["1", TraditionalForm]}}, None}},
     ImagePadding->30,
     ImageSize->100],
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{371, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->433442938]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->134431932],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImageMargins",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageMargins"]], "InlineFormula"],
 " is defined outside of ",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->148872213],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Framed", "[", 
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Pink", ",", 
        RowBox[{"Disk", "[", "]"}]}], "}"}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"ImageMargins", "\[Rule]", "k"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "70"}], ",", 
      RowBox[{"FrameTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "None"}], "}"}], ",",
          
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "None"}], "}"}]}], 
        "}"}]}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "20", ",", "30"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->65892421],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    GraphicsBox[
     {RGBColor[1, 0.5, 0.5], DiskBox[{0, 0}]},
     Frame->True,
     FrameTicks->{{{{-1, 
          FormBox[
           RowBox[{"-", "1"}], TraditionalForm]}, {1, 
          FormBox["1", TraditionalForm]}}, None}, {{{-1, 
          FormBox[
           RowBox[{"-", "1"}], TraditionalForm]}, {1, 
          FormBox["1", TraditionalForm]}}, None}},
     ImageMargins->10,
     ImageSize->70],
    StripOnInput->False], ",", 
   FrameBox[
    GraphicsBox[
     {RGBColor[1, 0.5, 0.5], DiskBox[{0, 0}]},
     Frame->True,
     FrameTicks->{{{{-1, 
          FormBox[
           RowBox[{"-", "1"}], TraditionalForm]}, {1, 
          FormBox["1", TraditionalForm]}}, None}, {{{-1, 
          FormBox[
           RowBox[{"-", "1"}], TraditionalForm]}, {1, 
          FormBox["1", TraditionalForm]}}, None}},
     ImageMargins->20,
     ImageSize->70],
    StripOnInput->False], ",", 
   FrameBox[
    GraphicsBox[
     {RGBColor[1, 0.5, 0.5], DiskBox[{0, 0}]},
     Frame->True,
     FrameTicks->{{{{-1, 
          FormBox[
           RowBox[{"-", "1"}], TraditionalForm]}, {1, 
          FormBox["1", TraditionalForm]}}, None}, {{{-1, 
          FormBox[
           RowBox[{"-", "1"}], TraditionalForm]}, {1, 
          FormBox["1", TraditionalForm]}}, None}},
     ImageMargins->30,
     ImageSize->70],
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{401, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->52318366]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotRangePadding",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRangePadding"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImageMargins",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageMargins"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotRangeClipping",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRangeClipping"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SphericalRegion",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SphericalRegion"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->422810485],

Cell[TextData[ButtonBox["Graphics Options & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], "MoreAbout",
 CellID->387708663],

Cell[TextData[ButtonBox["Options & Styling for Interactive Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/OptionsAndStylingForInteractiveManipulation"]], "MoreAbout",
 CellID->189864261],

Cell[TextData[ButtonBox["Plotting and Image Regions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PlottingAndImageRegions"]], "MoreAbout",
 CellID->118597489],

Cell[TextData[ButtonBox["New in 6.0: Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "MoreAbout",
 CellID->781202756]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ImagePadding - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 48, 11.8670518}", "context" -> "System`", 
    "keywords" -> {
     "inside image padding", "image padding", "image margins", 
      "inside image margins"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ImagePadding is an option for graphics functions that specifies what \
absolute extra padding should be left for extended objects such as thick \
lines and annotations such as tick and axis labels.", 
    "synonyms" -> {"image padding"}, "title" -> "ImagePadding", "type" -> 
    "Symbol", "uri" -> "ref/ImagePadding"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8475, 252, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->197962757]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 37924, 1137}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2229, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2852, 76, 1577, 37, 70, "ObjectNameGrid"],
Cell[4432, 115, 580, 15, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5049, 135, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5527, 152, 242, 8, 70, "Notes",
 CellID->29967],
Cell[5772, 162, 672, 23, 70, "Notes",
 CellID->4683],
Cell[6447, 187, 208, 8, 70, "Notes",
 CellID->13460],
Cell[6658, 197, 1274, 34, 70, "2ColumnTableMod",
 CellID->1714],
Cell[7935, 233, 503, 14, 70, "Notes",
 CellID->68265793]
}, Closed]],
Cell[CellGroupData[{
Cell[8475, 252, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->197962757],
Cell[CellGroupData[{
Cell[8860, 266, 147, 5, 70, "ExampleSection",
 CellID->40522096],
Cell[9010, 273, 86, 1, 70, "ExampleText",
 CellID->326774300],
Cell[CellGroupData[{
Cell[9121, 278, 351, 10, 28, "Input",
 CellID->146898665],
Cell[9475, 290, 321, 10, 171, "Output",
 CellID->68609767]
}, Open  ]],
Cell[9811, 303, 125, 3, 70, "ExampleDelimiter",
 CellID->616186802],
Cell[9939, 308, 96, 1, 70, "ExampleText",
 CellID->50922966],
Cell[CellGroupData[{
Cell[10060, 313, 462, 13, 70, "Input",
 CellID->272996428],
Cell[10525, 328, 379, 13, 167, "Output",
 CellID->106432707]
}, Open  ]],
Cell[10919, 344, 125, 3, 70, "ExampleDelimiter",
 CellID->143523097],
Cell[11047, 349, 104, 2, 70, "ExampleText",
 CellID->261359824],
Cell[CellGroupData[{
Cell[11176, 355, 389, 11, 70, "Input",
 CellID->107430734],
Cell[11568, 368, 358, 12, 183, "Output",
 CellID->22144315]
}, Open  ]],
Cell[11941, 383, 125, 3, 70, "ExampleDelimiter",
 CellID->238017468],
Cell[12069, 388, 80, 1, 70, "ExampleText",
 CellID->2513601],
Cell[CellGroupData[{
Cell[12174, 393, 558, 17, 70, "Input",
 CellID->469066761],
Cell[12735, 412, 376, 12, 158, "Output",
 CellID->110033886]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13160, 430, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[13384, 439, 266, 9, 70, "ExampleText",
 CellID->26905627],
Cell[CellGroupData[{
Cell[13675, 452, 705, 20, 70, "Input",
 CellID->67221593],
Cell[14383, 474, 3173, 62, 188, "Output",
 CellID->156615983]
}, Open  ]],
Cell[17571, 539, 124, 3, 70, "ExampleDelimiter",
 CellID->25196821],
Cell[17698, 544, 76, 1, 70, "ExampleText",
 CellID->254549396],
Cell[CellGroupData[{
Cell[17799, 549, 705, 20, 70, "Input",
 CellID->352847106],
Cell[18507, 571, 3029, 59, 183, "Output",
 CellID->253318931]
}, Open  ]],
Cell[21551, 633, 124, 3, 70, "ExampleDelimiter",
 CellID->21667574],
Cell[21678, 638, 104, 2, 70, "ExampleText",
 CellID->117888487],
Cell[CellGroupData[{
Cell[21807, 644, 575, 17, 70, "Input",
 CellID->46056034],
Cell[22385, 663, 2389, 47, 183, "Output",
 CellID->1048655362]
}, Open  ]],
Cell[24789, 713, 125, 3, 70, "ExampleDelimiter",
 CellID->916031387],
Cell[24917, 718, 88, 1, 70, "ExampleText",
 CellID->140939525],
Cell[CellGroupData[{
Cell[25030, 723, 752, 23, 70, "Input",
 CellID->120384357],
Cell[25785, 748, 2093, 42, 121, "Output",
 CellID->352378205]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27927, 796, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[28168, 805, 331, 12, 70, "ExampleText",
 CellID->261838529],
Cell[CellGroupData[{
Cell[28524, 821, 1015, 33, 70, "Input",
 CellID->17799],
Cell[29542, 856, 1550, 49, 133, "Output",
 CellID->433442938]
}, Open  ]],
Cell[31107, 908, 125, 3, 70, "ExampleDelimiter",
 CellID->134431932],
Cell[31235, 913, 335, 12, 70, "ExampleText",
 CellID->148872213],
Cell[CellGroupData[{
Cell[31595, 929, 1017, 33, 70, "Input",
 CellID->65892421],
Cell[32615, 964, 1546, 49, 166, "Output",
 CellID->52318366]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[34222, 1020, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[34541, 1031, 1001, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[35579, 1071, 319, 9, 70, "MoreAboutSection",
 CellID->422810485],
Cell[35901, 1082, 163, 3, 70, "MoreAbout",
 CellID->387708663],
Cell[36067, 1087, 204, 4, 70, "MoreAbout",
 CellID->189864261],
Cell[36274, 1093, 161, 3, 70, "MoreAbout",
 CellID->118597489],
Cell[36438, 1098, 197, 4, 70, "MoreAbout",
 CellID->781202756]
}, Open  ]],
Cell[36650, 1105, 27, 0, 70, "History"],
Cell[36680, 1107, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

