(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     39244,       1299]
NotebookOptionsPosition[     32653,       1068]
NotebookOutlinePosition[     34047,       1107]
CellTagsIndexPosition[     33961,       1102]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Solving Logical Combinations of Equations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SolvingLogicalCombinationsOfEquations"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Solving Logical Combinations of Equations\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LogicalExpand" :> 
          Documentation`HelpLookup["paclet:ref/LogicalExpand"], "If" :> 
          Documentation`HelpLookup["paclet:ref/If"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"LogicalExpand\"\>", 
       2->"\<\"If\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Logic & Boolean Algebra" :> 
          Documentation`HelpLookup["paclet:guide/LogicAndBooleanAlgebra"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Logic & Boolean Algebra\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Implies ",
 StyleBox["(\[Implies])", "OperatorCharacter"]
}], "ObjectName",
 CellID->5354],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Implies",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Implies"], "[", 
       RowBox[{
        StyleBox["p", "TI"], ",", 
        StyleBox["q", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents the logical implication ",
     Cell[BoxData[
      FormBox[
       RowBox[{"p", "\[DoubleRightArrow]", "q"}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->672]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Implies",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Implies"], "[", 
   RowBox[{
    StyleBox["p", "TI"], ",", 
    StyleBox["q", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"!", "p"}], "||", "q"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->18446],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Implies",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Implies"], "[", 
   RowBox[{
    StyleBox["p", "TI"], ",", 
    StyleBox["q", "TI"]}], "]"}]], "InlineFormula"],
 " can be input in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " as ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", "\[Implies]", "q"}], TraditionalForm]], "InlineMath"],
 ". The character ",
 Cell[BoxData["\[Implies]"], "InlineFormula"],
 " can be entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]=>\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " or ",
 Cell[TextData[ButtonBox["\\[Implies]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Implies"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->25156]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->639642630],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->840658571],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Implies", "[", 
  RowBox[{"True", ",", "a"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12125704],

Cell[BoxData["a"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->135427430]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Implies", "[", 
  RowBox[{"False", ",", "a"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->73404681],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->329607818]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->37477389],

Cell[TextData[{
 "Enter using ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]=>\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ":"
}], "ExampleText",
 CellID->8119997],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", "\[Implies]", "q"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->162312622],

Cell[BoxData[
 RowBox[{"Implies", "[", 
  RowBox[{"p", ",", "q"}], "]"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->100141907]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14127],

Cell["Certain arguments automatically simplifies:", "ExampleText",
 CellID->84982772],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Implies", "[", 
    RowBox[{"False", ",", "x"}], "]"}], ",", 
   RowBox[{"Implies", "[", 
    RowBox[{"True", ",", "x"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->316456057],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "x"}], "}"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->85756947]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->55020209],

Cell[TextData[{
 "Expand in terms of ",
 Cell[BoxData[
  ButtonBox["And",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/And"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Or",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Or"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Not",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Not"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->351195933],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", 
  RowBox[{"Implies", "[", 
   RowBox[{"x", ",", "y"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->203817188],

Cell[BoxData[
 RowBox[{"y", "||", 
  RowBox[{"!", "x"}]}]], "Output",
 ImageSize->{48, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->165742065]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->686947317],

Cell["Do symbolic simplification:", "ExampleText",
 CellID->622451923],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Implies", "[", 
   RowBox[{"p", ",", 
    RowBox[{"Implies", "[", 
     RowBox[{"q", ",", "p"}], "]"}]}], "]"}], "//", "Simplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->376852623],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->488851867]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12187583],

Cell["TraditionalForm formatting:", "ExampleText",
 CellID->292737182],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Implies", "[", 
   RowBox[{"x", ",", "y"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->477491846],

Cell[BoxData[
 FormBox[
  RowBox[{"x", "\[Implies]", "y"}], TraditionalForm]], "Output",
 ImageSize->{33, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->157174990]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11710154],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Implies",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Implies"]], "InlineFormula"],
 " to combine two regions:"
}], "ExampleText",
 CellID->37965020],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{"Implies", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
     RowBox[{
      RowBox[{"x", "+", "y"}], ">", "0"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->958192352],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->904728901]
}, Open  ]],

Cell["Symbolic reduction:", "ExampleText",
 CellID->9643715],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"Implies", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
     RowBox[{
      RowBox[{"x", "+", "y"}], ">", "0"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->311704166],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[LessEqual]", 
   RowBox[{"-", "1"}]}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "<", "x", "\[LessEqual]", 
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["2"]]}]}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", "\[LessEqual]", 
       RowBox[{"-", 
        SqrtBox[
         RowBox[{"1", "-", 
          SuperscriptBox["x", "2"]}]]}]}], "||", 
      RowBox[{"y", "\[GreaterEqual]", 
       SqrtBox[
        RowBox[{"1", "-", 
         SuperscriptBox["x", "2"]}]]}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["2"]]}], "<", "x", "<", 
     FractionBox["1", 
      SqrtBox["2"]]}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", "\[LessEqual]", 
       RowBox[{"-", 
        SqrtBox[
         RowBox[{"1", "-", 
          SuperscriptBox["x", "2"]}]]}]}], "||", 
      RowBox[{"y", ">", 
       RowBox[{"-", "x"}]}]}], ")"}]}], ")"}], "||", 
  RowBox[{"x", "\[GreaterEqual]", 
   FractionBox["1", 
    SqrtBox["2"]]}]}]], "Output",
 ImageSize->{381, 75},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->260671543]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->292981727],

Cell["\<\
Find the area of the complement of the difference of sets given by algebraic \
conditions:\
\>", "ExampleText",
 CellID->100096229],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"Boole", "[", 
     RowBox[{"Implies", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "2"}], "+", 
         RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "+", 
         RowBox[{"y", "^", "2"}]}], "<", "2"}]}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{
       RowBox[{"-", "3"}], "/", "2"}], ",", 
      RowBox[{"5", "/", "2"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->310451651],

Cell[BoxData["15"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->865199023]
}, Open  ]],

Cell["This shows the set:", "ExampleText",
 CellID->2908850],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{"Implies", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"-", "3"}], "/", "2"}], ",", 
     RowBox[{"5", "/", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->167686269],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->311379628]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5806998],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Implies",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Implies"]], "InlineFormula"],
 " to express set inclusion:"
}], "ExampleText",
 CellID->218471328],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{"ForAll", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", 
    RowBox[{"Implies", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"2", 
         RowBox[{"y", "^", "2"}]}]}], "<", "1"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], "<", "1"}]}], "]"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->346963841],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->266623981]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"2", 
        RowBox[{"y", "^", "2"}]}]}], "<", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->304390890],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->542752952]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->581193942],

Cell[TextData[{
 "Truth table for ",
 Cell[BoxData[
  ButtonBox["Implies",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Implies"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->470387246],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Outer", "[", 
   RowBox[{"Implies", ",", 
    RowBox[{"{", 
     RowBox[{"True", ",", "False"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"True", ",", "False"}], "}"}]}], "]"}], "//", "Grid"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->95768180],

Cell[BoxData[
 TagBox[GridBox[{
    {"True", "False"},
    {"True", "True"}
   }],
  "Grid"]], "Output",
 ImageSize->{75, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->625162112]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->111472470],

Cell[TextData[{
 "Implication of conditions in ",
 Cell[BoxData[
  ButtonBox["Boole",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Boole"]], "InlineFormula"],
 " functions:"
}], "ExampleText",
 CellID->257207371],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Boole", "[", 
   RowBox[{"Implies", "[", 
    RowBox[{"a", ",", "b"}], "]"}], "]"}], "+", 
  RowBox[{
   RowBox[{"Boole", "[", "a", "]"}], 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"Boole", "[", "b", "]"}]}], ")"}]}], "-", "1"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->551050724],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  RowBox[{
   RowBox[{"Boole", "[", "a", "]"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"Boole", "[", "b", "]"}]}], ")"}]}], "+", 
  RowBox[{"Boole", "[", 
   RowBox[{"Implies", "[", 
    RowBox[{"a", ",", "b"}], "]"}], "]"}]}]], "Output",
 ImageSize->{330, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->195956690]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->40654382],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->847828896]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22309],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LogicalExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LogicalExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["If",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/If"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->508]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20879],

Cell[TextData[ButtonBox["Solving Logical Combinations of Equations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SolvingLogicalCombinationsOfEquations"]], "Tutorials",
 CellID->4500]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->248129578],

Cell[TextData[ButtonBox["Logic & Boolean Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LogicAndBooleanAlgebra"]], "MoreAbout",
 CellID->196540961]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Implies (\[Implies]) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 48, 25.2736450}", "context" -> "System`", 
    "keywords" -> {
     "material implication", "implication", "less equal", "not unless", 
      "conditional inclusion", "subset", "Boolean algebra", 
      "switching algebra", "propositional logic"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Implies[p, q] represents the logical implication p \\[DoubleRightArrow] \
q. ", "synonyms" -> {}, "title" -> "Implies", "type" -> "Symbol", "uri" -> 
    "ref/Implies"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5259, 184, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->639642630]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 33818, 1095}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1912, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2535, 76, 108, 4, 70, "ObjectName",
 CellID->5354],
Cell[2646, 82, 663, 22, 70, "Usage",
 CellID->672]
}, Open  ]],
Cell[CellGroupData[{
Cell[3346, 109, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3824, 126, 396, 16, 70, "Notes",
 CellID->18446],
Cell[4223, 144, 999, 35, 70, "Notes",
 CellID->25156]
}, Closed]],
Cell[CellGroupData[{
Cell[5259, 184, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->639642630],
Cell[CellGroupData[{
Cell[5644, 198, 148, 5, 70, "ExampleSection",
 CellID->840658571],
Cell[CellGroupData[{
Cell[5817, 207, 128, 4, 28, "Input",
 CellID->12125704],
Cell[5948, 213, 158, 5, 36, "Output",
 CellID->135427430]
}, Open  ]],
Cell[CellGroupData[{
Cell[6143, 223, 129, 4, 28, "Input",
 CellID->73404681],
Cell[6275, 229, 161, 5, 36, "Output",
 CellID->329607818]
}, Open  ]],
Cell[6451, 237, 124, 3, 70, "ExampleDelimiter",
 CellID->37477389],
Cell[6578, 242, 189, 7, 70, "ExampleText",
 CellID->8119997],
Cell[CellGroupData[{
Cell[6792, 253, 101, 3, 70, "Input",
 CellID->162312622],
Cell[6896, 258, 214, 7, 36, "Output",
 CellID->100141907]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7159, 271, 216, 7, 70, "ExampleSection",
 CellID->14127],
Cell[7378, 280, 85, 1, 70, "ExampleText",
 CellID->84982772],
Cell[CellGroupData[{
Cell[7488, 285, 242, 8, 70, "Input",
 CellID->316456057],
Cell[7733, 295, 205, 7, 36, "Output",
 CellID->85756947]
}, Open  ]],
Cell[7953, 305, 124, 3, 70, "ExampleDelimiter",
 CellID->55020209],
Cell[8080, 310, 425, 18, 70, "ExampleText",
 CellID->351195933],
Cell[CellGroupData[{
Cell[8530, 332, 167, 5, 70, "Input",
 CellID->203817188],
Cell[8700, 339, 199, 7, 36, "Output",
 CellID->165742065]
}, Open  ]],
Cell[8914, 349, 125, 3, 70, "ExampleDelimiter",
 CellID->686947317],
Cell[9042, 354, 70, 1, 70, "ExampleText",
 CellID->622451923],
Cell[CellGroupData[{
Cell[9137, 359, 220, 7, 70, "Input",
 CellID->376852623],
Cell[9360, 368, 161, 5, 36, "Output",
 CellID->488851867]
}, Open  ]],
Cell[9536, 376, 124, 3, 70, "ExampleDelimiter",
 CellID->12187583],
Cell[9663, 381, 70, 1, 70, "ExampleText",
 CellID->292737182],
Cell[CellGroupData[{
Cell[9758, 386, 165, 5, 70, "Input",
 CellID->477491846],
Cell[9926, 393, 235, 7, 50, "Output",
 CellID->157174990]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10210, 406, 226, 7, 70, "ExampleSection",
 CellID->11710154],
Cell[10439, 415, 207, 8, 70, "ExampleText",
 CellID->37965020],
Cell[CellGroupData[{
Cell[10671, 427, 521, 18, 70, "Input",
 CellID->958192352],
Cell[11195, 447, 2315, 42, 70, "Output",
 Evaluatable->False,
 CellID->904728901]
}, Open  ]],
Cell[13525, 492, 60, 1, 70, "ExampleText",
 CellID->9643715],
Cell[CellGroupData[{
Cell[13610, 497, 410, 14, 70, "Input",
 CellID->311704166],
Cell[14023, 513, 1248, 46, 96, "Output",
 CellID->260671543]
}, Open  ]],
Cell[15286, 562, 125, 3, 70, "ExampleDelimiter",
 CellID->292981727],
Cell[15414, 567, 141, 4, 70, "ExampleText",
 CellID->100096229],
Cell[CellGroupData[{
Cell[15580, 575, 793, 27, 70, "Input",
 CellID->310451651],
Cell[16376, 604, 159, 5, 36, "Output",
 CellID->865199023]
}, Open  ]],
Cell[16550, 612, 60, 1, 70, "ExampleText",
 CellID->2908850],
Cell[CellGroupData[{
Cell[16635, 617, 689, 24, 70, "Input",
 CellID->167686269],
Cell[17327, 643, 2559, 46, 70, "Output",
 Evaluatable->False,
 CellID->311379628]
}, Open  ]],
Cell[19901, 692, 123, 3, 70, "ExampleDelimiter",
 CellID->5806998],
Cell[20027, 697, 210, 8, 70, "ExampleText",
 CellID->218471328],
Cell[CellGroupData[{
Cell[20262, 709, 527, 19, 70, "Input",
 CellID->346963841],
Cell[20792, 730, 161, 5, 36, "Output",
 CellID->266623981]
}, Open  ]],
Cell[CellGroupData[{
Cell[20990, 740, 590, 21, 70, "Input",
 CellID->304390890],
Cell[21583, 763, 6601, 112, 70, "Output",
 Evaluatable->False,
 CellID->542752952]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28233, 881, 237, 7, 70, "ExampleSection",
 CellID->581193942],
Cell[28473, 890, 197, 8, 70, "ExampleText",
 CellID->470387246],
Cell[CellGroupData[{
Cell[28695, 902, 285, 10, 70, "Input",
 CellID->95768180],
Cell[28983, 914, 234, 10, 48, "Output",
 CellID->625162112]
}, Open  ]],
Cell[29232, 927, 125, 3, 70, "ExampleDelimiter",
 CellID->111472470],
Cell[29360, 932, 216, 8, 70, "ExampleText",
 CellID->257207371],
Cell[CellGroupData[{
Cell[29601, 944, 329, 11, 70, "Input",
 CellID->551050724],
Cell[29933, 957, 441, 15, 36, "Output",
 CellID->195956690]
}, Open  ]],
Cell[CellGroupData[{
Cell[30411, 977, 103, 3, 70, "Input",
 CellID->40654382],
Cell[30517, 982, 158, 5, 36, "Output",
 CellID->847828896]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30736, 994, 311, 9, 70, "SeeAlsoSection",
 CellID->22309],
Cell[31050, 1005, 447, 17, 70, "SeeAlso",
 CellID->508]
}, Open  ]],
Cell[CellGroupData[{
Cell[31534, 1027, 314, 9, 70, "TutorialsSection",
 CellID->20879],
Cell[31851, 1038, 191, 4, 70, "Tutorials",
 CellID->4500]
}, Open  ]],
Cell[CellGroupData[{
Cell[32079, 1047, 319, 9, 70, "MoreAboutSection",
 CellID->248129578],
Cell[32401, 1058, 157, 3, 70, "MoreAbout",
 CellID->196540961]
}, Open  ]],
Cell[32573, 1064, 50, 0, 70, "History"],
Cell[32626, 1066, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

