(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21081,        769]
NotebookOptionsPosition[     16147,        598]
NotebookOutlinePosition[     17721,        644]
CellTagsIndexPosition[     17595,        638]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Using Previous Results" :> 
          Documentation`HelpLookup["paclet:tutorial/UsingPreviousResults"], 
          "Using a Text\[Hyphen]Based Interface" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/UsingATextBasedInterface"], 
          "Doing Computations in Notebooks" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/DoingComputationsInNotebooks"], "The Main Loop" :> 
          Documentation`HelpLookup["paclet:tutorial/TheMainLoop"], 
          "Mathematica Sessions" :> 
          Documentation`HelpLookup["paclet:tutorial/MathematicaSessions"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Using Previous Results\"\>",
        2->"\<\"Using a Text\[Hyphen]Based Interface\"\>", 
       3->"\<\"Doing Computations in Notebooks\"\>", 
       4->"\<\"The Main Loop\"\>", 
       5->"\<\"Mathematica Sessions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"InString" :> Documentation`HelpLookup["paclet:ref/InString"], 
          "Out" :> Documentation`HelpLookup["paclet:ref/Out"], "$Line" :> 
          Documentation`HelpLookup["paclet:ref/$Line"], "$HistoryLength" :> 
          Documentation`HelpLookup["paclet:ref/$HistoryLength"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"InString\"\>", 2->"\<\"Out\"\>", 
       3->"\<\"$Line\"\>", 4->"\<\"$HistoryLength\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Tokens Related to the Cell Menu" :> 
          Documentation`HelpLookup["paclet:guide/CellTokens"], 
          "Mathematica Session History" :> 
          Documentation`HelpLookup["paclet:guide/MathematicaSessionHistory"], 
          "MathLink Packets" :> 
          Documentation`HelpLookup["paclet:guide/MathLinkPackets"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Tokens Related to the Cell Menu\"\>", 
       2->"\<\"Mathematica Session History\"\>", 
       3->"\<\"MathLink Packets\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["In", "ObjectName",
 CellID->5979],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["In",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/In"], "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a global object that is assigned to have a delayed \
value of the ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " input line. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8898]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Typing ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["In",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/In"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " causes the ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " input line to be re\[Hyphen]evaluated. "
}], "Notes",
 CellID->16057],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["In",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/In"], "[", "]"}]], "InlineFormula"],
 " gives the last input line. "
}], "Notes",
 CellID->20669],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["In",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/In"], "[", 
   RowBox[{"-", 
    StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
 " gives the input ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " lines back. "
}], "Notes",
 CellID->18345]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->62829701],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->224872360],

Cell["Reevaluate a command without retyping it:", "ExampleText",
 CellID->5004527],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", " ", "=", " ", "1."}]], "Input",
 CellLabel->"In[1]:=",
 CellID->198294897],

Cell[BoxData["1.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18491432]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "=", 
  RowBox[{
   RowBox[{"a", "/", "2"}], "+", 
   RowBox[{"1", "/", "a"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->47916241],

Cell[BoxData["1.5`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->688873307]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"In", "[", "2", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->169481415],

Cell[BoxData["1.4166666666666665`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->215048899]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"In", "[", "2", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->300496243],

Cell[BoxData["1.4142156862745097`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->927801680]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9958384],

Cell["See what commands have been entered in a session:", "ExampleText",
 CellID->451131139],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "=", " ", "1."}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7712845],

Cell[BoxData[
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"3", "/", "2"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->422875913],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", " ", "=", " ", 
  RowBox[{
   RowBox[{"a", "/", "2"}], "+", 
   RowBox[{"b", "/", "a"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->99098248],

Cell[BoxData["2.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->410499210]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"In", "[", "3", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->37709375],

Cell[BoxData["1.75`"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->288782060]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"In", "[", "3", "]"}], ",", 
   RowBox[{"{", "3", "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->250194327],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "-", 
  RowBox[{"Sqrt", "[", "3", "]"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->373879239],

Cell[BoxData["2.220446049250313`*^-16"], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->12346214]
}, Open  ]],

Cell[TextData[{
 "Get ",
 Cell[BoxData[
  ButtonBox["Information",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Information"]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  ButtonBox["In",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/In"]], "InlineFormula"],
 ". Note that here this will only include definitions from this example:"
}], "ExampleText",
 CellID->4260808],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", "In"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->127581612],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["\<\"\!\(\*RowBox[{\\\"In\\\", \\\"[\\\", StyleBox[\\\"n\\\", \
\\\"TI\\\"], \\\"]\\\"}]\) is a global object that is assigned to have a \
delayed value of the \!\(\*StyleBox[\\\"n\\\", \
\\\"TI\\\"]\)\!\(\*SuperscriptBox[\\\"\[Null]\\\", \\\"th\\\"]\) input line. \
\"\>", "MSG"], " ", 
  ButtonBox[
   StyleBox["\[RightSkeleton]", "SR"],
   Active->True,
   BaseStyle->"Link",
   ButtonData->"paclet:ref/In"]}]], "Print", "PrintUsage",
 CellTags->"Info3383891509-3425567",
 CellID->188554685],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "In", "]"}], "=", 
      RowBox[{"{", 
       RowBox[{"Listable", ",", "Protected"}], "}"}]}]},
    {" "},
    {GridBox[{
       {
        RowBox[{
         RowBox[{"In", "[", "1", "]"}], ":=", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "=", "1.`"}], ";"}], ")"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"In", "[", "2", "]"}], ":=", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", "=", 
            FractionBox["3", "2"]}], ";"}], ")"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"In", "[", "3", "]"}], ":=", 
         RowBox[{"a", "=", 
          RowBox[{
           FractionBox["a", "2"], "+", 
           FractionBox["b", "a"]}]}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"In", "[", "4", "]"}], ":=", 
         RowBox[{"In", "[", "3", "]"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"In", "[", "5", "]"}], ":=", 
         RowBox[{"Do", "[", 
          RowBox[{
           RowBox[{"In", "[", "3", "]"}], ",", 
           RowBox[{"{", "3", "}"}]}], "]"}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"In", "[", "6", "]"}], ":=", 
         RowBox[{"a", "-", 
          SqrtBox["3"]}]}]},
       {" "},
       {
        RowBox[{
         RowBox[{"In", "[", "7", "]"}], ":=", 
         RowBox[{"Information", "[", 
          RowBox[{"\<\"In\"\>", ",", 
           RowBox[{"LongForm", "\[Rule]", "True"}]}], "]"}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["In"],
  Editable->False]], "Print",
 CellTags->"Info3383891509-3425567",
 CellID->224103319]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17493],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["InString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InString"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Out",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Out"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Line",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Line"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$HistoryLength",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$HistoryLength"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21732]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32748],

Cell[TextData[ButtonBox["Using Previous Results",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/UsingPreviousResults"]], "Tutorials",
 CellID->21565],

Cell[TextData[ButtonBox["Using a Text\[Hyphen]Based Interface",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/UsingATextBasedInterface"]], "Tutorials",
 CellID->18221],

Cell[TextData[ButtonBox["Doing Computations in Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DoingComputationsInNotebooks"]], "Tutorials",
 CellID->15589],

Cell[TextData[ButtonBox["The Main Loop",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheMainLoop"]], "Tutorials",
 CellID->1781],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaSessions"],
  FontSlant->"Italic"],
 ButtonBox[" Sessions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaSessions"]
}], "Tutorials",
 CellID->522604605]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->136203806],

Cell[TextData[ButtonBox["Tokens Related to the Cell Menu",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CellTokens"]], "MoreAbout",
 CellID->255048984],

Cell[TextData[ButtonBox["Mathematica Session History",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSessionHistory"]], "MoreAbout",
 CellID->440965949],

Cell[TextData[ButtonBox["MathLink Packets",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathLinkPackets"]], "MoreAbout",
 CellID->155005322]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"In - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 48, 44.3991346}", "context" -> "System`", 
    "keywords" -> {
     "expressions", "input lines", "lines", "input record", "history list", 
      "history"}, "index" -> True, "label" -> "Built-in Mathematica Symbol", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "In[n] is a global object that is assigned to have a delayed value of the \
n\\[Null]^th input line. ", "synonyms" -> {}, "title" -> "In", "type" -> 
    "Symbol", "uri" -> "ref/In"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5859, 186, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->62829701]},
 "Info3383891509-3425567"->{
  Cell[9959, 375, 529, 13, 70, "Print",
   CellTags->"Info3383891509-3425567",
   CellID->188554685],
  Cell[10491, 390, 2157, 73, 70, "Print",
   CellTags->"Info3383891509-3425567",
   CellID->224103319]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17217, 624},
 {"Info3383891509-3425567", 17365, 628}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3016, 66, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3639, 93, 39, 1, 70, "ObjectName",
 CellID->5979],
Cell[3681, 96, 679, 22, 70, "Usage",
 CellID->8898]
}, Open  ]],
Cell[CellGroupData[{
Cell[4397, 123, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4875, 140, 414, 16, 70, "Notes",
 CellID->16057],
Cell[5292, 158, 209, 8, 70, "Notes",
 CellID->20669],
Cell[5504, 168, 318, 13, 70, "Notes",
 CellID->18345]
}, Closed]],
Cell[CellGroupData[{
Cell[5859, 186, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->62829701],
Cell[CellGroupData[{
Cell[6243, 200, 148, 5, 70, "ExampleSection",
 CellID->224872360],
Cell[6394, 207, 82, 1, 70, "ExampleText",
 CellID->5004527],
Cell[CellGroupData[{
Cell[6501, 212, 103, 3, 28, "Input",
 CellID->198294897],
Cell[6607, 217, 159, 5, 36, "Output",
 CellID->18491432]
}, Open  ]],
Cell[CellGroupData[{
Cell[6803, 227, 162, 6, 28, "Input",
 CellID->47916241],
Cell[6968, 235, 161, 5, 36, "Output",
 CellID->688873307]
}, Open  ]],
Cell[CellGroupData[{
Cell[7166, 245, 98, 3, 28, "Input",
 CellID->169481415],
Cell[7267, 250, 176, 5, 36, "Output",
 CellID->215048899]
}, Open  ]],
Cell[CellGroupData[{
Cell[7480, 260, 98, 3, 70, "Input",
 CellID->300496243],
Cell[7581, 265, 176, 5, 36, "Output",
 CellID->927801680]
}, Open  ]],
Cell[7772, 273, 123, 3, 70, "ExampleDelimiter",
 CellID->9958384],
Cell[7898, 278, 92, 1, 70, "ExampleText",
 CellID->451131139],
Cell[7993, 281, 119, 4, 70, "Input",
 CellID->7712845],
Cell[8115, 287, 134, 5, 70, "Input",
 CellID->422875913],
Cell[CellGroupData[{
Cell[8274, 296, 172, 6, 70, "Input",
 CellID->99098248],
Cell[8449, 304, 160, 5, 36, "Output",
 CellID->410499210]
}, Open  ]],
Cell[CellGroupData[{
Cell[8646, 314, 97, 3, 70, "Input",
 CellID->37709375],
Cell[8746, 319, 162, 5, 36, "Output",
 CellID->288782060]
}, Open  ]],
Cell[8923, 327, 175, 6, 70, "Input",
 CellID->250194327],
Cell[CellGroupData[{
Cell[9123, 337, 123, 4, 70, "Input",
 CellID->373879239],
Cell[9249, 343, 179, 5, 36, "Output",
 CellID->12346214]
}, Open  ]],
Cell[9443, 351, 377, 13, 70, "ExampleText",
 CellID->4260808],
Cell[CellGroupData[{
Cell[9845, 368, 89, 3, 70, "Input",
 CellID->127581612],
Cell[CellGroupData[{
Cell[9959, 375, 529, 13, 70, "Print",
 CellTags->"Info3383891509-3425567",
 CellID->188554685],
Cell[10491, 390, 2157, 73, 70, "Print",
 CellTags->"Info3383891509-3425567",
 CellID->224103319]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12721, 471, 311, 9, 70, "SeeAlsoSection",
 CellID->17493],
Cell[13035, 482, 937, 35, 70, "SeeAlso",
 CellID->21732]
}, Open  ]],
Cell[CellGroupData[{
Cell[14009, 522, 314, 9, 70, "TutorialsSection",
 CellID->32748],
Cell[14326, 533, 153, 3, 70, "Tutorials",
 CellID->21565],
Cell[14482, 538, 171, 3, 70, "Tutorials",
 CellID->18221],
Cell[14656, 543, 170, 3, 70, "Tutorials",
 CellID->15589],
Cell[14829, 548, 134, 3, 70, "Tutorials",
 CellID->1781],
Cell[14966, 553, 284, 9, 70, "Tutorials",
 CellID->522604605]
}, Open  ]],
Cell[CellGroupData[{
Cell[15287, 567, 319, 9, 70, "MoreAboutSection",
 CellID->136203806],
Cell[15609, 578, 153, 3, 70, "MoreAbout",
 CellID->255048984],
Cell[15765, 583, 164, 3, 70, "MoreAbout",
 CellID->440965949],
Cell[15932, 588, 143, 3, 70, "MoreAbout",
 CellID->155005322]
}, Open  ]],
Cell[16090, 594, 27, 0, 70, "History"],
Cell[16120, 596, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

