(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     40813,       1539]
NotebookOptionsPosition[     31243,       1198]
NotebookOutlinePosition[     32533,       1234]
CellTagsIndexPosition[     32447,       1229]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Indeterminate and Infinite Results" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IndeterminateAndInfiniteResults"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Indeterminate and Infinite Results\"\>"}, "\<\"tutorials\"\>", 
       
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DirectedInfinity" :> 
          Documentation`HelpLookup["paclet:ref/DirectedInfinity"], "Missing" :> 
          Documentation`HelpLookup["paclet:ref/Missing"], "Check" :> 
          Documentation`HelpLookup["paclet:ref/Check"], "Quiet" :> 
          Documentation`HelpLookup["paclet:ref/Quiet"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"DirectedInfinity\"\>", 2->"\<\"Missing\"\>", 
       3->"\<\"Check\"\>", 4->"\<\"Quiet\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Indeterminate", "ObjectName",
 CellID->5794],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Indeterminate",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Indeterminate"]], "InlineFormula"],
     "\[LineSeparator]is a symbol that represents a numerical quantity whose \
magnitude cannot be determined. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14385]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Computations like ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", "/", "0"}], TraditionalForm]], "InlineMath"],
 " generate ",
 Cell[BoxData[
  ButtonBox["Indeterminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Indeterminate"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->944],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  ButtonBox["Indeterminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Indeterminate"]], "InlineFormula"],
 " appears in the argument of any function with attribute ",
 Cell[BoxData[
  ButtonBox["NumericFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumericFunction"]], "InlineFormula"],
 ", the result will be ",
 Cell[BoxData[
  ButtonBox["Indeterminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Indeterminate"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->28687,
  ButtonNote->"28687"]
}], "Notes",
 CellID->29920],

Cell[TextData[{
 "A message is produced whenever an operation first yields ",
 Cell[BoxData[
  ButtonBox["Indeterminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Indeterminate"]], "InlineFormula"],
 " as a result. "
}], "Notes",
 CellID->14775]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->200306318],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->211041968],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Indeterminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Indeterminate"]], "InlineFormula"],
 " is returned when a value cannot be unambiguously defined:"
}], "ExampleText",
 CellID->264575914],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"0", "/", "0"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19654],

Cell[BoxData[
 RowBox[{
  RowBox[{"Power", "::", "\<\"infy\"\>"}], ":", 
  " ", "\<\"Infinite expression \\!\\(1\\/0\\) encountered. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/infy\\\", \
ButtonNote -> \\\"Power::infy\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->324130777],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Infinity]", "::", "\<\"indet\"\>"}], ":", 
  " ", "\<\"Indeterminate expression \\!\\(0\\\\ ComplexInfinity\\) \
encountered. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/indet\\\", ButtonNote -> \
\\\"Infinity::indet\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->221727064],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->158991440]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8057],

Cell[TextData[{
 "Any numeric function of ",
 Cell[BoxData[
  ButtonBox["Indeterminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Indeterminate"]], "InlineFormula"],
 " also gives ",
 Cell[BoxData[
  ButtonBox["Indeterminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Indeterminate"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->4302],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", "Indeterminate", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2323],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->452159953]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3916],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Indeterminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Indeterminate"]], "InlineFormula"],
 " \"takes over\" any function with attribute ",
 Cell[BoxData[
  ButtonBox["NumericFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumericFunction"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->28687],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f", ",", "NumericFunction"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30997],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "Indeterminate", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13120],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->852735411]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->42421762],

Cell[TextData[{
 "Negative precision/accuracy can yield ",
 Cell[BoxData[
  ButtonBox["Indeterminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Indeterminate"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->540234267],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SetPrecision", "[", 
   RowBox[{"2", ",", " ", 
    RowBox[{"-", "10"}]}], "]"}], "/", 
  RowBox[{"SetPrecision", "[", 
   RowBox[{"2", ",", " ", 
    RowBox[{"-", "10"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->164276378],

Cell[BoxData[
 RowBox[{
  RowBox[{"Power", "::", "\<\"infy\"\>"}], ":", 
  " ", "\<\"Infinite expression \\!\\(1\\/0``-10.301029995663981\\) \
encountered. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/infy\\\", ButtonNote -> \
\\\"Power::infy\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->581757836],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Infinity]", "::", "\<\"indet\"\>"}], ":", 
  " ", "\<\"Indeterminate expression \\!\\(0``-10.301029995663981\\\\ \
ComplexInfinity\\) encountered. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/indet\\\", ButtonNote -> \
\\\"Infinity::indet\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->617031099],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->45935443]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->683095617],

Cell["Infinity in an unknown direction:", "ExampleText",
 CellID->237315919],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DirectedInfinity", "[", "Indeterminate", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->318398473],

Cell[BoxData["ComplexInfinity"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->243489050]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25949],

Cell[TextData[{
 "Mathematical operations with ",
 Cell[BoxData[
  ButtonBox["Indeterminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Indeterminate"]], "InlineFormula"],
 " produce ",
 Cell[BoxData[
  ButtonBox["Indeterminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Indeterminate"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->12582993],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Interval", "[", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}], "]"}], "+", "Indeterminate"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->110810431],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->618633861]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x", "]"}], "+", "Indeterminate"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->48720324],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->597361352]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{"Indeterminate", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->89848154],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->112475068]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{"Indeterminate", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->293017641],

Cell[BoxData["Indeterminate"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->44480330]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Indeterminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Indeterminate"]], "InlineFormula"],
 " threads over lists:"
}], "ExampleText",
 CellID->725538427],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], "+", "Indeterminate"}]], "Input",\

 CellLabel->"In[5]:=",
 CellID->544475],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Indeterminate", ",", "Indeterminate", ",", "Indeterminate"}], 
  "}"}]], "Output",
 ImageSize->{314, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->314452892]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], " ", "Indeterminate"}]], "Input",\

 CellLabel->"In[6]:=",
 CellID->212073207],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Indeterminate", ",", "Indeterminate", ",", "Indeterminate"}], 
  "}"}]], "Output",
 ImageSize->{314, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->489039062]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29523],

Cell[TextData[{
 "Digits beyond the limit of precision are ",
 Cell[BoxData[
  ButtonBox["Indeterminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Indeterminate"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->21591],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RealDigits", "[", 
  RowBox[{"6.7", ",", "10", ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12848],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "6", ",", "7", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "Indeterminate", ",", "Indeterminate", ",", 
     "Indeterminate", ",", "Indeterminate"}], "}"}], ",", "1"}], 
  "}"}]], "Output",
 ImageSize->{448, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->143714869]
}, Open  ]],

Cell["Create a number of lower precision:", "ExampleText",
 CellID->17691],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromDigits", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "6", ",", "7", ",", "0", ",", "0", ",", "0", ",", "Indeterminate"}], 
     "}"}], ",", "1"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6744],

Cell[BoxData["6.7`5.826074802700828"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->37635140]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5512],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Indeterminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Indeterminate"]], "InlineFormula"],
 " is not a number:"
}], "ExampleText",
 CellID->159177465],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberQ", "[", "Indeterminate", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->68341176],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21149408]
}, Open  ]],

Cell["It is neither real nor complex:", "ExampleText",
 CellID->355058086],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Re", "[", "Indeterminate", "]"}], ",", " ", 
   RowBox[{"Im", "[", "Indeterminate", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->222941139],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Indeterminate", ",", "Indeterminate"}], "}"}]], "Output",
 ImageSize->{212, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->889986255]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22771],

Cell["The value cannot be unambiguously defined: ", "ExampleText",
 CellID->79310316],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "^", "t"}], "/.", 
  RowBox[{"t", "\[Rule]", "0"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3192408],

Cell[BoxData[
 RowBox[{
  RowBox[{"Power", "::", "\<\"indet\"\>"}], ":", 
  " ", "\<\"Indeterminate expression \\!\\(0\\^0\\) encountered. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/indet\\\", \
ButtonNote -> \\\"Power::indet\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->66210987],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->55610890]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Limit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Limit"]], "InlineFormula"],
 " to resolve the value: "
}], "ExampleText",
 CellID->17189405],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"t", "^", "t"}], ",", 
   RowBox[{"t", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->173415729],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->380343515]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->286479834],

Cell["The answer is valid for generic parameter values:", "ExampleText",
 CellID->254839851],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"k", " ", "x"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "n"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->423315413],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", "x"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"n", " ", "x"}]]}], ")"}]}], 
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   SuperscriptBox["\[ExponentialE]", "x"]}]]], "Output",
 ImageSize->{85, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->172547239]
}, Open  ]],

Cell[TextData[{
 "This particular parameter value gives an ",
 Cell[BoxData[
  ButtonBox["Indeterminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Indeterminate"]], "InlineFormula"],
 " result:"
}], "ExampleText",
 CellID->111010313],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "/.", 
  RowBox[{"x", "\[Rule]", "0"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->68864802],

Cell[BoxData[
 RowBox[{
  RowBox[{"Power", "::", "\<\"infy\"\>"}], ":", 
  " ", "\<\"Infinite expression \\!\\(1\\/0\\) encountered. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/infy\\\", \
ButtonNote -> \\\"Power::infy\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->100489621],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Infinity]", "::", "\<\"indet\"\>"}], ":", 
  " ", "\<\"Indeterminate expression \\!\\(0\\\\ ComplexInfinity\\) \
encountered. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/indet\\\", ButtonNote -> \
\\\"Infinity::indet\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->259256091],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->483747563]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Limit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Limit"]], "InlineFormula"],
 " to resolve the value:"
}], "ExampleText",
 CellID->201987718],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{"s", ",", 
   RowBox[{"x", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->204260211],

Cell[BoxData["n"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->134327459]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->263544786],

Cell["Each iteration will result in lower precision:", "ExampleText",
 CellID->661905765],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{"Function", "[", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"x", "^", "2"}], "-", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"x", "-", "1"}], ")"}]}], "-", "1"}]}], "]"}], ",", "3`10", 
   ",", "16"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->179547627],

Cell[BoxData[
 RowBox[{
  RowBox[{"Power", "::", "\<\"infy\"\>"}], ":", 
  " ", "\<\"Infinite expression \\!\\(1\\/0``-0.739822570143582\\) \
encountered. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/infy\\\", ButtonNote -> \
\\\"Power::infy\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->387815668],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Infinity]", "::", "\<\"indet\"\>"}], ":", 
  " ", "\<\"Indeterminate expression \\!\\(0``-1.479645140287164\\\\ \
ComplexInfinity\\) encountered. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/indet\\\", ButtonNote -> \
\\\"Infinity::indet\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->24831383],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3.`10.000000000000004", ",", "3.`9.301029995663985", ",", 
   "3.`8.602059991327966", ",", "3.`7.903089986991948", ",", 
   "3.`7.2041199826559295", ",", "3.`6.505149978319911", ",", 
   "3.`5.806179973983892", ",", "3.`5.107209969647873", ",", 
   "3.`4.4082399653118545", ",", "3.`3.709269960975836", ",", 
   "3.`3.0102999566398174", ",", "3.`2.3113299523037987", ",", 
   "3.`1.6123599479677801", ",", "3.`0.9133899436317615", ",", 
   "3.`0.21441993929574282", ",", "0``-0.739822570143582", ",", 
   "Indeterminate"}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{494, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->58892930]
}, Open  ]],

Cell["\<\
In this case an equivalent function does not lower precision: \
\>", "ExampleText",
 CellID->585443534],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", "1"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}]}], "-", "1"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->38641378],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->282249260]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{"Function", "[", 
    RowBox[{"x", ",", "x"}], "]"}], ",", "3`10", ",", "16"}], "]"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->671501680],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3.`10.000000000000004", ",", "3.`10.000000000000004", ",", 
   "3.`10.000000000000004", ",", "3.`10.000000000000004", ",", 
   "3.`10.000000000000004", ",", "3.`10.000000000000004", ",", 
   "3.`10.000000000000004", ",", "3.`10.000000000000004", ",", 
   "3.`10.000000000000004", ",", "3.`10.000000000000004", ",", 
   "3.`10.000000000000004", ",", "3.`10.000000000000004", ",", 
   "3.`10.000000000000004", ",", "3.`10.000000000000004", ",", 
   "3.`10.000000000000004", ",", "3.`10.000000000000004", ",", 
   "3.`10.000000000000004"}], "}"}]], "Output",
 ImageSize->{536, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->90955315]
}, Open  ]],

Cell["Sometimes a higher precision is needed: ", "ExampleText",
 CellID->472837743],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{"Function", "[", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"x", "^", "2"}], "-", "1"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"x", "-", "1"}], ")"}]}], "-", "1"}]}], "]"}], ",", "3`20", 
   ",", "16"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->468585769],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3.`20.", ",", "3.`19.301029995663985", ",", "3.`18.60205999132797", ",", 
   "3.`17.90308998699195", ",", "3.`17.204119982655936", ",", 
   "3.`16.50514997831992", ",", "3.`15.806179973983902", ",", 
   "3.`15.107209969647887", ",", "3.`14.40823996531187", ",", 
   "3.`13.709269960975853", ",", "3.`13.010299956639836", ",", 
   "3.`12.31132995230382", ",", "3.`11.612359947967803", ",", 
   "3.`10.913389943631786", ",", "3.`10.21441993929577", ",", 
   "3.`9.515449934959753", ",", "3.`8.816479930623734"}], "}"}]], "Output",
 ImageSize->{564, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->42875292]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->801451953],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Indeterminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Indeterminate"]], "InlineFormula"],
 " does not equal itself:"
}], "ExampleText",
 CellID->118536086],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Indeterminate", "==", "Indeterminate"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->194211040],

Cell[BoxData[
 RowBox[{"Indeterminate", "\[Equal]", "Indeterminate"}]], "Output",
 ImageSize->{203, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->113672189]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["SameQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SameQ"]], "InlineFormula"],
 " for testing against ",
 Cell[BoxData[
  ButtonBox["Indeterminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Indeterminate"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->271306427],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Indeterminate", "===", "Indeterminate"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->144522564],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->896390195]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->627618186],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Indeterminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Indeterminate"]], "InlineFormula"],
 " in functions with special evaluation semantics might go undetected:"
}], "ExampleText",
 CellID->363026039],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"And", "[", 
    RowBox[{"True", ",", " ", "Indeterminate"}], "]"}], ",", 
   RowBox[{"And", "[", 
    RowBox[{"False", ",", " ", "Indeterminate"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->240957358],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Indeterminate", ",", "False"}], "}"}]], "Output",
 ImageSize->{156, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->223836953]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5235],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DirectedInfinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DirectedInfinity"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Missing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Missing"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Check",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Check"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Quiet",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quiet"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21959]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10161],

Cell[TextData[ButtonBox["Indeterminate and Infinite Results",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IndeterminateAndInfiniteResults"]], "Tutorials",\

 CellID->22324]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->3971],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/Indeterminate.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/Constants/Indeterminate/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Indeterminate - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 48, 31.7738114}", "context" -> "System`", 
    "keywords" -> {"indefinite", "undefined", "NaN", "not a number"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Indeterminate is a symbol that represents a numerical quantity whose \
magnitude cannot be determined. ", "synonyms" -> {}, "title" -> 
    "Indeterminate", "type" -> "Symbol", "uri" -> "ref/Indeterminate"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4428, 153, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->200306318]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 32304, 1222}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1514, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2137, 63, 50, 1, 70, "ObjectName",
 CellID->5794],
Cell[2190, 66, 482, 14, 70, "Usage",
 CellID->14385]
}, Open  ]],
Cell[CellGroupData[{
Cell[2709, 85, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3187, 102, 303, 12, 70, "Notes",
 CellID->944],
Cell[3493, 116, 642, 22, 70, "Notes",
 CellID->29920],
Cell[4138, 140, 253, 8, 70, "Notes",
 CellID->14775]
}, Closed]],
Cell[CellGroupData[{
Cell[4428, 153, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->200306318],
Cell[CellGroupData[{
Cell[4813, 167, 148, 5, 70, "ExampleSection",
 CellID->211041968],
Cell[4964, 174, 245, 7, 70, "ExampleText",
 CellID->264575914],
Cell[CellGroupData[{
Cell[5234, 185, 88, 3, 70, "Input",
 CellID->19654],
Cell[5325, 190, 367, 7, 70, "Message",
 CellID->324130777],
Cell[5695, 199, 402, 8, 19, "Message",
 CellID->221727064],
Cell[6100, 209, 170, 5, 36, "Output",
 CellID->158991440]
}, Open  ]],
Cell[6285, 217, 120, 3, 70, "ExampleDelimiter",
 CellID->8057],
Cell[6408, 222, 358, 13, 70, "ExampleText",
 CellID->4302],
Cell[CellGroupData[{
Cell[6791, 239, 106, 3, 70, "Input",
 CellID->2323],
Cell[6900, 244, 170, 5, 36, "Output",
 CellID->452159953]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7119, 255, 215, 7, 70, "ExampleSection",
 CellID->3916],
Cell[7337, 264, 414, 13, 70, "ExampleText",
 CellID->28687],
Cell[7754, 279, 142, 4, 70, "Input",
 CellID->30997],
Cell[CellGroupData[{
Cell[7921, 287, 105, 3, 70, "Input",
 CellID->13120],
Cell[8029, 292, 170, 5, 36, "Output",
 CellID->852735411]
}, Open  ]],
Cell[8214, 300, 124, 3, 70, "ExampleDelimiter",
 CellID->42421762],
Cell[8341, 305, 231, 8, 70, "ExampleText",
 CellID->540234267],
Cell[CellGroupData[{
Cell[8597, 317, 270, 9, 70, "Input",
 CellID->164276378],
Cell[8870, 328, 390, 8, 70, "Message",
 CellID->581757836],
Cell[9263, 338, 423, 8, 70, "Message",
 CellID->617031099],
Cell[9689, 348, 169, 5, 36, "Output",
 CellID->45935443]
}, Open  ]],
Cell[9873, 356, 125, 3, 70, "ExampleDelimiter",
 CellID->683095617],
Cell[10001, 361, 76, 1, 70, "ExampleText",
 CellID->237315919],
Cell[CellGroupData[{
Cell[10102, 366, 124, 3, 70, "Input",
 CellID->318398473],
Cell[10229, 371, 173, 5, 36, "Output",
 CellID->243489050]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10451, 382, 239, 7, 70, "ExampleSection",
 CellID->25949],
Cell[10693, 391, 364, 13, 70, "ExampleText",
 CellID->12582993],
Cell[CellGroupData[{
Cell[11082, 408, 188, 6, 70, "Input",
 CellID->110810431],
Cell[11273, 416, 170, 5, 36, "Output",
 CellID->618633861]
}, Open  ]],
Cell[CellGroupData[{
Cell[11480, 426, 131, 4, 70, "Input",
 CellID->48720324],
Cell[11614, 432, 170, 5, 36, "Output",
 CellID->597361352]
}, Open  ]],
Cell[CellGroupData[{
Cell[11821, 442, 139, 4, 70, "Input",
 CellID->89848154],
Cell[11963, 448, 170, 5, 36, "Output",
 CellID->112475068]
}, Open  ]],
Cell[CellGroupData[{
Cell[12170, 458, 132, 4, 70, "Input",
 CellID->293017641],
Cell[12305, 464, 217, 7, 36, "Output",
 CellID->44480330]
}, Open  ]],
Cell[12537, 474, 207, 7, 70, "ExampleText",
 CellID->725538427],
Cell[CellGroupData[{
Cell[12769, 485, 160, 6, 70, "Input",
 CellID->544475],
Cell[12932, 493, 253, 8, 36, "Output",
 CellID->314452892]
}, Open  ]],
Cell[CellGroupData[{
Cell[13222, 506, 163, 6, 70, "Input",
 CellID->212073207],
Cell[13388, 514, 253, 8, 36, "Output",
 CellID->489039062]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13690, 528, 223, 7, 70, "ExampleSection",
 CellID->29523],
Cell[13916, 537, 230, 8, 70, "ExampleText",
 CellID->21591],
Cell[CellGroupData[{
Cell[14171, 549, 139, 4, 70, "Input",
 CellID->12848],
Cell[14313, 555, 507, 14, 54, "Output",
 CellID->143714869]
}, Open  ]],
Cell[14835, 572, 74, 1, 70, "ExampleText",
 CellID->17691],
Cell[CellGroupData[{
Cell[14934, 577, 263, 9, 70, "Input",
 CellID->6744],
Cell[15200, 588, 177, 5, 36, "Output",
 CellID->37635140]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15426, 599, 232, 7, 70, "ExampleSection",
 CellID->5512],
Cell[15661, 608, 204, 7, 70, "ExampleText",
 CellID->159177465],
Cell[CellGroupData[{
Cell[15890, 619, 114, 3, 70, "Input",
 CellID->68341176],
Cell[16007, 624, 161, 5, 36, "Output",
 CellID->21149408]
}, Open  ]],
Cell[16183, 632, 74, 1, 70, "ExampleText",
 CellID->355058086],
Cell[CellGroupData[{
Cell[16282, 637, 204, 6, 70, "Input",
 CellID->222941139],
Cell[16489, 645, 228, 7, 36, "Output",
 CellID->889986255]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16766, 658, 226, 7, 70, "ExampleSection",
 CellID->22771],
Cell[16995, 667, 85, 1, 70, "ExampleText",
 CellID->79310316],
Cell[CellGroupData[{
Cell[17105, 672, 143, 5, 70, "Input",
 CellID->3192408],
Cell[17251, 679, 374, 7, 70, "Message",
 CellID->66210987],
Cell[17628, 688, 169, 5, 36, "Output",
 CellID->55610890]
}, Open  ]],
Cell[17812, 696, 202, 8, 70, "ExampleText",
 CellID->17189405],
Cell[CellGroupData[{
Cell[18039, 708, 178, 6, 70, "Input",
 CellID->173415729],
Cell[18220, 716, 158, 5, 36, "Output",
 CellID->380343515]
}, Open  ]],
Cell[18393, 724, 125, 3, 70, "ExampleDelimiter",
 CellID->286479834],
Cell[18521, 729, 92, 1, 70, "ExampleText",
 CellID->254839851],
Cell[CellGroupData[{
Cell[18638, 734, 255, 9, 70, "Input",
 CellID->423315413],
Cell[18896, 745, 459, 16, 52, "Output",
 CellID->172547239]
}, Open  ]],
Cell[19370, 764, 241, 8, 70, "ExampleText",
 CellID->111010313],
Cell[CellGroupData[{
Cell[19636, 776, 121, 4, 70, "Input",
 CellID->68864802],
Cell[19760, 782, 367, 7, 70, "Message",
 CellID->100489621],
Cell[20130, 791, 402, 8, 70, "Message",
 CellID->259256091],
Cell[20535, 801, 170, 5, 36, "Output",
 CellID->483747563]
}, Open  ]],
Cell[20720, 809, 202, 8, 70, "ExampleText",
 CellID->201987718],
Cell[CellGroupData[{
Cell[20947, 821, 154, 5, 70, "Input",
 CellID->204260211],
Cell[21104, 828, 158, 5, 36, "Output",
 CellID->134327459]
}, Open  ]],
Cell[21277, 836, 125, 3, 70, "ExampleDelimiter",
 CellID->263544786],
Cell[21405, 841, 89, 1, 70, "ExampleText",
 CellID->661905765],
Cell[CellGroupData[{
Cell[21519, 846, 403, 14, 70, "Input",
 CellID->179547627],
Cell[21925, 862, 389, 8, 70, "Message",
 CellID->387815668],
Cell[22317, 872, 421, 8, 70, "Message",
 CellID->24831383],
Cell[22741, 882, 762, 18, 54, "Output",
 CellID->58892930]
}, Open  ]],
Cell[23518, 903, 113, 3, 70, "ExampleText",
 CellID->585443534],
Cell[CellGroupData[{
Cell[23656, 910, 279, 10, 70, "Input",
 CellID->38641378],
Cell[23938, 922, 158, 5, 36, "Output",
 CellID->282249260]
}, Open  ]],
Cell[CellGroupData[{
Cell[24133, 932, 204, 7, 70, "Input",
 CellID->671501680],
Cell[24340, 941, 728, 16, 71, "Output",
 CellID->90955315]
}, Open  ]],
Cell[25083, 960, 83, 1, 70, "ExampleText",
 CellID->472837743],
Cell[CellGroupData[{
Cell[25191, 965, 403, 14, 70, "Input",
 CellID->468585769],
Cell[25597, 981, 701, 15, 88, "Output",
 CellID->42875292]
}, Open  ]],
Cell[26313, 999, 125, 3, 70, "ExampleDelimiter",
 CellID->801451953],
Cell[26441, 1004, 210, 7, 70, "ExampleText",
 CellID->118536086],
Cell[CellGroupData[{
Cell[26676, 1015, 117, 3, 70, "Input",
 CellID->194211040],
Cell[26796, 1020, 212, 6, 36, "Output",
 CellID->113672189]
}, Open  ]],
Cell[27023, 1029, 336, 13, 70, "ExampleText",
 CellID->271306427],
Cell[CellGroupData[{
Cell[27384, 1046, 118, 3, 70, "Input",
 CellID->144522564],
Cell[27505, 1051, 161, 5, 36, "Output",
 CellID->896390195]
}, Open  ]],
Cell[27681, 1059, 125, 3, 70, "ExampleDelimiter",
 CellID->627618186],
Cell[27809, 1064, 255, 7, 70, "ExampleText",
 CellID->363026039],
Cell[CellGroupData[{
Cell[28089, 1075, 268, 8, 70, "Input",
 CellID->240957358],
Cell[28360, 1085, 220, 7, 36, "Output",
 CellID->223836953]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28641, 1099, 310, 9, 70, "SeeAlsoSection",
 CellID->5235],
Cell[28954, 1110, 943, 35, 70, "SeeAlso",
 CellID->21959]
}, Open  ]],
Cell[CellGroupData[{
Cell[29934, 1150, 314, 9, 70, "TutorialsSection",
 CellID->10161],
Cell[30251, 1161, 178, 4, 70, "Tutorials",
 CellID->22324]
}, Open  ]],
Cell[CellGroupData[{
Cell[30466, 1170, 320, 9, 70, "RelatedLinksSection",
 CellID->3971],
Cell[30789, 1181, 184, 4, 70, "RelatedLinks"],
Cell[30976, 1187, 195, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[31186, 1194, 27, 0, 70, "History"],
Cell[31216, 1196, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

