(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     28795,        989]
NotebookOptionsPosition[     23341,        798]
NotebookOutlinePosition[     24700,        837]
CellTagsIndexPosition[     24615,        832]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ExactNumberQ" :> 
          Documentation`HelpLookup["paclet:ref/ExactNumberQ"], 
          "MachineNumberQ" :> 
          Documentation`HelpLookup["paclet:ref/MachineNumberQ"], "Precision" :> 
          Documentation`HelpLookup["paclet:ref/Precision"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ExactNumberQ\"\>", 
       2->"\<\"MachineNumberQ\"\>", 
       3->"\<\"Precision\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Representation of Numbers" :> 
          Documentation`HelpLookup[
           "paclet:guide/RepresentationOfNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Representation of Numbers\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InexactNumberQ", "ObjectName",
 CellID->23668],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InexactNumberQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InexactNumberQ"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]returns ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is an inexact real or complex number, and returns ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19019]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["InexactNumberQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InexactNumberQ"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " if ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " has head ",
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 ", or is a complex number either of whose components have head ",
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->4406]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->623893755],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->367107541],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InexactNumberQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InexactNumberQ"]], "InlineFormula"],
 " tests whether an object is explicitly an inexact number:"
}], "ExampleText",
 CellID->716711489],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InexactNumberQ", "[", "5.6", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->225592494],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28840888]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InexactNumberQ", "[", 
  RowBox[{"5", "/", "6"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->52990215],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->853352726]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InexactNumberQ", "[", "x", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->96585538],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->413919217]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30248],

Cell["An approximate zero is inexact:", "ExampleText",
 CellID->470160432],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"z", " ", "=", " ", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{"Pi", ",", "20"}], "]"}], " ", "-", " ", 
   FractionBox["1299139324288", "413528890451"]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->89028013],

Cell[BoxData["0``19.502850127305866"], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->357061507]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InexactNumberQ", "[", "z", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12544717],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->614050686]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->167879646],

Cell["\<\
Either real or imaginary parts of a complex number can be inexact:\
\>", "ExampleText",
 CellID->304109859],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InexactNumberQ", "[", 
  RowBox[{"1.", "+", 
   RowBox[{"2", " ", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3194879],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->667199381]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InexactNumberQ", "[", 
  RowBox[{"2", "+", 
   RowBox[{
    RowBox[{"N", "[", 
     RowBox[{"Pi", ",", "20"}], "]"}], " ", "I"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->262951164],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->66776279]
}, Open  ]],

Cell["\<\
If both real and imaginary parts are exact, then the number is not inexact:\
\>", "ExampleText",
 CellID->46635549],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InexactNumberQ", "[", 
  RowBox[{"3", "+", 
   RowBox[{
    RowBox[{"4", "/", "5"}], " ", "I"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->39030061],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->511309303]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8337],

Cell["\<\
Numbers are considered either exact or approximate (inexact):\
\>", "ExampleText",
 CellID->337526657],

Cell[BoxData[
 RowBox[{
  RowBox[{"numbers", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1.", ",", "2`10", ",", 
     RowBox[{"3", "/", "4"}], ",", 
     RowBox[{"5", "+", 
      RowBox[{"6", " ", "I"}]}], ",", 
     RowBox[{
      RowBox[{"N", "[", 
       RowBox[{"Pi", ",", "7"}], "]"}], "+", 
      RowBox[{"8", " ", "I"}]}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->441045006],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"InexactNumberQ", "[", "x", "]"}], ",", 
       RowBox[{"ExactNumberQ", "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "numbers"}], "}"}]}], "]"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<x\>\"", ",", "\"\<inexact\>\"", ",", "\"\<exact\>\""}], 
       "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->472518670],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdW81u1DAQzuanu9stpQiooFSwICE4wxHUI4gD1/JTQNpWSO0BAaV3XoCn
AY4ce++j9BFMnHha7+RzYmfz43alxjuOPZ75PP7G66SvZ0f7n7/Mjg72ZtOX
h7Nv+wd7P6Yvvh6mVdEgCILj9O/7rSD9LtJv2d+xEGmZXxN5jWRt9gn+OdRG
6UWKcVqGqkyCvJ2szxoE+SdSol5SuyHTu6TqZTlMy4nWL1FlyPSH6dc4Le9p
uhNgA7WLVTmAnslWQXImKxU07hKwt9C7UltiHEPvGzMZ99IRlPIqmKkyOVTI
6HUPUJ/CyNw+7CvXHUHUOY5joHsJYMT7cZuQjRSnDWFZ6XE9NDPP4nNZ2VwL
OefRRL5CqtBtG0VZOWXaaPVyW3SGSYyrm/hqBdkwh3aZfoxnGJj5bGSBCfGo
IaIKtdNKiyxXZ6EWY1cVafqIyAK7eeejrMBWxPEcx1DhmA+efVQN3aF5vA+s
pezBrYy1fiHEBuM4aQUhPNYqrL0peFxzdnoC+y2zVleh14TJRJxHP2EcKix1
7AjjNVXyCJKjyqz/VORsP1Z6rsHRXfYr3daSv1W7m2fCbcdyW9jvhkbQMhw7
fM3Z8foW8LqpXcIm0u24i1mGCKAdm/2OoJ7PxVx+18a/SpTsPKyXtbeYbJt3
N2p7lhij1rSeiF94dt0SbWVG5J1r3jb7WGBcTR4qhNC82OStO8Bru0w5trJ3
jcmvoO88rzwUfGXwGN8wji67USYZsfvPxXwGeSRyxt2E2rrNDpQF/sC7PMZ/
w1YU+ViHLkvU/xrtCI137exw8Xsmus52eYyenJz8zD5BlF1SWd3fRu29z2B5
z9PT0zmvUnkhr7rNUbuaTNb0lV12xcXLFonStANw7CMbcLZ4C31piv35DkeO
Zs/29gxrx6G6jPnYh98kuJZWhv6LLdLiqG65Lvw6t3VZcf7WrjOfL8bZLrdq
2QMkO5qLns+Geb+xB7j1iXzz58lcHnmATzsIX7TT6aEHODY/E36db18OPrku
OJu2dUbexM7qhrgcZ+R857ktut4xIsaXI74B9f7vsriuDzZeeLY/qW9z85nd
xjbfc2KVD31lE27XO8HjpWkGprOSy8CchO2OcGPBtp4e7gD7/D9FbdKXbs9O
qy0nG/s6UTVb2A77tXfOao+1DRs2fepaYl2rT96IfZp5wnacOd4Dp86976aj
/l4oRk3O5kVNts6rnDdpvhIlU0TQ7t+1T8k559y8fbSKCj67cUGPy9tGuC18
I2yxMebmaAAjhVb7p1o40JOUEq5grXWZv+G1mDa8W3L3j5/ox5ae1OlXcl5Q
GaVn2boYI0VmqooPY3RdMc/FYrGJUShlFcp/fN9FGSQUmP8pm9PsThzbYy75
xeTHVnO7x+TsebP6n4Jg8B9Hm9Zl\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{196, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TableForm=",
 CellID->234313736]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->873636812],

Cell[TextData[{
 "Inexact numbers have ",
 Cell[BoxData[
  ButtonBox["Precision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Precision"]], "InlineFormula"],
 " less than ",
 Cell[BoxData[
  FormBox["\[Infinity]", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->208922121],

Cell[BoxData[
 RowBox[{
  RowBox[{"numbers", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1.", ",", "2`10", ",", 
     RowBox[{"3", "/", "4"}], ",", 
     RowBox[{"5", "+", 
      RowBox[{"6", " ", "I"}]}], ",", 
     RowBox[{
      RowBox[{"N", "[", 
       RowBox[{"Pi", ",", "7"}], "]"}], "+", 
      RowBox[{"8", " ", "I"}]}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->204139606],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"InexactNumberQ", "[", "x", "]"}], ",", 
       RowBox[{"Precision", "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "numbers"}], "}"}]}], "]"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "\"\<x\>\"", ",", "\"\<inexact\>\"", ",", "\"\<Precision\>\""}], 
       "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->106801040],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdW1uP1TYQzsll71q23LVIZSn9ASzLCwKt6EurPvDKbQvSYUEFJFRKee9j
+8Ar4mftT9mfYOLEkzMZf46dHO85EZE2jp2JZ+bzeDxjn304/fTm9fvpp7fH
073fPk4/vHl7/M/er399LJuySZJMfkiS5O+rSfmsyqfqT1/ny7/6sX4q9D2j
t6oqNnq+ycqbruZlmZqySGo63V4RJPWVmSoviW5V9Lti2nW5Wpab7LvClKno
Py0f87K8AWRMDY/M0BFvly66/AVqrL9OiqZu2BOPFaCH9bW3t8LJg3+bizr+
iiOr69tA6656ahDjbTcdCK9VYs3abZnD9MetD+B4SITXAYcVIIn8TqIp67of
suxIKGO9GdXPor5mdEGW67CXztE4HIyozU3itdLmruq56UP9rNHVjT8BVG1q
KWlcjMlfbiEurf4kQtyD4lFIE7c/XQtAkvx46LyUeK5DHRrv6MNQdXlfn21y
tJBVhlmK5LIFqbRsBcAwNdrWzKvLtNAbGkM5v7k2SI7cQnao/eGR3DwTNDGv
bdh6ydJH+sR9r+RunvO34jWIxlNLQbOPxjk1lpKzcacIY8eU0op1rKWjngNV
W9iWatsNj4L8EYu+9Y3rlv+GdPNFhvfULJorGndSXxTt5QYjXf4HueHRlvMv
bHU6BJr418sOK2RUu8qOe99BjVDkGR6/DNNBrPnlwzWrRWr0Z5D0w+KEQ1En
G+haU3WnVwZK7bJZmv9y9T1UvrV8aKx8VYXaifTh50R91WCCsHRlUdzX/R/E
dUfUf4dabQiqL86+tQTkXdfE+/uqjqLXDUZfYS/6tlwPSJ5OVyaQQtqZglRk
fe5+eD0xzalTprSTIkymIXhMVQxPX1veycnJv9WVZNWtrJv3jxD9wr13LeXp
6WlLyrI+l5Tx/PNLVl+EZ32plu8pC0N5BHQf7gnlfHkCpQzzfHLV1H35PV24
Fwn3EbI/7Hf0bazxp/sNRVI8uudR+NDysgrf47yu7AxA075wSuzes+yT64+3
9bLQOca+ZjduGGvJZ2ME2CwIXe/6F4bvMcRV+vj1EaCyTFx1ozzp6IOnrONd
0DFgNC+efX3cPKjKtW91BJjERzV8h1PuDffBEtN+H/P+gi474+CDOZDj+5Ex
IpOLqt5ru6PaEc8ryF3fxhq7ud/IqO6RCo/GfjS0bD4kMy9N581U1qzpomG1
W3lOS9/mTBqeW2SMV57YO8QNbyb9JGnYdqyzpPdj0N43vrpByiq64symYdl4
iObW+4G858lQce4ke/zDI31YhNZ7hCLhE2VsOtbhYb/DWM546Mbr7G1zb2Z9
bORlJinlLABPdD6eAX+yGGT7xngY376eCPk4VG/o7JNazK11Gt5Xt9geiaSf
DB6h8HhxT9mrLLfMxvrz2ai1V0H5NY9l7IgrhBdZtaxnjj7wrpjE6CmUh1Ps
g77lOcmu1ctdyJ2Q0XuXOpK7rVDEsq3Y77jY1ztG+13RLn8vcA7y1rexRn3u
N2QJR2zEh5864Nl1BHgu/qwhpmzxThj8UhH/szx3cEtBvS/rNCIcH7Qqh51N
dPAYeELBZ1WcM1jN/HyF00h8iLV20xrxTBkP0pnpyZWEVkeeSdLqs6EiZYWt
VWDfbQutGfQcUYRlCaFxENx799veWDO52xDZ1nnCoEzJEyF25FXy96djyrNi
ocV3b3gc58Nl2dkQ1j9sHnZkHPYqiGdZwBzdhnRjyVc49a0Zlp3+2ZdFpArn
LTxf0EJtQqTPIts4mGnG9P0s6luWPDiqOBb1Oyos8n9Q9aYf6/8tSibfAIQ6
LKY=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{273, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TableForm=",
 CellID->644523772]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->462449979],

Cell[TextData[{
 "Inexact numbers have ",
 Cell[BoxData[
  ButtonBox["Head",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Head"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Complex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complex"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->51656093],

Cell[BoxData[
 RowBox[{
  RowBox[{"numbers", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1.", ",", "2`10", ",", 
     RowBox[{"3", "/", "4"}], ",", 
     RowBox[{"5", "+", 
      RowBox[{"6", " ", "I"}]}], ",", 
     RowBox[{
      RowBox[{"N", "[", 
       RowBox[{"Pi", ",", "7"}], "]"}], "+", 
      RowBox[{"8", " ", "I"}]}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->614358491],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"InexactNumberQ", "[", "x", "]"}], ",", 
       RowBox[{"Head", "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "numbers"}], "}"}]}], "]"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<x\>\"", ",", "\"\<inexact\>\"", ",", "\"\<Head\>\""}], 
       "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->367494095],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdW8lu1EAQdbxkMkmACEIIeziwHVluoBxBHLiyBZCGCAkOiC13foBvgSMS
PwCcIo75inxC47a7ZmrKr+2yxzNjMRLT0+1eql5313vuDg8He29evxvsvd0d
bN3/NPjw5u3u56177z+lRdFCEAQH6b+Pm0H626S/sn8HxqRp/p3Y78iWZp/g
W/pls1vw6XeRvwhrRa6POE1DlyZBXs+WZxWC/BO5LE+pXk/0u+jKbdpL0xXW
LnFpKPoP05+x84dsilx5T9YVfcWgL1tnCXptnwbJMO+akU2LwJdC68reEu8Y
vG0s8rgVR9fmj4JZLMuHDhFedgmOhH3hpSMrcF3pkRw3ex6P8kHQh3MkUe+D
fhcBorKdtAfZRyu+JeQxfhJ7adNUUbfe2VWw3Bjr6jGzXmJeKwa7aYorHiJo
Cy/OBG8e1zDOFGVXkfVje0L2z+MutiYM/FF4SYEmRX9tTJgUUxSTdJE1LKDV
LIJwjNGc6taYHGUV1rK2JQB5QiIfPPswbIjlhiwv9g2xY8R6yB9LbvXxfihG
q8OXK1PBE491FJaeNHIlyBV0A7Y7LWptQK8JoxUz2l00I6HDNGYzRHplzaVy
vdmYYHXMbddu0/WzCUf/O9PSNrVklRa8Y0baMRHrlNZk7PCM3WzNQw/Kna1j
qm2AipKvK3XDGX+tTmq2etqqGXJCdaQ/ziHrO6SumimgbZGn3VGmFBKKLh3Q
Pr7oQFFUapRtU6V4lPunUDopItNXLpIpj4l8zyGO1gRFVtkfZyrJf7PUEtK3
NZF/AJFbFrWuwFp6XrdoEE8vied3Tf5m2Xd+XDfd42vi1N/wqdxjv2At2nm4
D5632P7x2hF6n+rsqOP3wNTTDqcMiyLcO7YbePxCuyD/hJ4RF6Cd+Xj7+/tf
sk8QZV9p3j1/hOrPQSXgcQvnRzV61HFGGWqHh4djqKX5iVDzKISxEh0OOt3Y
Pi6vWJ5aabmf74Y2/YkMtsHvwRTZvM5qb+T/kPOLq6ZEBWAsSC3usHJCQc3e
0Dc+9yHrjbMzj1++EbHdMpo/gXbomFrWkiei2AKppK0FnKmvOt9PiHrE3JHK
Lz9b6viQ5zG3zlYr1CmVWp5WTzxhumH09z8XDObsmLWXLHze643/nqfOaWd3
SzeEzy3fBVW+J8nYjWdCWrHcAeRmhL3uNqiUVyZBXtbqdwC3eSJP90E8mvi0
DEZU5pc6gMd0EG10J9SqHsYzIFm21wH82p+BmndDXkXoU3l1OPP/iBqZLmxw
X3RchRy/L2pDM62b/J7jpsmjlLUipF3WSfWo05SPzDy0IHpXtqM+BuXd00+y
1nON1R1THs1tnpyzNbZ0le2qbJ8PT0irnhq5ltqOrXRm0tWY+MPhdwo+/Sny
614/I+cnzYXmnHuT6iWjelmnAUVPSmOQ0h6rczu+Y4qWt3WCLW9wS07zeqLU
PVtUjSM9xbdxbfpfPIu+oPe1JHaWxK0p+Eueac6gzzT2j04x/ZwgW9X1Z6gs
Wj2RRh6H3tr49r9wn+xtX37rrp9LFPnlyfNZM7Z6TVG3cXYmTkHaLgqw7qsd
gSpPlq+JvHx+GY7I4zA/Yb7m/LsJW5WxxUEwnO3ZMlRhvmg9PjNlnEEMg/6K
ynfH0De+m9NYtLLpOf9cj0XIF6rVANW24o6vzr1oyVuwLhYXSsvVzstGntP9
UjNOWOmsj/xdkf52obk3/B2ijt269VlyX1jUyHj1KdbuEVPFkjpmYZ6WRgtf
1OZ/mYneO0grEO749F++h0jusN84ZnwVeTzr66LWWdjXrsjfMiim0XtHjlz+
/7OChX8MK31M\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{217, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TableForm=",
 CellID->17185610]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->371728959],

Cell[TextData[{
 "A function equivalent to ",
 Cell[BoxData[
  ButtonBox["InexactNumberQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InexactNumberQ"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->370177670],

Cell[BoxData[
 RowBox[{
  RowBox[{"inq", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"NumberQ", "[", "#", "]"}], "&&", 
      RowBox[{"(", 
       RowBox[{"MatchQ", "[", 
        RowBox[{"#", ",", 
         RowBox[{"_Real", "|", 
          RowBox[{"Complex", "[", 
           RowBox[{"_Real", ",", "_"}], "]"}], "|", 
          RowBox[{"Complex", "[", 
           RowBox[{"_", ",", "_Real"}], "]"}]}]}], "]"}], ")"}]}], ")"}], 
    "&"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4966309],

Cell[BoxData[
 RowBox[{
  RowBox[{"numbers", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1.", ",", "2`10", ",", 
     RowBox[{"3", "/", "4"}], ",", 
     RowBox[{"5", "+", 
      RowBox[{"6", " ", "I"}]}], ",", 
     RowBox[{
      RowBox[{"N", "[", 
       RowBox[{"Pi", ",", "7"}], "]"}], "+", 
      RowBox[{"8", " ", "I"}]}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->56767047],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{
       RowBox[{"InexactNumberQ", "[", "x", "]"}], "===", 
       RowBox[{"inq", "[", "x", "]"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "numbers"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->587789134],

Cell[BoxData[
 TagBox[GridBox[{
    {"0", "True"},
    {"1.`", "True"},
    {"2.`10.", "True"},
    {
     FractionBox["3", "4"], "True"},
    {
     RowBox[{"5", "+", 
      RowBox[{"6", " ", "\[ImaginaryI]"}]}], "True"},
    {
     RowBox[{"3.1415926535897932385`7.", "+", 
      RowBox[{"8", " ", "\[ImaginaryI]"}]}], "True"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, BoxForm`opts$7481]]]], "Output",
 ImageSize->{127, 97},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//TableForm=",
 CellID->542492935]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28615],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExactNumberQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExactNumberQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MachineNumberQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MachineNumberQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Precision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Precision"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21256]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->86719361],

Cell[TextData[ButtonBox["Representation of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RepresentationOfNumbers"]], "MoreAbout",
 CellID->189368922]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InexactNumberQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 48, 35.8832916}", "context" -> "System`", 
    "keywords" -> {
     "approximate numbers", "real numbers", 
      "testing for approximate numbers"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "InexactNumberQ[expr] returns True if expr is an inexact real or complex \
number, and returns False otherwise.", "synonyms" -> {"inexact number q"}, 
    "title" -> "InexactNumberQ", "type" -> "Symbol", "uri" -> 
    "ref/InexactNumberQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4273, 148, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->623893755]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 24472, 825}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1431, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2054, 63, 52, 1, 70, "ObjectName",
 CellID->23668],
Cell[2109, 66, 883, 28, 70, "Usage",
 CellID->19019]
}, Open  ]],
Cell[CellGroupData[{
Cell[3029, 99, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3507, 116, 729, 27, 70, "Notes",
 CellID->4406]
}, Closed]],
Cell[CellGroupData[{
Cell[4273, 148, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->623893755],
Cell[CellGroupData[{
Cell[4658, 162, 148, 5, 70, "ExampleSection",
 CellID->367107541],
Cell[4809, 169, 246, 7, 70, "ExampleText",
 CellID->716711489],
Cell[CellGroupData[{
Cell[5080, 180, 112, 3, 28, "Input",
 CellID->225592494],
Cell[5195, 185, 160, 5, 36, "Output",
 CellID->28840888]
}, Open  ]],
Cell[CellGroupData[{
Cell[5392, 195, 132, 4, 28, "Input",
 CellID->52990215],
Cell[5527, 201, 162, 5, 36, "Output",
 CellID->853352726]
}, Open  ]],
Cell[CellGroupData[{
Cell[5726, 211, 109, 3, 28, "Input",
 CellID->96585538],
Cell[5838, 216, 162, 5, 36, "Output",
 CellID->413919217]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6049, 227, 216, 7, 70, "ExampleSection",
 CellID->30248],
Cell[6268, 236, 74, 1, 70, "ExampleText",
 CellID->470160432],
Cell[CellGroupData[{
Cell[6367, 241, 235, 7, 70, "Input",
 CellID->89028013],
Cell[6605, 250, 178, 5, 36, "Output",
 CellID->357061507]
}, Open  ]],
Cell[CellGroupData[{
Cell[6820, 260, 109, 3, 70, "Input",
 CellID->12544717],
Cell[6932, 265, 161, 5, 36, "Output",
 CellID->614050686]
}, Open  ]],
Cell[7108, 273, 125, 3, 70, "ExampleDelimiter",
 CellID->167879646],
Cell[7236, 278, 117, 3, 70, "ExampleText",
 CellID->304109859],
Cell[CellGroupData[{
Cell[7378, 285, 156, 5, 70, "Input",
 CellID->3194879],
Cell[7537, 292, 161, 5, 36, "Output",
 CellID->667199381]
}, Open  ]],
Cell[CellGroupData[{
Cell[7735, 302, 215, 7, 70, "Input",
 CellID->262951164],
Cell[7953, 311, 160, 5, 36, "Output",
 CellID->66776279]
}, Open  ]],
Cell[8128, 319, 125, 3, 70, "ExampleText",
 CellID->46635549],
Cell[CellGroupData[{
Cell[8278, 326, 181, 6, 70, "Input",
 CellID->39030061],
Cell[8462, 334, 162, 5, 36, "Output",
 CellID->511309303]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8673, 345, 232, 7, 70, "ExampleSection",
 CellID->8337],
Cell[8908, 354, 112, 3, 70, "ExampleText",
 CellID->337526657],
Cell[9023, 359, 412, 13, 70, "Input",
 CellID->441045006],
Cell[CellGroupData[{
Cell[9460, 376, 620, 19, 70, "Input",
 CellID->472518670],
Cell[10083, 397, 1655, 31, 70, "Output",
 Evaluatable->False,
 CellID->234313736]
}, Open  ]],
Cell[11753, 431, 125, 3, 70, "ExampleDelimiter",
 CellID->873636812],
Cell[11881, 436, 296, 11, 70, "ExampleText",
 CellID->208922121],
Cell[12180, 449, 412, 13, 70, "Input",
 CellID->204139606],
Cell[CellGroupData[{
Cell[12617, 466, 629, 20, 70, "Input",
 CellID->106801040],
Cell[13249, 488, 2058, 38, 70, "Output",
 Evaluatable->False,
 CellID->644523772]
}, Open  ]],
Cell[15322, 529, 125, 3, 70, "ExampleDelimiter",
 CellID->462449979],
Cell[15450, 534, 438, 18, 70, "ExampleText",
 CellID->51656093],
Cell[15891, 554, 412, 13, 70, "Input",
 CellID->614358491],
Cell[CellGroupData[{
Cell[16328, 571, 611, 19, 70, "Input",
 CellID->367494095],
Cell[16942, 592, 2065, 38, 70, "Output",
 Evaluatable->False,
 CellID->17185610]
}, Open  ]],
Cell[19022, 633, 125, 3, 70, "ExampleDelimiter",
 CellID->371728959],
Cell[19150, 638, 220, 8, 70, "ExampleText",
 CellID->370177670],
Cell[19373, 648, 518, 17, 70, "Input",
 CellID->4966309],
Cell[19894, 667, 411, 13, 70, "Input",
 CellID->56767047],
Cell[CellGroupData[{
Cell[20330, 684, 379, 12, 70, "Input",
 CellID->587789134],
Cell[20712, 698, 946, 30, 132, "Output",
 CellID->542492935]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21719, 735, 311, 9, 70, "SeeAlsoSection",
 CellID->28615],
Cell[22033, 746, 718, 26, 70, "SeeAlso",
 CellID->21256]
}, Open  ]],
Cell[CellGroupData[{
Cell[22788, 777, 318, 9, 70, "MoreAboutSection",
 CellID->86719361],
Cell[23109, 788, 160, 3, 70, "MoreAbout",
 CellID->189368922]
}, Open  ]],
Cell[23284, 794, 27, 0, 70, "History"],
Cell[23314, 796, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

