(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25892,        790]
NotebookOptionsPosition[     21030,        628]
NotebookOutlinePosition[     23088,        689]
CellTagsIndexPosition[     22924,        681]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Automatic" :> Documentation`HelpLookup["paclet:ref/Automatic"], 
         "Style" :> Documentation`HelpLookup["paclet:ref/Style"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"Automatic\"\>", 
      2->"\<\"Style\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Inherited", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Inherited",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Inherited"]], "InlineFormula"],
     "\[LineSeparator]represents an option value to be inherited from an \
enclosing style, cell or notebook. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7434]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["opt", "TI"], "->", "Inherited"}]], "InlineFormula"],
 " is equivalent to giving no setting for ",
 Cell[BoxData[
  StyleBox["opt", "TI"]], "InlineFormula"],
 " at a particular level. "
}], "Notes",
 CellID->16782],

Cell["\<\
If no explicit setting is given at any level, then a built\[Hyphen]in default \
value is used. \
\>", "Notes",
 CellID->2331],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Inherited",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Inherited"]], "InlineFormula"],
 " is always effectively replaced by an explicit value before the option \
setting is used. "
}], "Notes",
 CellID->6746],

Cell[TextData[{
 "If the nearest enclosing option setting is of the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["opt", "TI"], "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["a", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["b", "TI"], 
      StyleBox["1", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 ", then an option setting in ",
 Cell[BoxData[
  RowBox[{
   StyleBox["opt", "TI"], "->", 
   RowBox[{"{", 
    RowBox[{"Inherited", ",", 
     SubscriptBox[
      StyleBox["b", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " is taken to be equivalent to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["opt", "TI"], "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["a", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["b", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22870]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->164197357],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->527374241],

Cell["\<\
Create a cell with a font-size setting overriding the notebook-level setting:\
\
\>", "ExampleText",
 CellID->76437243],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{
     RowBox[{"TextCell", "[", 
      RowBox[{"\"\<abcd abcd abcd\>\"", ",", "\"\<Text\>\"", ",", 
       RowBox[{"FontSize", "\[Rule]", "14"}]}], "]"}], ",", 
     RowBox[{"FontSize", "\[Rule]", "20"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14809668],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVtPlEcch2l63/gV+lVse6tp403bpIopoG2MadO7Jr0wVVutTfEAooBK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   "], {{0, 0}, {458, 66}}, {0, 255}],
  ImageSize->{458 0.75, 66 0.75},
  PlotRange->{{0, 458}, {0, 66}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->141522376]
}, Open  ]],

Cell["Select the cell:", "ExampleText",
 CellID->290150425],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SelectionMove", "[", 
  RowBox[{"nb", ",", "Next", ",", "Cell"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->504834990],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnG1Pk1cch7vs/eJX2Fdxe7nMZNurLZlgBugWs2wfYC+MD5vMRXwAUWDK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   "], {{0, 0}, {458, 66}}, {0, 255}],
  ImageSize->{458 0.75, 66 0.75},
  PlotRange->{{0, 458}, {0, 66}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->37898422]
}, Open  ]],

Cell[TextData[{
 "Cancel the cell-level setting for ",
 Cell[BoxData[
  ButtonBox["FontSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FontSize"]], "InlineFormula"],
 ", letting the higher-level setting take effect:"
}], "ExampleText",
 CellID->491007953],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{
   RowBox[{"NotebookSelection", "[", "nb", "]"}], ",", 
   RowBox[{"FontSize", "\[Rule]", "Inherited"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->7996061],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnd1vFNcZxrfqfZV/of9K2svSSG2uUqmxUTFOq6hqrlEvopC0MalCABsc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   "], {{0, 0}, {458, 66}}, {0, 255}],
  ImageSize->{458 0.75, 66 0.75},
  PlotRange->{{0, 458}, {0, 66}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->237735250]
}, Open  ]],

Cell["Now the cell itself has no option settings:", "ExampleText",
 CellID->106188420],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", 
  RowBox[{"NotebookSelection", "[", "nb", "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->57081541],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->150679128]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->43423481],

Cell[TextData[{
 "This makes a cell in ",
 Cell[BoxData[
  ButtonBox["\"\<Text\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Text"]], "InlineFormula"],
 " style:"
}], "ExampleText",
 CellID->333448246],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"TextCell", "[", 
   RowBox[{
    RowBox[{"StringJoin", "[", 
     RowBox[{"Table", "[", 
      RowBox[{"\"\<abcd \>\"", ",", 
       RowBox[{"{", "40", "}"}]}], "]"}], "]"}], ",", "\"\<Text\>\"", ",", 
    RowBox[{"CellTags", "\[Rule]", "\"\<inh1\>\""}]}], "]"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->245516069],

Cell["\<\
abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd \
abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd \
abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd \
\>", "Text",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellTags->"inh1",
 CellID->303532796],

Cell[TextData[{
 "This is the ",
 Cell[BoxData[
  ButtonBox["CellMargins",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellMargins"]], "InlineFormula"],
 " setting inherited from ",
 Cell[BoxData[
  ButtonBox["\"\<Text\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Text"]], "InlineFormula"],
 " style:"
}], "ExampleText",
 CellID->73539666],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NotebookLocate", "[", "\"\<inh1\>\"", "]"}], ";", 
  RowBox[{"Options", "[", 
   RowBox[{
    RowBox[{"NotebookSelection", "[", 
     RowBox[{"EvaluationNotebook", "[", "]"}], "]"}], ",", "CellMargins"}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31274082],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"CellMargins", "\[Rule]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"60", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "7"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{229, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->115463978]
}, Open  ]],

Cell["\<\
This cell uses its own setting for the right margin and inherits the other \
margins:\
\>", "ExampleText",
 CellID->342376277],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"TextCell", "[", 
   RowBox[{
    RowBox[{"StringJoin", "[", 
     RowBox[{"Table", "[", 
      RowBox[{"\"\<abcd \>\"", ",", 
       RowBox[{"{", "40", "}"}]}], "]"}], "]"}], ",", "\"\<Text\>\"", ",", 
    RowBox[{"CellMargins", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Inherited", ",", "120"}], "}"}], ",", "Inherited"}], "}"}]}],
     ",", 
    RowBox[{"CellTags", "\[Rule]", "\"\<inh2\>\""}]}], "]"}], "]"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->629134313],

Cell["\<\
abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd \
abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd \
abcd abcd abcd abcd abcd abcd abcd abcd abcd abcd \
\>", "Text",
 CellMargins->{{Inherited, 120}, Inherited},
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellTags->"inh2",
 CellID->73707708],

Cell[TextData[{
 "In this case, the ",
 Cell[BoxData[
  ButtonBox["Inherited",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Inherited"]], "InlineFormula"],
 " symbol appears in the cell's ",
 Cell[BoxData[
  ButtonBox["CellMargins",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellMargins"]], "InlineFormula"],
 " setting:"
}], "ExampleText",
 CellID->6724411],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NotebookLocate", "[", "\"\<inh2\>\"", "]"}], ";", 
  RowBox[{"Options", "[", 
   RowBox[{
    RowBox[{"NotebookSelection", "[", 
     RowBox[{"EvaluationNotebook", "[", "]"}], "]"}], ",", "CellMargins"}], 
   "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->567545291],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"CellMargins", "\[Rule]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Inherited", ",", "120"}], "}"}], ",", "Inherited"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{309, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->281275345]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8360],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25778]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Inherited - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 48, 37.2270760}", "context" -> "System`", 
    "keywords" -> {
     "inherited options", "hierarchical options", "cascading options", 
      "inherited styles", "cascading styles", "hierarchical styles", 
      "default styles", "default options", "reverting a style", 
      "reverting an option"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Inherited represents an option value to be inherited from an enclosing \
style, cell or notebook. ", "synonyms" -> {}, "title" -> "Inherited", "type" -> 
    "Symbol", "uri" -> "ref/Inherited"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5605, 188, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->164197357]},
 "Notebook Image"->{
  Cell[6664, 229, 2524, 44, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->141522376],
  Cell[9439, 287, 2543, 44, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->37898422],
  Cell[12506, 354, 2923, 51, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->237735250]},
 "inh1"->{
  Cell[16623, 456, 315, 8, 70, "Text",
   CellTags->"inh1",
   CellID->303532796]},
 "inh2"->{
  Cell[18730, 535, 359, 9, 70, "Text",
   CellTags->"inh2",
   CellID->73707708]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 22261, 656},
 {"Notebook Image", 22402, 660},
 {"inh1", 22723, 670},
 {"inh2", 22818, 674}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 645, 15, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1268, 42, 1574, 37, 70, "ObjectNameGrid"],
Cell[2845, 81, 472, 14, 70, "Usage",
 CellID->7434]
}, Open  ]],
Cell[CellGroupData[{
Cell[3354, 100, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3832, 117, 268, 9, 70, "Notes",
 CellID->16782],
Cell[4103, 128, 135, 4, 70, "Notes",
 CellID->2331],
Cell[4241, 134, 258, 8, 70, "Notes",
 CellID->6746],
Cell[4502, 144, 1066, 39, 70, "Notes",
 CellID->22870]
}, Closed]],
Cell[CellGroupData[{
Cell[5605, 188, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->164197357],
Cell[CellGroupData[{
Cell[5990, 202, 148, 5, 70, "ExampleSection",
 CellID->527374241],
Cell[6141, 209, 129, 4, 70, "ExampleText",
 CellID->76437243],
Cell[CellGroupData[{
Cell[6295, 217, 366, 10, 70, "Input",
 CellID->14809668],
Cell[6664, 229, 2524, 44, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->141522376]
}, Open  ]],
Cell[9203, 276, 59, 1, 70, "ExampleText",
 CellID->290150425],
Cell[CellGroupData[{
Cell[9287, 281, 149, 4, 70, "Input",
 CellID->504834990],
Cell[9439, 287, 2543, 44, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->37898422]
}, Open  ]],
Cell[11997, 334, 263, 8, 70, "ExampleText",
 CellID->491007953],
Cell[CellGroupData[{
Cell[12285, 346, 218, 6, 70, "Input",
 CellID->7996061],
Cell[12506, 354, 2923, 51, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->237735250]
}, Open  ]],
Cell[15444, 408, 86, 1, 70, "ExampleText",
 CellID->106188420],
Cell[CellGroupData[{
Cell[15555, 413, 147, 4, 70, "Input",
 CellID->57081541],
Cell[15705, 419, 175, 6, 36, "Output",
 CellID->150679128]
}, Open  ]],
Cell[15895, 428, 124, 3, 70, "ExampleDelimiter",
 CellID->43423481],
Cell[16022, 433, 217, 8, 70, "ExampleText",
 CellID->333448246],
Cell[16242, 443, 378, 11, 70, "Input",
 CellID->245516069],
Cell[16623, 456, 315, 8, 70, "Text",
 CellTags->"inh1",
 CellID->303532796],
Cell[16941, 466, 361, 13, 70, "ExampleText",
 CellID->73539666],
Cell[CellGroupData[{
Cell[17327, 483, 304, 9, 70, "Input",
 CellID->31274082],
Cell[17634, 494, 377, 13, 36, "Output",
 CellID->115463978]
}, Open  ]],
Cell[18026, 510, 136, 4, 70, "ExampleText",
 CellID->342376277],
Cell[18165, 516, 562, 17, 70, "Input",
 CellID->629134313],
Cell[18730, 535, 359, 9, 70, "Text",
 CellTags->"inh2",
 CellID->73707708],
Cell[19092, 546, 369, 13, 70, "ExampleText",
 CellID->6724411],
Cell[CellGroupData[{
Cell[19486, 563, 305, 9, 70, "Input",
 CellID->567545291],
Cell[19794, 574, 343, 12, 36, "Output",
 CellID->281275345]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20198, 593, 310, 9, 70, "SeeAlsoSection",
 CellID->8360],
Cell[20511, 604, 447, 17, 70, "SeeAlso",
 CellID->25778]
}, Open  ]],
Cell[20973, 624, 27, 0, 70, "History"],
Cell[21003, 626, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

