(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     36668,        863]
NotebookOptionsPosition[     32417,        729]
NotebookOutlinePosition[     34520,        787]
CellTagsIndexPosition[     34402,        781]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Cells" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForCells"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Options for Cells\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluator" :> Documentation`HelpLookup["paclet:ref/Evaluator"],
           "Initialization" :> 
          Documentation`HelpLookup["paclet:ref/Initialization"], 
          "CellContext" :> Documentation`HelpLookup["paclet:ref/CellContext"],
           "DockedCells" :> 
          Documentation`HelpLookup["paclet:ref/DockedCells"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Evaluator\"\>", 
       2->"\<\"Initialization\"\>", 3->"\<\"CellContext\"\>", 
       4->"\<\"DockedCells\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluation Options in Notebooks" :> 
          Documentation`HelpLookup[
           "paclet:guide/EvaluationOptionsInNotebooks"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Evaluation Options in Notebooks\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InitializationCell", "ObjectName",
 CellID->6266],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["InitializationCell",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/InitializationCell"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Cell",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
     " which specifies whether the cell should be tagged to be evaluated by \
the ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " kernel when the notebook that contains it is opened. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17605]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Additional front end options determine the precise behavior of initialization \
cells when a notebook is opened.\
\>", "Notes",
 CellID->602380631],

Cell["\<\
When you first save a notebook that contains initialization cells, you have \
the option to make a parallel auto-generated .m package that contains only \
the contents of the initialization cells. The package is by default \
automatically updated whenever the initialization cells in the notebook are \
changed and saved again.\
\>", "Notes",
 CellID->79854124]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->236677644],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->926858937],

Cell["\<\
Create and save a notebook that has an input cell marked as initialization:\
\>", "ExampleText",
 CellID->560482265],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{"ExpressionCell", "[", 
     RowBox[{
      RowBox[{"Defer", "[", 
       RowBox[{"a", "=", 
        RowBox[{"2", "+", "2"}]}], "]"}], ",", "\"\<Input\>\"", ",", 
      RowBox[{"InitializationCell", "\[Rule]", "True"}]}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->298265157],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVtPlEcch2l63/gV+lF6utW08aaHVDAC2sYYm140aeKFKdpKbYoH8ACo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   "], {{0, 0}, {458, 65}}, {0, 255}],
  ImageSize->{458 0.75, 65 0.75},
  PlotRange->{{0, 458}, {0, 65}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->47420764]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"NotebookSave", "[", 
   RowBox[{"nb", ",", 
    RowBox[{"$TemporaryPrefix", "<>", "\"\<exmpl-temp.nb\>\""}]}], "]"}], ";",
   
  RowBox[{"NotebookClose", "[", "nb", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->298616822],

Cell["\<\
Initialization cells are useful when you reopen the saved notebook:\
\>", "ExampleText",
 CellID->1703219],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"NotebookOpen", "[", 
    RowBox[{"$TemporaryPrefix", "<>", "\"\<exmpl-temp.nb\>\""}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->106869461],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVtPVFcYhml63/gX+lN6utW08aaHVDGKto0xNr1o0sQLU7XV2tQTeEBU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   "], {{0, 0}, {458, 65}}, {0, 255}],
  ImageSize->{458 0.75, 65 0.75},
  PlotRange->{{0, 458}, {0, 65}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->105881367],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztne9TVNcdh+n0fSf/Qv+Vpn2rk0xeNE2mEUfRpJNx7PRFZjqTF5matKHp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   "], {{0, 0}, {458, 88}}, {0, 255}],
  ImageSize->{458 0.75, 88 0.75},
  PlotRange->{{0, 458}, {0, 88}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->57278377]
}, Open  ]],

Cell[TextData[{
 "Or, when you evaluate any cell, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " asks if you want to evaluate the initialization cells:"
}], "ExampleText",
 CellID->258717620],

Cell[BoxData[Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Graphics",
  ImageSize->{228., 78.8125},
  ImageMargins->0]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->298117578],

Cell[TextData[{
 "If you choose ",
 StyleBox["Yes", "DialogElementName"],
 ", initialization cells are evaluated:"
}], "ExampleText",
 CellID->391467571],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztne9TVNcdh+n0fSf/Qv+Vpn2rk0xeNE2mEUfRpJNx7PRFZjqTF5matKHp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   "], {{0, 0}, {458, 88}}, {0, 255}],
  ImageSize->{458 0.75, 88 0.75},
  PlotRange->{{0, 458}, {0, 88}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->377849563]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19738],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Evaluator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Evaluator"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Initialization",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Initialization"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellContext",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellContext"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DockedCells",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DockedCells"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18888]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18065],

Cell[TextData[ButtonBox["Options for Cells",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForCells"]], "Tutorials",
 CellID->21903]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->218657667],

Cell[TextData[ButtonBox["Evaluation Options in Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EvaluationOptionsInNotebooks"]], "MoreAbout",
 CellID->232106125]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InitializationCell - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 48, 38.0083460}", "context" -> "System`", 
    "keywords" -> {
     "automatic evaluation", "immediate evaluation", "startup cells", 
      "initialization cells", "active notebooks", "code notebooks", 
      "prototype notebooks"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "InitializationCell is an option for Cell which specifies whether the \
cell should be tagged to be evaluated by the Mathematica kernel when the \
notebook that contains it is opened. ", "synonyms" -> {"initialization cell"},
     "title" -> "InitializationCell", "type" -> "Symbol", "uri" -> 
    "ref/InitializationCell"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4633, 144, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->236677644]},
 "Notebook Image"->{
  Cell[5716, 186, 2515, 44, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->47420764],
  Cell[8869, 259, 2634, 46, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->105881367],
  Cell[11506, 307, 3178, 55, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->57278377],
  Cell[14901, 373, 11749, 195, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->298117578],
  Cell[26809, 577, 3179, 55, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->377849563]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 33719, 758},
 {"Notebook Image", 33860, 762}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2117, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2740, 79, 55, 1, 70, "ObjectName",
 CellID->6266],
Cell[2798, 82, 752, 22, 70, "Usage",
 CellID->17605]
}, Open  ]],
Cell[CellGroupData[{
Cell[3587, 109, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4065, 126, 157, 4, 70, "Notes",
 CellID->602380631],
Cell[4225, 132, 371, 7, 70, "Notes",
 CellID->79854124]
}, Closed]],
Cell[CellGroupData[{
Cell[4633, 144, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->236677644],
Cell[CellGroupData[{
Cell[5018, 158, 148, 5, 70, "ExampleSection",
 CellID->926858937],
Cell[5169, 165, 126, 3, 70, "ExampleText",
 CellID->560482265],
Cell[CellGroupData[{
Cell[5320, 172, 393, 12, 70, "Input",
 CellID->298265157],
Cell[5716, 186, 2515, 44, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->47420764]
}, Open  ]],
Cell[8246, 233, 261, 8, 70, "Input",
 CellID->298616822],
Cell[8510, 243, 116, 3, 70, "ExampleText",
 CellID->1703219],
Cell[CellGroupData[{
Cell[8651, 250, 215, 7, 70, "Input",
 CellID->106869461],
Cell[8869, 259, 2634, 46, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->105881367],
Cell[11506, 307, 3178, 55, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->57278377]
}, Open  ]],
Cell[14699, 365, 199, 6, 70, "ExampleText",
 CellID->258717620],
Cell[14901, 373, 11749, 195, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->298117578],
Cell[26653, 570, 153, 5, 70, "ExampleText",
 CellID->391467571],
Cell[26809, 577, 3179, 55, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->377849563]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30037, 638, 311, 9, 70, "SeeAlsoSection",
 CellID->19738],
Cell[30351, 649, 967, 35, 70, "SeeAlso",
 CellID->18888]
}, Open  ]],
Cell[CellGroupData[{
Cell[31355, 689, 314, 9, 70, "TutorialsSection",
 CellID->18065],
Cell[31672, 700, 143, 3, 70, "Tutorials",
 CellID->21903]
}, Open  ]],
Cell[CellGroupData[{
Cell[31852, 708, 319, 9, 70, "MoreAboutSection",
 CellID->218657667],
Cell[32174, 719, 171, 3, 70, "MoreAbout",
 CellID->232106125]
}, Open  ]],
Cell[32360, 725, 27, 0, 70, "History"],
Cell[32390, 727, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

