(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     28853,        820]
NotebookOptionsPosition[     24403,        677]
NotebookOutlinePosition[     26323,        730]
CellTagsIndexPosition[     26205,        724]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Expression Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OptionsForExpressionInputAndOutput"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Options for Expression Input and Output\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"InputAutoReplacements" :> 
          Documentation`HelpLookup["paclet:ref/InputAutoReplacements"], 
          "$PreRead" :> Documentation`HelpLookup["paclet:ref/$PreRead"], 
          "Set" :> Documentation`HelpLookup["paclet:ref/Set"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"InputAutoReplacements\"\>", 
       2->"\<\"$PreRead\"\>", 3->"\<\"Set\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Automatic Text Styling Features" :> 
          Documentation`HelpLookup[
           "paclet:guide/AutomaticTextStylingFeatures"], 
          "Defining Custom Notation" :> 
          Documentation`HelpLookup["paclet:guide/DefiningCustomNotation"], 
          "Programmatic Notebook & Interface Customization" :> 
          Documentation`HelpLookup[
           "paclet:guide/ProgrammaticNotebookAndInterfaceCustomization"], 
          "Stylesheets" :> 
          Documentation`HelpLookup["paclet:guide/Stylesheets"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Automatic Text Styling Features\"\>", 
       2->"\<\"Defining Custom Notation\"\>", 
       3->"\<\"Programmatic Notebook & Interface Customization\"\>", 
       4->"\<\"Stylesheets\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InputAliases", "ObjectName",
 CellID->17794],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["InputAliases",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/InputAliases"]], "InlineFormula"],
     "\[LineSeparator]is an option for cells and notebooks which specifies \
additional ",
     StyleBox["Esc", "KeyEvent"],
     StyleBox["\[ThinSpace]", "InlineCode"],
     StyleBox["name", "TI"],
     StyleBox["\[ThinSpace]", "InlineCode"],
     StyleBox["Esc", "KeyEvent"],
     " aliases to be allowed on input. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->25847]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The setting ",
 Cell[BoxData[
  RowBox[{"InputAliases", "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"name\", \"TI\"], 
StyleBox[\"1\", \"TI\"]]\)\>\"", "->", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TI"]]}], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " specifies that the ",
 StyleBox["Esc", "KeyEvent"],
 "\[ThinSpace]",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["name", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "\[ThinSpace]",
 StyleBox["Esc", "KeyEvent"],
 " should be replaced on input by the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22923],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " should be strings or box expressions. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->143908187]
}], "Notes",
 CellID->17836]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->28762064],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->401590444],

Cell[TextData[{
 "Create a notebook that uses ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]dli\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " as an alias for ",
 Cell[TextData[ButtonBox["\\[DotlessI]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/DotlessI"]], "InlineCharacterName"],
 ":"
}], "ExampleText",
 CellID->297271062],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"InputAliases", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<dli\>\"", "\[Rule]", "\"\<\[DotlessI]\>\""}], "}"}]}]}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->243537403],

Cell[TextData[{
 "Alias input starts with an ",
 StyleBox["Esc", "KeyEvent"],
 ", indicated on screen by ",
 Cell[BoxData["\[AliasIndicator]"], "InlineFormula"],
 " :"
}], "ExampleText",
 CellID->616331661],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztne1Pk1cYxrvs++K/sH9lm181W/yyLZlgJuoWY1z2YcmSfTBTN53LfAN1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   "], {{0, 0}, {458, 69}}, {0, 255}],
  ImageSize->{458 0.75, 69 0.75},
  PlotRange->{{0, 458}, {0, 69}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->274467080],

Cell[TextData[{
 "Typing ",
 StyleBox["Esc", "KeyEvent"],
 " again produces the desired result form:"
}], "ExampleText",
 CellID->54872689],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVtPVFcYhqfpfeNf6H1/RVtvNW28aZtUMAW0jTE2vWjSpBemaiu1KR5A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   "], {{0, 0}, {458, 69}}, {0, 255}],
  ImageSize->{458 0.75, 69 0.75},
  PlotRange->{{0, 458}, {0, 69}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->636728456]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5237],

Cell["Define an alias for a two-dimensional typeset expression:", \
"ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->143908187],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"InputAliases", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<x2\>\"", "\[Rule]", 
        RowBox[{"SuperscriptBox", "[", 
         RowBox[{"\"\<x\>\"", ",", "\"\<2\>\""}], "]"}]}], "}"}]}]}], "]"}]}],
   ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->142680571],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVtPVFcYhqfpfeNf6B/pRQ+3mjbetE0qmAraxhibXjRp0gtTtZXaFA/g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   "], {{0, 0}, {458, 62}}, {0, 255}],
  ImageSize->{458 0.75, 62 0.75},
  PlotRange->{{0, 458}, {0, 62}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->75713677],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnFtPlEcch7fpfeNX6H0/Qy96uNW08aZtUsVU0DbG2PSiSZNemKqt1Kae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   "], {{0, 0}, {458, 62}}, {0, 255}],
  ImageSize->{458 0.75, 62 0.75},
  PlotRange->{{0, 458}, {0, 62}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->345493]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3235],

Cell[TextData[{
 "Find out the ",
 Cell[BoxData[
  ButtonBox["InputAliases",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputAliases"]], "InlineFormula"],
 " for the selected notebook: "
}], "ExampleText",
 CellID->120676139],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Options", "[", 
  RowBox[{
   RowBox[{"SelectedNotebook", "[", "]"}], ",", "InputAliases"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->914788155],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"InputAliases", "\[Rule]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\<\"intt\"\>", "\[Rule]", 
      RowBox[{"RowBox", "[", 
       RowBox[{"{", 
        RowBox[{"\<\"\[Integral]\"\>", ",", 
         RowBox[{"RowBox", "[", 
          RowBox[{"{", 
           RowBox[{"\<\"\[SelectionPlaceholder]\"\>", ",", 
            RowBox[{"RowBox", "[", 
             RowBox[{"{", 
              
              RowBox[{"\<\"\[DifferentialD]\"\>", 
               ",", "\<\"\[Placeholder]\"\>"}], "}"}], "]"}]}], "}"}], 
          "]"}]}], "}"}], "]"}]}], ",", 
     RowBox[{"\<\"dintt\"\>", "\[Rule]", 
      RowBox[{"RowBox", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"SubsuperscriptBox", "[", 
          
          RowBox[{"\<\"\[Integral]\"\>", 
           ",", "\<\"\[SelectionPlaceholder]\"\>", 
           ",", "\<\"\[Placeholder]\"\>"}], "]"}], ",", 
         RowBox[{"RowBox", "[", 
          RowBox[{"{", 
           RowBox[{"\<\"\[Placeholder]\"\>", ",", 
            RowBox[{"RowBox", "[", 
             RowBox[{"{", 
              
              RowBox[{"\<\"\[DifferentialD]\"\>", 
               ",", "\<\"\[Placeholder]\"\>"}], "}"}], "]"}]}], "}"}], 
          "]"}]}], "}"}], "]"}]}], ",", 
     RowBox[{"\<\"sumt\"\>", "\[Rule]", 
      RowBox[{"RowBox", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"UnderoverscriptBox", "[", 
          RowBox[{"\<\"\[Sum]\"\>", ",", 
           RowBox[{"RowBox", "[", 
            RowBox[{"{", 
             
             RowBox[{"\<\"\[SelectionPlaceholder]\"\>", ",", "\<\"=\"\>", 
              ",", "\<\"\[Placeholder]\"\>"}], "}"}], "]"}], 
           ",", "\<\"\[Placeholder]\"\>"}], "]"}], 
         ",", "\<\"\[Placeholder]\"\>"}], "}"}], "]"}]}], ",", 
     RowBox[{"\<\"prodt\"\>", "\[Rule]", 
      RowBox[{"RowBox", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"UnderoverscriptBox", "[", 
          RowBox[{"\<\"\[Product]\"\>", ",", 
           RowBox[{"RowBox", "[", 
            RowBox[{"{", 
             
             RowBox[{"\<\"\[SelectionPlaceholder]\"\>", ",", "\<\"=\"\>", 
              ",", "\<\"\[Placeholder]\"\>"}], "}"}], "]"}], 
           ",", "\<\"\[Placeholder]\"\>"}], "]"}], 
         ",", "\<\"\[Placeholder]\"\>"}], "}"}], "]"}]}], ",", 
     RowBox[{"\<\"dt\"\>", "\[Rule]", 
      RowBox[{"RowBox", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"SubscriptBox", "[", 
          RowBox[{"\<\"\[PartialD]\"\>", ",", "\<\"\[Placeholder]\"\>"}], 
          "]"}], ",", "\<\" \"\>", ",", "\<\"\[SelectionPlaceholder]\"\>"}], 
        "}"}], "]"}]}], ",", 
     RowBox[{"\<\"ls\"\>", "\[Rule]", "\<\"\[LineSeparator]\"\>"}]}], "}"}]}],
   "}"}]], "Output",
 ImageSize->{525, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8124641]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25581],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["InputAutoReplacements",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputAutoReplacements"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$PreRead",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$PreRead"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Set",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Set"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20368]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7072],

Cell[TextData[ButtonBox["Options for Expression Input and Output",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/OptionsForExpressionInputAndOutput"]], "Tutorials",
 CellID->15343]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Automatic Text Styling Features",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AutomaticTextStylingFeatures"]], "MoreAbout",
 CellID->166128439],

Cell[TextData[ButtonBox["Defining Custom Notation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DefiningCustomNotation"]], "MoreAbout",
 CellID->68483455],

Cell[TextData[ButtonBox["Programmatic Notebook & Interface Customization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ProgrammaticNotebookAndInterfaceCustomization"]], "MoreAbout",\

 CellID->399920017],

Cell[TextData[ButtonBox["Stylesheets",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Stylesheets"]], "MoreAbout",
 CellID->156050984]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InputAliases - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 48, 45.0397760}", "context" -> "System`", 
    "keywords" -> {
     "abbreviation", "aliases", "escape sequences", "special character input",
       "user-defined aliases", "macro sequence", "macros", "document macros"},
     "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "InputAliases is an option for cells and notebooks which specifies \
additional Esc\\[ThinSpace]name\\[ThinSpace]Esc aliases to be allowed on \
input. ", "synonyms" -> {"input aliases"}, "title" -> "InputAliases", "type" -> 
    "Symbol", "uri" -> "ref/InputAliases"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5588, 180, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->28762064]},
 "Notebook Image"->{
  Cell[7039, 236, 2565, 45, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->274467080],
  Cell[9749, 290, 2496, 44, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->636728456],
  Cell[13086, 370, 2515, 44, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->75713677],
  Cell[15604, 416, 2489, 44, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->345493]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 25631, 704},
 {"Notebook Image", 25771, 708}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2598, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3221, 88, 50, 1, 70, "ObjectName",
 CellID->17794],
Cell[3274, 91, 686, 20, 70, "Usage",
 CellID->25847]
}, Open  ]],
Cell[CellGroupData[{
Cell[3997, 116, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4475, 133, 787, 29, 70, "Notes",
 CellID->22923],
Cell[5265, 164, 286, 11, 70, "Notes",
 CellID->17836]
}, Closed]],
Cell[CellGroupData[{
Cell[5588, 180, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->28762064],
Cell[CellGroupData[{
Cell[5972, 194, 148, 5, 70, "ExampleSection",
 CellID->401590444],
Cell[6123, 201, 365, 11, 70, "ExampleText",
 CellID->297271062],
Cell[6491, 214, 336, 11, 70, "Input",
 CellID->243537403],
Cell[6830, 227, 206, 7, 70, "ExampleText",
 CellID->616331661],
Cell[7039, 236, 2565, 45, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->274467080],
Cell[9607, 283, 139, 5, 70, "ExampleText",
 CellID->54872689],
Cell[9749, 290, 2496, 44, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->636728456]
}, Open  ]],
Cell[CellGroupData[{
Cell[12282, 339, 215, 7, 70, "ExampleSection",
 CellID->5237],
Cell[12500, 348, 150, 3, 70, "ExampleText",
 CellID->143908187],
Cell[CellGroupData[{
Cell[12675, 355, 408, 13, 70, "Input",
 CellID->142680571],
Cell[13086, 370, 2515, 44, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->75713677],
Cell[15604, 416, 2489, 44, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->345493]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18142, 466, 232, 7, 70, "ExampleSection",
 CellID->3235],
Cell[18377, 475, 231, 8, 70, "ExampleText",
 CellID->120676139],
Cell[CellGroupData[{
Cell[18633, 487, 179, 6, 70, "Input",
 CellID->914788155],
Cell[18815, 495, 2870, 76, 128, "Output",
 CellID->8124641]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21746, 578, 311, 9, 70, "SeeAlsoSection",
 CellID->25581],
Cell[22060, 589, 712, 26, 70, "SeeAlso",
 CellID->20368]
}, Open  ]],
Cell[CellGroupData[{
Cell[22809, 620, 313, 9, 70, "TutorialsSection",
 CellID->7072],
Cell[23125, 631, 187, 4, 70, "Tutorials",
 CellID->15343]
}, Open  ]],
Cell[CellGroupData[{
Cell[23349, 640, 299, 8, 70, "MoreAboutSection"],
Cell[23651, 650, 171, 3, 70, "MoreAbout",
 CellID->166128439],
Cell[23825, 655, 157, 3, 70, "MoreAbout",
 CellID->68483455],
Cell[23985, 660, 209, 5, 70, "MoreAbout",
 CellID->399920017],
Cell[24197, 667, 134, 3, 70, "MoreAbout",
 CellID->156050984]
}, Open  ]],
Cell[24346, 673, 27, 0, 70, "History"],
Cell[24376, 675, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

