(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18474,        546]
NotebookOptionsPosition[     14968,        433]
NotebookOutlinePosition[     16651,        481]
CellTagsIndexPosition[     16533,        475]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Expression Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OptionsForExpressionInputAndOutput"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Options for Expression Input and Output\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"InputAliases" :> 
          Documentation`HelpLookup["paclet:ref/InputAliases"], "$PreRead" :> 
          Documentation`HelpLookup["paclet:ref/$PreRead"], "Set" :> 
          Documentation`HelpLookup["paclet:ref/Set"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"InputAliases\"\>", 2->"\<\"$PreRead\"\>", 
       3->"\<\"Set\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Automatic Text Styling Features" :> 
          Documentation`HelpLookup[
           "paclet:guide/AutomaticTextStylingFeatures"], 
          "Defining Custom Notation" :> 
          Documentation`HelpLookup["paclet:guide/DefiningCustomNotation"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Automatic Text Styling Features\"\>", 
       2->"\<\"Defining Custom Notation\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InputAutoReplacements", "ObjectName",
 CellID->32480],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["InputAutoReplacements",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/InputAutoReplacements"]], "InlineFormula"],
     "\[LineSeparator]is an option for cells and notebooks which specifies \
strings of characters that should be replaced immediately on input. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->31604]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default setting of ",
 Cell[BoxData[
  ButtonBox["InputAutoReplacements",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputAutoReplacements"]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  ButtonBox["Input",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Input"]], "InlineFormula"],
 " styles typically includes such rules as ",
 Cell[BoxData[
  RowBox[{"\"\<->\>\"", "->", "\"\<\[Rule]\>\""}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15154],

Cell["\<\
In expression input, automatic replacements can be performed only on strings \
of characters that correspond to complete input tokens. \
\>", "Notes",
 CellID->27322],

Cell["\<\
In textual input, automatic replacements can be performed on strings of \
alphanumeric characters delimited by spaces or other punctuation characters. \
\
\>", "Notes",
 CellID->8778],

Cell[TextData[{
 "When material is copied from a notebook to the clipboard, replacements \
specified by ",
 Cell[BoxData[
  ButtonBox["ExportAutoReplacements",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportAutoReplacements"]], "InlineFormula"],
 " are by default performed. Typically these replacements include ones that \
reverse the action of the replacements in ",
 Cell[BoxData[
  ButtonBox["InputAutoReplacements",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputAutoReplacements"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12747],

Cell[TextData[{
 "When material is pasted from the clipboard into a notebook, replacements \
specified by ",
 Cell[BoxData[
  ButtonBox["ImportAutoReplacements",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportAutoReplacements"]], "InlineFormula"],
 " are by default performed. Typically these replacements are a subset of \
those given in ",
 Cell[BoxData[
  ButtonBox["InputAutoReplacements",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputAutoReplacements"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1703]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->25580405],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->18221503],

Cell[TextData[{
 "Create a notebook that uses ",
 Cell[BoxData["exinei"], "InlineFormula"],
 " as shorthand for ",
 Cell[BoxData[
  ButtonBox["ExpIntegralEi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpIntegralEi"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->297271062],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"InputAutoReplacements", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<exinei\>\"", "\[Rule]", "ExpIntegralEi"}], "}"}]}]}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->166739829],

Cell[TextData[{
 "To use the shorthand, start by typing ",
 Cell[BoxData["exinei"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->291430602],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVtPlEcch7fpfeNX6H0/RNPDraaNN22TKqaitjHGphdNmvTCVG21NvUE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   "], {{0, 0}, {458, 64}}, {0, 255}],
  ImageSize->{458 0.75, 64 0.75},
  PlotRange->{{0, 458}, {0, 64}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->57409990],

Cell["\<\
When you type the bracket, the shorthand is automatically replaced:\
\>", "ExampleText",
 CellID->81002871],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnO1TlFUYxmn63vQv9J80vXzNqfFLNVPiJFqN49j0oZlm+tBkVmaTqeAL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   "], {{0, 0}, {458, 64}}, {0, 255}],
  ImageSize->{458 0.75, 64 0.75},
  PlotRange->{{0, 458}, {0, 64}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->48296694]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13293],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["InputAliases",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputAliases"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$PreRead",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$PreRead"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Set",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Set"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3775]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19499],

Cell[TextData[ButtonBox["Options for Expression Input and Output",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/OptionsForExpressionInputAndOutput"]], "Tutorials",
 CellID->15343]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->164973562],

Cell[TextData[ButtonBox["Automatic Text Styling Features",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AutomaticTextStylingFeatures"]], "MoreAbout",
 CellID->125861645],

Cell[TextData[ButtonBox["Defining Custom Notation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DefiningCustomNotation"]], "MoreAbout",
 CellID->521491987]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InputAutoReplacements - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 48, 51.8211996}", "context" -> "System`", 
    "keywords" -> {
     "glossary", "keyboard shortcuts", "macros", "shortcuts", 
      "keyboard macro"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "InputAutoReplacements is an option for cells and notebooks which \
specifies strings of characters that should be replaced immediately on input. \
", "synonyms" -> {"input auto replacements"}, "title" -> 
    "InputAutoReplacements", "type" -> "Symbol", "uri" -> 
    "ref/InputAutoReplacements"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5911, 188, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->25580405]},
 "Notebook Image"->{
  Cell[7228, 241, 2539, 44, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->57409990],
  Cell[9890, 292, 2718, 47, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->48296694]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16165, 461},
 {"Notebook Image", 16305, 465}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2200, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2823, 81, 59, 1, 70, "ObjectName",
 CellID->32480],
Cell[2885, 84, 532, 14, 70, "Usage",
 CellID->31604]
}, Open  ]],
Cell[CellGroupData[{
Cell[3454, 103, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3932, 120, 477, 16, 70, "Notes",
 CellID->15154],
Cell[4412, 138, 176, 4, 70, "Notes",
 CellID->27322],
Cell[4591, 144, 193, 5, 70, "Notes",
 CellID->8778],
Cell[4787, 151, 556, 15, 70, "Notes",
 CellID->12747],
Cell[5346, 168, 528, 15, 70, "Notes",
 CellID->1703]
}, Closed]],
Cell[CellGroupData[{
Cell[5911, 188, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->25580405],
Cell[CellGroupData[{
Cell[6295, 202, 147, 5, 70, "ExampleSection",
 CellID->18221503],
Cell[6445, 209, 287, 10, 70, "ExampleText",
 CellID->297271062],
Cell[6735, 221, 342, 11, 70, "Input",
 CellID->166739829],
Cell[7080, 234, 145, 5, 70, "ExampleText",
 CellID->291430602],
Cell[7228, 241, 2539, 44, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->57409990],
Cell[9770, 287, 117, 3, 70, "ExampleText",
 CellID->81002871],
Cell[9890, 292, 2718, 47, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->48296694]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12657, 345, 311, 9, 70, "SeeAlsoSection",
 CellID->13293],
Cell[12971, 356, 693, 26, 70, "SeeAlso",
 CellID->3775]
}, Open  ]],
Cell[CellGroupData[{
Cell[13701, 387, 314, 9, 70, "TutorialsSection",
 CellID->19499],
Cell[14018, 398, 187, 4, 70, "Tutorials",
 CellID->15343]
}, Open  ]],
Cell[CellGroupData[{
Cell[14242, 407, 319, 9, 70, "MoreAboutSection",
 CellID->164973562],
Cell[14564, 418, 171, 3, 70, "MoreAbout",
 CellID->125861645],
Cell[14738, 423, 158, 3, 70, "MoreAbout",
 CellID->521491987]
}, Open  ]],
Cell[14911, 429, 27, 0, 70, "History"],
Cell[14941, 431, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

