(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     58225,       2146]
NotebookOptionsPosition[     45731,       1699]
NotebookOutlinePosition[     47058,       1737]
CellTagsIndexPosition[     46972,       1732]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Redrawing and Combining Plots" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RedrawingAndCombiningPlots"], 
          "Forms of Input and Output" :> 
          Documentation`HelpLookup["paclet:tutorial/FormsOfInputAndOutput"], 
          "The Interpretation of Textual Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheInterpretationOfTextualForms"], 
          "The Representation of Textual Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheRepresentationOfTextualForms"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Redrawing and Combining Plots\"\>", 
       2->"\<\"Forms of Input and Output\"\>", 
       3->"\<\"The Interpretation of Textual Forms\"\>", 
       4->"\<\"The Representation of Textual Forms\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"OutputForm" :> 
          Documentation`HelpLookup["paclet:ref/OutputForm"], "FullForm" :> 
          Documentation`HelpLookup["paclet:ref/FullForm"], "StandardForm" :> 
          Documentation`HelpLookup["paclet:ref/StandardForm"], "Compress" :> 
          Documentation`HelpLookup["paclet:ref/Compress"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"OutputForm\"\>", 
       2->"\<\"FullForm\"\>", 3->"\<\"StandardForm\"\>", 
       4->"\<\"Compress\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Converting between Expressions & Strings" :> 
          Documentation`HelpLookup[
           "paclet:guide/ConvertingBetweenExpressionsAndStrings"], 
          "Display of Numbers" :> 
          Documentation`HelpLookup["paclet:guide/DisplayOfNumbers"], 
          "Mathematical Typesetting" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalTypesetting"], 
          "Mathematica Session History" :> 
          Documentation`HelpLookup["paclet:guide/MathematicaSessionHistory"], 
          "Numerical Evaluation & Precision" :> 
          Documentation`HelpLookup[
           "paclet:guide/NumericalEvaluationAndPrecision"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Converting between Expressions & Strings\"\>", 
       2->"\<\"Display of Numbers\"\>", 3->"\<\"Mathematical Typesetting\"\>",
        4->"\<\"Mathematica Session History\"\>", 
       5->"\<\"Numerical Evaluation & Precision\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InputForm", "ObjectName",
 CellID->23704],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InputForm",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InputForm"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]prints as a version of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " suitable for input to ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19822]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " always produces one\[Hyphen]dimensional output, suitable to be typed as \
lines of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input. "
}], "Notes",
 CellID->7054],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " acts as a \"wrapper\", which affects display, but not evaluation. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->45936541]
}], "Notes",
 CellID->16313],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Put",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Put"]], "InlineFormula"],
 " (",
 Cell[BoxData[">>"], "InlineFormula"],
 ") produces ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " by default. "
}], "Notes",
 CellID->5701],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Short",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Short"], "[", 
   RowBox[{"InputForm", "[", 
    StyleBox["expr", "TI"], "]"}], "]"}]], "InlineFormula"],
 " can be used, but may generate skeleton objects which cannot be given as ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input."
}], "Notes",
 CellID->15722],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["NumberMarks",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberMarks"]], "InlineFormula"],
 " can be used to specify whether ",
 Cell[BoxData["`"], "InlineFormula"],
 " marks should be used to indicate type, precision or accuracy of \
approximate numbers. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->48588574]
}], "Notes",
 CellID->11209]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->191833490],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->553409153],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " of a typeset expression:"
}], "ExampleText",
 CellID->134753518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", 
  RowBox[{
   FractionBox["x", 
    SqrtBox["5"]], "+", 
   SuperscriptBox["y", "2"], "+", 
   RowBox[{"1", "/", "z"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->330426462],

Cell["x/Sqrt[5] + y^2 + z^(-1)", "Output",
 ImageSize->{168, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//InputForm=",
 CellID->108512946]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->432002570],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " of a graphic:"
}], "ExampleText",
 CellID->241319587],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  GraphicsBox[{
    {RGBColor[1, 0, 0], DiskBox[{0, 0}]}, 
    {RGBColor[0, 0, 1], 
     RectangleBox[NCache[{Rational[1, 2], Rational[1, 2]}, {0.5, 0.5}], 
      NCache[{Rational[1, 2], Rational[1, 2]}, {0.5, 0.5}]]}}], "//", 
  "InputForm"}]], "Input",
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"In[1]:=",
 CellID->519156385],

Cell["\<\
Graphics[{{RGBColor[1, 0, 0], Disk[{0, 0}]}, 
  {RGBColor[0, 0, 1], Rectangle[{1/2, 1/2}]}}]\
\>", "Output",
 ImageSize->{322, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//InputForm=",
 CellID->120893746]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->267107478],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Basic Objects",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->192468641],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Integer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integer"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Rational",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rational"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Complex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complex"]], "InlineFormula"],
 " numbers: "
}], "ExampleText",
 CellID->17800827],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"InputForm", ",", 
   RowBox[{"{", 
    RowBox[{"123", ",", 
     RowBox[{"1", "/", "23"}], ",", "1.23", ",", 
     RowBox[{"1", "+", 
      RowBox[{"23", "\[ImaginaryI]"}]}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->540624369],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1VtFOwjAU7XY3FUQxRsJ44wETv8MYffIjFmICD0YC/N0+brTj1iyH29zO
RpK1O6f3nrWndx2f9XHz9V0ft+t6+bGvd5vt+rB8/9lbijJjTGOvaWXsfWvv
uqtpW9sXriWHu5+ZA34BvAL8Cpg6VQK2sk1u4SPwT8w/c/8G47mo5tjSQt+7
cTdcQtwVjyNfRuYRz6qIjB8DfwN594zRc3mVYlT5i7scE2ALnvlImOnFMxI1
+y6lakkOxmr2d8Xh6xg/zy3UxkU99zCq3ikOo56Wjw5o8b7G0Elt9do8szam
JjVVzR0NY/7twHh0EzHm+xNFfE8Gv7FSLbmqfwAe9wqfHsqbRMbhqtFFn6fN
428uaCq4ZzgLrZIxH7EWvxgY//+n91RxgBK0Rgm5s4Rc2TWJzfksJ/5OEKs5
HiuZAnGTAF8B77/IuHvnfzFNoDXZCcQ2+mw=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{187, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->262674323]
}, Open  ]],

Cell[TextData[{
 "Arbitrary\[Hyphen]precision ",
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Complex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complex"]], "InlineFormula"],
 " numbers:"
}], "ExampleText",
 CellID->311286961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "/@", 
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"10", "/", "3"}], ",", 
      RowBox[{
       RowBox[{"10", "/", "3"}], "\[ImaginaryI]"}]}], "}"}], ",", "20"}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28481542],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox["3.33333333333333333333333333333333333333`20.",
     ShowStringCharacters->True,
     NumberMarks->True],
    InputForm[3.33333333333333333333`20.],
    AutoDelete->True,
    Editable->True], ",", 
   InterpretationBox[
    StyleBox[
     RowBox[{"3.33333333333333333333333333333333333333`20.", "*", "I"}],
     ShowStringCharacters->True,
     NumberMarks->True],
    InputForm[
     Complex[0, 3.33333333333333333333`20.]],
    AutoDelete->True,
    Editable->True]}], "}"}]], "Output",
 ImageSize->{345, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->645842579]
}, Open  ]],

Cell["Special constants:", "ExampleText",
 CellID->31597588],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "/@", 
  RowBox[{"{", 
   RowBox[{"\[ImaginaryI]", ",", "\[Pi]", ",", "\[ExponentialE]"}], 
   "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->70178760],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytU0sOgjAQHdoCagRiYtQlV2GjKw/REBNYGA1y/zotjZ9hEGIg6bTvTfvm
03LWbXW56rYudX5q9L2qy0d+vDVIyQAAChzZAXBtcOVGYQzOylppsftgSfCO
4Ixg6VQkYVdoBMK9nzfEL9hTlg2hn1OERnqe84doIobno9Bdyue4YFS5fbFz
vngXYyi2GNFMR/wJwTHBwaQKU9+/X+q2huiv/rka1Bv3e5H4+HPpC6/3+Rbn
zH9rpt+w+j5tuhdqK1ZMx9eme6k0p+4vKgYsBE9HqvuZ\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->42449552]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->110191034],

Cell["Characters and strings of characters:", "ExampleText",
 CellID->186250952],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "/@", 
  RowBox[{"{", 
   RowBox[{
   "\"\<a\>\"", ",", "\"\<\[Alpha]\>\"", ",", "\"\<\[CirclePlus]\>\""}], 
   "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->48683404],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytU9sOgjAMLQyiTMBHiUbla/TJj1jARB6MBvn/2Y0FtRuCxCVrd06vdOMk
msv5KpqqEPmxFvdLVTzyw61GinkAUOJeZoBniSe9SylRB0oyhfWCFcHbAcx0
FkbYDIWPcGf0nth9ZxRHESLkhE9MFp/wEcEpCgXjUdV0dNhh7QOwMLUSmsPk
VTp9i+ykjrSr0p65s+rayW6UDl6xwxPweucafK0yc0z9l6lN7X8+qqZv5VGv
Vjkwy5JaDDO+EHbXZfqj3cTOWPum7X7Cid/BR/Q/xqd/Hu7Ogk8/2b5r8zPr
FTm45M9+dD6tqeyR4D0BHXFjcg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->82539970]
}, Open  ]],

Cell["Control characters for strings:", "ExampleText",
 CellID->614169666],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "\"\<A first line\nA second line\>\"", 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->49753538],

Cell["\"A first line\\nA second line\"", "Output",
 ImageSize->{203, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->3185040]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Special Input Forms",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->155030223],

Cell[TextData[{
 "Different ways of representing ",
 Cell[BoxData[
  ButtonBox["Power",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Power"]], "InlineFormula"],
 " expressions:"
}], "ExampleText",
 CellID->822419852],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "^", "x"}], ",", 
    SuperscriptBox["a", "x"], ",", 
    RadicalBox["a", "3"], ",", 
    RowBox[{"Exp", "[", "x", "]"}], ",", 
    RowBox[{"1", "/", "x"}], ",", 
    FractionBox["1", "x"]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25296522],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1V8tugzAQNJhXaQjJrY16IPmY9tSPQFGl5BC1SvP/1CY2ReOFtVEbices
d8fjXRs77+3t9HFpb+dj27xd26/T+fjdvH5elUlGQkR7IUT9JNR7p976S/8O
6hIi0XdpbZ14BtwAfmH808D4mokP9Zf9qCRYd+oWK7g3T2R9BFwBTpj47YQ/
54fqY1K9xqmCD4Y1Nk+sXW78Sk8/HGVs7KgqUzdJ2JFX+2Ue/WfQjjpKowPj
EKfAs17IQ2e9t6YD7n3EfaYkv15iUJGT/qtAfxwDlTun3WGhRqz7LALHVDgt
qG/F6LU95w4TrmQfJrdqMVjlZBVi26fTWs22hlakoHSOMPKtTe/bsQqPVYk6
LM9mYTy2R93UtygZZXRjcAX4P7NmqzKXNW42TWVr2Sz0+3bQc7O3umuMXtN/
HM3NiRyw/S5gnO5z2CE8NNaOxU8fV53K4aUVhfL6VV127j5px4/7lG7OFvqR
e8BM1RBza4vTVXXT+zulj8vuCvgwf6F8ftVClobBqAL5MMszqx3Ps+z85LTg
+RV7wVN6aDx9TsU8IwuXUTgTdPfql4QWOZG5zCNXWBd7ikb1u4Vx9D8Q/Xrw
eBPRDz0ZK8w=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{289, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->652983421]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->468650050],

Cell["Special typeset expressions:", "ExampleText",
 CellID->215577449],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"y", "'"}], "[", "x", "]"}], ",", 
    RowBox[{"\[Integral]", 
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], 
      RowBox[{"\[DifferentialD]", "x"}]}]}], ",", 
    RowBox[{
     SubsuperscriptBox["\[Sum]", 
      RowBox[{"k", "=", "1"}], "n"], 
     RowBox[{"y", "[", "k", "]"}]}], ",", 
    RowBox[{
     SubsuperscriptBox["\[Product]", 
      RowBox[{"k", "=", "1"}], "n"], 
     RowBox[{"y", "[", "k", "]"}]}], ",", 
    RowBox[{"x", "\[Element]", "Reals"}], ",", 
    RowBox[{
     RowBox[{"x", "\[And]", "y"}], "\[Or]", "z"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->177296101],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWl9v1DAM767t3e3G2G0DwTb+bAIJ9oJ4Bp5BIPEhThPS9oBAY18Nvl5p
2vjq/mrHye2OcdLaJnEc27Ed29nXxc3lt++Lm6uLxemn68XPy6uLX6cff1zX
XflWlm39zrLs7HFWf1f1V/Pnfn/qv/az/XpfP0f1YF6/i/pd+vaOf7t2ltPs
KtuF9ja0D4x2oeB9x9bl/W8U+HvQPvX05wZcAe05tJ8upRKahW2kOvdUo7Rm
vv/Qvx8YeAkP0kN43irwyPULAS5EP9KxD+0njZSm9dN1OujSy563R56adrn2
N/IwJYM1JV0s24Sx6DDaOHZWwLHtecB+4rk/G+VpUeS4H3tpkOQKkBRJsOkv
+WqEjMt7yB9JX+NgQLPvK4GOnNGBVihJTadkCvrgnqgjSyyBVWbG+FTZu1Zr
LewNISXngfRW6WVzRyqkjFXSG8nbjfpyVXZCsnx5pgRJGGYipTF26mZPomaj
3Ao2a/kMQqVKVpeDzG/c2iJfUbJbrhykcTroyQc92kkdYyU2rRuyGVPeyA22
+f5mmsWw8TGM44mG+PBknotUh6hyn3j+IxVrtwNDYk5PmohsqFPJum7xgpEV
rb+t8zjo5XonydvScdRbpPmkIu2WYpE70ure3kgeJhf0GeNsgovTY8u7cz2W
rIniGHkXpdFu7RS95TEKxUzSrlGEGaOPlg7NzD2JwhAYZz52YJfLCO4Wscdq
co87y+zIRNLM/oxDgJhXXdxoekvQUsk2bKnIfqgPq8t3YnK4n7AvCXI3oVDn
h5RZJzv31vo6UbFGUEs0G5BySJ73DPIJNoc8BPmfYZ5kZ3IYR0gZlajhMAdh
9gS+rOzK8sIkF/L9XC58TJKnLB8uTfnk4HsheV3NS8+Da21XXUxLmaO9V2vI
C3u6h2fnHrSRV6yioL+KObN5G9c/MvjbFXcIoZ4bXDwSsSCtyCvG0+cGfHyF
qfA74fTgqOpyV64vE/9+iBL1fe59LFDg+u9XbS2GTttz/3ZyKD3nfE3clVfQ
Xq3i6D6xNpv+hWt9rvrV3HHV94wF9Gu55Muqtb8zmG9Viw+U/meJeFKrzhhR
aHWV1gmiH/kCbUt3U9tatfi1IKV14EWNpf7na8JvVbnRKrUqd9HtRu9kIA3h
Z3nvTAdcvBYdgpPOJQ1+pXZ0TVbKrZs6bLDuSzxgnIMy0HhdL83TRPgxW63l
D+M595tkSn3CpPvu7gionnC7O4ImGoioY1p5nFU5C9RPzZxRxBWIeFaxIslv
p2ehhAlPjkBuPIFePzaOl0wS3mkk7/G8DisXGiTFT0PcUubb0Ry7X//y/mJH
lHysprWuByPxQCVwM5aXimWNNmdV1rXTG9fFbCmuChVXi06wtgBuKX8Oca5x
uh/oF3z1lPfwZ+pOrPuOQ65SWXccjUeVzynRYigyCem4rivS/3jEzV5XZGfX
6DdvIfHV9EKRWa/mk8TdnVjBRu9EZL23djVV7+W9kiS2+Sp+/D11csSajNWO
DSQ70avxpc4xx8Hkf5szZjUZ2DzPTQhXt8ozLYqIi9fu7o6HvEXqHU+K1fH8
V/s/NILp52p8tIyGtiIlO28d4hbjoegcfU+Elmr/gzuVjgplVi7MLmM5SuIg
NI61pxzgW+dKv6rT3v/kHojuOlPugQI20LM5rExLFfCUtlUHxXH023g/cwpt
zOgQH7bxPgR1QZL3pu9oLBm3ezeQdDaMSpA7qqXzHFuq3WPb7YKz0Q9V/x6D
xo+r7n4Pb1P3YU7KfcuJIIllft50xtxoZFt/Ab9S4io=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{437, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28969025]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->771593175],

Cell["Different list structures:", "ExampleText",
 CellID->34531473],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->287661578],

Cell["{1, 2, 3}", "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//InputForm=",
 CellID->646304302]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"(", GridBox[{
       {"a", "b", "c"},
       {"d", "e", "f"}
      }], ")"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "e", ",", "f"}], "}"}]}], "}"}]}], "}"}]}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->250695724],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVV81OwzAMdpt2sAIDNhBIcNgBBE8CJyT2CNWEtB0QaOz9Q9w2qHLdOUmL
1lVqG7v++WzHTfKWb1cfn/l2vcznr5v8e7Ve/sxfvjaGpSKA6B0Azm/BjLUZ
FTdeC3MDJPhUlqdFekzoqUBT/bOe7VH6ZGD4Z574VVEV5amVmUdsyFn1vmKs
Ip+il/Q4dCgnZbkvPNeeeYiDsofyKTT1jit+yqBUDF+ai21+0F4CzV4cV/Jd
e/RQ4s0C4w2reqGV/tGFjdI3zrws8Cv1iNKn/p5r0iPN95xUjTZ7h54HasUl
D83ZEntqKRbrRTu3pntEaPp9h+0dK8lIQDwZfER0VZAionSkQ/oe5RPnSCkm
ur7zcxitIPOSSEtzlXrfJ3YqHdZn/fyVERP2Pu3aCStNbbJx1+nWjPZdv2FF
t58Ko7yyuU1KPoDFw+0LKE67e6w2y2Azb6267CFcOu3/UE4dUfaT8RtC3wnI
6X/jgdBdu6ArnkdPPHwWfXOPZxGs5z3hc2cmlHvSZa2lakknTl+/z45++ZMn
DhcOI4h+AXp30Sc=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{336, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->42425829]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->558045366],

Cell["Input without special interpretation:", "ExampleText",
 CellID->250099490],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "/@", 
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["x", "a"], ",", 
    OverscriptBox["x", "a"], ",", 
    UnderscriptBox["x", "a"]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->246234492],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlWL1OwzAQvsROI1q10MLAgpQNNgSMSIgFOvEQUYXUDghUSl8/2O5ZTc+X
xnEzpGApsX2+v+/OVnx5y1fz9498tZjl2XSZf80Xs+/s9XOpSCICiH4A4PQS
1LhQI/PotlYPgNRvYWkF3KmXno5UH6t+QNYnSE8I/SlQ7iVQThjvBaE+kPmQ
zPuo7YLRpunPB8pPA+VpFmIWnaHKzRxMk6gPw2FaglOJ6wLnmh6XeolRFchn
NW9ajFwxuHukj1qof5QvRe1c7iTjTTe8jbHfMNhGfemW79X7xWov2SzZMytJ
2RtoSKU2aa73SNXqcv1O0O8+K0+jYk9HWmvNBwnv81+LSuMd8U8i5p42ij51
rAieQjXvcKThcajJhMY78cI7rLXhY9ONR3extbnru4mbSkeGj9roOb5X7OGd
L5jw8LZdzOfF9qt7SHarvq3Hi+hYcfrdaETZZxYpf9/x2cVassd4UX1Poufa
tTtm5drPsY2uDJDpGuaQG+vx4W9Q8TGniIsTgLUjYVsBWs5yhWgrHMGs2fpl
f50yLvjKzmS1R7AXVfXUPh+6h4FaobW3zVc3UYXtN63xhNBuyJxayrh4Oufh
sRUt9P/KfUOtfFQ4Ks10irQrwmv/V2XYn2E+bmv4RgV3Sga4el0jzf8d08O1
xwiiXypQNzA=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{373, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->262958251]
}, Open  ]],

Cell["\<\
With special characters in the same positions there may be special \
interpretations:\
\>", "ExampleText",
 CellID->208413776],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "/@", 
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["x", "-"], ",", 
    OverscriptBox["x", "_"], ",", 
    UnderscriptBox["x", "_"]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->447735933],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNV81OwzAMdpu0BU3bEByAW5+DcYEDnHiIakLaDgg09v6lCXHnuc7SdGMl
0rrEsb9+/ml+3qrt6v2j2q6XVfm6qb5W6+V3+fK5aUQqAUgyAJjfQdOvm579
mZY3PwBtngplNSyaR9oMJ+4/Y/MPgfmnwLyyb1VM+sjGE8HKoC166j0H9LjX
qcjKSvXvGGzTDt+5YZsJr9FUgO5iM/1MlCpnkyJoO6VRXbc8nB7qc+58XDgu
UuS1w8mYD8rh+uTHs2kjtPOWcElH4ebPOqIQbIKbYmLbt4JXKr5TtqVacXh7
LHnesWYLEY96z8fWgI1VhO8hrGO5x+SBR3h8v7qVyDkWHRzVV8Kx+1VgR5oH
sHC95XrTYNzOXWtxTP9rZfm84HqJxeNo1qpP9VxQCX1GrGaib7596RSZyYT4
ybHHnXDcmjkf3377HubHX6/trhRVH/JeOnDdOriqHp8XjKCmEfdqiavjQIZD
Thx/zTbilCxUoeQVAGVET3N4PvTNUUT8HuJOfzb2OYtO7TuVHuLiX9ski9Ow
lFCpDDMxFu9htWKQLgUkzqVkOvw+J39Xt6L0ehDWlGnNBmHLUfKtmjS3Rb27
T3crlsf5vt6/hV85KxMRQ/qGzc9EVJyde6zku73p5j16kPwA/k1ABA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{261, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->412936297]
}, Open  ]],

Cell[TextData[{
 "In the case of superscripts, most things get interpreted as ",
 Cell[BoxData[
  ButtonBox["Power",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Power"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->197260386],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "/@", 
  RowBox[{"{", 
   RowBox[{
    SuperscriptBox["x", "a"], ",", 
    SubsuperscriptBox["x", "b", "a"], ",", 
    SuperscriptBox["x", "\[Dagger]"]}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->48008657],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{"x", "^", "a"}],
     ShowStringCharacters->True,
     NumberMarks->True],
    InputForm[$CellContext`x^$CellContext`a],
    AutoDelete->True,
    Editable->True], ",", 
   InterpretationBox[
    StyleBox[
     RowBox[{
      RowBox[{"Subscript", "[", 
       RowBox[{"x", ",", " ", "b"}], "]"}], "^", "a"}],
     ShowStringCharacters->True,
     NumberMarks->True],
    InputForm[Subscript[$CellContext`x, $CellContext`b]^$CellContext`a],
    AutoDelete->True,
    Editable->True], ",", 
   InterpretationBox[
    StyleBox[
     RowBox[{"SuperDagger", "[", "x", "]"}],
     ShowStringCharacters->True,
     NumberMarks->True],
    InputForm[
     SuperDagger[$CellContext`x]],
    AutoDelete->True,
    Editable->True]}], "}"}]], "Output",
 ImageSize->{285, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->710428704]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Special Output Forms",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->88001466],

Cell["Some objects use a special output representation:", "ExampleText",
 CellID->2037784],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->270064825],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "-", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, 1, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[-1, 6]}, 1, 4, 1],
  Editable->False]], "Output",
 ImageSize->{87, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2895976]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25363306],

Cell["SeriesData[x, 0, {1, 0, -1/6}, 1, 4, 1]", "Output",
 ImageSize->{273, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->60690025]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->82792717],

Cell["Some objects use an elided output representation:", "ExampleText",
 CellID->22244903],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"i", "=", 
  RowBox[{"Interpolation", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "1"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->151992235],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "4"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{244, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->392323807]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->298336904],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "1", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 1, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->122139198]
}, Open  ]],

Cell[TextData[{
 "The elided parts are visible using ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->186619138],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "i", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->400554568],

Cell["\<\
InterpolatingFunction[{{1, 4}}, {3, 1, 0, {4}, {4}, 0, 0, 0, 0}, 
 {{1, 2, 3, 4}}, {{1}, {2}, {3}, {1}}, {Automatic}]\
\>", "Output",
 ImageSize->{455, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//InputForm=",
 CellID->181620364]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "s", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->352112550],

Cell["\<\
SparseArray[Automatic, {5, 5}, 0, {1, {{0, 1, 1, 1, 1, 1}, {{2}}}, {1}}]\
\>", "Output",
 ImageSize->{504, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//InputForm=",
 CellID->481582292]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26526],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "NumberMarks",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->48588574],

Cell["Machine numbers format without number marks by default:", "ExampleText",
 CellID->790786255],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", 
  RowBox[{"N", "[", 
   RowBox[{"1", "/", "3"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->315109163],

Cell["0.3333333333333333", "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//InputForm=",
 CellID->298032835]
}, Open  ]],

Cell["The same number with number marks:", "ExampleText",
 CellID->195094700],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{"1", "/", "3"}], "]"}], ",", 
   RowBox[{"NumberMarks", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17858563],

Cell["0.3333333333333333`", "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->606928814]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->511386803],

Cell["Extended precision numbers include number marks by default:", \
"ExampleText",
 CellID->240263990],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", 
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"10", "/", "3"}], ",", "20"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->299941724],

Cell["3.33333333333333333333333333333333333333`20.", "Output",
 ImageSize->{308, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//InputForm=",
 CellID->125347552]
}, Open  ]],

Cell["Without number marks:", "ExampleText",
 CellID->208766706],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"10", "/", "3"}], ",", "20"}], "]"}], ",", 
   RowBox[{"NumberMarks", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->141694954],

Cell["3.33333333333333333333", "Output",
 ImageSize->{154, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->533727562]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->392681879],

Cell["A mixed symbolic and numeric expression:", "ExampleText",
 CellID->381026200],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr", "=", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{"10", ",", "4"}], "]"}], 
   RowBox[{"Sin", "[", 
    RowBox[{".25", "x"}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32636895],

Cell[BoxData[
 RowBox[{"10.`3.9999999999999996", " ", 
  RowBox[{"Sin", "[", 
   RowBox[{"0.25`", " ", "x"}], "]"}]}]], "Output",
 ImageSize->{115, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4629937]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "expr", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->114743573],

Cell["10.`3.9999999999999996*Sin[0.25*x]", "Output",
 ImageSize->{238, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->68577397]
}, Open  ]],

Cell["Include number marks for all numbers:", "ExampleText",
 CellID->651747076],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", 
  RowBox[{"expr", ",", 
   RowBox[{"NumberMarks", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->74346236],

Cell["10.`3.9999999999999996*Sin[0.25`*x]", "Output",
 ImageSize->{245, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//InputForm=",
 CellID->701383420]
}, Open  ]],

Cell["Omit all number marks:", "ExampleText",
 CellID->714319281],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", 
  RowBox[{"expr", ",", 
   RowBox[{"NumberMarks", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->463527511],

Cell["10.*Sin[0.25*x]", "Output",
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//InputForm=",
 CellID->184476364]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->361089022],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " affects display but not evaluation:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->45936541],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"x", "^", "n"}], ",", "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->145860351],

Cell["x^(1 + n)/(1 + n)", "Output",
 ImageSize->{119, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//InputForm=",
 CellID->21605399]
}, Open  ]],

Cell[TextData[{
 "Apply ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " to the evaluated integral:"
}], "ExampleText",
 CellID->306237246],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"x", "^", "n"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->167840055],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["x", 
   RowBox[{"1", "+", "n"}]], 
  RowBox[{"1", "+", "n"}]]], "Output",
 ImageSize->{35, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->24620390]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->46625405],

Cell["x^(1 + n)/(1 + n)", "Output",
 ImageSize->{119, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//InputForm=",
 CellID->186250410]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3670004],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " has a linear formatting: "
}], "ExampleText",
 CellID->100794910],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", 
  RowBox[{"Exp", "[", 
   RowBox[{"I", " ", 
    RowBox[{"x", "/", "n"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->210440999],

Cell["E^((I*x)/n)", "Output",
 ImageSize->{77, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//InputForm=",
 CellID->140309891]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " has linear formatting without special syntax:"
}], "ExampleText",
 CellID->28357278],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"Exp", "[", 
   RowBox[{"I", " ", 
    RowBox[{"x", "/", "n"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->106470571],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Power", "[", 
    RowBox[{"E", ",", 
     RowBox[{"Times", "[", 
      RowBox[{
       RowBox[{"Complex", "[", 
        RowBox[{"0", ",", "1"}], "]"}], ",", 
       RowBox[{"Power", "[", 
        RowBox[{"n", ",", 
         RowBox[{"-", "1"}]}], "]"}], ",", "x"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{320, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->585015692]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OutputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " all provide two\[Hyphen]dimensional formatting:"
}], "ExampleText",
 CellID->457767460],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OutputForm", "[", 
  RowBox[{"Exp", "[", 
   RowBox[{"I", " ", 
    RowBox[{"x", "/", "n"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->37175165],

Cell[OutputFormData["\<\
E^((I*x)/n)\
\>", "\<\
 (I x)/n
E\
\>"], "Output",
 ImageSize->{63, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//OutputForm=",
 CellID->663062555]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardForm", "[", 
  RowBox[{"Exp", "[", 
   RowBox[{"I", " ", 
    RowBox[{"x", "/", "n"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->52050003],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "x"}], "n"]]], "Output",
 ImageSize->{27, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//StandardForm=",
 CellID->2620225]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TraditionalForm", "[", 
  RowBox[{"Exp", "[", 
   RowBox[{"I", " ", 
    RowBox[{"x", "/", "n"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->16589577],

Cell[BoxData[
 FormBox[
  SuperscriptBox["\[ExponentialE]", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", "x"}], "n"]], TraditionalForm]], "Output",
 ImageSize->{23, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//TraditionalForm=",
 CellID->478373485]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->173810528],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ToString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToString"]], "InlineFormula"],
 " to generate a string in input form:"
}], "ExampleText",
 CellID->280553715],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToString", "[", 
  RowBox[{
   RowBox[{
    FractionBox["1", "a"], "+", 
    SuperscriptBox["x", "2"]}], ",", "InputForm"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->367460198],

Cell[BoxData["\<\"a^(-1) + x^2\"\>"], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->96667538]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->106513457],

Cell[BoxData["String"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->385925556]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2383],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["OutputForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OutputForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FullForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FullForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StandardForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StandardForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Compress",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Compress"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29957]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18610],

Cell[TextData[ButtonBox["Redrawing and Combining Plots",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RedrawingAndCombiningPlots"]], "Tutorials",
 CellID->16279],

Cell[TextData[ButtonBox["Forms of Input and Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormsOfInputAndOutput"]], "Tutorials",
 CellID->24009],

Cell[TextData[ButtonBox["The Interpretation of Textual Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheInterpretationOfTextualForms"]], "Tutorials",\

 CellID->27366],

Cell[TextData[ButtonBox["The Representation of Textual Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheRepresentationOfTextualForms"]], "Tutorials",\

 CellID->157498705]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->404749669],

Cell[TextData[ButtonBox["Converting between Expressions & Strings",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ConvertingBetweenExpressionsAndStrings"]], "MoreAbout",
 CellID->134317535],

Cell[TextData[ButtonBox["Display of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DisplayOfNumbers"]], "MoreAbout",
 CellID->492180383],

Cell[TextData[ButtonBox["Mathematical Typesetting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalTypesetting"]], "MoreAbout",
 CellID->242831457],

Cell[TextData[ButtonBox["Mathematica Session History",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSessionHistory"]], "MoreAbout",
 CellID->356652502],

Cell[TextData[ButtonBox["Numerical Evaluation & Precision",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalEvaluationAndPrecision"]], "MoreAbout",
 CellID->251455020]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
InputForm"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InputForm - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 48, 53.0087300}", "context" -> "System`", 
    "keywords" -> {
     "1D format", "ascii input syntax", "linear formatting", "linear input", 
      "unicode input syntax"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "InputForm[expr] prints as a version of expr suitable for input to \
Mathematica. ", "synonyms" -> {"input form"}, "title" -> "InputForm", "type" -> 
    "Symbol", "uri" -> "ref/InputForm"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7112, 223, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->191833490]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 46829, 1725}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3424, 75, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4047, 102, 47, 1, 70, "ObjectName",
 CellID->23704],
Cell[4097, 105, 638, 21, 70, "Usage",
 CellID->19822]
}, Open  ]],
Cell[CellGroupData[{
Cell[4772, 131, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5250, 148, 314, 11, 70, "Notes",
 CellID->7054],
Cell[5567, 161, 322, 10, 70, "Notes",
 CellID->16313],
Cell[5892, 173, 352, 14, 70, "Notes",
 CellID->5701],
Cell[6247, 189, 387, 13, 70, "Notes",
 CellID->15722],
Cell[6637, 204, 438, 14, 70, "Notes",
 CellID->11209]
}, Closed]],
Cell[CellGroupData[{
Cell[7112, 223, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->191833490],
Cell[CellGroupData[{
Cell[7497, 237, 148, 5, 70, "ExampleSection",
 CellID->553409153],
Cell[7648, 244, 204, 7, 70, "ExampleText",
 CellID->134753518],
Cell[CellGroupData[{
Cell[7877, 255, 223, 8, 46, "Input",
 CellID->330426462],
Cell[8103, 265, 184, 5, 50, "Output",
 CellID->108512946]
}, Open  ]],
Cell[8302, 273, 125, 3, 70, "ExampleDelimiter",
 CellID->432002570],
Cell[8430, 278, 193, 7, 70, "ExampleText",
 CellID->241319587],
Cell[CellGroupData[{
Cell[8648, 289, 373, 10, 70, "Input",
 CellID->519156385],
Cell[9024, 301, 260, 8, 66, "Output",
 CellID->120893746]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9333, 315, 220, 7, 70, "ExampleSection",
 CellID->267107478],
Cell[CellGroupData[{
Cell[9578, 326, 234, 7, 70, "ExampleSubsection",
 CellID->192468641],
Cell[9815, 335, 555, 22, 70, "ExampleText",
 CellID->17800827],
Cell[CellGroupData[{
Cell[10395, 361, 292, 9, 70, "Input",
 CellID->540624369],
Cell[10690, 372, 675, 15, 70, "Output",
 Evaluatable->False,
 CellID->262674323]
}, Open  ]],
Cell[11380, 390, 338, 13, 70, "ExampleText",
 CellID->311286961],
Cell[CellGroupData[{
Cell[11743, 407, 299, 11, 70, "Input",
 CellID->28481542],
Cell[12045, 420, 694, 23, 54, "Output",
 CellID->645842579]
}, Open  ]],
Cell[12754, 446, 60, 1, 70, "ExampleText",
 CellID->31597588],
Cell[CellGroupData[{
Cell[12839, 451, 191, 6, 70, "Input",
 CellID->70178760],
Cell[13033, 459, 498, 12, 70, "Output",
 Evaluatable->False,
 CellID->42449552]
}, Open  ]],
Cell[13546, 474, 125, 3, 70, "ExampleDelimiter",
 CellID->110191034],
Cell[13674, 479, 80, 1, 70, "ExampleText",
 CellID->186250952],
Cell[CellGroupData[{
Cell[13779, 484, 208, 7, 70, "Input",
 CellID->48683404],
Cell[13990, 493, 544, 13, 70, "Output",
 Evaluatable->False,
 CellID->82539970]
}, Open  ]],
Cell[14549, 509, 74, 1, 70, "ExampleText",
 CellID->614169666],
Cell[CellGroupData[{
Cell[14648, 514, 141, 4, 70, "Input",
 CellID->49753538],
Cell[14792, 520, 190, 5, 50, "Output",
 CellID->3185040]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15031, 531, 240, 7, 70, "ExampleSubsection",
 CellID->155030223],
Cell[15274, 540, 220, 8, 70, "ExampleText",
 CellID->822419852],
Cell[CellGroupData[{
Cell[15519, 552, 340, 11, 70, "Input",
 CellID->25296522],
Cell[15862, 565, 834, 18, 70, "Output",
 Evaluatable->False,
 CellID->652983421]
}, Open  ]],
Cell[16711, 586, 125, 3, 70, "ExampleDelimiter",
 CellID->468650050],
Cell[16839, 591, 71, 1, 70, "ExampleText",
 CellID->215577449],
Cell[CellGroupData[{
Cell[16935, 596, 697, 22, 70, "Input",
 CellID->177296101],
Cell[17635, 620, 2024, 37, 70, "Output",
 Evaluatable->False,
 CellID->28969025]
}, Open  ]],
Cell[19674, 660, 125, 3, 70, "ExampleDelimiter",
 CellID->771593175],
Cell[19802, 665, 68, 1, 70, "ExampleText",
 CellID->34531473],
Cell[CellGroupData[{
Cell[19895, 670, 162, 5, 70, "Input",
 CellID->287661578],
Cell[20060, 677, 168, 5, 50, "Output",
 CellID->646304302]
}, Open  ]],
Cell[CellGroupData[{
Cell[20265, 687, 418, 16, 70, "Input",
 CellID->250695724],
Cell[20686, 705, 776, 17, 70, "Output",
 Evaluatable->False,
 CellID->42425829]
}, Open  ]],
Cell[21477, 725, 125, 3, 70, "ExampleDelimiter",
 CellID->558045366],
Cell[21605, 730, 80, 1, 70, "ExampleText",
 CellID->250099490],
Cell[CellGroupData[{
Cell[21710, 735, 233, 8, 70, "Input",
 CellID->246234492],
Cell[21946, 745, 895, 19, 70, "Output",
 Evaluatable->False,
 CellID->262958251]
}, Open  ]],
Cell[22856, 767, 136, 4, 70, "ExampleText",
 CellID->208413776],
Cell[CellGroupData[{
Cell[23017, 775, 233, 8, 70, "Input",
 CellID->447735933],
Cell[23253, 785, 878, 18, 70, "Output",
 Evaluatable->False,
 CellID->412936297]
}, Open  ]],
Cell[24146, 806, 238, 8, 70, "ExampleText",
 CellID->197260386],
Cell[CellGroupData[{
Cell[24409, 818, 251, 8, 70, "Input",
 CellID->48008657],
Cell[24663, 828, 960, 34, 36, "Output",
 CellID->710428704]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25672, 868, 240, 7, 70, "ExampleSubsection",
 CellID->88001466],
Cell[25915, 877, 90, 1, 70, "ExampleText",
 CellID->2037784],
Cell[CellGroupData[{
Cell[26030, 882, 215, 7, 70, "Input",
 CellID->270064825],
Cell[26248, 891, 498, 17, 54, "Output",
 CellID->2895976]
}, Open  ]],
Cell[CellGroupData[{
Cell[26783, 913, 104, 3, 70, "Input",
 CellID->25363306],
Cell[26890, 918, 198, 5, 50, "Output",
 CellID->60690025]
}, Open  ]],
Cell[27103, 926, 124, 3, 70, "ExampleDelimiter",
 CellID->82792717],
Cell[27230, 931, 91, 1, 70, "ExampleText",
 CellID->22244903],
Cell[CellGroupData[{
Cell[27346, 936, 201, 6, 70, "Input",
 CellID->151992235],
Cell[27550, 944, 356, 13, 36, "Output",
 CellID->392323807]
}, Open  ]],
Cell[CellGroupData[{
Cell[27943, 962, 317, 11, 70, "Input",
 CellID->298336904],
Cell[28263, 975, 479, 17, 36, "Output",
 CellID->122139198]
}, Open  ]],
Cell[28757, 995, 221, 8, 70, "ExampleText",
 CellID->186619138],
Cell[CellGroupData[{
Cell[29003, 1007, 105, 3, 70, "Input",
 CellID->400554568],
Cell[29111, 1012, 285, 8, 66, "Output",
 CellID->181620364]
}, Open  ]],
Cell[CellGroupData[{
Cell[29433, 1025, 105, 3, 70, "Input",
 CellID->352112550],
Cell[29541, 1030, 240, 7, 50, "Output",
 CellID->481582292]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[29842, 1044, 218, 7, 70, "ExampleSection",
 CellID->26526],
Cell[CellGroupData[{
Cell[30085, 1055, 279, 8, 70, "ExampleSubsection",
 CellID->48588574],
Cell[30367, 1065, 98, 1, 70, "ExampleText",
 CellID->790786255],
Cell[CellGroupData[{
Cell[30490, 1070, 157, 5, 70, "Input",
 CellID->315109163],
Cell[30650, 1077, 178, 5, 50, "Output",
 CellID->298032835]
}, Open  ]],
Cell[30843, 1085, 77, 1, 70, "ExampleText",
 CellID->195094700],
Cell[CellGroupData[{
Cell[30945, 1090, 224, 7, 70, "Input",
 CellID->17858563],
Cell[31172, 1099, 179, 5, 50, "Output",
 CellID->606928814]
}, Open  ]],
Cell[31366, 1107, 125, 3, 70, "ExampleDelimiter",
 CellID->511386803],
Cell[31494, 1112, 104, 2, 70, "ExampleText",
 CellID->240263990],
Cell[CellGroupData[{
Cell[31623, 1118, 184, 6, 70, "Input",
 CellID->299941724],
Cell[31810, 1126, 204, 5, 50, "Output",
 CellID->125347552]
}, Open  ]],
Cell[32029, 1134, 64, 1, 70, "ExampleText",
 CellID->208766706],
Cell[CellGroupData[{
Cell[32118, 1139, 254, 8, 70, "Input",
 CellID->141694954],
Cell[32375, 1149, 182, 5, 50, "Output",
 CellID->533727562]
}, Open  ]],
Cell[32572, 1157, 125, 3, 70, "ExampleDelimiter",
 CellID->392681879],
Cell[32700, 1162, 83, 1, 70, "ExampleText",
 CellID->381026200],
Cell[CellGroupData[{
Cell[32808, 1167, 220, 8, 70, "Input",
 CellID->32636895],
Cell[33031, 1177, 258, 8, 36, "Output",
 CellID->4629937]
}, Open  ]],
Cell[CellGroupData[{
Cell[33326, 1190, 108, 3, 70, "Input",
 CellID->114743573],
Cell[33437, 1195, 193, 5, 50, "Output",
 CellID->68577397]
}, Open  ]],
Cell[33645, 1203, 80, 1, 70, "ExampleText",
 CellID->651747076],
Cell[CellGroupData[{
Cell[33750, 1208, 173, 5, 70, "Input",
 CellID->74346236],
Cell[33926, 1215, 195, 5, 50, "Output",
 CellID->701383420]
}, Open  ]],
Cell[34136, 1223, 65, 1, 70, "ExampleText",
 CellID->714319281],
Cell[CellGroupData[{
Cell[34226, 1228, 175, 5, 70, "Input",
 CellID->463527511],
Cell[34404, 1235, 175, 5, 50, "Output",
 CellID->184476364]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[34640, 1247, 237, 7, 70, "ExampleSection",
 CellID->361089022],
Cell[34880, 1256, 262, 8, 70, "ExampleText",
 CellID->45936541],
Cell[CellGroupData[{
Cell[35167, 1268, 190, 6, 70, "Input",
 CellID->145860351],
Cell[35360, 1276, 176, 5, 50, "Output",
 CellID->21605399]
}, Open  ]],
Cell[35551, 1284, 217, 8, 70, "ExampleText",
 CellID->306237246],
Cell[CellGroupData[{
Cell[35793, 1296, 152, 5, 70, "Input",
 CellID->167840055],
Cell[35948, 1303, 248, 9, 54, "Output",
 CellID->24620390]
}, Open  ]],
Cell[CellGroupData[{
Cell[36233, 1317, 104, 3, 70, "Input",
 CellID->46625405],
Cell[36340, 1322, 177, 5, 50, "Output",
 CellID->186250410]
}, Open  ]],
Cell[36532, 1330, 123, 3, 70, "ExampleDelimiter",
 CellID->3670004],
Cell[36658, 1335, 205, 7, 70, "ExampleText",
 CellID->100794910],
Cell[CellGroupData[{
Cell[36888, 1346, 184, 6, 70, "Input",
 CellID->210440999],
Cell[37075, 1354, 170, 5, 50, "Output",
 CellID->140309891]
}, Open  ]],
Cell[37260, 1362, 222, 7, 70, "ExampleText",
 CellID->28357278],
Cell[CellGroupData[{
Cell[37507, 1373, 183, 6, 70, "Input",
 CellID->106470571],
Cell[37693, 1381, 579, 20, 50, "Output",
 CellID->585015692]
}, Open  ]],
Cell[38287, 1404, 506, 17, 70, "ExampleText",
 CellID->457767460],
Cell[CellGroupData[{
Cell[38818, 1425, 184, 6, 70, "Input",
 CellID->37175165],
Cell[39005, 1433, 217, 10, 65, "Output",
 CellID->663062555]
}, Open  ]],
Cell[CellGroupData[{
Cell[39259, 1448, 186, 6, 70, "Input",
 CellID->52050003],
Cell[39448, 1456, 264, 8, 58, "Output",
 CellID->2620225]
}, Open  ]],
Cell[CellGroupData[{
Cell[39749, 1469, 189, 6, 70, "Input",
 CellID->16589577],
Cell[39941, 1477, 300, 9, 58, "Output",
 CellID->478373485]
}, Open  ]],
Cell[40256, 1489, 125, 3, 70, "ExampleDelimiter",
 CellID->173810528],
Cell[40384, 1494, 222, 8, 70, "ExampleText",
 CellID->280553715],
Cell[CellGroupData[{
Cell[40631, 1506, 208, 7, 70, "Input",
 CellID->367460198],
Cell[40842, 1515, 176, 5, 36, "Output",
 CellID->96667538]
}, Open  ]],
Cell[CellGroupData[{
Cell[41055, 1525, 100, 3, 70, "Input",
 CellID->106513457],
Cell[41158, 1530, 163, 5, 36, "Output",
 CellID->385925556]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[41382, 1542, 310, 9, 70, "SeeAlsoSection",
 CellID->2383],
Cell[41695, 1553, 953, 35, 70, "SeeAlso",
 CellID->29957]
}, Open  ]],
Cell[CellGroupData[{
Cell[42685, 1593, 314, 9, 70, "TutorialsSection",
 CellID->18610],
Cell[43002, 1604, 166, 3, 70, "Tutorials",
 CellID->16279],
Cell[43171, 1609, 157, 3, 70, "Tutorials",
 CellID->24009],
Cell[43331, 1614, 179, 4, 70, "Tutorials",
 CellID->27366],
Cell[43513, 1620, 183, 4, 70, "Tutorials",
 CellID->157498705]
}, Open  ]],
Cell[CellGroupData[{
Cell[43733, 1629, 319, 9, 70, "MoreAboutSection",
 CellID->404749669],
Cell[44055, 1640, 193, 4, 70, "MoreAbout",
 CellID->134317535],
Cell[44251, 1646, 146, 3, 70, "MoreAbout",
 CellID->492180383],
Cell[44400, 1651, 159, 3, 70, "MoreAbout",
 CellID->242831457],
Cell[44562, 1656, 164, 3, 70, "MoreAbout",
 CellID->356652502],
Cell[44729, 1661, 175, 3, 70, "MoreAbout",
 CellID->251455020]
}, Open  ]],
Cell[CellGroupData[{
Cell[44941, 1669, 305, 8, 70, "RelatedLinksSection"],
Cell[45249, 1679, 387, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[45651, 1695, 50, 0, 70, "History"],
Cell[45704, 1697, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

