(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8440,        316]
NotebookOptionsPosition[      5678,        226]
NotebookOutlinePosition[      6957,        262]
CellTagsIndexPosition[      6873,        257]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"MathLink and External Program Communication" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]},\
 #, 2]& , Evaluator -> Automatic], {
      1->"\<\"MathLink and External Program Communication\"\>"}, \
"\<\"tutorials\"\>", 
      StyleBox["\<\"tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InputPacket", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InputPacket",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InputPacket"], "[", "]"}]], "InlineFormula"],
     " \[LineSeparator]is a ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " packet that indicates a prompt for input as generated by ",
     Cell[BoxData[
      ButtonBox["Input",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Input"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->10323273],

Cell[TextData[{
 "Launch a subsidiary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel process:"
}], "ExampleText",
 CellID->1215824468],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"link", "=", 
  RowBox[{"LinkLaunch", "[", 
   RowBox[{
    RowBox[{"First", "[", "$CommandLine", "]"}], " ", "<>", " ", 
    "\"\< -mathlink\>\""}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->312144257],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{"\<\"MathKernel -mathlink\"\>", ",", "239", ",", "7"}], 
  "]"}]], "Output",
 ImageSize->{279, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->637739775]
}, Open  ]],

Cell["Read the first packet:", "ExampleText",
 CellID->625050465],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2053461425],

Cell[BoxData[
 RowBox[{"InputNamePacket", "[", "\<\"In[1]:= \"\>", "]"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->488155857]
}, Open  ]],

Cell[TextData[{
 "Write the packet representing the text ",
 Cell[BoxData["\"\<Input[]\>\""], "InlineFormula"],
 " to enter:"
}], "ExampleText",
 CellID->316479038],

Cell[BoxData[
 RowBox[{"LinkWrite", "[", 
  RowBox[{"link", ",", 
   RowBox[{"EnterTextPacket", "[", "\"\<Input[]\>\"", "]"}]}], "]"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->1893681694],

Cell[TextData[{
 "Read the ",
 Cell[BoxData[
  ButtonBox["InputPacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputPacket"]], "InlineFormula"],
 " expression indicating a prompt for input:"
}], "ExampleText",
 CellID->1400582518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1420596703],

Cell[BoxData[
 RowBox[{"InputPacket", "[", "\<\"? \"\>", "]"}]], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->75667397]
}, Open  ]],

Cell["Close the link:", "ExampleText",
 CellID->1054932471],

Cell[BoxData[
 RowBox[{"LinkClose", "[", "link", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1396673512]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]
}], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InputPacket - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 48, 54.4306414}", "context" -> "System`", 
    "keywords" -> {"input packet", "MathLink packet", "prompt packet"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "InputPacket[] is a MathLink packet that indicates a prompt for input as \
generated by Input.", "synonyms" -> {"input packet"}, "title" -> 
    "InputPacket", "type" -> "Symbol", "uri" -> "ref/InputPacket"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2094, 74, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6739, 250}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 688, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1311, 44, 54, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[1368, 47, 689, 22, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[2094, 74, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[2471, 88, 147, 5, 70, "ExampleSection",
 CellID->10323273],
Cell[2621, 95, 149, 6, 70, "ExampleText",
 CellID->1215824468],
Cell[CellGroupData[{
Cell[2795, 105, 234, 7, 28, "Input",
 CellID->312144257],
Cell[3032, 114, 260, 8, 36, "Output",
 CellID->637739775]
}, Open  ]],
Cell[3307, 125, 65, 1, 70, "ExampleText",
 CellID->625050465],
Cell[CellGroupData[{
Cell[3397, 130, 108, 3, 28, "Input",
 CellID->2053461425],
Cell[3508, 135, 215, 6, 36, "Output",
 CellID->488155857]
}, Open  ]],
Cell[3738, 144, 164, 5, 70, "ExampleText",
 CellID->316479038],
Cell[3905, 151, 191, 6, 70, "Input",
 CellID->1893681694],
Cell[4099, 159, 240, 8, 70, "ExampleText",
 CellID->1400582518],
Cell[CellGroupData[{
Cell[4364, 171, 108, 3, 70, "Input",
 CellID->1420596703],
Cell[4475, 176, 204, 6, 36, "Output",
 CellID->75667397]
}, Open  ]],
Cell[4694, 185, 59, 1, 70, "ExampleText",
 CellID->1054932471],
Cell[4756, 188, 109, 3, 70, "Input",
 CellID->1396673512]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4914, 197, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[5235, 208, 371, 11, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[5621, 222, 27, 0, 70, "History"],
Cell[5651, 224, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

