(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13385,        485]
NotebookOptionsPosition[     10195,        377]
NotebookOutlinePosition[     11476,        414]
CellTagsIndexPosition[     11391,        409]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Streams and Low\[Hyphen]Level Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StreamsAndLowLevelInputAndOutput"], 
          "Files and Streams" :> 
          Documentation`HelpLookup["paclet:tutorial/FilesAndStreams"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Streams and Low\[Hyphen]Level Input and Output\"\>", 
       2->"\<\"Files and Streams\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$Input" :> Documentation`HelpLookup["paclet:ref/$Input"], 
          "Streams" :> Documentation`HelpLookup["paclet:ref/Streams"], 
          "OutputStream" :> 
          Documentation`HelpLookup["paclet:ref/OutputStream"], "OpenRead" :> 
          Documentation`HelpLookup["paclet:ref/OpenRead"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"$Input\"\>", 2->"\<\"Streams\"\>", 
       3->"\<\"OutputStream\"\>", 4->"\<\"OpenRead\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level File Operations" :> 
          Documentation`HelpLookup["paclet:guide/LowLevelFileOperations"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Low-Level File Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InputStream", "ObjectName",
 CellID->22191],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InputStream",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InputStream"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is an object that represents an input stream for \
functions such as ",
     Cell[BoxData[
      ButtonBox["Read",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Read"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["Find",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Find"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->10779]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OpenRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenRead"]], "InlineFormula"],
 " returns an ",
 Cell[BoxData[
  ButtonBox["InputStream",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputStream"]], "InlineFormula"],
 " object. "
}], "Notes",
 CellID->17148],

Cell[TextData[{
 "The serial number ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " is unique across all streams, regardless of their name. "
}], "Notes",
 CellID->30236],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringToStream",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringToStream"]], "InlineFormula"],
 " returns an object of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InputStream",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputStream"], "[", 
   RowBox[{
    ButtonBox["String",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/String"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->32226]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->229092176],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->1631475],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StringToStream",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringToStream"]], "InlineFormula"],
 " opens an input stream: "
}], "ExampleText",
 CellID->1955700922],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"str", "=", 
  RowBox[{"StringToStream", "[", "\"\<123456789\>\"", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1511666010],

Cell[BoxData[
 RowBox[{"InputStream", "[", 
  RowBox[{"String", ",", "85"}], "]"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4929467]
}, Open  ]],

Cell["List of input streams that are currently opened:", "ExampleText",
 CellID->1250299530],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"Streams", "[", "]"}], ",", " ", "_InputStream"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->1179893847],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"InputStream", "[", 
   RowBox[{"String", ",", "85"}], "]"}], "}"}]], "Output",
 ImageSize->{177, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->305040952]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Close",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Close"]], "InlineFormula"],
 " to close streams:"
}], "ExampleText",
 CellID->1487433772],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Close", "[", "str", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->442271277],

Cell[BoxData["String"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->100478790]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->787],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Input",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Input"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Streams",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Streams"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OutputStream",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OutputStream"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OpenRead",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OpenRead"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26523]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29649],

Cell[TextData[ButtonBox["Streams and Low\[Hyphen]Level Input and Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StreamsAndLowLevelInputAndOutput"]], "Tutorials",\

 CellID->11451],

Cell[TextData[ButtonBox["Files and Streams",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FilesAndStreams"]], "Tutorials",
 CellID->478647659]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->276587181],

Cell[TextData[ButtonBox["Low-Level File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelFileOperations"]], "MoreAbout",
 CellID->616142450]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InputStream - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 48, 59.8214044}", "context" -> "System`", 
    "keywords" -> {"stream", "open file"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "InputStream[\"name\", n] is an object that represents an input stream \
for functions such as Read and Find. ", "synonyms" -> {"input stream"}, 
    "title" -> "InputStream", "type" -> "Symbol", "uri" -> 
    "ref/InputStream"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5378, 179, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->229092176]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11248, 402}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2274, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2897, 81, 49, 1, 70, "ObjectName",
 CellID->22191],
Cell[2949, 84, 867, 28, 70, "Usage",
 CellID->10779]
}, Open  ]],
Cell[CellGroupData[{
Cell[3853, 117, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4331, 134, 318, 12, 70, "Notes",
 CellID->17148],
Cell[4652, 148, 185, 6, 70, "Notes",
 CellID->30236],
Cell[4840, 156, 501, 18, 70, "Notes",
 CellID->32226]
}, Closed]],
Cell[CellGroupData[{
Cell[5378, 179, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->229092176],
Cell[CellGroupData[{
Cell[5763, 193, 146, 5, 70, "ExampleSection",
 CellID->1631475],
Cell[5912, 200, 214, 7, 70, "ExampleText",
 CellID->1955700922],
Cell[CellGroupData[{
Cell[6151, 211, 152, 4, 28, "Input",
 CellID->1511666010],
Cell[6306, 217, 223, 7, 36, "Output",
 CellID->4929467]
}, Open  ]],
Cell[6544, 227, 92, 1, 70, "ExampleText",
 CellID->1250299530],
Cell[CellGroupData[{
Cell[6661, 232, 173, 6, 28, "Input",
 CellID->1179893847],
Cell[6837, 240, 249, 8, 36, "Output",
 CellID->305040952]
}, Open  ]],
Cell[7101, 251, 199, 8, 70, "ExampleText",
 CellID->1487433772],
Cell[CellGroupData[{
Cell[7325, 263, 103, 3, 70, "Input",
 CellID->442271277],
Cell[7431, 268, 163, 5, 36, "Output",
 CellID->100478790]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7655, 280, 309, 9, 70, "SeeAlsoSection",
 CellID->787],
Cell[7967, 291, 943, 35, 70, "SeeAlso",
 CellID->26523]
}, Open  ]],
Cell[CellGroupData[{
Cell[8947, 331, 314, 9, 70, "TutorialsSection",
 CellID->29649],
Cell[9264, 342, 191, 4, 70, "Tutorials",
 CellID->11451],
Cell[9458, 348, 147, 3, 70, "Tutorials",
 CellID->478647659]
}, Open  ]],
Cell[CellGroupData[{
Cell[9642, 356, 319, 9, 70, "MoreAboutSection",
 CellID->276587181],
Cell[9964, 367, 159, 3, 70, "MoreAbout",
 CellID->616142450]
}, Open  ]],
Cell[10138, 373, 27, 0, 70, "History"],
Cell[10168, 375, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

