(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     40985,       1431]
NotebookOptionsPosition[     33184,       1161]
NotebookOutlinePosition[     34781,       1202]
CellTagsIndexPosition[     34695,       1197]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Digits in Numbers" :> 
          Documentation`HelpLookup["paclet:tutorial/DigitsInNumbers"], 
          "Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Digits in Numbers\"\>", 
       2->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"IntegerString" :> 
          Documentation`HelpLookup["paclet:ref/IntegerString"], "DigitCount" :> 
          Documentation`HelpLookup["paclet:ref/DigitCount"], "IntegerLength" :> 
          Documentation`HelpLookup["paclet:ref/IntegerLength"], "RealDigits" :> 
          Documentation`HelpLookup["paclet:ref/RealDigits"], "BaseForm" :> 
          Documentation`HelpLookup["paclet:ref/BaseForm"], "NumberForm" :> 
          Documentation`HelpLookup["paclet:ref/NumberForm"], "FromDigits" :> 
          Documentation`HelpLookup["paclet:ref/FromDigits"], 
          "IntegerExponent" :> 
          Documentation`HelpLookup["paclet:ref/IntegerExponent"], 
          "IntegerPart" :> Documentation`HelpLookup["paclet:ref/IntegerPart"],
           "ContinuedFraction" :> 
          Documentation`HelpLookup["paclet:ref/ContinuedFraction"], "Tuples" :> 
          Documentation`HelpLookup["paclet:ref/Tuples"], "BitAnd" :> 
          Documentation`HelpLookup["paclet:ref/BitAnd"], "BitOr" :> 
          Documentation`HelpLookup["paclet:ref/BitOr"], "BitLength" :> 
          Documentation`HelpLookup["paclet:ref/BitLength"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"IntegerString\"\>", 
       2->"\<\"DigitCount\"\>", 3->"\<\"IntegerLength\"\>", 
       4->"\<\"RealDigits\"\>", 5->"\<\"BaseForm\"\>", 
       6->"\<\"NumberForm\"\>", 7->"\<\"FromDigits\"\>", 
       8->"\<\"IntegerExponent\"\>", 9->"\<\"IntegerPart\"\>", 
       10->"\<\"ContinuedFraction\"\>", 11->"\<\"Tuples\"\>", 
       12->"\<\"BitAnd\"\>", 13->"\<\"BitOr\"\>", 
       14->"\<\"BitLength\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Atomic Elements of Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AtomicElementsOfExpressions"], "Constructing Lists" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingLists"], 
          "Discrete Mathematics" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteMathematics"], 
          "Integer Functions" :> 
          Documentation`HelpLookup["paclet:guide/IntegerFunctions"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Number Digits" :> 
          Documentation`HelpLookup["paclet:guide/NumberDigits"], 
          "Number Theoretic Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheoreticFunctions"], 
          "Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"], 
          "Numerical Evaluation & Precision" :> 
          Documentation`HelpLookup[
           "paclet:guide/NumericalEvaluationAndPrecision"], 
          "Representation of Numbers" :> 
          Documentation`HelpLookup[
           "paclet:guide/RepresentationOfNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Atomic Elements of Expressions\"\>", 
       2->"\<\"Constructing Lists\"\>", 3->"\<\"Discrete Mathematics\"\>", 
       4->"\<\"Integer Functions\"\>", 5->"\<\"Mathematical Functions\"\>", 
       6->"\<\"Number Digits\"\>", 7->"\<\"Number Theoretic Functions\"\>", 
       8->"\<\"Number Theory\"\>", 
       9->"\<\"Numerical Evaluation & Precision\"\>", 
       10->"\<\"Representation of Numbers\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["IntegerDigits", "ObjectName",
 CellID->27224],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["IntegerDigits",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/IntegerDigits"], "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of the decimal digits in the integer ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["IntegerDigits",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/IntegerDigits"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of the base\[Hyphen]",
     Cell[BoxData[
      StyleBox["b", "TI"]], "InlineFormula"],
     " digits in the integer ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["IntegerDigits",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/IntegerDigits"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["b", "TI"], ",", 
        StyleBox["len", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]pads the list on the left with zeros to give a list of \
length ",
     Cell[BoxData[
      StyleBox["len", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->26219]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["IntegerDigits",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerDigits"]], "InlineFormula"],
 " gives the most significant digit first, as in standard positional \
notation."
}], "Notes",
 CellID->19959147],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["IntegerDigits",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerDigits"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " discards the sign of ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20513],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["len", "TI"]], "InlineFormula"],
 " is less than the number of digits in ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " then the ",
 Cell[BoxData[
  StyleBox["len", "TI"]], "InlineFormula"],
 " least significant digits are returned. "
}], "Notes",
 CellID->20642],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["IntegerDigits",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerDigits"], "[", "0", "]"}]], 
  "InlineFormula"],
 " gives ",
 Cell[BoxData[
  RowBox[{"{", "0", "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20454],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FromDigits",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FromDigits"]], "InlineFormula"],
 " can be used as the inverse of ",
 Cell[BoxData[
  ButtonBox["IntegerDigits",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerDigits"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->25265]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->69414040],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->508433857],

Cell["Find digits in base 10:", "ExampleText",
 CellID->21201],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerDigits", "[", "58127", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4804],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5", ",", "8", ",", "1", ",", "2", ",", "7"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2708]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20573],

Cell["Find digits in base 2:", "ExampleText",
 CellID->15044],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerDigits", "[", 
  RowBox[{"58127", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15865],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", 
   "1"}], "}"}]], "Output",
 ImageSize->{298, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19465]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10792],

Cell["Bases larger than 10 can be used:", "ExampleText",
 CellID->7233],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerDigits", "[", 
  RowBox[{"58127", ",", "16"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27674],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"14", ",", "3", ",", "0", ",", "15"}], "}"}]], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11351]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13752],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["IntegerDigits",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerDigits"]], "InlineFormula"],
 " threads itself over elements of lists:"
}], "ExampleText",
 CellID->28410],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerDigits", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"6", ",", "7", ",", "2"}], "}"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26614],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24555]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7105],

Cell["Find the digits of 7 in different bases:", "ExampleText",
 CellID->22475],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerDigits", "[", 
  RowBox[{"7", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1274],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}]}], "}"}]], "Output",
 ImageSize->{177, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2483]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1577],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["IntegerDigits",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerDigits"]], "InlineFormula"],
 " includes no leading zeros:"
}], "ExampleText",
 CellID->8854],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerDigits", "[", 
  RowBox[{
   RowBox[{"Range", "[", 
    RowBox[{"0", ",", "7"}], "]"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17110],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "0", "}"}], ",", 
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{447, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16564]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11696],

Cell["Pad all digit lists to be length 3:", "ExampleText",
 CellID->27559],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerDigits", "[", 
  RowBox[{
   RowBox[{"Range", "[", 
    RowBox[{"0", ",", "7"}], "]"}], ",", "2", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14571],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{556, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14802]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17014],

Cell["Find only the last 4 digits:", "ExampleText",
 CellID->30258],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerDigits", "[", 
  RowBox[{"6345354", ",", "10", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25336],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5", ",", "3", ",", "5", ",", "4"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29160]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8438],

Cell["Leading digits of factorials:", "ExampleText",
 CellID->15896],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"First", "[", 
    RowBox[{"IntegerDigits", "[", 
     RowBox[{"n", "!"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "50"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->241],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "6", ",", "2", ",", "1", ",", "7", ",", "5", ",", "4", 
   ",", "3", ",", "3", ",", "3", ",", "4", ",", "6", ",", "8", ",", "1", ",", 
   "2", ",", "3", ",", "6", ",", "1", ",", "2", ",", "5", ",", "1", ",", "2", 
   ",", "6", ",", "1", ",", "4", ",", "1", ",", "3", ",", "8", ",", "2", ",", 
   "8", ",", "2", ",", "8", ",", "2", ",", "1", ",", "3", ",", "1", ",", "5", 
   ",", "2", ",", "8", ",", "3", ",", "1", ",", "6", ",", "2", ",", "1", ",", 
   "5", ",", "2", ",", "1", ",", "6", ",", "3"}], "}"}]], "Output",
 ImageSize->{480, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22360]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5111],

Cell["Cantor set construction:", "ExampleText",
 CellID->11886],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"FreeQ", "[", 
      RowBox[{
       RowBox[{"IntegerDigits", "[", 
        RowBox[{
         RowBox[{"n", "-", "1"}], ",", "3"}], "]"}], ",", "1"}], "]"}], ",", 
     "1", ",", "0"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "27"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9312],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", 
   ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "1", ",", "0", ",", "0", 
   ",", "0", ",", "1", ",", "0", ",", "1"}], "}"}]], "Output",
 ImageSize->{498, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7734]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32544],

Cell["Find all combinations of 3 binary digits:", "ExampleText",
 CellID->12225],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"IntegerDigits", "[", 
    RowBox[{"i", ",", "2", ",", "3"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "0", ",", "7"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30845],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{556, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14365]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tuples", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}], ",", "3"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28338],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{556, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->25032]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7802],

Cell["Pad digit lists to be the same length:", "ExampleText",
 CellID->22327],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PadLeft", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"IntegerDigits", "[", 
     RowBox[{
      RowBox[{"i", "^", "2"}], ",", "2"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3702],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0", ",", "0", ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{532, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7799]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25091],

Cell["The sign is ignored:", "ExampleText",
 CellID->4613],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerDigits", "[", 
  RowBox[{"-", "3134"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14137],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "1", ",", "3", ",", "4"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30818]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28963],

Cell["Leading digits of factorials in base 100:", "ExampleText",
 CellID->9954],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"First", "[", 
     RowBox[{"IntegerDigits", "[", 
      RowBox[{
       RowBox[{"n", "!"}], ",", "100"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "300"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18079],

Cell[BoxData[
 GraphicsBox[{{}, LineBox[CompressedData["
1:eJxdmF9yljUUh4NXXvaCCy+4CN84DON0mIqiIkhDBVHkT60UrCK8/AcBW1xB
ltAlvEvoErIElpAldAkM0+f5nJze/OZ58+XkJOfkJOnJx7tbzz5JKa0eS+mj
Hv0dro+ayqifop+hK+h36PEy9vd3J4L+guZgZ4FuoJ+HcU8daf0RPh36f4He
RlfDOGeCf2vw1+iXYbyz6Cb6VRjXfq7POfxzft+Mfqdvw+9dN/09H/z8HnV+
F4L/F+FL6A9oDt8dbx3/7sBlHKfK9r889q+y42/wPegyDsaJvFjGTX+uHGnB
n3ol+HEVJY5VNq9+Cv7J+neN77+i8HKdf0aJZ5W1bxzJh2VctX8d1n9ZPxnX
uOvHMn9uoOyLKhvvm6jzkx3/1hE3x78V/DavjLtsHpvX+FNk4l9l4tdk98dv
o39Fxr8auMFlm+9bo98FNq7VdvKh2e6++R1lnxbZfJHZf002v90HrL95uMxX
mXi4zsv5b4+8nJfxCtwCp7so61MC18AtcLoX+geugVvg9Ad+oQX1e1Xvhd9p
Z2fksjP+vu6M9trOaCf9GfwPXAO3wOmv0D9wDdwCp/uhv2z8ArfA6W/U+Aeu
svkje04+QKk3RXb/yQv6y9aPhyjnRZHZD1Wm/jTZc2FCqcsZtg4W29n3k0we
V5n1mwO3wF12/R6hrFeWWZ8isz6TvGB8mfNmlpl/kznfuuw59Bg71OUMWxeK
jP9T4Cozn1lmPk1mPl22/jwZ/c8y94oiE68J9hyrMnVx9veuf+Auu/5PUfIz
y9ZDmXybZPyrMvV5llnPBlvHuu3uv2ejP1nGnyLjzyR7Xsvcu2Z5g/Fl8rfL
jv985Cy7n2XzT/YeKrMes+z4sOdoD+OlF7Dzl52/7PxlzzeZ/J5lzv8mU2+7
7PgvYfefbD2Syc9J5v5UZcabZfMvcA/jpVfj/LJsPZPJrwn2nlJtt/7I1mvZ
/Sd7H/8H5T6RZeZTZPe/7PkgE69Z5t3SZPKzy95DX4/2s+x9Ssb+JGO/yrwz
Ztn4B/s92E9vUNYny94HZd4Zk+z6y66/bP2TiW+XfWe9xQ73/gybr0XG30n2
fibj7yzzDmra597ZbTf//4Wtf/KC8WXOzwn2nl5td/6y85ep91323biLHeKV
d0d7RcbeJHs/kK0/wV4L9nqwl/ZGeysy+ZRl5rsm65+MvU15gb8y9WlPJh41
2NuX3U8y8T2QeYc22Hvxe9vJly5Tzw5l3/Xv8IP7zsq70Z8sM781mf1XZN7l
m7DvkMl2/NmTzV+Z/0Ps6w/1YQ7+HAR/WvDnvcx9ocO+Ow6DP+k/lP25IpNP
WeZ9tiYbf5n5bMrU70nmPbcX+leZ+ezL1OdZJt4HoX/7v/8Hb3vd7w==
    "]]},
  AspectRatio->GoldenRatio^(-1),
  Axes->True,
  PlotRange->{Automatic, Automatic},
  PlotRangeClipping->True]], "Output",
 ImageSize->{184, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19196]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32232],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerString"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DigitCount",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DigitCount"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerLength",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerLength"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RealDigits",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RealDigits"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BaseForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BaseForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FromDigits",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FromDigits"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerExponent",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerExponent"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerPart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerPart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ContinuedFraction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ContinuedFraction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tuples",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tuples"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BitAnd",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitAnd"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BitOr",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitOr"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BitLength",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitLength"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->612]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32696],

Cell[TextData[ButtonBox["Digits in Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DigitsInNumbers"]], "Tutorials",
 CellID->21213],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->22869]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->7029],

Cell[TextData[{
 ButtonBox["Demonstrations with IntegerDigits",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=IntegerDigits"],
     None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[ButtonBox["Implementation notes: Numerical and Related \
Functions",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#23292"], None}]], "RelatedLinks",
 CellID->31113],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
IntegerDigits"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->104001888],

Cell[TextData[ButtonBox["Atomic Elements of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AtomicElementsOfExpressions"]], "MoreAbout",
 CellID->105432780],

Cell[TextData[ButtonBox["Constructing Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingLists"]], "MoreAbout",
 CellID->267903751],

Cell[TextData[ButtonBox["Discrete Mathematics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "MoreAbout",
 CellID->271373788],

Cell[TextData[ButtonBox["Integer Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegerFunctions"]], "MoreAbout",
 CellID->487017357],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->348268370],

Cell[TextData[ButtonBox["Number Digits",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberDigits"]], "MoreAbout",
 CellID->55453154],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "MoreAbout",
 CellID->92521734],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->9853876],

Cell[TextData[ButtonBox["Numerical Evaluation & Precision",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalEvaluationAndPrecision"]], "MoreAbout",
 CellID->86951152],

Cell[TextData[ButtonBox["Representation of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RepresentationOfNumbers"]], "MoreAbout",
 CellID->139348745]
}, Open  ]],

Cell["New in 2  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"IntegerDigits - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 49, 8.6028792}", "context" -> "System`", 
    "keywords" -> {
     "bases", "binary digits", "conversion", "decimal digits", "decode", 
      "digits", "explode", "hexadecimal digits", "octal digits", "padding", 
      "radix conversion", "ternary digits", "unpack"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "IntegerDigits[n] gives a list of the decimal digits in the integer n. \
IntegerDigits[n, b] gives a list of the base-b digits in the integer n. \
IntegerDigits[n, b, len] pads the list on the left with zeros to give a list \
of length len. ", "synonyms" -> {"integer digits"}, "title" -> 
    "IntegerDigits", "type" -> "Symbol", "uri" -> "ref/IntegerDigits"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9176, 268, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->69414040]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 34553, 1190}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 4803, 96, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[5426, 123, 51, 1, 70, "ObjectName",
 CellID->27224],
Cell[5480, 126, 1607, 51, 70, "Usage",
 CellID->26219]
}, Open  ]],
Cell[CellGroupData[{
Cell[7124, 182, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7602, 199, 258, 8, 70, "Notes",
 CellID->19959147],
Cell[7863, 209, 314, 12, 70, "Notes",
 CellID->20513],
Cell[8180, 223, 329, 12, 70, "Notes",
 CellID->20642],
Cell[8512, 237, 286, 12, 70, "Notes",
 CellID->20454],
Cell[8801, 251, 338, 12, 70, "Notes",
 CellID->25265]
}, Closed]],
Cell[CellGroupData[{
Cell[9176, 268, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->69414040],
Cell[CellGroupData[{
Cell[9560, 282, 148, 5, 70, "ExampleSection",
 CellID->508433857],
Cell[9711, 289, 62, 1, 70, "ExampleText",
 CellID->21201],
Cell[CellGroupData[{
Cell[9798, 294, 108, 3, 28, "Input",
 CellID->4804],
Cell[9909, 299, 228, 7, 36, "Output",
 CellID->2708]
}, Open  ]],
Cell[10152, 309, 121, 3, 70, "ExampleDelimiter",
 CellID->20573],
Cell[10276, 314, 61, 1, 70, "ExampleText",
 CellID->15044],
Cell[CellGroupData[{
Cell[10362, 319, 132, 4, 70, "Input",
 CellID->15865],
Cell[10497, 325, 351, 10, 36, "Output",
 CellID->19465]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10897, 341, 216, 7, 70, "ExampleSection",
 CellID->10792],
Cell[11116, 350, 71, 1, 70, "ExampleText",
 CellID->7233],
Cell[CellGroupData[{
Cell[11212, 355, 133, 4, 70, "Input",
 CellID->27674],
Cell[11348, 361, 221, 7, 36, "Output",
 CellID->11351]
}, Open  ]],
Cell[11584, 371, 121, 3, 70, "ExampleDelimiter",
 CellID->13752],
Cell[11708, 376, 222, 7, 70, "ExampleText",
 CellID->28410],
Cell[CellGroupData[{
Cell[11955, 387, 187, 6, 70, "Input",
 CellID->26614],
Cell[12145, 395, 377, 13, 36, "Output",
 CellID->24555]
}, Open  ]],
Cell[12537, 411, 120, 3, 70, "ExampleDelimiter",
 CellID->7105],
Cell[12660, 416, 79, 1, 70, "ExampleText",
 CellID->22475],
Cell[CellGroupData[{
Cell[12764, 421, 186, 6, 70, "Input",
 CellID->1274],
Cell[12953, 429, 366, 13, 36, "Output",
 CellID->2483]
}, Open  ]],
Cell[13334, 445, 120, 3, 70, "ExampleDelimiter",
 CellID->1577],
Cell[13457, 450, 226, 8, 70, "ExampleText",
 CellID->8854],
Cell[CellGroupData[{
Cell[13708, 462, 186, 6, 70, "Input",
 CellID->17110],
Cell[13897, 470, 642, 21, 36, "Output",
 CellID->16564]
}, Open  ]],
Cell[14554, 494, 121, 3, 70, "ExampleDelimiter",
 CellID->11696],
Cell[14678, 499, 74, 1, 70, "ExampleText",
 CellID->27559],
Cell[CellGroupData[{
Cell[14777, 504, 196, 6, 70, "Input",
 CellID->14571],
Cell[14976, 512, 732, 23, 36, "Output",
 CellID->14802]
}, Open  ]],
Cell[15723, 538, 121, 3, 70, "ExampleDelimiter",
 CellID->17014],
Cell[15847, 543, 67, 1, 70, "ExampleText",
 CellID->30258],
Cell[CellGroupData[{
Cell[15939, 548, 145, 4, 70, "Input",
 CellID->25336],
Cell[16087, 554, 219, 7, 36, "Output",
 CellID->29160]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16355, 567, 222, 7, 70, "ExampleSection",
 CellID->8438],
Cell[16580, 576, 68, 1, 70, "ExampleText",
 CellID->15896],
Cell[CellGroupData[{
Cell[16673, 581, 264, 9, 70, "Input",
 CellID->241],
Cell[16940, 592, 707, 14, 54, "Output",
 CellID->22360]
}, Open  ]],
Cell[17662, 609, 120, 3, 70, "ExampleDelimiter",
 CellID->5111],
Cell[17785, 614, 63, 1, 70, "ExampleText",
 CellID->11886],
Cell[CellGroupData[{
Cell[17873, 619, 406, 14, 70, "Input",
 CellID->9312],
Cell[18282, 635, 464, 11, 36, "Output",
 CellID->7734]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18795, 652, 233, 7, 70, "ExampleSection",
 CellID->32544],
Cell[19031, 661, 80, 1, 70, "ExampleText",
 CellID->12225],
Cell[CellGroupData[{
Cell[19136, 666, 255, 8, 70, "Input",
 CellID->30845],
Cell[19394, 676, 732, 23, 36, "Output",
 CellID->14365]
}, Open  ]],
Cell[CellGroupData[{
Cell[20163, 704, 170, 6, 70, "Input",
 CellID->28338],
Cell[20336, 712, 732, 23, 36, "Output",
 CellID->25032]
}, Open  ]],
Cell[21083, 738, 120, 3, 70, "ExampleDelimiter",
 CellID->7802],
Cell[21206, 743, 77, 1, 70, "ExampleText",
 CellID->22327],
Cell[CellGroupData[{
Cell[21308, 748, 300, 10, 70, "Input",
 CellID->3702],
Cell[21611, 760, 627, 18, 36, "Output",
 CellID->7799]
}, Open  ]],
Cell[22253, 781, 121, 3, 70, "ExampleDelimiter",
 CellID->25091],
Cell[22377, 786, 58, 1, 70, "ExampleText",
 CellID->4613],
Cell[CellGroupData[{
Cell[22460, 791, 126, 4, 70, "Input",
 CellID->14137],
Cell[22589, 797, 219, 7, 36, "Output",
 CellID->30818]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22857, 810, 224, 7, 70, "ExampleSection",
 CellID->28963],
Cell[23084, 819, 79, 1, 70, "ExampleText",
 CellID->9954],
Cell[CellGroupData[{
Cell[23188, 824, 342, 11, 70, "Input",
 CellID->18079],
Cell[23533, 837, 1718, 34, 137, "Output",
 CellID->19196]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25312, 878, 311, 9, 70, "SeeAlsoSection",
 CellID->32232],
Cell[25626, 889, 3451, 125, 70, "SeeAlso",
 CellID->612]
}, Open  ]],
Cell[CellGroupData[{
Cell[29114, 1019, 314, 9, 70, "TutorialsSection",
 CellID->32696],
Cell[29431, 1030, 143, 3, 70, "Tutorials",
 CellID->21213],
Cell[29577, 1035, 198, 4, 70, "Tutorials",
 CellID->22869]
}, Open  ]],
Cell[CellGroupData[{
Cell[29812, 1044, 320, 9, 70, "RelatedLinksSection",
 CellID->7029],
Cell[30135, 1055, 371, 12, 70, "RelatedLinks"],
Cell[30509, 1069, 267, 6, 70, "RelatedLinks",
 CellID->31113],
Cell[30779, 1077, 391, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[31207, 1095, 319, 9, 70, "MoreAboutSection",
 CellID->104001888],
Cell[31529, 1106, 169, 3, 70, "MoreAbout",
 CellID->105432780],
Cell[31701, 1111, 147, 3, 70, "MoreAbout",
 CellID->267903751],
Cell[31851, 1116, 151, 3, 70, "MoreAbout",
 CellID->271373788],
Cell[32005, 1121, 145, 3, 70, "MoreAbout",
 CellID->487017357],
Cell[32153, 1126, 155, 3, 70, "MoreAbout",
 CellID->348268370],
Cell[32311, 1131, 136, 3, 70, "MoreAbout",
 CellID->55453154],
Cell[32450, 1136, 161, 3, 70, "MoreAbout",
 CellID->92521734],
Cell[32614, 1141, 135, 3, 70, "MoreAbout",
 CellID->9853876],
Cell[32752, 1146, 174, 3, 70, "MoreAbout",
 CellID->86951152],
Cell[32929, 1151, 160, 3, 70, "MoreAbout",
 CellID->139348745]
}, Open  ]],
Cell[33104, 1157, 50, 0, 70, "History"],
Cell[33157, 1159, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

