(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20871,        695]
NotebookOptionsPosition[     16836,        561]
NotebookOutlinePosition[     18171,        599]
CellTagsIndexPosition[     18086,        594]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Digits in Numbers" :> 
          Documentation`HelpLookup["paclet:tutorial/DigitsInNumbers"], 
          "Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Digits in Numbers\"\>", 
       2->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Log" :> Documentation`HelpLookup["paclet:ref/Log"], 
          "DigitCount" :> Documentation`HelpLookup["paclet:ref/DigitCount"], 
          "IntegerDigits" :> 
          Documentation`HelpLookup["paclet:ref/IntegerDigits"], "BitLength" :> 
          Documentation`HelpLookup["paclet:ref/BitLength"], "ByteCount" :> 
          Documentation`HelpLookup["paclet:ref/ByteCount"], "IntegerExponent" :> 
          Documentation`HelpLookup["paclet:ref/IntegerExponent"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Log\"\>", 2->"\<\"DigitCount\"\>", 
       3->"\<\"IntegerDigits\"\>", 4->"\<\"BitLength\"\>", 
       5->"\<\"ByteCount\"\>", 
       6->"\<\"IntegerExponent\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer Functions" :> 
          Documentation`HelpLookup["paclet:guide/IntegerFunctions"], 
          "Number Digits" :> 
          Documentation`HelpLookup["paclet:guide/NumberDigits"], 
          "Representation of Numbers" :> 
          Documentation`HelpLookup["paclet:guide/RepresentationOfNumbers"], 
          "New in 6.0: Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicalFunctions"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"], 
          "New in 6.0: Number Theory & Integer Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Integer Functions\"\>", 
       2->"\<\"Number Digits\"\>", 3->"\<\"Representation of Numbers\"\>", 
       4->"\<\"New in 6.0: Mathematical Functions\"\>", 
       5->"\<\"New in 6.0: Mathematics & Algorithms\"\>", 
       6->"\<\"New in 6.0: Number Theory & Integer Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["IntegerLength", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["IntegerLength",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/IntegerLength"], "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the number of digits in the base 10 \
representation of the integer ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["IntegerLength",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/IntegerLength"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the number of digits in the base ",
     Cell[BoxData[
      StyleBox["b", "TI"]], "InlineFormula"],
     " representation of ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Integer mathematical function, suitable for both symbolic and numerical \
manipulation.\
\>", "Notes",
 CellID->126685801],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["IntegerLength",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerLength"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
 " is effectively an efficient version of ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Floor",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Floor"], "[", 
    RowBox[{
     ButtonBox["Log",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Log"], "[", 
     RowBox[{
      StyleBox["b", "TI"], ",", 
      StyleBox["n", "TI"]}], "]"}], "]"}], "+", "1"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->8928],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["IntegerLength",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerLength"]], "InlineFormula"],
 " ignores the sign of ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->289326791],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["IntegerLength",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerLength"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->555347927]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->169574427],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->160265857],

Cell["Find the number of decimal digits in 123456789:", "ExampleText",
 CellID->100884199],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerLength", "[", "123456789", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->332650706],

Cell[BoxData["9"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10919444]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->517907344],

Cell[TextData[{
 "The number of binary digits in ",
 Cell[BoxData[
  RowBox[{"100", "!"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1260627],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerLength", "[", 
  RowBox[{
   RowBox[{"100", "!"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3193799],

Cell[BoxData["525"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->318922131]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"IntegerLength", "[", 
      RowBox[{"n", "!"}], "]"}], "-", "n"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "50"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->49635995],

Cell[BoxData[
 GraphicsBox[{{}, {}, {
    {Hue[0.67, 0.6, 0.6]}, 
    LineBox[{{1., 0.}, {2., -1.}, {3., -2.}, {4., -2.}, {5., -2.}, {
     6., -3.}, {7., -3.}, {8., -3.}, {9., -3.}, {10., -3.}, {11., -3.}, {
     12., -3.}, {13., -3.}, {14., -3.}, {15., -2.}, {16., -2.}, {17., -2.}, {
     18., -2.}, {19., -1.}, {20., -1.}, {21., -1.}, {22., 0.}, {23., 0.}, {
     24., 0.}, {25., 1.}, {26., 1.}, {27., 2.}, {28., 2.}, {29., 2.}, {30., 
     3.}, {31., 3.}, {32., 4.}, {33., 4.}, {34., 5.}, {35., 6.}, {36., 6.}, {
     37., 7.}, {38., 7.}, {39., 8.}, {40., 8.}, {41., 9.}, {42., 10.}, {43., 
     10.}, {44., 11.}, {45., 12.}, {46., 12.}, {47., 13.}, {48., 14.}, {49., 
     14.}, {50., 15.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
  Axes->True,
  PlotRange->{{0., 50.}, {-3., 15.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->293563689]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->173520815],

Cell[TextData[{
 "Find how the number of digits in ",
 Cell[BoxData[
  RowBox[{"100", "!"}]], "InlineFormula"],
 " decreases with base:"
}], "ExampleText",
 CellID->199145635],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"IntegerLength", "[", 
    RowBox[{
     RowBox[{"100", "!"}], ",", "n"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "2", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->108653179],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "525", ",", "332", ",", "263", ",", "227", ",", "204", ",", "187", ",", 
   "175", ",", "166", ",", "158", ",", "152", ",", "147", ",", "142", ",", 
   "138", ",", "135", ",", "132", ",", "129", ",", "126", ",", "124", ",", 
   "122"}], "}"}]], "Output",
 ImageSize->{361, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->329263834]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Log",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Log"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DigitCount",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DigitCount"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerDigits",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerDigits"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BitLength",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BitLength"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ByteCount",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ByteCount"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerExponent",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerExponent"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Digits in Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DigitsInNumbers"]], "Tutorials",
 CellID->23990],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->25476]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->188831633],

Cell[TextData[ButtonBox["Integer Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegerFunctions"]], "MoreAbout",
 CellID->242863591],

Cell[TextData[ButtonBox["Number Digits",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberDigits"]], "MoreAbout",
 CellID->113344724],

Cell[TextData[ButtonBox["Representation of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RepresentationOfNumbers"]], "MoreAbout",
 CellID->689607836],

Cell[TextData[ButtonBox["New in 6.0: Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicalFunctions"]], "MoreAbout",
 CellID->153232020],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->429243392],

Cell[TextData[ButtonBox["New in 6.0: Number Theory & Integer Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]], "MoreAbout",
 CellID->297862971]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"IntegerLength - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 49, 9.4622762}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "IntegerLength[n] gives the number of digits in the base 10 \
representation of the integer n. IntegerLength[n, b] gives the number of \
digits in the base b representation of n.", "synonyms" -> {"integer length"}, 
    "title" -> "IntegerLength", "type" -> "Symbol", "uri" -> 
    "ref/IntegerLength"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8599, 255, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->169574427]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17943, 587}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3414, 74, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4037, 101, 1578, 37, 70, "ObjectNameGrid"],
Cell[5618, 140, 1135, 36, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6790, 181, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7268, 198, 132, 4, 70, "Notes",
 CellID->126685801],
Cell[7403, 204, 673, 25, 70, "Notes",
 CellID->8928],
Cell[8079, 231, 265, 10, 70, "Notes",
 CellID->289326791],
Cell[8347, 243, 215, 7, 70, "Notes",
 CellID->555347927]
}, Closed]],
Cell[CellGroupData[{
Cell[8599, 255, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->169574427],
Cell[CellGroupData[{
Cell[8984, 269, 148, 5, 70, "ExampleSection",
 CellID->160265857],
Cell[9135, 276, 90, 1, 70, "ExampleText",
 CellID->100884199],
Cell[CellGroupData[{
Cell[9250, 281, 117, 3, 28, "Input",
 CellID->332650706],
Cell[9370, 286, 157, 5, 36, "Output",
 CellID->10919444]
}, Open  ]],
Cell[9542, 294, 125, 3, 70, "ExampleDelimiter",
 CellID->517907344],
Cell[9670, 299, 151, 6, 70, "ExampleText",
 CellID->1260627],
Cell[CellGroupData[{
Cell[9846, 309, 151, 5, 70, "Input",
 CellID->3193799],
Cell[10000, 316, 160, 5, 36, "Output",
 CellID->318922131]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10209, 327, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[CellGroupData[{
Cell[10461, 338, 305, 10, 70, "Input",
 CellID->49635995],
Cell[10769, 350, 1043, 23, 130, "Output",
 CellID->293563689]
}, Open  ]],
Cell[11827, 376, 125, 3, 70, "ExampleDelimiter",
 CellID->173520815],
Cell[11955, 381, 175, 6, 70, "ExampleText",
 CellID->199145635],
Cell[CellGroupData[{
Cell[12155, 391, 273, 9, 70, "Input",
 CellID->108653179],
Cell[12431, 402, 427, 11, 54, "Output",
 CellID->329263834]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12919, 420, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[13238, 431, 1457, 53, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[14732, 489, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[15053, 500, 143, 3, 70, "Tutorials",
 CellID->23990],
Cell[15199, 505, 198, 4, 70, "Tutorials",
 CellID->25476]
}, Open  ]],
Cell[CellGroupData[{
Cell[15434, 514, 319, 9, 70, "MoreAboutSection",
 CellID->188831633],
Cell[15756, 525, 145, 3, 70, "MoreAbout",
 CellID->242863591],
Cell[15904, 530, 137, 3, 70, "MoreAbout",
 CellID->113344724],
Cell[16044, 535, 160, 3, 70, "MoreAbout",
 CellID->689607836],
Cell[16207, 540, 174, 3, 70, "MoreAbout",
 CellID->153232020],
Cell[16384, 545, 179, 3, 70, "MoreAbout",
 CellID->429243392],
Cell[16566, 550, 198, 4, 70, "MoreAbout",
 CellID->297862971]
}, Open  ]],
Cell[16779, 557, 27, 0, 70, "History"],
Cell[16809, 559, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

