(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     46817,       1678]
NotebookOptionsPosition[     37826,       1369]
NotebookOutlinePosition[     39431,       1410]
CellTagsIndexPosition[     39345,       1405]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer and Number Theoretic Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Integer and Number Theoretic Functions\"\>"}, "\<\"tutorials\"\
\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PartitionsP" :> 
          Documentation`HelpLookup["paclet:ref/PartitionsP"], "Divisors" :> 
          Documentation`HelpLookup["paclet:ref/Divisors"], "Subsets" :> 
          Documentation`HelpLookup["paclet:ref/Subsets"], "IntegerDigits" :> 
          Documentation`HelpLookup["paclet:ref/IntegerDigits"], 
          "FrobeniusSolve" :> 
          Documentation`HelpLookup["paclet:ref/FrobeniusSolve"], 
          "PowersRepresentations" :> 
          Documentation`HelpLookup["paclet:ref/PowersRepresentations"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"PartitionsP\"\>", 
       2->"\<\"Divisors\"\>", 3->"\<\"Subsets\"\>", 
       4->"\<\"IntegerDigits\"\>", 5->"\<\"FrobeniusSolve\"\>", 
       6->"\<\"PowersRepresentations\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Diophantine Equations" :> 
          Documentation`HelpLookup["paclet:guide/DiophantineEquations"], 
          "Discrete Mathematics" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteMathematics"], 
          "Integer Functions" :> 
          Documentation`HelpLookup["paclet:guide/IntegerFunctions"], 
          "Number Theoretic Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheoreticFunctions"], 
          "Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"], 
          "New in 6.0: Number Theory & Integer Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Diophantine Equations\"\>", 
       2->"\<\"Discrete Mathematics\"\>", 3->"\<\"Integer Functions\"\>", 
       4->"\<\"Number Theoretic Functions\"\>", 5->"\<\"Number Theory\"\>", 
       6->"\<\"New in 6.0: Mathematics & Algorithms\"\>", 
       7->"\<\"New in 6.0: Number Theory & Integer Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["IntegerPartitions", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["IntegerPartitions",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/IntegerPartitions"], "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of all possible ways to partition the \
integer ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " into smaller integers. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["IntegerPartitions",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/IntegerPartitions"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives partitions into at most ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     " integers. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["IntegerPartitions",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/IntegerPartitions"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        RowBox[{"{", 
         StyleBox["k", "TI"], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives partitions into exactly ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     " integers. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["IntegerPartitions",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/IntegerPartitions"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["k", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["k", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives partitions into between ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["k", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["k", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     " integers. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["IntegerPartitions",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/IntegerPartitions"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["kspec", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["s", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["s", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives partitions involving only the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["s", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->19910]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Results from ",
 Cell[BoxData[
  ButtonBox["IntegerPartitions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerPartitions"]], "InlineFormula"],
 " are normally given in reverse lexicographic order."
}], "Notes",
 CellID->19851],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Length",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Length"], "[", 
   RowBox[{"IntegerPartitions", "[", 
    StyleBox["n", "TI"], "]"}], "]"}]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PartitionsP",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PartitionsP"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31524],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["IntegerPartitions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerPartitions"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["IntegerPartitions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerPartitions"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->9976],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["s", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " can be rational numbers, and can be negative. "
}], "Notes",
 CellID->7439],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " can be a rational number if the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["s", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are rational numbers. "
}], "Notes",
 CellID->18371],

Cell[TextData[{
 "In the list of partitions, those involving earlier ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["s", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are given last. "
}], "Notes",
 CellID->29614]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->210749190],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->4716204],

Cell["All partitions of 5:", "ExampleText",
 CellID->51090020],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerPartitions", "[", "5", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16411],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "5", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{469, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->799091273]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28587],

Cell["Partitions of 8 into at most 3 integers:", "ExampleText",
 CellID->28026753],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerPartitions", "[", 
  RowBox[{"8", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->85821813],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "8", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{584, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12698996]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->47258070],

Cell["Partitions of 8 into exactly 3 integers:", "ExampleText",
 CellID->592408417],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerPartitions", "[", 
  RowBox[{"8", ",", 
   RowBox[{"{", "3", "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->51038783],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"6", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3", ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{350, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14069349]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->139858616],

Cell["Find all partitions of 8 that involve only 1, 2 and 5:", "ExampleText",
 CellID->28236487],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerPartitions", "[", 
  RowBox[{"8", ",", "All", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->357279635],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "2", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
     "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{431, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30853318]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22222],

Cell["Find ways to form 3 from combinations of rational numbers:", \
"ExampleText",
 CellID->140744245],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerPartitions", "[", 
  RowBox[{"3", ",", "10", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"1", "/", "3"}], ",", 
     RowBox[{"3", "/", "4"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->478714437],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     FractionBox["3", "4"], ",", 
     FractionBox["3", "4"], ",", 
     FractionBox["3", "4"], ",", 
     FractionBox["3", "4"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "3"], ",", 
     FractionBox["1", "3"], ",", 
     FractionBox["1", "3"], ",", 
     FractionBox["1", "3"], ",", 
     FractionBox["1", "3"], ",", 
     FractionBox["1", "3"], ",", 
     FractionBox["1", "3"], ",", 
     FractionBox["1", "3"], ",", 
     FractionBox["1", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "3"], ",", 
     FractionBox["1", "3"], ",", 
     FractionBox["1", "3"], ",", 
     FractionBox["1", "3"], ",", 
     FractionBox["1", "3"], ",", 
     FractionBox["1", "3"], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["1", "3"], ",", 
     FractionBox["1", "3"], ",", 
     FractionBox["1", "3"], ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{359, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->310135110]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->401335168],

Cell["Find partitions involving negative numbers:", "ExampleText",
 CellID->300044630],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerPartitions", "[", 
  RowBox[{"5", ",", "10", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3508859],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", 
     ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", 
     ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{454, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->123278231]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2957],

Cell["\<\
Find the ways to make change for 156 cents with 10 or fewer standard coins:\
\>", "ExampleText",
 CellID->462441892],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerPartitions", "[", 
  RowBox[{"156", ",", "10", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5", ",", "10", ",", "25"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->210018802],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "25", ",", "25", ",", "25", ",", "25", ",", "25", ",", "25", ",", "5", 
     ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "25", ",", "25", ",", "25", ",", "25", ",", "25", ",", "10", ",", "10", 
     ",", "10", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "25", ",", "25", ",", "25", ",", "25", ",", "25", ",", "10", ",", "10", 
     ",", "5", ",", "5", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{486, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->801827652]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->794268302],

Cell["Find \"McNugget partitions\" for 50:", "ExampleText",
 CellID->530304898],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerPartitions", "[", 
  RowBox[{"50", ",", "All", ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "9", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->265422514],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"20", ",", "9", ",", "9", ",", "6", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "6", ",", "6", ",", "6", ",", "6", ",", "6"}], "}"}]}],
   "}"}]], "Output",
 ImageSize->{249, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->598178446]
}, Open  ]],

Cell["\<\
Find the number of \"McNugget partitions\" for numbers up to 50:\
\>", "ExampleText",
 CellID->621398690],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Length", "[", 
    RowBox[{"IntegerPartitions", "[", 
     RowBox[{"i", ",", "All", ",", 
      RowBox[{"{", 
       RowBox[{"6", ",", "9", ",", "20"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "50"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->138226215],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", 
   ",", "1", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "1", ",", 
   "0", ",", "0", ",", "2", ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", 
   ",", "2", ",", "0", ",", "1", ",", "2", ",", "0", ",", "1", ",", "2", ",", 
   "0", ",", "1", ",", "2", ",", "0", ",", "1", ",", "3", ",", "0", ",", "2", 
   ",", "2", ",", "1", ",", "1", ",", "3", ",", "0", ",", "2", ",", "3", ",", 
   "1", ",", "2", ",", "3", ",", "1", ",", "2"}], "}"}]], "Output",
 ImageSize->{480, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->8524236]
}, Open  ]],

Cell["Show integers that are not \"McNuggetable\":", "ExampleText",
 CellID->348986608],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Position", "[", 
   RowBox[{"%", ",", "0"}], "]"}], "//", "Flatten"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->286755236],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "7", ",", "8", ",", "10", 
   ",", "11", ",", "13", ",", "14", ",", "16", ",", "17", ",", "19", ",", 
   "22", ",", "23", ",", "25", ",", "28", ",", "31", ",", "34", ",", "37", 
   ",", "43"}], "}"}]], "Output",
 ImageSize->{512, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->336093327]
}, Open  ]],

Cell["The last case is exactly the corresponding Frobenius number:", \
"ExampleText",
 CellID->183237632],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FrobeniusNumber", "[", 
  RowBox[{"{", 
   RowBox[{"6", ",", "9", ",", "20"}], "}"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->253000454],

Cell[BoxData["43"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->143263567]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21173],

Cell["Each sublist adds up to the original number:", "ExampleText",
 CellID->493099459],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerPartitions", "[", "4", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->36437367],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "4", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{296, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->219512251]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "/@", "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->950940723],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "4", ",", "4", ",", "4", ",", "4"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->527894405]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->291080728],

Cell[TextData[{
 "The length of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["IntegerPartitions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerPartitions"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PartitionsP",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PartitionsP"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->300469166],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"IntegerPartitions", "[", "10", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->564819999],

Cell[BoxData["42"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->133537412]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PartitionsP", "[", "10", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->445625143],

Cell[BoxData["42"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->374553647]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5150706],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["IntegerPartitions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerPartitions"]], "InlineFormula"],
 " gives results in reverse lexicographic order, not ",
 Cell[BoxData[
  ButtonBox["Sort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sort"]], "InlineFormula"],
 " order:"
}], "ExampleText",
 CellID->242496389],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerPartitions", "[", "5", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->314337893],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "5", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{469, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->947999022]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->192973907],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "5", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{469, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->64086377]
}, Open  ]],

Cell[TextData[{
 "For integers below 10, generate ",
 Cell[BoxData[
  ButtonBox["IntegerPartitions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerPartitions"]], "InlineFormula"],
 " order by converting to strings:"
}], "ExampleText",
 CellID->242796394],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reverse", "[", 
  RowBox[{"Sort", "[", 
   RowBox[{"ToString", "/@", 
    RowBox[{"IntegerPartitions", "[", "5", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->464812526],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"{5}\"\>", ",", "\<\"{4, 1}\"\>", ",", "\<\"{3, 2}\"\>", 
   ",", "\<\"{3, 1, 1}\"\>", ",", "\<\"{2, 2, 1}\"\>", 
   ",", "\<\"{2, 1, 1, 1}\"\>", ",", "\<\"{1, 1, 1, 1, 1}\"\>"}], 
  "}"}]], "Output",
 ImageSize->{506, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->468532202]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->279376140],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FrobeniusSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrobeniusSolve"]], "InlineFormula"],
 " gives coefficient lists for ",
 Cell[BoxData[
  ButtonBox["IntegerPartitions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerPartitions"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->536202180],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FrobeniusSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"6", ",", "9", ",", "20"}], "}"}], ",", "24"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32961858],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->202703743]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerPartitions", "[", 
  RowBox[{"24", ",", "All", ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "9", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->527297470],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"9", ",", "9", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "6", ",", "6", ",", "6"}], "}"}]}], "}"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->195337342]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->564],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["IntegerPartitions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerPartitions"]], "InlineFormula"],
 " cannot give an infinite list of partitions:"
}], "ExampleText",
 CellID->170241575],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerPartitions", "[", 
  RowBox[{"5", ",", "All", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6395087],

Cell[BoxData[
 RowBox[{
  RowBox[{"IntegerPartitions", "::", "\<\"undef\"\>"}], ":", 
  " ", "\<\"\\!\\(IntegerPartitions[\\(\\(5, All, \\(\\({1, \
\\(\\(-1\\)\\)}\\)\\)\\)\\)]\\) contains partitions that are undefined \
because they are infinitely large.\"\>"}]], "Message", "MSG",
 CellID->130306450],

Cell[BoxData[
 RowBox[{"IntegerPartitions", "[", 
  RowBox[{"5", ",", "All", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "]"}]], "Output",
 ImageSize->{235, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->329077939]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerPartitions", "[", 
  RowBox[{"5", ",", "10", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->99516236],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", 
     ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", 
     ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{454, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->421084764]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18321],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PartitionsP",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PartitionsP"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Divisors",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Divisors"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Subsets",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subsets"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerDigits",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerDigits"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FrobeniusSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrobeniusSolve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PowersRepresentations",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PowersRepresentations"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25310]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13062],

Cell[TextData[ButtonBox["Integer and Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->17318]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with IntegerPartitions",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=\
IntegerPartitions"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->372205044],

Cell[TextData[ButtonBox["Diophantine Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiophantineEquations"]], "MoreAbout",
 CellID->458397979],

Cell[TextData[ButtonBox["Discrete Mathematics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "MoreAbout",
 CellID->658101885],

Cell[TextData[ButtonBox["Integer Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegerFunctions"]], "MoreAbout",
 CellID->630286976],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "MoreAbout",
 CellID->675417753],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->447954652],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->282944106],

Cell[TextData[ButtonBox["New in 6.0: Number Theory & Integer Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]], "MoreAbout",
 CellID->8704769]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"IntegerPartitions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 49, 10.5560542}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "IntegerPartitions[n] gives a list of all possible ways to partition the \
integer n into smaller integers. IntegerPartitions[n, k] gives partitions \
into at most k integers. IntegerPartitions[n, {k}] gives partitions into \
exactly k integers. IntegerPartitions[n, {k_min, k_max}] gives partitions \
into between k_min and k_max integers. IntegerPartitions[n, kspec, {s_1, s_2, \
...}] gives partitions involving only the s_i. ", 
    "synonyms" -> {"integer partitions"}, "title" -> "IntegerPartitions", 
    "type" -> "Symbol", "uri" -> "ref/IntegerPartitions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11306, 350, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->210749190]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 39201, 1398}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3426, 75, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4049, 102, 1582, 37, 70, "ObjectNameGrid"],
Cell[5634, 141, 3164, 101, 70, "Usage",
 CellID->19910]
}, Open  ]],
Cell[CellGroupData[{
Cell[8835, 247, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9313, 264, 254, 8, 70, "Notes",
 CellID->19851],
Cell[9570, 274, 447, 17, 70, "Notes",
 CellID->31524],
Cell[10020, 293, 550, 20, 70, "Notes",
 CellID->9976],
Cell[10573, 315, 203, 8, 70, "Notes",
 CellID->7439],
Cell[10779, 325, 266, 10, 70, "Notes",
 CellID->18371],
Cell[11048, 337, 221, 8, 70, "Notes",
 CellID->29614]
}, Closed]],
Cell[CellGroupData[{
Cell[11306, 350, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->210749190],
Cell[CellGroupData[{
Cell[11691, 364, 146, 5, 70, "ExampleSection",
 CellID->4716204],
Cell[11840, 371, 62, 1, 70, "ExampleText",
 CellID->51090020],
Cell[CellGroupData[{
Cell[11927, 376, 109, 3, 28, "Input",
 CellID->16411],
Cell[12039, 381, 645, 21, 36, "Output",
 CellID->799091273]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12733, 408, 216, 7, 70, "ExampleSection",
 CellID->28587],
Cell[12952, 417, 82, 1, 70, "ExampleText",
 CellID->28026753],
Cell[CellGroupData[{
Cell[13059, 422, 135, 4, 70, "Input",
 CellID->85821813],
Cell[13197, 428, 798, 26, 36, "Output",
 CellID->12698996]
}, Open  ]],
Cell[14010, 457, 124, 3, 70, "ExampleDelimiter",
 CellID->47258070],
Cell[14137, 462, 83, 1, 70, "ExampleText",
 CellID->592408417],
Cell[CellGroupData[{
Cell[14245, 467, 159, 5, 70, "Input",
 CellID->51038783],
Cell[14407, 474, 528, 17, 36, "Output",
 CellID->14069349]
}, Open  ]],
Cell[14950, 494, 125, 3, 70, "ExampleDelimiter",
 CellID->139858616],
Cell[15078, 499, 96, 1, 70, "ExampleText",
 CellID->28236487],
Cell[CellGroupData[{
Cell[15199, 504, 207, 6, 70, "Input",
 CellID->357279635],
Cell[15409, 512, 846, 25, 54, "Output",
 CellID->30853318]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16304, 543, 239, 7, 70, "ExampleSection",
 CellID->22222],
Cell[16546, 552, 103, 2, 70, "ExampleText",
 CellID->140744245],
Cell[CellGroupData[{
Cell[16674, 558, 258, 8, 70, "Input",
 CellID->478714437],
Cell[16935, 568, 1187, 39, 81, "Output",
 CellID->310135110]
}, Open  ]],
Cell[18137, 610, 125, 3, 70, "ExampleDelimiter",
 CellID->401335168],
Cell[18265, 615, 86, 1, 70, "ExampleText",
 CellID->300044630],
Cell[CellGroupData[{
Cell[18376, 620, 215, 7, 70, "Input",
 CellID->3508859],
Cell[18594, 629, 589, 19, 36, "Output",
 CellID->123278231]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19232, 654, 222, 7, 70, "ExampleSection",
 CellID->2957],
Cell[19457, 663, 126, 3, 70, "ExampleText",
 CellID->462441892],
Cell[CellGroupData[{
Cell[19608, 670, 220, 6, 70, "Input",
 CellID->210018802],
Cell[19831, 678, 625, 19, 54, "Output",
 CellID->801827652]
}, Open  ]],
Cell[20471, 700, 125, 3, 70, "ExampleDelimiter",
 CellID->794268302],
Cell[20599, 705, 79, 1, 70, "ExampleText",
 CellID->530304898],
Cell[CellGroupData[{
Cell[20703, 710, 209, 6, 70, "Input",
 CellID->265422514],
Cell[20915, 718, 377, 12, 36, "Output",
 CellID->598178446]
}, Open  ]],
Cell[21307, 733, 115, 3, 70, "ExampleText",
 CellID->621398690],
Cell[CellGroupData[{
Cell[21447, 740, 358, 11, 70, "Input",
 CellID->138226215],
Cell[21808, 753, 709, 14, 54, "Output",
 CellID->8524236]
}, Open  ]],
Cell[22532, 770, 87, 1, 70, "ExampleText",
 CellID->348986608],
Cell[CellGroupData[{
Cell[22644, 775, 158, 5, 70, "Input",
 CellID->286755236],
Cell[22805, 782, 434, 11, 36, "Output",
 CellID->336093327]
}, Open  ]],
Cell[23254, 796, 105, 2, 70, "ExampleText",
 CellID->183237632],
Cell[CellGroupData[{
Cell[23384, 802, 169, 5, 70, "Input",
 CellID->253000454],
Cell[23556, 809, 159, 5, 36, "Output",
 CellID->143263567]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23764, 820, 233, 7, 70, "ExampleSection",
 CellID->21173],
Cell[24000, 829, 87, 1, 70, "ExampleText",
 CellID->493099459],
Cell[CellGroupData[{
Cell[24112, 834, 112, 3, 70, "Input",
 CellID->36437367],
Cell[24227, 839, 484, 16, 36, "Output",
 CellID->219512251]
}, Open  ]],
Cell[CellGroupData[{
Cell[24748, 860, 97, 3, 70, "Input",
 CellID->950940723],
Cell[24848, 865, 233, 7, 36, "Output",
 CellID->527894405]
}, Open  ]],
Cell[25096, 875, 125, 3, 70, "ExampleDelimiter",
 CellID->291080728],
Cell[25224, 880, 451, 17, 70, "ExampleText",
 CellID->300469166],
Cell[CellGroupData[{
Cell[25700, 901, 147, 4, 70, "Input",
 CellID->564819999],
Cell[25850, 907, 159, 5, 36, "Output",
 CellID->133537412]
}, Open  ]],
Cell[CellGroupData[{
Cell[26046, 917, 108, 3, 70, "Input",
 CellID->445625143],
Cell[26157, 922, 159, 5, 36, "Output",
 CellID->374553647]
}, Open  ]],
Cell[26331, 930, 123, 3, 70, "ExampleDelimiter",
 CellID->5150706],
Cell[26457, 935, 369, 12, 70, "ExampleText",
 CellID->242496389],
Cell[CellGroupData[{
Cell[26851, 951, 113, 3, 70, "Input",
 CellID->314337893],
Cell[26967, 956, 645, 21, 36, "Output",
 CellID->947999022]
}, Open  ]],
Cell[CellGroupData[{
Cell[27649, 982, 100, 3, 70, "Input",
 CellID->192973907],
Cell[27752, 987, 644, 21, 36, "Output",
 CellID->64086377]
}, Open  ]],
Cell[28411, 1011, 264, 8, 70, "ExampleText",
 CellID->242796394],
Cell[CellGroupData[{
Cell[28700, 1023, 212, 6, 70, "Input",
 CellID->464812526],
Cell[28915, 1031, 374, 10, 36, "Output",
 CellID->468532202]
}, Open  ]],
Cell[29304, 1044, 125, 3, 70, "ExampleDelimiter",
 CellID->279376140],
Cell[29432, 1049, 361, 12, 70, "ExampleText",
 CellID->536202180],
Cell[CellGroupData[{
Cell[29818, 1065, 193, 6, 70, "Input",
 CellID->32961858],
Cell[30014, 1073, 322, 11, 36, "Output",
 CellID->202703743]
}, Open  ]],
Cell[CellGroupData[{
Cell[30373, 1089, 209, 6, 70, "Input",
 CellID->527297470],
Cell[30585, 1097, 332, 11, 36, "Output",
 CellID->195337342]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30966, 1114, 224, 7, 70, "ExampleSection",
 CellID->564],
Cell[31193, 1123, 239, 7, 70, "ExampleText",
 CellID->170241575],
Cell[CellGroupData[{
Cell[31457, 1134, 216, 7, 70, "Input",
 CellID->6395087],
Cell[31676, 1143, 302, 6, 70, "Message",
 CellID->130306450],
Cell[31981, 1151, 307, 10, 36, "Output",
 CellID->329077939]
}, Open  ]],
Cell[CellGroupData[{
Cell[32325, 1166, 216, 7, 70, "Input",
 CellID->99516236],
Cell[32544, 1175, 589, 19, 36, "Output",
 CellID->421084764]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[33194, 1201, 311, 9, 70, "SeeAlsoSection",
 CellID->18321],
Cell[33508, 1212, 1483, 53, 70, "SeeAlso",
 CellID->25310]
}, Open  ]],
Cell[CellGroupData[{
Cell[35028, 1270, 314, 9, 70, "TutorialsSection",
 CellID->13062],
Cell[35345, 1281, 188, 4, 70, "Tutorials",
 CellID->17318]
}, Open  ]],
Cell[CellGroupData[{
Cell[35570, 1290, 305, 8, 70, "RelatedLinksSection"],
Cell[35878, 1300, 376, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36291, 1317, 319, 9, 70, "MoreAboutSection",
 CellID->372205044],
Cell[36613, 1328, 153, 3, 70, "MoreAbout",
 CellID->458397979],
Cell[36769, 1333, 151, 3, 70, "MoreAbout",
 CellID->658101885],
Cell[36923, 1338, 145, 3, 70, "MoreAbout",
 CellID->630286976],
Cell[37071, 1343, 162, 3, 70, "MoreAbout",
 CellID->675417753],
Cell[37236, 1348, 137, 3, 70, "MoreAbout",
 CellID->447954652],
Cell[37376, 1353, 179, 3, 70, "MoreAbout",
 CellID->282944106],
Cell[37558, 1358, 196, 4, 70, "MoreAbout",
 CellID->8704769]
}, Open  ]],
Cell[37769, 1365, 27, 0, 70, "History"],
Cell[37799, 1367, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

