(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23618,        880]
NotebookOptionsPosition[     18333,        696]
NotebookOutlinePosition[     19637,        734]
CellTagsIndexPosition[     19552,        729]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Putting Constraints on Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PuttingConstraintsOnPatterns"], 
          "Types of Numbers" :> 
          Documentation`HelpLookup["paclet:tutorial/TypesOfNumbers"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Putting Constraints on Patterns\"\>", 
       2->"\<\"Types of Numbers\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EvenQ" :> Documentation`HelpLookup["paclet:ref/EvenQ"], "OddQ" :> 
          Documentation`HelpLookup["paclet:ref/OddQ"], "NumberQ" :> 
          Documentation`HelpLookup["paclet:ref/NumberQ"], "TrueQ" :> 
          Documentation`HelpLookup["paclet:ref/TrueQ"], "Element" :> 
          Documentation`HelpLookup["paclet:ref/Element"], "Integer" :> 
          Documentation`HelpLookup["paclet:ref/Integer"], "Integers" :> 
          Documentation`HelpLookup["paclet:ref/Integers"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"EvenQ\"\>", 2->"\<\"OddQ\"\>", 
       3->"\<\"NumberQ\"\>", 4->"\<\"TrueQ\"\>", 5->"\<\"Element\"\>", 
       6->"\<\"Integer\"\>", 7->"\<\"Integers\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Conditionals" :> 
          Documentation`HelpLookup["paclet:guide/Conditionals"], 
          "Numerical Evaluation & Precision" :> 
          Documentation`HelpLookup[
           "paclet:guide/NumericalEvaluationAndPrecision"], 
          "Numerical Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumericalFunctions"], 
          "Representation of Numbers" :> 
          Documentation`HelpLookup["paclet:guide/RepresentationOfNumbers"], 
          "Testing Expressions" :> 
          Documentation`HelpLookup["paclet:guide/TestingExpressions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Conditionals\"\>", 
       2->"\<\"Numerical Evaluation & Precision\"\>", 
       3->"\<\"Numerical Functions\"\>", 
       4->"\<\"Representation of Numbers\"\>", 
       5->"\<\"Testing Expressions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["IntegerQ", "ObjectName",
 CellID->20377],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["IntegerQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/IntegerQ"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is an integer, and ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->763]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["IntegerQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerQ"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " unless ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is manifestly an integer (i.e., has head ",
 Cell[BoxData[
  ButtonBox["Integer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integer"]], "InlineFormula"],
 "). "
}], "Notes",
 CellID->9938],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Simplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Simplify"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], "\[Element]", 
    ButtonBox["Integers",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Integers"]}], "]"}]], "InlineFormula"],
 " can be used to try to determine whether an expression is mathematically \
equal to an integer. "
}], "Notes",
 CellID->4937]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->493053119],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->562952412],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["IntegerQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerQ"]], "InlineFormula"],
 " tests whether an expression is explicitly an integer:"
}], "ExampleText",
 CellID->56298805],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerQ", "[", "4", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->54835718],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->188145967]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerQ", "[", 
  RowBox[{"4", "+", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->174712197],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->118350163]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->59154058],

Cell["Test whether an array consists of all integers:", "ExampleText",
 CellID->115975965],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9", ",", "16"}], "}"}]}], "}"}], ",", "_", ",", "IntegerQ"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8042718],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->183056871]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", "4."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"9.", ",", "16."}], "}"}]}], "}"}], ",", "_", ",", "IntegerQ"}],
   "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->53610637],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->97355336]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->367619658],

Cell["Make a test for Gaussian integers:", "ExampleText",
 CellID->565934224],

Cell[BoxData[
 RowBox[{
  RowBox[{"gaussIntegerQ", "[", "x_", "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{"IntegerQ", "[", 
    RowBox[{"Re", "[", "x", "]"}], "]"}], " ", "&&", " ", 
   RowBox[{"IntegerQ", "[", 
    RowBox[{"Im", "[", "x", "]"}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->172904380],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gaussIntegerQ", "[", 
  RowBox[{"1", " ", "+", " ", 
   RowBox[{"2", " ", "I"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->88627904],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->115877600]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->95896583],

Cell[TextData[{
 "Integers have ",
 Cell[BoxData[
  ButtonBox["Head",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Head"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  ButtonBox["Integer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integer"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->397682388],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", " ", "8529050985092184098210948213048204809218402184"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->144159103],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"IntegerQ", "[", "x", "]"}], ",", 
   RowBox[{"Head", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->187506408],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "Integer"}], "}"}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->64430089]
}, Open  ]],

Cell[TextData[{
 "The pure",
 Cell[BoxData[
  RowBox[{" ", 
   ButtonBox["Function",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Function"]}]], "InlineFormula"],
 " ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["MatchQ",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MatchQ"], "[", 
    RowBox[{"#", ",", "_Integer"}], "]"}], "&"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  ButtonBox["IntegerQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerQ"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->74667697],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatchQ", "[", 
  RowBox[{"x", ",", "_Integer"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->93087454],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->121280577]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6105563],

Cell[TextData[{
 "Expressions that represent integers, but do not evaluate to integers \
explicitly will still give ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->300119677],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{"GoldenRatio", "-", 
    RowBox[{"1", "/", "GoldenRatio"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->330060467],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerQ", "[", "x", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->236245029],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->62672617]
}, Open  ]],

Cell["It is necessary to use symbolic simplification first:", "ExampleText",
 CellID->8565680],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "x", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->49119008],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->25345996]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12958],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["EvenQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EvenQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OddQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OddQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrueQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrueQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Element",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Element"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Integer",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integer"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Integers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integers"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11183]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20510],

Cell[TextData[ButtonBox["Putting Constraints on Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PuttingConstraintsOnPatterns"]], "Tutorials",
 CellID->13409],

Cell[TextData[ButtonBox["Types of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TypesOfNumbers"]], "Tutorials",
 CellID->4864]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->179155581],

Cell[TextData[ButtonBox["Conditionals",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Conditionals"]], "MoreAbout",
 CellID->7468051],

Cell[TextData[ButtonBox["Numerical Evaluation & Precision",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalEvaluationAndPrecision"]], "MoreAbout",
 CellID->344508315],

Cell[TextData[ButtonBox["Numerical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalFunctions"]], "MoreAbout",
 CellID->577484189],

Cell[TextData[ButtonBox["Representation of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RepresentationOfNumbers"]], "MoreAbout",
 CellID->36595535],

Cell[TextData[ButtonBox["Testing Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TestingExpressions"]], "MoreAbout",
 CellID->597908555]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with IntegerQ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=IntegerQ"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
IntegerQ"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"IntegerQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 49, 12.1967212}", "context" -> "System`", 
    "keywords" -> {
     "testing for integers", "testing for natural numbers", 
      "testing for whole numbers"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "IntegerQ[expr] gives True if expr is an integer, and False otherwise. ", 
    "synonyms" -> {"integer q"}, "title" -> "IntegerQ", "type" -> "Symbol", 
    "uri" -> "ref/IntegerQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6186, 191, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->493053119]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19409, 722}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3099, 68, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3722, 95, 46, 1, 70, "ObjectName",
 CellID->20377],
Cell[3771, 98, 836, 28, 70, "Usage",
 CellID->763]
}, Open  ]],
Cell[CellGroupData[{
Cell[4644, 131, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5122, 148, 587, 22, 70, "Notes",
 CellID->9938],
Cell[5712, 172, 437, 14, 70, "Notes",
 CellID->4937]
}, Closed]],
Cell[CellGroupData[{
Cell[6186, 191, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->493053119],
Cell[CellGroupData[{
Cell[6571, 205, 148, 5, 70, "ExampleSection",
 CellID->562952412],
Cell[6722, 212, 230, 7, 70, "ExampleText",
 CellID->56298805],
Cell[CellGroupData[{
Cell[6977, 223, 103, 3, 28, "Input",
 CellID->54835718],
Cell[7083, 228, 161, 5, 36, "Output",
 CellID->188145967]
}, Open  ]],
Cell[CellGroupData[{
Cell[7281, 238, 127, 4, 28, "Input",
 CellID->174712197],
Cell[7411, 244, 162, 5, 36, "Output",
 CellID->118350163]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7622, 255, 226, 7, 70, "ExampleSection",
 CellID->59154058],
Cell[7851, 264, 90, 1, 70, "ExampleText",
 CellID->115975965],
Cell[CellGroupData[{
Cell[7966, 269, 299, 11, 70, "Input",
 CellID->8042718],
Cell[8268, 282, 161, 5, 36, "Output",
 CellID->183056871]
}, Open  ]],
Cell[CellGroupData[{
Cell[8466, 292, 304, 11, 70, "Input",
 CellID->53610637],
Cell[8773, 305, 161, 5, 36, "Output",
 CellID->97355336]
}, Open  ]],
Cell[8949, 313, 125, 3, 70, "ExampleDelimiter",
 CellID->367619658],
Cell[9077, 318, 77, 1, 70, "ExampleText",
 CellID->565934224],
Cell[9157, 321, 312, 9, 70, "Input",
 CellID->172904380],
Cell[CellGroupData[{
Cell[9494, 334, 165, 5, 70, "Input",
 CellID->88627904],
Cell[9662, 341, 161, 5, 36, "Output",
 CellID->115877600]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9872, 352, 236, 7, 70, "ExampleSection",
 CellID->95896583],
Cell[10111, 361, 312, 13, 70, "ExampleText",
 CellID->397682388],
Cell[10426, 376, 163, 5, 70, "Input",
 CellID->144159103],
Cell[CellGroupData[{
Cell[10614, 385, 183, 6, 70, "Input",
 CellID->187506408],
Cell[10800, 393, 212, 7, 36, "Output",
 CellID->64430089]
}, Open  ]],
Cell[11027, 403, 559, 22, 70, "ExampleText",
 CellID->74667697],
Cell[CellGroupData[{
Cell[11611, 429, 131, 4, 70, "Input",
 CellID->93087454],
Cell[11745, 435, 161, 5, 36, "Output",
 CellID->121280577]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11955, 446, 228, 7, 70, "ExampleSection",
 CellID->6105563],
Cell[12186, 455, 275, 9, 70, "ExampleText",
 CellID->300119677],
Cell[12464, 466, 179, 6, 70, "Input",
 CellID->330060467],
Cell[CellGroupData[{
Cell[12668, 476, 104, 3, 70, "Input",
 CellID->236245029],
Cell[12775, 481, 161, 5, 36, "Output",
 CellID->62672617]
}, Open  ]],
Cell[12951, 489, 94, 1, 70, "ExampleText",
 CellID->8565680],
Cell[CellGroupData[{
Cell[13070, 494, 107, 3, 70, "Input",
 CellID->49119008],
Cell[13180, 499, 157, 5, 36, "Output",
 CellID->25345996]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13398, 511, 311, 9, 70, "SeeAlsoSection",
 CellID->12958],
Cell[13712, 522, 1650, 62, 70, "SeeAlso",
 CellID->11183]
}, Open  ]],
Cell[CellGroupData[{
Cell[15399, 589, 314, 9, 70, "TutorialsSection",
 CellID->20510],
Cell[15716, 600, 170, 3, 70, "Tutorials",
 CellID->13409],
Cell[15889, 605, 140, 3, 70, "Tutorials",
 CellID->4864]
}, Open  ]],
Cell[CellGroupData[{
Cell[16066, 613, 319, 9, 70, "MoreAboutSection",
 CellID->179155581],
Cell[16388, 624, 134, 3, 70, "MoreAbout",
 CellID->7468051],
Cell[16525, 629, 175, 3, 70, "MoreAbout",
 CellID->344508315],
Cell[16703, 634, 149, 3, 70, "MoreAbout",
 CellID->577484189],
Cell[16855, 639, 159, 3, 70, "MoreAbout",
 CellID->36595535],
Cell[17017, 644, 149, 3, 70, "MoreAbout",
 CellID->597908555]
}, Open  ]],
Cell[CellGroupData[{
Cell[17203, 652, 305, 8, 70, "RelatedLinksSection"],
Cell[17511, 662, 361, 12, 70, "RelatedLinks"],
Cell[17875, 676, 386, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[18276, 692, 27, 0, 70, "History"],
Cell[18306, 694, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

