(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23828,        817]
NotebookOptionsPosition[     18717,        653]
NotebookOutlinePosition[     20488,        696]
CellTagsIndexPosition[     20403,        691]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"IntegerDigits" :> 
          Documentation`HelpLookup["paclet:ref/IntegerDigits"], 
          "IntegerLength" :> 
          Documentation`HelpLookup["paclet:ref/IntegerLength"], "RealDigits" :> 
          Documentation`HelpLookup["paclet:ref/RealDigits"], "BaseForm" :> 
          Documentation`HelpLookup["paclet:ref/BaseForm"], "NumberForm" :> 
          Documentation`HelpLookup["paclet:ref/NumberForm"], "FromDigits" :> 
          Documentation`HelpLookup["paclet:ref/FromDigits"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"IntegerDigits\"\>", 
       2->"\<\"IntegerLength\"\>", 3->"\<\"RealDigits\"\>", 
       4->"\<\"BaseForm\"\>", 5->"\<\"NumberForm\"\>", 
       6->"\<\"FromDigits\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Converting between Expressions & Strings" :> 
          Documentation`HelpLookup[
           "paclet:guide/ConvertingBetweenExpressionsAndStrings"], 
          "Number Digits" :> 
          Documentation`HelpLookup["paclet:guide/NumberDigits"], 
          "New in 6.0: Core Language" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60CoreLanguage"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"], 
          "New in 6.0: Number Theory & Integer Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Converting between Expressions & Strings\"\>", 
       2->"\<\"Number Digits\"\>", 3->"\<\"New in 6.0: Core Language\"\>", 
       4->"\<\"New in 6.0: Mathematics & Algorithms\"\>", 
       5->"\<\"New in 6.0: Number Theory & Integer Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["IntegerString", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["IntegerString",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/IntegerString"], "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a string consisting of the decimal digits in the \
integer ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["IntegerString",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/IntegerString"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a string consisting of the base ",
     Cell[BoxData[
      FormBox["b", TraditionalForm]], "InlineMath"],
     " digits in the integer ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["IntegerString",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/IntegerString"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["b", "TI"], ",", 
        StyleBox["len", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]pads the string on the left with zero digits to give a \
string of length ",
     Cell[BoxData[
      StyleBox["len", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["IntegerString",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/IntegerString"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", "\"\<Roman\>\""}], "]"}]], "InlineFormula"],
     
     "\[LineSeparator]gives the Roman numeral form of ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->26219]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The maximum allowed base is 36. For bases larger than 10, additional digits \
are chosen from the letters ",
 Cell[BoxData["a"], "InlineFormula"],
 "\[Dash]",
 Cell[BoxData["z"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->14838],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["len", "TI"]], "InlineFormula"],
 " is less than the number of digits in ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " then the ",
 Cell[BoxData[
  StyleBox["len", "TI"]], "InlineFormula"],
 " least significant digits are returned. "
}], "Notes",
 CellID->20642],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FromDigits",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FromDigits"]], "InlineFormula"],
 " can be used as the inverse of ",
 Cell[BoxData[
  ButtonBox["IntegerString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerString"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->25265]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->137225351],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->112324324],

Cell["Convert to binary, giving the result as a string:", "ExampleText",
 CellID->652364120],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"IntegerString", "[", 
   RowBox[{"17651", ",", "2"}], "]"}], "//", "InputForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->567725321],

Cell["\"100010011110011\"", "Output",
 ImageSize->{119, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//InputForm=",
 CellID->442372096]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->845505880],

Cell["Convert to Roman numerals:", "ExampleText",
 CellID->66182985],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerString", "[", 
  RowBox[{"1988", ",", "\"\<Roman\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->350915190],

Cell[BoxData["\<\"MCMLXXXVIII\"\>"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->270280260]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["In base 16, a through f are used as digits:", "ExampleText",
 CellID->470037044],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerString", "[", 
  RowBox[{
   RowBox[{"50", "!"}], ",", "16"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->176494470],

Cell[BoxData["\<\"49eebc961ed279b02b1ef4f28d19a84f5973a1d2c7800000000000\"\>"]\
, "Output",
 ImageSize->{382, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->479498904]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1020263627],

Cell["The maximum base of 36 uses letters a through z:", "ExampleText",
 CellID->73843540],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerString", "[", 
  RowBox[{
   RowBox[{"50", "!"}], ",", "36"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->351381866],

Cell[BoxData["\<\"4q7eyp9zizmtqt0648txt4fm720cc1s00000000000\"\>"], "Output",
 ImageSize->{298, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->805679211]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ToUpperCase",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToUpperCase"]], "InlineFormula"],
 " converts to upper-case letters:"
}], "ExampleText",
 CellID->21781123],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerString", "[", 
  RowBox[{
   RowBox[{"50", "!"}], ",", "16"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70943904],

Cell[BoxData["\<\"49eebc961ed279b02b1ef4f28d19a84f5973a1d2c7800000000000\"\>"]\
, "Output",
 ImageSize->{382, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->629597945]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToUpperCase", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->143507566],

Cell[BoxData["\<\"49EEBC961ED279B02B1EF4F28D19A84F5973A1D2C7800000000000\"\>"]\
, "Output",
 ImageSize->{382, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->167799620]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->589267740],

Cell["Show a single number in successive bases from 2 to 36:", "ExampleText",
 CellID->139637016],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"IntegerString", "[", 
     RowBox[{
      RowBox[{"20", "!"}], ",", "n"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "2", ",", "36"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->121706092],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"10000111000011011001110111110010000010101101000000000000000000\"\>"}\
,
    {"\<\"121012122110010010112012202222100000000\"\>"},
    {"\<\"2013003121313302002231000000000\"\>"},
    {"\<\"130402040313000221204440000\"\>"},
    {"\<\"302523154413030400000000\"\>"},
    {"\<\"4233013654405404511500\"\>"},
    {"\<\"207033167620255000000\"\>"},
    {"\<\"17178403115182870000\"\>"},
    {"\<\"2432902008176640000\"\>"},
    {"\<\"48a465613446216aa0\"\>"},
    {"\<\"111aaa198400000000\"\>"},
    {"\<\"386b8c91c4a80cc40\"\>"},
    {"\<\"118d2d096b2393a00\"\>"},
    {"\<\"5851344680390000\"\>"},
    {"\<\"21c3677c82b40000\"\>"},
    {"\<\"e7ad44d9fg741b0\"\>"},
    {"\<\"68f15hag59a0000\"\>"},
    {"\<\"30g4092e8g5d0i0\"\>"},
    {"\<\"19dj81edhf40000\"\>"},
    {"\<\"fffd9kd0g5d600\"\>"},
    {"\<\"8d5eai80da92g0\"\>"},
    {"\<\"4j0935i8l806kb\"\>"},
    {"\<\"2iejj64l000000\"\>"},
    {"\<\"1fkakgf0c74o00\"\>"},
    {"\<\"pcm55b5bg8320\"\>"},
    {"\<\"g5hc33e5kq900\"\>"},
    {"\<\"ad9mdo45a5k00\"\>"},
    {"\<\"6pbpk5pq5hjeq\"\>"},
    {"\<\"4ha46ok4o0000\"\>"},
    {"\<\"32n98h5ioecuf\"\>"},
    {"\<\"23gr7fi1b8000\"\>"},
    {"\<\"1f4g8hfh5eui0\"\>"},
    {"\<\"10mhicwma0he0\"\>"},
    {"\<\"p6x99f2rya00\"\>"},
    {"\<\"ihfbs9340000\"\>"}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}}],
  "Column"]], "Output",
 ImageSize->{438, 523},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->474388172]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerDigits",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerDigits"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerLength",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerLength"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RealDigits",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RealDigits"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BaseForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BaseForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FromDigits",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FromDigits"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->107843627]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with IntegerString",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=IntegerString"],
     None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Converting between Expressions & Strings",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ConvertingBetweenExpressionsAndStrings"]], "MoreAbout",
 CellID->72892697],

Cell[TextData[ButtonBox["Number Digits",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberDigits"]], "MoreAbout",
 CellID->111556404],

Cell[TextData[ButtonBox["New in 6.0: Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60CoreLanguage"]], "MoreAbout",
 CellID->501913518],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->521796262],

Cell[TextData[ButtonBox["New in 6.0: Number Theory & Integer Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]], "MoreAbout",
 CellID->450170019]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"IntegerString - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 49, 16.1811982}", "context" -> "System`", 
    "keywords" -> {
     "binary numbers", "binary number system", "binary representation", 
      "convert number", "hexadecimal numbers", "hex digits", "hex values", 
      "number base", "octal numbers", "octal number system", "Roman numbers", 
      "Roman numerals", "StringInteger", "radix"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "IntegerString[n] gives a string consisting of the decimal digits in the \
integer n. IntegerString[n, b] gives a string consisting of the base b digits \
in the integer n. IntegerString[n, b, len] pads the string on the left with \
zero digits to give a string of length len. IntegerString[n, \"Roman\"] gives \
the Roman numeral form of n.", "synonyms" -> {"integer string"}, "title" -> 
    "IntegerString", "type" -> "Symbol", "uri" -> "ref/IntegerString"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8266, 249, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->137225351]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20260, 684}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2522, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3145, 81, 1578, 37, 70, "ObjectNameGrid"],
Cell[4726, 120, 2066, 66, 70, "Usage",
 CellID->26219]
}, Open  ]],
Cell[CellGroupData[{
Cell[6829, 191, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7307, 208, 249, 8, 70, "Notes",
 CellID->14838],
Cell[7559, 218, 329, 12, 70, "Notes",
 CellID->20642],
Cell[7891, 232, 338, 12, 70, "Notes",
 CellID->25265]
}, Closed]],
Cell[CellGroupData[{
Cell[8266, 249, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->137225351],
Cell[CellGroupData[{
Cell[8651, 263, 148, 5, 70, "ExampleSection",
 CellID->112324324],
Cell[8802, 270, 92, 1, 70, "ExampleText",
 CellID->652364120],
Cell[CellGroupData[{
Cell[8919, 275, 169, 5, 28, "Input",
 CellID->567725321],
Cell[9091, 282, 179, 5, 50, "Output",
 CellID->442372096]
}, Open  ]],
Cell[9285, 290, 125, 3, 70, "ExampleDelimiter",
 CellID->845505880],
Cell[9413, 295, 68, 1, 70, "ExampleText",
 CellID->66182985],
Cell[CellGroupData[{
Cell[9506, 300, 147, 4, 70, "Input",
 CellID->350915190],
Cell[9656, 306, 176, 5, 36, "Output",
 CellID->270280260]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9881, 317, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[10105, 326, 86, 1, 70, "ExampleText",
 CellID->470037044],
Cell[CellGroupData[{
Cell[10216, 331, 153, 5, 70, "Input",
 CellID->176494470],
Cell[10372, 338, 222, 6, 36, "Output",
 CellID->479498904]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10643, 350, 244, 7, 70, "ExampleSection",
 CellID->1020263627],
Cell[10890, 359, 90, 1, 70, "ExampleText",
 CellID->73843540],
Cell[CellGroupData[{
Cell[11005, 364, 153, 5, 70, "Input",
 CellID->351381866],
Cell[11161, 371, 208, 5, 36, "Output",
 CellID->805679211]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11418, 382, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[11659, 391, 214, 7, 70, "ExampleText",
 CellID->21781123],
Cell[CellGroupData[{
Cell[11898, 402, 152, 5, 70, "Input",
 CellID->70943904],
Cell[12053, 409, 222, 6, 36, "Output",
 CellID->629597945]
}, Open  ]],
Cell[CellGroupData[{
Cell[12312, 420, 107, 3, 70, "Input",
 CellID->143507566],
Cell[12422, 425, 222, 6, 36, "Output",
 CellID->167799620]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12693, 437, 228, 7, 70, "ExampleSection",
 CellID->589267740],
Cell[12924, 446, 97, 1, 70, "ExampleText",
 CellID->139637016],
Cell[CellGroupData[{
Cell[13046, 451, 311, 10, 70, "Input",
 CellID->121706092],
Cell[13360, 463, 1509, 45, 544, "Output",
 CellID->474388172]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14930, 515, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[15249, 526, 1467, 53, 70, "SeeAlso",
 CellID->107843627]
}, Open  ]],
Cell[CellGroupData[{
Cell[16753, 584, 305, 8, 70, "RelatedLinksSection"],
Cell[17061, 594, 371, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17469, 611, 299, 8, 70, "MoreAboutSection"],
Cell[17771, 621, 192, 4, 70, "MoreAbout",
 CellID->72892697],
Cell[17966, 627, 137, 3, 70, "MoreAbout",
 CellID->111556404],
Cell[18106, 632, 156, 3, 70, "MoreAbout",
 CellID->501913518],
Cell[18265, 637, 179, 3, 70, "MoreAbout",
 CellID->521796262],
Cell[18447, 642, 198, 4, 70, "MoreAbout",
 CellID->450170019]
}, Open  ]],
Cell[18660, 649, 27, 0, 70, "History"],
Cell[18690, 651, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

