(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     33960,       1257]
NotebookOptionsPosition[     27086,       1019]
NotebookOutlinePosition[     28447,       1058]
CellTagsIndexPosition[     28361,       1053]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Simplifying with Assumptions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SimplifyingWithAssumptions"], "Using Assumptions" :> 
          Documentation`HelpLookup["paclet:tutorial/UsingAssumptions"], 
          "Equations and Inequalities over Domains" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EquationsAndInequalitiesOverDomains"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Simplifying with Assumptions\"\>", 
       2->"\<\"Using Assumptions\"\>", 
       3->"\<\"Equations and Inequalities over Domains\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Element" :> Documentation`HelpLookup["paclet:ref/Element"], 
          "Simplify" :> Documentation`HelpLookup["paclet:ref/Simplify"], 
          "IntegerQ" :> Documentation`HelpLookup["paclet:ref/IntegerQ"], 
          "Reals" :> Documentation`HelpLookup["paclet:ref/Reals"], "Primes" :> 
          Documentation`HelpLookup["paclet:ref/Primes"], "Algebraics" :> 
          Documentation`HelpLookup["paclet:ref/Algebraics"], "Rationals" :> 
          Documentation`HelpLookup["paclet:ref/Rationals"], "Booleans" :> 
          Documentation`HelpLookup["paclet:ref/Booleans"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Element\"\>", 2->"\<\"Simplify\"\>",
        3->"\<\"IntegerQ\"\>", 4->"\<\"Reals\"\>", 5->"\<\"Primes\"\>", 
       6->"\<\"Algebraics\"\>", 7->"\<\"Rationals\"\>", 
       8->"\<\"Booleans\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Assumptions and Domains" :> 
          Documentation`HelpLookup["paclet:guide/AssumptionsAndDomains"], 
          "Formula Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/FormulaManipulation"], 
          "Number Recognition" :> 
          Documentation`HelpLookup["paclet:guide/NumberRecognition"], 
          "Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"], 
          "Polynomial Systems" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialSystems"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Assumptions and Domains\"\>",
        2->"\<\"Formula Manipulation\"\>", 3->"\<\"Number Recognition\"\>", 
       4->"\<\"Number Theory\"\>", 
       5->"\<\"Polynomial Systems\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Integers", "ObjectName",
 CellID->16039],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Integers",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Integers"]], "InlineFormula"],
     "\[LineSeparator]represents the domain of integers, as in ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], "\[Element]", "Integers"}]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16676]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "\[Element]", "Integers"}]], "InlineFormula"],
 " evaluates immediately only if ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is a numeric quantity. "
}], "Notes",
 CellID->2719],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Simplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Simplify"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], "\[Element]", "Integers"}], "]"}]], 
  "InlineFormula"],
 " can be used to try to determine whether an expression is an integer. "
}], "Notes",
 CellID->19535],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["IntegerQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerQ"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " tests only whether ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is manifestly an integer (i.e., has head ",
 Cell[BoxData[
  ButtonBox["Integer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integer"]], "InlineFormula"],
 "). "
}], "Notes",
 CellID->14858],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Integers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integers"]], "InlineFormula"],
 " is output in ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " as ",
 Cell[BoxData["\[DoubleStruckCapitalZ]"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28903]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->8232262],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->289019192],

Cell["7 is an integer:", "ExampleText",
 CellID->436130550],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Element", "[", 
  RowBox[{"7", ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->94897371],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->62442691]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->98498572],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " is an integer, so is ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{
     TagBox["\[Phi]",
      EulerPhi], "(", "n", ")"}], "3"], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->531594117],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Element", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"EulerPhi", "[", "n", "]"}], "^", "3"}], ",", "Integers"}], 
    "]"}], ",", 
   RowBox[{"Element", "[", 
    RowBox[{"n", ",", "Integers"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->111110433],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->89974573]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->902398367],

Cell["Find positive integer solutions of a Pell equation:", "ExampleText",
 CellID->311965230],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"2", 
       RowBox[{"y", "^", "2"}]}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"y", ">", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->269611568],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[GreaterEqual]", "1"}], "&&", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"3", "-", 
         RowBox[{"2", " ", 
          SqrtBox["2"]}]}], ")"}], 
       RowBox[{"C", "[", "1", "]"}]], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"3", "+", 
         RowBox[{"2", " ", 
          SqrtBox["2"]}]}], ")"}], 
       RowBox[{"C", "[", "1", "]"}]]}], ")"}]}]}], "&&", 
  RowBox[{"y", "\[Equal]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"3", "-", 
         RowBox[{"2", " ", 
          SqrtBox["2"]}]}], ")"}], 
       RowBox[{"C", "[", "1", "]"}]], "-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"3", "+", 
         RowBox[{"2", " ", 
          SqrtBox["2"]}]}], ")"}], 
       RowBox[{"C", "[", "1", "]"}]]}], 
     RowBox[{"2", " ", 
      SqrtBox["2"]}]]}]}]}]], "Output",
 ImageSize->{496, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->223611212]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->134533761],

Cell["Test domain membership of a numeric expression:  ", "ExampleText",
 CellID->186508013],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Element", "[", 
  RowBox[{"1234567", ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->150279975],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->143267790]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->140596962],

Cell["Make domain membership assumptions:", "ExampleText",
 CellID->24636061],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"n", " ", "Pi"}], "]"}], ",", 
   RowBox[{"Element", "[", 
    RowBox[{"n", ",", "Integers"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->144317606],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->324104903]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "n"}], "+", 
     RowBox[{"y", "^", "n"}]}], "\[Equal]", 
    RowBox[{"z", "^", "n"}]}], ",", 
   RowBox[{
    RowBox[{"Element", "[", 
     RowBox[{
      RowBox[{"x", "|", "y", "|", "z", "|", "n"}], ",", "Integers"}], "]"}], "&&",
     
    RowBox[{"n", ">", "3"}], "&&", 
    RowBox[{
     RowBox[{"x", " ", "y", " ", "z"}], "\[NotEqual]", "0"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->98595762],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->238413792]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->193348265],

Cell["\<\
Specify the default domain over which a function should work:\
\>", "ExampleText",
 CellID->24255137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"Expand", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "999997"}], "-", 
      RowBox[{"25", 
       RowBox[{"x", "^", "12345"}]}], "+", 
      RowBox[{"24", "x"}]}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "-", "7"}], ")"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", "9"}], ")"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->443061641],

Cell[BoxData[
 RowBox[{
  RowBox[{"1512", " ", "x"}], "-", 
  RowBox[{"216", " ", 
   SuperscriptBox["x", "2"]}], "-", 
  RowBox[{"168", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"24", " ", 
   SuperscriptBox["x", "4"]}], "-", 
  RowBox[{"1575", " ", 
   SuperscriptBox["x", "12345"]}], "+", 
  RowBox[{"225", " ", 
   SuperscriptBox["x", "12346"]}], "+", 
  RowBox[{"175", " ", 
   SuperscriptBox["x", "12347"]}], "-", 
  RowBox[{"25", " ", 
   SuperscriptBox["x", "12348"]}], "+", 
  RowBox[{"63", " ", 
   SuperscriptBox["x", "999997"]}], "-", 
  RowBox[{"9", " ", 
   SuperscriptBox["x", "999998"]}], "-", 
  RowBox[{"7", " ", 
   SuperscriptBox["x", "999999"]}], "+", 
  SuperscriptBox["x", "1000000"]}]], "Output",
 ImageSize->{383, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31251159]
}, Open  ]],

Cell["Find integer roots of a high degree polynomial:", "ExampleText",
 CellID->120019949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"f", "\[Equal]", "0"}], ",", "x", ",", "Integers"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->421960511],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", "3"}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", "1"}]}], "||", 
  RowBox[{"x", "\[Equal]", "0"}], "||", 
  RowBox[{"x", "\[Equal]", "1"}], "||", 
  RowBox[{"x", "\[Equal]", "3"}], "||", 
  RowBox[{"x", "\[Equal]", "7"}]}]], "Output",
 ImageSize->{304, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->514080260]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->656895780],

Cell["\<\
Find a representation of an integer as a sum of seven squares:\
\>", "ExampleText",
 CellID->149601652],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}], "+", 
     RowBox[{"z", "^", "2"}], "+", 
     RowBox[{"t", "^", "2"}], "+", 
     RowBox[{"u", "^", "2"}], "+", 
     RowBox[{"v", "^", "2"}], "+", 
     RowBox[{"w", "^", "2"}]}], "\[Equal]", "1234567890987654321"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z", ",", "t", ",", "u", ",", "v", ",", "w"}],
     "}"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->798049894],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "1111111106"}], ",", 
    RowBox[{"y", "\[Rule]", "33333"}], ",", 
    RowBox[{"z", "\[Rule]", "148"}], ",", 
    RowBox[{"t", "\[Rule]", "16"}], ",", 
    RowBox[{"u", "\[Rule]", "4"}], ",", 
    RowBox[{"v", "\[Rule]", "4"}], ",", 
    RowBox[{"w", "\[Rule]", "2"}]}], "}"}], "}"}]], "Output",
 ImageSize->{430, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->51139474]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->180392994],

Cell["Solve an optimization problem over the integers:", "ExampleText",
 CellID->317709048],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"x", " ", "y"}]}], ",", 
     RowBox[{
      RowBox[{"x", " ", "y"}], ">", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->194349879],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "2"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->83637259]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->107551944],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Integers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integers"]], "InlineFormula"],
 " contains ",
 Cell[BoxData[
  ButtonBox["Primes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Primes"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->112558139],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"Element", "[", 
    RowBox[{"x", ",", "Integers"}], "]"}], ",", 
   RowBox[{"Element", "[", 
    RowBox[{"x", ",", "Primes"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->155047900],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->441835370]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->52998338],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Integers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integers"]], "InlineFormula"],
 " is contained in ",
 Cell[BoxData[
  ButtonBox["Complexes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complexes"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Reals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reals"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Algebraics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Algebraics"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Rationals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rationals"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->356793860],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Refine", "[", 
    RowBox[{
     RowBox[{"Element", "[", 
      RowBox[{"x", ",", "#"}], "]"}], ",", 
     RowBox[{"Element", "[", 
      RowBox[{"x", ",", "Integers"}], "]"}]}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"Complexes", ",", "Reals", ",", "Algebraics", ",", "Rationals"}], 
   "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->134385914],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 ImageSize->{164, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->352478049]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->528881837],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["IntegerQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntegerQ"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " for explicit integers and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " otherwise:"
}], "ExampleText",
 CellID->658707985],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerQ", "/@", 
  RowBox[{"{", 
   RowBox[{"7", ",", "a", ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"E", "+", "7"}], ")"}], "^", "2"}], "/", "7"}], "-", 
     RowBox[{
      RowBox[{"E", "^", "2"}], "/", "7"}], "-", 
     RowBox[{"2", "E"}]}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->214818019],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "False", ",", "False"}], "}"}]], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->34712312]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Element",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Element"]], "InlineFormula"],
 " remains unevaluated when it cannot decide whether an expression is an \
integer:"
}], "ExampleText",
 CellID->180188583],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Element", "[", 
    RowBox[{"#", ",", "Integers"}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"7", ",", "a", ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"E", "+", "7"}], ")"}], "^", "2"}], "/", "7"}], "-", 
     RowBox[{
      RowBox[{"E", "^", "2"}], "/", "7"}], "-", 
     RowBox[{"2", "E"}]}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->445605478],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", 
   RowBox[{"a", "\[Element]", "Integers"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", "\[ExponentialE]"}], "-", 
     FractionBox[
      SuperscriptBox["\[ExponentialE]", "2"], "7"], "+", 
     RowBox[{
      FractionBox["1", "7"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"7", "+", "\[ExponentialE]"}], ")"}], "2"]}]}], "\[Element]", 
    "Integers"}]}], "}"}]], "Output",
 ImageSize->{343, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->28599606]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->64597674],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", 
   RowBox[{"a", "\[Element]", "Integers"}], ",", "True"}], "}"}]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->560006986]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18760],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Element",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Element"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Simplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Simplify"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Reals",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reals"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Primes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Primes"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Algebraics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Algebraics"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rationals",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rationals"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Booleans",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Booleans"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3963]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17110],

Cell[TextData[ButtonBox["Simplifying with Assumptions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SimplifyingWithAssumptions"]], "Tutorials",
 CellID->17766],

Cell[TextData[ButtonBox["Using Assumptions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/UsingAssumptions"]], "Tutorials",
 CellID->205],

Cell[TextData[ButtonBox["Equations and Inequalities over Domains",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EquationsAndInequalitiesOverDomains"]], "Tutorials",
 CellID->16575]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->200767417],

Cell[TextData[ButtonBox["Assumptions and Domains",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AssumptionsAndDomains"]], "MoreAbout",
 CellID->642830039],

Cell[TextData[ButtonBox["Formula Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FormulaManipulation"]], "MoreAbout",
 CellID->1020355068],

Cell[TextData[ButtonBox["Number Recognition",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberRecognition"]], "MoreAbout",
 CellID->35764214],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->13336717],

Cell[TextData[ButtonBox["Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialSystems"]], "MoreAbout",
 CellID->500321520]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Integers - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 49, 15.8686902}", "context" -> "System`", 
    "keywords" -> {
     "integer domain", "integer lattice", "integer range", 
      "integer solutions", "integer variables", "integers", 
      "integral numbers", "whole numbers"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Integers represents the domain of integers, as in x \\[Element] \
Integers. ", "synonyms" -> {}, "title" -> "Integers", "type" -> "Symbol", 
    "uri" -> "ref/Integers"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6604, 202, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->8232262]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 28220, 1046}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3368, 71, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3991, 98, 46, 1, 70, "ObjectName",
 CellID->16039],
Cell[4040, 101, 544, 17, 70, "Usage",
 CellID->16676]
}, Open  ]],
Cell[CellGroupData[{
Cell[4621, 123, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5099, 140, 261, 9, 70, "Notes",
 CellID->2719],
Cell[5363, 151, 335, 11, 70, "Notes",
 CellID->19535],
Cell[5701, 164, 473, 17, 70, "Notes",
 CellID->14858],
Cell[6177, 183, 390, 14, 70, "Notes",
 CellID->28903]
}, Closed]],
Cell[CellGroupData[{
Cell[6604, 202, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->8232262],
Cell[CellGroupData[{
Cell[6987, 216, 148, 5, 70, "ExampleSection",
 CellID->289019192],
Cell[7138, 223, 59, 1, 70, "ExampleText",
 CellID->436130550],
Cell[CellGroupData[{
Cell[7222, 228, 132, 4, 28, "Input",
 CellID->94897371],
Cell[7357, 234, 160, 5, 36, "Output",
 CellID->62442691]
}, Open  ]],
Cell[7532, 242, 124, 3, 70, "ExampleDelimiter",
 CellID->98498572],
Cell[7659, 247, 312, 13, 70, "ExampleText",
 CellID->531594117],
Cell[CellGroupData[{
Cell[7996, 264, 331, 11, 70, "Input",
 CellID->111110433],
Cell[8330, 277, 160, 5, 36, "Output",
 CellID->89974573]
}, Open  ]],
Cell[8505, 285, 125, 3, 70, "ExampleDelimiter",
 CellID->902398367],
Cell[8633, 290, 94, 1, 70, "ExampleText",
 CellID->311965230],
Cell[CellGroupData[{
Cell[8752, 295, 412, 14, 70, "Input",
 CellID->269611568],
Cell[9167, 311, 1278, 45, 82, "Output",
 CellID->223611212]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10494, 362, 220, 7, 70, "ExampleSection",
 CellID->134533761],
Cell[10717, 371, 92, 1, 70, "ExampleText",
 CellID->186508013],
Cell[CellGroupData[{
Cell[10834, 376, 139, 4, 70, "Input",
 CellID->150279975],
Cell[10976, 382, 161, 5, 36, "Output",
 CellID->143267790]
}, Open  ]],
Cell[11152, 390, 125, 3, 70, "ExampleDelimiter",
 CellID->140596962],
Cell[11280, 395, 77, 1, 70, "ExampleText",
 CellID->24636061],
Cell[CellGroupData[{
Cell[11382, 400, 249, 8, 70, "Input",
 CellID->144317606],
Cell[11634, 410, 158, 5, 36, "Output",
 CellID->324104903]
}, Open  ]],
Cell[CellGroupData[{
Cell[11829, 420, 519, 18, 70, "Input",
 CellID->98595762],
Cell[12351, 440, 162, 5, 36, "Output",
 CellID->238413792]
}, Open  ]],
Cell[12528, 448, 125, 3, 70, "ExampleDelimiter",
 CellID->193348265],
Cell[12656, 453, 111, 3, 70, "ExampleText",
 CellID->24255137],
Cell[CellGroupData[{
Cell[12792, 460, 449, 16, 70, "Input",
 CellID->443061641],
Cell[13244, 478, 861, 28, 54, "Output",
 CellID->31251159]
}, Open  ]],
Cell[14120, 509, 90, 1, 70, "ExampleText",
 CellID->120019949],
Cell[CellGroupData[{
Cell[14235, 514, 176, 6, 70, "Input",
 CellID->421960511],
Cell[14414, 522, 444, 14, 36, "Output",
 CellID->514080260]
}, Open  ]],
Cell[14873, 539, 125, 3, 70, "ExampleDelimiter",
 CellID->656895780],
Cell[15001, 544, 113, 3, 70, "ExampleText",
 CellID->149601652],
Cell[CellGroupData[{
Cell[15139, 551, 558, 16, 70, "Input",
 CellID->798049894],
Cell[15700, 569, 510, 15, 36, "Output",
 CellID->51139474]
}, Open  ]],
Cell[16225, 587, 125, 3, 70, "ExampleDelimiter",
 CellID->180392994],
Cell[16353, 592, 91, 1, 70, "ExampleText",
 CellID->317709048],
Cell[CellGroupData[{
Cell[16469, 597, 375, 13, 70, "Input",
 CellID->194349879],
Cell[16847, 612, 360, 13, 36, "Output",
 CellID->83637259]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17256, 631, 237, 7, 70, "ExampleSection",
 CellID->107551944],
Cell[17496, 640, 308, 12, 70, "ExampleText",
 CellID->112558139],
Cell[CellGroupData[{
Cell[17829, 656, 257, 8, 70, "Input",
 CellID->155047900],
Cell[18089, 666, 161, 5, 36, "Output",
 CellID->441835370]
}, Open  ]],
Cell[18265, 674, 124, 3, 70, "ExampleDelimiter",
 CellID->52998338],
Cell[18392, 679, 702, 27, 70, "ExampleText",
 CellID->356793860],
Cell[CellGroupData[{
Cell[19119, 710, 405, 13, 70, "Input",
 CellID->134385914],
Cell[19527, 725, 236, 7, 36, "Output",
 CellID->352478049]
}, Open  ]],
Cell[19778, 735, 125, 3, 70, "ExampleDelimiter",
 CellID->528881837],
Cell[19906, 740, 458, 17, 70, "ExampleText",
 CellID->658707985],
Cell[CellGroupData[{
Cell[20389, 761, 376, 13, 70, "Input",
 CellID->214818019],
Cell[20768, 776, 224, 7, 36, "Output",
 CellID->34712312]
}, Open  ]],
Cell[21007, 786, 256, 8, 70, "ExampleText",
 CellID->180188583],
Cell[CellGroupData[{
Cell[21288, 798, 454, 16, 70, "Input",
 CellID->445605478],
Cell[21745, 816, 614, 20, 54, "Output",
 CellID->28599606]
}, Open  ]],
Cell[CellGroupData[{
Cell[22396, 841, 103, 3, 70, "Input",
 CellID->64597674],
Cell[22502, 846, 260, 8, 36, "Output",
 CellID->560006986]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22823, 861, 311, 9, 70, "SeeAlsoSection",
 CellID->18760],
Cell[23137, 872, 1914, 71, 70, "SeeAlso",
 CellID->3963]
}, Open  ]],
Cell[CellGroupData[{
Cell[25088, 948, 314, 9, 70, "TutorialsSection",
 CellID->17110],
Cell[25405, 959, 165, 3, 70, "Tutorials",
 CellID->17766],
Cell[25573, 964, 142, 3, 70, "Tutorials",
 CellID->205],
Cell[25718, 969, 188, 4, 70, "Tutorials",
 CellID->16575]
}, Open  ]],
Cell[CellGroupData[{
Cell[25943, 978, 319, 9, 70, "MoreAboutSection",
 CellID->200767417],
Cell[26265, 989, 156, 3, 70, "MoreAbout",
 CellID->642830039],
Cell[26424, 994, 152, 3, 70, "MoreAbout",
 CellID->1020355068],
Cell[26579, 999, 146, 3, 70, "MoreAbout",
 CellID->35764214],
Cell[26728, 1004, 136, 3, 70, "MoreAbout",
 CellID->13336717],
Cell[26867, 1009, 147, 3, 70, "MoreAbout",
 CellID->500321520]
}, Open  ]],
Cell[27029, 1015, 27, 0, 70, "History"],
Cell[27059, 1017, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

