(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    995255,      18325]
NotebookOptionsPosition[    979530,      17784]
NotebookOutlinePosition[    981541,      17831]
CellTagsIndexPosition[    981453,      17826]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Approximate Functions and Interpolation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ApproximateFunctionsAndInterpolation"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Approximate Functions and Interpolation\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ListInterpolation" :> 
          Documentation`HelpLookup["paclet:ref/ListInterpolation"], 
          "FunctionInterpolation" :> 
          Documentation`HelpLookup["paclet:ref/FunctionInterpolation"], 
          "InterpolatingPolynomial" :> 
          Documentation`HelpLookup["paclet:ref/InterpolatingPolynomial"], 
          "Fit" :> Documentation`HelpLookup["paclet:ref/Fit"], "FindFit" :> 
          Documentation`HelpLookup["paclet:ref/FindFit"], "Quantile" :> 
          Documentation`HelpLookup["paclet:ref/Quantile"], "Nearest" :> 
          Documentation`HelpLookup["paclet:ref/Nearest"], 
          "InterpolatingFunction" :> 
          Documentation`HelpLookup["paclet:ref/InterpolatingFunction"], 
          "Piecewise" :> Documentation`HelpLookup["paclet:ref/Piecewise"], 
          "ListLinePlot" :> 
          Documentation`HelpLookup["paclet:ref/ListLinePlot"], "ListPlot3D" :> 
          Documentation`HelpLookup["paclet:ref/ListPlot3D"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ListInterpolation\"\>", 
       2->"\<\"FunctionInterpolation\"\>", 
       3->"\<\"InterpolatingPolynomial\"\>", 4->"\<\"Fit\"\>", 
       5->"\<\"FindFit\"\>", 6->"\<\"Quantile\"\>", 7->"\<\"Nearest\"\>", 
       8->"\<\"InterpolatingFunction\"\>", 9->"\<\"Piecewise\"\>", 
       10->"\<\"ListLinePlot\"\>", 
       11->"\<\"ListPlot3D\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Curve Fitting & Approximate Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/CurveFittingAndApproximateFunctions"], 
          "Data Transforms and Smoothing" :> 
          Documentation`HelpLookup["paclet:guide/DataTransformsAndSmoothing"],
           "Math & Counting Operations on Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicalAndCountingOperationsOnLists"], 
          "Numerical Data" :> 
          Documentation`HelpLookup["paclet:guide/NumericalData"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Curve Fitting & Approximate Functions\"\>", 
       2->"\<\"Data Transforms and Smoothing\"\>", 
       3->"\<\"Math & Counting Operations on Lists\"\>", 
       4->"\<\"Numerical Data\"\>", 
       5->"\<\"New in 6.0: Mathematics & Algorithms\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Interpolation", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Interpolation",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Interpolation"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["f", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["f", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]constructs an interpolation of the function values ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ", assumed to correspond to ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " values ",
     Cell[BoxData[
      FormBox["1", TraditionalForm]], "InlineMath"],
     ", ",
     Cell[BoxData[
      FormBox["2", TraditionalForm]], "InlineMath"],
     ", \[Ellipsis] . "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Interpolation",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Interpolation"], "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["f", "TI"], 
            StyleBox["1", "TR"]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["2", "TR"]], ",", 
           SubscriptBox[
            StyleBox["f", "TI"], 
            StyleBox["2", "TR"]]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]constructs an interpolation of the function values ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " corresponding to ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " values ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Interpolation",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Interpolation"], "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             SubscriptBox[
              StyleBox["x", "TI"], 
              StyleBox["1", "TR"]], ",", 
             SubscriptBox[
              StyleBox["y", "TI"], 
              StyleBox["1", "TR"]], ",", 
             StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
           SubscriptBox[
            StyleBox["f", "TI"], 
            StyleBox["1", "TR"]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             SubscriptBox[
              StyleBox["x", "TI"], 
              StyleBox["2", "TR"]], ",", 
             SubscriptBox[
              StyleBox["y", "TI"], 
              StyleBox["2", "TR"]], ",", 
             StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
           SubscriptBox[
            StyleBox["f", "TI"], 
            StyleBox["2", "TR"]]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]constructs an interpolation of multidimensional data."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Interpolation",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Interpolation"], "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             SubscriptBox[
              StyleBox["x", "TI"], 
              StyleBox["1", "TR"]], ",", 
             StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
           SubscriptBox[
            StyleBox["f", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["df", "TI"], 
            StyleBox["1", "TR"]], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]constructs an interpolation that reproduces derivatives \
as well as function values."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->18504]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Interpolation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Interpolation"]], "InlineFormula"],
 " returns an ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " object, which can be used like any other pure function."
}], "Notes",
 CellID->87807088],

Cell[TextData[{
 "The interpolating function returned by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Interpolation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Interpolation"], "[", 
   StyleBox["data", "TI"], "]"}]], "InlineFormula"],
 " is set up so as to agree with ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 " at every point explicitly specified in ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->165789745],

Cell[TextData[{
 "The function values ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["f", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " can be real or complex numbers, or arbitrary symbolic expressions. "
}], "Notes",
 CellID->28445701],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["f", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " can be lists or arrays of any dimension."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->122666961],

Cell[TextData[{
 "The function arguments ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["y", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ", etc. must be real numbers. "
}], "Notes",
 CellID->470674586],

Cell["\<\
Different elements in the data can have different numbers of derivatives \
specified.\
\>", "Notes",
 CellID->44352622],

Cell[TextData[{
 "For multidimensional data, the ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " derivative can be given as a tensor with a structure corresponding to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/D"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      StyleBox["n", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->719953730],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Interpolation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Interpolation"]], "InlineFormula"],
 " works by fitting polynomial curves between successive data points. "
}], "Notes",
 CellID->2156],

Cell[TextData[{
 "The degree of the polynomial curves is specified by the option ",
 Cell[BoxData[
  ButtonBox["InterpolationOrder",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolationOrder"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->29624],

Cell[TextData[{
 "The default setting is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InterpolationOrder",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InterpolationOrder"], "->", "3"}]], 
  "InlineFormula"],
 ". "
}], "Notes",
 CellID->5870],

Cell[TextData[{
 "You can do linear interpolation by using the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InterpolationOrder",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InterpolationOrder"], "->", "1"}]], 
  "InlineFormula"],
 ". "
}], "Notes",
 CellID->42],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Interpolation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Interpolation"], "[", 
   StyleBox["data", "TI"], "]"}]], "InlineFormula"],
 " generates an ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " object which returns values with the same precision as those in ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1352],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Interpolation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Interpolation"]], "InlineFormula"],
 " allows any derivative to be given as ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", in which case it will attempt to fill in the necessary information from \
other derivatives or function values."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->563880862]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->407295553],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->330046050],

Cell["\<\
Construct an approximate function that interpolates the data:\
\>", "ExampleText",
 CellID->27477696],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"Interpolation", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "5", ",", "8", ",", "5"}], "}"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->416760629],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "6"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{244, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->143985929]
}, Open  ]],

Cell["Apply the function to find interpolated values:", "ExampleText",
 CellID->185769659],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "2.5", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->144559998],

Cell[BoxData["2.4375`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->527350535]
}, Open  ]],

Cell["Plot the interpolation function:", "ExampleText",
 CellID->442754601],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->820225710],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 124},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->65217831]
}, Open  ]],

Cell["Compare with the original data:", "ExampleText",
 CellID->41725207],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"%", ",", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "5", ",", "8", ",", "5"}], "}"}], 
    "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->228623325],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 124},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->661489861]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19473],

Cell[TextData[{
 "Interpolate between points at arbitrary ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " values:"
}], "ExampleText",
 CellID->774922236],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Interpolation", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.1", ",", ".3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0.5", ",", ".6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", ".2"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->150112961],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "2.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{258, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->65453048]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"%", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->120115688],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->306188865]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->240595055],

Cell[TextData[{
 "Create data with ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->276002587],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"Sin", "[", 
      RowBox[{"4", "x"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3", ",", "0.5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16646568],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5`", ",", "0.9092974268256817`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", 
     RowBox[{"-", "0.7568024953079282`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.5`", ",", 
     RowBox[{"-", "0.27941549819892586`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.`", ",", "0.9893582466233818`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.5`", ",", 
     RowBox[{"-", "0.5440211108893698`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3.`", ",", 
     RowBox[{"-", "0.5365729180004349`"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{470, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->113795215]
}, Open  ]],

Cell["Form the interpolation:", "ExampleText",
 CellID->608429169],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Interpolation", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->120581792],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "3.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{258, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->222638107]
}, Open  ]],

Cell["Plot the interpolated function:", "ExampleText",
 CellID->121075124],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"%", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->178188815],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->282166973]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->344860950],

Cell["Create a list of multidimensional data:", "ExampleText",
 CellID->33307472],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], ",", 
       RowBox[{"LCM", "[", 
        RowBox[{"x", ",", "y"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "4"}], "}"}]}], "]"}], ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->459054826],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW8FS1EAQDRtgAWFBDoo3vsGPAC8e1YN62KKsgoOlhfy53mMm2ejadue9
nplks4pVxMxk0v26p6cz6bd5vXy4/fR5+XB3s7y8vl9+vb27+XZ59eW+7ip3
imLne1EULy+K+ryqz5q/8O9H/deetmdPwrHsrlbFrmgfivYpGP8MXD/KrA9d
z20fup7bvucT8+ercIBaw/VZ3Xwq+stV/4XRnyrX6kdRECs3Fe+Lkfwg77+m
ZjFIC8090X+46i/B/fv1Ya9uzlb/y+uyfQCu7xl690n5LG65ZjaFI9Yfc2Pe
5P3zkebH43dmHBe9swbSr3ZzT2ujlhFmirQwTsaCLZW5W1shUjpzn9cK5CsL
x9xlbaxPh0EjbR5n5lgfMOP+jnmEai7aQcu+YuVCtLVMtt4+AXrLlR4pV2ag
YxKPJV/ikDgt+Sz+M+AXuTvK5TcLt9Uv21fh4F7lTQzCFYF2hN7x+jpEd51Q
WOX8jak7zm65U5N5AFmUBwVnITcq7mnd5cUG/+7vfuxnmWPQmtXW4J8a0R0L
iBHN2t86UebBOuPsDD6XHpRY8nsYW4NHxMVZX4ZmVrX23I/NlkzuOa368Xny
A5NvkD6vfd78NqR/kT35shl+zjC+5XasU484/9Mzh5Vx+4XhPZ4vBlFNK9hS
rlZgyPJa1u6yf6loRTWk7om9qPSniKX33CHXwqXJ9eDV5J5l8kcnR8On9Us5
bYU1nMpavf9s26vf/3p1H+XSsf3p1YfwUzvDwar+/xubIDPr0H5g5Vq4LLmN
HGqPpVWt2So8Ow5VvS0cnio8Mw7V/iwcuavvyB8Wa+TxN+OPoXGw8xKLg7WT
xdHsXRNZEV+F3Teaid/NIBuHScrFjvSjYZmjA5eHpjt3ach8XvAha/c2zHz0
7ZgQo+BlHGRbezavt49Vm2UuQvyNbIfxHr4DWSV5Lzleezfts9qr7xjMCudF
r1ZUM0bXm+inKvN9EZr7OnrvlnkzDzOkRlwmRgRZ7F3Dcs16a6RefcNYqdbe
HPPeZFYYvXKNIQbXywAjfVZ1LPh0V+lHcarmjEQmhVmRXWWrb9x6BS1GPpOV
NZ955Fv4tH4uwmRcq1V8R1x71xHSh3YMaFZTGLNtzIap/pxmHhye9x/ylwfo
d0Xpv/sYIpLjfm2ymLy343RzdnEI25hnGbDTSmd0rH7E9CC5Z5VeSUPMF2Ls
YpmvdbzW7z3G9AMr18Jl6WtyYNNIZ87Q+4EakY418sik5dU3NSbtbTjAWrqG
8pHpmh7T9S5qNqfOUOXGEctQ5WbKYv3BMmBH5LipzMubKiZ6rbdolmHIOU67
b5OM0CYwxfqJ5Z1kDXuz/JTPN+3TFn1DI9vovQaxHN76PZLn5XoQ6+JlPVDt
02tfGG+xOTEsD9rzofmQ/nsfDsl5cWw+JFWelwlB9afUemZcBSBPlSS3bz9U
2xhRqTxizDdKnjq81x6S8UjiRLwMOPLhdkZOam6Yei7yfAsRk3+8XAeybzuj
KCcLMWWef+zoGvJr1zbSvJHVfSXfxxRb35KwckvDU1o/U5GPkcviPa/sb2SG
qPRbeD82sxlOmdp4sfMTStpPRg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{499, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->381320888]
}, Open  ]],

Cell["Create an approximate interpolating function:", "ExampleText",
 CellID->51445633],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"Interpolation", "[", "%", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->182616537],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "4"}], "}"}]}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{294, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->21614922]
}, Open  ]],

Cell["Plot the interpolating function:", "ExampleText",
 CellID->455664976],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "1", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->741719701],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJykvQd4VMX3P7yb3WSTzZYYpRcRAoJKRxQQ7lClCYpSo1IElCYI0kQgVMFC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   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmFuM1OUZxr+dmWV39sCyc9jpdknaGbxQA4gXHqBFKtawSzzAotR4pcZj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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllElszXEQx6fV9tV7r/T93/+9V0tCywGp4mBfa0lbiaWVOPQkEqr2hIoS
2oS2KtTBGlxaNIgDIS6IONkiqDi0jYQ0KUFEiPSGzzdzmOQ3v9nnOzPFG3fV
7Mw2s1ooB9qaNNsJlUTMeoabvcyYPYcu5Jp1xs0uJsz+FJktHmFWhuEM+AWh
WWW+2VdoH/xT5L0FZl0xs6Npsx/wU9CvjsLjqw1ai68j6OxGf8sos46RZqvR
f4evbcQvJv4m4l/Bvoi/CLYVyC0wuwH9JJ/JyLuQX027bAzxP+PvfQq/yAop
qB9+GvbzkU0g5gf4LPRv4e89Pu7g6yD5LEc2lOuxRkNj8z1mM76a4OP4ykT9
3QyNi/jfMXKdBV+Ofi8xR/EeIEZfgfuYGXpNqkU6S/A3nJhriNfH37Mir0G5
q2eHyaUJqkJeCdWh+xqdwQLH4BTxylNu28bfNdniv4r6K6EvxN6jGOQ6EZ1k
6BgJmxA6i79b2KyLeY8SvEPoEfrn8f8r7RgKu05oP+924rcSqyELnIh/DL6l
wP/uEms6Nj3Yr4Wmho6psJxHvAD5G2wmwXcTb1HoGAq7KuRz4fPgS+FXwJ/h
PRt//fiqwWZs6DWqtpUx780BfCai3iNhdwBaFncMu9EdTDj26slJZB1QCbJh
1GfIf6e9tkb+JhLvEvLNcY+5Pek7oNnXDKpW9Vy9Vs0D6LeQ0wTk6/PMFmq2
oCDqO3A86TOhWaiIeG3tSX+rxobAMRI2t8nnJnwk8NnTTMvX4tB7I5+q7Try
V3GvMcp7KfX3Y18Nfxx5O7Qq3/9KsS0LvfcjsZ+td+i9Vc/+Yvsv5Vidy3Hs
TgS+C8JwB7k+Jr/7uX4DhF0tOlkxx1C73JjwWdBO17O7ddDDqO/wJ3xnB+5b
OQVpnzHNlnSSvB8kvHbN3Hf0v6X8lpyO+mxqBoS9ZlS79CLjt0c7VUc+Yeiz
/JZ6s9OOqbDUTpciH5/yWXsCPq26TaHvrjArRH4v5bdINV3OeA6KrRnYm/KZ
06xph1oyfrN0q7SzGzJ+U3RLNFOHAp8JzYJ6ptv4MemxdSPrk56zctXNGML+
dtpnUZhODx0zYaUbNSf0G6Dd1863ZhxzYa2b+R/exbUu
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.3778217437468812, 0.20416319333846344`, 0.6480544836530957], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmguUldV1xz9mBubO8859zL0ztCBGkw4KjoEkCA4DimIiL5mBAW0CBJRB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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllmtsVFUUhU8LpXSmBebOnc60igE0WBStAiqtFREIAgJCW2nRKAWMQhSM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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5073212808896521, 0.4293279151369704, 0.8300817490560187], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnHeYVdXVxs/Mnblz79Tb5t47llgiYkPBEmyxBBMbFrBFVLD7CRgsURBF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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwlmXncVeMWx7d6z3nH89bZe5+zT0KGSxlSCaVuqYsPaZ6kt0GSkJKiMpUh
LtdQ4fK5l9S9xgYakagoZSiaU9GgEkIaDJGu7vf3+f2xPud59lrPetYzrfVb
65zUf2iXm6oFQfDOMUFQxG+zbBBcnw+CTHkQ/FoWBHviIOjOt1RlENxZyjf6
r9Hflg6Ch+hPRXYKdG9xELRjzHTajZFpVRIEQxj/Le1uyP+F9h3I14iC4NxC
EMxF/hF0zAuDoDP8AF41+juRf47+fnSN4Ft99J0JfZIKglXo2A5/BPyOtG+B
35v2JdBh5mvEt71JEOyDllQEwUrGjKyFDHQmvHU1g+BY5h9OP0P7Beb7Ftkf
oEXIf4z8+eh6jfm6Mf8vjPma+TpAn6D/tlLbcgZ0Yco2NUZ+by4InkK2F2M2
o+tz6HXa/2FPf2PsMGTuY66HGX8X6x3EtyLag6BNtK+D/wz7cRP9z+nfSH8Y
8kPpN8fWYZH3prJGEMyE3w7+SO03/HHMPR46hfmbIjMV/oXwf8LeNvDn0u9P
vyu8DvQXM/9+vt1H+6S021Pgr0372yxsnw29if1TqvkutGX+w2nfiRNpX8T5
jWL+GWmfbQtocLHPeDbyk5B5NhMEVci/Q/9tqIDsPcgMYT17kG/EZVvBehrQ
/pX5PmH/EQmeQfYYbPoT2eOw52R0vc/6+qI7jb4FyK9C/mXk/8C+fyK/EHs+
Zr4L4DeF953uH7xD9D+lP4g1v4T8i1Bj2m/A74TuSejcFfvO6a6NhH5A/++M
WYVsE+ha2gOgerRPhz5jvo3QI8j2lcHwjtKfW+4zvxx7B2BPL+xpjvwi+O9C
42lPYc1X0l6p+1s9CGrzLUO/L+v7FX3LGP8N9qXoL+X8qtCfgt8Knbtpvw1/
tO469j6K/Az6i+m3h98R3Qk6b0P+dqg1uuujYwO2rYd6MP4fjDlM+7vQtj8J
raW/BmrJXV4O7aX9AzQG3vPIF6MrDS1groVQ68jf1P4amT/pl3Omd+Ifyjiz
UnglWjP896AV6FoOdUT2OvRVh3dP1m9Dd+xc+o2hn2j/DEW0w8RvczryDzF2
E3MsLfYe3c3YP/k2C9nJ6BjM3CV536Xl0H727kzW14C1ZNHRFV1fsV959iZi
T07jbOpCY2lP5o4UJd5j7e18aB+69ue99rtlA/PVRecC+kO5L8fDux39c9Ff
F5ta0X+B/kf0d8M/gHwz5NdpvO4X7VWh3+ZlyI+hPxo6XGSf9V1iHyTfsxCb
zmP8O9jbtdRvuiO8DlAGXiX0ut4m9BDtWxgzHvkC+mYg3wf5Y+HVgtaxlvVQ
FfyLoN/kv+jnsGUC/CrG94Y2Mtfb7O8KdA1Bx0d5j5HsKOgm9rcZYy6Fv5X9
fQn5NYyfytgN7H9d+JPgf8tTWMsdeCTnN6a3dTL0b/b6KPJ3svZJvInXmKtH
1r7gbqhp1j5WvnUg/UvQNx+ZNpxXPeabyPjnCrZFMeawYgP63mf+ZvRrI3+U
b6PZz6nMPwreSKghvJbI/BX+cPSdhn1Z9DWj3Qd92+Bv5Uzmy9/Q/6LCPupW
+Muy9j1nF9vXtoRfP2Of2xN9rWO/rf7oW8Raq8HfWmGf8yPyIxK/fb3Jm5G9
g293s1fL0H8EXg75Q/Iv9NfTXg211V1gjmHwhyf2PbtSjo2KMYotipHXom8A
9BRjn5b/Zf4mutOMvQP5G2KfgfZeMaYu/Of5dgyyZ6V8F55gzU3KfSfasJ6l
rHko+30O6ylCdrFsQt8gvlUk9lHyTUuhPjm/cb3tn9H/ErIvQAsVD+Tz4P0V
+h/8I/IRkWOQYs9WZG6lPQf5d5C9HXuaMH9fZI5nedWY/5ysY4hixwl8exX5
6tBK5C9HxyO0H4auxrYW6PsU+TJ03FbpO5NBVy/0d80YYzyJrseh74u95kXI
FyE/EPli5D9HdhdURL8v+zEB/lLWuJH9qsF59tRbgepwHidAR9G/BJljseUP
dL5Iexrj5zBfJ+TXIruNbyvRPa3CZ7sW2pPxGctXrtF5VrfPbEj7CtbTOO09
aEl/O/JHkB9MP4RXU3iB84wYfxPtnth3gPlLoKa0ByaOTVPROZuxw5EZzt6+
nfHb3BAba+iNitcNmcszlnmV9XRApgr+aNZzPvZV8e0eZI9W+i6k9OYzvhNX
0q+CutD+HJu/YuzxBb8lxZg6jK8X+q69wfh+6Loefv+MY14ndK2G3yztGFeJ
/BbW/Bi8+5H/CP7HsbHJTGzoxvjrGH8Q247R/WGtt8ino7+Z3jf8q+Evxv4v
hWfQvTk2llqFzGD2Zwh0YYnP5HTmmxM6Fm+qtK9twvw/lNjnXk6/bexYJht7
0N7CfLOYK4W+9rSflr+nXw7tpl2H+XsieyWURf9u9JWjfxz6z+buPYjMGs5v
dZn3tg86D5Z4j7vExkCCEtWZszntm2Ufc+1D5kPaNdH/I3Pdgf1NC35Dejv1
2NOt8q30n6E/G5kxtEdD/005RrVAvjV0tnwvk+xD/3L6W+ifWuq73AGbjqR9
p4XNBqOzUYUxmrDkiwW/bWHKSnTXgI7D1mXYXIV9S5Dfw/i/M98ryPYVBuUt
zGJMG/b+vMSxXd96w9vEmIvT3oMtBb9Bvb2fkL8U/hcFt+fxrZtiIdQI+auY
83fhTXRuwNbz4J+FrgP0w7Rj/leMXcaeD6zhnOV9xp6u9xD4juc5n9/QcQNr
mwj/MOO/iI211zK+kbAVdGap78xO4S/6BeEV9mSkYhE0JOM9WJk4JioWCmOO
yBkDKPZXQA2wZYEwe+A70Ii9Pp8xv5b7DbZCVx2+zSz1GdWmnYe/utw+vQv8
Bnz7IG3MeY3eUsHYbQd0Me2TImNx6QjoN2VNgysc095A1/3Y81zamGGhsFzi
tyVM+juyZ7MnuyodQz+iPyt2brEP/pOh77Tusu6UsG2XxFhKGHdZ5Bii2LEm
5VyrD3RjDedcjZAvjoyl+rFfjelXRs79ttA/VXebOfrTH8ecPZUbQgsy9jEn
0v469Ns6BEX0V9I/j/bVxT4bxWTFYp3RH+z3kbyx8fGMjwvOwZR7KeZOoT+1
4FxBmPJTzmtlzthOPn8xa+sZ+i4rB6sN7zjdL+7CzCJjmYWhsaUwzXrW8nLB
sVAxULnD98KMJc4hng+NEYUNleMchr83a9+1GvqF/sTQsf7bEvuWTomxnnzM
98qNFLOKnaOeDP8E+bBK+8yR9NsiU1ZhH9U/sk+VL30QGzfB25gYK/cSZkNX
BfwxlY75gxm/Gv6UCmO66jrf0NhyG/26sd+M3krAtxtD51TKpZSD3RsZgwl7
jYHfMTSmFpYWxtbe3QylyryH49A3Xv6L9gH2s73mgqYy9t4KY1FhQGE/YdKv
sLcm/Ucr7VOnovti5K9IuQYxk/6MxFheOcHp2F+v4Nz1fvRdFRljCFtk2cOJ
ij/CD5xXC6gO7RPk78t8Zoq9efSvK3IMFlaOQ++dMHP9Wo4xii07Kv125EPk
O/SG/kb79di+qnvKe52OvTfac/nqu6DNKfvsjti3hjGPldoHqzYRa3/TrlHU
Yu+2IDM/Y4w/LDSGF3ZXjHgsNmYQVqgP/2LGvxU5lzuNNc9H17zE2PBRjYmc
UyuXVg7fkHZX1vxh2j6mnP5zkd+WahbNmf9E5igvc05zIHGNRbUVYfA35SsU
D8qcU0+h3YPx/bD3MvrTaK/H3vGqfQhz8xa2QY8x/6Plxs7vhr5rwtDjaTfO
O1fSHs0NHbMVq5UzyZefERv7yacrt9sdO3dQjvcj9k6AXq7pmoxyp1GhY6Ny
qHMS+wj5hgPlzm07h74rynF7RcZAwj7l6FzL3o6NjbX7VXdudVzk2Kscqwpe
L6h1yphUsUM1KdWiFEPeDI35hfWFwZUbb4gcG5UjK/fdERmrKQcWlr0i8lsT
pr05cg1ItR/lMHr7p4TGIvIBwgby2fLVwgh6y0NCY0+96YtoX4M93dN+M+fS
n5zYFyvnvyVyjqTcSDUtxdLOedf+FFNV29Ab1dtUjUNv8QnlFCm/SWHpNuiY
njam3kP7Aui9UudY8yLfSd1Fxdztwob0t1dax4/Yci329Um7ZjdQ2D0y1lNN
LE27YcG+UTUJ5eLTsq4tKidfnzMGFvYdxbfT0Hdszth9B/aeT3tF1thquWo8
6LsLfU1KnSMux55fYscWYYzhwjOKKaX2SfKt7RJjPfnYmXnXaFSb6Y7+L2lv
yrkWoBrHEmHByHdHmPlc5cM512ZUQ2uqWk7k2Pcuc+yKnDMpV1JOpLc+Ax3z
Mn7zqm1Nj537qMal2PhK7LelGJnDnrzqIaz9Se7HG/C/iZxr6Qz0FnskrjXp
TTan3zIydhBmLsBLsG8n8WENNhzMGsMIu6iGNCF2zFKsalhqbKE3rLcrjKHc
TDmSciPlaDnGjkXHRPRPK/XbmBa7Fqk3otrVvwquBaiGlUtcY1BtQT5PvnAt
1DJtn7hIvhT5Hsh3V85Ff3rkXGUC/e3Yck9obCaforO7ImtfozOUr18fu/Yk
n7+M9tLYeyUbVym3jI1lH1D9Ku+akmpJ2tMW2Nc/59xOOe21tAfkXHtUTtmP
9lU5YwPVvIfSzsbO1RTzlKvpzHXWytmEXVXDUO1CGFa5XTu+7S51jqdYtK7g
WoBi0pfYsyNvbKUajHzxg7Gxu3zyIMbekLNvUs30CLxZWdfmHhemVW4fO1c8
CF2G7KU5x17VbHuxvhtzzvWV4z6QcwxT7JJP19teknNtSW98Rej/AFT7V866
MfScmkuYvkz7W3AttYQ9GIAtZ+Vdu1eOpFr0nsS1LtWku2ad8yjX0ZnXhJdN
XPv7APu6ZF2TVy1emFLYfjP692eM8eVLtoXO5eVT5PtH1HKtXzGgDfaMzTk2
CnPIF34Wu9Ylnzg5dA1LtSvllDPQ3zn229Z/AHobtRPX0vRG9oXGAIr9wgiD
sOWGgrGFcty9of8z0X8lwrTybbrDurvycaoFVeV8FqoJtY+dMytXLoHfu+Ac
W7m1ahjC7npTekvC8DsL/k9F/6WoZtELXu+c93oaezAnZwwo7Kf/SJR7LIyd
KykHmZn1G9LbUU15jv570f8Xpc7hNkeu+ajWo5rGJMWyxLFSGOE6ZK/Pufah
GsZ02Rr5rORTVas/NbHvVc1+FvyZ0PrAPu1j+a+8/ytSjvkp+3Uodm1amH5N
wT5HvkY1k4boapC4dqb/hJS77s+6tqccdoTy4YJzY+Vk+i/jrcRYR/9pDIE3
uOC9UQ1/U8E5pnJL3SFha8UIxQZh7Ii1RDnnIqqxPavcN3KtUjWIh0Ln9Mrl
S1LO1ZLEvlM5m3K7Jon/e1COdyfjR0SuJQoD9VOuW3CtQj5N/5V8Gfu/LP1n
Mlm1pMi+SGdyYcE5vHJ31SA7xr4zuiv6T+r/+f7dWA==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6174927205091991, 0.6138011700141026, 0.9107222942596203], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnXeYlNXZxmd22TK7M7s7fVasWDDBgjUYBRUlthglFkTBrihKESnGirGg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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmnm8VXP3x3d1p3PvPTfn7H3O2ZWhUKYkqfDQoIFkLKk0I9KcSoUeSdRj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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7127048454516469, 0.7667805617410612, 0.9128928374509553], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnHe4VdW1xc895Xa49/R7wUYEjKDoU4Ro7KEpWFJsT1QEaxRNFGJQTCyJ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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwlmXm8zXUax3/ude51zrmWc35nu9UoLlqUotRQMWRrQyXLSynbpRHJXlKh
qGxFWYpyR0hpeiWyRC6aq9BMq2ZKQ3al1U6ZeX9enz+e1/k+v2f9bs/yPbV6
PXD7oLwgCGZXCoLK/DYOg+DVVBC0igZBh6pBsAA8lwuCM0VBMBe8M+Mr+ba1
wDzH00FwFGgagR4LgrPJIDiYQV88CEL4rwcvg94C2kLgaXSPBK/KuEGVIEgV
B0E9vj2L/KxqQbCe8dfIT0Q+D58aY+83dPTH3vnoexzbk4FbCoNgDPhxaLvh
nw7/j+hokvUc5Pspvp1k3BEbbaoHwc/I3Az/Bmwshrcf8Cz6X4CnG7SO+LMg
wVyylr2FhZkKfQb0roXmuYhxfeiHoF+LjVJ01eXbMtYiD7gY/W8Bx9DdAGjI
XG+Cvwrr9xH6ZsH7PDq/hbc7+iYwfoJvLRgvZk26IPsHMJz5jkM+Da0788vD
Xk3stWUu6/nWX/qZ00TkbwKaQRsLBNA2Y28u9tLgR5nPFL61R/848Eu0NvC3
xH45Nh7PmUe0UcD/sN0Je2fwJQW+VuvHHL6Hv0s+Y/jrh5ZdwbdC/LkNfA3+
DGb/+oIfYU2ehPYo/vUEP5b22ZDOcsYbgKXwPw20QV8J8svR9yY+zgffAv46
tpcAy/FlbdJrea/2BPrFoW03hz4+5zOhszAaqIrtMmTysVWN/ezEWjyG/Aqt
B/AveBPYX4j8BGz2wb/SYvv6Wo0g+BXe+ui8r8Bn7nXk2/JtDLKjgYbwxtCx
l7U4zHzLUj4TOgta038yvhmea6r7TG9nbe/i22XoGobMf3V2oTet7jmXYKs2
cAjeCcxvDPTRwDB8v471uIpxF+hjor5zM7F3BH9OML/GfFsB/UV87Itvi+UD
uhfx7U301cLGHmh7gSz0p/jWHn96o6Mj420cl4U6b3w7DP6DzhT4K+AvMW4E
lIE3Yz1PMd4PjAPfh77V6CtH/gjj+4Dt0DbzrZ98CS1bH3wK/DWAL/D3K74N
YS4PaH3xdQAwB/7zofeBtzfQE9lefKvLuC/0NuDnQb+Ouf7C/Oewd5OBmui6
Gp2n0fVj6Lt8azXHmnr4+1HMMeex0GdEZ+MRoDW63gMK0NUFmcXQG+Qcq+YB
m5n7P7A/B/uXs18H0PcNcIjg+Az6XmA8EyhBvgnyy7D1DtCDvYvw7V1oK4FX
oZUCMXT/ynqPx/996ByH/lnY3wltBLAW3obIf47ursAmbHeHPhveWcBZ8DVJ
6x6GjgJ4KwPDkX0L/oOKzUnfpXOZ/3T4ZwDD8aeG5gftbMKx8aeIY/MhYE7c
MboC3ruTPhs6o3cl7YNsaw0aML4M2ATtR/jjGccYxZZ3sF+I/SrAQGjt0HGI
8f3Yu4TYXbOaY1mcOc6POqb1hxbJ2HfdseqM+8KzGnwVUJ+1ehAogv8a7sAO
6E9D/wBfnon7rGpOmovObAm8T4BvRbYh/NvwbRJ4BfxLuD8XIj8efEvMZ+L9
0DFUsXNmnvficuDKiPekMvSeWjN4R+PfOvA28NeHf1XEug+gc2bcNtoxjue8
t/Xg3w49A36qyDlTvm9Ex7xCzyEaOoYodkzmfA1m3B+eySzrPmwsDH2HdXcj
+b6LdyR9VnQn57KWY7FZF/vXx5z79gAz4s6B1dK2Id0LWMMe0O4G5qI/P+69
0ZnRWdEezdT8Us59ykma+4fs97wir8F89NVF/kPGGyOO3eeAl8ccw7sx7iob
6LpV8Z3xBmBQ3Gfi96TPhM7CM7qz2NuGjgHwxqF3Zrw19F79HHWsmIb9rkWO
Ge0YXw7Ph+xVId9aMU4o/sO/E/4c47synlsEKGV8T8bjGNAo7Rys3Hu0wHvz
JTZOF3mPOsD7HPR20I5gbz/0HgnHtqr4/Cn6B7I+hVHbvBn6jcD6Aufcwznn
FOWSuvAPK3ZOUS5ZDDQK7ZN82QJPNuecrlwuH0Zj6wD6H0L/9ALn+kzoWkc5
X75NBxrE7KNqi5EJxy7VGAfQVwqez/qnsL+L9dqpOw2tRpFjUQ6d62OOSfci
XyKeuGsE7XUvvq2Mec+3q/aBfxG8S8F3JL0mWoss3yKM10I/D192Qm/B+Hts
TEP+APAF8rWBhfC+Ab0Kc5sHz0/ML8IZ68PcHtSagReznkXILgbaIHsZc9iE
vWjOtaJi7Grk30W+J/62YU9uAN+ec+7rgL42Sedo5eZHgM/QdQwbB5EdqvML
7ZuMY8cA3Ulkl7Nef+M8dGBOKxgXqj5B32FkhsM7FOiCbzndJ8Ztsz57WiPN
fR3w17jXQGfh1pxrEZ2JAvZ+Ezprcf8Gob8J/p1CfxmyA9HxB7zvQl+J/U7Q
L1WuAb8ozzVlV3z/BLwT8j1Yw8eU+4Gr8GckNi5IOmcqVyrnD4Y2KOe1VE5V
7uwN1CtyDtVdSiAzNeY7tTDrGkC5fxj4K2nfcd3tG1U/M+4Pz6VF3qOXpUs1
UcQ5c4vuK9AJfXfmubY8J+mzoRozzfxPoL8v+XIO82sGPgGeP+DNEtM6a22B
W2Ke8254n0i5NlBNNRT87bRjSXfOwyRkf0+4NlHNvwXerSnH2lWBa6lv4Qnz
XFPNh7c28qvw/Qv46+D/VL4V5PnMa26qUVSbaI7fZd3jqLdRjTgA/EHkC7B/
BXj7tGss1VYH0flQ6DlqbrUizg2qkVUbK0c0Q35xwmujGDeTuZ5WfYjtpsAM
9uq5nGv/GVW9V9+lnNu1Z3dmXYOo9lDNthS8HDyV7xp0Yug11Vq+wRrfCL0G
NtbE3GPcAN4S2MP6bETngqxrHNU2Q6BvVKxG37LAMVq90QnVWHnukSZDe585
d0PfyUq+y7Wyjt2600fg/RT6EOh71aOgbxPf6sWdk1T7fgy+Mc81cLn6B87H
A8jOYc6/CMfG/7i7e8BT6IqjfyOyS/B3A/Q7+HY46py5GbwidO28Hh13KpaD
D893TAmwt1rnGXvd2ZN88HUJ587e4PPx7+WMe4FW2Lg66ZigWLABfAf6vk27
1laNJ19iWdPkUwmytZTTVN8y5+MJ96zqVXXGv0o4hyl3FWDjcNIxWbG4FzLN
ka2dsezemOd2JuHaRnOsYO83p3xWVQN8xrht6FzVB/p9SdcIqg1Uo+xF1zZ4
Sio5589G18PgnyB/rs44+nepX4u4p5gG/7PAlXHzlOHb2KTXUj3WXGiFKcfm
ptg7yvjehHvZCVHnpvmqrwudo8qRrZxz7FdPol7vHviHxN3zqdZdAn5/zDVv
O+09/u+q7pw0Dl3NVUND+ws6p2J/CvB4nn08E/rO6K5cF/fbwklgXsxvDCcY
90Zfjbi/ZbA3F3uljHNaU9WDOdf6qnkOqv5IunZTTFVuO5nx3ijH7UQ2Br4M
+U+g/4fxvzPuxfQGcVC1vnruau6BKqB1Q2ZE3DW2YvPYnHtnxeh3Eu5J1Iso
x9TF9oCcexnF0JHMb1zOa9sY/q2M6+Lzd9B3Ar+if0jCsU8xUr3gOHwojrkn
3A99H/BC3DVoy9A5TblMd+wIstNzji0XYuMldH+edS6+FnyR4gEwtMg9lHQ1
Szo2SOdr2Gqe9FtEW73ZpP0moLeA1urh0N0q5dy7A33PMX4j69zblPWuDT4q
7Vr8CmAp4zeBSRH3nIrVD8ETRh2z66S8Bpr7rqo+K8cyzn06M6ptfki6l1KN
sw5dXZPuPRSj1iL7Xs5vOxXIn2XcOvTbSWfWpBz8D/AThX7DqFTsGKbYdTf0
CujZlM+OYv4B5rI/61yoHrc14zbqf5DdWehYfFvWtZVicsuEe1r1sqoJnkfX
DGCCapWI78ZNCfequiNd5D+wu9AxUr1tNOXYoR53lnqzlGOvcoZq3yvSjpWq
gddDfx8YXOiasCLhNw69bZTk23ZZ1rWGfFCs+Dhl3xUzVjFemfJeqadbk3KN
pdpKd3xFxm8uemtRzXVVwm9MeltSjzsK3qfw5/yY9/An1nJlzmdLcypP+Q1P
b3fKQerlbghdW6mnm4DuI/D/uZpriEfQ/2XWtWYs6l74t6zfEtQT621taLFr
ab2xHUo7Rys3q6YZAf/XrOEM1ZP4Vwv6Swn3qiujrgXKEq69VROoFumXce+h
mqQu9Dppv/WV439p0j2pelHl1CzjR5GPR11DP5XyG6beLscXOvbIpmwpBqmX
jYTuHdXTdk66x1dvrxjzd/jrp52blUOL0D8w4bevFTHn5rdD61aOVm69X/E5
6hyrtZsAz0eVvIaqXZVjlVtVwz7PeFrOd1NvlnorUs+oXlFvRsMS7lnUq6hn
092smrFt3dEm0Lthrz+ynbF/PbT5Sb/96MzdDv9taffOu9QPwf9ozrWpYvJA
+EeFjm2K8ZfC+3bCtbjukPaqfca9lvasBvQqoXtVvckpt+sNUG9/yvFPSjbl
vdGcv8+4Z1CvoDcM5ZpXMs7tyjl6a1iV8FuR3hxWo2tNzrFBOeZVzk6LpGtf
xUDV+iMzPjuq+aeolsg5Fqlm7IXtnsC5Eb+pTYL3h9Bz15n4nfH6nM+uYsxE
7GdD1zI18adj6J5AvYDebHV3loeuJXWHVFtckPHbiWqMJWnHYMXedsAH+Nsu
4VpXb0L98aVfyrlTb8bqTZOhe0f1qMpNLYDjVZyjNB6WcS+jb4PSznnKdXoj
babaJ+G93o78gJTnIN915k6he3bGufiY3jASfvPVW696nEVp5wjlBvVwylUP
h9alnLUm4ZirWKsaTbm0UdJvZ8qpxeh+MeXaQ28K6iX3p/3Wpp7yDOPTab9l
qYdSbdMy415TNc5u8EjStbDeINX7qQZU7ace8OOcc5JykXLsiLRzpHKj/oOo
k3GNptpMbxx6KxoH/5+ifjNamXBOUS5Rz1aa9ppoLcTTKnRPp15OZ0Rvc/kZ
x3690f0WukZVbar/HPRW9Xrae6s3K9211mm/ZejO/R9Id4zX
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.803300875021046, 0.8605603196323228, 0.8958109324361734], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXuQ1WUZx3/rcvbsnrN7ds/9rBOYLKBOOioIYWq20qCiUpCklVxEUdB0
YbwB5S5jKzqKDpfl2lSiZtoo/oF3LmYGiKiVM5nZ1HjBVLBEZS1vTN8P32eH
P979vef3e9/nfZ7vc3/3yJldk68+LEmScfpTr2djNkmGaCxIJ8muXJI8rzEu
kyQz8kmyv5QkL2nN021J8juNedqwXfsaNf6s91v0TGv8XvPumPN+c6z5k+bH
ilZ/Y5KcmNLepiT5qCFJPtTYrXO2ak2TxgZ9O1nfano+qW+rNT+vwe95t0lr
7tLvPr0/U8+9reZnj5470uYP3sqi2dzis6aL/4/F/4viYa2eqys+gz2sh+dZ
em7V+GJQktxfTpIHNCZq7wTxfLbG6DrR0Hn9onu51nQJp52an1RvnJifkzJe
z8d8Tpvnf0j5uSvmPL+d8fwuPU/VaNV8pLBZouelot+j89cVk2SqZBomOYZq
LNS6r9WEWSFJcvp9X8bncda0tPn/qebtWvM3rfmi2efsCj1WcsaF855LGy+w
6hatwdo7pt54zm4zb9ACl3+Ln0l6Tm4zb415vwert0VvUZt1eKb4fVn4vp4Y
D+iAz/Kc92MDyDcp6GyTLmthG+9qzTsaO/R7o3TzmLB+VGOEdLVeWEzQvrlZ
484cu3iiwbbBOXOC5wck20LJNTllfaGrw0WzRZi0auxtNu+Xhlxjtf6AcD9F
6xdq/emi26H5LyXHrzQ6m4zNkDbbw0Tx81rBttfT4vfgty3ldayBd/YN1/xo
8X5kwfPL2nWuxo3CeLpo/0ejoPe5NtsYPPS0GU9wAI+emO+OOT61ImddgOsb
GcvyvmSZK9m6NG4UneHSxWUlY3izvvdq3JvYz6AFnTX4gsYY8dokbJ4Vn7u1
vy/nM5Dphxn7Xm/IBe/QHNVk38ppvKr5OxqLhfuCBq89Xv5yhtaOa7WPr9Y4
Q6Pa4Hd8eznsYXPYAP4PfyfUmQa+Dh1iyaaILelYA/9T0rZR9NgZNMfK3vJt
9lPsEBvfEns/H2RsNmp+uvRyU9G8H5D+vtQYIVnXi7/jMtbv8ozfjREPs4RN
q3TflzLtT4L+PNnjqIxpYsN8x94eEe1bdcYtaWNF7AMvYt6dKcv6KTrSmgP6
/knaz9Hi/3DRvCBjXpGpM7AaSgyTnnL6Nr/s38wvFm+DiqaLb6bztgl8E103
RTzeEtgOkhwNGhsy1smFjdbLBY2ez09sa+/kDtkbNoHPopcNoZubxMsNOneB
sOsW/1dpbE45L7AXHODhX+HXi4In5vjZ2LB5+H47+LxCvB8nuneL1k/0fV/O
cQ9s3wt8sZmHw2445904672Y74icsznsB19ZEfx3RzzC3taJ7u0aIzP2gSkZ
55YBLLDtp4TzFe3WB3FpRsZ+QFzZLzqniN68Zvsea/bprA/C39AB/ol9Eptn
RXyGF3gg3g6XDnfVHPvRJc+D8V86Pb9qPB8W7dezlnlb7Gcv2BE3iFfPZJzT
0E1D3jIREzi/N2LdkS2OBcSBDcL3RX3brvUnNTkPkYPu0rmnyTbezNh2X9LY
KHnP0bvzND7U+w9Kjh1g1hsyQnOK+HwrziW/7NT4rM7yDStZNvDnTPjHN5+L
Nex7I/Ze3eD35CZ8a13o6B+ytXPbzdN1zfbPSSnvezN4gPbkoL9M7+7WGJ+y
rC+EvOgPf6ceGBk2wLkjJXtHu3+fIL0fX3adUl+xz+Avn4mHVRX7K/60I/j/
vnQ1XaO92TGoKXxtstb2i+6PG5yjyFXkRs4/EDz0cm7Juj014gS6IHfjB+S1
z8TL52XLs6BkLMBhW9j62DrXR/BFDCFnnlZwrlyasd7INdRKT0e9NC14hU9q
vrRs7HHxubnB9tEddRR1Q7XOvPEb/q6SjTVXXBelio6P+OaeZuMCJt3BGz5I
HnkmcskZkRM4u158HlZ07t0QNQrnXCh6W8qON8iFTMTwn+n9UTr32ZALHQ8R
/VEt9odhGs9VHROJK+CHPWFLyI2+oAM9aFCfUCeWQ0b86f7wKfz6vqivxodO
OIu66sM4d4Z4ubhi7KgFBkc9gH+DH3aIvqlboAPunM25e4Th7TXHOegtDZrj
JPdgYfJQk3POZYEttr488lFn5Lqvh52PD95qzY5NxKWrRX9PzXa/NPS/MnGc
wE7A9ZvUVwX7HzGdd+BD7CKP4BfYBLGPvI/uqeHB4kTxOVJjh771N/hJzYXf
nFW170CjIejga8zJww2Rp6ghn5QsT2n0iOe3sv7NnHqiXjT+mNivWIN8DNZg
8+QR9I6+VonekLJrym9p/r2KeSVfUxMQr8dHvIP/iVrza/H5ZaPX4aO875D+
FrcdipfMh6cd22+OOTbCPs49t+J6DnyJieSQQtTOjflDWDaGvJdr7eySZSMv
d4ePNMacnHtNu2s4ML9W9Dvz1h2yUq9i5/gKPoPd0idgL2B7fto5CD5HtDs2
gR++2d9qf58W8wX1fn4S8xXiq69kjOgFsFdsFT96v9WxaIkwXlt2bXRR2nUK
5/bpnFXEwWbnfHI6Psg64h018G/LjncD9fK2iNXEZex0cvRBhSbnefI//oEs
N5Xs//htb+RZ8hr+BJ/YLTXX/JJz10k6s7XNsaEj/Affod7mPbELX+VMbAx9
Tgpbgva+wJD8B96vJdb/vsjv0IUWOkE+8srwiLFgNy/6qfcH5s3GGT0cITnW
CquhKfv66pr1Nzv2gnmn1txbNU/EpVzwPCryITUnfe2sducRbOQHYSdjWiz/
xqjvLogajzq9Pmp1MMiFHKzjiZy8Zy9nkWPGxPcO8TlefI4O2qNjDf6Bz4AV
T/xmoI5mfjAvZ93D8p5ajRiF//5Itl0uuj+gz+2INWfpnK688xC5/cqs6Xyj
5l4OLKdob13kjo+E1Wh6PO3fIcySonuRlha/Q3bifEvMcwPzOsc0vuXC94dF
r32s6P2v4PzRIZozNL8jZTypm6mTZxacb7Bz6DUHTWwWPwSTxRE3wGKreH66
Ynn+or2VmmnRSy5qcf84NHgAhxWivVxjarPrwe1514Tse6Xgvcdr/ouSYyF5
hj4Z26AX7Io5fd3c7KE+el68n5D3/Qj2g22CK3GAHI6dEiv2Ruwgp7Mfmtgn
dfWk6EOnibfX8o7ba6qOBcSB9VXHFOLJbzS/r+rabVP0JMS9gz1V2AV+T737
cPQRh0dtg11vr9i28f8JkbuJ7fvjTmaK8Hiq6hp7QtX5iZyEDk+pWY85PV/N
W0bqHHI0+YJcSk1C3Qbf0wIHepaegfsN0cxV3MPB78fB89CsYxy+T18IT3y7
QWuv0ahmfZdwTNn3AvBKDkMu7DRbsa3uzjr/gSE23RHxinsw/JUYxZ1HPut7
D+4hrq+4V/1vwfaKjDU97ym6H+Oe5M2s9+0vuB4lz9GzQYc7vV6tXVyz/ZH/
+E4t0Rh3geyFL/gDq0rRfovPUn++Fe+xn/6Ib+Rn3iMj9x89FePzmPZ2a96R
dT5/MnI69zZHZH13s1M49XHHlHEP8UiLbW9n9AvImBKN2Xn72natX675zOgX
O8J/4Qn90uut0PejqsaCnEWPTd46VXL/vWjaQ/R8sObzLhH9mRVjgM+jH2y1
PeoP6qvTC74rxGf/qucrZZ+L7b4e+7AL7AM93ikehlX9bbnWLis7RtJzvFt2
3zFY339e9H0edO6IPnc++hQ/hcANPrCTg/1q1n4Bdk1Z28vW8C/891Ltm1Xx
tzY9z67afuml/hl9xD06f07e94S36XlluzHCpy+q+qytWrMk71oeXTWFvojR
5G+wfjVyC/b5pdZ/UbZuwaAjcFgpjNcUrYfbNF9WdKxcp3Me5d4k7u8Whs3z
m3xO/sWmuWsg9nJXnQ4bJcfujfoEuy6Ej5Bfb4299PGbyu7TsWn2Yf+cObHs
dVPFw9FV2/p3Jeu+ou9euG8mhxGTuQPobDp0H8aT+Ens+UrEH2hTN0OfuPJR
xBbuAdAtdSCDuo3aCZ1fX/K3M4XJiKLjU4v09VDZ99C3ip9c1Xws0ZpswXdg
5M9qzf7YEDUmNLkb2R71JL1JT+QX/AM/ITdxb0GfQ2/CHfWc6E/pcT8vuk8g
x1wVmNNPHF1xrUZeXR33JeB/d/Ts9Ezz4j6EMTfuJD+VHCcXXIOTQ7riXORY
UrUsxMvrImbOjDuXxyPmPRF4YhfYOLZBjCDG8fuoorEDN3R4TOixeSDnp8wH
55L7Lim5B6Duoxb7asH2ckTZtKCzSLzcWLH9dsU9DzzDH75H7MWPv1OxL5On
l0W/Rd9/oOR4uqbi+z7u+LB1ZKV2pc48P+ZLi/YHfq+q2Q/xQXyBOpU6mRrx
orCZVTp3Zdn1ILXFcXF/ia2uD96oE1mLvOgfOuB2S9S1+AV9x7a4g+UOrC96
GPpyaqyF0auTE+k3H4+7eXTBu+nxfnHoBb+jLqB+hya14kCNSV8E7ZVx7vbI
78Q4Yh0xlvy8uur8u7boeIHMD9Uco4nPxErum+gr8Y8Hw0e4X7827tivK/n/
KPhYf9x3EA9fEJ078q41DtYbcadIznyjalvHD6eGn5LHtgWf/wfJO5Ea
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllnls1FUQx18pS4/tFrfb3+5WBZRyqgTCKQICohxVIKJEoiClQEW5NILc
QhCFhEKglBYwGkBAUdA/xANFjEEoJICJiVeIBpB4JiqnkUs/X79/TDLz5njz
5s1837u1auaoGU1CCNuhptDIdAgjoCHNQuhUGEKmJITLUQhb4ddCVegWQC3j
IeRDL6PLRX4bXV+oXSqEoVnkvBD2EeMK+n+gwTHHGI7tA1AJ8lnkXejegobB
V0DPlYYwGxqH/+PQqmQIJzIhvFOET0EItejGsHYHtt2QG9hrI3uOxXY38lL4
4cT7Gf5baCP8SWyuJ8gNn6+Rf8N/Afx8aGpZCB+x9gj8jZynFl0L5HfxrWKt
jv16UYPN8N1ZO0TujdAa5PXUqwW6msixa6GL+M9FLoafREFz4NexdprYDfgP
Jb9u7HmpOITz1CdVZh/Z1rHWwH7LkUfj3xP7weQ+HblHDpSw7l9s6gps0wd9
X+gI55/RzGd/An1ugWvwCvwEfO7Etj9yNfrDipdLTZDPI3flDCvRb4JGIO8h
x+XEWwH9gryS+o8uss3N8C0yvpuF3OEiavE+9uWcrzU0i/M8C71HLouakzv6
74k/HLkEfSPxJqbdOx+yVpd0jVSbycTvoF5CHkXso8iPoa+N3IvbgnNfypkO
xHyGFzn7MvZfQm0WQ3/Bj2T/Qez9JfbV7H0DMS9qL3yuoN+Q9tkv5Xmva9DO
Qu85Gd/qMud+DP9N2A+K3Fvqyb74bibmaexPaSbI51XyGYi+ErkSXSP1mcd+
q2K+qxXYHIr7zh7C/wI209BfzA/heeQmxO+Z4xp2Ye9Yyrn+Wuxe1B6KrZ5s
idwq8mxlGdyukXtKvdRY4NkYkHRszchK6rMG/cN57vkc+M5Z98J8fK6T3zWo
ZY5z6kg+M5Ku/THoMPGPRL6bvejnYjsPOp7nHskQ6yvOcw+6BugqtguJ0Sru
mm5Ffg0aBL8Dao59MTSPu/udnvoO3/vTxoKryC8pN9ZGxHynA+AnKkfO8wY2
B5APYP808c9g3xt5S8azKYzRWcqyjqUzDUU3BDpHboewKYbfSz6tE74Txfoc
eibumOLr0Xcr9NotxN+U8Sy0Jv5txD7HWnP8E1Ac+zHIy2K+82bIMSiTY0wU
dggjhY3CkBdS7ln16hf0103YbiTn3uT2Gfo/4P8s9ez/j5HYd4mc+1ni78gY
c4Q1szljZ/olF5tGeuEn+uUYsdvi3zXfGFSP/XqoF/Uej3179msHVcQ8Qyfw
3Y3PnoQxpDZjzBfWj1N90d2V9V1dzjEW3I3/j4XGhJ3k9iZ0MOY7qxFWlBgb
RhNvvLACWsz+ZUXGznUZxxaGdiL23yXGrq3Yn5It8j78p+cZO/pHxnJhyJYS
z6BmTzkMw74i497XjOutWE3/noz7zdiOPBCfB2PuobMlvkPdXTHUD7kg615S
TRqw35BxrdSj09hrbsrYlYRmJj0jmg29ccXwVcRYHXOPfRy559XrelPaZ4x5
wjq9AXqLKpLGFr1J/fDfD02NG1OOoGtX5lr1yTV2j4Su5xvDtxHrqaRrdS/y
k0mvideMrSXXmqxrr5kvInYi7bdVb8g28nk9495RTQ6qtyK/dR+Q4/rIb4Le
As2A3qohxDwZ/GYJW9WT6kVhbE3SPazefVTvN/wc9X/cf4jF8EvSfhvasl81
vVmJz/HgN6Ije3WIrBOGfpo25gvrVZNP0O2PHFszJqzMjYxdwswfyKUN1DNh
TBqr3oLOxN1zX3M32ax7SRjVNOWZ0azozjpiW580lsrnPmzLU35ru0NTSj2z
mlW9qReQlwq/Ej7DhLRrqNrlxf2XEWYJq/Sn0WwK04XlmtHJaWOqsLQg7r9U
Zdq++lMJOyelrROGlpf6j6C/gWZsTso9qV5UDlPI/fase1mY0wb7o1n/lYQB
G7Cvz/pvoz/SbHxnpf130R2pdjqzzqoa9oBPp4zlwjhh5TeR/0rCzF1ZY4Kw
QJjRQKzLKb+lwrA21LM847dPM/gfuwFi/Q==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8888078253679134, 0.8890746091596268, 0.8575038953063449], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl2uIltUWx/eYM+P76ut78X2ed+RUMwOazsAhgi6jBg2ntLKiUorIbjYG
XUAdD0XXc+qcDzpdIK25aNQHtShK0bAgo75ENygr4lgzdlNKT3HSQwldaKz/
r/8a6sPm2c/ea6299lr/ddmd169asnJSSqmvKaXj9B0spTSk8XRLSme2pbRA
o1v/qxspteeat6Y0qeJvQQy/llPq0rx3sr9zY75nekrvalT0v1r8/UXv9Wu0
S/aQzrpaMq/S6JiW0reS847o32w2D7yfi6ZzmmWxtkfnHy99loj/uEx6aIwU
Urq5mtJWzec0mW9PyHlH9H8R/aWiv0Dz0VpKizR/Umdt1fibdDpZ+00zUspL
lnFT1XJ2VGyLWfDqjK+lx4WSeUjf/2r8JJq/i+YTnXW+aGYXTfc7favXi7LD
STNTervquy0TfYfGqM5eMSWlGzS+lpzPCp5jc/g+DZn8Q4cc1veFTPRizll7
JpsGOeh4KPScLh3+p3m3aKbrjuU2/18sXZZr7JNtDwY9d6mU/N8l+lXyyc2y
V3mq7Kv5sMby2DsY9Nh9QGdc0uLzWMduK4rGRSZQnSsZ94j3qPY3Sv5HU63n
S7LzdK1fLtoRzRdVbT/8+Y/cstdp7dd6SntFP6r1lQ3ja4tst1dyDuve49o/
prGhYL/yXajvQsnYLl9/r3PPlJ3aNQ6KZ1AyhjSuk65JfmiqWNdjZeN4AsPM
wcwE1sEbA/r1zfYP/sDPrE0KORcVvL9UY5bO6w0brZI+qzUyrd1Y9Pd8rY9l
jivOWScZr2usrZgH3k+ScbhT4xvZ4VHRnyO7/DTF2MXu2BxMdWrMl/4DJc/X
lYyzjljnn3ldPI9IRlNmH+FT/PmazjpdOv674XsRk8Tcy9rPpe/iVuvcL5p/
NbyGP/eGT/n+J+aHy54vmGzbNIUNu6TDMy3GJBh8vG4ccp8vmq0bftqt/ZnS
bZswu0+x+YL43mvx+a9J5hHxHda4TzY6W/fYNMMxBD9yOHdE/u/J/X+kbJ32
az6zzbgBK/D/MMX56GONsVbb/EHRrJfMB0rGTofGGbrX8+LbWbefH5P8ow3L
7NVdrtBYK95DU4057vGWdLshd0ysqRjjxOzZWntW/N81Wz70YIZYHmt2jL8u
3uWiWy6eE3TO8Q3bm3g9GDHeU/D53Hdc9Ns1LhD9d/o+onG69i6RjOHM+QSf
cAY+4jywmsvOp9TMA/2HLdYBOvJ+7U8+AyvghNzSHfN6wXG2QWOzZLycGZsP
S+apuWWhU3vc8USt3am9XZr3FYwL9Jgvm89rM0awXXvYvL/gWDyArSKvce5n
ssdg1efvmOz9s/T9Ueuf1s13pWw+Vva9iAtigLwBlsARuYV6cqBmPb6RvL2Z
44W6sb/ms4c0HxEehks+q6/o2LlXd/ln7ljv0d78krHbLhknauySDifouwE9
J0X9E+9oi+/YE/TzSp5z36+0fkbJcQfeFwfmyRHYjDxzn+74Zea9ewvOKdyJ
nAbW8Clx/FXmWP7dB63GFXH/aNX6n6d7nTTD5+MD+OHt053ezHxPsEZtIM/M
1/rMmnH3UeY8Tg5HP77Yk5y9tuo5NQN/4TfiMy+6zg1UnFuo73dL5i+Zz92S
GUPg5w7pdnube4c1ufMOOWe87JjA1z9Il7+KplqyjtXQsxb/4JUzK1FfO6IW
gMeHpNvl05y3npDO68NH5JruwDx4fK7tj7xVC5nYOFX+6H+ORb0gN8/Lnc8e
Jn+I9/6oew/FWfgLX7XHYI6tmJOL6IvI/a8UnJO6ZY/3NV4NPCObPEe9Wxh9
1Fztd2XmuU7n35WHfaaYDhrigHqAr5ZFXCCHtT/7kH/wjz3ALjYB12AZrD5X
c/4id63I7T98R4yNhXzw/Wroj92xPzmHPgA+YghZ1DryPHWP+gce+A7EnBjg
H1qwCB/3op6kqMVdOn9V1bGDX5dGTgNfyEEGcYJ+6Iaf8Bf54jLd5cGGcQCm
xqMHWFm1XGQeFc1SfKr9bTX3FhP57vu4C7Xk56L9gZ04E52JS2IYH5N/wAK2
pZ5T17dGHzoreijyM3WK3DsQNkHWi8LSPbn7AnIAOY/zoT0S9G9kUTOK3kMv
Yvz/QbM/6iD/5PjB6PHJCW9nrlXgmrif07C9h+MtQO+xLnoT7kXvCT+89H8D
UTexKTbER/ANBi8+PxA6kbMX5b4D9WF9zfmpM94A9O3kSPADjqinT0yzX8nf
m8vO4b2BM/CJPenpOas3cIc+xNuW6EXIKdgaO49GvYf3QulwEXguWvaWkE8P
NRD+OhI2w863KlfcVjem94cPqL+9stlpuel2y4a3qO9/quweYiDqDjo+FXp2
xltg4k58kUPup/fC7+QXfIkf6R94b1DHF0v+t3XnEvr0W6JXJ/6WxfsCjI8H
zvEX/OBsI3WMelZyDX8m6jo9CLbGzrOjX+EsdFwWfSP2JFYOx3sEfZDdEzWb
eMEu9PrEO/3Xxpp7MPIW+WsiT1wZMvHJjtCNuv1u7to9HnfAz3fV3DeAfXqv
vuizwTr7+JH+a0PdPdhZDfsDX+DPzYGBa7R2bcNY+0C07+WWBdbo/T6OHmlz
+BR/7Yw4JadeH3mVGKdO4yN6wE01YwH7YQdyGu+ec3LnPOJgR/TwQ+SWhvn7
o36T+38h/xQdT9TP4Xj7kMPBJnkcjNSj3+ONyz2IF/q+ubnzHzJ4PyGHuMOW
YIC6vSB37SY2RyL+99XcI+LrL6KnXBBvSvBOjJPnjkb8bpNe2+t+69LPEEsT
7yYwyBrxip/AEvl/RbxtJ97SxCDYWRP4IXf+GPmTdzi24F2wK/IsccA+ORj/
/gasYkkh
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllW1olnUUxo+WW8/en2fPfT/3IF2Dci8V0YfKZqBUzHT5oYX7VOl0QSps
LjB6odS+lNPAl7XnmZJ9KKNoEwrrg1HfEgLLIvBlI8lIrFEWVqih0e/y+nDg
/7/POdc5/3POde62tcN9Q3MjYjNyI/Juc8SKJGJrLmKkOqI1jXipEHF4XkQX
945SxJPILXUR99VHtGPfiv1h7Lu5j6MbQ1qxX4PNQvTLsohF6O5H/itG/APe
vzURe/CZRTeUB2sOmA2cifcsktZGLCfeILYf47MS2wPg7QNvC/FS/M/wrQ/b
v7G5wv0ysprY/cjvjRFt2P+M7d3o7yWfFeDt4zzSEvEn+rN82y0dGL3opudZ
twT/76tscxR9HTmeB+vXOr+tggzU+Y27yWcU/XbetgOZ4f4A9y7On+jNYFfA
+BHbKzeRF285yHufqXGN70G/q+DYinkB/WrkErbb0I9iOw5eGaxZanSE2Kuw
7yf+G0iFeG+iH6+3zX7u87E5Sf0muHekrrFq20vMNnw7qMnnYC9FFnAeJ8a5
WvfwbWIfQIoMxSnyuZ16zOCznPMPYHyL/XFkmnp9gf184j2UuBfvY/MRvt8h
63LuWSOx61UPdL+R70byWY904N9IzJc5b0Vu5bydbz3kMoV/L763qafEvgP/
Jt5SQDaQzxHivUdvDiKdiXNWrnqTavcoeBdrXMOV6i3SU+Vvj3NeSozXwjPz
IvhnqFcx5xmfRNeV+G0j6MvgVZBW/E9Q/yFsh0vOvZN8V4E3lxpcw/YqsrHF
PVOvlOMh8JdpRsH+C1nLeZ0E2yUQbpK3LcD/A/A7ed9zRfdQvWvKWTeVeZZk
UwvezsyzdgH/9cR6h3wfBK+dmHei25D3OY/NGOev0A+iT+jpT5q1xFzuA+9c
4h6rt+KAan2pYF/V/OaSZ06zpplq4Px63rXoB/NDbC/zbYRcL/K+VzlvK5lr
4rC4urnot4izqtUNfKvkXLO9nMcSc0McLeN7CvyGanNMtf+jaC6oB0+gn0bf
VO0d1M59b95vU017qO1UwbVWTx/mPllwbuqBuPwl91/qzOnF6PcXvAsWYb84
88xp1sRh7SrtGO0W7aydJfdAtRcHr+eaebaV8wS67tRY4vwOdLPYdGM/Ct5V
3notMRdTcj6L/enEs/RYlbnSnXkWxJlyZo6JW5V6v/2pknebavBZYk6IC5oB
cesFfDbVm2OHit5h2l3iVFnzjf95etNC/OPYf5N6FsTZE+CdTNxb5fw1umOp
c1OPn8/MEXFDMbRrFxL/WIN37mlitWTe7eLcK/h+2mxuq+eKrZ2uXa4c5jSb
Q+JOCt4w2I9k/lfon7Al9c7SrtKO2JT6H6F/Q8J9gPOa1FwaqPEu3tXsWmsn
7wHvaGKddtrT2A6mrr04oV08nBpLO/kt6nVX5lxmwv8u/eP0b9M/rLPkf6D+
fdqZ2r0Tze7N9R2s2U68u7Qz/wdsyf61
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{3251, 2756, 535}, {5951, 6513, 3071}, {5329, 5297, 
         222}, {3071, 2783, 603}, {2607, 2696, 1220}, {2697, 3148, 1221}, {
         2613, 2804, 2612}, {2796, 2794, 1201}, {5836, 5837, 2938}, {2794, 
         2795, 535}, {2783, 2784, 1302}, {5686, 4753, 2778}, {6443, 5605, 
         2697}, {3072, 3071, 603}, {3326, 2938, 2617}, {6136, 4779, 3278}, {
         4827, 6443, 2697}, {4805, 6156, 1576}, {5594, 4834, 2686}, {5742, 
         5744, 2836}, {3148, 2778, 1221}, {5293, 4422, 180}, {5930, 4503, 
         1427}, {3327, 2939, 2618}, {2608, 2607, 165}, {4708, 5930, 1427}, {
         2792, 2793, 1201}, {2608, 2713, 2607}, {2618, 2939, 222}, {2685, 
         3326, 2617}, {4780, 5700, 2793}, {3071, 3273, 2783}, {2617, 2938, 
         221}, {3278, 2792, 221}, {6110, 4730, 3251}, {3142, 2796, 1201}, {
         4781, 5702, 2795}, {2757, 3124, 1090}, {2696, 3147, 1220}, {6265, 
         5737, 2830}, {2686, 3327, 2618}, {6017, 6018, 3147}, {5703, 4782, 
         2796}, {2612, 2697, 1221}, {5737, 5739, 2830}, {4806, 5294, 1576}, {
         2804, 2697, 2612}, {5524, 5523, 2608}, {2780, 2781, 165}, {2685, 
         2617, 1089}, {5746, 5742, 2836}, {5528, 5527, 2613}, {4752, 5685, 
         2777}, {6156, 4806, 1576}, {2778, 2776, 1221}, {4657, 5604, 2696}, {
         2686, 2618, 1090}, {5743, 4517, 596}, {2756, 2757, 1090}, {4731, 
         5663, 2757}, {2782, 2780, 1302}, {5593, 4833, 2685}, {5690, 4761, 
         2782}, {4760, 5689, 2781}, {5838, 5839, 2939}, {4763, 5691, 2784}, {
         6513, 4762, 3071}, {2793, 3142, 1201}, {3124, 2686, 1090}, {5450, 
         5028, 2531}, {5583, 5584, 2672}, {5418, 4524, 609}, {4517, 5357, 
         596}, {2776, 2777, 603}, {2613, 2612, 180}, {5298, 4708, 1427}, {
         3273, 2784, 2783}, {3123, 2685, 1089}, {5999, 5998, 3123}, {2777, 
         3072, 603}, {4524, 6264, 609}, {2713, 2696, 2607}},
         VertexColors->None], 
        PolygonBox[{{5684, 4752, 2777, 2776}, {5745, 5746, 2836, 1220}, {4779,
          5699, 2792, 3278}, {5712, 4827, 2697, 2804}, {4730, 5662, 2756, 
         3251}, {5297, 5298, 1427, 222}, {5685, 5952, 3072, 2777}, {6132, 
         4763, 2784, 3273}, {5689, 4420, 165, 2781}, {5584, 5418, 609, 
         2672}, {6000, 5594, 2686, 3124}, {5527, 5712, 2804, 2613}, {5523, 
         5618, 2713, 2608}, {4762, 6132, 3273, 3071}, {4833, 6171, 3326, 
         2685}, {4501, 6110, 3251, 535}, {4834, 6172, 3327, 2686}, {5663, 
         6000, 3124, 2757}, {4753, 5684, 2776, 2778}, {6019, 5686, 2778, 
         3148}, {6018, 5745, 1220, 3147}, {4633, 5690, 2782, 1302}, {5744, 
         5743, 596, 2836}, {5662, 4731, 2757, 2756}, {5699, 4780, 2793, 
         2792}, {4761, 5688, 2780, 2782}, {6013, 5703, 2796, 3142}, {5702, 
         4501, 535, 2795}, {5839, 5329, 222, 2939}, {4420, 5524, 2608, 165}, {
         5952, 5951, 3071, 3072}, {4422, 5528, 2613, 180}, {5605, 6019, 3148, 
         2697}, {4782, 5701, 2794, 2796}, {5341, 6136, 3278, 221}, {5738, 
         5999, 3123, 1089}, {5688, 4760, 2781, 2780}, {5837, 5341, 221, 
         2938}, {5739, 5738, 1089, 2830}, {5604, 6017, 3147, 2696}, {5691, 
         4633, 1302, 2784}, {5357, 5450, 2531, 596}, {5294, 5293, 180, 
         1576}, {5701, 4781, 2795, 2794}, {6264, 6265, 2830, 609}, {5618, 
         4657, 2696, 2713}, {6172, 5838, 2939, 3327}, {5700, 6013, 3142, 
         2793}, {6171, 5836, 2938, 3326}, {5998, 5593, 2685, 3123}},
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4503, 5930, 4708, 5298, 5297, 5329, 5839, 5838, 6172, 4834, 
         5594, 6000, 5663, 4731, 5662, 4730, 6110, 4501, 5702, 4781, 5701, 
         4782, 5703, 6013, 5700, 4780, 5699, 4779, 6136, 5341, 5837, 5836, 
         6171, 4833, 5593, 5998, 5999, 5738, 5739, 5737, 6265, 6264, 4524, 
         5418, 5584, 5583}],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4805, 6156, 4806, 5294, 5293, 4422, 5528, 5527, 5712, 4827, 
         6443, 5605, 6019, 5686, 4753, 5684, 4752, 5685, 5952, 5951, 6513, 
         4762, 6132, 4763, 5691, 4633, 5690, 4761, 5688, 4760, 5689, 4420, 
         5524, 5523, 5618, 4657, 5604, 6017, 6018, 5745, 5746, 5742, 5744, 
         5743, 4517, 5357, 5450, 5028}],
        "12"],
       Annotation[#, 12, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4431, 4449, 5277, 6191, 4865, 5717, 4866, 5379, 5378, 5758, 
         5046, 5757, 5760, 5759, 4641, 5416, 5417, 5279, 5278, 4497, 5405, 
         4498, 5574, 5573, 5729, 5728, 5755, 5730, 5731, 5575, 5927, 4499, 
         5377, 4500, 5577, 5576, 5733, 5732, 5756, 5628, 5629, 5550, 5672, 
         6378, 4462, 5673, 4463, 6216, 4902, 6215, 4903, 5407, 5406, 4502, 
         5929, 5928, 5981, 5980, 4570, 5982, 5983, 5974, 6438, 4553}],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5266, 4440, 4416, 5715, 4852, 5714, 4853, 5374, 5373, 6169, 
         4825, 5707, 5709, 5708, 5215, 5358, 5359, 5272, 5271, 4487, 5375, 
         4488, 5902, 5561, 5591, 5590, 4586, 6283, 5008, 6282, 5009, 6284, 
         4619, 6028, 4693, 6074, 5916, 5917, 5019, 5238, 5237, 5503, 5018, 
         5443, 4893, 6295, 5017, 6293, 5016, 6294, 4490, 6507, 5562, 6506, 
         5563, 5538, 5539, 4457, 5540, 4458, 6189, 4855, 6188, 4856, 6203, 
         6204, 5083, 6317, 4894, 6316, 6201, 6202, 6157, 6159, 6158, 4568, 
         6039, 6040, 6036, 6038, 6037}],
        "10"],
       Annotation[#, 10, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4432, 5104, 6479, 5105, 5424, 5423, 5960, 5959, 5646, 4706, 
         6088, 4705, 4868, 6447, 4867, 6448, 4869, 4709, 5647, 4710, 5648, 
         5961, 5962, 5425, 5426, 4936, 6451, 4935, 5330}],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4550, 5972, 4735, 6113, 5027, 6168, 4822, 6166, 4821, 6167, 
         4885, 5723, 4886, 6197, 4850, 6186, 4849, 6187, 4456, 5637, 5638, 
         5636, 5635, 5531, 4663, 5268, 5267, 6049, 4665, 5625, 5627, 5626, 
         4631, 6034, 6035, 5831, 5830, 4441, 4417, 5748, 5749, 5747, 5751, 
         5750, 4826, 5710, 5711, 5521, 5522, 4443, 5823, 5822, 5693, 4768, 
         5692, 4769, 5694, 6027, 5608, 6435, 4658, 5619, 5525, 5526, 5828, 
         5827, 4803, 6153, 4669, 5537, 5670, 5671, 4739, 5250, 4552, 5478, 
         5113, 5784, 5115, 5782, 5114, 5783, 5273, 5659, 4492, 5566, 5565, 
         4696, 5643, 4864, 6087, 4704, 5923, 5924, 4494, 6107, 4493, 6348, 
         5156, 6347, 5157, 6349, 5154, 5496, 4597, 6419, 5155, 4740, 5546, 
         5545, 5544, 4671, 6278, 4996, 6277, 4995, 5224, 5223, 5453, 4994, 
         5439, 4829, 5741, 4984, 5740, 4983, 6274, 5364, 4448, 5222, 4901, 
         6515, 6516, 6500, 6502, 6501, 5363, 4447, 4426, 6368, 5529, 5516, 
         4637, 6054, 6055, 6052, 4673, 6053, 4430, 5219, 4672, 5547, 5548, 
         5549, 5645, 5644, 4461, 6214, 4899, 6213, 4900, 5086, 6476, 5085, 
         5241, 5240, 5512, 5044, 5454, 5045, 6042, 4640, 6041, 4639}],
        "8"],
       Annotation[#, 8, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4504, 5242, 5087, 5775, 5776, 5772, 5774, 5773, 5286, 6329, 
         6330, 6328, 6332, 6331, 5110, 5112, 6480, 5111}],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV1XmUiFUYx/FXEUYKYVDJjOWEKIVzlMjYjcqSrQYxZYnsJ8lSlkiSSJyy
zWQ7rcjOYMaarR0V2Y1tJGYMZetz//ie37Pd5z7vdt+47v3b9MsTRVHSHVFU
tlgUDbsvikqUjqKrRaOobokoyqXF+ZWKR1Gy/A/yify9tIN8R1xkryoVRX/T
1XSW2l9jo+g3xCMO5dDV+hs4q6avvmfodX4XbNInHRkoUzKKSuMzfWbT/HQW
LUDn0O/t007dTpqixy6aSkfrs4O9HTHy++2RxN4pvt3+nWlZ+hBO4CTaYYe6
bTRJfgt9iW6lzcR32XM3too1s3ch+8TgktgX8vPEUjAXhcVS6d20n/2PyMfw
21ubxq/BvqxvNnrjNRwXzyc/gp2XTjBvPfd3PO2pvjbdo6ae/GL9KrEXhbno
bqzBeHXZZhovPoH9Lh1shv3WVpSvgM/FytP59Em96qCW/AJ189He+ifCfaU1
w7Ol6ebJS/MhTd8NSLB+EL8/BqAfXlE/kCbTOvbopXdPvMqvpkec66lO51nb
ll5SO4Y9k/0o4uUfo70xgN0rPC8z7cBxPXLVp6iP1zuVXuU/Lt7DPF1Rip1E
u6AzzluXhXHq3pYbS9+hH+AZ/SfRG/qUZi+01032YnqLlhFbxM7Fcb1O4CT2
6LcX56xt5NoaowkeMdMy636hV+TutH4DP5G/kJ8Q+tEh+nW3vhsa8W+aaZW6
6upW01v8xuKT2DnsDmEuFArPWOy2WBP5B8QK6lFY3wPi7cN7IN6Cvyeslz9t
3kycQj3+/PDuyFXX4xb/jPhZnAvvqvWLwzsV5sVt+RfCfdWvuf7d6BXxl2ku
zcE1dA9nBE2miepGhXuNkeE7DPcbOeKT7VtGzwfV3U8PIVOui9wY9imznUYm
6vLn6jkPKahojgqoj3iURxzKYY78U+rz61UgvKtiGdgc3gG9l9l3KSaqe8/9
moih7DeQLT/Nmo8xFTPVTaczaBN1L5q1Mf1I7BOxD0MtnUyn0yl0Gj1AG6nb
RxuG7y3U0xnINttse402zxhsUd9XvA8miMfyi9NCrjsGtdWn0INqD2Eif7Oa
ZmbJoG3VXjd3KX5VPQaiYXiP7blSPH84P/mtrPsnPAOxBP519gp2Nfnl9D/+
hXCGq8vQoz+9zI/0XSufrG4dzcPPFv+Z/y2/Km1ovgQ0QH25dOs34U/z/oHf
wzPSPx4L9D0czkAcRYJcg/DOsTNxGgdxCH9hhH5P23MkHY4xYm+Fs5DWtX8T
Wod2sl9jdiMUDfPhdbFi9KJ9h6s5zU/hN9Avla7jr8Uq+6/ECqSZrwrKqalM
l2CotRfCd8heH95F11mJzqEVaR+5bvp15yfjWOgbzg32OvqdvstRM5zDalsg
Ec3xLFqicnhGtCp9jlahz4fzLfw78DC/ajhX8Kk+h8XeDP8QdMAS132JDpK7
lz04vOt0KTqJd8QwjMUQuSy9f9SzqHwRFGDfQwvSGq49hh5TN1rsOB1nv6Oh
t9xk11QEU8xSNPy31fRhD6Ql1G3XO5ZuoyXDv9q6OLlZ4VxTVy2g/xq51ZiK
r8K5qdeXtCn9mqarb02P4ghyzP5N+P/K9w/nDz83XJteP6m9yx5nwjwYhQ3h
u1WXFu6t3PrwbprpJt1Ib9BNdIS1+/Tdj3/1u4araK5HVjg31fRQc57dAiv1
WhXOZ5RSF4tR8pPCP0bP92kWbSPfGhvZTc2xiba0vhW9i7/FmlryW8N3ym8t
Ptq9+B9liGw1
         "]],
        "6"],
       Annotation[#, 6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV1nmQz3Ucx/Gvdd/X7uao0BRRKa1rWoowUiRHxVpH5Qi7jnV1H6NUpOiY
KVEzSpZNKzdFuSYqZ2RRylVJi0w1qOjx/uM5r8/7/Ly/3+/n+/39Gjw4uueo
EkmSvJWSJAtqJknXtCSplpokNVAdo9ljcDnq4gEMxCA0F1+YniQZtIAurJ4k
jfgL6Ha6Da303ERn8NWhDS9Lkmuw0foqsXwcrpUk3cQ70Prs22kD2pHWo+1o
e7TFbbgVXeUX2ncxttQwM9+X9Cx7v9h49gSMwyRMxFC9qopXwXbswFK+d8WW
0PdoYq4l6jeYMUu/L2hfup6O5D+g5iAu8DWtnSTnaXk1l8Tqsp/VZ5J4GVRi
7+XvLb6Jvwt7M52q5rD79RPm6nsLe5RYmvVL8lNpHruO3JZmqsGuiXR9qtNq
qIoD4gXitdQ/EdfInsg/CWf0+YrvNH3BLPWRqf4W/ME3gZ6lj8p9BA3E26Ov
fdvRI3zP6PujGQ/hB7RmJ3qWwGr2GnyK+/VZZO9Z/B/Td2hPOoz2pkNoLzqU
DpNbFM8IZ/S7wX6naTnzlKPpsWc8Y3nT5VRmTxbrYv0qXon7yteZ7w7M1fdQ
nI24z/g1ZmcfxQF8j4PozF9E92OzmY/Re+Wf4C/W72r2KXoN/ZbW1Lum3lPo
YDlDkMqeTHerG84/Ainst/UrQWfRzXH25D0W548+Tvfot9D6uPV9cbbk5sVe
rn0c7YZLahP3vEQ8V+yP+y+3JE3BJ1iMa/VojKXWPdSVoWXRXv/z/IvV/Kv/
PrEm+hfRbHZ/ZMV54utH+2KD/NL862kpukftSNfUL85+nHuU5P8o3m+slfeG
Od/EAut8FOnzInsfHaC2sppKMT97ofgHej7I35avDTJxVGyJ2Hg9W9PL2bX5
66AuLpNfKzTOfPjEW8VZci0r2auxCvl6n4n54z6Ib6Bb43uAzmKfyVmLT/E5
1sX1yFmCxu7DUloFT9rvqfimqeukLhsvWzeL74S+N9Nc8RwcEtutT666nTSH
7qLzIpeOYG+LbwXdQT+TP1jdEPzpOma6V6/jNXQQy8IW662YY6/ZKIzvYtxj
zI8Y3xX65+h3Qn6u2cvx59DytCzSkYZv5GySuxm19TmrdrKaNPs/R5eLr8Ay
9DRjSfHPaQpdR3+LZyLWCi3RTI/eYnn8n9DD7Az+5miBLvoOEJsvtlesHF95
9Of/lv1hnH/6Pp0X5yG+4eZYEL8d6BfnEk9EPv9U62l4Sk0T2hgbcbfZPuLr
4JoL6D98hfLP6deOXdqepdA9ni9txN8wvkfWhfjPvbmIp9XsYxdhJlLlz6Bp
dGx8B/QfQzPl9YpnHc8X3e3RQuzueG/4L9Ee7MQcD5t9GHbxV+S7KNaH/y7c
iefEdupxT9hmKM3+hV1o3YPvY7oILdX3RH89sjEREzBD/ilMsi6mGXJ6YKUe
/8W7ELPbMzNmp3loE9+WmFlslpom+l+HG3A9Bquv5/4cF7+S/kzr02X0LzN9
RR9X18u6N6ZbL6O38z9v3dV6BZYjg28a33DrEfEs2Xvpu7SROd6jczDOrONR
bO8LdIacXfbcjZ1xTuLbiyv568V/ELUn5Z6X+zvNo2MxO2ak98q5SX4Z13nS
Nf2OYlQ2yxl6Gqfi/RBvFu9W/MbH2Y13l38XdmMKe1X837DfStpd/Tn7pbMb
2aOq+H38Fdjb+EuJr2Z3Yq+h++R8h4fiP4zcfHt0pAvoIr6/xb5mVzfDN9Er
5uYfEN81PQbS/hguPgIPYxB7h5xW9tpO++h1fxDfhnjf4r+LvL7IQh9kox8q
y2lOq9KbaZV4Z+kx2s1+x2nr+A3Qe1T8x4vfNHYW+zF7jWE3Zd9ov5swh+8I
31Fs0qdCvJO0Is2O34v4HWbnIBeD1QzBULQW2xPvNv4HGNt20g==
         "]],
        "4"],
       Annotation[#, 4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4402, 5809, 5022, 5344, 5343, 4469, 5554, 4962, 6414, 4572, 
         4997, 4642, 6430, 4643, 5207, 6108, 4726, 5963, 5964, 5965, 4758, 
         5968, 5967, 5966, 4727, 6109, 5243, 5244, 4750, 5682, 4751, 5683, 
         6016, 5603, 4815, 5705, 5518, 5519, 4405, 5307, 4407}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4554, 6408, 4741, 4771, 5696, 4770, 6134, 4399, 5202, 4949, 
         6409, 4555, 5430, 4556, 6123, 6124, 6120, 6122, 6121, 4450, 5299, 
         5094, 6324, 5095, 6325, 4921, 5097, 6478, 5096, 6237, 4922, 6173, 
         4836, 5843, 5844, 5845, 5367, 4813, 6162, 4814, 6163, 5021, 4875, 
         6379, 4465, 5368, 6164, 6165, 6140, 4790, 6139, 4789, 5282, 4647, 
         5514, 4648, 6431, 5197, 5199, 6491, 5198, 5350, 4408, 6365, 5023, 
         5349, 5348, 5971, 5970, 6244, 4938, 6005, 4590, 4941, 4545, 5427, 
         5428, 4940, 6452, 4939, 5736, 4410, 6494, 5713, 5617, 4652, 5615, 
         4651, 5616, 5816, 5815, 4797, 6143, 6297, 6296, 5370, 4477, 5884, 
         5883, 5938, 5937, 4510, 6227, 4912, 6225, 4911, 6226, 5369, 5847, 
         5846, 6177, 4842, 5882, 6242, 6243, 4925, 6450, 4926, 4923, 6241, 
         4924, 6238, 6240, 6239, 5310, 4453, 6126, 6127, 6125, 6129, 6128, 
         4602, 5437, 4601, 6423, 5160, 5309, 5308, 5679, 4743, 5678, 4744, 
         4627, 6428, 4626}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5276, 5328, 5332, 5835, 5834, 6170, 4832, 5592, 5997, 5661, 
         4729, 5660, 4728, 5246, 5245, 4755, 6417, 4581, 4784, 4580, 6416, 
         4754, 4718, 4831, 6444, 4830, 4975, 4542, 6404, 4937, 5570, 4495, 
         5400, 5401, 5084, 6318, 6320, 6319}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5340, 4757, 5804, 4756, 5687, 4644, 6043, 6044, 5612, 5611, 
         5754, 5769, 4506, 6389, 5088, 4908, 5408, 4876, 5394, 5072, 5722, 
         4880, 5556, 5764, 6382, 4473, 5765, 4472, 6281, 5006, 6280, 5007, 
         5441, 5440, 4617, 6021, 6020, 6023, 6022, 4618, 5442, 6026, 6025, 
         6024, 5186, 5601, 4610, 5497, 4609, 5630, 5631, 5555, 5680, 4748, 
         4573, 5633, 5634, 5632, 5875, 5874, 4470, 6343, 6344, 5794, 5796, 
         5795, 5144, 5146, 5145, 4579, 6090, 6091, 6089, 4711, 6351, 5176, 
         6014, 6015, 5498, 5175, 5178, 6486, 5177, 4614, 5001, 6463, 5002, 
         5000, 5174, 6485, 5173, 5331, 4971, 6457, 4972, 4970, 4974, 6458, 
         4973, 4543, 6405, 4733, 4835, 5253, 5254, 5192, 5504, 5247, 5248, 
         4968, 6456, 4969, 4967, 5140, 6482, 5139, 4401, 5180, 6487, 5181, 
         5179, 5183, 6488, 5182, 4608, 4777, 6440, 4778, 4615, 4785, 6011, 
         6010, 4776, 6135, 5808, 6029, 6030, 5985, 5984, 4571, 5167, 6484, 
         5168, 5164, 5166, 6483, 5165, 4464, 6504, 6505, 6503, 5650, 5649, 
         5652, 5651, 4539, 6402, 4725, 4584, 5491, 5492, 5148, 5797, 5147, 
         5798, 4582, 5490, 4583, 5589, 5340}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{1, 4}, {1, 4}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 179},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->276152231]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7681],

Cell["Create data that includes derivatives at each point:", "ExampleText",
 CellID->55796517],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{"Sin", "[", 
       RowBox[{"8", "x"}], "]"}], ",", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"8", " ", "x"}], "]"}], ",", "x"}], "]"}]}], "}"}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3", ",", "0.5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->89317571],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "0.`", "}"}], ",", "0.`", ",", "8.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "0.5`", "}"}], ",", 
     RowBox[{"-", "0.7568024953079282`"}], ",", 
     RowBox[{"-", "5.2291489669088955`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "1.`", "}"}], ",", "0.9893582466233818`", ",", 
     RowBox[{"-", "1.1640002704689083`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "1.5`", "}"}], ",", 
     RowBox[{"-", "0.5365729180004349`"}], ",", "6.750831669859937`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "2.`", "}"}], ",", 
     RowBox[{"-", "0.2879033166650653`"}], ",", 
     RowBox[{"-", "7.661275842587077`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "2.5`", "}"}], ",", "0.9129452507276277`", ",", 
     "3.2646564945071357`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "3.`", "}"}], ",", 
     RowBox[{"-", "0.9055783620066239`"}], ",", "3.393432058695976`"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{488, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->238379788]
}, Open  ]],

Cell["Construct an interpolation:", "ExampleText",
 CellID->12252727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Interpolation", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->421319020],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "3.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{258, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->251616289]
}, Open  ]],

Cell["Plot the interpolation:", "ExampleText",
 CellID->285342954],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"%", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->368693818],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->195132544]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->531236255],

Cell["\<\
Create 2D data that includes a gradient vector at each point:\
\>", "ExampleText",
 CellID->55232974],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}], ",", 
        RowBox[{"Sin", "[", 
         RowBox[{"x", " ", "y"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"x", " ", "y"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{"x", ",", "y"}], "}"}], "}"}]}], "]"}]}], "}"}], "]"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "3", ",", "1."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "3", ",", "1."}], "}"}]}], "]"}], ",", 
   "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->132447345],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`"}], "}"}], ",", "0.`", ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1.`"}], "}"}], ",", "0.`", ",", 
     RowBox[{"{", 
      RowBox[{"1.`", ",", "0.`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.`", ",", "2.`"}], "}"}], ",", "0.`", ",", 
     RowBox[{"{", 
      RowBox[{"2.`", ",", "0.`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.`", ",", "3.`"}], "}"}], ",", "0.`", ",", 
     RowBox[{"{", 
      RowBox[{"3.`", ",", "0.`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.`", ",", "0.`"}], "}"}], ",", "0.`", ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1.`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.`", ",", "1.`"}], "}"}], ",", "0.8414709848078965`", ",", 
     RowBox[{"{", 
      RowBox[{"0.5403023058681398`", ",", "0.5403023058681398`"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.`", ",", "2.`"}], "}"}], ",", "0.9092974268256817`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.8322936730942848`"}], ",", 
       RowBox[{"-", "0.4161468365471424`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.`", ",", "3.`"}], "}"}], ",", "0.1411200080598672`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.9699774898013365`"}], ",", 
       RowBox[{"-", "0.9899924966004454`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2.`", ",", "0.`"}], "}"}], ",", "0.`", ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "2.`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2.`", ",", "1.`"}], "}"}], ",", "0.9092974268256817`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.4161468365471424`"}], ",", 
       RowBox[{"-", "0.8322936730942848`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2.`", ",", "2.`"}], "}"}], ",", 
     RowBox[{"-", "0.7568024953079282`"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.3072872417272239`"}], ",", 
       RowBox[{"-", "1.3072872417272239`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2.`", ",", "3.`"}], "}"}], ",", 
     RowBox[{"-", "0.27941549819892586`"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.880510859951098`", ",", "1.920340573300732`"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3.`", ",", "0.`"}], "}"}], ",", "0.`", ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "3.`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3.`", ",", "1.`"}], "}"}], ",", "0.1411200080598672`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.9899924966004454`"}], ",", 
       RowBox[{"-", "2.9699774898013365`"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3.`", ",", "2.`"}], "}"}], ",", 
     RowBox[{"-", "0.27941549819892586`"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.920340573300732`", ",", "2.880510859951098`"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3.`", ",", "3.`"}], "}"}], ",", "0.4121184852417566`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.7333907856540307`"}], ",", 
       RowBox[{"-", "2.7333907856540307`"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{471, 186},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->314672207]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Interpolation", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->167339111],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.`", ",", "3.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.`", ",", "3.`"}], "}"}]}], "}"}], ",", "\<\"<>\"\>"}], 
   "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{322, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2691194]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"%", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->373759667],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyMfQl0VMXy90xmJhMUFQMqCAIiigq4oCII2lcRFQXZ3OMCAg9FEUTFXVBB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   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNVD1PFFEUvajD2jjDx86wkJ1RVsWPFhP+gK0WZgwMWrALlkIkWUvBWm2g
sVATo5XJuPADBBNtLGzs0M6V0kSIreA5nkvW4mXeu+++e88999wZby3dWDxm
ZvewjmO9Gza7Gpu95L5mNl41ewaHzoDZW6wkgA3rc2jWgv1XZPYV59/Yz2dm
b2KdN+G7gfUC9td1s1dYP0/Jb8vffkHsvtRsFufR02Z3E7Odfn2f1LUvEeM5
fD/1mRWhfBlzO1Qc4qTfGtZT2CtDZv1DuuM7vr+Cb3fQ7Meg9qXXwrr47fie
tfHMXDOh8HO/4XVzz/vyP/um360jfxwIw67nWjmhL8+TuFseMfueyJ9c7LrP
SdR+Abw1YP+Dug+xbiL/vnNILOSNX+bNQ903YbsF/q6Bx+uB4jEucz1CjKlE
vDDutPMRBvqSh71I/Wt6H/e8l4zPM3MSf9dxTntevie2wntxBxgWsD7iPAYs
zUwxV2CbS9WrADUmsfLz/D4UV3xDPZG7Ar6j8IkcY+710nfH+3uYSU+skxhz
54F93/aYxDXjGiMHFzPxQM0Wbo9dx9yzNtZIDVD7D1LpqvAeMNZIrBqIn1zz
Sw7Z9w+h4tVi1UD8LXznU90dAO9qKpzEse61tIBrLhPvY3g762/XMHfnquL2
PvK3B9QX+i5kvT7Rzh41qppV4n84rBkmft7zPffUROSYj/TU8llsuw85KH0W
2tDqt0zcPK5LT8TO/ueuAc56mQjLYqIZZp86kWqkf+R8Me/Zqmo7mt+Kzyk1
vu//iqVEc8IZmYg1G9TvFN7eTlXHGezPxz3dcN7JJzn+pz/XecN1dBl1XMqE
izUdeF2seyvs6XzScTJexWPmfk8d0h67ZshT1/8njME72tnDmmv4L/LmvWE=

         "],
         VertexColors->None], 
        PolygonBox[{{7524, 5152, 1313, 3780}, {5197, 5399, 1294, 1358}, {7550,
          7551, 3775, 161}, {7309, 7308, 1682, 1753}, {7423, 7422, 609, 
         3669}, {5329, 7424, 3673, 3789}, {5415, 5328, 3671, 1314}, {5805, 
         7894, 4214, 1498}, {7425, 5155, 670, 3674}, {7913, 5154, 668, 
         4271}, {7720, 7722, 4015, 1682}, {5405, 5742, 1753, 3776}, {7777, 
         7778, 4081, 609}, {7516, 5402, 1295, 1331}, {7520, 5405, 3776, 
         3775}, {7521, 7525, 3780, 1301}, {7424, 5330, 3674, 3673}, {7780, 
         7779, 1498, 4081}, {5153, 6005, 1151, 668}, {7934, 7935, 3565, 
         1151}, {7894, 4993, 161, 4214}, {5413, 5329, 3789, 1313}, {5398, 
         5414, 1314, 1294}, {5858, 7913, 4271, 1302}, {7523, 7521, 1301, 
         3779}, {5156, 7914, 4273, 670}, {5121, 7522, 3779, 1683}, {7914, 
         5743, 1302, 4273}, {7331, 5175, 1331, 3565}, {5401, 7515, 1358, 
         1295}, {5328, 7421, 3669, 3671}, {7721, 5121, 1683, 4015}},
         VertexColors->None]}]}, 
     {RGBColor[0.3459751885875185, 0.148790634556318, 0.6032902978029864], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFm3mYVdWVxW/dGhnqVfHqVRVVvFcOKLOoGBBpcYqJAw6ogCIqIEQZjOlO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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwll2mMVeUZx19mZRzmIp1z7r1z554zDuMMMAhNQECI1eKCIgFEGCOoCAxV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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.4445450311255353, 0.3201769704651963, 0.741842135780683], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmnmUVNW1xi890F0F3dVd3V1d3VVdCCIz+BJHxESD83JAVMAxKpAoOCY+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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwlmHmQVNUVxi/D7MxMA9PzerrndSOLyiqVElkEBAUEowEU2YzK5gIY0Vhx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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.543114873663552, 0.4915633063740745, 0.8803939737583798], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXmQVNUVxp8Cs/bYw/RMd890T5MIKpqy3FlEQTCyjYIawQGtpOISGFNi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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHlw1dUVx69syUseJvCSl/fyFqqiUEYLRTYRWbSQIJulbGFsbXEDWlA2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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6210688111301061, 0.6195469525841011, 0.9108038181112673], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHmw1lUZx0/BBe4CF3jvy/v+fu9dhIyAHEAR1AHhUhpbwgUhBDSFpJpm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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3uQ1WUZxx/FpbNnITbPOXvO73d2zxHLFf0DMMhoEAUruTgKmpZIN0yq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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.693540453657602, 0.7359887166767667, 0.9124559483451845], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmgmYVNWVxx9K201XVdNNd3XVe1VdDTqABtlENKNiJsTMKIIwknEJDuAG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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHl4lcUVxgebkOUmYUlubr7v3iSCylJlB7VAaatYkc0CVhGoCCLaRRQo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         "],
         VertexColors->None], 
        PolygonBox[{{5267, 6630, 6629, 6635, 2810}, {6637, 5268, 2812, 6639, 
         6636}, {5269, 6637, 6636, 6642, 2813}, {6630, 5266, 2809, 6632, 
         6629}},
         VertexColors->None]}]}, 
     {RGBColor[0.7656674538528249, 0.8480105764507391, 0.9126706713949998], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmnecVdW1xw8w9d47jZk7t81cNIIKIrGhBjEGKVZQwZaEZgQTMggKigVj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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmWeYVUUShg8wAzN3BmbgxnMToqACihhRhHUliRgJEpQBDGCANaBidt01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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8307519075702507, 0.8697145075288175, 0.8835128944538956], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnHeYlEXW9pthpmd6Zpjp7unumekwA2Zd3VV01zWzGNasJDGhLqtiQEUX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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmnmc1vMWx3/N8sw8szRTz/PMs09RuUmW4tolQmm7WjTuTRRlaI8WriUp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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8958363612876766, 0.8914184386068961, 0.8543551175127914], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnXeclcX1/29h++7ddvduvYs9FlRAEBSlCYhINQW7FBGjdFQQRFE0RWPF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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwlmXeYlNUVxr/N7szu7LAF5pu6MwOWx2hioakQugVpAhJjkAAC0utSBASN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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHts1WcZx9/20Ntp155z2nMppecMysBk4yZDLrs5YbLBSIwbtwL7QzO5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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllmmI1WUUxo/OONfZr87879LMnVARg8ytIq1cMiNygUgQl9EPheY6kwu5
TbkXlRoFLYJaGgRR9kFIkySLTEP9omZC6uiMo1mORRGladnv4flw4P/esz3n
nOc97+31dPNTTV0jYjNSjAy+E6mNOMaPn/aI2JCJ2JmPOFgWsaoiYnpDxDTk
cklEZ3VEI7bluYihpRE1qYhxScSf6I+lI+7qFtHOuSMbkUU/FftxxFpLzP/w
bybm79g+TowJRRHfpO07jfOWIsdowXY7Pl9h20L+UejmY/MPsfpiM4vzk+QY
Qa7vOB+viSgj3x9gacIny/e+uojD+A7qHvFcwT6yPV0VsfqOiIfwf6084lXk
e77PYTOR+HfTj2GcF3Le3t055pJ7NZhuoL+OvFsf8UbGtZ+vjNjFeQ42f6H7
mxrP0Js94D8FljLkGfDck7g3irmhzj1Q7eqxsK4F08ZyY65gHiOwn9QlImEe
zxJrNtIP/88Y2FZquYn/Ofx7Us8afK/Qg4ldXNNLYPuX8wfkKgLjNWzvxaed
+e7DZyzfL2esK0Y+rrONdOp5Gry5rHtXhrxH7jexr8X2a/SDwLc1b67sQg7i
ewN9I/7TkHfq3SP1phWZg+1c5BV8+9CfmVnPWLMVxjHg6aDefiXmyE/ox+fN
ld+YxwR0Q5D11DaFHqQL5oS4MJf6p/C9jZ4fhW89wHiE2BfAtAUs8zg/gG8z
Pj9UecYL0K0XH/m+hawm323NCP8D4FmB7aP4tGPfhlwomNPi8pRq55pMznTK
ORehX4KcwXY0+IYwj0vY96S+4WAeje1efDqw/RKfvdS2DSktM0emov8I/Sn0
h9GX8N1NOZhnc8p341C9Z6078i34N4K/MuWev43tcs5X6N3PyFHdRfGL/I/R
vxno3897duKAsBzNOLYwKfeHnO9PGcMJuHMW/9eJ3Yn/yMScFBfvK3KvOrFZ
lHLPXuS8CnmQ2sd0MbYl+BenjfE0tq2c3+I8EHzXM+aMuNKf+JfRL4SDyyrM
kW3oV6CvSnsnPU9vlyKtVe7Jj+h21PiubsCmEfzTc46tndIbLDNrXHuKea4s
mFPikma6OOudoV2xG/1Fzic59y3xzmrB/oWCZ3+aeI9QfyX1Z6n/JOeRzGNH
3lzrw3k32FsTc/tAhbk2NPGuEecuJOaAZq8cg+HHRc77i8159fp84t6q52P5
XkeMX/A9Qv09iT8An2FwKU38wejHJ74LA8B7S3xWzkrvhKuJ77jutnoi7KMS
z1I17KNXn+dcm2b4cOKdqF2oHdSWmPPiumbQRqxqznOqjKlCXMWmpdRvQC3f
xeS4mfbOagLP8MR3QXdsb513inbJQfAvJ9aygnupmS4u+A7q7ukOXWX+vYg3
CayHqH8e8ebl3GvtYHF9aZ3fJnG+hu912nnVvnOb+R5N/k3lvqMzwL8y47uh
HbY/Yw6JO+K8dmfk3Evt0CZmuwDZCD82Ib9i3xs8k8FzqcS93llj7qrn4m5j
g99GcVi9SMi/tqt7ol4dJ/7tUvdsE/EWYt817TuiXB213hXKKexnc347VINy
X8u4F8LwRK1nrNnqTu0hf4+se6s7Px98CwreveJYObrSrLmpN/ILYu/PmfvC
2D/xDtLu0RtzIuc7pLsjzAPhxqy83x5xULu4Oe/eaCfPbjBHxU29gZpdZ8a7
VzPUrtObobdCO09caq/17han9N9iaca91X+MNRm/uXpr9eZrl1+q8W7RTl/M
eVGD74Z6qNlrp2uXiwOf1PtN1lusnfQ/Ua1KJA==
         "],
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5439, 5185, 5599, 7900, 5074, 6117, 5440, 7949, 5441, 5223, 
         7544, 7545, 7541, 7543, 7542, 5098, 6149, 6150, 5836, 7967, 5835, 
         6327, 5186, 5600, 7901, 5075, 6115, 6116, 5602, 7648, 5601, 7802, 
         5789, 5169, 7985, 6556, 7984, 6557, 6583, 6582, 6363, 6364, 5442, 
         5774, 5208, 6301, 5209, 5775, 6561, 5183, 6251, 7787, 5760, 7786, 
         5761, 7788, 5184, 7440, 5346, 7439, 5345, 7555, 5450, 5168, 7794, 
         7795, 7793, 5773, 7796, 5772, 7877, 5881, 7876, 5880, 6147, 7557, 
         5026, 7556, 7932, 7931, 5276, 7366, 5211, 7924, 5451, 5166, 7916, 
         5421, 5987, 7537, 5433, 7342, 7343, 5456, 5222, 7536, 5432, 7535, 
         5431, 7645, 5588, 5025, 7898, 5820, 5799, 7966, 5798, 6313, 5210, 
         5420, 7946, 5419, 6504, 6503, 6502, 6703, 6702, 6930, 7784, 7785, 
         7341, 7340, 7339, 5430, 6015, 6014, 6148, 5093, 7904, 5834, 5833, 
         5868, 7969, 5867, 5167, 5869, 7970, 5870, 5752, 7770, 5751, 7771, 
         7773, 7772, 7025, 5094, 6506, 6505, 5598, 7090, 5897, 5899, 7974, 
         5898, 5073, 6003, 6004, 6332, 6331, 5151, 5397, 7940, 5396, 5097, 
         5438, 7948, 5439}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{6507, 5347, 6705, 5603, 7958, 5604, 5188, 5762, 6475, 6476, 
         6119, 7547, 5443, 7546, 7549, 7548, 5224, 6328, 6329, 5837, 7905, 
         5100, 6143, 6016, 7539, 7540, 7538, 5437, 7790, 5764, 7789, 5763, 
         6931, 5605, 6706, 5348, 6509, 6510, 6511, 5426, 5453, 5213, 5452, 
         5425, 6144, 5096, 6785, 5435, 6784, 5436, 6786, 7097, 5911, 7947, 
         5434, 5912, 5904, 7095, 5905, 7094, 7884, 7883, 6229, 5032, 4965, 
         5922, 6354, 6353, 5589, 6156, 6155, 5212, 5777, 7320, 7319, 7533, 
         7532, 6508, 6507}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5778, 5214, 5755, 7964, 5754, 6294, 5753, 7031, 5765, 6562, 
         7045, 7921, 5191, 7046, 5192, 6236, 6237, 5610, 7225, 5079, 7902, 
         7903, 5193, 5611, 5194, 5767, 7965, 5766, 5117, 5989, 5756, 6558, 
         7083, 7917, 5171, 7084, 6305, 6238, 6560, 6559, 5778}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5131, 5996, 5851, 5860, 7968, 5859, 6100, 5309, 6046, 5251, 
         6361, 5250, 6045, 5408, 7526, 5409, 7527, 5372, 7488, 5371, 7992, 
         7230, 7231, 6731, 5373, 6730, 6733, 6732, 5147, 6289, 7312, 7311, 
         7310, 5739, 5745, 7962, 5744, 6142, 5018, 7897, 5819, 5818, 7082, 
         5876, 7080, 5875, 7081, 5149, 5866, 7868, 7870, 7869, 5865, 7078, 
         7079, 7075, 7077, 7076, 6141, 7026, 5089, 6497, 6496, 5627, 6244, 
         6243, 5150, 7315, 6742, 5381, 7494, 5380, 7647, 5597, 7646, 5596, 
         7781, 7782, 7333, 7334, 7335, 6295, 6296, 5874, 5873}],
        "0.75`"],
       Annotation[#, 0.75, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5165, 6293, 7318, 7317, 7316, 5748, 7766, 7027, 7028, 6748, 
         8014, 6749, 6747, 6764, 6763, 7519, 6744, 6745, 6743, 5382, 6746, 
         7030, 7783, 5759, 7336, 7337, 7338, 6228, 6322}],
        "0.75`"],
       Annotation[#, 0.75, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV02lMD3Acx/FfRhdpFgo5ysYDV8iTTnN0unnGZGHDpppj7in1hKduS9Ik
U/HcA2wyk/ua3IbN5ggZcw2vHrz/n9/3/v5+//8/pbR8QVlECCHGR3b/EA4n
hZBDNwwOYSPWY/yAEPKSQ5iJGXgpXpoYwquEEAqHqhUvoMUowiPxMeo66Fh6
eUgIbUgfHsJzvr5yXtA0sRr+LcNCqB0YQsugEFpxBr/Y28zYivt2eoBTaMII
vngk6tdT3m2+XnQNXY3pdpyGlfqM1n8U9iBWbKW57WJXcUBNsz6n0dtOz8Ri
aRz64Cl7nB2f0Bj2Dnn17jxc30a1O+19glbSGL0T5EXJi0YvPGZH0uVqPna/
k9wPNJZ20ihapq7ILoWIZr/nTzHnHY1k5/MX4I0ea+W+psfsVI8jcg5jhffP
9BZ1fPH0KE2x4z/8RS27UV0prnmHdszSsxhv+WbTBjmr9TlOV9E6fZvEbsm9
iRtYw3+Mv8G9TtIydiNdS5vl3pVzB0185Xz97LLJ/M3oFF9n//WId68vcr6i
C7vd9yetkNOh/iGq1bfy5YpNxSO+M+yzqNZvF37Lr9TvD13iDouRqnec72O7
HVvoPfZS/hJUyZ3AHsk/kabQNJpK99J/+OFcofaK3L/sCLNHukeg5fwTzE/D
WIzHOFShTm61PR6qb7X7JPUTkajmoF0PIQe5uCivBpnqspCBHGQjqfs/KCeY
ec452feRx87HFm+wz5xvZpSI7XdeRr+z55g5j51Hu9jz+Rc6n6cRel2gk9xh
Ml+neAZ7bvfvhn5ipzuXiU+hn9lZ/IucL9Ee6tvodfZ/s5CW8g==
         "]],
        "0.75`"],
       Annotation[#, 0.75, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV0klsjlEUxvEr1KzohFJDDLFDlaRdILFAQidFQkJZaChaYloJ2poSViwM
SSUszHNiZ2xRFiStRgyJkLYxdEIHbQ2/d/Hvc885zzn33K/vhHVFuVt6hRCS
/VmWEMKZkSFUjgmhAo9xJCmEc6NCyFNbq3Z2rJpcOa2k3SNC6MIqnpXoltvI
W8lbSBclhhA7LoSFtJzvLBY4PzT7EZby7E8JIZfeFz/ACvFylDqX4ZCZh3FP
X3/xAAzET7P6uecgb47agWgObZZvwgYzr9upR2+HfTeLn/Bvog28rbz1tIWm
0U75YnO3IsZ5j57PySEkIgk/5FtxV62FZnjXUL25ekvERfzFuO28mOcOncNz
jaeC59foENpQFh/CN/sdw1xz52EOmvSk8v2kM+gPWsCzHlftfdk7qmmcuAiJ
6uXmHUW8/oRohjsbcVPtO03VM8lO+c5T9Z60yym8ltttj4/mjHPXeHTzPNfX
RV/QFLmxSMYYjMYbPX/pP/yJ8uYHs0rNLKEXxG/t8w7vcYv/gvxL+ePiV/QE
HUV7opm0K7oj+pZoLX8iTUICRmIEquzTYa/f6Iz+R3wf7N6m1h79toiL/s90
ON3hrbl8OYgXd8qfN6NO3IB6NJuxna+FfrLjML41ZuZjsHOzniG0hRZ73z6e
/ai2fw0K9F3BcPV0v30G2s1tw1N3xct/pXH0C+2jfo72pn0Rg0b9xXbI1pOF
TMS6c7UdatRm8qQhy3eciSV4ZsZ4uck8U1AnniWup7PpXjMSnGPNHYpau1fR
ibyTkI6LZvenz72nzX0PaTs9zXcK8/XfMGeteYP059OBdLG3XNeX57u+QRv4
ttlpp3q23C46ja+QbzrdLT4ZfYd8w8y9hP+Cxa9x
         "]],
        "0.75`"],
       Annotation[#, 0.75, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5011, 5066, 7218, 7217, 7303, 7302, 5145, 6224, 6225, 5579, 
         7896, 5010, 6137, 7512, 7490, 7491, 7489, 7493, 7492, 5235, 5893, 
         7973, 5894, 5890, 5892, 7972, 5891, 7032, 6992, 6993, 6991, 6995, 
         6994, 5706, 7066, 7067, 7065, 7861, 7860, 6039, 6981, 5694, 6980, 
         5695, 6982, 5693, 7064, 5848, 7063, 5847, 7857, 6029, 7049, 5792, 
         7048, 5793, 6308, 6307, 6578, 6577, 6576, 5885, 7085, 5528, 6674, 
         5296, 6457, 5295, 6673, 5514, 6840, 6842, 6841, 5955, 6271, 5291, 
         6082, 7126, 6449, 6448, 6447, 6667, 6666, 4970, 5039, 7593, 5494, 
         7592, 5495, 6069, 6068, 7586, 5484, 7585, 7588, 7587, 6437, 6436, 
         5281, 6658, 7116, 4964, 5030, 5479, 7579, 7581, 7580, 5279, 7573, 
         7574, 7110, 7111, 4960, 5028, 6809, 6810, 6653, 5278, 6432, 6811, 
         7575, 7576, 7112, 7113, 4961, 6061, 6062, 5473, 6362, 7105, 7106, 
         5023, 6803, 6649, 6650, 6430, 6804, 6805, 5474, 6057, 5273, 6252, 
         5944, 6807, 7890, 6808, 6806, 7107, 6651, 5274, 6429, 5275, 6652, 
         6945, 7656, 5632, 7232, 7233, 6247, 5631, 6947, 5634, 6946, 5633, 
         7657, 4957, 6948, 6949, 6802, 5469, 6800, 5470, 5942, 5021, 6152, 
         6054, 6055, 5635, 6248, 5901, 7092, 5902, 7093, 5471, 7043, 5786, 
         6564, 6570, 6571, 5787, 6643, 5270, 6567, 5271, 6644, 5237, 6697, 
         5335, 6498, 6500, 7294, 7993, 5384, 7495, 7295, 7929, 7930, 7387, 
         7388, 7389, 7385, 7386, 6698, 7980, 5022, 7187}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5012, 5067, 7864, 7865, 7072, 5855, 7073, 5736, 6286, 7305, 
         7304, 7755, 7754, 6550, 6549, 5374, 6736, 5253, 6591, 6593, 6592, 
         6929, 6214, 5132, 7288, 6543, 5713, 7824, 5811, 7168, 7169, 7834, 
         7835, 7833, 5824, 6325, 6326, 5895, 7086, 7088, 7087, 5236, 7560, 
         6788, 6789, 6589, 7381, 5249, 6590, 7378, 7377, 7564, 7563, 5461, 
         7561, 5462, 7562, 5367, 6538, 6756, 7911, 5124, 6757, 5123, 6031, 
         6032, 5907, 6358, 5931, 5932, 7200, 7199, 7615, 5539, 7616, 5540, 
         6090, 6089, 6861, 5531, 6860, 6863, 6862, 6928, 6185, 6186, 5613, 
         6932, 5612, 6933, 7142, 4983, 5047, 5842, 7849, 7851, 7850, 5667, 
         7696, 5669, 7694, 5668, 7695, 5081, 6315, 5801, 6346, 5802, 6316, 
         7686, 7687, 7684, 7685, 7133, 7134, 4978, 5043, 5661, 7681, 7683, 
         7682, 5607, 6483, 6484, 6485, 6173, 6927, 6831, 6832, 6372, 6373, 
         6374, 6076, 6077, 5496, 6367, 6441, 8019, 6442, 7059, 7847, 5838, 
         7251, 7252, 6262, 5652, 6957, 5654, 6955, 5653, 6956, 5077, 6953, 
         6954, 6482, 6481, 6480, 5606, 6368, 4971, 6070, 6162, 5489, 6257, 
         5490, 6922, 5591, 6438, 7188, 6017, 5238, 6952, 5643, 6512, 6513, 
         5099, 6165, 6230, 6231, 6020, 5239, 6157, 7089, 6711, 6712, 6516, 
         7019, 8002, 8004, 8003, 5732, 7745, 5733, 7020, 5483, 7051, 7052, 
         6365, 7120, 4966, 5034, 6118}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5017, 5072, 6226, 6227, 5626, 6493, 6494, 6495, 7018, 7017, 
         7024, 7013, 7014, 7012, 7016, 7015, 5584, 6921, 5585, 6423, 6424, 
         6425, 5740, 7004, 5717, 7003, 5718, 7005, 5716, 7006, 5720, 7739, 
         5719, 8001, 7023, 7764, 7763, 7735, 7736, 7734, 7738, 7737, 5623, 
         6938, 6940, 6939, 5005, 5061, 6210, 6211, 5913, 6213, 6212, 5086, 
         7729, 5704, 6989, 5705, 6990, 5555, 7823, 5810, 7164, 7165, 7166, 
         7205, 6469, 6044}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{5164, 7915, 5418, 5981, 5587, 7957, 5586}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5136, 7742, 5722, 7741, 5723, 7743, 5721, 7740, 8013, 5853, 
         7863, 7290, 7939, 7291, 6548, 5135, 6547, 6546, 6735, 6734, 5252, 
         7804, 7805, 7373, 7374, 5234, 6309, 5233, 6580, 6579, 7881, 7880, 
         5556, 7626, 7628, 7627, 5975, 6280, 5305, 6096, 6402, 5972, 5971, 
         6275, 5302, 6094, 6396, 5965, 5964, 6306, 5299, 7407, 6088, 7143, 
         6459, 6458, 6456, 5294, 6672, 7141, 6453, 6452, 6451, 6669, 6668, 
         4974, 5041, 6446, 6445, 6665, 6664, 4969, 5038, 5946, 5493, 7891, 
         4968, 6067, 7584, 7395, 7396, 7393, 5280, 7394, 5477, 7952, 5478, 
         6435, 6434, 6657, 6656, 4958, 5027, 5475, 7570, 7572, 7571, 5277, 
         7390, 7392, 7391, 4959, 6060, 7566, 7567, 7565, 7569, 7568, 5943, 
         5472, 7889, 4955, 6646, 5272, 6645, 6648, 6647, 4956, 6056, 6792, 
         5463, 6791, 5464, 5939, 5019, 6790, 6609, 6610, 6426, 6793, 7979, 
         5020, 6794, 6616, 6617, 6427, 6795, 6796, 5465, 6623, 5264, 6428, 
         6797, 6798, 5466, 6053, 5265, 6246, 5940, 5941, 5467, 6799, 5468, 
         6801, 5266, 6630, 5267, 6634, 7100, 6640, 5268, 6637, 5269, 7091, 
         6641, 7035, 7038, 7798, 5784, 6565, 7371, 7372, 6304, 6569, 6568, 
         6566, 5785, 7040, 5919, 6696, 5334, 6499, 6750, 6751, 5383, 6944, 
         5630, 6943, 5629, 6245, 5628, 7769, 5750, 7767, 5749, 7768, 5776}],
        "0.25`"],
       Annotation[#, 0.25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5259, 6287, 5260, 6051, 6107, 6106, 6049, 6050, 5376, 6737, 
         5375, 6739, 5006, 5062, 7211, 7210, 7634, 5567, 7635, 5568, 6102, 
         7167, 6101, 6203, 5558, 6323, 6324, 6205, 6204, 6234, 6202, 7376, 
         7375, 6581, 5795, 7817, 7818, 7158, 7159, 7160, 7204, 7203, 7832, 
         7831, 5823, 6359, 6195, 6196, 5910, 6360, 5551, 6197, 5917, 7975, 
         5909, 7096, 5908, 6878, 5542, 6875, 6880, 6879, 5966, 6189, 6190, 
         6092, 6091, 4985, 5048, 7197, 7198, 6857, 6859, 6858, 5298, 6845, 
         5517, 6384, 6454, 6455, 7196, 7195, 7604, 5515, 7605, 5516, 6844, 
         5292, 6833, 6834, 6375, 6450, 7892, 4979, 5044, 6172, 7981, 8018, 
         6078, 8017, 6079, 6177, 6176, 5953, 6835, 6836, 6366, 6376, 6377, 
         6080, 6167, 5498, 6263, 5499, 6925, 6926, 6443, 7192, 7191, 7594, 
         5497, 7595, 7596, 6822, 6821, 5285, 6163, 5286, 6071, 6369, 4972, 
         6072, 6164, 5491, 6255, 5492, 6923, 6924, 6439, 7189, 7190, 6018, 
         6019, 5352, 6515, 6517, 6518, 6023, 6065, 6066, 6022, 5240, 6161, 
         5927}],
        "0.25`"],
       Annotation[#, 0.25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5582, 6914, 5583, 6919, 5980, 6918, 5581, 6415, 6421, 6422, 
         5624, 6941, 5625, 6942, 5578, 6920, 6417, 6418, 5065, 6223, 5576, 
         6283, 5577, 6937, 5622, 6936, 5621, 6898, 5564, 6891, 5565, 6899, 
         5978, 6897, 5563, 6404, 6413, 6414, 5619, 6935, 5700, 6985, 5701, 
         6986, 5699, 6988, 5703, 6987, 5702, 7728, 6683, 6587, 6588, 6401, 
         6406}],
        "0.25`"],
       Annotation[#, 0.25, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1569, 7058, 7099, 7098, 4945, 7886, 7887, 7885, 6601, 6600, 
         6603, 6602, 4946, 6605, 6606, 6604, 6608, 6607, 4947, 6612, 6613, 
         6611, 6615, 6614, 4948, 6619, 6620, 6618, 6622, 6621, 4949, 6625, 
         6626, 6624, 6628, 6627, 4950, 6631, 6632, 6629, 6635, 6633, 4951, 
         6638, 6639, 6636, 6642, 7888, 7978, 7977, 4952, 7101, 7102, 7034, 
         7037, 7036, 5783, 7041, 7042, 7039, 7800, 7799, 4953, 6693, 6694, 
         6692, 6695, 7912, 7983, 7982, 5138, 7292, 7293, 6768, 6770, 6769, 
         5207, 6766, 6767, 6765, 7104, 7103, 4954}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2829, 6663, 6819, 6074, 6075, 5506, 6371, 7125, 4975}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{2840, 6855, 7608, 6084, 6085, 5527, 6856, 5526}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{166, 7624, 7625, 5000}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5013, 5068, 7220, 7219, 7383, 5257, 7384, 5258, 7007, 5725, 
         6738, 5724, 6901, 5570, 6900, 6903, 6902, 5979, 6217, 6218, 6104, 
         6103, 5001, 5058, 7206, 7207, 7630, 7629, 5557, 6888, 5307, 6097, 
         5552, 7055, 5553, 6884, 6466, 6464, 6680, 6679, 4991, 5051, 7617, 
         7618, 6876, 5541, 6877, 5300, 6865, 5533, 6391, 7144, 5960, 5959, 
         6864, 5532, 6383, 6388, 6389, 6086, 6849, 5520, 6843, 5521, 6850, 
         5956, 5957, 5518, 6846, 5519, 6848, 5293, 6837, 5509, 6379, 7135, 
         4980, 5045, 6174, 6175, 6081, 5289, 6181, 5954, 6838, 6839, 6380, 
         6381, 4981, 6962, 6963, 6826, 5502, 6820, 5503, 6827, 5947, 5948, 
         5500, 6823, 5501, 6825, 5287, 6166, 5288, 6073, 6370, 4973, 6959, 
         5655, 6958, 6961, 6960, 5241, 6120, 5928, 5929, 6440, 5037, 6021}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5016, 5071, 7223, 7224, 6913, 6917, 6916, 5318, 6911, 6912, 
         6416, 6474, 7186, 5009, 5064, 7215, 7216, 6907, 6910, 6909, 5314, 
         6895, 6896, 6412, 6472, 7175, 5004, 5060, 7208, 7209, 6890, 6894, 
         6893, 5308, 6886, 6887, 6405, 6467, 6468, 7163, 6040, 5247, 6279, 
         5248, 6043, 6542, 6541, 6585, 7379, 7380, 6586, 6460, 6461, 7155, 
         7202, 5055, 7201, 6033}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{1268, 6136, 5137, 7534, 6782}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5217, 6783, 5218, 6780, 6781, 6777, 6779, 6778, 6787}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{2513, 6344, 5794, 6310, 5937}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5261, 6597, 6599, 6598, 6687, 7757, 7758, 7756, 7760, 7759, 
         5727, 7008, 5726, 7009, 5007, 5063, 6215, 6216, 5900, 6350, 5569, 
         6219, 6544, 6207, 5560, 6904, 6409, 5977, 5976, 6889, 5559, 6407, 
         6408, 5002, 6934, 6885, 6681, 6682, 6465, 5304, 6882, 5544, 6399, 
         7151, 5968, 5967, 6881, 5543, 6390, 6397, 4992, 6977, 6871, 6872, 
         6870, 6874, 6873, 5961, 6867, 6868, 6392, 6393, 4986, 6972, 6852, 
         6853, 6847, 5523, 6854, 5958, 6851, 5522, 6378, 6385, 6969, 5670, 
         6532, 7261, 7954, 7955, 7601, 7602, 5511, 7600, 7136, 7137, 5046, 
         6178, 5510, 6267, 5664, 6180, 6179, 5109, 6168, 6169, 5663, 6964, 
         5662, 7688, 4982, 6965, 6828, 6829, 6824, 5505, 6830, 5949, 5950, 
         5504, 6264, 6265, 6171, 8015, 6170, 5105, 6024, 5106, 6522, 6521, 
         5355, 6715, 5930}],
        RowBox[{"-", "0.25`"}]],
       Annotation[#, -0.25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5262, 6285, 5263, 6052, 5595, 7642, 8010, 5815, 7826, 7643, 
         7644, 6915, 7999, 8000, 6419, 8022, 6420, 8025, 8021, 6108, 6221, 
         5574, 6282, 5575, 6222, 5594, 7639, 7956, 7640, 7638, 7641, 5573, 
         6908, 8006, 8007, 8005, 8024, 8023, 6105, 6208, 5561, 6281, 5562, 
         6209, 5593, 7631, 8008, 5806, 7819, 7632, 7633, 6892, 6410, 6411, 
         6099, 6198, 6199, 5698, 6201, 6200, 6233, 6041, 6042, 5548, 5936, 
         4999, 6125, 6035, 6036, 5691, 6038, 6037, 6093, 5301, 6034, 5246, 
         6188, 5935}],
        RowBox[{"-", "0.25`"}]],
       Annotation[#, -0.25, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5014, 5069, 5856, 7866, 5857, 7867, 5737, 6288, 7306, 7762, 
         5738, 7761, 7047, 5791, 6012, 5230, 6351, 6008, 6009, 6303, 6302, 
         5915, 7976, 5916, 5914, 6906, 6905, 6473, 6685, 5312, 7412, 7411, 
         6545, 7289, 5133, 6220, 5571, 7636, 5572, 7637, 5333, 6114, 5707, 
         7730, 5708, 7731, 5618, 6488, 7226, 7227, 6206, 5085, 6486, 6487, 
         7622, 7623, 7621, 7161, 7162, 5057, 5973, 5554, 6398, 6403, 4998, 
         6978, 7747, 7748, 7746, 7750, 7749, 5686, 6535, 7268, 7269, 6191, 
         5119, 6533, 6534, 6394, 7145, 4987, 5049, 7609, 7610, 6866, 6869, 
         7907, 7909, 7908, 5118, 6973, 6974, 5844, 6976, 6975, 5535, 7611, 
         5534, 7997, 7146, 7147, 4988, 6113, 7698, 7699, 7697, 5672, 7700, 
         5671, 6971, 5674, 6970, 5673, 7701, 6670, 6671, 6584, 5245, 6382, 
         6386, 6387, 5324, 7689, 7690, 7255, 7256, 5110, 6268, 5111, 6526, 
         6525, 7933, 5290, 7400, 7194, 6027, 5242, 6269, 5243, 6028, 6527, 
         5112, 6966, 5665, 7062, 5841, 6968, 6967, 5513, 7603, 5512, 7996, 
         7138, 7139, 7140, 6110, 6111, 5656, 7253, 7254, 5107, 6266, 5108, 
         6523, 6524, 6444, 7193, 5040, 6026}],
        RowBox[{"-", "0.5`"}]],
       Annotation[#, -0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5015, 5070, 7221, 7222, 7838, 7837, 5827, 7057, 7744, 7011, 
         5731, 7010, 5730, 7846, 5832, 7845, 5831, 6321, 5816, 6349, 5997, 
         7070, 5852, 7002, 7733, 7183, 8011, 5817, 7827, 7184, 7185, 7214, 
         7213, 8012, 5825, 7836, 5826, 7056, 7732, 7001, 5715, 6999, 5714, 
         7000, 5130, 6319, 5812, 6348, 5813, 6320, 7753, 7172, 8009, 5814, 
         7825, 7173, 7174, 5059, 7862, 5849, 7068, 5850, 7069, 5709, 6998, 
         5711, 6996, 5710, 6997, 5129, 5995, 5807, 6330, 6000, 6001, 5854, 
         7821, 5808, 7820, 5809, 7822, 5974, 7858, 7859, 7283, 7284, 5127, 
         6278, 5128, 7285, 6540, 6984, 6983, 5994, 7751, 7752, 7297, 7298, 
         5142, 6192, 7813, 7814, 7812, 7816, 7815, 5970, 7855, 7856, 7276, 
         7277, 5122, 6274, 7279, 7278, 6537, 5692, 6979, 5992, 5993, 5734, 
         7021, 5735, 7022, 5538, 7054, 5804, 6395, 7150, 4990, 5050, 6121}],
        RowBox[{"-", "0.5`"}]],
       Annotation[#, -0.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5163, 6291, 6292, 5747, 7963, 5746, 5148, 6242, 7842, 7843, 
         7841, 5830, 7844, 5379, 6140, 6492, 5863, 5161, 6336, 5162, 5864, 
         7314, 7313, 7986, 5256, 7382, 7179, 7180, 7212, 6006, 5159, 6335, 
         5160, 5862, 6554, 6555, 6134, 6135, 5918, 6133, 6132, 5087, 7803, 
         5088, 7229, 7228, 5620, 6240, 6239, 5200, 7357, 7358, 7181, 7182, 
         5008, 6130, 6761, 5392, 6760, 5393, 6762, 5199, 7509, 5395, 7507, 
         5394, 7508, 6098, 6727, 5370, 6726, 6729, 6728, 5198, 7349, 7350, 
         7170, 7171, 5003, 6124, 6758, 6759, 6690, 5331, 6689, 5332, 7480, 
         7481, 7477, 7479, 7478, 5084, 7652, 5614, 7651, 5615, 7653, 5547, 
         6232, 5592, 6347, 5933, 5934, 5054, 7829, 5821, 7828, 5822, 7830, 
         5688, 7725, 5690, 7723, 5689, 7724, 5083, 7464, 7465, 7463, 7467, 
         7466, 5173, 7797, 5172, 7328, 7327, 5757, 6400, 4994, 6122, 7502, 
         7503, 7501, 5388, 7504, 5195, 6755, 5390, 6754, 5389, 7505, 6087, 
         6722, 5360, 6721, 5361, 6723, 7029, 7774, 7775, 7329, 7330, 5174, 
         6187, 6318}],
        RowBox[{"-", "0.75`"}]],
       Annotation[#, -0.75, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5219, 6340, 5220, 7368, 7367, 7879, 7878, 5317, 5771, 7923, 
         5206, 6284, 5728, 7960, 5729, 5412, 7528, 7530, 7529, 5378, 6740, 
         5377, 6741, 7074, 5861, 5157, 6334, 5158, 5411, 7943, 5410, 6595, 
         5254, 6594, 5255, 6596, 5313, 6686, 5416, 7945, 5417, 5404, 7517, 
         5403, 7518, 5134, 6145, 6146, 6007, 5176, 6338, 5177, 5407, 7942, 
         5406, 6128, 6129, 5879, 7351, 7352, 7353, 6339, 7356, 7355, 7354, 
         7875, 7874, 7287, 7286, 5369, 7487, 6489, 6691, 7428, 7427, 7426, 
         6539, 7282, 5126, 6276, 6277, 5697, 7726, 5696, 7727, 6095, 6725, 
         5120, 7910, 6724, 6536, 5366, 7619, 5545, 7152, 7153, 7154, 5052, 
         5969, 5364, 7270, 7271, 7272, 5445, 7275, 7274, 7273, 5365, 7475, 
         5985, 7462, 5359, 7265, 7266, 7267, 5758, 7613, 5536, 7612, 5537, 
         7614, 5962, 5963, 5845, 7853, 5846, 7854, 5683, 7719, 5685, 7717, 
         5684, 7718, 5082, 7458, 7459, 7457, 7461, 7460, 5327, 7420, 5326, 
         7987, 7148, 7149, 4989, 7765, 7705, 7706, 7704, 7708, 7707, 5677, 
         7711, 7712, 7709, 5678, 7710, 6083, 7703, 5675, 7702, 5676, 6183, 
         6182, 5524, 7606, 5525, 7607, 5325, 7691, 7692, 7257, 7258, 5113, 
         6270, 5114, 6528, 6529, 7402, 7403, 7401, 6716, 7989, 7991, 7990, 
         5356, 7449, 5357, 6717, 7345, 5189, 6235, 5608, 7649, 5609, 7650, 
         5190, 7346, 5871, 7871, 7322, 7323, 6337, 7326, 7325, 7324, 5872, 
         7872, 5988}],
        RowBox[{"-", "0.75`"}]],
       Annotation[#, -0.75, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{7914, 5743, 6002, 5858, 7913, 5154, 6333, 5153, 6005, 7899, 
         7934, 7935, 7332, 7331, 5175, 7516, 5402, 7514, 5400, 7513, 5401, 
         7515, 5197, 5399, 7941, 5398, 5414, 7944, 5415, 5328, 7421, 7423, 
         7422, 7552, 5146, 7777, 7778, 7776, 7780, 7779, 5546, 5805, 7894, 
         4993, 5053, 5444, 7550, 7551, 7520, 5405, 5742, 7961, 5741, 7309, 
         7308, 7307, 5687, 7720, 7722, 7721, 5121, 7522, 7523, 7521, 7525, 
         7524, 5152, 5413, 5329, 7424, 5330, 7425, 5155, 6290, 5156, 7914}],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{0, 3}, {0, 3}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 179},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->5222629]
}, Open  ]],

Cell["Compare with data that does not include gradients:", "ExampleText",
 CellID->880954819],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}], ",", 
        RowBox[{"Sin", "[", 
         RowBox[{"x", " ", "y"}], "]"}]}], "}"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "3", ",", "1."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "3", ",", "1."}], "}"}]}], "]"}], ",", 
   "1"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->442663468],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`"}], "}"}], ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1.`"}], "}"}], ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.`", ",", "2.`"}], "}"}], ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.`", ",", "3.`"}], "}"}], ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.`", ",", "0.`"}], "}"}], ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.`", ",", "1.`"}], "}"}], ",", "0.8414709848078965`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.`", ",", "2.`"}], "}"}], ",", "0.9092974268256817`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.`", ",", "3.`"}], "}"}], ",", "0.1411200080598672`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2.`", ",", "0.`"}], "}"}], ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2.`", ",", "1.`"}], "}"}], ",", "0.9092974268256817`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2.`", ",", "2.`"}], "}"}], ",", 
     RowBox[{"-", "0.7568024953079282`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2.`", ",", "3.`"}], "}"}], ",", 
     RowBox[{"-", "0.27941549819892586`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3.`", ",", "0.`"}], "}"}], ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3.`", ",", "1.`"}], "}"}], ",", "0.1411200080598672`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3.`", ",", "2.`"}], "}"}], ",", 
     RowBox[{"-", "0.27941549819892586`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3.`", ",", "3.`"}], "}"}], ",", "0.4121184852417566`"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{548, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->17410493]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Interpolation", "[", "%", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->39043401],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.`", ",", "3.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.`", ",", "3.`"}], "}"}]}], "}"}], ",", "\<\"<>\"\>"}], 
   "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{322, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->21412089]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"%", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->410679765],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyMfQmcj9X3/3xmPsuQUkOLSCqpRElZsnSfomRJkrVpkWglaVFpMaGkjSxR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   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl01s1UUUxaevXxj69Wj73gPpa1z5kUjFqImExGLEVmXlQtAFNA0lMWq7
BAuhbmwjViJQjASVtR+JVBcIbYilhGgCGBUBiUmLJhRaSgEVdur59R4ii8nM
m//MnXvPPffMvPs6e17szqSUFpekVKp+TVNKL6j9Xp3SY5UpPX5PSnNa0KPx
aG1KeypSulVM6XYxfl9uSKlO463afEZrbur7kxrvrUqpfFFKryxMaUTrmutS
2qzvv2l91eKUVmnNSY3PFVK6IvvvaPxuc0rLtKY9m9Km+pTa1H9Uk9J+tW/l
W/eClMbVjpbFGW9q37j83qi1I2rb9XunznpWPm+QH2+Vxt6BTPT8xs6jOmNQ
3/v0+0hZ+M7eD+Vvpeb/yMQZudLYO5OJved1VlZ9v363qN3OpfRZY0qHtbZa
872aW5YJm8SB3XH1NeqnM/G9V+Nh+fBSNs4/Lpur8yn9W4g9x4XBddkdkh+v
l2useF9TP+G9xDuiWI7U2L7WT2v9Tq1/QjaeUvtK9lvtJz4/qDUPqN0QNp1a
162zy/V9rDJyBpYXKsNX/CTHFzxeq7XrspGjD6pi/RaNryvn13TuroqIZa3X
1DhmcCCH5BI8f9b6M2q7nR/6Du39RPhl7g2evK2YXlY/XBL7nssGtvCozFyi
L10U605Wh0/4c7YsfCBnNHwC2/XCdpVir64LDsAnuAd2YEjeF4t715qCG+Py
qUP+jVWEbfbdNJcGjGef7RPvStsB8zrzCG7gJ37PY9UUvOfcg7VRS/DvaZ2z
Rn3BNkZsZ1S4DjfENzAqN9fhNNgxviKb02r7tOfhpcJ7adTcF9p3Vji36Yyf
1P+otstYM4ctsIXr5AW+Mwbneq093BhYrjCf4eqU5t9viLp5IxuYgA0YHasI
3KiDqaawQ+08XxF5gLtgRFzbjRf4dNVH3X5dEvVC/eIPWP9pDTm9RJjL7nLl
erfOH2wOTZp0LcETuNxmPlObfZo/URK10mt9IJ/4ib/gvNJ5GrVu4Ad1dqAi
/B0pi3PmzOetmeBSq8dgclWYzBQjn9gYtf8XM5Ef4mKuy/NdXsNZOyoCS3iE
713GYcL7GVPPY2Xhw7h9n3G+ji0IzNi3yfb/li9/FUNr95vj8LXbernKetBq
/ZlVrm40RT1czURccBvO7nVNDZmj8HMmF1qDX+AE78CJnLTlA69q6fpUPs5E
J+AI+dynNQ35yAEaj97N62MmeIY/LbK/vhiaRx1ttJ6fK4v4iX22IWxhp7UQ
e1jfaztozpj1jLwf1PqGYnARTm0wr0aMK1ypNS74cENrb6odqg3fWq354DNg
Dvyg76eLcc/MZmIvfKOG2q1X3HPYQBvRqrG7ODtpTqKRaGyVa/ui59E19kw6
llJryEPC7P7mwBPdvVAI+8SQdU2VWie32N+c7xe0a8x1Sv5eXRDc2iCbR4XR
tkxgdNZ3HnyGX+B/R3Pxq2Vh3HMLSyNXy4z/JY2ncsFr8AVnYmJdtfMy7VrC
H7QtVwx9g//U8DbnYsL6OeHf5AVf4SA4b7UdbI4bP8ZgDh5VrnvOHfbbAD7d
qa86Y9Vv3LDZ77OYx6dzPg+97LxLf8tt54p8n1b7sjbqmH7Q2tzh2Impx3FR
E5dcFz2Ot9M1TW7g9nfC75dizD9TiDuJfBU0l1c7oXrLqq8uxj2x0tpK/skB
YzT2pL6fUnuvNu57eA9ndvi9w53V5/cIueDOfMn3JjjMWgfmmkIj0IcZz4PV
Zc193hg1xL0CRsSMZnAfwz14vce5+F5xdeQjLu6HT/1eKjhubJ5XvJfNH/zF
dzhErq/azwGP5+/fTNQve2f9PmN+UT7elPPvkGK8h8CEs8gp6/4pxJuV+x8d
RYfgOvnr8ZsHrk/6foHzj/hNQn6Ih1jgV4vn0WRsoMNwdch3OpqL9uI771Zq
jN/LXUvUR685D8+pxVu54Azv7+Veg96Cd1/mf11AK9DYMb/HeCu1m2/cAZud
gx73xEXdD/legUe15hLcOWAtgWfjrgHeAvX50IU6+wn/5xwn+JNj6g4/+7X+
1JLAC71fXQitnsvFu5az+R9wyP590xhvDuzDyUH7uc7vSebxfbPr/IjWNxbD
t1/FpY8b480Id9Ag+HPR2gE+K3xfow9V1q0779Iu/7/g/w2aOOe3SZ/1By7z
1uEOa/cbY5s1gDE4/AcG7uEI
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllDlM1FEQxgfQZc3CLot7ofCIlUciHtHSA6MSlIpKTRRCZ6KQ2GqrRqIo
qIWJR200EW08oFCIRyJ4C2JiYyEsKCyg0Km/yVdM/m/ezPveN9/M+69q62hu
LzazRmwJNhnMJrDzEbN7CbN8zuxXymwAv3WZ2SKxeewyfj/x96zvEm8oNevG
T+PnsBdxs1EAl2fNhmrNDiTNRvDzGbOFoLMdnPkH/l/sZIlZHX6W2DR4gxFh
7CC2Ezu21OwB/DLEn6SF3UROAj8eFOsjv67a7LDfWW52tcxseIXZafDuF5lt
jJlNBXHwu3vhcJH1FNYF1lbqSxF/lBbXfeyNwL0FvFOI1JEU1lgN37gwb5Bb
tNLsYEx7Q9x3Jq27NmCTYD/jzNGo7ngH/ocgrVodn/Urctoi0nCc9Th7m1l3
sreA/xwOjUlxeEPsJXt74doFxhjaNMHnO/XGStS7n0G1eQ8niU1gfdRzLa6z
H4n3JISxn9gbOG+KCaOYWtZXS7tDMfWukvrzxerhMGdfYy1gX0hI68/kHE9K
c4+9DeLmOd+oPV+ju2/h/ybWTH5tBZzIuYNWPeRsKRVHn60/QTGfsdvEO4mX
sn5MvCGrnnmv/ExrVj3y3riGo+jxJSftnPNqYmuxWfDm2KsEayiI+3xE3I+A
UV6hGrxXM+BfiahnX3PS2LXtZu9TUA+9d65hH7n9Gc3iLjhd8nqD3o73cJra
Z7Dr1P+UGZ0jVgjCepjQ7NxMS2ufobNpzZDPjvekHn7rsuLuHGfBKmD1JcKs
ACsZNPv+hk7kpLlrXYhKu23sDUSlYSEjzs7Va/TYuZTenudsx+9NafYH8X9k
tefr9qh6NxvE3Xu4plaaupau8R5yd+dUq/8z6jLi5Fz8DZdVUUeVsLwGf+v+
j/F/i795n/XFjHrtM/8feRa76w==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.3540706342945908, 0.16286642834435472`, 0.6146694260747082], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmWl0ldUVhr8MXBIL94Z7k9wEyL1OFLXicsnCseJEQKX9g510qRWia3UQ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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtllls1FUUxm8LthXaGVqmM1PpzIBACiiYSGRTChoWE/QF1CdFtgc3IEZN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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.43984966330243086`, 0.3120129938753387, 0.7352422282925327], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXlw1dUVx3/ELITkJSSEl5flvQcqSysUQQdRAkIVsdOqIy6daTtaEZip
LKGACsqiRJCCRBbFbaSiILZWrCwuCFQBBa0Vl3YQqp2OdtBWtKAiBLd+P3xP
pn/88rvv/s4999yzfs9N99HNoyYVJEnSoj8n6d3UmCRv1iRJjX4M1niInlXl
SfKO5u6vTZL+mu+r3zWlSfLboiTJFidJn6okOdBB9J2TZFNJkqzWM6fK71Wa
n1ttmkbRDgua5drr67okeaRrkjxemCTHNF6m8VyNvxHvmaJr0fhirbtIz7vi
c2Unj1cXmzd86iT3rmLTQdPU2XKsKfHcJXoe1feuXfybcZ9ynwH5l2rPD+uT
ZGRZkpwW35hPV+pMmpuucVOZ5XpdMhc3WFZ+Mz9ET1OBaS8oM838ao8HF/g9
Msbta6B/WzwWaO/Jmpuj90uSYYzG12rfm/Teq7PME59JFUlydrmfpuC/uaP1
Dt3VGv9I4xmF1lnvjtbbXvG/VXzHadxPZ19VYhq+Q7dHfMZr/r9ae5fGzRpP
0jNXOnpMz4fab4VsnZLdp8sH3iv33AE920U/QLb4Vcr2rcgnSX2N5w+K9pNG
f/tM7436NknjXlr3vp4NotmaMp9B0sN/dN6P9XTX+D7513jRD5F8b0vPdY3m
mRPtb/TUF1hH6GyX9j1U5fVPaJyrth/gA/vKPA9PeCAffH6ZTZLh9aar6JYk
C7XHfmwj3mUp6+SwfO8d/R4lu7+i8V6Nl2n+RvHpLfkOae0vCv3eqL2maf76
RtM9Uu5YebjEur1Oz6ei6679T8n7nMu15z7JcFBrT9W3khL7G+Nijd/QXnu0
z6miL9E+z3S07tlvqOQplm5GiG6wvjfl/butxPsSs6uDD/zP1rhA4yXif45o
L6712lb5RaqbfZd1rEfmKR393pb4jCMk72rxGSRbH6+wPi4S/R50FrEMf/b5
SU7fcqadrHU/F69zNH8g3tjuBs0neq6WPB9JBwPSjq8ZmisV7/PRh95TZItC
jb8ne31fz3r9ntjFezaIz3cV5nOV1l6uPa/Qc5J+Z8v8jfmnxXtzzjx7lPk7
+/JAszoxHWfEjrPEf6ae54k5ydBUatsQM8TXmdr3eslxkein6T1F57xE4ws6
2S4jQg8XMheyocNrKizz6AqP0een0klzyvuOCHrmiYkHiuyrPTXuIn73k380
vqLSualf0DD/gM64Kue8uk+xsEJzTyamJb9Bj17RKd8ul/3PlR9cKVkX1nk9
a4kBYpQ4QsfY99Iin528QW4vF4/e5d63o8Yna3x3yMY+xM4C8ftLg2Md+XtF
vL+vvealbVPk6FZuOc+Q7mZHjTjS4NjAb/HBVeGH0OQi9ueIx44G/6ZGkOfI
pQv0O1vuWpCvdi5oS9m3DkTOvDYjG2v9Z0XWa8+QrXfIyrlmSYdzSizTo9LT
Wj3/kI8v0vxCPQ9q/tsK55eHEr/RHXoj3+yL8Uspr7tBsveXT52uZzG8JXs2
bd3eovGtDdZ1Ts/KQvvkx8qjd8lOixXLt2rNLSHTVs3P1vyUAtfMkgbXTXTw
eOjh1LTzGjL9QHHTud5812jdIJ2/Un53R5XPs1I8P5dd7s1YH9STgeX2B+rL
WeVR28XnND2bdKbOHc3jqNb21lwvPU9qfqjy3z21zn8f6Mwj9Xwh+1yl73n5
53HRbNH7+ZxjHf+jdlET8SXi7usiv2fFeJdkL9M5Z2q/B2WHq8XrK/GZVuF6
Sl1dJdkfyhiLELesxycLJM930sU4ybOl2jz5vlQ8WvWcKR5rxPODOsuai/qJ
n38pfkcyzgHkxWPhi2sk+86s6/EGjdfnnOce1nu/bDGo3BgHnaHD+8RjRcZx
w7odsZbaurbKsf6avm+TnOdF7iM2+mDHMtc5ahz5Bb8j/8wQj+l60uJzWGuf
kM67Sz/jNG5MO9ce1NzBGudyctWWlPPVdsk4O+04Qd59IfN+6flQnbHVMent
aKPz3Cbt81zWeWuC9NdSZawAlpjcxbEJVgAzkN++lj77Z73fyeLRo9Zxybrm
wBX4HWuJpRXS2+3EgmTcrf136TlTMjRXBKbS84XO9bmeidLPM6LfIPqpop+o
va7LG+v9S+fYUGtcAyZZHZiwVesW6ynS2l+LdqVoftjZtehnhc4n5IMddc4J
uyX7Lj2T47zjo3Yj/4QYMzchMNM34rkk7fyHDiaGHqir79T7DM9krUd0mGj+
O61ZKD8cWOIaTc3/g363Rjy+INptesaL/iPR7m1wTMK/OWSYGDiN8R6d71XJ
MLLUv8EbnG1w0DGeWeV5MN51cS7Gc8GHeo6UOn/MjRyyXDHXVue8At+BIef6
KuMk8ny5zrc2bbz8nmT8Nu9vL2adv8hdYHNwODifujgi7ALOago+ldLJn3WG
4aWO4+0Ry9QragWxPFOyNNUYl10qHzgl7Rw8Q/acVevceCJHVjlvgzvAKOgA
XW4PfRaWWg6wELofGBgJGZtCzkT8Tmp0j0CN7RdYl/gkZ5Gvhov2vMA9nBEM
BF94DAk++NnwGN8rnhPy7kduqzaOpx5drLP8OGdc1T/qOjVoWKyF/z01rovI
SS4bU/5/fMcYrPhs1rWBunCH+LXUGEvAY1jIsCZsQWycJR0vrXF/MbLGfoaP
LakyHTTojhqFP69LGfd1K7AvoWNi52/U67Rl3yZ/mC6/ycvne+SNd8G61Ieh
edeITYGP8IGemuuRNg4Ck47N2D/ekK2XZlwTbq92H0U/hE/gg+DkZVp3uM41
6yWd97m0/QfsB+YCUy0Vz+W1jqmJESvEwqjAZJyrq2S+O2ccRz4i/5NjwUeX
1dreY/V9TM69IHnkeJH9h1o+NWU/55zUfrD6a3XGwWBg8h14D7tQ82+us06P
Ru2j1jwn2k1p42LyL7bF1q2avyVtLLlTcs6WbnuWGQc/lbIcG1PGG/Q4+6uM
/5CJ3mhc1I4zpP8BWfdbO4l32bt/J2NO9ICuqK/oEiwEpusWuO4t2fevDfZL
+lB8t1uxczg5C922xDz+3Brz1CruD87OuB8h3hdVO+bvrrVtWDum0jbGvtTy
luDzVPgbPdfhKvd4+CBnAlNwLuSAPl9sm9IjcZ6ba50XyAkf612hMx8otD3g
CTYjr4AFOCP+dXvwAcvfkHK9pRd/q841GB67u5rPHPHsVev8T42tqnOdJQcn
dc6XHcSvoNq9LXW+Q4zBQPnApeBTxvCkF83FGKyCbGBL9Dov8gX6mR9yoi/G
5CJyNzrBdvgruA3fat+DXjhRPhuZca4An3AXA96h9jMGq+BLW2JfsE6/qO+b
5TvP6xknP+6gXF3QzbakPnwVNYLYgZ74IS4/j9ikzpKLiTv2455iRvRD2Ioc
RT0ip0DD3cJjgYvACPgZMpA7DocPcH/DPQ53QNi8vRfnd00Xxw9vaB6N/QdH
7NfKpofztg30xBv6wV85A7GPr7EXsZzL2Yewy/ldjRfBir+X3XdnnA/BlegN
vPpArXM9OfScjDE3WBn7sA6/fVJrX8kY4+EX+McVnXzefoGLiKFF0WtwPnIk
cUq+nJzxb/pRch4y01vgsy8Qyynz41zkNeahobcjBvB/8jc9FTmcOga2Kgic
2zmwPX0QdgEn8JtzUC/Ap9RmYocerS2wMf00+Zf+BVr4EPvt+IO9jgU986ti
P3Lg2ArjXdaS+5dF/ofHsaAH13eMfanLYGpqJT00NQf9gJ9Lo88Fd98T2Bse
R2OvbPRa7MWZ+5Y6n9Ov0auBf8hj/aNfy8teOyJ2uAtoijtPMMLAevvYY7LL
yxl/G5L33Q3+0xyYmdqDjeCJTbHJ6TEmLtkD/uzHPHbEtlPDdvC4LbB3Wntu
zvsb587G2cvE49waxy94mlyG/cFk4DZ6ZfICesCO6LtH6AFeU2Kvk8W7OeOa
AhbHT+jNwU5DAz/tqffdIvkYfP16nWtjOw7Dv+gxwOIn8J5i580G1xnW8CZf
0YMNjj4eGbmTZIwdeGML7guPRH4jzrZGrBFT8GIevDIg5KRHhYZ8Rr3knMQd
ctFLc3dNLsPn6Ivpn9ZFD0VPRX/5Yez5QfSwbRFT3IXiy7PijGBfeg5w7Im5
6NOxF7Wfuk9f8u9602E/9iGm8Lui8L3ZcVeO/EsCxyInPUlhO03sy9o5cScA
DX7REnuRV9m3IeoOuRSZ6TnnRe3mHGtjfqP89lnluGmVxg1gZPAMdzmcjXOh
T76jc3Dl01nn7flp93vtvSVvcho1qyX26pv1HQR6Jh/XRN6mBlEPiMfLtH+v
dNzJyUc6NBrXElv/zDi+HubeImuZuMunBlAz4Ts27vGwM2PqNdgIDAF+KEbe
nOUBb4ytdA0FA6FbdPxZYDrooaG+EiM3xV08dXaReCzO+Z6uJe724UPu7Bv5
c6XOsTbnPa6pdL3jnK9mfBdJfqLeUneZx8+JgfbYzIZOuHcZGHcvnJtei7O/
mPF5OAtYZl3c14HlH0xbZurS72pcm4hv9Ip+oEcnzHNvSr7mG/YlVoh3+iuw
FBiVc46IO0z6E+6223msDz5gT9aSc+jJ1wcu/aNkeSrn+s+d30/rjLm4U6dm
swc55vGa2LfKNZ6cSewiE/4GLhsT9log2i8bfS8MPiXHUwtKojclf1LPqX/v
xp0JWI5cCu91IfNWyfWnrO8e8TP6KDADPTk4lXyEfbAfNiImiA3orw9fh+ed
4rEkaxu2Sa7jjd6P71ODhpp/Y8r5B0xD3IED1+ssn+Q8BrdPi9jZL35/1zM/
8tO48OddDZYbGWbW+v9wxP7OlPtS/PNl0exusG647+SODB8lVyyJ/8PxXho9
3tKYhw//g3qj3n0D+t8S+RP/nVtprLFd+29Oeww2uSOw2VZqn77dJroLJdt7
te6rb4z8y9kvzPj/LsQstfXOuOs40T9VWVfMMyb/oI/90ctgNzAZfk5/w3yf
+J/RocBp2Jw7G3IbNYRaQu7CR/YFPf0PMoId4Ms8+gRbc9/EXRNytYYM1OrW
wGAvZ303xB70mtxZUJ8Hyw6jM84b3OENy9se/J+KezgwT0VX311SV7if25jz
N2JsVPTXyN0WfoufICty0gcQN8QXuX109JL8z+TanO+2yVvHI3eBa+ZHXeMu
h+/0U9yV4iv4CX63oca+R51DLmoBd1VgoKa4P6dXAffybguaHdx/5uwT/wML
FQ3z
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3uQ1WMYx9/dai/tno44neuec7bUyqUhmUptEVHGxIT4w4xGtmbcaiUV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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.525628692310271, 0.4611595594063227, 0.8558150305103572], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmWl0VOUZxy8hmZDMhCxkJpOZSeKK0qPWilsFrYgL4AJaW1QEFXePdTku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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3mU1mUVxx+WGWbed+Yd0Hffxm0IOoCEggUjCCMxoiKSR4vdIdyOaZwW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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5988082140397283, 0.5837803671368867, 0.9102963450611828], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmnmUVdWVxm9ZA0W9V9Or9+q9d18NitPSjphkrSSdbifUYACls8KgQWOa
skUwkkRlFhRXJ1GTCIkxCESw0SUxDhikh7SAwFqKEo1GLZRYODAJDUgSI0NA
TX8/vs3ij1Pv3HPP2WefPX773Dqp57tf/84JSZLs1J9q/RbzSTJYbZX612SS
ZFl9kjxRkyTrG5Pk6xn3T69LkoGtSbJZc/LZJDlZ/Qtrk2RTLklq1f9Qc2Zk
3H9JRP+ktXWtHvugJUn2qX2/xu/rYn5dm2kOEO09Oc9jDmNnxV70z445u/V+
j9ptmrMz52f64xo8Bx6/lfWcizLm8RS13eLzrAY/0x+tNcvVRuj805qSZLvm
76gyPfqf17tXi0kySDK5rN587VV7W/ycWedn+mt0xsmi+2vNf7kzSeYVdF7R
W6b2mGjnq8zn+znTnaU2U+/atG63xu7WukOa82c9jxRv80Vruvi/un+SPK19
buiSjNuTpLvZcuttsWwn6Wyr1Z+j+dtT0Ve7WGOrWjx+SbXf8bxDexxWv61f
kjwqnj4qS/ZqszR+pX7HqL2h/a7QWX8j/rNVlt3ukAN647yce6bajDqf7dKc
Zc3YJK0viH5ebbP43VjyvD/2N8/zxc/GZp9xtcZ71X9DbaX6ue4kKUnW7+j5
X7XuW2pbJfMF4mu+WqN436nnmzR3hHSX1fNS7d8iPu+SfJ6uiF+t/Zx4n6b5
H2uvX0ge96l9pLnrNLZWbaD6z2pOqvnbdK5TtM8QPT8h2vdIdz/VnHOkm0a9
u0ltg+jfrfPMF/+N+p0smfxfjWW7SOde0OL3d4nGxrLXMJfxX2jtyzrT79WG
iP77QYdx9HSb+i3i59YW9ysa7xWNV9WuFZ0ldeZxsPaaIB8Zr/bFWvPE+4dl
e7fXeT1r8422LexqgfQyQf1X8eWc/XB65vh+V1X7/fUxBx1NCLt6RPJ8SPob
J3l+uSNJ7hT/94j36ZLVNLX99bZf9ppdb99/M2cd40djpJdU/JysuQPUHtec
OU32NXxugWieqjYna98bpbF5Vbadj5vtL3P1/jbp7k3xO1C2cW7R77GPzc2W
zaKc+w9W+7mv2fJi/P6cn//W4D3vE807pfMBOtcmyWG+9DU3te99Q2un1Jrv
9ZLDf4jfYXp+HV9TK4vP4Wo3h+0xxjv0eEjnGhzzsYfeGOf9a9FfoveD9P7f
E9v0hfWOme912U/wkX2N9gd8YavGt6ktbXbcIl4Ra7PS/xj9TtachTn7En5E
nBmasz++FrwVNW+Nzjuj3fyP0Puv1FoOa0TnGbWS2kS9OygZXax3O/p5/fZ+
9mn2x6/Z5/XgjfmLWr1mrvrrkb/Gu9Xfq98DojNK/R82W66jtO+NtY6ro5FV
zjp/LPrEmcvVvyTn9+htkWhP1JrZsoFKxX3mXhLzoQ/tG0Nn6G5/leP97oj5
Jel1eq3jKnYG/9g58WZjnGW77GpHt8+zQrRXtNqeE8n+BLUnw2ZHRY6okyxv
6LAP/k3rp9Y6NxHXkT9n3Bs2Mi8xz5yTtfjbT2rM517p+oUmx5JhsZb8RSwd
Fn3kf2n0h8Y4+v25aN9Ta9//S52f6WMDo4IH9Iy+iYGPa3zkMT5y7jP+suR6
t87TXHf8HbYxTH5xuGz54eenxznJy+Qq8h++PjZ3PJ4jU3LWB2pTG4wTyOm1
bc7f6AnecjWWQTHksE/+N7fs58Xi57x2n6dN9Koz1ivnRg7Y4VPoo8nz+eWZ
ODNIfB5osn+hs9E5y2OcYsZntMc42fOnov+J6F8juRbl42eI3pJa+38p8m+X
5qwvOFfuanDcIqdfVbLu0fv/aLy3yhipVfT/WfRXidZwzT253nkDrDBOczPq
PyV6NbKlFcHviuD52BmQw1DNqe3y2DGbRo/8Lo/5xEXORmwcGudjzpOBMxg/
IFs+sWJcgAx4h8x/mRrbwfP/1pvXGzXe198+ctRXmhy72esR/f5K7Yj0+9sG
28jrGj+/3XpCR7fqd5ba7zPOl+eqlUVnpPTZoL1eFu3L1G8vOf7x+6WC+8M0
Xp13rM3IRhrabLNgt4GB30aHz2GTTcrLDamxR6afdQfuwi/hkdyxQu+nlv1M
bHqrzTGN377o88vz6oh/fdHv0NpKats9WzxOEp3DojNFZ/uk0XaObXNG5ozN
WufEvfe0bnnRur+93jJ4sdp2hb+AY8G5tYGB39X8d9QGZZxvid/kXOLWzsCH
QwMr4vtXi5cfl52fB0jel4m/J7VPb9axeFmd/XROo+UGTmBshGje0c95EfxA
nuyLvAlfe4I3/BM/xRfAJ+SAbD9jvT3h7/gLcwYE9q9rO76uLsa3VawndNSp
/hdSY88HFC8XdxiTFMTvtHpjb/gFr8Pzb7Ruudo3m6wPdHQmZ9dZF3Uaf14o
ejPU/6XWDNb4G2X72odgTLUD9cY4YB1qip6c+2Cefdp/Q9m56anUuBBMuKXe
uZ7cTG4ZHDnoC7LNR7XXFNnYl6XbP8ivmpCLzpWpuDa6WTw8rjlXaP5zGnu2
4hz4jSbnM/hPdY5y6AP6jJO/DoqXh0qWK+dlT2x4nfpr1a5TeyljXHFprf0S
/0QOn2jPv3c6rnO+njgv/twYeJUaBxnfW2X/fDjozAg6acSWaRFD8Kczw6ce
lo9vqXgM7IRO8MWREQeIa/BIfMhU2d9+Ffwfy+v47H2Szyvi85bY85bgnzpy
lvpzamwTM6NPjsEWyKfktwORQyeKl3VqazI+82Mhw8+K/pFO70+8+nXwAy+P
RJ/8Sp4Cr2PH2D1xHh97P3LlTp3r802u31aqpU32R+IwGAM5jQ67RKfnZ425
wds/aHB9xjNxgTqZ3IdvUxOSO56JGDMveEN2+CY10MbImxfLHi9KjXvATfsC
3zB3Xcw/TTI4teIYMlbnXtzt2HSO1m2Rvc7T2vPVPy81zV1xrtYa2xO0kMlA
vT9Scq02PujzHnxEzQBGGhb5FrxBrt8UNtYbuZ942Ndu/Ap27RW95/OuK1nD
GP152utZjS85wTUHcgIHEfPBsNRv4BH0CiZZIh5mi+8pendZf/8yh3wGZqLm
4hkcTt2HDKmZiaHEWPwfPhdr34Wp692tyCc1JhwbdQpzfqqxloLxHj66JvDw
5f2NDR8MHEe9iR3OjvqTvamFwDGchflgd9a8p7OO6vQz9rUzYjixd1HUIysC
a/aF/JE98iHmXhc6AmeMj3FwPnpBP+iY/cg9XxXv9Sc6v4+J2oAcimyzId8b
wDNF4yN0Rw7BtstxVuwKHEqew1fYc0KMQ4u8jC8nOlMVvtzoOMAveIAanDno
hLOB06m/bteeY7qdf5ZFTuJM6AofQ18zxdstFce5dVHbsi+8Z9qO758J+vhO
KfyIPHBL5AJkg4xWR52yMGRFbl0Q4/BGXQF/YyNmEhP6AgeADaid0Qv2cLQG
ybmuLMUc9sU/74/xVanvJriXILdvivp3TcR8aHKnsCry71D5ypAu14vk7TTy
wjNhe8xnXRr9u4quvbG15wvGpuBSfOjp8CPOSW2D7UGrHDKsyB+/o7a03rh7
dGBv8s8VET8PFU0Xmt0VY8dj90n84mvICrvA3/G/yTEODgIPgXXA0+Ah/IWc
trXivPafot9RMRYCJzAGxrij7LoOXXxadh0OViLfLk+dc8H94H+wMXFlURp3
VvrdnzqHcDf5QdQaLdrrnzp8XwZmvzrj2Msdz3MF2yQ1zaUFY91VGl9ZMR6h
3gXzUKeDTah9yZuH9P7Ndsch3jMOb/Tfj/kHJbMNBcumMcbx47mSw5/ET11/
P++ItZvF+9tqF4i/w6J/RO2b4qGqy/6MjtDVqMD31LPUgcSQJyJ3kiupmagZ
qBfgDxpTIi4Nzzg2UbeWMsbI/6U9/zv18+TIDcgHO0Jm2BL3gsRLagRsam7o
FNuaE/3zCrYt7OqMwOLolDukCRFf3lT7h6xxQqt0d1XZY9x7IR/klJNcx6MD
8fNF6e60Du+HLxFTiO09ksnYLteCxMrqBtcq4LzboyalzoI2e71Y8T0md5gT
xePv9PyAznJ11vUfNRs4aI/aFZo/X7o7pWJ8SD2DrsAdjaFD4jDxhTNh/2BS
6gowAHFgVta5lblgSWI1tc2WwJPkvStLHp8v2V9e8FrOB64irtZo/9qK7RUa
2bAT7ry4H6IG4e7wjorvD7nXnB53m00hS/gkpyAjbJuzoR/Ozh0kd1LYaqHR
MmTejZL39zpcQ4AxX8j4/mp26ns39v9x6jtN7jO/1993nOzH3eTsgu8fsTny
Ijlxgnhsa/fZ14DH846TNfq9WTTfyBqjNQXPxJBzop66VTQvKrhepo5/OuNa
HizxaNyf78+bLjR3clec9z3Qx9rzSj33qF8Wz2lqGwf7YOf0e6IOIOYTq5hL
TEbG3MUhZ+QAj+BkcubzkTc5D7/w8yXt+ULRa16LOzbiApgRXEZuPZjxHQH5
cW3GZ4E+NeJPUteJz5UcH4mNzP1tzGfuyphPXbI64/2vl2y/XfEz+Ywcyl7U
u0dxcLXroa8UXAPgD1sbLM870WPq5087fT+O/WzN2weQS1l+tr/o+hW5gYmx
7d+hkxOND+o0p7rLdxjnit5LBctzlmhU5Y1BuAu8JmIF9y5nxd3LVXq/MrVf
439LwwfTuH8k3y3uNFYDp4EdZheNH+7VPrtT16rbUn/n4O6cbxdzC/5+8bHW
Hu407iffjg39viK7fStrXxgd93Dk8bdkM2d3ODZwT/Fw8MMdPLTB9ltFb0un
763RGTGbvQ5lvI548q7k8U6XceufxddfUsffI22uIfFlcuaUyKGTpMPJFftb
vt21DXUNuXBRyBz+wXjIsKXbdo/NF5psJ9gLdrImfIR4SB1CTPyR+NpV7zvI
yYGhwU5gpZ7U8ewHktuc1DpukwzyatOyrrf2BtalrmAuPJNPdwVvYINV8b2p
p9tn5rzsDw3yCb6xNmyYe8HeqHFmav7f23yPDa7LRgzkTGdmXVtmRK8xdY7j
Loj7Ae4W+GZBjgIP1Ot9/9TvqHmHx53bZ0V/ecH3ZMsl2w8k23/JutakzoQm
dvRJ2bbEfiPD7z7T7TxEDgIv/LVozIB/l7LGA9zrE0u5S58u+s9U/A7beTHj
uLFQtvAzjW/V81fxrw7XU+BK8CWxd0vGeQvfvL7LWIHcs0O89eRte3xXYT5Y
FFnviDulBQXLiLNU8t7j1Yjz8+M7FPXUiLjv7QPXlS1D/Omdkn2K+McvPjJF
c6aqbRBf06kvKz4P8WdD5AXkvblimX9Ucfwl9n4tvotQJ70SZ+NcYAqwCDp7
Vzze123eqLf+mvpcfIfjnuLeuP8fHXcmnZr/ww7XwMiRuEU8I67ie/jd25Lb
H9tt48Semzocf5BZIeSMH3wteKOWhh64ktr37G7Xv9SI90edOCRiALFiU7v3
gD7x76SKfZizYlPEMfIYeZGcyDfzeR3GTk/I1yYVfA9ETH2ww3H1ItF8qOIz
4Aff7bAvvB7fl7C1o/i+3romrxTD9prFb2u360hy7fDgge9CZwVWmMp9Vafj
BGPtWY9zDwSuhc7y+DaHH/GtFPzLe2I08uC7LfHlYMiZeHhrfKPk2zPj+Av4
IB/0e+JbwIfhU+hsXOB31rEXeHBk6JE92gKPgSH4hsH3C7DEzVHvc/+0tN0Y
sxR3TdQ1J2lsRNl6OkOyfaDi9RdkfQcKJlwLpso7NrYWnGuRJ3d4/1i03vh2
cyDmnyh6J6kt1Pm3ac6C1DgP+W2N73Tc6/0ovm+B+4iJxMPt8b2Tey1kDA30
tj41f/B2sOIciX1Sr99ZNs6/TnydkfpOYVDUK+SXVzT/DxXHRPzm+0X7Dt8s
8TH8C4xL/4H4/sudFGfh/gAMuSTuSKA9IrDtgfhuNF77TigdzxO7Yg40Lgg6
fPfl+eg35X7xTV/9dtlsocP/m/Bv4v3a1FhkXHzzR6fnFP29ljXUZ8viTpw8
PCRwKZjy2rirPFW8nFbyPPAEd9uXRD2Sj3258z695Hd8f5sY3+DYj3n4Hd/w
ix2uucGMbbH2/wGpIuYq
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3tw1dURxw8kxHDvTUJIbm7u73eTyLOVqnScaW0pgoDSUR7t2PJQMRSo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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.661875648932041, 0.6851121863084201, 0.9117340883263733], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXuUlVUZxj+GGeCcuTBn5syZOddJl1a08lLpyksCS2oVispFkFugeCst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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3uQzWUYx197P2d37drdc/v9zjkboxrNlMzUNMJSqmnFuK7cFyFFuSyt
O1EtU1EKpSzpblxilEj+aNyGKJdNksuuzDRdREXLkj5P3/3jmfO+v+d+eZ/n
Oc2Hj+v1dIpzrgZIAw5EnDsI9E93Lp0P7UPOxaLOdWm8zwfXNu5cdY5zd+Y7
14777cXOlWU5V5DpXH7CuTVh5x7Pc25xrnOJpHM+8DO8+5s61wLcfN+52qB0
5CH/IjKKwO9Nde5NaH+LOdcTfC+gknsZPFug9TOc8+DdCc+4bOeeBko5t8S+
WVmS8Qn3fkX8Qr+X+wpkXfac6w1tM+RN5zwD+DXg3CT8/RHZZ9DxLva+D5zl
XAfsB/cedx/8RHQ+mKUYHMLXEuyN4uuoZs4F0dUHHQeQ9wo8byN7OdAa3Q3o
GwW+I/Q1+NamiXNLse8gMdqKrBeh2QY+C/5n4e9JIgZZ7IG53MvR8Qq4xdCH
iWUa8npYLLAhge4NyPgF/K9ADfSHkF/BeQD2rsuWj+2wpRnyppGvJUHZ/hg6
Y5nyoS/ypiSVu/9jDH3ck64S7Ekiaw82VyBvIrAY3QMiysVG8v8AvIOhWQ/u
AvldBu8S4H7Ol5BxBvmngB7YMhueKdjXBnnHwZ3n2znk/QRUWuzw6WVoDyKv
Ffb2yVNtlMPzQ0D5PYm+76GpAb8K/FV0NQCFyIvjfyq+PQL9LujnInMbshbA
cwT6QiAf3pF860Q+O+LvJGhbY893QcVrO/fJ0ORDexvfbhD76wnV0jp8+g7c
UaArtOPxpyaqGrLa6c63mej/MibeKuyZi65i8EeIz2HgFLacBgYh/33i+ya2
ny2W75fh6YYtLeCphNZDZ3d4lyAvCK6Bb3eA7w9+Lecr1NQEzjFoStNVo28g
qw4bhoD7ivzsIX67I6LtBM074FcDnXNVk3dD21CILnhLgM+g/RQ4kCr9teDb
e6qdwXxr6UuHyV4WVG3UQz8vSzVitbmKe1mGavQ+4nM6rNzvguYbYrkspNpP
yZZv6+knrXLl49fgOniSbTEYB+4G9k12yuGukHqAvf3xQCSuHmC1YTU+GlxB
WL5aTndi/1JPtXgYHauhv4R9p53e1Ajo88KqhZXYV+WrB1qvO4b8Y5yv4kNF
QD0uA9pB5hPni9TDPF890ugtx02jypHFuwSZadCX4OO2gHJmb2WQr9qwN7MH
+45GVTtHsKcQ+ifAbwe3AxjD+UlftWzfyojfmSLl4nV8Gg6uaVi6rKYnc5/k
q5nbG7iZ8y3AtqBq4hn4K4EAunZyv0hsLgAnYOlmMSU+E4DDOXqTV8DVe3pb
1kOH4Vs8qV6enq3czCDn5fnK0QpPPpkv19DZhPNM8MPAV4HvDP8s4vFnQDNg
iM2KIvXGe7B5aEg923p1GvLT0dWFb79w34zONO6buO9LUw+9hL6/PfWqHtCf
5PwjsBldHblv5LwGf8vgDXPfXqQeZr2rHzx9ye+r3Nfnq2atN/2b0Fu3HlUF
/wtAtZPNCzk/j331nK8A3xLbb3zF0npWKbksgP81/L+OT/uR1xWdPbM0A8uT
8tF8K6BnTIN3qq/ZsY9vJcjv6Cm35cjsB/108lGL7Ezoa8HVAU2yNaPGxlWT
VouHoPGRNYdv53I0I20WVXvKhc2kELgwUAl+a4Ziuwh/UoKK8e6Qer71+j3I
fJT7G556Uz0QwZe3PM22J4n/As7zgXWN8fnY+nNEubQdYDL0NWH1ygHEYDn3
gRHNtuHcn8OWeUBFunr8SGSN8OS71eytUfVE60XWYybGVVNWSzYDjoc1E2wW
DOReBL4Q2JAiHxvw5aq9iQz13Nn4OrOx/v4CVnKuBgqCmiHnOf8e0+7RG5iL
rKFJ5cpsHIisK9TLjRzN2GPor/el23Skc++c1Cw0Gg9fYkDbFNWM5a6a+iht
qhzei/z8iHKxEvpmCe1QtjtZDVnu58Rkq9WA5bYqptqzHD/MuTSm3mUzwHyx
N2pv03yajb5F8LhcvVHL9XlPb91yPo34/gmMCShmvcE3D6v32U7zV0Q913qt
7Vhl3PsBAzK1s0wCty6h2uhFjsag62qhdivreS2g/cDX7KrKUS99Cfl3BdRT
n4qrhq12rec0R/9NwJZUzSTrHf/A/0dAPcR8mdO4v5lPU2PaKWyXMJqaiGaY
1Yu9OduN+if1dmxHmo6sGb7emvXIz33ZaLbZzLdd8ERYu5/thKfQddpTL7Ec
Wq8cXqzd13rmUux5iHoM5qqn1oZV41bbczKEszdjb8VoCm13Q18tss/kaRbF
knprNpM+Ij49w9rtvIBm91hfs8BmysCoZprNMptBu9A/mnsiUzPdZumHUfHa
TF1LbipCyo3txCH0h4ul+yDyUtGdkVRvtZ7anXOPpHYV63m26y+IqDZt57dd
ri4s32yns11yOzQdcrVT7ojqDdnbsRwHYuq51mttpzVbOyEvnimbX8W35Unt
etZDWhHfx6PajWYH1ZttR7bd2Hq07V4j4R+RqR1sBf4NCWmXsDf1aEQ9x3qN
1aj1fttxbLexGVCNrSvjmhWnnHbVTZ5mg+2sI+C/Rv3Gs6RjJvwzEoqV+XgD
3oVF2rXtP8oXNqt97ZZWs0XFmgHW+y3H/wHzPejM
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7249430838243536, 0.7864440054799533, 0.9131718315915636], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNm3ecVEW2x+8gE3p6mNQzPd3TEwhGUIJgQEFd05qzDMgMsC4oqM+cw+4D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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHeUVdUVxg8w7b0Zhvb6m3kDJgoMTUAsgJhlRSJFaUMVFemBWNAooFLE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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7854235303425917, 0.8545987015407763, 0.903819966831649], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFm3eclNW5xwfYgdnZnZlld6fP7tKUplIUBY2xoyKgEBsgxJKIgFcENbGL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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXm8zfXWx3+cwdn7nH3O4Zw973M2eTIPB4UjEmUMxVWRSNzKdA2heZCh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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8420623673300127, 0.8734862444808253, 0.8784458186171942], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNm3eclNXVxx9Ydndmd7bv7OyUnaFqFLBQREUFFCWKnaLGLiBgQSkSW2yI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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXmcz3Uex7/M/GZ+P/ObGcf8fr/53e6tkI3ByLaoJEdlHaVTMY5I1pGK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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8987012043174338, 0.8923737874208744, 0.8530716704027393], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFnHe4VNXVxs/tdW6duXPLzB1iQcRIooICSb5IMQKCCMSCJhEBwYKKYgMV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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXd4lVUSxr8UCAkkodwv9+bmFlREiguWsCJrAWmK1IA0daUTRAXBAqir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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmgmUlNWVx7+uKuyml6KpruoFurppRcHRGeOoqCBqIiKuNGrGFfRoVBal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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllnds1VUUxy/0ySuUtkjfr++1fb8OERQlAoKYCAjSIi6koMhwEQ1RZjEC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         "],
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{7573, 7335, 7336, 5200, 7588, 5199, 7334, 7333, 5456, 7571, 
         5616, 8113, 5617, 6186, 6185, 5103, 7307, 7306, 7554, 7305, 7380, 
         7379, 5231, 6224, 5608, 7734, 5609, 7735, 8035, 6026, 5349, 6396, 
         5953, 5581, 5348, 5486, 8104, 5485, 5873, 7501, 7503, 7502, 5859, 
         7908, 7488, 7489, 6223, 6964, 6965, 6825, 5483, 6579, 6912, 7633, 
         7634, 7445, 7446, 7447, 5993, 8153, 5994, 5991, 8008, 5992, 8005, 
         8007, 8006, 5100, 6210, 8041, 6031, 8040, 6032, 6416, 6415, 5353, 
         5586, 8110, 5585, 5278, 5563, 5564, 5330, 5684, 8064, 5157, 6214, 
         5587, 8111, 5588, 5354, 6401, 6402, 5962, 8078, 5279, 6211, 5280, 
         7652, 7653, 7651, 5543, 7654, 5331, 5565, 6937, 6738, 5373, 6737, 
         5372, 7687, 7688, 7493, 7494, 6703, 5555, 6932, 7208, 7207, 6397, 
         7512, 7511, 6720, 6027, 6376, 6375, 6410, 7492, 7491, 7490, 5996, 
         8009, 5995, 7236, 7237, 7233, 7235, 7234, 6405, 6404, 5326, 6707, 
         6706, 5997, 8010, 7216, 7217, 6740, 8197, 6741, 6739, 6927, 6926, 
         7383, 5232, 8069, 5955, 5954, 6029, 8159, 6028, 5322, 5532, 8079, 
         5284, 5556, 8107, 5557, 5531, 7636, 7638, 7637, 6189, 5107, 7591, 
         7592, 6831, 5488, 6832, 7453, 7452, 5530, 7635, 7382, 7381, 5487, 
         7590, 5618, 7576, 5457, 7339, 7340, 5202, 7589, 5201, 7338, 7337, 
         7575, 7574, 7740, 7572, 7573}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7516, 5909, 5332, 5566, 5333, 6411, 5334, 6008, 6685, 6324, 
         5744, 7242, 7243, 6587, 5238, 6323, 5239, 6150, 6151, 6054, 6437, 
         6081, 6082, 6191, 6190, 6187, 6188, 5490, 8071, 5240, 7391, 8179, 
         5461, 7577, 7343, 7344, 5206, 7598, 5207, 7346, 7345, 7393, 7392, 
         5247, 7394, 7395, 7348, 7349, 5209, 7602, 5210, 7351, 7350, 7578, 
         5464, 8180, 7460, 5287, 7461, 8105, 5493, 7603, 7403, 7604, 5499, 
         7408, 7409, 6842, 5494, 6839, 6841, 6840, 6128, 6193, 5134, 7290, 
         7289, 5672, 7919, 5869, 7918, 5868, 6115, 6114, 6436, 5537, 6197, 
         6708, 5328, 8016, 6003, 8015, 6004, 8017, 5968, 5969, 5294, 6934, 
         5293, 8175, 6933, 6675, 6687, 6686, 6689, 6688, 7933, 5880, 7506, 
         7507, 5339, 6365, 5338, 7504, 7505, 7486, 7487, 5312, 6329, 6330, 
         6331, 6002, 8085, 5327, 6406, 5967, 5548, 5311, 7485, 7660, 7659, 
         6674, 6915, 5536, 7647, 7646, 6705, 6947, 5584, 5351, 7692, 5558, 
         7689, 7691, 7690, 5254, 6204, 7932, 5876, 7931, 5877, 6364, 6363, 
         5337, 5571, 8108, 5570, 5128, 5181, 5434, 5350, 5583, 8109, 5582, 
         5252, 5567, 5568, 5335, 6418, 6419, 6060, 5127, 6203, 6196, 8012, 
         8013, 8011, 5999, 8014, 5998, 6001, 8154, 6000, 7459, 7458, 7457, 
         7640, 7639, 7818, 7947, 5362, 7523, 7522, 5910, 6704, 5323, 6358, 
         7496, 7495, 7909, 5862, 7513, 8139, 8195, 8196, 7515, 7514, 5359, 
         6378, 5360, 7517, 7516}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwl1XtMl1Ucx/FDrZXN1koRUgRUqpV2WcGi2kqym6XV0ESzpnLzgkqA2vJC
mhcoXZkr23SVgjlbXtDmpc1U+KfUyK1aeV9ugkAKJs0sU3qd9cebz/nezznP
8/zol1+aOz0hhPCjPy/0DmHQbSHcgzmpIczFtykhfIf9qEsOYZvYVtRhQq8Q
ktJCSE0KYZR4Hrb2CaGAv44W0m00n35Fi+k8PYvoZXWj5Y/BWnPzE0NYQwto
De3RN4RaWsT+zLqQ3q72DmTgJHu9+CS6yV7+tb6CLlxFYc8QjtjXVPFGM37A
IWxgf08PolbfA/Q5OhSNak6raUKinj3xm/UpnLbnBntuopvQ7Dwb6Rlaom6e
uym2r4n4kG8lPkKq/u1itXL6mNEbw/U7iml8eXq+Ee+Pjol3gpnskfRljMAs
9kC553uYoV8RUvn7oi2e38zN+BJb7GkjLZP/u3iLPYxyH0HeNLO7+CeLZ8ub
RB+iT8rpFM+hQ/AEEuz5onkL5LyN+ZgqdyH9XI9UveriPByxn8Mo0+ML/kz3
9iBGm5uHDLFF+o1Qt8m6Qk05hun3jz0e5SsXW2I9jW+RWK31OpwUO4EZ4tv0
qKDH2cewRN5ijDQ3xHdNfpd1nrw35VWzy/jv5Kug77Ln8G8Xn03fYZfzjxJ/
Wp9n8BS68b0mZ358H8xpQrVzVWG5dYbn0ah2AJ0hP1f+Lv6vMTb2VbvaHY53
9gkYhxvMaKBz6QF3cxDb1e6I77S+G9StsF6g1/v0AyzHFL1ScLP4mHinuEvO
Uv0H0zU0h5bIXWtdqlc5yvA6WuS3Ypn6vXJ2yd1D67EPO9lZznHIeTLpEHmJ
qGQPiu8diq0nohDvsYvoyvgcrHORaU4WdvBdH89F/7CXC2jHeXRglXMsFfvU
3JXm/sL3MT0c3yH8ioPsFj1PyuulVxLa2K1o4JthzkxUoLu7vDWegSbrlYSe
7riGfUx+lfyf2D/jVPyW471bLxb/Rv1u3MK+n96HEziOheL7+RfFZ0WTPdfu
znwTisUn4s/4fTlPJy2Kv08oFZ+OenX71N2Y7j203ms9m9bTFL1S7G21vEtq
z+nxF13F/oT/gvP/7Uyd8duIv8Hxdyc+Q3Vt2Cm/hZ5BM7Lic8N1+r+i/6vo
Zu5YWok2d1Kp/1k5rdZ79JqlZza95Pt+QCzHnCvqc8Wv0mp2qZwqOp2221cC
/wA119AOdn+arefDSHP2dKzXq8P+0vjSo9/++iEdF+U/S4disDmP6t3O11/P
jvg89LxX/SP8Z9mPyTlHH6fr1KyI/3P0PMOXJaeArxB3q9mttpl/PHsC8jHZ
vp/nXyt+rdoaOoydJu8l93KZ/SLdof9OTJFfqW8JfYuekDdQ3Qi9RsZvPtY7
23CMk7NZbAsm8zepn6XX8N7//w/9D4gAI58=
         "]],
        "0.75`"],
       Annotation[#, 0.75, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwl1UlsllUUxvHbidLSylSh8wBGpaVAB1oqGgYZhJqCFU1kKogRNQpS0DBE
hhaUQIsyuZA2pUYDoYmzUlyoCxfiCpookmiNs8bAgkAsGlt/Ny7+fe455znn
3vd+75uWPLqxcUNCCOGMPxMLQyjNCeGB/BC25IZQcGsI68TPWe+X21YUwlb8
MTaERnFpXghlmIRLvGfHh1CSFcLi7BBuWv+NNeNC6KUP8U9Qq1f7hvcfuRz6
rvic9ce4LO4xa7mebvuewmn0iJ91hlz1N8R5dJP4pnlX9D0e8+L1NKM4hDet
swpC6HLWk9hlvRt7sBOj7DEaYzEG68yYyzcP96LPfnn26Zf/HpOdvQyd9ruq
fsr8K/Q07TbvJJ60d55cPrKRixw0eL6n9F3Qf4R/Cd9h2kDPuO+37JWtPwcj
5Xv1rJf7wLk+coaz2GlGn/6L6BU/of6h+qC5lXItzlirdwZ+4E0SJ5qTTIfs
kWAdkIRWuRt+vx3WxdZFqDGjFlWYjmr8aM4u7MYwnjS5FJqsrwV7MNX+183a
bv20c1Xiuuea72y30SS9NXLTcb9cPT4142H5ieqJ9C+6jLaZ/wzfTM/2Gt9N
+UV0gC6m6fGdstdwmoYXsQ93xn71RH1z47PSAedpN+8Qms3chEfcTRJvh9qr
4vfVVsulym1w98PoNbXD8XfC8/G9xxykm9lkj2qeA/Y8iDEYjbUYj6V8S9CA
Qv5O/ntoBz1qXmP8rlDAOye+v/SCu3hZ/RUcit8Sf5H8QvUj4nLxCs+0EsfN
OIZ57nwcMqzT9Y+gI2invg50xbsR93uWl+g+NFmvwUqsxiqsje+qOZvpFjSj
mzfXGXNwi/XPZmXQn+gyd1TnvjLFmfZ8L34bzvi6Mwb5BCTiBG8mbwaGzOlW
74/Pwl9qjym0jC73jCd4VtAufSnWx53nM/3HaLI4CbW8NWjj+4rvEr7G0Xj2
+G6qpZqZQofT1Kj4EueRJveC82bx/ypOt97rXK1oN6fdHm04iN/kBtX75A/a
7yI9QN8x4+14l+LZ4n6+WXSvuIt+J/4Wl9Ei/kK+h7+V1onr47dJW2ie/GK6
CAuQE+88/q5652OGcw74vc/L73B3ozzjSAx692vUPo/PKD+Ldzb+lT/nfh/E
NvO2Y6P87fbban2DLlC7Dwvxif78+B4imDskvmZGudkz7FuHmfHdxd0o0V9H
70KFniZnvco/if8XtUr+alShWDyNVmBV/L7wJ+8dvJPlylGGqZiCQv4Kcyvj
/xCzl/L/zj+Rf5pcs/NvxmNqVeIJhf//j/oPZkfaAw==
         "]],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5276, 8077, 5961, 5801, 7882, 5830, 7880, 5829, 7881, 6184, 
         7899, 5837, 7898, 5838, 7900, 5836, 5986, 8151, 5985}],
        "0.25`"],
       Annotation[#, 0.25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwl1Wdsl1UUx/GHUdoyBAVKZRSqskqZDZQOhBiBgrRIEVktAgnQUiiYMOIO
MhKJGA0lgBQ1hTJKW9+IAaqsEoKKyFBiQAMq8IKRqBQQROPnxhdffs8553fP
ufc+T/8kz16UX9ooiqIb/klOiqJxnaMoF0Udo6ht+yiaR9vRYponX0Lbi+fT
BLqAjpcvpR3EC2kiXUR3dYqi3ZiSEEUVj0fRQb5D2JMYRTvEldiGqepVfDs7
RFE1nS7eLX+Y9wiq+avFe1CFWp4adFHbTivxQegV9t5Ojj+Pvuo8BXp9ql5I
a+VrMEftkPjLrmbQHXKVKOVfhIouzucMR/Wrx7EwR3xZ/oG18+kClGCf+Ftr
99P39Tui323zrnteILeKfmZvK+leOgdz0UPteltnck/VqEItalCqtp/nAOah
CL3kbvHH2EszNEUcYjHEzI1mbkIx73yUhLVqZfrl2/t6OpE22PMd/Ika8W16
3/rj9veAnsZTvN3RA6ed7Un6BEbr9536Gbme4lHiZO/sd/EuOkJ8Tv2ufeTS
9fZQhkn2voLnBTpe7Xnk4W/zh7nvgfKHrV9iTQxfU0zCAPl7zlykb7o+D/hz
rUuhLdWHyWVjitxk1OsxTb63egs6FVOQFt6ZHsXI4m9iziT+vnyt1J+Ry0AL
+Zny2XQWbUULnbMlbcs3mH+xfKK4lHagOfafoX9jjNIjkS+Lr4SetJ/VfGuw
Ct34k8I89XXhHOJ3w971eBEj9GiDbjzNurlbupbnrD513s9Itbec4U0U8hea
twUf4iW1j/hn0jr1A5ho7Sd8m+nHdBP9GWV6neAb6Hmv5wF0ubX1cuvFZ8SN
zTzhuRG95xuptee74VvBXygUl9MCeofvUfNa836Pc2GNfun0Gr2K0Xq25mmD
R9Dcmng08Iw1d6vce84R676bYbPcTXoLN9DcPcVjC98YtfLw/YvXWdNUvQk2
ycfQY2Zl2lsWsnHK/Dq1oZ4z8A2+RiziUBm+F9oc8dggPkkH2d9A7La+KtyP
vgfFR+ky8RIsxQZxufsto1vpDLPuyxfS886XGe5EfBbH5VLssU/YL+9GPHSW
f/CF+jXnuYorGGVdSrgr+/kqfEP6X5JvkLuDffwXxRfwI57l7y0fz9+JdhSP
M6fIWYpxkz8n/B1jJMrVh/Ml6LtCnGbd2nBu+g6dYWac2htqqXJr5PrQ1XSC
2kPPT4fvFsOx2B5K0V1+eXiHPJnWf+7OMujb5q/Ec54X84+lL9M//I2nupc0
+xmEJD0m8OVjm7ir+IaeE8Xbxcv1W4ZV9rESFXJLxb/xpJt5hQ6lg/UfQn8V
99OjPwbg33BP5l6W70V/oSm0Tr4nvSSe5l6moyC8G/l++lyU70t/ov1pmv6p
9IK4Z/iNxkPeziGW/4H2kJuJWdgZfgOcc7J1r5iTQxfSMfR1Z3st/OZZfyp8
d/S89XPd42N0dugf1if9///0f6K/E8A=
         "]],
        "0.25`"],
       Annotation[#, 0.25, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3, 8146, 8145, 5950, 5219, 7356, 7357, 7549, 7548, 7303, 
         7957, 7958, 7955, 5917, 7956, 6217, 7442, 7441, 7440, 5802, 7849, 
         6104, 5726, 5223, 6319, 5222, 5951, 7987, 8097, 8098, 7366, 7365, 
         5224, 5952, 31}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5116, 5988, 8152, 5989, 5844, 5846, 8127, 5845, 5237, 5975, 
         8147, 5976, 5973, 6408, 5306, 8081, 5974, 6058, 6048, 8119, 5712, 
         6424, 5713, 6312, 5710, 6311, 7342, 6549, 5711, 7078, 5922, 7096, 
         5749, 6588, 6589, 5245, 6326, 5244, 7004, 7005, 7748, 7747, 5637, 
         8185, 7003, 8115, 7002, 6515, 6780, 6779, 6998, 5172, 5114, 7275, 
         6462, 5636, 7001, 5422, 6158, 6467, 6458, 5646, 7010, 6085, 7013, 
         5648, 7011, 5647, 7012, 6164, 6473, 6472, 6471, 5657, 7025, 6090, 
         7026, 5659, 7023, 5658, 6169, 5436, 7043, 5663, 7042, 7760, 7759, 
         5182, 5129, 6790, 6791, 6525, 6527, 6528, 7291, 7768, 7770, 7769, 
         6635, 6634, 5261, 6333, 5262, 7423, 6636, 7833, 5771, 8124, 6637, 
         6638, 6334, 5772, 6394, 6103, 7981, 5947, 7797, 5716, 7800, 5718, 
         7798, 5717, 7799, 5786, 5978, 8082, 5308, 6409, 5977, 5980, 8148, 
         5979, 5274, 5857, 8129, 5858, 5854, 5856, 8128, 5855, 6209}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5391, 6129, 6495, 6540, 7322, 7300, 7299, 7298, 7776, 7775, 
         5472, 6557, 6902, 6903, 6905, 6904, 6925, 6906, 6907, 6560, 6559, 
         6558, 5473, 7708, 7709, 7707, 5579, 5196, 6101, 6070, 6069}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5150, 5195, 7328, 7326, 7327, 6898, 6901, 6900, 5303, 6683, 
         6684, 6544, 7570, 7329, 7330, 6133, 7705, 5574, 6942, 5575, 6136, 
         8086, 6135, 6183, 5453, 6946, 5580, 6717, 6948, 8088, 5346, 7510, 
         6949, 6950, 6755, 6757, 6756, 5347, 6718, 6719, 6714, 7509, 5344, 
         6367, 5345, 6716, 6715, 5905, 7191, 5449, 6180, 6130, 6131, 5573, 
         6938, 5572, 6939, 7296, 6535, 6534, 6798, 6533, 6682, 6681, 5300, 
         6878, 6879, 6875, 6877, 6876, 5139, 5186, 6194}],
        RowBox[{"-", "0.25`"}]],
       Annotation[#, -0.25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5935, 6386, 6266, 5321, 7187, 7188, 7186, 7190, 7189, 5904, 
         7226, 6025, 7225, 6024, 8034, 6896, 6897, 6895, 6894, 6543, 5450, 
         7685, 7686, 7683, 5554, 7684, 5217, 7630, 5526, 7629, 5527, 7631, 
         5470, 7581, 7582, 6882, 6881, 7164, 7906, 7907, 7905, 5851, 7904, 
         5852, 6357, 6356, 5319, 6813, 6814, 6810, 6812, 6811, 5143, 5190, 
         7318, 7319, 7543, 7542, 5389, 7119, 7120, 7118, 5773, 7834, 7057, 
         6792, 6793, 6526, 5443, 7048, 5666, 6486, 7286, 6094, 6093, 7047, 
         5665, 6483, 6484, 5130, 6170, 7033, 7034, 7032, 7036, 7035, 6091, 
         7028, 7029, 6474, 6475, 5123, 6165, 7018, 7019, 7017, 5651, 7020, 
         6086, 6087, 5649, 7014, 5650, 7016, 5423, 6516, 6784, 7311, 6783, 
         8060, 5119, 7279, 8121, 5751, 7817, 7098, 7100, 7099, 5380, 6432, 
         6433, 6057, 5115, 5173, 7594, 6833, 6834, 6805, 6807, 6806, 5316, 
         6235, 6236, 5638, 7276, 7277, 7278, 7281, 7280, 5120, 8164, 8165, 
         8163, 6809, 6808, 5463, 7597, 5492, 7595, 5491, 7596, 5208, 5552, 
         7677, 7679, 7678, 5425, 6520, 6521, 6522, 7159, 8061, 5121, 7282, 
         5848, 7901, 5849, 7160, 5847, 7162, 7163, 7161, 7903, 7902, 5317, 
         6247, 6697, 6696}],
        RowBox[{"-", "0.25`"}]],
       Annotation[#, -0.25, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwl1ElIllEUxvFrFFiWZaSVZlpiEJi5aSSNRmzaBC0yyXTRhNoiaKQyaBIj
WwgmhUGWRJuyadNgQXObhGpRUWYTRSVUajjR76XF3+eec557zrnvB04o2bKy
PCaEEO9P0pgQZiSGsJZOp9tSQtiOrVg6PoQlmD0qhIHYOi6E5WND2Ku2B7n8
pe7l0RRajjI8UXuKNbwFWIWspBBaRocwT58EFModk2unITWEGNS4W2refPkz
7i+gDfQVnWr2evezkkOYgmz08E9NC2GOfDbNpTm0yT5BnwGIQb44Nj2EI2ZV
4o+eX/jG2OOheio9pP9BlIiLUeTOKd4P5nzEZ3xCCe959QY7tepzlu60xw6c
VIvlGYw3aq/RqUcXGtTbxOf439NG+oHGe/cQ/gv2qTHzm3Mffz9OiKvFy2i3
eDn9yndcboTzb/rM/TrnOOdhiMdQfeOQaeYkdPouCTz3na86j1NLxTTetGhH
PdNpF33Ml+x9T6KevtkE+WIz6tXm8+9y3o0S57V2qsI+tRRvz8cJ37AOmciS
n27eJOd+Pfv16vPuPtpL16jvVy+gFfSt/XrkR0a/jXg4TcAIdOjdHL2FLjR7
AUbzZMhNxEA9B6Ej+n3xC9Xe0MrXxHeULha/lF9Eq8SV9IX4OVpQIX4gP5n/
tF5z7VJP8+hm+1eb0+4tP/GY/77aPWSIN6ptwmXe73JN9ActtO8NPW+iLvpN
UYvVZl3yHZtwEW14j0b5a7zXcRVXsJ0/R75HvRfd0R3xLHs+821m0r9mvzOr
VnxAPNNOzebvssctupPepof57up3B83YIb9Orij6P+D+I3cT5TbwjqJl9C7u
RN9XfcXY//8z/gEJ86L/
         "]],
        RowBox[{"-", "0.5`"}]],
       Annotation[#, -0.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{6245, 5966, 7994, 7996, 7995, 6343, 6284, 5249, 6596, 6595, 
         5757, 6243, 6242, 5179, 7285, 7284, 7755, 7758, 7757, 7756, 6604, 
         8116, 7410, 7050, 8206, 5668, 7049, 5667, 7761, 5183, 5131, 6487, 
         5765, 6626, 7414, 5256, 6288, 6291, 7867, 7868, 7866, 5814, 6346, 
         6345, 5295, 7473, 8188, 5766, 7827, 7415, 7416, 6293, 7418, 7417, 
         7828, 5767, 7830, 7829, 6677, 8122, 6678, 6347, 8207, 5817, 7877, 
         5818, 7874, 7876, 7875, 5263, 7843, 7129, 7130, 7842, 7841, 5787, 
         6538, 7127, 8168, 5191, 7128, 6195, 5971, 7999, 5972, 8000, 5822, 
         6348, 7478, 6887, 5521, 7625, 5520, 7780, 7781, 7779, 5682, 6888, 
         5522, 6648, 6918, 6919, 5539, 6652, 6651, 6649, 5523, 6889, 6067, 
         7140, 5799, 6668, 7439, 6306, 5702, 6342, 5800, 6389, 6390, 6340, 
         6339, 5151, 6215, 7168, 7169, 7167, 5887, 7170, 5886, 8199, 6368, 
         6710, 7171, 5888, 8135, 6721, 7520, 6216, 5576, 6414, 6123, 7710, 
         7711, 7518, 5361, 7519, 8093, 5390, 7544, 7545, 7297, 5146, 7950, 
         7193, 7123, 7124, 7122, 5779, 7125, 5700, 6296, 6643, 6641, 5778, 
         7121, 5387, 6855, 5505, 6615, 6863, 6864, 5512, 6611, 6610, 6853, 
         5503, 7611, 7610, 6672, 7470, 7469, 7643, 7642, 5495, 6845, 5496, 
         6846, 7411, 6256, 5669, 7974, 5928, 7287, 7288, 5133, 6192, 5126, 
         5180, 6524, 6523, 5661, 7039, 7041, 7040, 7147, 5250, 7858, 7859, 
         7857, 5808, 7860, 5660, 6246, 5926, 7107, 5759, 6598, 6599, 6600, 
         6280, 7405, 7404, 6597, 5758, 7106, 5925, 7202, 6244, 6245}],
        RowBox[{"-", "0.75`"}]],
       Annotation[#, -0.75, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{6852, 5502, 6851, 5501, 7764, 7765, 7763, 5671, 7865, 5813, 
         7762, 5670, 7822, 5760, 7819, 7821, 7820, 5251, 7606, 7607, 7605, 
         7609, 7608, 5309, 6014, 8157, 6015, 5927, 6385, 6061, 6062, 6010, 
         8155, 6011, 6009, 6013, 8156, 6012, 5336, 6042, 8162, 6043, 6040, 
         8044, 8045, 8042, 6041, 8043, 5132, 8049, 6046, 8048, 6047, 6388, 
         6387, 5762, 6286, 6285, 6606, 6605, 7863, 5811, 7465, 7466, 5290, 
         6344, 5289, 7464, 7463, 7998, 7997, 6095, 7972, 7973, 7969, 7971, 
         7970, 6255, 5291, 7468, 7467, 5812, 7864, 6607, 6608, 6289, 6290, 
         5763, 7110, 7112, 7111, 7869, 7615, 7616, 7614, 7618, 7617, 5355, 
         6036, 8161, 6037, 6033, 6035, 8160, 6034, 6124, 5356, 6417, 6038, 
         7230, 6039, 7227, 7229, 7228, 5329, 6201, 6202, 6053, 6200, 6199, 
         5265, 5789, 7846, 5790, 7847, 5788, 6337, 7430, 7844, 7845, 7620, 
         7619, 5517, 7621, 5518, 8205, 6872, 7479, 8102, 8103, 7567, 7568, 
         7569, 7566, 7133, 8190, 8192, 8191, 5791, 8193, 8194, 8189, 5776, 
         7835, 5777, 6305, 6304, 6338, 5792, 6351, 5834, 6400, 5960, 6109, 
         5271, 7157, 7059, 6873, 6874, 6640, 7426, 7622, 7624, 7623, 6680, 
         8176, 6679, 8177, 5298, 7917, 5299, 7475, 7474, 5821, 7878, 5701, 
         6297, 6294, 6295, 5769, 7116, 5768, 7117, 7292, 6530, 6529, 6794, 
         5444, 8101, 6627, 7419, 6852}],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{6862, 5511, 6860, 5510, 6861, 5253, 7641, 5533, 6913, 5534, 
         6914, 7213, 7214, 5981, 8149, 5982, 8001, 5930, 7975, 7977, 7976, 
         5138, 7884, 7885, 7883, 7887, 7886, 5831, 7891, 7892, 7888, 7890, 
         7889, 5292, 7894, 5832, 7893, 5833, 5984, 8150, 5983, 5310, 5878, 
         8133, 5879, 5546, 7655, 5545, 5258, 6205, 5257, 8075, 5957, 6399, 
         6398, 5352, 7696, 7697, 7693, 7695, 7694, 6198, 6207, 6208, 5679, 
         7774, 5678, 6258, 5341, 7657, 7658, 7656, 5547, 5266, 8076, 5959, 
         5775, 5867, 8131, 5866, 5313, 5871, 8132, 5872, 5819, 5820, 5297, 
         7702, 5562, 7701, 7704, 7703, 5358, 6377, 5357, 8089, 5908, 6213, 
         6212, 5145, 7662, 7663, 7661, 7665, 7664, 5340, 6412, 6413, 6119, 
         6118, 6206, 5296, 7700, 5560, 7699, 5561, 5907, 8140, 5906, 5324, 
         6359, 6360, 5864, 7910, 5863, 7911, 5264, 7913, 7914, 7912, 7916, 
         7915, 5865, 7926, 7927, 7923, 7925, 7924, 8018, 7921, 7922, 7920, 
         5870, 6362, 6361, 7500, 7499, 6862}],
        RowBox[{"-", "1.25`"}]],
       Annotation[#, -1.25, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{0, 3}, {0, 3}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 179},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->735132219]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->189741689],

Cell["Also include tensors of second derivatives:", "ExampleText",
 CellID->861033046],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}], ",", 
        RowBox[{"Sin", "[", 
         RowBox[{"x", " ", "y"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"x", " ", "y"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{"x", ",", "y"}], "}"}], "}"}]}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"x", " ", "y"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x", ",", "y"}], "}"}], ",", "2"}], "}"}]}], "]"}]}], 
       "}"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "3", ",", "1."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "3", ",", "1."}], "}"}]}], "]"}], ",", 
   "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->53401651],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`"}], "}"}], ",", "0.`", ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.`", ",", "1.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.`", ",", "0.`"}], "}"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1.`"}], "}"}], ",", "0.`", ",", 
     RowBox[{"{", 
      RowBox[{"1.`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.`", ",", "1.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.`", ",", "0.`"}], "}"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.`", ",", "2.`"}], "}"}], ",", "0.`", ",", 
     RowBox[{"{", 
      RowBox[{"2.`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.`", ",", "1.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.`", ",", "0.`"}], "}"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.`", ",", "3.`"}], "}"}], ",", "0.`", ",", 
     RowBox[{"{", 
      RowBox[{"3.`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.`", ",", "1.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.`", ",", "0.`"}], "}"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.`", ",", "0.`"}], "}"}], ",", "0.`", ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.`", ",", "1.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.`", ",", "0.`"}], "}"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.`", ",", "1.`"}], "}"}], ",", "0.8414709848078965`", ",", 
     RowBox[{"{", 
      RowBox[{"0.5403023058681398`", ",", "0.5403023058681398`"}], "}"}], ",",
      
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.8414709848078965`"}], ",", 
         RowBox[{"-", "0.30116867893975674`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.30116867893975674`"}], ",", 
         RowBox[{"-", "0.8414709848078965`"}]}], "}"}]}], "}"}]}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.`", ",", "2.`"}], "}"}], ",", "0.9092974268256817`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.8322936730942848`"}], ",", 
       RowBox[{"-", "0.4161468365471424`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3.637189707302727`"}], ",", 
         RowBox[{"-", "2.234741690198506`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2.234741690198506`"}], ",", 
         RowBox[{"-", "0.9092974268256817`"}]}], "}"}]}], "}"}]}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.`", ",", "3.`"}], "}"}], ",", "0.1411200080598672`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.9699774898013365`"}], ",", 
       RowBox[{"-", "0.9899924966004454`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.2700800725388048`"}], ",", 
         RowBox[{"-", "1.413352520780047`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.413352520780047`"}], ",", 
         RowBox[{"-", "0.1411200080598672`"}]}], "}"}]}], "}"}]}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2.`", ",", "0.`"}], "}"}], ",", "0.`", ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "2.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.`", ",", "1.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.`", ",", "0.`"}], "}"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2.`", ",", "1.`"}], "}"}], ",", "0.9092974268256817`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.4161468365471424`"}], ",", 
       RowBox[{"-", "0.8322936730942848`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.9092974268256817`"}], ",", 
         RowBox[{"-", "2.234741690198506`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2.234741690198506`"}], ",", 
         RowBox[{"-", "3.637189707302727`"}]}], "}"}]}], "}"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2.`", ",", "2.`"}], "}"}], ",", 
     RowBox[{"-", "0.7568024953079282`"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.3072872417272239`"}], ",", 
       RowBox[{"-", "1.3072872417272239`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3.027209981231713`", ",", "2.373566360368101`"}], "}"}], ",",
        
       RowBox[{"{", 
        RowBox[{"2.373566360368101`", ",", "3.027209981231713`"}], "}"}]}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2.`", ",", "3.`"}], "}"}], ",", 
     RowBox[{"-", "0.27941549819892586`"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.880510859951098`", ",", "1.920340573300732`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2.5147394837903327`", ",", "2.636663275843921`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"2.636663275843921`", ",", "1.1176619927957034`"}], "}"}]}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3.`", ",", "0.`"}], "}"}], ",", "0.`", ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "3.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.`", ",", "1.`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.`", ",", "0.`"}], "}"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3.`", ",", "1.`"}], "}"}], ",", "0.1411200080598672`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.9899924966004454`"}], ",", 
       RowBox[{"-", "2.9699774898013365`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.1411200080598672`"}], ",", 
         RowBox[{"-", "1.413352520780047`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.413352520780047`"}], ",", 
         RowBox[{"-", "1.2700800725388048`"}]}], "}"}]}], "}"}]}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3.`", ",", "2.`"}], "}"}], ",", 
     RowBox[{"-", "0.27941549819892586`"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.920340573300732`", ",", "2.880510859951098`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1.1176619927957034`", ",", "2.636663275843921`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"2.636663275843921`", ",", "2.5147394837903327`"}], "}"}]}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3.`", ",", "3.`"}], "}"}], ",", "0.4121184852417566`", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2.7333907856540307`"}], ",", 
       RowBox[{"-", "2.7333907856540307`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3.7090663671758093`"}], ",", 
         RowBox[{"-", "4.620196629060486`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "4.620196629060486`"}], ",", 
         RowBox[{"-", "3.7090663671758093`"}]}], "}"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{578, 305},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->456663856]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Interpolation", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->92305978],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.`", ",", "3.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.`", ",", "3.`"}], "}"}]}], "}"}], ",", "\<\"<>\"\>"}], 
   "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{322, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->287879084]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"%", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->558343926],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyMfQd0VcXzf15eCypFVEBARTpIF6IIshdUJCiIKKIGRGlSBKQoCCIBKYIC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   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmXuQ1WUZx3975OzZw3L2evb89ix79sAMu4iXEUdNYSFLLK9gUuyFq4ii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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmlslFUUhm9butKhpZ2Zr9MyHTAFQUElBsE2oCJiQCiC0oWlCBjAKBAI
UQRNJMSwyW5AMSAQ+IFLxI0d2kJREKNiAGOCmvhT3HHBBfV5ef1xknu+s597
7nu+HtPmjpuTHULYDnWCxsZDqM2E0KM0hDu7hDAwHcLTFSH0ygqhPRbCZWQT
kyEszQvhua4hHEJ+EGpGd4Iobh3JVkG7ke2C+ueGUJwfwgp8vYP9FewHFYbw
fnUI1yVC6MZ5c4nPH/BtS4m/rUJ/eBTCXmxr4ffjax/UQKxGaA3y1dAr5FeE
znFk7dBJijpBvsc413QPob4shN+IOQr/A/D/DbZXKbiKXAag04buTmIe5TyR
GnZgPwmdKZxLU8iJPRV+FvaT/q+/jm+fkttZqIb63iT+QuzXks9X5BND/wL6
n0HnkU9Dfy+2R9L23ZtvjyD7OeNeqWc7kO1Mu/eXka/H1wFs/iLeEOw3wDeQ
fxm53gH/Pbkt4Vs/4i0rCmEYsofUT2zHQcuRLYNiyH/Bx3lindP95roHFeSe
Q38OEXsB/Xgg8h3pblqp53l8fY3+jK72ORH5OHqyoSCEDuSN8MuRL2JeFkOn
Oc9CXp0TQgKbefDfJlzLFOQjyG8u/GD4/Z1DGIP9KPTX4O8w/oYj3079g8kt
u8Tnt6j/1zx/a8VfA/qbuZ8/8VeP/XG+ZROrIte9qMWmI+aeFCOLQcVdPIPS
bcZ+W7Ztmji38y1w3sq3BP72dAuhEvsW/J9S7ejEqKcMnVZkjVUhfEnut6Bz
jnwHpT1rirmI2i5i04TuC8QfCn8T+vvQPwA1cO6Cv2ep9SL8BPjmKs9iHflN
jhxTsW7NdW/OUH9BvnvUqllNexb/pSfL0J2ScO0LybcN3R7MRBb6AdqG7svQ
JXR7otMf/dakbVfgb2bCPVevl+JzHfWth35nliL0+6D/Ovo/oL8W/QnkdxL5
JebjBP4zxDqc9tvXmxmCfGOFZ3M++XTg+1S133YNPqYTrw/zNrXMM7gH3z2J
sanEOd5PvePx0Ybv9QWezQi+IMcz+mq534Tewix0VlfiG5ts+tcXf5s4f552
Lfqmt6o3prelN1uMfgzaRX1b6f/AlO9cd62a3kC/Pu5af8zzW14H7c7zm74v
8gxq9vTmhX1jI/deGNgdf5Pifmsf429y3N901gy/jf++2Jeg/4nwDP4w9Dey
s/DvJq0jmTBSs5iM/HY0k+Pxdwz7K6V+AyVxz5RmSTVVEyud8izrzpqQza70
LGlmH6t0D1S77vhQ0j1Xr5XDPvgx8Ovg/4DvR6wbMz4r57qMMV1Yrh0xH91A
vD3km+FbS8LfdE7m+m2NVn87+Y3dy/ke6J9CY/rD6NZgfwG+c76x/TVyyC81
xp9hdk5DPfO8E4Q1Tdg/VWrM+TBpjBW26o20IR8VeRauyofwCsoq8kypdyMj
56YefhF3DoqtHI8mvRO0C64Sc1e1MVn49SjfypH1EqblOaeNxP4o8lsaSc/j
yG/IeHZ6CbOQPQM/r9Q76cVy7zTtMu2EWmqvS3mWhTE5nA+kvdu2ZHv3CHOE
NdpBRfAtce+yg4XexTMS3iWa753ku7vauSrnDuTfpbwbcogxmnN9ylgrDNTd
9SbHJfm+Q+3Kn+LeBdqZj5PLE2nvMmFoS2SMF7YLw1dSy4qMsV//CI1x34F6
/xL+y+HLKr0rtaOvzxhjhC264w2cb64yNmbFPBsjIu9SzUi2sCzlXqjn71Ub
U4QlwoyDSb8hvR3tyNnkM6fCvdfO64OvJ+nP0ELX2J50TMUSRjZWe2dqV2qn
6q6EYcIu3dnKjDFVWKqZ06xOj/tfQzMrLDuRdm+FaZq1ByPvTs3cTHTPR8Z2
7cQFSd+h7k6Yon+P29L+t9I/yDBkd6fcO+0I7dojSc/itZ1L7s2RsVdvVLtm
ccLYfm3nVHgHXds9xBiEr9tT3tXCUO2iuxLevdpJ2u2aYc2udvx/xRtYKg==

         "],
         VertexColors->None]}]}, 
     {RGBColor[
      0.35049472919436736`, 0.15664889510188454`, 0.6096430588683418], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnHmc3eO9x3+z5cxizpk5M3PObOecoKo0ida+NCGILiJBS0hIIguCLCK1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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHl4lNUVxr+EDJNJzCSRzPdlkswMFFFAEBcEgsUFtIpsWmWVhCQsscpa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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.4493586431066061, 0.32854654171214853`, 0.7486082497372067], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmgeUldW1xz9kmLkzd+qdW6bcewcFRBEbRsPwntHgcyXRFaNBY7BgASwJ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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwlmGmUlNURhu/oTM9MzwZMLzM93V8PAqIIKCoKxBU1bhFxAWU1rOJRQEFE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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5482225570188448, 0.5004441883224126, 0.8875734406060717], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHuc1lMex0/U0zzPPE3DzHN/ZiZr95WKvYh1SU0vsUwbketK7KLUps1K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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3l01NUVxx8IEzKZQJTJzGS26LEVAloruFBZ5IhUsSICcqQgatkKFQSh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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6250403507785297, 0.6259281117064565, 0.910894356982742], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmGmQlcUVhltkmeWyJPde7ne/e2cGyISgCWtAMaIh+aGmglaFUotSkxjK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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3uQzmUUxx+stdco7+77e3+/d3dpXLohRZRImekyqZkMpindTI0mRFIS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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6977282038118096, 0.7427172659207036, 0.9125514161502537], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmnmUldWVxT+kyno1QQ3vUW+sEge0NQ0qRhMEUXAgmMG4tBUxvdQ4AFkg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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHmQ1NURx584K8POLgLzm52Z3+wuoGgMJihCMCJoPECDWhhLIsSyShEv
UrUiNwgogreoiFgSYFkOOeSQQ1gUlUMuoxgBg4kFciUiSCIoioBHPt9854+u
eT3dr1+/fn3+Wva+/6aaBiGEq04LIcHvuGwIL2VC+DEVwuXJEF6OQ3i6KoQW
jUM4m/+uAL8S2FoawjE2PJsO4YvKEO4rD+Fu9q/PhzC+eQhPNgmhOTxvw7sK
aAnvJexfXAhhCXAutFv5L8qFsJs9Q8AfAp/D2fvZ37dpCO3Bv4LWBPmPlIXw
mzM4D/zv7L8RfFdJCKORPS6CB9mNgcnQphR8dg/2D0O/55A3Bn1gC4/APw18
ZRPzP859u3Nm+0box313wv8pZwwFfw/+NPr9gT17kbceeids0RkYy/nDG4bw
EWdtB7oX9ZkG71SgkrN/gfwVrN8ELmbdgv+q2dsc6AT/c8g/DO0Q0BPaHfCs
5Oz70elK8B6ceQXnn4B/Fvb/BPkb4d0EXA4vaofB8A6C5xz0TbJnMrQpwFnQ
m/KwzVpwB+AQ9hwA/wXwLmbjzfDv4j5bsO2D8H/KXS7jDa9AXjv45zcL4ZWG
XkfYa1ND//db9tezP0b//ezPgd8I/JT0+/2S9d6i/p/y3wbwyeyfi72/AW8p
3YDl3O2f8FwP/VvkDUefH6CfCf5YRQhrwdeBf6y3QF4NvH3Z8/9HZP9E1n3x
2e+h9YO/Hv4l8G+GfwLnPd/EPrYe3jfY87uUbaa7jgBSKd95L2+3D+gAb/+E
fXU10DFln13DegX7O4FfqjfUfdC3hPtvTdq3asHPSdjHluA/7XivVdhyl+IB
/p7YeBP8C8BXwjuiGnlnhjCP93wS/n7o/BmyekF/l/NGoU8S/jHQZ4HPAKqQ
35rzB0BbkDf+E/gJ7t8C+rJS3/9lZE8C5nP+TvbPQPcy+N/CPo3ZsxTexUBz
1hexP0bXAvBrzhst/WL7rHy1A/QJrJ8DGsl3U/bt6cB5Kfv4fNbzgGrWbVLW
bS74r1LW8RTr1rI564H8txD6a+AXprxHexcCFxTx2bzl2dh0IW9zgHhfDf8a
4Fbu1y1h3V8H2qV8hwuxbVtgKvqfOB3/LDhHKTet1ptj/6Pcbwrxs6nEtpwN
nF/UbyD2+wj59yD/fOw3m/fZA/8z8F+GPUbCOxP5aex5LTp1R14G2Ji0z09k
70H23F5mH+oAbRnwJ+xdztv+G9ooxRS8NY0cC/IJ+YJiYi3rA5Fj4z7o88A/
iBybitHt4Mcix4Zi5K+yD2duZ90QfY5lHEOiK2cpttvm7E/a36mFdZIujYGx
6PIocIS7p4G5kXOwYjeTcCxeB36qeF4d9NPAB0MrBxrgW4f5rwb7LcJGvcFn
sOcZbLuDPbuw3aLIteIJ6P8Afzgu5mZsuAneR9lzC7xrS5wrnoL/+9OdM7Zy
t0P890rwm4yCd2S1Y6USG2+Adzcyn27sN9rHei9wQ/B/S9G1lv03J/0GygUT
0vZt5YTF0DenTe8FvYK9mSrrNgUYq/yTdS1QTVgZOSYVi4rxCyods4rVWvS5
EH3f57/O7N0H/zDepyEyViUdc5/BuyBteQO5zyl4TwIfIq8X/z0F7XPk34Z9
+iLjKOst+HA3ZN/Nf1+pfoB3BO8D3pbzHkenkdx1P/JbQXshdmwuAo6wnpw2
713A18ofacu6B5iOPeqaO3eqBirXlqHvmqRz7lnIf6/CvtUO2Ji2jtJNMbic
s1vCPwr9z8Ie0/KOAfl+Z6AVsudUOHZVM9QLPJN27VFPUA/v2qL9MvC/jrxq
5I0scb5VLv8W+7+WdE5fBr0K+ogS56T2le451GvMxCZLoS/njg+WOB8M4rxz
s67NipGD0HZErq+r4Eny1g2BI6zv4owE63r8azT5+Enu2LTSPYd6jTGq0ch6
NuuzpeMbnD0S6Kl8wP7x0J7PWnfZZAn+PQx5N0KrU0yg+wvc6SjyR6BPa/Dz
c6bJZ1fCu4c3vLfUOsj3TsbOlfKZMay7Vviu6nEmoNuLwNfQ/oWMNujbqcK+
qBy4Je8eSb1IH2TOQtdhWddaxVRH5F0au7YqB8xJ24fkO8pRqrVDss73qrkP
s34o69qhHLCjyjlRuVA+OAbaq2n3SscT7l1qss7FimfF2jjggXLH3E5ou4AV
iWK9U07Se5bbZnugrUu796lNOpanol+rMu//kbv9BNQlLeMM7v4D9Kbqd3iz
/2CPodBXlPjMtei6jf+uL3cNfwnaNuC+UvvscegHeLPbypzTPsRXLuF9lrO/
O/InVDumFEu38D5PgH8Zu1e7FnwLvNfk7E/9ed+LsE9b4M1y9wDbuUtt2m+x
APwjznq62rG/hT0LI+dM5UrtUa/dLOdeUz33o+o1q9yLbSt175Ct8l3VQ8i3
hnO/g2X2se15+7R8WXfcELsHVtukHugBbDURHX5gfUr5IGOfli8rh+9E1lb1
1CX28RrkrQJuQVa+1LXl7rxjVzVGvbpqpmqlevZB0Abn3RvKhm/lnWOVWyWj
tto5SbmoN/ru5uxFQMekZ4AbkH8841hRTdNsMSzvszVjPAFvm5zrY1zq3j1d
tJfytXKl3khvo5w5Hbyu4LeUjDWsVxc8e6gHf5X1vIJnBfVAr7PenHFtOoTM
bqrHOb+tauKZ6NMYGF3mmUS1f2HWuUQ9wJbINVy1V/Y5gLxvIu+9Qz0j+K6M
41Mx/DH455HXmmkaIPtt2Vi1BPxv0Hdm3Mt9Bc+74Fsz9p3DSdee/QX7r2rQ
QOzzauxe7BrwweD1sXu534MPAl8Su/e7Fnwr+/vzXxfWVwMDWM+M3Wt2LTet
NvYsI55ydJsduXdQT6dapRhRbKhmyTbr4O+cso1SOddA1T7VmGbQj6WdWzVD
zQCfhby3k8UeC/4GwErwE0nH5geVnk10R/Vyu+G/PeGeTrPRPvB7E56RVsM/
reC3Uw7YiO9syjv33wTPDNZfFPwWilnF+pKcewH5697YPad6zZ7c4fScezj1
btLpfWgf5N1LqqYcgH9D3rJVw2uR/ee8ZSln/azaSIxOKvPMsq3gN9bbamac
pV4n69lOd9Ks1rmFezXNbHrb72LnJt1/Z8ExpNj5Y5l9Sz3i8KJ/fhm5R1Nv
Jrpqy+6Ca4VqjHLVfyPPOrr/Ps4+L+dZTTlVvqieVL2ofPI97r68YF9bB3/7
jGcOzRqaOQfDOyDr3vlc8KnqhavdC46F/xPuuqPS6y5J5/o9sW2rnK/cfCc2
Spc6R/dXrs95tlWOegPeIezpVu4Z+h3woeDXlXtGa4u+V8XOjfomcR3rbrFr
kXr0xyL3TOqVNPNVgR9B3wVJz6BzWc8D9pfYh8YpPtnfA96KMs9WR4v8mrEq
2X+8eH/h21B0fcGxqZ5Ovfv4gntV5ai9ivWC30JnDGS9LO3Z7WfgavCrCp7V
9Y2hPvLMqVlTMaRcvDbytxDlZOkuHXS2dBrO3mFAebANh7IeUnAvpJ5Js2qf
on01s+rbjmqAcr++8fRjvTTtbz0nwQeDDyp4FlNPNZL1irTfTjPpCPAHC+79
JPMv6Dcp9qyrbw6LYt9Rd9OMtyB2zlGu0YzXn1ioy7tX1Eys2L+44FlNOWAq
+Em9R8I9yJ3wX42PLIe3HujKukulv53ov/mRv0FofqlIONbuz7s2KObkO2/F
/vYkHxqh7x2VnnVUM+VLzXOe5eVTU5D3YuzeR+fPiTwTqLaoxpTkPFOrH1L/
NJN1Mue1/psUOSYUC3qfV2LnZOVizZzfcbfJkb/V6IyLcvY5+dpu+VTsnK1c
rRn32cjfuDQ/qcd5J2ebyBaqEXNiv6HeTjP3MeWStL+VqIc+I+ecqlyqmSTB
enrkWU421recmmJ91Tedutg1QLlfM/63yteVjn3NbK2q3NOol9E3hv8Bv/Hy
aQ==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.769622509427008, 0.8493294820985413, 0.9108988100420201], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmgeYlcXVx19Wyu7de3eXvb0uRSzxiYqCmkDsDUHRaOzGKBr9NJ+CGhVU
JEhRo6ACJiJgj0qwsSBiwxI1MfrFiDVqkIUUUjBR8qlYkv+P/8mTPM++O3Pn
nTlzZuaU/znzDjz13G+e05QkyYatkkR/yV3VJLlDz1fSSXJ5W5JMTiXJZr3o
pba15SS5oneSdKr+u2ySfKr+76rtPT31vknypvq+raefCB5ZSZKj9PTo9yEq
R1f8rrsjSZbquVL1JaLxWz2/Ep0JrUkyXm0Xi/6vM0kyV/U5ej5uTpLvqdzY
J0mGqX6O6k+r//+m3P6o6qdq7KmqT1J9qXh5KpckQ0XnMtEZp/arEpenRj0v
Wm8FnzPhRWvdXzQe07gXxed+qvdS2zCVJfW/QOu9X+1F1Z9SuUL9Bov+Rr3c
S/WBTS6Pq7j+rvbiDynXD+qXJCnR+Yvm3CFtXuETXk6O+hsau6Hi34ekPD/z
Pq32X6t9lH7fofHHqRyteZe3eb/Yq7fUZ6P6jNPvsSn33Tno08Z6e/R+XcXj
nxdvr+hdh8bup7ahGp+Iz2H9k+QRtS/S+ye03if1fEP8vpzXvqg+QvU1Kt/X
c1zatGmD/o/U9mM9A/X7HO3/Co25R/yenLIcscZp7ZKddo8dpvYTVY4XDy/V
tFd578+fdb57qv0l1VeJ3lNV/75X53ioyoWiM6bdfNGnqaExOdPZ0Oz5l6n9
j6K3vmqZ+Vz9P9NzbNq87BD83KrDvFN9jtTYu1Xeo2dHvXtEz2Lx9zuNfUWy
MbXdv69rDXmULvxNY+uad3WvJFmpeVfRX/VzRWuZ6qnelq83Q8aebnW9U+2P
6uwmtVovPhadWtDhN+1NsQ9DxcdTqi8RX/dV/Zs17qRyVR/r5eWt1s392807
7UOQi1braVZneUrKdO4VjcVVj2/Snr+q+sOad2Pasvqo+neLt7TGfiCa39Nc
52rcWu3Vtno3UfWC6r9Q+ye9va61kpkWjZ+ud/O05xOq7rda9E+XHPxA9cNa
JGcaM1X1gW1eJ2tMibdefaz7R0gOsyX/Xqn9+Jl+b9PbcrRHybJ0fx+f1dmJ
50eH4WF2PUn6a95W/X5V8z6tsVNUHy3eDtHzitZzo/p8t+Ixh4qffZvN25io
039TZ5J8pOcE7eWDKh/Qs0zn/6J4Hqw+yzXnB1pre6v36iKN3VHtH2vsRNmw
5yreh+3UdhVr6217eU3RZzEpzoW1Y+eGN1t/l7V530fJTmyv9f5QdP5P7ac1
WyeQ7cVtlivk63jx8P/Nls+LRfu1svm4Xu2vxroGh6ygC7umLU/IwMM52y9s
14kZ7/HW2s9ZWsve6vM18X2LeNhWe34le6i2eSqHq19Xu0tsy5VV21ls7Gjx
tbPKQWp/Tfu9ur9pj9LY2X38bm7QYvztqh+h+v6q762xZ6S9h+NF8+6KZewm
lfP1bK39ulrlvJz3k31vD5lnLyeFnJ+ns5rQaR6xjexpRu8ma+zlFdfna44R
6nuY6D+oNe6kNd4SvGBb4edyTT5Je7pM+3BFi/1Nk+o/EG8Pab3bqc8Slefr
98HYBPXZR31G9vV5Yluxq681Ww/QmwObvZfUh2rsjJz160bxcG3R/XYUnZ+H
Xr3TbF7hZ5bWcZP28siUz2Gk2vYS/2s1bnv4D97xCSeqfaxozixaj+APftnP
6ZLjaXpGqW1Is/eRPcSmHhZ2da3ay/zWu9vEY++SbdvuWuudOa/rlxr/uNo+
ld14I+332L0bxP/qZstVPu01wP8han9FdR1BspXaf8UciX1+a8m631sM5qS3
09V3rtaaSZvP9yVHN3V4Hezr1S3hp6Cd8rkcLxr3ZY0HnhGPZ8sfvIU9RgfV
v9rXNgM/hN0YFv4V3zq6xfqi5SUz+vjMOKMrxcMpqt+d2K4vjTV+UbLPgN5Y
8VvSfCvUPkr1D4vujy3HN2DPf6tyjZ6FGr+z6Jyk8seJ/R66jV7/RfyuDxy1
teifVzUff1L9UdHaXn2GqT685PMB+6xo9nrf1LhNot+dWM9Y91DVu9V2UsP2
u7WvS2x4M7Kacn/sBbqH3n09ZX8M/6NF8xH1W6Bxq3NeM+tlzifUfr/aW3SA
4+vuxz51q7xB7f/QvOMLHvuo9uSsgttZ933qM131PXPGTOCitMoZ6vN4X/sH
ZAj5aWjstgXr1I1F7wX7gByhb7SPFA8D1WcP1f8e+8veIl/YMuxYq973qVlu
Fqj9KPVpQx76Wp+OBV9pvSvKfve0ymfK1qUeyd7NHbZt8zLGhsgNmGJh2biC
MxyRso1mzPEp6+AxgW84X/Z779jzOa3mA/xwteZ9PmuZnC/6Z+o5GrwrWoen
rOPYSvAc9na55ny4bP3n/djos1Jtew7w2E6t69sp2/xrRPv6Lv/+TsryD+Z5
T/bh11Xr/Hba1x7t74m9vC8Lg7fTGrbv2PaHReeyqm17T/j6wehLh20Kurqv
1pVSOVPzHh36i34NQV8031V9jAUW5O2bvi96F6J06neRyov1NKk+R3PN6TJe
uURtl+rpm/Y7bAd2A19NG/6ac2mK9j1k93Np7z82JAkeKHtF/cKM94J96M4a
04PnwWVPtRqbHay2WXVjhv1U31/Pi+BclSP1PKv617H9edtqbC/zYuso81HH
N70Yvp5YBnrsMxjkxLxxCPYeep8EZry71bjxQL3/WtU83dgwJgAPgD2RIc4I
m0EMht1YmrXvxM7v3mysyVrAYvgY/MtC1RcVbdtPq9luYkNa9P6Ykm0DmOKs
FuMKbB74BvuAjQQzcXbPZWynh/dy//Et1oVNov953jYZ/4DvpD60ZF+Ln929
r7EgOHAMOtji9qtz9mf4suFZ2zn43F31P0vmjsVuqc9K0RrS5HUsLbkP9n2i
3n8mOrtl3bdb9Wf0/tmS1zNG5aa8+4xW/R9Rx1+B/5ClhX29B+gpOBQ/2isw
6q4troN78dOcF3gw32JMmKd/KWJetc1ssT49oaetxT4OHMn6kIGX1PeQkuPW
bbSfG5sdQ4Ej8EmoBlgM34nf3Ki1H1T6TxxMydjv6BxHleybdsjYDmID16j/
3+um26P6p3W/Y5/ANay9M2O8SWz6Udqx0RH9PAaesNU7aZ+XY4szbts22teo
7/tpYwD6E2PD/zNitq3m850mYTyv5n6bkNWaZYb37dHnrA7TZez4jG0VNmyV
dPlJPcerPqfTcU6H6gWt4/Gy6x/qfDZWjR2RtzXBDxjz5IyxEnbx0bJt40Vp
x0fEQ9jbwXpOT/wO21tS+Y7Wu3PBsonvGl2z/1qbNn3kebLav1uzHyT/MCnt
MzlUbYfpeTIwEdiIPsTz2B1szjq1rU/b3+2tvZpZsIwszji+BYNdJBrXFYx3
fl+xnzg7/NrMsHVL1efCLq/hqrTb8XfP6uWGmuOkP7Z7PvbktoxtKmu/OO3Y
Oaf6XRnHKtTB6GAI8AMYGT+Ef/mJ9nldl3/j65AX/B35G+wAOp3ojP7Z37YB
OX05ZBU8MjdotqcdD8yKWGJe0N+Ct/o4BgGrzowY822t462a33Ee2An8NbmQ
d2vOcXyg9favOY+0k9Z7bZtxM/EH8+CnSm32/+Sm0gXnqqhPSNlWVkOeHw+c
j76i8+jsYvX9R9VY85W0bSL2sEl0uhvGVhe32z4wBr3Hh6L7A9QnW/P+PFFy
vE2sTf6DfAK6Bj6dGBh1ZmBjzvGatLHOFvyTci4JzLJE447JuO8NKdsa9qa3
9GK1eC2qXtc8XXpmq88AlYNqjgvxw1Or9sW7pK0PyMNWev9Ew3IMxr+9Zpz/
DelOdoDtL1iJGIT9/0w6skPdcWhd/Byu9p2wh1rv0AHm7w3ReFPPEaqvaJg/
eBtXdnyOvT1UY+/MOIeDHM8P/HOA2m/NOI8BhgKLg0tpQ47h+Z2wWexhVrRz
dfNHnof29/uaNvKNbJ8Z9E8Pu3p16MvYjPkH24Dfj655rpMyjl+RyVfTPnvO
/dsZv6N9fof7IGPYVuwvtmIy+UzROSFjeWEs9hnZpw0dA0uvTtv/ondjg4cv
dD5fgo3SjsuwCfi7wZL5CQX7qM16/5meC9KOdxk7NOJueAOzIcO8RybzddtN
bOYi8XWLnv7qd1+79wH/coDaDkQ+05Y1chzEh9gG2q4KOfxbvMdPIV/I55H9
bL+wXZz9lWGj9he9cQWP/bbKffW7Gx1Ku8RPETs8lvae47fxAdh/fDY5OHAI
scPS6L9rxfE5Pmw7lVXRvJZ8X9DFN52ryXcrWF842yNib9Gpa2O96NY1UQcf
gheJNzNRByu+r5fTssaT7NMPQ2b2kd35Zsbx4hS976nZ3wxK+9zgH0wKNiVe
IH+ITyBOfDVyNPh3sPDgmjEV+szesW/biPdyzfORAz46+JmVNs/sOfnqedH/
t/qX0fme1c95jDMyxqQDwq8h8yvF5215xxHkALAB4N6C5tl5gM+MnBcyh7yB
6bDf4DriuU+KjunInRJHEA8uE71JDedywF3gtp5mx0CjI0d3ZOAgbPcfwo4h
V9uK3qHieXI/x0P0AdOmI5+N/cmLfkfV+OoSncXLNefQc/JFu4rnDe2OR/G1
+Nlr1f/1uvOV88TXj/Sc2G7bhSwQb4L7wILgn4ma++x+jh/LbfYTL0ReHN9L
ngF5/yBk/ljxcF3d6yCXvJlcGDnffqbVV8/sgv034+fUjVnZT/wkvnGPsOPv
Bj+7hA0mLzcoZIfYbW7OOS/yXeAgdJf8J/L4bMgkcXN7yViC2IscE76TfN6M
8KfcvTRVnW/9sNMxBDRXhd/rjPhyeOSUzpYsLaoaCxHTQQ+fvErtays+25tC
fmhHv8aG/b9C46ZXrUPYxun/xcu2kWNcHXlWYnxsw5Ml2wdyA+BI9JdcAvYU
W/qc5v1DxTKHjyWWAofPDJrgBObHhmIDwQH4W7DlIp317C7zgc7OCH6eJEdd
dowA1vu0bB/aq8PnDzbYR3PuUbUsDIn8YkXPMy3Ga+z5UJ3Lzu2Ox7kbwL9h
r8iJYKcXhJ/CR6H792resxrGQ4wbEXtOjmHWf+VIh8dasGH/LFtebo9cIHnL
NeTVG7b15JbuKhlzPJ9zjgB+iEtuiXz15MiDgvX7Ia8t5gscRxt5yIuKziPv
GFgQu4+cvN5i+Ua2Z0ruzig5d3inyu8VrbPY3ZPi7LiL4D15xfUxD2vHJ1PH
L4MTJ4bekRdhTmKuw6QvH5ZsE8ADlNiuC7Q/lTbrKOMuCb2lDm+7iX5VvMwr
uv2SeEf7QO3VpVnbW2w2eTXk4M/av782HGcQU76Tt56OCUzCHgxJOX8ODtkh
5fw5WIV7qo8rxsDcgz3S8H0W5wP25Iy+W3bci90jpt+p2XH9q2q/sWw5wd+h
78jhfdLNDf29Zmwn+B37+VjZd2noPrh+RMnv0uRO9fyxv+99bg1chO0/rvU/
OQlKbMX/1By3YCcv1z5NKTqHupx8S9G5t8cjXgX3IrvIMOeyUmMfqxnfrBef
6zp9FzEOOawZx5xbN0ZZGLEl/pn4FJuDfoN78fOnhF4frHGH1NyGTT8o5DCj
fX4tZO4y0Xujbp8wLu4M0aWpdcdO8HomOcaaY60xWecuezodhx0esdjJKk+p
GYdxt4l+cr8J3yvCd4Bl9ok8MLZjv8hjo5fgNnTzsqz9KD50mcrXas5FERsM
i3wsdunAyCFPqzp3Sd5yhfr/puZ32F3iDmzvvWq/uOZ7gxb1PavLeArfQgmm
wi7h27/aZByyd+TSZ6n/7KJ/4zOhgd9cLJpXFD3HdSqvL3pt/bm3r9uG7dnq
vCa4CIwAVsDmc4cyoN32nHJg1G+XzJ/a8G/y+sRa/75LwZYh80vU5zz12SVs
Iu3Yt1+K2cdzzp9iM3eJ/oPFz4sF25j3tAd35I2NiSWfz9jmnKr2ywrG4OOL
tkHYF2KvrQqOv3aQTnylZL4uFM3vl70e5h8ac2EDftPw+aI3+FR0inzq+Q3z
C5bpztvWfrVkfEN9bqdzEIx5Sf1/WfZ3BOdzX1FwboA+2BJycQM1dnnOWO9Z
rf2RnPd7ss52d63hHJ3ncrUvzfkuoq7+3TnHfg3mzRmfkp+ZHHeC+4ExC8a5
G8XnCNWf5g5c5zlSzwsZ35ETU2GjiO+xZdixzrLPnnPHTmAvsGncAR8Q9V30
vl/RNjslHlpKxgjMsSryMOROGJuN2GpMzJXVuq4sON9QE5/bF4xVi6pvXXB+
YrD6/ET1rTqsx1dE/PuC5n2+7JzsXdzFF+1L0GP0GT1FX0dHnftY7mW55/1d
1Xf8YNRe5Jlz1mfyWOOC/hLReyvrPP13tG8L845Z2zU2l/d9PvfDD8Y97wzx
Mjdre3+Z6jdk7QceUv8Hq75HXaDy5qrvV5e02RYSC+Njl8V5QQte8b8LROfm
su9YFqk8sOS86S8kAz+vGGf18F1N1fe6xFK3tDn2wyfgG9j/n5adj8De/FXj
3sz5O5I31PZ62bmokmj/NOc85RZb2W7/+5724d2isfaX6vtF2d/WcA58kwF2
AcNMjfrU+E6D+r0ad0/Rtvs9+Mz7fmOi9vOhvPPuU3TWCwv+jmAtOb+aY+WJ
nGnW/m+EeP56xfeHyAS5DOKezdyP5RwrN4v/O3LOxZA76SoYz3EvD5YHvx4a
sQo+5W3xMKTgWBa/NCbs/1ytb07Z+HywaA4qGXtCg7H4+u64I8Z2nlGzP8Mn
XKCyNe8YmvuTn5WdlwRLcscPnpxctW6j1+QAwLtgy1vUZ2rF99P4DrAd+QH2
mjsAcr8v6P3zFWNS7jp+XnZuDryG3CAzxDbgHjBPRWssN/wNAnm4u/POxdGn
HDHLNNmA6fX/4CRK4peOmnNk4GLuH+CBOwRknrngZ3/t/wzRvajD33LMD54P
DqwPzv+i3e/xSd/S2kdV/G1LKeZjLu6CuBPC3xFLE2cSY1bhq27bQ86Qb7/I
AxMTLY36fNG8qeoYCF5p59zxA/gDYidwI3X8Ar6LvcUvd4l2o26bBO6jH33+
PQacuRosX7XsPMB3XFXHXsSgh0UcOi3us+Cf+GZa1ImNibeJtYltpscdOrmx
zsiPEUPna+5LbLpP0eczU/PMqDr3SbwOHfwg9G+K/SFXSe6GvM2yhu9uua/d
TnowWbx1ttkOgPXAw8SjKzssY7fq3G7r8m/WsCH6gA+pYze4r+Pejj3buuac
IDkIdJzcBPbhbHLJddse9pX+yMBSdLzhHCfxxmvxXcdtonFrzT5qTM14Dix3
TM32DltHv9VBZ1bkZFnj/JAz9OhbNd8/ce/S0WU8B5a7o2b8l47vy7gn4I5g
G+3N99XvNP2eWPP9LrlddABZJHYD87GuxSG/fEPAPo9s+DshfAdyBQ3kBNuP
PtBOjMn3ScSZ5GXZe7DsN6r+fog7O+YrhcyTN+1dc+70TdXvKPl+CxyXKlpf
uIfZq+T4lnlGx1zEgvfkHfNdovrPss7fkMOYknMe452G87mzw9fwfd6iONO1
sbcXqM+EhrHOK+HP0GvufPYpOZYe1/C3EeTje6meNEzv/brz+9iTJu1H74iB
wSjg/S3fKrTb/p4QNpYYAB6wncvDfvLNDblI4lbu7HaLXBBzrI944YvImRAD
rpeMrCv7XgeceV58t0M/5uDbCb7r4Ts5Yu99K47Jicc3x7d80OFbLWIMfMHh
Jfs/fB80eoIO/b8IPL1X2fgGbLNA9G6uOL4nJv4yaLIO+AH3gn3mBvb7SHu1
qW7fTEzDvMTIYEP6gP3QUfAl2HJ48AqGH8Q3oRXf8Q5R2cg5FkGHp7Q5XiZG
/jy+UWSvP4p1TcHW1t1vy/d+bc4H7aZ1jBzgfeY70OUR5zNuU+R6oPVZ5Kmw
B+mIGbtLHs/YB0T/vrJt2lF56wnyeU/F3znhB7YEHDnngD+Mb+Sg/2XsLfvG
PWR7l3Pd+OF1ISfrxfu6ur9jYh/ZH+wSfH0eY8Gv6CS+gPfp6PNU2bkn8k6X
VpwHJF5cG/fExM6/0ft3s77PgT7nsWV/spZF4mziJ+Io7AP3b2Bh4t27ZT+2
7rLcE3MSe5I34J6LHDlx6fllf3/DnOgIdIjF/v09HDLfLF3ftWw5ugu8X3Z8
R9+m0ClyTudF3gnZBNMSZ/++5O+f8Ifgb3I05Eqwfd2hX/D1XvBGvJSJvCPf
ahG3cQ++I9/rZX1HAwZlLDH13KK/lcEPIn/oGHrBHc4/4x7nF5p/UNnz9JK9
SWq+J+yJfYb+zJy/XYPmVrGuLfsQ+s661opeT933cOTlJoQecbbPxfluFo3N
Wd9fva36O1l/Cwkvf8qZH2JLaBBf/iXnb3z5lmaN+jyXczt7xH4jP9wT8s0i
d4XoyJzQR2wLZ0TMjh3CHiGT+Ozdw0b9CwPKPnU=
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXeYldURxg+wK1suLOze3Vu+b++yLGBLJCo8EIEkCFERxYKxBUURwxMx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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8349011348530656, 0.8710981642675601, 0.8816540443494525], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFnHe4VcXVxjfeXs8tp9x7z7nngooUQVGjRlEUCyoWrFhiTRREsCsWwEbE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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmnmAz1X3xz8yM2bmO5vxne93vttnBglFidJTpEi2yFLRjkq2CqkUilQj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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.9001797602791232, 0.892866846436579, 0.8524092786568848], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnXecVdW1x8+9Z4owzMydcu/0uUisoIIoiBWQakHpRRFBFBUVC2KLgpWI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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXmYlNWxxr/ZN6Z7hullpnu6ezAKUdlXwcgOCojOAIIIYbsXYSCABAHN
FQkIRhZBUQFFc/PcGLerLBqFGERFQQSFCIiAuSTKpkhEEQx6WfJ7nzd/1NPn
fFWnqk6dc2rrRmOmDJicHQTBR1lBkMvv7EgQjM4EQb+yIAiXBsHzqSB4Abgl
Lwg6CsD/rjII+hSxJj8I/gfap4EFLB7N+l2Mj8eCIA3t5eVB0Jb5VubV8EsA
UxNB8Anf+oC7FZq98SDYA3Rh3BtYUR0ExcC9DYKgEPknGH8FTGa8Bvx9yP8e
ftcVBEEp375g7SN8u5QTBPfzrQ7c2XQQ5KPfNPS7K2Ke4rW8MAhqmD+F/r3B
z2O+Elxf9GmHbkXQvA2/nyaD4JWSILgb/KPwOhgNgtvCQTAUGA7t2QrkY69e
rLkA/XngT+z9SWzQhLVfg78M/Dp4fMW4ABnj0S/Gt4bwisJzErzXQj+KtdvB
n0affeh/Bfo9wjwbXd4pDoJyaEtZ804oCDYDLRmf5zz+AO+9rK9gXglNf/it
Y74K3H/yLUDX9tCvh1cbZCyB9xpkdMQ+X0CfzfhW7LMb/Z4C7kPeiELrmg9k
5VjnOeA+h/5V+K3gTE6zv9XwGwftBOb/rOI8gKXo+hDQEPn7wV+FCivh2Rhe
VwAtuGSLwQ+F1wL2eBbeEXjezfhDbNqI+1AM/QD0O6X7xDwbe/0JXhuAhext
A9Cg2jaVLWcjv5a97oO+N/R53I9v0eU0UMT4BehfY+16YGOu72ge8nOAqYzX
hYyr5z5UFZkmjj6t+LYYe72i82LcHn5fgB/Bt2fY30Rk5qJ7L9aXg28L/jNw
w4GD6D8FHv3Y3wns+xXzB4GtrG8F/mpom1aZ1/PYqAH8XobHBOy5lP0/qbvD
t+cYPw4+B3tfgN+9nPcsYDu4OVHbbhLyd7D3SeDbIS+FDY7EbFPZ8ipk/FPv
Aehd5jcznb2vZn171rcDZjO+lW+PFPqNv834E+ibQb9Udwj525A5AVmbkN8Z
eR+B74RuTaApY32TGtY25H5hv8bsrR75LdBnP3vuAX03IKK9Qx+C/yXwb4kf
cBHeZ/EJE+D9PPNaeF+q9Nv9JfBbxo2gn49+1xf57WaYv17sN3yS+/AU9hsI
fgp7DiN/EzwqkPUm+CehX4qOU9lbryL7rk6sf67APuwy1nZjzXeMZ/Dtv8E3
l37IvoFvq5g3Y/57cD2ZL+J8TrGHzWH7pHXgqqEZDP8k+/+ReWPsUYs95jO/
Evu1ZH/Hcu1T7od2PtCSu9UWGe2QPZc1BSW+Y4MYD4J/edhnkoFXI+A6+H0A
TQh93wJmgjsG/Sl4tWG/tfAaAHzJeBHwLriW6PxopX2efF3XIr/1PHSaV+I3
L1vKxrKtbJrD/ARn8ihncSc6noTXKPBl4FvD77ecZSu+PcB+1mPjE+jaD/qh
yH4DnRczfhBYAe8Eb34p53M1sIq3ehE4Cu6YfBT43vBoEbHNZevN8JjPWS0D
pmHPHdyhlhGfoc5uC/jWyH8H+ZXIjgFd4HUIfBd03QbPfujzCt+6sr4IfVaD
6wr9OuZD4PE8629jvhzZW1l/D7Lq4367tXl++zdwJj8U2QfMA/831ozgbV3L
ne8K76asXwPvHcg7xfwgOq7CXk+E7AuvFv8G9ony5d9g7/oG9umPMf8c/BXw
jnMmv2H9YXTMxlZJ1l8p348O0VLzmM15jQZfjj43FtiXLInZFvIpCeStZL6H
+d58n/3imG2pO9Ae/VPIb4qsT9nzH5H3asqxVjZaAe0/Yj7b7dBXwy9Z5bP7
BB73sf4Q+x/O/ttwHnnols19XM+8C/wi0FYAD+b4jWzQXcEe36D/SPhdAe4v
8C8D1xD4gfE88Pugb8z8PPOb4d+Rs+heYN65yBidZRljwO3jTLsVOCc5Df3v
mI/F/tfybRj4MzHH4p7AUclnfhm6J8B/hv26Z+x77uE8Rlb5DentlDGvZD4f
/Azw7xfZ1zwOjx5F9jnl4EJV9iXHw45tB+KOLYpxz6LLc2nnDj9izwy2Tied
CxwCDsTso+Wb+4E/Cv8LKfs6xfBrwHUA6rB3Gh0OMj4A9If+pnLnTlVV1k05
VIrzeAb8m2V+g7MizrmUa+kMNqLbG8AD+b7jq8G1x6avNXQ8fwnZLwKd0KUO
qEHXDlHrKp/SmXFjvq1Ft5dLHNuGKJ4WO8a9x9p96BRjXM8e3kXWqCrb8nvl
L6z9GTyO5DpH2BJzDqjcL1nmtxuDfkuR33CDqHMc5TZXYs/JrH9VZw7uXXhe
A/2zzN8ucw6gs+qb9tvWmW2O2SfIF8SVs4IrSzu2DIbfooxzQOV+s8ps20bg
94Rs4xsYN8z4bF/GZmsYj404/1lY4NzyDDRbws4x30Ne+4zPqqbMsfIDbDI5
5Jh5G+Nc8Huhvxd+6xivzZjXIt33CvtQ+U7d8VL2GwIexNaZbMeu5uDLyxzD
5kJfivyN8O8TONZvlz3LHfMXsXYh0A1e5fiLvsjvk3Jutwob3wH9pzG/BeUk
O4lFP6lx7nw9MntBexEZ41m/l287kXWj7gyym8HjA+h3JUzbDPvP4bz7686C
L1c+Bf9vKy3rEOsnossE4DS48dyvQvxZEbCm2Db9GfRDFA+ZJ7PtC0bpTMvs
E5aw9hD4IciLs58l3I/vYn7rZ/n2ObqOQV5D5G0q9V1popiV5TuzjP08DFwO
72fB92B8Evrl0O9i3ibpHF+5/Ub47Ug5p1IupTM8DK8fmT/DuJ49XESXC0Ah
/KZDfwhcecq57YKQc6Mp4P+/2DnSFubDkXEY2ttDzt1i2HRbyDncpKjvnO6a
3uAX0B9PORZqz4WsLY86lxoO/jVs9yv2OLHMOXxr8D3Bf5vrnHE7/L9MO/Y+
gowP4VWKvTL5fqMNoC9J+u7oju0QPTTLQo7xuxn/im8Lsf105kv1/uD/B/kH
bDYH2V2x19MFfrMtmbcA5mb7js5i/UjkVyP/DPyzlCuBfx3cZM5kDLrkZ1x7
yCcdh7ZdzLnKgBLXfgP4Fg67Brw745pEtYj2rFphoN502DXDgYhjrmLtHr69
gK6/AN+UcXf2eJTxkbTf/oawY2PHjN+qYmQ141UxxzbF1LaMD6dN+zrwZ2Tf
zvxy5ceBa5/xQOOwa6DW0PdM+a28xrw58+7MdzJfy/wzaFvwrW++71xOxjpL
V/kExbJUzLmfYloJd2cO37qAq+YOJaB/IuZY/jn2aQWutc63xDljFPz9KecK
X7PmpahzeuXytYFzq7uYdwg7x1JudmPKb1M52inO97uka7cfsPeBqGtc1bZ6
M2Fkv8V8CfOHgPfQfQrz5ow7c+eGgs9GhxfZ2yz4LWT98LRjxTj49Qc/GHlf
ltpnfsL+9gP9wQ/Lcu3VHTgXcg32Kbi/AnUl9kG6O+opqJegO7QHXLjGteeN
0Oxmvjfh8TWsP4e8n0N/Q5l9yCF4/105YNhnoNz4WNpnqxx5mvw/d25agWvu
mhr3PNTrUI49UrlexrWZeN7FuGncvQXteRO83kzb9+iNTQT3f2mf/Rnu5zjo
b8/Yl9fJR0accyrX/D37W8F4Q4VjnXLke1J+Q3o78mH52LMg6dr+cSAH/mMz
5jUQqGc8PmNeyjm7YIu2Sfsy+dyBjAcB+0v8pq9hfx1qXMsqB2jK+Ooa5yKq
2XpB2zvp2iI3z7XbxzHnaqrhzqi2RsY+7ma1YhD4NhnH2v7ssYv8Q+bftSBr
/pZ2zqpcVWfQQbVktX3JoHzXosrZlKupJq1jXJtxLlyIjD6MD8ecGxaUOjcM
VHOGnSP2y7jGVW2rGHWU8Ucp+y7FpHPI7pZybq6YOBLf3y7j3GNBtns9vdnD
A4Xu+YSx9+a07/qL2O8D7L0DyMcWk4E8+K/UnYT2uRzXGueq3OtQzaFewL3A
oDz3BK6H1y+i7pXJZypXy47YFypn+xBbboo4lqpH0Q3626BvmOc3kQX9pbTf
lvasXs7ymHtt6ukMYz6A8zrAef0Qcu18Bng/yzV0XdI0wukOKJe7LupelHK6
hmnHYMVe9ZQeY20J9lqi2hmdOqR9J3QXToLP6O2zfjfjj4AVin1AK/WigH2s
Hwj+G8Y3wf875kcijp2qOVQ7qaZTLacaakzUPLT2IrA8YR0kuxHre2Pb1nHn
SueK3Nu5I+FeoXo8yn32Y49G+c6BpsNvK/zGhxwjdoJ/LGNe6indCf5d8GND
jjEPRa2DZKsncJN6Z2nfjbqQa3vlIMo9VOPfAe1a1teCK5QPAX9z2ndfNmgH
ba+oeyPy0SPSzlmUqygm9oi7xlJtpZ7Dwph5ipd6DCu4T+OgCXGfukFzkL1u
izg2yieOwB4/r3JtqppEtI9VupbXmr2KRxn3WtRjUa37FfNfl7vmvR3aSuSt
x74fgv+PSt953XXZcBf8/hJ3r0A9W+VWqplUKynHqkX2ncqH0SWn2L2AEzH3
stQTmJawDPG+BP4W5oMTfjsFeX5r23j/nUr95p5A1uNx147SaXylewTqDagH
d5zxWxWOZWNZMyPtGKTYo57VDHSfGfVb7MudPwr9pgrH/jHQD0bfW6rsS1Sz
qFe1O+baVT2rFXHHeMX2ZejXU/Uv9pqHvS7wbVjKObxyd9WwzdlLi4Rjm2oa
9XaKku61qscTR79I2r1c5Xj5ejtJ+271WP4Yd86gXEE93/fR971q93plk+vg
3TnhXFk53fXoPp39Zpe4B9GV+eSIbaseVR3zGcxz5K/5VpN2z1C9Qr3RHsg6
qfxMb409zI07Z1eurpj317RjlmKVehg3Q/819L+B/g10aIJuPwWWFLtnq1xR
OaZyS+WM17K+U9q9rVMh69Krym9VOi1TrIua1xL83X9xvvdUujZWj/zXaffs
1KtTzjOT+bFqn7Vylsnqjacd25XTqTe2vNJvQz2y/4X3YehHlzonmQ3tn6P+
b0A9QP23UBf13dN/DLKl7rDurmyqt7wu5beuN91P/aWUe+WqweVLVOOqtpVP
GcZZTo06F/usxG9BZyDb603ItyjnV64vH6P/Ci7E3MvQfwY7o+6JqBeyXf9f
KJfj28t57sGfZm1NyrWKer6jkTcq6V62eoqtZV/ux55i94hqwd2cdC9HMWMr
tliccW37MTKHKP9XPp/lHCwOrjLjXFExfCOyX6p0L0w6/DLqPWpvqlkervAZ
6uymBrb1kWq/Ldm8Hv3Hpf12lBMPjbpnoV6Faib1Olsl/N+Fep7fw+9MlXv/
+s9kIWt3RW0L/UczTnc/4Vq/LftbGXfOo1xH/2lcgHY1a6aHXWPNironq16s
Ym4cW5dW+7+AK/Ndu6vnoV6H6s0WUccwxS7V/IrlGyvcy1NM/zbpnFi5sHp0
zdC1eZVtqR5dPeMJVe7lqyZ6Gn4Lkq61VSPMRJe7Kl0r6z+fAmSdT7hWVIxW
bOyY9ltRjPxYe404VionVq/qSKV7z+pZVUObiPq/DvXIz0f8H4B6/+oBvBFx
DaraUzX0QObPpvxfhGqyZMQ9GfVilBOoV5ab9n8d6pnJ1/WK2TfI551lb51T
7p3qzcvW+k9C/0XI5iXYdmbCttV/cuoFzo3a96oneEvaPSX1ktSzfhjcRP1H
V+Ie7qSka1rVsvqmXk5uxL1l9XSS8F5e7VxPPYKmjK+qdq6onrFiWZeYfbNi
mnxb95jvpnycapVQzP9VqGZRLaaaX7W+ajL5tpti/i9JPm4C8uoTvmt6U/qv
aWDM/zXoP6fihGsy1WJ6Q/8CZ/7vkw==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmGuUlVUZxzfDnLnPnDPDnBvMOWdkVuWFqyGoHxRC5WKiAlZo3tAyEsHy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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmuQjmUYx2/L++6uPdnd933efe3h3WqKYZ0Kiw8OOa/zqUIOEzMhh0L4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         "],
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5846, 5226, 7629, 5645, 7870, 7871, 7476, 5090, 6242, 5089, 
         8002, 8003, 8001, 5844, 8004, 5843, 6438, 5225, 5845, 6770, 6437, 
         5840, 7999, 8000, 7998, 5841, 5842, 5228, 5507, 8158, 5506, 5113, 
         5494, 5495, 5249, 5637, 8088, 5052, 6244, 5508, 8159, 5509, 5522, 
         8161, 5521, 5227, 8221, 7021, 6920, 5393, 7699, 5392, 8231, 8236, 
         8235, 5496, 5849, 8139, 5229, 8138, 5848, 6626, 6243, 5391, 7874, 
         5647, 7872, 5646, 7873, 5847, 7628, 7627, 7626, 5505, 7769, 5257, 
         7763, 5493, 7622, 7623, 5846}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7213, 5687, 7210, 7212, 7211, 7311, 6248, 6249, 6071, 6070, 
         5404, 5374, 8100, 8098, 8099, 5121, 8101, 5122, 8102, 5405, 6069, 
         5681, 8094, 5116, 6311, 5892, 8194, 5893, 6041, 6042, 5399, 6439, 
         5400, 6246, 6771, 5230, 6464, 6465, 5922, 6372, 5648, 6373, 6772, 
         5851, 5232, 6440, 5231, 5850, 5800, 6506, 6505, 6504, 5557, 7055, 
         5551, 7213}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7592, 5484, 7751, 5952, 8065, 6421, 6422, 5827, 7986, 5826, 
         7987, 5193, 7759, 7760, 7577, 7576, 7575, 5474, 5520, 8160, 5519, 
         6300, 5168, 8121, 5774, 5773, 5867, 8188, 5866, 6240, 5868, 8189, 
         5869, 5783, 5955, 8123, 5178, 6304, 5177, 8122, 5782, 5476, 7579, 
         7580, 5195, 7761, 5194, 7991, 7992, 7990, 5831, 7993, 5784, 6426, 
         5785, 7961, 5786, 7962, 5489, 7003, 5490, 7004, 7621, 7620, 5492, 
         7762, 6099, 6100, 5491, 7605, 7604, 7603, 7755, 7754, 8069, 6424, 
         6425, 5830, 7988, 5829, 7989, 6239, 7757, 7758, 7602, 7601, 7600, 
         5488, 5770, 8119, 5166, 6303, 5167, 8120, 5772, 5771, 5865, 8187, 
         5864, 6096, 6095, 5863, 8143, 5245, 6419, 6420, 5951, 8118, 5165, 
         6299, 5501, 8157, 5502, 5483, 7590, 7591, 5203, 7756, 6235, 7983, 
         7984, 7982, 5822, 6415, 6414, 7953, 7954, 7752, 5485, 7595, 7596, 
         7597, 7765, 7764, 5204, 7768, 5503, 7594, 7593, 7592}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{6774, 5859, 8009, 7318, 6683, 7177, 7176, 7174, 7175, 5099, 
         7180, 7885, 5654, 7181, 5655, 6775, 7179, 7178, 7319, 5240, 8075, 
         8076, 7366, 5983, 6446, 6445, 5858, 7317, 5994, 7323, 8016, 8017, 
         6485, 6486, 6487, 6452, 5905, 6483, 6102, 5993, 5500, 6493, 6494, 
         6298, 6297, 5153, 6302, 5151, 6301, 5152, 6292, 6293, 5991, 6295, 
         6294, 5250, 6453, 6454, 5906, 6482, 5907, 6444, 6443, 8078, 8030, 
         8031, 8029, 5880, 8032, 5252, 5881, 6776, 6774}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{8110, 5221, 8111, 8112, 8113, 5936, 5938, 6470, 6469, 5238, 
         6481, 5236, 6480, 5237, 6471, 6472, 5937, 5143, 8114, 5142, 8247, 
         8248, 8246, 8110}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5032, 7435, 6805, 6806, 8085, 8142, 8141, 5241, 5860, 8011, 
         8012, 7886, 5658, 6264, 6263, 5102, 6951, 5437, 6950, 5438, 7772, 
         5514, 7771, 5513, 6703, 6702, 6701, 5436, 6949, 6062, 7154, 7155, 
         7151, 7153, 7152, 7315, 5157, 6705, 6704, 6953, 6952, 6081, 6963, 
         6964, 6719, 7018, 7019, 5515, 6718, 6717, 6716, 5444, 6962, 6065, 
         6066, 7436, 7854, 5629, 8168, 6767, 7624, 6966, 5445, 6965, 7730, 
         7729, 5107, 6277, 6278, 5662, 7893, 5661, 7894, 8034, 8033, 5247, 
         8224, 8225, 8223, 6982, 6981, 7735, 7734}],
        "0.75`"],
       Annotation[#, 0.75, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5115, 6871, 6872, 6869, 5316, 6870, 5459, 7737, 7739, 7738, 
         5371, 7692, 5370, 8230, 6921, 5395, 7704, 5055, 6040, 5891, 8037, 
         8039, 8038, 6310, 5181, 6925, 6926, 6922, 6924, 6923, 4994, 7693, 
         5372, 6915, 5373, 7702, 7703, 7700, 5394, 7701, 5091, 6068, 5682, 
         7492, 7493, 5118, 6381, 5117, 6875, 6876, 6874, 5320, 7911, 5685, 
         7494, 7495, 6383, 5683, 7910, 5684, 7907, 7909, 7908, 6226, 4998, 
         7695, 7696, 7694, 5375, 7708, 5402, 7707, 5401, 6073, 6072, 5688, 
         8103, 5124, 6384, 5123, 7658, 5323, 7657, 5322, 7913, 7914, 7499, 
         7500, 5125, 6385, 7498, 7497, 7496, 5689, 7912, 5377, 7811, 5565, 
         7810, 5564, 6317, 6318, 5696, 8171, 5695, 6195, 5700, 8173, 5701, 
         5697, 5699, 8172, 5698, 6228, 5009, 8082, 5574, 5573, 5711, 8174, 
         5710, 6204, 5714, 8175, 5715, 5712, 6399, 7513, 7512, 5713, 7925, 
         5380, 7818, 5583, 7817, 5582, 6328, 5136, 7515, 7514, 7940, 7939, 
         5337, 7663, 5338, 7664, 8041, 8040, 6330, 5137, 8105, 5722, 6076, 
         6077, 5729, 7941, 5730, 7942, 5728, 7351, 5939, 7350, 8058, 8057, 
         5074, 5021, 6917, 6918, 6916, 5382, 6919, 7531, 7714, 5424, 7676, 
         5349, 7677, 7678, 6901, 6900, 7334, 7356, 5147, 6084, 6496, 6495, 
         5902, 6080, 5100, 6944, 5431, 6943, 6942, 6634, 5383, 6141, 6140, 
         6267, 6268, 5619, 7847, 7848, 7321, 7320, 8010, 5190, 7368, 7369, 
         7367, 5984, 7370, 5920, 8051, 5921, 7471, 7472, 6018, 6017, 8013, 
         5861, 7633, 7634, 5242, 6442, 5243, 6995, 6996, 6993, 5467, 6994, 
         8229, 5367, 7687, 6908, 6910, 6909, 7158}],
        "0.75`"],
       Annotation[#, 0.75, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5297, 6172, 5504, 7009, 7008, 7736, 5456, 8150, 6768, 7625, 
         6769, 8151, 5457, 6983, 6741, 6742, 5516, 6092, 6091}],
        "0.75`"],
       Annotation[#, 0.75, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5890, 7209, 5675, 6646, 6647, 6648, 6366, 7487, 7486, 6645, 
         7208, 7207, 7332, 7205, 7206, 6643, 6644, 5110, 6377, 5109, 8028, 
         5876, 8027, 5877, 5879, 8191, 5878, 5251, 8227, 6862, 8226, 6863, 
         6860, 5310, 6861, 5458, 6642, 6641, 6640, 5390, 6105, 6104, 7442, 
         7441, 7646, 5309, 8145, 6743, 5180, 7698, 5389, 7697, 5388, 6103, 
         5048, 8087, 7440, 7565, 7564, 5179, 6427, 6428, 5788, 7963, 5787, 
         7964, 6241, 4991, 7903, 7904, 7902, 5679, 7905, 5677, 6380, 7491, 
         7490, 5678, 7901, 5995, 7900, 5676, 7488, 7489, 5112, 6379, 5111, 
         7050, 7051, 7049, 5540, 7782, 5051, 6039, 5541, 7783, 7785, 7784, 
         7906, 4993, 8207, 6867, 8206, 6868, 6866, 5315, 7789, 7790, 7788, 
         5546, 5054, 7397, 7396, 7395, 5547, 7791, 5319, 7798, 5550, 7797, 
         5549, 5056, 7399, 7398, 7799, 7800, 7654, 7653, 5321, 7655, 7656, 
         6879, 6878, 7054, 7919, 5003, 7403, 7402, 5563, 7807, 6044, 6045, 
         7404, 7808, 7809, 6667, 6666, 5132, 6398, 5133, 7511, 7510, 5709, 
         7924, 5267, 6120, 5931, 8055, 5932, 8056, 5720, 7938, 5721, 7935, 
         7937, 7936, 8015, 5884, 8193, 5885, 5594, 7828, 5593, 6332, 5184, 
         7569, 7570, 7456, 7666, 7457, 7458, 5020, 7712, 5422, 7711, 5423, 
         7713, 8153, 8154, 5465, 7674, 5347, 7675, 5348, 6899, 6005, 6941, 
         5430, 6694, 6991, 6992, 5466, 7745, 7746, 7683, 7685, 7684, 7840, 
         5874, 8190, 5875, 5518, 7774, 7775, 7549, 7548, 5158, 7023, 5159, 
         8117, 7022, 6706, 6760, 6759, 5192, 6761, 6762, 6724, 6725, 5170, 
         6371, 7559, 7558, 7957, 7960, 7959, 7958, 6726, 8180, 7560}],
        "0.75`"],
       Annotation[#, 0.75, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4995, 7705, 7706, 6928, 5397, 8245, 6929, 7567, 7740, 5460, 
         8152, 7566, 6984, 6652, 5396, 6927, 5996, 6308, 6309, 6111, 6110, 
         6367, 6312, 5114, 6650, 6649, 5680, 6107, 6106, 7444, 7443, 7651, 
         7652, 6746, 6745, 5183, 6382, 5182, 7568, 6744, 5789, 7296, 5403, 
         6247, 4999, 6000, 5376, 6627, 6628, 5093, 6930, 5092, 7916, 7917, 
         7915, 5691, 7918, 5690, 8244, 6386, 7502, 7501, 5927, 8054, 7346, 
         6586, 8254, 6585, 6508, 5558, 6197, 6196, 6515, 6514, 6513, 5566, 
         7061, 7166, 7165, 7065, 7066, 7062, 7064, 7063, 6205, 5010, 6525, 
         6524, 7080, 7079, 7167, 7086, 7087, 7083, 7085, 7084, 6206, 5012, 
         6534, 6533, 7102, 7101, 7168, 7169, 6796, 5269, 6794, 5268, 6795, 
         5417, 7830, 7831, 7829, 5595, 6329, 5185, 7571, 7572, 7668, 7667, 
         7459, 8043, 5898, 8042, 5897, 8070, 5956, 7966, 7967, 6451, 5896, 
         6484, 5895, 6450, 5144, 7247, 7248, 7246, 7245, 6676, 5732, 6339, 
         6338, 6214, 6558, 6557, 7140, 5608, 7141, 7142, 7172, 7869, 7171, 
         6613, 6614, 5030, 6010, 5759, 6707, 7550, 5160, 6354, 6370, 6153, 
         6154, 6463, 6462, 5285, 6969, 5446, 6727, 6729, 6997, 5468, 6758, 
         7574, 6973, 5448, 6970, 6972, 6971, 6167}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5248, 7637, 5517, 7773, 6067, 7860, 5635, 7859, 5634}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5278, 6139, 7467, 7679, 5354, 7681, 7680, 6692, 6693, 5150, 
         6409, 7536, 7535, 6691, 5745, 7253, 5385, 6231, 6565, 6564, 5618, 
         7150, 5617, 7266, 5757, 7263, 7265, 7264, 6217, 7951, 7952, 7272, 
         7274, 7273, 5758, 7270, 7271, 7267, 7269, 7268, 6234, 5037, 6571, 
         6570, 7157, 7156, 5628, 7283, 5765, 7281, 5764, 7282, 6222, 7955, 
         5768, 7286, 5769, 6418, 6417, 7555, 7554, 6720, 5767, 7284, 5387, 
         7162, 7163, 7161, 7858, 7857, 6275, 5176, 6739, 6740, 6914, 7691, 
         6913, 6625, 6028, 6027}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5915, 6037, 6036, 6460, 5665, 6374, 5636, 7188, 5664, 7187, 
         5663, 7895, 6307, 5045, 6035, 5674, 6179, 6178, 6305, 5044, 7380, 
         7379, 6501, 5532, 7203, 7204, 7200, 7202, 7201, 4988, 7898, 7899, 
         7197, 7199, 7198, 5671, 7196, 5673, 7194, 5672, 7195, 4987, 7897, 
         5669, 7192, 5670, 7193, 5666, 7191, 5668, 7896, 5667, 8241, 7190, 
         8240, 7189, 6859, 5308, 6575, 5307, 6858, 7387, 7043, 7045, 8080, 
         7044, 6038, 6378, 5306, 6181, 5536, 7042, 7041, 6577, 6857, 6856, 
         7040, 5047, 7386, 7385, 7384, 5535, 6183, 6182, 7393, 7392, 7391, 
         7781, 7780, 7048, 6578, 5312, 6864, 7047, 7046, 5050, 4990, 7390, 
         7389, 5539, 7779, 5314, 7787, 5545, 7786, 5544, 5053, 4992, 7394, 
         6873, 5318, 6581, 6582, 7795, 7796, 7793, 5548, 7794, 6188, 6189, 
         5556, 7802, 5555, 7803, 5060, 4997, 6882, 6883, 6593, 6594, 6595, 
         7401, 6203, 5331, 6397, 6048, 7076, 7077, 7075, 5572, 6893, 5335, 
         6602, 5336, 6894, 5581, 7099, 5934, 7348, 5935, 7349, 5725, 7235, 
         5727, 7233, 5726, 7234, 6121, 8062, 5943, 7353, 7355, 7354, 5738, 
         7243, 7244, 7240, 7242, 7241, 6130, 7254, 7255, 6556, 6555, 6545, 
         5606, 6060, 5080, 5029, 7326, 7327, 7325, 7329, 7328, 5256, 6782, 
         6783, 6616, 6617, 5083, 5033, 7288, 5775, 7287, 5776, 7289, 5643, 
         7173, 5644, 6620, 6621, 6622, 7437}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5028, 6009, 5429, 6689, 6690, 5149, 6128, 5148, 6135, 8251, 
         6136, 5744, 6133, 6132, 5079, 6612, 6008, 6007, 6352, 5277, 6138, 
         6700, 6148, 5281, 6413, 5280, 6145, 6615, 6016, 6015, 6364, 5283, 
         6152, 6714, 6715, 6158, 7285, 6159, 5766, 6156, 6155, 5086, 5036, 
         6023, 5455, 6163, 6737, 6738, 6980, 6979, 6912, 6811, 6812, 6807, 
         6810, 6809}],
        "0.25`"],
       Annotation[#, 0.25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5191, 7971, 5798, 7970, 5799, 7972, 5777, 7956, 8243, 5953, 
         8066, 7556, 7557, 6723, 5169, 6722, 6721, 6968, 6967, 5284, 7330, 
         7331, 6781, 7638, 5255, 6449, 5254, 6780, 6779, 7373, 7372, 5607, 
         6903, 5356, 7682, 5355, 7133, 5601, 6546, 7427, 6057, 6056, 6407, 
         5346, 7673, 6209, 6540, 6053, 6052, 6404, 5343, 7665, 6207, 7417, 
         6604, 6603, 6601, 5334, 6889, 7411, 6599, 6598, 6597, 6887, 6886, 
         5002, 5062, 6592, 6591, 6881, 6880, 4996, 5059, 7801, 5553, 7052, 
         5554, 6187, 6186, 7792, 7649, 7650, 7647, 5317, 7648, 5542, 8163, 
         5543, 6580, 6579, 5313, 6865, 7388, 4989, 5049, 5537, 7777, 5538, 
         7778, 5311, 7776, 5533, 7381, 7382, 7383, 5046, 7037, 7038, 6851, 
         5304, 6576, 7039, 5534, 8079, 4985, 6853, 5305, 6852, 6855, 6854, 
         4986, 6180, 7026, 5525, 7025, 5526, 6029, 5042, 7024, 6823, 6824, 
         6572, 7027, 8208, 5043, 7028, 6830, 6831, 6573, 7029, 7030, 5527, 
         6837, 5298, 6574, 7031, 7032, 5528, 6173, 5299, 6375, 6030, 6031, 
         5529, 6174, 5300, 6376, 6032, 6033, 5530, 6177, 5301, 6306, 6034, 
         7035, 7036, 6499, 7378, 6849, 5302, 6848, 5303, 6850, 7182, 7183, 
         7184, 6639, 7185, 8093, 5108, 7186, 7485, 7484, 7483, 5926, 8053, 
         5832, 6435, 5834, 6492, 5833, 6434, 5870}],
        "0.25`"],
       Annotation[#, 0.25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5290, 6270, 5291, 6168, 6224, 6223, 6165, 6731, 6730, 6728, 
         5447, 6019, 5034, 5084, 6618, 6353, 5620, 6220, 5621, 6219, 6218, 
         6348, 6349, 6215, 5358, 6346, 5357, 7137, 7138, 6550, 6610, 6611, 
         7428, 7863, 7865, 7864, 7136, 7135, 5602, 7134, 6547, 6548, 6210, 
         7121, 5597, 7120, 7123, 7122, 7170, 6333, 6334, 5731, 7236, 7238, 
         7237, 5013, 5069, 7454, 7455, 7100, 7104, 7103, 5339, 7088, 7089, 
         6526, 6600, 8083, 5011, 5066, 7450, 7451, 7078, 7082, 7081, 5332, 
         7067, 7068, 6516, 6596, 8081, 5004, 5063, 6319, 8210, 8211, 8253, 
         8252, 6198, 6323, 6322, 6046, 7069, 7070, 6507, 6517, 6518, 6199, 
         8209, 6200, 5559, 6510, 6587, 6588, 7446, 7445, 7639, 5260, 7640, 
         6784, 6786, 8095, 8097, 8096, 5119, 7297, 5120, 6656, 6655, 5686, 
         6511, 5000, 6190, 6191, 5552, 6193, 6502, 6503, 6583, 5057, 6108, 
         6109, 5398, 6651, 6653, 6654, 6114, 6184, 6185, 6113, 5258, 6245, 
         5997}],
        "0.25`"],
       Annotation[#, 0.25, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3065, 7377, 4978, 6814, 6815, 6813, 6817, 6816, 4979, 6819, 
         6820, 6818, 6822, 6821, 4980, 6826, 6827, 6825, 6829, 6828, 4981, 
         6833, 6834, 6832, 6836, 6835, 4982, 6839, 6840, 6838, 6842, 6841, 
         4983, 6844, 6845, 6843, 6847, 6846, 4984, 6175, 6176, 5531, 6500, 
         7034, 7033}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{2900, 6877, 7053, 6194, 1453}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{121, 6890, 6892, 6891, 7816, 7098, 6895}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{5019, 6896, 7827, 7117, 6897}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5026, 6898, 7838, 7132, 2925, 6902, 7139, 7371, 6448}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5038, 5087, 6623, 6164, 5288, 6271, 5289, 7291, 7292, 7290, 
         5778, 6358, 5623, 6221, 5364, 6355, 5363, 7143, 7144, 6562, 7431, 
         7432, 5081, 6061, 5609, 6549, 6559, 6560, 5746, 7256, 6340, 8091, 
         6341, 6211, 5351, 6337, 5350, 7124, 7125, 6542, 6605, 7424, 5022, 
         5075, 7460, 7461, 7833, 7832, 5596, 7119, 5344, 7108, 5586, 6536, 
         7418, 7419, 5070, 7819, 5584, 7105, 5585, 7107, 5340, 7093, 5577, 
         6528, 7412, 7413, 5067, 7813, 5575, 7090, 5576, 7092, 5333, 7071, 
         5567, 6520, 7405, 5005, 5064, 6320, 6321, 6201, 5326, 6327, 6047, 
         7072, 7073, 6509, 6521, 7400, 5006, 7220, 5702, 6787, 5261, 6785, 
         5262, 7164, 5638, 6589, 7448, 7447, 7804, 5560, 7805, 7806, 7058, 
         7057, 5324, 6313, 5325, 6192, 6512, 5001, 7215, 5692, 7214, 7217, 
         7216, 5259, 6250, 5998, 5999, 6584, 5058, 6112}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5041, 7475, 7474, 7473, 7644, 5293, 7645, 5294, 6808, 7563, 
         6162, 5287, 6276, 6022, 6906, 6907, 6698, 5366, 6157, 5286, 6351, 
         6020, 6021, 5443, 6149, 5282, 6412, 5753, 6151, 7261, 6150, 6216, 
         6146, 6147, 5605, 6014, 5031, 6948, 6802, 6803, 6799, 5276, 6804, 
         5353, 6134, 5275, 6258, 6006, 6261, 5428, 6137, 6688, 6129, 5273, 
         6262, 6003, 6004, 6608, 6609, 6122}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5292, 6974, 5449, 6732, 7561, 5172, 6166, 5171, 6359, 6360, 
         5630, 7159, 6568, 6569, 5085, 7277, 6063, 5622, 6561, 6566, 6567, 
         7276, 7275, 6142, 6143, 5747, 6696, 7537, 7538, 6347, 5154, 6342, 
         6343, 7146, 7145, 6553, 6554, 5077, 8018, 6058, 5603, 6541, 6551, 
         6552, 5739, 7130, 5599, 7118, 5600, 7131, 6054, 7127, 5598, 6535, 
         6543, 5023, 7239, 7113, 7114, 7106, 7116, 7115, 6050, 7110, 7111, 
         6527, 6537, 5014, 7228, 7095, 7096, 7091, 5579, 7097, 6049, 7094, 
         5578, 6519, 6529, 6530, 5716, 7226, 5717, 7227, 5569, 6523, 7406, 
         7407, 5065, 6324, 5568, 6391, 5703, 6326, 6325, 5129, 6116, 6117, 
         5408, 6590, 5407, 6932, 5007, 7222, 7059, 7060, 7056, 5562, 6043, 
         7074, 5061, 6314, 5561, 6387, 6388, 6316, 8250, 6315, 5126, 6115, 
         5127, 6658, 6657, 5406, 6931, 6001}],
        RowBox[{"-", "0.25`"}]],
       Annotation[#, -0.25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5295, 6423, 5296, 6171, 5369, 6225, 6169, 6170, 5627, 6026, 
         5040, 6274, 6160, 6161, 5435, 6699, 6960, 7547, 5156, 6961, 5155, 
         7968, 7969, 7308, 7310, 7309, 5616, 7338, 7339, 6563, 7433, 7434, 
         5082, 8063, 5947, 7357, 5948, 7358, 5752, 7262, 5756, 7260, 5755, 
         6090, 6089, 7304, 5796, 6752, 6753, 6754, 6345, 7336, 5903, 7335, 
         5904, 8048, 7465, 7466, 7463, 7464, 6798, 6801, 8115, 6800, 8116, 
         5146, 7530, 8232, 5464, 7744, 6988, 6990, 6989, 5421, 6607, 6940, 
         7462, 6939, 5027, 6260, 6124, 8090, 6125, 5736, 6127, 6126, 6208, 
         5345, 6123, 5272, 6331, 6002}],
        RowBox[{"-", "0.25`"}]],
       Annotation[#, -0.25, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5039, 5088, 8067, 8068, 7360, 5954, 7361, 5779, 7295, 5781, 
         7293, 5780, 7294, 5106, 6082, 5763, 6711, 6712, 6713, 6363, 7341, 
         5914, 7340, 7343, 7342, 6064, 7722, 7723, 7552, 7553, 5163, 6266, 
         5164, 6710, 6265, 5434, 6488, 5433, 7305, 7306, 6755, 7573, 5188, 
         6411, 5189, 6757, 6756, 5797, 7307, 5362, 7259, 5754, 6697, 7545, 
         7546, 6344, 7846, 5614, 7148, 5615, 7149, 5427, 6259, 5792, 7300, 
         5793, 7301, 5741, 7303, 5795, 7302, 5794, 6213, 5352, 6131, 7643, 
         5274, 6336, 8077, 5987, 7374, 5988, 7375, 5420, 6986, 6987, 6749, 
         7016, 8124, 5186, 7017, 5187, 6751, 6750, 7670, 7671, 7672, 7669, 
         7352, 8060, 8061, 6679, 6680, 6681, 6406, 7529, 7528, 6682, 5737, 
         6083, 5141, 7965, 5790, 7298, 5791, 7299, 5592, 7333, 5894, 6539, 
         7423, 5018, 5073, 6255}],
        RowBox[{"-", "0.5`"}]],
       Annotation[#, -0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5263, 6118, 7449, 7659, 7662, 7661, 7660, 6659, 6660, 5128, 
         6389, 6390, 5694, 7218, 5693, 7219, 6227, 5008, 7409, 7408, 8237, 
         5570, 7812, 5571, 7223, 5706, 7347, 5705, 6663, 6662, 6119, 5265, 
         6394, 5264, 6885, 5328, 6884, 5327, 7920, 7921, 7505, 7506, 5130, 
         6392, 7504, 7503, 6661, 5704, 7221, 5378, 6532, 6531, 6522, 6792, 
         6791, 6888, 7932, 5719, 7931, 7934, 7933, 5718, 7929, 7930, 7926, 
         7928, 7927, 6230, 5016, 7421, 7422, 7823, 7822, 5587, 7231, 7232, 
         5933, 7230, 7229, 5138, 8107, 8108, 8106, 7112, 7109, 7821, 7820, 
         5071, 5015, 7420, 6538, 6678, 6677, 5145, 7128, 7129, 7126, 7835, 
         7834, 5076, 5024, 6544, 5740, 6684, 7249, 7250, 7252, 7251, 6212, 
         8023, 8024, 8022, 8026, 8025, 5871, 8021, 5873, 8019, 5872, 8020, 
         5886, 8035, 5887, 8036, 5611, 7147, 5610, 7841, 6350, 7541, 7540, 
         7539, 7946, 7945, 5359, 6695, 5360, 6904, 6011, 6362, 5279, 6144, 
         6708, 5161, 6356, 6357, 5761, 7278, 5760, 7279, 5762, 7280, 6236, 
         6237, 5632, 7160, 5631, 7855, 6365, 5173, 7562, 6733, 7688, 7689, 
         7690, 6911, 6624, 6025, 6024}],
        RowBox[{"-", "0.5`"}]],
       Annotation[#, -0.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5174, 7020, 5175, 6736, 6735, 5454, 6978, 5368, 6977, 5453, 
         6734, 7322, 8014, 5862, 7635, 5244, 7636, 8239, 5633, 7856, 7438, 
         7439, 6238, 7725, 7726, 7724, 7728, 7727, 5386, 6636, 6954, 6955, 
         6957, 6956, 5103, 7888, 7889, 7887, 7891, 7890, 5613, 6368, 6369, 
         6490, 6489, 6012, 6013, 7470, 7469, 8242, 5918, 8050, 5919, 7344, 
         7950, 7258, 5751, 7257, 5750, 7345, 5925, 8052, 5924, 5990, 8170, 
         5657, 6474, 5945, 8198, 5946, 5743, 7867, 5641, 7866, 5642, 7868, 
         5917, 6461, 5916, 6497, 6085, 6086, 5944, 6088, 6087, 6498, 5742, 
         6408, 5923, 5989, 8169, 5656, 6473, 5941, 8197, 5942, 5735, 7862, 
         5639, 7861, 5640, 8047, 5901, 6606, 7376, 5992, 8147, 5418, 6491, 
         5419, 6257, 6773, 5857, 5239, 6441, 5854, 8008, 5856, 8006, 5855, 
         8007, 5098, 8216, 8217, 8215, 6937, 6633, 6632, 6631, 5381, 7836, 
         7837, 7425, 7426, 5025, 6256, 7742, 5461, 7741, 5462, 7743, 5235, 
         7632, 5511, 7770, 6748, 6747, 5463, 6985, 5342, 6938, 5416, 6675, 
         7005, 8109, 5140, 7006, 7007}],
        RowBox[{"-", "0.75`"}]],
       Annotation[#, -0.75, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5450, 6975, 5451, 6976, 7324, 8222, 5246, 5882, 8192, 5883, 
         5660, 8092, 5105, 6272, 5104, 7721, 5439, 7720, 5440, 7997, 5839, 
         7996, 5838, 7851, 5626, 7850, 7853, 7852, 6619, 6905, 5365, 8146, 
         6709, 7551, 5162, 6361, 5624, 7849, 5625, 6233, 6232, 7717, 5432, 
         7716, 7719, 7718, 5384, 6635, 6945, 6946, 6947, 8218, 8220, 8219, 
         5101, 5985, 8205, 5986, 5888, 6447, 5253, 8144, 5889, 6778, 6777, 
         8167, 5604, 7839, 7429, 7430, 5078, 6059, 5425, 6685, 6686, 6687, 
         5512, 7534, 7533, 7532, 5426, 7715, 6079, 7944, 5734, 7525, 7526, 
         7527, 6335, 8045, 5899, 8044, 5900, 8046, 6055, 8059, 5940, 7519, 
         7520, 7521, 6405, 7524, 7523, 7522, 5733, 7943, 6078, 7710, 5415, 
         7516, 7517, 7518, 5853, 7825, 5588, 7824, 5589, 7826, 6051, 6936, 
         5413, 6670, 6671, 6672, 5510, 7015, 7014, 6673, 5414, 6075, 5097, 
         7709, 5411, 6934, 5412, 6935, 7631, 7630, 8238, 5580, 8166, 8164, 
         8165, 5068, 7452, 7453, 6790, 6793, 8212, 8214, 8213, 5095, 6933, 
         5096, 6630, 6629, 5379, 7814, 7815, 7414, 7415, 7416, 6229, 7225, 
         5707, 7224, 5708, 6396, 6395, 7509, 7508, 7507, 7923, 7922, 5329, 
         6393, 5330, 6202, 6664, 5131, 7012, 7013, 7011, 7010, 6665, 5409, 
         6074, 5094, 6251, 6252, 5650, 7875, 5649, 8005, 5852, 5233, 8140, 
         7316, 6789, 5266, 6788, 7410}],
        RowBox[{"-", "0.75`"}]],
       Annotation[#, -0.75, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{6402, 5803, 8181, 5802, 7974, 5651, 7881, 7883, 7882, 5410, 
         7879, 7880, 7876, 7878, 7877, 7973, 5801, 7583, 7582, 7581, 5477, 
         5499, 8156, 5498, 6296, 5497, 5929, 8196, 5928, 6400, 5234, 5470, 
         8155, 5469, 5962, 8126, 5205, 6476, 5206, 8127, 5963, 6097, 6098, 
         5960, 8200, 5961, 5957, 5959, 8199, 5958, 6283, 5017, 8084, 5591, 
         5590, 5836, 8186, 5835, 5196, 5967, 8201, 5968, 6478, 6477, 5209, 
         8130, 5966, 5471, 8071, 5969, 7609, 7610, 7611, 6431, 5211, 7613, 
         7612, 5808, 5197, 8125, 5478, 5723, 8179, 5210, 8177, 8176, 8178, 
         5481, 5724, 5480, 6284, 6674, 5139, 6285, 6286, 5837, 8135, 5219, 
         6436, 5220, 5341, 8089, 5072, 5965, 8129, 5208, 6429, 6430, 5806, 
         7976, 5805, 7977, 5198, 5807, 7978, 5652, 7884, 5653, 6254, 6253, 
         6279, 6280, 5809, 8131, 5212, 6432, 5213, 8132, 5810, 7584, 7750, 
         5479, 8234, 7641, 5270, 7642, 5271, 6797, 7362, 5964, 8128, 5207, 
         6467, 6468, 5930, 8104, 5134, 6998, 5135, 6669, 6668, 6764, 8249, 
         6763, 7313, 7312, 7975, 5804, 7606, 7607, 7608, 6403, 6466, 6401, 
         6402}],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{7000, 6765, 6766, 5981, 8136, 5222, 6458, 6459, 5913, 8086, 
         5035, 6289, 5816, 8183, 5817, 5815, 5819, 8184, 5818, 5200, 5973, 
         8203, 5974, 5970, 5972, 8202, 5971, 6281, 5812, 8182, 5813, 5811, 
         7980, 7981, 7979, 5814, 5199, 7364, 5977, 7363, 5978, 7365, 5908, 
         6455, 5909, 7337, 5910, 8049, 5612, 7842, 7845, 7843, 7844, 7585, 
         7586, 5201, 7994, 7995, 7589, 7588, 7587, 5482, 7948, 7949, 7542, 
         7543, 7544, 6287, 6288, 5749, 7947, 5748, 6410, 5214, 7614, 8228, 
         5361, 7686, 7468, 5912, 8195, 5911, 6456, 6457, 5980, 8204, 5979, 
         5202, 5820, 8185, 5821, 5659, 7477, 7478, 7479, 6269, 6282, 8073, 
         5975, 8072, 5976, 8074, 5824, 6433, 5217, 8133, 5825, 7314, 6959, 
         5442, 6958, 5441, 7753, 5487, 7598, 7599, 5982, 8137, 5224, 6479, 
         5223, 6101, 5486, 7002, 7001, 7731, 5452, 7733, 7732, 8149, 8148, 
         7578, 7749, 5475, 8233, 7619, 5218, 8134, 5828, 6637, 6638, 6273, 
         7482, 7481, 7892, 7480, 7618, 7617, 5216, 6475, 5949, 8064, 5950, 
         6291, 6290, 7766, 7767, 7748, 5472, 7747, 5473, 5524, 8162, 5523, 
         6094, 6093, 7985, 5823, 7615, 7616, 5215, 6416, 7359, 6999, 7000}],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{0, 3}, {0, 3}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 179},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->673973355]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2933],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "InterpolationOrder",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->3899],

Cell["\<\
Make a zeroth\[Hyphen]order interpolation:\
\>", "ExampleText",
 CellID->1098600312],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Interpolation", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "5", ",", "7", ",", "2", ",", "3", ",", "1"}], "}"}],
       ",", 
      RowBox[{"InterpolationOrder", "\[Rule]", "0"}]}], "]"}], "[", "x", 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32181],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWL0vBEEUn9tZieh0EtwuisP/IGiolKI+FxdX+AgqoiL0VBo6CRGREKIT
EpXQCoVK539Yb2Z3zuzb2ZuZvZzvze7Mvtn3+72ZeW/e7O5YcWl6aqa4VCkV
/dGF4vx0pbToj8wtQBPNEULO4FptI3AfwB2/zoIAarksQOnCo06oKdQ+a2U3
AT+q7R7UDtRNHNUraZEUlCzj5+2scD9kQlxe9SE9T4FjsC5Dvn6k1xGNIo/6
352RD4+zM+L3JTu0OmuFBCuelw4JL7fnkexWvSBbwSjhM1G7Ce83I8SBdSsb
2TE05pQ6rap+SzLVPMcy5sNyS4P5HOUohzRyTxXFvHComWMTncYhoyCJDjxf
IcLReDFdi4lrXFhZvpybPYWTeKygz09vkV7OyEbIMjiw83D/CifxoHDtkDHv
qFBsVtaV2iFpeDQZ8eO5T9dKt2rO8XMsuYooU/OIyJSETF5lYrhCJ8b3AQAn
8VhBL84fI728kg1HEmYfQijG4uzt3vmfwJbcrdicD9tx1Ihqu96oM6QN2r73
9dv8Sz0WbyX2vf76VUAo0G1uXIm8r4/kjzWPmQAe24e2t25jTLrdBLOWM42q
rPVJ2cjntlq/zVLaLq62nM23qh1LrSl/YaRFodAMAtPMmxVhNzc/0/+fZ0m/
VjPmAAWKf3/z7ATZKmrHbygam9Fbcp5nS0idkEDZI0/JUiu20rJ5HMlKMTte
TYQTSN+mxnawj/Ta+p7Yc/6+HtTh+eTfkjqwDNo4e9R+dP9x/U17YO8ZjDC3
pXtfsEeLOCf05vol9i1amjyysh3+c6m9Kg6kZnGccCH5X5jk3gGProiY\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 125},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->439928068]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->721579376],

Cell["Make a linear interpolation:", "ExampleText",
 CellID->148853706],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Interpolation", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "5", ",", "7", ",", "2", ",", "3", ",", "1"}], "}"}],
       ",", 
      RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}], "[", "x", 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->34711596],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 126},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->153099232]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->695303616],

Cell["Make a quadratic interpolation:", "ExampleText",
 CellID->691042944],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Interpolation", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "5", ",", "7", ",", "2", ",", "3", ",", "1"}], "}"}],
       ",", 
      RowBox[{"InterpolationOrder", "\[Rule]", "2"}]}], "]"}], "[", "x", 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27222],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 123},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->34862974]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PeriodicInterpolation",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->19444],

Cell["Make an interpolating function that repeats periodically:", \
"ExampleText",
 CellID->300248066],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Interpolation", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "5", ",", "7", ",", "2", ",", "3", ",", "1"}], "}"}],
       ",", 
      RowBox[{"PeriodicInterpolation", "\[Rule]", "True"}]}], "]"}], "[", "x",
     "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24863694],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 127},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->120258372]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->395],

Cell["Interpolate random data:", "ExampleText",
 CellID->751555411],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"Interpolation", "[", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", "20"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7840],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1.`", ",", "20.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{265, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3064585]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26997],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->677937715]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->346675374],

Cell["Find a continuous interpolation of the GCD function:", "ExampleText",
 CellID->291585353],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"Interpolation", "[", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], ",", 
         RowBox[{"GCD", "[", 
          RowBox[{"x", ",", "y"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "20"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "20"}], "}"}]}], "]"}], ",", "1"}], "]"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->163563753],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "20"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "20"}], "}"}]}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{308, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15344431]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "1", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->239276399],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->89318677]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16914],

Cell["\<\
The interpolating function always goes through the data points:\
\>", "ExampleText",
 CellID->166409219],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "5", ",", "8", ",", "5"}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->420782050],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"Interpolation", "[", "data", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4436254],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "6"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{244, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->285373183]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", "data", "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "1", ",", "6"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->552629468],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 125},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->310025950]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->352357730],

Cell["Find the integral of an interpolating function:", "ExampleText",
 CellID->2097121],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"Interpolation", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", 
     RowBox[{"-", "8"}], ",", "2", ",", "3"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->298476801],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "6"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{244, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->56911786]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->106845073],

Cell[BoxData[
 RowBox[{
  TagBox[
   RowBox[{"InterpolatingFunction", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"1", ",", "6"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
   False,
   Editable->False], "[", "x", "]"}]], "Output",
 ImageSize->{265, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->89962855]
}, Open  ]],

Cell["Plot the interpolating function and its integral:", "ExampleText",
 CellID->182944783],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", "%"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->40452516],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->151801752]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "1", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->811099943],

Cell[BoxData[
 RowBox[{
  RowBox[{"FindRoot", "::", "\<\"lstol\"\>"}], ":", 
  " ", "\<\"The line search decreased the step size to within tolerance \
specified by AccuracyGoal and PrecisionGoal but was unable to find a \
sufficient decrease in the merit function.  You may need more than \
\\!\\(MachinePrecision\\) digits of working precision to meet these \
tolerances. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/FindRoot/lstol\\\", ButtonNote -> \
\\\"FindRoot::lstol\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->413577860],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "1.2928929428076523`"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->157514331]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16429],

Cell["Extrapolation is attempted to go beyond the original data:", \
"ExampleText",
 CellID->103589623],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Interpolation", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "4", ",", 
    RowBox[{"-", "2"}], ",", "1"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87269104],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "5"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{244, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->103854334]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"%", "[", "i", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->273666884],

Cell[BoxData[
 RowBox[{
  RowBox[{"InterpolatingFunction", "::", "\<\"dmval\"\>"}], ":", 
  " ", "\<\"Input value \\!\\({6}\\) lies outside the range of data in the \
interpolating function. Extrapolation will be used. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InterpolatingFunction/dmval\\\", \
ButtonNote -> \\\"InterpolatingFunction::dmval\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellID->276148536],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "4", ",", 
   RowBox[{"-", "2"}], ",", "1", ",", "30"}], "}"}]], "Output",
 ImageSize->{131, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->40929162]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->596791667],

Cell["\<\
With the default choice of order, at least 4 points are needed in each \
dimension:\
\>", "ExampleText",
 CellID->21143964],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Interpolation", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "4"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32682846],

Cell[BoxData[
 RowBox[{
  RowBox[{"Interpolation", "::", "\<\"inhr\"\>"}], ":", 
  " ", "\<\"Requested order is too high; order has been reduced to \
\\!\\({2}\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Interpolation/inhr\\\", ButtonNote -> \
\\\"Interpolation::inhr\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->487562523],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{244, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12492180]
}, Open  ]],

Cell["With a lower order, fewer points are needed:", "ExampleText",
 CellID->586348783],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Interpolation", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4"}], "}"}], ",", 
   RowBox[{"InterpolationOrder", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->335729401],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{244, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->36269360]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->245084543],

Cell["\<\
The interpolation function will always be continuous, but may not be \
differentiable:\
\>", "ExampleText",
 CellID->244612626],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"Interpolation", "[", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", "10"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15443498],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1.`", ",", "10.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{265, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24004347]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"f", "[", "x", "]"}], ",", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"f", "[", "x", "]"}], ",", "x"}], "]"}]}], "}"}], "]"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->351783099],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->722969784]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25868],

Cell["Interpolate the sequence of primes:", "ExampleText",
 CellID->7936034],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"Interpolation", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Prime", "[", "n", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "30"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->786550147],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "30"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{251, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->147713023]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "n", "]"}], "-", 
    RowBox[{"f", "[", 
     RowBox[{"n", "-", "1"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "2", ",", "30"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->496939396],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 127},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->249499683]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1369],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListInterpolation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListInterpolation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FunctionInterpolation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FunctionInterpolation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InterpolatingPolynomial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InterpolatingPolynomial"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Fit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Fit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindFit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindFit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Quantile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quantile"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Nearest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Nearest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InterpolatingFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InterpolatingFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Piecewise",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Piecewise"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListLinePlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListLinePlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListPlot3D"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23499]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18219],

Cell[TextData[ButtonBox["Approximate Functions and Interpolation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ApproximateFunctionsAndInterpolation"]], "Tutorials",
 CellID->4796]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Interpolation",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Interpolation"],
     None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->108662588],

Cell[TextData[ButtonBox["Curve Fitting & Approximate Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CurveFittingAndApproximateFunctions"]], "MoreAbout",\

 CellID->858289768],

Cell[TextData[ButtonBox["Data Transforms and Smoothing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataTransformsAndSmoothing"]], "MoreAbout",
 CellID->733175073],

Cell[TextData[ButtonBox["Math & Counting Operations on Lists",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathematicalAndCountingOperationsOnLists"]], "MoreAbout",
 CellID->47798868],

Cell[TextData[ButtonBox["Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalData"]], "MoreAbout",
 CellID->32497920],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->94781786]
}, Open  ]],

Cell["New in 2  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Interpolation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 49, 23.3532568}", "context" -> "System`", 
    "keywords" -> {
     "approximation of functions", "bezier curve", "bilinear interpolation", 
      "b-spline", "b spline", "cubic spline", "curve fitting", 
      "extrapolation", "interp", "interpolate data", "interpolate equation", 
      "interpolate formula", "interpolate numbers", "interpolate table", 
      "linear interpolation", "splines"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Interpolation[{f_1, f_2, ...}] constructs an interpolation of the \
function values f_i, assumed to correspond to x values 1, 2, ... . \
Interpolation[{{x_1, f_1}, {x_2, f_2}, ...}] constructs an interpolation of \
the function values f_i corresponding to x values x_i. Interpolation[{{{x_1, \
y_1, ...}, f_1}, {{x_2, y_2, ...}, f_2}, ...}] constructs an interpolation of \
multidimensional data. Interpolation[{{{x_1, ...}, f_1, df_1, ...}, ...}] \
constructs an interpolation that reproduces derivatives as well as function \
values.", "synonyms" -> {}, "title" -> "Interpolation", "type" -> "Symbol", 
    "uri" -> "ref/Interpolation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[18716, 549, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->407295553]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 981309, 17819}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3811, 83, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4434, 110, 4197, 83, 70, "ObjectNameGrid"],
Cell[8634, 195, 4619, 143, 70, "Usage",
 CellID->18504]
}, Open  ]],
Cell[CellGroupData[{
Cell[13290, 343, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[13768, 360, 398, 12, 70, "Notes",
 CellID->87807088],
Cell[14169, 374, 482, 16, 70, "Notes",
 CellID->165789745],
Cell[14654, 392, 244, 8, 70, "Notes",
 CellID->28445701],
Cell[14901, 402, 332, 11, 70, "Notes",
 CellID->122666961],
Cell[15236, 415, 316, 13, 70, "Notes",
 CellID->470674586],
Cell[15555, 430, 129, 4, 70, "Notes",
 CellID->44352622],
Cell[15687, 436, 839, 28, 70, "Notes",
 CellID->719953730],
Cell[16529, 466, 244, 7, 70, "Notes",
 CellID->2156],
Cell[16776, 475, 257, 8, 70, "Notes",
 CellID->29624],
Cell[17036, 485, 246, 10, 70, "Notes",
 CellID->5870],
Cell[17285, 497, 274, 10, 70, "Notes",
 CellID->42],
Cell[17562, 509, 526, 17, 70, "Notes",
 CellID->1352],
Cell[18091, 528, 588, 16, 70, "Notes",
 CellID->563880862]
}, Closed]],
Cell[CellGroupData[{
Cell[18716, 549, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->407295553],
Cell[CellGroupData[{
Cell[19101, 563, 148, 5, 70, "ExampleSection",
 CellID->330046050],
Cell[19252, 570, 111, 3, 70, "ExampleText",
 CellID->27477696],
Cell[CellGroupData[{
Cell[19388, 577, 225, 7, 28, "Input",
 CellID->416760629],
Cell[19616, 586, 356, 13, 36, "Output",
 CellID->143985929]
}, Open  ]],
Cell[19987, 602, 90, 1, 70, "ExampleText",
 CellID->185769659],
Cell[CellGroupData[{
Cell[20102, 607, 99, 3, 28, "Input",
 CellID->144559998],
Cell[20204, 612, 164, 5, 36, "Output",
 CellID->527350535]
}, Open  ]],
Cell[20383, 620, 75, 1, 70, "ExampleText",
 CellID->442754601],
Cell[CellGroupData[{
Cell[20483, 625, 211, 7, 28, "Input",
 CellID->820225710],
Cell[20697, 634, 2355, 43, 145, "Output",
 Evaluatable->False,
 CellID->65217831]
}, Open  ]],
Cell[23067, 680, 73, 1, 70, "ExampleText",
 CellID->41725207],
Cell[CellGroupData[{
Cell[23165, 685, 255, 8, 28, "Input",
 CellID->228623325],
Cell[23423, 695, 2470, 45, 145, "Output",
 Evaluatable->False,
 CellID->661489861]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25942, 746, 216, 7, 70, "ExampleSection",
 CellID->19473],
Cell[26161, 755, 168, 6, 70, "ExampleText",
 CellID->774922236],
Cell[CellGroupData[{
Cell[26354, 765, 470, 16, 70, "Input",
 CellID->150112961],
Cell[26827, 783, 359, 13, 36, "Output",
 CellID->65453048]
}, Open  ]],
Cell[CellGroupData[{
Cell[27223, 801, 211, 7, 70, "Input",
 CellID->120115688],
Cell[27437, 810, 2502, 45, 70, "Output",
 Evaluatable->False,
 CellID->306188865]
}, Open  ]],
Cell[29954, 858, 125, 3, 70, "ExampleDelimiter",
 CellID->240595055],
Cell[30082, 863, 194, 8, 70, "ExampleText",
 CellID->276002587],
Cell[CellGroupData[{
Cell[30301, 875, 298, 10, 70, "Input",
 CellID->16646568],
Cell[30602, 887, 809, 25, 54, "Output",
 CellID->113795215]
}, Open  ]],
Cell[31426, 915, 66, 1, 70, "ExampleText",
 CellID->608429169],
Cell[CellGroupData[{
Cell[31517, 920, 109, 3, 70, "Input",
 CellID->120581792],
Cell[31629, 925, 360, 13, 36, "Output",
 CellID->222638107]
}, Open  ]],
Cell[32004, 941, 74, 1, 70, "ExampleText",
 CellID->121075124],
Cell[CellGroupData[{
Cell[32103, 946, 211, 7, 70, "Input",
 CellID->178188815],
Cell[32317, 955, 3027, 54, 70, "Output",
 Evaluatable->False,
 CellID->282166973]
}, Open  ]],
Cell[35359, 1012, 125, 3, 70, "ExampleDelimiter",
 CellID->344860950],
Cell[35487, 1017, 81, 1, 70, "ExampleText",
 CellID->33307472],
Cell[CellGroupData[{
Cell[35593, 1022, 474, 16, 70, "Input",
 CellID->459054826],
Cell[36070, 1040, 1826, 34, 70, "Output",
 Evaluatable->False,
 CellID->381320888]
}, Open  ]],
Cell[37911, 1077, 87, 1, 70, "ExampleText",
 CellID->51445633],
Cell[CellGroupData[{
Cell[38023, 1082, 132, 4, 70, "Input",
 CellID->182616537],
Cell[38158, 1088, 438, 16, 36, "Output",
 CellID->21614922]
}, Open  ]],
Cell[38611, 1107, 75, 1, 70, "ExampleText",
 CellID->455664976],
Cell[CellGroupData[{
Cell[38711, 1112, 312, 10, 70, "Input",
 CellID->741719701],
Cell[39026, 1124, 158590, 2640, 70, "Output",
 CellID->276152231]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[197665, 3770, 238, 7, 70, "ExampleSection",
 CellID->7681],
Cell[197906, 3779, 94, 1, 70, "ExampleText",
 CellID->55796517],
Cell[CellGroupData[{
Cell[198025, 3784, 505, 17, 70, "Input",
 CellID->89317571],
Cell[198533, 3803, 1245, 38, 71, "Output",
 CellID->238379788]
}, Open  ]],
Cell[199793, 3844, 69, 1, 70, "ExampleText",
 CellID->12252727],
Cell[CellGroupData[{
Cell[199887, 3849, 109, 3, 70, "Input",
 CellID->421319020],
Cell[199999, 3854, 360, 13, 36, "Output",
 CellID->251616289]
}, Open  ]],
Cell[200374, 3870, 66, 1, 70, "ExampleText",
 CellID->285342954],
Cell[CellGroupData[{
Cell[200465, 3875, 211, 7, 70, "Input",
 CellID->368693818],
Cell[200679, 3884, 3844, 67, 70, "Output",
 Evaluatable->False,
 CellID->195132544]
}, Open  ]],
Cell[204538, 3954, 125, 3, 70, "ExampleDelimiter",
 CellID->531236255],
Cell[204666, 3959, 111, 3, 70, "ExampleText",
 CellID->55232974],
Cell[CellGroupData[{
Cell[204802, 3966, 810, 26, 70, "Input",
 CellID->132447345],
Cell[205615, 3994, 3932, 122, 207, "Output",
 CellID->314672207]
}, Open  ]],
Cell[CellGroupData[{
Cell[209584, 4121, 109, 3, 70, "Input",
 CellID->167339111],
Cell[209696, 4126, 449, 17, 36, "Output",
 CellID->2691194]
}, Open  ]],
Cell[CellGroupData[{
Cell[210182, 4148, 312, 10, 70, "Input",
 CellID->373759667],
Cell[210497, 4160, 219079, 3649, 70, "Output",
 CellID->5222629]
}, Open  ]],
Cell[429591, 7812, 93, 1, 70, "ExampleText",
 CellID->880954819],
Cell[CellGroupData[{
Cell[429709, 7817, 564, 18, 70, "Input",
 CellID->442663468],
Cell[430276, 7837, 2305, 80, 88, "Output",
 CellID->17410493]
}, Open  ]],
Cell[CellGroupData[{
Cell[432618, 7922, 108, 3, 70, "Input",
 CellID->39043401],
Cell[432729, 7927, 450, 17, 36, "Output",
 CellID->21412089]
}, Open  ]],
Cell[CellGroupData[{
Cell[433216, 7949, 312, 10, 70, "Input",
 CellID->410679765],
Cell[433531, 7961, 204904, 3413, 70, "Output",
 CellID->735132219]
}, Open  ]],
Cell[638450, 11377, 125, 3, 70, "ExampleDelimiter",
 CellID->189741689],
Cell[638578, 11382, 86, 1, 70, "ExampleText",
 CellID->861033046],
Cell[CellGroupData[{
Cell[638689, 11387, 1085, 34, 70, "Input",
 CellID->53401651],
Cell[639777, 11423, 8106, 251, 326, "Output",
 CellID->456663856]
}, Open  ]],
Cell[CellGroupData[{
Cell[647920, 11679, 108, 3, 70, "Input",
 CellID->92305978],
Cell[648031, 11684, 451, 17, 36, "Output",
 CellID->287879084]
}, Open  ]],
Cell[CellGroupData[{
Cell[648519, 11706, 312, 10, 70, "Input",
 CellID->558343926],
Cell[648834, 11718, 228481, 3795, 70, "Output",
 CellID->673973355]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[877364, 15519, 217, 7, 70, "ExampleSection",
 CellID->2933],
Cell[CellGroupData[{
Cell[877606, 15530, 234, 7, 70, "ExampleSubsection",
 CellID->3899],
Cell[877843, 15539, 94, 3, 70, "ExampleText",
 CellID->1098600312],
Cell[CellGroupData[{
Cell[877962, 15546, 432, 14, 70, "Input",
 CellID->32181],
Cell[878397, 15562, 1062, 21, 70, "Output",
 Evaluatable->False,
 CellID->439928068]
}, Open  ]],
Cell[879474, 15586, 125, 3, 70, "ExampleDelimiter",
 CellID->721579376],
Cell[879602, 15591, 71, 1, 70, "ExampleText",
 CellID->148853706],
Cell[CellGroupData[{
Cell[879698, 15596, 435, 14, 70, "Input",
 CellID->34711596],
Cell[880136, 15612, 2628, 47, 70, "Output",
 Evaluatable->False,
 CellID->153099232]
}, Open  ]],
Cell[882779, 15662, 125, 3, 70, "ExampleDelimiter",
 CellID->695303616],
Cell[882907, 15667, 74, 1, 70, "ExampleText",
 CellID->691042944],
Cell[CellGroupData[{
Cell[883006, 15672, 432, 14, 70, "Input",
 CellID->27222],
Cell[883441, 15688, 2786, 50, 70, "Output",
 Evaluatable->False,
 CellID->34862974]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[886276, 15744, 238, 7, 70, "ExampleSubsection",
 CellID->19444],
Cell[886517, 15753, 102, 2, 70, "ExampleText",
 CellID->300248066],
Cell[CellGroupData[{
Cell[886644, 15759, 442, 14, 70, "Input",
 CellID->24863694],
Cell[887089, 15775, 5182, 89, 70, "Output",
 Evaluatable->False,
 CellID->120258372]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[892332, 15871, 221, 7, 70, "ExampleSection",
 CellID->395],
Cell[892556, 15880, 67, 1, 70, "ExampleText",
 CellID->751555411],
Cell[CellGroupData[{
Cell[892648, 15885, 191, 6, 70, "Input",
 CellID->7840],
Cell[892842, 15893, 359, 13, 36, "Output",
 CellID->3064585]
}, Open  ]],
Cell[CellGroupData[{
Cell[893238, 15911, 208, 7, 70, "Input",
 CellID->26997],
Cell[893449, 15920, 4731, 82, 70, "Output",
 Evaluatable->False,
 CellID->677937715]
}, Open  ]],
Cell[898195, 16005, 125, 3, 70, "ExampleDelimiter",
 CellID->346675374],
Cell[898323, 16010, 95, 1, 70, "ExampleText",
 CellID->291585353],
Cell[CellGroupData[{
Cell[898443, 16015, 570, 19, 70, "Input",
 CellID->163563753],
Cell[899016, 16036, 440, 16, 36, "Output",
 CellID->15344431]
}, Open  ]],
Cell[CellGroupData[{
Cell[899493, 16057, 314, 10, 70, "Input",
 CellID->239276399],
Cell[899810, 16069, 46389, 765, 70, "Output",
 Evaluatable->False,
 CellID->89318677]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[946248, 16840, 233, 7, 70, "ExampleSection",
 CellID->16914],
Cell[946484, 16849, 114, 3, 70, "ExampleText",
 CellID->166409219],
Cell[946601, 16854, 205, 7, 70, "Input",
 CellID->420782050],
Cell[CellGroupData[{
Cell[946831, 16865, 133, 4, 70, "Input",
 CellID->4436254],
Cell[946967, 16871, 356, 13, 36, "Output",
 CellID->285373183]
}, Open  ]],
Cell[CellGroupData[{
Cell[947360, 16889, 313, 10, 70, "Input",
 CellID->552629468],
Cell[947676, 16901, 2526, 45, 70, "Output",
 Evaluatable->False,
 CellID->310025950]
}, Open  ]],
Cell[950217, 16949, 125, 3, 70, "ExampleDelimiter",
 CellID->352357730],
Cell[950345, 16954, 88, 1, 70, "ExampleText",
 CellID->2097121],
Cell[CellGroupData[{
Cell[950458, 16959, 242, 7, 70, "Input",
 CellID->298476801],
Cell[950703, 16968, 355, 13, 36, "Output",
 CellID->56911786]
}, Open  ]],
Cell[CellGroupData[{
Cell[951095, 16986, 157, 5, 70, "Input",
 CellID->106845073],
Cell[951255, 16993, 390, 14, 36, "Output",
 CellID->89962855]
}, Open  ]],
Cell[951660, 17010, 92, 1, 70, "ExampleText",
 CellID->182944783],
Cell[CellGroupData[{
Cell[951777, 17015, 261, 9, 70, "Input",
 CellID->40452516],
Cell[952041, 17026, 4003, 70, 70, "Output",
 Evaluatable->False,
 CellID->151801752]
}, Open  ]],
Cell[CellGroupData[{
Cell[956081, 17101, 225, 7, 70, "Input",
 CellID->811099943],
Cell[956309, 17110, 613, 11, 70, "Message",
 CellID->413577860],
Cell[956925, 17123, 227, 7, 36, "Output",
 CellID->157514331]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[957201, 17136, 226, 7, 70, "ExampleSection",
 CellID->16429],
Cell[957430, 17145, 103, 2, 70, "ExampleText",
 CellID->103589623],
Cell[CellGroupData[{
Cell[957558, 17151, 205, 6, 70, "Input",
 CellID->87269104],
Cell[957766, 17159, 356, 13, 36, "Output",
 CellID->103854334]
}, Open  ]],
Cell[CellGroupData[{
Cell[958159, 17177, 202, 7, 70, "Input",
 CellID->273666884],
Cell[958364, 17186, 487, 9, 70, "Message",
 CellID->276148536],
Cell[958854, 17197, 263, 8, 36, "Output",
 CellID->40929162]
}, Open  ]],
Cell[959132, 17208, 125, 3, 70, "ExampleDelimiter",
 CellID->596791667],
Cell[959260, 17213, 133, 4, 70, "ExampleText",
 CellID->21143964],
Cell[CellGroupData[{
Cell[959418, 17221, 165, 5, 70, "Input",
 CellID->32682846],
Cell[959586, 17228, 412, 8, 70, "Message",
 CellID->487562523],
Cell[960001, 17238, 355, 13, 36, "Output",
 CellID->12492180]
}, Open  ]],
Cell[960371, 17254, 87, 1, 70, "ExampleText",
 CellID->586348783],
Cell[CellGroupData[{
Cell[960483, 17259, 238, 7, 70, "Input",
 CellID->335729401],
Cell[960724, 17268, 355, 13, 36, "Output",
 CellID->36269360]
}, Open  ]],
Cell[961094, 17284, 125, 3, 70, "ExampleDelimiter",
 CellID->245084543],
Cell[961222, 17289, 137, 4, 70, "ExampleText",
 CellID->244612626],
Cell[CellGroupData[{
Cell[961384, 17297, 195, 6, 70, "Input",
 CellID->15443498],
Cell[961582, 17305, 360, 13, 36, "Output",
 CellID->24004347]
}, Open  ]],
Cell[CellGroupData[{
Cell[961979, 17323, 400, 14, 70, "Input",
 CellID->351783099],
Cell[962382, 17339, 4775, 82, 70, "Output",
 Evaluatable->False,
 CellID->722969784]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[967206, 17427, 224, 7, 70, "ExampleSection",
 CellID->25868],
Cell[967433, 17436, 76, 1, 70, "ExampleText",
 CellID->7936034],
Cell[CellGroupData[{
Cell[967534, 17441, 279, 9, 70, "Input",
 CellID->786550147],
Cell[967816, 17452, 357, 13, 36, "Output",
 CellID->147713023]
}, Open  ]],
Cell[CellGroupData[{
Cell[968210, 17470, 293, 10, 70, "Input",
 CellID->496939396],
Cell[968506, 17482, 5312, 91, 70, "Output",
 Evaluatable->False,
 CellID->249499683]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[973879, 17580, 310, 9, 70, "SeeAlsoSection",
 CellID->1369],
Cell[974192, 17591, 2756, 98, 70, "SeeAlso",
 CellID->23499]
}, Open  ]],
Cell[CellGroupData[{
Cell[976985, 17694, 314, 9, 70, "TutorialsSection",
 CellID->18219],
Cell[977302, 17705, 188, 4, 70, "Tutorials",
 CellID->4796]
}, Open  ]],
Cell[CellGroupData[{
Cell[977527, 17714, 305, 8, 70, "RelatedLinksSection"],
Cell[977835, 17724, 371, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[978243, 17741, 319, 9, 70, "MoreAboutSection",
 CellID->108662588],
Cell[978565, 17752, 186, 4, 70, "MoreAbout",
 CellID->858289768],
Cell[978754, 17758, 167, 3, 70, "MoreAbout",
 CellID->733175073],
Cell[978924, 17763, 189, 4, 70, "MoreAbout",
 CellID->47798868],
Cell[979116, 17769, 138, 3, 70, "MoreAbout",
 CellID->32497920],
Cell[979257, 17774, 178, 3, 70, "MoreAbout",
 CellID->94781786]
}, Open  ]],
Cell[979450, 17780, 50, 0, 70, "History"],
Cell[979503, 17782, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

