(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    213178,       4269]
NotebookOptionsPosition[    205445,       4009]
NotebookOutlinePosition[    206997,       4050]
CellTagsIndexPosition[    206910,       4045]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Interpolation" :> 
          Documentation`HelpLookup["paclet:ref/Interpolation"], 
          "FunctionInterpolation" :> 
          Documentation`HelpLookup["paclet:ref/FunctionInterpolation"], 
          "InterpolatingFunction" :> 
          Documentation`HelpLookup["paclet:ref/InterpolatingFunction"], 
          "ListLinePlot" :> 
          Documentation`HelpLookup["paclet:ref/ListLinePlot"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Interpolation\"\>", 
       2->"\<\"FunctionInterpolation\"\>", 3->"\<\"InterpolatingFunction\"\>",
        4->"\<\"ListLinePlot\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Plotting Options" :> 
          Documentation`HelpLookup["paclet:guide/PlottingOptions"], 
          "New in 6.0: Data Visualization" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60DataVisualization"], 
          "New in 6.0: Graphics & Visualization Options" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Plotting Options\"\>", 
       2->"\<\"New in 6.0: Data Visualization\"\>", 
       3->"\<\"New in 6.0: Graphics & Visualization Options\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["InterpolationOrder", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["InterpolationOrder",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/InterpolationOrder"]], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Interpolation",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Interpolation"]], "InlineFormula"],
     ", as well as ",
     Cell[BoxData[
      ButtonBox["ListLinePlot",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ListLinePlot"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["ListPlot3D",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ListPlot3D"]], "InlineFormula"],
     ",  ",
     Cell[BoxData[
      ButtonBox["ListContourPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ListContourPlot"]], "InlineFormula"],
     " and related functions, that specifies what order of interpolation to \
use."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->30713]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"InterpolationOrder", "->", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " specifies that polynomials of degree ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " should be fitted between data points."
}], "Notes",
 CellID->12848],

Cell[TextData[{
 "For multidimensional data, the polynomials are taken to be of degree ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " in each variable."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->24791691],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"InterpolationOrder", "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 " specifies that data points should be joined without interpolation."
}], "Notes",
 CellID->160962568],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"InterpolationOrder", "->", "0"}]], "InlineFormula"],
 " yields a collection of flat regions, with steps at each data point. "
}], "Notes",
 CellID->177275586],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"InterpolationOrder", "->", "1"}]], "InlineFormula"],
 " joins data points with straight lines in 2D, and with piecewise polygonal \
surface elements in 3D."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->56808198],

Cell["\<\
Higher interpolation orders generally lead to increasingly smooth curves or \
surfaces.\
\>", "Notes",
 CellID->84017054],

Cell[TextData[{
 "In functions such as ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"InterpolationOrder", "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 " specifies that the interpolation order should be chosen to be the same as \
the order of the underlying solution method."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->10369318]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->274277503],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->261709279],

Cell["Use different interpolation orders for curves: ", "ExampleText",
 CellID->427779188],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "0"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->382025405],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListLinePlot", "[", 
    RowBox[{"data", ",", " ", 
     RowBox[{"InterpolationOrder", "\[Rule]", "n"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "3"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->492389364],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{0., 0.}, {1., 0.}, {1., 2.}, {3., 2.}, {3., 4.}, {4., 4.}, {
       4., 2.}, {6., 2.}, {6., 0.}}]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 6.}, {0., 4.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], 
      LineBox[{{0., 0.}, {1., 2.}, {3., 4.}, {4., 2.}, {6., 0.}}]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 6.}, {0., 4.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{}, {}, 
     {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw9lQs0lGkYx8cYY8ZgjNvURiFlu6mzu6dVqedJdZpK5TbKXalEqHUJpVLL
ZEOUWnKp3CIkRrmlKCO1q8VGjNQkIps70eTStjvv7nvOd57vnO983/e+z///
/z36ew9b7adSKBSPr9c/9d9l5Wcqu3GpENMP71fzi4UjonbLgu03YOXpg+1C
biqImE5GhrolIHa/x9mcngMhn/dbeww+BA3rvNFwXyFsveC0qLfoCXjyx0y6
RkrgOo//gdFWD/tGmJ36LffhU4xgQnL7OSQW6K1r5DyCpZEGNWdSWyDdK7B2
n08NJF92/uV91UuY5hVZnZB/Cid2RQcK6G9g756ZDPPndXDyUFJDgNlbEB58
uJ56pAHiBFsWVMV1gav9XbsPl/+E5GzFbZ3SbrioMRRyrL0JvBs3cZ38e0E3
jX7+ycYWaKX4u+RS++CdxvnDA/ViqFpJlW7LGIDco3NoCqfawXdVgaNz3hBY
tG4wXmAtgVj7L+X32SPAn7/jfdHCDsg8uZAqHzIKT3rau31L3kJy5iud/qEx
CKiaRXN07IID9e0fV/uMg8kP5oWTWt0gmXwZmDs6AfK/PXR53dUD0sVx0dOh
UqhmiEJjn/ZCimO5/pDWJLgFpoRfFX2A4ljmPDPhFDQnJ0guveiHlbUmR4T8
GZDpMkQqBXMcwrOO6w3DTyk9ljatFKxnWTIk20bg9prJfvUiOUyi/gGc06Pg
1/aAuTuGisu/cz8kfTAGh4KL28BLHh9Enc0+SRuHnbMO/NrNo6E7LVEzwmIC
GootfQ8aKqBtJPPZVOonSLWZTu+YVsAKjfWD1RNSODnc5+rTRMfimNwEkcUk
cKIzXi/OUsRjw0Xd73KngGuUbfV9AAMNl9SMqzJmYE3l8ZH0tUzsMN7avXDf
F1jJTx9N+MJE3wlbj3MuFKx6nxZpXK6EGfm3+iQsOQwPnhkM9WKhQfHryLPF
coiKq23ztJRRKrjWPOZMxasXxKN1d5TRLDFzdxJNHu1m7ZmZ4amguseN9IEb
8miYZJPr3KiCIV67Nu3dREPhbJMVjO2qGK/rU+choWFpXMwj7j1V9Pt4rTbI
XwF7GJL4m9+w0cg7rYZKo+N4UM47sScbn04v5h+PpmNiZ0CHKIeNXnqDNFs1
RQzj1VQJxGw03JHhRo9SRM8snbI142yUycIgVQ0jaN0DvYcY6EGe/35q1GlV
AwN/Ju9v/DBKiV/GxATyfZ8qYWRuGBM/kv/XBk0WznvBxC6yvyfRV4ySDZSw
hOy/L2j39aeeSlhIzicskm+wuK2E88n5L5Uc8GwbUkJ70h/VGfP57BUsvE76
l0A5kx/vzfq/v0UmjZU6OSyMIP1vnUdnbe5moYjoc2Z534ZKA2VcS/Rb1rFj
rrHrVx2Ivjb50u2m15RRl+h/VK1UcPGNMuoQf7BO80PEhioYQfwTG5zytsxL
BQuJv0L9HLzbS1VQQvy36719Qy9TFV2IPy9Yuleec1XFE8S/Wd+aD7jfV0UB
8Te3p0ltsT4bRcT/LvRnbcFRbBSQfPynyxfZAqfKshatdWoIJF920nPUDaFq
WEvyVzijaL78sRrmkXzq6tWcOsPmoOISWX7t8m09uhw42E/yrfPZomkqh4P+
JP8LbHhRflMcLCB8WKTS6Di0Ux3LCD96Ak5x5mSqYyrhi5akJyBpUh3DCH+O
XLnKn22tgZ2ET8KPP4aY5mqggpyMX3EbeXfz5DUxnvCt4YVbHcdRE0WEf3rT
c6M17mhiOeHjeoZqtR1LC9MIP//i1ayK2qOFNwlfm9niCqtiLRwm/K269YrL
Z2pjEOGzm5+79hp7bTSLlfE7sFApLC9bG3lbZHy/W+qw1HJMG98Q/reLB9oa
TLmoPCmbD2n7dzs8P83FZiXZ/KjOWxpMqeZiyWPZfJHJwpXpFOVT8TdaBAIj

       "]]}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 5.999999999999999}, {-1.3247595295057257`*^-17, 4.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{491, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->469672195]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1761758280],

Cell["Use different interpolation orders for surfaces: ", "ExampleText",
 CellID->366887124],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", " ", "y"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "4", ",", "0.5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "4", ",", "0.5"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1694724436],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListPlot3D", "[", 
    RowBox[{"data", ",", 
     RowBox[{"InterpolationOrder", "\[Rule]", "n"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "3"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->846342531],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{487, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->1632815]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->449166033],

Cell[TextData[{
 "Use different interpolation orders when constructing an ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->132922510],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "0"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->176688483],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "@", 
      RowBox[{
       RowBox[{"Interpolation", "[", 
        RowBox[{"data", ",", 
         RowBox[{"InterpolationOrder", "\[Rule]", "n"}]}], "]"}], "[", "x", 
       "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "6"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "3"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->283451882],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{487, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->237147413]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30932099],

Cell["\<\
Use piecewise quintic interpolation to approximate the sine function:\
\>", "ExampleText",
 CellID->18143327],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ifun", " ", "=", " ", 
  RowBox[{"Interpolation", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"Sin", "[", 
         RowBox[{"\[Pi]", " ", "x"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "1", ",", ".1"}], "}"}]}], "]"}], ",", 
    RowBox[{"InterpolationOrder", "\[Rule]", "5"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->472983925],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{258, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->460230588]
}, Open  ]],

Cell["Show the approximation error:", "ExampleText",
 CellID->8777866],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"\[Pi]", " ", "x"}], "]"}], "-", 
    RowBox[{"ifun", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->120150554],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 85},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->137095402]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->47935291],

Cell["\<\
Show the smoothing effect of higher interpolation order in plotting:\
\>", "ExampleText",
 CellID->46063480],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0", ",", "0"}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->295336130],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListLinePlot", "[", 
    RowBox[{"data", ",", " ", 
     RowBox[{"InterpolationOrder", "\[Rule]", "order"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"order", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->150516518],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{448, 74},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->455608167]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->106647203],

Cell[TextData[{
 "Show the smoothing effect of higher interpolation order for ",
 Cell[BoxData[
  ButtonBox["GCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GCD"]], "InlineFormula"],
 " data:"
}], "ExampleText",
 CellID->67337716],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", " ", "=", " ", 
   RowBox[{"Array", "[", 
    RowBox[{"GCD", ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "10"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->583648735],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ListPlot3D", "[", 
    RowBox[{"data", ",", 
     RowBox[{"InterpolationOrder", "\[Rule]", "order"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}]}], ",", 
     RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"order", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "3", ",", "9"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->74364391],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{326, 252},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->83629973]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->143071983],

Cell[TextData[{
 "Get a solution that uses interpolation of the same order as the method from \
",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->4328395],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"a", " ", "=", " ", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "'"}], "[", "t", "]"}], " ", "\[Equal]", " ", 
        RowBox[{"y", "[", "t", "]"}]}], ",", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"y", "'"}], "[", "t", "]"}], "\[Equal]", " ", 
        RowBox[{"-", 
         RowBox[{"x", "[", "t", "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}], ",", " ", 
       RowBox[{
        RowBox[{"y", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "1000"}], "}"}], ",", 
     RowBox[{"InterpolationOrder", "\[Rule]", "All"}]}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->55047586],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.3430000000000207`", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", 
       TagBox[
        RowBox[{"InterpolatingFunction", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{"0.`", ",", "1000.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}],
          "]"}],
        False,
        Editable->False]}], ",", 
      RowBox[{"y", "\[Rule]", 
       TagBox[
        RowBox[{"InterpolatingFunction", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{"0.`", ",", "1000.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}],
          "]"}],
        False,
        Editable->False]}]}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{376, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->436939266]
}, Open  ]],

Cell["\<\
This is more time consuming than the default interpolation order used:\
\>", "ExampleText",
 CellID->842529970],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"d", " ", "=", " ", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "'"}], "[", "t", "]"}], " ", "\[Equal]", " ", 
        RowBox[{"y", "[", "t", "]"}]}], ",", " ", 
       RowBox[{
        RowBox[{
         RowBox[{"y", "'"}], "[", "t", "]"}], "\[Equal]", " ", 
        RowBox[{"-", 
         RowBox[{"x", "[", "t", "]"}]}]}], ",", 
       RowBox[{
        RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}], ",", " ", 
       RowBox[{
        RowBox[{"y", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "1000"}], "}"}]}], "]"}]}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->32480185],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.12499999999997213`", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", 
       TagBox[
        RowBox[{"InterpolatingFunction", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{"0.`", ",", "1000.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}],
          "]"}],
        False,
        Editable->False]}], ",", 
      RowBox[{"y", "\[Rule]", 
       TagBox[
        RowBox[{"InterpolatingFunction", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{"0.`", ",", "1000.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}],
          "]"}],
        False,
        Editable->False]}]}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{376, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->21328256]
}, Open  ]],

Cell["It is much better in between steps:", "ExampleText",
 CellID->605010152],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"First", "[", 
        RowBox[{
         RowBox[{"x", "[", "t", "]"}], " ", "/.", " ", "a"}], "]"}], ",", 
       RowBox[{"First", "[", 
        RowBox[{
         RowBox[{"x", "[", "t", "]"}], "/.", " ", "d"}], "]"}]}], "}"}], " ", 
     "-", " ", 
     RowBox[{"Cos", "[", "t", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", "All"}], ",", " ", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Directive", "[", 
       RowBox[{"Thick", ",", " ", "Blue"}], "]"}], ",", "Red"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->656660252],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 82},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->150995416]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->139142986],

Cell["Very high order interpolation can lead to large errors:", "ExampleText",
 CellID->662263906],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], " ", ":=", " ", 
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"25", " ", 
       RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->164685498],

Cell[BoxData[
 RowBox[{
  RowBox[{"points", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"f", "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", ".1"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->844477502],

Cell["Interpolate with order 20:", "ExampleText",
 CellID->252621354],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"if20", " ", "=", " ", 
  RowBox[{"Interpolation", "[", 
   RowBox[{"points", ",", " ", 
    RowBox[{"InterpolationOrder", "\[Rule]", "20"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->390361133],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1.`"}], ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
   "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{266, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->185417501]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"if20", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->83759474],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->529925840]
}, Open  ]],

Cell["\<\
Piecewise interpolation with lower order makes a much better approximation:\
\>", "ExampleText",
 CellID->489623730],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"if3", " ", "=", " ", 
   RowBox[{"Interpolation", "[", "points", "]"}]}], ";"}], "\n", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"if3", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->123386240],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->142656961]
}, Open  ]],

Cell["\<\
Show the approximation error for different interpolation orders:\
\>", "ExampleText",
 CellID->460044594],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ifn", "=", 
     RowBox[{"Interpolation", "[", 
      RowBox[{"points", ",", 
       RowBox[{"InterpolationOrder", "\[Rule]", "order"}]}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"ifn", "[", "x", "]"}], " ", "-", " ", 
       RowBox[{"f", "[", "x", "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"BaselinePosition", "\[Rule]", "Axis"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"order", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "9", ",", "12"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->216312036],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{487, 125},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[6]=",
 CellID->15819951]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8402],

Cell["\<\
Zero order interpolation, with Voronoi cells having the constant value:\
\>", "ExampleText",
 CellID->416090439],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"100", ",", "3"}], "}"}]}], "]"}], ",", 
   RowBox[{"InterpolationOrder", "->", "0"}], ",", 
   RowBox[{"Filling", "->", "Axis"}], ",", 
   RowBox[{"Mesh", "->", "None"}], ",", 
   RowBox[{"PlotRange", "->", "All"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<Rainbow\>\""}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->53176001],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{285, 226},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->610095447]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1914],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Interpolation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Interpolation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FunctionInterpolation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FunctionInterpolation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InterpolatingFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InterpolatingFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListLinePlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListLinePlot"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8765]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with InterpolationOrder",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=\
InterpolationOrder"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Plotting Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PlottingOptions"]], "MoreAbout",
 CellID->109859477],

Cell[TextData[ButtonBox["New in 6.0: Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataVisualization"]], "MoreAbout",
 CellID->595263145],

Cell[TextData[ButtonBox["New in 6.0: Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "MoreAbout",
 CellID->355552896]
}, Open  ]],

Cell["New in 3  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InterpolationOrder - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 49, 32.1659824}", "context" -> "System`", 
    "keywords" -> {
     "dense interpolation", "dense output", "Hermite interpolation", 
      "method order interpolation", "order of interpolation", 
      "piecewise interpolation", "spline interpolation"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "InterpolationOrder is an option for Interpolation, as well as \
ListLinePlot, ListPlot3D, ListContourPlot and related functions, that \
specifies what order of interpolation to use.", 
    "synonyms" -> {"interpolation order"}, "title" -> "InterpolationOrder", 
    "type" -> "Symbol", "uri" -> "ref/InterpolationOrder"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10698, 292, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->274277503]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 206766, 4038}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1988, 45, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2611, 72, 4202, 83, 70, "ObjectNameGrid"],
Cell[6816, 157, 1127, 34, 70, "Usage",
 CellID->30713]
}, Open  ]],
Cell[CellGroupData[{
Cell[7980, 196, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8458, 213, 285, 9, 70, "Notes",
 CellID->12848],
Cell[8746, 224, 330, 9, 70, "Notes",
 CellID->24791691],
Cell[9079, 235, 274, 8, 70, "Notes",
 CellID->160962568],
Cell[9356, 245, 200, 5, 70, "Notes",
 CellID->177275586],
Cell[9559, 252, 360, 9, 70, "Notes",
 CellID->56808198],
Cell[9922, 263, 131, 4, 70, "Notes",
 CellID->84017054],
Cell[10056, 269, 605, 18, 70, "Notes",
 CellID->10369318]
}, Closed]],
Cell[CellGroupData[{
Cell[10698, 292, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->274277503],
Cell[CellGroupData[{
Cell[11083, 306, 148, 5, 70, "ExampleSection",
 CellID->261709279],
Cell[11234, 313, 90, 1, 70, "ExampleText",
 CellID->427779188],
Cell[11327, 316, 467, 16, 70, "Input",
 CellID->382025405],
Cell[CellGroupData[{
Cell[11819, 336, 358, 11, 28, "Input",
 CellID->492389364],
Cell[12180, 349, 3339, 75, 130, "Output",
 CellID->469672195]
}, Open  ]],
Cell[15534, 427, 126, 3, 70, "ExampleDelimiter",
 CellID->1761758280],
Cell[15663, 432, 92, 1, 70, "ExampleText",
 CellID->366887124],
Cell[15758, 435, 395, 13, 70, "Input",
 CellID->1694724436],
Cell[CellGroupData[{
Cell[16178, 452, 399, 12, 28, "Input",
 CellID->846342531],
Cell[16580, 466, 38629, 637, 139, "Output",
 Evaluatable->False,
 CellID->1632815]
}, Open  ]],
Cell[55224, 1106, 125, 3, 70, "ExampleDelimiter",
 CellID->449166033],
Cell[55352, 1111, 266, 8, 70, "ExampleText",
 CellID->132922510],
Cell[55621, 1121, 467, 16, 70, "Input",
 CellID->176688483],
Cell[CellGroupData[{
Cell[56113, 1141, 559, 18, 47, "Input",
 CellID->283451882],
Cell[56675, 1161, 4396, 76, 130, "Output",
 Evaluatable->False,
 CellID->237147413]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[61120, 1243, 219, 7, 70, "ExampleSection",
 CellID->30932099],
Cell[61342, 1252, 119, 3, 70, "ExampleText",
 CellID->18143327],
Cell[CellGroupData[{
Cell[61486, 1259, 478, 14, 70, "Input",
 CellID->472983925],
Cell[61967, 1275, 360, 13, 36, "Output",
 CellID->460230588]
}, Open  ]],
Cell[62342, 1291, 70, 1, 70, "ExampleText",
 CellID->8777866],
Cell[CellGroupData[{
Cell[62437, 1296, 301, 10, 70, "Input",
 CellID->120150554],
Cell[62741, 1308, 3428, 60, 70, "Output",
 Evaluatable->False,
 CellID->137095402]
}, Open  ]],
Cell[66184, 1371, 124, 3, 70, "ExampleDelimiter",
 CellID->47935291],
Cell[66311, 1376, 118, 3, 70, "ExampleText",
 CellID->46063480],
Cell[66432, 1381, 205, 7, 70, "Input",
 CellID->295336130],
Cell[CellGroupData[{
Cell[66662, 1392, 313, 9, 70, "Input",
 CellID->150516518],
Cell[66978, 1403, 4391, 76, 70, "Output",
 Evaluatable->False,
 CellID->455608167]
}, Open  ]],
Cell[71384, 1482, 125, 3, 70, "ExampleDelimiter",
 CellID->106647203],
Cell[71512, 1487, 237, 8, 70, "ExampleText",
 CellID->67337716],
Cell[71752, 1497, 238, 8, 70, "Input",
 CellID->583648735],
Cell[CellGroupData[{
Cell[72015, 1509, 525, 16, 70, "Input",
 CellID->74364391],
Cell[72543, 1527, 63218, 1041, 70, "Output",
 Evaluatable->False,
 CellID->83629973]
}, Open  ]],
Cell[135776, 2571, 125, 3, 70, "ExampleDelimiter",
 CellID->143071983],
Cell[135904, 2576, 257, 9, 70, "ExampleText",
 CellID->4328395],
Cell[CellGroupData[{
Cell[136186, 2589, 904, 27, 70, "Input",
 CellID->55047586],
Cell[137093, 2618, 887, 30, 54, "Output",
 CellID->436939266]
}, Open  ]],
Cell[137995, 2651, 121, 3, 70, "ExampleText",
 CellID->842529970],
Cell[CellGroupData[{
Cell[138141, 2658, 842, 26, 70, "Input",
 CellID->32480185],
Cell[138986, 2686, 887, 30, 54, "Output",
 CellID->21328256]
}, Open  ]],
Cell[139888, 2719, 78, 1, 70, "ExampleText",
 CellID->605010152],
Cell[CellGroupData[{
Cell[139991, 2724, 809, 25, 70, "Input",
 CellID->656660252],
Cell[140803, 2751, 4941, 85, 70, "Output",
 Evaluatable->False,
 CellID->150995416]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[145793, 2842, 230, 7, 70, "ExampleSection",
 CellID->139142986],
Cell[146026, 2851, 98, 1, 70, "ExampleText",
 CellID->662263906],
Cell[146127, 2854, 282, 10, 70, "Input",
 CellID->164685498],
Cell[146412, 2866, 359, 13, 70, "Input",
 CellID->844477502],
Cell[146774, 2881, 69, 1, 70, "ExampleText",
 CellID->252621354],
Cell[CellGroupData[{
Cell[146868, 2886, 228, 6, 70, "Input",
 CellID->390361133],
Cell[147099, 2894, 387, 15, 36, "Output",
 CellID->185417501]
}, Open  ]],
Cell[CellGroupData[{
Cell[147523, 2914, 289, 9, 70, "Input",
 CellID->83759474],
Cell[147815, 2925, 2648, 47, 70, "Output",
 Evaluatable->False,
 CellID->529925840]
}, Open  ]],
Cell[150478, 2975, 126, 3, 70, "ExampleText",
 CellID->489623730],
Cell[CellGroupData[{
Cell[150629, 2982, 345, 11, 70, "Input",
 CellID->123386240],
Cell[150977, 2995, 2783, 50, 70, "Output",
 Evaluatable->False,
 CellID->142656961]
}, Open  ]],
Cell[153775, 3048, 115, 3, 70, "ExampleText",
 CellID->460044594],
Cell[CellGroupData[{
Cell[153915, 3055, 817, 24, 70, "Input",
 CellID->216312036],
Cell[154735, 3081, 7392, 125, 70, "Output",
 Evaluatable->False,
 CellID->15819951]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[162176, 3212, 223, 7, 70, "ExampleSection",
 CellID->8402],
Cell[162402, 3221, 122, 3, 70, "ExampleText",
 CellID->416090439],
Cell[CellGroupData[{
Cell[162549, 3228, 486, 14, 70, "Input",
 CellID->53176001],
Cell[163038, 3244, 39354, 649, 70, "Output",
 Evaluatable->False,
 CellID->610095447]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[202453, 3900, 310, 9, 70, "SeeAlsoSection",
 CellID->1914],
Cell[202766, 3911, 1010, 35, 70, "SeeAlso",
 CellID->8765]
}, Open  ]],
Cell[CellGroupData[{
Cell[203813, 3951, 305, 8, 70, "RelatedLinksSection"],
Cell[204121, 3961, 378, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[204536, 3978, 299, 8, 70, "MoreAboutSection"],
Cell[204838, 3988, 143, 3, 70, "MoreAbout",
 CellID->109859477],
Cell[204984, 3993, 166, 3, 70, "MoreAbout",
 CellID->595263145],
Cell[205153, 3998, 197, 4, 70, "MoreAbout",
 CellID->355552896]
}, Open  ]],
Cell[205365, 4005, 50, 0, 70, "History"],
Cell[205418, 4007, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

