(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23798,        859]
NotebookOptionsPosition[     18949,        697]
NotebookOutlinePosition[     20445,        737]
CellTagsIndexPosition[     20360,        732]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Representing Textual Forms by Boxes" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RepresentingTextualFormsByBoxes"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Representing Textual Forms by Boxes\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Interpretation" :> 
          Documentation`HelpLookup["paclet:ref/Interpretation"], 
          "DynamicSetting" :> 
          Documentation`HelpLookup["paclet:ref/DynamicSetting"], "TagBox" :> 
          Documentation`HelpLookup["paclet:ref/TagBox"], "FormBox" :> 
          Documentation`HelpLookup["paclet:ref/FormBox"], "ToExpression" :> 
          Documentation`HelpLookup["paclet:ref/ToExpression"], "ButtonBox" :> 
          Documentation`HelpLookup["paclet:ref/ButtonBox"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Interpretation\"\>", 
       2->"\<\"DynamicSetting\"\>", 3->"\<\"TagBox\"\>", 4->"\<\"FormBox\"\>",
        5->"\<\"ToExpression\"\>", 
       6->"\<\"ButtonBox\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Defining Custom Notation" :> 
          Documentation`HelpLookup["paclet:guide/DefiningCustomNotation"], 
          "Low-Level Notebook Structure" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookStructure"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Defining Custom Notation\"\>", 
       2->"\<\"Low-Level Notebook Structure\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InterpretationBox", "ObjectName",
 CellID->13196],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InterpretationBox",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InterpretationBox"], "[", 
       RowBox[{
        StyleBox["boxes", "TI"], ",", 
        StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a low-level box construct that displays as ",
     Cell[BoxData[
      StyleBox["boxes", "TI"]], "InlineFormula"],
     " but is interpreted on input as ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21187]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InterpretationBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpretationBox"]], "InlineFormula"],
 " is used in the low-level representation of ",
 Cell[BoxData[
  ButtonBox["Interpretation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Interpretation"]], "InlineFormula"],
 ". Except for low-level notebook expression manipulation, ",
 Cell[BoxData[
  ButtonBox["InterpretationBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpretationBox"]], "InlineFormula"],
 " should not need to be used directly."
}], "Notes",
 CellID->32280],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InterpretationBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpretationBox"]], "InlineFormula"],
 " provides a way to store hidden information in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " output. "
}], "Notes",
 CellID->3355],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InterpretationBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpretationBox"]], "InlineFormula"],
 " is generated sometimes in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " output, and often in ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " output. "
}], "Notes",
 CellID->26943],

Cell["The following options can be given: ", "Notes",
 CellID->17599],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AutoDelete",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AutoDelete"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[TextData[{
     "whether to strip the ",
     Cell[BoxData[
      ButtonBox["InterpretationBox",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/InterpretationBox"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["boxes", "TI"]], "InlineFormula"],
     " is modified "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DeletionWarning",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DeletionWarning"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[TextData[{
     "whether to issue a warning if ",
     Cell[BoxData[
      StyleBox["boxes", "TI"]], "InlineFormula"],
     " is deleted "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Editable",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Editable"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[TextData[{
     "whether to allow ",
     Cell[BoxData[
      StyleBox["boxes", "TI"]], "InlineFormula"],
     " to be edited "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Selectable",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Selectable"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "whether to allow ",
     Cell[BoxData[
      StyleBox["boxes", "TI"]], "InlineFormula"],
     " to be selected "
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->43],

Cell[TextData[{
 "If you modify the displayed form of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InterpretationBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InterpretationBox"], "[", 
   RowBox[{
    StyleBox["boxes", "TI"], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " only ",
 Cell[BoxData[
  StyleBox["boxes", "TI"]], "InlineFormula"],
 " will be modified, and there is no guarantee that correct correspondence \
with ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " will be maintained. "
}], "Notes",
 CellID->19215],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InterpretationBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpretationBox"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldComplete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldComplete"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->32279]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->195072058],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->379995982],

Cell["\<\
Make a formatting structure whose interpretation is not based on its \
appearance:\
\>", "ExampleText",
 CellID->211548304],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InterpretationBox", "[", 
   RowBox[{"\"\<abc\>\"", ",", "0"}], "]"}], "//", "DisplayForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->103315873],

Cell[BoxData[
 TagBox[
  InterpretationBox["abc",
   0],
  DisplayForm]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//DisplayForm=",
 CellID->519896940]
}, Open  ]],

Cell[TextData[{
 "An ",
 Cell[BoxData[
  ButtonBox["InterpretationBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpretationBox"]], "InlineFormula"],
 " is interpreted as the expression in its second argument:"
}], "ExampleText",
 CellID->566359390],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "[", 
  RowBox[{"%", ",", "StandardForm"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->262204972],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->135896033]
}, Open  ]],

Cell["\<\
Copying the interpretation box and using it as input also evaluates the \
hidden interpretation: \
\>", "ExampleText",
 CellID->226035960],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  InterpretationBox["abc",
   0],
  DisplayForm]], "Input",
 CellLabel->"In[3]:=",
 CellID->116624031],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->28577570]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->170575578],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InterpretationBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpretationBox"]], "InlineFormula"],
 " is used in the standard formatting of ",
 Cell[BoxData[
  ButtonBox["Interpretation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Interpretation"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->417301226],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToBoxes", "[", 
   RowBox[{
    RowBox[{"Interpretation", "[", 
     RowBox[{"abc", ",", "0"}], "]"}], ",", "StandardForm"}], "]"}], "//", 
  "FullForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->182437031],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"InterpretationBox", "[", 
    RowBox[{"\"\<abc\>\"", ",", "0"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{191, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->99736935]
}, Open  ]],

Cell[TextData[{
 "The first argument of the ",
 Cell[BoxData[
  ButtonBox["InterpretationBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpretationBox"]], "InlineFormula"],
 " gives its visible format:"
}], "ExampleText",
 CellID->321732698],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Interpretation", "[", 
  RowBox[{"abc", ",", "0"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->122889414],

Cell[BoxData[
 InterpretationBox["abc",
  0]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->106915361]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->240248949],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting for many built-in functions uses ",
 Cell[BoxData[
  ButtonBox["InterpretationBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpretationBox"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->121027838],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToBoxes", "[", 
  RowBox[{
   RowBox[{"EllipticNomeQ", "[", "a", "]"}], ",", "TraditionalForm"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->647043495],

Cell[BoxData[
 RowBox[{"FormBox", "[", 
  RowBox[{
   RowBox[{"RowBox", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"InterpretationBox", "[", 
       RowBox[{"\<\"q\"\>", ",", "EllipticNomeQ", ",", 
        RowBox[{"Editable", "\[Rule]", "False"}], ",", 
        RowBox[{"Selectable", "\[Rule]", "False"}]}], "]"}], ",", "\<\"(\"\>",
       ",", "\<\"a\"\>", ",", "\<\")\"\>"}], "}"}], "]"}], ",", 
   "TraditionalForm"}], "]"}]], "Output",
 ImageSize->{567, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9101275]
}, Open  ]],

Cell[TextData[{
 "In the typeset result, the letter ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 " stands for ",
 Cell[BoxData[
  ButtonBox["EllipticNomeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticNomeQ"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->683899304],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"EllipticNomeQ", "[", "a", "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27232496],

Cell[BoxData[
 FormBox[
  RowBox[{
   InterpretationBox["q",
    EllipticNomeQ,
    Editable->False,
    Selectable->False], "(", "a", ")"}], TraditionalForm]], "Output",
 ImageSize->{24, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TraditionalForm=",
 CellID->175664199]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["InterpretationBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpretationBox"]], "InlineFormula"],
 " allows this form to be used as input without losing its meaning:"
}], "ExampleText",
 CellID->57261212],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{
   InterpretationBox["q",
    EllipticNomeQ,
    Editable->False,
    Selectable->False], "(", "a", ")"}], TraditionalForm]], "Input",
 CellLabel->"In[3]:=",
 CellID->129285842],

Cell[BoxData[
 RowBox[{"EllipticNomeQ", "[", "a", "]"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->31449456]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27618],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Interpretation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Interpretation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DynamicSetting",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DynamicSetting"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TagBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TagBox"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FormBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FormBox"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ButtonBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ButtonBox"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30476]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18513],

Cell[TextData[ButtonBox["Representing Textual Forms by Boxes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RepresentingTextualFormsByBoxes"]], "Tutorials",\

 CellID->9312]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Defining Custom Notation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DefiningCustomNotation"]], "MoreAbout",
 CellID->67942145],

Cell[TextData[ButtonBox["Low-Level Notebook Structure",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookStructure"]], "MoreAbout",
 CellID->144292557]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InterpretationBox - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 49, 35.8848276}", "context" -> "System`", 
    "keywords" -> {
     "hidden box data", "magic cookies", "disambiguation", 
      "interpretation data", "interpretation hints", "parsing hints", 
      "parsing interpretation", "semantic hints", "semantic markup"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "InterpretationBox[boxes, expr] is a low-level box construct that \
displays as boxes but is interpreted on input as expr. ", 
    "synonyms" -> {"interpretation box"}, "title" -> "InterpretationBox", 
    "type" -> "Symbol", "uri" -> "ref/InterpretationBox"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9032, 290, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->195072058]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20217, 725}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2540, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3163, 86, 55, 1, 70, "ObjectName",
 CellID->13196],
Cell[3221, 89, 756, 23, 70, "Usage",
 CellID->21187]
}, Open  ]],
Cell[CellGroupData[{
Cell[4014, 117, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4492, 134, 601, 17, 70, "Notes",
 CellID->32280],
Cell[5096, 153, 294, 10, 70, "Notes",
 CellID->3355],
Cell[5393, 165, 513, 17, 70, "Notes",
 CellID->26943],
Cell[5909, 184, 69, 1, 70, "Notes",
 CellID->17599],
Cell[5981, 187, 2106, 63, 70, "3ColumnTableMod",
 CellID->43],
Cell[8090, 252, 568, 19, 70, "Notes",
 CellID->19215],
Cell[8661, 273, 334, 12, 70, "Notes",
 CellID->32279]
}, Closed]],
Cell[CellGroupData[{
Cell[9032, 290, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->195072058],
Cell[CellGroupData[{
Cell[9417, 304, 148, 5, 70, "ExampleSection",
 CellID->379995982],
Cell[9568, 311, 133, 4, 70, "ExampleText",
 CellID->211548304],
Cell[CellGroupData[{
Cell[9726, 319, 181, 5, 28, "Input",
 CellID->103315873],
Cell[9910, 326, 226, 9, 50, "Output",
 CellID->519896940]
}, Open  ]],
Cell[10151, 338, 260, 8, 70, "ExampleText",
 CellID->566359390],
Cell[CellGroupData[{
Cell[10436, 350, 142, 4, 28, "Input",
 CellID->262204972],
Cell[10581, 356, 158, 5, 36, "Output",
 CellID->135896033]
}, Open  ]],
Cell[10754, 364, 148, 4, 70, "ExampleText",
 CellID->226035960],
Cell[CellGroupData[{
Cell[10927, 372, 125, 6, 70, "Input",
 CellID->116624031],
Cell[11055, 380, 157, 5, 36, "Output",
 CellID->28577570]
}, Open  ]],
Cell[11227, 388, 125, 3, 70, "ExampleDelimiter",
 CellID->170575578],
Cell[11355, 393, 379, 12, 70, "ExampleText",
 CellID->417301226],
Cell[CellGroupData[{
Cell[11759, 409, 243, 8, 70, "Input",
 CellID->182437031],
Cell[12005, 419, 369, 13, 50, "Output",
 CellID->99736935]
}, Open  ]],
Cell[12389, 435, 252, 8, 70, "ExampleText",
 CellID->321732698],
Cell[CellGroupData[{
Cell[12666, 447, 135, 4, 70, "Input",
 CellID->122889414],
Cell[12804, 453, 186, 7, 36, "Output",
 CellID->106915361]
}, Open  ]],
Cell[13005, 463, 125, 3, 70, "ExampleDelimiter",
 CellID->240248949],
Cell[13133, 468, 388, 13, 70, "ExampleText",
 CellID->121027838],
Cell[CellGroupData[{
Cell[13546, 485, 184, 6, 70, "Input",
 CellID->647043495],
Cell[13733, 493, 577, 16, 71, "Output",
 CellID->9101275]
}, Open  ]],
Cell[14325, 512, 308, 11, 70, "ExampleText",
 CellID->683899304],
Cell[CellGroupData[{
Cell[14658, 527, 149, 5, 70, "Input",
 CellID->27232496],
Cell[14810, 534, 317, 11, 50, "Output",
 CellID->175664199]
}, Open  ]],
Cell[15142, 548, 268, 8, 70, "ExampleText",
 CellID->57261212],
Cell[CellGroupData[{
Cell[15435, 560, 212, 8, 70, "Input",
 CellID->129285842],
Cell[15650, 570, 197, 6, 36, "Output",
 CellID->31449456]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15908, 583, 311, 9, 70, "SeeAlsoSection",
 CellID->27618],
Cell[16222, 594, 1459, 53, 70, "SeeAlso",
 CellID->30476]
}, Open  ]],
Cell[CellGroupData[{
Cell[17718, 652, 314, 9, 70, "TutorialsSection",
 CellID->18513],
Cell[18035, 663, 178, 4, 70, "Tutorials",
 CellID->9312]
}, Open  ]],
Cell[CellGroupData[{
Cell[18250, 672, 299, 8, 70, "MoreAboutSection"],
Cell[18552, 682, 157, 3, 70, "MoreAbout",
 CellID->67942145],
Cell[18712, 687, 165, 3, 70, "MoreAbout",
 CellID->144292557]
}, Open  ]],
Cell[18892, 693, 27, 0, 70, "History"],
Cell[18922, 695, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

