(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     31848,       1163]
NotebookOptionsPosition[     25023,        921]
NotebookOutlinePosition[     26363,        958]
CellTagsIndexPosition[     26278,        953]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Descriptive Statistics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/DescriptiveStatistics"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Descriptive Statistics\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Quartiles" :> Documentation`HelpLookup["paclet:ref/Quartiles"],
           "QuartileDeviation" :> 
          Documentation`HelpLookup["paclet:ref/QuartileDeviation"], 
          "QuartileSkewness" :> 
          Documentation`HelpLookup["paclet:ref/QuartileSkewness"], "Quantile" :> 
          Documentation`HelpLookup["paclet:ref/Quantile"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Quartiles\"\>", 
       2->"\<\"QuartileDeviation\"\>", 3->"\<\"QuartileSkewness\"\>", 
       4->"\<\"Quantile\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Descriptive Statistics" :> 
          Documentation`HelpLookup["paclet:guide/DescriptiveStatistics"], 
          "New in 6.0: Statistics" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60Statistics"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Descriptive Statistics\"\>", 
       2->"\<\"New in 6.0: Statistics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["InterquartileRange", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InterquartileRange",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InterquartileRange"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the difference between the upper and lower \
quartiles for the elements in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9858]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["InterquartileRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InterquartileRange"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     ButtonBox["Quartiles",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Quartiles"], "[", 
     StyleBox["list", "TI"], "]"}], "[", 
    RowBox[{"[", "3", "]"}], "]"}], "-", 
   RowBox[{
    RowBox[{
     ButtonBox["Quartiles",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Quartiles"], "[", 
     StyleBox["list", "TI"], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1730],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InterquartileRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterquartileRange"]], "InlineFormula"],
 " works with ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->11686772]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->63934531],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->166680514],

Cell["Interquartile range for a list of exact numbers:", "ExampleText",
 CellID->31273586],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InterquartileRange", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "3", ",", "4", ",", "2", ",", "5", ",", "6"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2858],

Cell[BoxData["3"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->167004779]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5044],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InterquartileRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterquartileRange"]], "InlineFormula"],
 " works with any real numeric quantities:"
}], "ExampleText",
 CellID->13924],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InterquartileRange", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Sqrt", "[", "2", "]"}], ",", "E", ",", "Pi", ",", 
    RowBox[{"Pi", "^", "2"}], ",", "1", ",", "2", ",", "3"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19854],

Cell[BoxData[
 RowBox[{"3", "-", 
  SqrtBox["2"], "+", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", 
     SqrtBox["2"]}], ")"}]}], "+", 
  RowBox[{
   FractionBox["3", "4"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "3"}], "+", "\[Pi]"}], ")"}]}]}]], "Output",
 ImageSize->{216, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4278904]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->139342064],

Cell[BoxData["1.5455343184125234`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->59597617]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->64612447],

Cell["Interquartile ranges for columns of a matrix:", "ExampleText",
 CellID->281606070],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InterquartileRange", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"3", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "8"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"7", ",", "8"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->421309609],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["15", "4"], ",", 
   FractionBox["13", "4"]}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{66, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->642966039]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->158391064],

Cell["Obtain results at any precision: ", "ExampleText",
 CellID->160553898],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InterquartileRange", "[", 
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"5", ",", "10", ",", "4", ",", "25", ",", "2", ",", "1"}], "}"}],
     ",", "30"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->190699768],

Cell[BoxData["8.`29.82390874094432"], "Output",
 ImageSize->{214, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->35033140]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->650909219],

Cell["Compute results for a large vector or matrix:", "ExampleText",
 CellID->285474028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InterquartileRange", "[", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"1", ",", 
    RowBox[{"10", "^", "5"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->315224713],

Cell[BoxData["0.500146321462463`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->758622344]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InterquartileRange", "[", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"1", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"10", "^", "4"}], ",", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->594479966],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.49337023384007994`", ",", "0.4965046870890705`", ",", 
   "0.49624254892697395`", ",", "0.49373941462309456`", ",", 
   "0.5013482430446208`"}], "}"}]], "Output",
 ImageSize->{336, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->549576844]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6422],

Cell[TextData[{
 "Compute results for a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->625271644],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "i_"}], "}"}], ":>", "i"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
        RowBox[{"j", "<", "i"}]}], "\[RuleDelayed]", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"i", "+", "j"}], ")"}], "^", "2"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "10"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19878761],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "955", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 955, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "10"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{202, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->452904205]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InterquartileRange", "[", "sp", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->235263230],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "5150", ",", "5250", ",", "5350", ",", "5450", ",", "5550", ",", "5650", 
   ",", "5750", ",", "5850", ",", "5950", ",", "6050"}], "}"}]], "Output",
 ImageSize->{399, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->112931352]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8756],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InterquartileRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterquartileRange"]], "InlineFormula"],
 " is the difference of linearly interpolated ",
 Cell[BoxData[
  ButtonBox["Quantile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quantile"]], "InlineFormula"],
 " values:"
}], "ExampleText",
 CellID->38722882],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"10", ",", "20"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->133352675],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.2496611828041604`", ",", "5.650639442875393`", ",", "7.981558141814162`",
    ",", "9.833397004739332`", ",", "2.796367053614901`", ",", 
   "2.0631432342768496`", ",", "6.446472609873666`", ",", 
   "7.119393765225491`", ",", "2.314101263265693`", ",", "8.065424285636709`",
    ",", "9.988808228481833`", ",", "4.26975393525038`", ",", 
   "2.6652824309807976`", ",", "6.159622454434013`", ",", 
   "6.116433710737333`", ",", "3.36749159663315`", ",", "8.401557495547893`", 
   ",", "4.844750877628039`", ",", "5.0092190030197825`", ",", 
   "7.395048379458473`"}], "}"}]], "Output",
 ImageSize->{429, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->785956063]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InterquartileRange", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->632052870],

Cell[BoxData["4.606373935512292`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->291109916]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"Subtract", ",", 
   RowBox[{"Quantile", "[", 
    RowBox[{"data", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"3", "/", "4"}], ",", 
       RowBox[{"1", "/", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->155558425],

Cell[BoxData["4.606373935512292`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->152349516]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->103804862],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["QuartileDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/QuartileDeviation"]], "InlineFormula"],
 " is half the interquartile range:"
}], "ExampleText",
 CellID->15299726],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"10", ",", "20"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->118537781],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "6.577451251109339`", ",", "3.90153561968545`", ",", "1.5953524826004895`", 
   ",", "5.133960668635201`", ",", "9.76281176978344`", ",", 
   "0.4843421537184911`", ",", "9.478164128512168`", ",", 
   "3.4342563397290893`", ",", "6.749066418361149`", ",", 
   "0.8400868049031796`", ",", "6.274152253160057`", ",", 
   "3.8482216253269486`", ",", "9.750932237445923`", ",", 
   "6.056379123720783`", ",", "0.3857501636207661`", ",", "9.08423575925564`",
    ",", "6.529094883165854`", ",", "4.924938852417062`", ",", 
   "7.530222198130893`", ",", "8.10269882845753`"}], "}"}]], "Output",
 ImageSize->{436, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->92471221]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InterquartileRange", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23051440],

Cell[BoxData["4.175221530766192`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->621180999]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", 
  RowBox[{"QuartileDeviation", "[", "data", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->481300380],

Cell[BoxData["4.175221530766192`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->184306094]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->631682428],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InterquartileRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterquartileRange"]], "InlineFormula"],
 " is the difference between the first and third quartiles:"
}], "ExampleText",
 CellID->533304287],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"10", ",", "20"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->239649738],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "4.799248745490172`", ",", "6.100959534829156`", ",", "6.134623000792647`", 
   ",", "2.751802496779001`", ",", "9.986052258265921`", ",", 
   "0.7956983113690752`", ",", "8.226925294287803`", ",", 
   "4.528281502701725`", ",", "6.198666616356121`", ",", "5.336096103102719`",
    ",", "3.3249302248520007`", ",", "0.003915567611987303`", ",", 
   "8.029481874480869`", ",", "9.15043436947094`", ",", "4.113492085073311`", 
   ",", "4.233247416344774`", ",", "1.181356484607321`", ",", 
   "8.508811555304884`", ",", "6.424857349643583`", ",", 
   "8.234485417779336`"}], "}"}]], "Output",
 ImageSize->{443, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->161577]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InterquartileRange", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->333901997],

Cell[BoxData["4.40899242942168`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->39784665]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"Subtract", ",", 
   RowBox[{
    RowBox[{"Quartiles", "[", "data", "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"{", 
      RowBox[{"3", ",", "1"}], "}"}], "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->501255430],

Cell[BoxData["4.40899242942168`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->360624786]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11051],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InterquartileRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterquartileRange"]], "InlineFormula"],
 " requires numeric values:"
}], "ExampleText",
 CellID->9090],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InterquartileRange", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9034],

Cell[BoxData[
 RowBox[{
  RowBox[{"InterquartileRange", "::", "\<\"rectn\"\>"}], ":", 
  " ", "\<\"Rectangular array of real numbers is expected at position \\!\\(1\
\\) in \\!\\(InterquartileRange[\\(\\({a, b, c}\\)\\)]\\).\"\>"}]], "Message",\
 "MSG",
 CellID->115993913],

Cell[BoxData[
 RowBox[{"InterquartileRange", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Output",
 ImageSize->{202, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->307982611]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21649],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Quartiles",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quartiles"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["QuartileDeviation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/QuartileDeviation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["QuartileSkewness",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/QuartileSkewness"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Quantile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quantile"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10485]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8553],

Cell[TextData[ButtonBox["Descriptive Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DescriptiveStatistics"]], "Tutorials",
 CellID->4063544]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Descriptive Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DescriptiveStatistics"]], "MoreAbout",
 CellID->233280307],

Cell[TextData[ButtonBox["New in 6.0: Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60Statistics"]], "MoreAbout",
 CellID->146174474]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InterquartileRange - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 49, 36.8536024}", "context" -> "System`", 
    "keywords" -> {"hinges", "iqr", "lower quartile", "upper quartile"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "InterquartileRange[list] gives the difference between the upper and \
lower quartiles for the elements in list.", 
    "synonyms" -> {"interquartile range"}, "title" -> "InterquartileRange", 
    "type" -> "Symbol", "uri" -> "ref/InterquartileRange"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6726, 206, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->63934531]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 26136, 946}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2270, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2893, 81, 1583, 37, 70, "ObjectNameGrid"],
Cell[4479, 120, 623, 19, 70, "Usage",
 CellID->9858]
}, Open  ]],
Cell[CellGroupData[{
Cell[5139, 144, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5617, 161, 727, 26, 70, "Notes",
 CellID->1730],
Cell[6347, 189, 342, 12, 70, "Notes",
 CellID->11686772]
}, Closed]],
Cell[CellGroupData[{
Cell[6726, 206, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->63934531],
Cell[CellGroupData[{
Cell[7110, 220, 148, 5, 70, "ExampleSection",
 CellID->166680514],
Cell[7261, 227, 90, 1, 70, "ExampleText",
 CellID->31273586],
Cell[CellGroupData[{
Cell[7376, 232, 199, 6, 28, "Input",
 CellID->2858],
Cell[7578, 240, 206, 7, 36, "Output",
 CellID->167004779]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7833, 253, 215, 7, 70, "ExampleSection",
 CellID->5044],
Cell[8051, 262, 233, 7, 70, "ExampleText",
 CellID->13924],
Cell[CellGroupData[{
Cell[8309, 273, 270, 8, 70, "Input",
 CellID->19854],
Cell[8582, 283, 460, 18, 51, "Output",
 CellID->4278904]
}, Open  ]],
Cell[CellGroupData[{
Cell[9079, 306, 97, 3, 70, "Input",
 CellID->139342064],
Cell[9179, 311, 175, 5, 36, "Output",
 CellID->59597617]
}, Open  ]],
Cell[9369, 319, 124, 3, 70, "ExampleDelimiter",
 CellID->64612447],
Cell[9496, 324, 88, 1, 70, "ExampleText",
 CellID->281606070],
Cell[CellGroupData[{
Cell[9609, 329, 446, 15, 70, "Input",
 CellID->421309609],
Cell[10058, 346, 297, 11, 51, "Output",
 CellID->642966039]
}, Open  ]],
Cell[10370, 360, 125, 3, 70, "ExampleDelimiter",
 CellID->158391064],
Cell[10498, 365, 76, 1, 70, "ExampleText",
 CellID->160553898],
Cell[CellGroupData[{
Cell[10599, 370, 265, 8, 70, "Input",
 CellID->190699768],
Cell[10867, 380, 177, 5, 36, "Output",
 CellID->35033140]
}, Open  ]],
Cell[11059, 388, 125, 3, 70, "ExampleDelimiter",
 CellID->650909219],
Cell[11187, 393, 88, 1, 70, "ExampleText",
 CellID->285474028],
Cell[CellGroupData[{
Cell[11300, 398, 201, 6, 70, "Input",
 CellID->315224713],
Cell[11504, 406, 175, 5, 36, "Output",
 CellID->758622344]
}, Open  ]],
Cell[CellGroupData[{
Cell[11716, 416, 254, 8, 70, "Input",
 CellID->594479966],
Cell[11973, 426, 338, 10, 36, "Output",
 CellID->549576844]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12360, 442, 238, 7, 70, "ExampleSection",
 CellID->6422],
Cell[12601, 451, 211, 8, 70, "ExampleText",
 CellID->625271644],
Cell[CellGroupData[{
Cell[12837, 463, 592, 20, 70, "Input",
 CellID->19878761],
Cell[13432, 485, 486, 17, 36, "Output",
 CellID->452904205]
}, Open  ]],
Cell[CellGroupData[{
Cell[13955, 507, 115, 3, 70, "Input",
 CellID->235263230],
Cell[14073, 512, 321, 9, 36, "Output",
 CellID->112931352]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14443, 527, 232, 7, 70, "ExampleSection",
 CellID->8756],
Cell[14678, 536, 372, 12, 70, "ExampleText",
 CellID->38722882],
Cell[CellGroupData[{
Cell[15075, 552, 158, 5, 70, "Input",
 CellID->133352675],
Cell[15236, 559, 761, 16, 71, "Output",
 CellID->785956063]
}, Open  ]],
Cell[CellGroupData[{
Cell[16034, 580, 117, 3, 70, "Input",
 CellID->632052870],
Cell[16154, 585, 175, 5, 36, "Output",
 CellID->291109916]
}, Open  ]],
Cell[CellGroupData[{
Cell[16366, 595, 511, 17, 70, "Input",
 CellID->155558425],
Cell[16880, 614, 175, 5, 36, "Output",
 CellID->152349516]
}, Open  ]],
Cell[17070, 622, 125, 3, 70, "ExampleDelimiter",
 CellID->103804862],
Cell[17198, 627, 227, 7, 70, "ExampleText",
 CellID->15299726],
Cell[CellGroupData[{
Cell[17450, 638, 158, 5, 70, "Input",
 CellID->118537781],
Cell[17611, 645, 760, 16, 71, "Output",
 CellID->92471221]
}, Open  ]],
Cell[CellGroupData[{
Cell[18408, 666, 116, 3, 70, "Input",
 CellID->23051440],
Cell[18527, 671, 175, 5, 36, "Output",
 CellID->621180999]
}, Open  ]],
Cell[CellGroupData[{
Cell[18739, 681, 134, 4, 70, "Input",
 CellID->481300380],
Cell[18876, 687, 175, 5, 36, "Output",
 CellID->184306094]
}, Open  ]],
Cell[19066, 695, 125, 3, 70, "ExampleDelimiter",
 CellID->631682428],
Cell[19194, 700, 254, 7, 70, "ExampleText",
 CellID->533304287],
Cell[CellGroupData[{
Cell[19473, 711, 158, 5, 70, "Input",
 CellID->239649738],
Cell[19634, 718, 760, 16, 71, "Output",
 CellID->161577]
}, Open  ]],
Cell[CellGroupData[{
Cell[20431, 739, 117, 3, 70, "Input",
 CellID->333901997],
Cell[20551, 744, 173, 5, 36, "Output",
 CellID->39784665]
}, Open  ]],
Cell[CellGroupData[{
Cell[20761, 754, 279, 9, 70, "Input",
 CellID->501255430],
Cell[21043, 765, 174, 5, 36, "Output",
 CellID->360624786]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21266, 776, 226, 7, 70, "ExampleSection",
 CellID->11051],
Cell[21495, 785, 217, 7, 70, "ExampleText",
 CellID->9090],
Cell[CellGroupData[{
Cell[21737, 796, 166, 5, 70, "Input",
 CellID->9034],
Cell[21906, 803, 273, 6, 70, "Message",
 CellID->115993913],
Cell[22182, 811, 260, 8, 36, "Output",
 CellID->307982611]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22503, 826, 311, 9, 70, "SeeAlsoSection",
 CellID->21649],
Cell[22817, 837, 977, 35, 70, "SeeAlso",
 CellID->10485]
}, Open  ]],
Cell[CellGroupData[{
Cell[23831, 877, 313, 9, 70, "TutorialsSection",
 CellID->8553],
Cell[24147, 888, 156, 3, 70, "Tutorials",
 CellID->4063544]
}, Open  ]],
Cell[CellGroupData[{
Cell[24340, 896, 299, 8, 70, "MoreAboutSection"],
Cell[24642, 906, 155, 3, 70, "MoreAbout",
 CellID->233280307],
Cell[24800, 911, 151, 3, 70, "MoreAbout",
 CellID->146174474]
}, Open  ]],
Cell[24966, 917, 27, 0, 70, "History"],
Cell[24996, 919, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

