(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18245,        698]
NotebookOptionsPosition[     14250,        559]
NotebookOutlinePosition[     15557,        595]
CellTagsIndexPosition[     15472,        590]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Lists as Sets" :> 
          Documentation`HelpLookup["paclet:tutorial/ListsAsSets"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Lists as Sets\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Union" :> Documentation`HelpLookup["paclet:ref/Union"], 
          "Complement" :> 
          Documentation`HelpLookup["paclet:ref/Complement"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Union\"\>", 
       2->"\<\"Complement\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Discrete Mathematics" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteMathematics"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Discrete Mathematics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Intersection ",
 StyleBox["(\[Intersection])", "OperatorCharacter"]
}], "ObjectName",
 CellID->31879],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Intersection",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Intersection"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["list", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["list", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a sorted list of the elements common to all the ",
     
     Cell[BoxData[
      SubscriptBox[
       StyleBox["list", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->31528]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "If the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["list", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are considered as sets, ",
 Cell[BoxData[
  ButtonBox["Intersection",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Intersection"]], "InlineFormula"],
 " gives their intersection. "
}], "Notes",
 CellID->9203],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Intersection",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Intersection"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["list", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["list", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " can be input in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " as ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["list", "TI"], 
    StyleBox["1", "TR"]], "\[Intersection]", 
   SubscriptBox[
    StyleBox["list", "TI"], 
    StyleBox["2", "TR"]], "\[Intersection]", 
   StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
 ". The character ",
 Cell[BoxData["\[Intersection]"], "InlineFormula"],
 " can be entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]inter\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " or ",
 Cell[TextData[ButtonBox["\\[Intersection]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Intersection"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->824],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["list", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " must have the same head, but it need not be ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->16745],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Intersection",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Intersection"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["list", "TI"], 
     StyleBox["1", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", 
    RowBox[{
     ButtonBox["SameTest",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SameTest"], "->", 
     StyleBox["test", "TI"]}]}], "]"}]], "InlineFormula"],
 " applies ",
 Cell[BoxData[
  StyleBox["test", "TI"]], "InlineFormula"],
 " to each pair of elements in the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["list", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " to determine whether they should be considered the same. "
}], "Notes",
 CellID->30729],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Intersection",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Intersection"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
 " can be entered in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " as ",
 Cell[BoxData[
  RowBox[{
   StyleBox["a", "TI"], "\[Intersection]", 
   StyleBox["b", "TI"]}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["a", "TI"], "\[Backslash]", 
    RowBox[{"[", "Intersection", "]"}]}], 
   StyleBox["b", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12549]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->443455973],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->294747309],

Cell["Find elements common to all the lists given:", "ExampleText",
 CellID->26524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Intersection", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1", ",", "3", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7115],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "3"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28010]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12726],

Cell[TextData[{
 "Enter using ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]inter\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ":"
}], "ExampleText",
 CellID->28233],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "\[Intersection]", 
  RowBox[{"{", 
   RowBox[{"b", ",", "c", ",", "d"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15709],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "c"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7723]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31252],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Intersection",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Intersection"]], "InlineFormula"],
 " works with any head, not just ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->23413],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Intersection", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"c", ",", "a"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", "b", ",", "a"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11107],

Cell[BoxData[
 RowBox[{"f", "[", "a", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6741]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3881],

Cell["Find divisors common to 45 and 78:", "ExampleText",
 CellID->2173],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Intersection", "[", 
  RowBox[{
   RowBox[{"Divisors", "[", "45", "]"}], ",", 
   RowBox[{"Divisors", "[", "78", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14550],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "3"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10296]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6271],

Cell[TextData[{
 "If there is no intersection, the result is ",
 Cell[BoxData[
  RowBox[{"{", "}"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->3414],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Intersection", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "e", ",", "f"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6905],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13834]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19891],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Union",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Union"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Complement",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Complement"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17411]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7724],

Cell[TextData[ButtonBox["Lists as Sets",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ListsAsSets"]], "Tutorials",
 CellID->16979]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->362047689],

Cell[TextData[ButtonBox["Discrete Mathematics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "MoreAbout",
 CellID->334832073]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Intersection (\[Intersection]) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 49, 39.8380538}", "context" -> "System`", 
    "keywords" -> {"disjointness", "lists", "overlap between lists", "sets"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Intersection[list_1, list_2, ...] gives a sorted list of the elements \
common to all the list_i. ", "synonyms" -> {}, "title" -> "Intersection", 
    "type" -> "Symbol", "uri" -> "ref/Intersection"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7587, 274, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->443455973]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15329, 583}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1807, 47, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2430, 74, 119, 4, 70, "ObjectName",
 CellID->31879],
Cell[2552, 80, 855, 28, 70, "Usage",
 CellID->31528]
}, Open  ]],
Cell[CellGroupData[{
Cell[3444, 113, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3922, 130, 346, 13, 70, "Notes",
 CellID->9203],
Cell[4271, 145, 1334, 46, 70, "Notes",
 CellID->824],
Cell[5608, 193, 323, 13, 70, "Notes",
 CellID->16745],
Cell[5934, 208, 756, 26, 70, "Notes",
 CellID->30729],
Cell[6693, 236, 857, 33, 70, "Notes",
 CellID->12549]
}, Closed]],
Cell[CellGroupData[{
Cell[7587, 274, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->443455973],
Cell[CellGroupData[{
Cell[7972, 288, 148, 5, 70, "ExampleSection",
 CellID->294747309],
Cell[8123, 295, 83, 1, 70, "ExampleText",
 CellID->26524],
Cell[CellGroupData[{
Cell[8231, 300, 333, 10, 28, "Input",
 CellID->7115],
Cell[8567, 312, 199, 7, 36, "Output",
 CellID->28010]
}, Open  ]],
Cell[8781, 322, 121, 3, 70, "ExampleDelimiter",
 CellID->12726],
Cell[8905, 327, 190, 7, 70, "ExampleText",
 CellID->28233],
Cell[CellGroupData[{
Cell[9120, 338, 216, 7, 70, "Input",
 CellID->15709],
Cell[9339, 347, 198, 7, 36, "Output",
 CellID->7723]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9586, 360, 239, 7, 70, "ExampleSection",
 CellID->31252],
Cell[9828, 369, 329, 12, 70, "ExampleText",
 CellID->23413],
Cell[CellGroupData[{
Cell[10182, 385, 309, 10, 70, "Input",
 CellID->11107],
Cell[10494, 397, 180, 6, 36, "Output",
 CellID->6741]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10723, 409, 222, 7, 70, "ExampleSection",
 CellID->3881],
Cell[10948, 418, 72, 1, 70, "ExampleText",
 CellID->2173],
Cell[CellGroupData[{
Cell[11045, 423, 201, 6, 70, "Input",
 CellID->14550],
Cell[11249, 431, 199, 7, 36, "Output",
 CellID->10296]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11497, 444, 232, 7, 70, "ExampleSection",
 CellID->6271],
Cell[11732, 453, 158, 6, 70, "ExampleText",
 CellID->3414],
Cell[CellGroupData[{
Cell[11915, 463, 244, 8, 70, "Input",
 CellID->6905],
Cell[12162, 473, 171, 6, 36, "Output",
 CellID->13834]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12394, 486, 311, 9, 70, "SeeAlsoSection",
 CellID->19891],
Cell[12708, 497, 449, 17, 70, "SeeAlso",
 CellID->17411]
}, Open  ]],
Cell[CellGroupData[{
Cell[13194, 519, 313, 9, 70, "TutorialsSection",
 CellID->7724],
Cell[13510, 530, 135, 3, 70, "Tutorials",
 CellID->16979]
}, Open  ]],
Cell[CellGroupData[{
Cell[13682, 538, 319, 9, 70, "MoreAboutSection",
 CellID->362047689],
Cell[14004, 549, 151, 3, 70, "MoreAbout",
 CellID->334832073]
}, Open  ]],
Cell[14170, 555, 50, 0, 70, "History"],
Cell[14223, 557, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

