(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12587,        455]
NotebookOptionsPosition[      9409,        349]
NotebookOutlinePosition[     10758,        387]
CellTagsIndexPosition[     10673,        382]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Interval Arithmetic" :> 
          Documentation`HelpLookup["paclet:tutorial/IntervalArithmetic"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Interval Arithmetic\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Interval" :> Documentation`HelpLookup["paclet:ref/Interval"], 
          "IntervalUnion" :> 
          Documentation`HelpLookup["paclet:ref/IntervalUnion"], 
          "IntervalMemberQ" :> 
          Documentation`HelpLookup["paclet:ref/IntervalMemberQ"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Interval\"\>", 
       2->"\<\"IntervalUnion\"\>", 
       3->"\<\"IntervalMemberQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Interval Arithmetic" :> 
          Documentation`HelpLookup["paclet:guide/IntervalArithmetic"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Interval Arithmetic\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["IntervalIntersection", "ObjectName",
 CellID->3854],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["IntervalIntersection",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/IntervalIntersection"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["interval", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["interval", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the interval representing all points common to \
each of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["interval", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->257]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->727768737],

Cell["Find where intervals overlap:", "ExampleText",
 CellID->573335621],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntervalIntersection", "[", 
  RowBox[{
   RowBox[{"Interval", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "2"}], ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Interval", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4"}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21672380],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "3"}], "}"}], "]"}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->127019031]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10050],

Cell["Disjoint intervals:", "ExampleText",
 CellID->117993232],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntervalIntersection", "[", 
  RowBox[{
   RowBox[{"Interval", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "2"}], ",", "0"}], "}"}], "]"}], ",", 
   RowBox[{"Interval", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4"}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14873481],

Cell[BoxData[
 RowBox[{"Interval", "[", "]"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->383898150]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->206455444],

Cell["Use exact symbolic quantities:", "ExampleText",
 CellID->128587741],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntervalIntersection", "[", 
  RowBox[{
   RowBox[{"Interval", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "2"}], ",", "Pi"}], "}"}], "]"}], ",", 
   RowBox[{"Interval", "[", 
    RowBox[{"{", 
     RowBox[{"E", ",", "4"}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->131513629],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{"\[ExponentialE]", ",", "\[Pi]"}], "}"}], "]"}]], "Output",
 ImageSize->{115, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->192180775]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9977],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Interval",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Interval"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntervalUnion",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntervalUnion"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntervalMemberQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntervalMemberQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23200]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23346],

Cell[TextData[ButtonBox["Interval Arithmetic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntervalArithmetic"]], "Tutorials",
 CellID->16368]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with IntervalIntersection",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=\
IntervalIntersection"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->239574880],

Cell[TextData[ButtonBox["Interval Arithmetic",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntervalArithmetic"]], "MoreAbout",
 CellID->148824911]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"IntervalIntersection - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 49, 40.0568094}", "context" -> "System`", 
    "keywords" -> {"common range", "common subinterval"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "IntervalIntersection[interval_1, interval_2, ...] gives the interval \
representing all points common to each of the interval_i. ", 
    "synonyms" -> {"interval intersection"}, "title" -> 
    "IntervalIntersection", "type" -> "Symbol", "uri" -> 
    "ref/IntervalIntersection"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3587, 113, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10538, 375}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1979, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2602, 77, 57, 1, 70, "ObjectName",
 CellID->3854],
Cell[2662, 80, 888, 28, 70, "Usage",
 CellID->257]
}, Open  ]],
Cell[CellGroupData[{
Cell[3587, 113, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3964, 127, 148, 5, 70, "ExampleSection",
 CellID->727768737],
Cell[4115, 134, 72, 1, 70, "ExampleText",
 CellID->573335621],
Cell[CellGroupData[{
Cell[4212, 139, 334, 11, 28, "Input",
 CellID->21672380],
Cell[4549, 152, 240, 8, 36, "Output",
 CellID->127019031]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4838, 166, 216, 7, 70, "ExampleSection",
 CellID->10050],
Cell[5057, 175, 62, 1, 70, "ExampleText",
 CellID->117993232],
Cell[CellGroupData[{
Cell[5144, 180, 334, 11, 70, "Input",
 CellID->14873481],
Cell[5481, 193, 187, 6, 36, "Output",
 CellID->383898150]
}, Open  ]],
Cell[5683, 202, 125, 3, 70, "ExampleDelimiter",
 CellID->206455444],
Cell[5811, 207, 73, 1, 70, "ExampleText",
 CellID->128587741],
Cell[CellGroupData[{
Cell[5909, 212, 336, 11, 70, "Input",
 CellID->131513629],
Cell[6248, 225, 258, 8, 36, "Output",
 CellID->192180775]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6567, 240, 310, 9, 70, "SeeAlsoSection",
 CellID->9977],
Cell[6880, 251, 720, 26, 70, "SeeAlso",
 CellID->23200]
}, Open  ]],
Cell[CellGroupData[{
Cell[7637, 282, 314, 9, 70, "TutorialsSection",
 CellID->23346],
Cell[7954, 293, 148, 3, 70, "Tutorials",
 CellID->16368]
}, Open  ]],
Cell[CellGroupData[{
Cell[8139, 301, 305, 8, 70, "RelatedLinksSection"],
Cell[8447, 311, 382, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8866, 328, 319, 9, 70, "MoreAboutSection",
 CellID->239574880],
Cell[9188, 339, 149, 3, 70, "MoreAbout",
 CellID->148824911]
}, Open  ]],
Cell[9352, 345, 27, 0, 70, "History"],
Cell[9382, 347, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

