(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15582,        565]
NotebookOptionsPosition[     11901,        442]
NotebookOutlinePosition[     13320,        480]
CellTagsIndexPosition[     13235,        475]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Interval Arithmetic" :> 
          Documentation`HelpLookup["paclet:tutorial/IntervalArithmetic"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Interval Arithmetic\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Interval" :> Documentation`HelpLookup["paclet:ref/Interval"], 
          "IntervalIntersection" :> 
          Documentation`HelpLookup["paclet:ref/IntervalIntersection"], 
          "MemberQ" :> Documentation`HelpLookup["paclet:ref/MemberQ"], 
          "PossibleZeroQ" :> 
          Documentation`HelpLookup["paclet:ref/PossibleZeroQ"], "Nearest" :> 
          Documentation`HelpLookup["paclet:ref/Nearest"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Interval\"\>", 2->"\<\"IntervalIntersection\"\>",
        3->"\<\"MemberQ\"\>", 4->"\<\"PossibleZeroQ\"\>", 
       5->"\<\"Nearest\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Interval Arithmetic" :> 
          Documentation`HelpLookup["paclet:guide/IntervalArithmetic"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Interval Arithmetic\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["IntervalMemberQ", "ObjectName",
 CellID->16881],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["IntervalMemberQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/IntervalMemberQ"], "[", 
       RowBox[{
        StyleBox["interval", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if the number ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " lies within the specified interval, and ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["IntervalMemberQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/IntervalMemberQ"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["interval", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["interval", "TI"], 
         StyleBox["2", "TR"]]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["interval", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     " is completely contained within ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["interval", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->13930]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["IntervalMemberQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntervalMemberQ"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["Listable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Listable"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->26415]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->820228579],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->27219895],

Cell["\<\
Test whether \[Pi] lies in the interval 2 through 5:\
\>", "ExampleText",
 CellID->106448552],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntervalMemberQ", "[", 
  RowBox[{
   RowBox[{"Interval", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "5"}], "}"}], "]"}], ",", "Pi"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->781084834],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->40918240]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24602],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["IntervalMemberQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IntervalMemberQ"]], "InlineFormula"],
 " tests whether one interval lies within another:"
}], "ExampleText",
 CellID->131871482],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntervalMemberQ", "[", 
  RowBox[{
   RowBox[{"Interval", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Interval", "[", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->97491756],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->229188221]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntervalMemberQ", "[", 
  RowBox[{
   RowBox[{"Interval", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "5"}], "}"}], "]"}], ",", 
   RowBox[{"Interval", "[", 
    RowBox[{"{", 
     RowBox[{"4", ",", "6"}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5950451],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->43843832]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->283183136],

Cell["Exact numbers do not define an extended interval:", "ExampleText",
 CellID->655869578],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntervalMemberQ", "[", 
  RowBox[{
   RowBox[{"Interval", "[", "1", "]"}], ",", 
   RowBox[{"Interval", "[", "1.", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->499524286],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->110156448]
}, Open  ]],

Cell["Approximate numbers do:", "ExampleText",
 CellID->145804898],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntervalMemberQ", "[", 
  RowBox[{
   RowBox[{"Interval", "[", "1.", "]"}], ",", 
   RowBox[{"Interval", "[", "1", "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->367588645],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->29824776]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26140],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Interval",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Interval"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntervalIntersection",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntervalIntersection"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MemberQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MemberQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PossibleZeroQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PossibleZeroQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Nearest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Nearest"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7573]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5124],

Cell[TextData[ButtonBox["Interval Arithmetic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntervalArithmetic"]], "Tutorials",
 CellID->21258]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->30614],

Cell[TextData[ButtonBox["Interval Arithmetic",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntervalArithmetic"]], "MoreAbout",
 CellID->238025951]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"IntervalMemberQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 49, 40.2599396}", "context" -> "System`", 
    "keywords" -> {"point location", "searching"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "IntervalMemberQ[interval, x] gives True if the number x lies within the \
specified interval, and False otherwise. IntervalMemberQ[interval_1, \
interval_2] gives True if interval_2 is completely contained within \
interval_1. ", "synonyms" -> {"interval member q"}, "title" -> 
    "IntervalMemberQ", "type" -> "Symbol", "uri" -> "ref/IntervalMemberQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5568, 181, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->820228579]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13092, 468}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2182, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2805, 79, 53, 1, 70, "ObjectName",
 CellID->16881],
Cell[2861, 82, 1833, 60, 70, "Usage",
 CellID->13930]
}, Open  ]],
Cell[CellGroupData[{
Cell[4731, 147, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5209, 164, 322, 12, 70, "Notes",
 CellID->26415]
}, Closed]],
Cell[CellGroupData[{
Cell[5568, 181, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->820228579],
Cell[CellGroupData[{
Cell[5953, 195, 147, 5, 70, "ExampleSection",
 CellID->27219895],
Cell[6103, 202, 103, 3, 70, "ExampleText",
 CellID->106448552],
Cell[CellGroupData[{
Cell[6231, 209, 222, 7, 28, "Input",
 CellID->781084834],
Cell[6456, 218, 160, 5, 36, "Output",
 CellID->40918240]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6665, 229, 216, 7, 70, "ExampleSection",
 CellID->24602],
Cell[6884, 238, 239, 7, 70, "ExampleText",
 CellID->131871482],
Cell[CellGroupData[{
Cell[7148, 249, 307, 10, 70, "Input",
 CellID->97491756],
Cell[7458, 261, 161, 5, 36, "Output",
 CellID->229188221]
}, Open  ]],
Cell[CellGroupData[{
Cell[7656, 271, 306, 10, 70, "Input",
 CellID->5950451],
Cell[7965, 283, 161, 5, 36, "Output",
 CellID->43843832]
}, Open  ]],
Cell[8141, 291, 125, 3, 70, "ExampleDelimiter",
 CellID->283183136],
Cell[8269, 296, 92, 1, 70, "ExampleText",
 CellID->655869578],
Cell[CellGroupData[{
Cell[8386, 301, 207, 6, 70, "Input",
 CellID->499524286],
Cell[8596, 309, 162, 5, 36, "Output",
 CellID->110156448]
}, Open  ]],
Cell[8773, 317, 66, 1, 70, "ExampleText",
 CellID->145804898],
Cell[CellGroupData[{
Cell[8864, 322, 207, 6, 70, "Input",
 CellID->367588645],
Cell[9074, 330, 160, 5, 36, "Output",
 CellID->29824776]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9295, 342, 311, 9, 70, "SeeAlsoSection",
 CellID->26140],
Cell[9609, 353, 1215, 44, 70, "SeeAlso",
 CellID->7573]
}, Open  ]],
Cell[CellGroupData[{
Cell[10861, 402, 313, 9, 70, "TutorialsSection",
 CellID->5124],
Cell[11177, 413, 148, 3, 70, "Tutorials",
 CellID->21258]
}, Open  ]],
Cell[CellGroupData[{
Cell[11362, 421, 315, 9, 70, "MoreAboutSection",
 CellID->30614],
Cell[11680, 432, 149, 3, 70, "MoreAbout",
 CellID->238025951]
}, Open  ]],
Cell[11844, 438, 27, 0, 70, "History"],
Cell[11874, 440, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

