(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10274,        372]
NotebookOptionsPosition[      7571,        281]
NotebookOutlinePosition[      8862,        318]
CellTagsIndexPosition[      8778,        313]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Interval Arithmetic" :> 
          Documentation`HelpLookup["paclet:tutorial/IntervalArithmetic"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Interval Arithmetic\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Interval" :> Documentation`HelpLookup["paclet:ref/Interval"], 
          "IntervalIntersection" :> 
          Documentation`HelpLookup["paclet:ref/IntervalIntersection"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Interval\"\>", 
       2->"\<\"IntervalIntersection\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Interval Arithmetic" :> 
          Documentation`HelpLookup["paclet:guide/IntervalArithmetic"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Interval Arithmetic\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["IntervalUnion", "ObjectName",
 CellID->13820],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["IntervalUnion",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/IntervalUnion"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["interval", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["interval", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the interval representing the set of all points \
in any of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["interval", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->30189]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->289317568],

Cell["Combine intervals:", "ExampleText",
 CellID->27296556],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntervalUnion", "[", 
  RowBox[{
   RowBox[{"Interval", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}], "]"}], ",", 
   RowBox[{"Interval", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4"}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->395384],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "4"}], "}"}], "]"}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->89700113]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9682],

Cell["Combine disjoint intervals:", "ExampleText",
 CellID->229862032],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntervalUnion", "[", 
  RowBox[{
   RowBox[{"Interval", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "2"}], ",", "0"}], "}"}], "]"}], ",", 
   RowBox[{"Interval", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4"}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->678042830],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4"}], "}"}]}], "]"}]], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->447036977]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4601],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Interval",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Interval"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntervalIntersection",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntervalIntersection"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9004]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3292],

Cell[TextData[ButtonBox["Interval Arithmetic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntervalArithmetic"]], "Tutorials",
 CellID->20730]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->163297604],

Cell[TextData[ButtonBox["Interval Arithmetic",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntervalArithmetic"]], "MoreAbout",
 CellID->24278723]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"IntervalUnion - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 49, 40.9162064}", "context" -> "System`", 
    "keywords" -> {"join intervals"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "IntervalUnion[interval_1, interval_2, ...] gives the interval \
representing the set of all points in any of the interval_i. ", 
    "synonyms" -> {"interval union"}, "title" -> "IntervalUnion", "type" -> 
    "Symbol", "uri" -> "ref/IntervalUnion"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3457, 110, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8643, 306}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1864, 47, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2487, 74, 51, 1, 70, "ObjectName",
 CellID->13820],
Cell[2541, 77, 879, 28, 70, "Usage",
 CellID->30189]
}, Open  ]],
Cell[CellGroupData[{
Cell[3457, 110, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3834, 124, 148, 5, 70, "ExampleSection",
 CellID->289317568],
Cell[3985, 131, 60, 1, 70, "ExampleText",
 CellID->27296556],
Cell[CellGroupData[{
Cell[4070, 136, 303, 10, 28, "Input",
 CellID->395384],
Cell[4376, 148, 239, 8, 36, "Output",
 CellID->89700113]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4664, 162, 215, 7, 70, "ExampleSection",
 CellID->9682],
Cell[4882, 171, 70, 1, 70, "ExampleText",
 CellID->229862032],
Cell[CellGroupData[{
Cell[4977, 176, 328, 11, 70, "Input",
 CellID->678042830],
Cell[5308, 189, 335, 12, 36, "Output",
 CellID->447036977]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5704, 208, 310, 9, 70, "SeeAlsoSection",
 CellID->4601],
Cell[6017, 219, 474, 17, 70, "SeeAlso",
 CellID->9004]
}, Open  ]],
Cell[CellGroupData[{
Cell[6528, 241, 313, 9, 70, "TutorialsSection",
 CellID->3292],
Cell[6844, 252, 148, 3, 70, "Tutorials",
 CellID->20730]
}, Open  ]],
Cell[CellGroupData[{
Cell[7029, 260, 319, 9, 70, "MoreAboutSection",
 CellID->163297604],
Cell[7351, 271, 148, 3, 70, "MoreAbout",
 CellID->24278723]
}, Open  ]],
Cell[7514, 277, 27, 0, 70, "History"],
Cell[7544, 279, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

