(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     39981,       1354]
NotebookOptionsPosition[     32775,       1104]
NotebookOutlinePosition[     34103,       1141]
CellTagsIndexPosition[     34017,       1136]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Beta" :> Documentation`HelpLookup["paclet:ref/Beta"], 
          "BetaRegularized" :> 
          Documentation`HelpLookup["paclet:ref/BetaRegularized"], 
          "InverseGammaRegularized" :> 
          Documentation`HelpLookup["paclet:ref/InverseGammaRegularized"], 
          "InverseErf" :> 
          Documentation`HelpLookup["paclet:ref/InverseErf"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Beta\"\>", 
       2->"\<\"BetaRegularized\"\>", 3->"\<\"InverseGammaRegularized\"\>", 
       4->"\<\"InverseErf\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functions Used in Statistics" :> 
          Documentation`HelpLookup["paclet:guide/FunctionsUsedInStatistics"], 
          "Gamma Functions and Related Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/GammaFunctionsAndRelatedFunctions"], 
          "Inverse Functions" :> 
          Documentation`HelpLookup["paclet:guide/InverseFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Functions Used in Statistics\"\>", 
       2->"\<\"Gamma Functions and Related Functions\"\>", 
       3->"\<\"Inverse Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InverseBetaRegularized", "ObjectName",
 CellID->31416],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InverseBetaRegularized",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InverseBetaRegularized"], "[", 
       RowBox[{
        StyleBox["s", "TI"], ",", 
        StyleBox["a", "TI"], ",", 
        StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the inverse of the regularized incomplete beta \
function. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6485]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "With the regularized incomplete beta function defined by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"I", "(", 
     RowBox[{"z", ",", "a", ",", "b"}], ")"}], "=", 
    RowBox[{
     RowBox[{"\[CapitalBeta]", "(", 
      RowBox[{"z", ",", "a", ",", "b"}], ")"}], "/", 
     RowBox[{"\[CapitalBeta]", "(", 
      RowBox[{"a", ",", "b"}], ")"}]}]}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InverseBetaRegularized",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseBetaRegularized"], "[", 
   RowBox[{
    StyleBox["s", "TI"], ",", 
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
 " is the solution for ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  FormBox[
   RowBox[{"s", "=", 
    RowBox[{"I", "(", 
     RowBox[{"z", ",", "a", ",", "b"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->16133],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["InverseBetaRegularized",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseBetaRegularized"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["z", "TI"], 
     StyleBox["0", "TR"]], ",", 
    StyleBox["s", "TI"], ",", 
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"]}], "]"}]], "InlineFormula", "TemplateInclusion"],
 " gives the inverse of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["BetaRegularized",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BetaRegularized"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["z", "TI"], 
     StyleBox["0", "TR"]], ",", 
    StyleBox["z", "TI"], ",", 
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->9639],

Cell[TextData[{
 "Note that the arguments of ",
 Cell[BoxData[
  ButtonBox["InverseBetaRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseBetaRegularized"]], "InlineFormula"],
 " are arranged differently than in ",
 Cell[BoxData[
  ButtonBox["InverseGammaRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseGammaRegularized"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20594],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["InverseBetaRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseBetaRegularized"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->89921497],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseBetaRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseBetaRegularized"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseBetaRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseBetaRegularized"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->45705950],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->168435305],

Cell["Evaluate numerically:", "ExampleText",
 CellID->103289786],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseBetaRegularized", "[", 
  RowBox[{"0.8", ",", " ", "1", ",", " ", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->219125055],

Cell[BoxData["0.5527864045000421`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->50401747]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->348976950],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"InverseBetaRegularized", "[", 
    RowBox[{"s", ",", "2", ",", "3"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->269007598],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->623362145]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->485893928],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->379827554],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"InverseBetaRegularized", "[", 
    RowBox[{
     RowBox[{"11", "/", "100"}], ",", "2", ",", " ", "3"}], "]"}], ",", 
   "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->468769707],

Cell[BoxData["0.\
1503697553375992163155643822376407455999373786984486951242587814969`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->245969362]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->169489262],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->862606097],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseBetaRegularized", "[", 
  RowBox[{"0.110000000000000000000000", ",", "2", ",", "3"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->70235645],

Cell[BoxData["0.15036975533759921631556438223786420182`23.04139268515823"], \
"Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->554432784]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->84094409],

Cell["Series expansion at the origin:", "ExampleText",
 CellID->742245473],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"InverseBetaRegularized", "[", 
     RowBox[{"z", ",", "2", ",", "b"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "0", ",", "2"}], "}"}]}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->194847399],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"InverseBetaRegularized", "[", 
    RowBox[{"0", ",", "2", ",", "b"}], "]"}], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"Beta", "[", 
      RowBox[{"2", ",", "b"}], "]"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"InverseBetaRegularized", "[", 
         RowBox[{"0", ",", "2", ",", "b"}], "]"}]}], ")"}], 
      RowBox[{"1", "-", "b"}]], " ", "z"}], 
    RowBox[{"InverseBetaRegularized", "[", 
     RowBox[{"0", ",", "2", ",", "b"}], "]"}]], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"Beta", "[", 
        RowBox[{"2", ",", "b"}], "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"InverseBetaRegularized", "[", 
          RowBox[{"0", ",", "2", ",", "b"}], "]"}]}], ")"}], 
       RowBox[{"1", "-", 
        RowBox[{"2", " ", "b"}]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"b", " ", 
         RowBox[{"InverseBetaRegularized", "[", 
          RowBox[{"0", ",", "2", ",", "b"}], "]"}]}]}], ")"}], " ", 
      SuperscriptBox["z", "2"]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"InverseBetaRegularized", "[", 
        RowBox[{"0", ",", "2", ",", "b"}], "]"}], "3"]}], ")"}]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "3"],
    SeriesData[$CellContext`z, 0, {}, 0, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
    InverseBetaRegularized[0, 2, $CellContext`b], 
    Beta[2, $CellContext`b] (1 - InverseBetaRegularized[
      0, 2, $CellContext`b])^(1 - $CellContext`b)/InverseBetaRegularized[
    0, 2, $CellContext`b], Rational[1, 2] 
    Beta[2, $CellContext`b]^2 (1 - InverseBetaRegularized[
      0, 2, $CellContext`b])^(1 - 2 $CellContext`b) 
    InverseBetaRegularized[0, 2, $CellContext`b]^(-3) (-1 + $CellContext`b 
      InverseBetaRegularized[0, 2, $CellContext`b])}, 0, 3, 1],
  Editable->False]], "Output",
 ImageSize->{583, 92},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->246649471]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->398914894],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->13074565],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseBetaRegularized", "[", 
   RowBox[{"s", ",", "a", ",", "b"}], "]"}], " ", "//", " ", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->922305493],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubsuperscriptBox[
    InterpretationBox["I",
     BetaRegularized,
     Editable->False,
     Selectable->False], "s", 
    RowBox[{"-", "1"}]], "(", 
   RowBox[{"a", ",", "b"}], ")"}], TraditionalForm]], "Output",
 ImageSize->{48, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->149212460]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14588835],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseBetaRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseBetaRegularized"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->279459999],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseBetaRegularized", "[", 
  RowBox[{".4", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "5", ",", "7", ",", "11"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->250610554],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.6324555320336759`", ",", "0.5554999979162327`", ",", 
   "0.5907848780904453`", ",", "0.6070048769274049`", ",", 
   "0.6653997690424562`"}], "}"}]], "Output",
 ImageSize->{315, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->920817294]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->468367845],

Cell["Evaluate the 4-argument generalized case:", "ExampleText",
 CellID->243514930],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseBetaRegularized", "[", 
   RowBox[{"0.6", ",", "0.2", ",", "4", ",", " ", "2"}], "]"}], 
  " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->444630360],

Cell[BoxData["0.7042384955144103`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24877512]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->588164932],

Cell["\<\
Model the PDF of the beta distribution through uniformly distributed random \
numbers:\
\>", "ExampleText",
 CellID->288165617],

Cell[BoxData[
 RowBox[{
  RowBox[{"pmod", "[", 
   RowBox[{"a_", ",", "b_", ",", " ", "n_"}], "]"}], " ", ":=", " ", 
  RowBox[{"InverseBetaRegularized", "[", 
   RowBox[{
    RowBox[{"RandomReal", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", " ", "1"}], "}"}], ",", "n"}], "]"}], ",", "a", ",", 
    "b"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3528651],

Cell["Compare binned modeled distribution with exact distribution:", \
"ExampleText",
 CellID->499060203],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "=", "3"}], ",", 
     RowBox[{"b", "=", "2"}], ",", 
     RowBox[{"n", "=", "2000"}], ",", 
     RowBox[{"s", "=", "0.1"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"ListPlot", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"First", "[", "#", "]"}], ",", 
           RowBox[{
            RowBox[{
             RowBox[{"Length", "[", "#", "]"}], "/", "n"}], "/", "s"}]}], 
          "}"}], "&"}], "/@", 
        RowBox[{"Split", "[", 
         RowBox[{"Sort", "[", 
          RowBox[{"Round", "[", 
           RowBox[{
            RowBox[{"pmod", "[", 
             RowBox[{"a", ",", "b", ",", "n"}], "]"}], ",", "s"}], "]"}], 
          "]"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", " ", "-", " ", "x"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"b", " ", "-", " ", "1"}], ")"}]}], 
         RowBox[{
          RowBox[{"x", "^", 
           RowBox[{"(", 
            RowBox[{"a", " ", "-", "1"}], ")"}]}], "/", 
          RowBox[{"Beta", "[", 
           RowBox[{"a", ",", " ", "b"}], "]"}]}]}], " ", ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], "}"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->119081168],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->364051070]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26008275],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseBetaRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseBetaRegularized"]], "InlineFormula"],
 " is the inverse of ",
 Cell[BoxData[
  ButtonBox["BetaRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BetaRegularized"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->100339472],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseBetaRegularized", "[", 
  RowBox[{"0.66", ",", "3.5", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->143097721],

Cell[BoxData["0.5413129217717647`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->532280534]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BetaRegularized", "[", 
  RowBox[{"%", ",", "3.5", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->445931233],

Cell[BoxData["0.6600000000000004`"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->402163014]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->74630012],

Cell["Solve a transcendental equation:", "ExampleText",
 CellID->109144439],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"InverseBetaRegularized", "[", 
       RowBox[{"x", ",", "a", ",", "b"}], "]"}], "^", "2"}], "+", 
     RowBox[{"2", 
      RowBox[{"InverseBetaRegularized", "[", 
       RowBox[{"x", ",", "a", ",", "b"}], "]"}]}]}], "==", "1"}], ",", " ", 
   "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->448166484],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->346099912],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"BetaRegularized", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        SqrtBox["2"]}], ",", "a", ",", "b"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"BetaRegularized", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SqrtBox["2"]}], ",", "a", ",", "b"}], "]"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{517, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->430139711]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->349615119],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseBetaRegularized",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseBetaRegularized"]], "InlineFormula"],
 " evaluates numerically only for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", "\[LessEqual]", "s", "\[LessEqual]", "1"}], TraditionalForm]],
   "InlineMath"],
 "."
}], "ExampleText",
 CellID->9654031],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseBetaRegularized", "[", 
  RowBox[{"1.2", ",", " ", "1", ",", " ", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->214415996],

Cell[BoxData[
 RowBox[{"InverseBetaRegularized", "[", 
  RowBox[{"1.2`", ",", "1", ",", "3"}], "]"}]], "Output",
 ImageSize->{230, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->118833319]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->151853234],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ",  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox[
     InterpretationBox["I",
      BetaRegularized,
      Editable->False,
      Selectable->False], "z", 
     RowBox[{"-", "1"}]], "(", 
    RowBox[{"a", ",", "b"}], ")"}], TraditionalForm]], "InlineMath"],
 " is not automatically interpreted as an inverse regularized beta function: \
"
}], "ExampleText",
 CellID->594351452],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{
   SubsuperscriptBox["I", "z", 
    RowBox[{"-", "1"}]], "(", 
   RowBox[{"a", ",", "b"}], ")"}], TraditionalForm]], "Input",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellLabel->"In[1]:=",
 CellID->5986270],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   SubscriptBox["\[ImaginaryI]", "z"]], "[", 
  RowBox[{"a", ",", "b"}], "]"}]], "Output",
 ImageSize->{60, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24448184]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29415],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Beta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Beta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BetaRegularized",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BetaRegularized"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseGammaRegularized",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseGammaRegularized"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseErf",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseErf"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2922]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29739],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->7204]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->11387],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/index.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/GammaBetaErf/InverseBetaRegularized/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->51283454],

Cell[TextData[ButtonBox["Functions Used in Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInStatistics"]], "MoreAbout",
 CellID->290692335],

Cell[TextData[ButtonBox["Gamma Functions and Related Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GammaFunctionsAndRelatedFunctions"]], "MoreAbout",
 CellID->15674728],

Cell[TextData[ButtonBox["Inverse Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InverseFunctions"]], "MoreAbout",
 CellID->8422701]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InverseBetaRegularized - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 49, 41.1349620}", "context" -> "System`", 
    "keywords" -> {"inverse regularized beta function"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "InverseBetaRegularized[s, a, b] gives the inverse of the regularized \
incomplete beta function. ", "synonyms" -> {"inverse beta regularized"}, 
    "title" -> "InverseBetaRegularized", "type" -> "Symbol", "uri" -> 
    "ref/InverseBetaRegularized"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7407, 247, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->45705950]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 33875, 1129}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2478, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3101, 85, 60, 1, 70, "ObjectName",
 CellID->31416],
Cell[3164, 88, 623, 19, 70, "Usage",
 CellID->6485]
}, Open  ]],
Cell[CellGroupData[{
Cell[3824, 112, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4302, 129, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4425, 135, 974, 34, 70, "Notes",
 CellID->16133],
Cell[5402, 171, 789, 28, 70, "Notes",
 CellID->9639],
Cell[6194, 201, 417, 13, 70, "Notes",
 CellID->20594],
Cell[6614, 216, 275, 8, 70, "Notes",
 CellID->89921497],
Cell[6892, 226, 246, 7, 70, "Notes",
 CellID->31226],
Cell[7141, 235, 229, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[7407, 247, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->45705950],
Cell[CellGroupData[{
Cell[7791, 261, 148, 5, 70, "ExampleSection",
 CellID->168435305],
Cell[7942, 268, 64, 1, 70, "ExampleText",
 CellID->103289786],
Cell[CellGroupData[{
Cell[8031, 273, 163, 4, 28, "Input",
 CellID->219125055],
Cell[8197, 279, 175, 5, 36, "Output",
 CellID->50401747]
}, Open  ]],
Cell[8387, 287, 125, 3, 70, "ExampleDelimiter",
 CellID->348976950],
Cell[CellGroupData[{
Cell[8537, 294, 267, 8, 28, "Input",
 CellID->269007598],
Cell[8807, 304, 2254, 41, 140, "Output",
 Evaluatable->False,
 CellID->623362145]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11110, 351, 220, 7, 70, "ExampleSection",
 CellID->485893928],
Cell[11333, 360, 70, 1, 70, "ExampleText",
 CellID->379827554],
Cell[CellGroupData[{
Cell[11428, 365, 244, 8, 70, "Input",
 CellID->468769707],
Cell[11675, 375, 235, 7, 36, "Output",
 CellID->245969362]
}, Open  ]],
Cell[11925, 385, 125, 3, 70, "ExampleDelimiter",
 CellID->169489262],
Cell[12053, 390, 113, 3, 70, "ExampleText",
 CellID->862606097],
Cell[CellGroupData[{
Cell[12191, 397, 177, 5, 70, "Input",
 CellID->70235645],
Cell[12371, 404, 218, 6, 36, "Output",
 CellID->554432784]
}, Open  ]],
Cell[12604, 413, 124, 3, 70, "ExampleDelimiter",
 CellID->84094409],
Cell[12731, 418, 74, 1, 70, "ExampleText",
 CellID->742245473],
Cell[CellGroupData[{
Cell[12830, 423, 308, 10, 70, "Input",
 CellID->194847399],
Cell[13141, 435, 2228, 61, 113, "Output",
 CellID->246649471]
}, Open  ]],
Cell[15384, 499, 125, 3, 70, "ExampleDelimiter",
 CellID->398914894],
Cell[15512, 504, 202, 7, 70, "ExampleText",
 CellID->13074565],
Cell[CellGroupData[{
Cell[15739, 515, 203, 6, 70, "Input",
 CellID->922305493],
Cell[15945, 523, 400, 14, 54, "Output",
 CellID->149212460]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16394, 543, 242, 7, 70, "ExampleSection",
 CellID->14588835],
Cell[16639, 552, 238, 7, 70, "ExampleText",
 CellID->279459999],
Cell[CellGroupData[{
Cell[16902, 563, 314, 9, 70, "Input",
 CellID->250610554],
Cell[17219, 574, 335, 10, 36, "Output",
 CellID->920817294]
}, Open  ]],
Cell[17569, 587, 125, 3, 70, "ExampleDelimiter",
 CellID->468367845],
Cell[17697, 592, 84, 1, 70, "ExampleText",
 CellID->243514930],
Cell[CellGroupData[{
Cell[17806, 597, 192, 6, 70, "Input",
 CellID->444630360],
Cell[18001, 605, 175, 5, 36, "Output",
 CellID->24877512]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18225, 616, 227, 7, 70, "ExampleSection",
 CellID->588164932],
Cell[18455, 625, 137, 4, 70, "ExampleText",
 CellID->288165617],
Cell[18595, 631, 387, 12, 70, "Input",
 CellID->3528651],
Cell[18985, 645, 105, 2, 70, "ExampleText",
 CellID->499060203],
Cell[CellGroupData[{
Cell[19115, 651, 1535, 47, 70, "Input",
 CellID->119081168],
Cell[20653, 700, 3173, 56, 70, "Output",
 Evaluatable->False,
 CellID->364051070]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23875, 762, 236, 7, 70, "ExampleSection",
 CellID->26008275],
Cell[24114, 771, 363, 12, 70, "ExampleText",
 CellID->100339472],
Cell[CellGroupData[{
Cell[24502, 787, 156, 4, 70, "Input",
 CellID->143097721],
Cell[24661, 793, 176, 5, 36, "Output",
 CellID->532280534]
}, Open  ]],
Cell[CellGroupData[{
Cell[24874, 803, 146, 4, 70, "Input",
 CellID->445931233],
Cell[25023, 809, 176, 5, 36, "Output",
 CellID->402163014]
}, Open  ]],
Cell[25214, 817, 124, 3, 70, "ExampleDelimiter",
 CellID->74630012],
Cell[25341, 822, 75, 1, 70, "ExampleText",
 CellID->109144439],
Cell[CellGroupData[{
Cell[25441, 827, 412, 13, 70, "Input",
 CellID->448166484],
Cell[25856, 842, 453, 8, 70, "Message",
 CellID->346099912],
Cell[26312, 852, 621, 22, 43, "Output",
 CellID->430139711]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26982, 880, 230, 7, 70, "ExampleSection",
 CellID->349615119],
Cell[27215, 889, 364, 12, 70, "ExampleText",
 CellID->9654031],
Cell[CellGroupData[{
Cell[27604, 905, 163, 4, 70, "Input",
 CellID->214415996],
Cell[27770, 911, 243, 7, 36, "Output",
 CellID->118833319]
}, Open  ]],
Cell[28028, 921, 125, 3, 70, "ExampleDelimiter",
 CellID->151853234],
Cell[28156, 926, 553, 20, 70, "ExampleText",
 CellID->594351452],
Cell[CellGroupData[{
Cell[28734, 950, 251, 9, 70, "Input",
 CellID->5986270],
Cell[28988, 961, 263, 9, 53, "Output",
 CellID->24448184]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29312, 977, 311, 9, 70, "SeeAlsoSection",
 CellID->29415],
Cell[29626, 988, 980, 35, 70, "SeeAlso",
 CellID->2922]
}, Open  ]],
Cell[CellGroupData[{
Cell[30643, 1028, 314, 9, 70, "TutorialsSection",
 CellID->29739],
Cell[30960, 1039, 143, 3, 70, "Tutorials",
 CellID->7204]
}, Open  ]],
Cell[CellGroupData[{
Cell[31140, 1047, 321, 9, 70, "RelatedLinksSection",
 CellID->11387],
Cell[31464, 1058, 176, 4, 70, "RelatedLinks"],
Cell[31643, 1064, 207, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[31887, 1073, 318, 9, 70, "MoreAboutSection",
 CellID->51283454],
Cell[32208, 1084, 165, 3, 70, "MoreAbout",
 CellID->290692335],
Cell[32376, 1089, 181, 3, 70, "MoreAbout",
 CellID->15674728],
Cell[32560, 1094, 143, 3, 70, "MoreAbout",
 CellID->8422701]
}, Open  ]],
Cell[32718, 1100, 27, 0, 70, "History"],
Cell[32748, 1102, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

