(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     37215,       1286]
NotebookOptionsPosition[     29770,       1026]
NotebookOutlinePosition[     31209,       1066]
CellTagsIndexPosition[     31123,       1061]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Discrete Distributions" :> 
          Documentation`HelpLookup["paclet:tutorial/DiscreteDistributions"], 
          "Continuous Distributions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ContinuousDistributions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Discrete Distributions\"\>", 
       2->"\<\"Continuous Distributions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CDF" :> Documentation`HelpLookup["paclet:ref/CDF"], "Quantile" :> 
          Documentation`HelpLookup["paclet:ref/Quantile"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"CDF\"\>", 
       2->"\<\"Quantile\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Descriptive Statistics" :> 
          Documentation`HelpLookup["paclet:guide/DescriptiveStatistics"], 
          "New in 6.0: Statistics" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60Statistics"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Descriptive Statistics\"\>", 
       2->"\<\"New in 6.0: Statistics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["InverseCDF", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InverseCDF",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InverseCDF"], "[", 
       RowBox[{
        StyleBox["dist", "TI"], ",", 
        StyleBox["q", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the inverse of the cumulative distribution \
function for the symbolic distribution ",
     Cell[BoxData[
      StyleBox["dist", "TI"]], "InlineFormula"],
     " as a function of the variable ",
     Cell[BoxData[
      StyleBox["q", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The inverse CDF at ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 " is also referred to as the ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " quantile of a distribution."
}], "Notes",
 CellID->8281],

Cell[TextData[{
 "For a continuous distribution ",
 Cell[BoxData[
  StyleBox["dist", "TI"]], "InlineFormula"],
 " the inverse CDF at ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 " is the value ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " such that ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["CDF",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CDF"], "[", 
    RowBox[{
     StyleBox["dist", "TI"], ",", 
     StyleBox["x", "TI"]}], "]"}], "=", 
   StyleBox["q", "TI"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->362874503],

Cell[TextData[{
 "For a discrete distribution ",
 Cell[BoxData[
  StyleBox["dist", "TI"]], "InlineFormula"],
 " the inverse CDF at ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 " is the largest integer ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " such ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["CDF",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CDF"], "[", 
    RowBox[{
     StyleBox["dist", "TI"], ",", 
     StyleBox["x", "TI"]}], "]"}], "\[LessEqual]", 
   StyleBox["q", "TI"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->529769856],

Cell[TextData[{
 "The value ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 " can be symbolic or any number between 0 and 1."
}], "Notes",
 CellID->128083967]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->59635119],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->144837843],

Cell["\<\
Inverse CDFs for a normal distribution and a Bernoulli distribution:\
\>", "Notes",
 CellID->431130830],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseCDF", "[", 
  RowBox[{
   RowBox[{"NormalDistribution", "[", 
    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "q"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->617514039],

Cell[BoxData[
 RowBox[{"\[Mu]", "+", 
  RowBox[{
   SqrtBox["2"], " ", "\[Sigma]", " ", 
   RowBox[{"InverseErf", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"2", " ", "q"}]}], "]"}]}]}]], "Output",
 ImageSize->{189, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->418394539]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseCDF", "[", 
  RowBox[{
   RowBox[{"BernoulliDistribution", "[", "p", "]"}], ",", "q"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->53095017],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9U8EOgjAMHWxTNEDiRYleIPotcuIjFmICB6JB/n+WUdE0PSyGuGTr3vra
12ZpZYbm1pmhrU1e9ubRtPUzv957eJKBEKKCfcgE3C3c3K6sBSvhlADLGYkR
Wrf+/HrEWgq0K5Z1IrggWLNRYy4NMAGrwGrij9Cfol+5LCGcIaAtYcdOaMaO
O9XLsVOWLWeFb+7GSylCpYjpXb+rX1Txl97oH9BqY4JD5l84vZFHuwi8FBOM
xgLd2nlwlFf2M8F7NmqN+S9oM5a15Ix95nuaeRG8AKfrH7c=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{77, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->174460851]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["Obtain exact numeric results:", "ExampleText",
 CellID->659006259],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseCDF", "[", 
  RowBox[{
   RowBox[{"ChiSquareDistribution", "[", "10", "]"}], ",", 
   RowBox[{"1", "/", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->191583331],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"InverseGammaRegularized", "[", 
   RowBox[{"5", ",", "0", ",", 
    FractionBox["1", "3"]}], "]"}]}]], "Output",
 ImageSize->{237, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->476046370]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseCDF", "[", 
  RowBox[{
   RowBox[{"PoissonDistribution", "[", "10", "]"}], ",", 
   RowBox[{"1", "/", "3"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->359728176],

Cell[BoxData["9"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->90135786]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15255080],

Cell["\<\
Obtain a machine\[Hyphen]precision result:\
\>", "ExampleText",
 CellID->416017623],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseCDF", "[", 
  RowBox[{
   RowBox[{"ChiSquareDistribution", "[", "10", "]"}], ",", ".3"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->610607049],

Cell[BoxData["7.2672181659276065`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->473982307]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19374803],

Cell["\<\
Obtain a result at any precision for continuous distributions:\
\>", "ExampleText",
 CellID->157989833],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseCDF", "[", 
  RowBox[{
   RowBox[{"ChiSquareDistribution", "[", "10", "]"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"3", "/", "10"}], ",", "30"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->235751636],

Cell[BoxData["7.267218165927606266225706020031403600426694761641`30."], \
"Output",
 ImageSize->{221, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->151579439]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->457132839],

Cell[TextData[{
 "Obtain an exact result at any precision ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 " for discrete distributions:"
}], "ExampleText",
 CellID->576110967],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseCDF", "[", 
  RowBox[{
   RowBox[{"GeometricDistribution", "[", 
    RowBox[{"1", "/", "5"}], "]"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"3", "/", "4"}], ",", "30"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->191591077],

Cell[BoxData["6"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9813212]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell["Plot the inverse CDF for a standard normal distribution:", "ExampleText",
 CellID->526665614],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"InverseCDF", "[", 
    RowBox[{
     RowBox[{"NormalDistribution", "[", 
      RowBox[{"0", ",", "1"}], "]"}], ",", "q"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->346682293],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9mGuIVVUUx7f33JdjZup4HSJoiIKgD0FERGQFYhERERQVIjROj5kPpugE
YQRG78gC7THTWFOaQY8PRqIEBpEQCZEQCVFBGIR9SIKkDwPB6bfX2ufcs/fZ
Z+ZMmJeZe/faZ73Xf+3HuX1kYuzBTSMT46Mjw7dsHdkyNj66bfjmzVuZShYZ
Yw7y//CQYZwykv+DacrvMr4bkPtyyiT2qXzMXn/21Km//NmIZImnPNvm2062
PQ2LA9tJRv/04x99WZ3Wj5VtVkkd//a3vlTHWcos62w3kM11HT70Q1+20q9P
DpyYL6Y8/uee/WLezN1260wkc/fc/T7JCyRN8vmRn50/7/j8+I6xUMuZM7Oo
L/jaZLKVa3t8+2dHv/ylr61TiNk4TtNUGkbY341WI0nTckZbOb35kU8pi7MR
y2si3pw8+efoxo9nZ/8xM9UVaOc0n/3vHZ+aPDaTR5f5qt61AvmG0E/uOKJJ
NG+VMNKPBS+I9tjXvzqusEOUi/QSG5kxe7w6tQo6Zt7+xkxHdYjHCc8fnTh0
+vTfZirKpTXBkw3rP/jow+/MpGdJctTEj927viJ5pPn1qJYB4aOl8BdzDF6N
8p0nfFhDGXzo25VnKSlgR+Ra8KEPVtBn6/ZKOmd/OfoCkcUFAAvMqaBF+s76
yCrQKySRZA8ooAtv1JUXKz2x5CrxgODwgP4AEraGz9fyfrUUBROgiPKqOGMb
/9O1NTSy9qJ0CEOsW7tH4DtYxGG/h1xaeh5KC9h2UVU967nIG5FnSV7hYh9I
nF4/SRxtmylZtPgm6ZRxeYmzHVhZGdflzdTh6QV6kxKHxFdCdS/uYZfBie9/
B4BA+M479oEGakFFlkZ9yapzriOJV0PWhYF8hhYA+UCRyhANMdGcA3FPCiv8
qv8UT7YKrD5r9egEHOJFB3ABMdahG9dM0doslXYfia/0jcpokpp1O3voKuuW
SnTwnhiIxIunsYB4wj3t/8DaUOqvBBJvO/AdgDUidctWr2w1GQx09dLIblvK
6NX2q4tFrT5LI5De+dJREM5W8VBU5lqRATGcz3RjoaPpB/ZMJjd6Ea6x1GJa
hnbXjRMTWhC6hgXAbIjauEnkWOk1GbhGt7EvYw+rmDH3ReXWiRznGwIgjIi9
u0TO7r77K7MS1n4+Otx3Fipfi16idDk25l1s58SPheahlN3rA3plRa0VhsRr
hgOJS3O9FmP3WqoLn+IRSfDIgQE8suesjfqwPnW4ZJMFl+NjB4o4sSeMGzwb
95d8hB8pZNFgc39d1M4D4htu4IyeYShbLnRNVGYsdf1VlNFtBgeu8vzalHqr
twahhwVzZVT7ltStj7oZ66mKPNtz8RVRiW0ioccn8ktykcOGrczlImHPYYlb
Ea1Xj9nZNj5gg3LwR8iQlwl35X3P0dtFGu3EjyXWF5W+pJb0EyLN4pVL4wTK
Lq6UtuSOTIq4cJfK6un2olo2nxKwU2VNjztnX1hL9hmRJbt6rqYYtnZDeV6z
W479fcHONikDgelVrxetmJzJmzzO7yCDHmrkBuDuHnQZxldE9bwsNG1FSuwN
bXmUS+4iTfCDKRJA1pZ51uRek5BPsmpRdn5Ui3LhKlw2e0ujXLuF5jmRWS65
Rcke2Czg77WAa0mezeKJLFytVIqsEYddAQZq1U9ugYnej+1Q+FU2uBFbUrnR
TpS2ztXcRfoNofW9gB1286irz5x2KDfYRF9w2GEniiq5DSe0C23W5wozP5nl
FHU+l9XxpjwFTu5dUjuqQy2BOPdmZy4ufc3ic/Ut0WtkcD4d+lKmmkt10bHA
0g5beV6LN/DpIIutWjVT3dqlC5Xqvy1qlSqW5DkgPe49mnLNh9S4VD2PQql4
jgAQMOpzxfLdYPv0Kzpdmi3JkMP4071zzJpF/wJopN2e\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->97992544]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->331526780],

Cell["Plot the inverse CDF for a binomial distribution:", "ExampleText",
 CellID->57844831],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"InverseCDF", "[", 
    RowBox[{
     RowBox[{"BinomialDistribution", "[", 
      RowBox[{"20", ",", ".5"}], "]"}], ",", "q"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->224981200],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWM1rU0EQ32ZfUluoRG3TDxV6US/1T1APYouIiAcR/DikQWgPWqnpwY+z
9SZYDxarRW0Lam+WiqAgCoIgFjyJCtKD9GIRLB48PWdmd/v2K8lLzAsIhmTz
duc3s7+Z2Z1d3uF8cejM2XxxuJDvHRjNnx8aLlzo7R8ZhSHexBhbgN/FLgbP
ITzRbyEM4d9td0GbAgDHHkckjjJ67NBlaSETH0TkPJr4mIohw6GUR0Z4thPb
IJIwlrbYtTuIjGVti4MInBHXiovJWXa5g0iV4ByPURCTR7Jcmy3Nzf7ZtAx0
1MQZ84h57kyQqZrDz5DH5F57LKuJg8skbc1bz7yrvZ6R/2qX2jFt18YVS5+e
6otdq1eVNsviTJnRVmjnlF8RZmXlJz7a8fjfN/tBHHzdo7q9yv62WKxmKozi
WputSfOfmGXp/TeP5l+NembZt2fSo2mMYna4XosM6QYrl6nYKOwyDjDJ815p
e9FtY/zqy6eLH9l9wqqKk66AcXZICayqcOUwKo5U5h4/+gD8WYANLwzOy7ze
NqMpZxZMRs49kf42EAU8AchasOGCJIquGx6Juj999x0owJe1YMOPH5tz0M6J
y0WyG4wCb9ChLHn1+dN3Kb9ieEX3LA4plF5lyasD+6dWV3+ZaH2OHdQH32VG
G4h68fwLOtRJXgmSKBo0vKJ7Bp+dWZJe5cgrWIFjxUUUFbxz7KU+GAZ0hJJH
rfykQm1PVdSl3eneLXz1ICk7EDJYs6wHGy62A4r6q7CLXWFvbe032EFT3WRv
4sYbsQHYQI08T1AfUp+IHXnZYqog+TLn17TXxjrq0MFpdL2L/Id4SHnfuhbO
cYrQUFZktHKEhvUHhRJFu71zFEO5FxuPunzpGVLcRDyjWtFteDWmYiC9yhIa
Fir8o6jHO8c4agNiayJSVZGRSivxiep3m8H+Wmiu4BYrJxu9c0xYcUwGhfxu
Kunpkw+pXFEDO0wsMnHyl7AJdVBWe04NeCVPPr8WXT2081Gg5EVTfpSKvV/8
uvZ+dN5l1M0Kdkk7gGIOjoINOBOaa2cRiOhN3noLwdfsRPUn9FcOulVwSCbo
4WMm0nXe/9j3LL+uXq+CULttVdRUq2iKpK9ffT165MHy8g9NqtsQKNj0ciWm
y6Ci9ZoMClnfISmsdSiZ5W1gNSjtU/2kilWj5qsvm6DMTcVEqoWnt5XOWtNC
9We1qW+/Sy11AyEtWNjxtdy3Jyyj84zHVmp6bhLzNOS+JWZNfwDYCDOL\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->198462296]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->245574851],

Cell["Generate a random number from a distribution:", "ExampleText",
 CellID->183677565],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseCDF", "[", 
  RowBox[{
   RowBox[{"StudentTDistribution", "[", "20", "]"}], ",", 
   RowBox[{"RandomReal", "[", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->353828563],

Cell[BoxData["0.43072959389164744`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->180604569]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseCDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseCDF"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["CDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CDF"]], "InlineFormula"],
 " are inverses for continuous distributions:"
}], "ExampleText",
 CellID->203272416],

Cell[BoxData[
 RowBox[{
  RowBox[{"dist", "=", 
   RowBox[{"ExponentialDistribution", "[", "\[Lambda]", "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->410116367],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"y", ">", "0"}], "&&", 
    RowBox[{"\[Lambda]", ">", "0"}]}], ",", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"InverseCDF", "[", 
      RowBox[{"dist", ",", 
       RowBox[{"CDF", "[", 
        RowBox[{"dist", ",", "y"}], "]"}]}], "]"}], "\[Equal]", "y"}], 
    "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->142961085],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->570730178]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", ">", "q", ">", "0"}], "&&", 
    RowBox[{"\[Lambda]", ">", "0"}]}], ",", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"CDF", "[", 
      RowBox[{"dist", ",", 
       RowBox[{"InverseCDF", "[", 
        RowBox[{"dist", ",", "q"}], "]"}]}], "]"}], "\[Equal]", "q"}], 
    "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->66031175],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->49188515]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26722913],

Cell[TextData[{
 "Compositions of ",
 Cell[BoxData[
  ButtonBox["InverseCDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseCDF"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["CDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CDF"]], "InlineFormula"],
 " give step functions for a discrete distribution:"
}], "ExampleText",
 CellID->558267465],

Cell[BoxData[
 RowBox[{
  RowBox[{"dist", "=", 
   RowBox[{"PoissonDistribution", "[", "2", "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->286444275],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{"dist", ",", 
     RowBox[{"InverseCDF", "[", 
      RowBox[{"dist", ",", "q"}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->398800],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWL1rFEEUf9nZuxQakEtyKlqk8/wLbAwWoqksxXpziJdCE+LZaKloY6MW
EhBFAoJgZ4jYiYKVaCtaSApJYxAMFlbre7Mz6+TN3O3MRjcrZNl9uzPvvd++
r52PPZP0e+cvJv25bjI1s5gs9Oa6l6dOzy9ilxgBgBW8Fg4APqf4JK+VNMW7
TY8ijVBAUEuQJPWCfJw0eY2Mlx3AuSLnQlTAa+MDdUUOnpSHDtH4Dwegwayb
sCSaDK1lScRWz7iHTJvhCktC+gH7mNxkoYXut8eedlVr+6hfdIdmyMcHyjPV
wf5Qy+cvPccTWkTie3ffbm7+MuQMpEZa5Im2we2B8PQtOPYf3n/FE1pE4u7s
M7y7PYgsJNuewT5w//92HUV5XjEVmQ+qt6nubXXnNTVu9GvbXXq6LbbGz8yn
yN8Nt2stNYZ0Wce8UIdHjOeSt8dYe6JA/nAg/l4Xf4dindddDbK661t1Vqth
QB7udYpzxLdxhs7VfB3jg6Fn87ikrjmbkg/UzHVv3Xz16OE76BARnz99U5qJ
A0vPBe44oBGIQTBHJNa1qy8Rm1izAVjHZfvF6setukZu+NjFI+pG4DWwXSmy
fbqSN+1aXSffrFGC7Ts867lgncS/9PIoBFKtDaJkFLiO5/vZyBB5W16DyrrS
X6VFeoeIWFv7rvjHhmihlNqhdIiIUycfDNW6INsnppcsKfKqN5Drh1FXqWp8
Cx0LBqAEfofVoZhzNKn+B/YbGdG7O78s/Lvawh04CuIJB4nQF7ux8ZNYh5xa
12X73Nkn6+s/dlqKfL1RI3tCrcYhUsV+j459NsxmO1oL847WUivqECm19VaH
658kr0Q3Dte0/5HwbyHDwSlH+SokwbpT/NGSuPdTVeW4nsfZKgiHBKR+/Ob1
F9TPprpmSUseb0vPNSo8lV32X2wY+Q3nQY1y\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->140401882]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"InverseCDF", "[", 
    RowBox[{"dist", ",", 
     RowBox[{"CDF", "[", 
      RowBox[{"dist", ",", "y"}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->388428965],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWE1IVFEUfvpmxkhsE0XQn+bYpp9FapuyFqYRJhFlLcxgGgyl1NCxRX+r
so0UlFSC5CKL/hZBYgQFURAJkRAFUUEYhC2SIGkhBK9zzr1v7rtn7oyvGuf1
mLlv7jvf+b/n3DuvPpZoaW6LJVrjseKtnbEjLa3xruLajk54ZOdZljUM36OL
LPjtwC/6DjsO3FPHdTDaAIjKez7c8+FeIudWiGDywqchD8omYiWOCHboslbg
EFJzgfcilrO5baKHxTw5khR0Lw/vs6S52ChhtrWWeOZmT8tlxMv86VIIyRf1
pcErJ+pPU9irCSVTNCJevnRxrJC2lTpqNblrL18uPe/cdryrzruKi5hlQxme
zoXxpuuNwoy9+gIfK4wDzicmfpB7TEbQ88h/Zg+f28bIC9TehhsyqksZvYzN
V85A96dlIBuoixeeD159aYVxsO/cfi3pfUkuXJEiK8+efgKUQtdtG5Q6+ow6
ipglOUQ9fvRRrfa3b75Keq/m1TxCXx8a62i/Dx8rjINdUz0gdfQadSxglgSJ
Qi8WEvX4sYebq/rhY4VxQC/Gx78j6bRRplih4DBEKGgUerHM9SJ+4K7KRXdi
ZHLyJ5JOZJA5NTWtdTcQIXWYucqYJQKFFYEgXvFm9ByG4nvHP3Kd7XmCJRah
OhNpR1JXWim2u3faH95/06oUovFg5B2SEsQdkRHnfq6hOShOQXtRIV9cBY7a
4WZG8/wkUf1XRjGhEcrq9PQvST+krZy1hB598Vmr4p07rkkdh406KpklQaLQ
i/VEhf4rqzhCVSygSIobZVYhN2S5OQdUtHKTayU0IwxzhGIN+4LkajTKQq4C
yqFY1vhsnxFZI7U2ZYWKFtcSCnq8ZjHUiOTalVYWrTitryjrdxu56qUFDUTV
/1m4/yh41ek81A8ynkn5PBv8lg0CIC6mjlP3B3JxKuQBv9aDoK9D8JC0/S/t
JP+wHmZFjjxw0eWewnmmzJx8DSRRsHWZeld1kgt17CE0nE+03tXUeAtOZUja
YtTRxCwJEoVe7CcqOKr1LuECkjYYZTa7XOAz/twYIAq9OOjmAo61qlOoE3G5
UWaSS3aKEOUbuKSOCiNXG7Mkhyjog6Y6X6XFop3QsGqhcaoqhuRLHauNOrqZ
JQIlCsm9XBZeXWZeXr38vQKnZ1mKOEjKGhYHUSSV+paKUyENuKEjqBpvbbkH
0pEUVdJS3mrwKJ2kOWQNssh4U95T8JObmdfb+dz3EfzUZubk2U+PQpmniAon
dagu1SNEmpC02CjzDJO5JEAUetHj5hL+XqkeoTrdfKNMwQVnDu00AQHIyHWO
5oGgtL1bnUELtVicJzRQNbTSUWjUcYlZkkOUFn11AlTvWtCry/QIMqrtyGLb
09F+38dZeb8B5sjAVQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->715779811]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->683712],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseCDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseCDF"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  ButtonBox["Quantile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quantile"]], "InlineFormula"],
 " for distributions:"
}], "ExampleText",
 CellID->958682470],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseCDF", "[", 
  RowBox[{
   RowBox[{"CauchyDistribution", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", "q"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->54070942],

Cell[BoxData[
 RowBox[{"a", "+", 
  RowBox[{"b", " ", 
   RowBox[{"Tan", "[", 
    RowBox[{"\[Pi]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], "+", "q"}], ")"}]}], "]"}]}]}]], "Output",
 ImageSize->{133, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->277912383]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantile", "[", 
  RowBox[{
   RowBox[{"CauchyDistribution", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", "q"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26145892],

Cell[BoxData[
 RowBox[{"a", "+", 
  RowBox[{"b", " ", 
   RowBox[{"Tan", "[", 
    RowBox[{"\[Pi]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], "+", "q"}], ")"}]}], "]"}]}]}]], "Output",
 ImageSize->{133, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->20929670]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell["Symbolic closed forms do not exist for some distributions:", \
"ExampleText",
 CellID->414643541],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseCDF", "[", 
  RowBox[{
   RowBox[{"BinomialDistribution", "[", 
    RowBox[{"50", ",", ".5"}], "]"}], ",", "q"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10975216],

Cell[BoxData[
 RowBox[{"InverseCDF", "[", 
  RowBox[{
   RowBox[{"BinomialDistribution", "[", 
    RowBox[{"50", ",", "0.5`"}], "]"}], ",", "q"}], "]"}]], "Output",
 ImageSize->{307, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->317216717]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseCDF", "[", 
  RowBox[{
   RowBox[{"BinomialDistribution", "[", 
    RowBox[{"50", ",", ".5"}], "]"}], ",", ".75"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->881203487],

Cell[BoxData["27"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->134755224]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CDF",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CDF"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Quantile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quantile"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Discrete Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DiscreteDistributions"]], "Tutorials",
 CellID->4738],

Cell[TextData[ButtonBox["Continuous Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ContinuousDistributions"]], "Tutorials",
 CellID->7471]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Descriptive Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DescriptiveStatistics"]], "MoreAbout",
 CellID->93210454],

Cell[TextData[ButtonBox["New in 6.0: Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60Statistics"]], "MoreAbout",
 CellID->32703887]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InverseCDF - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 49, 41.4943462}", "context" -> "System`", 
    "keywords" -> {
     "cumulative distribution function", "inverse CDF", 
      "inverse cumulative distribution function", 
      "inverse distribution function", "quantile"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "InverseCDF[dist, q] gives the inverse of the cumulative distribution \
function for the symbolic distribution dist as a function of the variable q.",
     "synonyms" -> {}, "title" -> "InverseCDF", "type" -> "Symbol", "uri" -> 
    "ref/InverseCDF"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7354, 238, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->59635119]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 30981, 1054}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2137, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2760, 78, 1575, 37, 70, "ObjectNameGrid"],
Cell[4338, 117, 780, 24, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5155, 146, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5633, 163, 328, 12, 70, "Notes",
 CellID->8281],
Cell[5964, 177, 581, 23, 70, "Notes",
 CellID->362874503],
Cell[6548, 202, 595, 23, 70, "Notes",
 CellID->529769856],
Cell[7146, 227, 171, 6, 70, "Notes",
 CellID->128083967]
}, Closed]],
Cell[CellGroupData[{
Cell[7354, 238, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->59635119],
Cell[CellGroupData[{
Cell[7738, 252, 148, 5, 70, "ExampleSection",
 CellID->144837843],
Cell[7889, 259, 113, 3, 70, "Notes",
 CellID->431130830],
Cell[CellGroupData[{
Cell[8027, 266, 211, 6, 28, "Input",
 CellID->617514039],
Cell[8241, 274, 348, 12, 38, "Output",
 CellID->418394539]
}, Open  ]],
Cell[CellGroupData[{
Cell[8626, 291, 180, 6, 28, "Input",
 CellID->53095017],
Cell[8809, 299, 503, 12, 44, "Output",
 Evaluatable->False,
 CellID->174460851]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9361, 317, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[9585, 326, 72, 1, 70, "ExampleText",
 CellID->659006259],
Cell[CellGroupData[{
Cell[9682, 331, 203, 6, 70, "Input",
 CellID->191583331],
Cell[9888, 339, 288, 9, 51, "Output",
 CellID->476046370]
}, Open  ]],
Cell[CellGroupData[{
Cell[10213, 353, 201, 6, 70, "Input",
 CellID->359728176],
Cell[10417, 361, 157, 5, 36, "Output",
 CellID->90135786]
}, Open  ]],
Cell[10589, 369, 124, 3, 70, "ExampleDelimiter",
 CellID->15255080],
Cell[10716, 374, 93, 3, 70, "ExampleText",
 CellID->416017623],
Cell[CellGroupData[{
Cell[10834, 381, 183, 6, 70, "Input",
 CellID->610607049],
Cell[11020, 389, 176, 5, 36, "Output",
 CellID->473982307]
}, Open  ]],
Cell[11211, 397, 124, 3, 70, "ExampleDelimiter",
 CellID->19374803],
Cell[11338, 402, 113, 3, 70, "ExampleText",
 CellID->157989833],
Cell[CellGroupData[{
Cell[11476, 409, 261, 8, 70, "Input",
 CellID->235751636],
Cell[11740, 419, 214, 6, 36, "Output",
 CellID->151579439]
}, Open  ]],
Cell[11969, 428, 125, 3, 70, "ExampleDelimiter",
 CellID->457132839],
Cell[12097, 433, 188, 6, 70, "ExampleText",
 CellID->576110967],
Cell[CellGroupData[{
Cell[12310, 443, 284, 9, 70, "Input",
 CellID->191591077],
Cell[12597, 454, 156, 5, 36, "Output",
 CellID->9813212]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12802, 465, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[13032, 474, 99, 1, 70, "ExampleText",
 CellID->526665614],
Cell[CellGroupData[{
Cell[13156, 479, 320, 10, 70, "Input",
 CellID->346682293],
Cell[13479, 491, 2147, 39, 70, "Output",
 Evaluatable->False,
 CellID->97992544]
}, Open  ]],
Cell[15641, 533, 125, 3, 70, "ExampleDelimiter",
 CellID->331526780],
Cell[15769, 538, 91, 1, 70, "ExampleText",
 CellID->57844831],
Cell[CellGroupData[{
Cell[15885, 543, 324, 10, 70, "Input",
 CellID->224981200],
Cell[16212, 555, 1489, 28, 70, "Output",
 Evaluatable->False,
 CellID->198462296]
}, Open  ]],
Cell[17716, 586, 125, 3, 70, "ExampleDelimiter",
 CellID->245574851],
Cell[17844, 591, 88, 1, 70, "ExampleText",
 CellID->183677565],
Cell[CellGroupData[{
Cell[17957, 596, 211, 6, 70, "Input",
 CellID->353828563],
Cell[18171, 604, 177, 5, 36, "Output",
 CellID->180604569]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18397, 615, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[18638, 624, 343, 12, 70, "ExampleText",
 CellID->203272416],
Cell[18984, 638, 175, 6, 70, "Input",
 CellID->410116367],
Cell[CellGroupData[{
Cell[19184, 648, 420, 14, 70, "Input",
 CellID->142961085],
Cell[19607, 664, 161, 5, 36, "Output",
 CellID->570730178]
}, Open  ]],
Cell[CellGroupData[{
Cell[19805, 674, 429, 14, 70, "Input",
 CellID->66031175],
Cell[20237, 690, 160, 5, 36, "Output",
 CellID->49188515]
}, Open  ]],
Cell[20412, 698, 124, 3, 70, "ExampleDelimiter",
 CellID->26722913],
Cell[20539, 703, 370, 13, 70, "ExampleText",
 CellID->558267465],
Cell[20912, 718, 160, 5, 70, "Input",
 CellID->286444275],
Cell[CellGroupData[{
Cell[21097, 727, 308, 10, 70, "Input",
 CellID->398800],
Cell[21408, 739, 1164, 23, 70, "Output",
 Evaluatable->False,
 CellID->140401882]
}, Open  ]],
Cell[CellGroupData[{
Cell[22609, 767, 312, 10, 70, "Input",
 CellID->388428965],
Cell[22924, 779, 1636, 31, 70, "Output",
 Evaluatable->False,
 CellID->715779811]
}, Open  ]],
Cell[24575, 813, 122, 3, 70, "ExampleDelimiter",
 CellID->683712],
Cell[24700, 818, 342, 12, 70, "ExampleText",
 CellID->958682470],
Cell[CellGroupData[{
Cell[25067, 834, 199, 6, 70, "Input",
 CellID->54070942],
Cell[25269, 842, 367, 13, 51, "Output",
 CellID->277912383]
}, Open  ]],
Cell[CellGroupData[{
Cell[25673, 860, 197, 6, 70, "Input",
 CellID->26145892],
Cell[25873, 868, 366, 13, 51, "Output",
 CellID->20929670]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26288, 887, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[26522, 896, 103, 2, 70, "ExampleText",
 CellID->414643541],
Cell[CellGroupData[{
Cell[26650, 902, 203, 6, 70, "Input",
 CellID->10975216],
Cell[26856, 910, 295, 9, 36, "Output",
 CellID->317216717]
}, Open  ]],
Cell[CellGroupData[{
Cell[27188, 924, 206, 6, 70, "Input",
 CellID->881203487],
Cell[27397, 932, 159, 5, 36, "Output",
 CellID->134755224]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27617, 944, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[27936, 955, 445, 17, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[28418, 977, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[28739, 988, 153, 3, 70, "Tutorials",
 CellID->4738],
Cell[28895, 993, 157, 3, 70, "Tutorials",
 CellID->7471]
}, Open  ]],
Cell[CellGroupData[{
Cell[29089, 1001, 299, 8, 70, "MoreAboutSection"],
Cell[29391, 1011, 154, 3, 70, "MoreAbout",
 CellID->93210454],
Cell[29548, 1016, 150, 3, 70, "MoreAbout",
 CellID->32703887]
}, Open  ]],
Cell[29713, 1022, 27, 0, 70, "History"],
Cell[29743, 1024, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

