(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     53174,       1855]
NotebookOptionsPosition[     43567,       1520]
NotebookOutlinePosition[     44908,       1557]
CellTagsIndexPosition[     44822,       1552]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals and Elliptic Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals and Elliptic Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EllipticNomeQ" :> 
          Documentation`HelpLookup["paclet:ref/EllipticNomeQ"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"EllipticNomeQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Functions" :> 
          Documentation`HelpLookup["paclet:guide/EllipticFunctions"], 
          "Elliptic Integrals" :> 
          Documentation`HelpLookup["paclet:guide/EllipticIntegrals"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Elliptic Functions\"\>", 
       2->"\<\"Elliptic Integrals\"\>", 
       3->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InverseEllipticNomeQ", "ObjectName",
 CellID->24618],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InverseEllipticNomeQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InverseEllipticNomeQ"], "[", 
       StyleBox["q", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the parameter ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " corresponding to the nome ",
     Cell[BoxData[
      StyleBox["q", "TI"]], "InlineFormula"],
     " in an elliptic function. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8124]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["InverseEllipticNomeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseEllipticNomeQ"], "[", 
   StyleBox["q", "TI"], "]"}]], "InlineFormula"],
 " yields the unique value of the parameter ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " which makes ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EllipticNomeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EllipticNomeQ"], "[", 
   StyleBox["m", "TI"], "]"}]], "InlineFormula"],
 " equal to ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10900],

Cell[TextData[{
 "The nome ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 " must always satisfy ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[LeftBracketingBar]", "q", "\[RightBracketingBar]"}], "<", 
    "1"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->4825],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseEllipticNomeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseEllipticNomeQ"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseEllipticNomeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseEllipticNomeQ"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->5949741],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->128041306],

Cell["Evaluate numerically:", "ExampleText",
 CellID->70611792],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseEllipticNomeQ", "[", "0.1", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->210043588],

Cell[BoxData["0.8024032982175767`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->46634327]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18898412],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"InverseEllipticNomeQ", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", " ", "0.6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->337243360],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->145905002]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->881134843],

Cell["Series expansion:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->751272945],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"InverseEllipticNomeQ", "[", "q", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", ",", "0", ",", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->564723879],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"16", " ", "q"}], "-", 
   RowBox[{"128", " ", 
    SuperscriptBox["q", "2"]}], "+", 
   RowBox[{"704", " ", 
    SuperscriptBox["q", "3"]}], "-", 
   RowBox[{"3072", " ", 
    SuperscriptBox["q", "4"]}], "+", 
   RowBox[{"11488", " ", 
    SuperscriptBox["q", "5"]}], "-", 
   RowBox[{"38400", " ", 
    SuperscriptBox["q", "6"]}], "+", 
   RowBox[{"117632", " ", 
    SuperscriptBox["q", "7"]}], "-", 
   RowBox[{"335872", " ", 
    SuperscriptBox["q", "8"]}], "+", 
   RowBox[{"904784", " ", 
    SuperscriptBox["q", "9"]}], "-", 
   RowBox[{"2320128", " ", 
    SuperscriptBox["q", "10"]}], "+", 
   RowBox[{"5702208", " ", 
    SuperscriptBox["q", "11"]}], "-", 
   RowBox[{"13504512", " ", 
    SuperscriptBox["q", "12"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "q", "]"}], "13"],
    SeriesData[$CellContext`q, 0, {}, 1, 13, 1],
    Editable->False]}],
  SeriesData[$CellContext`q, 0, {16, -128, 704, -3072, 11488, -38400, 
   117632, -335872, 904784, -2320128, 5702208, -13504512}, 1, 13, 1],
  Editable->False]], "Output",
 ImageSize->{461, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->141631359]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6812],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->295425803],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseEllipticNomeQ", "[", 
  RowBox[{"0.2", "-", 
   RowBox[{"0.3", " ", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->91963367],

Cell[BoxData[
 RowBox[{"0.9817691894091463`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.10358961714310295`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->163773913]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->745773765],

Cell["Evaluate to high precision:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->186880852],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"InverseEllipticNomeQ", "[", 
    RowBox[{"2", "/", "3"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->310855173],

Cell[BoxData["0.\
9999999995706938369117355358852765100062533091509960903440895972131`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10869836]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->54545494],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->75055808],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseEllipticNomeQ", "[", "0.666666666666666666666666666", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->382640901],

Cell[BoxData["0.99999999957069383691173553588525335214`25.829802236996887"], \
"Output",
 ImageSize->{193, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->34894770]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->420108127],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseEllipticNomeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseEllipticNomeQ"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->916053844],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseEllipticNomeQ", "[", 
  RowBox[{"{", 
   RowBox[{"0.2", ",", "0.3", ",", "0.4"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14133259],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.9658521935950791`", ",", "0.9956043683608315`", ",", 
   "0.9996641472708129`"}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->491566708]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->193311377],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->31216930],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseEllipticNomeQ", "[", "q", "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->143449975],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox[
    InterpretationBox["q",
     EllipticNomeQ,
     Editable->False,
     Selectable->False], 
    RowBox[{"-", "1"}]], "(", "q", ")"}], TraditionalForm]], "Output",
 ImageSize->{36, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->362105604]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32554],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseEllipticNomeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseEllipticNomeQ"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText",
 CellID->283059217],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseEllipticNomeQ", "[", 
  RowBox[{
   RowBox[{"Tan", "[", "q", "]"}], "+", 
   RowBox[{
    RowBox[{"O", "[", "q", "]"}], "^", "6"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16720936],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"16", " ", "q"}], "-", 
   RowBox[{"128", " ", 
    SuperscriptBox["q", "2"]}], "+", 
   FractionBox[
    RowBox[{"2128", " ", 
     SuperscriptBox["q", "3"]}], "3"], "-", 
   FractionBox[
    RowBox[{"9472", " ", 
     SuperscriptBox["q", "4"]}], "3"], "+", 
   FractionBox[
    RowBox[{"182912", " ", 
     SuperscriptBox["q", "5"]}], "15"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "q", "]"}], "6"],
    SeriesData[$CellContext`q, 0, {}, 1, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`q, 0, {16, -128, 
    Rational[2128, 3], 
    Rational[-9472, 3], 
    Rational[182912, 15]}, 1, 6, 1],
  Editable->False]], "Output",
 ImageSize->{321, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->177602759]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->277],

Cell["\<\
Convert between elliptic modulus and nome in elliptic function identities:\
\>", "ExampleText",
 CellID->95909029],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    FractionBox["\[Pi]", "2"], " ", 
    SuperscriptBox[
     RowBox[{"EllipticTheta", "[", 
      RowBox[{"3", ",", "0", ",", "q"}], "]"}], "2"]}], "==", 
   RowBox[{"EllipticK", "[", 
    RowBox[{"InverseEllipticNomeQ", "[", "q", "]"}], "]"}]}], ";"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->53286629],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"q", "\[Rule]", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "3"}], "/", "4"}], ",", 
       RowBox[{"3", "/", "4"}]}], "}"}], ",", 
     RowBox[{"{", "20", "}"}], ",", 
     RowBox[{"WorkingPrecision", "\[Rule]", "20"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->46398057],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->15407652]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->686280512],

Cell["\<\
Partition function for a one\[Hyphen]atom monatomic gas in a finite container \
of unit length:\
\>", "ExampleText",
 CellID->308362215],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SubscriptBox["Z", "1"], "[", "\[Beta]_", "]"}], " ", "=", " ", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"2", " ", "\[Pi]"}]], " ", 
      RowBox[{"EllipticK", "[", 
       RowBox[{"InverseEllipticNomeQ", "[", 
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{"-", "\[Beta]"}], " ", 
          SuperscriptBox["\[Pi]", "2"]}], "]"}], "]"}], "]"}]}], "]"}], "-", 
    FractionBox["1", "2"]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->673489268],

Cell[TextData[{
 "Form partition functions for ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " bosonic particles:"
}], "ExampleText",
 CellID->6486712],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SubscriptBox["Z", "0"], "[", "\[Beta]_", "]"}], "=", "1"}], ";", 
  RowBox[{
   RowBox[{
    SubscriptBox["Z", "n_"], "[", "\[Beta]_", "]"}], ":=", 
   RowBox[{"Expand", "[", 
    RowBox[{
     FractionBox["1", "n"], 
     RowBox[{
      SubsuperscriptBox["\[Sum]", 
       RowBox[{"j", "=", "1"}], "n"], 
      RowBox[{
       RowBox[{
        SubscriptBox["Z", "1"], "[", 
        RowBox[{"j", " ", "\[Beta]"}], "]"}], 
       RowBox[{
        SubscriptBox["Z", 
         RowBox[{"n", "-", "j"}]], "[", "\[Beta]", "]"}]}]}]}], 
    "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->39931723],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["Z", "3"], "[", "\[Beta]", "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->120280450],

Cell[BoxData[
 FormBox[
  RowBox[{
   FractionBox[
    SuperscriptBox[
     RowBox[{"K", "(", 
      RowBox[{
       SuperscriptBox[
        InterpretationBox["q",
         EllipticNomeQ,
         Editable->False,
         Selectable->False], 
        RowBox[{"-", "1"}]], "(", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["\[Pi]", "2"]}], " ", "\[Beta]"}]], ")"}], ")"}], 
     RowBox[{"3", "/", "2"}]], 
    RowBox[{"12", " ", 
     SqrtBox["2"], " ", 
     SuperscriptBox["\[Pi]", 
      RowBox[{"3", "/", "2"}]]}]], "-", 
   FractionBox[
    RowBox[{"K", "(", 
     RowBox[{
      SuperscriptBox[
       InterpretationBox["q",
        EllipticNomeQ,
        Editable->False,
        Selectable->False], 
       RowBox[{"-", "1"}]], "(", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["\[Pi]", "2"]}], " ", "\[Beta]"}]], ")"}], ")"}], 
    RowBox[{"8", " ", "\[Pi]"}]], "+", 
   FractionBox[
    RowBox[{
     SqrtBox[
      RowBox[{"K", "(", 
       RowBox[{
        SuperscriptBox[
         InterpretationBox["q",
          EllipticNomeQ,
          Editable->False,
          Selectable->False], 
         RowBox[{"-", "1"}]], "(", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["\[Pi]", "2"], " ", "\[Beta]"}]], ")"}], ")"}]], " ",
      
     SqrtBox[
      RowBox[{"K", "(", 
       RowBox[{
        SuperscriptBox[
         InterpretationBox["q",
          EllipticNomeQ,
          Editable->False,
          Selectable->False], 
         RowBox[{"-", "1"}]], "(", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["\[Pi]", "2"]}], " ", "\[Beta]"}]], ")"}], ")"}]]}],
     
    RowBox[{"4", " ", "\[Pi]"}]], "-", 
   FractionBox[
    SqrtBox[
     RowBox[{"K", "(", 
      RowBox[{
       SuperscriptBox[
        InterpretationBox["q",
         EllipticNomeQ,
         Editable->False,
         Selectable->False], 
        RowBox[{"-", "1"}]], "(", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["\[Pi]", "2"]}], " ", "\[Beta]"}]], ")"}], ")"}]], 
    RowBox[{"8", " ", 
     SqrtBox[
      RowBox[{"2", " ", "\[Pi]"}]]}]], "+", 
   FractionBox[
    SqrtBox[
     RowBox[{"K", "(", 
      RowBox[{
       SuperscriptBox[
        InterpretationBox["q",
         EllipticNomeQ,
         Editable->False,
         Selectable->False], 
        RowBox[{"-", "1"}]], "(", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "3"}], " ", 
         SuperscriptBox["\[Pi]", "2"], " ", "\[Beta]"}]], ")"}], ")"}]], 
    RowBox[{"3", " ", 
     SqrtBox[
      RowBox[{"2", " ", "\[Pi]"}]]}]], "-", 
   FractionBox[
    SqrtBox[
     RowBox[{"K", "(", 
      RowBox[{
       SuperscriptBox[
        InterpretationBox["q",
         EllipticNomeQ,
         Editable->False,
         Selectable->False], 
        RowBox[{"-", "1"}]], "(", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["\[Pi]", "2"], " ", "\[Beta]"}]], ")"}], ")"}]], 
    RowBox[{"4", " ", 
     SqrtBox[
      RowBox[{"2", " ", "\[Pi]"}]]}]], "-", 
   FractionBox["1", "16"]}], TraditionalForm]], "Output",
 ImageSize->{410, 133},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//TraditionalForm=",
 CellID->182598279]
}, Open  ]],

Cell["Calculate and plot mean energies:", "ExampleText",
 CellID->79517838],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubscriptBox["\[ScriptCapitalE]", "n_"], "[", "T_", "]"}], ":=", 
  RowBox[{
   SuperscriptBox["T", "2"], 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{
       SubscriptBox["Z", "n"], "[", 
       FractionBox["1", "T"], "]"}], "]"}], ",", "T"}], "]"}]}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->34189751],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{
      SubscriptBox["\[ScriptCapitalE]", "1"], "[", "T", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"T", ",", "1", ",", "10", ",", ".1"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->65949565],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxNywtMU2cYxvGunRFDDFUr6TYwZWJRSxy3UVQuDxcLlNKWlhYzUFFHYZkR
BJ0oYRCDiuiGcRfCVrkY7zcMEYFCa2mRgDTgYJARHcFMTQRqIOpwTkSXnfeU
k3w5+X3/7/HZkavJ4nI4nPT357///99UlERu6Qk3rwRzga7W+XaDUWKfZz4O
OUfnWYDSrC/vuiyErtHgcNkLG3pHB1wWIc088sjlTxG6X7AkgrUvyoaTClwW
47hRvTGS9Wp8ZbzWFMV6LfgNeboY1v4QiA5aZKzXYdvmuv5k1gE4pZy5spl1
IJa21NlyWAehaeTq7yWsg7Eo3/yqlnUIAqplxl7Wn8PbP+/QAgs5FM/qTVY1
aym4F8+03mAdhvLcyuVrbpPXw3Ev02RmvQHSrJcd+VbyRvR1vM1VdJDDMZOx
109lI0fAs8q5rcROjkTrHz6/PuwkR0FeZf/iYBcZ8Hw+5qnsZlwK/PZ6PGT7
XerR+KG9aK7ZQT0aRRkTNfp+6jEQFpuXRg9Qj0GeYVxSNEQ9FpZCbrnbCPVY
uJeLv5t8QD0OtvMOw9qH1OPgVynj3XlMfRPkktklt8epb8KBX7TcT6aoyzCc
s5J3/yV1GeKz7dwP3lCPR1t1RcP3XF+mx0Pw2lp4eBFjTgKMsqnKJ3zqCTDf
ODreKKSeiGev7sROiKgnolA1uuLkGupyTIuTe+qDqMthmdNsEYVTT4KRf6LT
XUY9CaeOGE071dQV4E0+7fdLp65ApEf6rjQD9WQsLBMOTO+hngzHyQTR38XU
ldi9wKbbWUFdiWFhozasiroK38wGjhWcpa5CdHbPRUEjdTX6Wu7HfWRlDDXO
zs1KS/vovRqLlSEv4v9kbFUjd8vyB7snaZ8C7+bBuOf/0j4FQ08lhYPuq5h9
Co78JL212IuxNQXNilXSOn/GHA2U3w75H4tgDA2WdWV0dilpr4G37y6/tEza
a/CjqbY4LJ/2WuzrvenMKaO9Fv90X6h58jPttfhQ1dbScIn2WvBmcgy2dtqn
Yseb8CGve7RPxfZzp0PNf9E+Ffb9Jdb6Gdqnwhm48Hq3u5jZ6zB7/GMEiBhD
h6j2MfNwCONSHXxswftMiYytOpxR8NpGttJeD+fWyxNBe2mvx7LMsK87j9Fe
j89qrp87UUt7PfgewR4VTWK8A3fJg8E=
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 10.},
  PlotRange->{{0., 91.}, {9.869604401091314, 11.35456893442418}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->341627535]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->357956876],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseEllipticNomeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseEllipticNomeQ"]], "InlineFormula"],
 " is a modular function. Make an ansatz for a modular equation:"
}], "ExampleText",
 CellID->364458585],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"ansatz", "=", 
    RowBox[{
     RowBox[{"With", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"u", "=", 
          RowBox[{"InverseEllipticNomeQ", "[", "z", "]"}]}], ",", 
         RowBox[{"v", "=", 
          RowBox[{"InverseEllipticNomeQ", "[", 
           SuperscriptBox["z", "2"], "]"}]}]}], "}"}], ",", 
       RowBox[{
        RowBox[{"Sum", "[", 
         RowBox[{
          RowBox[{
           SubscriptBox["c", 
            RowBox[{"i", ",", "j"}]], 
           RowBox[{"u", "^", "i"}], " ", 
           RowBox[{"v", "^", "j"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "0", ",", "2"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", "0", ",", "2"}], "}"}]}], "]"}], "/.", 
        RowBox[{
         SubscriptBox["c", 
          RowBox[{"2", ",", "2"}]], "->", "1"}]}]}], "]"}], "==", "0"}]}], 
   ")"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->618922507],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1W0tvEzEQdrNJlr7SF0WlBVqgBVJQW0BFSNw48DggwYULXKoKqUVCICgn
fgYnKvhJHPk9Yb1rJ87nscf2biqlm7E97/HYO9O+Ojo7+fDp6Oz0+Gjr+dej
Lyenx9+2nn3+WgxlU0JM/RJC7K6J4vug+FZ+5M958RHilvyd6bGBmAb4LTP/
g5l/xMwflFKsFL/l4ALMzgI8D3BX4fUD8ZcBzhXeQ2JdijyheCjHemmFizDa
Y6hcUNxEu0QX1Ywc6cDKRYAzZp7jPK85Z0POol18urAO7YB8V4tfrQJsqadJ
D20UYo0xWiOrFD9LCRpqat3iuVYSW4VVcwQWymTCbYDRTygV50eOP8Km/aVV
cmY98l8plRjBymFjI+g3TsauRQG5ou84irMWRdPuYuhNKakZdRQtSQZzlo4w
9CbCGNUDwsNtPe2xejtRzjxQziyQPsqJu70zGO0ZLkqonVHHFzZPtCLGel2r
8hxl3GZDBsvG+ion9SwKLUrmzhBWmC1yFL1hylfxW6D5WZQoSyVJ7t3lXNTb
8ju4WvKTWbdr4vmwURO0a7I1vJwozmihifnFZRtPzpDwBe1FWrMq4q25eXJ0
lhwlbY8xYmH1yFGMLyrLRknLxQgX24G8EDfIJgnZt56nzFishkLyb1P2tnUm
b6LxcYo88G7XZMR6eFFw7tx9QZLXiiiP7yK0yEwtIiO4U98CCTHcnqjdQ/Re
IjlXcWzfzkuJclitcKibFJ5GLWUD/Ryn3vNQ5053m1qMrGYuoWS1bxs+6iH3
Wh83lK6ebpwfmuXGWVLOc+e8rFtkmm/bXJMRHPXbhr4d90gsLn505SeMp64N
LHuxuDjoKipYp4mTJWuEitboqscvmwoX85C0pWSAef66ww54crvec0L53Has
J++mBnylJt/LDcjtsvUWOWdmfEFQvAEwF/Ub0VzK/FZ8doASpbMJP0nSZy9Z
vm2PbS8rf5D3BO48hfih6FD1EBNercPfkYevOWhy8GFDtrgzAZ1kjA3zR7Uj
PJTpd2KM034SFfToNsAvkqjeb0SWXdI65NkzdqpjpwYtw1NAX95krMJTfFBb
hj5pjWkLD7VF2MbAE5PT1qZwGM2j0mZzUJ3Nc+rZV89dGM8tettq5iWsPGQx
75aP32r+r3reK0flkvOAb3gjQe1+AozvM/8qUcb6LlwnTPewHsO47sztqSd2
PmYAxnevnKH7vRQSdzDXFUKLcH012WdoCwEduqEHjZVcp+wSsx7tkZOcM2IH
cpzXB1SXMUWH9yUBHOW6OWhzrke2ZsBSWPsdOrbrhbbH9agBvlNxFTyO/zrA
dp0gVqN3JVpK90O/A8X2tHAn6e5LWK0ppTuFXqG6XJTkmNVCu32pXTS0TMfB
rznLYPy9UeRGEVu3w1PRCO03kV3qgHojWV9M6hhhHGQWJYcuqH+YjNx9P0kH
y/MWHl9nDe4osT03FVN16vuJfR2kRb5Th/kpsUNDZZ5QbWbIUdxrZNQkSktl
Zh8c1Q2I7mZ548azj8jaeu0+i6SaM5lmMNpbE+iRTJsSROvjeSP19jnS+hsu
63H1lkn3l14bShpM4uvkyd0P3x7T2ae5/gXmH9vfPtmp+8/kZKVuP5PjRmcb
ySMTMZX3TIT2LVy3u7hOBHq045UBPahvpnE8qTO5fg+lsrj++9HQyvuKgzqe
iyjztoMP4qF9Fx38tHw4fiOQD8q3E4hHW5G+QYRU2/EvKtm/QCy+HsAY10GQ
OFcZHFMvar9izS6EJ1elpd+Fdb2kyXr4jIMm12/AjNt30OFgpHMpkA59d9ps
SIrdRDpV9ajGjQf2tw/eBxgrW9iJJPOSt3qPFHF3nZDaxtfXkQ/u/D3GEhsA
oyVxB9+OtCytJ19pb1qvGYsjdhjCNNH/N+Cu1C+qmUVrZl/N2LWGK2pGU+87
Vx6omY8luKMg3Vd4qp6n6vmnXCVRqw6AmPoPV2BJuA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{409, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->24618207]
}, Open  ]],

Cell["Form an overdetermined system of equations and solve it:", "ExampleText",
 CellID->793774682],

Cell[BoxData[
 RowBox[{
  RowBox[{"eqs", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"N", "[", 
      RowBox[{
       RowBox[{"ansatz", "/.", 
        RowBox[{"z", "->", 
         RowBox[{"N", "[", 
          RowBox[{
           RowBox[{"1", "/", "k"}], ",", "120"}], "]"}]}]}], ",", "50"}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "3", ",", "24"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->728428],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Solve", "[", 
     RowBox[{"eqs", ",", 
      RowBox[{"Flatten", "[", 
       RowBox[{"Table", "[", 
        RowBox[{
         SubscriptBox["c", 
          RowBox[{"i", ",", "j"}]], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "0", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}]}], "]"}], "//",
     "Chop"}], "//", "Rationalize"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->303513854],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"svars\"\>"}], ":", 
  " ", "\<\"Equations may not give solutions for all \\\"solve\\\" variables. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/svars\\\", \
ButtonNote -> \\\"Solve::svars\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->308959954],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox["c", 
      RowBox[{"0", ",", "0"}]], "\[Rule]", "0"}], ",", 
    RowBox[{
     SubscriptBox["c", 
      RowBox[{"0", ",", "1"}]], "\[Rule]", 
     RowBox[{"-", "16"}]}], ",", 
    RowBox[{
     SubscriptBox["c", 
      RowBox[{"0", ",", "2"}]], "\[Rule]", "0"}], ",", 
    RowBox[{
     SubscriptBox["c", 
      RowBox[{"1", ",", "0"}]], "\[Rule]", "0"}], ",", 
    RowBox[{
     SubscriptBox["c", 
      RowBox[{"1", ",", "1"}]], "\[Rule]", "16"}], ",", 
    RowBox[{
     SubscriptBox["c", 
      RowBox[{"1", ",", "2"}]], "\[Rule]", "0"}], ",", 
    RowBox[{
     SubscriptBox["c", 
      RowBox[{"2", ",", "0"}]], "\[Rule]", "1"}], ",", 
    RowBox[{
     SubscriptBox["c", 
      RowBox[{"2", ",", "1"}]], "\[Rule]", 
     RowBox[{"-", "2"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{504, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->103731638]
}, Open  ]],

Cell["This is the modular equation of order 2:", "ExampleText",
 CellID->421554106],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ansatz", "/.", 
   RowBox[{"First", "[", "sol", "]"}]}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->47755878],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFWcty0zAUVSLn0bR1E2hLgcJ0aLtoN91RFqxhxYYFOxaZDjPtgoEp/Ql+
AL6FrzOSLA3x0ZWuFNshM7YsS/fccx96WPmwfLj98nX5cHezPHl/v/x+e3fz
4+Tdt3v1Sg6EGPwSQuwfCfVcqSdz6d9vdakGfZfuXSW2oP4J6lOo/2TaPzLt
R4aFKOqi/u1Bn20CQ1df23IO7TOoS9vvypZvM+WuE/s/MUYM4W3JWIMeRy0S
6i+gjt5CVkUm/iGDj/3PeubzMhO/jgKi7EB9l4kCRm3ERAHxUB9azeFjFBAf
+2MUuuaDUeDwDX8x1MPZhMI0eFKFekTPj9UN5ZBdIfwIL9RtZN+nyE/dQ+V+
62jF0VwQOJTVHI72v7T9pJ0gN2fVbhvtMLblPzHLq57lyyZT4c+cEyIzmhh7
NMZo1X7db9/rJ1OxUP8YsK1nUpl4ueDxCPiFRRqTvWQ+544tnvfFC9aMqc1T
X9ewLmkPem9xJNJ+Lcm3OGs+JnimYs3CfsN5l+VBzVKp/uCwInm3JvsuLad9
25od7kfycm5FGjMbZ9BI9kVQKNQJ4R16xHLok3TvrcGRjg3nt6jFbeK/cT8M
N8U8OYfrAmIxgd62DXdzRlNjLi8j0mjHAWVHMhqOpTzplB1aEy3mFw5t3ESr
6pWQzJX/ZD/sS3phmLKO67t03m7wkUT+ubMCn70kbMR8k1Fpin26LioDwnYl
5U9gP+WQ+7Ci7ExvbA5y3yOYbXoMFi5fYN9FscV5D+NdBuScHsr6FD0YrUXA
Hk4O970o73C75s/tCHL1xmJN79hWs0VAxM1spa4FaKHY4BcrrQ2RYt8f1FzJ
nZlRTPBEicp1lNHfVnqkYdum+Zd98gjkic5RKre4b0XTHliPZgFMnF9iOjWO
5q2r2wE8rNO7/JB0LpvDRBYcDkbTnQqFvNavlXhu3A2bxsqx5pcQd8KN9VOG
qb+HfsQgHkMdx/Nla43X2QhPSY+SUWnI4fhFWzArX0Edo4FzDp7RIN5zxtcX
LfWhJzn5Z6Qftzy/4U44128zDxF3S209xWtA3/gSJtPN/lCP/R1b+tnnVsq5
13JqWxzGQbDncRU6n7wMYLyB92aNF+e2dmbLz7a8suUf00tD1//RisFfGv29
/A==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{406, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//TraditionalForm=",
 CellID->14502019]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10994],

Cell["Compose with inverse functions:", "ExampleText",
 CellID->477143856],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"InverseEllipticNomeQ", "[", 
    RowBox[{"EllipticNomeQ", "[", "z", "]"}], "]"}], ",", 
   RowBox[{"EllipticNomeQ", "[", 
    RowBox[{"InverseEllipticNomeQ", "[", "z", "]"}], "]"}]}], "}"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->9596804],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", 
   RowBox[{"EllipticNomeQ", "[", 
    RowBox[{"InverseEllipticNomeQ", "[", "z", "]"}], "]"}]}], "}"}]], "Output",\

 ImageSize->{303, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->265342105]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->642218276],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", "z"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->213644322]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->100126756],

Cell["Find derivatives:", "ExampleText",
 CellID->55226870],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"InverseEllipticNomeQ", "[", "q", "]"}], ",", "q"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->797473439],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{
    SuperscriptBox["\[Pi]", "2"], " ", "q"}]], 
  RowBox[{"4", " ", 
   SuperscriptBox[
    RowBox[{"EllipticK", "[", 
     RowBox[{"InverseEllipticNomeQ", "[", "q", "]"}], "]"}], "2"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"InverseEllipticNomeQ", "[", "q", "]"}]}], ")"}], " ", 
   RowBox[{"InverseEllipticNomeQ", "[", "q", "]"}]}]}]], "Output",
 ImageSize->{377, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->530222834]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1006566609],

Cell["Symbolically solve a transcendental equation:", "ExampleText",
 CellID->621096222],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"EllipticNomeQ", "[", "z", "]"}], "+", 
     SuperscriptBox[
      RowBox[{"EllipticNomeQ", "[", "z", "]"}], "2"]}], "\[Equal]", "g"}], 
   ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->771346962],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"InverseEllipticNomeQ", "[", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         SqrtBox[
          RowBox[{"1", "+", 
           RowBox[{"4", " ", "g"}]}]]}], ")"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"InverseEllipticNomeQ", "[", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SqrtBox[
          RowBox[{"1", "+", 
           RowBox[{"4", " ", "g"}]}]]}], ")"}]}], "]"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{318, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->423655198]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->111721473],

Cell["Numerically find a root of a transcendental equation:", "ExampleText",
 CellID->46473010],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"InverseEllipticNomeQ", "[", "z", "]"}], "+", 
     RowBox[{"InverseEllipticNomeQ", "[", 
      RowBox[{"z", "^", "2"}], "]"}], "+", "z"}], "\[Equal]", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0.4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->384089874],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", "\[Rule]", "0.2824619887507407`"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->270120747]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15968],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseEllipticNomeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseEllipticNomeQ"]], "InlineFormula"],
 " remains unevaluated outside its domain of analyticity:"
}], "ExampleText",
 CellID->907253201],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseEllipticNomeQ", "[", "2", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->402882490],

Cell[BoxData[
 RowBox[{"InverseEllipticNomeQ", "[", "2", "]"}]], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->287613378]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->866647803],

Cell[BoxData[
 RowBox[{"InverseEllipticNomeQ", "[", "2.`", "]"}]], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->687060234]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->188486212],

Cell[TextData[{
 Cell[BoxData["InverseElliptictNomeQ"], "InlineFormula"],
 " is single valued, and ",
 Cell[BoxData[
  ButtonBox["EllipticNomeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticNomeQ"]], "InlineFormula"],
 " is multivalued:"
}], "ExampleText",
 CellID->378306622],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseEllipticNomeQ", "[", 
  RowBox[{"EllipticNomeQ", "[", "z", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24759733],

Cell[BoxData["z"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->700209926]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2431],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["EllipticNomeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticNomeQ"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->4574]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->941],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "Tutorials",
 CellID->2744]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->9648],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/InverseNome.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/EllipticFunctions/InverseEllipticNomeQ/"]\
, None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->31186323],

Cell[TextData[ButtonBox["Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticFunctions"]], "MoreAbout",
 CellID->324663722],

Cell[TextData[ButtonBox["Elliptic Integrals",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticIntegrals"]], "MoreAbout",
 CellID->370112998],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->254206045]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InverseEllipticNomeQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 49, 42.1974892}", "context" -> "System`", 
    "keywords" -> {"elliptic modulus", "elliptic nome", "modular angle"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "InverseEllipticNomeQ[q] gives the parameter m corresponding to the nome \
q in an elliptic function. ", "synonyms" -> {"inverse elliptic nome q"}, 
    "title" -> "InverseEllipticNomeQ", "type" -> "Symbol", "uri" -> 
    "ref/InverseEllipticNomeQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5542, 191, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->5949741]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 44681, 1545}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2100, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2723, 80, 58, 1, 70, "ObjectName",
 CellID->24618],
Cell[2784, 83, 686, 21, 70, "Usage",
 CellID->8124]
}, Open  ]],
Cell[CellGroupData[{
Cell[3507, 109, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3985, 126, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4108, 132, 618, 22, 70, "Notes",
 CellID->10900],
Cell[4729, 156, 303, 12, 70, "Notes",
 CellID->4825],
Cell[5035, 170, 242, 7, 70, "Notes",
 CellID->31226],
Cell[5280, 179, 225, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[5542, 191, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->5949741],
Cell[CellGroupData[{
Cell[5925, 205, 148, 5, 70, "ExampleSection",
 CellID->128041306],
Cell[6076, 212, 63, 1, 70, "ExampleText",
 CellID->70611792],
Cell[CellGroupData[{
Cell[6164, 217, 118, 3, 28, "Input",
 CellID->210043588],
Cell[6285, 222, 175, 5, 36, "Output",
 CellID->46634327]
}, Open  ]],
Cell[6475, 230, 124, 3, 70, "ExampleDelimiter",
 CellID->18898412],
Cell[CellGroupData[{
Cell[6624, 237, 237, 7, 28, "Input",
 CellID->337243360],
Cell[6864, 246, 2311, 42, 155, "Output",
 Evaluatable->False,
 CellID->145905002]
}, Open  ]],
Cell[9190, 291, 125, 3, 70, "ExampleDelimiter",
 CellID->881134843],
Cell[9318, 296, 197, 5, 70, "ExampleText",
 CellID->751272945],
Cell[CellGroupData[{
Cell[9540, 305, 233, 7, 70, "Input",
 CellID->564723879],
Cell[9776, 314, 1251, 38, 54, "Output",
 CellID->141631359]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11076, 358, 215, 7, 70, "ExampleSection",
 CellID->6812],
Cell[11294, 367, 211, 5, 70, "ExampleText",
 CellID->295425803],
Cell[CellGroupData[{
Cell[11530, 376, 166, 5, 70, "Input",
 CellID->91963367],
Cell[11699, 383, 274, 7, 36, "Output",
 CellID->163773913]
}, Open  ]],
Cell[11988, 393, 125, 3, 70, "ExampleDelimiter",
 CellID->745773765],
Cell[12116, 398, 207, 5, 70, "ExampleText",
 CellID->186880852],
Cell[CellGroupData[{
Cell[12348, 407, 194, 6, 70, "Input",
 CellID->310855173],
Cell[12545, 415, 234, 7, 36, "Output",
 CellID->10869836]
}, Open  ]],
Cell[12794, 425, 124, 3, 70, "ExampleDelimiter",
 CellID->54545494],
Cell[12921, 430, 112, 3, 70, "ExampleText",
 CellID->75055808],
Cell[CellGroupData[{
Cell[13058, 437, 147, 4, 70, "Input",
 CellID->382640901],
Cell[13208, 443, 218, 6, 36, "Output",
 CellID->34894770]
}, Open  ]],
Cell[13441, 452, 125, 3, 70, "ExampleDelimiter",
 CellID->420108127],
Cell[13569, 457, 371, 11, 70, "ExampleText",
 CellID->916053844],
Cell[CellGroupData[{
Cell[13965, 472, 178, 5, 70, "Input",
 CellID->14133259],
Cell[14146, 479, 275, 9, 36, "Output",
 CellID->491566708]
}, Open  ]],
Cell[14436, 491, 125, 3, 70, "ExampleDelimiter",
 CellID->193311377],
Cell[14564, 496, 339, 11, 70, "ExampleText",
 CellID->31216930],
Cell[CellGroupData[{
Cell[14928, 511, 157, 5, 70, "Input",
 CellID->143449975],
Cell[15088, 518, 366, 13, 52, "Output",
 CellID->362105604]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15503, 537, 239, 7, 70, "ExampleSection",
 CellID->32554],
Cell[15745, 546, 233, 7, 70, "ExampleText",
 CellID->283059217],
Cell[CellGroupData[{
Cell[16003, 557, 223, 7, 70, "Input",
 CellID->16720936],
Cell[16229, 566, 852, 29, 54, "Output",
 CellID->177602759]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17130, 601, 221, 7, 70, "ExampleSection",
 CellID->277],
Cell[17354, 610, 124, 3, 70, "ExampleText",
 CellID->95909029],
Cell[17481, 615, 355, 12, 70, "Input",
 CellID->53286629],
Cell[CellGroupData[{
Cell[17861, 631, 402, 13, 70, "Input",
 CellID->46398057],
Cell[18266, 646, 160, 5, 36, "Output",
 CellID->15407652]
}, Open  ]],
Cell[18441, 654, 125, 3, 70, "ExampleDelimiter",
 CellID->686280512],
Cell[18569, 659, 146, 4, 70, "ExampleText",
 CellID->308362215],
Cell[18718, 665, 569, 18, 70, "Input",
 CellID->673489268],
Cell[19290, 685, 166, 6, 70, "ExampleText",
 CellID->6486712],
Cell[19459, 693, 647, 23, 70, "Input",
 CellID->39931723],
Cell[CellGroupData[{
Cell[20131, 720, 167, 6, 70, "Input",
 CellID->120280450],
Cell[20301, 728, 3539, 123, 168, "Output",
 CellID->182598279]
}, Open  ]],
Cell[23855, 854, 75, 1, 70, "ExampleText",
 CellID->79517838],
Cell[23933, 857, 376, 13, 70, "Input",
 CellID->34189751],
Cell[CellGroupData[{
Cell[24334, 874, 345, 11, 70, "Input",
 CellID->65949565],
Cell[24682, 887, 1689, 36, 126, "Output",
 CellID->341627535]
}, Open  ]],
Cell[26386, 926, 125, 3, 70, "ExampleDelimiter",
 CellID->357956876],
Cell[26514, 931, 263, 7, 70, "ExampleText",
 CellID->364458585],
Cell[CellGroupData[{
Cell[26802, 942, 1015, 31, 70, "Input",
 CellID->618922507],
Cell[27820, 975, 2224, 40, 70, "Output",
 Evaluatable->False,
 CellID->24618207]
}, Open  ]],
Cell[30059, 1018, 99, 1, 70, "ExampleText",
 CellID->793774682],
Cell[30161, 1021, 461, 16, 70, "Input",
 CellID->728428],
Cell[CellGroupData[{
Cell[30647, 1041, 539, 17, 70, "Input",
 CellID->303513854],
Cell[31189, 1060, 386, 7, 70, "Message",
 CellID->308959954],
Cell[31578, 1069, 996, 34, 36, "Output",
 CellID->103731638]
}, Open  ]],
Cell[32589, 1106, 83, 1, 70, "ExampleText",
 CellID->421554106],
Cell[CellGroupData[{
Cell[32697, 1111, 170, 5, 70, "Input",
 CellID->47755878],
Cell[32870, 1118, 1391, 27, 70, "Output",
 Evaluatable->False,
 CellID->14502019]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[34310, 1151, 233, 7, 70, "ExampleSection",
 CellID->10994],
Cell[34546, 1160, 74, 1, 70, "ExampleText",
 CellID->477143856],
Cell[CellGroupData[{
Cell[34645, 1165, 295, 9, 70, "Input",
 CellID->9596804],
Cell[34943, 1176, 296, 10, 36, "Output",
 CellID->265342105]
}, Open  ]],
Cell[CellGroupData[{
Cell[35276, 1191, 107, 3, 70, "Input",
 CellID->642218276],
Cell[35386, 1196, 203, 7, 36, "Output",
 CellID->213644322]
}, Open  ]],
Cell[35604, 1206, 125, 3, 70, "ExampleDelimiter",
 CellID->100126756],
Cell[35732, 1211, 59, 1, 70, "ExampleText",
 CellID->55226870],
Cell[CellGroupData[{
Cell[35816, 1216, 171, 6, 70, "Input",
 CellID->797473439],
Cell[35990, 1224, 554, 17, 71, "Output",
 CellID->530222834]
}, Open  ]],
Cell[36559, 1244, 126, 3, 70, "ExampleDelimiter",
 CellID->1006566609],
Cell[36688, 1249, 88, 1, 70, "ExampleText",
 CellID->621096222],
Cell[CellGroupData[{
Cell[36801, 1254, 298, 10, 70, "Input",
 CellID->771346962],
Cell[37102, 1266, 851, 30, 81, "Output",
 CellID->423655198]
}, Open  ]],
Cell[37968, 1299, 125, 3, 70, "ExampleDelimiter",
 CellID->111721473],
Cell[38096, 1304, 95, 1, 70, "ExampleText",
 CellID->46473010],
Cell[CellGroupData[{
Cell[38216, 1309, 371, 11, 70, "Input",
 CellID->384089874],
Cell[38590, 1322, 227, 7, 36, "Output",
 CellID->270120747]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[38866, 1335, 226, 7, 70, "ExampleSection",
 CellID->15968],
Cell[39095, 1344, 256, 7, 70, "ExampleText",
 CellID->907253201],
Cell[CellGroupData[{
Cell[39376, 1355, 116, 3, 70, "Input",
 CellID->402882490],
Cell[39495, 1360, 205, 6, 36, "Output",
 CellID->287613378]
}, Open  ]],
Cell[CellGroupData[{
Cell[39737, 1371, 97, 3, 70, "Input",
 CellID->866647803],
Cell[39837, 1376, 207, 6, 36, "Output",
 CellID->687060234]
}, Open  ]],
Cell[40059, 1385, 125, 3, 70, "ExampleDelimiter",
 CellID->188486212],
Cell[40187, 1390, 289, 9, 70, "ExampleText",
 CellID->378306622],
Cell[CellGroupData[{
Cell[40501, 1403, 155, 4, 70, "Input",
 CellID->24759733],
Cell[40659, 1409, 158, 5, 36, "Output",
 CellID->700209926]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[40878, 1421, 310, 9, 70, "SeeAlsoSection",
 CellID->2431],
Cell[41191, 1432, 205, 6, 70, "SeeAlso",
 CellID->4574]
}, Open  ]],
Cell[CellGroupData[{
Cell[41433, 1443, 312, 9, 70, "TutorialsSection",
 CellID->941],
Cell[41748, 1454, 191, 4, 70, "Tutorials",
 CellID->2744]
}, Open  ]],
Cell[CellGroupData[{
Cell[41976, 1463, 320, 9, 70, "RelatedLinksSection",
 CellID->9648],
Cell[42299, 1474, 182, 4, 70, "RelatedLinks"],
Cell[42484, 1480, 208, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[42729, 1489, 318, 9, 70, "MoreAboutSection",
 CellID->31186323],
Cell[43050, 1500, 147, 3, 70, "MoreAbout",
 CellID->324663722],
Cell[43200, 1505, 147, 3, 70, "MoreAbout",
 CellID->370112998],
Cell[43350, 1510, 145, 3, 70, "MoreAbout",
 CellID->254206045]
}, Open  ]],
Cell[43510, 1516, 27, 0, 70, "History"],
Cell[43540, 1518, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

