(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     81049,       2254]
NotebookOptionsPosition[     71596,       1914]
NotebookOutlinePosition[     72883,       1950]
CellTagsIndexPosition[     72797,       1945]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Erf" :> Documentation`HelpLookup["paclet:ref/Erf"], 
          "InverseErfc" :> Documentation`HelpLookup["paclet:ref/InverseErfc"],
           "InverseGammaRegularized" :> 
          Documentation`HelpLookup["paclet:ref/InverseGammaRegularized"], 
          "InverseBetaRegularized" :> 
          Documentation`HelpLookup["paclet:ref/InverseBetaRegularized"], 
          "NormalDistribution" :> 
          Documentation`HelpLookup["paclet:ref/NormalDistribution"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Erf\"\>", 2->"\<\"InverseErfc\"\>",
        3->"\<\"InverseGammaRegularized\"\>", 
       4->"\<\"InverseBetaRegularized\"\>", 
       5->"\<\"NormalDistribution\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Error and Exponential Integral Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/ErrorAndExponentialIntegralFunctions"], 
          "Functions Used in Statistics" :> 
          Documentation`HelpLookup["paclet:guide/FunctionsUsedInStatistics"], 
          "Inverse Functions" :> 
          Documentation`HelpLookup["paclet:guide/InverseFunctions"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Error and Exponential Integral Functions\"\>", 
       2->"\<\"Functions Used in Statistics\"\>", 
       3->"\<\"Inverse Functions\"\>", 
       4->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InverseErf", "ObjectName",
 CellID->7655],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InverseErf",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InverseErf"], "[", 
       StyleBox["s", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the inverse error function obtained as the \
solution for ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      FormBox[
       RowBox[{"s", "=", 
        RowBox[{"erf", "(", "z", ")"}]}], TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14628]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "Explicit numerical values are given only for real values of ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " between ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"+", "1"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->14456],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["InverseErf",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseErf"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["z", "TI"], 
     StyleBox["0", "TR"]], ",", 
    StyleBox["s", "TI"]}], "]"}]], "InlineFormula", "TemplateInclusion"],
 " gives the inverse of the generalized error function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Erf",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Erf"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["z", "TI"], 
     StyleBox["0", "TR"]], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->9245],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["InverseErf",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseErf"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->8816046],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseErf",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseErf"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseErf",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseErf"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->234498203],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->557600642],

Cell["Evaluate numerically:", "ExampleText",
 CellID->10046],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseErf", "[", "0.6", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15717],

Cell[BoxData["0.5951160814499948`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->829373271]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9822],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"InverseErf", "[", 
    RowBox[{"0", ",", "s"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27403],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFmFuIlVUUx7dnzplzzjhTTpaJNZeKKamgYlLEUAvTaVJniFID6WEagpmg
DJte6qVe8qVe6iUh8qELZD0YiREYhEIkREIkRAVhEPaQBEkPA8HXb631Xc7e
Z5/LMEnifGfv/f3XZf/3Wmvv/e2ZWZh76pmZhfnZmdGJQzPPzc3PPj+68+Ah
hnpWOOdO8Pf0Wkc7oaV/J5KE3wPy7JG+/nP7dLRPR99/79zi4j/SnGqD2r/3
g4sX/1oaqgRo/zJ1LA81++THP/34Ryt/Dj776blvf+uk44WFk2e//lWaO3iU
AVXaoA+/+uVnJ3+Q5s4GlOta6v7URk+ALvOQbiFVOvrON5MBKpRqtIEBzEjz
oSVIMXUIyGbvygWq/YwuXfr7kel3Mx6E+V5vBVYqatfk0cuXF6W5J6rLUC+9
+PmZ0790QhHHR9462wlF0BA6rVH9Ojo/d/z8979Lc7fndX/A5O42OkgqLMFD
C9RAoGtXFHVV4sfgw54/9hYKCXRmpm+bdVytoyQCAQ/WhVFjqFXZekO3oMIo
MdRghkKXWJzw/Lkms4Q/pJbbmljUxiNltUYUttDF0kHYlgBXjspdl603VvDE
bUha50yz9Bp9deHCn1h95eVTTGJzRK7ItbU69MWpn1lNlgr8pq7srNNXrK/J
YXBjV3I3ZnJPHPjQ1n08KTKoGT8sz4rlKaY+OvadxNwmb11G5dmL62++8RVp
yQozH/jeENV4i2ok5aCHDMV52m48ih1TzajCYdTm8Luj6PXyrLLijWhzxd3p
eVxN16AU6BGEMlsxLbi4Y/vbTF3fNEaA1FwZuynQMJraiWFH2lhVvKsFb3TU
q4pDOkcacM0S0nj9tTMwInMMV3w46I80aasGiKGO9kv205NOK51ZmBvNctcn
lkUq39/45pPj51ksaCZj2HTSPTONqivifZcseyOKqeIcLuIo7jJINlCNlOdS
5vH/5mEl9cJVCQeig/JFBhC7lDK2G4vrtnxmGkLm/2svvdiXR41so8RQpdka
oZZ4MKfXdOVzE6IL36uJf24YSX8bx12drIJM82vbliMWoXgq2TYYWBoNNAwH
Fixl9NxWszhibZgs60QKU6YooANJY5XS/bZGhJEiVCLKr1VX46Ye2LcaqGfN
OjU68Js2I1K74/vCozqKXyjHhCthypXNmOy1zj2e83Ysn01foCtcjaX2wz1o
ufq0X6efT4xpwSNswqmLZOgV8WCp/SZebw36Y0FfY7pOABFGBBMhlddTolXO
Wzd00GB2w5tcngV5wFJScv6k9k3kchK3ejatNfqRlyA0bI/a0PNjPa8AeJ1H
bJppW6Ny1yZpJqHcMolgz4U2R2X0tFUjeXIZXKRWmsxGby620zJHqrxhi1o6
HtWudbMaFDJ4kpPsXVEJPQvVrMrAF8yyp+OPbeh3RGVuUysc+PDLTjk8OatI
bq+PStyuEmaFExEpAL34JRJj3pzVy144xZlG2M1Rvff4aOjBDcyMRNH3apjB
Di7Y0UyYHIpidSXScx9MQgp+ECLrPG91jSswYdQRoBLpusbuscTOWmG1u09l
wIHGZ7gWGd1n3N4AG55q9P5QwSuYx5592rA47Ci7TR5yGyE2kIWG1S3lpPuA
4qEeVvlPY7ArO5pjcoOCM7m9rOpK6kHt452FuOWkcliK7LH27YGJpHfLAW9V
7GZX3Dz7oyscolZGUZOZJZySZl8UZffS4lZd9/yxmy9RQqrLetWjOgxFOLC2
0qy1QRW3/DjKbuTFd4Wq5499GeAVAP9tsw78JVXE6zjKdBVfmnrboAoWez1/
pgJ/2umAReKqQMmpoRzJMtNJHU/7lTyeGu9Ecaniq41JtcoQQxff4Ay9L0CH
d62pgLGlSLHrsa8VUnpm8s6W8Rkdzr+/FTxkeSW/01FUuAJxXXFUEcetUfKF
z4+E6abRZs3Q5vEd//YbH3Ur/gVYD5dJ\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->121392698]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8481],

Cell["Exact results for special arguments:", "ExampleText",
 CellID->25048],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseErf", "[", "0", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18500],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->277798430]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseErf", "[", "1.", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19413],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->400311613]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2625],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->10926],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"InverseErf", "[", 
    RowBox[{"33", "/", "100"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12664],

Cell[BoxData["0.\
3013321461337058261285027181583947739658242828285337274329904307918`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->339602631]
}, Open  ]],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->15252],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseErf", "[", "0.330000000000000000000000", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32300],

Cell[BoxData["0.30133214613370582612850271815839515098`24.920815183371335"], \
"Output",
 ImageSize->{193, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->154747308]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2614],

Cell["Series expansion:", "ExampleText",
 CellID->11523],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"InverseErf", "[", "z", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28330],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{
     SqrtBox["\[Pi]"], " ", "z"}], "2"], "+", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    SuperscriptBox["\[Pi]", 
     RowBox[{"3", "/", "2"}]], " ", 
    SuperscriptBox["z", "3"]}], "+", 
   RowBox[{
    FractionBox["7", "960"], " ", 
    SuperscriptBox["\[Pi]", 
     RowBox[{"5", "/", "2"}]], " ", 
    SuperscriptBox["z", "5"]}], "+", 
   FractionBox[
    RowBox[{"127", " ", 
     SuperscriptBox["\[Pi]", 
      RowBox[{"7", "/", "2"}]], " ", 
     SuperscriptBox["z", "7"]}], "80640"], "+", 
   FractionBox[
    RowBox[{"4369", " ", 
     SuperscriptBox["\[Pi]", 
      RowBox[{"9", "/", "2"}]], " ", 
     SuperscriptBox["z", "9"]}], "11612160"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "11"],
    SeriesData[$CellContext`z, 0, {}, 1, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   Rational[1, 2] Pi^Rational[1, 2], 0, Rational[1, 24] Pi^Rational[3, 2], 0, 
    Rational[7, 960] Pi^Rational[5, 2], 0, Rational[127, 80640] 
    Pi^Rational[7, 2], 0, Rational[4369, 11612160] Pi^Rational[9, 2]}, 1, 11, 
   1],
  Editable->False]], "Output",
 ImageSize->{414, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->118371117]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->559922074],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->527916890],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseErf", "[", "x", "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->415879500],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["erf", 
    RowBox[{"-", "1"}]], "(", "x", ")"}], TraditionalForm]], "Output",
 ImageSize->{42, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->85602714]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4566],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseErf",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseErf"]], "InlineFormula"],
 " threads element-wise over lists and arrays:"
}], "ExampleText",
 CellID->7741],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseErf", "[", 
  RowBox[{"1", "/", 
   RowBox[{"{", 
    RowBox[{"2.", ",", "3.", ",", "4.", ",", "5."}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->14578],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.4769362762044698`", ",", "0.3045701941739856`", ",", 
   "0.2253120550121781`", ",", "0.1791434546212917`"}], "}"}]], "Output",
 ImageSize->{269, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->74262053]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Inverse of the Generalized Error Function",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->629],

Cell["Evaluate numerically:", "ExampleText",
 CellID->31014],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseErf", "[", 
   RowBox[{"0.4", ",", " ", "0.2"}], "]"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19494],

Cell[BoxData["0.6317759030550063`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->59665500]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10973],

Cell["Series expansion:", "ExampleText",
 CellID->22384],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"InverseErf", "[", 
    RowBox[{"z0", ",", "z"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z0", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2306],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"InverseErf", "[", "z", "]"}], "+", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     SuperscriptBox[
      RowBox[{"InverseErf", "[", "z", "]"}], "2"]], " ", "z0"}], "+", 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"InverseErf", "[", "z", "]"}], "2"]}]], " ", 
    RowBox[{"InverseErf", "[", "z", "]"}], " ", 
    SuperscriptBox["z0", "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z0", "]"}], "3"],
    SeriesData[$CellContext`z0, 0, {}, 0, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`z0, 0, {
    InverseErf[$CellContext`z], E^(InverseErf[$CellContext`z]^2), 
    E^(2 InverseErf[$CellContext`z]^2) InverseErf[$CellContext`z]}, 0, 3, 1],
  Editable->False]], "Output",
 ImageSize->{470, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9137621]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1643],

Cell["Generate Gaussian-distributed random numbers:", "ExampleText",
 CellID->1634],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseErf", "[", 
  RowBox[{"RandomReal", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "10"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18761],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.22608981487445096`", ",", 
   RowBox[{"-", "0.17269123678985654`"}], ",", "0.0677889924573625`", ",", 
   RowBox[{"-", "0.46243123106038325`"}], ",", 
   RowBox[{"-", "1.2152458090168163`"}], ",", "1.0283751329178348`", ",", 
   "0.9175057779867987`", ",", 
   RowBox[{"-", "0.6238676128697083`"}], ",", "0.5993578160670848`", ",", 
   "0.005596400313584855`"}], "}"}]], "Output",
 ImageSize->{419, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->99093697]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32030],

Cell["\<\
The number of standard deviations for a 99% confidence interval in the \
Gaussian distribution:\
\>", "ExampleText",
 CellID->32516],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sqrt", "[", "2", "]"}], 
  RowBox[{"InverseErf", "[", "0.99", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13940],

Cell[BoxData["2.5758293035489004`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->118414356]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30870],

Cell[TextData[{
 "Plot ",
 Cell[BoxData[
  ButtonBox["InverseErf",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseErf"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->19598],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot3D", "[", 
   RowBox[{
    RowBox[{"InverseErf", "[", 
     RowBox[{"z0", ",", "z"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"z0", ",", 
      RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}], "//", 
  "Quiet"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7994],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->403908308]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24504],

Cell["Solve a transcendental equation:", "ExampleText",
 CellID->24141],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"InverseErf", "[", "x", "]"}], "^", "3"}], "+", 
     RowBox[{"2", 
      RowBox[{"InverseErf", "[", "x", "]"}]}]}], "==", "1"}], ",", " ", "x"}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26096],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"-", 
     RowBox[{"Erf", "[", 
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox["2", 
           RowBox[{"3", " ", 
            RowBox[{"(", 
             RowBox[{"9", "+", 
              SqrtBox["177"]}], ")"}]}]], ")"}], 
         RowBox[{"1", "/", "3"}]]}], "-", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           FractionBox["1", "2"], " ", 
           RowBox[{"(", 
            RowBox[{"9", "+", 
             SqrtBox["177"]}], ")"}]}], ")"}], 
         RowBox[{"1", "/", "3"}]], 
        SuperscriptBox["3", 
         RowBox[{"2", "/", "3"}]]]}], "]"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{354, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->239954748]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26756],

Cell["Numerically find a root of a transcendental equation:", "ExampleText",
 CellID->5771],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"InverseErf", "[", "z", "]"}], "+", "z", "+", 
     RowBox[{"1", "/", "2"}]}], "==", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23807],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", "\[Rule]", 
   RowBox[{"-", "0.26275908464067865`"}]}], "}"}]], "Output",
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->171183267]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26176],

Cell[TextData[{
 "Obtain ",
 Cell[BoxData[
  ButtonBox["InverseErf",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseErf"]], "InlineFormula"],
 " ",
 "as the solution of a differential equation:"
}], "ExampleText",
 CellID->19910],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"w", "''"}], "[", "z", "]"}], "-", 
     RowBox[{"2", " ", 
      RowBox[{"w", "[", "z", "]"}], " ", 
      RowBox[{
       RowBox[{
        RowBox[{"w", "'"}], "[", "z", "]"}], "^", "2"}]}]}], "\[Equal]", 
    "0"}], ",", 
   RowBox[{"w", "[", "z", "]"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28743],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->93760756],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"w", "[", "z", "]"}], "\[Rule]", 
    RowBox[{"InverseErf", "[", 
     FractionBox[
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"z", " ", 
          RowBox[{"C", "[", "1", "]"}]}], "+", 
         RowBox[{
          RowBox[{"C", "[", "1", "]"}], " ", 
          RowBox[{"C", "[", "2", "]"}]}]}], ")"}]}], 
      SqrtBox["\[Pi]"]], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{298, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->541215245]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27108],

Cell["Compose with the inverse function: ", "ExampleText",
 CellID->17027],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseErf", "[", 
  RowBox[{"a", ",", 
   RowBox[{"Erf", "[", 
    RowBox[{"a", ",", "z"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4430],

Cell[BoxData[
 RowBox[{"InverseErf", "[", 
  RowBox[{"a", ",", 
   RowBox[{"Erf", "[", 
    RowBox[{"a", ",", "z"}], "]"}]}], "]"}]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3603596]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22123],

Cell[BoxData["z"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->100345790]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2171],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseErf",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseErf"]], "InlineFormula"],
 " is a numeric function:"
}], "ExampleText",
 CellID->14931],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "InverseErf", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29190],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "Listable", ",", "NumericFunction", ",", "Protected", ",", 
   "ReadProtected"}], "}"}]], "Output",
 ImageSize->{367, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2977032]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumericQ", "[", 
  RowBox[{"InverseErf", "[", 
   RowBox[{
    RowBox[{"1", "/", "Pi"}], ",", 
    RowBox[{"1", "/", "2"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23862],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->515196686]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3078],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["erf", 
     RowBox[{"-", "1"}]], "(", "z", ")"}], TraditionalForm]], "InlineMath"],
 "is automatically interpreted as an inverse error function:"
}], "ExampleText",
 CellID->20010],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["erf", 
    RowBox[{"-", "1"}]], "(", "z", ")"}], TraditionalForm]], "Input",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellLabel->"In[1]:=",
 CellID->19184],

Cell[BoxData[
 RowBox[{"InverseErf", "[", "z", "]"}]], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->548974895]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14845],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseErf",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseErf"]], "InlineFormula"],
 " evaluates numerically only for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", "1"}], "\[LessEqual]", "s", "\[LessEqual]", "1"}], 
   TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->8581],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseErf", "[", 
  RowBox[{"0", ",", "1.3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1892],

Cell[BoxData[
 RowBox[{"InverseErf", "[", "1.3`", "]"}]], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2337840]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14221],

Cell[TextData[{
 "Riemann surface of ",
 Cell[BoxData[
  ButtonBox["InverseErf",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseErf"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->4122],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "[", 
       RowBox[{"Erf", "[", 
        RowBox[{"wr", "+", 
         RowBox[{"\[ImaginaryI]", " ", "wi"}]}], "]"}], "]"}], ",", 
      RowBox[{"Im", "[", 
       RowBox[{"Erf", "[", 
        RowBox[{"wr", "+", 
         RowBox[{"\[ImaginaryI]", " ", "wi"}]}], "]"}], "]"}], ",", "wi"}], 
     "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"wr", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"wi", ",", 
     RowBox[{"-", "2"}], ",", " ", "2"}], "}"}], ",", 
   RowBox[{"PlotStyle", "->", 
    RowBox[{"{", 
     RowBox[{"Opacity", "[", "0.66", "]"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12153],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->489293156]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9760],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Erf",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Erf"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseErfc",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseErfc"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseGammaRegularized",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseGammaRegularized"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseBetaRegularized",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseBetaRegularized"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NormalDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NormalDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13041]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11633],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->18846]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->13774],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/index.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/GammaBetaErf/InverseErf/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->198196721],

Cell[TextData[ButtonBox["Error and Exponential Integral Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ErrorAndExponentialIntegralFunctions"]], "MoreAbout",
 CellID->237841561],

Cell[TextData[ButtonBox["Functions Used in Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInStatistics"]], "MoreAbout",
 CellID->98900458],

Cell[TextData[ButtonBox["Inverse Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InverseFunctions"]], "MoreAbout",
 CellID->212205196],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->163537487]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InverseErf - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 49, 47.9476364}", "context" -> "System`", 
    "keywords" -> {"confidence intervals", "Gaussian random numbers"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "InverseErf[s] gives the inverse error function obtained as the solution \
for z in s = erf(z). ", "synonyms" -> {"inverse erf"}, "title" -> 
    "InverseErf", "type" -> "Symbol", "uri" -> "ref/InverseErf"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6577, 219, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->234498203]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 72654, 1938}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2795, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3418, 91, 47, 1, 70, "ObjectName",
 CellID->7655],
Cell[3468, 94, 735, 24, 70, "Usage",
 CellID->14628]
}, Open  ]],
Cell[CellGroupData[{
Cell[4240, 123, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4718, 140, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4841, 146, 362, 14, 70, "Notes",
 CellID->14456],
Cell[5206, 162, 648, 24, 70, "Notes",
 CellID->9245],
Cell[5857, 188, 250, 8, 70, "Notes",
 CellID->8816046],
Cell[6110, 198, 222, 7, 70, "Notes",
 CellID->31226],
Cell[6335, 207, 205, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6577, 219, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->234498203],
Cell[CellGroupData[{
Cell[6962, 233, 148, 5, 70, "ExampleSection",
 CellID->557600642],
Cell[7113, 240, 60, 1, 70, "ExampleText",
 CellID->10046],
Cell[CellGroupData[{
Cell[7198, 245, 104, 3, 28, "Input",
 CellID->15717],
Cell[7305, 250, 176, 5, 36, "Output",
 CellID->829373271]
}, Open  ]],
Cell[7496, 258, 120, 3, 70, "ExampleDelimiter",
 CellID->9822],
Cell[CellGroupData[{
Cell[7641, 265, 262, 9, 28, "Input",
 CellID->27403],
Cell[7906, 276, 2197, 40, 127, "Output",
 Evaluatable->False,
 CellID->121392698]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10152, 322, 215, 7, 70, "ExampleSection",
 CellID->8481],
Cell[10370, 331, 75, 1, 70, "ExampleText",
 CellID->25048],
Cell[CellGroupData[{
Cell[10470, 336, 102, 3, 70, "Input",
 CellID->18500],
Cell[10575, 341, 158, 5, 36, "Output",
 CellID->277798430]
}, Open  ]],
Cell[CellGroupData[{
Cell[10770, 351, 103, 3, 70, "Input",
 CellID->19413],
Cell[10876, 356, 168, 5, 36, "Output",
 CellID->400311613]
}, Open  ]],
Cell[11059, 364, 120, 3, 70, "ExampleDelimiter",
 CellID->2625],
Cell[11182, 369, 66, 1, 70, "ExampleText",
 CellID->10926],
Cell[CellGroupData[{
Cell[11273, 374, 183, 6, 70, "Input",
 CellID->12664],
Cell[11459, 382, 235, 7, 36, "Output",
 CellID->339602631]
}, Open  ]],
Cell[11709, 392, 109, 3, 70, "ExampleText",
 CellID->15252],
Cell[CellGroupData[{
Cell[11843, 399, 127, 3, 70, "Input",
 CellID->32300],
Cell[11973, 404, 219, 6, 36, "Output",
 CellID->154747308]
}, Open  ]],
Cell[12207, 413, 120, 3, 70, "ExampleDelimiter",
 CellID->2614],
Cell[12330, 418, 56, 1, 70, "ExampleText",
 CellID->11523],
Cell[CellGroupData[{
Cell[12411, 423, 219, 7, 70, "Input",
 CellID->28330],
Cell[12633, 432, 1324, 41, 56, "Output",
 CellID->118371117]
}, Open  ]],
Cell[13972, 476, 125, 3, 70, "ExampleDelimiter",
 CellID->559922074],
Cell[14100, 481, 203, 7, 70, "ExampleText",
 CellID->527916890],
Cell[CellGroupData[{
Cell[14328, 492, 144, 4, 70, "Input",
 CellID->415879500],
Cell[14475, 498, 277, 9, 52, "Output",
 CellID->85602714]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14801, 513, 238, 7, 70, "ExampleSection",
 CellID->4566],
Cell[15042, 522, 220, 7, 70, "ExampleText",
 CellID->7741],
Cell[CellGroupData[{
Cell[15287, 533, 200, 7, 70, "Input",
 CellID->14578],
Cell[15490, 542, 302, 9, 36, "Output",
 CellID->74262053]
}, Open  ]],
Cell[CellGroupData[{
Cell[15829, 556, 256, 7, 70, "ExampleSubsection",
 CellID->629],
Cell[16088, 565, 60, 1, 70, "ExampleText",
 CellID->31014],
Cell[CellGroupData[{
Cell[16173, 570, 153, 5, 70, "Input",
 CellID->19494],
Cell[16329, 577, 175, 5, 36, "Output",
 CellID->59665500]
}, Open  ]],
Cell[16519, 585, 121, 3, 70, "ExampleDelimiter",
 CellID->10973],
Cell[16643, 590, 56, 1, 70, "ExampleText",
 CellID->22384],
Cell[CellGroupData[{
Cell[16724, 595, 244, 8, 70, "Input",
 CellID->2306],
Cell[16971, 605, 978, 28, 40, "Output",
 CellID->9137621]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[18010, 640, 222, 7, 70, "ExampleSection",
 CellID->1643],
Cell[18235, 649, 83, 1, 70, "ExampleText",
 CellID->1634],
Cell[CellGroupData[{
Cell[18343, 654, 240, 9, 70, "Input",
 CellID->18761],
Cell[18586, 665, 552, 13, 54, "Output",
 CellID->99093697]
}, Open  ]],
Cell[19153, 681, 121, 3, 70, "ExampleDelimiter",
 CellID->32030],
Cell[19277, 686, 142, 4, 70, "ExampleText",
 CellID->32516],
Cell[CellGroupData[{
Cell[19444, 694, 154, 5, 70, "Input",
 CellID->13940],
Cell[19601, 701, 176, 5, 36, "Output",
 CellID->118414356]
}, Open  ]],
Cell[19792, 709, 121, 3, 70, "ExampleDelimiter",
 CellID->30870],
Cell[19916, 714, 188, 8, 70, "ExampleText",
 CellID->19598],
Cell[CellGroupData[{
Cell[20129, 726, 395, 14, 70, "Input",
 CellID->7994],
Cell[20527, 742, 15202, 253, 70, "Output",
 Evaluatable->False,
 CellID->403908308]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[35778, 1001, 233, 7, 70, "ExampleSection",
 CellID->24504],
Cell[36014, 1010, 71, 1, 70, "ExampleText",
 CellID->24141],
Cell[CellGroupData[{
Cell[36110, 1015, 307, 11, 70, "Input",
 CellID->26096],
Cell[36420, 1028, 913, 31, 72, "Output",
 CellID->239954748]
}, Open  ]],
Cell[37348, 1062, 121, 3, 70, "ExampleDelimiter",
 CellID->26756],
Cell[37472, 1067, 91, 1, 70, "ExampleText",
 CellID->5771],
Cell[CellGroupData[{
Cell[37588, 1072, 298, 10, 70, "Input",
 CellID->23807],
Cell[37889, 1084, 248, 8, 36, "Output",
 CellID->171183267]
}, Open  ]],
Cell[38152, 1095, 121, 3, 70, "ExampleDelimiter",
 CellID->26176],
Cell[38276, 1100, 238, 9, 70, "ExampleText",
 CellID->19910],
Cell[CellGroupData[{
Cell[38539, 1113, 427, 15, 70, "Input",
 CellID->28743],
Cell[38969, 1130, 452, 8, 70, "Message",
 CellID->93760756],
Cell[39424, 1140, 599, 20, 55, "Output",
 CellID->541215245]
}, Open  ]],
Cell[40038, 1163, 121, 3, 70, "ExampleDelimiter",
 CellID->27108],
Cell[40162, 1168, 74, 1, 70, "ExampleText",
 CellID->17027],
Cell[CellGroupData[{
Cell[40261, 1173, 180, 6, 70, "Input",
 CellID->4430],
Cell[40444, 1181, 272, 9, 36, "Output",
 CellID->3603596]
}, Open  ]],
Cell[CellGroupData[{
Cell[40753, 1195, 103, 3, 70, "Input",
 CellID->22123],
Cell[40859, 1200, 158, 5, 36, "Output",
 CellID->100345790]
}, Open  ]],
Cell[41032, 1208, 120, 3, 70, "ExampleDelimiter",
 CellID->2171],
Cell[41155, 1213, 200, 7, 70, "ExampleText",
 CellID->14931],
Cell[CellGroupData[{
Cell[41380, 1224, 111, 3, 70, "Input",
 CellID->29190],
Cell[41494, 1229, 270, 9, 36, "Output",
 CellID->2977032]
}, Open  ]],
Cell[CellGroupData[{
Cell[41801, 1243, 212, 7, 70, "Input",
 CellID->23862],
Cell[42016, 1252, 161, 5, 36, "Output",
 CellID->515196686]
}, Open  ]],
Cell[42192, 1260, 120, 3, 70, "ExampleDelimiter",
 CellID->3078],
Cell[42315, 1265, 402, 14, 70, "ExampleText",
 CellID->20010],
Cell[CellGroupData[{
Cell[42742, 1283, 219, 8, 70, "Input",
 CellID->19184],
Cell[42964, 1293, 194, 6, 36, "Output",
 CellID->548974895]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[43207, 1305, 226, 7, 70, "ExampleSection",
 CellID->14845],
Cell[43436, 1314, 358, 13, 70, "ExampleText",
 CellID->8581],
Cell[CellGroupData[{
Cell[43819, 1331, 126, 4, 70, "Input",
 CellID->1892],
Cell[43948, 1337, 196, 6, 36, "Output",
 CellID->2337840]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[44193, 1349, 224, 7, 70, "ExampleSection",
 CellID->14221],
Cell[44420, 1358, 201, 8, 70, "ExampleText",
 CellID->4122],
Cell[CellGroupData[{
Cell[44646, 1370, 802, 25, 70, "Input",
 CellID->12153],
Cell[45451, 1397, 22193, 368, 70, "Output",
 Evaluatable->False,
 CellID->489293156]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[67705, 1772, 310, 9, 70, "SeeAlsoSection",
 CellID->9760],
Cell[68018, 1783, 1260, 44, 70, "SeeAlso",
 CellID->13041]
}, Open  ]],
Cell[CellGroupData[{
Cell[69315, 1832, 314, 9, 70, "TutorialsSection",
 CellID->11633],
Cell[69632, 1843, 144, 3, 70, "Tutorials",
 CellID->18846]
}, Open  ]],
Cell[CellGroupData[{
Cell[69813, 1851, 321, 9, 70, "RelatedLinksSection",
 CellID->13774],
Cell[70137, 1862, 176, 4, 70, "RelatedLinks"],
Cell[70316, 1868, 195, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[70548, 1877, 319, 9, 70, "MoreAboutSection",
 CellID->198196721],
Cell[70870, 1888, 191, 4, 70, "MoreAbout",
 CellID->237841561],
Cell[71064, 1894, 164, 3, 70, "MoreAbout",
 CellID->98900458],
Cell[71231, 1899, 145, 3, 70, "MoreAbout",
 CellID->212205196],
Cell[71379, 1904, 145, 3, 70, "MoreAbout",
 CellID->163537487]
}, Open  ]],
Cell[71539, 1910, 27, 0, 70, "History"],
Cell[71569, 1912, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

