(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     75100,       2388]
NotebookOptionsPosition[     64932,       2033]
NotebookOutlinePosition[     66391,       2072]
CellTagsIndexPosition[     66305,       2067]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Numerical Data" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingNumericalData"], 
          "Discrete Fourier Transforms" :> 
          Documentation`HelpLookup["paclet:tutorial/FourierTransforms"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Manipulating Numerical Data\"\>", 
       2->"\<\"Discrete Fourier Transforms\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Fourier" :> Documentation`HelpLookup["paclet:ref/Fourier"], 
          "FourierDCT" :> Documentation`HelpLookup["paclet:ref/FourierDCT"], 
          "FourierDST" :> Documentation`HelpLookup["paclet:ref/FourierDST"], 
          "FourierTransform" :> 
          Documentation`HelpLookup["paclet:ref/FourierTransform"], 
          "InverseFourierTransform" :> 
          Documentation`HelpLookup["paclet:ref/InverseFourierTransform"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Fourier\"\>", 
       2->"\<\"FourierDCT\"\>", 3->"\<\"FourierDST\"\>", 
       4->"\<\"FourierTransform\"\>", 
       5->"\<\"InverseFourierTransform\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Data Transforms and Smoothing" :> 
          Documentation`HelpLookup["paclet:guide/DataTransformsAndSmoothing"],
           "Integral Transforms" :> 
          Documentation`HelpLookup["paclet:guide/IntegralTransforms"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Data Transforms and Smoothing\"\>", 
       2->"\<\"Integral Transforms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InverseFourier", "ObjectName",
 CellID->13144],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InverseFourier",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InverseFourier"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]finds the discrete inverse Fourier transform of a list \
of complex numbers. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24951]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The inverse Fourier transform ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["u", "TI"], 
   StyleBox["r", "TI"]]], "InlineFormula"],
 " of a list ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["s", "TI"]]], "InlineFormula"],
 " of length ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " is defined to be ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     StyleBox["n", "TI"]]], 
   UnderoverscriptBox["\[Sum]", 
    RowBox[{
     StyleBox["s", "TI"], "=", "1"}], 
    StyleBox["n", "TI"],
    LimitsPositioning->True], 
   SubscriptBox[
    StyleBox["v", "TI"], 
    StyleBox["s", "TI"]], 
   SuperscriptBox[
    StyleBox["e", "TI"], 
    RowBox[{
     RowBox[{"-", "2"}], "\[Pi]", 
     StyleBox["i", "TI"], 
     RowBox[{"(", 
      RowBox[{
       StyleBox["r", "TI"], "-", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{
       StyleBox["s", "TI"], "-", "1"}], ")"}], "/", 
     StyleBox["n", "TI"]}]]}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->174632140,
  ButtonNote->"174632140"]
}], "Notes",
 CellID->28052],

Cell["\<\
Note that the zero frequency term must appear at position 1 in the input \
list. \
\>", "Notes",
 CellID->6719],

Cell["\<\
Other definitions are used in some scientific and technical fields. \
\>", "Notes",
 CellID->9195],

Cell[TextData[{
 "Different choices of definitions can be specified using the option ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4048],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}]}]], "InlineFormula"],
 " the discrete Fourier transform computed by ",
 Cell[BoxData[
  ButtonBox["Fourier",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fourier"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    SuperscriptBox[
     StyleBox["n", "TI"], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        StyleBox["a", "TI"]}], ")"}], "/", "2"}]]], 
   UnderoverscriptBox["\[Sum]", 
    RowBox[{
     StyleBox["s", "TI"], "=", "1"}], 
    StyleBox["n", "TI"],
    LimitsPositioning->True], 
   SubscriptBox[
    StyleBox["v", "TI"], 
    StyleBox["s", "TI"]], 
   SuperscriptBox[
    StyleBox["e", "TI"], 
    RowBox[{
     RowBox[{"-", "2"}], "\[Pi]", 
     StyleBox["i", "TI"], 
     StyleBox["b", "TI"], 
     RowBox[{"(", 
      RowBox[{
       StyleBox["r", "TI"], "-", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{
       StyleBox["s", "TI"], "-", "1"}], ")"}], "/", 
     StyleBox["n", "TI"]}]]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18839],

Cell[TextData[{
 "Some common choices for ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"]}], "}"}]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"0", ",", "1"}], "}"}]], "InlineFormula"],
 " (default), ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "1"}], "}"}]], "InlineFormula"],
 " (data analysis), ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", 
    RowBox[{"-", "1"}]}], "}"}]], "InlineFormula"],
 " (signal processing). "
}], "Notes",
 CellID->6989],

Cell[TextData[{
 "The setting ",
 Cell[BoxData[
  RowBox[{
   StyleBox["b", "TI"], "=", 
   RowBox[{"-", "1"}]}]], "InlineFormula"],
 " effectively corresponds to conjugating both input and output lists. "
}], "Notes",
 CellID->700],

Cell[TextData[{
 "To ensure a unique discrete Fourier transform, ",
 Cell[BoxData[
  RowBox[{"\[VerticalSeparator]", 
   StyleBox["b", "TI"], "\[VerticalSeparator]"}]], "InlineFormula"],
 " must be relatively prime to ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->27054],

Cell["\<\
The list of data need not have a length equal to a power of two. \
\>", "Notes",
 CellID->1096],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " given in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InverseFourier",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseFourier"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 " can be nested to represent an array of data in any number of dimensions. "
}], "Notes",
 CellID->4251],

Cell["The array of data must be rectangular. ", "Notes",
 CellID->14321],

Cell[TextData[{
 "If the elements of ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " are exact numbers, ",
 Cell[BoxData[
  ButtonBox["InverseFourier",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseFourier"]], "InlineFormula"],
 " begins by applying ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " to them. "
}], "Notes",
 CellID->31475]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->205694156],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->122220227],

Cell["Inverse Fourier transform of a real list:", "ExampleText",
 CellID->263592636],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourier", "[", 
  RowBox[{"{", 
   RowBox[{
   "1", ",", "0", ",", "1", ",", "1", ",", "0", ",", "1", ",", "1", ",", "1", 
    ",", "0", ",", "1", ",", "1", ",", "1", ",", "1"}], "}"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->123378913],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2.773500981126146`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.06036791406673812`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.20430072968345028`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.016615856108415438`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.3196654252552804`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.43656498892450946`"}], "-", 
    RowBox[{"0.08181776968389066`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.33420964844223333`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.6010289732440862`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.2313090221790341`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.24643392871528733`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.21008769529701243`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.4212072796263527`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.21008769529701243`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.4212072796263527`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.2313090221790341`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.24643392871528733`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.33420964844223333`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.6010289732440862`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.43656498892450946`"}], "+", 
    RowBox[{"0.08181776968389066`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.016615856108415438`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.3196654252552804`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.06036791406673812`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.20430072968345028`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{567, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->261491592]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->523458389],

Cell["Inverse Fourier transform of a complex list:", "ExampleText",
 CellID->12926469],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourier", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"2", "I"}]}], ",", 
    RowBox[{"3", "+", 
     RowBox[{"4", "I"}]}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->130761640],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2.82842712474619`", "\[InvisibleSpace]", "+", 
    RowBox[{"4.242640687119285`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.414213562373095`"}], "-", 
    RowBox[{"1.414213562373095`", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",\

 ImageSize->{281, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->91570151]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27754],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is a list of real values:"
}], "ExampleText",
 CellID->413253560],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0"}],
     "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87945966],

Cell["\<\
Compute the inverse Fourier transform with machine arithmetic:\
\>", "ExampleText",
 CellID->990656031],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourier", "[", "x", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->56592719],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.3779644730092272`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.3405342233544578`"}], "-", 
    RowBox[{"0.1639926388028409`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.23565699438616372`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.29550452425305174`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.0841050075363194`"}], "-", 
    RowBox[{"0.3684881145497891`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.0841050075363194`"}], "+", 
    RowBox[{"0.3684881145497891`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.23565699438616372`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.29550452425305174`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.3405342233544578`"}], "+", 
    RowBox[{"0.1639926388028409`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{568, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->185897244]
}, Open  ]],

Cell["Compute using 24-digit precision arithmetic:", "ExampleText",
 CellID->229684788],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourier", "[", 
  RowBox[{"N", "[", 
   RowBox[{"x", ",", "24"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->110326053],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.37796447300922722721451653623418006081`23.69897000433602", ",", 
   RowBox[{
    RowBox[{
    "-", "0.3405342233544579049302902426908887413`23.481909888084697"}], "-", 
    
    RowBox[{
    "0.1639926388028408838980160125022749532`23.119664180579505", " ", 
     "\[ImaginaryI]"}]}], ",", 
   RowBox[{
   "0.23565699438616372137999731319582503706`23.505073248104882", "+", 
    RowBox[{
    "0.29550452425305176272897285899968990422`23.566100546520282", " ", 
     "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{
    "-", "0.08410500753631943005696533862202632618`23.00589116876815"}], "-", 
    
    RowBox[{
    "0.36848811454978912116904315350258504898`23.6180295020387", " ", 
     "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{
    "-", "0.08410500753631943005696533862202632618`23.00589116876815"}], "+", 
    
    RowBox[{
    "0.36848811454978912116904315350258504898`23.6180295020387", " ", 
     "\[ImaginaryI]"}]}], ",", 
   RowBox[{
   "0.23565699438616372137999731319582503706`23.505073248104882", "-", 
    RowBox[{
    "0.29550452425305176272897285899968990422`23.566100546520282", " ", 
     "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{
    "-", "0.3405342233544579049302902426908887413`23.481909888084697"}], "+", 
    
    RowBox[{
    "0.1639926388028408838980160125022749532`23.119664180579512", " ", 
     "\[ImaginaryI]"}]}]}], "}"}]], "Output",
 ImageSize->{414, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->340050870]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->200448062],

Cell["Compute a 2D inverse Fourier transform:", "ExampleText",
 CellID->144411824],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourier", "[", 
  RowBox[{"RandomComplex", "[", 
   RowBox[{
    RowBox[{"1", "+", "I"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->311628150],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1.8819361221396396`", "\[InvisibleSpace]", "+", 
      RowBox[{"2.447995189341757`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.35459627946728384`", "\[InvisibleSpace]", "-", 
      RowBox[{"0.37057069734891673`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.07633794429608111`", "\[InvisibleSpace]", "-", 
      RowBox[{"0.8341809013169089`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.13834423243623575`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.4038191908672883`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.24132569615544897`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.233067474882971`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "0.149869062380303`"}], "+", 
      RowBox[{"0.28008047982687456`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.5544162602725162`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.0607604286349882`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{
      RowBox[{"-", "0.08600835094948626`"}], "-", 
      RowBox[{"0.29835529911955966`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.3164862623875345`", "\[InvisibleSpace]", "-", 
      RowBox[{"0.21959420265388233`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.143192342697566`", "\[InvisibleSpace]", "-", 
      RowBox[{"0.09489332495175076`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "0.3101977286928245`"}], "-", 
      RowBox[{"0.31197125784903207`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.011592052912585872`", "\[InvisibleSpace]", "-", 
      RowBox[{"0.12358493150957607`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.13488719287170495`", "\[InvisibleSpace]", "-", 
      RowBox[{"0.10328978712917142`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.10226381418439254`", "\[InvisibleSpace]", "-", 
      RowBox[{"0.3811170638218765`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{
      RowBox[{"-", "0.09099750777962774`"}], "+", 
      RowBox[{"0.032129866256604925`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{
     RowBox[{"0.008078641394783192`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.1544980007413117`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.13193592649045657`", "\[InvisibleSpace]", "-", 
      RowBox[{"0.23244346192741044`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{"0.09892405387846358`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.14340927750341614`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{
      RowBox[{"-", "0.034815845224945685`"}], "+", 
      RowBox[{"0.11005096156974617`", " ", "\[ImaginaryI]"}]}], ",", 
     RowBox[{
      RowBox[{"-", "0.10840833475861301`"}], "-", 
      RowBox[{"0.21750678575524338`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{581, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->254658387]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->100783856],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is a rank 4 tensor with a single nonzero entry:"
}], "ExampleText",
 CellID->33600865],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{"ConstantArray", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "3", ",", "2"}], "}"}]}], "]"}]}], ";", 
  RowBox[{
   RowBox[{"x", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "]"}], "]"}], "=", "1"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->142022986],

Cell["Compute the 4D inverse Fourier transform:", "ExampleText",
 CellID->29067393],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourier", "[", "x", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->151685488],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnM1u1DAQgL3NLgWWUuDEsc8BF8QBTjzEqqrUHhCo9HHhWULiNNUymlVi
Oz9j8yG1G28TZ+aLJ38fybfDw+3N98PD3fXh6uv94eft3fWvqy8/7puvqo1z
m9/OuZv3rpmumyn/0/770/x0k93Uu/Z31f+1dlvR/iDanwbmf7ny8kPtymf9
dmCuj82vs6b5WVm6/V5GOdX8odmcjcqmjaJtbh/X2n7ums/j77XP3UC/5zP1
K9vPycd0PtOMUj/X7qntl3FPFfRs1Nzp32q5tOs/NxudFu0L2MI2M7bhe5Q3
A3NVaiz7hXKWe9FXpqKRrC5gB7sV2IW2N77fuHMJtkDdj86j9iXsYLcCuyWv
IrSct647D9I+5XnReJIhvU43mshlzlzWHqkpsch7DftV1ir7S9hvwqJgFmtW
WmrV62f9FyuuW84VN9Lg8r9yiavGIaPUzlU95tTfg6rc6bvR7fxtqK8jl5Os
5N6CeCYYS74h3WL4VOk20veXjX3sl9+Pijp3i1WalSstH9n2HgariPmCLWxP
stWi747C2MP4aCQrDBjsLNhDfyWPHUyIBsMFOwvsZM36ozX2j1wWz2XukZhy
DWzT4mC0YDGmvykrqXwbg6WCSwgXvdqwc3nHI7eXj8830u2bHKdDI6oMGyd7
HVrKpp0LzSJ3G1Sa3SotH9nubF3oKMWCxEWnRYthgm1ubLXou6O2JB53zsy9
V40VRgp2dmzeNOcMEK/70SgJww52C7PT703NV+n2rFJJhqykXJYemSnX1DYt
D8YLFmP6m7Oyyrc7WC+4hHDRqy/U+Kxtv6zZOGvxyO01pR0s/dk8ta6yeVZP
i773Ozy7Rz7r5jPqrI5n+TBWsIXtSbZj2HdHbZ7ti49GssJowc6CDVTPkXjW
LyEajBbsLLAbqvSUN33kYZ1KMmgl5bL0yEw+Hh61bVgfDBgsYvqbsrLKtztY
L7iEcBlXfTwrmHc8Q1u5+5/07SR2cByrXGzgv88GYv/IZ818pjy3s+Al8rIm
GCnY5shWi543d6ZGI1lhqGBnwe7x5s7UaDBSsLPATtYsb+4kFxv2jjd3Yqhg
EcNizkoq37ZgoeASwkWvNmxc3vHI7TXls3kx99OO22XYudTqtGnvptjn9OMz
R3tUmg0rLR/Z7uxe6qjFosRFp0WLoYJtbmy16LujfOq1LpbmdDSSFYYLdnbs
4DznFGyBuh+dkjjsYLcwO/3e13KVb89ilWTkSspl7ZGashablgnjBosx/S1Z
aeXbJiwcXEK46NUYc09H0q0cttBqPHJ7hdlLt/kLcsrISg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{476, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->700200873]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18290],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FourierParameters",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->24985],

Cell["No normalization:", "ExampleText",
 CellID->185963725],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "=", 
  RowBox[{"InverseFourier", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "1", ",", "0", ",", "1", ",", "0", ",", "0", ",", "1", ",", "0", ",", 
      "0", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"FourierParameters", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->320765889],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0.4`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.11180339887498947`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.03632712640026805`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.15`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.03632712640026804`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.11180339887498947`"}], "+", 
    RowBox[{"0.15388417685876268`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.15000000000000002`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.15388417685876268`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.15000000000000002`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.15388417685876268`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.11180339887498947`"}], "-", 
    RowBox[{"0.15388417685876268`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.15`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.03632712640026804`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.11180339887498947`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.03632712640026805`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{462, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->788439319]
}, Open  ]],

Cell[TextData[{
 "Normalization by ",
 Cell[BoxData[
  RowBox[{
   StyleBox["1", "TR"], "/", 
   SqrtBox[
    StyleBox["n", "TI"]]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->741719999],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourier", "[", 
  RowBox[{"{", 
   RowBox[{
   "1", ",", "0", ",", "1", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", 
    ",", "0", ",", "1"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->164749528],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1.2649110640673518`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.35355339059327373`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.11487646027368062`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.47434164902525683`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.11487646027368058`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.35355339059327373`"}], "+", 
    RowBox[{"0.4866244947338651`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.4743416490252569`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.4866244947338651`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.4743416490252569`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.4866244947338651`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.35355339059327373`"}], "-", 
    RowBox[{"0.4866244947338651`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.47434164902525683`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.11487646027368058`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.35355339059327373`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.11487646027368062`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{518, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->66037746]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "*", 
  RowBox[{"Sqrt", "[", "10", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->215750475],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"4.`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.118033988749895`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.36327126400268056`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.4999999999999998`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.3632712640026804`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.118033988749895`"}], "+", 
    RowBox[{"1.5388417685876268`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.5`", "\[InvisibleSpace]", "+", 
    RowBox[{"1.5388417685876268`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.5`", "\[InvisibleSpace]", "-", 
    RowBox[{"1.5388417685876268`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.118033988749895`"}], "-", 
    RowBox[{"1.5388417685876268`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.4999999999999998`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.3632712640026804`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.118033988749895`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.36327126400268056`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{567, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->201182007]
}, Open  ]],

Cell[TextData[{
 "Normalization by ",
 Cell[BoxData[
  RowBox[{
   StyleBox["1", "TR"], "/", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1380829],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourier", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "0", ",", "1", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0",
      ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"FourierParameters", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->448291357],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"4.`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.1180339887498947`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.3632712640026805`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.4999999999999998`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.3632712640026804`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.1180339887498947`"}], "+", 
    RowBox[{"1.5388417685876268`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.5`", "\[InvisibleSpace]", "+", 
    RowBox[{"1.5388417685876268`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.5`", "\[InvisibleSpace]", "-", 
    RowBox[{"1.5388417685876268`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.1180339887498947`"}], "-", 
    RowBox[{"1.5388417685876268`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.4999999999999998`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.3632712640026804`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.1180339887498947`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.3632712640026805`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{567, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->759628352]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30882640],

Cell[TextData[{
 "For real data, ",
 Cell[BoxData[
  ButtonBox["InverseFourier",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseFourier"]], "InlineFormula"],
 " is the same as ",
 Cell[BoxData[
  ButtonBox["Fourier",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fourier"]], "InlineFormula"],
 " with parameter ",
 Cell[BoxData[
  RowBox[{
   StyleBox["b", "TI"], "=", 
   RowBox[{"-", 
    StyleBox["1", "TR"]}]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->354992793],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourier", "[", 
  RowBox[{"{", 
   RowBox[{
   "1", ",", "0", ",", "1", ",", "1", ",", "0", ",", "1", ",", "1", ",", 
    "1"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16428431],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2.1213203435596424`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.10355339059327373`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.25`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.35355339059327373`"}], "+", 
    RowBox[{"0.35355339059327373`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.6035533905932737`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.25`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.6035533905932737`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.25`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.35355339059327373`"}], "-", 
    RowBox[{"0.35355339059327373`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.10355339059327373`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.25`", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",
 ImageSize->{497, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->517668268]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fourier", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "0", ",", "1", ",", "1", ",", "0", ",", "1", ",", "1", ",", 
     "1"}], "}"}], ",", 
   RowBox[{"FourierParameters", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"-", "1"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->837585869],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2.1213203435596424`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.10355339059327373`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.25`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.35355339059327373`"}], "+", 
    RowBox[{"0.35355339059327373`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.6035533905932737`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.25`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.6035533905932737`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.25`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.35355339059327373`"}], "-", 
    RowBox[{"0.35355339059327373`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.10355339059327373`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.25`", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",
 ImageSize->{497, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->53898418]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellLabel->"In[3]:=",
 CellID->698575024],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->43068943],

Cell["Data from a sinc function with noise: ", "ExampleText",
 CellID->209804439],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Sinc", "[", 
       RowBox[{"x", "-", "10"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "100"}], "}"}]}], "]"}], "+", 
    RowBox[{"RandomReal", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", ".05"}], ",", ".05"}], "}"}], ",", 
      RowBox[{"{", "100", "}"}]}], "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->218852198],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"x", ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20447913],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJw1lHswXHccxW8N49HUozQqRTwygqgRZZEox9su67FrLSUT75SECFoiEish
hISMNyGEzQZpQ41tRU1JpkglTNaoTI2QIPmjhEijbaSk7fjuztzZ+dxzzznf
+/v9do1jjvPiFRiGifvv+v97+/PSVcfiPudwttSVbqB6/IlP75CcVeAUmzO3
/3Q/sSYU510eKkukA9usg+SQybj12THij7H77fLQj3YjxPoojS4Y6Ll9k/xG
2LA90235aJrYBK9LuooRvky8B887uk2j01eJzXBkkRkzZMl1c0gcBvRsP50l
toRu6YxD2qvrxFbYuXZC6ze9Yeq3RkyWeMJl4h6xDZJfcbQ1rGuJ96N8s+Cm
wsk+8ttiyvBFrr7XIPFneLj3bBRT/T2xHazsDGR/dxaS3x51CrU5JaoSYhaM
SvTdFp7F0fMO0PTsmuJZfUfsCHGC06+MXi+xE3jKvTkpMWLiAxiyP++tGtlB
eQcxqd/AzW++SuyMrAZW1Y70IuLPcVT5VLHTcA75XcB8MsLKi/Qg3RX8UtXO
NxE9pAPspBnt491527oIiG1Qj/LX6qbn3VCkW/h6SUzrI3LDjpZBx113zpHf
HZGCAMGKF7HIHY8DOpQsxitI98BUcUXa5j9XSfdAk8TQ+YvKZsr3hGg1SkHj
eR7pnmgcteC8LZfrXljpX2VnvWsn3Qua102T1JeqKd8b+e++VUo17SDdG86L
zYbZyRmk++Bwq3bkBPsKze8DaUitRBZeRvm+GD0mC2UfqyS/L8S22QJFvxrS
2WgVprapZdSSzkbC6uSltQX5eeFgXpzi2a7UTvkcRKk1KlWOCqjfD062iQ7X
zC6S7gdmrvGCYZwf+f2x3N6Su0+njfL98fVok+uKsZh0LuJnT/1xwv4y+blg
7WrcUFiUzxcAA+1farYSWkkPwO44TuIV807qD0SfRMd7p0MN5QfC/VlZrv66
PD8IFhsLRpkPircZQcj8IaIo16ue8oJwqG/EQPr+tW3/YBCGhW/8Zv1bKT8Y
VjrCfRZVtD4IxmanR+GRD2h/RMGYNtLXdZ4s2M4bDIZ7YuEUq/Ub6udBReVp
2SUJzQMeJH/OpfHqm6ifh5YCS6HSXTpPgzys4ZY5/6cm6ufD82DnDZdAWg/w
cc5szth3roD6+Vg5/V5vwEAV+fn4ULo8fZ7bRv0hqGWLWP1mlIcQPPnItS3F
JJb8IbjjHaekzq2j+UNQ3fUo9taFcvILcHaptyhHXEH9AsgatH/OT5fvtwBt
S1rOJx3l7y/AsEY9//dDdN6YUKglceMFj0vIH4rLt7dEL8bo9y4KRc/e9cCj
W/R/MhiKjIuZ1tFPb1C/EDaKvL/8RdHkF+LMuIn7eCjNIxJiD8sjIvvlOfIL
IZsfnc7foP1lwlB6LyGcWaV8hIEzY9Rz1yef3j8MldL7NgekRbR+YdCTjdoz
DnQemHA8GP/qy5LUOtd/AWLB2ks=
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->854829051]
}, Open  ]],

Cell["Get the Fourier transform:", "ExampleText",
 CellID->327738748],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{"Fourier", "[", 
    RowBox[{"x", ",", 
     RowBox[{"FourierParameters", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->112561964],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Abs", "[", "f", "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->31088335],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxdlWtIU2EYx9UiFEWTLKzUtKxMY3jXvO3xus3b7jtrKerSyuUt0TS0PKRW
EJZZKGmWUzEkaiT2qcAzslFZmob7oCgYpNYHqWBiJlHhc4L3HRzG7/zPe97n
fS7/46cvVxQ52NnZFf69/v1v/r4Jb/z0f7Ta0iPEG3B3vX/0y4YR2RFqcxg3
SzXP2yGq5pVpZph/3gOSnK61ik33kD0hZo/u/VNRJ7IXfLd0+Mxb7iP7gvCA
Nd99gF+/H+p3xbyp7OHZH1qOTLYcbuhDPgQV/ZGCuHZ+/wDwcnLvDtbzHAgD
BUtfB2d5Pgrn3L3DbAHdyAKozDXZ1ot5DoaoYcMLn4cdyCEwMvVsh225DTkU
bl5sEi131iGHQfBLxn6x14AcDqP5E7GP355GjoB8y2/X6wIGORJurfaWTRt1
yFEgnhOpm9dykaMhOiLPY0MgQz4GTJK6IHCmFDkGFnaWTq7MnkCOhRBD15jS
tRA5Dq4kBsWtRRQgx8ODH37GwX18PAkw3vfR+bNJgSyEO+cP6kq6ipABvJ3q
XbYU6TeZBdC1asYbzRWoJ8KHxTM9/X64P5sIhebnLhOn+HiToO22YUVir0U9
CVZ0jkNNvrWoJ8NUxrRb/F7MF5sMAoVka8JcFeopsNvc/Kn6ghL1FChxOrt2
6Z0U9VQYzAnQGKQnUU+FspElW6MDf740iG5qqLO68uvToCZU7Cy5KkJdBEOe
6ZcXcvn4RdA20568zViMuhheh1ufBDGYP1YMerE1pds9D3UJOJgnqyS/ylGX
QGfN/FhpHaCeTunp1PoM6v0Z1P6ZVHyZVPxZ1PmyqPNnU/nJpvInpfIrpfIv
I+sDMrJ+rIysLyej6i8n+wPkZP+wcrK/ODnVfwqyP0FB9i+rIPubU1D9ryTn
A5Tk/LBKcr44JTV/KnI+QUXOL6si55tTUfOvJv0B1KR/sGrSXzg15T8a0p9A
Q/oXqyH9jdNQ/seQ/ggM6Z8sQ/orx1D+qyX9GbSkf7Na0t85LeX/x/9/H/4A
LLe3Cg==
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 100.}, {0., 0.03807948690571825}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->64829598]
}, Open  ]],

Cell["Reconstruct the signal from part of the spectrum:", "ExampleText",
 CellID->112725837],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"s", "=", 
   RowBox[{"2", " ", 
    RowBox[{"InverseFourier", "[", 
     RowBox[{
      RowBox[{"Take", "[", 
       RowBox[{"f", ",", "20"}], "]"}], ",", 
      RowBox[{"FourierParameters", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", ".2"}], "}"}]}]}], "]"}]}]}], 
  ";"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->89179771],

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseFourier", "::", "\<\"fpopt2\"\>"}], ":", 
  " ", "\<\"Warning: the discrete Fourier transform may not be invertible \
unless the second element of the option FourierParameters -> \
\\!\\({\\(\\(-1\\)\\), 0.2`}\\) is an integer having no factors in common \
with the length of the input.\"\>"}]], "Message", "MSG",
 CellID->155709136]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"Re", "[", "s", "]"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}], ",", 
   RowBox[{"ListPlot", "[", "x", "]"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->106816461],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWM1PE0EUH7q7wIEmHjhoQrUKRhOFC9wMSETxQD0RgwZj0jTEEiIYyomD
By8kBM+EBEMwYuJZY/8AL3Ly6tl/ZJyvnTf75u10a8EYm7TbNzPv977fvPZR
fau58rK+tdqoVx9u1l81Vxut6vzGpliK+hhjX8T7xUUmvnPxTb0vcM5ZJL+p
FzuWHwyvjima7+yIPd5ssljRS/P7d6cPHszss2lFn3z4Iei3e99YoujT7782
1j+3v/5kt0Ko1apEHRw0qKc3721MtNojMwZ16fFHKWXukE2GUNptPjvLj44M
CtAa5XRzT6I+2Ta6gS2gW0mAjopn5DxLZn1EnoqtrmZXC0tfVUHEDk9E6nsd
0VcVMtCa3z1xCVmk9gfsPmwYHVii9+yn4pAJ0CefZ6TVZURHiL5CIvxtLaoO
ne8JGa0Kz+ZwbNbHiukAJzhkUmfJLo7KMSffY7Q/WkyTxNVESlZe7Hf5isZD
awR1nBjbrnHI8JLJupIpB5eOeKgSoNeA/6Eu3wQ0gp6xjKI2FuKyhbKMPE3F
3kfZ5tlOUqHixcri8ySNjYeR9EjjnOgV76xprJ/txnJJeL7/j/BEVjDn5vG8
WkP0MIrnFDdZw5ybxkOZRFzjKL5TqS3uTWPzV+/Cnai5oXbuBGTCnbdGnoqR
ZglJQ+3gfB9H+7cR/1BAKtifkDTUYg3RI0hKGXkIpEr/mZkB3dPZ3iPQXn+S
aCuHqTRrI+6eZeTZkI2gcxmhrNFaYM9bLYJS7CkcL2zrGrkPWg2TUoaQLS1E
YymAIv1fRjq2KP+mrVy93LtW0elA5Oi0iyzRMrO3WIJwcjCsHRQG7it4DthF
1lAYA4hHdnBJHhc8699tWR5ll7/iczk+7s9UR97d+Z7MB3qW77R6fnhe7niT
Cm1ld5HO83yc7+/cmKQ6SVL1b6fyGwRvOh9hOzQv1G/3vFC1Dc+XOBdpj6Sx
eIbsmCPjp6VC3eJZJ8hlK7WCdA9y2drEk+AcoT/IoDGXESZ9qofcdWu/YOYW
rv9z48rrZuleESs6TXx+Dxvg8Ovgv+th/3geuF0lFP1z1OeMbjNVwU5X0PMK
9LGFANfJxFN56sZzbwYNcS3V3slTswfeLLmQ0fe+3rVdDk9StIyeMzHz3xOe
PygvLyCPLSoAzBl1jKvGgbugNxzwWzc4kMvdy+2Nr0g+a8sgVxcz8cO/k2CX
wLBZRJ8yOvX9BkUWGMw=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->440622247]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7278],

Cell["Some Gaussian data:", "ExampleText",
 CellID->557484947],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{"-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"x", "-", "50"}], ")"}], "/", "10"}], ")"}], "^", "2"}]}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "100"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListPlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->143210398],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxdlWlIFGEYxzehrERINg82DbXySFs0j9V09Vld71V3Z0+vtDAoo9TStBAZ
xQ5No1T6UCpWYuTKfkgIs5QpS9NCDKWiLKWklDWPFA90pWKfL+87MAy/+TEz
7/E8/3E5nsucsODxeNn/zv9X8zEf3m3fueFZ/UqMNyCLcW22EHxB3g6eJvVV
Y8UC8i4Q1dvZVfptCzPzbggZdN/7rW4PsgPoXg+nzgz4IDtCP+smPrZDiuwM
i6tlG0V5WmRXOPlZklU6kYO8H95enu1KCyhFdoOjVbVj0w9uInvAeafG3IDV
e8gH4ZlhzYvZ2oHsDe6895NOz3uRhcAvarZetxlF9oG+Mjnvw5ZJZF/otngk
aqleRD4Mtv6VXrKnFuFm9gPf73zHtTobZH9IVbkd+OPtjBwAtww9UyLhIeRA
EDo8fqh/F4wsgrPydfWbtGjkIPjVZ/rksckgB0O/MUc33ZyJfASKBRke6cOn
kENAPzIeqG8tQA4FWf7F0VpfFlkMOYUhp4cnryGHwVKoS6f6RS1yOHwtTnly
qeMuMoBRL5XEW7eYmQVg3P3DSwra0UtA0GipChvsQC+BFW3Fjfz1LvQRcOFM
A7/V8iX6CNg0lS+pm/rRRwJ/8Yp9q3IIfSS42nbtbLMdQS+FoDnvQM31j+il
UFBxbqWmeAx9FAz53E6vH59AHwXLlstt9+/8QB8NedmFiRnKn+ijwaq8vWnO
OIU+BuTCfda9UiP6GHATLDTMhP1GHws1VnmlAz2z6GNhs8HLVGKYQx8H5us8
+jjKx1PPx1PvT6C+n0CNT0aNX0bNL5GafyK1PknU+iVR65tMrX8ytT9ycv9A
Tu4vKyf3n5NT9aEg6wcUZH2xCrL+OAVVnwxZv8CQ9c0yZP1zDNUfSrJ/QEn2
F6sk+49TUv2pIvsXVGR/syqy/zkVlQ9qMj9ATeYLqybzh1NT+aQh8ws0ZL6x
GjL/OA2Vj1oyP0FL5iurJfOX01L5rCPzG3RkvrM6Mv85HZD/hxQQ9ma2iKoM
4r/jKsW8
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->44243205]
}, Open  ]],

Cell["The multiplication of each mode to get the first derivative:", \
"ExampleText",
 CellID->647848870],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"k", "=", 
   RowBox[{
    RowBox[{"-", "I"}], "*", 
    RowBox[{"(", 
     RowBox[{"2", "*", 
      RowBox[{"Pi", "/", "100"}]}], ")"}], "*", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{"Range", "[", "49", "]"}], ",", 
      RowBox[{"{", "0", "}"}], ",", 
      RowBox[{"-", 
       RowBox[{"Reverse", "[", 
        RowBox[{"Range", "[", "49", "]"}], "]"}]}]}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListPlot", "[", 
  RowBox[{"Abs", "[", "k", "]"}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->5172728],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxdlVlIVGEUx+/YJiRUUDjlRG6pWFZW6tg2R2ccx2WcuXeWOxX0YA0UpQZC
QVF8gSBo+CBU2Db0ktGT4FsPdWmh5i2oIGhxiKiwCG2xxbGN+Ruc88Ew/O6Z
+33n/L9z/lPQ3mXEszRN2/f38+87syZcGl+0ojR38NayETzPBlvgxXT1RuHu
RP4D8FLEH4LtlJq4eGR93mOwA79/Cs6nzp5rrkUlz8GFeD8FLqaZhbt6jtpf
gUuw32twGd15Mrb/7co34HLs/w68lvoScb9ZNA5eh/M+gDdQ8MD7yvtlH8GV
OH9Wh410esjZn5c7Cd6EfD6BN1PnyeMnHi3/DK5Cfl/A1aTvvdnV7/gKrkG+
U2AnVfls7e5V38C1yP87eAvZKzzh6YIf4K2o5yd4G6WX9HpHi6fB21FfGryD
Xk4lnQdLZ8Au1PsLTHT7Wc6aovLfGVaE+jXKxOsolBoe6DgLVnXQw4Z4Pd01
kr3Jc2BVD32yEHdT9b1xtXoIrNzQaw7iHhquyTl26jxYeaDfXMQbyH69ovvF
BbBqgJ7zEPdSnyNwqPYSWHmh73zEGyk9cDh+5jJYNULvBYj7qMM2uGcyAVY+
6J+NeBONdY+a/itg1YTns6tZxJvF+y1i/xZxfqvIr1Xk7xf1+UX9bUKfNqFf
QOgbEPoH+f1QkN+fCvL7tYLi/nXeH6Tz/lE67y9LF/1n8P4kg/evMnh/W4bo
/xCfDwrx+VEhPl9WSMxfmM8nhfn8qjCfbyss5j/C/YEi3D9UhPuLFRH+E+X+
RFHuXyrK/c2KCv8zuT+Syf1TmdxfLVP4b4z7M8W4f6sY93crJvx/5///hz9t
IZrD
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 100.}, {0., 3.078760800517997}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->28445898]
}, Open  ]],

Cell["Approximate the first derivative of the data:", "ExampleText",
 CellID->60931031],

Cell[BoxData[
 RowBox[{
  RowBox[{"d", "=", 
   RowBox[{"InverseFourier", "[", 
    RowBox[{
     RowBox[{"Fourier", "[", "data", "]"}], "*", "k"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->512744128],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{"d", ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{"-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"x", "-", "50"}], ")"}], "/", "10"}], ")"}], "^", 
           "2"}]}], "]"}], ",", "x"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "100"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->247737702],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->583773901]
}, Open  ]],

Cell["\<\
Note the derivative approximation implicitly assumes periodicity:\
\>", "ExampleText",
 CellID->687590751],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"InverseFourier", "[", 
   RowBox[{
    RowBox[{"Fourier", "[", 
     RowBox[{"Range", "[", "100", "]"}], "]"}], "*", "k"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->236893832],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxd1HtMjXEYB/C3VJKUOo1qabmOokXlcpK+1enU0eFcOhfZaaHcjzBsjejF
6o8wl2LCwmyxHfIPy7LpbQ2by7rQspIiZiQc5oyzdtzOM3uOd3v37rfPu/f9
XZ7nO3nNVv1ab0EQLL/vP0+HLj+oaEIYnj8M+brvyxRJ+HuFo88/uza6dyrc
4yisHIgwdsyKJI/Beps9dHZQNPkUlCsDIuIHQ8mnocXZvu1eQTj5DJTV2M4m
1wWSz0Tp+ENFJafDyGNRdmoLKlR+5LPhOFlqUbwJIY9H/7mplYV1XuQJOOxQ
f/C7GUw+F2nWVsV1n5Fm93geujPnpgyXBZInwlku82uXO8iTcEaZOu5d3xjy
ZLSpdIUbd9jJ5+PwHNOPj1dHky/Atpb7q690vCdfiKi4kwX7H/uSL0L5qNaw
b92D5HIorLJgV5wPeQqCJ73Q5m/tJV+M0vwM+bomb/JUyB/XN/odaCdfAtnr
p5adJV7kaXDOujF588EmciDisirRCsHtIuCa2HPqof5SmtvTccS3xqfB4HKP
xXQkz9zbfbn6LnkG1I1K/1GaEfIMZNx7m5JyvpM8E6GNzudZG5zkmeh6GVds
9+0hV6B6aEv34jPfyRW4E9B1oaBqgDwLtt1DLlu/gzwLDY+ssj2fBsmVuL39
+JzQpG/kSiQEea2U5G/Js+HIPDGyq/oreTZWVHV2Ne54T56DVR/VhalOO3kO
mousQ5qLw+QqxFgkfeDaz+QqRPKxsBRCMXtfXIoQ/j0hFw/4/8Rc3OLzEdS4
wecrqvGZr0dYhr18veIyXOP7ISzHLb5f4nIk8f0UNKh6xfZb1GASPw9Bi9y7
7LygxUSP89SiOZadt6TFdF4Pgg7KOFYv0GGwnteTDgPTWL1JOsR41KMenbxe
oUclr2dRj59RrN4lPSwe/ZCHJ7xfkIcs3k9iHo7xfpPycNqjHw3YzPsVBtTw
fhYNGCuyfpcMeO2RB0as4HkBI47yPBGNeMbzRjL+l0cmVPC8ggklPM9EE47y
vJNMaPPIQzPO8ryEGSLPU9GMAp63khm9lMcvN0W21brM//L6F6onrx0=
     "]], 
    LineBox[{{1.5885223174068577`, -9.473624797747043}, {1.7945229223111054`, 
     11.119658098461363`}}], 
    LineBox[{{2.4113604191225324`, 11.119658098461363`}, {
     2.8237689277796836`, -9.473624797747043}}], 
    LineBox[{{3.2647831065564374`, -9.473624797747043}, {3.8844173442465544`, 
     11.119658098461363`}}], 
    LineBox[{{4.154467577202634, 11.119658098461363`}, {
     4.982562405305247, -9.473624797747043}}], 
    LineBox[{{96.01743759469475, -9.473624797747043}, {96.84553242279736, 
     11.119658098461363`}}], 
    LineBox[{{97.11558265575344, 11.119658098461363`}, {
     97.73521689344356, -9.473624797747043}}], 
    LineBox[{{98.17623107222032, -9.473624797747043}, {98.58863958087747, 
     11.119658098461363`}}], 
    LineBox[{{99.2054770776889, 11.119658098461363`}, {
     99.41147768259314, -9.473624797747043}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 100.}, {-9.473624797747043, 11.119658098461363`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->858169078]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4671],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   SubscriptBox["v", "s"], TraditionalForm]], "InlineMath"],
 " is given by ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     StyleBox["n", "TI"]]], 
   UnderoverscriptBox["\[Sum]", 
    RowBox[{
     StyleBox["r", "TI"], "=", "1"}], 
    StyleBox["n", "TI"],
    LimitsPositioning->True], 
   SubscriptBox[
    StyleBox["u", "TI"], 
    StyleBox["r", "TI"]], 
   SuperscriptBox[
    StyleBox["e", "TI"], 
    RowBox[{
     RowBox[{"-", "2"}], 
     StyleBox[
      RowBox[{"\[Pi]", 
       StyleBox["i", "TI"]}]], 
     RowBox[{"(", 
      RowBox[{
       StyleBox["r", "TI"], "-", "1"}], ")"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        StyleBox["s", "TI"], "-", "1"}], ")"}], "/", 
      StyleBox["n", "TI"]}]}]]}]]],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->174632140],

Cell[BoxData[{
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{"N", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7"}], "}"}],
     "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"n", "=", 
   RowBox[{"Length", "[", "x", "]"}]}], ";"}], "\n", 
 RowBox[{"u", "/:", 
  RowBox[{"Subscript", "[", 
   RowBox[{"u", ",", "r_"}], "]"}], ":=", 
  RowBox[{"x", "[", 
   RowBox[{"[", "r", "]"}], "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->272526693],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     FractionBox["1", 
      SqrtBox[
       StyleBox["n", "TI"]]], 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{
        StyleBox["r", "TI"], "=", "1"}], 
       StyleBox["n", "TI"],
       LimitsPositioning->True], 
      RowBox[{
       SubscriptBox[
        StyleBox["u", "TI"], 
        StyleBox["r", "TI"]], 
       SuperscriptBox[
        StyleBox["\[ExponentialE]", "TI"], 
        RowBox[{
         RowBox[{"-", "2"}], "\[Pi]", " ", "\[ImaginaryI]", 
         RowBox[{"(", 
          RowBox[{
           StyleBox["r", "TI"], "-", "1"}], ")"}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            StyleBox["s", "TI"], "-", "1"}], ")"}], "/", 
          StyleBox["n", "TI"]}]}]]}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"s", ",", "1", ",", "n"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->282552249],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10.583005244258361`", ",", 
   RowBox[{
    RowBox[{"-", "1.3228756555322945`"}], "+", 
    RowBox[{"2.746979603717467`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.3228756555322945`"}], "+", 
    RowBox[{"1.054958132087371`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.3228756555322945`"}], "+", 
    RowBox[{"0.3019377358048386`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.3228756555322945`"}], "-", 
    RowBox[{"0.3019377358048386`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.3228756555322945`"}], "-", 
    RowBox[{"1.054958132087371`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.3228756555322945`"}], "-", 
    RowBox[{"2.746979603717467`", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",\

 ImageSize->{489, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->454424648]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Chop", "[", 
  RowBox[{"v", "-", 
   RowBox[{"InverseFourier", "[", "x", "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->230118472],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], 
  "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->265916664]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->642067338],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseFourier",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseFourier"]], "InlineFormula"],
 " is equivalent to matrix multiplication:"
}], "ExampleText",
 CellID->85199546],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "[", "n_", "]"}], ":=", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     StyleBox["n", "TI"]]], 
   RowBox[{"Table", "[", 
    RowBox[{
     SuperscriptBox[
      StyleBox["\[ExponentialE]", "TI"], 
      RowBox[{
       RowBox[{"-", "2"}], "\[Pi]", " ", "\[ImaginaryI]", 
       RowBox[{"(", 
        RowBox[{
         StyleBox["r", "TI"], "-", "1"}], ")"}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          StyleBox["s", "TI"], "-", "1"}], ")"}], "/", 
        StyleBox["n", "TI"]}]}]], ",", 
     RowBox[{"{", 
      RowBox[{"r", ",", "1", ",", "n"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", "1", ",", "n"}], "}"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->107344537],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "=", 
  RowBox[{
   RowBox[{"m", "[", "6", "]"}], ".", 
   RowBox[{"N", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], 
    "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32015240],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"8.573214099741124`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.224744871391588`"}], "+", 
    RowBox[{"2.121320343559643`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.2247448713915878`"}], "+", 
    RowBox[{"0.7071067811865477`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.2247448713915892`"}], "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.2247448713915878`"}], "-", 
    RowBox[{"0.7071067811865477`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "1.224744871391588`"}], "-", 
    RowBox[{"2.121320343559643`", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",\

 ImageSize->{401, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->130775138]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Chop", "[", 
  RowBox[{"v", "-", 
   RowBox[{"InverseFourier", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], 
    "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->117476890],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->499068582]
}, Open  ]],

Cell[TextData[{
 "The conjugate transpose of the matrix is equivalent to ",
 Cell[BoxData[
  ButtonBox["Fourier",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fourier"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->118323452],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Chop", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ConjugateTranspose", "[", 
     RowBox[{"m", "[", "6", "]"}], "]"}], ".", 
    RowBox[{"N", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], 
     "]"}]}], "-", 
   RowBox[{"Fourier", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}], 
    "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->107782018],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->515753609]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1458],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Fourier",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Fourier"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierDCT",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierDCT"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierDST",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierDST"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseFourierTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseFourierTransform"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26519]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27921],

Cell[TextData[ButtonBox["Manipulating Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ManipulatingNumericalData"]], "Tutorials",
 CellID->29367],

Cell[TextData[ButtonBox["Discrete Fourier Transforms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FourierTransforms"]], "Tutorials",
 CellID->25968]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with InverseFourier",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=InverseFourier"]\
, None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->126874757],

Cell[TextData[ButtonBox["Data Transforms and Smoothing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataTransformsAndSmoothing"]], "MoreAbout",
 CellID->499417827],

Cell[TextData[ButtonBox["Integral Transforms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegralTransforms"]], "MoreAbout",
 CellID->156635289]
}, Open  ]],

Cell["New in 1  |  Last modified in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InverseFourier - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 49, 49.8695606}", "context" -> "System`", 
    "keywords" -> {
     "Cooley-Tukey transform", "data", "discrete Fourier transform", "FFT", 
      "DFT", "Fourier transforms", "frequency spectrum", "image transform", 
      "power spectrum", "spectrum", "transform"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "InverseFourier[list] finds the discrete inverse Fourier transform of a \
list of complex numbers. ", "synonyms" -> {"inverse fourier"}, "title" -> 
    "InverseFourier", "type" -> "Symbol", "uri" -> "ref/InverseFourier"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9436, 339, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->205694156]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 66162, 2060}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2605, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3228, 87, 52, 1, 70, "ObjectName",
 CellID->13144],
Cell[3283, 90, 534, 16, 70, "Usage",
 CellID->24951]
}, Open  ]],
Cell[CellGroupData[{
Cell[3854, 111, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4332, 128, 1150, 46, 70, "Notes",
 CellID->28052],
Cell[5485, 176, 121, 4, 70, "Notes",
 CellID->6719],
Cell[5609, 182, 108, 3, 70, "Notes",
 CellID->9195],
Cell[5720, 187, 258, 8, 70, "Notes",
 CellID->4048],
Cell[5981, 197, 1288, 49, 70, "Notes",
 CellID->18839],
Cell[7272, 248, 570, 23, 70, "Notes",
 CellID->6989],
Cell[7845, 273, 232, 8, 70, "Notes",
 CellID->700],
Cell[8080, 283, 312, 10, 70, "Notes",
 CellID->27054],
Cell[8395, 295, 105, 3, 70, "Notes",
 CellID->1096],
Cell[8503, 300, 390, 13, 70, "Notes",
 CellID->4251],
Cell[8896, 315, 72, 1, 70, "Notes",
 CellID->14321],
Cell[8971, 318, 428, 16, 70, "Notes",
 CellID->31475]
}, Closed]],
Cell[CellGroupData[{
Cell[9436, 339, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->205694156],
Cell[CellGroupData[{
Cell[9821, 353, 148, 5, 70, "ExampleSection",
 CellID->122220227],
Cell[9972, 360, 84, 1, 70, "ExampleText",
 CellID->263592636],
Cell[CellGroupData[{
Cell[10081, 365, 278, 8, 28, "Input",
 CellID->123378913],
Cell[10362, 375, 1850, 36, 88, "Output",
 CellID->261491592]
}, Open  ]],
Cell[12227, 414, 125, 3, 70, "ExampleDelimiter",
 CellID->523458389],
Cell[12355, 419, 86, 1, 70, "ExampleText",
 CellID->12926469],
Cell[CellGroupData[{
Cell[12466, 424, 249, 9, 70, "Input",
 CellID->130761640],
Cell[12718, 435, 435, 13, 36, "Output",
 CellID->91570151]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13202, 454, 216, 7, 70, "ExampleSection",
 CellID->27754],
Cell[13421, 463, 141, 5, 70, "ExampleText",
 CellID->413253560],
Cell[13565, 470, 213, 7, 70, "Input",
 CellID->87945966],
Cell[13781, 479, 113, 3, 70, "ExampleText",
 CellID->990656031],
Cell[CellGroupData[{
Cell[13919, 486, 109, 3, 70, "Input",
 CellID->56592719],
Cell[14031, 491, 1067, 26, 54, "Output",
 CellID->185897244]
}, Open  ]],
Cell[15113, 520, 87, 1, 70, "ExampleText",
 CellID->229684788],
Cell[CellGroupData[{
Cell[15225, 525, 163, 5, 70, "Input",
 CellID->110326053],
Cell[15391, 532, 1558, 45, 139, "Output",
 CellID->340050870]
}, Open  ]],
Cell[16964, 580, 125, 3, 70, "ExampleDelimiter",
 CellID->200448062],
Cell[17092, 585, 82, 1, 70, "ExampleText",
 CellID->144411824],
Cell[CellGroupData[{
Cell[17199, 590, 250, 8, 70, "Input",
 CellID->311628150],
Cell[17452, 600, 3025, 64, 139, "Output",
 CellID->254658387]
}, Open  ]],
Cell[20492, 667, 125, 3, 70, "ExampleDelimiter",
 CellID->100783856],
Cell[20620, 672, 162, 5, 70, "ExampleText",
 CellID->33600865],
Cell[20785, 679, 385, 13, 70, "Input",
 CellID->142022986],
Cell[21173, 694, 83, 1, 70, "ExampleText",
 CellID->29067393],
Cell[CellGroupData[{
Cell[21281, 699, 110, 3, 70, "Input",
 CellID->151685488],
Cell[21394, 704, 1542, 29, 70, "Output",
 Evaluatable->False,
 CellID->700200873]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22985, 739, 218, 7, 70, "ExampleSection",
 CellID->18290],
Cell[CellGroupData[{
Cell[23228, 750, 234, 7, 70, "ExampleSubsection",
 CellID->24985],
Cell[23465, 759, 60, 1, 70, "ExampleText",
 CellID->185963725],
Cell[CellGroupData[{
Cell[23550, 764, 401, 12, 70, "Input",
 CellID->320765889],
Cell[23954, 778, 1388, 30, 71, "Output",
 CellID->788439319]
}, Open  ]],
Cell[25357, 811, 196, 9, 70, "ExampleText",
 CellID->741719999],
Cell[CellGroupData[{
Cell[25578, 824, 246, 7, 70, "Input",
 CellID->164749528],
Cell[25827, 833, 1426, 30, 71, "Output",
 CellID->66037746]
}, Open  ]],
Cell[CellGroupData[{
Cell[27290, 868, 124, 4, 70, "Input",
 CellID->215750475],
Cell[27417, 874, 1369, 30, 54, "Output",
 CellID->201182007]
}, Open  ]],
Cell[28801, 907, 180, 8, 70, "ExampleText",
 CellID->1380829],
Cell[CellGroupData[{
Cell[29006, 919, 392, 12, 70, "Input",
 CellID->448291357],
Cell[29401, 933, 1371, 30, 54, "Output",
 CellID->759628352]
}, Open  ]],
Cell[30787, 966, 124, 3, 70, "ExampleDelimiter",
 CellID->30882640],
Cell[30914, 971, 490, 19, 70, "ExampleText",
 CellID->354992793],
Cell[CellGroupData[{
Cell[31429, 994, 225, 7, 70, "Input",
 CellID->16428431],
Cell[31657, 1003, 1108, 25, 54, "Output",
 CellID->517668268]
}, Open  ]],
Cell[CellGroupData[{
Cell[32802, 1033, 365, 12, 70, "Input",
 CellID->837585869],
Cell[33170, 1047, 1107, 25, 54, "Output",
 CellID->53898418]
}, Open  ]],
Cell[34292, 1075, 69, 2, 70, "Input",
 CellID->698575024],
Cell[34364, 1079, 124, 3, 70, "ExampleDelimiter",
 CellID->43068943],
Cell[34491, 1084, 81, 1, 70, "ExampleText",
 CellID->209804439],
Cell[34575, 1087, 492, 17, 70, "Input",
 CellID->218852198],
Cell[CellGroupData[{
Cell[35092, 1108, 166, 5, 70, "Input",
 CellID->20447913],
Cell[35261, 1115, 1931, 39, 122, "Output",
 CellID->854829051]
}, Open  ]],
Cell[37207, 1157, 69, 1, 70, "ExampleText",
 CellID->327738748],
Cell[37279, 1160, 297, 10, 70, "Input",
 CellID->112561964],
Cell[CellGroupData[{
Cell[37601, 1174, 133, 4, 70, "Input",
 CellID->31088335],
Cell[37737, 1180, 1528, 34, 129, "Output",
 CellID->64829598]
}, Open  ]],
Cell[39280, 1217, 92, 1, 70, "ExampleText",
 CellID->112725837],
Cell[CellGroupData[{
Cell[39397, 1222, 401, 14, 70, "Input",
 CellID->89179771],
Cell[39801, 1238, 375, 7, 70, "Message",
 CellID->155709136]
}, Open  ]],
Cell[CellGroupData[{
Cell[40213, 1250, 294, 9, 70, "Input",
 CellID->106816461],
Cell[40510, 1261, 1453, 28, 70, "Output",
 Evaluatable->False,
 CellID->440622247]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[42024, 1296, 222, 7, 70, "ExampleSection",
 CellID->7278],
Cell[42249, 1305, 62, 1, 70, "ExampleText",
 CellID->557484947],
Cell[CellGroupData[{
Cell[42336, 1310, 573, 20, 70, "Input",
 CellID->143210398],
Cell[42912, 1332, 1483, 32, 137, "Output",
 CellID->44243205]
}, Open  ]],
Cell[44410, 1367, 105, 2, 70, "ExampleText",
 CellID->647848870],
Cell[CellGroupData[{
Cell[44540, 1373, 610, 20, 70, "Input",
 CellID->5172728],
Cell[45153, 1395, 1339, 31, 137, "Output",
 CellID->28445898]
}, Open  ]],
Cell[46507, 1429, 87, 1, 70, "ExampleText",
 CellID->60931031],
Cell[46597, 1432, 220, 8, 70, "Input",
 CellID->512744128],
Cell[CellGroupData[{
Cell[46842, 1444, 686, 22, 70, "Input",
 CellID->247737702],
Cell[47531, 1468, 2786, 50, 70, "Output",
 Evaluatable->False,
 CellID->583773901]
}, Open  ]],
Cell[50332, 1521, 116, 3, 70, "ExampleText",
 CellID->687590751],
Cell[CellGroupData[{
Cell[50473, 1528, 249, 8, 70, "Input",
 CellID->236893832],
Cell[50725, 1538, 2443, 50, 123, "Output",
 CellID->858169078]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[53217, 1594, 232, 7, 70, "ExampleSection",
 CellID->4671],
Cell[53452, 1603, 889, 36, 70, "ExampleText",
 CellID->174632140],
Cell[54344, 1641, 496, 17, 70, "Input",
 CellID->272526693],
Cell[CellGroupData[{
Cell[54865, 1662, 955, 33, 70, "Input",
 CellID->282552249],
Cell[55823, 1697, 972, 26, 54, "Output",
 CellID->454424648]
}, Open  ]],
Cell[CellGroupData[{
Cell[56832, 1728, 165, 5, 70, "Input",
 CellID->230118472],
Cell[57000, 1735, 257, 8, 36, "Output",
 CellID->265916664]
}, Open  ]],
Cell[57272, 1746, 125, 3, 70, "ExampleDelimiter",
 CellID->642067338],
Cell[57400, 1751, 228, 7, 70, "ExampleText",
 CellID->85199546],
Cell[57631, 1760, 759, 26, 70, "Input",
 CellID->107344537],
Cell[CellGroupData[{
Cell[58415, 1790, 268, 9, 70, "Input",
 CellID->32015240],
Cell[58686, 1801, 912, 25, 54, "Output",
 CellID->130775138]
}, Open  ]],
Cell[CellGroupData[{
Cell[59635, 1831, 261, 8, 70, "Input",
 CellID->117476890],
Cell[59899, 1841, 247, 8, 36, "Output",
 CellID->499068582]
}, Open  ]],
Cell[60161, 1852, 236, 8, 70, "ExampleText",
 CellID->118323452],
Cell[CellGroupData[{
Cell[60422, 1864, 485, 15, 70, "Input",
 CellID->107782018],
Cell[60910, 1881, 247, 8, 36, "Output",
 CellID->515753609]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[61218, 1896, 310, 9, 70, "SeeAlsoSection",
 CellID->1458],
Cell[61531, 1907, 1238, 44, 70, "SeeAlso",
 CellID->26519]
}, Open  ]],
Cell[CellGroupData[{
Cell[62806, 1956, 314, 9, 70, "TutorialsSection",
 CellID->27921],
Cell[63123, 1967, 163, 3, 70, "Tutorials",
 CellID->29367],
Cell[63289, 1972, 155, 3, 70, "Tutorials",
 CellID->25968]
}, Open  ]],
Cell[CellGroupData[{
Cell[63481, 1980, 305, 8, 70, "RelatedLinksSection"],
Cell[63789, 1990, 370, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[64196, 2007, 319, 9, 70, "MoreAboutSection",
 CellID->126874757],
Cell[64518, 2018, 167, 3, 70, "MoreAbout",
 CellID->499417827],
Cell[64688, 2023, 149, 3, 70, "MoreAbout",
 CellID->156635289]
}, Open  ]],
Cell[64852, 2029, 50, 0, 70, "History"],
Cell[64905, 2031, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

