(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18795,        672]
NotebookOptionsPosition[     14830,        542]
NotebookOutlinePosition[     16317,        581]
CellTagsIndexPosition[     16232,        576]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Function Names as Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FunctionNamesAsExpressions"], 
          "Working with Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/WorkingWithOperators"], 
          "Equations in One Variable" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EquationsInOneVariable"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Function Names as Expressions\"\>", 
       2->"\<\"Working with Operators\"\>", 
       3->"\<\"Equations in One Variable\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Solve" :> Documentation`HelpLookup["paclet:ref/Solve"], 
          "InverseSeries" :> 
          Documentation`HelpLookup["paclet:ref/InverseSeries"], "Composition" :> 
          Documentation`HelpLookup["paclet:ref/Composition"], "Derivative" :> 
          Documentation`HelpLookup["paclet:ref/Derivative"], "Identity" :> 
          Documentation`HelpLookup["paclet:ref/Identity"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Solve\"\>", 
       2->"\<\"InverseSeries\"\>", 3->"\<\"Composition\"\>", 
       4->"\<\"Derivative\"\>", 5->"\<\"Identity\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{
         "Inverse Functions" :> 
          Documentation`HelpLookup["paclet:guide/InverseFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Inverse Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InverseFunction", "ObjectName",
 CellID->7295],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InverseFunction",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InverseFunction"], "[", 
       StyleBox["f", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents the inverse of the function ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     ", defined so that ",
     Cell[BoxData[
      RowBox[{
       RowBox[{"InverseFunction", "[", 
        StyleBox["f", "TI"], "]"}], "[", 
       StyleBox["y", "TI"], "]"}]], "InlineFormula"],
     " gives the value of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " for which ",
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     " is equal to ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InverseFunction",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InverseFunction"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["n", "TI"], ",", 
        StyleBox["tot", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents the inverse with respect to the ",
     Cell[BoxData[
      StyleBox[
       RowBox[{
        StyleBox["n", "TI"], "\[Null]"}]]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " argument when there are ",
     Cell[BoxData[
      StyleBox["tot", "TI"]], "InlineFormula"],
     " arguments in all. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->19035]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["OutputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InverseFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseFunction"], "[", 
   StyleBox["f", "TI"], "]"}]], "InlineFormula"],
 " is printed as ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["f", "TI"], 
   RowBox[{"(", 
    RowBox[{"-", "1"}], ")"}]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24442],

Cell[TextData[{
 "As discussed in ",
 ButtonBox["Functions That Do Not Have Unique Values",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/FunctionsThatDoNotHaveUniqueValues"],
 ", many mathematical functions do not have unique inverses. In such cases, \
",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InverseFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseFunction"], "[", 
   StyleBox["f", "TI"], "]"}]], "InlineFormula"],
 " can represent only one of the possible inverses for ",
 StyleBox["f", "TI"],
 ". "
}], "Notes",
 CellID->29175],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseFunction"]], "InlineFormula"],
 " is generated by ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " when the option ",
 Cell[BoxData[
  ButtonBox["InverseFunctions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseFunctions"]], "InlineFormula"],
 " is set to ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15117]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->599416584],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->754270311],

Cell[TextData[{
 "The \"inverse function\" of ",
 Cell[BoxData[
  ButtonBox["Sin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["ArcSin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSin"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->93992796],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFunction", "[", "Sin", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->88041283],

Cell[BoxData["ArcSin"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->96187238]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->128801033],

Cell["Symbolic inverse function:", "ExampleText",
 CellID->162663475],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseFunction", "[", "f", "]"}], "[", "x", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->425267976],

Cell[BoxData[
 RowBox[{
  TagBox[
   SuperscriptBox["f", 
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}]],
   InverseFunction,
   Editable->False], "[", "x", "]"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->739005389]
}, Open  ]],

Cell["Derivative of an inverse function:", "ExampleText",
 CellID->295276232],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{"%", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->221501336],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{
   SuperscriptBox["f", "\[Prime]",
    MultilineFunction->None], "[", 
   RowBox[{
    TagBox[
     SuperscriptBox["f", 
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}]],
     InverseFunction,
     Editable->False], "[", "x", "]"}], "]"}]]], "Output",
 ImageSize->{82, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->446723010]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8343],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"InverseFunction", "[", "f", "]"}], "[", "x", "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->363561274],

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseFunction", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used. Values may be lost for \
multivalued inverses. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InverseFunction/ifun\\\", ButtonNote -> \\\
\"InverseFunction::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->121349245],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->414199]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28924],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Solve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Solve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseSeries",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseSeries"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Composition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Composition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Derivative",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Derivative"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Identity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Identity"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17771]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20649],

Cell[TextData[ButtonBox["Function Names as Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FunctionNamesAsExpressions"]], "Tutorials",
 CellID->6363],

Cell[TextData[ButtonBox["Working with Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/WorkingWithOperators"]], "Tutorials",
 CellID->27892],

Cell[TextData[ButtonBox["Equations in One Variable",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EquationsInOneVariable"]], "Tutorials",
 CellID->26614]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->40265709],

Cell[TextData[ButtonBox["Inverse Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InverseFunctions"]], "MoreAbout",
 CellID->14524104]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
InverseFunction"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InverseFunction - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 49, 52.4633770}", "context" -> "System`", 
    "keywords" -> {"FunctionInverse", "invert"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "InverseFunction[f] represents the inverse of the function f, defined so \
that InverseFunction[f][y] gives the value of x for which f[x] is equal to y. \
InverseFunction[f, n, tot] represents the inverse with respect to the \
n\\[Null]\\[Null]^th argument when there are tot arguments in all. ", 
    "synonyms" -> {"inverse function"}, "title" -> "InverseFunction", "type" -> 
    "Symbol", "uri" -> "ref/InverseFunction"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7540, 248, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->599416584]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16089, 569}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2523, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3146, 86, 52, 1, 70, "ObjectName",
 CellID->7295],
Cell[3201, 89, 1833, 58, 70, "Usage",
 CellID->19035]
}, Open  ]],
Cell[CellGroupData[{
Cell[5071, 152, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5549, 169, 655, 26, 70, "Notes",
 CellID->24442],
Cell[6207, 197, 561, 17, 70, "Notes",
 CellID->29175],
Cell[6771, 216, 732, 27, 70, "Notes",
 CellID->15117]
}, Closed]],
Cell[CellGroupData[{
Cell[7540, 248, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->599416584],
Cell[CellGroupData[{
Cell[7925, 262, 148, 5, 70, "ExampleSection",
 CellID->754270311],
Cell[8076, 269, 324, 13, 70, "ExampleText",
 CellID->93992796],
Cell[CellGroupData[{
Cell[8425, 286, 112, 3, 28, "Input",
 CellID->88041283],
Cell[8540, 291, 162, 5, 36, "Output",
 CellID->96187238]
}, Open  ]],
Cell[8717, 299, 125, 3, 70, "ExampleDelimiter",
 CellID->128801033],
Cell[8845, 304, 69, 1, 70, "ExampleText",
 CellID->162663475],
Cell[CellGroupData[{
Cell[8939, 309, 139, 4, 70, "Input",
 CellID->425267976],
Cell[9081, 315, 307, 12, 36, "Output",
 CellID->739005389]
}, Open  ]],
Cell[9403, 330, 77, 1, 70, "ExampleText",
 CellID->295276232],
Cell[CellGroupData[{
Cell[9505, 335, 120, 4, 70, "Input",
 CellID->221501336],
Cell[9628, 341, 430, 16, 57, "Output",
 CellID->446723010]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10107, 363, 215, 7, 70, "ExampleSection",
 CellID->8343],
Cell[CellGroupData[{
Cell[10347, 374, 171, 6, 70, "Input",
 CellID->363561274],
Cell[10521, 382, 428, 8, 70, "Message",
 CellID->121349245],
Cell[10952, 392, 155, 5, 36, "Output",
 CellID->414199]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11168, 404, 311, 9, 70, "SeeAlsoSection",
 CellID->28924],
Cell[11482, 415, 1200, 44, 70, "SeeAlso",
 CellID->17771]
}, Open  ]],
Cell[CellGroupData[{
Cell[12719, 464, 314, 9, 70, "TutorialsSection",
 CellID->20649],
Cell[13036, 475, 165, 3, 70, "Tutorials",
 CellID->6363],
Cell[13204, 480, 153, 3, 70, "Tutorials",
 CellID->27892],
Cell[13360, 485, 158, 3, 70, "Tutorials",
 CellID->26614]
}, Open  ]],
Cell[CellGroupData[{
Cell[13555, 493, 318, 9, 70, "MoreAboutSection",
 CellID->40265709],
Cell[13876, 504, 144, 3, 70, "MoreAbout",
 CellID->14524104]
}, Open  ]],
Cell[CellGroupData[{
Cell[14057, 512, 305, 8, 70, "RelatedLinksSection"],
Cell[14365, 522, 393, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[14773, 538, 27, 0, 70, "History"],
Cell[14803, 540, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

