(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19182,        698]
NotebookOptionsPosition[     14965,        556]
NotebookOutlinePosition[     16387,        595]
CellTagsIndexPosition[     16302,        590]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Equations in One Variable" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EquationsInOneVariable"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Equations in One Variable\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FindRoot" :> 
          Documentation`HelpLookup["paclet:ref/FindRoot"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FindRoot\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InverseFunctions", "ObjectName",
 CellID->7924],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["InverseFunctions",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/InverseFunctions"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Solve",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
     " and related functions which specifies whether inverse functions should \
be used. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21728]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Settings for ",
 Cell[BoxData[
  ButtonBox["InverseFunctions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseFunctions"]], "InlineFormula"],
 " are: "
}], "Notes",
 CellID->5389],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "always use inverse functions ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "use inverse functions, printing a warning message (default) ", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "never use inverse functions ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->29028],

Cell["\<\
Inverse functions provide a way to get some, but not in general all, \
solutions to equations that involve functions which are more complicated than \
polynomials. \
\>", "Notes",
 CellID->19685],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Solve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Solve"], "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      ButtonBox["Sin",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Sin"], "[", "x", "]"}], "==", "a"}], ",", "x", 
    ",", 
    RowBox[{"InverseFunctions", "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"]}]}], "]"}]], "InlineFormula"],
 "\[LongRightArrow]",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"ArcSin", "[", "a", "]"}]}], "}"}], "}"}]], "InlineOutput"],
 " gives a single solution in terms of ",
 Cell[BoxData[
  ButtonBox["ArcSin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSin"]], "InlineFormula"],
 ". In fact, there is an infinite number of solutions to the equation, \
differing by arbitrary multiples of ",
 Cell[BoxData[
  RowBox[{"2", "\[Pi]"}]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " gives only one of these solutions. "
}], "Notes",
 CellID->14936],

Cell[TextData[{
 "When there are several simultaneous equations to be solved in terms of \
inverse functions, ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " may fail to find any solutions, even when one exists. "
}], "Notes",
 CellID->31423],

Cell[TextData[{
 "When inverse functions are allowed, ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " solves for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " first, then applies ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InverseFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseFunction"], "[", 
   StyleBox["f", "TI"], "]"}]], "InlineFormula"],
 " to the result, equates it to ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ", and continues trying to solve for the remainder of the variables. "
}], "Notes",
 CellID->4665]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->45960545],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->101251942],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " uses inverse functions but prints warning messages:"
}], "ExampleText",
 CellID->498336114],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->615068353],

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseFunction", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used. Values may be lost for \
multivalued inverses. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InverseFunction/ifun\\\", ButtonNote -> \\\
\"InverseFunction::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->15034360],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{
     TagBox[
      SuperscriptBox["f", 
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}]],
      {InverseFunction, 1, 1},
      Editable->False], "[", "0", "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{104, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->261709500]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->474401374],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->364979597],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", "0"}], "}"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->87313441]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->101098913],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InverseFunctions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseFunctions"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " does not print inverse function warning messages:"
}], "ExampleText",
 CellID->41155148],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], "\[Equal]", "0"}], ",", "x", ",", 
   RowBox[{"InverseFunctions", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->150621549],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{
     TagBox[
      SuperscriptBox["f", 
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}]],
      {InverseFunction, 1, 1},
      Editable->False], "[", "0", "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{104, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->433256334]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "\[Equal]", "0"}], ",", "x", ",", 
   RowBox[{"InverseFunctions", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->386395636],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", "0"}], "}"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->221950441]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->135518962],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InverseFunctions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseFunctions"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " does not use inverse functions:"
}], "ExampleText",
 CellID->208160627],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], "\[Equal]", "0"}], ",", "x", ",", 
   RowBox[{"InverseFunctions", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->143230375],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], "\[Equal]", "0"}], ",", "x", ",", 
   RowBox[{"InverseFunctions", "\[Rule]", "False"}]}], "]"}]], "Output",
 ImageSize->{298, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->275572394]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "\[Equal]", "0"}], ",", "x", ",", 
   RowBox[{"InverseFunctions", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->202852608],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "\[Equal]", "0"}], ",", "x", ",", 
   RowBox[{"InverseFunctions", "\[Rule]", "False"}]}], "]"}]], "Output",
 ImageSize->{312, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->318220895]
}, Open  ]],

Cell["\<\
Solving algebraic equations does not require using inverse functions:\
\>", "ExampleText",
 CellID->203165551],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", "1"}], "\[Equal]", "0"}], ",", "x", ",", 
   RowBox[{"InverseFunctions", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->413086211],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "\[ImaginaryI]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "\[ImaginaryI]"}], "}"}]}], "}"}]], "Output",
 ImageSize->{127, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->93368428]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29424],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->30351]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10476],

Cell[TextData[ButtonBox["Equations in One Variable",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EquationsInOneVariable"]], "Tutorials",
 CellID->22500]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InverseFunctions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 49, 52.6977580}", "context" -> "System`", 
    "keywords" -> {
     "inverse functions option", "invert", "unapply", "use inverse functions",
       "solving equations using inverse functions"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "InverseFunctions is an option for Solve and related functions which \
specifies whether inverse functions should be used. ", 
    "synonyms" -> {"inverse functions"}, "title" -> "InverseFunctions", 
    "type" -> "Symbol", "uri" -> "ref/InverseFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6625, 228, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->45960545]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16160, 583}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1185, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1808, 59, 53, 1, 70, "ObjectName",
 CellID->7924],
Cell[1864, 62, 637, 19, 70, "Usage",
 CellID->21728]
}, Open  ]],
Cell[CellGroupData[{
Cell[2538, 86, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3016, 103, 206, 8, 70, "Notes",
 CellID->5389],
Cell[3225, 113, 981, 26, 70, "2ColumnTableMod",
 CellID->29028],
Cell[4209, 141, 205, 5, 70, "Notes",
 CellID->19685],
Cell[4417, 148, 1152, 39, 70, "Notes",
 CellID->14936],
Cell[5572, 189, 313, 9, 70, "Notes",
 CellID->31423],
Cell[5888, 200, 700, 23, 70, "Notes",
 CellID->4665]
}, Closed]],
Cell[CellGroupData[{
Cell[6625, 228, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->45960545],
Cell[CellGroupData[{
Cell[7009, 242, 148, 5, 70, "ExampleSection",
 CellID->101251942],
Cell[7160, 249, 240, 8, 70, "ExampleText",
 CellID->498336114],
Cell[CellGroupData[{
Cell[7425, 261, 188, 7, 70, "Input",
 CellID->615068353],
Cell[7616, 270, 427, 8, 19, "Message",
 CellID->15034360],
Cell[8046, 280, 412, 15, 39, "Output",
 CellID->261709500]
}, Open  ]],
Cell[CellGroupData[{
Cell[8495, 300, 190, 7, 70, "Input",
 CellID->474401374],
Cell[8688, 309, 453, 8, 70, "Message",
 CellID->364979597],
Cell[9144, 319, 232, 8, 36, "Output",
 CellID->87313441]
}, Open  ]],
Cell[9391, 330, 125, 3, 70, "ExampleDelimiter",
 CellID->101098913],
Cell[9519, 335, 475, 17, 70, "ExampleText",
 CellID->41155148],
Cell[CellGroupData[{
Cell[10019, 356, 243, 7, 70, "Input",
 CellID->150621549],
Cell[10265, 365, 412, 15, 39, "Output",
 CellID->433256334]
}, Open  ]],
Cell[CellGroupData[{
Cell[10714, 385, 245, 7, 70, "Input",
 CellID->386395636],
Cell[10962, 394, 233, 8, 36, "Output",
 CellID->221950441]
}, Open  ]],
Cell[11210, 405, 125, 3, 70, "ExampleDelimiter",
 CellID->135518962],
Cell[11338, 410, 460, 17, 70, "ExampleText",
 CellID->208160627],
Cell[CellGroupData[{
Cell[11823, 431, 244, 7, 70, "Input",
 CellID->143230375],
Cell[12070, 440, 333, 10, 36, "Output",
 CellID->275572394]
}, Open  ]],
Cell[CellGroupData[{
Cell[12440, 455, 246, 7, 70, "Input",
 CellID->202852608],
Cell[12689, 464, 335, 10, 36, "Output",
 CellID->318220895]
}, Open  ]],
Cell[13039, 477, 120, 3, 70, "ExampleText",
 CellID->203165551],
Cell[CellGroupData[{
Cell[13184, 484, 265, 8, 70, "Input",
 CellID->413086211],
Cell[13452, 494, 358, 12, 36, "Output",
 CellID->93368428]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13871, 513, 311, 9, 70, "SeeAlsoSection",
 CellID->29424],
Cell[14185, 524, 196, 6, 70, "SeeAlso",
 CellID->30351]
}, Open  ]],
Cell[CellGroupData[{
Cell[14418, 535, 314, 9, 70, "TutorialsSection",
 CellID->10476],
Cell[14735, 546, 158, 3, 70, "Tutorials",
 CellID->22500]
}, Open  ]],
Cell[14908, 552, 27, 0, 70, "History"],
Cell[14938, 554, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

