(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    143854,       3090]
NotebookOptionsPosition[    136745,       2840]
NotebookOutlinePosition[    138217,       2880]
CellTagsIndexPosition[    138130,       2875]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Continuous Distributions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ContinuousDistributions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Continuous Distributions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NormalDistribution" :> 
          Documentation`HelpLookup["paclet:ref/NormalDistribution"], 
          "GammaDistribution" :> 
          Documentation`HelpLookup["paclet:ref/GammaDistribution"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NormalDistribution\"\>", 
       2->"\<\"GammaDistribution\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Continuous Statistical Distributions" :> 
          Documentation`HelpLookup[
           "paclet:guide/ContinuousStatisticalDistributions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Continuous Statistical Distributions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["InverseGaussianDistribution", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       RowBox[{"InverseGaussianDistribution", "[", 
        RowBox[{
         StyleBox["\[Mu]", "TR"], ",", 
         StyleBox["\[Lambda]", "TR"]}], "]"}], " "}]], "InlineFormula"],
     " \[LineSeparator]represents an inverse Gaussian distribution with mean \
",
     Cell[BoxData[
      StyleBox["\[Mu]", "TR"]], "InlineFormula"],
     " and scale parameter ",
     Cell[BoxData[
      StyleBox["\[Lambda]", "TR"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11754]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The probability density for value ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " in a normal distribution is proportional to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     StyleBox["x", "TI"], 
     RowBox[{
      RowBox[{"-", "3"}], "/", "2"}]], 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{
         StyleBox["\[Lambda]", "TR"], "(", 
         RowBox[{
          StyleBox["x", "TI"], "-", 
          StyleBox["\[Mu]", "TR"]}], ")"}], "2"]}], "/", 
      RowBox[{"(", 
       RowBox[{"2", 
        StyleBox["x", "TI"], " ", 
        SuperscriptBox[
         StyleBox["\[Mu]", "TR"], "2"]}], ")"}]}]]}], TraditionalForm]], 
  "InlineMath"],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", ">", "0"}], TraditionalForm]], "InlineMath"],
 ", and zero for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "<", "0"}], TraditionalForm]], "InlineMath"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->26811,
  ButtonNote->"26811"]
}], "Notes",
 CellID->429991538],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseGaussianDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseGaussianDistribution"]], "InlineFormula"],
 " allows ",
 Cell[BoxData[
  StyleBox["\[Mu]", "TR"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["\[Lambda]", "TR"]], "InlineFormula"],
 " to be any positive real numbers."
}], "Notes",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0.7, 0},
 ScriptMinSize->9,
 CellID->26584],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseGaussianDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseGaussianDistribution"]], "InlineFormula"],
 " can be used with such functions as ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["CDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CDF"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->20877,
  ButtonNote->"20877"]
}], "Notes",
 CellID->33143606]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->216125287],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->125690957],

Cell["The mean and variance of an inverse Gaussian distribution:", \
"ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 CellFrameLabels->{{None, None}, {None, None}},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->20877],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"InverseGaussianDistribution", "[", 
   RowBox[{"\[Mu]", ",", "\[Lambda]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1014],

Cell[BoxData["\[Mu]"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->197625925]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", 
  RowBox[{"InverseGaussianDistribution", "[", 
   RowBox[{"\[Mu]", ",", "\[Lambda]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->484],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[Mu]", "3"], "\[Lambda]"]], "Output",
 ImageSize->{21, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->11019386]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11495],

Cell["Probability density function:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 CellFrameLabels->{{None, None}, {None, None}},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->26811],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"InverseGaussianDistribution", "[", 
    RowBox[{"\[Mu]", ",", "\[Lambda]"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1293],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{"\[Lambda]", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "-", "\[Mu]"}], ")"}], "2"]}], 
      RowBox[{"2", " ", "x", " ", 
       SuperscriptBox["\[Mu]", "2"]}]]}]], " ", 
   SqrtBox[
    FractionBox["\[Lambda]", 
     SuperscriptBox["x", "3"]]]}], 
  SqrtBox[
   RowBox[{"2", " ", "\[Pi]"}]]]], "Output",
 ImageSize->{99, 65},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->161936131]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"InverseGaussianDistribution", "[", 
      RowBox[{"2", ",", "1"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6798],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->299967656]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14890],

Cell["\<\
Generate a set of random numbers distributed according to an inverse Gaussian \
distribution:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->8493],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{
   RowBox[{"InverseGaussianDistribution", "[", 
    RowBox[{"2", ",", "1"}], "]"}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29074],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.4209669156364555`", ",", "0.5330448060872874`", ",", 
   "0.06814648089342867`", ",", "1.4648948877507084`", ",", 
   "1.00517884345395`"}], "}"}]], "Output",
 ImageSize->{336, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->102964007]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13774],

Cell["Properties based on higher order moments:", "ExampleText",
 CellID->20699375],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Skewness", "[", 
  RowBox[{"InverseGaussianDistribution", "[", 
   RowBox[{"\[Mu]", ",", "\[Lambda]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9314],

Cell[BoxData[
 RowBox[{"3", " ", 
  SqrtBox[
   FractionBox["\[Mu]", "\[Lambda]"]]}]], "Output",
 ImageSize->{45, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->525285790]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Kurtosis", "[", 
  RowBox[{"InverseGaussianDistribution", "[", 
   RowBox[{"\[Mu]", ",", "\[Lambda]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29218],

Cell[BoxData[
 RowBox[{"3", "+", 
  FractionBox[
   RowBox[{"15", " ", "\[Mu]"}], "\[Lambda]"]}]], "Output",
 ImageSize->{52, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->49343320]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12351],

Cell["The fourth moment of an inverse Gaussian distribution:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->6923],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpectedValue", "[", 
  RowBox[{
   RowBox[{"x", "^", "4"}], ",", 
   RowBox[{"InverseGaussianDistribution", "[", 
    RowBox[{"\[Mu]", ",", "\[Lambda]"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7118],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[Mu]", "4"], " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["\[Lambda]", "3"], "+", 
     RowBox[{"6", " ", 
      SuperscriptBox["\[Lambda]", "2"], " ", "\[Mu]"}], "+", 
     RowBox[{"15", " ", "\[Lambda]", " ", 
      SuperscriptBox["\[Mu]", "2"]}], "+", 
     RowBox[{"15", " ", 
      SuperscriptBox["\[Mu]", "3"]}]}], ")"}]}], 
  SuperscriptBox["\[Lambda]", "3"]]], "Output",
 ImageSize->{190, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->385225584]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18040],

Cell["\<\
Plot the cumulative distribution function of the random variable:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->19271],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"InverseGaussianDistribution", "[", 
      RowBox[{"2", ",", "1"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "10"}], ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12368],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->239500984]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15258],

Cell[TextData[{
 "A contour plot as both ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["\[Lambda]", "TR"]], "InlineFormula"],
 " are varied:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->4157],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"InverseGaussianDistribution", "[", 
      RowBox[{"2", ",", "\[Lambda]"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "10"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Lambda]", ",", 
     RowBox[{"1", "/", "10"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9647],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx0XQVUVM/3Z2npXUJRscXEFhTjjl2oGF+xxe5uQUWxuxU7sRVFRSwkxUBB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   "], {{{}, 
     {RGBColor[0.3368494610805928, 0.13292345896139263`, 0.5904629838252804], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmXe0VcUVxs99j3vPeZd7wUQhYi9IkWahGECkGEMURFFjAqiIFBWJUUGx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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3mwj2UUx9+7/d7nt7yXFqppEVEhtJBKaUiLrZkaS4slxlKEhEoK2ZWI
FjtpszRTqYhrK2tE2ZeWGVFJasrEpZL6fH3vH9+53/Oc5zy/857nPOecW7lz
n3t750dRtAMUglW5KFqWiaIT8IeLouizJIqOpaPoqYIoGpSKopXIK8B1eawh
12bvj2As+uHIY+CXF0fRu3EUHeeM7tkouhh5DvIWbEqwXc9517B3AMig+xib
yujGsGcu+nmgE7oarNWFd2X/d/jyTZF9+YX94wvs02b8LUS+l/0D0fdD3wib
w/BfwH74KNYmcPYy9rRBnoB8Gt2/YDf2u8ChfH/DYvgnoI6+h7Ua+DeJ/V9i
/ykYCG/GGUex/bPIv9WftSNF/s06+LKRtTYpn1kZfimYSiw2od/K2dvAYPi3
fN+j2N6Ifj/y90XmvVg7UOS1NchrQRf4SM6rCa+hGHHedtY2cdZOfvNJ/H0C
+UF0r2FfyO8XgJrF/gb5/hnorvtNHPsdnJdDtz/jWI9FfyG2TZGTAvu4ir2f
Jr7rdexZgv3qxLmwD/vz2b8l59grJ+pj2xDkYf8qOASvAraztxvyEGzXYXM1
9nXAbchfIzdJOYbbOeswOfMdZw1Bbod+MvpUyt9Uiq432KX8I2F7oJ+LvgK6
c0ED5D3IjVOOYX3krci3pJxDbRPHRLFQDrRAbg4ORL7T+YHfCr7bfeypie8H
0a/Gfj7ydHTPgcXwr8Ar8CpgKfxzMANeDfTgvGXIE+GVwRL4OlAe3gl8CB8C
iuEdwQfwZ8FZ8M7gI/hQUA7+EFgIHwx+49u7Zf2W+vL9I9BdAQbye8vRr5Dv
/C1Ffpy/TyHXDfatOjYXwIeBT5BHgynwy0AJ/AvwBLw/eAE+DgyAXxvse1Xs
E3gH8D7yM+Ci4D3SyeZS+FBwMHKMlsJbgMPwPeA6+MtgA3w96Aq/HRyAB864
Bj5BMYWviR27ScF7FcOF8JbgCLyEO5kDrwVq83srY9/Fq2Bj7DsZB+8b/K2r
wdnwl8Ba+DD9JrwIfMVZp4ocmyz4J+UY/QV6I18Qe02244N90xl3wt8F5fn9
H5Anw18MvvsHWbsk2Af99iIwE34j2Fp2RwPhT8oGebz2wD8GP8eO2bnBd6K7
GA4ehz8MmhOfW7DvCS9QjCOvPQY/xb5KyBVVX5ALg31pidwP/kgwl80L8O6g
aZ5j2AOeH3y21sqRa+XBad5vT/AaugrBvmxSDsFP87c2e1fEvttzgmOrO34a
ngmuve8hT4OfB0aoH4D/eF8R55/i7K757gWLMubqCYrFXeDH2DF5D36H8iv2
2ih4dcUM/jdHXSnfwTbdD/Lz8L9173nOqebBOaTcOcR6U3izYP6TckpvFfwO
/wNUDL4j3Y18Pj/4m/QtI8HdwTmu3JbNxcFvTm9Nd1padqbOOlKWS3Fwrimn
5sKbBNca1Z9e8C7Bd6ec+hLeLrhWqCZshj8QXCtUE7boboNrg2rKF/D7g9+m
asrr8JrBd7Mj9l11C+73urPl8PbBtUYx1NutFJyresOqhSfKvlU18Q3kW8HO
spiqNmaL3TtUIx/Juceot5RSn5bm3DPUKzpj/3nimUGzwjBQkdrcAv1e9pbS
H5bnPENodujK/jvhU7G5h7178txLjmbcW9RTZFsLlBT6jJnsna6egK4VNhtz
7pHqjQPACvjKnGeb7qBE/TDn31KPrYft9YlnjXn40ADdCXwcne83cCTjnqBe
oBlEvahP1r6rJ41gb6vEsdqQZ19mg9Yp+9Qe3iFxb26Cfl7aPUy9q2LKs5F6
pHqjZqSO8ClpzwrqgSfhN+fcS+VTKPaMo/c1Cp9qZRxjxVYz2AL4/MSzg2Yq
9cKbEs8a6olnemXiWUk9c6J8T3v20UyhXjws7d6vnjwR/gdrOcUf+RL2V0o8
2zxPvAoyjrlirTsrTTvminUL5IOqXznnRlXWsuyflFinmWlW4pgoFopZPvoD
mkFSniGvhFdPPPtoptLd/5p1L1QO3Bb8pvSW9sauFSdj12bVjEHIrcCYyD1z
FfwY6ycj9zT1gnnBtuoJz8Bbg8mRbdSrFgTXGvWswfC2ei/I70R+G2+CXbHf
SCP4W6qZeV5Lw/sE35XubKx8Ce5dqtlD4PcF1y6dKds6YFXsM9Q73ga7Y/eQ
xvB3wA15XqsXXKNVm9UDn4W3CfZN39AwuCaoFmyPbVs/uPfrjKGaNTO+S81o
PZFHZ5yrmrF2s3dG4relmn0V+Xc061zQjJwgD0879zVzFyOXK/asrRlrEGeV
S7sWaMb+KzgnlAuaGTV7XpT27KcZdFriGqC3rxm/GrrjWc9+ykHNLlPB5tgz
zA3BPUa9RWv/xp7ZNKsphuoNs4O/XT1CuZUu9v8eyrFl6G4Onp2UEw3gs4Jn
qzMzHb4sz7gX6n+k/wGJ2Nyj
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.4237163832417785, 0.2839615768841779, 0.7125649514758411], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHuwV1UVx8+9v8fld87vXHBGjbBQnFB5aI8BkZcMxWSpA3eEyOJNF0kD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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlnmQz3UYx7+//e31/X5/313/JBHZJrHoMm6GjplqbFMG6SAbYTNWmgmN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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5105833054029641, 0.43499969480696304`, 0.8346669191264019], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1l22QlmUVx+/d597nee6XZ6OcdMCZRMOEFKf30bG05E0LWRZRcS1AKEhA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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmlsVlUQhu+3dLn3fl8Dogg1EWSR3UiQBOJCRAUkhNKiAo1CKQp1ofhD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         "],
         VertexColors->None], 
        PolygonBox[{{2626, 2441, 821, 2691, 2625}, {2440, 2626, 2625, 2688, 
         819}},
         VertexColors->None]}]}, 
     {RGBColor[0.5885462264797228, 0.5672922085563679, 0.9100624033521684], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNV2lsVkUUff2+97V9b16JtCwajAELZVUDGoQoGlkMBloEkRYDKMUIrdLW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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlllsV1UQxu//f++F3qUurWIIRkFABFEjMahxDYUEAwXaIG21qIABRG1d
Ihjc0CgqhrqFPmiLWJDEFNEQEGpSBYkBIQq40AVZNIISHowPJggK/j6/Pkwy
35k5M+ee+WbOHTK7sbqhGATBm0iENCVB8EcWBCVhEOwpBMEr4OfSIHgEp13g
5ehNyJXYz+I/HL0xD4IbwAfwWQFuRsrAQ7AfYf/y0iCYDX4Aey22OmQ++lTs
DYqdOvY5yDfk/hbZi38H9m5i9yAb8f8F+xLiHcO+H307Mhe8AzwB+xrwMfCX
xLsu9Jn/Br9N/sXgV8FnwROJNxbcAh7A3ouQq9FfLvhsnyFzQp9xBf4nsa8u
Oud4bClrxznbZtbOQ5/A2rvoZ1h7Ft9y8HEuM0bWg6vwaSo4xzrwIPKvxHYj
0gIeDd6Cvq5fEIzDt4y1DeQfydpa9ImJzzac/VPAk5Fu7D1IA3sfyn33p/H/
EN8pwuhn2LMN3/tYay34jsaBb++7333ITvR5ie+uEnvO2VdxX7WcpQ55Gttu
1Sh0zZX7CdZmRj7DpehPZibP8zHxyL0j992+iP0DYp3L/k3gmcTrh16pmkY+
453o05ENRde4g1h1xFzBeW4Bn2T/TOxl6CP6UytsXcR4itiLYn9LA2s1kb9p
G77nJ+bmgti+D+e+G+3ZC96TmpvKqdruzh1LNa7HtpH9b+A/SBzCNpK1M+B/
kcX4V7N2WPXCfza2WcpBvNHiQAm1R64h3nb2T8PWgkxCvwC5ltgrdQehe6QK
vQ2Zhn4h8h3x9yE7A3/Par6/DVlYdE3m4nuC+GOIPzQ0F98vda3EyfnY56Xu
ncnsuRx9a+67eAafA8TuRboC129pag6Lu+rhLdiGZr7/8ZFrt4b49f1cw03Y
LiFeG7YK5EdwM/j62JxoBo8lXiP7C/gvxXYPcoVqF1tXTVVLrR0sdQ+I++1I
DflmpJ4Nqvlb+P+T+lv0zQ/iuyDzbFKPV6hXiZGzNw591rvUT0WfeQm+wzhP
Hf6drP2Qu4aq3QuxuRgTozcyJ7eqHzP3yyTwo9gPYR9UMAd+Um/l7v1l5Psd
30py/hW7B8qxdSTu1VGRaz0mce1V8xB7e+K70Zq4tjJzr4tzA7F3JubS4NCx
f8s865Tjf66k3ivOqBYfY78pck00W+ak3qsZMwz8feLeVo/cCj6VeBZqBtaD
14OTomfWKva+l3p2iLPiwjCkMzQnhuo9yDzbdKeD0T/NzAXZ94tbffNJHNbb
UQs+0jePj7P/db6pMTSnlXstPgNCn2Egvh9lno2amReLb0hHaNwfPUHaQ3Ps
MfTHM8+aVvZ3E7sHORHZR7W8KnMvqqYn6Z3yvvmqni0j992qWdGc2Qn+Gnmt
6Jo3EevnxG+XZvQibAtTv1Wa+ep19aR6UT1/FPxFZu6Mjt0bFZlnrXrkHfDU
zLP75tizviIxV3SmLapdYm7qzfwk853o21VjcbWGGEcjc7ZK9Ub+jDyT9mMf
hZyN/OZdpvcyNVeXEbM1c8+p15TvsPiduzdqwLXoM3LPauXoYO9tiWeh3kTF
1kzULFSOO9CD1Hevf4bp6IfwnxW6pveTqyv3260ePV3iO9LdiFOn0H9FRsSu
sfTNmWeP1nrBL+WeHaqpanUw97eoZvr29tRn1x3ordJM0CzQm7Ur9Rult0mc
O43+ValnoWqss1annr06873gzzO/PeLLf9cWMbU=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6524135145693961, 0.6699091692545404, 0.911518380806677], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNV2lsVUUUvu/de9/rXZ4JSwQJoZTFDSUWFAxCRdCyGFmKYCnSukUJmCoU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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlnmIVmUUxu/Mdz+de9/7CY2WFpNLuBQRNQoqlZO5TGqkzthirm2QaVjj
SH+EWgmOkDMTZDMOBqMGLbhiC6lIqZWjoI1m6qhtFmWkJQm5RvV7evzjwHne
c97zvvcsz3v7PPFc9dziKIqakBh5KYuiRUjEYtdcFLWkUbQCKY+8tqLAehJF
CbaJnaKoAVsHsgA8HGlCb0fmo1ci/Yj1NLgv+kYOeCBE0VFkBvqHRVH0B/pS
4u1Fn8daAf8uyK3oMzmyg/OOIq2ctQrpj+0ge6Zg34SsRu/GWjP6KewFzlrI
Wgz+ATlI7L9Ze4vz14EzfDeljt0IHgA+jv9j6JuRHHgge57lPnXyRz/D+ReI
fRK8nr0PIz2INxmpw38JMpx4v2GvQb8F+0lytRh7D53FWgX6DtZeRr/M2mpw
aT6KRhC/lfPLZOPMsdgrU+fjMPG6oB9jrQ7fqdzhEv7DwPuUS3Bv9DbWhrB/
GGsjwSOQUu7TDq5l/zzkZ3ANPpMyf5O+5Udkcupv0rdcj5RjGw8+X+Qc/At+
nvtdwPZ17Nw+SIyfYue4Ar0en3347o/dG5WsHYrdI3Pwf4V43bGfA9+O7VTi
u6xEdoJ3IN+gz+Eby/Cvwn4n+7fg/xS5fxLZzv4l2D8j1ufIuWJ/k+7anLrX
dOf56I2pe/HXIp+9C5md8x22om9L/a0vgms4L0qd64usXUGfnrmWa8Dfg2vx
uYTeC//m4Bqqdr3wOV5CfQruTfXAfZm/Ud+mHPRn/xfYF+b8jaPYPxo5BN5A
vMvs7xn8rfXsvwLuC94OfjNy7tuIV5t3Df7Bfhtru9DXYj+GPjF4lmZy3jh8
WwqezVbOS7EFZAP+L+AzQTbkfN49Mg3bdOQX7J8UOVYVciLnmIe5//KCe60M
PADbzUgFsZvBJehDqVcfzl7LnmvB48CDNN/gR9i/Gbws9sx8hf3e4G/XDGv2
F6WeDfX8VPQPWHsN2w3434FvOVKJvRX7gdQzrtkWx3TDNgb/8qvnDQYPQcbj
/zb+ndEHJ66V7ldKfraCm8BvICXgTkiK/6uxZ3Nd4tnXjJ4I5izlQhyxEb0e
/3559+g74GXgm/K+Q0B/PzG3NCDvYd8JXhU7JzeCJyWeVdV8VmqOEjeJI2dh
b0jMhX+CnwHPDp4d4RmaRfYsFt/lzAWXE8+eOOFAcI8pv4+CrwvOkXLzEdKY
OKZi1WJ/KDPHiFs003uxzUqcO+V8F/jxxLlXzdvw3Y2cKvIM7g/meHH7ZORI
MEeLm8Xxejti8NLYb8hZ+rcjuFeHkrMt6B8H9756fgf6p8G9rx4fm7indP+B
sXOtGqp2yvm84BnW7GpGVfvl2Afl3QNd0Ucm5lbVfHfmHOv7a/BpQb8r8Wz8
3wOZ3xS9JX2wVyeumWp1d+zadw/OpXpgSOIZUG/1js2FYzJzpTgxJOZcca1m
7Hdm6XTBtdObotnpnLn3NEPb9LYlni1x+hny1R5cS33TmuA76m56IzVb4ixx
lWasmthVBc+yZnw99hXBd1MNviXelNSz1TPvWVPPqlc1c3syc564Tpyjt+hs
cK9oPosT11C1E4d14H80MzfrjRqFPjrz26Me+avEZ+oscdA04t2TmHv15unf
4ZrE3K9/iCv6F2Btbs6cqV6/iLTm3PMx9nPEG5Y3R73OWadLzIV64xckfgPE
/XozNHubg2unGRT3fBncq5oR/VskV+unf4w97P0u9dutOxxJzYHiPr3p24j3
bnAv6p+jg7MnpP5X0h3v5z5FqblXb/5/e4g9bw==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7162808026590696, 0.772526129952713, 0.9129743582611858], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1mG1sleUZx5+ec3pOn/M8R9wmG8rbBmYWAtG1zDcmDqbUaSYIggGlrK0l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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlW1o1mUUxu/teZ65/8ujGfZemM60pHTJLJxF9KIzI2ebEU7LnE4qtUni
/BAtKCJDTS1pizKLrbflCwl92UxhztSEOQ1yWph+sNZmK0Snfet3cfXhwLn+
5+U+/3Puc91jauurXi4MIWxEssjraQiVcQhj0UfmQngbXIS8g/Em8OIkhOFR
CAOZEPqRQ/iWIe+hr0Rm41sAPon/z8gacCN4CrYc8RGxr4Angs8h/6I3pj5r
O/gM+UvB+4hdgmzNh/AIuAd9TlEILfiv4NsN6FOocQx4KfaL2C8hneS/Ffwp
+kR8CsEzyHmC3Efkj+0Y39qwf41MwHYHsg/7fuQUem9i39Pg+/FtAmdo0qoC
auDsucgV6u0CZ7E/ldi3N7g3x6lpTcY9SsDPYj8vjL0q7xyKvUqOcuz14Jup
tYR62sGjqPFu9PGc+TD6DOQ4eBN4gFzr8TlK/AeF7tVB9STjnrVF7ql6+Rb4
TexvID/iO4jciO0i0oT9L+wXikN4H/sRcDv1/UN8GXgDvq8iKfoevt2CXoPP
79TaTw0dnN9DzX3k+hM5iz3mWxP25rxnPwL8LvGjkRbwXfzvGc7bif98co0G
v6b+5d2LpZoJuYvBU9HLkHPgk8TUoS9Disk1LPUsdCe7I89Us5xOPdX4z0MW
Uc93+FRgm5m6lr349OE/CdyB/j1yFHwA/znoXyKD6Bv51l3gO/sceIB6hsi9
Dbyc2L8j9+Yq/r9ib4h81jN8O4zewbcKbJ8jefwbiB9N/BbwAv69Bpkb3NPH
sG8jJl/kGc9DH4n//pzv8DRwHz7N4HXgEmJfAl9BbyBmArhkODuU8QyGit1j
9XY335oT77B2dxwx94GnIocznnkDtrWpe9vPPyxMPBPNQndWZ42L/a8680Ds
HdbuLkc+w3878k3OdzZFzyc+ey35JqMvwb8SWxffxoMXgmdlvXPXkf/61LOu
pyfL0OuQ54N3uhP/zeB7yP8keG/imWlWynFC3IJsznjnpmEvRyrpxRec35X4
juhuqIYj4C3kKyVfNbgyb44Rt2in2xJziLhDd/AyvUz4tiPjmal3L0SOVQ/n
g39LzFXaiR3YsuSvyJgzfqG207F3Y6t2BN/pkWehnOLOrti9FIeeQh/Evjrj
mU7Cf3Hkf1f/xFU14Jn/9+8j9EWpd/k8Z3wM3kCOB7Wr4FX82zrsSaE5Rrt4
CJ/WrHeyOTZniCtU83rwKPDKnHO0xuZcca045CznD6nfOe/kE6lr0Nni/NWx
d0y7JY5vT8wB2n3VXKddQm4bZo4Zi+3FyLMSJ/fgfywxF4mzy8k3PTZ3NRZ6
F8SZ4krtRHfsndAuqGc/EVuPfVeB74BqrU38Vqlm3aU7E3O97lQv870ae7f1
5tVGvrPqtTihNPEMhA+KM6n9Qt5cLk6owDYr8e7rzEvYLufNjeJo7f7u2Nwp
DtgV+83SWyUO/JDYByLvima0JzGHiDseypqr/ojMXeKsKvRv8ZmM7yZiFkTe
Kd0Fcc5X6LP5tq7APoOxe6jeaUfU+08i77pmsBM9l5pb9KaOQL9G+5b1Doqb
foj9touj9HboTddbrjfkdvTqyLXoTj2a+s3SW6U3W7t2b+LeaecOpH7D9Hbp
jj2uXU781qnmTu1/4l1Zgb0VvSUxN6gmcePTkXsjjhT3DE/NreIgvYXXRo7V
m/gfx3kqqw==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7783625363960179, 0.8522440482064405, 0.9069832857921271], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmF+MXVUVxs89955759xz7tA647/QAerUqYnEDkwjtKAdiIQiklAsfwwQ
2tIaQelMS1IMLzXFBxvqWFuxU9EWaLUKtIBIo9aHZqrRFqe2FTDQKQUhZPpn
BgmIDw3q9+u3jA8nZ9+911577bW+9a117vQlAzcsT5MkWVVJkqreo/qxUINS
77fzJPl6mST7akmyQc8F9SQ5X/N/aCZJr+YL7flGK0m26fcC7Tkl+T9rvELj
7zeS5Pfac0Iyn5LsmNbu1N7p0rFR84t1Vp/Gm7Q+pPFIzeec1Pig5vs1Xq+1
6dK3S89h7X1KZy2SrkmtvaAzbtV7j+R79O7S+g0av1G1LvSMSs8U2TEz9fiz
ml8rnXdJTyo9367ZxpGw88nM91yj8X7Jz4rx0brvhM6LZcsRPRPS+Zh0bNMz
LJkfa72i94Rkjkl+TM/9kllUJMkdesar1sP8N1Ov8RudLa2XenZJZkfD+1l/
X3Yu09Ou3z/VOT/T84jOaMs8h83E6lDqeBGb26r2xYdyx4kYDaX2PfZtqtkn
+GFAOu7RM6Hxq206T8+CxHagb0H4dmbE6weS3Vuxnv/IrhOyZ7Nsma35GQ3H
86Tu8ZbWlmvP36Tvdf3uSOwf9rP347Jrsfa+LZmlue/GvW6RrgHNjSeOQ9mw
/4k3stjJOZyHz39T9znIg79B/U5ld0fme83Q/JjmF0vmgMYHNF6o8ZMan06t
F50DsuGvhfH0cOgHk2CTO/0k5JHt1niZ7P2qnnclv7XidXSCGWwmDrfnxsdw
6OhuWG6fznlea/Mk84789CWNh6XnHxp/IXdunJZ/TufGyR7J/0njS1P7Hh/i
z3clf5PmH62FbZrr1PNh3X1t3XbOrFv3YOLz8R32fLrufas1/0/peU/Px7Q2
Ve+FufPuucxYASf9qfezt6tmH+PbScn35c4jcrZTMr1a+6PG52r/CnInd/6D
P2KxW3Mva29vzfZhW54Z09wL/JLrYPi47v4VPX8PPB6KHGftcODz5zrzu1o/
rt8XyG/PNC33kmz7t55M40boJ1/WZf59u8YrZddFkj8lmbtk5ydK4wMOuaZu
mc7MPsWfKyu+V5/Gu/W+pGZOwTZy5krNr5GOB0rvaYuzuNc9Decq/HqnzppV
GDtTJHtOabx/hH2l/d6lfdMy69ySmwvaw6/Twrd79b6iZq6Eg7cHD5Nj+Bs8
fDJ0oYd958b4NunsKYxx8oZ7ElfsWpLbtk69H5TOKRXnJxgHw9Nk40juWKPj
1tx6wFd38AC5tqNifv6cZB7SnutT8/ZTFecj/gOL4JDcm51ZnliultyGyOXO
8D/51xFj8mRW8NKVmf2Lbye1b2PqvcfjTR79tuJ5+JB9vZEXjcAFsX5fd32t
MFetCTlkjovH0naNG84z/Itvb0ZW91qUOgbEAt6Ab+ZkvuO1khmWzC3kkPQf
1PNS6joAz2Mj+dYfex+NeOKTFVEzsH+Z9IyUvh85AvccjlqNXWCeOveZqFng
8pLQc53i80Th38OB2cHAMz4DD6/IrqNN+/1myT9b+D4T8EHL+bAzs99m1f7P
s/DANsluL3z22jibc09pbp9sHtTvq+D5wvvPpM45YkPNxx9n63XTPQT3htep
B3D7DM3fXVruW1XvJ5bkSU/d9z6T+RzqxyrpGCscB/DOPbkjPcurhTGAn8mf
/jj//rDhWNU8BUdx/pmoSXBNGfwDZ0wEb9yYmzfXhy/L8OdI8AjYovdZ33RO
wp/n1cwh8Ca/8WFN+LqwZa6dWroegPGu0lyPvXDXUOZeYklhvILVazT+YuG8
gu+4b1/w6jl189AxyY417b+6zjog+fmp19tD5pBwfm9p/z4t2ZUt33e33l1N
9wttGv+icH2YjZ25e6ixlvkXHGLfiarrVbvWFxfOm6Wl+zlwS3yp33D7Ay3X
S+oLteuD1Dk+X/uu1vNi1bkC15Mv9C/0c2BtrtbnUFOrxja8DP7Ia86He7Fl
KOondY64Lo+esSc4ZKF0fLlw/OGbjuDDSyM/yU1qOzxNfaeG/65wHcfv8Brc
dZnuN7fpO1APqYvsv1zymwvzMbwIF+6JXos5MANPHCvMFXDh86ETTgUXcC99
K3UX7HyH3GqZ17GBfXAO/sIexv1Rm8lHcuZM5N0adLTc66BrY2Yscp9N0dNQ
A+bFufDZi6GTfINj4JC5utd46XpEbYcLyZ2LNfdaaV7tFt5mNt3bntB7vOma
TYzWRZyIKfmM7svkg8sL+wluHw1Ms2d11PqD4A58aDzQsh3YQE0CF9wXjj0a
vTT154XCfk8jD8mRDcFFcOxHS/dk4IgYTkYc6X/5bgEn1EHyhlo4FPZzR/qG
q2Oe3hP8UK9qcR5nHW46HyYCS/SL+JEcoD7BS/1af7jwmfdpfGNhv27W3q+1
zBX74zsMe/ZGf09Nuo5vpZZr02BuXgAXTd3rR4WxPhn9IjLkyWj0YPRstbDz
bD8ZPSVcvz/uDh4PBCbJ3V9H/l4fOcA834jUp/OjD2w0rBeMzIkYTer9ctNx
AX990W/Pk0y/noM1c09emn/WBedx1wdz1xW4nrxGlvuD3/OCT+Fr1ulb/lXa
p/hze2me7Y/+4kjN8b87N+bA2/TS2CKWWzR+r80YXAfX0rdr3+ulv+vG45vm
oejJqVHdUd+/13Q88POzustzLeOCGsl3JnEfi/oP9u7T3lWlOZt7/LBhLseO
rdF7jUatI17c4ZHIU2ocviZ2PXEGcvidfhD8UVPfjG9Y8LsjdFJjqOvEmZif
Du4lrsQXXHbIZ53ttqm36b6ZnLkivpeIHTZngZ9ftYxXsIqPJ6OX2xj9GTin
5vAfAfURW8AV9uBLfEpdA/s3Bf7/kjs2+ANMcV+whI1gkT7hg8At9vNtejK+
T+E/eAFOAJddkTv4443wCXYwJpf/941Bzc+kY2duX9LzPl5YF1y7O/rYnU1/
P5+VT30mfAWPUj/wD99wvyz8+/OZ6ww8uaN0PZ4f+saCY/8LHjs1VQ==
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllVtsVlUQhXf/Xuj+z/lLheIlASKKVKMxhDYRFC0aFRVNBMtFwUgLJaJC
W03A4IMKPIB4qVYpiIJKtd4ABdsH8cFQXkRFbmK0rdyMoUhbo6gPiPot18Mk
s86a2XvP2TNrj6qtn7Y4E0JYhRVg1TGE33IhlA0KoSkvhD+LQ8glIWzND2Eq
/FH8g/CvFIXwGt8mED8AHkR8I/GbwB3gevg+8JpsCM9iVcSWgmvIr02c28d6
38NdWhJCG/nLOMjP5P6BXQhezIEa4Xuwp4hvhp8Ot4Y9GuDOFoawm7XmgTex
9mT4D8Cd4CvZ/xpifgQfwY6TnxAT0xCy2Bi4aez/NtxO4suJH8u3DeB28Chw
OfgO8BRsFmtvI389/mryR7D3ZfATwddjd8O3we+CGxK9Vz977oD7AryBem4k
/iD4ZWIqyZ8Nnot/EfUN4PdjneCy6H+lGp+Jrlm1zsLOcB9d2CLWuwn8FuuV
kvMSsR+Cz+HfEl3LFvAJ7QUeCW4G/4pfwbdd4N1YE2uPA9/PfrdT81ecZTZr
/sTZG7Eh8DOjz/45+e/BnU98C7gdvAG/mm89xN4AjsTfFf3vOwpd67XwX+a7
5gfhF2Ir4Ufz/1vgb4P/Vr0E3wt3OWd4l/p6OE934hhxNeS8g9+mHP73G5x5
BX4F8auJHUbMUfBx7PlC16TeLAQXZNyj6u3h4LEZ93gZvXdYMeC14CmcvTjn
2laTv4DY+dh++N/ZP0N8N/w+cAPxXez9NzkH4J6khqeJXZ76LGW6Y7id1DCe
+BbWqyO3lDVeJLeEM08i9gqdF35vgdeqS9w7WvNe/FOJZ0E9fB9+X/RdnQCP
By8EV8PvAd8Kro/urUP5vusBcGeB77xWPjFVGc/MDPyZ2FxwB/iJ6JnTrH0K
nga3JPrfd7PeP5z/X2x9of/ZKdZ/HXs0z99aE/ekevFqclL8idGzIg1pZe2R
WAPnnwreAvdIzr7u6DPi50T/K53xYdYeTfzhjGtYAl5A/GDyI3s8QHyO+F7y
T+b77o+l9tUD4qpS/1vF7GWt/mit0ZoHwPuz1qI+cDf+PubrbMaasx1cl/ru
54C3grdkrYXqiYroGdNsqaeb4F7AyuDnwX+M/1HWWqOeqUmtkdJGzby09Dv2
Gxqsqa9Sz1+ptUcaNRh/KTEXF3nGNctDS9yrmun3E/eselU9vR08PVq71XN7
wA9Fa5Nm5hC4IVrL/tcsznak2L1cTX098Euje0Gad0w49b/WGW+O1hhpSzP7
3xk985r1deBL4L6J1mL15DDwMvgxRdaMGdGaIi15E3xP4h5Tb0lDJifuYfWu
NEG9tTG11qnHpA292HP51ojyrDVDWqE3RLNVmVrbNGPtcJ/krDWLiqydqlm1
SkPP5Kyx0la9OdLq5XyrLLJmjyB2R865etO24m/LWat1x+plzbxmXT39mLSF
b79k3EPSpuuwcxlr1FXkzo/WrkkZvyWrsOGFflPU2xujtUE9vhK8AluX5zP1
sdZp7PGM9ziJ/0PW2qN/0o8/Lute1p4TEmuEtEEaLG2Xhkg7pPENeqtzfrt1
htPs/XXW2q89dHebE8+y7lBv64jUd6c3VtrVFd3r0jD1qmZGs6Ke1dt6Qere
0Burt/W81L2jN3Yzfmvqf6Ea/wMEmCKs
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8357196958415591, 0.8713711325458928, 0.8812873297601466], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl21snWUZx5+e03OePuec+ywdtg0qOtAtLqKuymY0EJjrYGu3D47Jopjo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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllW1ollUYx8/z3M/Lnvu5zyOmJVbm7EWMolw1o1LU3EhnfijUfajILEpX
WSxhzdGH0ojecAZBtkwot4Jom86yPlqUES401IhmFn2qNss2iKVlvz//Dxdc
/3O9nXO9nTnrn7h7Uz6E8AxUgM7GEI5BhzhsK4dwGj6fhTCZC6EEHoUfg3qK
ISwIlm1E54KSde6vhrAOeiNBF/kZ5H9Bu9FvBh9FdxLagK/PiTGehjC3EkKl
YJuPkA1BXyLbhM+AbKwuhE70E+Qr8P0kZ/eifwK8CN0P8T9I7F+IcS24UAth
M/rHwWP4b4Dy8NvR74GfDW3Gdwv4KWyP4B825NAZxP5i5I8ib4OGiNdKvB34
v4U79YCXgLvA9eCXpU+8XcS7C1wFZ9An+GrHZy/6zehvRX8e8g/Aq8AvgRvA
G4nVltq2PzgXC7jToYJzshX9F6Ap8A9jcwbfMzL7mkbMr5GViN8Bvwadk8o9
8luJvx58DPw6uLHonF2B/ZXQN+Bu4p2D/zc6F1/h80X0r+EOjxBrNOdeqMf/
nrJ74ndkw9y3Hf0O8HXIr4dO4G83/prhB4h3QPac3ae3c9ZILofBM+Avio79
GbgGH6Fng3N2Z8Vv1NuUo7nwV0X71p1/w/ev0E3gpeAR7nISujpxDUewn4d8
H2/dD60FjytnZdfwD2SnM/eiergb2Rg6nbzlIPoJ/J/0wxb0VyMvyh7cBW4F
n8P2LPQg9u+D3yRfKfgVbPvAefzloms/AG5E1gml8C3k4Cf4GzLHepWzCfhx
aHXwjDRgOz+6F5RTveUH7jBU8Js0Cwuje10zMVu1Qb4icY3+Uy2gXcR6DPwt
+q+Rn6bEM3cE2TbuXMPXFwXPwgHdt+SZqBCvHXxpyW/qh1+FzlTZc/apejt6
9mVzGfEvST3Ly9CZWfPMalY1E03KJ/pTyp4B9ep7xFhZdM/OwvZj5Lcnnnnl
vim6d1QD3WUQnXsS3ymP/Sl0lin/4AfwNRP5wbx9aPb3cLa86B1Qj2wkWrcP
PB35NOjxnHM0ie4/mWupGmxAdyc2yxPvtKeRHa1zrlRDvWVq5tnXmy7H1/Ho
2ektO1fboaWJc6bazKlZphotJPe3QYfhhxP38vnoWqmnJ4j1dube1htvztxD
6h3thLXYroF+xPZU4rvuj96VurNq/X2dd7dqPh3ZhdGzphmTbUfFu0E+1uF7
ILq2yuEostHUu1IzrtmZlXlXaYZ097aKd43e0IvsoYp3bQt0OPWO0G7QTHWn
nknNonLSUvUO1+7+DtqbukaqjWqs3bWyapl22Fvg1qrfuhi8BLw489+imejL
fAfFVk+9C/8OdEfRPaDdt6jqXGsH3ljxn6a/TD2gv6EdnVD0H6G/6+fMs6n/
6Pmqd7B2r2ZGu//vzLOuP+C8bKNnXTtBf1F/5t2hP0m7cDDz7tBO7ILfknm3
aqdvw/a56L9FO3Iv/L7ov0c7WHebn/pv0h0nUv+ZutvOxG/VjtVu1Zv1d+1I
PYv6w/4HGKACUw==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8930768552871005, 0.8904982168853451, 0.8555913737281661], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmFtwlVcVx/c55HwnJzlfpJ3SBEK5FFvDveJYCBaBqYWkDzrgAL7YB4Xa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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllUtsV1UQxs+/7b3tv/97LoiUAq0IVdSoBdSIGilgFF8LTTAxbmShGxEf
qUVTxdeCKlJQ6EMiorSFGmmMFhMfGHChhI0kPCyKr+hCWhO1iEiQUh+/L99i
kpn7zcyZc+abubPue3TpI2UhhOeRCuTyYghrSiFMxJiE3I++jW+nCiE8h+Ov
WQi/I1uSEFr49ksM4Qj4m5UhfJ2GsBH/V5DlYLXEr0NfizyAPRl7Gv7TkX3E
r+a8NrAD2OuIjeDvkLsuD2Er+QaI6QafR/4VBddwLr41yOfEdxRc62Xg51S4
5h3EDyC3U2sf+Cr0F/AhfSgR8y92IH5Q54N3gc0h/kH0k8h67CNVuIDXkK8B
3wuRA9ivFVzranzWp65ZuV8suXad0QJ+kjN68T+PDwuqQ2hCJlDPSuLruduJ
ot+ygzvWg3UhS8p5Z+wG8FnIGL6biX8L3xFyDqF3g/djHyP/q+Tvwv6q6B7o
7fVmO6N7qN49xLf96IvIX0b+LZXu1SJ8hhP3rA/7NPYM9E6kEbuj5LdQD0d4
iyvBv8H/CfBh7IT6PiB3J/f9j1pawRtSv+lk9GdUQ+oePRvdc/W6kW93kH8C
9m6wPcjxzJwSl97ALoGtQi7Bdxf2UfxvwT6OfiPffuL8cuz3sZup56xq41st
+TeBj4uP0W+3AnxIveX+s7n/DXy7AKwNmZ+6p39x9h+6Q8E9G0f/G3kaewD7
fO46M3du9WQhsY+pJ2DHkMXRNao2fRN3NpTMfXHoW/D3wDdRSy8+Pegbqecz
+j9KvgrwrZzXVvCdvic+5Pa9HvXH6B6qd3rzi6I5KS4exL89+o6622LkCuxG
pBf8KPiX5BvD7gSrDsbmii+JfXL0aqQd/RO+HUQ/pB4Hc/waapuPLAPfx51O
oS/kvH4ctiFl0TOlWdqJPY3ap+euZQ85aqNnVrO6F/wwuc9gb0jdM3HhTvJ9
mpgTV2G/nXl2xblBsCnk2554hlrBnsxci2q8Gvxn7O7EM6G7ZNHc0Z3majfk
5rZmfDf21Nzcu5R8ZfRqUu7Z0o7ZRexHyBdgLal318sl7wLtsPEqz4RmQTN1
usqcFBcDdk3umdesq+flnPcu9d3Feftx6Qf7ODr3UvxfIvdTmXeTdpi4N4bs
SMzB1/HfjFwcXNNy9LXEL0jN6YT8g/jfjf93+HSCD1FPlnin9GgXZb6rOHY4
eudo14gTM3JzUlzsq/RZ/0TPjs48hF5XbUw90y7SDtLu0U7S7ugtepdph9TL
P3o3aMdrtv5EehLP2ESwvUXvAvVcs16I5o5m/nH0lcg9wRxrRh/NvBvqUu+a
s5lnUzvnN/SH+TY19T/pROYY+erMEezhzLMkjpzJvKO1m/XGTUVzWlwWx+7l
rsuQhjLXoF0Wo2dDO01vPy96ttQD7ZIp0dzWTrlWb1f0v0v/oNuwb0V+INco
PnPQ1yDXpZ7BJvUyelbEkUHttujdrR3RSq6bo2O1A5uL3kHaPdrhyjU7ehco
54fgtbm5qDvobcQ5cU1vtAT7pmguijPiSnvJ/2Zx5n8LiBAX
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.9411759999999999, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlklslVUUxy+vfd/r177XgkSgUBoHXCJGUoUwGREHREBZwKvRBRIKMSlR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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllDloVGEQx2ffXr59R6JisptdBEVLDwyiTYwE41EYL2wiWighiLDBIxBB
LW1cz414NMYo8QRdC7WwDGhtYaESG42NhYIoSEB/4x/ewMz3/898c31vycGR
3fXAzPqQHPIrNtsQmp3MmFUAziZmVeRN3mxdwWx/yewE9mL0WtZsdp7ZEGdL
0UeLZtnU7DYx+uEfx35BrAMlcZfjE0RmGWQK+x6SI1YWGebuTfj8Jl4nMW4U
ddYOtoMYDfLpJp8P2BnwEfC7noPfB/4TfIKz88S+gCykGNKwBvytyHdi98Pv
gduBz/WiavRYPeT3N1DM9XCLnI2hz+RVm/fAa/cap/BfkCr3Ofw/ku9eOJ3Y
dXw+wc2n6kUfMdfC/xKLW8+o9tWc1XLqwRn406Fqe819K9AvwukALyNf8f0c
y/caeAPsHML3v8YW2I9QtQ+Cr0JvAlbAqshl9EuReuExn/tsuXNZQT127krO
unLyeYU+A94Cvwm+DX0z8jKjHpbRuxLl2uTsMYEfITuxdyEP0O8j29EHkAn0
W7Fm6zvxLFbOnuu+vHyPhOq1x2jSy3FkOlCNp8CvROpFCn4ae5j728mvDfso
vr3Ye+C3yKeWKEfPzXfWZ1PHrhQ0o6ehdsh3x3fAsdlYvXXO1Uh3eGyf0SJm
+QSfNNCOvEOvpqrV7/Rc7nD2Lauc3mNbql1wn7fYf5DDRdXkvfc34W/BZzDH
/vSWtCuTuG4EPxaqlsFAu/gwVi99J7vB1yTieo/H4G5JxPUZDWCXU83O38yh
SD33XnuO45F66r30mU/Cn59qV/wN+ez9Dfvb9R0YTfRP8H+Bv/l/P/R67Q==

         "],
         VertexColors->None]}]}}, {{}, {}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2259, 3578, 3538, 2588, 2708, 2707, 2260, 2955, 2956, 2954, 
         2958, 2957, 2261, 2960, 2961, 2959, 2349, 2962, 3196, 2964, 2350, 
         2963, 2351, 3601, 2466, 3575, 2465, 3612, 2545, 3249, 3250, 2915, 
         2467, 3431, 3197, 2965, 2352, 2817, 2818, 3602, 2470, 3559, 2469, 
         3301, 2357, 3300, 3303, 3302, 3438, 2645, 2268, 3584, 3546, 2479, 
         3605, 2620, 2621, 3585, 3547, 2480, 3606, 2365, 3317, 2366, 3318, 
         3445, 3444, 2653, 2654, 2487, 3449, 2486, 3607, 2295, 2272, 3331, 
         3332, 3231, 3232, 3233, 3587, 3550, 2492, 3608, 2382, 3343, 2383, 
         3344, 2500, 3454, 3353, 3354, 3352, 3356, 3355, 3462, 2661, 2278, 
         3589, 3551, 2508, 2623, 2300, 2279, 3378, 3379, 3240, 3241, 3242, 
         3591, 3384, 2411, 3243, 3244, 3611, 2518, 3560, 2517, 3391, 2417, 
         3390, 2418, 3392, 2520, 3399, 2424, 3398, 3401, 3400, 3468}],
        "0.9`"],
       Annotation[#, 0.9, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2291, 2309, 3248, 3247, 3397, 3396, 2288, 2307, 3246, 3245, 
         3389, 3388, 2285, 2304, 3609, 3610, 3467, 2516, 2666, 2665, 3466, 
         3376, 3377, 3373, 3375, 3374, 3464, 3365, 3366, 3362, 3364, 3363, 
         3461, 3350, 3351, 3347, 3349, 3348, 3453, 3341, 3342, 3338, 3340, 
         3339, 3451, 3329, 3330, 3326, 3328, 3327, 3448, 3323, 3324, 3320, 
         3322, 3321, 3443, 3315, 3316, 3312, 3314, 3313, 3441, 3310, 3311, 
         3307, 3309, 3308, 3437, 2725, 3512, 3513, 3511, 2591, 2715, 2714, 
         3581, 3580, 3541, 3618, 3617, 2468, 3615, 3616, 3540, 3579, 2265, 
         2706, 2258, 3577, 3537, 2587, 3614, 2464, 2705, 2586, 3504, 3506, 
         3505, 2348, 2952, 2347, 2953, 3194, 3195, 2950, 2951, 2947, 2949, 
         3535, 2948, 3536, 2257, 3192, 3193, 3125, 3127, 3126, 2342, 2803, 
         2804}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2427, 2673, 2781, 2780, 2256, 3187, 2608, 3186, 2609, 2797, 
         2796, 2540, 2765, 2539, 2764, 2907, 2906, 2541, 3472, 3122, 3296, 
         3298, 3297, 2912, 2911, 2317, 3135, 3136, 3113, 2523, 3112, 2524, 
         2704, 2703, 2637, 3502, 3503, 3168, 2585, 3169, 2463, 3510, 2589, 
         3507, 3509, 3508, 2713, 3432, 3433, 3074, 3566, 2355, 3299, 2356, 
         3603, 3604, 3542, 3582, 3583, 3305, 3306, 3229, 3230, 2292, 2267, 
         2727, 2271, 3586, 3548, 2592, 2737, 2736, 3442, 3081, 3082, 2970, 
         3319, 2368, 2971, 2485, 3089, 3568, 2372, 3325, 2373, 2981, 2491, 
         3095, 3569, 2380, 3337, 2381, 2987, 2499, 3101, 3571, 2390, 3346, 
         2391, 2995, 2505, 3458, 3460, 3459, 2397, 3234, 3235, 3236, 3588, 
         3372, 2404, 3237, 3238, 3239, 3590, 3018, 2410, 2875, 2876, 2877, 
         3221, 3028, 2416, 2889, 2890, 2891, 3224, 3037, 2423, 2901, 2902, 
         2903, 3228}],
        "0.7`"],
       Annotation[#, 0.7, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2460, 2700, 2699, 2324, 3267, 3051, 2443, 3413, 2442, 3572, 
         3573, 3558, 3050, 2905, 3039, 3038, 3120, 2757, 2322, 3266, 2917, 
         2556, 2779, 2778, 2792, 2793, 2600, 3561, 2599, 3619, 2777, 2542, 
         2766, 2595, 3178, 2596, 3179, 2543, 3123, 2544, 3124, 3600, 3429, 
         3574, 2462, 3430, 3190, 3191, 3041, 2263, 3539, 3040, 2806, 2914, 
         2913, 2318, 2769, 2770, 2610, 2798, 2618, 2619, 2611, 3203, 3202, 
         3201, 2590, 2724, 2723, 3436, 2477, 3077, 3567, 2361, 3304, 2362, 
         3439, 3440, 3208, 3209, 2969, 2364, 2828, 2829, 2294, 2270, 2733, 
         2734, 2593, 3172, 3174, 3173, 2738, 3447, 3087, 3088, 2978, 2980, 
         2979, 3450, 3093, 3094, 2985, 3336, 2379, 2986, 2498, 3100, 3570, 
         2388, 3345, 2389, 2994, 2504, 3003, 2395, 2854, 2396, 3004, 2507, 
         3011, 2402, 2863, 2403, 3012, 2510, 3105, 2511, 3106, 2409, 2872, 
         2873, 2874, 3220, 3027, 2415, 2886, 2887, 2888, 3223, 3036, 2422, 
         2898, 2899, 2900, 3227}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2290, 2308, 2897, 2896, 3033, 3032, 2287, 2306, 2885, 2884, 
         3024, 3023, 2284, 3219, 2871, 2870, 2869, 2408, 3017, 3217, 2865, 
         2864, 2862, 2401, 3010, 3216, 2856, 2855, 2853, 2394, 3002, 3214, 
         3103, 2503, 3104, 2387, 2845, 2386, 2993, 2497, 2984, 2378, 2837, 
         2377, 2983, 2490, 3092, 2976, 3210, 2977, 2975, 3086, 3085, 3446, 
         2735, 3084, 2482, 3083, 2483, 2651, 2650, 2269, 2293, 2827, 2826, 
         2363, 2968, 3207, 3078, 3080, 3079, 2360, 2824, 2359, 2967, 2476, 
         3076, 2711, 2712, 2474, 2809, 3198, 3199, 2639, 2264, 2808, 2807, 
         2910, 3563, 3565, 3564, 2316, 3155, 2315, 2909, 2908, 2429, 3409, 
         3410, 3406, 3408, 3407, 3476, 3138, 3139, 3137, 3141, 3140, 2461, 
         2758, 2759, 2612, 2756, 2755, 2313, 2674, 2675, 2536, 3118, 2535, 
         3119, 3143, 3142, 2323, 3479, 3480, 3146, 2561, 3147, 2459, 3167, 
         2584, 2802, 3189, 2686, 2439, 3054, 2445, 2920, 3270}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2534, 2754, 2689, 2923, 2922, 2921, 2446, 3055, 2630, 3145, 
         2560, 2929, 2930, 2931, 2783, 3272, 3271, 2928, 2559, 3144, 2444, 
         3134, 2554, 3133, 2553, 3475, 2773, 2774, 2602, 3184, 2601, 3185, 
         2782, 2760, 2761, 2555, 3525, 2598, 3264, 3265, 2321, 2776, 2701, 
         2702, 2676, 2428, 2763, 2627, 3427, 3428, 3287, 3288, 3289, 2574, 
         3157, 3156, 2941, 2573, 2768, 2767, 2709, 2710, 2638, 2353, 2718, 
         2354, 3075, 2475, 2810, 3200, 2966, 2358, 2823, 2825, 3543, 3544, 
         3545, 2266, 3205, 3206, 3166, 3576, 3165, 2811, 2481, 2647, 2646, 
         2732, 2648, 2649, 2746, 2745, 2367, 2652, 2484, 2974, 2370, 2834, 
         2371, 3091, 2489, 3090, 3211, 2982, 2376, 2836, 2838, 2839, 3212, 
         2990, 2385, 2844, 2846, 2298, 2276, 2999, 3000, 2851, 2852, 2299, 
         2277, 3007, 3008, 2860, 2861, 2302, 2281, 2662, 2283, 3218, 2812, 
         2513, 2664, 2663, 3109, 3021, 3022, 2881, 3026, 3025, 3110, 3030, 
         3031, 2893, 3035, 3034, 3111}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2311, 2904, 2687, 2440, 2626, 2441, 2672, 2670, 2752, 2678, 
         2679, 2558, 2629, 2320, 2694, 2448, 3183, 2597, 3180, 3182, 3181, 
         2775, 2327, 3275, 3064, 2453, 3063, 2452, 3046, 2432, 3047, 3405, 
         3048, 2937, 2936, 2335, 2762, 3471, 2537, 3121, 2538, 3490, 3491, 
         3488, 2572, 3489, 2314, 2628, 2576, 3290, 3291, 3292, 2790, 2338, 
         3293, 3163, 2578, 3161, 2577, 3162, 3492, 2575, 3493, 3158, 3160, 
         3159, 2565, 3149, 2566, 3150, 2473, 2719, 2720, 2717, 2716, 2640, 
         2722, 2641, 2642, 2526, 2644, 2820, 2643, 2726, 2478, 3164, 2579, 
         2942, 2943, 2339, 2636, 2340, 2944, 2580, 2945, 3294, 3295, 2731, 
         3171, 3153, 3154, 2938, 3284, 2336, 2744, 3469, 2528, 3114, 2529, 
         3470, 3115, 3116, 2972, 3549, 2973, 2833, 2835, 2296, 2274, 2657, 
         2658, 2494, 3096, 2493, 3097, 2659, 3099, 2988, 2989, 2841, 2992, 
         2991, 3102, 2997, 2998, 2848, 2393, 3001, 2506, 3006, 2399, 2858, 
         2400, 3009, 2509, 3015, 2406, 2867, 2407, 3016, 2514, 3107, 2515, 
         3108, 2414, 2880, 2882, 2883, 3222, 3029, 2421, 2892, 2894, 2895, 
         3226}],
        "0.3`"],
       Annotation[#, 0.3, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2437, 2685, 2684, 2312, 2688, 2625, 2691, 2690, 2426, 2671, 
         2532, 2680, 2533, 2753, 2431, 2692, 2693, 2682, 3553, 2681, 2325, 
         3065, 3066, 2946, 2345, 2924, 2346, 2617, 2255, 3060, 2451, 3059, 
         3058, 2805, 2343, 3072, 3073, 3070, 2458, 3071, 3269, 3268, 3478, 
         3477, 2557, 2785, 3620, 3621, 3526, 2604, 3527, 2568, 3152, 2334, 
         3556, 3151, 2935, 3425, 3426, 2457, 3424, 3283, 2934, 3416, 3417, 
         3418, 3067, 3068, 2932, 2329, 3069, 2330, 2632, 2567, 2933, 3278, 
         3279, 2721, 3170, 3128, 3129, 2916, 3251, 3252, 2742, 2743, 2527, 
         2819, 2821, 2822, 3204, 3043, 2430, 3042, 3045, 3044, 2344, 2728, 
         2729, 2635, 2634, 2697, 2698, 3531, 3532, 3530, 3534, 3533, 2581, 
         3501, 2583, 3499, 2582, 3500, 2337, 2939, 2787, 2570, 2799, 2569, 
         2786, 2616, 3624, 3625, 3562, 3623, 2613, 2800, 2614, 2750, 2749, 
         2369, 2655, 2488, 2656, 2374, 2751, 2375, 3335, 3188, 3334, 3557, 
         3333, 2495, 3452, 2496, 3098, 2384, 2840, 2842, 2843, 3213, 2996, 
         2392, 2847, 2849, 2850, 3215, 3005, 2398, 2857, 2859, 2301, 2280, 
         3013, 3014, 2866, 2868, 2303, 2282, 3019, 3020, 2878, 2879, 2305, 
         2286, 2667, 2289, 3225, 2813, 2521, 2669, 2668, 2739}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2522, 3395, 2420, 3393, 2419, 3394, 2519, 3387, 2413, 3385, 
         2412, 3386, 2512, 3383, 2405, 3380, 3382, 3381, 3465, 3370, 3371, 
         3367, 3369, 3368, 3463, 3360, 3361, 3357, 3359, 3358, 3457, 2660, 
         3456, 2501, 3455, 2502, 3514, 3515, 3175, 3177, 3176, 2275, 2297, 
         2622, 2615, 2801, 2594, 2791, 2531, 3132, 2552, 3130, 2551, 3131, 
         2273, 2832, 2831, 2830, 2530, 2748, 2747, 3263, 3262, 3261, 2550, 
         3474, 2571, 3529, 2607, 2940, 3285, 3286, 2788, 2789, 2606, 3528, 
         2605, 3622, 2696, 3260, 3259, 3258, 3524, 3523, 2549, 3497, 3498, 
         3494, 3496, 3495, 2730, 2784, 3596, 3595, 3555, 2603, 2795, 2794, 
         2548, 3521, 3522, 3256, 3257, 2319, 2683, 3255, 3254, 3253, 2547, 
         3473, 2546, 2772, 3274, 3273, 2563, 3481, 2631, 3482, 2564, 3276, 
         3277, 2328, 2771, 3517, 3518, 3516, 3520, 3519, 2433, 3411, 2434, 
         3049, 3282, 2332, 2633, 2331, 3281, 3280, 2456, 3423, 2455, 3420, 
         2454, 3419, 3422, 3421, 2333, 2695, 3435, 2471, 3434, 2472, 3486, 
         3487, 3483, 3485, 3484, 2262, 2816, 2815, 2814, 2525, 2741, 2740, 
         3594, 3593, 3554, 2562, 3613, 2919, 2918, 3053, 3052, 3117, 3148, 
         2326, 2927, 2926, 3062, 3061, 2341, 3056, 2449, 2925, 3057, 3628, 
         2450, 3626, 3627, 3415, 2447, 3414, 3599, 3598, 2677, 2310, 3403, 
         3404, 3402, 2425, 3412, 2436, 2624, 2435, 3597, 2438, 3552, 3592}],
        "0.1`"],
       Annotation[#, 0.1, "Tooltip"]& ]}, {}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  PlotRange->NCache[{{
      Rational[-1, 10], 5}, {
      Rational[1, 10], 5}}, {{-0.1, 5}, {0.1, 5}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 234},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->419709550]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7986],

Cell["The probability density function integrates to unity:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->10189],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"InverseGaussianDistribution", "[", 
      RowBox[{"\[Mu]", ",", "\[Lambda]"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Mu]", ">", "0"}], ",", 
      RowBox[{"\[Lambda]", ">", "0"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11156],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26476436]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2512],

Cell["Moments can be obtained from the characteristic function:", \
"ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->3912],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ev", "=", 
  RowBox[{"ExpectedValue", "[", 
   RowBox[{
    RowBox[{"x", "^", "4"}], ",", 
    RowBox[{"InverseGaussianDistribution", "[", 
     RowBox[{"\[Mu]", ",", "\[Lambda]"}], "]"}], ",", "x"}], "]"}]}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->9551],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[Mu]", "4"], " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["\[Lambda]", "3"], "+", 
     RowBox[{"6", " ", 
      SuperscriptBox["\[Lambda]", "2"], " ", "\[Mu]"}], "+", 
     RowBox[{"15", " ", "\[Lambda]", " ", 
      SuperscriptBox["\[Mu]", "2"]}], "+", 
     RowBox[{"15", " ", 
      SuperscriptBox["\[Mu]", "3"]}]}], ")"}]}], 
  SuperscriptBox["\[Lambda]", "3"]]], "Output",
 ImageSize->{190, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->454216628]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cf", "=", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"CharacteristicFunction", "[", 
     RowBox[{
      RowBox[{"InverseGaussianDistribution", "[", 
       RowBox[{"\[Mu]", ",", "\[Lambda]"}], "]"}], ",", "t"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "4"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21817],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{455, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->141746691]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", 
  RowBox[{"cf", "/.", 
   RowBox[{"t", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->172750144],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[Mu]", "4"], "+", 
  FractionBox[
   RowBox[{"6", " ", 
    SuperscriptBox["\[Mu]", "5"]}], "\[Lambda]"], "+", 
  FractionBox[
   RowBox[{"15", " ", 
    SuperscriptBox["\[Mu]", "6"]}], 
   SuperscriptBox["\[Lambda]", "2"]], "+", 
  FractionBox[
   RowBox[{"15", " ", 
    SuperscriptBox["\[Mu]", "7"]}], 
   SuperscriptBox["\[Lambda]", "3"]]}]], "Output",
 ImageSize->{149, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->955182707]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"ev", "\[Equal]", "%"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->455190901],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->778480107]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28834],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseGaussianDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseGaussianDistribution"]], "InlineFormula"],
 " is not defined when ",
 Cell[BoxData[
  StyleBox["\[Mu]", "TR"]], "InlineFormula"],
 " is not a positive real number:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->14578],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"InverseGaussianDistribution", "[", 
   RowBox[{
    RowBox[{"3", "+", "I"}], ",", "6"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4949],

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseGaussianDistribution", "::", "\<\"posparm\"\>"}], ":", 
  " ", "\<\"Parameter \\!\\(3 + \[ImaginaryI]\\) is expected to be \
positive.\"\>"}]], "Message", "MSG",
 CellID->190823513],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"InverseGaussianDistribution", "[", 
   RowBox[{
    RowBox[{"3", "+", "\[ImaginaryI]"}], ",", "6"}], "]"}], "]"}]], "Output",
 ImageSize->{295, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->141910296]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseGaussianDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseGaussianDistribution"]], "InlineFormula"],
 " is not defined when ",
 Cell[BoxData[
  StyleBox["\[Lambda]", "TR"]], "InlineFormula"],
 " is not a positive real number:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->19785],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"InverseGaussianDistribution", "[", 
   RowBox[{"3", ",", 
    RowBox[{"-", "6"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9227],

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseGaussianDistribution", "::", "\<\"posparm\"\>"}], ":", 
  " ", "\<\"Parameter \\!\\(-6\\) is expected to be positive.\"\>"}]], \
"Message", "MSG",
 CellID->762788906],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"InverseGaussianDistribution", "[", 
   RowBox[{"3", ",", 
    RowBox[{"-", "6"}]}], "]"}], "]"}]], "Output",
 ImageSize->{282, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->550090459]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19046],

Cell["\<\
Substitution of invalid parameters into symbolic outputs gives results that \
are not meaningful:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->16727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mean", "[", 
   RowBox[{"InverseGaussianDistribution", "[", 
    RowBox[{"\[Mu]", ",", "\[Lambda]"}], "]"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Mu]", "\[Rule]", "I"}], ",", 
    RowBox[{"\[Lambda]", "\[Rule]", 
     RowBox[{"-", "2"}]}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25838],

Cell[BoxData["\[ImaginaryI]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->454439137]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26528],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NormalDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NormalDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GammaDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GammaDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10443]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12253],

Cell[TextData[ButtonBox["Continuous Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ContinuousDistributions"]], "Tutorials",
 CellID->7471]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Continuous Statistical Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ContinuousStatisticalDistributions"]], "MoreAbout",\

 CellID->263281336]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InverseGaussianDistribution - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 49, 53.3696502}", "context" -> "System`", 
    "keywords" -> {
     "first passage times in Brownian motion", 
      "inverse Gaussian distribution", "Wald distribution"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "InverseGaussianDistribution[\\[Mu], \\[Lambda]] represents an inverse \
Gaussian distribution with mean \\[Mu] and scale parameter \\[Lambda].", 
    "synonyms" -> {"inverse gaussian distribution"}, "title" -> 
    "InverseGaussianDistribution", "type" -> "Symbol", "uri" -> 
    "ref/InverseGaussianDistribution"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7816, 254, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->216125287]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 137987, 2868}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1984, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2607, 78, 1592, 37, 70, "ObjectNameGrid"],
Cell[4202, 117, 703, 22, 70, "Usage",
 CellID->11754]
}, Open  ]],
Cell[CellGroupData[{
Cell[4942, 144, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5420, 161, 1111, 41, 70, "Notes",
 CellID->429991538],
Cell[6534, 204, 526, 17, 70, "Notes",
 CellID->26584],
Cell[7063, 223, 716, 26, 70, "Notes",
 CellID->33143606]
}, Closed]],
Cell[CellGroupData[{
Cell[7816, 254, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->216125287],
Cell[CellGroupData[{
Cell[8201, 268, 148, 5, 70, "ExampleSection",
 CellID->125690957],
Cell[8352, 275, 284, 7, 70, "ExampleText",
 CellID->20877],
Cell[CellGroupData[{
Cell[8661, 286, 185, 5, 28, "Input",
 CellID->1014],
Cell[8849, 293, 162, 5, 36, "Output",
 CellID->197625925]
}, Open  ]],
Cell[CellGroupData[{
Cell[9048, 303, 188, 5, 28, "Input",
 CellID->484],
Cell[9239, 310, 213, 7, 54, "Output",
 CellID->11019386]
}, Open  ]],
Cell[9467, 320, 121, 3, 70, "ExampleDelimiter",
 CellID->11495],
Cell[9591, 325, 253, 6, 70, "ExampleText",
 CellID->26811],
Cell[CellGroupData[{
Cell[9869, 335, 209, 6, 70, "Input",
 CellID->1293],
Cell[10081, 343, 592, 21, 86, "Output",
 CellID->161936131]
}, Open  ]],
Cell[CellGroupData[{
Cell[10710, 369, 317, 10, 28, "Input",
 CellID->6798],
Cell[11030, 381, 3096, 55, 166, "Output",
 Evaluatable->False,
 CellID->299967656]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14175, 442, 216, 7, 70, "ExampleSection",
 CellID->14890],
Cell[14394, 451, 276, 8, 70, "ExampleText",
 CellID->8493],
Cell[CellGroupData[{
Cell[14695, 463, 205, 6, 70, "Input",
 CellID->29074],
Cell[14903, 471, 334, 10, 36, "Output",
 CellID->102964007]
}, Open  ]],
Cell[15252, 484, 121, 3, 70, "ExampleDelimiter",
 CellID->13774],
Cell[15376, 489, 83, 1, 70, "ExampleText",
 CellID->20699375],
Cell[CellGroupData[{
Cell[15484, 494, 189, 5, 70, "Input",
 CellID->9314],
Cell[15676, 501, 226, 8, 60, "Output",
 CellID->525285790]
}, Open  ]],
Cell[CellGroupData[{
Cell[15939, 514, 190, 5, 70, "Input",
 CellID->29218],
Cell[16132, 521, 237, 8, 51, "Output",
 CellID->49343320]
}, Open  ]],
Cell[16384, 532, 121, 3, 70, "ExampleDelimiter",
 CellID->12351],
Cell[16508, 537, 229, 5, 70, "ExampleText",
 CellID->6923],
Cell[CellGroupData[{
Cell[16762, 546, 253, 7, 70, "Input",
 CellID->7118],
Cell[17018, 555, 579, 18, 57, "Output",
 CellID->385225584]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17646, 579, 223, 7, 70, "ExampleSection",
 CellID->18040],
Cell[17872, 588, 249, 7, 70, "ExampleText",
 CellID->19271],
Cell[CellGroupData[{
Cell[18146, 599, 368, 12, 70, "Input",
 CellID->12368],
Cell[18517, 613, 2526, 45, 70, "Output",
 Evaluatable->False,
 CellID->239500984]
}, Open  ]],
Cell[21058, 661, 121, 3, 70, "ExampleDelimiter",
 CellID->15258],
Cell[21182, 666, 362, 13, 70, "ExampleText",
 CellID->4157],
Cell[CellGroupData[{
Cell[21569, 683, 485, 15, 70, "Input",
 CellID->9647],
Cell[22057, 700, 101243, 1696, 70, "Output",
 CellID->419709550]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[123349, 2402, 232, 7, 70, "ExampleSection",
 CellID->7986],
Cell[123584, 2411, 229, 5, 70, "ExampleText",
 CellID->10189],
Cell[CellGroupData[{
Cell[123838, 2420, 512, 15, 70, "Input",
 CellID->11156],
Cell[124353, 2437, 157, 5, 36, "Output",
 CellID->26476436]
}, Open  ]],
Cell[124525, 2445, 120, 3, 70, "ExampleDelimiter",
 CellID->2512],
Cell[124648, 2450, 234, 6, 70, "ExampleText",
 CellID->3912],
Cell[CellGroupData[{
Cell[124907, 2460, 283, 9, 70, "Input",
 CellID->9551],
Cell[125193, 2471, 579, 18, 57, "Output",
 CellID->454216628]
}, Open  ]],
Cell[CellGroupData[{
Cell[125809, 2494, 367, 11, 70, "Input",
 CellID->21817],
Cell[126179, 2507, 3852, 67, 70, "Output",
 Evaluatable->False,
 CellID->141746691]
}, Open  ]],
Cell[CellGroupData[{
Cell[130068, 2579, 162, 5, 70, "Input",
 CellID->172750144],
Cell[130233, 2586, 530, 18, 55, "Output",
 CellID->955182707]
}, Open  ]],
Cell[CellGroupData[{
Cell[130800, 2609, 135, 4, 70, "Input",
 CellID->455190901],
Cell[130938, 2615, 161, 5, 36, "Output",
 CellID->778480107]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[131148, 2626, 226, 7, 70, "ExampleSection",
 CellID->28834],
Cell[131377, 2635, 466, 14, 70, "ExampleText",
 CellID->14578],
Cell[CellGroupData[{
Cell[131868, 2653, 198, 6, 70, "Input",
 CellID->4949],
Cell[132069, 2661, 223, 5, 70, "Message",
 CellID->190823513],
Cell[132295, 2668, 304, 9, 36, "Output",
 CellID->141910296]
}, Open  ]],
Cell[132614, 2680, 470, 14, 70, "ExampleText",
 CellID->19785],
Cell[CellGroupData[{
Cell[133109, 2698, 193, 6, 70, "Input",
 CellID->9227],
Cell[133305, 2706, 208, 5, 70, "Message",
 CellID->762788906],
Cell[133516, 2713, 287, 9, 36, "Output",
 CellID->550090459]
}, Open  ]],
Cell[133818, 2725, 121, 3, 70, "ExampleDelimiter",
 CellID->19046],
Cell[133942, 2730, 281, 8, 70, "ExampleText",
 CellID->16727],
Cell[CellGroupData[{
Cell[134248, 2742, 354, 11, 70, "Input",
 CellID->25838],
Cell[134605, 2755, 170, 5, 36, "Output",
 CellID->454439137]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[134836, 2767, 311, 9, 70, "SeeAlsoSection",
 CellID->26528],
Cell[135150, 2778, 489, 17, 70, "SeeAlso",
 CellID->10443]
}, Open  ]],
Cell[CellGroupData[{
Cell[135676, 2800, 314, 9, 70, "TutorialsSection",
 CellID->12253],
Cell[135993, 2811, 157, 3, 70, "Tutorials",
 CellID->7471]
}, Open  ]],
Cell[CellGroupData[{
Cell[136187, 2819, 299, 8, 70, "MoreAboutSection"],
Cell[136489, 2829, 184, 4, 70, "MoreAbout",
 CellID->263281336]
}, Open  ]],
Cell[136688, 2836, 27, 0, 70, "History"],
Cell[136718, 2838, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

