(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    705903,      12695]
NotebookOptionsPosition[    697162,      12395]
NotebookOutlinePosition[    698811,      12439]
CellTagsIndexPosition[    698671,      12433]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals and Elliptic Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals and Elliptic Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"JacobiCN" :> Documentation`HelpLookup["paclet:ref/JacobiCN"], 
          "InverseJacobiCD" :> 
          Documentation`HelpLookup["paclet:ref/InverseJacobiCD"], 
          "InverseJacobiCS" :> 
          Documentation`HelpLookup["paclet:ref/InverseJacobiCS"], 
          "InverseJacobiSC" :> 
          Documentation`HelpLookup["paclet:ref/InverseJacobiSC"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"JacobiCN\"\>", 
       2->"\<\"InverseJacobiCD\"\>", 3->"\<\"InverseJacobiCS\"\>", 
       4->"\<\"InverseJacobiSC\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Functions" :> 
          Documentation`HelpLookup["paclet:guide/EllipticFunctions"], 
          "Inverse Functions" :> 
          Documentation`HelpLookup["paclet:guide/InverseFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Elliptic Functions\"\>", 
       2->"\<\"Inverse Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InverseJacobiCN", "ObjectName",
 CellID->17698],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InverseJacobiCN",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InverseJacobiCN"], "[", 
       RowBox[{
        StyleBox["v", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the inverse Jacobi elliptic function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox["cn", 
         RowBox[{"-", "1"}]], "(", 
        RowBox[{"v", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
      "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4570]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["cn", 
     RowBox[{"-", "1"}]], "(", 
    RowBox[{"v", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " gives the value of ",
 Cell[BoxData[
  FormBox[
   StyleBox["u", "TI"], TraditionalForm]], "InlineFormula"],
 " for which ",
 Cell[BoxData[
  FormBox[
   RowBox[{"v", "=", 
    RowBox[{"cn", "(", 
     RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->29772],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseJacobiCN",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiCN"]], "InlineFormula"],
 " has branch cut discontinuities in the complex ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " plane with branch points at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[PlusMinus]", "1"}], ",", 
    RowBox[{"\[PlusMinus]", " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"m", "-", "1"}], ")"}], "/", "m"}]]}]}], TraditionalForm]], 
  "InlineMath"],
 " and infinity, and in the complex ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " plane with branch points at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox["z", "2"]}], ")"}]}], TraditionalForm]], "InlineMath"],
 " and infinity."
}], "Notes",
 CellID->241713],

Cell["\<\
The inverse Jacobi elliptic functions are related to elliptic integrals. \
\>", "Notes",
 CellID->25366],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["InverseJacobiCN",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiCN"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->250399474],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseJacobiCN",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiCN"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseJacobiCN",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiCN"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->66034471],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->103384074],

Cell["Evaluate numerically:", "ExampleText",
 CellID->692069],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiCN", "[", 
  RowBox[{"0.3", ",", "0.4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->335790773],

Cell[BoxData["1.3880413582458326`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->574086572]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiCN", "[", 
  RowBox[{"%", ",", "0.4"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->107203619],

Cell[BoxData["0.30000000000000004`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->936499]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16101587],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"InverseJacobiCN", "[", 
    RowBox[{"x", ",", 
     RowBox[{"1", "/", "3"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->153026984],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 123},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27249509]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->576203269],

Cell["Series expansions:", "ExampleText",
 CellID->25780993],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"InverseJacobiCN", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23743233],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"EllipticK", "[", "m", "]"}], "-", 
   FractionBox["z", 
    SqrtBox[
     RowBox[{"1", "-", "m"}]]], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"2", " ", "m"}]}], ")"}], " ", 
     SuperscriptBox["z", "3"]}], 
    RowBox[{"6", " ", 
     SqrtBox[
      RowBox[{"1", "-", "m"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "m"}], ")"}]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "5"],
    SeriesData[$CellContext`z, 0, {}, 0, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
    EllipticK[$CellContext`m], -(1 - $CellContext`m)^Rational[-1, 2], 0, 
    Rational[1, 6] (1 - 2 $CellContext`m) (1 - $CellContext`m)^
     Rational[-1, 2]/(-1 + $CellContext`m)}, 0, 5, 1],
  Editable->False]], "Output",
 ImageSize->{316, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->66788954]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"InverseJacobiCN", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->153381913],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"ArcCos", "[", "z", "]"}], "+", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "z"}], " ", 
       SqrtBox[
        RowBox[{"1", "-", 
         SuperscriptBox["z", "2"]}]]}], "+", 
      RowBox[{"ArcCos", "[", "z", "]"}]}], ")"}], " ", "m"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "m", "]"}], "2"],
    SeriesData[$CellContext`m, 0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`m, 0, {
    ArcCos[$CellContext`z], 
    Rational[1, 4] (-$CellContext`z (1 - $CellContext`z^2)^Rational[1, 2] + 
     ArcCos[$CellContext`z])}, 0, 2, 1],
  Editable->False]], "Output",
 ImageSize->{309, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->55068235]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16706],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->551805159],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiCN", "[", 
  RowBox[{
   RowBox[{"0.2", "-", 
    RowBox[{"0.3", "I"}]}], ",", 
   RowBox[{"0.1", "+", 
    RowBox[{"0.5", "I"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->102361289],

Cell[BoxData[
 RowBox[{"1.2973915590858223`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.4355993205915295`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->230584937]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->169754269],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->654966717],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"InverseJacobiCN", "[", 
    RowBox[{
     RowBox[{"2", "/", "3"}], ",", 
     RowBox[{"3", "/", "5"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->368196955],

Cell[BoxData["0.\
9029626003687082442861505360482778909800052062650195552561032411665`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->623613988]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->327928165],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->67807481],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiCN", "[", 
  RowBox[{"0.6666666666666666666666666666666666666", ",", 
   RowBox[{"3", "/", "5"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->152063859],

Cell[BoxData["0.9029626003687082442861505360482778910834967697`35.\
47394106149602"], "Output",
 ImageSize->{263, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->35256759]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->203414112],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseJacobiCN",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiCN"]], "InlineFormula"],
 " threads element\[Hyphen]wise over lists:"
}], "ExampleText",
 CellID->674035758],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiCN", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.1", ",", "0.2"}], "}"}], ",", "0.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->952307843],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.7126519067915709`", ",", "1.5711866797949883`"}], 
  "}"}]], "Output",
 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->345990485]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23779011],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellID->563494599],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"InverseJacobiCN", "[", 
    RowBox[{"0", ",", "m"}], "]"}], ",", 
   RowBox[{"InverseJacobiCN", "[", 
    RowBox[{"1", ",", "m"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->343918558],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"EllipticK", "[", "m", "]"}], ",", "0"}], "}"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->369288992]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"InverseJacobiCN", "[", 
    RowBox[{"z", ",", "0"}], "]"}], ",", 
   RowBox[{"InverseJacobiCN", "[", 
    RowBox[{"z", ",", "1"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->257978136],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ArcCos", "[", "z", "]"}], ",", 
   RowBox[{"ArcSech", "[", "z", "]"}]}], "}"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->230245001]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->54695299],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->34569057],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseJacobiCN", "[", 
   RowBox[{"z", ",", "m"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->313226108],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["cn", 
    RowBox[{"-", "1"}]], "(", 
   RowBox[{"z", "\[VerticalSeparator]", "m"}], ")"}], 
  TraditionalForm]], "Output",
 ImageSize->{59, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->253026514]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19362],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseJacobiCN",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiCN"]], "InlineFormula"],
 " can be applied to a power series:"
}], "ExampleText",
 CellID->197834340],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiCN", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcSin", "[", "x", "]"}], "+", 
    RowBox[{
     RowBox[{"O", "[", "x", "]"}], "^", "7"}]}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->336277738],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"EllipticK", "[", "m", "]"}], "-", 
   FractionBox["x", 
    SqrtBox[
     RowBox[{"1", "-", "m"}]]], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", "-", 
       RowBox[{"3", " ", "m"}]}], ")"}], " ", 
     SuperscriptBox["x", "3"]}], 
    RowBox[{"6", " ", 
     SqrtBox[
      RowBox[{"1", "-", "m"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "m"}], ")"}]}]], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "28"}], "+", 
       RowBox[{"72", " ", "m"}], "-", 
       RowBox[{"53", " ", 
        SuperscriptBox["m", "2"]}]}], ")"}], " ", 
     SuperscriptBox["x", "5"]}], 
    RowBox[{"120", " ", 
     SqrtBox[
      RowBox[{"1", "-", "m"}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "m"}], ")"}], "2"]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "6"],
    SeriesData[$CellContext`x, 0, {}, 0, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
    EllipticK[$CellContext`m], -(1 - $CellContext`m)^Rational[-1, 2], 0, 
    Rational[1, 6] (2 - 3 $CellContext`m) (1 - $CellContext`m)^
     Rational[-1, 2]/(-1 + $CellContext`m), 0, 
    Rational[1, 120] (1 - $CellContext`m)^
     Rational[-1, 2] (-1 + $CellContext`m)^(-2) (-28 + 72 $CellContext`m - 
     53 $CellContext`m^2)}, 0, 6, 1],
  Editable->False]], "Output",
 ImageSize->{463, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->734716851]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11565],

Cell["\<\
Plot contours of constant real and imaginary parts in the complex plane:\
\>", "ExampleText",
 CellID->147991225],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ContourPlot", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"InverseJacobiCN", "[", 
       RowBox[{
        RowBox[{"x", "+", 
         RowBox[{"I", " ", "y"}]}], ",", 
        RowBox[{"1", "+", "I"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
     RowBox[{"Contours", "\[Rule]", "24"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{"Re", ",", "Im"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41283476],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyEnXd8VUXTx5N7c0MVEAQpShOpiqA0QTlHpSMCCii9g0oTAelFikpHpCkg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     "], {{
       {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
        GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlm1Ml2UUxs+flyARECReTeGPNHXiH9O14cqmc7pogUK5NVkTqazY1EKh
hSSCpH2w6Sql0nBztdra+lCrZJCy9ar4odRyq62ptQX6gS+t9aV1/TqH+eHe
fT/3c55zX+c61zn3U7VtZ/OONDP7SyNd45cCs8eKzSYSZts1Dif83Wi+2bDW
T2s8vNCsQWOFPvg322yl5u/kZJ/etWid1HxO9mfz/d3IHWanNGdrXNO7+vA5
nWe2SaNRY7dGp0ZRptnV+fJTpDPT/HxwdMu+O+E++HZSdqv0/KLWz8n/95l+
9l2al2eYvZvw99vD5kyG++7Sc4V8f1rm+Nty/ftpvX89y2xHjtu1ioeRhf68
TPbzas3+lN3gHLM9FfJjHuOj6c7JuNZb7vTnDs0viZeXE84LHMzgPxyxNCjW
h/Lcrlj+2+XzqvyfnufPrPuFLSvbYyIevq/RWC0MD8zxnAzIR3+e83tT505q
tGndvsDsWJVZb7ZjGst3nD2zzOZq/K31aKbjgydw8C2YjyrW12r9fHiBV3J7
pcTsUNJsKs6ZCvs9y5RD8XlN9j9Wmp1PSUvC95R0dF3Pf6Q7VjDD21vVZm9r
fDLLca2OWL4S3vfK5S/h55IXzoY/tARvRfrmV+2ntLdTnL2/yJ8rNF8qNLuV
43kkh+Qcva1VjM/q22eEpyLleMDCuWiAc8CChoaEq7XM1+Tk+UrPxbfZfjbn
dmtvcdL3+qImakJv8AnOpjzXN9r+OuW8wAk57Av7lrlmv2n/Rprz8GW+42Fv
81zfHwldEsv+yDW1uV4aOa2YO2Q/LKzn9f6gzr0lXDc11gjrcvk4X+l11Ffh
OkbDr8jHYPiBg7E4F55uBFcfyfeHGrtnu0735rquLsp2QqMuw3X0TY5r6XPF
eEb6WJvhWNELfQDfo6E96pJeQA0Tx0BguCKM96a8l1yIPoNOOJtaIkbyhp7I
3VblqLrAtdeU7rVRE7yejbMYw7G/KXJxMuEcEju6ADsxkEe+Oxffbszz/MFb
Ksc1eAL8Oc4fcd1XalZW6/khLmKayW131PjRpZ4PckEe6Gv4vDvzdk0fSPdn
1uxR7/iD5+ngEU6Y6V3o8nqW49mlWrm/yPOyRZrtme/vHlHfatSoF94lOr+7
0HNEf2KPfnAqcgDuJxd4v6BXPKF5vMr7AZz0RSxol/yg7ybx/0Gp9xJqj/xQ
F5PR98DDHv7Yh3/yRC7gHv2hNfKDNsg1+b9c6Wegwd/TXYfJNM8Va7iHb/gf
CZ3N3DXj0Ys/VrxLSj2vxDsed1BdjufyC32zptjvObS3V72rpcx74ZuK+8Fy
x4w9+cb//ALvTfQlelxd+HmhwnsQHBArMaPJZNJ7BLoiHnCsDE46omcOR167
Yp6IHOMXnCfirkOv3HdoMBV4qL2J4G2z8r+u3PlFZ23Rsw+HDvkWzvdHre0P
7bOPj4tx7nRori40B7dge1Wx/FTidwuY6WfksUtxD5W4/eXFZj9rDM32+mZG
XxuE6/Ei13hPoWsRHZ5RXzlS4LpHG82hj13ibFvcg1PR0+ipx5Sv9gKvX/x9
tsh98s2BqH/upbZqv5N+EJZ/ihwDtq2BgdxWJT2/jfHvQSzNscb/dNQ+a+aN
se6M/a74p1iVuN3nG2MfTuvjf6Mz/mmod/r6WOgT2+GoZXoqvRVdgXddsWN+
p9rrmVqmnrChppgbwp5v0Qo64a7rDAxopC500hT/VGBAP/QO7OGY/wx4hmO4
5u44qXzeU+v3yRuaj2sMcE6J93d6O7VyqdLrpV91dkg2+3I9l9jSw/pDb+gX
35Phn3kq/tuIhxjAw53fX+tx9eb6PmuwjYb9IOfU3n7fG/HTg1eUej/YHjmA
f97vCxvqAn2j1a0Fridyin6PLPV9/mf5L+QeHI+7gJodjF71/39EhnNzMGrn
QtQg7+hT5L5GeNaXOnZ6OfUw8z/KTE1uKHU7bLjP6Hec8R88ppdO
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwllElI1WEUxY/PWdM0n/rUHN5TSiNTEYJAQU0MGiysJEgqq0UkmIVDZGZY
NhCE0TwXQRQELWqREkFBc0SRVos2WkJl+3bR73IXF/7f/07nnnu+L7x1V0tn
QFIzFoO9XyS1BqXV0VJLqjSSLp0plw6lSPmx0s18qY1/ncnS6XjpLfFbOF+N
ktYQXxaRPsyXXuB/mSCNZuPDrpPbQIPGLCmzgnrE3qDHdJGUVyr9If4H56dh
8qi5HP8+8j+Te5SavxKlGawNbKOljuUw8Q9zpEnq1aZJ1ZybQtJ+8h/jf0O/
9fQL4T9CvXdgrGGWEHh3xkntzHSC8ylsiO9MclaWSM+IfzJbWke9efiWhbyW
zXCL3vew7llSB/72YubHDlD7N/g+MU9dhvQq4BjOl3sPq20cGpYNYGoIOKYF
1O4ucq4ykqRKzj3gnyT2UYzH7sCmoz1nKfgO5kk/wV8FZzXwcTzi3LQTsy3d
d2i7s52MUzvAv434/9EjTGwk4v0qiD8Jtj64i09wDsaof61QCsb6ji8x2wXs
NecH4LvL7LX07Eh0Dmw3E9k+u+2orsQxGrZKrAesvVgls/TKsazCvyTZMY0s
hH+sPslj0uGnCv4eM2t3qnP5nH/Rac6paat/jvQ3yjVmu7xY7Nhsp4bdaliu
zdCYy/5yXSum6Tb0cpn4qXifqTnHMRtW47yP2l1w9jXOe0SBfbwMDph1jH9v
qD1R5FwapuYS14xpxWYyLi3HYo1T42pToWvZODNtF4C5J8o1bnehPsu1aXei
GN924gcSXFN7wbMavP1Jjse0uaLEtW4a3V3kMeYzzMfKXUOmnUHmucP3/Yhr
y2rcZn9NQdfuN+LXBv0O2901zqeotxbOvwdcc0PUG8YGUhxza4bfWburFjNo
dyfkvSzmHPf3bNi1ZTOYtsvxB5Ncc5uZryvXtXqFenPJX4x/LMY1PRPxO2p3
0zRhuXvyHKvV6C/wGpZrO/zCbj6W+VtiO6oO+Rtlb5PVtLdhOM21Z2/Ef6Be
s4A=
           "],
           VertexColors->None]}]}, 
       {RGBColor[
        0.3231396826877461, 0.10908585686756271`, 0.5711922317809802], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmGts1uUZxp8eKLZv6dsySg8gpS2RWTmNZBQD2fYBCnIKMIfGOY4tJYFI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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3lslOUWxg+UIqWVtftU6HQqtJWZQVwgcVcE4oaK4gYipSBXjWxiMRhU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           "],
           VertexColors->None], PolygonBox[{{7329, 5143, 5142, 7331, 1837}},
           VertexColors->None]}]}, 
       {RGBColor[0.35568446383506896`, 0.165672442076368, 0.6169378587236668],
         EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl3ts1eUZx99Dy2l7TmsL2Pb0eIHT0zgp7SnDTQb7Y4niaozO++KkGwNR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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl2lw1eUZxd+SKIRIIMu9uTcLIcuQkO1S6kI3GbVUdLQChkVZIhgQW6sC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           "],
           VertexColors->None], 
          PolygonBox[{{8833, 8831, 8830, 6100, 2535}, {8102, 9005, 2657, 6280,
            8101}, {8609, 8925, 2610, 6230, 8608}, {8100, 9008, 9007, 9006, 
           913}, {7610, 7337, 7336, 6231, 1959}, {6928, 8218, 2222, 8254, 
           6927}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.38822924498239186`, 0.22225902728517327`, 0.6626834856663535], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHlw1dUVx2/yCMmDJI8YGhNQ4IXUvAgJjtqK9g9HrSyCiLghKGPjQu24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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJw1mHlwltUZxW8ISZNAyEZCSCA7fCEkwVYRtFPbSqtAaw1RJKyjkUU6VUjY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           "],
           VertexColors->None], 
          PolygonBox[{{8520, 10356, 3153, 10355, 8519}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.4207740261297147, 0.27884561249397855`, 0.7084291126090401], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1mHuMVdUVxjePO8zj3jsMjPNmZi6XZgZwQFspTWzaNFZkQBsgysDY1GK1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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3twldUVxU8IeZEHuYk3b5PcPK+BhLGVgv2j0Wm1ULQDlPKyVUMtYGeE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           "],
           VertexColors->None], 
          PolygonBox[{{11471, 11413, 1089, 6071, 11470}},
           VertexColors->None]}]}, 
       {RGBColor[0.4533188072770376, 0.3354321977027838, 0.7541747395517266], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmH1sleUZxp+29IPT03NOFVtKsbSnBQ+0B4YDGQanZBDZYICYiDiNghuL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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHlwleUVxl8SSEIWSG7IQkK2m5Cb7Qa1IIvUYrVTtspiW6FiEWxZJUzV
dkQQrZUdgcFhce0CLdJpQTaxtQgotbZliRbSUqZW6IjQmQoatrSC/T083x/P
3PPd+37ve96zPOecWzV59tiWlBBCcacQOvN5ODeEREkIteAQ8vLKEFr7hHAE
LENOxEJ4uDGEh0Atcrw4hK7JEBpzQmgCNfEQJhSG8F5qCGvSQmhrCOFCQQjt
4BhyjPd68XspyEO+KxHCPH6bC8YiT2gO4VtgVZcQ3mG//B4hjC4P4WA6+7Pn
Tex/I5iLvvMyQrhaHcLTTSH8JzuEk1xkX1UIe8F01j7WNYSPKkLow97N4DTy
fta2giNgH9jAmbvBq+Bn4DXWPYeez4LdyLV89gD5oDfI5ru6XtgBZCGvKArh
O+hzsKt1aEfXCyADY7aiTyN3OZ0XwoegAbmRz/1lIWzlPsvQ/2J+CAPZd4Ds
hFzGng/XYl/QC3lEXQjrsNNh9i4HP+b5/hpslRVCC89v4acDoIrzhuK/Bxt8
B+n+PeSt2HkI9/oS2IK8kO828tsGsAD5E2xwDkzh/TzsfQJfXuY+d2ayJsd3
D+z/eU/b4E3O3s6abWA/8kXucxu6DgEXkPuCx7DzWu62Bh89he5vcO4Z9D2U
7bs3sObeLNugHrmF9YtYv4z1U7HR+SbrcjTHsTGRc7/d4Bg5wLkfc24l8bEw
x76IEYN5xfbJHcTLdmI12d0xMBZ7jQGDuEYt5z/A+3N4vzvvP8r7I3geDlK6
WKdHiPGvsFcV938HnTqIpZ3otwNcQR6Gbcaz/zgwFHkce98NBrB/e6Zt8xJ4
MbLRKnReie1XgJXIw9njB6z/PhiGPJI1/2Of0bzbgj731zrHlFuTkRcTX0ux
x8g0+7iKc6vRZRfyqm4hdGHdHL57BHRGXoz9puCro9znPPu1ElNnOecMOIK8
ERtNwyd7sMVdrJmNb7K4cyZoQS5EnyLQP8c+Oc6er/DOzfjqMvb5fYXvIN0P
IG9scowrtjcgf4M7nkTvD8DXkSfDIRvJh3bexx1hasI5r1yfAm7m7v1AB77/
FTm0lj22g21gDZiETn3j/m0L+DdxkMF36eAs8vl69uKsMeAccl6ZY0ixcztn
PoP+L2GbF8Fq5PHE8vikfT87zWfpDhuiM09hoxT27QROIr/J5wfc459gP3I1
sREr895J9hjMngu435l02/x1bL+Efc5i3+MpPruSeKuosQ7y9QuVtr183oU4
2MsefVKcI3uwV2bSXHoOe73HPdfjr2Hoei3VXLAVf/RLNye8X28b6O7/AC+w
/jC2OASeR+5dZx/Kd5fALPS/k/3vY79UdHgZP+4A6/F1Zoq5L8a98/LNgcP4
HF3n3EmAnyD/tM7coxy/kfvei737ppuzl3DH6WAaWAxqWFsNHuK3v7DmXXy+
rcS14Q/ok18K52GPXiBW6lheEr2rmJYvxIniQvlkM2fNL7JtM4j/ctYcK7Rt
lvN8C7b5MmtvA4OQOypcA8T9V8BsMAtfTODsJej/Lu/ewB1WdvEdOvDPA8Xm
plH4Z2ax39HakTxf4/fP4rbdWJ7X19rmsvU65Gc4cwF4CqwGE0tdw1S7VpOz
xdh6HzbdC4oieX9Ui/SduKeC9wrSzUGqtYX4ryDmmnuFsy/FzVfiaOXyPVG9
VU6Ly76WNJdozXR+nwGeyPQacd9yMCPLHKi927jfsQqfsZe998Uj7iMnE8h1
0fPLvN9W4xog7j8G2vDbYHzyKuclU8w14swrEefMJJ4vU6M/yTRHbmJtN/x3
hLWp3RxryjHllmLul7Wuuaq1m2ud6+oh1Dso56ew18/Jt4vYZ3WmuXQg5wyo
MqdO5DMLe1enukYod7fw7q8bnMP1VfaBbF8H5qH/j2KO/WXsmZ5wzVStTEPO
Jb4+q3Zv8WA35949ze5NlIPPcb+OanP/V4Nj52rcsaEYmpsw54nrHk24l9rE
eb+IuadSLVbNVq1WTV5NvHyR/JhEflwEl9j7IjifaRveis3j+OoO/JHMMvep
ZkyOOFC1SjVKtUk1K4P1b+SaS5ozzM0XQHvE0TvQdxJntqW5x5qWax/JN9DJ
9Vj7b9y5oHhSLdsQ9UqqaV9g/5vAJmJ7Ku+fTphzxbUfJtx7JEFT1IPsxd6N
+Hl3imtYS65zWrmsGv14nmNMsTUfeU6lOUNcoRg8gS3+DuKdXRNvx9ct6H8i
spe473fg9YgD7yt1z6VeS3dU73kNW19tcA+qXmshWBD1XOolBhBf/cvdU4i7
T6HjyVxz+Nt8buP7MdiiFJ0WlTjnlesLS1xLOyKuUU1V75tAh9pS98DiBvWQ
6h3FEZUgrcC5JZ+X89wpz7I4YE5P1yzVqmOc+V3O/yv7plAL/4RPDha4Z1ev
/ucCc584VVwqDiytdg+v3r0EOQNumJXrWJXPepSYM8WV+cgnyKGZ2HQpXLIk
27Eqn8qXitmAPuPKzeW7yYHPscUt+G9XjjngBmxaC9/0Bn0K3avOivyjnlW9
onoW9SrqGbX2iupTzO88ATcsggs/ynYNLeHcadxjKuiJPL+HdZRuy7Ldi6kH
Ve+pnqxT0jGvWK9Cn4/r3BOpF9KdVJvqo9xXjRI3yIaynThCs8HaqPfQjKDZ
IZv4z4pHM4TOQc+7G93TK5fEGeIK5ZR6P9lctlYPqN75/ag2q4duQbc9Ze51
VYOeLDRHiBt+iJzCO6lJ664cL0g655Xr/fjuX+h9qsq99Yqu1kUxqNiTTsO5
78g6zwriWPUWneptK/UYykXZtGeUk+J+9XQHohogX8rH8q18qlwSJ2+Ockq5
Ix/Lt8oh+WYknyMa7KOn8d9bSffmh9AvE3+9gp0bu5uTtVYxp1jTO/XFvqPu
pp5Tuaiaui7KyYHoM6jZvYt6iLaoBoj71ZO2ct6QMnOPZhj1En1Ac9RTaDZV
z6ZeTTOqflPPq15XaxRrj7PHmWzHnGpp/7h7TdXLo4XuMdRbdJNpepijxTWK
6W9We2bSrKQa215mDhN3fYo8M8/fSZ6R515xVMy5rJ5Rsa+eVr2scmBbtWcm
zUp/ZL/FTZ7xNNtJx9d4/zjPbHW9Bg5FeJu9d6ZHNb3IPZt6Nc2gqh1Dea7J
dg3RbFRCPD3f2TOS9jpQ7bO0p2qpZgbNCqqp4tZJFZ61dV/NuvKxfKuZV77t
XuPeRj7+LTb9TaV7AfX8O4nFXXWexTWz/43fPi33bCwO038N12ekAv/noLv0
Q5FnM3yndbnmPHGdemBxsf5D0H8H4uRRda5ZqlW6o2Z55ZRySTP94BL3cOrd
1PM25Lumq5arBmm21Ayu2VszprhaM7JmY3H2fO7eVuVcU48s25XWmPtlw6VF
nsk0i6km3VrimqT4EIeLOzRTaJYQh2jW14yk2Ugz/3Z0Ky9276Ga8n9wB5N5

           "],
           VertexColors->None], PolygonBox[{{7736, 7748, 1931, 6174, 7735}},
           VertexColors->None]}]}, 
       {RGBColor[0.4858635884243604, 0.3920187829115891, 0.7999203664944132], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmGts1lcdxw+9tzwPFCh9VtrS8rSFB3uZQLMWYWRvJBM3iGYwVvACu3CH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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHl0lOUVxt/siwlnSDLDkgwkk2RmEjITUGuJLEetWlZpVZYgLS0gSyDQ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           "],
           VertexColors->None], 
          PolygonBox[{{4826, 7346, 7345, 7344, 599}, {8663, 10438, 3207, 
           10458, 8662}},
           VertexColors->None]}]}, 
       {RGBColor[0.5184083695716833, 0.4486053681203944, 0.8456659934370999], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1l21sleUZx++V0/OUnh5OAUNp4bTlHJAWyiEiGDNozZYhLgM2dRqrEwdz
kgK+Gz+ohUXAaBZEQXDo3hT4oBs4A8IHMS7LKvg21DjndF+YmCBRTFREwaj/
n/+rH+6c57mf+75e/tf/ejmTlt14yQ11KaXe76U0Qr9XT0hp1OSU3synNK0p
paNaY3L6rkO/1ZqlM1vrU/p+ltJZ2r875/1j2j8wKqV1DSnt0/ed2tuhNU/r
Osl8UOvuuMu9+XH+Hsm5T7q/KWpD71Kd+nTn0RGWebKS0p+bU1ose74oWNcS
ra6ulKZqfam99T2So/W+bD05MqU/Sk6HdCzV3i1a72n/q/aUzmhVZd9a7a3r
sW978/4+WufzsmWtfh8ZYRl/0rpX79Mb/M7zbbWUFrbax4VjU3qnM6V66dyi
97x+58jmFWXdkW2DmW3sq9lOdKHnB8nYguu5es50r2GkMcmNtLzZev6x7n5W
TelEo/CXjPnS93qdz+LrON2/SnsbhO1R7e8WVsWOlHpkb5dsHDUzpTWy63DR
mGMbNubCzrdk33P61qvfp/S7vN72bSj5DDYQn5X69lXOcsHihPZ/ISznSsfb
wQP8R+ag7L1L62HZfJP8fbrR8QXvzpnGnBjcnJkP/5woTknOFD3/frRipIdt
Bcd7Zs5+LZXvv9J6TXYM1puL8Gq27t1Rte6V8nuF1nrJfrglpcZ23z+t72e0
3qu3f8iGW9vrzDnwnyacu7Xu1PfjundEqyQ5v9F7W8QLnvMd7hX0/Ead/R0r
G/Z0+ttleXMH3sJl5KOnWz5/1Gg8O7X/StHvxJVfOH9+Zrl5ral63ixZh4Xb
hTNSWjDDMYCD4A+35yruu9t8btN4YarYd8uGVuHUUHM8R0hvndbTsuH+kuOK
bmIMFuTZ/4X5wATrwjZsIhbfhI3gc6n4/G6LYzagvYfy1gW/Ph5jjhX1PFVY
rI78zoLPcLN/rOOIPmIHnldK5hVat2bO6d6oIX+TT0+1WUeuwXqII3WFegGX
mmRboej8WaWz17eZaw+UfIbcvFI6ny9bL+eLRXPmX0VjDc7UOM5OV8yWCbOD
4uJ5sqF8dkovTXRewKOtLbaBHNilvdP63Viyj/j6V929sdm151bdWzjOMdym
vWtqxhMZL7ZZzqtF24ENv9OZ56abA/BnU5M5BO+oF2C1QL5cWzPniD91iBy8
oVvYd/sO38hzOIl84oxeuI5csO0ST07D15w59Aft/0/3VmeuVcO1j1/OD9Ub
VzBfG7V+eB8sTkftZ5+8AL/xPcbwHOXckdHmFdx7NfyFU9hGLnxYck5z/j86
/3bVNY1cRfaA1j+E2dKKbaXnbAl+kedwAtvgc1/walA4r5GcuZljyxnie6DV
vYS6Qq6Tt+Rsk4DPj3ed4w79Cd5iy7udtqc3uHss6iG+o3dF0Xzg/ZB8v7Nq
GycrXi+3O+/AFT1gRC1cHzYfyYztUNQl4oQO5K0KjtF/yHl4BU7gRYzPI8+q
tnVSh+NKTMs5+4D99Ihx0Wef1JlZOr+zwT25ELkwqujcII8K8cx+j84fbDNu
1PF89LeBzDGBe/Afe4gdHKeOw7edkcvMCfixJ+JIPr0TOfUznb+45t4zrJs6
c0qYPan9dtn5mHj9gNZmcXu+6t+PZhjvnib7Ru79O3O9oSdgy8bAZ58MOTjF
XF4cdYS8ow7Td9F1QHm3q2JfPpWsH2bOiQ9Vz/rbzeczsve4Vp++VRTTYovr
OT22KfostoMpMufq7mJxZq/2N0v2Jq3PJfuX+l3f4vjQw5/tdB//uXj4E71P
jzq9I3Cjpw5FDuyXT/tKnn3IG2o0OPNtVcRja6v7HHnzTMmykEPf29Hqffbo
B9tjLquL52bVyFLZ/lNbwAIcjme+h/yF+n5I9X1l5vztDgwXdbk2fVeXmrxP
XhPDv0QcmXuwHTy/VC/4YoLnLPLyokZzbF2LMSpHjcV3coTaVA4Ow39ii67i
ZM9h5Dd1979V5wg2LirbTvwDC3LwgsyzDjWVWntRl+st34kDZ+hh8AkuEf+P
xthmelR/9KkDRdsOr+D4zphDwGhP5EWHbLirxbwmbuggFtRPagF1oKNoXlDH
tyg+j9eM9+3yZV7VfIVz1P+2iHNPwTqI3fbgW7/uzdT9oZBHfiIT/48HN4Zi
DsDHr1WbH6xY/46wH9tOSW/vZOsg3+gX1CN68N7owXDySPDywrGOPbFgrv8g
Zntm1SU1zxDX1VwTqYcDqk+fVBzvZRXXaOrUTyXn83bH+e9l12jylfvwHK5N
qXhGoY+0x+zD+Rcke2iie/kK/h90eX6Cx/QKzhHz3og7ucP8Az8v19nLulxL
mHPzMRv3yf7eqmcc6svGqG/0ODgMVi/L19XN9peedn/MVMxiZ1c8j3F2X8Sd
uQNuwRNqFTMlfYq82B95jZ/MW3CSe/uDl3BsMM6viTo3L/ZWx/6JMZ69hmVf
EP4WhGdT2e/MRMxG9wQ25cDwhPhwuMV94JmoM+gdF9+/m99K9hGMyD8wof8S
i5NRK+j5V1WMFecKw/81Ms8WcJ9++Er0xCdUO2dHPwL/DSF/yQT//2Qu+3XN
cz95D6fhNvkFNmCHncubPT+BG/1wTqt7IrLpecjn3srIhW8BOj71Fg==
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHl0lOUVxl8gZJEEQiaTkCF7SDKTVShSIAKnoKhsxYK2LHKEqpCQoNZK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           "],
           VertexColors->None], 
          PolygonBox[{{6109, 7020, 7019, 7514, 1907}, {7124, 7906, 2063, 7905,
            7123}, {7020, 8105, 2213, 8108, 7019}, {6107, 7016, 7015, 7508, 
           1905}, {11839, 9689, 9688, 6438, 3516}, {7016, 6109, 1907, 7513, 
           7015}},
           VertexColors->None]}]}, 
       {RGBColor[0.5509531507190062, 0.5051919533291996, 0.8914116203797865], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVl1slFUQHej2Z9nulnbR/Wm3227X2h/aRkAIggmBokaB8GdLa8BYiGmx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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHl0VdUVxg8kmIQhJC95Ce+REEIgyUvyQhktBIVVUFwltUChVCbLUJeA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           "],
           VertexColors->None], 
          PolygonBox[{{9742, 7371, 7370, 9757, 2972}, {8107, 6284, 2659, 9010,
            8106}, {7933, 6571, 1138, 7931, 7932}, {6285, 8107, 8106, 9012, 
           2660}},
           VertexColors->None]}]}, 
       {RGBColor[0.5782880606937685, 0.5508101905033292, 0.909828548767831], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVktslGUUvbXzZjp9TGunMx2mrdMylrSlVg1MxdCEhWVBKAYNgkqoIdiW
kigGFyb4osooFDQuBIoRS43WUK1RKQhhYY2ulZWP6kbFGBOfG0P1nJ5rWNx8
///997uPc8+939+8c+/m0RvM7FdIOaRYZdYLmQqYHW02G8mZjUXMFvG+EWs7
lN7jt7DZDNY/oLsqb7Z8mVkaug2QXuils2ZP3WS2AXrrIP2QFdD/rtPs42qz
fNBsZUzfub82ZHbMbbYlzW7E+fcR2CdRs7viel6A76+w1kE6sVeM6J1nSjif
KTP7LG3WirP78NzfgbOQkQqz+kazGsT5SkBnz1eaVZZpnfPn1qCeJ6HTh1j6
IrJJPKhHTPrjiuduYLUK64VK2VuAn28hU/B1M+I/lVZMtEG8aOe5erPPu2Q7
EVPOjJ3fZ1yHfi64r2y18mEup5DTa1nhfiKoOBjDEbyfCSjmgYzZv9A/B7v3
oQ73Q/bD/w/I+0fIo6jRFyH5HcTZF1LAJae8i7XQRb13AOM7I7LLGIo415tX
jLT9QVL2T+Pcz9hvxNnhFmAM+RK1ehj13Q25AhwmIvJ5lhjCfiwj+5chs6jb
N9jfnxCOa6H7JPhSbFB+K/F8EPHtAE6/A/+jWdWI/GRszHc79rZAHgmLT4d9
//tO5ca83kjoG/cfRIzPoAafRsWnUrliI97nvY7kcrhDfGbd6Y+cKF9uNl4t
/cmE7BL3QFi8LDluzIe5vAj/08CoLSj/1B8w8Zm+aYe8Z66sI/FaD1uv4n1N
g7Dgt8cjqiE5cAz1WQMcd0e1x74slck3sabNEGJvSim2f4D3L9CPwO5l8O4h
nF8dFabUZx+NApM9kCvR63Zpkz2z0fueMeUDiv80YrvUJA4R+5mc4x9QTanz
N/z+lRE2W2CnPSZuc2XPM+878uI0+VyBdaxec4J8oj/a6SmY3QoJxoXNVo+j
lNIcIa7DsPdbSLxiX7W7fXKM5xhTZ0C8J+eZN/Fi7mnMhMcgSZx7GzEMpZQv
vy+4zjgwm0AMu4DNmYRqT2y7gedq4DaD/eMxYUr9g2nVnnXnzOvz+TYXEvac
n+Qv+UU7T2C/K6he4Dt5Mvn/6pyZR01fhs3ngeU4cD2SUc6Dzaor7XJ2lnye
sD8HwsqbHDzs8bA/Wr0XFhHnpowwof8DYcVwsqC5T24Ru2mvRSP4Xwm5BL13
o8p7wfuYNeHZe4DlIKQl7DglVM8ecPnrevGEOQzFxGeurB9r91EN+LoCNpep
1lxZb+Z5KKy5vQex7S1o/gbr4Ae+3vQ7oeh8vgVYbU6Jd9Rjv7G/Rgu6V9h7
jL0rrnOceZxNjIH3Fu1wzgQ8T+ZITrGO5DB7grVkHU9UiQe0F4oLK+LRHddM
o33D2Wted94FPRWapbwfmnKqWQ7xvgUuxWLKk3xkXoyFM4nxNDSKr/xG251u
n8/dPj/ZS1UxcaACtUpALoaVa7frk29Le0HdRYmscmNPv96gvl70WcA5wHu4
1XEbRs+OQLahNk+jng8g5vmo8lt0fc4/zkHeHeQQdbnPOsx7Ldhj11yfc7fX
Z2wStavtEEacR+xZcpixd3mObcDqHfitjOkO5UoOTzrXyFX28Z8t8jPt83eJ
w8A7k5OdCXyPpFSfq8hpLKXzVW53xv9JEm6fd93V/PX5tN5nHvFnzlOeE32y
1kszt1x9wfuFetT5Ka97iHcQe3TOczyLuLKN6tN1PjOIFf8nWDP2wsVq3W3s
4SGss0n9BxA73lPsa/bnAa/vObfN+OmH9zPfN/g/BH1sQt13ovc+jOiu2eV3
wHbEsy2nvUPonZpa5cWeC9SJn4yJsTFH3i2lgmbR7VhvK6gn2Pf3+h2dyeq/
kP5n45rPxIi8P+7zk5yP+TMxbHEcGdeY34Wcn0X/R2V/sv/IbeYx0KRciC85
xzuR/30vNau3iE3EZx1nC/fY+5wxSZ8z+5Djs2nlyBpv9flMnIk9+/E/59hl
qA==
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHl0VdUVxg9CyMCQhCQv00seiZlDkhasSgDFVVRowYoubRVQl6xlFQKh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           "],
           VertexColors->None], 
          PolygonBox[{{11078, 4558, 4557, 11077, 3250}, {6111, 7516, 1906, 
           7511, 6110}},
           VertexColors->None]}]}, 
       {RGBColor[0.6022160054354343, 0.5892557396817447, 0.9103740322088639], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVk1sVFUUPrZlXueXoVPttNP5e1Q7VV5r2AiExISY0E4TY2pwU8PCmCjT
0q5af1ZiQhNXRGShU0Rko8zCigvFQn/QYEKIbDRGE1s3JsiCsBBq0KB+X76z
uPPuu+/cc777ne+cO9WXZidm2szsZ4x2jDX8bCTN8g+ZfZoxm9luVkxo/kPc
7LsOs/FOs1sYNdj+lDZbxPd2zP8eNPsHYzOptdMYk/ATpMz+gP2XCHQTz2q7
5rkBs2+zZvcR94kRrPeb9QTam4jLJ/fd9L33e80eh90LMbNDsM2UsCcQLuIj
HvqutytuG559GFnM92Dvgz6z5jaza9i/0KFvq5gfxjOJ8XrV7E2M8bjOTZ88
72Md2jcBnM9VFJtxd3WbvVVVvPOwabSLtzvw+Upcfvnk+wN+j8s3Y43EtY94
qxn5J95a2WxlWBxfDM2+xiiAjzlwOJ+S/9kus89rZrcx74f9PfDQD/t+2L0P
XFcRq1A0ez6PXGB+BP6+icyOI1dzSfmiH9ryfLsxn4HPoZJ8bhXMPgBXx4H7
Qg7nLAlb8LDyxBwxB+SP660O8UHtMIfdA7L5FVxtVpTLM8A3iPj7O5VXrt0G
ny8Cfxzx1mI6x55QZ9mCLir4dgDzNNbf65P/I9iXS0ozv+CMz/aJ9xjOF0SK
QV5TcWmgE76DgvLMtYSvM29Rt2yp73HXcwu2H2H8FROup3cKG7mgDqiB76Hx
GxhXgCMqSZfkg7pn7RDnIvDvDWV/Dt+z3fI/5zaPtIk/6nAJeE4Az2RZmtmB
c7SwNwlcU+Byuiz9sI5Yd8Sahk0KYyQtbAcD4Wtg33SomvgM+5YwPoH9PGK+
llQs6mDeMUzB1grSALHNuw21QJ1RD+tJfeM6NfhkWnqnvn4MpbENt6GuyFnC
c3oWOfq4V/VLvZUT0hxj/pdV3FPA+A5GEzjHEtI7z0ud0icxHAY/x6qqG/Ky
EJN+3sbaRE65/S1SD2Ie9oHvk1Xp5TrWm8D6LnDvBZZjO9WbNvC8XFF/4aBv
1iN9U6P0vysjH9Qb6/RGRjnl2Rpey9RKy+s/g1jbI3FEvql78vYGsCznZL87
kr6p7Rb4OY/RBDdjWL8LPuvOEXNIfsjZM2mtXcb3gUjvT4HDRFn9jPq75jVJ
DREfY03uEL/klho8GkqH5DCVkGZ6ULMdqO2uQPWx6H2bPCTdhn1sKiXfp9F7
PqzpndinB4SftfhySTzwDOMJ9SL2noW8dNdAL9rXq3uDuql6r6577+J5mSfW
FmuDdXvHezS5Zw7YH7g25jphn2YN1zwXJwLlIw9sFxFvNFCdbMWkW2qYT2r1
T+ThZFF3BHvMZqT6PQfOBkeUP2JZdzw8U9N77FBO+qa2j4KPL3LSDXmrpzSf
wfpsTe+MSQzkh73hXkFa4rnrzhW1Rs3xnsjB96vDqlPW2YT385lQdU59rFSk
Y+qXdyV7BPsDa2s0Ep8bsFnsk555z1Rdw6zZTe8Dt3wvz0Lu1vwuI9e0Z5+n
j0tZ+bmE+Muh7hzysu79gXztd81z7YrXL+/5M6HqiHfLozn1rRWsrYbS+F3Y
FMrKBXPCd87JN/N81e9s+s96v1p3/wehwX+z0gE5OuD/M6jxUe+NxJ6NhJ9r
5ILrsyX1fWqHvhmD+HkPD5XFZ8Sz8m4L1GsX/D4gP23+H4O6q7r2Cv3aQ/uG
35Hkk/9flrOq11OI+XtRmpj3/slc8ByrwzrLV13SAddZn7xXySG1WcmL722o
3aJjOxvqfwz1Q+33FHVW9p5aUT2BXBZcb0NF3ZGsM9pOlmR/AZpdqqkH877t
8rj/A7qkS70=
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHeQV+UVhj8FFtilbIEt7C5bBBbYXRZLRgRM1NhAJRETSELRUWZUOvYS
DUVRUGNBo4MdnAiKEhtFwS4KRpIImEjTKEWpTiwUBfM8nvvHO3v2/u79yqnv
OTUXThg8/siU0rQjUmrO35u6prSpQ0obwTTkmwpS2tAlpfVgGvLfuqf0HLiy
TUq7+ea2bik9DB4CM8GkHilNBVPARLC3Z0pti1NqA/Yg3wbmd0xpHpiJvIq1
1oI1YCVoXZXS+40p3d02pekc6OXalH5ZmtIDLVOqyE1pHP+PB2tap9S9WUqf
s8e34BvwGRjNu09VpjSb98/i/dM5U24h64LTkHdzpyd4by7YhXwc5yhgvXxw
LHJv7vl1Pv9zt/6tUrqaMy7n+TJwFfKjoKQopWLwCHIXznoqe67grKdy5i3s
/TEYzdm+y+GedXwLXgFPgiU16JE7TgWLkf9YkdLf2ft9cD3yO6y7ooG/4G3k
S3qldCm4mbWLMdRm9vsEbM5L6TX2GMzex/D/KZx1M2d4lzNt5axbwArkFp1C
R+qmOfJY7jcGHGoeOnLvZzjHgpo4wzTs/il2+ARMRc5n7QKQhy534x9n86wd
//fmPFfhA2P5Zgw45oiwyfimlHqxViMYh3wje90N7gI3gIl8/zVr/w9MQO5T
n9Lr+NVr4HjkgwVhM211QN9DT6vASrAeNGDHa3nvGlCPfD3r/Jy9TgTXIZfw
vAZfqwbFyCObYk3XGoG8AZ0cQDf7wXrk7ei4JX9zwDbkTtiuvDJ0OYw7dUG/
pfx/Jrpqgw4uQI/ry7AxOB+5iXNWgyrQC7zNs5fAi+AtsBObP8A57wc76kI3
laAi09Hl2OQMznk6uAy5oTPPwRB850js+zbf5bBOC9dDHosO7uK7i1uHDZfi
w6vASrAELMYWr9RGrLzD79+z5+LCzHfwmQWFcSbP8jTy4+hpDef+EDyGPI81
/gLuA0+C/qAn6AH6gaPR4YPEx2B8YXU73sGG/TlbP/BX5EJsXIIfF6KvIvbr
wP9F4ADvl/DsD+h9G3ttBb9H3lud0mFwCOwBt3CGyZztT2A68qKjUpqBbm4F
LyGP4O/t6Ok2MBx5AWfpyd49wNPI9Tw7xL1+AD2Rd7D3HHT2iLGcF754Dr5w
dkH4ZD7n+MAYBO27he2ewA/mFoUNu/LOdtbdBrogP47dX+WcX7LeInQ6iHfe
596rwDnIj7LuYfR0CDyC/Kua8FF9cxDyFO48Cl+7CExGvo/vSvmuBNyL/BZ3
zjUPgjeRD3KOn/PuifptUcRKU+Zrxoy5bBa4J8tp63hnD/vsBmuR+7Hm1chn
4S+jwQus8y/2/Sd4HnkQ57wAnA/OAceg9yrQGRwNLukWMWesXYw8Ct+cAPbl
RI47k1wwAAzMjRxwBWfORz/tweXIq1ljfGHUijfQfx7vtgVN5I/5+OdhzrYU
+ywBh5A31ERNsBasR15YEDbSNs8ij8EHnmL/+WA08gGet2GPPLAfeRz3Opd7
/RqMRW7DnfaUsz/I6xq1YijvDekWNaOWd65FvgbUIJfyzlJ0tgSUdA1feZ/4
X1UZPrMZv1vJvu+BTchfE2tLQDn3H5AbttiJj+woC5s0wwd/hh6OA0cif8s5
vgM350QM7cenjmSfI8A+5Dc4x0LvCl4H5eilQrSKmlTPvcpAKegJHkZPd6Kn
kdhijPkYPfwODAVjQAn560R01R8UI++vjJpuLd+HXG1scI+aZlFDtvLeas73
AdiC3MBv96GXe0E98g/qEt3sAt8jD6qNHGtuPQd5eAm+Q+2qBMNKQre3ZdxA
HZtr3sjuZs55ldrWnTOcxd6VuWEbfe7izEb6hnu4tj5SSpy27Bi5xBxjLniA
Z/dXRE7Q9w7rS1Xhg9Zua7a12hremzvP51zzQBPyeZyzgjOUg8HIU46KGmDu
f4jz7KoKjiA32Ik8gt+GgN+C4ZVRm4xxY9saZaya48xtxmwx73QjDqdj7zM4
7xj8Yjt7bQOjy8JW5gRzgTbrzfOd2GaHcd4rcoU5wNg3ZxTwXiN3bQD5yH24
x0Hi6QA4HrkUm9Ry7xpQUh57nUz8nVQYexr7a8hlH+ZHDqjmvnfz7l2g6qjI
nXI2uZo5dA3fDMS2A8CHyM+zx79Z9yPwXElwG3O2uVqOs7B7cAS5gRxxKOcc
BS4CQ0Ajv01FV23IRQObRa2Rc07Lak5fdDKZczyI7j8iRxxXHTnFXHJsdeSy
vqxxaevIaXIpc4a5Qk51R6/Qsbq9HflG/o7EL0aAG5DP6Bg6UjendwwuKseT
28lJ5Q7GrLEqh3iU92ZhwztbRs6TOzTwrL48OMQs/g7DVrNbBd+ztpmT9mc1
7mB2Bvc+gHxaXeRYc+updZGb9El90Rz1VG1wDrmGnEvd9wN9MxvcWxecUi45
qy5q5dgs1q2Zi7nnp9jlE7AI+Ufu8DB3eQgcRn6Gc2zht8/BAuRF2GQDz9eD
l5BvL4+cZi7by30uwgcGo/dzwYXIb7JON77tCt5A3szzTdXBDXOxx1qedeC3
IrAG+RHWWsS9G9oFB1B39gByf3W4EZuXco4SsAF5Av4zDjTDNwbaY3CuL/Dt
7WBXceReOcFLWQ727NYEa4F3sDbPKYvewBq9rik4j1xnLfLC+tCJuni2PnLd
FGJhcn7kvCl8fyvv3gImZ9zEGND35SjPE4eje4Vveka5oBzA2i8nXEfOXM57
29n7C7AMeSS+2dQ6npVlnFwubg7fxhkmsuYEsBX5xeLwEX3jheKoJZOyXsqa
Mpj3NlaHro2h98qCA8l93i2L2lfm2p2iBtoLWPOt9fYEP+XyzHfM6Zeh8xZ8
19x9kHfjA7PY4x6wCzmPu+7AH78EucgVPGtlDBEPHcDcpuBIcqM5TcGd9mZc
Tg6lL+gz+oo+MR6cQp49GYwrCV/UZ/VVfXIdzx8Es8FaMJBn+/l2HxiAfCN7
/BncAW4AVzZEDjd3XwE2cb6vWGsv2Ij8WXnkLHPVf8ujd7NHsjeyh5M7n2KO
7BUc2t5Xji+3tweWC6hjdSsn0Pe1mbYyBtzrMPscqog97XXtMewt7Hnllp5p
Y8Yx7TXkHHINew59zR7Q3k+fk8voA9peTmNtmwlmZDXO3sEe0d7QHmJzYcSw
sbupMHpxOb1c3p78pIrIeea6X1QE15Szy9XlnN7dGDT21EFz3qutCPtaX631
Q7Pcbc2/pyY4vtzeHGxuMUaNTXPMj50jx5hbDiP3qIqYMBas8S3LI8eYW17N
idr1Mb71n9KoYZMao2f8qVdsjFw2Iqu15rSR2Tv+NqIxaqEcR25jTZzN3w/q
gms6Q7D30kf1TXswuVxf8vUJBcHpnD3IweRea7JeUg4td7anbN8YnFWuas8r
N5Zjyi3lyNremNmV+YDcrT7jZnI4ZxfLyYFVuTHDMJe967ygNHKavcOgjHvb
Qzg7WZr1cs5Q5G4DwJkZh5O76NP6shymkmf5oD2o6ByxIieQCxgz73Kvxeyz
CKzoElzUHsneSE46jG/6YKvZLaLHzS2PnsFe4bWciDV7+nFZzH3ZJXoqe6mr
8qL3fTvrde2BXyYPHc8aK3Oih11aGz2pvagc+ZvamNE4m7FneJX/l9XG7EQd
LWWPM7oEFxzfPmrHY7VR660hzqK804psJjW3MTiM3GUO8nXY7FqQ1yy+6Y6N
e1SGr/lsCr81dAjuYU7+R0HMIJw9rC6IWdGNWW5xZjS+MnSsbsdVRm4cRZ65
qCFy5PLO0RPYCyzrHLncGmNtMafP5NlvWOc8MAO5Eh95lph4slXkzzaNwSHk
DvZEU/kml7Vby0WdTTTGTMpZVF3b6EWdcTjbsCfV9l9h670l4QPtQNvOMRuq
Yf3ppWEzbeUMaWJB9ABy/wkF4RvqcE7mI/raDH67tTJ8Tu4zsCLWkgM5i3BG
5GzImYSzHDmXXMuZjlzSmmutlVM6q3ioe/QmzizkdieUBbeW41n7e3PXpobg
APMbggPLfec1xCxsXVYLnInlVsWM0NmgPmYvqA2WZT2hvUyPoujN7Wms7eYk
c5E13tjrn80yjMGuRcHR5eb2ZHL18d2De8jZrY1yGrmMNdJZjT6jrzizsVYt
BouymmWulqPLzc3Z9nb2oHlZj2evbc2dlPXc5toWHcMXzLk/1dZsfuL/cj97
YHtfOaBc2pmRsyI5tbM6Z2rO0pzZOct0puUsy5mmvmHPZq+mj8gNrAk/1YJO
Mdux5y3JZjzOUpxJOItwpmJunpfNgszRzjacoe7KZhzOfqxB1h5nQHLtkVlu
lnMbK1dmtdmY6VMbMyRnR/a01ayZ0xi+7YzG2V45a3UqjBnfDGx9bxYfcmxn
reYIc4MzV2cdzhAOZTMPv92QzQpd4xBneK4oZmnmuM/RY3lF6NsYlNsa48a2
HDc34xxyDWPQWJATygWNCXspY9pYtqeyd5Qj5WY95DD2HV4VudOe3FmOMzxn
d850nLU6A16czVzt9ZxpOcuy55NrOUNydiTnsteyJ7cX/yjr7eyJjs16PH3P
mJmX+aCxZA9u721MybXMKeYSOZe9sT3tzqxHdrbmzMlZkzM2e0N7fnt9e0R7
eTmbXM2e3lxmT2MvY077PxjNw7Q=
           "],
           VertexColors->None], 
          PolygonBox[{{7510, 4579, 2215, 8111, 7509}, {7242, 4707, 4706, 8272,
            1825}},
           VertexColors->None]}]}, 
       {RGBColor[0.6261439501771001, 0.6277012888601603, 0.9109195156498969], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNVktslFUUPgPtvP6ZgdJBZtrpY6ZjOi1MpXamEgQcgYiJZUOLm8ZHu+0L
Go1RUxPd6EI3shFIBBPDy0VbUaAtLQiEmAiFkFhdqDGRpTs3bkz8vn7HxMXN
3P/cc8/5znced/KjU0cmN5jZCtZGrIWo2a2IWbXebE/JbDdWkDCbxuHTkH0Y
MvuhbBZrM+uCbi1sdhL6d+rMlgtmBzLal1vNdmB9h7Ms1tcps4uwMYffeax+
2DraYTaE9V7cbCe+e7H+BIaJuHxRdhx3xgL57XcZdR5BpxIzG8X+IHwWgakv
EJZPwsJwFniu9JiFqAufVaws7DwP7EGz2U3orUE2Hle89NOTVKx9Kcn66oV5
FqtSrzgYz4su73c8xEJMIXDyQR7xpxFfTDbHsT4LyfaY729EFC/jeTcpHcZ6
oQh+sCYC8U67tHkIsoWnFGMaa2aTMJzPmn3frjzsRVyntwE3Yn8FGCLA0IP7
p7bpjPJizqwjpxgYe59zciWsPeOlbcZJ+6yFivOwC7Uwmhemk0nhoE4jsKWL
+q5FxfVXdcJ1Lits6xyndM78L0bF3VXkaAGrCedLkN2MSM7cHIaf/Rulu+T6
3YjjNuwORGWLfuqg8xH0A+j/jmL+BedHGrW/izx/i/U3zv+Cn4+xnzZhqTie
kbxiY1zzuPdPk/g4E5Zd2vkVNn9rl489fkb5Zeg+bjB7GFJNvVEQ9vHtZq89
gX1CPiP/+QXex2HtP00qtnV+U/LJXJSQt91tin0ZPn9sVQ28CpzX21XzbyXU
I6zVtyF/Jy++mG/GRE52wM77kA9B1hpXX/TCflcLfGAdBdfDLYqB+Hci9i+b
pEf/NcdAXqrea+u5iahuqUe77LWq1wrr5EJM9cV+7wb27a26Q7w3/nf3cFR4
SvCbyItrcjvovvg75Hv20qDntxN8v9CsmXAMebvcqHg5k+I+l2h7wO2zRrqd
E/Ycz9mznA2fFzQfWFPPlnQng/6IbhX+pYJqlPUZx5z5AvsNPp84p4iBvcAZ
NuM1zlpnHq8VVHPM9T3Mp/tYJ6CbAefFjHAdQhwvpdX7lF0qSE5M9EP+RxL6
5p74OBdYD+TyVqCYyP3tQLV0bIvZg05970L/DYP/n3A+Cflqp+6MIt6RdtUf
Z/R6/9frl7rE/zrOj2/Rm/AHOH+5RXWSRBxBWfPsLOyfySpvjOO5ZsVyH35O
ZYSt6j3DPJLXXE7ckjNyxxnCnqh5X0zFxS3rhHljXTB37IOuNsXO80nnn3OH
dsg/a5r9xz57BlgWNyvXka3KK/0S+ybHz1wxJ6zf08B7oEN22bfnYoqXnM76
bEzifNnnCc9Z67RJrtnPFe+PKcd/ArqJsmZ+c0480ib7fc3fmOEG6VGH7+di
QT1Fn3xjiJ/csAbJzzeNqvs6n43z/jbNQzZX0mxgnexNqf4b4H8zVm9SuPne
MEf87vYZyvdnzN+gN+H/ybRyMoP8/4xcrgaao4yfNmibPkLuf84xEGPN31/O
I9Yu63bQa4D9ex32VwqaHQPwM1vSHKPNfY6Z82PV3xe+edSlnG8g33vKSqiF
lR7dIf4Jf1tTZdmd9v8O/GWdMNdr/t79C+19EJw=
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHeQV+UVhq8FFncBd1mW7cvuUrazoJhYQIoTMRAhoYwmhhqYSSZ0OyqG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           "],
           VertexColors->None], 
          PolygonBox[{{7518, 7515, 464, 7510, 7517}, {7489, 8085, 8084, 4443, 
           408}},
           VertexColors->None]}]}, 
       {RGBColor[0.650071894918766, 0.6661468380385759, 0.9114649990909298], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVEtIFFAUvWrljA7mZ/I344zjqDM5jRotjMxf0kdqUVar/Ixu2kRlapRR
IAhRuyRa+MGCShd9qUikRQYZaFHtCmoRhEsjol1Q53AetHi8+373nXPueS/S
f6rzZLqZXUXLQBvLMbu3zuxHmllN2CyBthkLqXKzXrR5j9nliNl0qdmVDZp7
l9R8VZbZiNfsL86uYryCc2uIayuwr9DsM8YjyDdYaXYd69PIM4U2jDMLtWaV
WNuHea9PfTX23ywxy/ErjheYvca9z9I15v2M41i/hTsOIM9UqfBxjVyeOxy8
YwVzg4iXgDnPL16PcecjtDnsS2JPNs70QYe9AbM9AZ3p8ij3eJq0GfIqzwTu
mYxoTG6lmeJO/FmOw8eQ2Qe0P1jzboJGQe3rB4aecuHLRo4UWgB5ujFO4Wwz
8h2CTp1oTdlmp/OhY0h68u6G9aoRtemPSI8Oj3gzPhw1O4J2A3hnKjRm/BPx
QK44nsW5hrDuItYOp/mxMmBDGwLOyWKzXVHdR7zvY8JMPuEM5Zl3Y2KjVsS7
G3E38j8pkK7tG1UP1oI4WH/qeQka1+cpZn8urJg+4h7qmSqUh6jxLPxQ5Rdm
D/oxaLIMzm0414rW61HNRj3SiT2xM24hV7QezFUGlZc5X4FXlfMeNR7IF5cz
6PvKpTP5kSc534dXH9bKK9R7m1c+JN5lh5l+mnW+2JonnuRF/tRvzeVcdXEM
e9qjwlsGrot10B7n51CHu+C8gPxtWA+FheGr8wp1IB/G1JzvY6ZEeLZA+0W+
WcQ+eGrNo/gN5uoKlJNYWBdyZI4vXuXhHawb60tNu1x+ejTo+D5FDl9EY3Kl
r8mXegTcnoki+KhCealX0q2RR6Zf99Br34rktyXo1BJQTYdxbrJIXKuz9c74
/rKK5Wn6qCakOhH/iYTZ9zxpfwEcP8VUDzbWhvuvxfWu6NGLOBcN/v+vqDfr
8wtxjk/6vE1Kd+KMAe94XO+T/8fLcv0hDcj3O1cYz4NXY1h63YE2B/3yMjXm
GyB+erbVcWQ/Wqt4CrwSIfl1v0+6UqsHWB9yb5Y93zBj/s23S4WhvkBeIWb+
PfyDWGvm3u7u6gOeHXHN0+/8c+l51o1/N3XgP0ed6NWjUelI/ZpwrjkuXejN
UIX02om5xrj8xfELnzRkncmB+Pl/kBt5kT/fIusVRI7jCZ35BzX83K0=
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHl0VdUVxk9EJSEBTQIkL+N7ZHhkFgeoCEHFKgqrpIpd0qoEVqWrXSpB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           "],
           VertexColors->None], 
          PolygonBox[{{6968, 7094, 7093, 7110, 1738}, {6836, 8113, 2216, 4580,
            6835}, {7519, 6836, 6835, 7515, 1908}, {6841, 7519, 1908, 6113, 
           6840}},
           VertexColors->None]}]}, 
       {RGBColor[0.673999839660432, 0.7045923872169915, 0.9120104825319627], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lU9slFUUxW8HU2ZoO4yZkT8z7XwdMnUmwVDpolMCFkpNoU0MhrgBIxJi
ApqIIfinGNy4cW1JtFZYWYMt/gOJwUQTJSoxIUY2urBbiwtdQGLiAhPPz/Nc
vHzfvO/e8+455943jWMvHDyZi4iLWmu0ltZHfKA1WoxY7Y44U4h4RR9u1yIK
90dMdemb9u7kI04pfkJxE/q+mvPeL+u8/14jYrHh/IfKEd8ORvyh72OKb/VE
9Cnuz7z3cuTVI36u+z2X9sH5QXmdLOKQfl+tRjw9EPG26prVmT/e53ourjde
tcs13NXKp1rupPcjvcrV2qO86U0RQ/3O3yXs8cwcpguOmVN8bUvEvg0R89p7
Uty/2xZxS+dONSMuD0eMiEPhgYhhxS0r91VhPF5xXTcVd3ttxOAa8/46cUe/
S/2u+W9qV31b9TyXt9bo3ClaI/gcF2ZbOa/r+/sN103N6EfMi4q/Iezxtjn/
ozP3rTM25+ETGs6K028Jn9q3V1x/rmTtFhR3UvgvlRy/tDniqbI9/Wqzf/M+
Ku6fK38ond9JNQxIg5bir+a8N5r20eWtbvN9JnnG+zUwNpkHeE9sMCa9Rz71
vNFtHDD3i+P+mnXF+9paY19RP/xe8xlgHN9qnAXtP9c0BlrwBGel6H59tMs+
4zf9APbkoPHHy8YFkz7AG3SbVN5Mwbk3mIWK/X2n4DzeL2fuUWpE7+k0OwvS
9q+S+/O8vt/T+8N6f1Y1nsis1S31/qmSPUTLn+qumb441mPtxprWDt3OluwZ
ftEr7R7jb1e/nG46J6/3scw1w28maQj3I6nP4QQ35ou1t+h56Zen9S324pDW
Ya0h1fCx5uATrV7FnRH2bGYc5uDTzL7cFMeDqmGx2/26nHx/pO155hxmid4H
80Sv8Tlnd+Z8cpkPzhkpuF/5jm7M4uGaMegR/EVDen8q9f8FaTOvdVo5L+s5
1zZX+E2mHuC5N3Gnp/CcWg/U3HNohR/g4QVz+H9PdZqeB/ptpM/640Or4juF
+2SHnr/Wred14e1o+86jZu5YMOmFZmZezGMnzf5H4ni0Ye7weDdxARdtmMdW
Opt45utemjHuLGLpB85/vuEa0Hsk+Ui98ykGzdjn+9xG9diA3/EEjYnnbm5l
vpvp67k0F3D6ZtC84LSU7hN4LKX/kZ1au4rmyH3z34wqpk9aXagan3j4LySv
6Qn8Xq66j/EL/1aSd8zNYxX7PqGYPVVr8Kbq2Zm5v5nR8w3PJjUzk8z7Z4q5
0va9mK94nonhblhJ/2douZr0/F78hsv+L0GbcxutDxoz/+R+2O86qKGnYW7w
4h69VLVfR5W7u+z74UHV+OU263JW579Wc330dWPAui+melfT3TWT/EdDtMJ3
/g+/SHfO3TTDeI3GxOHvv8O7/e0=
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmGl0VtUVhk9QkShTEpKQBPgCZCSSQGwFtTIIKlJZglW7xFZBW2jtEkVQ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           "],
           VertexColors->None], 
          PolygonBox[{{6119, 7520, 1687, 6841, 6118}, {6497, 6977, 6976, 7812,
            2023}},
           VertexColors->None]}]}, 
       {RGBColor[0.6979277844020978, 0.7430379363954069, 0.9125559659729956], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVU1sjFEUvTramTHTac1UaceYH6OtMBVCtZFoS2NGE5qIhShJQ0IQxF+J
USK6sMWmFQtRSlrSIiFU/dXKQiMhaLqwq11tK5E6x3mLl3nvfffn3HvOfZPc
d3zHsQIzu4XlwVpTZtZTY7YDhw4fLrxm43PNWgNmJ3HeP8dsu1f7n7hvge1m
rHDQLFds9i4o+49Rs6ZKfEOc/pDZkRKzTr/Z1kKzEHwvI/RAhdkDrOYi5MTq
gu0HgOlNmmXLzd7jXBA36y4124Tvqx2WCdw/j5k9w7qHu0e4G/XJ/jZylqCG
auzXwbcP5w0e+bEW5iAWYqJfG3DmXK4B2L6vNbuGXGe8ykk8U7D5FZU/MbAv
4y4n4/xGT/4C4yv47kKN7VH1kT1shc1vn/Aw9mCl4udDsuX9JOwfVyjfeMJs
fcTsLfI24XtZUPsq1DJSq3hj+K3HeTf2C/B9xiebgkVmczPoFzA2xGVHmxM+
5WOuHH6zId2tLNE9cfah58vLxBd5ZYyrqGsUuF5jtRWJJ/6SO3IwVST7MfeN
9/1e6YMxUuDnxkL4uF7Oun5eQe7dAcVvSEM7GceFV/70rVps1hiR/SHYHE7L
h7obmiebvKuD+ImdmiOeU6ilCudGj7Q25rCRZ2qLXE9Wm10Km30JSO+rHV95
v7jtcvVRr4xJO55ZdzQl3MS8MSKsxNmBeqcWSjtfUdMXrJvF4rnVaWC4Qppm
P74jzs64amgB741YQ9ifc3NCzA8Re3CxdHcSdQ87ne9F/j1pzWVdWP5DTpec
QeJ87ZNGqc8Zv/rOnjf7pS3ORae7p81T9OFOUvmLg9Itcd+EZmvmy5f9J798
B9jjTwn1mX53nS/5ued4pDapQdq0+6R97qmprqj0dB09S8acbpaaHU0KH2N0
uzhHV5gdW6HayoFlIiUMp1B7Pib81NGyReKFPPI9Yj9Y+x9XJ3uddZqvi2je
ODvUEueBXL1ZBQ6BIYd9D/IUZuRPrn6kFMPjUx83uPeNfWZezmh1XH3jHTkj
X7XIdR71vijQzHKu2ZcZN8Pck3P2j3o7GNf8cCbaXA/Y/2mXm3GYl/yxdsZb
4N6KC8jzpEb6KcZ+NKIZYB29KdVCXYZczhHw+7JSb/Cse4upZ+ZhfcxVD61t
K1M+vjFdMXHDd59c/c9bKv54vo/+9SfFA2OfSysudTXt8NOf3LCutXG918x3
EJwcSEi/35aAi1JhuQiuJzC3nwPqV7vTFXXKuIyZ5fsZ1pyw35mI7jm79GO9
xEfczHUWuPJxzTt1wfeRujqdlA6ogf0J6Yx93pLWW0+dUMv8TgzTDgN55//P
t5Tm/R/zCAAG
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHl0VdUVxk+SCgmUkORlfO9leGQAkpAHQhnECmESoWChBV0gLVMNLRVk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           "],
           VertexColors->None], 
          PolygonBox[{{8255, 6987, 6986, 8259, 2223}, {6985, 4662, 2223, 8259,
            6984}, {7122, 7132, 1602, 4228, 7121}, {4663, 6985, 6984, 8264, 
           2224}},
           VertexColors->None]}]}, 
       {RGBColor[0.7218557291437636, 0.7814834855738224, 0.9131014494140285], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlkls1VUYxT868Dq9Tq9qBzu/2ibY1ggUddPECTWKhoQ2UdmghWAiRtRI
bBA10RhBF4ptXWiLJGqMRt3oQgxqWxcm0qaK0lJTKhtx4cYF3TicH+caFjfv
/u/wDeec77uvfddj2/cVRMS0RqHGUEnEmkapxhWtEXUamzX/sTxiV2XEgn7P
dkfs2+C1r/siMjURN6/z7yvtnu9fH3FfccRRza/JRnRpnJCdw9rfKJs7NN9Z
ETFWFfGc/D7UFvFwm898J5uLHRH9ZREDtRF3NkWsyM5J2btOa6tFEVt19u36
iBuLbWNNY7U0okBrnzdHvKozNYp3XOvfKsEjime4xLFxtrbS59mf0Nha6jXm
3BtWvL3yNaf1d7LOfV2Bz6yl8/yOpXmuwriB34hi293m2PK6W17uePZqr0c2
qwT0RuV3RFj8G8YGjF4r8tmKcs+7eyPea7ffm3IRPzQ6F2IhJrgg1teVW6Vs
Tml/Vn4P63u2J2JG46UKc3mxxDiD5ZZa4zmqO28UmqPdimekw/k+nY84oLFH
9vvk93jjZfyGEobwxxrzN0t8Fjt1V0fckOw/rlxfyOi72DESK/HXiP8TOcdc
n/c3c/JZrbLezuv3tyrnif1txcbhHp29W+MRrZXpbmnemMEVnK0It9PK42eN
a8s82GMdPp7POLbJrH1gf7lFOms1Tv+sNyZgAxZ/VlhvtdqfqRZvYJD1Huud
iV/4WpGdg9XGGZ45C9fHhN9ko3kJ6fOZZsdBHVyfamFZvCxo/K0z74vz0Vbn
PVhpzIltIukWvU1nbIOc8AO++JpXLHMag0XGjxzR2EnV1Dd9tndljWuM+qJO
3826Vhelt6Vef4ML9+FkRfV+rttnzvcLh37ztLDe+ILtx1dFbFJe92es0w8a
zDVY9acz2ILb0Pqz0sihJs/pI+wx36G8H8y71nfqd6nDNT+X7t4r7o5lzR+a
IMbVFOcd1f4mX7C80GI8OUc+6KdauX/abDvUEb5ZJ5ZDtY4B/Ra1XO458Ez9
ogvwQudjqd/A9fcZx4QfciVn7gwl/qgRetVI6glnlNMvGn06+4nWzwjzKd2Z
KXf/o17oCfQB5h8Ky69y5pe1o1mvr4qTzS32fzH100s13uo8yZH6m046OSU/
c72+PyB7822+B2ZgB47b6yI+a7D+we6BjOfUwVrSPH1rtto4D6a+Rmy3d0bc
1um6x/apZB/djqe+CodziWu0CY/YYW0+rVPbexPX1OOL5cYezMkR/T+6wf3x
/56MbXrIhHAtrHc9/tri2qZ2TuvsYrd9kAO5wOnL1a5bcIMPNI1W0Vx/emvI
kfiIh/7am3Mt81691WHO6AH0AmxSJ3CCHp4QVk+1O+Zb1Y+35PxWnJPPn3pt
G52eTbXPe3tXenO5Tw+4pDf5Ge9w3LlK50y+9Pf9qWfBAX2Autuj2Eabzf8m
2bulx3qcTLWN7Sfb/a5wfkJ6+StvrOnNv3fa/keq5Ya87ZLXtvSmZ5ucA/GD
98FmY44+u9Jbhq+pxO8F2TvQ4ZqhTw+lXk0eufQWk1s+YUjcM0n/X8j2UINr
cbnb/z+oW7Q/kPQPB12pLvDzR6dtftloTaNhNEW88Ij/4dTH19L7iE7wQw/C
F3pZSpqhDtAidv4Ddd5FTw==
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmGeUldUVhg+gSBGmMSPDzGX64AzMDHZNNCiCRrEkoGIiJhEskBULzUYw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           "],
           VertexColors->None], 
          PolygonBox[{{7155, 7467, 1882, 7476, 7154}, {7684, 8261, 8260, 4662,
            479}},
           VertexColors->None]}]}, 
       {RGBColor[0.7457836738854294, 0.819929034752238, 0.9136469328550615], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlkts1UUUxqe0pbfPeyt93LZcLv232AYpVWjqI5AYIyDShzUxgrrQhhbd
2Go0QYNhUaJEjbio7wUBY6JREVB3GiSAS4EYaQtthOBCjYmmBUxAxe/Xb4yL
yZ07/5lzvvOd75yZ5sGR+59cEEK4rFGoMdURwkhjCDv0Z6fGTFEI9xVoZEMY
W+z/v7SEcHBlCOfLQrhUGcKcxjmtb1wawiaNQ6kQ/iwN4ZrGrGwuLwlhOtqZ
Kg9hUqN0gc9MlHv9leYQXtZ4TGe2VoQwpLG+0FiOtxtPNu2zzMeTEN5K7Oev
Uv+ukL0LYNLZtZr35oUzF8I++S8S/ncTY8LHoxpbZGeLbI5Xef9wyvM+4dkp
Oy3a85D2tGneI5uZQvufiPi/Ft7DGju0r07fr+r8Ua1/vySEM/J1XX5/rzA+
sJWlHBt7Tiqm883m+FSp97HntOZ/VHjtTdkYr/f6G/rds8LfqmR3tMzcsp+9
+CpQjOuUm1eLHBf5WapvFztD+EljQ0a4tTYkHKs0RuQ/qQlhjTD0VjhOYhxQ
PrdX+f/N0kNf1vl7rsrrU0X+5T+8XGiTrzbndqYphJvE+Vfi8Abx36uzZ7X/
Hs035M0xHJJLeOyrsB1sDgrrxxozwrBcNm5bZK7QwnDUw0Cp55Wy86DsNVaH
8Izm3Yqvttk5u1Hz9XnHuVkxBP2WFPsMtsjDOn3/qNE20e9c2n5fFKaxcuNv
ku1bO62F4cR5heddcQ86JA/kA87R1MMV1lWPuN6kMZs2ZnyjsZ5i20NXE+L2
oPjpL3YMFxf67GDkgD3w2x+1xxy+Ho86JbdolX3EzZ6aZnPB/29Uo0c17qwy
Dnyz9wg6aLV+zgjDp1l/Az97N8v+XTE35GW9NHV3i2PFL9rC94Gsz3MWrbG+
NmqjJ+ppv7jZrjFZ5DiSiHNU/p/NOy9wuStyPqa9mchnfdrf6A/vif/irGtp
dZHPjQZjBi8afqnc+cMOPQBM4MFnf+SNfnUp7ZzfUWhb2MEP/sgpuboQz45F
m9TpbvH2a4u/wcfJDnMC170xR08njg181NyJjOuuP+taoo6ovQbZ/CdY+/AM
X2Ai7/SW7pRzhc0jymF33nGWtbr30e++VI3017m/zmp9rtU8dqVc5/jJaq2h
1f4mYozwid7hoUS+mmvcC9ZE3c7F9Q8b/Y11fF+LPFN/aJraodbnmsx5te6H
6zWuB3ouGkI/paqb2sXOKzqkLtDM/G/GvvDZE+uFfso9A+dg5p6Ak+86rF10
S910L3Ht0NMry70Of6yx/xHh2tvo/H6Wdb3xjR4EfvK7WlxOdvzfd/AP7x/I
z5EGcbXQ+SGW+bpTHx5K3JPpk3wnxm051wNxwXE2aoneh/bJNfN9sRY+1/4v
NN4vcXzkHszohn4FZuoIH9ifLnEtcfZEu/NNrukZaBgtv13t/ksu0Nl/tkeE
95167/shMS/YPyZ9bs25PrEzFWsL//Q59tC/N+WN/Uf1+LMd7t+ZrPvsUNx7
Kt5xnD0d7yP0x3d61LHEPRfNcA8cT5yH+VqM9UjvpJ7RWPUycbHMNf1bvbGC
sz/WCrnYp9wurXHsty/yncF9wTtlIGsNdUkjwzlrjNq/XOk5fZaYOfutsJxI
3K/IW328m8A1G+8F7o2t8e6gDuriPU7+p2NeDsvPoZzzNCp7TyXmdL9wrsrb
13B829BjxmJfoR6vVBof+aLHDsf7gnfWzy3xrZX2HvC/Lg3saTdn5Kcn5oi+
MRjfLWCCM7QXxEfnEvdV3ill8a3CG2R33jiIidio9RntfSHjfWjpXHy/Udtj
sT+/pvrYu9KcbpSNe/POy9XID3bQ+1Ssgfm7O2UNUG/UItxWSbcHctYJv+lq
z7viOwX8n/AOzHheUOueQj8hJt494KlR3p/PeT0lzkpafP+jA3ok+OnF8ANP
teiw03Pus1VRq7wdHmi1duGvK2IgDvI9f5ep797SYbt/a+9Uu+8J9Ei+yfUT
yv+2xLVBLV6J+U2if3o7fQtO6V3/ArAFj+E=
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHl0VdUVxg8kmISAvJfkkYG8l+RlfkmAMAk4lEEGlUlB0VZaZVJYqwoy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           "],
           VertexColors->None], 
          PolygonBox[{{8914, 8915, 2428, 8626, 8913}, {8267, 7685, 7684, 4664,
            2225}},
           VertexColors->None]}]}, 
       {RGBColor[0.7689898760962757, 0.8491185157398542, 0.9111822292072649], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFln1o1VUYx89q271zut25LXfndufuNVHcjKgoE42USpL5MtOS1EpDiyI3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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHlwleUVxt9oIgREc3PJSnKT3CzkJgQFFBcUC4jgAoISFStUJZAROiLI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           "],
           VertexColors->None], 
          PolygonBox[{{11108, 5712, 969, 6802, 11107}, {7313, 7328, 1820, 
           5399, 7312}, {6289, 7190, 7189, 7689, 1978}, {5713, 7327, 7326, 
           6802, 969}, {8266, 7686, 1977, 8267, 8265}, {7687, 8258, 8257, 
           8262, 1977}},
           VertexColors->None]}]}, 
       {RGBColor[0.7904787944894419, 0.8562844974314675, 0.9015552130240473], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlm1o1mUUxu+pe9WHbc/U9vLsmc/+cwycsw+WSihRaVE5X0BMndN8KchI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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHl0VdUVxk+ABAiJNC/Jy/wykTmBChStDFIGASsgrIKCmiijq2EVFAJh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           "],
           VertexColors->None], 
          PolygonBox[{{6496, 11911, 11910, 6981, 1489}, {8502, 5069, 785, 
           8484, 8501}, {6288, 9121, 2745, 9123, 6287}, {9017, 6288, 6287, 
           9018, 2663}},
           VertexColors->None]}]}, 
       {RGBColor[0.811967712882608, 0.8634504791230809, 0.8919281968408297], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl1ls1VUQxk9L6XJvy6W9twtdaO+9tfBAFxNtCy0EohBxgbaoQCKLEFAS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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHl0VdUVxk8GEpIQkrwkZE5exvdCIKEyy1AoQwUrWihElCGFWmAVWpcC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           "],
           VertexColors->None], 
          PolygonBox[{{8972, 8981, 8980, 7100, 96}, {10750, 5401, 945, 9823, 
           10749}},
           VertexColors->None]}]}, 
       {RGBColor[0.8334566312757744, 0.8706164608146943, 0.8823011806576122], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmG2QlWUZx2/3nD1n9+yesyfdZffsLrCcc1oW5KWYNLNQXEsHJ8XUwDQc
WCdFGoGhkT6I2STZ+DYCaqZmmKik1owKoqaYpWC86Eo2k5l9qNRGZZG00lKW
/r/9X8z04Z7nfu7nuq/7evlfL/czaWj5WcsaUkq/PyKljJ7fyKf000JKDzSm
tEzzmsbSbEqb9fHfGjeK+PxcSo9p3qg96/W+VfNfa2/D5JTe7fc73z/I+Pv2
UkrPafQ3pTS5yc8HRX+wNaWPNU4V/1n6/mmN4/RtQ1tKZ2rtKdEcqImnxvys
1+bH+lLxfTRkeGBcSvf1W77RKSnt07hDfN8/UrwHUnpb62vEc632zNWoS7+c
xnfEZ5X0a9T8MvGdp283aZyh8cG0lBaP9/dSl/hXU8qLrrk3pZ9NTOne0BH9
kGFX7MUOfXmfyXyLnm9lLO8VknN2n99PFL+TNDY3+9z1sTdT8DnI01aynKxt
k83Pkm3m6KyBZtvpNO25QX56tpjSVXreKvpKOaUXxed0rf1B4y6tz5XM1W77
rUvfqxrDyXRdMT9ack3qsU07ZO9Wja/r3B+JZ3fZvDfVZTPZoiyeg2Wf9Svt
bfyEdJhu2V7RmQtl659r/Vid26Zzz8tZD/TB5su0f4r2fi1ru6EDtoP39h7z
39GZ0iVHpfRPrTfJ3ks1/0Dzf2me77NdL2gzD2RY3mi7YBOwtrHRuNon2pkz
UxrXbDnAceYI+7Dcaz/uKBmjR4lmSOf8dabnYP0RfX9Y/LfnfCbzm4W17/X7
GzboDjuUS9YxK10/FH5GpMMVkmG2cHSLaHaJZqeex/RahurUlD6jcaewekol
pa+I7heS+0rZbKVo7s44Fu+KeFwrfhNE8+WISZ7QgLVdgZ/VwtQVGm9I/ueK
ti3f1hZsd+y1KGt+u0Vfkrz3FHwu/j+zwxh4Pmccj+G5yXlgOTErmz+YC/tK
9ky7aW8Tz3NFc4NoXs4ad8zB4P5mv4PTQy3GKr59u8/+vVo81xXsw4+Fgekz
PS+L/4GjbPsvSO/1st0vxfNzms+pGGPgBn7E7PfbvA8MgC/0Jd5bxPOeqv3y
Ud62uThkRLZVmp+sc04ZsK3OEZbP1lgpecvCSVuX9WtudO4Aw+SqzZEPv6i1
QY0V5Cede4nWnokcxRzM8Fwbc+S7MeYzdObH02wXaJZGPtkSOQOaMyVLlhyo
M94R7S7hYCjrvJWJXHFC1TmFfDJRsk0oOV7eEv03pdtDsuF1+n591Tr/TesX
a/2EVuP/Pa39WGf9RnZ9Qfw/bHB8Ef/4aKMwsK7Z8ULcNHR4XulzXiOnDYr3
yRpbm40dnmCT3I5cYJ5cA29yz+uT5ItJ5nusfPpZjYXad6jgPPJkMtbatX+1
dEyy0SdL/k7dYE4dwQ/4A/48Z8WcHMk7tt6rmFokfe/PWZZZUWt69RyvcT54
aHPt6dH7d/VeLxtXO8mrJcvDs7tkHELfG+vYG7sT43lhJjfRta4nfME6/mBO
3IGTBWXjcyDmk2MMRj6pxJwcPdrm2CO3QcP+Z+LcnuD5bZ05U7l4XZOxND/4
4z/8+HSyTrXQ607Rz5XNl8jmQ8LhEtnnRNn1gHy4pMu47tD364WHU/L22W3i
80IyD3gtzDr/wR+Zyf0vRf7/I7HfZl+OtHlODSdOr45Yxd4jsY5u6EhuoTeA
D34GA6yDT+x9V/iIvcyx/+F3egNy89Edzs+v9bs/oDd4U1jbNNFYJt+Phj3P
UN+ybZz7lZHAADzR6dawGzozxwbzxjsXk3+7wmf4YiDm2GGFYuQ08aznja/e
wAB+Hvg/v0+JOX3ThR3unahT1ARwfdh2T0buHQ07YD/seDinD8S5xEpHyXXn
tfDXnyPmbg/5x2Is+q6npcdflAtGW91nPdvpHmtLn/sn4vd1fX9Do6Fov0CL
fzMtXtum+Zv6/neNbNG8Dwb/ceJ5pbB0QcG0maBvbDEttv2HaH7baSyRY4sl
51Ke1CdqEzWqFP1DNnoJcl9WNesx4fbJnHMYumMfvpeDnr3lqMt8bw8a8Il9
0eVeYb7Y5T6lGjFCrjpJ+fDSGSm9WvT5xeBJ/FTD79dIhuNUB0dyxjh8wTPP
V2N+bc01Hl3wye3hF2oCvSk1AbwvDMw3yD7DotmT/HypZLvRl2yPXhosbA9d
yEs7I49h29+hr557S54/HfjdG3POvyNkgBdxgL+yce628C/nIsthXsQBZ+6I
c7H5juid6LPe6XOv1RvygFv0Qa9D0U9SV8AquGVOfgLH2IFYQI6xuE+u1UcW
Xa+xz8HA3mDEGvH3H+Huvxq9RZ9Rify8JmIE214r/77d6VqPzNASI/snuPYQ
E5eL5r1pPo8cxBqykBs6Jjs/0KdcHXEH5s4uuC+6Tv5dNsNYq4RcL0bvdHfB
/Ro5Glvuibh8LfJKJWoatprd4R6X+g8dNH/S2CR++bp7wTsCP8T0cPgZ2r2R
r16IcziPfIgP8SU+hQ56aMAFWAEP9BNj/A7HZtDTH7D3qcDMbZFDZqjOrJQ8
i1ucWx+JXqg36hG57iPZMld3Lc3IPoeqthc1pjH4c9+kF6UnHcsncRb9Ti56
HurZCtEVGr0fu2c1HxG/d6vuvbgb8Z07yIv6/rjo69wP8UuX6c+VfxbMcF98
ldbXaPyk4HvOxCbfO+D9cN70xDr5iHhHRmxPDUePI2qWhR6EvgSsgnswDZ7p
Ve+LfrUWdy5yxu5O93DYG7kaaj4LbG2N++Tx6lXuG2/5uffs7PS58+JuSs4h
1yAr2ENvbIDuyEPsgKcLxaOz7t4V++Er9ME/2Hh31OtXIm52Rp0ih9BT05Pi
u+kD7lN5vzzv/n513CP2BD6xDzLuDszuCWxPiXqHXbiLXBV3vfnKmUXVyOGc
8TkceQZbzo7Yf1w1cVe/6+AqxcXAZN+510ZfPVZDtfb5WL9Itlo84P3dcT8l
HrjPvdXnHEX9AX9g70vKx9fUHJ+b5NONnb7DVCN+n4kY2Rsxxr3kYJf7FnIm
ueHB6O3p2aEnRn9QM1ZG9fxwgnNARusNdetXjjsXuKL3AnfktzlV3w/pXfEX
vqIOrs67B8Lmp8edHh98SvLcVPbdrqh4PEf854j/qRXXG2oN/ceyuC/S7xKj
5EP8CC18NoDlHscN2N8W8fW87DFYMR6SaL5VNt6O0fyrPfYdff+jcVdBN3AE
5tcHXrHL8eP9H4e+Ah4bgk+lw/9r+FezP/pAsIg+6+K+yh5y0FNRK0+LOxF8
50UsFKNHwFbcmw+2+158tO5NU6fbZtSBNZG3uS8RE9xPiZtC7K1FP0sOPLli
/dEd/5Af8BFP7pDM62FXzloc8UAs7JPPRya4hhAHiyL3E4vcJzl7QfTw1LD3
au6BOJs8dn7IRD7BFsQOefT9muMRe/MvBxtwLjl0UdxnV4Ve7dEDgpmby74/
45fWXucXcssPy/43Qa6+P/DFXu6KQ2GH/VX/3yG30O9z/sLID8zPiP9e8+L/
A/8JRiIv8c/pvKmWtSPumMhEL7gkbIi8l8W5BenXUrP+3HGfrViO7rh/4Qv+
N1w61f8c+D83FP/o5sc/MuR8qO5/Vfhta/zLQDbkRrfhw/rmrTPj5ZCBu/K+
aaajpvHvAbyRF9gDzdhdKGcbIj/nowMxSj3B79ifd3ok5EI+Yoq6NBx7uXs9
UbctyPet7V5f0OMYg45/EPxzIBdclLev8fkTkjPXE/8FexzDyDSG5XzgOe/c
A0ax++WhL/9UuqvW7X/ZZe+h
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJw1mHlw1dUVxy95yXtJSCCQjZc972V9WXBGoGCHfatAK5IUGIGO4ACBmkAd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           "],
           VertexColors->None], 
          PolygonBox[{{5515, 6946, 1735, 10861, 5514}, {7498, 8083, 8082, 
           8093, 1896}},
           VertexColors->None]}]}, 
       {RGBColor[0.8549455496689405, 0.8777824425063078, 0.8726741644743946], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHts11cZxk9Lr79eYbS/tvQCLZOmFDZYJDo2GNSNZGgYa+sYmSsCwykC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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHlw1OUZx98cm82GrOTYHJtkE8hybE5xRmiFdhhJk8wUGARDCR0hkmjk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           "],
           VertexColors->None], PolygonBox[{{7532, 8285, 8284, 4717, 492}},
           VertexColors->None]}]}, 
       {RGBColor[0.8764344680621068, 0.8849484241979212, 0.863047148291177], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHts1tUZx09L+7br7X2LnRRLb28L7XqxOumUFiaIsI3hZhRGMYMsMlCB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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3ls1VUWxw/QjVeQttQu0P29R4t9rxWliLTOBMGWcSgaR5CSoRh3WkKN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           "],
           VertexColors->None], 
          PolygonBox[{{11076, 4556, 4555, 11075, 3248}},
           VertexColors->None]}]}, 
       {RGBColor[0.897923386455273, 0.8921144058895346, 0.8534201321079594], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmH1s1tUVx2952tI+z1OgpcJTaLE8raWAhSxAFrGIKIYBzoEC6oQ4FSrC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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmGlw1eUVxk8g+4ImRO5N2O5NLsmN2aaFwIiJBISCoFGgBiU6glWEsCjT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           "],
           VertexColors->None], PolygonBox[{{5025, 7418, 7417, 7434, 1717}},
           VertexColors->None]}]}, 
       {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
        GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmX1s1tUVx+/ztLyU52l5q7SgQ0qBtpaCiMAG40WSZXG8gyjaYik4N4fI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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtll1M1XUYx58DAgIHCjxwADM5B4jDDuCFbRaFvKwuyOUbWUtqDkOLOaS2
ao2mDZfoBg5MXrywpuXaSnMjIZ1BuVhaXPi2FGsNywt7wS6a1oWk9Xn8dvFs
v/95Xn7Py/f5/k5kffvqzQlmthOZg8yEzEYWmT10j9m+RLOSErMlyK50sx5k
e8TsaNQsnGb2YcDsZqXZG/lmnTg/n2n2RIHZMqQL3zXIgoVmTfiUp5rVzDVL
f8DscJbZaXz3Eq8E39+IP8j58wyzxByzKuIPY5+VYrYb3QfIHvTvINvKzV5B
jNhXg2bryLdvvtmNZHLjt415ZjHyP0Quf5LTIb7PVxCf2KPc+VXM7Hqx2ZvE
ehv/z7hrBJnANj9NsQ7cazabpphdfM/yfRL9DN9JIdXktcTJcQPxd2JzHV05
8ZcVmR3kt6VJ6tFF6juFTy93NWLzPuclZToPku/isNnZOHbop5AD84hVoN57
jYbtFnwGEtXjRmyX51ILtiNIIvUcLqQX6K9R06PUsgL7WeJ/Sn6/cH8bMXZj
e5tBP4L+o//tvcfJ2G4nxmr0OQHNPsiMtiULAy9h24qcpN4zibqrOqrYHiMN
+7nI3+ib6XmQ/MeJ10m8m4nKZTSq3npOD9ObgwvM+pntGPVswf5GXLX/Q371
2Dczn5XU0sZvr2abpS5S7GPcWcgsq/Lk6z1/Df1jxD+eqhy3ot+EvMzdrcSo
w3bHfM2uPkOz7UAupmnG2fTnLfDVh+1x9BPM7xIyjP0tYrSha0J602XTh/1+
MD/BfT8y48eZXxJ4/J5cj+C/knqepf7FQfXUdc9g80NQNn8UC5OORcdgV0Q7
5bvUTv457EbjQp2b+W2SuxpC2qUn6UE396fQj3WZqrGeWEXUuy9VGK4u1075
Ll3hvj585zH/liRhaD/n4TLt3r/0+yl6X0UPrwaEqQuc997PTqYIA6PUfo07
vg5oB3vx3Vom3wG+a6l1IqZd6uD7O2z/Ip9PvJf4fEz8IPVfQH8eiZNfa1i5
TSM/xzUD7/0lvptDwpBjxznEd9l3zHfLd3oN9k/Hhf1xcqjmrhfRb8D/hQz1
fhX+DwY1g1p0UWzqMsQBvehWkMNP6O7gX5MnzDnWfMfv2uYJK+6zg3M/MznK
/UXoO8l9bUS77xgYQh+kX2P0axf2e9DVEa+F3HPp+XixfvNzO/25laueeC+8
R5P4HkMCc4S5sbh2wnfBezZA/OlSeAX/cmSQ79Pk2I1vT4aw0MzMZgLCRD31
1yFfJmgnG0o0E5+Fc/hl8i/G591M5VicJYw5tjqxmcL+VIlm65zs2PimQnc5
RsLl6qH3zjHt3BUJa3bOYZvgh0H25wi7dYJ8vyCXsZi42TmhMCpOcS5xzDaA
pZGQuPB17JdyV02FZtnhOxIWZhwrPjPnUn+T/C1yTu1B1x3WbHzmk/Tq21L1
ymeynv5HsxTLOcVrnwqrVu9BU5k40rmxLyhu2pilWTlHXaGW6SJhzTljM7m3
I0Mp4vg8eldWqbfI3zTHygn6/VySMFMT0474bvhMnHsTYuJq50/jHEDOpMhn
Lf7vFYu7hvD/PaQ30N8+5/Bfwc/EfeqVY8ax4Bh07DkmnAudM50rnRP7yX1V
vmbhOfsup1SKq3ynz4HNsxFxTVOSuO5ySL1wzluerTfe33bHWC33teTpbfWd
KyD3/Ji40DljoEhvuL/djoEwunO54lLnoDvM5nap7rpbc0RvkL89/h/hP8l1
Sbc=
           "],
           VertexColors->None]}]}}, {{}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV02toz3EUx/GD3Kewzea6iw3L7QGSMbtEGmXMLZfCck0jRS1ClEtRCCMP
5FZyeYKhudZWw2qMXPaIPHH3CNFcX/8H7//ne873nPM93/P7/rMq1pWvbRMR
qX6m9Iho6R+xgJ7IidiLrcMj1iTow+4d0XFkxNKeEUcHREyn30ZEVPEfp5EX
sSUl4suQiAM0mf1ETBq7uVdE9dCI+oERL/BJvUY1bqCK/d5+fT9+8aXyauTn
0tN0LK3tHvHcOQ0Jfy4fSvEsPeK7/lrlX1A/KS3iNt2SHPGVjmI/pln0De2p
xjZ5lViIFvUWqv+Ov5J+ZB/kP4NreKt+R3ebLL/9sIh5NI3uV7+MbmYPpatp
Ac1V54O8MjkvaQP2q7sVP+2dpJfRyt91UMQls/7hjHTxeViixg6sx0lntJrJ
KfrZvLqJvyL3kx5rfIck9lPzOmaGfcy4N9ITs0+co9Z2PS3I0rf4/hnuab0I
Hdg7xc1Qdz6dSfc5b6/4JrUeYbeeDuvtJv032LcV1wbl9v6y/+A3au03q/kY
qeJnOaccu9g7cTU7YqKYab7xWVqZGbEW63DOWzvMP1O/a9jV1kfQLjUiX954
nOdv69xb7tmOXmIX8E9AmXtco9dRgxL1B3oLGdaZWCV2NTbKncTeQDubWxd0
QpO9EjWLMcYMCmkR6lGHz97/F1xU94m6RTSbFtPdfd0Rv7zLWrMu5CvRz1Lx
Fcg2i3tqZNGJcgpRgJXiiugyugJD9LGc7lFrlPxMe/nsDDqOnjWjFWrcUfOQ
eRaLOZHok7b4XjnyX9I6sTniGvVSam+q9zINS6xTEv9ZmuSOd+TexW0s5jvg
3FPusAmvzf4VRoub478yF7Mw3X9rNs03vwf6qnbWfXqUJnkPXdHoLTxEA/8R
/lfWO8T/B5TCqPw=
           "]],
          "2.8600000000000003`"],
         Annotation[#, 2.8600000000000003`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV0ltoz2EYwPFHJM2NoTnNYbMxsxE7uEAhOduFiznUIuU0C1dWy5ScxShR
iBlGznNMbcQilBBjuaKcD1cO04zm87/4/r//932f53nf93l/aYtXz1nVISK6
+fk6OKI4I6JncsQ8novJAyPepke8Q0nviLzciALkY5ZxFs/kYby9W8TjvhHl
Yo/0iljL1fwJ10ZEHLfebo8LIyNudo/olBVRNyjiEvLMFSAfHe2/Lc06j7B/
Lm6JvyzuqFrpYmo4tWfECnErUYo+4of2j/iZE/ELP/BKXAtn95HjDHv5mjoj
7d2lR8R58Y3OORw5qLA2xxmfuc9zvBga8RLNyBsQ0cTP8Qzn3LtNvdvudVjt
nf6fkLuLa7nWehGf4ll8kmdzrnOu0qcG47P2u4CLuOssJfYYyA3ue97cGdSL
K5G3Uc4MPm5car4Mo8QfNZ5u/hhP5Rqexn+ca1O/iM0Yb+6y+43jNPeqtcc+
5/jqjav0boxeHtKTQj7AB7HE2lJkimsQP4SXGy/DJDUmJr4F//OxVfwW/NPr
P/YrcP4HenQfE1LsO8S3NDzikRpj/c/B02ERd1DnHdrcJck5Xutjsfedinqx
qeJepUZ8xl/3T3KOVv+r5ayx1wYsRJa8XmhJ9FRekrzWTLXVr8Zvb1LJVbhn
/iWKxH/iDGvj1FjuW8nmCi7iKnukcLFxJ57MneW8t8dVecewB5/1rEzdD+os
4GbjBebLsB7J5t+4+yD5j3k0f+d16tdzV+PT3KpPPxPfXeL95BUmzoZ76jWp
ccN7FqpfY5zBV3gaf9HrRj35KL/cu1/3TTzEF/16YdyIfeo/sZ7ijZ6K7y5v
t/xvxuu4nQ+4W7l9fvBsMfvVWMSdvcUO86XqlTpfJXZ488OYr9fN3mQK/wcw
GrEM
           "]],
          "2.73`"],
         Annotation[#, 2.73, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{11498, 10347, 10348, 10344, 10346, 10345, 11496, 10342, 
           10343, 10339, 10341, 10340, 11490, 6082, 10336, 4965, 10335, 4964, 
           6077, 11953, 4238, 6593, 6592, 11487, 6076, 9197, 9198, 4237, 6867,
            7477, 6863, 6864, 7842, 7841, 4959, 11411, 11412, 9188, 9189, 
           9190, 9217, 9216, 12207, 4929, 10309, 4930, 8463, 8464, 9131, 9130,
            5051, 10379, 10380, 9295, 9296, 4358, 11115, 5726, 7985, 7984, 
           8556, 5151, 10382, 10381, 8038, 9316, 8037, 5194, 8599, 5149, 7730,
            5150, 7032, 8052, 4396, 7618, 8051, 8050, 9054, 6255, 7621, 6460, 
           7456, 6033, 7763, 7764, 7453, 7452, 7176, 4576, 7182, 7183, 6303, 
           7728, 5374, 7179, 4345, 6715, 6203, 7001, 7000, 7444, 11576, 11577,
            11575, 11579, 11578, 6243, 11722, 6297, 11721, 6296, 11931, 11932,
            8271, 10187, 10188, 7532, 8285, 7545, 7720, 7707, 6139, 7175, 
           5368, 7266, 7279, 6782, 11090, 4570, 11075, 4555, 9786, 9771, 
           10703, 10688, 5039, 8442, 8457, 11998, 12117, 12102, 4538, 9755, 
           7384, 7400, 6907, 7433, 7416, 5022, 11375, 11392, 11358, 11815, 
           11798, 6389, 4522, 9737, 9720, 10671, 10654, 6646, 10620, 10637, 
           9668, 9685, 11853, 9703, 6435, 11323, 5991, 11305, 6009, 11341, 
           5005, 11285, 5973, 11267, 5955, 11781, 6372, 9651, 9633, 9615, 
           5352, 10603, 6629, 10585, 5334, 9561, 9579, 9597, 6416, 11231, 
           5919, 11213, 5937, 11249, 4987, 11194, 5898, 11176, 5880, 11763, 
           6354, 9543, 9525, 9507, 5316, 6611, 4279, 10549, 5280, 10531, 5298,
            10567, 4841, 7361, 5862, 9078, 7861, 7880, 6889, 9172, 9153, 
           11156, 5838, 10261, 4815, 10513, 5262, 10475, 5243, 10494, 11928, 
           6518, 12018, 4684, 7829, 4703, 12037, 6537, 6761, 11625, 11644, 
           9353, 9372, 4440, 7638, 4421}],
          "2.6`"],
         Annotation[#, 2.6, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{6092, 12067, 6093, 6594, 6595, 6090, 11499, 6091, 11500, 
           4971, 11497, 6088, 9201, 9202, 9203, 9222, 11515, 11516, 10286, 
           10285, 4850, 6446, 11863, 11864, 10310, 4931, 10311, 4851, 8372, 
           8771, 8770, 5495, 6946, 5515, 10082, 10102, 10122, 5777, 10182, 
           10162, 10142, 5535, 6710, 4317, 5595, 10941, 5615, 10961, 4897, 
           10921, 5575, 10881, 5555, 10901, 6966, 5635, 10981, 5655, 11001, 
           4871, 11061, 5695, 11021, 5675, 11041, 4337, 9263, 12205, 4770, 
           10229, 4790, 12255, 8347, 9002, 11693, 11713, 9425, 9445, 4494, 
           7682, 4474}],
          "2.47`"],
         Annotation[#, 2.47, "Tooltip"]& ], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV01toznEcx/GvnUzIsDkMw5zm7MKN5VDDFGrGE7tAbRdak8eFFEYuDcNy
vNCQ5HCjsJQrKxeLmGYkigvDRjlGjy2n13Pxfj6/w/f7+f6+v9//mVizfW2y
X0Rk+lkyLmIxGiZFXMmL6D854oBx7viIuuER90dGtMyJOG1vkbhT9Jb50tER
bfbK6E3zk9YX2j9OLyOTTwa28KguiTiW9uaZg2zUWH8zN+LDhIim4ojeWRF9
+IVPfGt5DR4akeCxDjNnR8zAVrUOi2/EIXwUm5JTLb4Gg0ZFXLQ+kF6ih/WS
lLPCOQ8Zl9NKcS/lfbVfK+4T/YLPyFazQp01yBKfg+y0h7gMmol/4vrRwA59
ncdf419FEcv5HzTu5F+hThMtor/zIwaMjbiq9zyaURDxfqI7N18/Rq/WBqG0
0P2l+xBfQBvlJ+w/5r1X3X2ox3c9d9gbodZ+Z1sp9gSvc2I/G3ehildS3m60
WL+GZusJdbYNi9jo7neZT7NfiD5+OfZSalfTJPbxqJwZ8cK9lNEHdMFUb4H2
6RF3cd1b9vLK1c8rd53wrstxR2yhuOd8utHHK1e9lHGznKQe9mMTpsorwA+9
XJOXKy81hTf/Zvx0r/W0EfesP8Vq8e9psb1SHlucv4Tuoqtpoxr5NGGeQcto
lpwuNW7Ku4Cj6NZvHd+3fKroM/Mq63XYiyHWX+u9SP5DOi/97dA9/O/QAeZX
aGqEd/HddPAvlzc/fTbc4/eEx23fyXz+582L6Q1aTnu8Ras7eSd/p/ds8RZt
6HFfneatOMH/kf18/6V28Xnyjsj/aL6H/qFn9LZTnW90lZiTPDbTLG/RYL2W
X63z1aPBf+osNrjrZ95kGf0PHCahUg==
           "]],
          "2.47`"],
         Annotation[#, 2.47, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV03to1WUYwPFnTl2Ubcu52bGsnZWXudwJcqaF5kipKcTY0QZdwCliA0+Z
mHPekgrCzAiV/pBNCUmHKGghLSgn6gZ2gVkSEWuUbhNrukU2FDT6nD++5/t7
nvd9n/d6kiveqHs9JyIa/Dx7X8TFyREv8r5HI97HppkRq7NMEiciclMRr46P
2PNQxGIeroxYL/8J354e0Twh4ip/yAXlET/oUyT+viRid0VExyMRP+KKel1q
fIH14j7tHQ/K67/IuOPGJ3k/P8EnCyMumOdMNj9FDovQfX/E39Y3Yvwh9e+a
GNHOzUURQ5wSf8eT+TfOV2OzcY2ox0X16tW/LN/IA+Jd8gdwApfUz7W3auNz
HotIcxHvVH8JN4mn8Sqey0l1+o1bYsxPfAY71d2EG9pa+BhG5POmRrQ563/M
MUH/KXhFjW3IoMUcI84kz53ccl4Dvn9Gwrh24xa6izR6jMtLRtwsVduYU9lz
R7l+c3Be32p7/4VreYtaGXWWY8R+x/At60+4i6loMt/Laq1xF2ltLeK2B9wV
NmrPoF6NS/LX0Cq/+2FGjfgr7+Y4DmObvXVqL3bH49DqHteiTu6AOM0f6VPP
VeJl3GudffbTj+3meRvrrOOOta7lxe661jw1vEP/OfKj+Ut7P5udn8eKU9Zz
t5r3YIPvJqTUrtOnktdZ35tY6v2k8bx1fFYWcS8f5Hw+xFedzUpjJupbqEaB
/GH5g/IXrG25+Rq1N/C75noPg87oGq5jtrYn0aH/7+71FP/Bc+UWeBNrsu+L
M3xa21Pyw2oM4az4sr6r1R5t/j7f/Tgnv8L/6jX5MfIDclfQKd+FRvk/3eEg
Ut7IX/w473H2q9S9bQ8zxXe4V98S+5pvT8+gGgtwXt8q5z0bBfaZKI74z7sa
RL64bEbELLR7Y9+iB0ey/0Pei3dQYUyhPsPmmKTmPPG/5sqzngS26j+PK5B0
Z7Xaa8xXpv5Lxm0QT58W8TRewDf6F/MoDKm/Uvtz+uV6Axn+QNyg7S3swMf6
d/IJtGK/9iq1e+ztV99fG3Odu7nUGtu4S7ydP+e9XGVdo9Tp813CN3msvrP8
l+aLx/EMLuVhdSvdx1Fn+6n/zw1znuRe8T57LHf2R7210+jO3id2eYs53kkz
/w+1qN04
           "]],
          "2.34`"],
         Annotation[#, 2.34, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV039o1WUUx/GzpYuKZbvOmmXuXjfnXGmRY86ykBIx04SBsx/mZIYIjX4t
12Yus2jWHOSSAtkMK22EgRbCJKexUCgtVjNTWVK2JtXMWbZcVNDr/vG+n+85
zznnOc95npuqfqLi8YyIWOPn7pyIYzdGLKFbCyOa0DAtYlWa69njIzJviViW
iHh9YsS9dGh6RC3/G/Sf4oj63Iif6SZ69dSIL8Qk2EevjWi9KeJgQcTXOKve
YTU+Qi273/rBCfzi58rbLT9Jt9Hb6N5rIr6yT3faP5kPc9GTF3FBf8Pyd6p/
+XURnbR+bMR5Op19hE6g39FsNdbKW41KHFOvUv0f+VfTAXYL/1vYgzPqZzrb
HPlxc0QFTdBm9RfQOnYRfZSW06Q6P8lbIKeXdqNZ3QZctNZGP8Awf1ZRRIdZ
/2GPseIL8bAajahBmz2GzSTLnYyY14Dv48iT1ynvHndRgT55WamIS0m15RxI
zx3F4mbiM7FznP0EXUyfU6tGnSoMO+8oOqL/PHcxGXX2e0itx9xFhbU2dscN
7grPWq9BpRpn+M+hnb81n2I+e593sxvvodHZDlnPdcdd9C5s1O8Ks9jO9w7e
xmZxs+gdKEM5ZuJ7Pb9or/vcb0IvC/W1CFf6nqW/ZvU24ddJEb/gAT2MZu8z
hxf0coW6/6bfjffTwP8pzdHX0+ZV4OxP0UJ61B5HUKtGDl8CY9QaYH9sxl3Y
j+XqlXlvVfSstUFzu0zcKOxQeyN61Wmm5/Q/aFZrxTVgh9iX+ZowxH8BLeLK
9bmZfiPvOBr512G5/80jWIZ2Z3jX3H7n/1bMD3pZ6YzPs9fjJN8JtKpTrf5K
jOhxotx8JLFE3CSaQrlaf1s/oM6t7Gy1StNva5wZ6nUpiszgS/4yWifuTTQh
Ye73e1eZdBW7Umy382fRv8SeljOPvqTuUtprrR8F4jd4f6X0SflV+M87HUS2
3lMlETPQyf85+vB++n9Nt2ADSvQ3RsyQPcbbbzb7z/Te3kQe1omfTUuQdN+L
rc93rpT6D8pbw54yJeJ2LEKX+FyagfPqV1ufJy7Tm6ihr7JXWHsGr+A18Yfo
HrRjm/VStfvM/ZTv/XJ+oz00X48d9DB7Pf2QbqGl+spQp9/3OHqJjhY7w2zu
ZF9Fp9J8OqTuNO91lzlvN7eL9txLT7O3OmOxe97lPX6CHnH9aPGfCXddT/8H
wvHoCg==
           "]],
          "2.21`"],
         Annotation[#, 2.21, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1H1M11UUx/HDCitHLcDE0gAFRRJsSeXK0AVjZiWFixY94FPMLbY0i7A0
BZwVsQqwlgHWRsWabWJz0pJ0bLr1TOlaa0TOyEarpEmky7XZ6/fHm8/3nHse
7j33/pi5Zv2Kx5MiYrs/t6dGHL824j66KzdiBzYVRtQkuIZ9dUTS9REPpUW0
ZUbcQcfmR2zkf42enxtRPyVilL5EL8+P+FJMKvuLqRGt8yIO5UR8i1/VO6rG
h9jIHrF+aAa/+FJ5e+Vn0S56A91/ZcQ3+gwk/LP5UIrBaRF/2d+E/HfVn5QR
0Ufr0yNO00L253Q6/ZGmqPGMvHWoxHH1KtX/mX8dPcVu4d+NXpxUP8nZlsi/
IL+CphZENKu/jNaxZ9O1dCHNUucXecvkHKMDaFZ3E8atddAPMMGfPCeix6zP
6JEmPgcPqrEFtejQY8JMkt3JOfM65fs7ZMjrk1fiLiowJC95ZsTZbLXlfJKY
O/LE3YxPxS6x9+9pOX1WrVp1qjHhvBfRc/af4S5yUadflVqPuYsKax3snunu
Ck9br0WlGif5/0Anf2sWxVL2R97NXryHLc52xHq6O+6nxXjefstojXmU0xK9
LlHzHTGvir+VTmLfyT9V/za+S9mNej7BjqvUo3fJX8u/Vc9tWCPuDblV/FX2
skr/Gc7cby0HFd7JClwmZoPYJr5GtLGXy2mlO9GOG81lg5neRJvpw+b6r17n
0e0tbkZK4ix0VPwJ/mI1mnx3m+VvsyJW6zFKV9FSey/Bc85eKa7APgoxH732
cICvD4tRrVaLuh/7bk68DW8lHW86S43YDvqItQa1qmmj+AZ08jfR7VjJ32Uv
b2E3Uq297Bxp9B6zKcc8Z9vGd9B+f/Le+ukJesa9F/jNHvC2Jpv1kLdU7B0t
xr1+Z496Q+PqLNR/n/jD6MYwvsZXZpWbmB3q1HgdO5Cq7nI1kmgNu9JsBuwj
mf4jdlheGW3S+356zNoIZolv0LOIrpdfjf/s6XekmGn2dREL0Mf/GYbwfuL/
AW1HA/Kd4woxY3pM028R++9Eb28sA5vFL6L5yHKv5daXemPZ6j8g7yn2nLyI
W3A3+sWn08Bp9VdbLxOXZKa19EX2SmtP4gW8Iv4I7UUnuqwXqT3knn/wfVDO
n3SQZtpjDz3K3kr30XZaZF+hzojvKfQsvVjsArO5jT2ZzqWZdEzdAu9/jzm/
bW7jeu6nw+xdzpjnTezx9g5jUNwIWtzpBe+rnv4PPNLtRg==
           "]],
          "2.08`"],
         Annotation[#, 2.08, "Tooltip"]& ], 
        TagBox[
         TooltipBox[LineBox[{5713, 7327, 7313, 7328, 5713}],
          "2.08`"],
         Annotation[#, 2.08, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1G1M1lUYx/HLgpWjB1CBwoBARVNLJaOy5lIJaUZSYVabrRnD5IWIIVbU
XGVptrixcg5otFYsbROLoi3TsUnZIyXZw4wXRlZbBS0i3Vqb9LlffPn9r3Ou
p3Odc1Owtu6ODRMi4jl/bsqIGMiNuJPumR6xDVuujKhOksO+lOO8iHsnRbTk
RSynI1dF1Ft/kf47K6JxSsSv9Fl6wRURn/FJZ3+aFZGYE3FoWsRX+Fm+Pjne
Qj17yP6hy6zzXypuv/g82k7n0+70iC/V6U2uz7CGpei/JOJP/Y2Jf03+1OyI
Hto4OWKYzmV/QnPoDzRNjofF1aAKA/JVyf+j9Rp6ir3T+svowkn5w9kWiz8r
vpKmz43YIX85bWBPp2tpCc2T5ydx5WKO0V7skHcLRu210jcxZj2lKKLTrP9S
I4N/Ie6Rowm1aFVjzExS3MkZ8zrl+ziyxPWIW+IuKnFCXEpBxOnL5RbzQXLu
KOJ3DY7yXaz3b2kFfUSuWnnWYMx5z6Fn9J/lLqahQb275VrvLirttbI7p7or
bLZfiyo5Tlr/HW3WE/kUZez3vJv9eB1NznbE/iR3fJDeiKf1W0qrzaOCLlGr
DKnyrqC3IFPdiewJmRGPyTmuzwxraXK2FTqvvLtpKm2nzea1jq5Hwvdu53nQ
9zdynKf2+disv43iN1lvtV9H67ERTfrIMZ/VfO5CwpttQaG6dWZbQPc684De
rjPj2Xq6nu7ms8/6zWL65PkQy32X42L5uvhdRFepW2atyH2l63kvv8nsavt9
1ob187bvbpQn3zk6vfl53vZHfI8m/fWRiRL+U+i1dKrc++X7jl8XXSf+F+s1
dKGzv2LWzXJ10AR91/o7uI3vfDEr6YKk+v30WL+d/ZQ5V9Ljan6NJ9nN3sJ2
Z0/wWSnvMuTyudpetjtqoR14wSwe8MZG9VWi5gF3cRivYhBf4HNzm6b/hWjQ
60vYlpyLGrd6r0Gr2VVq95pRCv2H76C4UvqEma+ix+wNoYD/VjWL6Qbxa/Cf
9/8b0vSTP9sZ0WP9Y5zAG8n/F3QXtmKWM1zIZ0SNbPUWsf9O1nbmLDzKfxGd
hTxvpcJ+mfPmy79a3EPsGTO9DazAQf6T6Ljcw7jffim/8I5q6Xb2ffY34Rk8
z/8I7UIb2u0Xy33CG/je9/ti/qD9NFePnbSP/Tg9QHfRYn2N+x7yPVm+0/Rc
vgvM5gb2RDqT5tIReed4k/vMucPcRtXspoPsPc5Y5Peyz7s4jH5+Q9jpTs+6
/0b6P3rS8Iw=
           "]],
          "1.9500000000000002`"],
         Annotation[#, 1.9500000000000002`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1HtM11UYx/HHcLOoDTAgKSBQkZIK0bCsuTRCl1Ju0rpstJaMFn+UFmHG
ytUsRTOycog2V5lrtnnBZlsmaTjpamI3A5aCWpsXWgS6tTak1++PN5/vc85z
O885P/IXLV749KiIWOPPXWkRR3MiFtLmiRErsPTmiOoE17KzIkZuiXhkbMSb
uRFzaD97ifW36b83RNSnR/xJG+mVN0Z8yyeF/U1mRFNRxL4JEUdwWr6DcuzC
Enaf/X3Z1vnPFrddfA7dRIvp7tSIH9TZn1gvsIbZODwu4i/9DYrfIv/oayL2
0PqrI87TIvbXNIt202Q5nhdXg0ocla9S/l7rNfQUe7X1d7EDJ+QfkX+m+GHx
C2jKTRGr5J9L69gT6OO0lObIc1LcXPPopPuxSt6lGLDXQj/GoPWkSRFbzfpv
NVL55+NhORpQixY1Bs0kyZ1cNK9Tvn9Chrg94mYV6wdd4pLyIy7kyS3m88Tc
UcDvVnTwnan3X2gFXSZXrTxVGHTeUfSi/jPcxXjUqfeQXE+6iwX2Wthbr3NX
eM5+LSrlOGH9LDZab7qeopz9qXezHR+iwdna7ae54730Tryq3zJabR4VdJZa
5Rgt7+1qpqvZIE+ILbY2ipaLn4N70Ok+juCAN3GFGslYPz5iA5qx3llq6BP4
Wfwx+iuq1HpP3x8gz7m30Kl6nobXzW8NxpjRl/prxwFMt/e7HMfxknq9tJGe
08cyOc/SVn5naJvZp/Efp5+sxAzkP8R3rLX7nGE+rUh8o9X5UtW61/c8pCMD
h9znafyBDrFr9TRNnS7n3SXHb7SVTtdHKU4W+u2gFz32urE4UddvrgOD+hhC
i1rHnb9I3aHEfXh/YzBsr5tfJ/rUatTDF/QT/KjuK+7iDXey0v00ib1fzbuR
rYep9jIz/C+gm/GWuou8rwG1Ss1kpzfchvfRg+/xnRmNT5wJdc74DlYgRY35
3uqI2Gp2pdr79ZJEh/j2iCujL+vzAdpprw954parWUKfEl+F/7z9M0jWT+7k
iCnYY/0rdOGjxP8Kug7LUegMV/HpVyNTvRnsfxK1nTkDL/CfQQuRY3YV9sud
N1f+B8U9y55o/rdhHvbyT6OX5D6Px+yX8RuRv5auZD9q/xm8hrX82+kObMQm
+yVyd7n/Y74/E3OOHqbZcmylB9kv0p10HS3R1yXffb7HyneBXsZ3itncwb6c
TqLZtF/eye59mzlvNrcBNXfTHnazMxZ4y9u8ozYc5teH1e5l2P3X0/8Bnvn+
uA==
           "]],
          "1.82`"],
         Annotation[#, 1.82, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1HtM12UUx/Ejdpm1EAvMAlIUMS2BitScSzOyGcstymrTWhEVf5QWl9QY
0Swvrcxqc0CzdWGFS2k6mhrE0i3tYoJdHJAa2lqltAh1a23Ken3/ePP5nuc5
5zznOefhl1O2vHTZiIh4xZ9bx0R0Z0fcQzflRqxGzfSIsoSr2VdFDOdHPHh5
xOvXRNxBB9jLrb9J/702ojo94je6jl4yNeJrPqnsr8ZGbLguon1SxEH8Kt9e
OT7Bcna//fYs6/znidsqPos20Xy6PS3iO+d0JuuTrWEeDoyL+Et9Q+Lfl3/k
lRFttPqKiFN0Gns/HUd76Sg5nhNXjlJ0y1cq/y/Wy+kJ9nrrb2Mbjsk/LP8c
8efEL6Kp10eslX8BrWRPpI/QIpolz3FxC/Sji3Zirbw1GLTXQLdgyHpKXkSz
Xv/tjNH8J+ABOVahAg3OGNKTFDM5q18nfH+PdHFt4uYWqAc94lJyIs5MkFvM
Z0nfkcvvJnzJd47af6QldIVcFfIswZD7Bj2r/nSzyEGl8+6X60mzWGSvgd2c
aVaosl+BUjmOWf8TjdY3jKcoZn/q3WzFB1jlbnvsp5nxbjobL6l3Pi3TjxI6
11nFmOG8heyZ9E72O2Ifp08ktaBW7ip7j/kuR9PEiAvNppGO5Ftn/wJ2iu+d
vncl93DGYnUtVctD+JnvWH3Yr4Y+3/fZ66U9GK0X77nXPrmn6+PzasmnzdZu
5leE273lYsy03p3UTA/RLuSJrzKHGnxhLtV0tv2D4reo4+Pk/bIvk/e4Hv6k
1sPom6IuvOBu9fbq6VH2ESwzr6cxhd9H8rWgVh0r3GUl2uXuQKmzd8h/VPwP
OCn/EbrTXH+nrcn71I/TySy8vYtwTnyvu3ShX9518n5Od+CQfrxo9q+pZY27
bRB7t5y3IVN/b7CXkeF3gG7GG2p4VJ2Delukt63ebwfeRR++xTfuniP3jajU
n7ewGqnOuMs7HRZbxi51dqdaUuhpvn3i5tN6dd5Lu+z1Y7y4OmcW0qfEL8F/
3v0fGKWe7GkRBWizvg89+DD5naAbUYc8d7iUz4AzMpw3i/1PcrY7p2Ml/1nJ
bJGldyX2i903W/7F4p5lTzKnGViI3fzT6Hm5T+Fh+/P5DctfQdewl9p/Bi/j
Vf576DY0osl+odw9fu8O+94l5iQ9QDOTt0j3smtpK91IC9V13ne/7zHynaEj
+BbozS3si+lkmkkH5J1q7i36vFnfBp25nfaxN7ljrv/TFm+tAwf49WO9uZwz
/2r6P9yv++U=
           "]],
          "1.69`"],
         Annotation[#, 1.69, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1HtM11UYx/EHtxq2kSaUBaRcBLESUtfEuURGlrFY4bpsOJfkFl0WRmi5
RjULZSuym1PUrRU5W4DTcCUapcvsQmGXNWBlZGul0iK0rbUhq9f3jzef73PO
cz3n/Mi9b+2K+pSIaPHnxssiTlwdcQfdOitiI9bNjahNyGRfFTFRHHHPtIgX
Z0TcREfY9dZfpv8URTRmRPxKN9PJcyI+45PG/vSKiNZrIw7lR3yFX+Q7Ksde
1LOH7R/Kts6/TFyH+CzaRufSfVMjvlSnN1kvsIYy9F0Z8Yf+xsS/If+k6RHd
tDE94iydwz5Op9NBmirHenFrUI0T8lXL/5P1NfQUu8X6DnTipPwT8i8WPy6+
iqZdF7FJ/mW0gZ1L76ULaJY8P4tb5jz6aS82ybsOo/a20bcxZj2lMKLdWf+p
xqX8Z+JuOTagDtvUGHMmKe7kb+d1yvc3SBfXLW5JiX4wIC4lN+J8jtxiepJz
Rz6/+TjGd7Hev6OV9HG56uSpwZh5/8uSX//p7iIHDerdJdf97qKKzzZ2O5+9
eMx+HarlOGn9NLZbb51JUcE+4N104E1sMNsR+1Pc8UG6CM/qt5zWOo9KWqHW
crqc3p6ou9xhnltoVp4Yeaa5gwK5esxbyq7S9wPqPej7IezUT5H56qzl6eE1
8/TQV5P7oTXyHld3JZ0vts2bnEffle9m8RPeV6/9QvEf0Nl0wJyDWG+vXj9N
9JQ5HvH9o/VFfI7xLaWpanfo4WN2J13lHt4x34f4CE+p24RudQ+gXY7deAtz
9NFnb6m4cnQ5805MlvO09TNJnPUlchZaL6Ork7M32365J6nfrLdvE199/UDf
s/cb7UreJd9zyR14cxdh3LyDeujHsPqbk5npfnztvJ9R4wV33+w+WsXeJudS
ZDr/6+1lXO73T3fhJX2t9qZG9brA7F3e7WG8jiF8gc/1myP3PDQ471ewEWlq
3Op9ToitZVer3auXFHqO75C4cvq0PlfQfnvDmCGuSc0S+rD4Gvzrvf+OVP1k
XxNRjG7rn2AAu5P/D3QLmlBghkv4jKiRod5C9l9JbTOn4wn+C2kBspxdpf0K
82bLf6e4R9l5syNuwHIc5D+FXpD7LFbZL+c3IX8dbWavtL8Wz+F5/kdoJ7aj
zX6J3APu8Xvf74s5Q/tophzt9Cj7SdpFt9ASfV3wPex7qnznafAtdjal7Ivp
LJpJR+Qtcu97nPMu5zaq5j46xN5qxnzveo/f2GH08RtGi3sZd/+N9H/sWPja

           "]],
          "1.56`"],
         Annotation[#, 1.56, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1HtM12UUx/HDVlOWWkJZgIgohhUXdQ3KFJm5FcstNGuztWJs0damIphm
LmeBdkG7OS8jWblGm2IQzUhi0zSTKCxdQ9aMbK1UWoS0uTZk1ev3x5vP9zzP
OZ/z3PhlV65ZvjopIl71Z8HkiNOZEQ/TnTkRW1CbH1GRIF2cFjFWEPFYSsT2
aRH300HxKuNv0quzI2pujviVbqXj74g4JWeC+KspEQ13RRyZGfEtfuF3jMch
rBIPmD8y1bj8EnUH1KfTPTSPtt4U8Y0+XYnxWcZQgp7bIv6wvmH17/FPujWi
ndakRlyms8Un6RR6jo7jsU5dJcpxml85/5+MV9IL4m3G9+IgzvMf4z9f/aj6
pXRCXkQ9/yW0WjydPknn0XQ+P6tb4jx6aRfq+dZiyNwu+iGGjcftEfud9Z96
TJQ/DY/y2IAq7NJj2JmEO/nbeV3w/T1S1LWrW1hoPehTF9kRI9N5q/ksce6Y
IW8uTsidb+1naRl9jlcVn5UYtt9/M/hbf4q7yEK1fit4Pe0ulsrZJd4v5xDW
mq9COY/zxi9it/GGLIrF4k+8mwN4Hxvs7aj5Se64g96Dl6y3lNbzGa9/t+9k
us8emrAX76IRV917MZ8idNjrCvf8jD1MneG8cNxYJs217zP8zmKtmhFj62ir
Xm34CBX8bsBEvZqs/xXf++iYvBxr/1zOLHrC3u/1Zo/TPL4n6ReYrO4ULTTW
TUvkLESP72J16/m9I86Vt0BcgkXo1WO59S/D2+bvM7YRz2OOO9ls/3NprfkX
jJWrb+ZV5uxmOf/kW/S0n4/NteMwv6eccye96N7avKsk43X2cYbXJWfwIz1s
7jfaknib8q8k7sG7uw6jep2zll4M6LU1sX/ahu/02qzv6+6/zt4a1D7EcxHS
rKnQXKo1baeNeCOxHncyZA/znGGLt9uJJvTja3Q7syzec1Dtzt7CFkzQ40Fv
dExthbhc7y5rCXpFbr+6UvqidS6jveYGkKluk54F9Fn1K/GPN/87xllPxp0R
+Wg3/iX68EHiN4LuwCbk2EOynEE9UvUrEv+V6G3PKVgvv4jmIN3ZlZlfbL8Z
/B9Rt0acnRtxNx5Ah/xJ9Brvy3jCfKm8Mf5VtE78uPnVeBmvyT9KD2I39pgv
4N3nHn/w/amaS7SHpvHYT4+JN9IWuoMWWNc13wO+b+Q3Qv9zJvnOplh8PZ1J
0+gg31z33uycG+UM6dlK+8U77XGG/9Fmv3Wd6JE3gG3uZdT919D/AQoZ+Iw=

           "]],
          "1.4300000000000002`"],
         Annotation[#, 1.4300000000000002`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1H1oFVQYx/EnCo2m0lbWZjqdU2d7UwkjX9aaA5UGLXwBQ9zcaH8Ey7ml
EpZIU8GWFcg0LGkzZs2JYkxzDRTKtNVmRswhtgzJl0VrGkQwR63P/eN7f/c5
53k7zzn3ZlTWrNhwX0Ts9rEoOaJnSsQLdO+MiO2oy4soTzCJnRYxkh+xOiXi
nfSIJXSAXW39Pfr37IjaRyOu05107JMR5/kksb95LKIhJ+J0ZsT3+FW+s3Ic
RTW73/7pydb5F4hrFZ9G99MceuzhiO/U6Uysz7SGAnSlRvyuvyHxH8sfj0ec
oLWPRNymWexzdCK9TMfI8Zq4CpSiR75S+X+2XkGvsXdZ/wBHcFX+EfkXiB8W
X0KTciN2yF9Ma9hT6To6j6bJ84u4YvPopp3YIW8dBu010sMYsj6KZrP+Q41x
/KdglRxbUIVGNYbMZBR/mdc1+gOSZzmjuMVz9INecaPTIu7isJgvEnNHBr+5
+IrvAr3/SJfTTXJVybMGQ8777xPy6z/ZXaSjxhtYKdfL7qKETyO7mc9RbLRf
hVI5rlq/iX3WG6ZSFLE/925a0YQtznbG/nh3fIpeQCFK1F1GlyJLX8X2P+K7
hB6kOWpko04PFXqpRBkuZenBWr69WrreWjkuuqMeFIlP18dY+ddlRLSbx0bv
7yQdx55Nz+u9yV00YwK/SuvP8KmgC+liLMI5ebPlykGLmLliW53vU3Fd9j6j
M8Vvnq538yvg9yHdxE5yriL2c1iI2fwOWX/I2ZroSn2uwmq8IdcV59rmPJnm
PQPrved8fuW02p3dMKN2PaxVvwzX1elg36TH9RFq1PuNXFL3ltlcoe32fqNt
ibcp5k7iHry5+zHsbi47Yzf6nXun+C/pcVxUd5se3tZPvd4axD4v57NI1X++
vZSJ/gPoAbyrjzI9DupxnrfY5u124CD68C0umF263HNQ482+j+1IUmOZNzoi
tpxdqnanXkb53UGfuEL6pj5fpN32+jFZ3FY18+gr4tfgH2/+BsboZ1J2RC5O
WP8avfgk8R9B92ArMp3hQT4DaqSoO5/9Z6I2kp17M//5NBNpZrfcfpHzTpJ/
hbgN7Gnu7SksxSn+4+k9uW9jrf1CfiPyV9F69kv2X8Vb2M3/DD2CfdhvP0/u
Xvf4k+8nxdyiXTRVjmZ6lv06baN7aJ6+7vne7/sE+e7S/8wk12yeZj9Ap9NU
OiDvLPfeYs4H+AyqeYz2sfc6Y4a32OI31IEufv3Y5V6G3X8t/R8cQvhr
           "]],
          "1.3`"],
         Annotation[#, 1.3, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1HtM1lUcx/FTzTDUekgKCFAgNC4P6potVubKLixXtKhly2Su+KPNAuyy
opoTdCvUWg5tTlfodEuYjuzCTR5XWVFQtoasGeJcXmgR2ubagCX2+v3x5vM7
53zv5zzkPldTUX1VCOEDf+5KCaE/O4RH6db8ENZhbUkIlRG3WGeEMLkghCdv
DGHTnBDuoyPWa+y/Ry8VhFCbGsJpuoFeWxjCt2ySrY/eHEJjcQjtt4bwI06J
lxCjFWush5y3Z9lnv4TfJ/zT6XZaRA/EQvhBnq5of549LEFvegh/qm+M/0fi
X6FttHZ2COfp/LQQvqGp9DidJsbL/FajHP3ilYv/u/3VdNh6o/0PsR8nxJ8U
v5T/OP/lNDkeQoP4y2i19Rz6LF1E08U5yW+ZefTRLjSIuxajzproPozZn0Kz
Wf8lxwz2WXhCjNdQhSY5xsxkCv+Y1zD9GbH5euR390L1YIDfVE4IF7GPz5fR
3JHDbiG+Yluq9l9oGX1FrCpxVmBMv/9liq/+mLvIRrU3UCHW8+5iOZsm62Y2
rahxXoVyMU7YP4tt9hvnUqyUo8l6ppnNwgzcgOvxiFxt3sIhfIoa8QujfPTY
bXrDTrPoZ3udWMm4U6xud1+kzwnzK2EfxyF9XlZDqb2V1mnq6DSHdJovRmte
CCnixHCY/65ofno6hZOo4N+QK56a1tM4raeV6HE+7E0m6KDYhepIiF1Aj0Sz
Fq/Mb6NLTQ/IlS9Hj3xHkMD99rrpYXSgC524hC36ScJ0FKq1AN1qqZP3TbyB
3eza5fmYHpVrtlypyHUXxXIm3aRP39NpFi1hl0nPmP1T4q3CaffZoeez9KAZ
XdFHvVjH5D3n+zf6mbM/aEv0dvlciO7Nm7wa4/Idd0d9GFLTBr130oP4Sb63
5XvXvdWbUSPfh8W8J7oHvZc4S1HbJroDW9SxyrsbVd8ifbV42x3YhUF8j+/M
IFvsBajW4/tYh2Q5HvKGJ/lWWpdH81TLFLsLGOS3lL6lzsdon7MhZPKrkzNO
X+C/Av/6TZzBNPVkFJkl2ux/jQHsif6H0M2oQ54ektiMyJEi72Lrv6PciOn7
VfaLaR7Sza7M+b36zRD/cX4vWc/1pm/Hg/iC/Uw6IfZ5PON8KbtJ8atovfXT
zl/EerzDvofuxzZsdx4Xe8A9/ur7cz7naC9NE6OZJqxfpy10M42ra8L3kO9Z
4l2kl82k2GzusL6G5tI0OiLuPPe+15x3sBmV8wAdtN6qxxy/ib3eegd62Q1h
o3sZd/+19H8VgwHH
           "]],
          "1.17`"],
         Annotation[#, 1.17, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1HtM12UUx/FjQxtaQVJAXARMNEEls82AnLmV0y2a4bQ1cW7yR8XVLitX
c4FuplaLoc11Y4ZbYjpalsiW62JFYZc1ZK3IYpXSJLSt8EKF9fr98ebzfZ7n
nM85z+VHwfrGyoYJEbHNn9JrI47nRtxNW2ZEbMKGuRFrE2QZ3xAxNi9i5dSI
7dMi7qBDxjXmn6N/3hTReF3EIN1MJ86O+FhMsvGxdDWKIw7fGPE5fuR3lMd+
1BgPWD+cY158ubw35GfQXXQ2PZAa8Zk63Yn5QnMoR09mxG/6G5H/Kv/LtJM2
pkWcpoUZER/RNHqCJvF4WN46VOA4vwr+35tfR08abzH/IvbhO/5j/BfKvyh/
OU2eE9HMfwmtN86la2gJzeDzg7wlzqOXdqOZ7wYMW2ulezFifhxtzvqMGpPF
Z6OSx2OoRqsaI85kHH84r5P0S6TMtEd5ZSX6QZ+88fyIc9gr593EuSNP3Dx8
IHah3r+mS+kjvKr5rMaI/f6TzV//Ke4iB/XewL281ruLFXSVuGvMX42dcn9y
HoP4e5ZcHBGXJudBfTyEY9a22tMZ72cY7XkRs/SZb26StStxs/m/3GmrvFGa
LSYH59W4bXrEfPGvmC/1fV5/F/CS2oX2ly5nJm1IvDfU45BxjdplzrjJeyql
zTRLbDZWqt3Pq5Leov4F3vnqtfGcLXePmNflvG+/7TTVudSLb0AN6lCL0Md/
cpfxWI7RxDrPN+XvR5191aKOd0uBN6m31/CC7zXmqpDMY7HeJtNydZ6wVkZb
6VS5Gc476fqI6XQizaWd8t7CKjWqMOi+uvT+Kz2o38vOrUlfX/E85ftb+ra1
n2lH4m3KOet7ijc3ARfVOaGvXgyou5n3EXoQX9jTU2o+416bnMc2uct43o50
e51jLVVf2+luPKuPKu9q2PsqcQcd3m4XXkY/PsUnzjiH91zUu9vnsQnJatzl
jY7JXWtcoXa3XsbFnUW/vEX0SX3eQ3utDSBL3kY1i+kD8ldj1Jv/BUn6ySyK
KEKn+Q/Rhz2J/xF0BzaiwB4miRlSI1XdBca/J2ojxb4fFb+AFiDD2S21vth+
M/mvkFdnPM37n4878Y74KfQS79O43/oicWP8q2mT8X3Wa/E0top/j+7DTuyy
Xsy7zz1+4/uQnFO0h6bzaKNHjR+nHXQHLdbXJd8Dvq/id47+60yKnM2txlfQ
fJpOh/jOSPwenfNuMcNqHqD9xi32mOdNtnvTXegRN4At7uWi+2+k/wMkBfle

           "]],
          "1.04`"],
         Annotation[#, 1.04, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV03tM12UUx/HjqEW2sFBAUC4mXgClhkWJrNjS1RatcusyU9qotVkOWuWs
5kIxJNAiwrm1IodbUpJbF5EtuxcFXdaQtSKb0xSL0LZqQ7awen3/eP8+3/M8
55znnPM8v3m19avrpkXEE36uuzxiMDfiFtpWGLEZ9Usj1ibksLMjJksjVqdH
PJsXcQMdZa+3voP+uTiiblbEMbqVXlAU8SmfVPYnmRHNJREH50d8iZ/lOyzH
61jPHrF/cK51/hXiXhOfSTvoYrr/sogvnNOXrC+whgr0z444rb5x8S/Lf54e
oHUzI07RwqyIj2k6PUJT5HhEXA2qMShftfw/Wq+hR9mN1ndhH36Qf1L+cvET
4m+mqUsitshfRTew59I1tJRmyvOTuCrzGKB92CJvPcbstdO9GLc+hU6z/s0Z
F/PPwR1yPIZatDtj3Eym8Id5HaVfI22hHsUtv1I9GBI3VRBxFnvFvJvMHXn8
luJDvuVq/5auosvcx9UoQzmuwUq1tarjuFzv82v3Dj6gJ9g7rGflR/zlDl6w
nuM7G7ORb++NKyKuFV/iHpvYXdZPezu/IsX9tiU9+r6P3zZzWkcbaQ0d1M+l
cm5nZ9NmOqinNN/58sw0+1moEL8ClXjV3h4sclaPHAvpm/RfM7p9jhniP9+9
ZlHI7xC9f553IO8DtFW/LUh3153iUsW/Qi+i7faXW1/j7HXIVfuAXAvk6VdH
B58qfe6ibc55HtvsZesjBxvxOJ4R04SdSY3yPEeXJe9ef3fzP0Z77f9Ce8zu
vDk1mO838p30/T19y95x2p28LTFnfE/3ZgIT5nBEDwMYUfNWZxyiPfhKL0+p
Ybv/UoM30Sz2JjlXIEMdJfZmZPgP091oVce93sWYXkvdd7e314uXMIzP8ZkZ
zpF7CTaY405sRqozVnpjk2LXsqud3aeWKX5nMCyukj6pzlvpgL2R5P2I2+TM
Yvqg+Dvxtzd7AinqySqOKMIB6x9hCHuS/zhtwSYU6OFCPqPOmOHcMvbvydlI
0/ej/MtoATLNbpX96/WbJf9t4h5m5y6KuAo34h3+0+k5uU/hHvuV/Cblr6UN
7LvsP4Sn0cT/PboPL6LDfrHcQ+7xO99vizlJ+2mGHJ30MHsj7aYttFhd53yP
+L5EvrP0HzMpSv6n7Gk0n2bQUXnnu/cuc97NZ8yZ++kwu02Ped5Xlzfai35+
I2h0LxPuv47+D9Sd7ws=
           "]],
          "0.91`"],
         Annotation[#, 0.91, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV03to1WUYwPEni5aXLa1teZtzWm5HWzLRwoYJaQpuDk1DdCyaUKx0s4tI
Nd2SplmRmKFFSBjkZKKpaIMkZtlys8B0RB0nUumiNdMkmAfcoD7nj+/5/p73
8rzPezkFq9c9WXdbRLzo55FREZ15EYt4+/0R9agrjqhMM1Y8JiL1UMTSeyLe
mhDxGPeIa7S/wzeKImqzIy7xG3x7IuIbYzLEX+dGbJ0WcWxyxGlclO+EHPtR
I07qPzZeu/GzzfvM/BzeyYXcMjLiO+u0ptsf0IbZaB8d8Yf6+sz/WP5BPsi1
90Zc4cn3RZzkUXyeh8ixzrwqlKFTvjL5f9Fexd3izdo/wD78LH9K/lnm95u/
kDMejGiUfy6vEY/jlVzMOfJcMG+u8+jgVjTKW4defTv4U/RpH8AeZ/2nNe4y
fgyWyPEyqrHDGn3OZADXnFc3f4+8Ke4gPRYJOUe4s+G44ewKxZnTI677XuVs
/+EscZH2s2q8Ju+PfJ03cr6+iWgSv4lF1lzmvsp4Oa917t0TI8rFF3gxb3Rf
m/A6Zspbz53qek49s8QN4oe5MT3OGqsnRWzhZ7iJq/mU/dyt5pEY1DY83z6Q
ic/1H8JX1r4lT5HzKdA+x3tMaaswpw3z3csTmIeFWIA7jR1hXJs9lZu7Xk2Z
4ixUjYt4GqetvdI+3vNdyWfEu9UwzHl9yFPkrrDXUmd3WN8RLPauDnE5v2Kv
v7u3EvubgQNqm8ktvFbOS3LU8EVeJteAvINoUPsP2i/7/okP6/+Vm9Nvx7ir
vod6E/+ptR/nnX8HkgX+T3J/wQdwxtm8poYt6mtQ51ZzF8j5KLLtf6q+rBz/
Ud6Ft9W9ytvtVXOx82h2z8fxEbrwLU45h7FyT8MaZ/cu6pFhjXneW8rcSnGZ
tVvVMmDcVXSZV8qvqrOcO/QlMdq8DdZM8LPmL8e/3v1vGKKe3KnuFQe1t+Ec
Pkn/h3kbNiDfHu4wpscaWdYtEf+VXjv9Tuz7JeNLOB85zm6+/jn2myt/hXkv
iMcXRkzH4zhq/FC+KfcVrNBfalxK/mpuED+l/3lsQpPxX/I+vI+d+hNyn3OP
Z30fMecyt3O2HHv4hHg9N/M2Tqjrpu+k72Hy/c23nEmRs5khDp7A2dwj7yT3
vtc57zKm15ot3CXebo953theb/w42o1LYrN76Xf/tfw/i8PnOw==
           "]],
          "0.78`"],
         Annotation[#, 0.78, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1H9o1lUUx/GzgmGQYD1b/l5tuu3ZXP6oCNNtUKHlahpl4paUmbX2QxeE
FiNLqGkFQlv2QySM3ESbWLiEpExrugkVuqIerSjcAnMVUWwrlazX94/387nn
3nPOPffc+33yVzXfuzYrIpr93HxVRN/UiEV0y/SIFqy5PqI2YRJ7YsTozIh7
ro7YlBdRQQfZdeZfon+kI5pyIn6gz9HLSiKO8MlmH74monVGxP5pEcfwnXwH
5diFOnbG+v4p5vnPFbdTfA5to0V097iIo/Y5kMwXmsNc9EyI+Fl958Rvk/8i
7aJNqYgBWjA+4hM6jp6kWXKsFbcCVeiTr0r+b82voKfZG823owPfyD8q/03i
h8UvpNllEc/KX0kb2JPoclpGc+Q5ldRHz0+O+AeNetqAGfpQihKkrHdfF/Gb
89bowe80bb4YlXpZgQX2+IjPdPo5ny9QY36W2Dn8CsyPte+u5A70500cUuOd
1hZhWF8ftLbN/EP0qP7eIHal8Y20l30MDdYX818oXzW9g67m8ygexiNYhT6+
E5zxgQK9wjK+92Mx/1bzm5Cx5yl8r+4l5kfV/DfeFd+FvWi232k+hbMi/lX/
JXFt8r2Kdnxl7m79Om69mr6m1nfEvU4viLuIDuOdyZ3JPZ+20CZvag1q2Y3X
OhfqE9zhX/KWGfcl6+o6LO8RfMx3xNrbalqPcrnb+U8zV2lcgXL+6519Pt0n
vshaIQZ8J/Xud6+8jbRWvuWoQR17KX2MtuEchtR4Bl8b73PGH2ln8m74DRmP
8W4u+eaGcVJfe5HJ9y3J/wHdg+P2fVotL3gvG/S4VewCOW9BSt0l1sbmugu6
FS+qt8abOKvWMj3s1OtuvIF+fIZPnWui3KVo0POX0YJse9xW5A7F1rKr7H1A
LRf4DaFf3Dz6lDrvor3WMhgvbp0903S1+Pvwp2/rJ2SpJ7fUO0eX+UM4gbeS
75duxjrkOcPlfAaTN27f2exfkr1xpXM/wX82zUOO3t1uvdx5c+WvFlfPnlwc
MRO34n3+Y+iI3ANYZn0ev1H5V9IN7KXWH8czeJ7/h7QDr6DNelruE97Il8bv
iTlDe2hKju30IPtJ2kk307S6RowzxlfI9ys9ryfFejOH/R97Kk2xB+XNd+87
9Hkrn7P23E372VuccYp3uMP/UDd6+GWw0b0Mu/8m+j/8Y+nB
           "]],
          "0.65`"],
         Annotation[#, 0.65, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{4195, 8793, 4194, 7844, 7843, 8378, 8377, 8406, 11836, 
           6399, 11835, 6400, 7768, 7767, 10276, 10275, 11833, 11834, 10278, 
           10277, 4825, 7344, 7345, 5846, 9062, 7845, 7864, 6873, 9156, 9137, 
           11140, 5822, 10245, 4799, 10497, 5246, 10459, 5227, 10478, 11912, 
           6502, 12002, 4668, 7813, 4687, 12021, 6521, 6745, 11609, 11628, 
           9337, 9356, 4424, 7622, 4405}],
          "0.52`"],
         Annotation[#, 0.52, "Tooltip"]& ], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV0ltoz3EYx/FnE+aQ+NvmtLGN9t8wc7ogJrQLh0UR5pRCjc22kmg5lcOk
FCG05BCaFHIoLhBKbrS2m11QYoq4QbbZ5PTaxbvP7zl/v8/vm7uxdllNSkT8
xebBEdcmRUweEdGSGbHe9xTfa+g6rMXtrIizEyIWF0SUYRFKh0YMGhbRKL5F
j6V8C/g6xkZ04ieq+Ffxl6OL3Y0GvmqkFUXkDjdrXMRUTMPc7IhmPb9OjPiO
b6jQfwh/AmPl91OXR/vTx/os5n/S0099Cl+gF1LxT33emIg5YhnsQnXDaCaq
+WtQOEQfPWrkVKOWr0re7JF6iS3pyWX/zrMv/ME2djf9hU504SfeyF3pjqtQ
aV9bsc5Ox4mV2M0dPVuSEXU5EQV8Sdw0r3JURJ+MiBx7LpFzkj0i3Vy6yZku
2t9lXMLp3Ig9avZiuvO1sT/gPV6Lt9J9Yvfodbw0Y5e+BxPqzD3krqWjI2Yg
4R4FYgPNPkxP4Yj55c79Ue8Jdn/VDu/iDJrxDE/dZbjehdhaHHEUdehtxrx8
b0DtavZCs+87S7e8z2hWN5Pu7HlD9IVYKzLV7TAzSTepX4ZvhRFvEc6TPj4i
Hzf4H6EJ5+31HK3HDmS7Q6qcNjMGmlvM/tQzGwPcu1Z+Mc3GUHudLz7LfdP1
L1O3hT3SvynCXNyW35e26/0eK8RnyuvQfwPdw14uXoHdOCD/Ab2C4zghntS7
ydt85fuWmnf0OU3o0UAfsrfTq7SeJp2r3Xer7zT9vtAuO8m3m8nsv+wsmmC3
6ZvjbVyw51NyPprZSJvZx9xxlDd4wXu8i+fyWrHff/nh/1fR/5xvmwU=
           "]],
          "0.52`"],
         Annotation[#, 0.52, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV0ltoznEcx/HvSpRdbDOnHTwzbGNjizC5cAhlDjVLORU2ZxePJLXQUMYQ
aiXEbkayC7I5XZBny3IjrbCIxC4mbihbUYiXi3ef//f3+57/v8K6PTXJtIj4
i+2ZEa9GRyQqInrpS6yfEPGCXiyLuOB+G16Pj3iD74mIAQxil/Mb5REZYyKq
siOqJ0fUYBVypkZ05UYk+bTxaeDzMCfipPMjvk/Qw7SJPuHXjZPsLWo30VPO
r4h9NzHiLU6zTzkv1OfEgoj5kyJS+ilTt1K9Uprp7jffPzjD/yz/rfKdoU+m
qYGv4r5hU2FE+ki1xA6nt8VmOM/8f5cXke2s2ox3xkbUsjejLMtM49Sie/gt
l28ZVmIFfql1RU8tuJYfsdP+NthjpfNaOpPOxiwcGhGxTp8p352oF7NErQJx
CaSpMc9OFukjqXatmeswg+90PHJ3V+/38NgsnUhhCf9WZ4tph5ly9ZmHp3bZ
Lv9UZx00gUrzZdES9dJHRRyjzTgu9xq99+uh1L+7apftOI8edCJl32PUm4yd
cjahHkPMtaDY+xC7lr1Ur3f0/ZPfZ/SIm0P367GKdrvrxShx+9QspnXiV+Hb
lIj3+OvdZJdGFKHN+UM8x2U7vUAbsQ/5Zkjj06dGurrl7E//a2O4/Sb5l9N8
jLDThe7nmjfbvMvF7WDnlNgR5uMW/6F0QO6PWO1+Dr9B+TfSg+wa99txAEf5
36etOItz7ovlfm73z3zfFPOBdtEsOS7RB+y99CptpMX6GvDd63uYfF/oDzsp
spsK9h92Hs1i98lb4N+22HMzn341r9Me9mkz5npfLd5lO7r49aLBf/nuDe+m
/wB4Yp2Z
           "]],
          "0.39`"],
         Annotation[#, 0.39, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV00lszmEQx/ERS4KgqmjVrrWXY7ngYj0pQVWIpa040EUtJQRtIhFLtNVa
mtopSsSuByRu0jRUb2o5EE5iSbQSwec9fN/fM88zM8/MPP93zPqiJVu6RcQA
P83JEfkpEdUDIxpSI/4OjfiHHvZWjonIRf9RoP1wOS3i1MiI05g5LGIGSlCR
HtGVFJFtXcfnjPO+gyJq2Y2jI07Qx+5qsP+IVshVicVy56BmiHqmR/QWc8K6
D62Yoi7rA7SK3hou3h2l6BgX0SbXMbXuV/cksfvoqoyIPKxE3UT3IzUr4iVq
9fjd/jcU6q9Y3nx5i+gG2qmHAvu7p0Us0cNOugvluDEiYru629T8Gq+wke8V
dVxFgx7P4hxy1NU5IeIXLrDvqSuXT4k+i3FWbAPejBWrp+tY7/6btMac8vg+
EHNJ7BVcRZP7f8vXhYvs+8479LRQLwtQrc/J6qmhu+XeizozOYWTidmo/a3Y
ue6ch1X88rDGnL/Id0e/d1Eq7zJ5t9LltCRRO91GV9AyOsgcr6nxOP9GWkXX
6XktisxqIftwol/rYhyxzlTPQ2/VOjXiKZ64d4i9CYk5qu8gdqC7OmePj/jp
jhXs+Wq9Y2ad/D6jVVw2LVP7AvrcWTtSxJV6x0y6TvxifJ1kRvirnuTJERlo
tN+MFpw281paiVKkD/an4PPBHX3cm8X+lLgbvc1oM/8smo6BvpU5zmd6s2Rv
tkhcITvVjKdgFm7y70l/yP0eS51n8/sp/2q6i53jvADl2Mf/Pj2PIzjqPFPu
Ft/7C+smMe/oM5okx0n6gF1ML9BKmqmuH9bt1r3k+0J/mUmG2Uxj/2EPo0ns
D/KO9O3Um/NxPh/deZm2sg/pMc271Xvz23jGrx17Ev8h3+Im+h+ywa2E
           "]],
          "0.26`"],
         Annotation[#, 0.26, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV021szlcYx/FrQZRJqqrUbfXUxmNLQ4g3ItHMEBtKqbYTYWVbZFJkUyld
12ZCVoQwTUmUen5oJESLpBlixCSShsSmOg+JV0sQvBGZz/3ie//OdZ3r/M45
1/nfw1esLfzhk4hI+LnfLyJrdMSLYRHF6RFPaBF9TlcPMDch4ntagoTxEtqZ
FlFAB4pn0vf9IzrGRDzEA3QbHFHZN2JXXsQe1KMB+7Db2iv2W2ZNKy2lsxN8
UGx8b3xEuZr9fFfQu+Ii+b+HRPzlTJOcLd2+h4ZGXM3ho+ZIVsTkzIjB/KfS
ITTfml+c43M1MzB/UMRPvCaa326+jtbQrckxjtv/5vCIYfxuq7tuvNwe0/mc
ds5zOIpZ4hO0gvcGTODzo3Pl0vMjIk7RBdkRm/R1vXy5mkxrDn8WkUHr1PyK
atTgZ+Sqz8Mx++XTZnoE36m/7xzFPJt4LaWP1X8l/4h2osl8kfxJ/pf1oQ1f
612XuVL5o9aV0DfOsdK6Mv6t4lJ6iXa6+x9qq/hsxgz7FuBTfciX701v6Mci
/Zujvsh4MQqTOSxEjbue5bdfzRnaQA96rwOYq69fYoncFrXFtJqW8fqX/1M8
QR/7NMufs74F9XI7sQOV4nHWjffuuXSh+5WPcwa6iv7pW0tRd4te4tHTeF3y
jVCH9fjC3a65VwfSnbfCuhy6fGTEPPznu/0HH/injY3IxnH5NtxBg7320lpU
IJER8b/6Lt9jr+Qbip/zfocUPV+jPpcm0Ffvp5uf6o3S9GI273LxwFERYzEN
Z9R3p694P0ah+SnqXvMvo5Xi+ea/wUZUq79AD+E31JvP4X1HD24bn7amk7bT
VB6/04vitbSJ1tIc53pl3GHcg98L+lZPsvUmL/m/Fg+iqeIuvln+R43eYJea
Z/ZspnfF29wx0xs1+pZa0K6uA1Xe9KXv8Vv6ETHQrWE=
           "]],
          "0.13`"],
         Annotation[#, 0.13, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV03toz1EYx/HH5T+a+8aMYXLdJUMUTUTkH5fWFmKZuRdylxIWkWURprls
7ky0IluTbRSGoZZrjdjKny7lryl5+ePze5/nnOd8nuec8/0NLdy4cEOniOjl
Z3WviB+DInZjy/CIerqdEVFOSWkRh4ZENGdFXOod0TYyohTLxSnyPveMSBgb
0T8xomNMRDoOE/+W803cVdyCP/tFpA2M2G9cabwB7+IpTOijJraKq7AJn/NN
S44oMT6iZgXdoT38duAKmkc7rS+x5xePibhA/GmEetTF+k35U3E0JVKR9Tny
evKelBKRI+6hrxxnTMAp7uFhUsTf/hHdnfGDc+QNjniP63l1M/fOOGNAxD17
aqiWTohP8yyjSvnTxAVYh2eonCrE33mfN652r0X0R52nPDuw1nwNlZqfi0dx
S2bEZiq0N80ZG/g30jnr9fiAduj7q7eq5/EFG7ANH2ABj4fYLm7Eft4skVYN
jUjuG/FE7ZXGL3ANTsbVON63sF1eNm7DrbRA/vH0iLPO8JVvO7XRHXsKrTWO
Uoua7H9KZfa+xFf0nJr/16Ek81fc/VXK19N1zMVKa3n4zHmaqEDNZfTG/Br+
z3AdZqqZRVdSfZvy9w+To6c9eICKqa+8C3yTsIjXZm+0y7vNt++GPdVyxuI2
85m4Rc4muqb/2fZcxltURTniArUeqd/kLVL1/9j4qrsvdq8HaS8V8zmM43C7
vHneaLr+Z9I+3ll8BlmfZD0ZJ+BF39tSfvflVKjR211me+cX+vrozXPtaea1
XE6Z768IX4vzzc9Sfw4tNq7R51Ksw2NyTvI/TSV0nEppp/9UZ328He27phbq
+O/DN1HdGdhqbx4OEC/CtZRivArb9ZSrty+Yj98wRb037vUfXtevtw==
           "]],
          "0"],
         Annotation[#, 0, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{6072, 12215, 6073, 6045, 11558, 6215, 11557, 6214, 11900, 
           6483, 8403, 4928, 12229, 8402, 12234, 8405, 12082, 8404, 4354, 
           9293, 9294, 9292, 12226, 9291, 9290, 5147, 6580, 12257, 4229, 7029,
            7030, 6040, 11408, 11409, 8940, 8939, 11580, 4376, 9113, 9114, 
           9112, 6492, 9115, 6491, 7803, 4447, 6768, 5180, 8841, 6102, 8839, 
           6101, 8840, 9057, 9056, 4387, 8036, 8035, 8598, 8597, 6719, 8737, 
           8738, 8311, 8745, 10192, 4731, 8746, 4727, 8304, 7010, 7331, 5142, 
           7011, 8305, 4728, 9039, 6312, 8879, 6186, 8308, 6189, 7026, 7023, 
           10406, 5190, 10403, 10412, 10409, 5181, 8030, 8641, 11975, 4382, 
           8644, 6821, 11650, 11653, 11647, 6274, 11656, 6192, 11893, 6478, 
           9280, 9283, 7040, 5166, 11548, 6198, 11545, 6195, 7585, 4444, 9402,
            8094, 12049, 4913, 8394, 7896, 5203, 11979, 4448, 5782, 4451, 
           11982, 5206, 6724, 6727, 5209, 10422, 5212, 10425, 4496, 11668, 
           11671, 11659, 11665, 11662, 4215, 6913, 10708, 10711, 10705, 5369, 
           5700, 12053, 5697, 4571, 5717, 12056, 5720, 5736, 12059, 5733, 
           8418, 4947, 8415, 4950, 8421, 10267, 4819}],
          RowBox[{"-", "0.13`"}]],
         Annotation[#, -0.13, "Tooltip"]& ]}, {}, {}}}],
    AspectRatio->1,
    Frame->True,
    PlotRange->{{-3, 3}, {-3, 3}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyEnXd4VcXWh9MDAiJIFVAUREARkCJF2FvpSBNRmkhHQBAFRLo0AelFmjQp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     "], {{
       {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
        GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl0tsVVUUhndLEbmX3tJSLCDQll6eQRB5DAyChgSIgKIDg0GJGAxFqeJA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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwlVEtIlGEUPTr5+icddX6fpM6nM45Cuok2UVS0CYIiiSh7ECEkBWWLpIVt
XESUUblw1bSKDCJqJk0tCqPIbNG7oBdZiqE7X5BE2rmcxYX7/ffc97m/O3yi
6Xg6gO2UFZTdPrAnCnh8vAsAP2uA3yGgPhO4GQReOWCE8tQDnlFa6oBJ+vwj
tjcXSKeeoP0RbSnir1UB88VAciVwOwfIoT1F+zDt92jfyVw7fOVKMee2EmCo
CLhMvTUD6C4H5uh/l/5eFtAVB85T9tH2nt/OEDvPHGmMV8r30ipglDXVs+ZT
jDlI2wBlifp++owz9zfKc+JHPGEPFQChdPlksJ5dhUCU+CTrW2Q9lazvPvUG
zqCBuefC7D+gns4x1t+wsA8Ybz3xG0uU6wDrXeb8FinVxA94ij3H952gcqRK
AWffmP8Ie17DXFMh5XoT0OzrOIOJTO1gM+2T9Omm/pb2MtY7y3wx6n2MOUP7
tFNvY3wvO30z/aWn3eX7wtoOx1jLrxrt1nqyXmeIGfXUs+3ibJFqs5000ZbF
eX1JYw/EhCrEAdu9zfgW7dOM8YO+j2nfS2yC9k15mrHZeoh56AmTz9idfA/y
PR4UN4YoTzxxxLh03SmWcWoDe70Y12yNA1brH6ferGbjinHOuGacKWb8j05c
nWD8GwXimHGrjP20OdVgufs9zTIYFXdtpgni1/nahU/8i2qgivuaZS9ZfLfQ
/6iTbx9lC323+tqN3VCE2FH6tGbK5zN311UuLtsMT9cCJ2vF1SueZtUY0S3Y
zBbYSy850ANxPMx6PpHjsWzgK/3HubspStITxzorgQ6KCwhzkLWVFQhrmIWw
arZajYNtxLZTarLlM0VspEizsZqHnWZos7OdNLOfwqhut5b4Ruox9vs6IE6u
pr42qlnZt0tON2K3YTs3rh+L6VaN85GoYlqs/qBus8SXbjfawXe70+0YR3LJ
t7wKzd7+Od8rxUnjovVwNR/4ENEsk2m6nQtx/Svshv4DcYrDKg==
           "],
           VertexColors->None]}]}, 
       {RGBColor[
        0.3255901418096829, 0.11334654349736283`, 0.5746366485162774], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl1lsVVUUhnfvUNreAdpCi0BvoaUtagtERA1zhweNgQeIASnEQAyJYAp9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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmtQlGUUxx+Xi8guwsLC4o3dhYWl8tKkVpNaozKT1qRFFwUysyk/BKn0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           "],
           VertexColors->None], PolygonBox[{{6797, 6367, 1126, 5509, 6796}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.3585387064784007, 0.17063519920207634`, 0.6209498420451924], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl29o1WUUx8+dm9vuvbv7g9vVbW7r7s9VJIjIUIgQoV5ZwkgsiKa+MDPx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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3ts1fUZxr+1hZaeas9pTzmUnp6e07szTmLAJdMtC8JCGVAFUbkJbTI0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           "],
           VertexColors->None], 
          PolygonBox[{{7285, 6479, 6478, 7299, 2060}, {7397, 7393, 2091, 7400,
            7396}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.39148727114711845`, 0.22792385490678982`, 0.6672630355741074], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNlU9slFUUxS+ddqa0nZmWtpT+YTrMUCEkkpjgSt1oFJtAopMuXBgjbAY2
gDUuLAEkITBCTAM1mqjx3wKjLEgAN90YLWEhbkhYwcYACzcqoXvC+XFuo4uX
7/veu+/ec889935b9h9uHeqKiK+0ClqfDkb8UY9Y7IvYr+c3tYjyej2fifha
6/OBiLNDEUcnI+Z18R19v1yKuNsd8au+7+h5dl3ExWLEshy+ovWebJfGIm70
2A6bN2Wzazziea3Lsr2muBdk94v2d5Z8n7uV/ojftN6V76X095JsTgrDkUnv
TwjjuNa93oiRSsSwVqtg+x/SzxcN5ahVxdfWiGMjESt6P67nPn1f7ze+K0Xf
/X2b8CTmYtV+31Dco3q/pP2q7K5qHRNPiwVjBOtjcfigZHv8nOq27eYu53lf
GD/R/qTwTtX++8bXXMFcwn1FcRfE+1sV+6cGi2Xz1lacD8vmYXnE9aAWnGMP
x8QfTcy7xe3JurFSt3Npf0B+5ir2B/7ryTN83V5n/yt5Rl4nyo7LXXjsqdo/
seAI3tkr5v7aN7y0p6QV4ehTvmPC0NBqKdcxrecGzNOZmYjOjL831M013C1k
3O4u5/Bxvzm5rzxqTetutmJM2JA/PKKzR9O2wwbtEm9Lj+NRE/JEp38W/T6x
XXkL62rJmkUHaOB98i77zpkNETcnXS9wLSQn+Gil/4/K5muNZzhG22CitvQI
59gtpZ8TWdOVCdVC69mS9Us/UBNwoClqRF9+l72JZjvdPrsp3j7Y6BjE+qvX
mkFL9Crc7FB+m2rW6Xn19AWtzwaMG37ggVz45n2vOCxstw/qWU2twwe8kNe0
6tCoOV47z9jv5FwgX+qGD2oHj/OZ78/Sxb8N2z/U8++GOXthyljBubnpHib2
tzXXAP6bulsctt7Iv5Pz523de01npV5j3zPt2PDcTp3glzvYd+TvH/k/2O/Y
B1Pz9MeB/+l/KefPDvm8NWzt0HflzAsOtiYP7N/NWcdsI09ypEfBwtmXivnq
kPEwv5gRzIOnfV+2T/qokr35k3Txo9YmYT+iur2YWkUvt0atGbR5Ovmh39AQ
uJtgGzSe+eSBXMjx9ZwDxOGdfJlJxMdPO/fBCadXEyfcTzXNPxpdztlBnH11
x6Imj9dbBzeGzR126Hamz+eziYH4cHcndYOOyY8aUfvZtCFvenU19YqeyGVQ
MYfq7u9R/Vv6xv0vaSWPcEic2cyFWdWTs4v9ucwdXGAG29r8hQf6A9/E/F73
Vqdtx6xlDqIpZs9a/z0B/FfonQ==
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHtwVdUVxndQSOQhCffGJHCJSW4S1FYKMwVsxVZF7Bi1RMAnDwFnCs7w
EmpH6IAyQ5BqFRQrgkpi67MW26qtHXWmIzhqAUfow0elvtpQFFFHoDrFMv39
Zu0/vrnrnnvOPmuvvdb6vnWb5yyavLBPSqmhIqXj+Xy1OqX1xZTWgV3YN4/g
ek1Kx4E12G82p7QH7AZvgC1NKT0OfgnuB2vbUqrmczWLjR6Y0srBKb1Yn9J2
sAK7fWhK+0op9YI27FVDUhrWmNI/q1L6db+Uuri+h++7wWrs04an9IdhKT0D
TsUusE4LaAZDwFd12PjaBI5i9/COV/h8GXRjb8LHO8Ed4B7w4/aUfgiWguXt
sdfzT0lp4imx5wnssRNMAueCHp55BDwMusE47pvNfbPAWOy/tabUpzalCvBX
7FO4fhqfp4IR2M8VUqrD98mVKb3H/spcn8Gep4MW7M/4/R/llPaCT7EfyzEx
FvU8s5R3Flh7CFiC/TvwPHgOPA22EaOXwUvgBXCYa0fBf8EhsB008Gw92Ib9
Nmc6mneMAn/HriCmu9jHTpCwDxGzqfg1BXyO/SExHo09CuzHHt+Q0g6ut/VP
6Ul8PIfvP8XfW8HZ2BXVcU07Yfew7mjyYRToNnass4pcmkXSvTggpbfw+S/g
z+DNUvhyDb/PqQmf9vLOdfh6O3gbeydx2gp+BXaAn3H9Qt7dAe7CPsI+d/P5
GjiMvZQ8WgZuAEvAHfhxLe+ZB9Zjl/DnCLlyGAzDbuGsLjW/+saZfeW58Nsn
4Cj2E8TwIOf6MdiK3aeFZ7EPgQrs89nzWez9KWJTWRW5NBaMyTn18eDIWXP1
APbl7PEVnn0ZXIZdxfUZ3DcdVGI/hM+PgUfBg2APe2pm/UdY/3T8O4t9fBvc
Qv0e4vuHPLOA++aD/djDyanx+H0mKGHfyPVLiFUnWIk9vSbOyLOZhr15aMTU
WG4Cr7L2e9z3LtiFXV0TZ+JZDMauImaXs9ZloBL7+pNSWtwevpzYN3LjMXrC
o22RI3OJ2QIwH/wAzCReTXk//YnXXvZXy/eH+T6yMmKxn2v/ro2YTOOZ2WAW
uKo5cnk5viyrj5ze1xg+6lsv9p3WeHuc5930o234eBK/1YIXsPvzrpeIy7PH
xTtXcYa3g9vATS2RW9fg+5y2yLFV5Ewz6/6E3F3RP3Lzfd79Xn3k6Bru2UEd
3cZ6U8FB1ljLtWu5fx44rxg1ZS1NwL6LtTaDTWADGFuMHDE3xmBPBhfj50Xg
kmLk9ixidnV15Hgl5/Y09h85/6WDIpbbh0ZuGFP3+lauLffcOyJq1Nr8l3nJ
/U/WRq+x5yw6OXqCvWAh9oGG6Ln22o+wtxDLDdxfx/0biWcPa56FX+NBN/YD
7PdB8AvQ0xK9Uk6RS+yZR8wt7HXE7lzW+IR7trL2sRQxshau5t0zh0dNyBUf
gPczZ7xRjJqxVl4vBrc8T24/Vw6OmUROdIALwPebw9eb24KL9Nmz2pxz2zNb
UBcxMRbz66JWrUFrz5q9B1/70RP6go3YgwoRE2MxELuLd9wIVoLVYA0xOJ+z
mgi6sLuL4bO+bgF31kUPtXe+RE4+zJpTiekU8JBxIr92NkXtGKP/sK8vec8X
4Aj2PPYyFUwBc8GJvKcv6x4PBrUGN+8Af8ocfYgz/By8QL89dkKclTk2Jp+Z
vbaDM7igJXru0dzT7GVyyD7wLngH9DYHV3bnvciZ5uaV2FcUI0efqQnOlqt/
j30111YWo9dvA7PZ2xwwCF8uIWdHsO+J4DzQDrbw3juog/XgfuuPZ7/LGt8B
HdjnDI8cM7fOxi7VRE1by8NqIvdc4/6cg2qJH5E315dCUzQSw5PB/qqIibU6
lOsfVEXNylVyoNwnZw0tBmfL1Q3YA4vBwXLvgGJoCWvGWlFTyNVdORfkbHNz
Z+Yqc9SzKfDckGKckVyyKWsTOUUtYA+3d6sJPBt7tL3ZM6rH17XEvfZEcpZ8
vo9r94Lj2cvgAZH7agq1hDVgbMeCMTnGnqV7ci/vZF/kQLlPn1YU48w8q+0D
otfImXKlPUftJafIJWowtdbT7POp2tBc5vI1YE7O6ZHl0Ihqw9PLwWVqQLWf
nCYXqHGWZE7w7O/KvXB97o0bwd25R6oFm1mnqRyacDG4bljUkppCrXcruCVr
PrnCHDE35IyuxuBAuW81mNYaNWutXoVdSa9eSE4sAP2wH2dPa+RR40vNXsoa
/bn3BDBVLqsODaj2m18dWlGNsDVrRmOvBlb7egb2ti959oua6HH2jmXghtxD
5JaLyaXlJwTHfIPzOIO1x4GR2A/we09jcIs1JFdZc9aanOXanaw7aXi8Yxx5
/1vO5jdgbCl8lyPlRvcgt9oD7X1y7PNZM27LGlNt+VDWHmpMe5s1aS3a49Q+
B83d5tBAxm6GOdsSMVRrrcpcquY62hYcYO+fOTC0phwnt6k5C+T2s9hLiPdy
+OxAITSu2vajQmgbr2mrcdT+h7PWdQaoIc+GNMVZOYOodZZm7deZtUgfNErF
SaFJOhuip9vLJzVELzMnzAV7Wjdn+gbrvQ62YJfMmVL0CmeWJ3huMfctUg8W
git8xnvljAvL0ePt7R3l0CoT8myhZnF2MofMHWcouc4eZ2+T825VqxCTmwZF
TPYUYqZwllCzGOvruGdxTcTcXJGT5WJzRm14Zil6hRrR2rEmT881tLspZiJn
odeaYi/OOM427ulT1vysJbSLGuNg5oTefOZq3e9VhxZS89a2Ro+0NxZbI/e+
xT1nNEQOWpvH8P9/hahRYzm9FFrZmNpLzFlz1Z6yDx8/BgdAbzli0UGubjgu
YqI9txTa0Wtq3a+z9tcKoXm1PQNj77WLTo4cNPesMWc1a8zacmaz1zhDOjva
c+QeNZtaTQ5yllATq4WdKWay1pXgCjCjLbRmd3toIzWne1Ujq43ds7PFhvbQ
ov6udpbj5XY1dANrfrMhtJicpPacl7leDeossi/HwpnEdzujO5vrg1phbtbW
agZnJXPU3HRmstf0wZeK1ug5aomZ2Xc1hVpsVmv0fjWZs6pn6lk6s/qsM5Gz
kGvc1xYzl7PWvW0xK9gj7Y3ODJ7dtKzVPUNnLTWLWsWZy9oyB1/LNeYs7X8A
zv7O1K2sUW4MrSBnW7u+03dZw86OXbmXO0P6X8WkrP38z8JZyZliZNbDcmeZ
fO2sCA61t6uh1c72+Ik10YPsPXKqs+7PB4d2cuZ1ln4z//fhTD06z/zO+qOy
FuvJ/xWoyezFcopcYk8uEYPh5eBqfVCb2IPsPWoUuXNE1kJy6P8BKCyTmQ==

           "],
           VertexColors->None], 
          PolygonBox[{{9875, 4315, 4314, 9873, 3222}, {6457, 6826, 1816, 5554,
            6456}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.4244358358158362, 0.28521251061150327`, 0.7135762291030224], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lEtrU1EUhbfaR2r6SFv7SpM2abXkFygqDquiFSHiSKli26SCVIWoU1sc
VNPEWDrzMRERBaE4FARBsIIO7VRx1KEgOBLF9XVvByf33HP3Y+211kn+0tXi
wk4zu6m1S6uqn+8JszN6HkuZHRkye7LDrK735wnf3283m2oye6fERK9ZdsS/
Z8fNMlrLSbO/LWaNZrOTimtJ+HdyhxW72GN2Wu/L/ao1YbaqesVO9dSq6DxP
TM5sK+E9n0Xf2m7f/zHHdTTl5yX12VJeRefjOlsu+AyHMorT+tlqdmrU61Jz
UjE19X2s3Ftps4W04y0J92zS45kRLohptDtGZqb/VuCZSTpu8PxSjd/7zNZ1
vl/YDmitBwdzzY5tpeC9qXlWzzXFPNX+tfioav9W8e9VJxfnOeG90+MclDXH
iQE9Veu6uOnXPMfbvDZ5xPPtYqufoQH40eiT4j9r1cXflT6zpSHXBU3QBi3W
Uj4D+O8KZ1Ur3+mcF0MX8nlnX+tQn+DqhzB+VM2NFtchlfS+D8fMHo35O5oM
jrgub/aY9RY89ktoR/xeYfzW5XwyQyl4KweHzIhOrxLOK1jABGY82NbrM11o
dU7IYQZ4wM/kPAhPoikao8VSk5/Ti9rkE7sqrm6n/Tu48QZ15jX75Q73AXyX
Ah81iKX+wKjrtK1R0r2NX67Jdzfk+6V298vUqOOfj3r4C9/AJbqQC9dwTg3e
K3E+E3jw7VzsP2SlRdbrVIS/a9jxwPdkt3O9GTiZty48KxPORx+6dzvfG6rx
NbQ4nPG7hNacoRPnzFAPP1ATLbkj1N6M/TnlZUbcZ+cz/s4evKXwD3MVgx/u
wXTG9ZuNGObiTkyn3AP3Cn6X0C416P9B6M6s+Htb32bXEV3gthY++e85Zgcf
e7zHf9KLtHNOLDlwiHfwEL2KcR+YnbsIX+XQvRE1X6rGwbj71N6Mc+rgN3rx
bMT/yWLafQZneIq+4PwHu3bGNw==
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHlslFUUxV9bKGWz0860DGU69ptp6Qhu8EcLUdwBY1HLUhWFsjUiJhTU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           "],
           VertexColors->None], 
          PolygonBox[{{7224, 7959, 2376, 5553, 7223}, {6548, 6853, 6852, 6851,
            419}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.45738440048455403`, 0.34250116631621674`, 0.7598894226319374], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtU7tOVFEUXYoMcwdkZsAZZm7mzsCdBKGy84VgYmeJBdJhbOwkMRotLCSR
RHTUqI2PwkcU0c5HY6MdMv4B0YSoiIXExxfgWlmnODnn7rvPXo+9z9DJ2WOn
twM4wdXBdbEb2J8BzvBjoMFzDfjXBRxOgAmu41mgzRiKwBDPRyNgF/M/sMgS
z81e4H7WK+X5HverI8C1EX+P54jV7finEhBVgRc7gA1+r3NNEvd1HXjLVWK9
UWLN9zn+OwZ6KsARnvPcV6rmKk5fGFsmh1V+P+e9WidxBoF63XWTTvNrMe9K
mfuwY3f5/wFXLjJncVP9N4yNFYCFbcBszlx0/ksuPxL7o1q6o/wJ5ixmrUUe
pMGHPeT8tWh/bvWYg3D/sM6+qusUKtYjLZusfSB4Lq9mAp+xqrGVvxS4Cv8c
PbxJLWB+O7Gn4nCDsevDxswzf4r5ax3G1r331DKSAo8q9k4cfyXmucn4Wt49
EgdpU82dTfrf9IwssJ/vEudc6HNvxFO8NROq8znjfjxlfJLxrYz7khbcm/Xg
tzB0t8gaudj39lJvuWHPhSNOwmoPAI/znjn152DVOYPsV9TvObrN88PU8yDM
cpf1zgQsaflJj3fH9kT8xFM588ScK5vnIeKOJ/buPGtHsXO/Fd1XaWyF+7qr
9yCvVfMs+3ApNr64ymPlFyLnKed7zTx01tsaTT3L6qX6pJrijsBfvBfDG+mn
lumsNWqfCmf5qdmQV9JxKraWj6y/kvh+ixrvNPxOxE2zL369nIWufmuaiz1b
wl4NfRMH7VvBq1d1v9VSmK/poOsZdTxJzfEl/y/WrXuZ+JfDW96o2lN5p/t6
Y5qd/0UMnC0=
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmH2UlVUVxk8MwgwgMwN3Zphh7h3uzB0ZgtJ0rRg0tCzUllgNxoAfgKKu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           "],
           VertexColors->None], 
          PolygonBox[{{6928, 5485, 5484, 6927, 1873}, {7364, 7369, 2081, 7368,
            7363}},
           VertexColors->None]}]}, 
       {RGBColor[0.4903329651532718, 0.3997898220209302, 0.8062026161608524], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFll+IlVUUxfc4f+69c8dm7ozXxuvcO965MzZFTwaZaRjUQ2GFE1g4QURT
gX9SQoTAJ40YrKh8KSgrNQwpjEzTSDOaZMryyQLNsEKdZjS1SXsoiWj9Wkd6
2HznO985++y91tr7fNVHV9+/akpETMjqZZnmiCbZ5bqIX2bovSPiaFPExr6I
vcWIFxoinmmPuKYSsVgbFpYj5suWZCNa9X2wFFHQmnOaOyvbn7XPrGyT/I9r
bkL2iebbtW5Mvr+Sn2PNXse5H+vbrib7nyV/Vdkpvfc1+nlQ8+uqEeur3rtP
60/I7tPe67siKortdEYxyv/n+j6sBIeafOYave9MOZY03tIb8Zbs67zWd0a0
yOaS73URDynn7+XzkNY1yteQ/JzUug+b/b5BOOwuO85SLmKmLKP1R7sjLujb
U5p/P+88v9R4h85/YmrEZq15Rb6/EV7vNRjTsuJ9Xs/jOvuEbEGd8wIL/N+Q
cMppfrPwOK04X9Tcn7WIpTrrZY0fk32r2Ca15h/NNyivD3T+auG0rOoY/hCf
v9U8rije0eRzPO0/WW9sMomvOYr3pSZj8LDmBrLGljx2pDFckevixGOpxfv7
e8RHj2P6bqaesm1a/5zivaz5VYrtXo1fVT7d9eZoPMWwMu/v6OFiuzHljEHx
m5Uutzc5/17FMKL5uv6IO9qM7Vz5vrsgncFzwVzC40XlPSF7V35vEW8/F5zP
I+LiAVlRcZ/X/K+yA5r/SDnumWqO+L48rdlXdD3A25h4ONNp/C8I29XSXr1w
Paw4D8lmZR1Hi+YWNdonTzgazBlDYmYd/B+rs1/G4L9e/oZljTlrfCDpfKGe
05TH28LzoHg+WDGfvMMVWkVTPVnXzQVhXFI8CzR3QGvHpkV0af2gvt8u25px
bivyxgr8GaPnJ/N+Z9yqvWfK1ibYUPfUI1zAAzyCHVxSayFepvRbL6xjPTmS
HzlTg9QQPQX9zBe3t86wppaL8zsTp9t0bhS8F02gUeLs0ffuijHZnndt47Og
fHMl19ORmeYMXKltMKC+Fk03LrxTvyOpV8APGoSjvlmuVTQARmA1nLAFV/L4
u9l8gPnjfdY0ONBThpKen9bceI91S++gh1B7aHBe2bz2i5+lXa4peKT24JLn
TbKtguAvYXKl2/0UDHYmHOCSHIitL+f1+OA8dAaGl6T932vuSfRF6hqfE4ph
etm50Uuae61ndD1Z85g+TV+nB03V3FjSAD7mpNhKqXegW2oR/jiXWIiJNdwl
c1N/o3Z7c//3afAlfrAkdvAcTb0vl/zMSXn9IJw6FffsrHvKYNIwvmo5+yOf
yNvnceXyTqtjOyJ9ldocQ3fO/A0l3GanOJdKFxOtPhf/+GZ+RepJYD6snlos
ur/D6WiquwnV1mcV+74kzje2u4YOC7Nn213zu/V9j2y61mzSWT+mfs7529JZ
9Iq9qV+c1dpzFcdYUd5DVWsI7VfbrH/uBHzhp0VrHqwaC/pxNvX07pI1jZ7J
BZ1S12cU8/6K77BT2rul0/cB+HUlXaFj5qgL6nMy457M+S01x4Ae6FXodp38
rZU15Nxz4RGMqINc6uH0LHACN7RQS3qgFnly7uvos9/648l/BmP8cb+hSf5B
bkv/IdQkWoRregz9mHfiID60sfnaiNfUF9Zl/E/Bk/40mu5F4oHbtVXze6Ni
3lD0/cZ5nI82uFevdPg+RYv8H6AFsIHb8/XGeWXSzYKyexl9rKjxuYL1Dlen
Ks6fnn31f4ceiw4mU89kjr3wtyf1VDgcSTwuSX2Z9Wj2v7oK3xV96X6Y0eYa
QP/8axxN9bg3nYXvuxTXzcp5vNn64/6Cf2ri017nTv1e5Yr/PNaSLzESF3E2
SG/LOtyH+Sf6omzN0O/4n0Az7GXfmoQV9xA53SNMBqrucSPpH4scwRmM0Rg4
sxefbwi/NyuOdZee87rs8ydp81KH74d/ASivcQI=
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHtwlOUVxt+YhFwh2bC57WY3ye4GA4VaC1MJotDWC4xAFSoUrJCC0E6L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           "],
           VertexColors->None], 
          PolygonBox[{{4969, 6667, 6666, 6673, 1752}, {5121, 6373, 1680, 9226,
            5120}},
           VertexColors->None]}]}, 
       {RGBColor[0.5232815298219895, 0.4570784777256437, 0.8525158096897674], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmGuMldUVhr+Zc2bmzBxmzgwOMNcznGFgjhmqUexF+IE/oFxsJNE0KpG2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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3lwleUVxl+Sm/UmJOHmhtybhCQk4aYEtNDYNvCHjktZrNoROizVlk2t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           "],
           VertexColors->None], 
          PolygonBox[{{7190, 6605, 6604, 4121, 2008}, {7604, 7621, 2212, 4739,
            7603}, {7618, 7604, 7603, 4738, 2211}},
           VertexColors->None]}]}, 
       {RGBColor[0.5562300944907074, 0.5143671334303572, 0.8988290032186824], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl1lslVUQx4dSStdbekuhC7etXbgtxUQj2GICKD4giy++CDExAR6IIUBM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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl2lslVUQhofaFgotpfe2lHvb28Jte1sosgYSiyGgUbYfGgMRxJhQdggg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           "],
           VertexColors->None], PolygonBox[{{7053, 6011, 6010, 6896, 1854}},
           VertexColors->None]}]}, 
       {RGBColor[0.5824647097284128, 0.5575209033370476, 0.9099237635015661], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmG2M1UcVxmeXZffu3bt7Ycu+793/ssvdu2whaipGo43UNtgPpYIpJE2J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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl2lsVGUUhk9pmWmhZUqX6Uzb6ZQpM7eiCO4aIHEhqIiKJm0C6A9bEVEj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           "],
           VertexColors->None], PolygonBox[{{7055, 6014, 6013, 6615, 1739}},
           VertexColors->None]}]}, 
       {RGBColor[0.6066895287905356, 0.5964434469422791, 0.91047601476272], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmG1sleUZx++ewzntOT09BwscDi3lOT2llCybS/Zh42W6FxhF5oAiW8AX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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHlw1dUVxy+Q5T0IWV6Sl/fykryQl42Ogra2hkBQxBIIYQlSsMYWSoCw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           "],
           VertexColors->None], 
          PolygonBox[{{6061, 10010, 3242, 5871, 6060}, {7054, 6612, 6611, 
           6014, 1905}},
           VertexColors->None]}]}, 
       {RGBColor[0.6309143478526584, 0.6353659905475108, 0.911028266023874], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl3uMlVcVxc90LvfOHe5lHsjM3LnD3KE4UCM2JvjqaAwtpVCaUGZ4GWOV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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHlwleUVxl8Bc7khSBKSm+UmuUBIAhYFbbUlLdEWEYSyy9LKJoUEZLMh
CdCKw1IQBDsDQkWhlr2lsrbQAbXEsrYQlMVa6Cigtk7b0VahtUUR+nvm+f54
5p77fe9yznnP8rxf+/EzhkxvFkK455YQWvD7y7wQLidD2B4L4ba0EI6VhbAu
O4S14Cjyf0DfRAjT4iGMzAhhaYcQfgJWgyVgVCZjC0J4ATyCfLQ8hA/47cla
LzL+AOus5N0KsB85mR/C7aAzKASVqRC6g1p0mcweuW1DuMrYKyAHOTBnZHEI
I8DNrBD+khtCMe+KwPvID/G7ijHPgj7Iy1jrKfRdDJ5G7gf6grcwdjbrz8fe
1ypCiLUO4STPijsxj316gyLkNPSvbhfCJ7ybhP5nePZ2mxA+RZWe/H6FcUNL
QxgCvow8ifeb0GMjqEHuyV7f0r74t5b9kuy1nHnLQGGFbS9jXse29kEm+kzk
+QTQBvnJwhDqQR2YC0YzZi06vQBGIU9Ht4dkG2tPSw9hAc/6MbcvmI/8BL7f
iR92gB8ib+RZPr6p5TyqQRXrLEaXRaAH8iv8rmfsz8DLbWx7jZBuHzyO3IBt
A5A/B1eIlfY8q0y3T3ZzJn9Hz+7Ez8Os/xR+uaOEuS1DWNOKOUU8w64M/N2N
Z13Zsz/4NrgTHGH8OXAWHAbr0OE4e6yOOSYmoH8Ne5QStINvDeFjdKlnvTrw
L+RJ2Pg8+qyRzshniJMDyPvB6UiWT+QLPZuTdEwqFmcnHet12D6zwDE/ssAx
qNgbgXyRvf+NffejzzjsG4rvH+R86/H/LJDNmNcZewpkIR/mN8W6JeCQzhib
7gX3gE6gBD1OM+4Ea92b5tyYiI8mFDlH4pmOacVyS+RM9m5gnXrQBnkDPtuC
DpvB+nK/W4k+K1IeMwsb7sT/V/H1N5vjZ/SvJE+7g35Z3ks5q1zVnoo9+VS+
VAw+WWQfyPa5GsseU8Bj4JFy59oeasLuMudcNeezClvr8M9Bzmd2Tgj3kQdV
YBbyFs7zJGc1hNiZx3keRu9/ss5H4BDyM+xxAX3Pg+VFzq2d6LYj0zl2Ab06
o0sncB55EGc4usD1a3i6Y0kx3SOKqcr22A9exfZtvL+DdVLsXwK6yPfoVENc
VIM3kG9POseUW52Rj6P3D7CrF/Pz0D2NvRrxeyfs28x5fb/INVC173HkXzDm
NPPqefdj7BvMs4FgHvNvMGcOOi8qdO7JB8c4pxPgDLGzAH91RqfFvG8Rc84p
Ftfgl+cSjslfY289Y+rAr5CbmDuQd2dZ6xxrXGb/l5hfwPxGkI5eBSAfxMF4
xj8K/sv4a6AKO7uBrqAH6EhM1HVkL1Ca5dqzG/t3ZbsGaW5r/Fqb4TWeYcxw
4mwYWI7ckncPp2z7FMYcxd6F/N+EbusZ3wFfjFZN5v9F9FvHnqU8u4T8aJpr
TyVrdW/rGvQ7YrAmYV1bUjNuYHej4oLxb3HmCXw9kz1qQW7Sc79DnIws9Rr7
+P2NfsHeUu99a7lruXRoynfNUa05ibwBfIAdR6gvKzmPre3sc/l6C7ibeLjA
WufBXZ0ci+pB6j2KyUvE0FiejwEXc5wb6egfTzhHLuPHq9h0BVzK9ljFoGJP
c6a3dY4rt6e19dzNzNtU5jXkq1noOCLNPpvNnEE8fxP/HMQ/vdXb8p1bDXH7
oh7URT4Zyb5VoAcYUeHeoZ6uXq4e8j7+7c7eXwPvZbqWyWbZqppWgs47eVcU
c4wfwJdnyt3bO+KvJbzblmfukMaYv/H/wYR7axP4UpF1lq7vKf7Qtw/vT7Uw
p2inXss5vhpzT1Hu7ZC/MpyDE4nLlWAFmAAm47c/ouebYBLyYNbqk3ItVo//
fco5ptw6HXct0hyNVU2an+M1tdY85NeSrtGqzY1J95aP2P/DCvcY5d47jH27
o3NQsaUap9qmGDvJXuPynItnQXqua5pqWRz5U3y9L+Xe9d0M1x5xGnEZ1SDV
lm283xd3jVGsqYccimKukbGfkcfXwMFsj70/07VFc/6Kzmvz3Zt2x1yru0a9
VTVbveF5sCbqEcp9xaRiUTVAsfYFel7PdcyJa7Xh3W3Z5lziWupxWRHneoA1
eqXMbYbi7yeynePK7RfpOa+jz1j8cRVb18XMfcQxXo44kHrppSznvnpqTalr
impJdanPeiFYEJ15Lud7AL32gxzkIvbbzhqFqgf4dDvnNJr9PmG/j8FY1TvG
XUG3pXFzvQV5riXifKmUa5Rq0xDe78QHE8RvM8yR5OtT7NGUbZ/PZ/xc3m9k
7Ia4e/nWqDaop59g7d8W23bVEMXysVyvrZiemO8eqd4oDvMs7ydj61dbumdW
sk6vdu5lw0BToXueet3JQvdG9WT1YvXI3az1Bmv8lLl16JvkeRFIxlwT1DvE
EcQN1EM24sMrme6Fp+BjF9D5z+Al/pehzy7WO5X0Wc1kvR9hz2fs24f/rVqb
S0/j/9RCc+ph4EaZe83lFuZe6onqheJgqjXitOKyqjldCtxT1UvFIYfgz0Hg
XeS5+GggPp6SZV0+TDe3GpJwLRPH2o9vG7LNZTYxZwzvJyZ8tkvirq3q8ert
qrEx7B6fcC96DByqsE2yJQ4+Z61bSlyb1KPvLnYNUO7fVWzurJhTrIlDf539
vpHy3UQ1a3WuOb+4/irkZaw9oIN1z2nt2Iujw9QMx6C4zKiIO4nTzFCNzzf3
E0drUB9m/anR+srF8/j6T4XOSXHpLqB5s4hTU3cGsHd/8BxyWrF10N6KKdUq
1SDVHtWs0di1k/c7wCjko/h6AL/9wRHk6/ijVaSPOKm4yPGUa6c4yTvovSfh
Wq8e3FNziszlpZN0r8/33Ug2qNboDvZ0VHN013mAeOtZ6juPuLE4V+eII4ur
dOO3a9KcZRxzZrTz3UacQ7b+HDu35thmcRXVcNVucRbdZdTT1ct1p2nO/GYp
1ybdIVTLGvBRfbFrmnJbdwTdDZTjI7BtaMq9STH5P2L7WpnvirrD3WBMrMDc
rynNtSeZ7VxRDRqQcI1XbRcnky81pyni97Jdd0bdFeUD3RVV01XLdWfUXVk5
qtzUnVlnpTuj7oo6s/vwy7vscRlUIX/BeZxFPgOul/tuqB6u3q07ori+OLa4
tTj/JPZdXOq7WCM2ZVSY84nrtaowdxycci6KQ+7g/yL2mRJzTVGtWZvnWqua
I+6eHnFLcfhz2H6pzLVLnHtpge+wursuKTB3KM52rRKH0F1PHG1vdOcbk+ca
rtqtni/uqTua7ma7orObyF4TOvgMX9Edi/HprX0HWJjnHFdu65m4oXTQ3uKI
inXlwKgo5uU7+UC2y4e6+1dFXFjfABSL8nlVFJO6W4+MuJPu2L25W9zMNBdV
DVVsigNejGJU3FjfFPQtQRx5cdIcU9xSPn0y4Z6iXiKOLC6jnFYui9PI1jmc
zews26xaoDuu7raqCfrWoh6h3qBvLuIqujPqrijOUow/9qZ81ifw5z8KXWNU
W3RH17eVZPTtRd9YOiT8zUffetpHvVbPJKvn6ltPI7oczPI3nz+kzDnENXSH
0d1KNVG1UHesm8wZnnBviMXcO8TZxdXVQ66Bykx/S1CP0ben2nx/O9A3qAUp
2yDd1XPV25cWei31ePVq9QDVfvXsI9h8OuXeoG8M0lU1XbVcOovb6huJvo2I
44qbiLOJq4mjiCuLg1RHnPl7CfcQ9Q7V8D1Z5rjituLgykXloHJPOSmuopqq
WirO8n8s+9Iq
           "],
           VertexColors->None], 
          PolygonBox[{{6154, 4974, 4973, 6664, 1590}, {5797, 9901, 1875, 6957,
            5796}},
           VertexColors->None]}]}, 
       {RGBColor[0.6551391669147812, 0.6742885341527424, 0.9115805172850279], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl31snWUZxp+uW08/TrueU3pOd/pxykZbCR+iJpqQGNNsZDr+WNsNlpJQ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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHlwltUVxm/ELASQj4RAQraPLF/CIgZpdQozoFO0sgioFYhDKC6E0AWr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           "],
           VertexColors->None], 
          PolygonBox[{{6494, 7173, 2001, 4109, 6493}, {6758, 6538, 6537, 5491,
            1789}},
           VertexColors->None]}]}, 
       {RGBColor[0.6793639859769042, 0.7132110777579741, 0.9121327685461819], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl21sleUZx29aStvT89Iy4Zz29PQcStvTaJSKC8axzIVsBT9pEPkwXzJt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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHlwltUVxi+JkEASyB7Cly/5sjPGGrZqhzCT6CiOWgTRTgtI0MIQAtoN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           "],
           VertexColors->None], 
          PolygonBox[{{6720, 6728, 1629, 4572, 6719}, {7261, 6557, 6556, 4189,
            2057}},
           VertexColors->None]}]}, 
       {RGBColor[0.703588805039027, 0.7521336213632056, 0.9126850198073357], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl1tslVUQhXfp6TktbTltsfZAezi0AQpFEYqJD6IkqECiJoAaFUUUJWi5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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHlwleUZxV9IuCGSEBKy3OSS3CSEBEeqIdDaDqEStJCqKKC2SjoGsQwQ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           "],
           VertexColors->None], 
          PolygonBox[{{6716, 6277, 6276, 6715, 1768}, {7881, 7874, 997, 7872, 
           7880}},
           VertexColors->None]}]}, 
       {RGBColor[0.7278136241011498, 0.7910561649684372, 0.9132372710684897], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHuQ1WUZx989LOcCZ3dZaM85e2EPrcEqGmSWTQYlM4IImDOGAoKSDKiB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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHtw1cUVxzfkcRNIyOPmcXOTmxsS84AKCoHadprUxGIJpEUQgUgCMUoL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           "],
           VertexColors->None], 
          PolygonBox[{{4115, 6616, 1741, 6623, 4114}, {7887, 7298, 7297, 7900,
            2338}},
           VertexColors->None]}]}, 
       {RGBColor[0.7520384431632726, 0.8299787085736687, 0.9137895223296436], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHmMltUVxu/s28cMy6x8HzMwyCKgTQsjIFaDS1KWgoIim2hBQDapBWps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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3lwleUVxt8kJCQazb7c5OaGXGKCRekIpJWZGkbQmSYuI1ulgmnDIkKC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           "],
           VertexColors->None], PolygonBox[{{5754, 6625, 1742, 6925, 5753}},
           VertexColors->None]}]}, 
       {RGBColor[0.7748736967145935, 0.8510806131361108, 0.9085462828429421], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl1twlOUZx18SyWk3Wci6yW42yS4bAswUplYJ6EyHRiL2pgOKndYZOtNW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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3tsluUZxm9bKD2xHj/ar/3afi18bWcgW4QiJgttBtsSUZiIbgtmizA0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           "],
           VertexColors->None], PolygonBox[{{6626, 7325, 2065, 7327, 6625}},
           VertexColors->None]}]}, 
       {RGBColor[0.796629228396707, 0.8583355032554255, 0.898799824145197], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmGtwVdUVxw9Jbh43uQRokgskuTfckoQwrTwc5A21g3SKEJC+sP3UfhGi
YLUzYgEFp8V2kCpYQVIgBOUlZdopL0VoxdY6dRQQMgUKrR/8YAXH4uggDEyn
/f/uf9F+2HPW2Wfvtdf6r+c+w37w4PwlJUmSnO6XJKV63pdLkoUa/aqSZGpt
knxdo07zczNJsl9zV0XvzifJ2Ha//7s5Sa4NSpK3Kr1+msYXtWZW7IVekkqS
6aJ7dNC08iQ5qH3TUvGu+eFa05LxOubONybJyhFJsqsiSSbr+xSNL2jN9f6e
O6s1R7T2H+KzPGUe0+OsX4r/Ia1ZX5YkfZob0uL3SbXmBR/WT41zd0iXV+u9
fqb41WvtE6IPaHwmXhP0zA1NkgtafwUZJOf4dJJsKvPzjrTnKyXH3dpboWdp
NkkuNUnulEeb5rdp/aKUddks+XVkUQaw5X1y0Fuk+1b0156Dpeb/gWwzWLKN
Ef2s+Nwr/t2N1v05vffX2o+0t7Pc+y6njP2sOGtbifEF2z/pkB0DdYbo6bLb
U7Jfjc75s+Z3ar63xDrs15lrNRq1rylj2ZuDLiTmD++izCVetzmeuVjT1d80
3+8X3ZaxLMzlYw384Nsl/kt0/htiOEFrhmUs81itGa2z+jR3u+irkrVeOv9K
74WM17FG24s21qdkYMa+kQ1cJwW28Bgddh9Taxqe2+ARNPPQyDlaPn4x7M7a
MeHDLXEu/soTOR4EHxn10YLlY01byIYNr2Vsx7HBh7Oyms9r7Qnx3C0f2zPU
/ve0+PQOtV1rZOce+VJnhXGcFX6+QfRGDWK3o8TvxG+T/PmNevsbMTavyjS+
WakY3ae5siH6NkC+JHl6xXu7Rn3KcoANvnmxYP/ANzi7t8prkG9m0BM1cpXO
HXurTOOzxMWUGsfISsmzKu/9h/VtRthldI35EGvM3RXzF1LGir0z5DN3aXyi
fdfSfkfXfwXN/GmtfVfjYe1bpj2z044F7EbcYrslop9q1TedMVP+/jWN71Xa
h6cGnuQVvo8Sj/UCoC5vmZr1zOWN43btWyJMfqa9HWXmQS5aOFh6ynfvKXE8
fSVwSwWW+N47EfMK0eRzra9pse4PyL6LNRbo/DmK69lZx8LklOduYcwTbKu0
L61xSu8PpXz+V8VznvbNzdoPwQffAKtndOjzjcbmbN65g7yxNG098AFyyYKY
RyfyLHzPaf4vI/x+JW2+YL5Y+vVKzye1dmO17CZsekpdIzoznn9FNeS9duet
SZF3iU188uNKr/9cfG6Iz5uVzm3kbvLbjQrPjdeaK6WuRfgOtgJDfLRd/Efk
zOs/wvP9Ztcm6hD72dsYeYu89KGem/TUkcnrMsiCgnMJGKwOHOCxN/jcVmO/
xLfJUY2Rry5J33qNxjLbtKnMMp3U91Mat5c4n+CT5DHyKPlUj6JtfxH25fvp
WEO+2FvinNaXMS9yy5ag4bkqHTGs+QoJUq7RJvrRBtlSdq0T3Zvx2RNCrhPh
c8U9KedzeOyLd+rAnqgF2zPez94zer4T2L0m/t8UviNT5tlQbb6TI/7BZ5Ts
PEbjoDA7rvWX27we/0Qect1j2jOgn/NVRX/XV+K0UjZfqnUdKevfrXFbic8/
kTH9dsgDfShl3uRS5s5E7aDWbM1YF3JyX2BITDwTcXF32jWdsx8OGyDjUWF5
TKNdupVVu45iD2yMrbEzvHuC/0RhllFcjEv5eaPB9FGBvabVNbk75EbmkyEP
MpBfngvd6TnGhV2oj+BP/QV39hIzn5Y6JsAPf9ga9fSyYnNn3r0NuB+osT3Q
75GU+5bd0mlPwTq8G76BvtQcdKUerq5xTiefE3/I1KEz52Tcu1A7toVvUBPJ
y/hdtp/ntofMTWELZJ9abp9DL/q4VdHL9YT8xRhRnP222bGHbpyJf7wkefcW
7Ge3YoD8TF3gbM4tYhB8rqddI6gP5LiOkI0+jTpC7b1H9l+ftc3pWedGjvo4
8he56GTw5Ex6yw3Vzj2bhHN31vl2h3z8O1n7K/H3+wZjUZd2bOAnnIctrkQ/
kor8Tz7F9uTqDZEz4T+yxPoTF7dyCjWCPrnYI5c6hlNRO8ivyE+Ool97KXo2
ZF4e6zlnQpx1IGj8jTM3hL7E2t7Ih/QZy2LNHaotf5duc6THxZRxB9O3pPua
rHsrsEMObEcuwJ+GR39FXSTeb2bsQ1ejd+qJ3uJU8CvW6irHAvIerrEf48MH
ggbD/72X+gm+0NTbY8Ndc/8pgI+KvlBtf+BJnSI/vB0++VmpYwm87xvsGkD+
pz4RX3zbLh1f0Pigxr1be/Rv+CZxgT9/kjYv+MyIukQOBH/sSQ+DP84Inzxb
7fpV/Fbld+henfOtrGN1sXT5Y539+Rua26xvP0o5lxyrN0bUr47o8egdftrq
/oEe4XDg9t2Ce1DqybMRx/jWbvFfWrC9qYHUYXLLcvnve0NcO+br+5GcdTsi
LF/VOF/tWF5R43hGd+ZYk1WOb27zN/rNZIhzBfkH/NALHYg5/LCyv/M+/dnK
cn9jvjNtXyNmf6N8MD36UmTcFPqiC7kJfeDDevorYq8z9nbJkd8c4rpP/ae/
gQ/86Heh0Z/cjs9vVu5c0+C+FVmRCXnGCdtrta4VG6PXLNq6v2lsQD6oih7s
yFDXY2R5XLnixQGO3Yk6ZEu7+XYH7mD+inB9TbY+JxzXZX3noeY+nbUf4ANr
RT8w0LWjO/qCQZE3jkSMg8Hs0P1Lw5Lkyxq70s6zxBP5Bv+7lHKMlFS5ZuOv
Q9OO0764Q4yM/APPyrARPSf88G30vhI4EAP0NOTqnirfDfCfHwqzne2u58Rc
d+h7NXINulzWPeNO9BLvimb7HL60KfREx3FRPzineLcvt77YtnSw7ct9elrU
JnwKmfEHML0SPSq958s5x3eXnotyxuDFdtsGu9Cn0N/QTyyTLD8uuP7/XLbt
HOCe69OIIXR/f4hjBn3zcc+lHzgu/1/X6jvPk3qubvX95rDOPJRz3K9t9b2O
XLtLMvyhwb3MC02+44Fjp+jZTfbfMsnwu1rXlnLR+2t9X6xuMdbgXCn6YK3t
Sc6Yn3VcXZJe41scG9if3DEo8tjasB0Y/i1tHMnxF6OnGhn3DOiO+IaPce+k
76CXXij6+az7YXoAehd6g7agqUdFO4TPUK/pz9ifCxrckO1y+Odi8dyUdb5l
7lLITLxeDvrDmO+IeOKd/LA05O+IfoFz6Bmw9/m0/Z5YBTPW5KKfZx2YrWg0
bjlh1tzi+yu9w4XAhBjZEPepKfEfCRxWCeeVbe6h8GkwpWfqi/8D9HtgTJ8B
zjfjH1rxn1D83wC3MfG/gRr5E/nJunrfPzoijqmn/DObF//NiE/8nnr9mPLY
irxjEfwW1RpD+vt9ce8AA+oEOEyPf3ScdSDipyb6vZvR8307615nafSRj0Su
/nWz+zbqPnWW/ILtwOp63Nm3NjlO6uIs+ilscSruMmDCPzn6V3pXsL4efRq5
aXLcKfKRn+gZTkT/T59P3HzU5tiZEL0DOMyO/g9fxUeuRa5Gh0NhxzPx/6or
6tJDoRcYQ4Nze/y36Q1b0zuQx44rZ4/KOR/8VXify/sfE/fIewvOcy8P9d2A
HMb/g9fjHwL1/nD0BsTN92sdO+wnnzP/xAj/p6AnwpeXpv7/v2hb+Mn92tRV
MPb0Po/HPwd86mb0WvQe1yMH/hfV/Lg5
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3lwlVUSxZssJAYwC3l5Wd6SPLKgjrgB8Q+XxCJolUkEWdzLtUaIJFSN
VUZDWFxwQVQWRVSIAYQEtFwTAqIScKBEk6EYHAk4U+UyghsFriAlhb9Df3+c
ev2973739u3bffrckjtmXtuUZGanQAo4WGZWXWxWBb7Bbk6YtYCUIWYbGNhb
bjYA9oGt+o2bfQZmpZr97wze893DWWYPga3Yb2Wa3QYiTJ6bYfZ+ntl3fFeP
Xc43b0TNXgdLBpnNTzfbHGOOXLOfk81+AW/z7R0gzvdhvmllrWbmqE8za2O9
Z1jn+YjZMvA09uF8s72M7+b90sFmF1aYJYfNLmGttxlfjr0iZPYSKMOuKTSr
A7VgHLiBvd4IQqz3G+vPyDa7O9/tUex/PjEJ4cN45jp/KP+zl2zGZ4Ffsb9g
vVMaTyzrhpn1M35Njtlq0Ifdy7e7GJPNuzDzfV5A7PivBRzAnsPvPOaZz9wh
fN5SavYB8TjK+gc4gwH8Mfw8xdh92P9n7Cbi0QO+xv6UdQaI5z6wF/vjPPdR
vu3K87k2Mee+IT7ni8yxoshsLvGqJ14RxvTi51ZQhN1FLBvAWcSjkPgfZO23
mONN8A32MdaoI/Yn+H4X53cU+82RnCs4gn2MWDQwppK1HmSOE/g1PXjeyfgf
8KuXdc5mr91gOuOngYnE5nue+/BvCv5NBp9gL+LchhOjccR/FDF6Kt9jolgs
xL6OnLuL2NwJpmJvwo+T+Pon6ME+t8RsLX7vId/WsZ927GeYswXfzkzzXFjG
PM/le07sJB97+HYj2IH9FDnTyjz9nF8D/nXh/xL8XwzewW5ib21Rz+XHwAfM
cQW+7Ve+M/8CnQFxifFuwxnu6xCeMyLu81zm6OCbUJrnwEesNcDe1/F8/Eyz
VYxbHfH8V358SS69GqxXj0//JQ8/B0OJbx1rVme7D1p7FGPWErtXwOIUr5Fy
9rQRhPFlGTnRybsomMBzl+qL/c7Gh93MPZP1ZpA7L4Dl4B5QPZz6HmF2K6jC
7mZ8Ap9KQBd2EjhPNnvZCC7APh8cMf/vn8R1MvOvYv6LOfOtPE/A/yMZnqMn
8f0q6jod36/G37PyvKZUSyOx/+BdNWdaBY5jdxK/1/j/VdCBvUi5zPkuZ7+X
DPVaLQbxoGZnEfOXGdsGWrDXl/qcp+fCvoX1V+HvQb79hfpoZZ9NoBHMAv28
qwt7LkSHeWwWgCeCGM0mB1dFPRea2dNixs5hv3sY+49Uz82PGber1HN0NfO1
g/tSfc0prJ+HLyEwGXsB3/8n7lwrDpnJXBvY33rQhP0V83SIv4jddyCFufaz
twGQjF1FPswgn64nlgP4M5z/zuG/s0EO9m4wIexnnWD+8Yz9lm8PgRrsNnJv
JchN9RysLPIxeje2yGv1LnBnULM9+HM3+TUIfz/Dn08znaPFzRew/ra4c6K4
sIYxB8q8B6n37AfdMZ9D3ypHFVtxgrhAMW5ljYlhj+W9YDsxnEQc2vD9Iubs
j3kNq3b7Yh7rf4M9QczVy/rAJ0FPU6wUE8VCMVPtVvDd4XSv4UEjnGPFrYbd
E/M9aS/5+DeR2G/WvOJX/uvk+38xVxx/VuLPWuyp+NuMr+nEoDrhHC1ursIe
GfOaVC1qzXeZKy3qvVBzXkYe1Ad8q565kHdjyLGrWesdcvw8vt0Uc1/UQxuL
vAZVezrzZ/HnFur0ZrAUe2WRc664Vj3gPfJoYZlz4bMpXtutQa6rxpULyinl
knLiEHE4gf2HagR7Xtx7mLipHR8a2NOhXO9dx/ExDV/Ti72X7E3y3qEaUW1o
T+rl4nRxuXq6epk0hbSEetroLO/h6t0XZXkvUo2oNtSTdLb9wVnrjEvJhWvY
az0Ygf14rnOYuOsx+cXZxZi7MsM5KRV7cLFrjX78O8Eea/HlUs5qDHtK5l1K
sWuZviTnls2FrmXEMR0FzoniwnUBtzfx21jgHC/t0B7x+EhDJDP3yaj3TvXE
Wt79nuO9UfFQ7kzDR8J4Oof28NzI84U8VwzzXP8w13NLOd+ZcB/lmzigmfVm
x10rqWY7C70nqxerx8R4FwEvpzjni4t3MF97knOytGCt8ivQhKptcby4XTXe
XeCa4bRWKHBtJU4SF0ljRamph3TmrN1KDs4h5+5JeC6ox0d51xtybtYZtBOL
jrhrtUfVIxN+JjqLPPZzHeuuq3CtoBpSL/1bifdy9VRxuXqAuL8t0DLqGeoV
0jTqDerZ6tXqEdJOvYGWlYaqITaVYCwYl+9aY3HIuUmaYyxjtrPPbWAM9nsJ
z2nlcgX+XSntVeS9+ib8qWLMT6x7FFwu7Yu/30e8F0uTTmKNl+KuBbo4/7+T
tw0gieeNya6Vfg/OS/khbSKNJW0ljVKV4xyg2lfPn5TtnCIuuTbbtYk0orSh
NMoYYvU1ufkVGF3iWu24dFrENZu09dy41674XWcvTTU1yIENUdcc0hrSuNsC
DS3t3Bv22IkTxAWK4fSY9xz1Gu3pfvzqyPa7hDT2k8RlS8i5ppb3K5h7Uti5
fO5grx3FULFTDakXSjNLK6sn6q6hHFTu6c6hvR0Ieof2KK33cJlrRWk+nZ3u
DLor6AylBSqD3iVN8EDCNbG0sO48j/Dto2Wu9XUG4k5xirhEHFpJTMYWu9bS
nUZaURpZ2liacVapc464pgV7e6ZzhLhhG/bSTP9P9hJwLNM1h7SGOF25o5xT
rimHxLXiQHGfOFdaszHHa0Ua0Ar8DqK7h2pa3FcT5LI4UHepLQnPVd2pdDdb
n/Da0h0tg70MKfbetJszuF56hdhcNtjveFN4XlPhZyON8jzvlhf5WGloaTf1
QPU+aTjV/uNgXoZzgLSacnB0oNl0N5IGk/bSHUlaZie/O3Jc08wjzg+O9NyQ
Bp4W8xpRbUhTTM90zSKtIk6sz3LNKK2oNXV3GR/1WtQdRlweLncuEqfrLqUc
Vu7qTiVttijsWlQaTdrgMHP+mOUaQdp/YdjvgroDSBs/HXatIY0sbageq94q
jbgmyzW1tLRiKG28NDhraeTbM11DSjuK49dnO8eL28XBqk3dYXR3UY2+S0x6
Cr0XScNPzncOEXfoDiVfpWGlXeWztJ1yULknjafYSsNIuyjGfwF7gmd5
           "],
           VertexColors->None], PolygonBox[{{8059, 5752, 1300, 6622, 8058}},
           VertexColors->None]}]}, 
       {RGBColor[0.8183847600788207, 0.8655903933747402, 0.8890533654474518], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmG1s1tUZxk/79OVpi5SWllZon77Q9ml4kcLotCUMXJiJc2y8SBPJYNMl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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmGlw1dUZxg8kNwlJJDcLyQ1Jbval4oIWCDBjIQzQokQUhNrOSIvVEREI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           "],
           VertexColors->None], 
          PolygonBox[{{6834, 4410, 4409, 6839, 1824}, {6742, 6736, 311, 4118, 
           6741}},
           VertexColors->None]}]}, 
       {RGBColor[0.8401402917609343, 0.8728452834940549, 0.8793069067497068], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVEtoU0EUvZrSvCRo0zRCm7z3TKiQCm5EKVIQ7EIEBZEK1ioqduHGT1yp
tZt2V8SN6xYEP7hRkFZdFAWlFuPCLBq708a99YemNR/Bc3pmMcy8O3fOPed+
Xn60OHRls5kVsSJYe3yzVrfZZXystptdiJmV2szmsB/FurPJLBuYdcBvKWo2
mDJrhmZb4L8C/4/Yn2JdhT2eNRvA+cV2s9/w+YC3pxJms57sxJvyhHkO96ex
Wvh+APw3fWa3cC5gTXrCHYvItvEWOBM478K5Cv9qQbj/EHM60N04fOaw9wN/
MWl223Go4X4Na8HT/Svncwmcv8O+D5i/cP4W6G4CmPe7pKuJ3DSwZqC1A5it
QG+HYDubNluGTwZvmp5ychwxp/G2ge9H2IdD3THuM0+xqshlrtNsJ76f49wI
hfEVMfqjyv9P4J9JKw+MuTWpuMQgF+K0wecacr27XbUox+VfiQqLOAeBvz+p
nFPHXl/vX2aknziPYVsDhx5PeohF7euIez6lnB+Az/WcalIL1QfUyxys+Hr3
DvYyVj6mPmK+yYG1Yf1Y2xnwfQ8+ZfCpA78GnEXYPwHjsy8f6mEc1j3RC3tK
taXWzqTuiTfp+iWRVS5o74auvjzyHdE9/cj/YkqaqZd9czOhno8BP96rb/Ya
+3XA+Yy4cz0Ub3KmHuoiP8YrOa7s46ynuOzNlUAYJxFzOKPZOoF9Nq3aUPN6
VNyOZXRH+w+8+xKoX+pRzeHGDHrqEXJgnQtuRm7kND/kzhk95OaUNaY+6mU+
5n1xK7m+GHNzSxsx2YusO+s4DsxBX/yy0L2wTbPL3lx179mb6Yw4sNd7XP9z
5l4nNXeHgXHEl4551Oets3PnP4Jnzv1Dx/8e9mJK/wjG5jtqJ+eKm4s/ofqV
8ei35HzI92+gd3e7NMPUl4S9GciPvVnZof5shZq9jKtZ1uV22eWF5xH372Ie
n8B3ys3If2yNzyw=
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJw1mHuQ1mUVx58FhQWCvbH3fV/2ypJgQcqCMA3INWgERBPMJkdn5J9CaKYm
UcFQU0DBABEKzAsUqNkkJCTaH4COOgrNlDjDAouGBiRgQFwXs8+n8+uP77xn
3/e5nOc853zP99mGO+dMv7tLSqmqIKUr+Px9RUpb+6f0KngZ+ze5lNaD7/ZK
aUlhSnNKUyquS+mv3VNaxN+3l6XUf0BKLeD72P9g3nbmvQY+xT7H3NGMn9c1
pV2MLy5OaVpNSp91S+lvrHGM9S63ptQJjmJ/yW+TGTMJ/Ad7eGVK27C3gmHY
t9WnVJuL/Wf0xOHylGYy7jjrNfRI6amS8ElfVmHPqk6pN/t/BdyFPaUqpWr8
qgI3YN/IuIl8TgDTsAex3lx8mQMGYrf1S+lsLnyfxfrd+H4/Z2sHV2Ifz6fU
yLgG8Bn2VtZ5oTalTeBV7IPs+wX2z5jfCjbUxhzHrse+wNrnwSDic54zrcWH
l5lTzdhL4MmKiKmxXIk9lDNt4bybwbXY/6wIn/TlWEX4Vo7dtzV8bGOfZznD
M2Ao9nbu6cu+xBa8hv0cY15k7RfAs9gL2H8I4waD+WVxlzv5bUf/uNNtxDDP
Z848wW7jXgZwL61gKPYMzjQL3AVuASPzsaZrjcDu4I47ics67uuPnO973GcR
89oK4j5X4tMb/P06WDEgYmnM1mcxHcmZi/i+DxiB/Wvi/iPsueBp7H74+TBr
PgTy2OdBWWNKpeAc9ln2H1cXsX6L/eeVRYyMzT1lkStzOdec6siZ69jzW2Ai
GF4be/2OfV4qjz1v884ZV8tal0FjY8xxbAP2cOL0JmvtAsOwx+LXFHADGAOm
Mn8ymASm5MO3yeBi9/Cxg9zo0ZTSvdTfZtZfjP0Qfj4IFmH3GBA5YS4UYl8g
tj/gjMPJp9ld4y49o2fzTo3dZfzorIgYWrvWgLlvDX+cizvybrYUxlnf4e+3
S+PM1sp1YHhWM39pgSP4bQPYk9nzOev91fFdQQP7cc5OkLAPkIcfg4/Afm1i
NJdxI/D1Vs74S87+BOsuA2uw2/FnJ3N3gH3YfyJv385HrVvzg5nbnX27ga9j
L+MMa8BqsHRArNVObPaVxJre1SugpjDuTF+sWWtVn4yNHCE3GKPlxeGTvvwC
O0fd9WOtPeRqB/svJW57yf0PwOPYmxj3BnNfBxuxRxOzL5pZF4zCngGq8LUS
3FIeuWUNW7vm2JtF5Dyx22TOYDcRs3/ngw82sOdq9ljJva8AT2GfZo/NnPMV
cAp7Iv5NBVPABPDz4qhZa/Vh7FvrgxPlwpnYm4nnEca1dQ9Ono5PffCtN7gR
uwcxv5k7ugkUYo/k+yFgMBgBnsaPXvjYE6xritrfRiy2VgYHfI3Po+xzBFyN
3cy4t/Bjd0GcR+6whq1dOcS72ci5Ogvjjq7hu27MuRJ8A3s8434Ct/0YjMNe
xNjx1g14FHsFOMFex8HysojNJeupLmL0YWnklLm0F/vbfH8F627pETWnXUse
TOkR3/VsipqylqzBdcz7F39/wN8LCyO3uhC/gprIsaGs2UhcGsC1pcG957jb
sxXBwd7tWPwaUxZ37F2tYb3VVXFnM2qi58zK8vsw5+gAB8HfwUjOfIZcOg1G
YI9kjwfxaSEYgV1fEjlqbn4V/96tjp5rr32H73ZVRo6YGzuxP2LeKeb9Oav3
GcTxMN/37hp3IHdZA+a+HHYaH86Dc+BUfXD1E9zFstbgbM9iTpqLnsncsmY9
izm2BPtufJ8NFtuHyJGLueBie+BJ7M9z4YscdkdpxHxh9rvaxJ5oL1SjWFsD
GXNVadSYvt+Uj97pGYyVNWjtGTO1zKFccKmapmtT5IS50AX7eXCINTrAc9jl
5N0E8w70xV7TFDlvrq8GHZzzUF3Eei/7HSwNDtX/+1h/O7/dno/esKVrcKE1
bO3KiXLXZHybVB4cJjfIaXKZHGFtFYOirMY6ifFYPseAS9gPEPd7wTywAIxn
zmgwCowDl6uCY+VWc/iT5uBgufcwdllL1Ly1XtoStSZnp6zm5AI5S66SEy40
Rw6ae+ebo7YPZ7lpjZ/kuyH8NhicaI5aPJ3lijWpluvHuvmG0HQbs5gb69+C
2fhaQvyKwQ8bg+vaif2+yuC8moaY49hq7DMt0WPtraexf8oe99SHVlVzqi3V
KGoTNabaYAlYnGmET7mHA8zbDz7B3kNOfc7Yk3IU9rTi0KRq0anY74LpVXHX
ewpCS6o58pmmdK2j4Ei2plppJ587WkIzDayInmmvvKoitICcPDPTBPrmnu6l
j641NtMKrqk2GcO86ytCo7zUHDlhLryI3YfPXk2Re2oquVsNpvaSw4c1xJk9
a1tD1PL1xHZ0ZdT0+xWhmdRK71UElzcTt6bW4PRlTcGxcuvSpuAme6C9T47q
NNfzwd3Wn1x3J+PuaArO+yb+3Vcf2mY5/i3g+7lgDpjfFL3enmWvsud/WBSa
R62ztyi4po04DG0JzplIfY2vi7V8E6iNRrP/qHxopJLi4EC5b0i3mDsy612u
IVe3gv4ZZ19i3sV83K1neDQXmkIt8UgueokaWu1sT1Ebt4N9mUZuz2JkbMxZ
tZ0cLTer8Yy1NWTt/C/mfHc2H7Gyx8vl7vlIxum7qKPnc/HWsiepLaZmWlGN
IVet+T8XVQZXWdPWspxl7plz5po5aKx9I/k2MuarikJzqDWeLIpeZo+wN9jT
rAVzzNyyJnx7qMHV3r5B5CJzqi3jJHuxNWzt2pPHNkZOmUtjGqMXqlnVqvZE
taRvQN9+asqrWXc+e90PBqlrifE1dcFdvhnkQjm5b8aJe0rizeFbY3dJ3L2a
QC1gDph7C7LcMgd9G7mHa/tGOkFsa3JRK/ZAuUmOqc44qjHTQGof33it5cGh
cmf/8uBae769flSWSzlQl+WUtbMqi6019J2SiImxuLkkxj6Qcbdz+hLTZ/D9
D11DY/h28U3RkL1h1D5qIrWQGkjffRP7dvIMalFrxlpRk3bm4o3l79bHetau
qole5B5qufFZr1DTmcty4O4sp+3Va8Gvsp7t21hNp5bzjfx4c9yBsX+sOd6W
7/P5XnO8Mb1Le7693jv1beCb07embwTXdo3Hsj18a9iT7cW+OdTyvglXZJp+
bS40g1rAN7W95ph9qDl6jtxoT7AXyJH21i7YBS3RY+0t3qF3Z49xrm9+3/qu
4VvY/4H4vw/fxM5Vc6o1XeNMPjS52lUN2xNfetUGt/iG8W1woC7e+r4RFuVD
8zre+rZX+z8N/5dhz1a72DPtlWqY/wKKgaOp
           "],
           VertexColors->None], 
          PolygonBox[{{4288, 7336, 7335, 6330, 461}, {9420, 5376, 2337, 9427, 
           9419}},
           VertexColors->None]}]}, 
       {RGBColor[0.8618958234430479, 0.8801001736133696, 0.8695604480519616], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVE1IlFEUvaXOONZMZpnTjB9OfRJDtBaCbIICx5oI2hS0quwHQoeg0sgW
LcOwFkVhtaiw2vqzUiqKlq1rV5ERlGaOqTkS1DmcKy4e7++8e88999635UTx
cNdqM7uGUYHxJWb2ptpsssrsU2D2BOM69ktxs/0Yc8CUMR+I63wgovOHlWZ1
odnljNmlGthKmXVsMPuA+1qcTyfNbmPdVyXbt1aZncR9ebPZ+4j8DLqvO+BQ
gM2DmKccz3f0E6uSL/ovOybva74lZslxtLPknMOo2f3IytuCn7dh7sdoQfCt
a/WGNreD/w6Mb3jT0mR2BOvzEGosC5uNZsWE2URMepFjCdxnMF6BQyXuz9bJ
5iDwc4E0JTfqRb/ncL+Y1D6F+58Ye4H5HegN8aPwMZIQx0ac924124fzK9C4
tVY60/d33N9wnfiuB37/gm9xE3xGdT/lGq6PSO8ucBiC7YWo4rpYozXzchRv
rd5sDbR6AL/H65S75+CVzkovatkclZ70Efr6D/CLGG/B42uF/NHXTthvd51n
krJLm53g0JUQtuhr+n3XbPZvo9Y3Ee+LlHK6O643xHPNmfaPZaQjNczFdcfz
WeTiXlI42uJbxtufkV3aZDzUuMdtDjlmFzUG5gK4z0KDZ1lhEqH2XFMz4qkt
52Ffs+5YS7Q/jnev66UB74lbjoMzfdEWOVD/vPOhVtQs7+s9iGUhkE/WGWPt
rpBd1i7rNtyGvGBc9VrmTA5lt0PMPPToAP+7EZ21+/lsoNqlL9ZmTaj6pJ6s
Icb1I6KcUs9SUr3NPDZlFCe5HEKu2lLCsobz3pus0ZznhTrk3Cb7Y1248u9Q
C+pQAsfPgWJkrQ14//Zm9New/mOYPwbqKdYkc0V8wf8oxvWyWnc8TweqFWrH
nmD/TnoP5byPqD37jhw4MwbyP91g9igtTMHzS7/zgf4I5vFMg3DLsQ57jn8B
Mx2IC3uL9c16ZC77/D9kPib8PzmF2J9mxW8YPkfoNyotR/1PYB/zjHr2IKbu
jPp4HNqPpdSTtEl75MPe6vT+epxWHfCe+WfeqBX/mCDQP/MfIaHimw==
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHmwlmUZxh/AOIDC4ZzDOcB3znf2j3NMtKAEEZpA1mAGEDWwZTQ1caYC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           "],
           VertexColors->None], 
          PolygonBox[{{8313, 7234, 7233, 8315, 2678}, {6700, 6677, 6676, 5213,
            1766}, {7453, 7240, 7239, 7183, 2116}, {4571, 6659, 1751, 6658, 
           4570}, {7234, 4851, 2244, 7672, 7233}, {7238, 8316, 2678, 4157, 
           7237}},
           VertexColors->None]}]}, 
       {RGBColor[0.8836513551251616, 0.8873550637326842, 0.8598139893542165], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlctrnVUUxfftbZPY6E1y09w2L5LeJJcMbDJpB4LgRG0c1IJShabQ0qam
D02pRScq2GgHDhIfk2oQSgQf0Aalgk2UQltahybECqKg4j9QHynYRojrx9rF
weG737n7rLP22mvvb+vBE09NrIuIOa2i1khXRHd3xD/1ESfbI0p6v1QXcfGB
iFop4sP1Ef92RFxrixhQzP5KxAGtW9q/rffvFPMFgBv8/nYh4qX7I1b0+3Pt
n9f+Oq1Lir8h/Id0dk4xR3oi3h0w/u7eiEe1vl3vOOJnC75/cqNjePJ+Ws/f
qhGvt4i/9k8LY0xYBZ15XtgttYg17T8jDtOK36Pn70XznSgYBwzwhxX/Y5/v
ZY+cp7U/X+cz+7SGhT2kdeC+iL+l0yeD4ivcafHtrxlvfHPEQlPElDjc0bqr
NS+c2X7rxd27dOZJre3C3Kn3Ea0FxVzs1Jl2v6P9eLv1X00c4hd1bknrsYaI
s6kl/A+J1wsVa08sZ8C+Lo43Bn0GPY5XrAn3704Or4r/412uOzVczDq+Im1v
9bh25AMvMEelzV6tJcW/2eAnWh2tdxwxD+rcNq390upn1eedLdKwzpzZg3dJ
ejdpvdYYcUU4T0u/7cL5SefGyubG/mjeRZ1PVl3rFT3fV8yoYs63mCs8+Q9u
4NzW3uHWiHOKmSn6fvyGH09tNGfqOTngmn4mnT7V2qP8l7X3Yrvrv6NoXDCJ
K2z435t4Gp8/3KzabfFv6v9lp7V4q2Qv4dupkn2Il8hnJXWjXruyFniUOPzJ
PZH41PbjzX6vJSY+faLe9QQHLoWMLyQ3eF5tMD5+7Ku53+DTJu0rffYSGGez
19CLnPHtB2Vrjc7Uh1qBh8ajqfPO9C/xzIU3sqfAuJP+n6jYo/f8yRn20Rpc
6vyRNJvVmhTGL7pzvGwM+mBvr3uhLP6rTeb6iDz7cq9nzXvNninU97p0Gmt1
zfE5ucMZ7ZkF+zIX9uCPlvgYDfmfGoCDvmvZX98r7x8arQMxzyYO/cL95AUe
+YJ5uGwfU9Nih3sA/3VpblxocX+h02RqdSZ7Cp8NKfdtVc8d+nIke/Mvne0c
tFZoRL/R52s5s+C/3Giu8KQ+VzJH8C5sMubNjMFjeI09fjObbuY+GlBTdIDv
H93mzLnljLksvK/6rQuzc6ji+UnfDFfdO+hE3dBqIflRd+Lmc5+6TOV8pi/Q
gV5ezjyI53kuf/OtuNpmD1Pbuzlr+S5d7rAHV/U8WnF/0Jdfd7gvvtHzRMW9
i+/rGp3Xc2V7bkfyxDtz6Q16GH/Ah//Inbnya9WcwACLGpErud3Ll5yI5z54
UWtm4UyX/UD/bcoepA5TOR965OsjZd/L3J1JvMWc/XAmZ/hSX3yAH+gr8m6t
OXdmzFJ+f//sds/g10Ot7hNwmxV7rOJv9amcKXiJOpzJWvwH2c4s0Q==
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHlwVFUWxi/pYGJQ0ummu5PukHToJYkSmMElgIlVhDVCiYggOFqDiuJW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           "],
           VertexColors->None], 
          PolygonBox[{{9706, 5679, 1222, 8260, 9705}, {7241, 8979, 8978, 8316,
            2040}},
           VertexColors->None]}]}, 
       {RGBColor[0.9054068868072751, 0.8946099538519989, 0.8500675306564713], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lktM3FUUxg8vkZmRx0AHtDQ8CiNJhYlVE9uFLqwLd6JSXAmS+khfDFih
VlOK0bQxKQ3tomBtjGmVJpXEjVpN26QWNsaFmpiUUh8JGzXGpoXGBUH9fpzD
4ubO/95zzzn3+75z7jT19T+zt9DM5jSKNOYTZjc0TIsHSs0Sd5ltLjC7XWe2
lNaajM7Wml1tM0tqryJr9mrGbF/Kbd/RqCpy2yfq3b6hxOyFMrMN8vP1vYqh
vW9kt6AYufD/UYvZpzVm3yXNpmS/O/a7y822axzU+nHN4xpVWj+i+bDGFsUt
UG6Fde7r8SqznevN/pHPEcWaUqyvtD53j9k1jUXl8aj8b7jb8zp7n+xkny71
u1/XSBf6HmsHi81mNa7Ix0MF7u+HVvf5fspn1rnPI6Vue1r4nJLPt/RdvdHs
KeEwovzrFesl7b0n31OK85/O7RHUMzrzsGyvFjt22+TrD+316k4v1vn3tPC5
VWn2k9Y7wUT+Fs3n7vj9fNK/e5T/oaRjBv5gtCLfRwscg66k+8fP0+X+nWsw
29TgPJ3U90D4zGseTDrmk7r7Fy3+/WWjc8m9X9b6r82ex4DuldfoU9yjwumY
xtaUn/m7yP1cFM+9Gf/mzMmIBSdgDvaTOjOh0VzivKJFdHJBevtMZ09pbzTp
9+SO2IIfmIJ3zUbHvE46HVBuy8rp8xaPTdxK+bmp+97RfVcqHV+wfVZ+ziRd
/5wfDf/okFho/o78TaQdowcVa7PGX8pvk/i9Kb56dfznQtcaOA8rh3TGed5R
6zpAAw8o/nKF18VYma9xdpe0U1DrOkXz6BGdgA02aBJMj4T+qb2BwPw18bJP
YzB4YB3eD8nfm21eW+cSrj/uuFd57VAex8o8B2b8v5Hyb/K5rPuWZ93/v8WO
WY/WfxS3HRnHjPpaKnPtja/3eMTiDHlgT72SM7WJHvORG+cWw+dvivVK2rVM
viPhB26nNe+R/QHxVdLm3+SyFGfTynGX8hlWPjnNfyq/5/S7HexbvTbpKfQQ
8EQHJ6KfMB+P38wnAvfVHtboGqAOqWk4HQ97/NCrctGvyG8h+Pog9IsmyRWN
sE+PmQ/8qdeuqNmSpOuU+yxLI683Ot5wOBhYwf9YcFQVd6EuyBW/xO2PemUd
XNEi+NCbt0V/Rjfwgfamou+Rz1ir91A4og7OxTo2/KZGbmn/UrP7pX+sxity
zX7S4Lq9Hhpbw2EqzlLbh0MD1E8+an+mzd8V6ou1/lhf7ZHRJ+EEzrgrPk8H
vutU67NtXp/EYY9zfXWeK3mC5WP1jucFYXt5nePJO/ZxxAX3uXgj6JP8hhd6
zWTEYqbv0/Pp5dVRy+hzItaxm4gc4GchuJgIP9iQ+4fhk77+fdbxQbO/hG7R
/ZqmqBdyh8cbsp3Juo8tTWZPNjk3YG/RN9DUtch/VU8J/w2ucAa2HeIw1+zv
PW8sPQ4cwLE73lze4/l4E/nGrjdqGS7RD29GQ/Ql9NwZbwo9ZHv4pE7RN7lc
VD3+nvX7U5eNGa9NegN9DW1UZ7xvzkSfWIm7k3tn5L/GE/XYFfdCh5yBD3CG
A36DIe9be7xx56v8bQCXM8JsuML/v3SFlvHJ2z4bfsCUO5Ib/wVmYp03/0rY
wQfag8ehlNcY+KA/+mBP1GY+6pM+NRQ2u3XfamGyP84NxZuNZndmnPutsYdu
E1HH6IpavB06py++W+v9hn3iYTMqnN/WaA9O4AYe+d8xHfq9VONvJDXWcb/Z
t5X+JpPL/siH9wEfcP0/BPxr8w==
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHuQl2UVxx/WhWB3k939sb9d9n7fBWMRwQQR/gCRNJhJQBFmVCAs73Kb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           "],
           VertexColors->None], 
          PolygonBox[{{6674, 6702, 6701, 6699, 96}, {4232, 8375, 1730, 6585, 
           4231}},
           VertexColors->None]}]}, 
       {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
        GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHts1tUZx8/b0gJ921JaWhq5tlDuLZcYkajdopkhm+iGRYgg2RCDCpRb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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlVtslFUUhXeZzrTTTtuhw0zHTjvOTPtTLIqiRm004wNCqqYv9ZY0sdHG
xqIRoiVAQFPRoEastRpbaAERbTGAQn1RMaCJUZqq4cFoNFqNifGFEqkXEi6x
fjvLh5385z9nr7P22peT71nfuW6RmW3BSrEdWbOjDWZHQmaRqNlkwuzZjFlf
mdlsxOw4e8vzZhMVZg3lZrsWm/U3mb1aaVYFwCuc/zVnNsL+GP+u5fxKbDJs
9gQYiXqz3jrh/QTe03wPZ7Q3wZlVgVk7Vh4zi8KhwF3H4mYzJWb7wfwkbXYI
vDrufpf92mVmRTicY39zldl8s9mKWrMwe2e4/6kWs2ewfyuFMcB9W/GZ4exK
1ttZh1mvrxLHAbi8DcdT7D0MpzMpszv5dzff78BplvMjxLsbvAh3JOBXjb0B
t33Yg/B7AOtGy1nw1uLbhX2EyHGPF37XwPc0+NNgLKBVKf578N3tGGCPY+Uh
YT6C762cvxGs++AwznpPnbBXg/cne8cLZleAtRz7kdiPXUZe8F+LRVsUg3Of
jEn7hnrl0nMwRL6n48p1GbaN/BX51wn+BP7z4PekdVcr+CX4P5oRlynOnyOe
YtLsLHt/YCf4/hD8PPuj1MMGtH2Tf88T7xQaLya397C+yNkL2KYas7fA/CYs
zWrhugmfjzl7CJ818DlMPJ9y/yh8Pkev2UbF9wL63AS/GOc3VqkGFlKqCa+F
jZyZIbYVaPB+TDn1Wt6fUO15/GMJ5cC195x67f6OjVaohk/Cb2eNcvce57vR
pier2p8C/3HiH1yiXJ7Efrvc7Beskdi34rMI7UrSqjWPcRhuL8L/MfyvqlZu
X0aTm2PKscfqd/pdHvN2zhbJ6bpy+bRz9w44T3L3/WFp8QP7fSFpchtaXoD/
GNy/BdNYT8LnaFQadGbVQ94758Ebgc/4MnH5Eo5n8X0d/HFi2QXGDfhvRr+v
8Z1mvw3/JxOqjdeI8WpyOYcGc5z/ijNDxDIYKPceUzv7YdZ/VQrDvzv493el
/j0H1kvUeyGimPrIX81SZgpnL5Wqtr0Gvfa8xm+HTzqvXvuOM9/Xaeb4rHGM
A+T3cEba1+N/C7Hege0Euzuk2kqk1BteYz+n1CPeGwewGHoGSfl6D3hs1yc1
SzzGAtwalqq2BuBQzfeJgnrPOXstnk9JG6/JbcTW26Ta9RnZhX4HE6qdIKLc
dmSVC8/xAlzmasW112cU8fW3SNsv0H9VUj3nvTaPXWxWzj3X3oM+23ym+iz1
GZcKpJlr5T13JKme9F70monmlWPPrc+g0znd6Xd5D3jteM97r3sNTRDLwSbN
Yp9Rw02aiT4LvWb+yamGvHa8Bn22bomrl33G+uxLt0hrn4E+ix6q06z1meRv
S+b/+eRvzGdxzSifTT7zN4Ddn1Nt+IwpEl9boNr1N6MtLg1dO585e9H63qy0
9jftFLlZQ7460OdKrCehN8zfLq+RVrCCQG+PvxldSc0sn1WXsOvITSbQd1lI
s/aDnGaR918AdqogbH8zhsjP3mbNBn8DWsFb0qje9RlxF3wHc6qlfSV6uyxQ
bv0Nqwh0p9/lPfMfmA8ZNw==
           "],
           VertexColors->None]}]}}, {{}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV0ltoD2AYx/FnQk0y9mfG5rDxN4ea05Jl/V3QGtqFs3Yh/lEO5TRFDjFy
CDNTFpblOEJxIYcVSxJxIXdGjmkukENR7GI+Lr793ud5n+d53+d534L02jlr
MiKiA5W9I7rkRcyltUMj9qFwREQ+ZudGdOZEZI+MSPWJuDkwYjLtyf7Df25I
ROngiG2JiBJaQ1N0YaGYQRHJfhHf2BfVv4o76n2U8xafhkeMtt9X3DrxFeIO
yp9G99JDwyLasiJe9I84wn7vXu34jPF81UURY+V/UaeE/qDF2RpKqsH+zU7R
Djpd/F95v/Adx9SrV/81fwM9ye7k71oQkYlJ/JvVr5DfTb1K2oNOVD+PVrH7
0Pk0h84QnysvgV44rWYjPvBfoJcxiL8QLeY8hX+7+rswVP5oJDFZ/Wm0AiVI
oRRHxbXKazD3RtTjgLntQUpOpZnNQav5XsmPeCC2jv2YFjnzoPV1/iZ9LrBu
d34Vvcy+wX8Hi9lp3LUeIyfPWzfb3+3dztL+7GJkI4HlauTTZXSHmPPWT5xX
7K7B1+yNM+hqe6sw1b85rJc61OKe2d2Ws9Hcq7EBK/ypLP+uF+75Ez/l3KU/
aFpvBbRRrVPqLmUvwX1s8k/O8Z1EF3YGLmEHe6tZ7aT18o5ggv7GYw9fN3tb
3Pnd/76cvYmdoC/N9D3fK9oyIOKWu+0X95C+NvM2/u7e9Cm9po+N8s7QMWqW
ius0gy/2ytxhJuaZ3ygxaXpCD9Vya7Ac5XxXnfFID8dRJLdFnZXuWoXn4uv8
4SasR21f/dBx/Lli37hvJv1KZ4kvQ9LMcvDXHJ/xl1svEv8PiU+RUw==
           "]],
          "2.25`"],
         Annotation[#, 2.25, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV0ltI12cYwPEn2qCIkYc8ZCdd5kr7aySRK/5dKOIKL6pVw4tolmvrXI4x
WIMsOtCBDtBRkM1Oo+wEUShYF5sr6CKsm3nhXCNsYWNWGKwi69PF9/99n+f/
vM97+L15yzcsXD8kIsb7qU6JGDImYiHvy43YibyCiDGYnx0xmBmROjkimRpx
LSdiJo8Q/y9/ckJE2fiIzekRpdzASV7ysZpxEfkZEf+Jz+rfglb9HprTg0f5
EVP8n65ug/oqdXvML+cdvHdiRNfIiD+yIg6IH9hXL/owTa7+k4hi85/oU8pP
OZEW8ZbLxS84ya+4Qv1L8wbQj8P6HdS/W/4InxAPyg/NixiGGfLf619l/geT
3BEP5+n653CNOIUXcQZ/pj7LvDR8hJ/0bMTf8qf5HMbK56HNPc+S/1H/rZhg
/hTkY6b+5VyFUiRRhkPqbpp3xL034iB2u7ftSJpT7c4W4Kb7PT824le1+8W3
ucCae4wvyzc552LjXuvX8DnxVflWLBXXot240Jwc3/qM/7f5bs2cKU6gCP3W
SXWm5zxg/QpzfnB/6XJzjUdxJjLwu7124LQ1f+MzvM7bWeENrOc63uqM21Bs
XIIiJDAVr72BNG9xzft3yGs5nVfxa3v5zrpzrLlanCLfb85m76nFO8223ibj
BuMH/LW99vBK/ou/cq4XfFw8wCf4uvdyY5S3zu38pb7L0Cy+IE6oK0YJ6kdH
3H+/b/93OWsJ94l78I/en7rHSrzxHS6a/4w77bEbHWhX/5iPcitf4Qt8irfo
/Yv93NMrIe7gXG6T36VPh3N3+/5daj609h2+5D1+68w/c6F7LlM36O088d9s
32ouPrevyWpq+bh7qTe3AXWolGvR/5Y7P4YCc9v0+cYbqEGn+v3O0YSN2Oc+
tnCJfJbaP+1vGP/L89TPRr57ysBL57orX2n8hfp3qY+r+g==
           "]],
          "2.1`"],
         Annotation[#, 2.1, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV0mtoz3EUx/HjUiTZzIwZNv7GaMiSoX9prCEP3LXkgdwfWfNAueSSSy4x
91tyv8y9UBtrDxjKA/GIMiK5hFw3sTJ57cH7//md8z3nfM85/2+feWXTlraK
iFw/k1J9ZEVMpdtzIjYhp39ED0zuHtGcEZGaF5HsHHGzR8QI2oH9m/9kdkRh
74iVXSIK6FqapDP7iukVkega8YV9Vv2LqFLvjZyXeNcvIs95mril4kvEbZVf
RDfSbYmIZykRT7tF7GS/0tdbfMRQvvIBEYPlf1KngH6j+WkR/2gRu5EmaRMd
K/6PvAZ8xV71KtSv599HD7Gb+Vv3iWiH4fzL1S+R3ybXjmh7Okz9TFrKTqHT
aTodLz5DXmd0xDE1D+M1/2laiSz+HFTb8yj+VeqvQ2/5eUhghPpFtAQFSKIQ
u8TVyttn74dRgS32tgFJOZPsbApq7fdCz4g7YnewH9Bcd271fZX/qDln+H7r
/lJayb7OX4U57Lmo8T1QTqb/+ozz9f63E7QrOx+D8NU9qWb6QRvcP1bOCvtL
41tNS9gT0Et/q/23Pell7+Y7/YExzpaLS+qvSY3batagzJv6S+/aay2tELMT
/bzFBJZ4N7vt447zGjvIdrbE/W3V+6luFl8lzuMnfyf9pKDR2Vm+BnqOLnT2
XK0F9Jf7T5nxJBbZy2Lc8u5usK+jKTNivvnv8S+gbfRVb5Zd8o64d48Z7osZ
pfdGvY2j5exOzhbT2XqcjOKWt+v8Jd6rM9KOi/FX/mVv9Dt9bMZ61KFGnQ90
P62i1+gleoquUfec3p+olc+uo9m0mn+zOnXuqjfrs5bdmP8hvWJny8x+nA40
S6G4Zu/qk7PRZpmAafoaIGYuPWjGcrlrMR/FfBfVv283B5Art7plX3ZUisfi
d5jjKMqwPV2fdAh/htgX+mtHP9OJ4kcj4W2k44+5HvEX+54l/j9j3rLQ
           "]],
          "1.95`"],
         Annotation[#, 1.95, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV01toj3EYwPEHRYhhxsxhNmMrhywZ+qfGmsnFnBstiQs3TnMhpxxyyCGH
nCfnU8ypUFutXTBTLjRXdjEycgg5iy0mPi6+/+/7e97neX7v73nff8bC5TOW
tYmIVD9TukX8TYuYxrsGRmxF+pCIPihOjWjtFZGUE5HoHnFb3mjuaP1T/Ex6
RN6AiDXJEbm8gRM8K1NO/4jMlIgP1hf6RlSgUr8Xap7iVVZEtvvd5S2VXyhv
h/p83sI7B0U0JEU87h2xx/qZ53qJtxghVpYdMUz9O31y+RMP7RHxh/Otv3OC
W3iC/GZ13/ARB/Tbq3+j+EE+at0q3iYjoj1Gia/Uv1B928FmxB14pP6pXGLd
lWdwMk+Sn6KuGzrjpJ7laBI/x5eQJp6OKnMeK75W/43orz4bmRitfz4XIhcJ
5GGfvBp1B829HHux3dw2I6FmiplNRY35Xu4XcUfubuv7nGXPHa6vix93zpmu
X9q/hC9Z3xSvRKn1fFS7zlGT6l2fd3+T93aae1rP6xnxxR4n7LvAvs3cgglq
1pnfePsVui5CEvq6Vyqexh/xVc1z/oxPWGJdo+9ibtG3kzl1xDP3mpy5ic/j
Iu468wVerd8q5Ov/0/oH8nxPJfrMQXgnD73zv561Ws0vebf4G5fbY6qcItwz
g7bc6HveJ37M/f2ev66P9+Pb/m7uE7nMuot7i3iufYtR8P87dP8pXpvNGPMq
wG/1V+39mev9fxpRi2p93vAhruQbfIXP8np9Lzr/I72GWtfyAK4S36ZPrb0a
nbFBTjuzecDXnHGFM53iHOfIk9dqXu/cG+csRZjuuYbImc9HnLFM7QYsRIFY
hf51/l+HkaW2Sp9F3nUJ6uXvdo7jWIZdZrmeh4unyH3i+drze54sfxwy/YeT
0excD8ULXM+W/w8IzKyD
           "]],
          "1.7999999999999998`"],
         Annotation[#, 1.7999999999999998`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV011IlmcYwPHLkTH6UDO3Mr96s2zURlK65D1xihU1rFYhHYygoLPV28EY
C3TQBzXZks1qjubok75WBwXKWkfOICLqpDpwZesTjdXAmoa+Jvt18Pf/3td9
Xddz39fzmNiUWrM1IyJK/FmeEzE2I2IVN8+M2IXisojpqJ8ekX4/IuuDiOSU
iIvyKvhd60HxwyURlcURX0+NKOcmTvLaWXKKIhLvRfxjfbwg4jQ69Hug5i4e
z44os58j7wv5dfL2qq/mnfxtacSd7Ijb0yK+t+51rkfow0diqbkR89X361PO
L3hebsQoV1u/5CS/5k/kD6kbwHP8qN8+/XvEW/kn67R4JCIysVD8S/3r1GfM
MSMezwv0n8YN1pP5M87lJfLz1GVjAtr1bMN98aN8Evnixeg058Xi2/X/BoXq
y5BAhf7VXIdyJFGJFnmX1bWaexv2YY+57UBSzXIzW4nL5nuqMOIPviK/05xf
iZd67n98zt4QD6JGXZpH0SE+wsNoV3NN7Ro9NuS5g72/MdN7L/L+S/iedS/e
eKe/OMMYD/OgnnXiK/ApxrlngX7d5nTMfsp+jnja78/NO9tzRv3O4olm1Gv/
ofX9t2fz/BFUyF+EUb8f+k622ZvgeRMxTuwr/aeov5avN692xgZcdPY+/p2v
utdN3PItXMeY2CUzHNb3Ag9wm14r5S/Fn86dwT3u2iL+s/0f9O72jMW++5fe
SQ2nrCfZ28zr3acetW+/Uft38cR39bHZ12JE/VnP/pdv+N/qQRcu6fOU93MH
n+czfIQb9T3hvjf1mmfdxUXcKb5bny7P6jGvO3LeMb+r/JtZb3OnX3mue1TK
S/t++u1VuctSrHauOXI28EF3TKltwkbUip3Wv9v/3gGUqu3UZ7N5N+CG/O/c
4xC2oNksG/lD8Ty5fzlfJj/jZfKrkPDecjHkXtfFa/1eJ/9/Wuazmg==
           "]],
          "1.65`"],
         Annotation[#, 1.65, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV0klszVEUgPFjCAsR89wWRUssDEFjpZUQi9bQagxJE0RoaZ+lqYOwacxT
jDWTlliQqNbYqmEhSgyLUrEhpkTCQoqkid9bfO97595zz73n3v/oVRvyE10i
It3PvL4RncMj5nP1qIjtSM2IGILcoRH/Bkf0Hh8xs19Eg7zbgyIujoy4hO8j
IobJf90n4ofcN9yQFvEhM6KRJ6F5YMQtzk+P6Jlq/VgxFokXosl8o/g+3+Ev
vM74elTa866xKi5WvwSn7FmDE8Y2y9mCjagVb+JU51vOy7AUD9Rba12p+d1D
Isr1sodzkYdWZ13p3Ef9L+bn4jq5F/HQ2gL5LVwm3iunQryPF2AhXsgvse6Y
/2X8UnxZ7iU8tm6x/EecEO+XUyk+wIuSZ9FHPp+0poBreGb/iAtcKD7L53EO
Re6+Q/3p7nu3e8yWt4tncbs+32OGuSx883b3vFuP5J3jlrVN7mX/OO/BqXLS
8E69NHPtPNkeUzAJXZO9OFspsp27xPutwxoUYy0avEs930QGxiMTs+XfVzOH
v6c4C7qpN1XdWt/MWWcuc+bTnOBzXOEsefI6xJ3ibt7ryTB7ijv8r1OvFlX6
2oZKdbahChv1Wc4Vyf/YJN7K7dYP9k0XWnfd/X/mBn7ijK145fxP0Zn8/rzJ
H/tf4598xJ558ufggbMHt+lnj/Gj5vep26L+DHv9cqfZnBD3Mreal+gnFzn4
bP4dPg7wdqON4a/1l+39g5/ppw3NaFTnEx/kG3yV6/hMsid1L7iPVrUmiJs5
heuN71Cn2V5t7u6NnC5j9MlXvPUGPdVwhj6myfvnHb6Yy9LLHCxwrrFyiviw
HhPWlmMFcozVqt/i+ziEdGvr1VntuyjEM/k79XEcpah2l1t5ovEBct86X3f+
ynPlZ2GU77EffuvrqfEc/wvk/weeSbh6
           "]],
          "1.5`"],
         Annotation[#, 1.5, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{9442, 8871, 8872, 8195, 8196, 4017, 3936, 8873, 8874, 8197,
            8198, 4018, 3938, 8891, 8892, 8199, 8200, 4020, 3946, 7494, 7495, 
           7127, 10440, 7128, 10367, 10368, 10369, 3950, 9611, 5563, 9610, 
           5564, 9612, 5518, 6816, 5519, 7063, 7064, 6041, 8201, 8202, 8203, 
           3952, 10149, 5974, 10148, 5975, 10150, 5822, 9963, 5824, 9962, 
           5823, 6228, 6227, 8091, 5770, 7358, 8492, 8493, 6821, 9603, 5520, 
           7955, 5521, 7956, 8129, 8128, 10185, 6026, 8149, 8151, 8150, 5977, 
           7065, 5976, 7038, 4259, 8104, 7965, 7966, 7964, 5572, 6400, 10208, 
           6399, 7650, 7594, 10209, 7595, 7583, 7599, 7598, 4159, 6404, 4158, 
           7246, 7244, 4854, 7674, 4713, 6390, 8204, 9604, 9606, 9605, 7957, 
           7328, 7329, 7330, 6924, 7326, 7325, 6626, 5755, 6622, 8058, 6618, 
           4117, 6740, 5296, 6885, 5302, 7877, 7884, 9425, 9417, 5372, 10423, 
           7415, 10415, 7407, 6293, 6732, 6724, 6080, 6655, 4567, 6284, 7318, 
           4238, 6593, 5685, 9712, 5695, 6509, 7178, 6499, 8278, 8267, 8256, 
           9701, 9689, 5090, 8500, 8512, 4344, 9384, 4332, 9931, 9943, 9919, 
           5815, 9955, 5777, 9907, 5803, 9895, 5790, 6522, 4770, 9676, 5672, 
           9663, 5659, 6580, 4226, 8383, 7639, 4819, 8960, 4805, 5545, 10350, 
           5531, 5925, 4147, 10233, 4838, 6198, 6212, 4942, 10275, 4956, 4499,
            9069, 9083, 9055, 4928, 6566, 4033, 3986, 10017, 6068, 7011, 6996,
            4555, 9353, 9368, 9323, 5255, 9338, 4394, 10002, 5848, 9987, 5863,
            6981, 6966, 8735, 8720, 9972, 5833, 8768, 4434}],
          "1.3499999999999999`"],
         Annotation[#, 1.3499999999999999`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{3948, 6747, 3943, 8167, 8166, 10138, 10137, 5433, 10136, 
           5966, 8165, 3942, 8890, 4589, 8887, 8889, 8888, 3941, 8885, 8886, 
           8882, 8884, 8883, 3940, 8880, 8881, 8877, 8879, 8878, 3939, 8876, 
           4588, 8875, 4587, 5430, 5429, 4019, 6094, 5432, 10341, 5431, 6309, 
           3947, 10192, 5454, 6095, 9484, 5456, 9483, 5455, 6310, 4590, 9517, 
           5468, 9515, 5467, 9516, 4021, 3951, 7085, 5565, 8218, 8219, 8220, 
           6817, 6818, 6819, 5583, 8248, 8249, 4089, 6850, 4088, 7161, 7162, 
           7147, 7565, 7148, 7149, 5035, 7779, 7781, 7780, 4675, 6822, 4674, 
           6336, 6463, 6462, 6387, 7093, 7092, 7933, 5481, 8052, 8053, 8051, 
           5750, 6153, 6152, 7052, 4721, 6401, 8301, 7221, 7597, 8930, 8931, 
           7596, 7187, 7188, 4856, 7678, 4857, 7679, 4722, 6602, 6603, 6403, 
           6402, 6627, 3993, 7682, 7683, 7133, 7332, 7331, 4275, 6624, 7327, 
           6625, 5754, 6621, 8057, 6617, 4116, 6739, 5295, 6884, 5301, 7876, 
           7883, 9424, 9416, 5371, 10422, 7414, 10414, 7406, 6292, 6731, 6723,
            6079, 6654, 4566, 6283, 7317, 4237, 6592, 5684, 9711, 5694, 6508, 
           7177, 6498, 8277, 8266, 8255, 9700, 9688, 5089, 8499, 8511, 4343, 
           9383, 4331, 9930, 9942, 9918, 5814, 9954, 5776, 9906, 5802, 9894, 
           5789, 6521, 4769, 9675, 5671, 9662, 5658, 6579, 4225, 8382, 7638, 
           4818, 8959, 4804, 5544, 10349, 5530, 5924, 4146, 10232, 4837, 6197,
            6211, 4941, 10274, 4955, 4498, 9068, 9082, 9054, 4927, 6565, 4032,
            3985, 10016, 6067, 7010, 6995, 4554, 9352, 9367, 9322, 5254, 9337,
            4393, 10001, 5847, 9986, 5862, 6980, 6965, 8734, 8719, 9971, 5832,
            8767, 4433}],
          "1.2`"],
         Annotation[#, 1.2, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV021MllUYwPELA0u38IUU8SUEimQtWmrTL/EB5ibEB3sCJQMD2yxCc03d
oGUyVmuiW7mKrUaBTWXVxMm0pgU0+UCwFrZEoaHLUZu5aahTmpsvvz78n/99
rnOd65zr3PeTtXFr4s2kiMj2s3NWRG12xNuLItJmR1RyMtfxmUciXl0SMc7f
IuG5lUdnRmzhIuN3+GRaxImciHP4GafnRTTPiCjMjXgBy7AV1eiydp2cldas
5jzOl5+JyYyIDONKbloYMfRoxHzj/4w3zDU/P2J/esRIZsRXPMqf8i9PRLTw
Nn1sxw60LIjYjZ+csZnbzc9Q41lrUvR2Qa1U4y/NteG88RhqUI0f5XXjB/Si
BzVz5NurDV+gTM1KuSfNfa/fJnud8PyHehPutdg+1dZc18c1jIr/K75avEp8
Quw7606r84px/uP65Ke5w328Ze4f9S6hRKwYjXjZuRvsVckVmOJe13PwS5zE
n9tjm/VH7NmJb+ybLnaDS7gUz+OU2hv1kOu95Lvzp7BWrBzhDCt4lZqzxH/1
PIQG533Q3FTsUft14/e4lu/pqU4Ps+W/wXeNf5eXrv4csQe8z7W8DhVI8W53
LY54F+XG0+VPQ9gnmVOQEH8RUz2X8SY18jy/xk9yEj9s/wbnHFOv3toRTrNn
Qm+dvtFxPsZ98gcx9FhEP26LHXeXN9U9zFf4Y+ctkV+IHj3dUWvYvTWLf2J+
r7q9Ysvsd9X7eI7rjB8yV8NleilGAcbNn8Ofzrg0Swy3rD9k78s84F0NoxvH
1bnIH/JR/poPcivXq9vufzmoVq5xN2dwl3ijOt32GvY+f5Nz1/ffxx3uf7Oe
PuMcfTwjb9J3+5e55XopRKlzZclZz/v0WOc/2YAqFIgdUL/Xd/QRMq3tUqfG
XScwIP8DfbSgFu+7y3peIj5T7tn/v0X+m4vkL8ciZ0vFdX31ixd4XiP/PgbW
r8o=
           "]],
          "1.05`"],
         Annotation[#, 1.05, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV03lI13ccx/F3i44/kkqtbJWVZkUUaG1EoIGyLtKtA7pcKW6CaNnsIGNF
BNWSoqIa23SwP7qjQ8uiwEVUlDJ2xCyCgqLjj042srautcfvj+fv9fm8P+/z
8/38hpYtnVXdKSIy/XzWOyIvI+Jy34i/h0ckWQ/EuAERBbjPHiMirtGedAT/
VcMiNqRGVNBvsQmt7DP5l6KpX0Q63+09I85hT381UiI+z4yoRSV28J/PNmRk
xHSan6Ym7iVHvBSb3SsiQ57v+0RU8dlPLzh7p7c/aPugiJYhEev4Ncmfpr+W
rIgs2kZ/4rOKvcF+r7kO0ka6jd6hzQl/2o5WPJRnnzle0LyhETm4ra/rct1F
nlpTMRul8nYbaA6aK89T52PpOfst4nc5qzNLuxnfsv1sjvwPI6ZhJ/sT50fM
1EGb6St3eVnt39CWbk6cZLvL/yidSZPlvS1XF/Ef6Os/OorfO3o+4Tc4oq86
R+hxHEPw68bnvbvoTuv0WM/eomaNdaq5l9Fytlb3+yutlOO5b5hpzgzcd9/L
xT+gje78BJowma1c3Un0qh7qfecc/VVbL8Un8tbQr3AIi7EE5ersV6OWf4f9
AjXnYT7mYqG4N+q/xWs+xWxF6qWhPxoT7wsrnGU7y8G/ZiuT9x/6Bb0q/xnn
a/kt0mMJvmR/xPcxljmb7putpCe9tWacQJW4zWK+wXtnu+1/Ye/wHS+Z/wUt
FFeEJ/I8xTN04TeOX1f6ET2V+E+pORGbzJhLN9JPnRUjHyl8K+hzfdVa/2Xd
wzcudIffudNmNZLcxQEa9KYcVc5/9E1WeDdb9fMDLqj1sXu5qOfR/lcTcIjP
adTyv+NNJamxQ8wt97OeFif+L97GS5qurzEYaT9F7Hg6hzaJLfE+qjEWM5CP
OvfyO/8rfK7jDM6K+do7LfCuFtMbYhsS79b+cOIdo8z6T1qp187mK6bJdDWt
MMcac/wPhw63Lg==
           "]],
          "0.8999999999999999`"],
         Annotation[#, 0.8999999999999999, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV02tI1Xccx/FvLXqwuVouZzd3POUyMEhNIsgH+qRF0YrYIHSbdAFTd4OB
jmI1qMCKjI2xhc2CbZVzLAWLjVmUtaM+ycRTBHMmFW3BoqILDGbY6zx4n8/v
8r3/fye5+eMNH02KiKV+3poRUT4/IvVaxMOFEVnWc1E6N6ISt51POL9KpxVG
LGTfWBCxe2ZELf0ae9HvfD37GnTlRuSxbZkecQ7fz5bj1YjqBRFNqMMh9hud
JRZFrKYVs+TEreyIp3yXvBKRFOfbnIh6Nsdpr7txtV2h6byInvyIney6xM9V
X88bEQV0gB5l0+i81f4H9Z+knfQgHaPdGXuaRj/uivOjPp7Q8mREMW6o65pY
N1Eu15vYgBpxp87TB10hzj33JfSc/X7+X7lr1ktaj/87O6uPijkRq/Cl83/d
/6ynx7Sb/meWKbkvY+D1iAvoRbsev3P/Ex2iJ+hJ7Lbeiz0YNd9m8VNmto/2
0Rz6AZ1FG2guLTW3EhSjS55O/O7ukZoe4xibLWpbqeZ65x0JNSIf85FEu5l2
sMmhrXSU7TBN8e1R11kk9FRjRnk0336XfJ3sktY3vI0xTHP/Mj5394u7nfQU
TbB5V54XfI8pWCJGMQrNdKsa/3BXJdclWp3pmY6I9xfq1dGAzWqbsA9+42Yz
KvYF9OI8LuEinrmbxGYy7rNvkfsBfYghb61U7DIsRa39NgybSyO/T3zr7TRt
f1rdb6tvim/xoveyRg3/+OZ3cRTvid9GB9U/IkaR9d80QWdiiE8Z3xGaQlL+
xZn/kThtZnBH7BV899ivla8KFcjWf23m+4nVZP3A+iW2a8T8xgy6vcksdZ6g
E2z+FKPe/RFz/1RNB8zgcGYu6i/T+0U5i/wvl6OdzRk0sR/zTrL4H+Iz4k1+
Qasy/ze1PqV56lqMQvuVfJfRd2gX3/fV/yFKsA4VaDa3QfZ9bK7hV/zGZ7v/
QKU5NNDrfFvp+szbpzexyXqY1ql1sv6q6Az6Ga3Vxw59PAdSqMGv
           "]],
          "0.75`"],
         Annotation[#, 0.75, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV02tI1Xccx/FvRBRJq9ZlreykmRXGypAV5AN9sAUbbdIYhJERBQcdUdDF
sgtWWqZtreZauFXQTbtLEUYmo4HZnlhkbpBZdDFWBK1YjxZIr/PgfT6/y/f+
/53M5au/WTUgIvL8fDUyIn9yRPvYiH+nRqRZj8fsCRGFeOK83/ldOmxaRDb7
9VMidoyOSNJ6VKPDeRH7pWj+KCKd7Q/DI9pw9GM5RkUszoooRyn2sl/kLDE9
4gtaME5OPP4w4i3fmSMiMsT5ZUxEGZsT9Lq7d2q7RbsmRrRmRGxl1yz+WPW1
Zkdk0Zv0MJv1zhvsj6m/kV6g39OH9FLKnnahA/+Ic1wf/9H8zIhZeKCubrEe
IV+u+ViIpeIOStcHnSfOS/e5tM2+lv9+dzV66dLj/86u6aNgfESv/blExHmc
xVUzvCBnDp8ycUsxxGwG44CYz/X6AiWpnJjEbrRYZeazwTyK2Gykf8nVjRNm
/Yl8M3GEXS6dhen8quSvxhLn7b7RU/ThTz694j3AfTSIs9nsEnrIQCZumXUn
tmIO5qKF7w28nhTxmxi/O5uMLCSQjafiTaGbsVbcJ/braFLNK9TSpJYO3/YU
/UzOH9ntxy5n+2gN7Rd7h+9The3YiWpsMe8z4p1FE07jFCrY17jfjV3Yxq6W
VtIP1Nuon5PY46wuFUv9A+1XyH9Yzptq+8lcf0Y9rjlvcd5Gb9P7vkMvtptr
Ug91tJKW4yKbTXK00vrUvbglZn/IutN9j9g51s9ogo7CbW8sT589tB0Z/Gek
/kfmdEh9ffzn8a2yX6C/YhRgpJkl6Ruxyq1fWQ9l+6WYB+S/pPY0PZ+k/Wzu
iVHm/le1r1FXnXd1ENe9yTx9/SFnjnc3F01sLqOc/UPvM43/Xj493mwlLU79
39T6lqarawam2n/O91P6LW3mW6L+lcjF1yhAje/Tyf4Gm2604AqfCv+FQnP4
jv7Nt4EWpd4GfYRl1ndoqVoH6K+YjqAbaFIfm/TxHiSVwK4=
           "]],
          "0.6`"],
         Annotation[#, 0.6, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1G1M1mUUx/HTi9piNQmTUiQEMYWEmss22QK3cKtVDHERbmJb2y20FpR6
48OQTVCQkW+YNR2+iB4nCpNZKXPNJoLlrInUFpsIrWSrTZcPbzTNPveLH9/r
Ov/fOde5zv/+k/t2Y1XDAxGx3J/XHosoyYsYzoy49nREmvVcei4roox+F78n
fhEfWRyRz785P2Ln4xEJ7KY2GhGv4K+lgScisng/nBVxkj6Z64zZEWsXRiSp
jvbyV4tlL4l4GUufdCZNZ0TclFuUHpGjzkdzIup5PsNTnt3R2084lh0xtCCi
mW9A/Tn6G1oUkYejeJBns/h++179f4H92IWTOJjy4xiN0Iw6n7rHDSzJjSim
S/oaV2uKSpy1iiqpVt1H+U7isF7b9Hkad+GdeRG3qcTz93mb9F0h/3pOxFL+
s+6yXW/9/Ov5j2Atdspp5r3PW52aOb6B/+G0GR72fLUaVVRJb3q2BhPOeGZ+
xFZ1K8VWimXZz6d+Obu9j3bqNdsZM28VO+e878yvWR95fLVyHjSDh2iDenVU
oP923rOe/UCjdI5+pCvq9ah3Wb1bPFN40H6hWltw0H6P+CHn9NE0/0bxo+J/
iV/U69/YJPaiekn8RWyMLrnrDf5cPSyg69aj5pLDN4Jt2OKeO3EHtmK2M77G
Pvn13lm731cHFT1l5lTu3AZ1XsK7evyXOuScMfsL8k6YRZNZHMctWCynUZ00
fTVgeqpX7OY9QF3U4ez3xDPV3aSvTu+2xT5JR9XYJj6E3eIJ560zzx7r855P
8BdY/4nZmEE/q79M/xM4TDnyC1Pfkx56vJc/5K+Q22r/qr5rqJTS3SOB/6iV
tL5q/TDvK2ruc/6g30+aXj/Hezy/qVHv+QGz/UBfnb6nj+mU2Sxz/++dWWB2
L9CXPMcoyT/p20iTv1fOhPm0YE3qu9PrTczSVyEtsi+X+zyuwQG56/T/Lj1L
r1MptXvP5/nP8IzTN/StnK3+r5SZwzv4q9z9WGH/FU7RW9YXsE6v4X41OAub
MOEe29zjf/bWwVs=
           "]],
          "0.44999999999999996`"],
         Annotation[#, 0.44999999999999996`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1F9I11cYx/GnBqXE5vq3mdmvWa4MaiNiYG3KWpuappI1HDT6Y7+0XKtR
xqwRlGDEjEAqEhsU/SNpVhsJsgtt1bYLa7qQcmNUtIvtohEFa8Yk9/Li4/uc
5995nvM9P7OqtlZsGRURC/wpGR+xcEbE1Vci/p4VkWqdTm9Ojcin++xD7L/g
uNkRM8Vvz47YMykiic3UQNfZS8V/TO2vRmSIbUqL+I6OT3HGxIiPZkbUUTUd
EP8hW2ZORCHmpTuT7k2IeCJ37ssRCXUOT46oEXMSu/ie6e0G9k2L6Hwt4gtx
7epP0l/n6xFZ+AMeE7Od/aj9Cf2fxnl6686MeC5nD98wFmZFFNBvevqVavV1
RNwnWO6sMmrSxxjnbWI7xHeYqvW6gTaynbCvwaT9XLEd0yOe6qHMmf9iOd5g
W8vXg2vwZzk36aKcqXr9OsNd4DG+XvZL7NPsL7An8Bv7PvZz7nOlGilmqlJ3
LK7HVFyHa/g24GpM4gV56fJP4p96bFRvp7vscc4ZtW6zF4qtEFuAK7AIl2Mx
ltBSemaOQTov/j37JbSYPqD3aZeao/EF+lGfP9FX6lfbL6RFlEvv0NtUpH4+
FuM/6i7FLb7nY99+K67le3FkJqyiGv7v+Rr0fQX34qBZCtj/wkIclYj4z6zl
vvFyetf3bZPbzT/G927zjsbiczHjzDGEB/XZzzZFfB8m5KSI/9SbTMMd2KxG
C31J+5yzmX2yvG1m3i9nt30dXVSvnr0Tm9mTaq5Sr9W6h39AfI71H5iJ4+mm
+vP1NYBXKSF/zsjvSH+t5n8gP1fuXvtic1dSHqWZP4mP1KqzfmidIrZIzUPO
v+ROU/V6CofE3FGjhr/F3X6mr/3e9RHq8ibme9vdzszx/t+iM2K+pTrxv/tt
p8o/IGfA/e7GypHfm16fYIa+5lC2/RK5C7AC2+Wu0n8tvUHLKI8avYke8dfE
3KLL1CHnc/9P8t3DRuyXexRL7c/iXVpt3YvVeh3WcyW+ZM4dmDRHPdv/wF+z
jw==
           "]],
          "0.3`"],
         Annotation[#, 0.3, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV00lszVEUx/EjQWsunV5VDR0fCRGRsCBiSIwxRbogNmqIEEVLDY1ZGrHQ
iKiGlWEhGlMlbEgQRdXY0IWI1JaYIoiaPm/xfb97z/3dc889//tGrKhcvKFb
ROT7mTMwYmJhxO2ciA+lEenGuRiTHzEZb8W7xJ/R3mURhfybiyN2Z0VU0Hrs
xV3xefzL0JQb8Yk/j/8zTdKPdBT9SkfSL7QkI+L74IiVw+XC75KIJeILhkXM
xxT0Rnsyog9tUdc9DB4UcVmOK/gu/gM/cViuP/Q3urBRvkoU8mfKv8l4M6pR
hVa5HiHL2hbzxwMittI2scfIFq8xfyK+jW5PjcWL5MuxtsP8lRo68Nd5/3CB
tzkR0c94V3ZEX7qb9qc3aIJOL4iYged69QLn7Wk0f4Q2nMBMZzTQWfSsfGfQ
yfeNf49YyZCIUpShw1qavDvl70l7IR0vfIdxeWrlb+Ip5h2u53X6tFDti9CN
rwe6Y6q199Y+oMp3WCOW49tnI2EtY6jz1HTH90jSUlz13WtpljM61VbCs68o
Yj9OOq9Fn07RXPMEfvEFz0Kx+9Z6yvWAHrR2AA+NX6r5D98R+Xa5Q7t5gv8p
LVBHmvrWZ+oprab16mzAIRxU9zrxLHs36UedPbWp++CinDXi12m9eIWcS+Vr
NG613sFfZvyO5tMMtMk/Vo0d9DYK7E+m3rl+NupLp/0T7N1jPts7KMck9Fd3
Rerdy1Vl/N44jXemnEedf0nv09V6mnbxvJJjtfUG969UV513dgw39Xes/t5y
Zpn+jMdZniuo4n/tv5du/+HUO9DXWlrujEy1fqF56kqiyHyavePoItpk71L1
r8VozMUkHPDGWvnv8DxHM67Zs9X/fbI+rKHt9h6n88zP0TdYbvyErlLrXzWX
037uWU0r3KNG7D9N/aeo
           "]],
          "0.15`"],
         Annotation[#, 0.15, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{7125, 7126, 4050, 5516, 9597, 9599, 9598, 4647, 5515, 
           10201, 4015, 4049, 5513, 10342, 5514, 4646, 5512, 10200, 4013, 
           4047, 6099, 5511, 8192, 8193, 8194, 6324, 7954, 7551, 7552, 8912, 
           8911, 4644, 10404, 7952, 5504, 7951, 5505, 7953, 7962, 7961, 6832, 
           8235, 8234, 7158, 5581, 7977, 5985, 10158, 5986, 10159, 7142, 7550,
            4633, 10265, 7392, 8742, 8743, 7573, 7574, 7570, 7572, 7571, 3997,
            4041, 8938, 8939, 7615, 4733, 7616, 8755, 6451, 4735, 7023, 4734, 
           7975, 7976, 7972, 5577, 7971, 7974, 7973, 4724, 8934, 4725, 7605, 
           8320, 6264, 4531, 7693, 4868, 7138, 7692, 8207, 7691, 3998, 7698, 
           7699, 7697, 7702, 7700, 4243, 6895, 7053, 6011, 6615, 6013, 6610, 
           7191, 6606, 4124, 6662, 4971, 6669, 4979, 8079, 8086, 8072, 5764, 
           6762, 6931, 5488, 6534, 6779, 6770, 4781, 7030, 4790, 6543, 7266, 
           4185, 6552, 6857, 5590, 6438, 5601, 6426, 6415, 5067, 10287, 5078, 
           5056, 6940, 6951, 6234, 9880, 4320, 6710, 6271, 10056, 10069, 
           10043, 5901, 10082, 5613, 6002, 10218, 4102, 6470, 4753, 9646, 
           5639, 9633, 5626, 6869, 4197, 8342, 7278, 8838, 8851, 4540, 7471, 
           7101, 8998, 9011, 8355, 8368, 4210, 9434, 5383, 7306, 7894, 7291, 
           6485, 4882, 6640, 6168, 6183, 4898, 9025, 4913, 9040, 4267, 9817, 
           9832, 9772, 9802, 9787, 3971, 6345, 9153, 9168, 9138, 5043, 5237, 
           10300, 5222, 4306, 5269, 10315, 5284, 5340, 10332, 5325, 7524, 
           4605, 7509, 4620, 7539, 8802, 4470}],
          "0"],
         Annotation[#, 0, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{5517, 8917, 4649, 8915, 4648, 8916, 9596, 9595, 6814, 6815,
            5987, 10202, 4016, 6813, 4014, 4048, 8216, 8215, 8914, 8913, 4012,
            7145, 7144, 7143, 4645, 9582, 5508, 9581, 5507, 9625, 9626, 8236, 
           8237, 4069, 6833, 7160, 7159, 7978, 5582, 10358, 7212, 8093, 10027,
            10028, 8746, 8747, 4401, 6849, 10132, 10133, 10131, 10135, 10134, 
           4482, 8919, 8920, 8918, 9396, 9395, 5307, 4423, 8757, 8756, 9394, 
           9393, 9722, 7855, 10260, 7856, 7854, 8112, 10429, 10431, 10430, 
           5914, 10093, 5915, 8113, 5913, 8147, 8148, 8145, 10184, 10183, 
           7651, 7617, 7618, 7604, 7621, 7620, 4162, 6301, 6302, 6629, 6628, 
           6086, 7482, 7703, 8986, 8987, 8985, 8041, 8043, 5748, 7701, 8394, 
           6897, 5709, 6896, 6010, 6614, 6012, 6609, 7190, 6605, 4123, 6661, 
           4970, 6668, 4978, 8078, 8085, 8071, 5763, 6761, 6930, 5487, 6533, 
           6778, 6769, 4780, 7029, 4789, 6542, 7265, 4184, 6551, 6856, 5589, 
           6437, 5600, 6425, 6414, 5066, 10286, 5077, 5055, 6939, 6950, 6233, 
           9879, 4319, 6709, 6270, 10055, 10068, 10042, 5900, 10081, 5612, 
           6001, 10217, 4101, 6469, 4752, 9645, 5638, 9632, 5625, 6868, 4196, 
           8341, 7277, 8837, 8850, 4539, 7470, 7100, 8997, 9010, 8354, 8367, 
           4209, 9433, 5382, 7305, 7893, 7290, 6484, 4881, 6639, 6167, 6182, 
           4897, 9024, 4912, 9039, 4266, 9816, 9831, 9771, 9801, 9786, 3970, 
           6344, 9152, 9167, 9137, 5042, 5236, 10299, 5221, 4305, 5268, 10314,
            5283, 5339, 10331, 5324, 7523, 4604, 7508, 4619, 7538, 8801, 
           4469}],
          RowBox[{"-", "0.15`"}]],
         Annotation[#, -0.15, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV01tI13cYx/HHULDC1A7OrKaWdpzEWqxsFxurtaQDkYQpUVIjVkjZYUUX
C7KIHLgxVl40OwrBVnRgo6KTF0ESHcn/RRRUjHLa0VqkLdp6/S8+//f3+T6H
7/N8v79/4ZJV81amRMQYP79mRfQeEnEAbxdEtNGmkREbaE1+ROqwiOujI5Zl
R8weHrEYm9kTxb3OjKgoipg/MGIuLsRFWC+mDOewv8Sv8UmuHOtx1iU4AT/D
ZrFfWJfSc/X+/yCiyLq7MOI/SnNmN7vLupP+omHskXKr+0fkYib7lP0WukhD
B0XcwQRdpRz+fHE9amdjOrvZ/u90nLrYTbiTfqQU9kP9PqCuERGvBugNX9IL
atLzmDx3hznuItN5VexK6jDDOWecT+pDtlotuMYcg9zlIzkHrTvtPaJ+chPu
v42+4u9I1sT1Ys7yP5R/Gh/gGWxX/yVfvdlf4A/4D34i7yOsU6+mOOKNt/uX
bpnhoJwr6p/kq+c7gUf1miKnAAupyd3sEtNh1nx2sfdtFHtZ7HdmfDc0YpL6
ZXJ262MPNdE+c+5Nyjl/J/un9uSc1EkzxH8qr3VwxDO93tTTU7zAV4d/4Bbs
p1Zmck52mh4m4325pTja2ZUU+uhFKTTV97pCrWlYxZeu/qyciAx9zMSnZsiz
P5j/Cl8eptpbrnZfXI0N8nfQNqqT8639bHew0sxb5Wxk19Ih/a2z/yc22K9W
t0K9RutW/oT4Iut7mIsZdEn9En0m8DzlyS+mBfpr9N+6K3+i3O/Z00dFlFMp
9fUO1fhYrVrrDutUsdPU/Mn5h71Jml73Yo+YNjWW8u/wXjX62uquf6bT7q7E
3Z1xZpFv9mPaL+YI1Yq/5c3S5G+Xk3DvG7HcGVl6fYY5+iqmAvbncsfjHPxN
boX+l9FYmkGltNk31iq+Rcw1OkbH5az13U5xD9/gDbm/YBn7AN6mKuvLuESv
b/Vcjn3MuRqrzbHO3nsx4rar
           "]],
          RowBox[{"-", "0.3`"}]],
         Annotation[#, -0.3, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV01toDnAYx/FHW9gaZsw2h81sDtNyyM2ckxwuLBlNEputJcQ7hBWKJBRy
TCGxK4fkWKK4YiGstiSERmwZcyiHFPns4vv+nuf5P6f3//7f/KpE2ZouEZHj
43h6RPcBEWfo88ERTdg6LGIj1uZFJA2KeDIioqZ3xJwhEUtpPX+cvB+9IsoL
Ixb0jZhLF9MldLec2bSUP43OpO3Zatgj2cV0LJ1A6+VOZZegQ79/WREF7J/5
EX+RbOZP/hd2G1owkD9UbUVGRBbtyb8hfgf3MCAz4gVtxiNkOs+V90vvdNqN
Xy9+DpfxhX+CHsE+BD9V3iL9fxdE/OkTsUI8gQ2d/fTfRbdjc+eOcv/J+6Z/
G+3AEvFq5Pp+d51n05cDI55iV65azNd/A92MRvG3dKGaNLlt7Az62r0d7B/x
jp6kx1CqrmZoxEqUoxKLsWd4RFc18/SYg+/2fmOXdnsl9PvMv2vOA0Tn7yg2
ye87GRMxFVNQ5M5H4LSZb+WNNrOFtjv7hPHqr6i9iuu4honez4Qciq/2ey+v
h9lpyHeWJ2cIrfRuctlFeuyU90DeQ/eZoq7VzDqxDvPSzO6Jbnb+4GwTTRHv
jVTU8vd6n4exE9v7RSwXT/eWV+u3Q00dP4Hzeq4Xv0b3ileYXW6Xo+wG583y
C9ivaRZNw339i73zZnobOeoLsdBOR/03Xqkfp3YLf4Z7L0MJUt11Bf2oV4Ld
yk6SO13P/eZf8Dsl2/UU/SWnSY8q54fdyyp77XAHB3DTfRe7m1tmFrjDMTgt
5yIS8p95U8md71BNs/uso2Vm9LLrZ5ppr0Lk8aeoHUVL6Vm15favQRFmoQTb
/Pca5N+R8xiXcFnNOv+F8e6hmjaqPURn88/Q51jEfkiX2fWPnctoiu9ZSyt8
j/Vi/wFGx6Rk
           "]],
          RowBox[{"-", "0.44999999999999996`"}]],
         Annotation[#, -0.44999999999999996`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV03loz3Ecx/G3LccSc8yGGXYwWiJ/GH+QluMPSzZNa82w9gfSz9GkUI7k
nGuOsMSUM1GKKP5yTY7akpBbWTRXOVoRj/3x/L3e78/nfX0/n88vu3ppaaJT
RAzwc7hXRNfMiOP06dCIZqwdHrESy4ZEJGVFPBwRUdM7YkZOxFzayB8r7kdq
RFlexOy0iJm0glbSLWKm02L+ZDqVfuovhz2SXUDH0Am0UewkdiE+q/c3IyKH
/TM74g+S9fzJ/8JuxRtk8vPkVvWJSKc9+Fes38AtDOwX8Yy24D7S7GeJ+6V2
Ku3Cb7R+BhfxhX+E7kMd/vWNSBFXrv7v3Ih2/kLrCdR21FN/M12P1R0ziv0r
7pv6rfQzKq1XI8v33bSfQZ8PiniMzYPlolT9Wroaj6y/pXPkdBfbyu5NXzq3
PQMj3tEGehDF8mqGRSxCGeahAlvzIzrLmaXGDHw39yuzfDJXQr02/k19mnCK
fw756rXy36PIXZ9w3idxDPX2D6ABh9Dofu6pddn3jxef4X0s9w7S6bgB7hBf
zdZEU83bC930zJKbQofSTfbv6NOEu3ilZp4ar2mbntesbfO+dmA76jDV29zp
Pe5CHbamR+zueKPm2GD+erqe1tJUb3kJ3WiGVdYSOKvnCuuX6A7rVWYvU3M/
+7b9FvE57Jc0nXbHXfMW6N1Cr6O//FzM8U379X4hf6zcNfwpzr0EhUhxPlX0
o1oJ9gd2ktgiNXfqf849JZv/KP0lplmNBfbrncFic210Brtx1T0WOItreua4
w9E4JuY8EuKfeFPJHe9QTotzXUVL9Ohp1jaaZq5cDOZPlDuKFtPTcsvMX4MR
mIZCrHP+t8XfEPMAF3BRznL/jfHOoZo+kruXTucfp09Rzr5H55u13cwltJvv
XEqrfMcKa/8BeU2p9Q==
           "]],
          RowBox[{"-", "0.6`"}]],
         Annotation[#, -0.6, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV0mtoz3EUx/GzuSb3mcv2H/6bW0vkyVyXhKmNjLaWZm57gAdzyaVQtAcu
IXdhxJRLI0oR4RFCRm1JCLmURYhySW3J6//g/fuc8/2ec77nfH/f5JKVc1ek
RUS2z9GeER2zI07R54MjmrBpWMRarBwUkZYT8XhERHWviOLciPm0nj9G3M8e
EWVDIub2iZhF59FKuk1MES3hT6bT6Of+ctgj2Pl0NB1H68UWsgvwVb22fhFJ
9q9kRCvSnfmL/43dgrfI4ufJreodkUm78q9Zv427GJAZ8YI24xEy7CfE/Va7
O+3Ar7d+HpfxjX+MHsAu/MuI6CyuQv0/eRF/+Uut12BNqp76W+kWbEj1KLZN
3Hf1W+hXVFpfjIT57tjvS18mIp5i60C5mKP+GroBT6y/o+VyuohtYfekr93b
3qyI97SOHkaJvOqhEctQhgWYh+3DI9rLma1GMX7o+41ePuurRr0v/DvOeYCz
/AYMU6+F/wFT/OvT7vsMTmK//UOowxHU+z8P1bpq/rHir9DxAyIuqNGAWn1l
i0ug0v58FHlXhWJm0FpvJmlvlnfVzhuaSVv1/VvuIfuP7TdiXd+IVd7fJPlZ
4grpBExEPvqrscN6XurtmilhxhzU6fkEjmO6e8gQc9O/3cne5I3vopnWis2w
VJ0F8gfr7a7z76HZPEn+a5pJu+C++vlymukt9FMnF+X+x0E9vlJjjNyN/Knu
vxQF6OyMKvpJrRr2R3aa2Clq7nZPDeZON+eJ1PximtRYZH+/+ZfrrdYMe3Bd
z/n+yw1nJs04CifFXESN+GfeVnrqPcppdi/raakzuun1C83QVy5y+JPkjqQl
9JzcMv1XYzimowCb/eN74m+LacQlXJazyj2OdQ+L6RO5+2gR/xR9jgr2Q7pQ
r3/1XEo7mXMFrTLHamv/ASUVphw=
           "]],
          RowBox[{"-", "0.75`"}]],
         Annotation[#, -0.75, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV02toz3EUx/GzXJaQmevMZTe3RB7YKJKwB5YMkzRj83+AB3NPuUQUI8Js
ckn2n2vCSgwPPEKRUZOEkEsscs9IkfLag/f/8z3f3znne875fv/ZiRWzl6dE
RIafQ2kRHTIj6ujjrIhmbBgSsQbLB3EaEHFvWESie8S0nIj5NMkeze9Ht4iS
vIhZPSOm03m0lG7nU0iL2BPpFPqhrxjrodbD6Sg6lib5TrDOxyf5/vaJyLJu
zY74gxRntrI/W7fgJTLYOWLL0iN60s7sRvvXcRN9e0U8oQ9wF+m+Z/L7KXdX
2p6dtH8GDfjMPkz3Yxf+9YhI5TdX/l+5Eb/Zi+1XYnVbPvm30c1Y11Yj37/8
vsrfQj+h1H4FMvV3w/de9Gn/iIfYNlAsZsq/mq7Dffuv6Bwxnfi2WHejz81t
b7+I1/QIPYAicYnBEUtQggWYh6qhEe3EzJBjGr6p+4VaPqirUr6P7BvOuY1T
7LMYLF8L+w0muet68z6JY6j2vRZHcBBJ93NHrsv6L+B/kY7LiLhE8+kYZPDr
hya5qtR5z9vaQevtHW/LgYS3swh53lwuOw85GKTWgXirhx/eXitOOLMJE+Su
cXaTHmvpKnlXYivfRea72R2W0020gjaY11c97HT2F/od33DFmTXiGmmqd1wl
13lsdEa6mrojDTvNcwdq9Vbnv5BENWqwH8/Ejza79c6ZrKZi5CNVrjL6Xlyl
9Tvr4DtJ/bvVclbOlN4RR+lPPs1ylPte7cylZrpFjXtwVV/DzfCaWrPMZCSO
8TmHSv6P9JjS9g7FPDC7tbTYGV3c8Uearq5s9GePFzuCFtHTYkvUn8AQTEU+
Nun/Fv/rfJpwAQ1iVphngTlV0Pti99FCdh19jLnWd+hCtf5WczHtqM9ltEwf
K+39B8O3qwo=
           "]],
          RowBox[{"-", "0.8999999999999999`"}]],
         Annotation[#, -0.8999999999999999, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{4246, 6916, 4253, 8405, 8398, 9849, 9842, 8045, 7423, 
           10442, 4449, 8776, 4442, 10398, 8239, 4081, 9298, 5200, 9291, 5207,
            9305, 4484, 9284, 5193, 9277, 5186, 6375, 9263, 5158, 9256, 5165, 
           9270, 4510, 5179, 5172, 4074, 6138, 5151, 8690, 8697, 8704, 5362, 
           8683, 8676, 8669, 5144, 9249, 4699, 9235, 5130, 8627, 8634, 8641, 
           5399, 8662, 8655, 8648, 5137, 9242, 6131, 9228, 5123, 8606, 8613, 
           8620, 5355, 8599, 8592, 8585, 5116, 9222, 4693, 9204, 5110, 8549, 
           8555, 8561, 5393, 8579, 8573, 8567, 9216, 9210, 6125, 9188, 9194, 
           8537, 8543, 4378, 9408, 4372, 7383, 7377, 7811, 7805, 4687, 7793, 
           7799, 7371, 7902, 8531, 4360, 7908, 4366, 6362, 6797, 6367, 6808, 
           6803, 4681, 9569, 9574, 9554, 9564, 9559, 10117, 4354, 8525, 8520, 
           5102, 9179, 6119, 7787, 5097, 7360, 7365, 7843, 7847, 6692, 7396, 
           7400, 4402, 6690, 6691, 5580, 7157, 8114, 8115, 5916, 10094, 4066, 
           8231, 8230, 9624, 9623, 4828, 8298, 8299, 8300, 10116, 10115, 4139,
            10172, 10173, 10171, 10175, 10174, 5734, 9738, 9740, 9739, 4067, 
           9314, 4068, 8233, 8232, 8922, 8921, 6092, 6093, 5406, 9441, 5407, 
           4581, 10196, 4003, 4043, 4631, 4580, 7112, 7113, 7114, 4729, 7610, 
           4762, 8950, 8952, 8951, 4217, 6879, 10166, 10167, 10165, 10169, 
           10168, 4797, 9655, 5649, 9653, 5648, 9654, 6477, 7299, 6478, 4875, 
           6633, 6161, 6176, 4891, 9018, 4906, 9033, 4260, 9810, 9825, 9765, 
           9795, 9780, 3964, 6338, 9146, 9161, 9131, 5036, 5230, 10293, 5215, 
           4299, 5262, 10308, 5277, 5333, 10325, 5318, 7517, 4598, 7502, 4613,
            7532, 8795, 4463}],
          RowBox[{"-", "1.05`"}]],
         Annotation[#, -1.05, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{4245, 6915, 4252, 8404, 8397, 9848, 9841, 8044, 7422, 
           10441, 4448, 8775, 4441, 10397, 8238, 4080, 9297, 5199, 9290, 5206,
            9304, 4483, 9283, 5192, 9276, 5185, 6374, 9262, 5157, 9255, 5164, 
           9269, 4509, 5178, 5171, 4073, 6137, 5150, 8689, 8696, 8703, 5361, 
           8682, 8675, 8668, 5143, 9248, 4698, 9234, 5129, 8626, 8633, 8640, 
           5398, 8661, 8654, 8647, 5136, 9241, 6130, 9227, 5122, 8605, 8612, 
           8619, 5354, 8598, 8591, 8584, 5115, 9221, 4692, 9203, 5109, 8548, 
           8554, 8560, 5392, 8578, 8572, 8566, 9215, 9209, 6124, 9187, 9193, 
           8536, 8542, 4377, 9407, 4371, 7382, 7376, 7810, 7804, 4686, 7792, 
           7798, 7370, 7901, 8530, 4359, 7907, 4365, 6361, 6796, 5509, 6802, 
           5875, 8094, 5876, 10029, 5107, 9184, 9186, 9185, 4071, 6696, 10123,
            10124, 10122, 5949, 10125, 5948, 5951, 10362, 5950, 8120, 8119, 
           7439, 10340, 5350, 7869, 7437, 7438, 5353, 8904, 4639, 8903, 4640, 
           8905, 4585, 5408, 10263, 4518, 5963, 5561, 5510, 10197, 4010, 6322,
            4641, 9579, 5501, 8180, 8181, 4007, 4044, 6794}],
          RowBox[{"-", "1.2`"}]],
         Annotation[#, -1.2, "Tooltip"]& ]}, {}, {}}}],
    AspectRatio->1,
    Frame->True,
    PlotRange->{{-3, 3}, {-3, 3}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{390, 185},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->458106809]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32379],

Cell["Compose with inverse function:", "ExampleText",
 CellID->10684727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"InverseJacobiCN", "[", 
    RowBox[{
     RowBox[{"JacobiCN", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], ",", 
   RowBox[{"JacobiCN", "[", 
    RowBox[{
     RowBox[{"InverseJacobiCN", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->530612772],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"InverseJacobiCN", "[", 
    RowBox[{
     RowBox[{"JacobiCN", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], ",", "z"}], 
  "}"}]], "Output",
 ImageSize->{269, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25342350]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " to disregard multivaluedness of the inverse function:"
}], "ExampleText",
 CellID->77618357],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30362828],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", "z"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->406936716]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->390870124],

Cell[TextData[{
 "Differentiate",
 Cell[BoxData[
  RowBox[{" ", "InverseJacobiCN"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->715886131],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"InverseJacobiCN", "[", 
     RowBox[{"z", ",", "m"}], "]"}], ",", "z"}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->809586479],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"JacobiDS", "[", 
    RowBox[{
     RowBox[{"InverseJacobiCN", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], 
   RowBox[{"1", "+", 
    RowBox[{"m", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["z", "2"]}], ")"}]}]}]]}]], "Output",
 ImageSize->{249, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->661697032]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"InverseJacobiCN", "[", 
     RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->192074691],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", "m"}]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"EllipticE", "[", 
      RowBox[{
       RowBox[{"JacobiAmplitude", "[", 
        RowBox[{
         RowBox[{"InverseJacobiCN", "[", 
          RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], ",", "m"}], 
      "]"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
      RowBox[{"InverseJacobiCN", "[", 
       RowBox[{"z", ",", "m"}], "]"}]}], "-", 
     RowBox[{"m", " ", "z", " ", 
      RowBox[{"JacobiSD", "[", 
       RowBox[{
        RowBox[{"InverseJacobiCN", "[", 
         RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}]}]}], 
    ")"}]}]}]], "Output",
 ImageSize->{500, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->328309318]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20875427],

Cell[TextData[{
 "Obtain",
 Cell[BoxData[
  RowBox[{" ", "InverseJacobiCN"}]], "InlineFormula"],
 " from solving equations containing elliptic functions:"
}], "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->322808586],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"JacobiCN", "[", 
       RowBox[{"x", ",", "m"}], "]"}], "2"], "+", 
     RowBox[{"2", 
      RowBox[{"JacobiCN", "[", 
       RowBox[{"x", ",", "m"}], "]"}]}]}], "==", "a"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->554970152],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->198520500],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"InverseJacobiCN", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        SqrtBox[
         RowBox[{"1", "+", "a"}]]}], ",", "m"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"InverseJacobiCN", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SqrtBox[
         RowBox[{"1", "+", "a"}]]}], ",", "m"}], "]"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{520, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->507039090]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6421],

Cell["\<\
Machine-precision input is insufficient to get a correct answer:\
\>", "ExampleText",
 CellID->3979231],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiCN", "[", 
  RowBox[{
   RowBox[{"10.", "^", "25"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->563558634],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9557092]
}, Open  ]],

Cell["With exact input, the answer is correct:", "ExampleText",
 CellID->260060486],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"InverseJacobiCN", "[", 
    RowBox[{
     RowBox[{"10", "^", "25"}], ",", "2"}], "]"}], ",", "50"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->289346646],

Cell[BoxData[
 RowBox[{"0``50.03290277325207", "+", 
  RowBox[{
  "1.3110287771460599052324197242348815881866250356313753709235069234168`50.\
15051499783199", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{447, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->4429435]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2904],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiCN",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiCN"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseJacobiCD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseJacobiCD"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseJacobiCS",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseJacobiCS"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseJacobiSC",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseJacobiSC"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25854]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17549],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "Tutorials",
 CellID->1559]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->143598663],

Cell[TextData[ButtonBox["Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticFunctions"]], "MoreAbout",
 CellID->31845507],

Cell[TextData[ButtonBox["Inverse Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InverseFunctions"]], "MoreAbout",
 CellID->303729402]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InverseJacobiCN - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 49, 59.0885466}", "context" -> "System`", 
    "keywords" -> {"inverse Jacobi", "inverse Jacobi elliptic function cn"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "InverseJacobiCN[v, m] gives the inverse Jacobi elliptic function cn -1 \
(v \\[VerticalSeparator] m).", "synonyms" -> {"inverse Jacobi CN"}, "title" -> 
    "InverseJacobiCN", "type" -> "Symbol", "uri" -> "ref/InverseJacobiCN"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6718, 231, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->66034471]},
 "XRef-2005-4-26-23-37-1.8558342"->{
  Cell[689060, 12076, 192, 7, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342",
   CellID->715886131],
  Cell[691376, 12170, 238, 7, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342",
   CellID->322808586]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 698253, 12419},
 {"XRef-2005-4-26-23-37-1.8558342", 698409, 12423}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2322, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2945, 83, 53, 1, 70, "ObjectName",
 CellID->17698],
Cell[3001, 86, 778, 25, 70, "Usage",
 CellID->4570]
}, Open  ]],
Cell[CellGroupData[{
Cell[3816, 116, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4294, 133, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4417, 139, 533, 21, 70, "Notes",
 CellID->29772],
Cell[4953, 162, 893, 31, 70, "Notes",
 CellID->241713],
Cell[5849, 195, 114, 3, 70, "Notes",
 CellID->25366],
Cell[5966, 200, 262, 8, 70, "Notes",
 CellID->250399474],
Cell[6231, 210, 232, 7, 70, "Notes",
 CellID->31226],
Cell[6466, 219, 215, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6718, 231, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->66034471],
Cell[CellGroupData[{
Cell[7102, 245, 148, 5, 70, "ExampleSection",
 CellID->103384074],
Cell[7253, 252, 61, 1, 70, "ExampleText",
 CellID->692069],
Cell[CellGroupData[{
Cell[7339, 257, 138, 4, 28, "Input",
 CellID->335790773],
Cell[7480, 263, 176, 5, 36, "Output",
 CellID->574086572]
}, Open  ]],
Cell[CellGroupData[{
Cell[7693, 273, 129, 4, 28, "Input",
 CellID->107203619],
Cell[7825, 279, 174, 5, 36, "Output",
 CellID->936499]
}, Open  ]],
Cell[8014, 287, 124, 3, 70, "ExampleDelimiter",
 CellID->16101587],
Cell[CellGroupData[{
Cell[8163, 294, 297, 10, 28, "Input",
 CellID->153026984],
Cell[8463, 306, 2359, 43, 144, "Output",
 Evaluatable->False,
 CellID->27249509]
}, Open  ]],
Cell[10837, 352, 125, 3, 70, "ExampleDelimiter",
 CellID->576203269],
Cell[10965, 357, 60, 1, 70, "ExampleText",
 CellID->25780993],
Cell[CellGroupData[{
Cell[11050, 362, 251, 8, 70, "Input",
 CellID->23743233],
Cell[11304, 372, 1024, 33, 59, "Output",
 CellID->66788954]
}, Open  ]],
Cell[CellGroupData[{
Cell[12365, 410, 252, 8, 70, "Input",
 CellID->153381913],
Cell[12620, 420, 867, 28, 52, "Output",
 CellID->55068235]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13536, 454, 216, 7, 70, "ExampleSection",
 CellID->16706],
Cell[13755, 463, 74, 1, 70, "ExampleText",
 CellID->551805159],
Cell[CellGroupData[{
Cell[13854, 468, 230, 8, 70, "Input",
 CellID->102361289],
Cell[14087, 478, 273, 7, 36, "Output",
 CellID->230584937]
}, Open  ]],
Cell[14375, 488, 125, 3, 70, "ExampleDelimiter",
 CellID->169754269],
Cell[14503, 493, 70, 1, 70, "ExampleText",
 CellID->654966717],
Cell[CellGroupData[{
Cell[14598, 498, 241, 8, 70, "Input",
 CellID->368196955],
Cell[14842, 508, 235, 7, 36, "Output",
 CellID->623613988]
}, Open  ]],
Cell[15092, 518, 125, 3, 70, "ExampleDelimiter",
 CellID->327928165],
Cell[15220, 523, 112, 3, 70, "ExampleText",
 CellID->67807481],
Cell[CellGroupData[{
Cell[15357, 530, 196, 5, 70, "Input",
 CellID->152063859],
Cell[15556, 537, 225, 6, 36, "Output",
 CellID->35256759]
}, Open  ]],
Cell[15796, 546, 125, 3, 70, "ExampleDelimiter",
 CellID->203414112],
Cell[15924, 551, 232, 7, 70, "ExampleText",
 CellID->674035758],
Cell[CellGroupData[{
Cell[16181, 562, 189, 6, 70, "Input",
 CellID->952307843],
Cell[16373, 570, 243, 8, 36, "Output",
 CellID->345990485]
}, Open  ]],
Cell[16631, 581, 124, 3, 70, "ExampleDelimiter",
 CellID->23779011],
Cell[16758, 586, 91, 1, 70, "ExampleText",
 CellID->563494599],
Cell[CellGroupData[{
Cell[16874, 591, 251, 8, 70, "Input",
 CellID->343918558],
Cell[17128, 601, 241, 8, 36, "Output",
 CellID->369288992]
}, Open  ]],
Cell[CellGroupData[{
Cell[17406, 614, 251, 8, 70, "Input",
 CellID->257978136],
Cell[17660, 624, 273, 9, 36, "Output",
 CellID->230245001]
}, Open  ]],
Cell[17948, 636, 124, 3, 70, "ExampleDelimiter",
 CellID->54695299],
Cell[18075, 641, 202, 7, 70, "ExampleText",
 CellID->34569057],
Cell[CellGroupData[{
Cell[18302, 652, 173, 5, 70, "Input",
 CellID->313226108],
Cell[18478, 659, 323, 11, 52, "Output",
 CellID->253026514]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18850, 676, 239, 7, 70, "ExampleSection",
 CellID->19362],
Cell[19092, 685, 225, 7, 70, "ExampleText",
 CellID->197834340],
Cell[CellGroupData[{
Cell[19342, 696, 249, 8, 70, "Input",
 CellID->336277738],
Cell[19594, 706, 1619, 52, 61, "Output",
 CellID->734716851]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21262, 764, 223, 7, 70, "ExampleSection",
 CellID->11565],
Cell[21488, 773, 123, 3, 70, "ExampleText",
 CellID->147991225],
Cell[CellGroupData[{
Cell[21636, 780, 716, 23, 70, "Input",
 CellID->41283476],
Cell[22355, 805, 664860, 11190, 70, "Output",
 CellID->458106809]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[687264, 12001, 233, 7, 70, "ExampleSection",
 CellID->32379],
Cell[687500, 12010, 72, 1, 70, "ExampleText",
 CellID->10684727],
Cell[CellGroupData[{
Cell[687597, 12015, 381, 12, 70, "Input",
 CellID->530612772],
Cell[687981, 12029, 339, 12, 36, "Output",
 CellID->25342350]
}, Open  ]],
Cell[688335, 12044, 245, 8, 70, "ExampleText",
 CellID->77618357],
Cell[CellGroupData[{
Cell[688605, 12056, 106, 3, 70, "Input",
 CellID->30362828],
Cell[688714, 12061, 203, 7, 36, "Output",
 CellID->406936716]
}, Open  ]],
Cell[688932, 12071, 125, 3, 70, "ExampleDelimiter",
 CellID->390870124],
Cell[689060, 12076, 192, 7, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->715886131],
Cell[CellGroupData[{
Cell[689277, 12087, 225, 8, 70, "Input",
 CellID->809586479],
Cell[689505, 12097, 484, 17, 57, "Output",
 CellID->661697032]
}, Open  ]],
Cell[CellGroupData[{
Cell[690026, 12119, 225, 8, 70, "Input",
 CellID->192074691],
Cell[690254, 12129, 980, 33, 70, "Output",
 CellID->328309318]
}, Open  ]],
Cell[691249, 12165, 124, 3, 70, "ExampleDelimiter",
 CellID->20875427],
Cell[691376, 12170, 238, 7, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->322808586],
Cell[CellGroupData[{
Cell[691639, 12181, 359, 13, 70, "Input",
 CellID->554970152],
Cell[692001, 12196, 453, 8, 70, "Message",
 CellID->198520500],
Cell[692457, 12206, 661, 24, 43, "Output",
 CellID->507039090]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[693167, 12236, 225, 7, 70, "ExampleSection",
 CellID->6421],
Cell[693395, 12245, 113, 3, 70, "ExampleText",
 CellID->3979231],
Cell[CellGroupData[{
Cell[693533, 12252, 161, 5, 70, "Input",
 CellID->563558634],
Cell[693697, 12259, 168, 5, 36, "Output",
 CellID->9557092]
}, Open  ]],
Cell[693880, 12267, 83, 1, 70, "ExampleText",
 CellID->260060486],
Cell[CellGroupData[{
Cell[693988, 12272, 220, 8, 70, "Input",
 CellID->289346646],
Cell[694211, 12282, 324, 9, 36, "Output",
 CellID->4429435]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[694596, 12298, 310, 9, 70, "SeeAlsoSection",
 CellID->2904],
Cell[694909, 12309, 983, 35, 70, "SeeAlso",
 CellID->25854]
}, Open  ]],
Cell[CellGroupData[{
Cell[695929, 12349, 314, 9, 70, "TutorialsSection",
 CellID->17549],
Cell[696246, 12360, 191, 4, 70, "Tutorials",
 CellID->1559]
}, Open  ]],
Cell[CellGroupData[{
Cell[696474, 12369, 319, 9, 70, "MoreAboutSection",
 CellID->143598663],
Cell[696796, 12380, 146, 3, 70, "MoreAbout",
 CellID->31845507],
Cell[696945, 12385, 145, 3, 70, "MoreAbout",
 CellID->303729402]
}, Open  ]],
Cell[697105, 12391, 27, 0, 70, "History"],
Cell[697135, 12393, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

