(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    659542,      11793]
NotebookOptionsPosition[    651006,      11501]
NotebookOutlinePosition[    652656,      11545]
CellTagsIndexPosition[    652516,      11539]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals and Elliptic Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals and Elliptic Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"JacobiDC" :> Documentation`HelpLookup["paclet:ref/JacobiDC"], 
          "InverseJacobiDN" :> 
          Documentation`HelpLookup["paclet:ref/InverseJacobiDN"], 
          "InverseJacobiDS" :> 
          Documentation`HelpLookup["paclet:ref/InverseJacobiDS"], 
          "InverseJacobiNC" :> 
          Documentation`HelpLookup["paclet:ref/InverseJacobiNC"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"JacobiDC\"\>", 
       2->"\<\"InverseJacobiDN\"\>", 3->"\<\"InverseJacobiDS\"\>", 
       4->"\<\"InverseJacobiNC\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Functions" :> 
          Documentation`HelpLookup["paclet:guide/EllipticFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Elliptic Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InverseJacobiDC", "ObjectName",
 CellID->25280],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InverseJacobiDC",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InverseJacobiDC"], "[", 
       RowBox[{
        StyleBox["v", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the inverse Jacobi elliptic function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox["dc", 
         RowBox[{"-", "1"}]], "(", 
        RowBox[{"v", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
      "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29256]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["dc", 
     RowBox[{"-", "1"}]], "(", 
    RowBox[{"v", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " gives the value of ",
 Cell[BoxData[
  FormBox[
   StyleBox["u", "TI"], TraditionalForm]], "InlineFormula"],
 " for which ",
 Cell[BoxData[
  FormBox[
   RowBox[{"v", "=", 
    RowBox[{"dc", "(", 
     RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->22933],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseJacobiDC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiDC"]], "InlineFormula"],
 " has branch cut discontinuities in the complex ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " plane with branch points at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[PlusMinus]", "1"}], ",", 
    RowBox[{"\[PlusMinus]", 
     SqrtBox["m"]}]}], TraditionalForm]], "InlineMath"],
 " and infinity, and in the complex ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " plane with branch points at ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["z", "2"], TraditionalForm]], "InlineMath"],
 " and infinity."
}], "Notes",
 CellID->610144994],

Cell["\<\
The inverse Jacobi elliptic functions are related to elliptic integrals. \
\>", "Notes",
 CellID->18483],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["InverseJacobiDC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiDC"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->70927170],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseJacobiDC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiDC"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseJacobiDC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiDC"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->604320205],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->36682535],

Cell["Evaluate numerically:", "ExampleText",
 CellID->156488630],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiDC", "[", 
  RowBox[{"1.3", ",", "0.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25804197],

Cell[BoxData["0.9198645310074398`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->54189033]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiDC", "[", 
  RowBox[{"%", ",", "0.5"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->75588654],

Cell[BoxData["1.2999999999999996`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->5096536]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->306083438],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"InverseJacobiDC", "[", 
    RowBox[{"x", ",", 
     RowBox[{"1", "/", "3"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->592668477],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 129},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3030128]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->280795932],

Cell["Series expansion:", "ExampleText",
 CellID->511351488],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"InverseJacobiDC", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->183899751],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"ArcCos", "[", 
    FractionBox["1", "z"], "]"}], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SqrtBox[
        FractionBox[
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["z", "2"]}], 
         SuperscriptBox["z", "2"]]], "+", 
       RowBox[{"z", " ", 
        RowBox[{"ArcCos", "[", 
         FractionBox["1", "z"], "]"}]}]}], ")"}], " ", "m"}], 
    RowBox[{"4", " ", "z"}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "m", "]"}], "2"],
    SeriesData[$CellContext`m, 0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`m, 0, {
    ArcCos[$CellContext`z^(-1)], 
    Rational[1, 
      4] $CellContext`z^(-1) (($CellContext`z^(-2) (-1 + $CellContext`z^2))^
      Rational[1, 2] + $CellContext`z ArcCos[$CellContext`z^(-1)])}, 0, 2, 1],
  
  Editable->False]], "Output",
 ImageSize->{297, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1011815722]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19903],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->55645938],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiDC", "[", 
  RowBox[{
   RowBox[{"0.2", "+", "I"}], ",", 
   RowBox[{"0.1", "-", 
    RowBox[{"0.3", "I"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->266251706],

Cell[BoxData[
 RowBox[{"1.428652564180102`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.7035989083662356`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->291577764]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->268824359],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->132691703],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"InverseJacobiDC", "[", 
    RowBox[{"3", ",", 
     RowBox[{"1", "/", "2"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->866802414],

Cell[BoxData["1.\
5109586514187672605502044573978781162982167772402998921990648488376`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->126459616]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->36479535],

Cell["\<\
The precision of the input tracks the precision of the output:\
\>", "ExampleText",
 CellID->579439215],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiDC", "[", 
  RowBox[{"3", ",", "0.50000000000000000000000000000000"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->632752147],

Cell[BoxData["1.510958651418767260550204457397878116298217736661`31.\
24585083828964"], "Output",
 ImageSize->{235, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->104071807]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->688497564],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseJacobiDC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiDC"]], "InlineFormula"],
 " threads element\[Hyphen]wise over lists:"
}], "ExampleText",
 CellID->43876107],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiDC", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u1", ",", "u2"}], "}"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->271543877],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"InverseJacobiDC", "[", 
    RowBox[{"u1", ",", "m"}], "]"}], ",", 
   RowBox[{"InverseJacobiDC", "[", 
    RowBox[{"u2", ",", "m"}], "]"}]}], "}"}]], "Output",
 ImageSize->{332, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->344141566]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->255377976],

Cell["Simple exact results are generated automatically:", "ExampleText",
 CellID->328717422],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiDC", "[", 
  RowBox[{"z", ",", "0"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->617758456],

Cell[BoxData[
 RowBox[{"ArcSec", "[", "z", "]"}]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->578445017]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiDC", "[", 
  RowBox[{"1", ",", "m"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->658205930],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->386173359]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23210608],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->471035179],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseJacobiDC", "[", 
   RowBox[{"z", ",", "m"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->179888293],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["dc", 
    RowBox[{"-", "1"}]], "(", 
   RowBox[{"z", "\[VerticalSeparator]", "m"}], ")"}], 
  TraditionalForm]], "Output",
 ImageSize->{59, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->431035313]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29214],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseJacobiDC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiDC"]], "InlineFormula"],
 " can be applied to a power series:"
}], "ExampleText",
 CellID->120235099],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiDC", "[", 
  RowBox[{"x", ",", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"1", "+", "m"}], "]"}], "+", 
    RowBox[{
     RowBox[{"O", "[", "m", "]"}], "^", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->77454719],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"ArcCos", "[", 
    FractionBox["1", "x"], "]"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       SqrtBox[
        FractionBox[
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["x", "2"]}], 
         SuperscriptBox["x", "2"]]], 
       RowBox[{"4", " ", "x"}]], "+", 
      RowBox[{
       FractionBox["1", "4"], " ", 
       RowBox[{"ArcCos", "[", 
        FractionBox["1", "x"], "]"}]}]}], ")"}], " ", "m"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "m", "]"}], "2"],
    SeriesData[$CellContext`m, 0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`m, 0, {
    ArcCos[$CellContext`x^(-1)], 
    Rational[1, 
       4] $CellContext`x^(-1) ($CellContext`x^(-2) (-1 + $CellContext`x^2))^
      Rational[1, 2] + Rational[1, 4] ArcCos[$CellContext`x^(-1)]}, 0, 2, 1],
  Editable->False]], "Output",
 ImageSize->{302, 79},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->726014467]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14269],

Cell["\<\
Plot contours of constant real and imaginary parts in the complex plane:\
\>", "ExampleText",
 CellID->147991225],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ContourPlot", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"InverseJacobiDC", "[", 
       RowBox[{
        RowBox[{"x", "+", 
         RowBox[{"I", " ", "y"}]}], ",", 
        RowBox[{"1", "+", "I"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
     RowBox[{"Contours", "\[Rule]", "24"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{"Re", ",", "Im"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41283476],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyEnXd8VcXz95OQBBAFRBQUAUEEBRSRKqB7QYqABZAigtJURLqIoEgXBEF6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     "], {{
       {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
        GraphicsGroupBox[{
          PolygonBox[{{4369, 5953, 113}, {4989, 6341, 1863}, {6002, 5904, 
           113}, {6234, 5293, 1981}, {4431, 6002, 113}, {7713, 8180, 3112}, {
           6058, 6053, 1863}, {6016, 5969, 113}, {4349, 4431, 113}, {8180, 
           7709, 3112}, {5293, 6238, 1981}, {6341, 6058, 1863}, {6054, 4989, 
           1863}, {5969, 4369, 113}, {5904, 6016, 113}, {6238, 6230, 1981}, {
           4649, 7713, 3112}, {5953, 4349, 113}, {6230, 6234, 1981}},
           VertexColors->None], 
          PolygonBox[{{7709, 6054, 1863, 3112}, {6053, 4649, 3112, 1863}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.3257497057288623, 0.11362398206018565`, 0.5748609349076116], 
        EdgeForm[None], 
        GraphicsGroupBox[{
          PolygonBox[{{8575, 8573, 4165}, {5284, 5928, 1204}, {4873, 6936, 
           2479}, {2045, 1862, 1473}, {6935, 4873, 2479}, {4471, 5805, 244}, {
           2793, 2791, 801}, {4064, 2791, 244}, {1815, 2793, 801}, {7894, 
           7895, 3282}, {4505, 7562, 2998}, {4065, 3239, 914}, {7463, 7462, 
           2878}, {7850, 7849, 3239}, {7360, 4471, 244}, {6832, 4775, 700}, {
           3282, 2791, 914}, {7420, 4774, 700}, {5928, 5288, 1204}, {3238, 
           2155, 700}, {2878, 1984, 1473}, {7898, 4872, 3284}, {8503, 7719, 
           914}, {5288, 5926, 1204}, {4872, 7900, 3284}, {4774, 6832, 700}, {
           6463, 6720, 2155}, {8584, 8575, 4165}, {7896, 7898, 3284}, {7358, 
           7362, 2791}, {1473, 1984, 503}, {5305, 6242, 1984}, {6061, 5284, 
           1204}, {2791, 3282, 801}, {6931, 8584, 4165}, {6466, 6463, 2155}, {
           7849, 8504, 3239}, {1862, 2998, 1473}, {6555, 6997, 801}, {5897, 
           5899, 1815}, {4065, 4064, 3238}, {6926, 6555, 801}, {4871, 6926, 
           801}, {4064, 4065, 914}, {2300, 2155, 503}, {2155, 3238, 244}, {
           2183, 1862, 1204}, {6496, 4504, 2183}, {1984, 2301, 503}, {3239, 
           3238, 700}, {6998, 5901, 1815}, {3238, 4064, 244}, {3239, 4065, 
           3238}, {7719, 6739, 914}, {6936, 6933, 2479}, {2301, 2300, 503}, {
           4649, 6053, 503}, {2791, 4064, 914}, {2155, 2300, 700}, {5805, 
           4469, 244}, {6722, 7421, 2300}},
           VertexColors->None], 
          PolygonBox[{{6053, 6058, 1473, 503}, {5905, 6017, 6016, 5904}, {
           7562, 6497, 1473, 2998}, {4775, 7850, 3239, 700}, {6055, 4990, 
           4989, 6054}, {6058, 6341, 2045, 1473}, {6497, 7463, 2878, 1473}, {
           4350, 4432, 4431, 4349}, {6017, 5970, 5969, 6016}, {6242, 6723, 
           2301, 1984}, {8504, 8503, 914, 3239}, {4599, 5897, 1815, 3082}, {
           6997, 6998, 1815, 801}, {4469, 6466, 2155, 244}, {7421, 7420, 700, 
           2300}, {7895, 4871, 801, 3282}, {6933, 4599, 3082, 2479}, {7710, 
           6055, 6054, 7709}, {6739, 7894, 3282, 914}, {5901, 7660, 3082, 
           1815}, {7660, 6935, 2479, 3082}, {7362, 7360, 244, 2791}, {4432, 
           6003, 6002, 4431}, {5970, 4370, 4369, 5969}, {5380, 7358, 2791, 
           2793}, {5926, 6496, 2183, 1204}, {6720, 6718, 503, 2155}, {7714, 
           8181, 8180, 7713}, {5899, 5380, 2793, 1815}, {6231, 6235, 6234, 
           6230}, {4370, 5954, 5953, 4369}, {5954, 4350, 4349, 5953}, {6723, 
           6722, 2300, 2301}, {6338, 4986, 1862, 2045}, {4504, 6052, 1862, 
           2183}, {8573, 7896, 3284, 4165}, {7462, 5305, 1984, 2878}, {6003, 
           5905, 5904, 6002}, {8181, 7710, 7709, 8180}, {6052, 4505, 2998, 
           1862}, {6238, 5293, 1204, 1862}, {7900, 6931, 4165, 3284}},
           VertexColors->None], 
          PolygonBox[{{6718, 7714, 7713, 4649, 503}, {4990, 6338, 2045, 6341, 
           4989}, {4986, 6231, 6230, 6238, 1862}, {6235, 6061, 1204, 5293, 
           6234}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.35808341145772454`, 0.1698435641203713, 0.6203098698152232], 
        EdgeForm[None], 
        GraphicsGroupBox[{
          PolygonBox[{{7894, 6739, 2311}, {3117, 2310, 516}, {6554, 6556, 
           2221}, {6496, 5926, 1825}, {6722, 6723, 1346}, {2397, 1346, 459}, {
           803, 853, 388}, {1813, 1368, 301}, {7582, 7316, 2753}, {6723, 6242,
            1346}, {2480, 2478, 803}, {7660, 5901, 853}, {2517, 2222, 853}, {
           2841, 2842, 459}, {6239, 4870, 1813}, {5329, 7315, 2752}, {7317, 
           7582, 2753}, {5294, 5896, 1205}, {1825, 1205, 301}, {1346, 2841, 
           459}, {2475, 3283, 2311}, {2184, 1368, 1206}, {7579, 7317, 2753}, {
           8576, 8578, 2478}, {3240, 2398, 2310}, {7463, 6497, 2184}, {2221, 
           2311, 516}, {5305, 7462, 1206}, {5445, 6743, 1368}, {6745, 6240, 
           1983}, {6149, 5689, 388}, {5300, 6952, 1205}, {6497, 7562, 2184}, {
           5688, 4624, 459}, {6935, 7660, 853}, {1983, 2843, 1206}, {2273, 
           2397, 459}, {2310, 2273, 516}, {4623, 5688, 459}, {2310, 2398, 
           2273}, {6648, 7021, 2273}, {6938, 8577, 2480}, {6931, 7900, 
           2478}, {7314, 5329, 2752}, {4505, 6052, 301}, {2222, 2475, 2221}, {
           6743, 6744, 1368}, {6998, 6997, 2517}, {5446, 7431, 2842}, {6649, 
           6648, 2273}, {2311, 3117, 516}, {5808, 6149, 388}, {2841, 1346, 
           1206}, {8578, 6932, 2478}, {2398, 2397, 2273}, {6928, 6554, 
           2221}, {7850, 4775, 3240}, {4870, 7429, 1813}, {2222, 2221, 388}, {
           8503, 8504, 3883}, {1368, 1983, 1206}, {853, 2222, 388}, {6952, 
           5294, 1205}, {4871, 7895, 3283}, {6226, 4889, 1825}, {5896, 5299, 
           1205}, {3117, 3883, 2310}, {8459, 8460, 2753}, {1205, 1813, 301}, {
           6240, 6241, 1983}, {1368, 2184, 301}, {7420, 7421, 2832}, {6052, 
           4504, 301}, {6939, 6938, 2480}, {8460, 7579, 2753}, {2843, 2841, 
           1206}, {4889, 7294, 1825}, {2397, 2832, 1346}, {2475, 2311, 
           2221}, {4554, 5808, 388}},
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlElPVFEQhQvptrsBpR89QT9s8iQRjWHtsBBoo+6MQlCIM2uHhThEIwgx
kbjUjUaXKqChY+KQuBGEnS6Nsxt/hFPi9B3qLU4obtetOvfUqReNnOo/ucLM
doME2N5m1gt6QBVMlswGQD+YADcDs6OcRymz7jqzf1mzvZztAX+J7+XNNpC3
HtwlHs+ZLbWaLYIx4lHOW0AAToOtRbMwNHuUMeusN2vgrAk0ggyYrZg9ADNN
ZivJuUiNIWrtBxeIB7l7Gz61tNlbfv8ZeA3d/UGcWmPW3GL2Gq7lRuc6GvcW
54GyWRf1u6mf4v574ncVj99wluXuL+p/TXsN9VpNz4cZ73k2cM2k1Rni8chs
CkyjxcsGsz7q94BtoBesg08XmOLuMwTPU+tqnF+jZrJgNt9u9gIkiMf47SN8
PoBLxNe4eytw7VVjgrPLkd+Vht87zDrIrYBvHX73M/gU1xC3XOj5yxzpc556
58AC8ebINZfWG5v5S7+dBdeuDeT0XrSrao6B95ohni55z2PMZRf5IbnzKZ+l
3qS3aKbSopO8tRXX5AY9m+GTwIQL6HWC+Hj8vzQvhj5TzbJAPEL953nXrpp0
7jU8NFf0N8ir4ihu8myt5J6UF+dK3lsaSRtxUK/r7d5bPeX9vnhW2oEMHiuR
M1jv/ryPH36Tn+V9h6R52c8UH8747JbAYjxD7cIsvWfyvhN/OKuWnbtqfIFD
Oue1NRNpq53SLkljef0gOBB7frrFe6qXdkK7NBnvpnZK3kzl3LvyqLy9KfJZ
yuPyWmPk3tT8VVsaSRv1GKL2cNlnNwTHttBnIO1bQ59VFsylXa/HvOsI9wrk
P0342+WphVgD7b52Vru6/A3g7Enec/UN2VL0b4Def6XOZ6md0i5ppqvgtS/0
3dYM7jCTV4HnioO8Jo/Km/JcknhHwbmLk7ypb5C+PfLof02PnrQ=
           "],
           VertexColors->None], 
          PolygonBox[{{5289, 6226, 1825, 5926, 5288}, {6929, 6937, 6936, 4873,
            803}, {7316, 8574, 8573, 8575, 2753}, {7899, 6929, 803, 4872, 
           7898}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.39041711718658684`, 0.22606314618055695`, 0.6657588047228349], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VE1LVGEYfWwc50tzvu+Md0Yd/QUFLaxIolQIStACnYVlziJKaydUELXp
Y/qCaiW26BusCHLjJksiooE27aKNlAPSriIz2nQO53XxcN/73uc9z3nOc95b
Onpq6OQmMzuLCCDmmswmsBjC5mjQbDJk5mOdSps979D7bNHsLmIpZraeMMv6
ZgsNZvfxfIn3XVjnkLcGrC5g/c2bxZNmX8NmrzJmvz2zYWAOplAzi1rIGcD+
eM6sjJo/8b4SEY9HwLyHCEXFbTmsfeLWGlUrWzCbBp/9jeIcxdlOfL/aaVZF
dG82SwDjSzt6wLc+1AoiPwf+TUXVLrtz3OPZw+Ayj54XQzrPvom9F73sRkyG
1cdoUr2Q4wPH81qTcokTiwiXGl50epDzVvS+E/nv8a0/Ix4bHHiW+QuoU0Nv
fTjTitzbWD+LSNexqPolL+rF/Mvo9QqiC3zXqHNGNXvbwBnxD5zfRaRBLzi0
gnuoKE23Yw49iKfIrwTUB3myF+KR00AcXBHf8O6BS0NJPPrAsx8xBZwZ8EkG
5Yc09Bsuih9rslfuX8K5NPpZAc4IODz05Td64UBKflgC/lvEalSeuuGJz2vs
BTOqQR+UnVas+z2q/WxIGJ2uj4rz8zHU+ZHTmlxXXX53uzSiPuTE/qg5/Trn
9KAu1Juz5jv3iZMD3nha9W960p2ac070J+fdg7pbUtL+OnI+JKTrGfQS8MSX
M30RVn43ZvgJmG/gxainO0bdiFdx/mEf1I4cPoP/uZJmugy9P+bV/x48pxPy
Kr/fKSiHOPWIsOK+vEW+vi8fsNdDwDnu6x5yfhPOY5PYm/J1nnnVkHT5g3/D
PtR43CJf5AryBr1VdrMi3gmHSY6DbtaxZunHHmMl+YNzYAw4vzHoPeo/ilmN
tOluzRSlF7XiXdmW0uz4P1jMuJlhfdD5cEdW94o5Vac7c+quHvc5k3pRc+H9
55Neou+aPXnmPDheKIkTa9fdWWrwq0M6jCF3PiHNT0OLJy3yGP3B/yNnnff1
b9q4H9SCOtDL9ChrHYEX1jt0vga82by8cqugeXAW1JGeIs//ily8sg==
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlElsjWEUhg/V6d62qvdv///29t4OLLCrRKIhhlRrRaIlVKgWC6LYkBBC
VWIeEsOmhoWh1FQJEhtTSqRdSNiJTYMmIrFpoioWPG/OXZzkfN8Zvvec856v
dtOulp2TzWwjMgWZSJr9Qb4UmG3JMVsacjnN7F+pWSP6m8jsQMJsPzKIvhfb
6yqz7zGzHcQsIbae8z7OXZwfY29Imb0tNFs0yexwrVkl51YebSZngN7D3TL0
byVmNznfQvKJb8FnBe+c4d3TeZzB01ZmFsP/a4nnKMN3Dj7vyP8A6QBTW6VZ
HD2FvQjfeK3nHkVelJs9L/fY5VO8thZkZbZGYemudWzCNFZt9hvpKzb7Sz2f
M2afMl6L3hsi7niNWV2JY3wamM0C00zkCfoxbKeQ6djbcs1WUUtATAJpRS+l
nnkVZnfzvOeyqefqtXwmqh2D3r5d7Fj3YNsdOuZL9Ppy2uxV3Ox9sfdmPvma
crxHyj2VN0YK/I0Gzrn06GS+2T3O+cQ20491ue5zJHSMwtaD9CPd9PcQcge9
CIkhz6i/jJhH5BsGxwCx43meW3fS9YawaQbqvTAOgSUEc3vMfS6gf6BPw8zi
Pv1cQN9+EhMv8pn+AlsJ70XkOor/KLaRtHOhgrtE6JiFtQwZp1fTM94vzewq
vu2hz+t13GsRh8Vd1SQut6GvjZzTj8FSEHruF0ilagfjQSSJ3od9NvZZyC30
zsg5J66ph5pNIotFMxJ21axaVcM26tuacm5vpoY8cm6M/K0azjPgypW0Y9U8
H1BPwDtj2LrwqU8458U97dRi9q0x6bumndue8jeU+1uhc3GA+IeBczKijooq
575moN6f5zxa6DN4g96U9F3+gb0m4xzQ7Ksz3qsNyPpsz1aBdXXa3xLGXmJL
Uz7LOs0IPZnFK84odoBcD0PPcSXpMfIVh9ayu2uQWKHvsHzVc/VaMSdqfKe0
S9o5+TbBkSjuMUsqvSfqhThwl7hW3mlB+tF3pPyP09+mmmXTjDVb+dzAfh1Z
OMn/IM1eO61dFgc6A++RetOb739ZKuW7pD9Ff19H4LsqDOJyFLmvOH0S7InA
Z6k/4WPgM9estR9nqfFc6FwXhovku5blgzicm3bOiCuqWTb9AYqXz1xsvdn/
QH+AuKoeqHZxdhDfl1W+u/qz/wNS6cyH
           "],
           VertexColors->None], 
          PolygonBox[{{5295, 7290, 1814, 5896, 5294}, {5807, 6468, 2156, 4470,
            5806}, {8179, 7712, 7711, 8182, 3494}, {6470, 5807, 5806, 4472, 
           2157}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.42275082291544913`, 0.2822827282407426, 0.7112077396304465], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1ll1o1XUYx5+513POdsZ2jtuZ52znjDK6yZympRY0eiElLJtdeDGzuqgQ
WsYKCoNAw0pqgXQTplDbRVgYmkFFBrG0zbkLU4oiu/CiC12kZS6D6Pvp+/Pi
4f8/v//z8n2+z8vv9D828tDTCyLiuKResi0X8YxkVO91hYi1pYiqPjS0Rsy3
RSzT+4pKxErJ9mxERrI4E7FH51/JrkW/TzREDNX7uUTO2/XMS3bI5zd9ERsX
SU82bzdFbGiO2Crd/pxt0J/W2YBkRjZruiKy/REfSve9csT7Zcf4VvGPS+6S
zS2dEY8LZ6Nsf+mNOCtpFN6x7og3Javl67LsX5TdNvncq1jDWeP5K2vf4BuQ
v8Ee69QtjFhXc85biv7GeaHReT+r92U6W16x369bIs5n/f0e+ZisWAcOwAs/
5HUSDvVsVB4LJPvEw5eKdVTyQJO5ubHP/BTz5mhQPvPK47J0flWOh5I/8n2h
2Xbgv7nFdpzD5Uze+if1nE3vnYo5oLoOpu8n0zk4+H2kLmKX8n5N0q/fu+T7
WMb6q2W7puzfxIRHODyrfP/uiDit+K3iPt/rel4vH6eKriP4sEGfetArcDPc
HrFZMi5ezkj/FeX4fN4ymnfvvSN/KwrmjbPnJIeE86p07xee3fJ7vtXfOL9B
MY9U3XfUmRzJb2+vMYEH/uCRfsP2Qqtj0e9R8Dv9db7PPbZdZ5Ml9+oqxTzc
YW7+kc5VSXvOussL1r9Yb7/goX83dbrPiMP5Dp0fFaaxjGcKTPQ8tlOdrjd1
GU7c4L+PWZTsk22bcnmi5HrNJfz4pL+m0+zAy1w65/tvKcd22a4Xd9flXGPw
gBd+fxcn3Y3GymwQ64zy65T+vH6vVX5NVfvaVDIvcHJQc3pvj+dsNvUV3D+i
PLZ0Ozdqsrjouky2mX96dTRhANtsxt/pk5r8ZxYazxey2ykch7O2O5xq973m
5cpC1+KnDnMEZuL82Z1iye7RoueR3TbU5nzZW8wMGB4WJxt7vf8mVN/xsndb
UXYfVW2zWf7elc7SZu+t+9LuOqDzB0v+Ta5TFefLXpho896YztiO+jLX1JWa
vpQ1Z2CDc+aZWblNPm6t+HuXnqWK+WRWsGUnjObcP+SwJ+VDLjvFx+ma54Sa
UUd8HhS24YQTX8wEPH8m3wd63If4eyv55NmS3un9l1OtnxI3WyXnMp55+oYa
zYmb28vegR8r1h2LHOui6tJQdq/WNCN/VI1/JOeY3DXUn16kVzeUPdv074k0
q0vSLMAdtpc0I/XS259JfZyzzrUc/veZ9a4Gzwfdjo3tULpvwHNKuZ+umCN6
7ece5wJ26gr+u3vc39SJexDczDX1G0/1pa9G0r1ZUM+8XnOP/SicxxR3UnbH
W1xj+pO99W/KER6pJTzf2ep8yGV3zbsYXi6Js/mq44EPX/hZ1Wwf8Ea9iEPN
vqt4HtD5RPh/6PAdRc33p7qPpLsenPDCXUN9mS1wgGFp2iX07UTaQ+S7Ur3w
adXzOpbwkztzP5P2LWfnUi1eVR5THcbJ/r/2HwFdntQCfNSKu2Yk4YJn3uGd
2oJ9NuHvks/Pi94l7EL6DD9XquYLrpYVfOfhk/8EDWknX6AXyp7L7op3LvuW
/Qe3cEzufGe3vKFeWF8w36WSex2sS+TjprJ3eZd8dHSZxyfLnhPy/w8ytTsF

           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlVls1FUUxk87XabLtGlnOjNl/mPboEYxKpRFFh9sLC48gNKSyAMo+mIk
UTFQI2AkaY0LUUyMLwYxKmAUjaQV4hIxMYDSSB+gxCUBa4z6IBpRC1UT4+/L
Nw8nc+//3vud7yzfmZ57H1r9YHVEPIrVYIuSiAXYI2y2N0Y80x3xNDZcFdHT
EtFVjOjGCrURe/h2YymiNxvRl4rI8m26I+IiNsD+Z4Dnc3b+sojxhoib+bYN
rHx7xEt1ETnwjnN2DEtzfrQ5oqoH7MRvJzj/sytiBd/Wt+ID/LNl7oA/k4Ev
99/A/2vYi2Cn4TvAeS7HL+cPN0WcaIt4rhCxpN4xbOTuA9hmYv0Bn1fhewF8
aqvNoa8zoh+bht8mcjACl8XcuQlfY+BvJ/a7wZsH3ni9Y93Ffmm9Yz4M3yvx
38rbCfDuAvsCb65PR1zB/lzZMYh7LTYHLge5/x52Neu13J8G7zHw3oHDMr6N
dTq/x3k/Sf5uBW+UWLaQn1s4W97peomzfN1fcmzyuQHcYtG10Z0d1OOtgnO5
MeVcrIHPpibnpI/9V7Minqpzza5l/w2cdrE+gu0tOSbF0kA+qsjvALYaC+ws
XM5hk2n3yBfc7SWHWxvN73L4nGE/w74FPttY18AnhW1lPYx9nHOuRxtd230l
+1KNnyX+nd3uxQvsb0jsQ9iPc2d5wZzEpb/gXH5CjVbVOacTcLuDHKzCTrL+
vuxvWk+xngTvdOLevgheO29PJV6Ls2IdAnNLoRIzOGfgMyRtwKfEfgf3n8Bm
ZX03h2Urb94ktmv4nYPtZz2Ezzx314G9mxr8DeYGznrrncMD8Lqu5Nz3gn8a
XyMdrv3mFmOPYMMVH8rlT2D+WHZOq3n7B/l5lfd7sGP4WphY279gC+E4zv73
Rvt8hXe7sS+pzVz2o5wfBOc21nfWu/e+K7t31YMr4PNhYm7S5DzuLym5f9Sz
xcSalpYVY1vemMLSDEhxd1HWWhHHd9FPNufaSsP/EWs/57/ib2edcyMNSnvi
O1i25qV19bBysQYbrORklHy+XvJs+LTJWFX4ON9szBnW9+Ss9b0Za1E9qV6U
Jufy+y/Wytt9GefqA2ryedo5q+N9Vda1/63Z2LdnvZaP++CaJ0dHM54x4tYB
p1ybOc5P7EPY0oiwl+Wtffk4nPOM0Gw4xPoUNhu8kxnXaAqtftvu2flCg7Wq
b1pLs38VrDlpTTNJs/RSl2PVTH2+kiPlRjNMs66VfM5u8sx7ssM9p15Tj6u3
xUlc1OPqNWloqtJzK4k9lXetNHP1X7I4sTY1f1q4k8EO6f8EHzXEVVtyb+rb
GFzWF9x76qHBojUlLQ0UHfvLZddeOfgo55mhWaEca1a+j32Wdv9Jawe483bO
mjuheZH4v0gzfCXxNZfNRTFfYr+05Fkr/1+3WTPSijD/Sfwfpv8u9cSRDmtY
2tWMUW01gzR7VON1cF5b9KyVhsRFMSkWcfofot0CzA==
           "],
           VertexColors->None], 
          PolygonBox[{{4944, 6993, 1675, 5635, 4943}, {6224, 5287, 5286, 6063,
            1864}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.4550845286443114, 0.33850231030092826`, 0.7566566745380581], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1llts1FUQxofLdoFuu6XbLd3u0t0SKTzIJUIL8cLlRRPUgiQYVEBAwQdR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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmto1XUYx59ztrNzpmeXs3Pdzn87Z4Ir0makLslkCilU3rY2UQoyawpd
QWga9kJjKygIFvamF7WgVxm2RV4237jMdaELqVthqGXkpaZWCNJGrc+X57z4
cn6///N77rfTvO35zufCZvY6KAeZhNmarNlqkOb8YcqsO2fWBQ5w/jNtdq7O
LBI121th1heYHeP7UZi3R8x+guc0327NMRuPmT1YNAvBE4d2kW/hAt+SZg+A
EOdb0H5oMHu10uwKhtRxn4B/N/Jb4PmN+zB4o5pv6JuPrkPwPV7Fu5BZTcZs
IG82C/9+6AnuGew7Ba2/zKwS3iK2v4u8G+j/HNlfgOucr4Hl6L4PTMf8/S75
DVKgF4SRHQGDyE+VOa0f9JXeHKg3Gwnct1FkLEHfzoTb2o79w9B6sPkd9E/y
Zi3xiPImDW2Ke1fCdUrXw5wD4rIPnr0gz3mGt+vQvxZMc97Ku8fACP5lkJFv
NqsHJ9FtNdjRaPYdNn0LfuG8Dn0VijH6/yVms5xXI/d+8B/nr/mtzXjsitCb
cp5D5U4255uwCdwWJx+gkPM3oimmZ3nb0Oy6Fc+2tPPobZKcbUH2ZvAi9o5Q
I9+g7ynyV0BXM7hJbHbCX1eLfdA3c1+a9ti9hfxu7P+IWEwgO1LtsVzJvX+O
27AIeb+jrx/7V5Kf9fDWNHot9oCXoT9dcF3PKH/wD2LPFO+fhb8Deiex7QAb
S7E/wpvDKc9BB/o3FD3Whv4vA8+B7qqhJmqnt+i+7kL+GeinAq9d9cBxavFJ
4vVp1HWql5Rj5VY99RX0CWS0l3n9vwRvBPnlYA/nceI7QC7fj3kMR7Erg76x
qPfcKuyewv9f495Dq+BpV/+Ue4yqiUW80WMxb67Zec4XwNGo92Qbb5eCt5G9
h/c/ou8T9I3F/NvCrM8A9f4Czv9APw/9dMxrsBU/rqL/Qtx9WIEvQ1nvJfVU
OOE1rtoOgcuNXqOqzUtgMbrvBpfwfTf6TbOBuIxiXzLqvowH3ivyaTH0P9B3
Me4+T5Hba+A98jsIYmmvSdWicqRa18zRrFHN3w5vFzZugNYa91n2ATxzK3ym
raAWW3gzgP1t1PRV/F5U9Fr5Gf3j0M7CM429J+Jey+oh9Y5q+gVoPdh/Iuoy
7yQ/rXmfDeLp4f3WgtdKUOW5vlyKhXJ+EF8/DnxWzKBvEP2zGY+FYhKFN6zZ
CSo4d4NHCi5roWae5mfR3x+PeO8mc95L6uHhlNeYamuI8zJsew2fx2rd5+/5
vqnovTY/4rNaOqVLM7uX9/uS3kvque0573H1tny+zrtJvu0o95yotyVTstTj
j1I7+xNuq2w8V+8zWrNZNXUz6zNes107QL1zI+27Rj20g3tVo9fyZ9yf4L6k
znOpntBuaIF/W5XviE1Z32naZd1Z3yWqGdWKdsoR9IfAK5U+Q/9KuA7JjsZ9
1ktGd2nmv5n3naH61s45Q6z60h5r9dSCvMdYsb2DczOy5uV8tg2GvPZONnnt
qAbvITbLAu899cBhbGsjvmvK3AfVunaW6lk1r9mumaVZpRmv2aUdod3QUcrl
XUmfhcrpFuxI5bx2lRPtgo1Fn2XaCQ9xXl/03aCdtBwZ9+Z9FmkGaBbKJ/mi
maj/BuFSL+s/gnaTdop2iXZUGfi7znelfCjPe0wVS+3QKPeKvMdCM20a32YC
733t7Cv429ngvaeZMhR4T6gXtAMmG3xmyj7l7H9SKzHV
           "],
           VertexColors->None], 
          PolygonBox[{{6060, 6222, 1979, 6224, 6059}, {6223, 5932, 5931, 5287,
            1979}, {4648, 6060, 6059, 6717, 2298}, {4866, 6218, 1978, 6217, 
           4865}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.48741823437317366`, 0.3947218923611139, 0.8021056094456697], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl2uMldUVhjfnzJyZw1w5c87czsyZM5QBESL+UMZEEARp0pZqGQai8Z+p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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmlslHUQxodd2u1ytLZ7tu92d8upKYIfhBpD5ShiwlFooRWhJmoCJBgB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           "],
           VertexColors->None], 
          PolygonBox[{{6225, 4893, 4892, 6229, 1980}, {8311, 6691, 1344, 5430,
            8310}},
           VertexColors->None]}]}, 
       {RGBColor[0.519751940102036, 0.45094147442129956`, 0.8475545443532813],
         EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHuMlOUVxt+9zMLs7uzOLszsZXZgSaTWYmuNKb25QLlUWxPqAtKk2P4h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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl2ls1UUUxad93WkL7dva92/7ioqo4IILbmwWEBTDDpoIJqKCxgSIJCzR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           "],
           VertexColors->None], 
          PolygonBox[{{7289, 5895, 5894, 7293, 2736}, {7393, 5121, 998, 7391, 
           7392}},
           VertexColors->None]}]}, 
       {RGBColor[0.5520856458308983, 0.5071610564814851, 0.893003479260893], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw9mHts1eUZx9/S055e6OlpOact7SktOsOmuA1wi2FeNrcoFIwOSLYlGBKM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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3ts1eUZx9+255ze6IHTnmt7DudUbJyim5NtGoV5D1IxEiBDEy8R4sBk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           "],
           VertexColors->None], 
          PolygonBox[{{6987, 6992, 6991, 5629, 798}, {5824, 7988, 3335, 7996, 
           5823}},
           VertexColors->None]}]}, 
       {RGBColor[0.5789655173774839, 0.5518986748897328, 0.9098439926936246], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHtsluUZxp/Wlq/n0vb76IEevg7MJkK2yVDnlH/GMskkArosMyyKVKLO
UbdlDhUZwjJR2bHTcqoU0IQiCAhBqkjRBaUZidvQZRFm5sKZYGYKA5yQXT+u
m/DHk+997+957vN13/fztt/bOX1OYUppY0FKV+n3+9UpFQxPqbI4pa9lU3q8
NqWl2tBZltLyypRmFaW0YURKL2udHqZzoueLTX8ml9ItzSkN6n1PVUrvaI0X
fZr2/UG0XvFfJx4DOjMo+jVaXUG/tcp7/qfn9XnJ0Jos2lnki2/DVT7H+Z/q
3Ct6HtD+a6V3j377tfJ6HiP5J9us7+gG8W1MaU0mpV/ovS/ObqqR7uL5S+n1
Gv/pd7PoF3Ruks4v1t73MrZjsnjOkh9uFv0R7VmRsQ7of7X4n9eZl7TnTvnt
SfntDv3ervPr42xXhX2xBbvksyXSZ0jy/i75H2h16HlI/u3Q2Rna/2ZLSju1
Pi6XXOk5XrJf1NnF+v8prXvEv1u8WyV/s+gT9P+AdGgvMo/7gs+D4lsn2vPa
87jkTG+XDjq3utB74TlH9KmiLyt2nPiF5/yMZfA8SrosytnXnSUp/aPIftgh
W7ZpnZec66TDrjbHEh2fC/2wjdg8ID6zdHatnk/pebDNZ9g/R/QlGcflQn1K
X5bNu7XnqM52FHn/9fLFhHLzxS//0uqUjT+o8j74vqp1Wra9Lfp2xeWz4ZZ7
NuPcQI93JffrWeddo/Y0NTiebyrXdmnNEL810meD1kJioZjv1DqseBYo5idK
U5or+le095x8coh8UHzflpytWgtLnVOHCh33V0V7KzmXnqhyPh3Q2YN5v/+o
Sfmi/G4vNZ9t2vsnrR7JbJeePycOFeaNjH8WOTfJl77AEX6bL53Wad2lPaek
1yc55zR5hs51ws4Z5d1/G43VKfLfY8OMte/q/yV6H1dk2vrA4NoS+wJ7OdOV
McbZ9+dhzqMJyo2+nPktCYyhzzf1nK8yNn8vW+a2W9fjsveYVlepbQDT6E58
tgR+t0QsiSP1A+yQD1NHpvQdrf2lxv4t5c7J0dLh6ha/3yRZj7ZbD3y6JuI4
W3m6u8168/83mr3n/qxrBPXhgOz4MGfcUIeg4Yef1MnWettEriwIG99V3PY3
OdbUgxWRwzfKxzdodUj2DskcJxmzK72eKHcthT85TN0Dr7MDs+AKfFE3Pipy
vKHfIB0+bU3piHLhXuF/ZrVz77xop7QOiz6y0mfYv1LvPZGXf6xwLpKH4HlV
oWsRZ+BXVeCcQhZ17Ljwd0Y8+/RcLP1vlexpilO/ZO6ott70B/oE+JwZdPRZ
V2r61gLT+oNeKL++3uyewnn+641eA4394OnZwNST8m2PfNuLr0rs28HIO2rX
6rCB/8EYC9rWeMZe/j9ebTux8RnxXCm7lun9kNaxamOGM92BVTC4MvwGbWn4
jd9l8Qwm7650jObJlovVjukLcRb8bgte8Ia2Iujw6Q7+y4P/ZVw/UGz/g7+B
QudevtR1Bwwi586Qdb1y6qOcffF8hWP8VtiLXdhXEL/ga5Jsvz1nGV2xH0y1
ypatRfY/PQS+8IQHvPBbU6Xzs1G/3fiv1efRA33oI9QPYkNtALd1ha5F1Oxp
smGM6Et17rqo7eTg2KIrMeQc/j8nnJ7Vqsq4f4yJHjdKvMuGuT6Qs0MRU86P
jz0Pyb7NefetwQbnMTkMvuiL6IQN98UzdWZU8KyL/ouvkAMdO84K97tr3GuW
yIerWo0r8po+RK7er9rzQpPtuTHrHnNprpHdi8SnQNjZKd1ek0636f1kzBrU
pR7t+WuF+w3rk3LT22XHF7T2VRpfYP5AkWMBzsE48vurr+BpZmCKmgh/ai8z
w8w4e0B67lNdKtf//5EtH7RaNjMLcXwpee89wQcbeCYOs2OuwH+nw4/4Bznw
Wxg4YvYh90/IB19s9gwGD3jBk5wsrHZcqP284/PL+Qr9Kem4vcV+Q25T2Ev/
2BdzF/reEbl3TL49mnPvgn4xbKGmPR29kl5I/cYn1IPjgY1VyrWB2oiJ/P3D
nPOHGgzOwXihcmBt1jj5kmy6RuvH4nu4xnmGzswg0KiHzEPYhtztGfsHPzHL
MuOCbWZmehj6TJLMItlbX+7ZiZgRr/el12Cd/U0vHVHu/ZzlmZ7Mb3080+vy
MZ9c6u0Z1xJye37MBuC9PzA/WnbdpTi1ZOwLauH88A/v2LVfOtzcbh2o05fq
heg3yR9b8p4Tj4rH97K2fU/M++CyT7ocKfP8Rv9YX+qzy4WVC3nXBebJvWX2
N2e7oi6h069KrCczKXLAeHXOcwz2Fss3ZZKdzfhesqnM8wlnsqEn9YaZEp67
JXMg75nxYfGZmLWu7EU/9nOfIb/o6ei4osl6gpuUcyyP6Fx/g2MEXhbHTA6W
N8TMdFb7qxo8M/EfcQVHH2csA/7k74Lhxgtz9GcxS/9WZ3/T6PkLeRNLjS9k
7s5ZblHGcyYYmVLnPo0NA8L0Lq3XKyx7bdzLwNPiRu+/qJhWjnR8mA2ZEckZ
+KEfun2qPb0NnhuZfYk78Wf2Io7IYnbnXgeuJwoTt2U9A47V7+d53z2YHQpH
eD/1dShykToH5rCLmZ46j3/eaPasgCzmUvoC/QE5ZzKem5glf9fsegC+z8f9
iVqLX7CRGkM9AYfflt2P1vieQW0Ek+CRWfyRmLVOxj0QekfMMadipngxZnvq
5IK43+0Rv4dH2G/s7Yv9+GZd5Dn3oQdz9tNzcS86EHci7iTcR5gH58VMyAyA
HTMiFtwlsGW5bP131hhZoeeVzcYMcyg2MXP2KObP1nqmaFWsW1p8ZyIeYAw7
l2vP07WeF/A3PRhMkQMn444wV/H62Ui/d8dMQV+el3ENJ0bTxeOhJteaXvH8
da1nH2yk38Mbm7CNu+fLefdReijzHv7Bx/TYLTHnczfsDPziX/yN34lpdca6
4XtiQG3/lnLzYItjSb1HHnT2ks/sp861RK2jFr4X9ZD7bmfOdQUd54ee9LS6
uD+ubvAswhxSFrMA9ZM79GM5602u0FeoyTvoCbXG6l8ynrOIJ98MOrL2P/+1
B5YP1vjbAfPeyibPEMwP3PmG6t17qO0bo0eQ9/QOfDhWZy/m7evjI8wLPpuo
bzlj5ZW8v6HQc6iLG8O3yyRrQa1jj457S3x2bOCMuj0u5mviDo5H1RjL56TX
3jbnAt9XTsQ3likNrsXU0b/lHRvi0ic5G/Pud9yFiDEYuVSTSqwPNa4n7mnd
knN3o+t+rs79ifi9kfP8xOx0TP45mvU9h75Ej6Q30ZOPtbkH07/nxfzYK3tX
NbmWUBPBFPUNX04Of36Y93cr6gF8iR+xo05z96AffF7vbyXLolbRE/Ah/a0j
7Hqn1t93huIOzTcgbB8Ieczz0KYGnXq2JnPlLsgv+rzPjN3oXjJKthY2+wx3
Ds5Tr/g+9NV8zKAN/pbUEd9BmEUu1aJi5zz7uY9e22xdyXfuuOQ8s9XlmY5c
XxTYoXfwLQR+c3VuVdZ59H8x+u54
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3lw1Gcdxt+EkEAOaHb3l+wum2QDtl5hpAOppU6Z0TLai6EUHcChoglS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           "],
           VertexColors->None], 
          PolygonBox[{{8026, 8025, 8024, 5923, 1821}, {5870, 6586, 2248, 6585,
            5869}},
           VertexColors->None]}]}, 
       {RGBColor[0.6027382728454415, 0.5900948780871738, 0.9103859382972065], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmG9s1eUVxx+gtLctt7299NI/3JaWJc6NBMKfLQOGmbpMXygtLINMky06
SOZstUB1Tsi2wjIVcGtfGEUKlRe8QJaZqbBGB92bwcXEgrhFR0vR4R+WMSCg
Tuay7fvp9yx78eT3+537POc5zznf8z3nue33Prj6gakppYEpKU3Tc0tdSrc3
pdST0dBztD6lY2UpbdY4OD2lIc25Re+Den9d7ytrUlqQS+lOPXuqUhqTvF+6
3p/m96Le1+p5r76btFFHNqXx6f7974WUvtGY0p8l/0g6z0p+RfJlxZTu0L6r
yqxjPHSu1veOCst/15bSUY27tW+7nv1a0yd7TsxJaanWPqJ9Vuo5u+h1v2/z
GuZvkr0bNZqnWvfZ0N9dntK+Cp/1F1p7k2wbKvPZ5mv+Uem/p0XzC577SK3l
88qsZyzOhWxByL/UYp/iz381SKf0/lR77NDcOdPtk32yq7rOsrekt046hiV/
VPK5zfJTxvYe1/iC5nxW5fedel9SrfNU++wfz0rpE42s9JfJ9j156zmj32do
rJ/idaVYe7Xcc9nvmOZe19rzmr8n4/lJ9r8gG36g894hH6zUeR+o9trN+l6U
s6+26H1xzrLycsvfknyX9C6YZj8jWxzynTrrew3GxqB0r2lPaeYM2SpZXna/
M8XPj4t+f1ujVTrW6HkxfIEfSuETvo/IzhqteU1zlubsF3zCvtiEndel74bw
54Tmr9fe26VnnnD+RY21kj8n+bqQP9eq+MnWFVq7Ufpuq7FeMA8mXpD+V6Wz
R/a/p5h8KOxd0Ngt7N1faVxfTMYCa8DDm/r9tMZWzVkY2AJXrGcdOdRXZcyC
86XSv1zjx1XG4l01PmO/7Hg4axvAOu8tZfbPlUr7/A+yfafOtS/j338Y878i
DJbm+BvMjk51LD6nuXM1OjX/yxnb0K/5XfLHb+SXDu09ZbZyQ3Pyiuse+WeJ
9vhqmc/XEWcs1TrfOT+xy+n5rvTszzk2nOVZ7dsn7C0JLtlaYT4ZzBu7w4HD
scAt/HC+ynl6WDa8qFGv71t0ln83eP2E/DRTtp7R+/Wsfcr8WTOV+0VjEbs+
iLz7WrXfT2jOTfp9nXRt05rlsvG3NbZzvs53Xfp/Ldue1XkX63u5bNkuHP1c
ftgtG/8o+Z80TgnDzdJxqdG5c1g6luUcR/ShF9mt+t5WYR7l9+Xhk0X6/kmF
cfGp9ry/4Hj9U++fNfi3G2Xn4bxjRgzgC3yFX/cH7kvaY0gxOK7n92TPCq3Z
WmXewe8j0vktnfkdPd9ItoUYYM+EcFHeaJ7FvydneJ+ndL7HtO+BqZadCvlJ
rT+nMaExGs+zGqeS9fMbeUZekVPflz3D0r9Fe+2Wzh3SeVA6n9H7Lo2npHdZ
mZ/PS/543nuz74aCv3kn/4kz/EDMBxr9/bTmPpH32v9ozwV1PjNYJq/AMzWA
PMKH16pcn8DDXq19Umt/pfeJjPmZXCOXwTR45nmi1pjpzbmWrMz6bDtCD/G/
HBgAc2CXfFyteZ0aN2RcI6gf5D71hzlgdUw2v1tvniQ34QPsBMs9gWc4mBoA
D8Mt86P+Em90Et91RdcwOAPeokaADfBfCvu/Lr9Na/H52XOk0fueFraPyheD
snOD/PdKq3mMXCXG6G+ZZhwgh3OIB7G4UfrOtTm38PfW8Hkp7CPHtwXHkRfY
+6Ow+VbZs6/B9pALe2sd60PS2dvuOgZu1wR2iRHxw+dHZPNIs2P1dsxhLvHp
jXpXinjxfqjN3AFvnI58IBdqZUNZi/W2Bn/BXfDE9ojvqqx1EndifrXKWHld
Ph8t/v8b34MfepyRvPFzQfoPFFyThmtcV4gL/LA/eAC94IFeaEPUP+yjRuJX
Yveo9N2jen1Meo5oz1eK5kfsZA62omdT9DlgkXpPfadOs464UCt2RY0mL0cK
zs1OzRmoNhd1yR/dLf6GG3qbzA8F8ertjcY4OfFa4Ap+JKfhgKOKyXfa/Rt5
TV7CGcR9KPAPv86rM8eCk70hp66Qi8QFjlwW/Eld4DycZY3serjdfry50nzc
kbFd8D62bYqehz6BHudawWvB+4cFY/6l2cY6eM5F3PH907L/83Xue+k1yDuw
Tq2lBmPzmHxfX7B8Ycjh7XHJzxa9BtlAzIdX89HjDcmeUovziR6rO2v/U1eH
Wu2DSzXORc5FDuLHk8G3S+IdjuOdPIKbyU10dsY6eiEwRw+/OfxKXwP2X211
/pA7o9Hfk6fEgTw8GrLR4Pb/cT37wiudob+nYM7Flp9VuK5Q6xisZy2983j0
zx/EvQDMgAtwA2Y2Km6XCv4NHOEDMADH4V98e63FvSM5Ae//LWP+2Z53XTkY
eUoOTN4plOsPFtyftGd8D6FXp2/viDnkD31Df/DLqaiP9IbPNLs/3B+9ATn7
V8kebzIe39D7XJ29r9I9wmCrz/MP/f6JxrmM7xbHohc9G/ca9t3U5LsW9yx6
7FVRIybtrzVfkV/wNjGCL8mfeXEfIidWhe8ORr6cF7Y/zfms9N306OC8K+tz
gGfO+1HUKPpi7hv0xsyFI+CHSexUOr7E+/nI62+rT7hLoyXr3F0f+cveYOt0
cEtr1vwyFDZTA6hfnIszguttld7nStH9E7l9PG+fsvfOvGszeif9V2MfrtP+
983xHuAV3eDy/QaSzPGFc8kD8jrJx8Wie1v08OSM+IN8xv7vzvHZOBf8TKyJ
yy+J0Sz3W73y00Ma+fj9cMyhPiHj7sSdYG296/YZzR1vs183BJfjHzhrONai
ZzhwBT9daDZHnQu/43NqNTWS+siexJ618Ep/cDX3CvpE8paxMPKXHL05/PxY
k2v8YNylqN+TNUL2/qXRfqNPWR15gb7OyD34FT5Cz9W4q56PXFsduKU/HWlz
34Ie8gscUjOZB55XNPoeyL0Df5FD9PnoWBX7DsZeyMFIX9iP7HLI4f77Cvbl
QNH3JWooXMedG74bEXbebLaO7sg/8I8OdO2Oe8Zg2ECMuTNxNurRiRr3IfDZ
N2vcK8PZu5qMLf5juLPePSb5czG46EX5YGPB89FRiv6Hu8vLcX+5kvedKh85
Uor7YG+r7xjYtjfk2ACP0PfQV9Bj8E5P8pL2ernN9oHnrrgPcke5XLQeeGBR
3NO5D4IZ5hAn+mFiQd3ALvIFHd2hh/5rccEY53+FQ7Ndv7YEp+BPYt8ZsUYf
/Q86icGW8Dl8AyeDN3R3Rb3riN6YuHMvpMZRz64IJwdmGWvovDvuv0/INw+1
GtNP1rvfZT84YCTq038B/zW2jg==
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3lsVFUUxq9toaUbdOhMmelMOxRkCQECBmSPC0YjiIiGIgQUKErZZVFQ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           "],
           VertexColors->None], PolygonBox[{{6676, 6077, 6076, 6680, 2283}},
           VertexColors->None]}]}, 
       {RGBColor[0.626511028313399, 0.6282910812846147, 0.9109278839007884], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHuQ1WUZx1/O3s9y1j3bnrO3s2d3cabWEsYmuZiLTeU/OmpKsESTICA6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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3lslFUUxZ+l0mlLkWk703ZmOgNoBBdwB1HQRNFERI1EgYIChVaF4gJW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           "],
           VertexColors->None], PolygonBox[{{5584, 4845, 4844, 7889, 1635}},
           VertexColors->None]}]}, 
       {RGBColor[0.6502837837813565, 0.6664872844820557, 0.9114698295043703], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHlwleUVxt+EJJDc3GzkhiRwc0NHsaKCCgZRhKBOVSgOixLbzuBGxYW6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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl2tw1NUZxg8hBMMm0d1sllz2ptMq2ioikIiIgKKoNIxXUNKCglwMVNsU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           "],
           VertexColors->None], PolygonBox[{{5134, 8106, 8105, 8096, 999}},
           VertexColors->None]}]}, 
       {RGBColor[0.6740565392493141, 0.7046834876794967, 0.9120117751079521], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmnlw1dUVx38kkEDykkdeSAgvyXsPyzhgwR0xCUQMkUUJVccVpzWiUARx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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3twleURxl8TILcTIF/OOSYn5xJQM4QiXlBBGDFohCDE8YYiVARDkIuC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           "],
           VertexColors->None], 
          PolygonBox[{{4444, 6015, 1846, 6014, 4443}, {6374, 4362, 4361, 5965,
            1836}},
           VertexColors->None]}]}, 
       {RGBColor[0.6978292947172717, 0.7428796908769378, 0.912553720711534], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXl0VdUVxi8BAhnewEvyEpK8BFSQQYaiqwymCkVW1WDBsQ4UxAllCIIT
qBFtbRVs6yxSlxZBHJm6sFVoFRFcVaAVnBaDitglWBVopa1Vgfb78W1W/zi5
5927zz777LP3t4d0vWTqWS1FSZLcoz9t9eyfSZJ+GqX6fXR5kqzokCRN7ZMk
lU6SYfo9SPMPNR/S3vPflSXJdr1fWZIkbxSSZEOnJPmiXZK8VZEkQ/V7iZiW
6/u7HZOkRvSb2vnZ2iZJntLaRfr2pJ6rRXdecZIMlAwvtTf/HqLpJT57q/Vb
38fo++WS513NH6tPkt9orC81P/hXiXd5NkmuE02J5vMy/j5PPKfWJUmLxi7k
1PoLxGuyzvhiic/AXjs6J8lfO5tXf52xn8a14j1fPJNizx8QbYuel8BTzyka
A8VnkfZ6IuPv74n/5Hj/odZlU0nysubDa5LkkUrtVeQ90Rn7ntyYJKdoZES3
v8TPmeJxWk7n0ZrBol8oPpOC5+iqJPlznX/PakiS2zX2SubZet6o8VPpdLCe
QzS+r/kVtdKbRrV4P9AlSR7q4vONkLynaIwp8nrWna3nZaJdrH0/lx6flBzT
tU9TkeVdpbFMMi/Wu+OkgxM1jhe/DTrXuna+o+qO1sF+6W2H+DSLZoueWzVy
+vamnt+TbB00XyY+B7TPkvam3ZM1Pbx1vYlM6LAOutdbD3elve6g6F8oNr8R
ovmOvlV2tN02684HaH6f5tO09lXZzw/DjrHnxZJzgtZ2E81eyTk057vhXvrE
nhIveV3v5krXO7XuFc3X1FhWbGFPB9tDb/2sC1lXy/b/JJoW6ecj2e2X0svL
4t9BH4s72z7XiXitRjfJ2Ci5honuDNEUNB8a87dF1yTZ8nrepPuZXu59FqYt
X1NiGx8nHqNE06LvvfRusEap9rkrb7tbKzvqy7nF80Id6hvJM0N296b2/4tG
H62/o61187VkvlLn7ykegzRGSZ4JdV5/t2zzVxonit/vdcYNOs9w0S+qsH5Z
v7bYekfn+GvvCvtsTs9udbabAdr/BI2dKd/ByrClaZLtao0HJdvluovLpPyr
daaD5fbXh0UzQ99v0HhUNJ/JRi5v8Hk5N+dHbvR0Tbnffy6aifgAflpufoOC
dmrMebYE/YYOximwhDs/t6vvvVnyPFVl+4c3e8Bzir5P1tit+9mkvQ6J9ku9
35z1bzDjBvnR9Rp9dIZLJfsDmp9R4rucHnc2XOvTYXOv6Jz/1fNQ2P/isC/O
fI7oz5UMx5Z4zr1fKNmaG/y+d9Y+fWKR7eSJtH0T/MW/sVHeLYr392jfuzUu
Fu/nRXNOsXWIH7IvNK36fnPG73qljSVgH3GAOf4Idg8st+/szNs+sA38eknw
ObIGzBwUc9aeJNlPbrA/LdJZvtvVvJZKnrOLLfOr0v1tjf79Bdin54/0rBbN
3naOIxu15z7hz552ji88kYFYtL7geJTXPg/LVj/QPe/R+o/17geiqdH77jnH
ugNhc9jbvox/Mz8U37DnF8Rvbr3XT5ZcBa39RDTXg9/iVRDdbtn4Lo0705Zx
U8g5jtgoOX+pc+1IO/aA/+AS/nBbG/sEc95vjrWc5RjwvqvXrNLalWljHDJ9
qz1fb2OZ3o5z/UdyHiw4jsDvpYinLVqXTfv3+freRTLdoDucJZ8d08m4OEUY
0tLZeL4445g0RzJv1Llb9f5+7TurxPeGzaOrvRnLMVEy/jvn+6mUPqoaHMvr
y60bdFXWYH3x+ycFYyu4epbu+vi8YycxkzXEzd1aUxdredbHvEh8VlQYw5Zl
/e2bxLF9fVvHd2LyZx0cp5dpn+U1xu6vtdeAKusefYG1jyTGXbCM32MlWz/d
V43mV2ivSxuMGVc2GIPADWQb1cb7rtO6qyR3tegPSce3Ske3lFjX2ciZpssu
runi3/21/zTN02nnVzzxkWatGanxa83/ID39sdF84YXe0fnajLGRPY4q9XmJ
g/jjLUGDrWfS9rlJknlCgzEMP8KHRrSxveTDZjjHlpTPgn1xHs6CnfEE2+ul
jxWSp71+b02ZnvzqA93blkrb7EOyk/crzXtbynTQbIk58ZF4/katcWCmZB6b
cs62pMaYC95O0/fptcY88PlI/rhS+/ettEzvi357jWM/uQo5ziI9S+UvB8Wn
XvNLxOPSWudrq/T+9JxxcmSD4wr4Sp64LeQ8ptQ2RJ44O/JA5CGffFjjNO2x
T3a3sc55zun6fWrcF7kP9sv7F4udq3IvPy9yroGf3l7mNdCj9+aY3yy57qk1
/1M1H695peavphzLieOc6eZGn2uzZLhJ8+761i3lJxhCnB4Tew9tsN1j8+Rz
8AOPP9Pau7R2kGjv0PPjCufg48v8bkqRzzo347PNyBpHuXfw4qtiz6cKD/5R
7XyEeILOyOFvkZz319qOswXnrOSr7E8sQYYa6blP2vnlffKD+7v494C0Yxn5
1b16d26VaYhxvbK+D+IoesNnM+E/2PlW7blNY3aJ84yPUsbbszKeY2PEn1T4
WiprOrBuu9a9KFnnlNjWqgK3iTnwI25AT43xUdjy9rBnfKMmMGRcwdjBb3Ce
eulnHV27vBD3cqu+31ZwnCR3oBbCZ/FdfJh4eql8qmcn80SP2A12Au2TQU++
CGZjX9jxY2XODcilqEU4Y3WpdY1/PCh9Dszb/m/Rva+ss7+c0NF0zPGrScU+
03jtf3HBvw/Jjrp2Mm1L1ELg6lfSx6mdvBd5BTaE/cyo8jmXRZ1EDUP9Mln0
kzSOke72aV1DtfPA92t9B+if3Ote0S9o4xi6sYN9HwwF17hrsGZDvL9JcadP
3ucmzs+LWI8/HltmnwRjyH+xAWrcvhoXiP+nyC85x5U5ByYnwoY5B/PD+XA7
4xRrwQZowVzyVvZm31Gy+U4Fn/MoneuigtfgewPCnnMFxznkOVPynl1lXJqV
dc5OvFuvO9mg0avUGMITm8Hn0RkYcp38bmbEYr5hV+DMBMkwMu/fR2vdiqhz
B+jd6Lz1/2M9x+Yd59YHTrGWe+kWGALmrEnZDjtk/Rv86SH7eSdw/hM9+3ax
DxDvoCdfIj8Fs8lLqVGYoz9sc2bY53O6n2drHJuP1TnmKx6c09G6+Dzi9RZh
0t/Ff0Vb9xKGRT/hjYjt3BEY9FXkhtSw1K/kBuQtz2X8e1zkv+Tb62VfF3W2
P5bqjnbVuA6kZro76qYK7VNZsN2QuxMP2LN7Z8uKnPg/8RFsQb5lxd6HWIze
D8uXd7zB18jZWAc9NeFvi21r6P+oI/Qpz7kLYvLa8MFTxOfORt8lY3Wcv0nY
fmKD8YMaa1vBdRa1RJ+oISaGr3Gnj2ddn1CbLIw6ABpy232RvzHI5bjrDyod
y4nj4Au88NMbstY7Oq8PHtQprIMPNlAX79A58lETHYzn5phjL3uDfn7UTV9G
LU1dVIjaekzsA84RQ5GFnHZinIs7Jg/j3vEPzgvNWPnCexVev1nzVt13kWjO
rHJMIh6BL+Sq4Dw9BPoHYMJw+fQ7Fa5Ftuo5oqvrJGzq2Yz3+6d0uD/t2vkk
cvPIRUuKXMud38Z5CXzpabRIrilZn+2gxnLND2Q8yF/Ju3gPFoAD5FP4G75G
X6qs3r2pvtGj4yzUdH1jjtzMm+Iu8FvuEZuGJ/GMfZYHf+xxVdQRYDrYj8/i
v4+Gn+biLGJ3uJ4h9nCf5APYwVVtnCvCB9tujvfYBrUxfS5qFnIDYgNxYXr5
/2t38gbi6brA5P5xFnzkyvBx7qRfYDW9RmycOumMsAVscnzgI9hIXl/d4Ny+
JWp9alvOvSx0zt1wrkNh/99GfYd9DQk+1L70X6iH0SU6XRP2NTFsjP4IezdF
zQo+YbMHcs5BkQlsJF8nV6dGnBa1D73PgdH/BAeJG+Ae2IJOiDXgzt2hN2LF
JZHHokNkGxJ9Aub4G7lMKvIT8iTyJeJ+n+h7Ton4Bs+B0WvAz+hBkAtcU2s7
IF8g5zqcU0fuwHvqBvIg8lbi4z3RQyDvZi+wjmfvmINTqyMnJKfrHfnbzgrn
nXzjN/zJsekrDIs+w5qIK+RE9C9nNXofYhH3wXewf3TgP3ni0hrLPSJv3AQv
0T18wJk54vFphbGWfkP/Bt9Bc9gsNRF96JdDZmqiL9N+T3+UWhi8ub7KPSb0
D+ZgC69HDw2cwN6wk8mBUcSIcdFfmxT1AbH47QpjDThD7IUXNsN+6Jp8j3VL
w67Ig470OcCkbRXeb2dgGbkocfKkvG2Rvs6KkKdVZ7+x0fugsz1RB4JH4BI2
cFP0fDgXdJMjT6OXc3P4wqYa93Dpw4KpI3P2WXLEmqgTybfJtYiR5+ruBuXs
x/BoDf70ntm7Pnpf4CY4A+1bQY9c4GaKOEMtWOs4z51wZ+gJPi2Bq/hNKvCE
PKIlck/wD2wFA+kTLAsMxFaxKexvQdYxkpqP/t9D0fsF68F8bKGn9HdthXtC
9LynRJ9kdLV7puABdRO14rzAN3AUX6ZH9XHe94f88KSvQgzh95zAz5GBq+tE
vyPn+AIN76FDV+AyvcKnxeOZjPs89Jt3ZW270PONtcfpfbdO7m3QO6mLvsrT
sQ4a9Ice0TP8ng7Z/qa1n2n8InrP5A3Ee/zgmaChr3xBwff9moy0qrNxhtxt
R9b2h27npB33iQ/NcUb6GfCmlwQOzI48GTxuChz+V859perAH7AHvwDHsfnW
qKF5T61Ej78lelzUrtSw2Am9nMvytlF6sbNyriM594g4+6pG1zzYMvc9N+6R
HOKUsNV82Pgj0dOAbl5gKXdCS5P87vmIYdQz9Obwt9niv67KGLM8bJK7wK5n
xf9x5oQemgKr4TEo7IScA71xrhGhh01a+1rO8eVezVtz7i/0DOwgzvJ/Bv7H
cEbkqksDj0bGXRyxR56cBxnuivuaG30Pzkh+Qc5BjkH/aW3kb5vDd6DHvnZH
T6wQekEn+B7nbY2c7bnIo3guDlti3wXhg9jmHWGfz0Y+Pydsb3Hk9tSI2AV2
QD1Kvw9/B3dWRk6CLe8P/4IOu0E2zrEwzoL9zY/8c1H0z8E05OBc2OTjkTsf
mS+I89KveTj6JNj2jMiP5wZmcE/0KckROQ//d6E/817kDePDzp+JXivnJn6D
oZxjb6X/t0r/hV7XebXOK/E3aMAWegz0GnpE3nkoYvqW6E9w3ucb3fOlfzMk
/o8LPbXQh9E/6RY1J3UJ/cKromcIDd8Hh83sDzs8GPkrd4rfvRS9bPZcEPsS
J8gZ0dU06aGszmc+/L/Z6KeRT7GOXG5N9Dp7xP9nd0T/hPPPCNyg3l4U/28l
f+Wu6Vv8D68zGu0=
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3lslOUWxl8o0DJd6Hwz0xnazkyrgIqWIJogtIpBSUBQQRGjIiiLqGBr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           "],
           VertexColors->None], PolygonBox[{{5387, 6517, 2195, 6525, 5386}},
           VertexColors->None]}]}, 
       {RGBColor[0.7216020501852292, 0.7810758940743787, 0.9130956663151159], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHuMVdUVxjczMDPMnTtzh5m53DuPO0MDjiMICGpLoAqDUjRlQA1iUSgP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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJw1l3lslFUUxR9tpWMXoDPTYVo630wJqyIgIGqQfRFXcEERraLRYJTFoiC2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           "],
           VertexColors->None], PolygonBox[{{5030, 6253, 1990, 6257, 5029}},
           VertexColors->None]}]}, 
       {RGBColor[0.7453748056531867, 0.8192720972718196, 0.9136376119186977], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHts1eUZx19OWe+c/tqec9qeXmjF1s05K4niZeJ0LptC1MmGUimwzPGH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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3ds1GUYx19oaa/0Wq699to72rurEpaMfzAChiUOhoBgChSKIGCi7Fhq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           "],
           VertexColors->None], PolygonBox[{{5763, 5009, 1866, 6066, 5762}},
           VertexColors->None]}]}, 
       {RGBColor[0.7684833141727466, 0.8489495908361777, 0.9114091684950592], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl31sleUZxp8WTlva0/actuf04/S0p9PEzOkSY6Kg4pKpWdGpGTgQ2spo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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl2mM1FUWxR/Q1UU3XU1XL0VXVVdXtZIgiEP8IKCCKyCNwQWJgjQIDTri
AokYAWWxF7pZ3ZJxjIISRTGuH3RMxgZEXJiZzJKwM92RFkSdMWoQTMANf4fz
/3BS9//efffdd9+9591qaF44ZUHfEMIXoAiU1odQDhKgBFxcGcJjhRCGlIfQ
pwQFxmKgCJzNhTA2HcIYML9/CPeAzqoQqvMhVIEO5HgmhEmgERSDrxjbkQ0h
XxpCAxiFjZFgP06Mwf6XzG9nfkY8hI/6hbCrGt9Ydwx8KLkihAODQmhiftqA
EA6z90/onwGHkEcz93IyhPeZG4rOZGxnGW/Et/kD7Pt77PGXKp/hGOu2cMbu
4hAux5/JjDXxPb0shNvAFNbfDL7Fl7vQGYv9T/Dj73HbX8g5C+jnwQLkCxpC
GI+v48AQ5EYwE/37CW7TQM6HL+V1xBccR54OpoE2/GsHZ5H7sbYv+A15X9pn
1Nn2gqNp29Daz8G77PsmujOI3XywiXMl+a4AG5FXcL4y5AFgOXIX+odqfJZF
6P/I2KnaEE6CU1mfZQS6f8j4TDcQjxvrHYsY17+EPZeBR8Bi0IleR8Z3NxZk
GKsFE/s75jqLfJIvOlMp5y5hvj8oqfNdXE2MrmrwnSQYfywVwgZQhnwGv1Yi
rwCnkTcnfceK/Vrst5Kbw7EzEeey5Og81jyPziYwV/7h+3qwDnTUOxZLOOfi
rGPyT2y9jm4L8ZiKzTR3XQvmko/LsTmGWN2IXuBsSfJnGHIrdlrAUOQke4/n
fsdxv9PJn6WsvYnvxxP4iv49iiv2T4L5yLOY28JZvmO/xaWuHY1JVg2tRU5H
8dvI2Oo629DaTuRu/D0EZuLrHWAS+u3EoJ6zr+F7JHqXgFX4v5092tnrKeL6
JGiTDN5EfkNjyF38vgq2gverXEvnciKqqf3sleFMF3OW27E/m3PPIS/uIx/u
BXuY/4yaXEaspjE/EZuNoIXvawlbwMZazlNB/WwkhjvY4wH8243uLXHX9g7O
sL3aNa7aOJcjUY1MZ7872G8ee80F+9hvLxgcvOdt6EyI4v8M8RrB99mM93qo
1HfTh/1mFFnnFL59WWN/yth/b8ocI27Zg7yZuVHgM+a+xX4l+z9IXS8CSeRu
9C4k3sPAf5F/zpkTxYU/gV+TrlHV5i/I1+Wto7kJyE/z+xrj24hnFziLvy0F
527lAOfKvqjWlTMfg2Up89NmcuKJnDlI+S+OOzjInCouFSd+w/z/QRLfh8XN
BeIA1b44QbXxH+z9O+UaEXe8Q3zvLjGHvIStndj8ALwoLmbubxlzizh6dcoc
JW7qTDl3FhLfBbXOIeWadDSnnGunrrux8QtrW8mTDZz3H8RtV5Fr9iv2mZpy
rt4bNxeKo8RN4kTFSjWq2lTMTujuwOG4a1Zc1KP4pMxJ8kVnkO/yqTflO9Nd
HUFeRRyu4R6uBu1Zc30T9h6JmfMVa/kkXxTzu9n/4Zxr+ShXPbvSOalcvLPM
XKWaejLiLOVqN3u/188524UPh7HfjP3T2ByL/FdsrsF2o/ILn6/J+S1bGTPX
KCeUC+Ic5eoi9E8E56y4UDXdFnGi3q6TKeey/J2p9wuQUuGP7H89c5PAlOCa
FBcuB8siThyN4khwhvv4OmFu64y4siXSVcwUK60Zgq1/caYYd/Mc+21l7K3o
/dlEDubERQXntu74ceQNYF7MPURzpTlE3HE/yGHvWewdwf9nih2bUQX7ohj1
VJhjxC26o8uIx4hK647n+1F0VxQsZ7A/m/ndfN+J3BozF/cMMleKk7fU+Azy
/TTzU5jPE++2mDmih7s7wfoXyv0GvK2+hRzuKfcZR7O+t2BuGBdz7C4D/0s4
huIK9QQLIs7YyNzz4FLWr0B/f8o1oVpQT9CLbxWKV8J3JC5rqjP3i6+W5s1B
4p4lyD1p9xTqJVTjB/G3lfHhCXNinNh0iP9BMXJfMBj980Ef5GzOb5zeNnH6
tox7JPVG4oB2bLWBeX1tM523Tdmqzbt2xGkTohrSW1Ia9Yp6UwYyVg9yoDzv
XrCZ8TlV7gk1J5u1kY7eqtUZ9w56s1TLqtkjUU0fJB6PqgcAB5CvJ/5ba/3W
qabWkZfrs+6dhvQxd68sOBfE4TuZ+yDrt0g9p3pbxVSxVI/7Uso9rnpbvckH
+L4i7V5WNXcptn5g396Y71jc8wo63xebgybz/UTBuaQc19u9Bv3nSv2Gz+Au
1/G9LeGx5cqFGueObOqudEe6G92Z3sp1aXO96n0bvh+vci+sNz+ZNmeIK3RH
F3GvF7J2GBgeyU+z5k9Zj6nXiUe9t3oe9a5XDvLboB5WsdWbpbdKMd7N3F1p
91Y7ilyberP1VqtG3611jam2VDPigkU15jZxQi95fXu9uVEcNEvvd725CPfC
Meab61375wXnxsAoV5Qjc5g7WmFd9Rh6O36rc++lN0S9YlfUq6hnVO+qHvF0
1MOqt1QPWRb1mKtwoq1grlWP9CnyJwVz+Vy+l+L7xwXL4gz1vurxhkY98HFs
fpH1fwP9B7gVXzqr3Wv8udS97nXV7v103y+n3IOo91COiEt0Zp1VnNIfn+MN
zlVxit5i9SB7ojdZuTKzzlyqnOmo9p7aSxxRXuMeXL13osa9iGpEtaGeRP89
lBPKBf0H0Vuunli9sN70TQX3dOrlxEniBtmULXGEejH1nOo11ZPpv5v+05z7
L4P8Autn1ZjL9B/toShnlCvq6X4Hm+v4xQ==
           "],
           VertexColors->None], PolygonBox[{{7062, 7066, 1688, 4655, 7061}},
           VertexColors->None]}]}, 
       {RGBColor[0.7898328620652612, 0.8560690961794822, 0.9018445901712391], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHuQ12UVxt+9//byW/Z+Y3dZImuyAiJjGcoIQ4nk0hiMY1yErXQphQXE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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJw1l3lsVWUaxr8u0tvaxXtvub1t7720uIwCMogREXVQFBhlRhMjMcoi1H2j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           "],
           VertexColors->None], 
          PolygonBox[{{5070, 7699, 7698, 8057, 3363}, {7570, 7564, 1217, 7568,
            7569}},
           VertexColors->None]}]}, 
       {RGBColor[0.8111824099577757, 0.8631886015227868, 0.8922800118474191], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHts1eUZx99D29PT0+s5hdL2tOXg3KySJVRQo9km6vBCmbv8ISA6gW1g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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3ls1GUext+B0k4LA52ZWuZgpi14cMiKUNdANob1AIGq8dg/cL3AxSWx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           "],
           VertexColors->None], 
          PolygonBox[{{7301, 6252, 6251, 7305, 2740}, {4767, 5998, 1845, 5997,
            4766}},
           VertexColors->None]}]}, 
       {RGBColor[0.8325319578502902, 0.8703081068660914, 0.882715433523599], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1mHtslXcZx3+90svpac/phZ4eDj11hU2cjraMyVSGJkzAMeZClRadG5GZ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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmlsVFUUx28ZoJ0pTjvT0um850xnpAoWgRYKhIJGTZSCRQiJrApIBFGw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           "],
           VertexColors->None], 
          PolygonBox[{{5024, 7041, 7040, 6675, 888}, {5267, 6960, 2496, 7282, 
           5266}},
           VertexColors->None]}]}, 
       {RGBColor[0.8538815057428046, 0.8774276122093959, 0.873150855199779], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1l2mMVFUQhe8wPdDd9AxOz0L39MybaaOJAioa/AFjYjQRl0FFTFwAjdGA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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlntsVFUQxqctpdvtA7vdbru77XaLYORhAcXEFsQQE8SIsUACyitGIxQK
tClNFBHlUd+mFdtCETUgJi1ipIYiNBo1SC0IRhMjmhiCFE2IKI9qxAcBf19m
/5jcOfecO/PNd+Z851Y8Uj9ndbqZdWLDsMMFZp+Wmf2SY9aUZnYiYtbKu/XD
za5jrzPewnhTwOwc42NRswnFZpXYUfz3E2b7sPdyzZYQr4NYrVgL1o7dwtxl
nun5ZpNY00S8XSGzndga/P3EiZSAJ8vsPqyZmD2s/xY828lZVGE2QP4NYLtC
jCdZe5xvvsTW4rfzXFRothBrw382ZtZIznXkys32XA28ry/2nPuwFr77jlyD
1HMWDJXkXEiuAO8O8O2HqonvXyDnilKzjUVmq8jdFTSbSpw94OnGpuBf4tt6
cp8m14/EOM/avVgw4Bymg3922GweZH9DjBzyzWf9PCyI/wrxX8ZezCAv8dtZ
OyluNhFrwx/DujfIMx1sN2c59/WsX13qezCN+bXEeQK7s9Bji2NxqxwNqTWa
EweXwVtA3Kqg4/0IvvqwGP5SaniAuJuZf435LUHnfoD9+D3H92Am3NyL1cDP
M4xXEvf2YscmjJ1820SMNdi2VC16J181HeNZmjSLY0fDXotqVq2qqZZ4j7Lu
abhbBCcjwLaR8RDYGjN8r8WhuNOetxR4z6pXn8L+Js4sOF86gjk4v3qDWTk1
z6K+VfTnSGKN4LuxGZ7jP9bfDZahPK+xEL+Teu6ils/yvJeFWVjV0x9Qe0/C
e0M934u/H/vZvGcO4fclnMs95NwM/oaQ93JVtvdmM++a071Hi8lXkvS9v0rM
UdTyJhgzGL8Exr34X4P3LfyPwRsK+x5q76pZcweYpmKzwR5i/l/me+FxMfPD
MuGKXj9I/Pn0Xis1lTF3utzsVWp7jO+PgOXzmJ/dBvD1gfVwzP3GbO+NQ9jD
5j3SDZ4ubAx4tmX4Xt4IvpGFvqeKXUOOtqDnyOd9BevjAf9GWjCEhXJdE/4B
b2uJY83ALjF3EYvjt4D3Av44OJvI+jTWB0Jek2pRDO3dVWKcCvoeTmH9c5y/
a1nOSQXj9Yx7M72nm/D7kn7Wd/EuGXHOxbXOYBfcdke9NvXI29KriPdOC+sX
kKuI/DPwa+mve8A2I+HaqTMxSP1nyp3bpUHXio6UFkozpG39MedWGjeRXp3J
+Br8pLN+GvUtiLl2TSbeOca/FnlvH891LToB/rp816R+evULaRJYRoNhLFiq
+GZupnO2m7XLihx7PzZKXIa8164HXJuCJc61NGo7e1UZcizqwUWMF8Y99g/Z
zu3z2ECmc/x90nMo9uP5jm0D8yvzHeMh9XbSuVYP7oCDk0lfqxgX4TqXfANp
riHS5h7GZ4e7RqsX5iR979UTqm18wu8S1Xig1HtIvaMe+IN4k1N6dIr6OhmH
4fivfO/f/qjfYbq7jmB1Ba7R0madYfWy7hTdJerpT8p8D8S97sj72ZsgdiHb
96w25jkUO8673/DPR127dGalhTcRZ3Sha2Jz2DVW2qozsoK174BhN7Ycvxos
BxOuHePRsDNwf1ux8yPN3kovbmXduwHnSHfP3Ihrg+6gPLAOpfRB34wD//gy
32v1rLTxSti1Wxqpu315qd9tuuOry1xTpCU1Oa6F6kn1ojRRd9uOiP8L6I7b
Sf7eYr+7pdG3sn+bwq69OnMPgf9BrAS9O8l8HbnCSddW9exX+NNL/CypZ/Qv
UFWWyk3MdXG/A6T94lx3XX9q73TniTvdybqLxaG4qapw7sSR9n5b1P8d1APi
8s+o94b4mYCfKPWzKs3Uv4X2RHuhfwz9G3RE/F9B/wiLwbMk7mdBNZVz1pPl
Xps08ifwL4t5L0jzElG/A6T9uoMqGA/GXbt1B/wPwjBV4w==
           "],
           VertexColors->None], 
          PolygonBox[{{4902, 6045, 1857, 6044, 4901}, {5053, 6266, 6265, 6261,
            905}},
           VertexColors->None]}]}, 
       {RGBColor[0.8752310536353193, 0.8845471175527004, 0.8635862768759589], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlltslFUUhQ+0helc2k47Qzudv+20JSZGEg2EBBMTMdRWxERp8aU+qJgI
YhTfSIwm3p7AgIAGg4kxAWmx+oARSo1aYxBUrtEIAkbQByxFEY0XFKiuz3Ue
/vznP7P3PmuvvfY+07l8df/j00MI5/RU6ampCeHldAgj00IotoQwWAhhy8wQ
lshouDqE2do/ltferBDWar1R662zvN9ZDqGuKYTdtSHcJt/DlRDelW+/no/l
O182n+ZC+Cx+P6fYc2U3pO+nFL9vRgi9eh+U363a79Z6Q1sIr+gZyxgH8cBx
bxLC0sRYB2Q/UxjmK4Ee2Z2VzcUan8N7XPbbZbNDT0+dYgrzIdl3Cc8cva80
htAq3/cU7x9hOqWY4zrzE9mdU7xu7e8ohbAnFcJJxbtU7dy/kc0JPf9m/L69
4vUGYf9bcY7r/Ls6Q7is9XT5Jfr9c63353z++rwxPCDe3heGr5Tv3mIIHeJw
nvAcUMwDsjmddk7kv1n2fzYIS9F87asXp/XmakW9+aCGfxV8Nuc+qnhvNIew
MPLM3luKc6fOWD7DewuE+9dq7/+hc3/XU8iaiy+U96B+GxLOYT0Z7U1lfDb4
CxEHGB7S7yt13ne1xtPUYPw7lcctzdYA9fugxpq5nHG89VqPpswx62HxPVTy
3pZYc3JvEYfNFevoGXFwqOJY6Il6U2vyQ1PksqjOe/ie6QihLXH9CuLmVcUf
SVk7LzVbP9QM/tA/tYRbcn1T5/wsmyPTfNZ41DOcleJZzwrPqsR4FreHcIee
fnE4pfc1PRNZ6wefDdXW5tlY06sZn825aGd34u/ntb47sf1rwjmiM5rE99t6
J/ouat2u328suUaPJO5JuF3YYjts4H573pjn6nuenkmt21Sv1+W7K+U6sk/8
AWFNas0PfTYQe21jzrbonxlwNO819ccfPdD/u2XTN90+6ID+yqZdT+q7RN+H
tH4n6qcY8QymjY81OFiTC30Pr+hgj7B8mXcc+rIzsW7AXoi+YES38LmiVTy3
GM+WkmtPXmj0RMp9hyaoDTyvFSdp9eP+aY45N3JyQb4/6TmZcg2xJ3c0To7o
Jiu/X2RzSjZz1EM3tHkm7dTetpJ5+U3vnOy+TTkfZisamNT+RMmYwAf/8FaI
58PthPw+UsxclfsmG3sHH3CBuVf4+/Qci3UYrXXuqxT7YLPnMXztqXXu/eIv
KZurM2nXhTlMb6FpeEfjxGNmbJf9Nj1HZNugXu8u+wxmxrKK50ZPxXOcmUAv
PlznHsk0ml9wDkg/q+V/v2LW691VNibOv5axNjblrDnqQ870IjxsVR7XdXim
0ePMdXpzkc68Uog9LOwXYr/Qr4uiDbO2K3Hu9Pe+2OPM3aGKZy/c0wPwdlrn
LFbM+9LGsznnXvte+z90+Bt+4IYcz8tvadYa35sxH8wW6lOfdu5HddZI2d/M
BeYw/r2aE33t9icnMINnsujaw8FwxfcZvzPDVrZaL3B5qWQ+icVcBw/3BHWl
po/J78fEPQKncIuG12Q9N/EBS1+8F5jdxEaHlcS9h97QO7+xzx1JrmB7Wjg7
pYObM9baky3WG/24MfKGFrhvwMYbW/qOGhCDusMbNaNe+G2KvuzxG3MMXllj
MyFcjYnnB725IMaknx4suz/uSXwHkDf/J/6PU+U7ttjpfJjX5A1X/D4Wz6JH
qQN9+oR4rptlnrkjpqJWORuNYMvs2RXvTbihnsS8WrBG0SfcfNhkfuglNAR2
5v0LBeMnDncDvcmcPtzmuMwOtA8G+oA7nu918n1Rz6jifS3b423uJWYFdy3z
gHss32je6DXwgY378/qs7yVqej5qGO03Jc6tGGdsd+QDfcIJ/6GWJdbDTVrP
bncs+FwTOaXX4AtfZio8Mdup+ZJY9/F4LxKzq9F6RatwRE7cvfgORp75LzUW
67hOfF7MO85/+IuI4g==
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlX9o1WUUxs/m9M67Tb337u6H93vX3SZFJGjGogjSwLkykNqMworKoFQy
FylRFkT1l4aD2jANo3K6xeiPom0FZT/AlZY/+mWlUas/StPEgkrKZZ+nZ38c
7vt93/Oe5znnfc65zSvXdd5fHhEbsQqssy6iC7tjSsRYWcSZxojfsW8rvbew
IWIRlp8W0crFdDbiF86/qrT/lgzf+YgafFv4foRYY5zvxR5mfb4pYgl2Y3XE
CWyA/V3YCPdHsUuKEVdxfzwVsbgqIilEFLHXOBsi3gxiVGWNJT4TxOoAcyV8
jhPvFHfvxv+76RGfwy/Bv0Ucy8y5JYF3Yjydr5odsZQYXdwdYu9a1muxh/ju
xNpZX9fk9RL8B0oRg9jiGRGXTfHde4nRUe4Y6Rx+4B8Gv5Ec9tVG9JDTW+Qy
VgN/zvvJdxis4enG+guf8qnGbOfuv03OZSnxW/FPSr7bxvfPcD+OrUg7p9s5
r1ZNsNtYb+DsIn4vxNaz3g/W/PqIedg+1p/C5ZVJ/LNwmgPWMvifBv9iMFvB
X5Z1PqPwW06Mm7Be8GaDfwAuj1Pjt/F/PWXsW8C6OWcOWXyPXRBxa9ocH8W3
BOYVYN1DzV6Ax1p878N2sM7hP4rP9eW+cwJuJ7FvKq2pcbTWXHCtxKke/I3s
fQT2XmryQcaakpZ+AqMG7tuIuyhlzXYTv4/69mLrWD/A2UKwr8a6WW9ir6Hk
WO/RABnu/wHfWuIdLDO3N/N+a3E8wtlm8F/lbKLKXOZnXTtx6ij4DfV20oC0
nMdna8qaVi0eY+/KKtdEtbgcHm31rsnTiTmJyyj16GLdmVj7eoOOJmtSWlQP
reFsNTanzG/yInG6c+4N1WBbrTUhLTzH+sHmiA/hcIxYuVkRd8H1zoJ7QfXe
TS12lZy7NN5ScE/pfIR8dvA2/cQ6yP3f4PjPZEzFmgr+x2APNrqXq9OutWaA
el81b1fvlDw7zpN/P++3Bv9OuLaB+VnGGpU2t/B9EuyejGdJjv6dAO99/D8h
/vdp9/6fYHdM8wxYlbOGlItmgHptgByq0tb8oYxzEPdNxJzH+g3yOSq9stcM
9pPq2Qq/0ctZa0ZaeYl1nly3NnpWqIbLyaWr5N6UZqS1BeBdWrDmisQepx+e
QV9nKsz9y6K1oxw0+2bmXFvNpD2cvVuc1DIxT3F+iPOZaffEO6w3J9aGanYW
jCewgZRnyGny+7ro2kqjT3F2Q2Js5fQr8bZP9sfRSvdKddZr7an3VzMPksl+
0+zWDNk3OcO3847P1/ktpLkFDe5x9bY49NV7JmkW9dZ7NmzAf32dZ4TWqqlq
qT3NnrlFz3rNoD1gfMH3Ob73V7p2P2DP1riGOzmflfNs0nuuIL9rGjyL1GND
Bf+H6f9BNRvJWzP/awXOfZp/GWtNM1m5zq3zbFPOmpWaGZoVmpmDBWtaWpaG
mtkvJdam3usA8Q5nrCX9R/1d6xzEXZoaxvdcrXvjSMraUE+qF6UR5drT4DPl
/CO5NiXWonLemfg/Rf8l6jnNds1QzU7N+P8AgQkdgA==
           "],
           VertexColors->None], 
          PolygonBox[{{5942, 6637, 2266, 6639, 5941}, {6032, 6037, 6036, 4899,
            821}},
           VertexColors->None]}]}, 
       {RGBColor[0.8965806015278338, 0.8916666228960051, 0.8540216985521388], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlU9slFUUxe/QMjOdr63MlJl26Ddl2lIW/gmJCzaYYIzQmhgXgHFhSJGF
0MYAXbgxMS7caCS2MVbtwqRRyp+ddaGkG3XjhpgiiaRWqVEwKhpjJOhGjOeX
84iLl/fmfu/de+49594ZPnrywIlNEXFBq0PrgXrEzuGI3ZsjhrVmShH/6ENW
jljW+Uyn7jYjvmxFXJTtT/0u6d6k3m7K/O6EzrNFv3+zEPFCI2JvX8Tj8rMi
W1lrtOC7p5L/r+Tvs6Z91bsdl/drsv9elUPZ3i4aBxiezSOOay1VIl4biLiq
e1dK9s0OrqzXb3bJ9qP2bbKPKdbUtognahGLso1sVxyt2/L/etEYwRxbtDK/
fUz2iU7ntdAT8Y7WJeF4Wbg2hiLmOo0DXOQF1rtYNmQ/rlXUeYfijCnuS4qx
pvd/d/ncVh7Due/x/eig7cSalm2y03ffKNo+pVqOytfhDsck9rj2z5uuNTmw
1orOBb/TCQO2PSXbpxM2/MMl3+/Tu9WKsVNDYj5Sciw4v1L13Vk4LLkmpcxc
weN6eocelpTTudz+rqlO3cK9U3duy0+1Zp5PybbY7xi/av+t35pYVr7zFdf2
qXvMAznC2+iguUMvd7ZaM5uV93P95rCceSfHD8rmHt4LmTUK5qzPmMBDTcmT
HMkbvPA4olh5wxrqyPweDGDBRu3RRSH5pC4bqc58W0k6n5IOb/X4N3WiXmDr
ynymbhdy14vYmeL2NoyJ7+V0/+tu5w1H+1SDca1V1ektvamVXCt8zaYePCN/
7zZdg/26W+lzHU73WNtgp9ZdCcNf0vx41dzNaX+lZfwndX5R56XMnNMP+P+l
aBv6+Vhzoy/3N+p9K3NtD8h2MDeXhxV/Xhw9JB/7e+0LrOvS8s3cNf5DfJ7P
raHLivtFy77O5sYEHjj/qG7epyrGAYafdeen3Lnd33CfL6a+v5E0MKP479Xc
B5fl+/SANbva8m/O3F1PM42Zt5L4BPtcwk//opunO9xPs0lv9OV0n7VEvd/P
HXcL56a5Y9aAmbdou5C4oJbMFnKBV3CAgfjoB21+Kh+fND1/vlGsWm4+j2mf
2Gp9kt/zDeeID3yB4d8h64bf1IgZN5H6izO6ZiZcSrMALAsJz3zdNaIue5TL
g/2eMTOJQ/SD1lar1turLc9oZhP/JztqnvcH2xGHtDrE/6Pa97WdGzUAB/jB
xuy+i2chzdsjwv6M1rfC/4Ny+X7IPdGSLR/0zNiVuMIPnBCHnltSnLPE0+/r
endDa11vHxb/ewfM8+6UB9ouNjxTmCPkyDvyPC8f59rWLzXCB5wy70tp9o0q
75H8f22CF67BR4/SF8dUw8lB278Tlg9r7ptl7dfa5o2euLfuvgAfcwQt0KN3
hqyNJ3XnUO4ZMLbd/w1o76a4qNSsU7iltnB9se5epU//A4lPB+E=
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlEtolWcQhkdzOUnOMZpzcm3+k5wkGq233tAuFFKKUQPdeCkURGKFEm2N
JgvdlS7c9CKNFFKvqGASE3BhXIh0064bSkSwtWmrrVo01UhpbLsQxeflzWL4
v++fmXfmm3lnWnYf2Lp/fkR8gBQjT7MRK2sjzpVGZFMRzzkfroo4Wuz7wrqI
cWzuoX+J+1AhYhTZWBkxUBLRkYvox+Ym+neKItY0RHyHTJRFHF8Q8VMeHRKZ
iDLsm7G/WhPRhX0beK9wnkkiUumIcmQC7A3ILL57iTED9jD3Ts792K/GvpQc
v8S/TPbEeg2bV5HvOY+CNYZMVkT8wxueEPtfpIb4LcQ/je8B3jeM7zQYB7m/
R07rUn5Dd2NEazM+2O/gPZXo+9C/jf4r9D+AdYY47ehmwfiG2uzC59dy450l
j/3Y9yJnOF8glxGkbZ5z6qj3G/W2cTA3V0dMEa8IrE3k+yY+j8GfQdZyvsJ7
/1tEXpQwRf4Z8tkJ9np8B4h3Cpul+LcjJznfJ1Yv+GnwA8zl+E/zb17aMfZh
sy7nXqmGKfC2YV9UabwP0S0G6xP0O5FD+C7j31LkYGKsl8GcnzbmYt7/EMw+
8llb4l6qR+qNeprB73ZTxJ+lrpl8V9XYVhiqld6st6pmF9G9Ve/apOHQSMGc
E9fEgdbENVet91LPPdx7EtdumHtV1pwRV9TzZ8R+jkyWu4Z/cF4xx/efM+5l
nv6Nlzu/x3DjC+JfT5mzSa1zUi7H8LmFfzpnW81IP7G/poeDSB/n39HfaTL2
Cmx+hC838u6dMK9gU0D2kOstZIT4bYnf0l1srDfI5/VGYx4hl7+rzeWpEnNd
MRVLnN/C913lUOF8rlc5hrCvkvOnxP4s79qIgzl0XeBtLvYMnqx2j9XbE5y/
FffAKC3xDFdQz8/J5X/qc5P79sQ7Q7tBMSexPVbr/l5C39LsGVN/NEPyTWc9
O8JQ7F+wObLAOZwHbyix7xLqtb3gmdWsipNH68xRcVOc7yx4p2iXaEdsAn9j
o33V45bENVUtVeN7Te6JejGV8axn5vA081nsHySeFeV0oeAdpd2kHXeO+B/l
PAvaAZoFzbhmWzOhWt1tMrZq9hv+gzXulXbmeXIZa3AvlMP75PqgwbtFOyPh
vpX4gxXmoGa3NWuuaYZl+1eDay8fcVc7WvUXh7cl5oB6L4yP897B2r3acdol
2hHaDdopu4nXkzOWZly9u1blXaYeXs5652vX6y4uiiPihjj5qM47W7taM9/G
v0U5v035vABCId47
           "],
           VertexColors->None], 
          PolygonBox[{{7975, 7973, 861, 4971, 7974}, {5938, 6603, 6602, 6598, 
           844}},
           VertexColors->None]}]}, 
       {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
        GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVD1PVFEQnRXYD/bBhl18SHZZxKCoRAF9QGEirbU/QBMajSEQGzuNiY1G
KbVQEytRI41QmoC1NhqDGonfNsvbVRLiuloYz8mZDcXk3Xfv3JkzZ87cgem5
k7M7zOwSrAUWt5ltwOKEWS1n9jsw24f16xTWWbP5hPYavr8Jqwfb/tWc/nn+
F3aqRXsRvj/h8xSxt1qxl1Ae3ufdlQ6zpez2OfMx10LJ7AHsZbtiDaWU908g
HLw/kTQbTypeFTYGu48Yw6HZl7JZN3zW4Psm0Ho6DTzwX8T6M86/w97hLEwK
BzHUgeWX17uA3Ksdinlop9kB2Ch8sgWzj2XFvYm9D7vNLneKp7rfZYw1z0u8
dcd8F9gG+s0q4PxtIJ/naESjU3e5Jg7WTT42u81u7BIvxM4aeDcDbtM5cbue
AYaM4p8BZ2dLwk4++CX+hveEHO5F/qF+9YncrTfvoq7pomK9aldOYqh1gYde
8fa1LO7IG/GybmJOe/+Jh/ushxy8wL0jPWaDiHUH3x+9wrEH+U8XlZscNDzO
OM4v9qlO3olS0tAxYJvp0T/jEgt5pi4et6ouYiAv7NF++F8o6fxbWTUsumbp
F3tfao6bMSLnh7rlPtdT4Px4UtzTr+qcc4/cEEPkWqf/JDDOFlTjCLRRxf9k
mzS+4lq6jZ4eLSrnNdR6tU/n1CF7zxk5D+xjzlvMb155mYvxuM5hfykv3irw
P+j6XM5KP4zF+eCcMGbktRDzFfDxL5Q+57qkS+rqE7gKCtImMd7qFs4pnzXG
OYw8tZJwbHgO3qXfoPfrSV74iC32+WTtxBJ7jYuOad7fAdZPH56Hnov6YI6K
v1ETPu/UEbkmz+SJOmNu5on9HXsPjZ0A/uuI/Qh4H5aka84x+Rr1N6Pq/qFj
IwbyNOUYxn1NrNQ99UfeqNk1/2/Gin326cf6yPGw87zqbx3j87vs7969HumV
Wh0E5nMFvXPE3ZzjLcfUxBM552nXO/MmQ/WGfWF/Rnz9rFdzxZn6D6Dz8pc=

           "],
           VertexColors->None], 
          PolygonBox[{{5192, 7271, 2726, 3467}, {5996, 5637, 820, 1844}, {
           6284, 7632, 3063, 2003}, {7007, 4967, 2525, 2523}, {4970, 7971, 
           3319, 3321}, {4876, 7901, 3285, 3287}, {7971, 4969, 3320, 3319}, {
           7549, 4463, 233, 2146}, {7333, 7337, 2769, 1267}, {7908, 7907, 428,
            3288}, {7969, 7970, 2523, 233}, {7632, 7631, 3062, 3063}, {4974, 
           6047, 1831, 862}, {7975, 6043, 862, 3322}, {7402, 8154, 3467, 
           1329}, {5418, 7402, 1329, 1328}, {8486, 5421, 1328, 3849}, {5938, 
           4923, 1844, 1828}, {7336, 5360, 2003, 2769}, {7631, 5525, 3712, 
           3062}, {4644, 8486, 3849, 495}, {4645, 7972, 3321, 496}, {7272, 
           7270, 3519, 2726}, {5637, 5638, 1335, 820}, {8413, 4785, 714, 
           3712}, {7286, 5274, 1195, 1831}, {4969, 7973, 3322, 3320}, {7270, 
           7561, 2994, 3519}, {4786, 7903, 3287, 714}, {7901, 4875, 3286, 
           3285}, {7902, 4483, 276, 3286}, {6124, 6123, 495, 1335}, {5270, 
           7281, 1828, 1195}, {4496, 7334, 2768, 2995}, {7560, 4496, 2995, 
           2994}, {7905, 7906, 3288, 276}, {7335, 7333, 1267, 2768}, {7010, 
           4645, 496, 2525}, {6591, 6592, 2146, 428}},
           VertexColors->None]}]}}, {{}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{7972, 4970, 7971, 4969, 7973, 7975, 6043, 6638, 5943, 4974,
            6047, 4904, 7286, 5274, 6963, 5270, 7281, 5937, 6603, 5938, 4923, 
           5996, 5637, 5638, 5422, 7405, 5423, 6124, 6123, 4644, 8486, 5421, 
           5417, 7401, 5418, 7402, 8154, 5192, 7271, 7272, 7270, 7561, 7560, 
           4496, 7334, 7335, 7333, 7337, 7336, 5360, 6284, 7632, 7631, 5525, 
           8413, 4785, 5903, 4786, 7903, 4876, 7901, 4875, 7902, 4483, 5886, 
           5675, 7905, 7906, 7904, 7908, 7907, 4589, 6591, 6592, 6453, 7549, 
           4463, 5788, 7969, 7970, 7007, 4967, 7010, 4645, 7972}],
          "3.12`"],
         Annotation[#, 3.12, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{8261, 7639, 7640, 4590, 6283, 7638, 7637, 6593, 5373, 5558,
            4342, 4423, 7933, 7934, 6981, 6983, 6982, 4874, 7331, 7332, 6557, 
           4559, 5783, 4560, 7629, 6558, 6941, 6940, 7250, 7251, 7249, 7253, 
           7252, 4859, 5676, 6761, 4686, 6947, 4880, 6563, 6569, 7633, 4562, 
           7350, 7200, 7201, 6566, 7203, 7202, 4794, 7008, 7009, 6632, 6634, 
           4618, 7050, 4619, 5646, 4976, 6048, 4971, 7974, 6042, 6637, 5942, 
           4973, 6046, 4903, 7285, 5273, 6962, 5269, 7280, 5936, 6602, 6598, 
           5754, 4927, 6001, 4770, 5749, 4952, 5644, 4957, 6037, 6032, 5639, 
           8275, 8276, 7668, 7669, 4625, 6125, 8357, 8358, 8356, 8360, 8359, 
           4895, 5560, 5559, 7187, 5193, 8155, 7186, 7400, 7399, 8301, 4642, 
           5660, 5548, 6208, 6207, 8395, 8260, 8261}],
          "2.99`"],
         Annotation[#, 2.99, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{6565, 4879, 6946, 5612, 7011, 4968, 6633, 6635, 6636, 5071,
            7083, 5714, 5715, 4975, 6640, 6642, 4621, 6041, 4620, 6639, 5941, 
           4972, 6045, 4902, 7284, 5272, 6961, 5268, 7279, 5935, 6601, 6597, 
           5753, 4926, 6000, 4769, 5748, 4951, 5643, 4956, 6036, 4899, 8220, 
           5321, 7567, 7573, 4521, 5948, 4516, 6506, 6091, 6266, 5053, 7307, 
           7308, 7306, 8216, 8215, 6267, 4656, 7716, 6734, 7468, 7467, 5435, 
           6165, 5210, 6209, 8397, 5504, 8396, 5505, 7274, 7273, 4497, 5786, 
           5787, 5547, 5611, 4495, 5836, 4494, 5610, 4840, 7614, 7615, 4546, 
           7935, 7750, 7751, 7749, 7753, 7752, 7789, 5367, 8524, 5368, 5250, 
           6194, 5500, 7456, 5501, 7457, 5251, 7247, 5252, 7248, 8159, 7197, 
           8160, 8161, 8162, 7198, 6447, 7348, 5370, 6590, 7636, 6287, 5369, 
           7349, 5372, 8259, 5371, 8563, 7623, 4551, 8469, 6551, 8468, 6552, 
           6760, 7754, 6759, 6368, 6945, 4878, 6564, 7079, 7080, 5067, 6568, 
           6567, 6565}],
          "2.8600000000000003`"],
         Annotation[#, 2.8600000000000003`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{6853, 4793, 6850, 6852, 6851, 4341, 4422, 7854, 7855, 7853,
            7857, 7856, 4558, 7861, 7862, 7858, 7860, 7859, 4458, 5779, 4459, 
           8450, 5201, 6154, 6153, 7664, 7663, 8274, 7662, 7723, 7722, 4665, 
           7724, 7725, 7665, 7666, 4616, 6155, 8375, 8376, 8374, 5492, 8377, 
           4834, 5859, 6446, 5781, 4783, 6286, 4784, 8585, 5782, 6550, 8505, 
           8506, 7863, 7864, 7865, 6842, 6843, 6841, 6840, 6942, 5820, 7967, 
           7968, 6999, 7001, 7000, 4667, 7005, 7006, 7002, 7004, 7003, 4498, 
           6085, 6086, 5265, 7275, 8212, 8211, 6040, 4670, 6746, 6747, 6789, 
           7794, 6788, 6433, 7138, 5138, 6641, 5137, 7137, 5939, 6644, 6643, 
           5940, 4905, 6044, 4901, 7283, 5271, 6960, 5267, 7278, 5934, 6600, 
           6596, 5752, 4925, 5999, 4768, 5747, 4950, 5642, 4955, 6035, 4898, 
           8219, 5320, 7566, 7572, 4520, 5947, 4515, 6505, 6090, 6265, 6261, 
           5057, 6301, 5664, 5668, 7069, 7065, 4654, 8496, 6728, 8491, 6733, 
           6666, 7035, 6671, 7041, 5024, 6068, 6067, 6166, 7481, 7482, 7480, 
           7484, 7483, 5510, 5511, 8457, 4507, 8406, 8407, 8355, 5479, 8354, 
           5480, 5794, 5793, 4348, 6431, 6430, 6787, 4720, 8500, 6532, 7600, 
           6853}],
          "2.73`"],
         Annotation[#, 2.73, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{7502, 5136, 5591, 4429, 4347, 6379, 4367, 8441, 5478, 6122,
            6121, 4677, 6750, 5541, 6751, 6752, 4679, 6350, 4678, 7474, 7475, 
           7473, 5542, 7476, 5523, 5524, 8462, 4535, 7060, 4536, 8463, 7059, 
           6533, 6886, 6881, 7301, 6252, 4598, 6614, 6619, 7164, 7159, 6390, 
           6395, 5761, 5766, 5012, 5770, 6657, 6661, 5023, 6675, 7040, 6670, 
           7034, 6665, 6732, 8490, 6727, 8495, 4653, 7064, 7068, 5667, 5663, 
           6300, 5056, 6260, 6264, 6089, 6504, 4514, 5946, 4519, 7571, 7565, 
           5319, 8218, 4897, 6034, 4954, 5641, 4949, 5746, 4767, 5998, 4924, 
           5751, 6595, 6599, 5933, 7277, 5266, 7282, 6959, 6964, 6576, 7012, 
           8472, 4565, 7013, 7014, 6574, 6573, 6572, 4900, 7147, 7148, 6380, 
           6381, 4368, 5952, 5874, 7047, 5038, 6432, 5039, 7086, 7087, 7084, 
           5072, 7085, 4643, 6706, 6705, 7049, 7048, 7276, 6039, 6711, 6710, 
           6709, 5420, 6196, 6195, 5822, 4617, 6631, 5821, 4822, 6038, 4821, 
           6943, 6944, 6559, 7630, 4561, 5780, 6562, 6561, 6560, 4877, 6476, 
           4482, 5741, 7121, 7122, 7120, 5119, 7123, 7627, 7628, 7111, 7112, 
           7110, 8077, 8076, 6111, 4545, 6834, 6835, 6833, 4778, 7851, 5672, 
           7535, 7534, 7788, 4710, 8498, 6473, 7555, 7241, 5229, 7240, 8196, 
           8195, 6110, 4414, 4335, 7498, 6365, 6475, 6474, 4481, 6192, 6193, 
           5249, 8206, 5248, 8207, 5674, 8209, 8210, 7504, 7503, 7502}],
          "2.6`"],
         Annotation[#, 2.6, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{8436, 5099, 5573, 5101, 8518, 5100, 5711, 4340, 8439, 5117,
            5582, 5583, 7500, 8092, 5118, 7792, 4718, 7793, 4719, 6786, 5135, 
           7136, 8552, 4722, 7795, 4723, 7145, 7146, 6376, 6377, 6378, 5331, 
           8229, 8231, 8230, 4533, 5393, 4532, 8461, 4813, 4669, 6083, 6084, 
           5070, 7699, 8053, 8048, 4641, 6704, 6699, 7811, 7816, 7821, 7806, 
           7046, 8003, 8008, 7676, 7681, 7686, 5047, 8514, 5052, 5033, 6256, 
           5028, 6081, 6501, 4511, 5840, 5844, 5315, 6885, 5311, 7305, 6251, 
           4597, 6613, 6618, 7163, 7158, 6389, 6394, 5760, 5765, 5011, 5769, 
           6656, 6660, 5022, 6674, 7039, 6669, 7033, 6664, 6731, 8489, 6726, 
           8494, 4652, 7063, 7067, 5666, 5662, 6299, 5055, 6259, 6263, 6088, 
           6503, 4513, 5945, 4518, 7570, 7564, 5318, 8217, 4896, 6033, 4953, 
           5640, 4948, 5745, 4766, 5997, 4771, 5750, 7641, 6594, 5374, 7351, 
           6458, 6457, 5212, 7213, 5211, 6167, 6575, 7338, 8245, 7339, 6651, 
           6650, 4626, 6288, 4627, 7670, 6652, 7376, 7375, 6578, 6577, 6910, 
           7891, 4847, 7890, 7403, 8302, 8303, 6707, 6708, 6199, 5253, 6295, 
           5419, 6355, 6356, 5609, 4485, 7556, 4484, 8539, 7404, 6879, 4823, 
           6855, 4824, 5785, 5784, 6325, 6342, 7599, 7598, 7597, 5522, 6282, 
           6281, 5203, 8378, 8379, 7547, 7548, 4461, 6452, 4460, 6450, 6448, 
           4750, 6837, 4780, 6836, 4779, 7852, 5740, 7243, 5232, 7242, 5233, 
           7244, 5102, 7246, 5235, 7245, 5234, 8199, 4478, 6185, 6186, 5231, 
           8197, 5230, 8198, 4336, 8193, 8194, 7495, 7494, 7493, 5092, 6106, 
           6105, 6323, 4410, 7492, 7491, 6359, 5091, 5703, 5702, 4334, 8436}],
          
          "2.47`"],
         Annotation[#, 2.47, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{4321, 5083, 4703, 7769, 4704, 7770, 4320, 7772, 7773, 7771,
            7775, 7774, 4322, 7777, 4705, 7776, 4706, 7778, 4323, 8433, 5084, 
           4707, 6415, 7448, 7449, 7451, 7450, 6101, 8349, 8350, 8348, 5470, 
           8351, 5085, 7101, 5094, 7099, 5093, 7100, 6104, 6107, 6108, 5200, 
           7545, 7546, 4456, 8200, 4457, 8389, 8390, 8388, 5497, 8391, 5472, 
           6324, 5473, 7199, 5202, 6449, 6451, 6145, 5189, 7185, 5191, 6424, 
           6426, 6427, 7501, 6844, 4787, 6829, 4788, 6856, 4797, 6854, 4796, 
           7478, 7479, 6790, 6791, 6792, 6197, 6198, 5717, 8467, 5716, 6119, 
           5756, 4548, 7620, 6539, 6538, 6912, 6911, 7215, 5797, 5798, 5392, 
           5617, 8581, 4523, 6092, 4522, 7574, 7575, 8222, 8221, 5322, 7309, 
           8175, 7212, 8322, 8321, 7423, 6735, 5436, 7422, 4827, 8580, 5845, 
           6459, 7214, 5213, 8521, 6620, 7658, 7659, 5950, 5951, 5317, 5949, 
           7568, 7569, 4517, 5944, 4512, 6502, 6087, 6262, 6258, 5054, 6298, 
           5661, 5665, 7066, 7062, 4651, 8493, 6725, 8488, 6730, 6663, 7032, 
           6668, 7038, 6673, 5021, 6659, 6655, 5768, 5010, 5764, 5759, 6393, 
           6388, 7157, 7162, 6617, 6612, 4596, 6250, 7304, 5310, 6884, 5314, 
           5843, 5839, 4510, 6500, 6080, 5027, 6255, 5032, 5051, 8513, 5046, 
           7685, 7680, 7675, 8007, 8002, 7045, 7805, 7820, 7815, 7810, 6698, 
           6703, 4640, 8047, 8052, 7698, 8057, 7694, 7690, 5037, 5778, 5774, 
           6413, 6409, 7178, 7182, 6630, 6626, 4605, 6272, 5335, 8235, 5339, 
           5856, 5852, 6524, 6520, 5390, 8484, 4610, 6278, 4615, 7961, 7966, 
           7951, 4962, 7956, 4999}],
          "2.34`"],
         Annotation[#, 2.34, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{4315, 7758, 7759, 7757, 4700, 5468, 8430, 4316, 6098, 4318,
            8431, 5469, 6100, 6099, 5079, 8066, 8068, 8067, 4708, 6416, 6417, 
           6418, 7490, 4324, 6102, 6103, 5095, 7102, 7104, 7103, 5699, 6109, 
           5704, 5705, 5471, 5707, 5706, 6112, 8208, 5254, 7254, 5255, 7255, 
           5190, 7260, 5258, 6425, 5257, 7259, 5259, 7261, 7846, 4761, 7847, 
           6830, 6831, 8454, 8456, 8455, 4499, 7051, 7052, 6490, 6489, 6488, 
           4795, 5592, 4430, 7506, 7505, 6373, 7140, 7139, 4772, 5875, 5876, 
           5606, 4467, 6093, 5718, 5846, 6462, 6461, 6460, 5214, 5796, 8587, 
           5795, 4657, 8334, 8335, 8333, 5453, 8336, 5452, 8527, 5540, 5671, 
           6349, 5491, 6331, 5593, 6357, 5451, 6311, 5194, 8324, 8325, 8323, 
           5437, 4537, 8247, 8248, 8246, 8250, 8249, 5362, 8317, 5433, 8316, 
           5432, 8416, 5535, 8567, 5536, 5431, 8319, 8320, 8318, 5434, 4655, 
           7061, 4650, 8492, 6724, 8487, 6729, 6662, 7031, 6667, 7037, 6672, 
           5020, 6658, 6654, 5767, 5009, 5763, 5758, 6392, 6387, 7156, 7161, 
           6616, 6611, 4595, 6249, 7303, 5309, 6883, 5313, 5842, 5838, 4509, 
           6499, 6079, 5026, 6254, 5031, 5050, 8512, 5045, 7684, 7679, 7674, 
           8006, 8001, 7044, 7804, 7819, 7814, 7809, 6697, 6702, 4639, 8046, 
           8051, 7697, 8056, 7693, 7689, 5036, 5777, 5773, 6412, 6408, 7177, 
           7181, 6629, 6625, 4604, 6271, 5334, 8234, 5338, 5855, 5851, 6523, 
           6519, 5389, 8483, 4609, 6277, 4614, 7960, 7965, 7950, 4961, 7955, 
           4998}],
          "2.21`"],
         Annotation[#, 2.21, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{4317, 7761, 4701, 7760, 7763, 7762, 8064, 7765, 7766, 7764,
            7768, 7767, 8069, 5696, 5697, 5087, 8070, 5086, 4409, 4325, 6772, 
           6773, 6419, 6420, 4411, 4327, 6776, 6777, 6422, 6423, 8437, 8438, 
           7257, 7256, 7258, 5256, 6477, 7557, 7558, 5679, 7790, 7791, 6778, 
           6780, 6779, 7124, 7406, 4486, 6479, 6478, 4789, 5602, 4464, 5789, 
           5790, 5206, 7204, 5205, 8582, 7205, 7706, 7705, 4647, 8549, 6860, 
           8548, 6861, 6859, 4798, 7432, 5448, 6749, 7727, 7150, 5145, 7149, 
           5144, 8112, 5755, 4671, 7726, 6748, 7089, 7088, 4724, 7881, 7882, 
           7603, 7604, 4539, 8009, 4538, 7602, 7601, 7880, 7879, 4802, 7166, 
           5150, 7165, 5149, 6862, 4801, 6507, 6508, 4525, 6887, 4524, 5618, 
           5557, 5800, 5799, 6128, 7466, 5533, 7465, 5534, 6333, 6332, 5493, 
           8385, 8387, 8386, 5013, 7997, 5014, 7998, 4776, 6065, 6066, 5762, 
           5757, 6391, 6386, 7155, 7160, 6615, 6610, 4594, 6248, 7302, 5308, 
           6882, 5312, 5841, 5837, 4508, 6498, 6078, 5025, 6253, 5030, 5049, 
           8511, 5044, 7683, 7678, 7673, 8005, 8000, 7043, 7803, 7818, 7813, 
           7808, 6696, 6701, 4638, 8045, 8050, 7696, 8055, 7692, 7688, 5035, 
           5776, 5772, 6411, 6407, 7176, 7180, 6628, 6624, 4603, 6270, 5333, 
           8233, 5337, 5854, 5850, 6522, 6518, 5388, 8482, 4608, 6276, 4613, 
           7959, 7964, 7949, 4960, 7954, 4997}],
          "2.08`"],
         Annotation[#, 2.08, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{5077, 8516, 5078, 4702, 5694, 7489, 7488, 5074, 8065, 5570,
            5076, 8515, 5075, 5695, 4319, 8432, 5080, 5571, 5082, 8517, 5081, 
           5698, 4326, 8434, 5088, 5572, 8073, 5090, 8071, 5089, 8072, 5700, 
           5701, 5097, 7105, 5096, 8074, 4412, 6361, 6360, 5708, 4711, 6113, 
           5574, 7118, 7119, 7116, 5103, 7117, 5456, 7440, 5457, 7441, 4687, 
           6314, 6315, 5678, 8535, 5677, 8571, 7536, 7537, 4424, 4343, 8305, 
           5424, 8304, 5425, 6297, 6296, 7702, 7701, 7700, 8307, 8306, 8398, 
           6210, 4646, 7704, 7703, 5426, 5625, 4552, 8059, 5073, 8058, 8061, 
           8060, 4861, 6922, 4860, 6923, 4977, 7015, 5967, 5968, 5276, 8213, 
           5275, 6211, 4672, 7728, 8502, 4773, 7848, 7550, 8422, 8423, 7739, 
           7740, 7741, 6351, 6352, 5544, 8424, 5543, 4683, 6317, 6318, 5461, 
           8337, 8339, 8338, 7096, 7095, 4385, 6398, 6397, 6770, 6769, 7193, 
           6129, 6511, 6510, 6509, 5323, 8243, 8244, 8242, 5356, 4447, 7328, 
           6439, 6438, 6396, 5151, 5726, 5725, 4389, 8236, 5340, 7318, 5341, 
           7319, 7607, 7608, 6875, 6876, 6872, 6874, 6873, 4388, 5809, 4384, 
           7512, 8116, 8115, 5148, 7626, 4555, 7625, 5358, 4542, 8466, 4831, 
           5316, 6082, 6257, 5029, 5048, 8510, 5043, 7682, 7677, 7672, 8004, 
           7999, 7042, 7802, 7817, 7812, 7807, 6695, 6700, 4637, 8044, 8049, 
           7695, 8054, 7691, 7687, 5034, 5775, 5771, 6410, 6406, 7175, 7179, 
           6627, 6623, 4602, 6269, 5332, 8232, 5336, 5853, 5849, 6521, 6517, 
           5387, 8481, 4607, 6275, 4612, 7958, 7963, 7948, 4959, 7953, 4996}],
          
          "1.9500000000000002`"],
         Annotation[#, 1.9500000000000002`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{4339, 6367, 4333, 6364, 6363, 6742, 6741, 4664, 4818, 8507,
            4817, 4477, 4684, 8435, 4332, 5496, 7552, 7553, 7554, 6336, 6337, 
           5495, 8529, 5494, 4331, 7786, 7787, 7783, 7785, 7784, 4330, 7781, 
           7782, 7779, 4709, 7780, 4329, 7497, 5098, 8075, 7109, 6421, 6775, 
           6774, 7106, 4413, 4328, 7496, 6362, 7108, 7107, 4712, 7114, 7115, 
           7113, 8079, 8078, 4415, 4337, 7443, 7444, 7442, 5458, 5683, 5682, 
           5712, 5713, 5459, 6754, 6755, 6756, 6316, 4680, 6753, 5460, 7737, 
           7738, 4681, 6156, 7206, 6857, 6858, 6491, 6948, 8555, 8557, 8556, 
           4881, 7909, 4882, 6949, 7642, 4591, 5918, 5919, 4929, 5917, 4928, 
           6015, 4444, 4362, 6374, 5966, 4906, 6126, 4907, 7977, 4980, 7976, 
           4979, 7023, 7022, 6864, 4805, 6863, 4804, 8425, 8426, 7742, 7743, 
           7744, 6319, 6320, 5462, 8340, 8342, 8341, 5687, 7098, 4682, 6758, 
           6757, 8063, 8062, 7097, 6771, 4698, 7755, 7756, 7544, 7543, 4448, 
           4386, 7515, 7167, 7514, 8442, 7513, 4728, 8123, 8124, 8121, 5166, 
           8122, 4449, 7520, 7519, 7518, 5167, 5732, 5731, 4393, 7523, 6804, 
           4735, 6802, 4734, 6803, 7522, 6801, 4733, 6799, 4732, 6800, 7326, 
           7327, 5348, 8237, 5349, 8238, 4543, 6343, 6344, 5527, 8533, 5526, 
           5645, 4853, 8554, 4854, 4557, 6273, 4556, 5359, 5858, 5857, 4534, 
           7371, 7372, 6525, 5386, 8480, 4606, 6274, 4611, 7957, 7962, 7947, 
           4958, 7952, 4995}],
          "1.82`"],
         Annotation[#, 1.82, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{4966, 7924, 4922, 7920, 7932, 7928, 4588, 6348, 4584, 8479,
            5531, 4858, 5885, 5815, 5819, 5228, 7239, 8192, 8188, 6184, 4575, 
           5868, 6589, 5873, 5995, 5990, 4839, 5864, 4421, 5581, 5116, 8086, 
           5111, 8091, 8288, 8283, 4636, 8547, 7386, 6828, 4760, 6822, 4755, 
           8101, 8106, 5134, 6823, 7397, 7398, 5407, 8525, 5408, 5106, 8080, 
           5105, 8081, 6115, 7596, 7595, 6839, 4782, 6838, 4781, 5673, 4685, 
           4714, 8499, 4713, 5237, 4479, 8452, 5236, 5104, 5576, 5575, 6201, 
           6202, 5710, 5709, 6114, 4416, 4338, 7499, 6366, 6481, 6480, 4487, 
           5684, 5685, 5260, 8536, 5681, 8537, 5680, 8572, 7538, 7539, 6429, 
           6428, 6369, 7126, 7125, 4762, 6157, 5603, 5604, 6095, 6094, 6096, 
           6097, 5539, 7729, 7730, 7731, 6310, 4674, 7732, 6950, 4884, 7910, 
           4883, 8400, 8401, 8399, 5506, 6212, 5277, 8265, 5375, 8262, 8264, 
           8263, 4566, 7978, 4567, 7635, 7634, 4908, 7911, 5324, 8223, 5325, 
           8224, 5058, 8010, 5059, 8011, 4803, 7868, 7869, 7541, 7540, 4446, 
           4382, 8345, 5466, 8344, 5467, 6322, 6321, 7748, 7747, 7746, 8347, 
           8346, 7447, 8343, 5463, 8565, 7745, 5195, 8519, 8520, 8157, 8156, 
           7194, 6399, 5152, 7168, 4729, 7822, 7823, 6798, 8570, 6797, 7184, 
           5733, 4394, 7525, 7524, 8130, 8129, 5599, 8133, 8134, 8131, 5175, 
           8132, 5735, 7531, 7530, 7529, 5179, 8138, 5600, 8142, 8143, 8139, 
           8141, 8140, 5736, 4400, 7825, 4740, 7824, 4739, 5184, 5183, 4454, 
           5601, 5185, 8148, 8150, 8149, 5737, 4407, 7844, 7845, 7841, 7843, 
           7842, 4406, 5519, 8532, 5520, 5516, 5518, 8531, 5517, 5521}],
          "1.69`"],
         Annotation[#, 1.69, "Tooltip"]& ], 
        TagBox[
         TooltipBox[
          LineBox[{4361, 4443, 6014, 5916, 6028, 5981, 4381, 5965, 4361}],
          "1.69`"],
         Annotation[#, 1.69, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{4408, 4455, 5187, 8153, 5188, 5739, 5738, 8151, 8152, 7828,
            4742, 7826, 4741, 7827, 5180, 8144, 5181, 8145, 6445, 6444, 4738, 
           6817, 7526, 7527, 4452, 6441, 6440, 6806, 6805, 4390, 4450, 8125, 
           5168, 7183, 5169, 5728, 8443, 5727, 6130, 7311, 5327, 7310, 5328, 
           7446, 5465, 7445, 5464, 6514, 6513, 6868, 7874, 7873, 7872, 6537, 
           7070, 8465, 4541, 8013, 5060, 8012, 5061, 8014, 4828, 6890, 7884, 
           7883, 5719, 5847, 4468, 7551, 8177, 8176, 5215, 8561, 7734, 7735, 
           7733, 5450, 8332, 6713, 6712, 7054, 7053, 4688, 6762, 4689, 6763, 
           7189, 7188, 6146, 6147, 5449, 7433, 7435, 7434, 4673, 5742, 8107, 
           8108, 7141, 7143, 7142, 4763, 7262, 7263, 6482, 7559, 4488, 6200, 
           4489, 6484, 6483, 7265, 7264, 4715, 6781, 4716, 6782, 7616, 4547, 
           6204, 7619, 7618, 7617, 5355, 6485, 4490, 6203, 4491, 6487, 6486, 
           7267, 7266, 7452, 7458, 5502, 8394, 5503, 8393, 8392, 5204, 8163, 
           8165, 8164, 4462, 7036, 6784, 6785, 6783, 4717, 6899, 4846, 5584, 
           4845, 6898, 6909, 6904, 4580, 6191, 5242, 8205, 5247, 5833, 5827, 
           7991, 7995, 7987, 5003, 7983, 5007, 8300, 5416, 8292, 5412, 8296, 
           5133, 8096, 8105, 8100, 4754, 6821, 4759, 6827, 7385, 8546, 4635, 
           8282, 8287, 8090, 5110, 8085, 5115, 5580, 4420, 5863, 4838, 5989, 
           5994, 5872, 6588, 5867, 4574, 6183, 8187, 8191, 7238, 5227, 5818, 
           5814, 5884, 4857, 5530, 8478, 4583, 6347, 4587, 7927, 7931, 7919, 
           4921, 7923, 4965}],
          "1.56`"],
         Annotation[#, 1.56, "Tooltip"]& ], 
        TagBox[
         TooltipBox[
          LineBox[{4360, 4442, 6013, 5915, 6027, 5980, 4380, 5964, 4360}],
          "1.56`"],
         Annotation[#, 1.56, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{6144, 6143, 8371, 8372, 8370, 5490, 8373, 5186, 6142, 4401,
            8448, 5489, 4744, 7829, 4743, 7830, 8147, 8146, 6138, 6139, 5485, 
           7532, 7533, 4398, 6137, 4395, 4453, 6443, 6442, 6808, 6807, 4391, 
           7521, 5597, 5596, 6179, 4730, 5729, 6400, 7196, 5198, 7195, 5197, 
           8158, 6150, 6516, 6515, 6512, 5326, 7510, 8566, 5481, 8361, 7511, 
           6435, 6434, 6793, 7797, 7796, 6794, 6534, 7407, 8464, 4540, 7605, 
           8564, 5427, 8308, 8309, 7409, 7408, 5146, 6382, 6383, 6384, 5801, 
           5877, 5878, 5743, 4764, 6148, 4765, 7093, 7094, 7090, 7092, 7091, 
           4465, 7866, 7867, 6845, 6847, 8541, 6846, 8542, 4622, 7667, 5532, 
           8534, 7464, 8415, 8414, 5477, 8352, 5476, 8353, 4363, 7373, 7374, 
           7269, 5261, 7268, 5262, 6206, 6205, 4492, 6116, 6117, 5120, 6370, 
           6371, 4344, 6375, 4365, 7388, 7389, 7387, 5396, 7390, 5395, 6289, 
           6676, 6077, 5401, 6294, 5654, 5659, 5406, 7135, 7396, 5124, 7130, 
           5128, 5588, 4428, 7889, 4844, 6897, 6908, 6903, 4579, 6190, 5241, 
           8204, 5246, 5832, 5826, 7990, 7994, 7986, 5002, 7982, 5006, 8299, 
           5415, 8291, 5411, 8295, 5132, 8095, 8104, 8099, 4753, 6820, 4758, 
           6826, 7384, 8545, 4634, 8281, 8286, 8089, 5109, 8084, 5114, 5579, 
           4419, 5862, 4837, 5988, 5993, 5871, 6587, 5866, 4573, 6182, 8186, 
           8190, 7237, 5226, 5817, 5813, 5883, 4856, 5529, 8477, 4582, 6346, 
           4586, 7926, 7930, 7918, 4920, 7922, 4964}],
          "1.4300000000000002`"],
         Annotation[#, 1.4300000000000002`, "Tooltip"]& ], 
        TagBox[
         TooltipBox[
          LineBox[{4359, 4441, 6012, 5914, 6026, 5979, 4379, 5963, 4359}],
          "1.4300000000000002`"],
         Annotation[#, 1.4300000000000002`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{4405, 7840, 4749, 7838, 4748, 7839, 4404, 7837, 4747, 7835,
            4746, 7836, 4403, 7834, 4745, 7831, 7833, 7832, 4402, 6141, 4399, 
           8447, 5488, 5182, 6140, 5486, 8528, 5487, 5178, 8369, 5484, 8368, 
           5483, 6136, 8136, 5176, 8135, 5177, 8137, 5170, 8126, 5482, 8367, 
           5567, 6328, 5224, 6180, 6472, 4476, 7477, 5545, 5608, 5607, 6335, 
           5345, 8411, 8412, 8410, 5514, 7229, 5219, 7228, 5220, 7230, 5196, 
           7226, 8569, 7227, 7225, 7313, 8568, 7312, 8225, 8226, 6865, 4807, 
           6867, 7871, 7870, 6866, 6535, 7606, 6536, 6889, 6888, 5619, 5881, 
           4806, 5802, 6540, 4549, 5744, 6543, 6542, 6913, 4848, 7893, 7892, 
           6553, 7624, 5791, 4799, 6214, 5613, 5614, 4978, 6049, 5443, 7427, 
           5444, 7428, 5391, 6645, 6646, 6647, 6158, 8381, 8382, 8380, 8384, 
           8383, 4790, 7208, 7209, 8168, 8167, 5207, 8560, 7355, 5378, 7354, 
           7357, 7356, 4886, 6216, 4885, 5924, 8026, 8025, 8031, 8020, 8041, 
           8036, 5019, 6685, 6690, 8314, 6694, 7417, 7413, 6162, 6072, 6680, 
           6076, 5400, 6293, 5653, 5658, 5405, 7134, 7395, 5123, 7129, 5127, 
           5587, 4427, 7888, 4843, 6896, 6907, 6902, 4578, 6189, 5240, 8203, 
           5245, 5831, 5825, 7989, 7993, 7985, 5001, 7981, 5005, 8298, 5414, 
           8290, 5410, 8294, 5131, 8094, 8103, 8098, 4752, 6819, 4757, 6825, 
           7383, 8544, 4633, 8280, 8285, 8088, 5108, 8083, 5113, 5578, 4418, 
           5861, 4836, 5987, 5992, 5870, 6586, 5865, 4572, 6181, 8185, 8189, 
           7236, 5225, 5816, 5812, 5882, 4855, 5528, 8476, 4581, 6345, 4585, 
           7925, 7929, 7917, 4919, 7921, 4963}],
          "1.3`"],
         Annotation[#, 1.3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[
          LineBox[{4358, 4440, 6011, 5913, 6025, 5978, 4378, 5962, 4358}],
          "1.3`"],
         Annotation[#, 1.3, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{4387, 8444, 5164, 5594, 5595, 7517, 7516, 5165, 8120, 4731,
            5172, 5171, 4451, 5598, 5174, 8127, 5173, 8128, 5734, 4397, 6815, 
           6816, 6813, 4737, 6814, 7528, 6812, 4736, 6809, 6811, 8445, 6810, 
           8446, 4396, 7453, 7454, 5569, 5568, 6329, 5350, 8523, 5515, 5624, 
           8240, 8241, 7612, 7613, 4544, 6135, 8363, 8364, 8362, 8366, 8365, 
           4777, 7170, 5155, 7169, 5154, 6131, 5153, 7325, 5346, 7322, 7324, 
           7323, 4474, 6151, 4473, 6471, 5218, 6170, 6169, 4529, 5803, 5804, 
           5438, 5620, 4527, 5848, 4526, 5879, 5880, 6305, 6304, 4849, 7029, 
           4984, 7028, 4983, 6764, 4690, 6541, 4691, 6765, 4721, 7352, 5376, 
           6604, 7643, 7644, 6213, 8402, 5507, 7459, 7461, 7460, 5278, 7287, 
           5279, 7288, 8166, 7207, 8170, 8171, 7210, 6454, 7211, 6455, 6456, 
           5379, 6925, 4862, 6924, 4863, 6987, 6992, 5634, 4936, 7941, 4941, 
           7946, 4869, 6221, 5283, 5890, 6495, 4503, 5923, 8024, 8030, 8019, 
           8040, 8035, 5018, 6684, 6689, 8313, 6693, 7416, 7412, 6161, 6071, 
           6679, 6075, 5399, 6292, 5652, 5657, 5404, 7133, 7394, 5122, 7128, 
           5126, 5586, 4426, 7887, 4842, 6895, 6906, 6901, 4577, 6188, 5239, 
           8202, 5244, 5830, 5824, 7988, 7992, 7984, 5000, 7980, 5004, 8297, 
           5413, 8289, 5409, 8293, 5130, 8093, 8102, 8097, 4751, 6818, 4756, 
           6824, 7382, 8543, 4632, 8279, 8284, 8087, 5107, 8082, 5112, 5577, 
           4417, 5860, 4835, 5986, 5991, 5869, 6585, 5455, 4676, 6280, 5351, 
           5352, 5064, 8015, 5065, 4820, 8508, 4819, 4480, 5498, 8530, 5499, 
           5264, 6330, 5589, 5590, 6372, 4346, 6326, 6327, 5564, 5563}],
          "1.17`"],
         Annotation[#, 1.17, "Tooltip"]& ], 
        TagBox[
         TooltipBox[
          LineBox[{4357, 4439, 6010, 5912, 6024, 5977, 4377, 5961, 4357}],
          "1.17`"],
         Annotation[#, 1.17, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{6172, 5343, 6279, 5512, 8408, 5513, 8409, 5344, 7321, 7320,
            6527, 5342, 8253, 8254, 8251, 5363, 8252, 8256, 8255, 5357, 6546, 
           6547, 6548, 6134, 7622, 7621, 6549, 7330, 7329, 6531, 6530, 4816, 
           6878, 5552, 7876, 4815, 7589, 7590, 7591, 5354, 7594, 7593, 7592, 
           5347, 6414, 4392, 5730, 7173, 5162, 7172, 5163, 7174, 5199, 7171, 
           5161, 6403, 6404, 6405, 5724, 7153, 7154, 6796, 4727, 7801, 4726, 
           8553, 7144, 8559, 5143, 5263, 8453, 4493, 5441, 8497, 4666, 6120, 
           5142, 6308, 5442, 6353, 6354, 5562, 4366, 6309, 4345, 8440, 5475, 
           5474, 8420, 8421, 8417, 8419, 8418, 4631, 5834, 5835, 5008, 5828, 
           7996, 5823, 5829, 5243, 8201, 5238, 6187, 4576, 6900, 6905, 6894, 
           4841, 7886, 4425, 5585, 5125, 7127, 5121, 7393, 7132, 5403, 5656, 
           5651, 6291, 5398, 6074, 6678, 6070, 6160, 7411, 7415, 6692, 8312, 
           6688, 6683, 5017, 8034, 8039, 8018, 8029, 8023, 5922, 4502, 6494, 
           5889, 5282, 6220, 4868, 7945, 4940, 7940, 4935, 5633, 6991, 5629, 
           6996, 4947, 6609, 7652, 7657, 5895, 7289, 6951, 4592, 6570, 8169, 
           8471, 8470, 4564, 7056, 4563, 5636, 5361, 6285, 4887, 6986, 4931, 
           6984, 4930, 7936, 4445, 4364, 5561, 4981, 6653, 7081, 8485, 4628, 
           7082, 4629, 8326, 5439, 7426, 5440, 6303, 6302, 4659, 6306, 6307, 
           5537, 5669, 4658, 7471, 5538, 7470, 7469, 6736, 7425, 7424, 4695, 
           7340, 7341, 6581, 6582, 4569, 6173, 6334, 6171, 6172}],
          "1.04`"],
         Annotation[#, 1.04, "Tooltip"]& ], 
        TagBox[
         TooltipBox[
          LineBox[{4356, 4438, 6009, 5911, 6023, 5976, 4376, 5960, 4356}],
          "1.04`"],
         Annotation[#, 1.04, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{6849, 4792, 6848, 4791, 5686, 4694, 7875, 4811, 7583, 7584,
            7585, 4830, 7588, 7587, 7586, 4812, 5693, 5692, 5810, 5811, 5160, 
           8119, 5159, 8258, 5366, 7611, 7610, 7609, 4832, 5723, 5722, 7885, 
           4833, 6891, 6893, 8550, 6892, 8551, 4663, 7472, 4662, 5670, 5549, 
           7487, 5551, 7485, 5550, 7486, 4675, 8428, 5555, 8427, 5556, 8429, 
           5554, 6313, 6312, 6152, 4661, 7721, 6921, 4852, 6920, 4851, 7235, 
           5223, 7234, 5222, 6877, 4814, 6526, 6528, 6529, 4916, 6978, 6980, 
           6979, 4699, 6402, 6973, 6974, 6976, 6975, 4383, 6437, 6436, 6795, 
           7800, 7799, 7798, 6737, 7717, 7072, 5063, 6966, 5062, 7071, 7577, 
           7576, 8558, 4982, 7979, 7024, 7027, 7026, 4668, 6050, 8113, 8114, 
           7151, 5147, 7152, 4985, 6051, 5040, 6985, 5041, 7055, 4888, 5925, 
           6714, 5927, 4894, 6225, 4893, 7298, 5304, 6956, 5298, 7293, 5894, 
           7656, 7651, 6608, 4946, 6995, 5628, 6990, 5632, 4934, 7939, 4939, 
           7944, 4867, 6219, 5281, 5888, 6493, 4501, 5921, 8022, 8028, 8017, 
           8038, 8033, 5016, 6682, 6687, 8311, 6691, 7414, 7410, 6159, 6069, 
           6677, 6073, 5397, 6290, 5650, 5655, 5402, 7131, 7392, 7391, 5129, 
           6118, 7671, 6768, 4693, 6766, 4692, 8579, 6767, 5066, 7563, 4506, 
           8540, 7078, 6849}],
          "0.91`"],
         Annotation[#, 0.91, "Tooltip"]& ], 
        TagBox[
         TooltipBox[
          LineBox[{4355, 4437, 6008, 5910, 6022, 5975, 4375, 5959, 4355}],
          "0.91`"],
         Annotation[#, 0.91, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{6164, 5209, 6358, 8174, 8173, 8172, 5553, 5605, 4466, 5428,
            8526, 5429, 5208, 6163, 7708, 7707, 5430, 8310, 6686, 6681, 5015, 
           8032, 8037, 8016, 8027, 8021, 5920, 4500, 6492, 5887, 5280, 6218, 
           4866, 7943, 4938, 7938, 4933, 5631, 6989, 5627, 6994, 4945, 6607, 
           7650, 7655, 5893, 7292, 5297, 6955, 5303, 7297, 4892, 6229, 5292, 
           5932, 6223, 6222, 6060, 4648, 6716, 6715, 7058, 7057, 5647, 5648, 
           5068, 8042, 5069, 8043, 4994, 7025, 4993, 7030, 4528, 7914, 4911, 
           6967, 4912, 8586, 6968, 7718, 8509, 6738, 7912, 7913, 4910, 6965, 
           4909, 6869, 4810, 6870, 6401, 6583, 8473, 8475, 8474, 4570, 5384, 
           8271, 8273, 8272, 5382, 8269, 8270, 8267, 5383, 8268, 4475, 8538, 
           7366, 7231, 7233, 8451, 7232, 5221, 7345, 7346, 7342, 7344, 7343, 
           8277, 8278, 7377, 8562, 5364, 8257, 5365, 6178, 6177, 7455, 6918, 
           6919, 6544, 6545, 4550, 7347, 6127, 5720, 5721, 6246, 6245, 4725, 
           8501, 5546, 4829, 5616, 5615, 6244, 4800, 5792, 5141, 8239, 5353, 
           8110, 8111, 6164}],
          "0.78`"],
         Annotation[#, 0.78, "Tooltip"]& ], 
        TagBox[
         TooltipBox[
          LineBox[{4354, 4436, 6007, 5909, 6021, 5974, 4374, 5958, 4354}],
          "0.78`"],
         Annotation[#, 0.78, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{7369, 5984, 5983, 6268, 5985, 4601, 6622, 6621, 5385, 6176,
            6175, 6174, 4571, 7379, 7380, 7378, 5394, 7381, 5156, 6132, 5157, 
           8117, 5158, 8118, 4918, 6915, 4850, 6914, 6917, 6916, 4593, 6247, 
           7437, 7438, 7436, 5454, 7439, 7736, 7300, 5307, 7299, 5306, 8214, 
           6243, 4660, 7720, 6740, 7877, 7878, 4826, 6880, 4825, 6957, 6958, 
           6571, 7353, 8266, 5377, 7645, 7646, 7647, 6215, 8404, 5508, 8403, 
           5509, 8405, 4864, 6217, 4865, 7942, 4937, 7937, 4932, 5630, 6988, 
           5626, 6993, 4944, 6606, 7649, 7654, 5892, 7291, 5296, 6954, 5302, 
           7296, 4891, 6228, 5291, 5931, 5287, 6224, 6059, 6717, 6064, 5042, 
           5649, 4630, 8315, 7418, 7419, 7216, 7219, 7218, 4808, 7223, 7224, 
           7220, 7222, 7221, 7365, 4568, 6580, 6579, 6971, 6970, 5623, 6871, 
           6977, 7916, 4915, 7915, 7367, 7368, 7369}],
          "0.65`"],
         Annotation[#, 0.65, "Tooltip"]& ], 
        TagBox[
         TooltipBox[
          LineBox[{4353, 4435, 6006, 5908, 6020, 5973, 4373, 5957, 4353}],
          "0.65`"],
         Annotation[#, 0.65, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{6057, 4992, 6340, 4988, 6233, 6237, 6063, 5286, 5930, 5290,
            6227, 4890, 7295, 5301, 6953, 5295, 7290, 5891, 7653, 7648, 6605, 
           4943, 5635, 4942, 6029, 4553, 8328, 8329, 8327, 8331, 8330, 5139, 
           8109, 5140, 7507, 7508, 7509, 7018, 7019, 7017, 7016, 6385, 4696, 
           7076, 7077, 7073, 7075, 7074, 4530, 6030, 6031, 5622, 5621, 5902, 
           4809, 7191, 8449, 7192, 7190, 7542, 5566, 5565, 6133, 4697, 8458, 
           5691, 6584, 7370, 4917, 7578, 8227, 5330, 8228, 7580, 7581, 5982, 
           4531, 6969, 4913, 6930, 4914, 6972, 7661, 6168, 5217, 7364, 6469, 
           6470, 5807, 6468, 6465, 7217, 5216, 8184, 8178, 8183, 8522, 8179, 
           7712, 6057}],
          "0.52`"],
         Annotation[#, 0.52, "Tooltip"]& ], 
        TagBox[
         TooltipBox[
          LineBox[{4352, 4434, 6005, 5907, 6019, 5972, 4372, 5956, 4352}],
          "0.52`"],
         Annotation[#, 0.52, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{7021, 6648, 6649, 4624, 5688, 4623, 7431, 5446, 7430, 5447,
            6241, 6240, 6745, 6744, 6743, 5445, 7429, 4870, 6239, 5299, 5896, 
           5294, 6952, 5300, 7294, 4889, 6226, 5289, 5929, 5285, 6062, 6236, 
           6232, 4987, 6339, 4991, 6056, 7711, 8182, 7715, 6719, 6721, 6464, 
           6467, 4470, 5806, 4472, 7361, 7363, 7359, 5381, 5900, 5898, 4600, 
           6934, 6937, 6929, 7899, 7897, 8574, 7316, 7582, 7317, 7579, 8460, 
           8459, 8583, 6932, 8578, 8576, 8577, 6938, 6939, 5690, 5689, 6149, 
           5808, 4554, 6556, 6554, 6928, 6927, 7315, 5329, 7314, 7020, 7021}],
          
          "0.39`"],
         Annotation[#, 0.39, "Tooltip"]& ], 
        TagBox[
         TooltipBox[
          LineBox[{4351, 4433, 6004, 5906, 6018, 5971, 4371, 5955, 4351}],
          "0.39`"],
         Annotation[#, 0.39, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{6055, 4990, 6338, 4986, 6231, 6235, 6061, 5284, 5928, 5288,
            5926, 6496, 4504, 6052, 4505, 7562, 6497, 7463, 7462, 5305, 6242, 
           6723, 6722, 7421, 7420, 4774, 6832, 4775, 7850, 7849, 8504, 8503, 
           7719, 6739, 7894, 7895, 4871, 6926, 6555, 6997, 6998, 5901, 7660, 
           6935, 4873, 6936, 6933, 4599, 5897, 5899, 5380, 7358, 7362, 7360, 
           4471, 5805, 4469, 6466, 6463, 6720, 6718, 7714, 8181, 7710, 6055}],
          
          "0.26`"],
         Annotation[#, 0.26, "Tooltip"]& ], 
        TagBox[
         TooltipBox[
          LineBox[{7898, 4872, 7900, 6931, 8584, 8575, 8573, 7896, 7898}],
          "0.26`"],
         Annotation[#, 0.26, "Tooltip"]& ], 
        TagBox[
         TooltipBox[
          LineBox[{4350, 4432, 6003, 5905, 6017, 5970, 4370, 5954, 4350}],
          "0.26`"],
         Annotation[#, 0.26, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{6054, 4989, 6341, 6058, 6053, 4649, 7713, 8180, 7709, 
           6054}],
          "0.13`"],
         Annotation[#, 0.13, "Tooltip"]& ], 
        TagBox[
         TooltipBox[LineBox[{6234, 5293, 6238, 6230, 6234}],
          "0.13`"],
         Annotation[#, 0.13, "Tooltip"]& ], 
        TagBox[
         TooltipBox[
          LineBox[{4431, 4349, 5953, 4369, 5969, 6016, 5904, 6002, 4431}],
          "0.13`"],
         Annotation[#, 0.13, "Tooltip"]& ]}, {}, {}}}],
    AspectRatio->1,
    Frame->True,
    PlotRange->{{-3, 3}, {-3, 3}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx0nXd8VcXz90lIQhUEBAuIonSRooiiwF5671WR6hcbIE26AgqCCCJduogC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     "], {{
       {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
        GraphicsGroupBox[
         PolygonBox[{{4160, 6994, 113}, {6994, 4145, 113}, {7007, 4160, 
          113}, {4145, 4241, 113}, {7040, 5822, 1154}, {7094, 7007, 113}, {
          5859, 7040, 1154}, {5840, 6957, 1154}, {7081, 6941, 113}, {5822, 
          6959, 1154}, {6941, 7094, 113}, {4241, 7081, 113}, {7938, 7025, 
          1154}, {6957, 7938, 1154}, {7025, 5859, 1154}, {6959, 5840, 1154}},
          VertexColors->None]]}, 
       {RGBColor[
        0.32625774252648276`, 0.11450732084828888`, 0.5755750420854077], 
        EdgeForm[None], 
        GraphicsGroupBox[{
          PolygonBox[{{7939, 7024, 1690}, {2576, 2577, 1155}, {1270, 2091, 
           455}, {2576, 1270, 455}, {10682, 10680, 3094}, {8168, 8187, 
           2091}, {2573, 2574, 301}, {1270, 2576, 1155}, {8818, 6122, 1270}, {
           6151, 9556, 2574}, {7058, 4327, 301}, {1690, 2005, 301}, {9557, 
           6152, 2575}, {6153, 9559, 2577}, {5023, 9306, 1680}, {9524, 8168, 
           2091}, {7164, 7257, 455}, {9288, 5861, 1156}, {11270, 7466, 
           1822}, {1822, 1270, 1155}, {1156, 2573, 301}, {7187, 5255, 846}, {
           2575, 2573, 1155}, {2005, 1680, 301}, {10680, 10681, 3094}, {5879, 
           9288, 1156}, {7024, 7498, 1690}, {7498, 5066, 1690}, {11433, 9558, 
           2576}, {1680, 1156, 301}, {5255, 6430, 846}, {10679, 5254, 846}, {
           1156, 1822, 1155}, {5254, 7165, 846}, {2573, 1156, 1155}, {10092, 
           8818, 1270}, {7416, 5023, 1680}, {7466, 10111, 1822}, {7435, 7450, 
           1821}, {7257, 11432, 455}},
           VertexColors->None], 
          PolygonBox[{{7008, 4161, 4160, 7007}, {7165, 7164, 455, 846}, {6152,
            9555, 2573, 2575}, {5861, 11270, 1822, 1156}, {9555, 6151, 2574, 
           2573}, {5066, 7435, 1821, 1690}, {4242, 7082, 7081, 4241}, {9306, 
           5879, 1156, 1680}, {6995, 4146, 4145, 6994}, {7095, 7008, 7007, 
           7094}, {9556, 7058, 301, 2574}, {5823, 6960, 6959, 5822}, {10111, 
           10092, 1270, 1822}, {7025, 7938, 2005, 1690}, {7082, 6942, 6941, 
           7081}, {9558, 6153, 2577, 2576}, {6960, 5841, 5840, 6959}, {4161, 
           6995, 6994, 4160}, {10681, 10679, 846, 3094}, {6122, 9524, 2091, 
           1270}, {9559, 5860, 1155, 2577}, {7168, 7187, 846, 455}, {8187, 
           7168, 455, 2091}, {5860, 9557, 2575, 1155}, {7938, 6957, 1680, 
           2005}, {6942, 7095, 7094, 6941}, {4327, 7939, 1690, 301}, {4146, 
           4242, 4241, 4145}, {6430, 10682, 3094, 846}, {5859, 7025, 1690, 
           1821}, {11432, 11433, 2576, 455}, {7041, 5823, 5822, 7040}},
           VertexColors->None], 
          PolygonBox[{{7450, 7041, 7040, 5859, 1821}, {5841, 7416, 1680, 6957,
            5840}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.3590994850529656, 0.17161024169657776`, 0.6217380841708153], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlVuI1VUUxpeeGefM9TjjOTOHcaa5eRyHJqjooQuObzEX9KHGlLKheojC
LuT0khQ9jBY9pZFBSJSpTUVKkOmM9mAvgSNUGg0kRESZCVG9q9D341vSw2av
/95rr72+9X1r/weeeP6B51ZGxDGNgsZ8Y8Tsqoi/tdixPqJd40BTxPlSxCPN
Ea/K6ZzsJY3t8jnWFfH4aMQfdV5j70nFuZR+366IOKh4/Q0Re+Xz7LqIZzTO
6p5PdO5jjXWtEU3ViE9l12RvLnoeVoyziv+61ttancNSxieXX+Q3ohy+1tk7
b4m4Vh/xo+46rnG54Py2FZzDvqGIfzsi3i96v6slYkp7vcqjR/Z0wTHPZ3zu
wQbv9yMRv43Yr6S1iuZvVhgfOPEv6O4+YWzSnZ3d+u52HcH83ipjebAWUaza
969bVbfOiIuKdX1txI21zmtU/surHOcOYbpe8dpd7RELPRHv6t6VgxEbBo1/
Vucu9rrG4yXHANdj/fJV7S7r7Ile8wRHdVkj6sPdHzU65u0F2/DOPJ/2K6rb
7gHX7Xflu61mnFXNO4dch7s1z1dci+V277F+Q/YXuvs72bPK/ULF2E42ue7/
qG5vV3yes7P1xkpuDGzq8MZtEYfK5vKUeFgcMQfg2VhyfOaxkrEflWav9EVM
yp4ouS67FPvLvBeuyy0+gz+xyqmHl3XXUx3WDvusE39rzfjBDq8dLY6/c4P0
rPGrtHOh6Jm67VOOh0fst1/5vCl7Qv4zwrE1bfiZGjJH9MPB1Av7L5TtQ67s
o+FGaeehmjlcbrCu8J8sGScY6dXJtI+nJqjlSzrbKWx71UevaexpNefMrNFH
cNxWMndoay7XWSvlOvcQH65eHHV/0psflM0THG2irplDJXuGOu6SVvf3Gedc
5kB89rjjaIPPwiPccn48ORpPjGBhf1PGBwOx0PBS9ivc0d+V5JQ60XP04HbV
b6bPNnzB5WRqn1jEOa31haJrTm/9tCa5Ec8Tsq82O4eNmSe+0/nOoC90hrbh
7VKuw8s7Ta7bh+qnIxpnih4n0584nCXWPerfzf3/a5XaoMPKoN8C8iR3MKC3
z8Xv/R3G/3SHdUwdyIf4nH9L9Z+uuR70689V50dfPtzj3hxb7feUt5Rcr2VP
nsv3HixwyLtDTbp0z+6qNXV4wD1PnmPJD/VHLwcS+0RqBx5nVM8e1fOHZmua
Nfp9Kv05z7/ls3y7eId4x9FpQTlcWe0+2NHstxst8e+Aa+IcWe+3AH7pvz3Z
U/BwE19D1e8yZ9A8cW7+X3bk/46er8uY/Kt4P/l+NH2499Sw6jzsNfTelpon
LjmhN3DCN1zTJ6dTY/cJS33Z+rua/zVy+Ep47+0zv8QDNzx2q2aHtLeYOl3M
mPB8Jn0Y2HCxpegcyB+Ot6RN/83lO4DuFjIOa+SAxuiVP9c4//8AfRcbQQ==

           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlUls1GUYxp92ugx0kDpth6Ez0+mUbgODAdQDYDR6MBYCMVoFcUnhQCAU
VODiQkBDKUdcE2OQIriwxJi4dACNnDzoQdFIookxxrAb9KQQSsLvyTuHJ/P+
v+/93uV5lymte/aRLfWSNoIG8MWA9GlW2pmQnmqRVnRLI+Acl8OcLcxJP2Wk
M2AB8oNp3oLV9fFmA/JEu7QqEWeZ+VJTl1RGHpshjQ5KX5Wkq3z/if3t2Ml0
StuapI+mSVV0x3ukAvIHzdLxWVL6Dum+mdJ5YnipLB3ul5ZhvzUlPYzu5l7p
NPpjDeFrkhyebgmfUx3YzktnsV/hfklRWgoWJCKGl7H3DPEO1ew9R04J7s82
h72Vs7kn5p+x9w/8rOX+gVbpfjCCfLEtYrDuADa+HAgOzZ1j2IW8GYyCneAK
+dzdJ90FLiNvKEcM9u2cPq5ITxDvL8TbC1+pgpQDnaAFDOPzTnwvAo/m4u5V
fl/Jhc5/c4JTc/kh2EtuRXLoAuPIu9uDQ/tzzub6R77zqeD8UDlicixpzhbB
58Ku4O5Go3QTP3uwMYu7T4jxM3x+Xoja/FAntefDp321Idfl48yywGFqf6gU
uqeS0r/pqLlrfYDveYXgzFzNde7wO4F+lbuTYBx+XuuP2G+Dnxfp1Q56bDfy
HrCsEDV0PbqxuQafM3i/Mhk9YFud2DyRDJtJ3j9GLYroJhqD2zfA6zWOi9iq
gknQBYZ4Ww9nf/D2EvX9le97CuHrXew3VyIHx96EfD4TZ5bPIT+OryOVqG0D
/t7Dx72twe3b0yOXF7IxK85pEF8d4J268DlKr2/NhS/3fIp8pqPfh+4Kx0Tv
ToEb4CJ4njpsrwRX5uz2/vBpX2+B79uix9xb3yEfRXd1X/SybV4j5iF8PgT+
R04wq/vK0RueWd85R+dmHXN3jPiO5oLDYWw1Z4Pb/ehv64kZcO9v7YlZuFSL
1TNxgd+vyelMMnrQvTaJv45U9Jxzq6v1knOs8vv3PHZSKjhahY1p2eDWNd3P
d7o/cl3ODvkLW4u7Y5e55z07p4n9m0zMkGXvOO82nzW61+dHb3lnLGe+3mSn
/JaInXgd/xPwdgBcQ95BzmOD0RvrFbM8lYtZ8Uybm2Ktl8xRnnfvl2IWvGM2
YX/HnJiFb8nnYCl2kHePe9a+noTnNb3h07Jr5Nr4zLvSOTtX70zP/ilyPlmO
HeBd5BqYe+8kc71pMHaxOf89Gzk4dud4wbOQi9p5J57ATrUcsbkm3oXeSd5F
3omeFe/IkdrMePbco+5Nz6D/O8yZufJ/yMH2mHHPtv8z1mZih3l3uaa3AEA8
6aI=
           "],
           VertexColors->None], 
          PolygonBox[{{7484, 5067, 5066, 7498, 1824}, {10683, 4566, 454, 
           10680, 10682}},
           VertexColors->None]}]}, 
       {RGBColor[0.3919412275794483, 0.22871316254486662`, 0.667901126256223],
         EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl1ts1EUUxmdpd/9L2QvdLe0W2q5rt2WlhYZGg9FEuSQaX4D2SYpCJSYC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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmtslFUQhoeWsksvhLLtdsu23a5tl9a2GLDIxVsCiQoKCBEDVgut/qCC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           "],
           VertexColors->None], 
          PolygonBox[{{6081, 9874, 2838, 11399, 6080}, {8069, 7028, 7027, 
           8081, 2068}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.42478297010593113`, 0.28581608339315556`, 0.7140641683416307], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNlk1slWUQhYfSX9pLW8pPG2ub0kup9hYTF2pijD8rE2Jvb7cGUYRSN20F
FXVT0AIuRHBDjIo/iSsXUhaoKxNiMBFNSQomLrBGe4m4UUnAGpXoeTxD4uLN
937fO/POmTNn5t6+HVNjkzURcUZrpdaNVRHTrRF/63nj1ojPO3W2IuK3uoir
Wvtks1Tn9+e1v78t4l2t57TvaY84LZ9jsq/WR4zL5ri+j5Qitm3QnS0R/yjI
Ln0/pO/VvJP7fpLNjk777CpE7CzYbvuaiLv0fatAnihGvK31fVPE7esjjmg/
UquYuve8vl0PYyeHi7LvGIhYq/WG3p+pczziXk38S/nO87CeK2Rbo3VA9m81
2G9f2lczd/ya6p07ufa2O99rwni902fYXk770VbviQ9PH3aaq5Lw/9ofURb+
/asc82D4vH/YNnA4UTAnPyi/H7XuVaxxcfle0e8ttbaD50XlfKgx4j7ZXBGf
P5fs/4HiXi6Z061rIxpvi3hYdViqN9fw/KKeLxQcl3dsX9V9E42OTdxin2tM
vh+pLk/o/aDOZxv9/F2+lVbnzF3Hiq4TNSLXofXOFx0s5J2f1XqPzaG8C/wz
WTPq0yw+CsPGeKrGeWJDjeD22azJt1mX4dURf2ldW2nuyBPdoQt0Df5Krfdg
5g7uol57Mi614Bw77GfE+dHuiHm9f9GsmmnNCcdD4vIBrWbltFExywVr9Q7l
+tVQxJjsaxucJzmC6Wz6ggndUbtHBiMaOiJO1hg/PLB/VDHLXcZWls3ooP0v
pybBWhw2R/DzXbN5hKPq/zS+oPpf1BotGMNccti8RTpZZx0tZU8fTg1Qf3yf
VE+MlczfqfRbjtRPnfOgJxebnOfypog/tPau8oLT5eQWXYC5RXif6nTttuv+
bb325Rw7dHhU+nm9aH183OI+h/9LjeaV2p2Rts91ufe3iPMT3T5jHpST8ymd
j4u3sXrran/22i/S5Jvdrs+exEpccCymPqnz3sQPH/jDCTV/MOtOf9AnlfQ7
0Oz3xg7XlTrObxamzT57WvnO9jqXb9o9Z5mx4K5kXtSH2MQtp4bI5SXxMVt0
fvA4k7ksJPdgXq/759YYL/k9PmB/ehONwPkr0mYMmIsxYawMWtcTeu4etI6m
u8wdvOFXyb6mv9lzz4WSZzSaR//9q62RSsFaAxuzrZJ7dDuavlN6TrY6X2zL
acMMn8rfIPoAGzh8R3kf6fNsX2oy7/B1T0/E3VqTWUfugTewgAlsfGO/nH09
lXFv5gOX6Audwfdwzg+0Xs5cuGc89X48+4Q9eriyzr30Xx/pvmqrcVKHw0Ou
RTm1TY5TaUNu6PeTNmuYOXopZ+l8/rbxnXqfTmz4LCUnOwfcn/Qm/bSwydx+
WnRv4HundPj1kO9lJtEnaK2aPIPztaK1RRw0ga7AfL7Hsw8s6IC5cnMGoFH4
ZNbCF3ioAbOY30lqQx8wPxezR9Dn2VusezT/pfCcGzLvF4T9ZI9nMTnOJg8v
F50PuWxMfRGXc+KCpZqc4Pen7hlpc/36lPuuQePmf8RjqdVKyXoi9/f13L3B
moKP6eTkX5FnYkM=
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJw1lmls1GUQxqelp1Ck3Z7QQgvbbUtbTZACQtR4JHJIr0Q8kKvcVYqhFBOB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           "],
           VertexColors->None], PolygonBox[{{7311, 9843, 9842, 9841, 1230}},
           VertexColors->None]}]}, 
       {RGBColor[0.4576247126324139, 0.3429190042414444, 0.7602272104270383], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmGtwltUVhU8uJCb5kiAxEhECCSGEXEYF/dFCraDIjFVUwLaDWoUqiRbE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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHlwleUVxl9CQiAJEBKyJyT3JiQhNyBlFaHKUsYKCI4LWhZZFQfahCmb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           "],
           VertexColors->None], 
          PolygonBox[{{9409, 9401, 9400, 9347, 2512}, {10563, 5132, 828, 
           10560, 10562}},
           VertexColors->None]}]}, 
       {RGBColor[0.4904664551588967, 0.40002192508973333`, 0.806390252512446],
         EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmGtwldUVhje5Q3LOCTmeGjSYcAIhkMRaKaMlVECtSi/2IlVbBR10Johg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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHd81tUVxq+QASRI9p7vG7LeF0UQWUFmXQTQVhRlyAiCCgSUpVYIRUgY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           "],
           VertexColors->None], 
          PolygonBox[{{4495, 7588, 7587, 8134, 2071}, {9951, 9932, 2849, 9969,
            9950}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.5233081976853795, 0.45712484593802216`, 0.8525532945978537], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmGtwldUVhjfmnJOc5BwTctHEBExCuIwnJzrISChQyoyk9vajHUQ7XkoJ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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHl0VtUVxS+QhCEJJiSBkAQyfQkJSQDrAKI4VERQoKKIAwiUGQUVLYii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           "],
           VertexColors->None], 
          PolygonBox[{{11186, 5652, 1094, 10760, 11185}, {6897, 5942, 5941, 
           7523, 1666}},
           VertexColors->None]}]}, 
       {RGBColor[0.5561499402118623, 0.514227766786311, 0.8987163366832612], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl1lslVUUhY9wb9tbeukEXKptsYNXsPdWHGJ88EEETEF9sNDiFDWg4hAH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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHeUVeUVxT+cgSmATGXqG4YpD6Y8BEUFNbqAwSgRiCjFFgsCQgKKGoqK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           "],
           VertexColors->None], 
          PolygonBox[{{7159, 6895, 6894, 7161, 1708}, {5173, 6978, 1684, 7157,
            5172}, {7062, 7162, 1708, 5192, 7061}, {8812, 7062, 7061, 5193, 
           2327}},
           VertexColors->None]}]}, 
       {RGBColor[0.5823272387940917, 0.5573000257972879, 0.9099206295876798], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl2ts3mUZxu92Pbxv2/XtSra2Ww9p17dr0r4Vwg7GZIh03aEziEvamHhi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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHuY1mMax59SW1PNqKZmappDM9PMVDMTSkWOWyqJSpZYG0qUXFdFUUIO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           "],
           VertexColors->None], 
          PolygonBox[{{8141, 6878, 1665, 8156, 8140}, {7060, 7160, 7159, 7162,
            1695}},
           VertexColors->None]}]}, 
       {RGBColor[0.6064735188638946, 0.5960963790955683, 0.9104710904017123], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl1ts1GUaxr9OmZnS0qltme20dFoH6FTtFGxia2pwN7QaQHRBs1nPihhN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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHl0lOUVxt+wJJDN7AkhyWQmyUyWCYggyqYiSMJSAmp7QJC1IItHQEDZ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           "],
           VertexColors->None], 
          PolygonBox[{{7126, 7111, 771, 5006, 7125}, {4354, 7949, 7948, 6896, 
           316}},
           VertexColors->None]}]}, 
       {RGBColor[0.6306197989336974, 0.6348927323938487, 0.9110215512157447], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl21o3eUZxp+k5rw0OUl6TtOcvHtOW482iWmwDIZrXRMxkiY2jrJhB9rU
KVRdx9qmMNhcEcY+lH1oxQ+bU2t9aWSFTVthCiKbWTJlHwzMjRQLdmzCBlpL
MyZNy3b9vG7pPjz8/+f538/9et3X/ZzK3u99Y399SmmkLqVVeh7Ip9TenNLP
9OPNckpf6U3psWxKk1k/NzekNNqW0lCvZb7WndKFVp3JpHRyY0ovaj0nXfm+
lGZ0/qjkDzSmNJ1LaasM5Wr6plXTXkclpbLWbn3bVvV5zj4rXR+s9tk3Gmwb
uw3y6zbZfEJ65jpTWuxJ6XHJTml/p9aIfN+k/Vu0Dmn/LZ2Z1dmxG1L6h76d
13pP7+3ya3Ewpb2y+4rOLRVS+qXkHtaZH8nuimxcko0ZPafrLEcM+N92U0rn
5OsTyfrRva3ez2OrLDORtd9DWh9tSulDyW/St4Wcfdyj94PSd6jRZ1sb/Lur
3nu8s3eX8ryuP6Xjkv9WzvrXS2ZXzjKcpVZPrXItxptSuifv7/N6HtFeY71j
u6r33XovSb6odUUyY8r3x6rTmL69kbEdbDxaTKlasfw1/f5bxuf3y5fvrE9p
n3QvDqT0bcndU3BOyW1JMovK/cPSuUXvb3ek1LQmpcN1rt2nWdf3SZ3p0Dqt
GB9qT+npDT7PmU+ylp9Qzlavcf6frtlX/CxId732P5RcUfrXaPUGBsAUMXe2
SH+L30clP9Jn21/Xc3ufbezSs1++zuhso/TdLxw/KFtrm52jJBw8qL2TNcc/
pVinu53/gzr7205j72XZ+Ux2zmn/Pvm8RfEcVz62ypdR5fhynXHMOxg40WoM
gZ862d1+k7H+x5xx93fp+a90fzX0jMnuMz2u43CDsQWulrX37x73RkZ6xoXn
jXn3wXxgrFM17KoYH1PS9wPleUHfPm6yDDqPBbbAbbnZuAI/9Ouu2Ed2IXSS
g51F5wFf9uSMdfr43QH3Mja3dtvu+WZj8qnAFhjboLO368xW8qL3zerHPw/6
dznk6YXleueX3D4gnb/pNZbhlb09zuuVVdZ1JBmL6OD354pjJWec0yMHQufB
vHuLd3D8CJxQ737fF++vVZ1T8klu9kYe/irs/0Xrx3ljItvgvnhfffrQeus6
lLct9PxK2Dlds73h4ANiL622TnQT/1D4/5H0/KTfMZ3T+2ivsfXD4CbewfXV
6OulestyFt6aDwzBZ/QtcmPSs9DhvD8uv94OmUcV4z6tUv56PJz5ksuId3+j
a4zvryvn/YPmPOq9OXyGSzgHnqn9cMT44s0pvXCz6wBnwxHwA3wM12BjKOqP
PPzFDCFv5O9g1GuLMLWz3ZiFq8bXmgfOZY0PsAHXo/ti8OdMcOOfdPYW+X13
wflbiT4lZviAOfKs6vOM1h2Ntg8O8IHvyMFF/7nBuSbenwr7j1R99vbwn31k
14Y8OF2qGqs7ZHu8YDl4Co5Dhl4CX/T7nLDd0GcbmWbnipzh96GYBe/Kx/dq
ju1izrOJeOe0t7voWh3N+By5eEl4/KDNeIRLljvNJ2CcGOFVakhs+N8uW+sK
/t2onDVXruObJ3h7XrZO1Pw7nzePEs8OxTpZtV+nWtyz1GaglNLvKrZHL8KJ
8OE72jtecwxP6jko3w5nzIFglDo90O0eAPPcB+h1+JNZOt3nd+4dv6+4bnAV
NQe35PtY8Ax8yGxgFpTVWx1aU03uEWY/uF2Wv5fD75HgUOrDPvEwF+CVyagj
/ASvgU/mWibuJfNxFlvcL26suM+Z4fQhPXhNtXhOuCwXrG9H6AR/nQXPnRP6
/vyAfzMjO6Iu5J7akH9qdSrynA0fmK1w3fm4E6zIhytai80hGzGCbfwGw9R9
tsX6qNVgyfUi7/QM/bKUcY9djF47Gv1WIcZBz/ON8uudmvsfLPeWjOdZ6Xyl
Yt65U30x2Wo++zV8XjFnLcbdjfsRc3UuZuut0vm+8jAR2FwOziOW2ahLVrau
tZoPJpp8B5qO/jgcPjPnB2LW4/dM7IO7WwN71AE7zLXLkSv049OemMsvB04+
i/tbOTAAHngHg+S+Pfa5Qz1W9D3qNnHwqbLrOaH37/a7B7tafF8BM2cU61mt
4YL5jye9DyauxF1iTvn+g9a9cd+ZitwxNy60eR7An/ApPNYR+vGBGTtcNpbR
Vwz8k+t83L+456KbHJ6qeCahE+4/Wzb/408p7pD40BX+X435hK0j8d4YnJYN
XqNuYI7czkZ/rQuO3BH5H40e3hD3k/HYxyfqS54/7/FMwh/0lUMnvdIe/QKP
gDswzP3o1ao5F79XIp9wNFyA78TE/Y/5wkwr/t87MuQK7vlXyfxTjLsiMsTY
ED0IHuAYevCfkr23anv4RKxguE312t5mzHKXhePgZ+684ANsMCOZleSA2fHC
l/Mj454Ew7t1L75vo+8UZ1Sv1yrX75L0FrhlLnGeufPzrpR+oXWS+4Ty981u
8wD/pb5fMha2aa+937a5t8K9X9xjMz4H113Kme/xYV42F7SW9HtAeT7T6jlP
n10KGf4vjrQZl8RJvOSQ/4uH1zhvX8y0nGOvk74Lm2x/KO4czClm1umYW9zr
76iaz+itvkF/g0vBKD6/rjvv2Q3+/wdH4CM8wr11Mv6nvSpbM4PudfLBjCcn
9O798T/of5Xd+r8=
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXd0luUZxp8kkhBGQsZHFiH5sr4kJigCdbBkCSorSNtDrLIEJQqVEZAp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           "],
           VertexColors->None], 
          PolygonBox[{{5940, 9334, 9333, 6911, 1170}, {4993, 7068, 1699, 7067,
            4992}},
           VertexColors->None]}]}, 
       {RGBColor[0.6547660790035003, 0.6736890856921292, 0.9115720120297771], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl3tsluUZxp+WU/u1fF9phR7SWvu19KtQMHOEQl0EJm5LlMIoim4L7cyY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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXd0VVUWxg+dFOClvfSQ9xKSvJcER8VCb4qNorEOMDRFFASXNB2aoBQb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           "],
           VertexColors->None], 
          PolygonBox[{{4494, 9861, 9860, 7593, 424}, {6853, 6004, 1848, 7633, 
           6852}},
           VertexColors->None]}]}, 
       {RGBColor[0.678912359073303, 0.7124854389904096, 0.9121224728438095], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1l31sleUZxp9+n9OvUyg9tNj29PScnpYCi9tihkEYmBiHlM3PSTZNnFmy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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXl0lUUSxRsCWSCRbCQkBJK87Akq6qAiOzoigqKAyjniuIyOKAx4REQE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           "],
           VertexColors->None], 
          PolygonBox[{{7897, 6611, 6610, 4297, 1964}, {6817, 6580, 1628, 6826,
            6816}},
           VertexColors->None]}]}, 
       {RGBColor[0.7030586391431058, 0.7512817922886901, 0.9126729336578421], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1l1tslFUUhQ+d6WWmtJ1enZGWgWIvCE2ABxJvUBIVpRRovSREiImYAAHE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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHl0VdUVxk/mBEjIe3kZyUDGl7EFbNWiTBZFCDhA4rBKuuoIyLgqIFoQ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           "],
           VertexColors->None], 
          PolygonBox[{{9398, 7321, 7320, 6024, 2534}, {7614, 9832, 2820, 9831,
            7613}},
           VertexColors->None]}]}, 
       {RGBColor[0.7272049192129088, 0.7900781455869705, 0.9132233944718745], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxVV1tsVFUU3e20nVdn2s7Q0qG0Qzt0pjpTwCAmgPKIiDwE4gMMCImSyENF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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHd0lGUWxl9IT0iZySSZ9Ex6MjMecMWGK7HgQQErQUFgjxWkc1aKujTF
pahLFbAggggWkGCBBVndA4YSsawQRXSlSA+KwqrsEsL+Hu/3x3Pmzsz3ve99
73vLc2/o3pG3j2jvnHu8nXOxfJ4pcu7SSue2JTu3I8G59yqcuy3o3K3gXeS2
iHPLc517BZxHfq3UuVNR534EK5Ezypy72e9c7xTneiY5Fwg51y3LuV7I9YnO
ba+wNbXWNtCe5y/h/z+AdsjTeH4xny+CvyJn1vAu6An8YG6Jc6+C5WAO6FXl
3EAwAPQEVxQ717fauU/Z/yQHiyl3bkq2c5NBe+Qm1v1L2LnHwA7kqznH2YBz
kQ7oEO/cx7x/gHUW8P5Czt+Hd87w7mlQjxyLHXqhdwL2SQKF6DAD3aeDAuRn
ePdR8Ah4GnTmDJOwx2PoUh/jXHI+emHjLaw9EoMXsO5s7DgL5COvznRuMPsM
AquQ09Hxetaexbv3ol+Q3zbnmrwOe37DejvBx2AvuKLWuXnsNxdcjvwkz7/M
70vAVOQo641lvTEggnwO/Y6Bo+B/4EwGa+TxLjiNvI13hvPuz+xfCiLY50/8
NxCEkT/EHv8M2n93csZfsc1QUIptRoNTpXbHutsfkXNZ7zzn/xfnX4/+zxbi
e2AKmA+uQ4dX0X05uBb5OfYZwjsPgUXIiei9hXNtBgk6Bz4xA0wHD4PJ7HE2
x7nfwCTkV3hnHfZ6DyxDnohuc8BsMAEcYd0b2bc7OIzco9ZsKNvdVGu2Hcfv
YzPNxveyx0T8ZQK4B/k8ejZyno9AK/LeArO5bP01cgfZm3PMwD7diYE9/J7L
XkHwFfJE4mZC1Hz1eXxuEzpuB9vA+6ADtl2Lb1yUytnjnPuSc/TH7vHY7hli
NpN9H/Q59wDwI9fgc1eBLqAajGf/mWAGGAdG8Vw650gDI5EbOEcV56wEa5BP
cIY/o+9C1n8u0XQ/yW8r29sZ4pQLsFsyd1uCTi+RKzZi6w1gcaXdrUO/XQl2
x+ncQWdwCUgD5ZwlwLOZoAy5T8BiXLFdj/wTnzcQR93AqRq7y2vZ75oKu9N9
xEg8tosD3yF/kmM6aO+dyD3Q9YT8iL3XYq+qHNtTe1UiDyLu60Fv8CA4lGcx
pNj5XjI+tQI7/ZZoPr8xbDGq2NyAfHOF+bh8OxHE5ViO+D035Jjv1mOz3iHz
4YPgfu7sPnAAuY3nfLyfAc4jb0HvtaABbAYfovtDfA4GHxTaXRznvUWJdifN
leaj8s3dyOncxxrOFkk1H+mNnq3sdQ7cgXySc12FXbuAFuTh2HWF9ATDkN/l
vCdY4zh4B7kRn/0v5zwLPkJOAyFQAlLBQvbdylqNYAHyO/jQMPx3KHjbZ7lH
MazYVQ6q5gyz2PdvoAr5YNh0lG4HkHvm2R3pbnp4vj8OeWyOFwPFlrOVqzci
x/HOafb9GcQiZ6H35+w9Pg0firNadRy7Hiu3mvV3zhhPPYgD65Hn8tmHuKsH
c5Ab0bkcny1TDPustp2UrQJW455VbeAzDOYHLHds92qXcsiNnGsXen0Buudb
blVNUC1QjlVsKQcq9ynGnmSP13h2JZjqs1wyhfubHLGcMhmbHaqyXKCa0VBj
OU65bQ04jZ6XcO+N+N4H7S3X3sA5y5It53bl3Js42/vgauTrwubz8vVrw7aX
Ykaxoj1bi6ymqJYoXu/CzkvR+2VwJ7Kfd9LBU8pfHazWfcl+zUGreaotzdzT
7jyrMQ9wzoHo96tiI9Fy43x+m1dqOVK5SXeou1OO6o8OudghhmeT8N98rY+d
mkEe8mTu9gjPbUe3Wu74mmzzIflOHfINnGMqez8BuiG/zZ22qcaAtdXGTRKw
abzfOMqIbOME4gLDFdfovID3fiA3z6Smbs0ym8lWjVmWe37lrn4pthz0PbpW
8FkODiLv4lyt3NuoGMt537LWfu5+H/gGeRF6dC+1Wp/BM3Xo0JG6eg9psonz
diuzGFTsXY/ciu2OgaPgHBiWYzlBuWCozopdJrH2RPAE8kTOWMceXcEE5OaQ
1XTV8t0hq53TuatpQauhsuVRsCTFbDqEc40DY8FDIJuzOPzsAmtlBSy3j+CO
hkcsx//Mvu9gt7fBT8hDA1YTVQuHBMx3dCadRT60Ejtdhe2vxB+6gH4lloOU
e/qCRvap5b0a8BFygH0u56yXgcyI7a070V1Ih+HE4QX86At0j1D/VnOPFzhb
G1hVblxAOkkXcQLlgi9Bs5cTKrD/Kp5dhO0XgAh7nsEep0EY+Q6f1VTV0tt9
livSvdqlnLGXu8vLN18Rh1Ot6cn50uKs5uzCRrdUGDds4c5Lee8a1qkDoVKr
1XvY56tqq9nKTbkg6OUoccuYoNUWccxOrP0xdmoCHf1WG/t5tlONvIk76yHf
xLfSQA33sh+drkSXmATz1fFe7ZfP3sa57gf3gVuLjBuIc4triyPs9zi1uLR8
WLrJRmFPR/neXI97ywfF9VvY7/oE4/zivuJg4l7iwPL1Smy+MNV8fjY+fYjn
N3F3fp6/rcJsJlulcN6skPUM6hX6gDEZ5uPy7YeRV4Hl3OMr4M0MO2u1uH2C
nbkz60+KWq7Ymmy5aYjn28pRAWybhA/5uL8fnOUK+aB8TzljfaFxJHGjdcgz
M6xmqFbMQF5fZjaU7dapT2G9PNbOBS8gr4wapxKXWoHcVmQ5VrlVPnucNX08
1wF/aRA/iRrHE7eTT6oWqaaqlqomyba9sPEdKWbjQ+wzq9JsV5loXFg5U7lS
nDiNM9yNrp+nWI2Q7z/COuOLLAae5nMO558NnvJ84THkR3PNJ8TFR4IRHidf
4jPOLK78ks98UTV1veeT4sbivOK64shT0PUw9744xXKM5DT0nZdsv+3n+xus
VZdsPVZUHJR314CIz7jSxazbqcQ403Te/ZT/1uEvKSkWS+Io4iaKKeXmJJ5N
LLEc3VJtNUC5/0S19YYtPHuiwHpEPza6QF5oA75ay53NXq5UDq3Djhlh6wVV
88R144Pmm+K8K/j+Ar59MtZy2uhay8nKxaNqrZdTDVDuV093TpwiYlx5J2fo
yvqpZdYLzIwxLvUG771ea5xKva96CvUSL3q9qnxOvqaeVdxNNVq1WRzu9Qqr
Kaol4ojq5WRT2VI9nXLbP9B3U6nlOHElxYB8X5xJvbVyvnK9euyKGuNE4kLl
NcYt03g+mmocU1xQnEhcSJywqdh6ZvXKuiPdRZrHFXUn4p7iSOJG4qDibspp
ymXicG+h0+oq427y8c/5/WLe7QQ+Q77M00m6XFpjudYXNi6inKvavYP9CxOt
hqu3Eues8noscTNxfHF7cbT/+IyDi3uf8RkXV0+sXlic/Op86zHUW/wRObvK
eir1UllVxmU/4b+d2cZp1YuoZ1evrp5kMOsMAkXiZkkWe4q5p7wY7Bu1GqPa
clfUakGL56uqCfP5bSPYAOZFjWspByr3iXMpVsSBxH0UM5ptlHG20jybcYjL
K2cpV4nTqxfRjEazGfUk4kIDsfuAWuNEs7HJ4mKrFZ/FWi+iGFFsqCeR74z2
fFs+JFtPq7RYlM3riNE8zvILsdCZmMlAj8Xc04sgHTkNW/jKbBakGYZyj2ZI
mh0pB+nZBo/b6h3NdtTjq7fXjOci7mkZ51oKosgF7FWYa7qq/1Vs6xn9pxhX
r68aodqgnl9c8mv8bk/AOKV6UdXkkNeTDuPOF2Za7RSHFvdSj7Xb42BvBo0z
iCuohnVlzUF+m3WI84lb6U51l79zLHykK/9/j24dsdEanm8A0zS/IebSkJeE
bPbxKWu8hY2a8Jsd8iNkv2ZeIcsNeud55BdCNovTmrq7XNYP+u0O1cvncPbs
cuvp1buJ44rbqofzl9me2kszOL27xes1tYZq8WGwL9ZqsnxJd5ju+dT2GuO8
4rrbaozL/5vPb2uM06vXPA6OeT1nF79xPnG9MP7QhF4DIsbttUc6+16Ra7ZQ
TdDsr9XjupoBJvLfW0Hr3VWjlWtfCtjsTDlXuVs9uXpx5fAGL8cqtypHDWCd
vvhoWYz5pHTTDEmzI+mo2ZZ6zh7ejEu9pu5AtlfP2Y53j2QYt9QaEWI2WmRn
Uc1Wr/GsN6tSz7GMmF1abbX4bKJxAc3Iwh4nUC8vTiEuoZ5etVkcRdxENbof
31MzrZfTzFK+oJmVZlXyCXFb9QDi/uK46pUUc4o19Ux3s8ctpba3ZkLqLdUz
b/R6TM3qRoNR3syuT6H1oOo96wuNaz/jzSrFufWseir1UnpHvcEmbxalHkGz
Ms2wNLvSzGxfoc3QNDv7TrML/G1ImeU+zYzE1cTRV3mcTbGoGYJmB4rJxwts
pqVYFodTrKvHUG+hmFcvcpmX+9WTDOasg0qtlxLn1ax6TMhmVZpZizsoxyu3
d/J6FfXE6oXVs2j2oxqj2qIZkHxZM6dTnk+r98/2cr1mAJptiOOJ22nGsYNz
9iu23lYzIuVqcb4VXs6uBquDxu3EcVQrVFNUS1QzNNvVzEizIs14+xMrAyqM
66pmaBY9uMpyh2bS6uU1w9HsRj29aqNmSpolqUZqNq2eSb2SZtSaremOdbea
sWl2oRhW7GqGIa6hGa9mu+Ic6tXzfWZ/9ezigvO92iNOONLjgOJ+4oT/Bwen
o5A=
           "],
           VertexColors->None], 
          PolygonBox[{{9239, 6933, 1135, 5772, 9238}, {6025, 7647, 7646, 7039,
            1231}},
           VertexColors->None]}]}, 
       {RGBColor[0.7513511992827115, 0.8288744988852509, 0.9137738552859069], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl1lslFUUx28Lw8y0dIApHToO7djS6ZQuBhUfUBPUBJE3BWPiglFwVzDG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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHeUVdUVxo8gMDO0KW/6vOlv+pAAakRRBAXEqCuCQsC6wEoVEwFRuqhg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           "],
           VertexColors->None], 
          PolygonBox[{{5095, 7465, 7464, 7449, 805}, {7917, 6919, 276, 4314, 
           7916}},
           VertexColors->None]}]}, 
       {RGBColor[0.7741859717202453, 0.8508512751755771, 0.9088543830241173], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmGtsFeQZx98Wej290fbQ0paWc9rSQA91tuoqjmIwGuO+zGJbaLKi3ZTs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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHd4VuUZxt8wMgArGd/3ZQ/IIBMVVJQyBC1Yq7agBLFWpAoqCAitLFsZ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           "],
           VertexColors->None], 
          PolygonBox[{{4311, 7912, 1669, 6913, 4310}, {7415, 5839, 5838, 7056,
            1692}},
           VertexColors->None]}]}, 
       {RGBColor[0.7958709700567304, 0.8580826443035522, 0.8991395232020065], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl1lslWUQhkfac9qetlha6CK1ciwHl1MXUDQolESJYoy4oIlGIaIslbqH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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHl4VdUVxU8SEzKpecl7ycvLTPIS8hICKEMFCS2gxVoh1SihqJ/YyjyK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           "],
           VertexColors->None], 
          PolygonBox[{{6915, 5769, 1808, 7372, 6914}, {7434, 5858, 5857, 6976,
            1681}},
           VertexColors->None]}]}, 
       {RGBColor[0.8175559683932153, 0.8653140134315274, 0.8894246633798958], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl21s1mcVxk9b6Bt92vKUl9Y+7axdV7Qtc/KybIJZgJpsGVKJZVvcoBmD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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHl0VtUVxS8JgglBky8zmcmcfGFQwQFYuBSwsIqAS4SoWMQyiDJjZRCt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           "],
           VertexColors->None], 
          PolygonBox[{{4672, 10129, 10128, 7483, 490}, {5777, 7376, 1672, 
           6925, 5776}},
           VertexColors->None]}]}, 
       {RGBColor[0.8392409667297004, 0.8725453825595024, 0.879709803557785], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmFtw1dUVxncSCDlJTnIICZ5cDAYSEiQnCK2COm1RuYiD7UgVEKGADGJL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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHl8V9URxS8JBEMSDFnI9kvyC9khQcDK4kKhEhStilGQRWWru7KDCpYq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           "],
           VertexColors->None], 
          PolygonBox[{{9103, 4866, 4865, 9121, 2416}, {4469, 8037, 1673, 6931,
            4468}},
           VertexColors->None]}]}, 
       {RGBColor[0.8609259650661854, 0.8797767516874775, 0.8699949437356743], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmX1s1tUVx+/TF/r2PO2DbWnLS6VIW2pb0SjyZmBOEKZGHKC8UygFZlQ2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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHl0VdUVxg/JC4+MJJBH3gvx5SUhcyJDmFEQhCQFlkhQZkEh6EKQyYKr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           "],
           VertexColors->None], 
          PolygonBox[{{7224, 4840, 4839, 7223, 1714}, {6405, 7622, 1845, 6001,
            6404}},
           VertexColors->None]}]}, 
       {RGBColor[0.8826109634026704, 0.8870081208154527, 0.8602800839135635], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl3to1lUYx8/Wu73bfG1T021mu7h3c7UtLQ0vOCMqjUxtBuG8pxZmF4eB
WVokpH8ECf2R5ZSkCUWRdygh/UvL0oSiNK/Dv2JFFEWQzJx9P36f6I8f57zn
POe5fJ/n+Z7z1i9bPff5wpTSrQUp3aTxi9tSeroypQnZlPq1NkabM7U+oSWl
8fqezaV0uTGlpoqUHi9LqTSf0pqqlBZLZqx+/12c0itFKa3KePxZ6+/VpHRH
fUpvSOdpnT8z2PJd+j1PNjL6+oamNGlUSrN0frlk5pR5/6h+Pyo9n8u5R5LH
WRo7tHY85hWSeVW/f9F8Zsi2I1tumUXJ8SAzRX7N0fqL8mGl5l2y2yrfukpS
GtyU0lOK6y3ZrpVMnb7nCq3ju9BzfVBKO6RnrH4vTPYJHza3pfTQsJSuSv59
xTtOOt+UzSU561ms8Wv5OX+wfcf+uvDhBeFX1ubfJ4ptC5vIrA2swI15nbC6
LH2H9fVK5qK+1wrty1rFkmuyz+AAdmBxJufznCUnkzPOy1GNfVrv0bgla3+n
an0g9G8s9AiOxI5PzLF1JGRYZzwS/nwzXDE32K8u4bFzZErri+3jJa0tkPzs
cueA2K+VWxad1M6hjP07JT1PNFgnOCBP/D1Zn+csMdZGjgplZ/4I+ZMx3rWB
OWeIHQy3Rv31aX42Z1zA5HTMWafWyBM5Pdea0vlW5ww92EV+T5njJXbO/Rhn
J0p2UqsxpSYXRM0xXo0afUc+Zlp9hhrfEphv095FfW8XuAdaVY9fab4v8Kgv
sE1sgwmxESN1PkE6d6l3FkhuusYm9Wmt1ldVu6/QB16rIu9guDLm1OfSnDEE
tyUxX6P6nd4szEq8hr07k328pK9I/mRl90PZ+kB7Oek8Jp0L+ZS75hbr3Vvm
/d7oX/JMDezKWje+HI/8g3mP/D9VYU5g/2TWMk8qjqmK5+5i/2adXNDXCwPn
Peq7zUNdtxlxVP8QY0g/vVTifM2QjhnRp/eXKqbAmbEt5vNLPV8nmd3SuWmo
67dbXLdC3HhB+wez5ik4qjswIYd3qf9+qjHWYHExsDqgmA5Xm6M+0f6EBtcj
vXM5em1njbkSnoRn8Rnf8bWEfpKeP5ST3mbzUJHq6N0RruVdOtdT43qiXg5F
zXymtU9rjPcG5WW87HbK/xHFri1kvhTnF8m3cq1tL3K/4vNy+fy98qjjaXWJ
OZIauKSFxcONwbao2U59D8ufIcL2gOTaVYDTam2jP/bJaU52BlXbfrV8aam3
bvp7dvT4eMX0Q4vr+eY6+VXnfnhQcT/Q7NwvCnzxE/vMwQduXhY5wSY6MiED
z7EGh10LHmMcCPw7K+03Ps9VHjv07c2Yn66FDNjujd75705qDw4cCK6kR8kt
nLA179qlbomJXsUndM+rtC5yxT65GHeL4lOM7dI9qc49TP/21hh3MMcuPEW/
TNbaFH2rs9YF9vhG3+FHX9yV3Cv0GXk+mHeud5f+f1fTQ+XBUZzbGzwDrscC
W2Jib1HcHeAJro2qk/Y2+7S4wT1zo18Uy6bReltEPzHSU/TBRyPdC/RNd/QI
dnol11/od0FXcOPket8r5GFrgWuOPHIHk2/WwG8gZwzvafC7BM7PyIdDzZaF
L7kzyFcFGOSNAXzfEXieifuCWPcXWDfvn1bF+Ks4ZYXi7yh03GDSp5zOiHtn
aYM5iDq5Uux8UC/EQ9zIdwdPoBc9RwPDfYE5+aJ+twcuA1Gr1BU5xD6cwBuF
WOBq+mlj3j31cd5cA7bkljsVH6oq3M/08slR5inyfj64ANyulxl/8jBJmP/Z
6Dv7deG3Hk6WXKNqMl9nvmTtYpXXV6jGp7U5JmoQvqEOuZPBCHyGiY/nye7v
ZY6/M7Dl7sA2dnlvwhfk/1714sujjCVxcO5Q1N2C6GW+/tBzKe5Q8MWn+VFv
cGdH4P+b4ioY7Tipde5l3oQ7Am/84szVkIcLrgSGE7O+18H29npjCp7kF3uc
G6v1kVoXFDdqizcxeaCfqUFqCiyImd6aF/7DUXBzZaP5mbgfa7LtY1FDXdET
vBvoC/zdHr0DL7CHHt7RzwRvXOAeH+bzcOdfNeZPcFoYtUfeWiqMEX18X5V7
mXuSdy1YLNG4pcr2stJdXG0s6Lmzpa6fXXFXk/cZyt3SSueL+xIZcGY8F/Nl
2t+W92/Wz4ceeBn+4J0AlisCz0bhkW9yr5C78sjFP1W+w8rj3cS9zj3OfdIT
74RBqsP1o5xv7lX6Gx7jrVTV4PcSHNUZZ/cHv1AP347x/wTuP/7znAi+2FBh
roFnOocYI/D5F2AwyFM=
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl31sleUZxh/ox2nLKW2hH6df9LSnpfT0FAywwJiKwoRNZ5TWKEhBxGKc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           "],
           VertexColors->None], PolygonBox[{{6837, 6003, 1847, 7632, 6836}},
           VertexColors->None]}]}, 
       {RGBColor[0.9042959617391554, 0.8942394899434277, 0.8505652240914527], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1l21MlmUUx4/AwwPPgyhiCExFRFAB0dKaVhPXqpUferHcCpVefNlSsWVr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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlnlsVWUQxafQvq5AC5TyWqB9pa+UrhCWFEWFgKigAQokbMUNmhgWI0Zp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           "],
           VertexColors->None], 
          PolygonBox[{{8063, 4471, 416, 6851, 8062}, {6777, 7562, 7561, 7580, 
           1657}},
           VertexColors->None]}]}, 
       {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
        GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl31s1dUZx5+2SK/3cm/bS4GW8lZKX+gL6FqJmP2Dmkw2iEMxQVo16QyJ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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlEts1GUUxY+0zgzT0g4FZYbWvmda22mLUhtxY4pNFFwotSxsiyaQkKhY
jC8kqRZKfAVITGQhaogIEkAaCCwgMUbCa1M1BdxoLAnqgoUhiiQ1VsXfyXVx
k+///+53H+eecxvWbuwfmSPpWawUO9IgfY79yfl0SvqtwP8WaVuJNIx93Sj1
10lVnDvnSk/WSl81SaOcx5LSmXYp2SZdvk06Wk7crLSkQ9o/T3r1dqkb/6VY
kaQdCenDeultbCm5urH1VdIfeWljmnhl0k7y78AqOWewj7jvJX4Tsbfi/yB3
1zK8J99F3pyltmPYAb7foJ7BojSEVfD2BjkbWjlj+/jejxW561okTRPvR+z3
Znqi5ruJdYOernL/N/Vs5vtpelhGvgewQfq/QLwV4JHnzRf4XqeeucTK8uaH
8qi5D+zuwdbh/yb2c7X062JpOedD9L8VLK40R65x6m26Q5qkv27e92C/EO+D
YmB5nQEdnA9m1NNGPYfp8WHnvlN6nbv3iTdCb10Lotdd5NiWkzbUxmxGmWkJ
d5N8H+D7k1T0PkA9mxKBwb/EvoWNEn+c+k+5llzM6l7ue/GdBe93SuNNzaLA
0NgZ83P4nscGSoNDncz+JHjuA7tPsfVgsboleslRwzLm+Rc5HnK/1DOzUPqm
Mbj1DPX3c9+Ti17MmUq+Z4g5WSFNeebUOkT8AWItT8cspqhxSyJmYt9jxBtP
xZunqHWWN6/hm6ae2bvin8+OYewzzOC+8pjBBFq4RYzvebuQ/GPg9111zG4s
Ebk2MZPKVOQsUF+a/lrB7ho97iDeZmz7nOD4BPePEnNLKmp6Ea5O/1+vYxzH
91swWFsSGFsLN7EX0qEJa2sxVlsWGvsM35q20Io5eRysTmDzOY+A/07q/akG
TiYjx3A2OG0uG4MneDtdCG1bU5OcG6oCW+fYXggNWnvW0G5qeSsf3LuAnlMd
oXFr+xViXqWeK23BXfdQ3ynVdcYuMYZH8T+D9XEe4n4J3N1DfalkcOZUNjhj
rnhneBYT9bEbPJM+4t+sDq5bQ8/hn8T/ZXzfpd9ZsO9uDW0b8487QgPmvnPm
irEzvCus0QT3u3Px9iVi7GE2w7y/xPsT5CxrCU1YC57p85xH8qEd75wMsd7L
BNae0WlqvVwfXG6viNi7akPbznGpKXaUd5N3ZprvmcbAwjt2XnvsDO8Ka8K7
6Evy9aZjJ3n3rmyMXeMd7F3mnM7lndZFP49UBVetOWvdPbkXa95Ym6PmpjF/
nHir6kJr5sxh5tHTHNr0TjF3zHlz3Rx6LBM7wbvAO2IqH5wwF1zjGuq5vxC7
0Ria697Z3tXm/D/47s0EFt6pnt2GbHDHMxzMhqatZe+4I7mYkWfjHfofFG/u
ig==
           "],
           VertexColors->None]}]}}, {{}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{5411, 10974, 5345, 10911, 5326, 10930, 4347, 6721, 6740, 
           5935, 11308, 5916, 7518, 4493, 8112, 8131, 9170, 11140, 9151, 7769,
            7788, 6531, 11676, 11714, 11695, 5304, 10799, 8951, 8970, 5436, 
           9988, 9968, 9949, 10835, 10817, 4763, 8523, 4781, 8541, 8880, 
           11767, 4623, 10854, 4641, 9931, 9913, 10778, 10759, 11202, 5668, 
           11416, 6116, 8424, 10069, 10086, 7411, 9270, 5802, 8441, 5819, 
           9287, 5060, 7156, 5188, 6993, 8155, 6892, 7139, 7124, 4991, 7394, 
           5005, 7080, 6877, 8050, 8063, 4471, 6864, 9253, 8777, 8778, 8018, 
           8908, 11596, 4373, 8909, 5367, 8017, 8016, 8015, 5017, 6579, 6578, 
           4240, 9744, 9717, 9716, 9715, 4710, 10780, 5285, 10779, 5284, 9786,
            9785, 9784, 10333, 10332, 8606, 7883, 4867, 8588, 9582, 9581, 
           7499, 4328, 9791, 11289, 11288, 5897, 11793, 9868, 9869, 9867, 
           11355, 11354, 4910, 10349, 4911, 10350, 4689, 6454, 4690, 7731, 
           7732, 6453, 6452, 10936, 4175, 9727, 9726, 9995, 9994, 4646, 7326, 
           5680, 11213, 5681, 6597, 6596, 4298, 8619, 8620, 8618, 11807, 
           11808, 11775, 8621, 4680, 11567, 6327, 11566, 6328, 11568, 6250, 
           11528, 6252, 11527, 6251, 4257, 9725, 9724, 11489, 6236, 9723, 
           11358, 7675, 6235, 9681, 6234, 9626, 4520, 6777, 7562, 7543, 4519, 
           9606, 9625, 9680, 9661, 6233, 9457, 9438, 7809, 7828, 6553, 11526, 
           6572, 5364, 10014, 10033, 10052, 11021, 11002, 4665, 8403, 8384, 
           10254, 10273, 10292, 10235, 8901, 10873, 10892, 8327, 8346, 8365, 
           5392, 10955, 5411}],
          "3.5999999999999996`"],
         Annotation[#, 3.5999999999999996`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{9714, 8504, 4741, 7853, 9054, 9055, 5580, 8505, 4742, 7854,
            9056, 11804, 9057, 5581, 11175, 5639, 9763, 9764, 9765, 7282, 
           11268, 5783, 11267, 5784, 11269, 4318, 7924, 10308, 10309, 10310, 
           8562, 7862, 7863, 4881, 11338, 5976, 9809, 9810, 9811, 7290, 7999, 
           7998, 7997, 5977, 9345, 6411, 6412, 5987, 9367, 5988, 9370, 5640, 
           7291, 5643, 7679, 6406, 6407, 6003, 6837, 6014, 6863, 6851, 8062, 
           8049, 6876, 7079, 5004, 7393, 4990, 7123, 7138, 6891, 8154, 6992, 
           5187, 7155, 5059, 9286, 5818, 8440, 5801, 9269, 7410, 10085, 10068,
            8423, 6115, 11415, 5667, 11201, 10758, 10777, 9912, 9930, 4640, 
           10853, 4622, 11766, 8879, 8540, 4780, 8522, 4762, 10816, 10834, 
           9948, 9967, 9987, 5435, 8969, 8950, 10798, 5303, 11694, 11713, 
           11675, 6530, 7787, 7768, 9150, 11139, 9169, 8130, 8111, 4492, 7517,
            5915, 11307, 5934, 6739, 6720, 4346, 10929, 5325, 10910, 5344, 
           10973, 5410, 10954, 5391, 8364, 8345, 8326, 10891, 10872, 8900, 
           10234, 10291, 10272, 10253, 8383, 8402, 4664, 11001, 11020, 10051, 
           10032, 10013, 5363, 6571, 11525, 6552, 7827, 7808, 9437, 9456, 
           6232, 9660, 9679, 9624, 9605, 4518, 7542, 7561, 7580, 6795, 5965, 
           6776, 6758, 7987, 7969, 6307, 11635, 4538, 7723, 4556, 10540, 
           10558, 10503, 5149, 10580, 10522, 5213}],
          "3.4499999999999997`"],
         Annotation[#, 3.4499999999999997`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{5168, 10443, 5124, 10424, 10481, 10462, 4460, 7705, 4441, 
           11615, 6286, 4976, 6815, 6639, 6658, 5722, 11240, 5703, 7350, 4403,
            8686, 8705, 8667, 4934, 10372, 4219, 6364, 5519, 8227, 5500, 9011,
            9495, 9476, 4602, 8248, 6506, 4840, 7224, 6507, 8206, 8207, 5415, 
           8229, 8228, 8208, 5274, 8837, 4733, 6471, 4935, 11654, 4936, 4370, 
           4708, 11582, 4139, 5992, 11319, 11320, 11221, 5683, 11220, 5684, 
           7331, 7330, 4301, 7902, 7901, 5470, 11050, 9690, 7843, 7842, 7841, 
           8496, 8495, 4122, 4196, 7839, 7838, 8490, 8489, 4120, 4195, 
           11219}],
          "3.3`"],
         Annotation[#, 3.3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[
          LineBox[{7737, 7738, 7238, 11046, 8984, 8985, 8491, 10192, 4720, 
           8492, 5467, 11047, 5468, 11048, 4726, 9740, 9741, 4198, 4128, 7243,
            4133, 11581, 6209, 5476, 11481, 11482, 9695, 9696, 4134, 7251, 
           4140, 9708, 9707, 11060, 11059, 4734, 7852, 9012, 11588, 4220, 
           9013, 9225, 6258, 11529, 6259, 11530, 5768, 7371, 9777, 7910, 9232,
            9231, 9630, 7289, 4371, 9816, 8007, 5984, 9366, 4709, 6460, 5985, 
           9368, 5986, 9369, 5641, 7621, 5993, 7680, 6396, 7622, 6405, 9395, 
           9386, 4274, 6588, 6825, 7632, 6836, 6013, 6862, 6850, 8061, 8048, 
           6875, 7078, 5003, 7392, 4989, 7122, 7137, 6890, 8153, 6991, 5186, 
           7154, 5058, 9285, 5817, 8439, 5800, 9268, 7409, 10084, 10067, 8422,
            6114, 11414, 5666, 11200, 10757, 10776, 9911, 9929, 4639, 10852, 
           4621, 11765, 8878, 8539, 4779, 8521, 4761, 10815, 10833, 9947, 
           9966, 9986, 5434, 8968, 8949, 10797, 5302, 11693, 11712, 11674, 
           6529, 7786, 7767, 9149, 11138, 9168, 8129, 8110, 4491, 7516, 5914, 
           11306, 5933, 6738, 6719, 4345, 10928, 5324, 10909, 5343, 10972, 
           5409, 10953, 5390, 8363, 8344, 8325, 10890, 10871, 8899, 10233, 
           10290, 10271, 10252, 8382, 8401, 4663, 11000, 11019, 10050, 10031, 
           10012, 5362, 6570, 11524, 6551, 7826, 7807, 9436, 9455, 6231, 9659,
            9678, 9623, 9604, 4517, 7541, 7560, 7579, 6794, 5964, 6775, 6757, 
           7986, 7968, 6306, 11634, 4537, 7722, 4555, 10539, 10557, 10502, 
           5148, 10579, 10521, 5212}],
          "3.3`"],
         Annotation[#, 3.3, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{5459, 11720, 5460, 6467, 6466, 9687, 9686, 9685, 11045, 
           11044, 6340, 5458, 11719, 5457, 6468, 4121, 11576, 5462, 6341, 
           5464, 11721, 5463, 10194, 10195, 10193, 10197, 10196, 11049, 6469, 
           4129, 11579, 5471, 6342, 4199, 4130, 7244, 9699, 9698, 9697, 5477, 
           11449, 11450, 11447, 6168, 11448, 6169, 11730, 6170, 5767, 7908, 
           7909, 4304, 7252, 4305, 9227, 9228, 9226, 9230, 9229, 4666, 8404, 
           8405, 7744, 7745, 4141, 8774, 4143, 6334, 5013, 8008, 8798, 8799, 
           8801, 8800, 4372, 6421, 6002, 6932, 8037, 4469, 7612, 9838, 7620, 
           6001, 6404, 9394, 9385, 4273, 6587, 6824, 7631, 6835, 6012, 6861, 
           6849, 8060, 8047, 6874, 7077, 5002, 7391, 4988, 7121, 7136, 6889, 
           8152, 6990, 5185, 7153, 5057, 9284, 5816, 8438, 5799, 9267, 7408, 
           10083, 10066, 8421, 6113, 11413, 5665, 11199, 10756, 10775, 9910, 
           9928, 4638, 10851, 4620, 11764, 8877, 8538, 4778, 8520, 4760, 
           10814, 10832, 9946, 9965, 9985, 5433, 8967, 8948, 10796, 5301, 
           11692, 11711, 11673, 6528, 7785, 7766, 9148, 11137, 9167, 8128, 
           8109, 4490, 7515, 5913, 11305, 5932, 6737, 6718, 4344, 10927, 5323,
            10908, 5342, 10971, 5408, 10952, 5389, 8362, 8343, 8324, 10889, 
           10870, 8898, 10232, 10289, 10270, 10251, 8381, 8400, 4662, 10999, 
           11018, 10049, 10030, 10011, 5361, 6569, 11523, 6550, 7825, 7806, 
           9435, 9454, 6230, 9658, 9677, 9622, 9603, 4516, 7540, 7559, 7578, 
           6793, 5963, 6774, 6756, 7985, 7967, 6305, 11633, 4536, 7721, 4554, 
           10538, 10556, 10501, 5147, 10578, 10520, 5211}],
          "3.15`"],
         Annotation[#, 3.15, "Tooltip"]& ], 
        TagBox[
         TooltipBox[
          LineBox[{6199, 7674, 7234, 4118, 8487, 8488, 8486, 4719, 6201, 
           11795, 6200, 7235, 5461, 6202, 11575, 4119, 7236, 7237, 6204, 
           11734, 6203, 7239, 5465, 11722, 5466, 4725, 9737, 9738, 9739, 4127,
            8499, 8500, 7845, 11802, 7846, 11740, 11741, 11742, 4132, 9694, 
           5727, 11243, 5728, 9205, 9684, 11573, 11574, 11570, 11569, 5626, 
           11166, 5627, 11167, 5983, 11546, 6267, 8005, 8006, 7678, 6253, 
           6254, 11589, 4265, 6796, 6474, 10702, 10703, 10701, 5276, 10982, 
           5417, 10981, 5416, 8932, 8931, 8268, 5275, 8838, 4847, 9103, 4866, 
           7882, 8857, 10722, 10741, 8267, 8287, 8306, 6059, 9053, 5542, 9034,
            5561, 6383, 4239, 10391, 4955, 8724, 8762, 8743, 4422, 7370, 
           11262, 5747, 9224, 5766, 6696, 6677, 10658, 10677, 10618, 10638, 
           5232, 10599, 5251, 11398, 6098, 9891, 6079, 11379, 5579, 11080, 
           11116, 11098, 4821, 7223, 4839, 6505, 8247, 4601, 9475, 9494, 9010,
            5499, 8226, 5518, 6363, 4218, 10371, 4933, 8666, 8704, 8685, 4402,
            7349, 5702, 11239, 5721, 6657, 6638, 6814, 4975, 6285, 11614, 
           4440, 7704, 4459, 10461, 10480, 10423, 5123, 10442, 5167}],
          "3.15`"],
         Annotation[#, 3.15, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1HtM11UYx/EHdLZKS0EF+QFKpkAEQVsXKxtbXtKtFS5TWVbD6VwtLl5W
plkDbDrT5UrUtTZNU1DXqmlWGGJtMRyzuwKp4GbkStNFZWt2efHH28/3/M5z
+ZznHMypqJpVmRQR6/1TNDKiPS8imX5IL+EUnh4RkZYdMYfOL4x4NT2iMjXi
rYyIi2Mk07mjI/oKIqbSA5kRJWIv5ET8hy5MEV+r1orhEd3yN4yKyBkX8QIt
GR8xaoK++EvenX5frG5fim+1vqPz1H4G03FMzpJbI1rSIt6eGPE1XWNdy/ei
/IgquoGuwAHswEgec7GGv2tulk//Uatd/al6TrwpYhJSUc5rA68bef2V14/0
m8HjO/Rxule/Gh6fwEz8rv5ZbJXbbk5J8neIW+/cG+kq5DvbT/p0iCt2tm08
TtA7BcPU+HtsxDQxV9WuV2d1bsQmlDp7tXUNqrBm4G7U+Ddhtkh1jp/VT6G/
0NXqXdVnj7nsxlPm8iRe5/0ufurVO69uHU0qihiOG9Egfxi9AUMxzowOOssQ
v/eq24N91nvRhFXybzO/YhRigfpFtEz/WSg1t/u8lfFmONM6m95jfb/fZ1g/
iBN8Tbb+nnbiJJap28XfUtpNs+R10iXWJ2gNTefvpO9Me5PUnK93gr/tfBU5
YyEyrBfaT6DLXDtxSs4PeE6N0/R5WiI2S2wmdvK/C31if8Q5VIg5I7YHe9RP
6N1Ie/TtxVnk6nGY90xnaaZZ9FOaoEfpZwNvFa04gm/Ft7nLb+g0+V/4nu29
PYq5mIPHUG+vDlO8jd+s+7HQnS5CpTse7P6T1EvGCPeVihQ0eH9fme8mdzdG
TGJgjy6T05wV8az8z2m1tzbIW3zffiPe4+cT6z3+To7b/4CuFNNBWwe++ahE
l+9d6q3T54w+Kwf6WffgvL2TYh7yXeqtXqat9h9Q/xA/f3jru+nt1pfkVphr
Gc75vVevN5xlnP0W9zDolojROMhvG7LcRYX19bTfXPab2zz312Q9nW6hk+0/
jC7xFxBq3+19DHG//eIL7B3ga5/8FmzFS8682J3ORrO4l/U+To84x36sM7dy
80jnL4+/AvqIc07GFTN7V81jar5JT9NuOlbPNjqUNjlbA+qw1m/LcZSXK7wV
u9MsXIfD9r/EHc7xp5hr+SgVU4gMXFa7kddknjfT1/h9Ed1meRGzvbePvdkO
bEYtdvK+lPdXsA1reZ7J/3K6AMXOl43tcqvVPSQ+T812mu//mXsxGBl6l9E0
lPv+H5pY9iM=
           "]],
          "3"],
         Annotation[#, 3, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1HtMlmUYx/ELySZWSw4iGIKUCiEOdZktaWyFLrdS16xkWgubgQdAyy2g
rFE2rXS5hHStlpWnck0apWUjy5rhGNrW1mBAupopqbCZ0VoH+7x/fPk993Nf
h9993Q9v/vK6B2qTIqLBn2kZER2FEUn0UzqIXqxMjcjMjXiILpsW8WpWRE16
xFvjIy5mR1zFw5kRZ6dGlNO2nIjpYi/kR/yHbtwjvkmt+jERPfK3jI2YOFFf
Ov2WiIzJ+uJPebO8r1LzbJpntX6gS9RehXk4IWddcUT7uIh3p0R8TzdaN/G9
4taIWrqF1qMNu5DO6xRs5O/aSfLpP2p1qF+u5+SbI+5AGip4beF1K6+XeD2s
37087qZL6Qf6reXxEczH7+qfwQ65HeYU8neJe8W5t9JnUOhsv+rTKa7E2Xby
OEnvVFyvxl95EXPF/K32i+psKIjYhjkTIsY52zC/FXyPsr+atuqRYu9n70fT
j62/vSkiS+1s/Kt+vf6XzO5pOkgbaJ15DfCTKu88bTWDg9jARyZ/FfbfFjcm
cb/0RrqWHpNfR7+h6+hscf3m86C8VXyXm9NKOpfert4sFNn/zbsBzLSegWoz
7HWePpzz/jwKxS1Up99zH3pRps4C7+5HlXU1nsAK7DbjBj5m8pHnDLmoVuM7
OZXqT9XnMVpMlznnXeJLMQePy8uX10ivyFtq/7T3Z3BKjcP6naTbzbgZr+NR
M2+hyWLr7V9D96g9ku6lNeZWq+bXaq6mNViDTvc47B4y3Ed64s7dT7N5dqnx
stxk6wF9u/VL8Tzk+Qa6zV4WHa9nGn1K/SPueI2ZH6N1/IxQr9X+PhyU/7n1
Xt93V+JboI1iOunRxLNvqwbdnt9XbzMP/Tw00lPWP+GcvR/F3Oe5jOchetT+
3eof4ueKb3QPnWE9KLfSt7kIv3h/Wq/t7jPPfrt5jCiKGItP+D2OHHOptB5N
L/v9OGAuS8xnv/U8+gYttb8A3eIv4Cpmu8OR7uiy+CJ7bXx9KL8dO/CcM1eZ
2WIcEfe83l30S+c4gM2J7znx/8NfAX9FdKFzlmLYzD5S84Sab9I+2kNz9TxO
r6P7na0FL2CTd+vxVeJOnbvE70MOUvCF/ZO4zTn+EDOKjzIxxcjGkNr7eE3i
uZm+xu+z6DHLi1jsu/3Md92JZjThPd6f5P0l7MQmnufzv54uR4nzTcA7cuvU
PSS+QM0OWug35k4kI1vvRTQTFZ7/B6I+6Zs=
           "]],
          "2.85`"],
         Annotation[#, 2.85, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1GtM1mUYx/ELl4eiF544ieJZQ+xBs+mUeCxIpVzZpJIOL8w1y0No+cIE
a5hNV7gsD7CWqJ0UXctGWdmQ1guDCHPVCleW1aSZpkWFWS3r87z48rsP133d
v+v63w8jF62YX5kWEU/7M3FwROtVJvQteg5f4cEBERl5EXfQe64Wmx2xfFDE
C0MizuZEXMKdmRGnCiJKadPQiEKxZ0ZG/ItOlIivkWt1/4jjztdmRAwfEfEo
LRwdMWise3HBuWutL5bz1EBjuT6jC+Reglloc2blxIjmrIjd4yKO0fXmNXzf
nx/xEK2lq9GEXRjI61is56/3GOfpP3K1yl/qzjGjIqZhACp43cbrJl5/5vVt
983h8WV6N2103woe70UZfpP/JOqcbdWn//jdJe4pdW+iVRivti73tItLqK2e
x9Hu7o90OS4Oj7hRzN9yPyHP2vERmzFjWESm2nr4reC7r/2l9ACP/ex9b/36
XD2gf8p1AQnzKnet1Jt18qan+iJnpnuzcLM6BvM0l2bQnXLtUG8D7ZOIKHYu
iS71F8iVq09lYofQm2iBnnzuHUygLTweRjNa+fwQy4yX4ideG8ynqGuqe7Y4
O40+R6+xdtp+IZ2MSTjhvqT4mahS41pU41nxJ619h1/E/YqP3d9NS/Q737mZ
NIklYke4YxG9TS8eoB/x2YZPzat9m9l6sNh6g3r+ojvoRVos/+08zVF7GXbr
73zz66yX0+m0CDNwFxKpe/kolbsEjfzso6OsNdIsvdwgz1Hfos5b6LJeT/Os
b6M5NF3PtxtP9o3afaMe+qX30Ini1LvnNUl7+w59UOs7H1PHVuc6aC9rp9Xd
yUs/4/PGV9LN4rJojv4NoI/wcEg9y/j5gFaqJ03uA/b34HXn3zV/1W+kw/4b
dI2YdtqSGntHy9Fp/JJ8G91/wv1r6Cfm3+BHe1+ImWucVMd52mL/BvkP8vO7
ml6hk8zPObvQG5mHH6x/664teppnv9n3SJvgjeJNfo8gVw8Wml9Ou/Vxv14t
0Le95rPodlpk/xZ0ij+DS5jqu17mPXSLz7fXxNc+55tRh8dSb0HPynFI3OPu
7qCH1bEfG/WtIvUb5G8cf/n0VnUWoUfPXpOzTc7n6df0OB3mziP0CrpXbduw
DhusrcL7qe+s7oTfXC764T37RzFFHX+I6ctHUkwBsnFe7j28Bs9b6TP8VuO4
Xp5Fuff2jvfXjq2owYu8P8z7k6jHBp7L+F9F70NCfUOx09lKeQ+KHydnKx3v
/9R09EK2u+fRDFQY/w/v2fFD
           "]],
          "2.6999999999999997`"],
         Annotation[#, 2.6999999999999997`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1HtM12UUx/HDapJYCxXBlIvgJa624WpFc5VZVCv/IJNVS8zmuphQrpnd
RuF0hcsliHNt2VXKtTCVEiTLLQKZZdMIZ6bLqDkVDIvWsoxevz/efJ7Lec75
POf7/MhdXFNRnRQRr/hTlBbRlR8xMj5iJx3AETw8NiItO2I+va9E7MSIpWJe
nxRx+oqIC7gnPaK/KGIO3Z4ZMVPsqdyIf9GHm8TXyrUiNeKw8/UTIrKnRDxN
Z06NGDdd3WkRfzo3y/oSOfvHGct1kC6Q+xHMRbczNcURHRkRb86IOEDrzGv5
f6gg4nFaT1dgOzZjLK/TUMffxerU0PNydck/R82peRHXIBWVvDbyupbXM7x+
ot6tPL5D76Xvq1fN4/0oxzn5j6PJ2S59+o/fzeJedu+19BnMcL9f1OkRV+Ju
G3nMU/typMjxV07EzWL+lvsleZ67MmIdrsuKmOBuw/xW8j3K/qO0hcdkez9Z
v2GyHtDXaIG1k/bWG9fJuQrVxjVIUfMW/kYn+qRGsbVFak5xxyqaS39z/iz2
qv0FHrSeZ30xbaaf8pJOd9jbiVYMiN9OP8a2BPYLvJPL3PNL8Tnmbdbbcbfe
DIqfTzvMd+MrMZ1YqMYhvv7h7yA9T3cVyi1Pu14Wulcb7cBu1Mnxnf714nYx
t2GMXh/13cqMr8dTaie58x6ao29N+jRkfg6HnGswz7a+gWbSRppFz/IyiON8
HUOK2iec+Rn9KDA/7f0sFH+KPkA38XSp9ZP29/Ffrgff89Jj3EtneaulCPlG
nCl1v27fZx++9TZa+D1Ai9QtRiFmogT18qfxNQGn5T+DI3Im+YZ9NJkOWhtD
14lNpxPFptIn5WzT88fU3kuXeUOhVov9LfjI+V3m7/l97Le/ja4U00P3JMb8
LUWf8dvyrXHHo3q3kn5j/iN+tdcr5g7j2e41SPfYv1H+Vn5+98bfpVeZDzhb
5bvPwwnrx9RarydZ9jv0JXzz8djBbycm+c5V5pfQIT3dqp8L9LrZfC7dQMvs
34k+8adwAVf7vV7kPQyJz0+8I74+cL4DTXjenZfoWQXaxL2g9n76mXtsxRp9
q0z8/vibzl8+vcs9yzCsZx/K2S3nJvoDPUwz1eyko2mzuzXiRay2thyf8zLs
3iX+v0xCMtrtf41S9/hDzCg+ZospRAYG5d7C6wgPDfRVfp/F4cRbQEXid+mN
9KABtXiL9yd4X4WNWM1zOf/L6SKUuN9kvOHsMr1oFT9dzi46w/+oa5GEDLXn
0TRUGv8Po6b8wA==
           "]],
          "2.55`"],
         Annotation[#, 2.55, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV03tM12UUx/HTRbssuYMhWKEQaOBm04rFNHPSrPzDSpZUtDkTJcX8Q+0K
0jTF5UpTmxXaRdG5KMrKRjbbHIZYzc3BTGsamkmwadJaLtBe/PH+fZ7Lec7z
Oef3fHPmLH6k+qqIeM3P2LSI1oKIy6kRn9MeHMO85IjUWyIepbOLItbcHFEl
ZsuIiO7MiH48lhHRdUfEFNqcHVEk9lxOxH/owH3ia+RamhTR6Xx9esTI2yKW
0aLREcl57s2N+Nu5O63PlbMrxViuI3SW3JWYioPOVBdGtAyP2Hp7xI+0zryG
/zljIp6l9XQpmtGAJF5Ho46/a9xTTS/J1Sr/FHeOGhUxEYko43UDr2t5/ZPX
L9w3jccP6OO00X2LeCxHKS7I/ys2OtuqTwP8Nohbre619Hnkqe+0e9rEFapt
E4857k7ADXL8c2vE/WL+lXuFPC/mR6zDPSMj0tTWx28Z30Psz6dNPA61d9L6
pCw9oG/QAmuZOGZ/Oj1LT9J650a6N5uHefJn0Qq9e8a43N2HxDXyeUKNpWq4
xMsi+b63/p0e7McFeSrVNlmeyzwPoF8dR+UIOQacyxS/Td0JYlLkmyZfmnk6
MvCUvE+i0t58zEMVFqBH7gf0vZcuE3uTtRgX8aD5MOPJcqVaT0EyJpk3u+dT
FCNRPQn4Xd/qnPmDnsUKb7YWE+09IX8Cj9fKO8H8Is9b5BpmrdzebBSrZbq9
V5ypwWk5zgzmkfMusbV0Im1Q+ztq30rfpY3q6hdfYn+n8b10PF9F7ihEsh52
62GSs4loMi8Qv1vsKfm78BsOu78dR/xHP3kfa3hZjUPWNvsfs/wvI3Dc++yV
90bjdf7/dDrc20ikzzm7110LnNtPFzp3xX1N9rfjY2e/4u0j30S7/U/ocjFt
dN/g2F1V6DB+X75V+nOcl+X0B/MTOGPv6GCvjEv0oJfusz9Z/j38/OV9fEjH
mfc4W6G2GThl/Rd3veldZ9tv8R1e8V2kjI34jN8DyNS7CvPr6Hk92qW/s/Rs
h/lU+hYttv8QOsSfQz8meBNXeyvnxefba+Zrp/Mt2IiX1DxXz2Zir7iX3d1O
v1HHLqzSt7LBb46/XP7y6cPqLEafnu2W86Ccb9OfaSfNcucBej3dobYNqMVK
a0vwLS996i70tjIxFF/bP4zx6rgoZggfJWLGIAO9cm8f/M54WE9f5/cFdOpl
N2b6L7/0btqwHjXYxvti3l/FJqzkuZT/JfRpFKpvBN5zdqFe7BGfK2crzdP/
uxHIcPcMmooy4/8BRPDy4Q==
           "]],
          "2.4`"],
         Annotation[#, 2.4, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV03tM12UUx/FDodlWICAGaiWCXAI3m83cnEpOmykimaxc0laulBB1S81q
pKUrLaeYzshLeaGcEyWtaGZri+FMa6sVZLdZloXCZqWrXCT2+v3x/n2ey3nO
+Tzn+f5yHlk0c2FSRLzkp2hARFthxJWMiEO0C6fwaFpE+i0RM+kDIyJezIqo
FtMwKOJcdkQP7hsYcaY4opQ2D4koEduZE/Ev2jFBfJ1cS/pHdDi/JjNiyNCI
pbQkN6L/cHXzIi45d7v1uXKeSTeW63M6S+7HMBHHnKktiThyU8SO/IjP6Erz
Ov4fLop4nK6hS9CM7UjldRhW8neNOrX0slxt8peqmTMs4g6koJLXjbyu5fU8
r++oN4nHnfR++qZ6C3icjcn4Xf4fsMnZNn36j9/t4l5w77X0SeS538/qHBdX
7G6beRyq9o3oJ8dft0bcJeYfuVfI81RBxDrceXNEhrtd5LeS72T782gTj33s
nbY+brAe0PW0wFoWTtmfQn+lp+kKe/Vq7MB6Nev07TXaIleRsz+JKaTPW/ua
vzniHsQMXnbrxS7sxFlrG5ytx9lEfjTwdFKeKj7nINs9S+UYRKvEzXbmEz6S
6G96Wmvvqj71JnqFLHut1j5Gql5N0ucUmpb4LlCun93qTKcH9eQAMrxLJr7w
PQ6g1zvbDweNl1ubJrbLmTKa5p3TkZr4PuXuT8eJHY/L3mG+fNWYIHYr/51q
bvV223CJv9HusNS4y/4T9DxdQvd5r1K1RrpTPt2v9nDaRAvoDfSQfKm0mabQ
t2mPvjTSPuYVcvSl99Kv9HEGTTafTq+l5fRv1OBu8wX0Vf26Ry+nYhpGJe7g
neah3Lwh8fbG67znQO+S4u0XqdmiH/Pd5SNao1avfE3292C/O7ynH7v9R07Y
P0CXiTlOjybG8laj3fgN+Var8a1vZRn91Pw7/GLvSzFTjMfy1E2P2h8v/2Fe
/vCd76IjzLucrdLzMvxo/Xu1NujJYPtHvE+v/0nabfrFbyuy9LzKvC+9oLd7
3W+WN2g0n0hfoWPsT0W7+E70YJT3TvKeF8Tn22vm6y3nj2ATnnbnud64Ai3i
nlH7BP3APfZitb5VJv6D/OXyl0+nuecYXNSzfXIek3ML/YZ20EFqttLraKO7
bcSzWGVtMT7k5aJ7F/s/ZaEP3rd/EiPd408xyXyMFVOITHTLvYfXKzzU05f5
XY4OvTyHCm/5rm/jOOpRh9d5X8j7c9iMVTxP5n8xfQjF7peNbc7W6MVh8bly
ttE8/R+Nq7xlql1mnI5K4/8BeITzfw==
           "]],
          "2.25`"],
         Annotation[#, 2.25, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV03tM12UUx/HjVDRTQ6LwUgESYmCX1cplF3O5MTPnQtT+0FXMyoykzSxt
pKQrqWaYzlVC4SUJxSizHNlsOZyzm1uDGdZsqATqsqKhLUXr9f3j/ft8v99z
nvN8znmeX3ZJWdHCPhGx1s/Y9IjmsRG9V0Z8Qk/hMOYNixh2XcRDdPaNEa8O
j5gv5+2REV0jIs6j6OqI9oKIibTxmogCuZ3ZEf+iBffKL1drUWpEq/WrrooY
lRXxHC3Iibgi177XR/xt3S2+l6jZnuZZrUN0htqPYxL2W1M6LqIpI6JmTMR3
dLn3cv4fvSHiKbqKLkIjqjGU12ws56+PfUrpP2o1qz/RnlmjI27DEBTzuobX
Sl5P8vqp/e7nsZbOoh/Y72keH8Zk/KH+L1hrbbM5XeC3Wt4r+q6kzyNHf8fs
c0Bevt7W8Zhp78EYoEZPZsR9cs6pvUydJXkRb+COayPS9NbNbzHffcWfoA08
9hM76vvdo8yArqZjfMvAYfFC2kGP0mViVfaowWp7lpvbO7RSvTaev9ZrC19H
PLfSGrFqZFk/k59ZKEpmgxm4JP8u8f9oqvwT9jiOTPm/6/cMvlfrBxxCs5zd
cgfRl62rQIrchd7bzPURa4/Qub5fMI9edPl2El08VptBZ3LetEOdUv2coFPc
x716P2tdD5aacYUe88Vr1G+m1TTFvB+Tu0R8mj1fc0ZnnfFA33voADpUbFe+
O0Bnmk9xMiOxKuv73xSxzXlsRz3SknvBy1g5eUhN7r37lC73rH7PoT3xaa/Z
fO2Q+xEaMMTaRjrYmt/MaQjtoGPUuVNuLS+b3IVn5dXSMrqRlotd5k4NRJH3
D9Wow1Zc7lstX5V6HOT5Xb43oBqFzutBM5mGr/g5Zq9B9jxOt/FcjxOe54k/
ycNeM19g1hft2+CubcZ2vXxm7Sb/oYPiO+hiOQfonuTZ2vlo8fy+ma80hzZ+
F9NvvR/BcbEf5RR6nqDH03SP+D3q7+TnT2e+kY7zfsraOfqZil99/9leb+pz
pHgTvxf9j1Kd1cf87kOG85zjvT89YwZ1yT01hy3eJ9G36HjxKWiR34nzuNWd
i+S+ys8Va+Rrq/VNWIulei5xltPxubwX7X2QfqGPOqx0V4qT/yh/o/nLpQ/o
czy6zaxezf1qrqc/0VY6wp77aArdorc1eAkrfCvDl7x06zvf2WWgH3aLf4Ob
9fGXnL58TJCTh3ScVnszr708VNHX+X0h+S+bZRemO8td7swBVCV3Ce/x/gzv
FViHFTxP5r+MzkW+/oZjg7ULzGKn/NHJf5nmmP/tuMRbur2neh6GYs//AzKj
A/I=
           "]],
          "2.1`"],
         Annotation[#, 2.1, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV021Ml2UUx/ETZm8qQSlA8wlECSibrtycT6ibmTUyWOnCTbGalQ2bmdVI
nS6lGmGaSWpqiawNo7SBpKtkKIhtbQ2mWLMhNkk3K8xVojb78OL7/933dc51
rt851/1PX7ysoOSWiNjiJ+uuiKZ7I64nR3xJL+AknhkYkTQ8Yi596v6I9WkR
S+RsHRLRPTiiF0+kRHTmRkyltUMjcuSeT4+4ijZMkV+q1vKkiHb7N9wdMWRk
xCs0Z1TEgNHOzYy4bN8D1ovV7BzkWa0faIHazyIPR+1Zel9EQ2rEjjER39PV
3kv5X5gd8TzdQJejFttxJ68jsZq/cM5S+o9aTepPdeaIjIjxuAOFvG7ktYzX
33g94LwZPO6iT9Iq573I4zzMxO/q/4xN9jaZ0zV+t8t7S99l9FVk6O+sc5rl
ZettM4/DnX07blPjyoiIaXL+VnuVOq9lRbyLh4ZFDNRbD7+FfCeIP0dreOwn
dsb6pHvMgJbT0dZScFJ8Fv2VnqGrxCqcsQPlziw1t0papl4Hz0f02sbXCdqo
fivK8YH4AfvXy6/g/5j9zViEy/pabL2HnrR3mHix94Vi8/UwDy+r0UFP46Y+
w0xmmM8J+dPpNj2eEvuIrvRtVdLDZnPc3bSiBVl6W8NrtdheVCHJvSSqcYPf
RfyN47PK/MbTZc4cY88xe5uRy1MO6uXWm2Udzfb+mDt+FP3NKGFsxIfqbsUW
ZLrrzhx96CWfv93ydmEnzlqrsL9dv119M/Z+Dl2odP5QvtLEprnrh/WyQG4R
nkaLs77hbbZez/Fxzeyvoxct1q7Sf5Eqr975B1GHXnUa1U22fkXvf2G+mbxt
hkfMtBHfIVe8230k9v0P9T6A7qOfY67eH0eN50wz2iaWTkchA538TOJxMqbo
eTryMEjNg/47DfiWhxr6CY7rfR9doedmeqjv2QyWoM3zTt/cOns7+FxBT3g/
jS6xH+XM8jxRXxfpIfHJPOzn6Q/fyW6a6/2CvUXuYw5+sf6Ts97Tw2DxBn3c
MONE8/mC50akmEeR91vpJfOs5r/AXPZ4z6Pv0wnis9Em/zx6Mc5935R7CZli
tXzttb8Bm/C6vovdSz7qzPcNZx+nX+ujGuvcd2Hff5W/dP4y6SP6nIAec/1M
zaNqbqGnaDtNc2Yj7U/36G0j3sRaayU4zEuPvrN9cynoh3rxVozVx59yEviY
KGcMknFR7U95vc5DBX2H35VoN8tu5PtuvvI/aUYFSvEx7y/xvgabsZbnmfyX
0AXI1l8qttn7glnsl5+uZhPNMP8H8R9vyc6e4zkJhZ7/B0BqBjM=
           "]],
          "1.95`"],
         Annotation[#, 1.95, "Tooltip"]& ], 
        TagBox[
         TooltipBox[
          LineBox[{4157, 4253, 7093, 6953, 7106, 7019, 4172, 7006, 4157}],
          "1.95`"],
         Annotation[#, 1.95, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV031M11UUx/GD1WZqaRSglfKkBoKuUpur1MTMXLICrU3b0EytNGxkWiNt
utTVCB96cIllPlDNRYIDyfojhjHF5lYwtBRn5jQtK1rpJCzrxR/v3+fe77n3
nM+59/7S5zxXuCghIjb6GXpTRGNWRNeNEbvoWbRhzg0RfQdFPEwfHR6xqn/E
fGveuTnizICITjySHHEiJ2Isrbo1Itva0+kRl9CCe60vlaukX0Sr/auTIgak
RTxPszMjrhui7uCIP+wb4ftsOU8kGst1iBbI/STGY589C3Ij6lMiKoZGHKTL
zUv5L8qOeIqupiWowib04TUVy/n7T70F9KJcjfKPVXNQRsQd6I1CXtfyuobX
n3itUW+CPe/T6XS7es/w+Bjy8Kv8R7He3kbn9De/m6x7Vd9r6AtI198P6jRZ
l6W3DTwOVLsXrpHjz9SIcdZckHuZPEtvi3gdowZG9NNbB7+FzidBfC7dyWMP
sXbf777FGdAyOti3JLSJT6KnaDtdJlauRgXK1Cx1bhvpGvmO8PylXlv4aqYN
8h9AGd4Ur7F/lfU76dt66HKOS8VGic3g9Rc1npD3uPHJYRE/IkHvFfwX+Paz
+A7nWYl282NIkm+rWqe8p6PmNTzMsqcIzzq/DLqQ9hwRkWl8rVw9McS3Lnsu
Ywl2i+1CDaoxTc5mfeTT++WciGPubZZeM+Qqor318IEz/Zf/LfQKTZMrHan4
2J2PlONO3GX/F+YX9X4BM9T/i86kTfx81e1J/KA8/dUfgP32HcBkdZO9sQdo
Ch2ndi1fuWrU2ZND99BO+S7ha7kOohnZvh+Ss8r4E9QZ16JNrkrv6TD9kCY5
23n0W/O5dJE6xZiqfi99TnW2+XgIFdbmurscTHdf07DZPc7Tfx3dg3XqzuZr
qb2V3uN2jLN3PPKsn4g+Yg3yTzC+D3PESuRu0UOT3Hux2Pf5aDF+z9tbKX5E
/4tps/l3OCn2jTWTjMf4P5yje8Xv4aPae/7N/2ILHWZ+1t6ZzmEKjvv+Pc9v
dJ+5eL1+L/tfXe/dfepdNSDJ/cw0v4qe108ljwXuZpv5eLqOjhafjBbrT6MT
tzvHK9aeR6ZYFV877K/Heryo79neRD5qnfdLau+nn+mjEiudTWH3f7b7TfGX
SR/U52h0uPuP5Nwn51v0MG2lKWo20KvpNr2txctY4VsxPuelQ99Z/j9J6IE6
8QMYro/fu/9vfIzpfotIxDm5t/LaxUM5fY3fJWh1lmeQ7553u9smlKMUm3lf
yPsr2IAVPOfxX0wfR5b+kvGuvU87i2rr0+RspOnOfyT+4S1R7SnGfVFo/D8o
eQJ6
           "]],
          "1.7999999999999998`"],
         Annotation[#, 1.7999999999999998`, "Tooltip"]& ], 
        TagBox[
         TooltipBox[
          LineBox[{4156, 4252, 7092, 6952, 7105, 7018, 4171, 7005, 4156}],
          "1.7999999999999998`"],
         Annotation[#, 1.7999999999999998`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1H1Ml2UUxvGDlc1MCgVBRUHUAAOxojkLXZSFcy6gtw1bc+p6wZzZCxlp
06VkM0yTWqJSoGvRKC2c1dZikIJtbQVDtNmsmIabFeVymTWrD398uZ7nPuc+
93XOc/+YvPSJe1YmRMTL/kxLjmjPibg4JuIDOoBeLEmKSJwUcTe9Lz9iQ1rE
w3JeHx9xelzEBZSOjTh5fUQRbUmPyJF7anLEn+jGrfKr1Vp1bUSP/RtTItIy
I56kOVMirp7m3KkRv9mXb32xmidHe1brK1qm9lLMRYc9lXkRB1Mj6q+L+JKu
9V7N/0O5EY/QjXQVWrADI3mdhLX8/eu8SnperXb1i5w5MStiJq5COa9beK3h
9Sde9zvvNnt203tpk/Me4/F+FONn9b/FVnvbzekvfnfIe1HfNfRpZOrve+cc
kpett208pjt7BC5X41xGxBw5f6i9Rp2qbN8EN02MuEZvg/yWm0+IL6PNPCaI
nbA+e4IZ0M10irVk9IrPo/30BF0jVuuMemx2ZrW5vUFr1Ovj+XO9dvN1hLap
34XNeE18v/0b5DfTOj1cNMcqsf/obPHzdJS6w8TqnJNAi+WPsFZlfkvtW4K3
9NOARv00Ybfn1e7TLlqi9wH5C8xlpf6Pm9kxLONxj3jT0D6MVC/RXEvMuEHN
QnVKeXiOnzJaTT9To1WN4XwsUP8jzzerfcC+VvSp20zfw3DrV+KSvru8H0En
DuMK65PM713PP/r2Ne5LP32J9jj3QR5m8nPUGTfQAnxjfQbtpmXiS/gvpalq
LNJjBVLFe+zJHDpPT4c9dyJZ3RQUO2MMHcNnGh2H8XInYI56d4gX+Ga30yLv
/bx/IZbHawfNp4fodrXrkO/7zECv/Ok0F+m+Uz124hw/v+MBtTbxuty8Hkcl
7jTL0e5FEnbJXa92n7yn6BHvx/CDel+b1TzPs+SfoZ+I3+Jb7HMvf3G/G2iu
9wF7K3iaj++sH/fNXjGrVPGD+vzb72PU9Ij33Z82JPNT4X0YPWtGe3kq01uj
97n0VVoofhe65Z/CBRTo9ZLcs8gSa+Frj/0HsRXP6mexGS5EqzmvdnYn/Vgf
e7He3Skf+u3xl8FfFi3RZyEGzfsdNTvU3E6P0h461plt9DLaqLcteB7rrK3A
p7wM6jvb/5ZkJOCAeBfy9PGrnOBjlpypSMIZtd/m9SIPtXQTv8+gxyxPY6Hv
9qE7dQi1qMZO3pfz/gK2YR3PxfyvoIuQrb8UvGnvo2axT36Gmu000/xvxD+8
JTl7vudElHv+HyaN8U0=
           "]],
          "1.65`"],
         Annotation[#, 1.65, "Tooltip"]& ], 
        TagBox[
         TooltipBox[
          LineBox[{4155, 4251, 7091, 6951, 7104, 7017, 4170, 7004, 4155}],
          "1.65`"],
         Annotation[#, 1.65, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV039MlmUUxvGDZlKpUShW8iOUwBJ0ZTLTXC4qMlTIWtoySvpluQUqFmrT
UlZTDK1c6mqZZLFR2nKoa4vhXNbWpjAqnU2pgbBZ0ZwspJbahz++7/Xcz33u
c65znvvNLCuf93JCRGzxkzUyonl8RH9yxBe0C214+rqI4ekRc+gjeRHrboh4
Vsx7N0V03hjRh7kpEacmREynDakROWI7MiP+Rgumia+SqzwpotX59aMiRt8c
UUFzxkVcc4u6WRF/OZfrfamcp673LNcPtFjuRZiBQ84szo1oHB2xPTvie7ra
uor/hbdGPEfX03I0YBuu5jUNq/m7qN5i2itXs/zT1UwdGzEJV6GE1028VvN6
hte96t3jzAd0Hv1YvRd4fBQz8bv8J1DrbLM5XeB3m7g39F1NlyFDf6fVOSwu
W2+beRyjdiIGy3EuI+JuMeflXiVPZU7EW7gjLWKE3nr4LTGfy7SM1vMY9k5a
Tx1jBnQDHetdMtrsF9Df6Em6yl6NGtuxQc0qc9tKq9X7iedv9NrC13e0Sf4j
2IAt9vc6v058PX1XD/3mWGnvEp1qv5cOk/cc7VdnK661HoFETBPzqvjJ9CE9
DjLTB2kCnUV7zeeAWVW6WwdpvjPtZlBknajer56H0gIe7kW+eUzBw/INEX8l
hmK2XEW4z/wvOTvYu4v0CrrU96xAifP7rXPM5SXrRs+v87YWhXJ+ov9+vr5G
nX534bLvPtHeJOThGI4OPIu5gD5MMcNcusJMKzGE3zv1MZ/HOWrORTHK7HU6
+6TYDlpKz9BsfircxxNqldPjdIf3Xc6n6+FTcXl0N52oVjdf6bynIRXp3j+h
9xR5Rgz8T5z/zP2pxyzzmG2d6n0antL3ooH/NebbOy/XArpS/ix5MuR7zHoh
rxVyLkU5lmMZ9qnxjG/WIme7Ho/RMusi96dN36e963EXasX97C60ez7qXYHn
fPe+mx6wd5eZ73Fv/3D/P6TjrbvUXMBzIX7x/rj+N5pDiv1G3v/x/xl2W8Tn
ZtmEZD4XWCfQs/zXuSvF/O+0nkHfppPt348W8R3ow0Se/xN7Fpn2Gvja5Xwj
arFCL6XmXISv9PaK2t/S/fqow1p9lgz8Nwe+D3+Z9AF9TkaPO7RbzkNyvkN/
pK10lJpNdBDdqbdNWIk13i3BQV569J3tuyQjsM/+EUzQx59iLiNfzDgkoVvu
j3jt56GGvsnvcrSaZSeKfM8vfbPDqEEVdvD+Iu+vYTPW8DyT/yX0cWTrbyTe
d/Z5s9gjPl3OZpph/rfjX96S1C70PBwlnv8HxhH1yg==
           "]],
          "1.5`"],
         Annotation[#, 1.5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[
          LineBox[{4154, 4250, 7090, 6950, 7103, 7016, 4169, 7003, 4154}],
          "1.5`"],
         Annotation[#, 1.5, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV039M11UUxvGjcyvSwlChUAhE0FScWc4yl8WvlStZNKStOSsxyzWcWZI2
W8p0CGpWE5ouk9zcKGkZ1T8yHGqtloOobCCUU2GzojFcRj+ll3+8eb6fe889
5znnXjKfXltSMSoiqvzJmhjROiNieELEB7QPnVhxc8S49IiHaUluxJZbIlaK
eTM14sKtEVfwSHJEz6yIhbRxSkSO2POZEb+jHfeIr5SrYnxEh/NbJ0UkZ0Ss
pTlZETdkqzst4jfnZllfLmdPkt9yfUWXyv0kFuG4M6tnRzSnRNTnRHxBN/mu
5P+J2yPK6VZagUbUIYHXKdjE37/qraaX5WqVf6Gak6dGzMH1KOa1ltcqXi/y
2qTefc7so4/Sd9V7hsfHsBg/y/8Ddjnbak5/8Fsn7jV9V9F1SNdfrzpt4rL1
tpvHVLWvw2g5Bm+LuFfMkNwb5Vk/PWI77kiLuFFvA/wWm89V+hQ9zOOIs12+
F0w2A1pNM8UnodN+Hj1Hu+hGezVq1KPauUpze4tWqfcdz8f02s7X57RF/lOo
xuv2m5zfIv4wfUMPw+a43t5/dIH9y3SsvIN0WJ2/UYfn9TGofrlzQ7Te2mgz
yTefbWptR5jve/obkecQ/Vr9Luu56s1GL2/rxDTwehCFzvbY78Ux62dpN5qw
zNl94lus3+Wd3okZ6hbIU4giPKTGg0jQR5/9H93NRfoT3ek91KLfPSfM8SZx
2l6vvU/kbVZ7Ff999rut9eAsPra+gbejtISPOrGlvOx3nyX0BD8rMF6uSnoT
3UAT6Rg+8vkpQB6KUIhsvp/zBqfRk+K+Mcsz+B4r5S1Hlhxfim3zTk5gyJxL
eSgQU4g87HE+n96v9zHuaK45V7i7ZuulvpehDCn6SEYKP6l6KPI+z1nf4VwN
HnB3nfZ6rZ1Gnu/5Yvrpp3LdLecRb/AXb3k/ne67z0zK+CpCt/Uzau/gd5L9
ZnP+0//C2JkR78vfgiTey3wHvaTnBr6XmvcB34voTjrPfgHaxZ/HFeS6j3/E
XkKGvUa+DjrfjF14UT/L3ckSfKTHl9Q+ee1O9dGAV/VVfO3/jL80/jJoobc8
DwPu75Ccx+XcQ7+lHXSimi10FD2gt1q8jM3W1uAzXgb0ne0OkzDi91H7pzBT
H7+KuYr51qciEf1yv8PrMA81dBu/L6DDLC9gifv+0L23oQaVeJv3Z3l/Bbux
mefF/K+hjyNbfxOw19lVZnFEfJqcrTTd/OfiL/4S1S7yexyK/f4fcWD2Ug==

           "]],
          "1.3499999999999999`"],
         Annotation[#, 1.3499999999999999`, "Tooltip"]& ], 
        TagBox[
         TooltipBox[
          LineBox[{4153, 4249, 7089, 6949, 7102, 7015, 4168, 7002, 4153}],
          "1.3499999999999999`"],
         Annotation[#, 1.3499999999999999`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV039M1lUUx/HjMkttzgfBlB8hBpbmz+ZMc7lcuUkKCy0oYmWYEG1aWSNs
WspsBkr+RLOpOBsbpa3CmiXDuaytP4Ks1SRcpeFmiXO61MrUej1/vPk833vP
Pedzzr3klD8/b0mfiGjwZ2RqRPudEZeHRLxPe3AUTyYiBt4WMYcWjYtYOSyi
XMzG9IiTwyMuYu7QiO67IqbRlsyIPLEnciL+RAemiq+Wa/HgiE7nV6VFpI2I
WELzbo/on6dubsRZ58ZYL5OzO8Vvub6mBXI/hek45EzF2IjWWyO2jor4ii7z
Xc1/6eiIhXQVXYwWNOJmXjOwjL9/1augF+Rql3+amukjI8bhJhTyWs9rLa+/
8bpPvfuc2U4fprvUW8TjPMzA7/L/iHXOtpvTJX4bxb2u71r6ArL0d1ydw+Jy
9dbA43C1+6GPHOeyI+4Vc17uGnmW3hHxBiZmRdyit15+C83nGl1Am3m87uwx
31MyzICuoSPEJ3DU/kz6Cz1Ga+zVqbEVa5yrNrdNtFa973k+qNcOvr6kbfIf
wRq8ZX+f8yvFN9MNerhsjkvtXaVT7F+gA+Q9R/9RZ7beGmk+XayX8zyU21+I
Ec7/bG21WiX6egzFaJSnSf5duJGfG9AXG80/w5vLQiYGO9/Ed4KW8FSM4daH
4WmxV51fQFN919AEHYIUfKO3mepOdGYCxuNuc6uUrwLz7ZWKqXJvz+FZHEze
pXdy1t1vob10M92EdOc/tz/VWzljfb21jdiAz6xXOH+AVtJ+Yh+Xe5E62/X1
NrZhIY873Puvznd5Jz20Mdm/+EfEF/FURPdba8XHuC5mZnJuZnY/fZS+5j5W
4Lj9/ua9Wc135duDuWKeEDOHltECWkoPiF9L5/uup11m1I2fsIGvtPERQ5GK
Zh5n67Ov3A/R/OT/h7hVqPROr3jD37rXTmTwfDn5JsVeopO9g1P0E9/3qLnX
zP8Q/w4d5bvHTIrlmIUu6z/w8iZPqfZbzfIv/zMDxkS8ZyZtSJhpse//vIHT
6u9Ws0C/O61Pp2vpJPsPoEP8CVzEWHO7IvY0su218NXkfCvW4SW+y8wvHx+a
28tqf0H3e7e7sUK9wuT/I3+Z/GXTB735Seh1R3vkPCTnevod7aRD1GyjQXfq
rR6vYLm1KnzKS6++c80zget+f2T/CEbr44yYa5hsPQeDcEruHckZ81BHV/P7
IjrN8iTy3d0H7usw6lCNbbxX8v4qGrCc5xn8V9ES5OovBVucfcYs9orPlLOd
Zpn/BPzN3yC1Z/k9EIV+/w8zwfd5
           "]],
          "1.2`"],
         Annotation[#, 1.2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[
          LineBox[{4152, 4248, 7088, 6948, 7101, 7014, 4167, 7001, 4152}],
          "1.2`"],
         Annotation[#, 1.2, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1HlM13Ucx/F3h0I2NzQrFUQURDwytmYQSfcfrmQd01YjTTkaLcSokTab
yioGaiXmVYqu0rBwNezYYpBLO7aC0GI2aybasoWBpmHLo3rwx5PX5/N5n5/3
9/NjXNGiByouiYhl/owbEdGaFdF/VcQ79Bg6MXdYxJDUiLvpfddFLB8ZsYDP
mtER3aMizuCeayIOTYnIpY0pERl8j4yLOI125PCvkqs8KaJD/IqrI0akRSyk
GekRiRPUzYg4IW6S80I5Dw23lusrOkvuechDm5jSqRHN10asz4z4nC6xr9L/
w5MiiugKWo5GrEOCXkdjif7OqVdKT8nVKn+umqPGR0zFYBTotU6v1Xo9qtcm
9WaI2UTvpQ3qlejxfuTjN/m7sEpsqzn9pd91/Ja5dzVdhBT3+1GdPfzS3W21
HkeqPQghR+/YiJv4nJR7sTyVEyNewPVjIq50tx79FpjPBfoo3a7Hi2IP2k9P
NgNaQ8fyT0In+230MD1IF7PVqrEeNeKqzK2eVqt3QM+fuGu7vvbRFvn3ogYv
sTeJX85/O33FHfrNsZLtPJ3OXuy8Xp3zaqylQX9Vp4vvfDUqzfmw2TWZw890
F+3jN9c9H0GF+hVmdtT6GLqRyS9Xjhz8oK90/pfyG08ne4Mf+C5fmM+XOKt+
ln02ew7fXDTb/8RvN52Ir80wk35Dy/Q0m08D/y3YjF71/mHf4f6FuF1sn7NP
9XWKnsRO5+f4/Gm9yZ1ex2uYI9cCtlu8mVtxM/IxA/Odl6u3EKVi+9QvoU/Y
91o3sv9B08y3Ta0N8m1Egn0i5rE/zvchOsj+cpwYeA/4mP+NanxEc+hKcXUo
9u5KUIQus/4ep9HJth/f4jscwGW+UT2/tViDt7EDW32DF81gjHkXyZ0wzRvx
ZmdP1oeZD0bewO9c7QTrBv5vsW+hb9J9ck/wJhP5N1uf9e6vsN6p/xYkiZtj
/6/6x9XZJm6Wuluc59GVNJv9DrTzP4IzmDLwnfgeRypbo1pbxTdjFZ7yLQp9
z5l4z52fVvszuts72obn1CsY+E15t8lmmErv9I6z0WPGb8jZJufLdD/toMPV
bKH/DdzPb7UOz2CpszJ8qJceM0g3pyRctH6ffS+y3ON3Phdwg/M0DMUvcm3W
a78eaunz+n0SHX5X3Zjpjezy/2APalGFDXp/TO/PYjWW6jlf/2X0QaS73zC8
KrbYLN7lnyxnK00x/2n4W39D1b7LeggKrP8HtST0/g==
           "]],
          "1.05`"],
         Annotation[#, 1.05, "Tooltip"]& ], 
        TagBox[
         TooltipBox[
          LineBox[{4151, 4247, 7087, 6947, 7100, 7013, 4166, 7000, 4151}],
          "1.05`"],
         Annotation[#, 1.05, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{5622, 11726, 5623, 6395, 5621, 11587, 4194, 6486, 11163, 
           10306, 10307, 10304, 4800, 10305, 5618, 11725, 5619, 9762, 9761, 
           4799, 10298, 4188, 9757, 9756, 9755, 4795, 11150, 5607, 11149, 
           5606, 6195, 11642, 4701, 6196, 11733, 6197, 4705, 7673, 4704, 6326,
            7233, 7232, 7231, 11039, 5453, 11038, 5454, 11040, 4700, 10189, 
           11043, 11042, 10188, 10187, 5455, 11041, 5947, 10351, 4915, 9802, 
           9803, 9804, 5413, 10978, 10980, 10979, 4913, 7789, 4912, 8648, 
           5099, 11168, 5629, 10339, 10340, 9130, 5596, 9127, 9129, 9128, 
           9419, 4367, 11348, 11349, 9417, 6036, 7602, 8134, 7587, 9854, 7594,
            6028, 9349, 9409, 9401, 4290, 6603, 4280, 7888, 6016, 7312, 9844, 
           7301, 8084, 8071, 7030, 7637, 5084, 7487, 5070, 7439, 7454, 7045, 
           5827, 6964, 5845, 7420, 5027, 9310, 5883, 9292, 5865, 11274, 7470, 
           10115, 10096, 8822, 6126, 9528, 8172, 8191, 7172, 7191, 5259, 6434,
            10686, 4569, 9499, 9070, 9088, 8573, 9107, 4851, 7867, 8842, 
           10707, 10726, 8252, 8272, 8291, 6044, 9038, 5527, 9019, 5546, 6368,
            4224, 10376, 4940, 8709, 8747, 8728, 4407, 7355, 11247, 5732, 
           9209, 5751, 6681, 6662, 10643, 10662, 10603, 10623, 5217, 10584, 
           5236, 11383, 6083, 9876, 6064, 11364, 5564, 11065, 11101, 11083, 
           4806, 7208, 4824, 6490, 8232, 4586, 9460, 9479, 8995, 5484, 8211, 
           5503, 6348, 4203, 10356, 4918, 8651, 8689, 8670, 4387, 7334, 5687, 
           11224, 5706, 6642, 6623, 6799, 4960, 6270, 11599, 4425, 7689, 4444,
            10446, 10465, 10408, 5108, 10427, 5152}],
          "0.8999999999999999`"],
         Annotation[#, 0.8999999999999999, "Tooltip"]& ], 
        TagBox[
         TooltipBox[
          LineBox[{7281, 7280, 11504, 11505, 11503, 11507, 11506, 5620, 6248, 
           11735, 6247, 7278, 7279, 6246, 11586, 4191, 7274, 4189, 4262, 9759,
            9758, 4796, 10297, 4183, 9753, 9752, 9751, 4788, 11809, 10293, 
           11170, 11727, 5634, 11169, 5633, 7287, 5632, 11315, 5966, 11312, 
           11314, 11313, 4176, 4258, 4956, 11655, 4957, 5101, 10405, 5100, 
           8795, 8794, 7996, 8764, 8763, 7898, 8590, 10323, 8591, 8308, 11768,
            8307, 11769, 4642, 10983, 4643, 9969, 9950, 9970, 5418, 8952, 
           8933, 10781, 5286, 11677, 11696, 11658, 6513, 7770, 7751, 9133, 
           11122, 9152, 8113, 8094, 4475, 7500, 5898, 11290, 5917, 6722, 6703,
            4329, 10912, 5308, 10893, 5327, 10956, 5393, 10937, 5374, 8347, 
           8328, 8309, 10874, 10855, 8883, 10217, 10274, 10255, 10236, 8366, 
           8385, 4647, 10984, 11003, 10034, 10015, 9996, 5346, 6554, 11508, 
           6535, 7810, 7791, 9420, 9439, 6215, 9643, 9662, 9607, 9588, 4501, 
           7525, 7544, 7563, 6778, 5948, 6759, 6741, 7970, 7952, 6290, 11618, 
           4521, 7706, 4539, 10523, 10541, 10486, 5132, 10563, 10505, 5196}],
          "0.8999999999999999`"],
         Annotation[#, 0.8999999999999999, "Tooltip"]& ], 
        TagBox[
         TooltipBox[
          LineBox[{4150, 4246, 7086, 6946, 7099, 7012, 4165, 6999, 4150}],
          "0.8999999999999999`"],
         Annotation[#, 0.8999999999999999, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{5195, 10504, 10562, 10560, 10561, 7110, 7109, 4565, 7677, 
           6339}],
          "0.75`"],
         Annotation[#, 0.75, "Tooltip"]& ], 
        TagBox[
         TooltipBox[
          LineBox[{5608, 11787, 5609, 5602, 11496, 11497, 11495, 6242, 7268, 
           11494, 4260, 11493, 9750, 4784, 11143, 11144, 9728, 9729, 9730, 
           6194, 11474, 11476, 11475, 4703, 6198, 4702, 11643, 5456, 6512, 
           6511, 10342, 4897, 10341, 10344, 10343, 4783, 8544, 4782, 8545, 
           4914, 11212, 5679, 11211, 5678, 7325, 5677, 9377, 5991, 9375, 5990,
            9376, 4352, 11342, 5981, 9359, 9361, 9360, 5674, 9357, 9358, 9346,
            9348, 9347, 9400, 4289, 6602, 4279, 7887, 6015, 7311, 9843, 7300, 
           8083, 8070, 7029, 7636, 5083, 7486, 5069, 7438, 7453, 7044, 5826, 
           6963, 5844, 7419, 5026, 9309, 5882, 9291, 5864, 11273, 7469, 10114,
            10095, 8821, 6125, 9527, 8171, 8190, 7171, 7190, 5258, 6433, 
           10685, 4568, 9498, 9069, 9087, 8572, 9106, 4850, 7866, 8841, 10706,
            10725, 8251, 8271, 8290, 6043, 9037, 5526, 9018, 5545, 6367, 4223,
            10375, 4939, 8708, 8746, 8727, 4406, 7354, 11246, 5731, 9208, 
           5750, 6680, 6661, 10642, 10661, 10602, 10622, 5216, 10583, 5235, 
           11382, 6082, 9875, 6063, 11363, 5563, 11064, 11100, 11082, 4805, 
           7207, 4823, 6489, 8231, 4585, 9459, 9478, 8994, 5483, 8210, 5502, 
           6347, 4202, 10355, 4917, 8650, 8688, 8669, 4386, 7333, 5686, 11223,
            5705, 6641, 6622, 6798, 4959, 6269, 11598, 4424, 7688, 4443, 
           10445, 10464, 10407, 5107, 10426, 5151}],
          "0.75`"],
         Annotation[#, 0.75, "Tooltip"]& ], 
        TagBox[
         TooltipBox[
          LineBox[{4149, 4245, 7085, 6945, 7098, 7011, 4164, 6998, 4149}],
          "0.75`"],
         Annotation[#, 0.75, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{5586, 6389, 6388, 7735, 7736, 6480, 6479, 7259, 9748, 9747,
            7855, 9683, 9682, 6249, 11532, 11533, 11531, 11556, 11555, 6314, 
           4255, 4159, 9720, 9719, 4714, 10321, 10322, 10318, 10320, 10319, 
           4174, 9722, 11779, 4871, 10317, 4872, 11805, 8589, 9374, 11345, 
           11346, 9827, 9828, 4383, 7605, 4382, 8484, 8485, 10191, 10190, 
           4717, 9372, 9373, 8029, 9823, 9824, 7322, 9198, 5675, 9199, 5676, 
           11210, 11209, 8068, 9841, 9842, 7299, 8082, 8069, 7028, 7635, 5082,
            7485, 5068, 7437, 7452, 7043, 5825, 6962, 5843, 7418, 5025, 9308, 
           5881, 9290, 5863, 11272, 7468, 10113, 10094, 8820, 6124, 9526, 
           8170, 8189, 7170, 7189, 5257, 6432, 10684, 4567, 9497, 9068, 9086, 
           8571, 9105, 4849, 7865, 8840, 10705, 10724, 8250, 8270, 8289, 6042,
            9036, 5525, 9017, 5544, 6366, 4222, 10374, 4938, 8707, 8745, 8726,
            4405, 7353, 11245, 5730, 9207, 5749, 6679, 6660, 10641, 10660, 
           10601, 10621, 5215, 10582, 5234, 11381, 6081, 9874, 6062, 11362, 
           5562, 11063, 11099, 11081, 4804, 7206, 4822, 6488, 8230, 4584, 
           9458, 9477, 8993, 5482, 8209, 5501, 6346, 4201, 10354, 4916, 8649, 
           8687, 8668, 4385, 7332, 5685, 11222, 5704, 6640, 6621, 6797, 4958, 
           6268, 11597, 4423, 7687, 4442, 10444, 10463, 10406, 5106, 10425, 
           5150}],
          "0.6`"],
         Annotation[#, 0.6, "Tooltip"]& ], 
        TagBox[
         TooltipBox[
          LineBox[{4148, 4244, 7084, 6944, 7097, 7010, 4163, 6997, 4148}],
          "0.6`"],
         Annotation[#, 0.6, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{11380, 6080, 11399, 9873, 10639, 5252, 10619, 9892, 9893, 
           8167, 8637, 10347, 10348, 8636, 7994, 7995, 5125, 11543, 6266, 
           11541, 6265, 11542, 7686, 10167, 10166, 10165, 6320, 4678, 4713, 
           11644, 4712, 5280, 11657, 5281, 4891, 8608, 4890, 8609, 6478, 
           10334, 4892, 8610, 8612, 8611, 4605, 7603, 7604, 6061, 11361, 6060,
            11794, 9629, 9746, 9745, 4254, 4158, 6337, 7730, 7729, 5628, 7283,
            5585, 7258, 8461, 8460, 6154, 11434, 9560, 8030, 5096, 8784, 9325,
            9324, 7026, 8081, 7027, 7634, 5081, 7484, 5067, 7436, 7451, 7042, 
           5824, 6961, 5842, 7417, 5024, 9307, 5880, 9289, 5862, 11271, 7467, 
           10112, 10093, 8819, 6123, 9525, 8169, 8188, 7169, 7188, 5256, 6431,
            10683, 4566, 9496, 9067, 9085, 8570, 9104, 4848, 7864, 8839, 
           10704, 10723, 8249, 8269, 8288, 6041, 9035, 5524, 9016, 5543, 6365,
            4221, 10373, 4937, 8706, 8744, 8725, 4404, 7352, 11244, 5729, 
           9206, 5748, 6678, 6659, 10640, 10659, 10600, 10620, 5214, 10581, 
           5233, 11380}],
          "0.44999999999999996`"],
         Annotation[#, 0.44999999999999996`, "Tooltip"]& ], 
        TagBox[
         TooltipBox[
          LineBox[{4147, 4243, 7083, 6943, 7096, 7009, 4162, 6996, 4147}],
          "0.44999999999999996`"],
         Annotation[#, 0.44999999999999996`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{7450, 7041, 5823, 6960, 5841, 7416, 5023, 9306, 5879, 9288,
            5861, 11270, 7466, 10111, 10092, 8818, 6122, 9524, 8168, 8187, 
           7168, 7187, 5255, 6430, 10682, 10680, 10681, 10679, 5254, 7165, 
           7164, 7257, 11432, 11433, 9558, 6153, 9559, 5860, 9557, 6152, 9555,
            6151, 9556, 7058, 4327, 7939, 7024, 7498, 5066, 7435, 7450}],
          "0.3`"],
         Annotation[#, 0.3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[
          LineBox[{4146, 4242, 7082, 6942, 7095, 7008, 4161, 6995, 4146}],
          "0.3`"],
         Annotation[#, 0.3, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{7040, 5859, 7025, 7938, 6957, 5840, 6959, 5822, 7040}],
          "0.15`"],
         Annotation[#, 0.15, "Tooltip"]& ], 
        TagBox[
         TooltipBox[
          LineBox[{4241, 4145, 6994, 4160, 7007, 7094, 6941, 7081, 4241}],
          "0.15`"],
         Annotation[#, 0.15, "Tooltip"]& ]}, {}, {}}}],
    AspectRatio->1,
    Frame->True,
    PlotRange->{{-3, 3}, {-3, 3}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{390, 185},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->56971193]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20632],

Cell["Compose with inverse function:", "ExampleText",
 CellID->196753002],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"InverseJacobiDC", "[", 
    RowBox[{
     RowBox[{"JacobiDC", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], ",", 
   RowBox[{"JacobiDC", "[", 
    RowBox[{
     RowBox[{"InverseJacobiDC", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5296189],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"InverseJacobiDC", "[", 
    RowBox[{
     RowBox[{"JacobiDC", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], ",", "z"}], 
  "}"}]], "Output",
 ImageSize->{269, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28262639]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " to disregard multivaluedness of the inverse function:"
}], "ExampleText",
 CellID->785308763],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->81233632],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", "z"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->751932501]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->390870124],

Cell[TextData[{
 "Differentiate",
 Cell[BoxData[
  RowBox[{" ", "InverseJacobiDC"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->715886131],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"InverseJacobiDC", "[", 
     RowBox[{"z", ",", "m"}], "]"}], ",", "z"}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->809586479],

Cell[BoxData[
 FractionBox[
  RowBox[{"JacobiSN", "[", 
   RowBox[{
    RowBox[{"InverseJacobiDC", "[", 
     RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], 
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   SuperscriptBox["z", "2"]}]]], "Output",
 ImageSize->{241, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->399796182]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"InverseJacobiDC", "[", 
     RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->192074691],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", "m"}]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"EllipticE", "[", 
      RowBox[{
       RowBox[{"JacobiAmplitude", "[", 
        RowBox[{
         RowBox[{"InverseJacobiDC", "[", 
          RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], ",", "m"}], 
      "]"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
      RowBox[{"InverseJacobiDC", "[", 
       RowBox[{"z", ",", "m"}], "]"}]}]}], ")"}]}]}]], "Output",
 ImageSize->{481, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->243013801]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20875427],

Cell[TextData[{
 "Obtain",
 Cell[BoxData[
  RowBox[{" ", "InverseJacobiDC"}]], "InlineFormula"],
 " from solving equations containing elliptic functions:"
}], "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->322808586],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"JacobiDC", "[", 
       RowBox[{"x", ",", "m"}], "]"}], "2"], "+", 
     RowBox[{"2", 
      RowBox[{"JacobiDC", "[", 
       RowBox[{"x", ",", "m"}], "]"}]}]}], "==", "a"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->554970152],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->22564037],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"InverseJacobiDC", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        SqrtBox[
         RowBox[{"1", "+", "a"}]]}], ",", "m"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"InverseJacobiDC", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SqrtBox[
         RowBox[{"1", "+", "a"}]]}], ",", "m"}], "]"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{520, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->63533333]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22797],

Cell["\<\
Machine-precision input is insufficient to get a correct answer:\
\>", "ExampleText",
 CellID->3979231],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiDC", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"10.", "^", "5"}]}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->563558634],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->166191270]
}, Open  ]],

Cell["With exact input, the answer is correct:", "ExampleText",
 CellID->260060486],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"InverseJacobiDC", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"10", "^", "5"}]}], ",", "2"}], "]"}], ",", "50"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->289346646],

Cell[BoxData[
 RowBox[{"1.\
3110217060782478629804804814681645310524577933290961280047731123883`50.\
15051499783199", "+", 
  RowBox[{"0``50.03290511563697", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{447, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->151494057]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30165],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiDC",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiDC"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseJacobiDN",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseJacobiDN"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseJacobiDS",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseJacobiDS"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseJacobiNC",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseJacobiNC"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19703]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7226],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "Tutorials",
 CellID->22574]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->718141252],

Cell[TextData[ButtonBox["Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticFunctions"]], "MoreAbout",
 CellID->3548275]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InverseJacobiDC - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 50, 13.5889178}", "context" -> "System`", 
    "keywords" -> {"inverse Jacobi", "inverse Jacobi elliptic function dc"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "InverseJacobiDC[v, m] gives the inverse Jacobi elliptic function dc -1 \
(v \\[VerticalSeparator] m).", "synonyms" -> {"inverse Jacobi DC"}, "title" -> 
    "InverseJacobiDC", "type" -> "Symbol", "uri" -> "ref/InverseJacobiDC"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6416, 222, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->604320205]},
 "XRef-2005-4-26-23-37-1.8558342"->{
  Cell[643305, 11195, 192, 7, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342",
   CellID->715886131],
  Cell[645316, 11279, 238, 7, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342",
   CellID->322808586]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 652097, 11525},
 {"XRef-2005-4-26-23-37-1.8558342", 652254, 11529}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2187, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2810, 81, 53, 1, 70, "ObjectName",
 CellID->25280],
Cell[2866, 84, 779, 25, 70, "Usage",
 CellID->29256]
}, Open  ]],
Cell[CellGroupData[{
Cell[3682, 114, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4160, 131, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4283, 137, 533, 21, 70, "Notes",
 CellID->22933],
Cell[4819, 160, 726, 24, 70, "Notes",
 CellID->610144994],
Cell[5548, 186, 114, 3, 70, "Notes",
 CellID->18483],
Cell[5665, 191, 261, 8, 70, "Notes",
 CellID->70927170],
Cell[5929, 201, 232, 7, 70, "Notes",
 CellID->31226],
Cell[6164, 210, 215, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6416, 222, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->604320205],
Cell[CellGroupData[{
Cell[6801, 236, 147, 5, 70, "ExampleSection",
 CellID->36682535],
Cell[6951, 243, 64, 1, 70, "ExampleText",
 CellID->156488630],
Cell[CellGroupData[{
Cell[7040, 248, 137, 4, 28, "Input",
 CellID->25804197],
Cell[7180, 254, 175, 5, 36, "Output",
 CellID->54189033]
}, Open  ]],
Cell[CellGroupData[{
Cell[7392, 264, 128, 4, 28, "Input",
 CellID->75588654],
Cell[7523, 270, 174, 5, 36, "Output",
 CellID->5096536]
}, Open  ]],
Cell[7712, 278, 125, 3, 70, "ExampleDelimiter",
 CellID->306083438],
Cell[CellGroupData[{
Cell[7862, 285, 297, 10, 28, "Input",
 CellID->592668477],
Cell[8162, 297, 2297, 42, 150, "Output",
 Evaluatable->False,
 CellID->3030128]
}, Open  ]],
Cell[10474, 342, 125, 3, 70, "ExampleDelimiter",
 CellID->280795932],
Cell[10602, 347, 60, 1, 70, "ExampleText",
 CellID->511351488],
Cell[CellGroupData[{
Cell[10687, 352, 252, 8, 70, "Input",
 CellID->183899751],
Cell[10942, 362, 1066, 35, 81, "Output",
 CellID->1011815722]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12057, 403, 216, 7, 70, "ExampleSection",
 CellID->19903],
Cell[12276, 412, 73, 1, 70, "ExampleText",
 CellID->55645938],
Cell[CellGroupData[{
Cell[12374, 417, 208, 7, 70, "Input",
 CellID->266251706],
Cell[12585, 426, 272, 7, 36, "Output",
 CellID->291577764]
}, Open  ]],
Cell[12872, 436, 125, 3, 70, "ExampleDelimiter",
 CellID->268824359],
Cell[13000, 441, 70, 1, 70, "ExampleText",
 CellID->132691703],
Cell[CellGroupData[{
Cell[13095, 446, 215, 7, 70, "Input",
 CellID->866802414],
Cell[13313, 455, 235, 7, 36, "Output",
 CellID->126459616]
}, Open  ]],
Cell[13563, 465, 124, 3, 70, "ExampleDelimiter",
 CellID->36479535],
Cell[13690, 470, 113, 3, 70, "ExampleText",
 CellID->579439215],
Cell[CellGroupData[{
Cell[13828, 477, 167, 4, 70, "Input",
 CellID->632752147],
Cell[13998, 483, 228, 6, 36, "Output",
 CellID->104071807]
}, Open  ]],
Cell[14241, 492, 125, 3, 70, "ExampleDelimiter",
 CellID->688497564],
Cell[14369, 497, 231, 7, 70, "ExampleText",
 CellID->43876107],
Cell[CellGroupData[{
Cell[14625, 508, 185, 6, 70, "Input",
 CellID->271543877],
Cell[14813, 516, 342, 11, 36, "Output",
 CellID->344141566]
}, Open  ]],
Cell[15170, 530, 125, 3, 70, "ExampleDelimiter",
 CellID->255377976],
Cell[15298, 535, 92, 1, 70, "ExampleText",
 CellID->328717422],
Cell[CellGroupData[{
Cell[15415, 540, 134, 4, 70, "Input",
 CellID->617758456],
Cell[15552, 546, 190, 6, 36, "Output",
 CellID->578445017]
}, Open  ]],
Cell[CellGroupData[{
Cell[15779, 557, 134, 4, 70, "Input",
 CellID->658205930],
Cell[15916, 563, 158, 5, 36, "Output",
 CellID->386173359]
}, Open  ]],
Cell[16089, 571, 124, 3, 70, "ExampleDelimiter",
 CellID->23210608],
Cell[16216, 576, 203, 7, 70, "ExampleText",
 CellID->471035179],
Cell[CellGroupData[{
Cell[16444, 587, 173, 5, 70, "Input",
 CellID->179888293],
Cell[16620, 594, 323, 11, 52, "Output",
 CellID->431035313]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16992, 611, 239, 7, 70, "ExampleSection",
 CellID->29214],
Cell[17234, 620, 225, 7, 70, "ExampleText",
 CellID->120235099],
Cell[CellGroupData[{
Cell[17484, 631, 271, 9, 70, "Input",
 CellID->77454719],
Cell[17758, 642, 1087, 35, 100, "Output",
 CellID->726014467]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18894, 683, 223, 7, 70, "ExampleSection",
 CellID->14269],
Cell[19120, 692, 123, 3, 70, "ExampleText",
 CellID->147991225],
Cell[CellGroupData[{
Cell[19268, 699, 716, 23, 70, "Input",
 CellID->41283476],
Cell[19987, 724, 621473, 10390, 70, "Output",
 CellID->56971193]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[641509, 11120, 233, 7, 70, "ExampleSection",
 CellID->20632],
Cell[641745, 11129, 73, 1, 70, "ExampleText",
 CellID->196753002],
Cell[CellGroupData[{
Cell[641843, 11134, 379, 12, 70, "Input",
 CellID->5296189],
Cell[642225, 11148, 339, 12, 36, "Output",
 CellID->28262639]
}, Open  ]],
Cell[642579, 11163, 246, 8, 70, "ExampleText",
 CellID->785308763],
Cell[CellGroupData[{
Cell[642850, 11175, 106, 3, 70, "Input",
 CellID->81233632],
Cell[642959, 11180, 203, 7, 36, "Output",
 CellID->751932501]
}, Open  ]],
Cell[643177, 11190, 125, 3, 70, "ExampleDelimiter",
 CellID->390870124],
Cell[643305, 11195, 192, 7, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->715886131],
Cell[CellGroupData[{
Cell[643522, 11206, 225, 8, 70, "Input",
 CellID->809586479],
Cell[643750, 11216, 375, 13, 52, "Output",
 CellID->399796182]
}, Open  ]],
Cell[CellGroupData[{
Cell[644162, 11234, 225, 8, 70, "Input",
 CellID->192074691],
Cell[644390, 11244, 784, 27, 70, "Output",
 CellID->243013801]
}, Open  ]],
Cell[645189, 11274, 124, 3, 70, "ExampleDelimiter",
 CellID->20875427],
Cell[645316, 11279, 238, 7, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->322808586],
Cell[CellGroupData[{
Cell[645579, 11290, 359, 13, 70, "Input",
 CellID->554970152],
Cell[645941, 11305, 452, 8, 70, "Message",
 CellID->22564037],
Cell[646396, 11315, 660, 24, 43, "Output",
 CellID->63533333]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[647105, 11345, 226, 7, 70, "ExampleSection",
 CellID->22797],
Cell[647334, 11354, 113, 3, 70, "ExampleText",
 CellID->3979231],
Cell[CellGroupData[{
Cell[647472, 11361, 185, 6, 70, "Input",
 CellID->563558634],
Cell[647660, 11369, 170, 5, 36, "Output",
 CellID->166191270]
}, Open  ]],
Cell[647845, 11377, 83, 1, 70, "ExampleText",
 CellID->260060486],
Cell[CellGroupData[{
Cell[647953, 11382, 246, 9, 70, "Input",
 CellID->289346646],
Cell[648202, 11393, 325, 9, 36, "Output",
 CellID->151494057]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[648588, 11409, 311, 9, 70, "SeeAlsoSection",
 CellID->30165],
Cell[648902, 11420, 983, 35, 70, "SeeAlso",
 CellID->19703]
}, Open  ]],
Cell[CellGroupData[{
Cell[649922, 11460, 313, 9, 70, "TutorialsSection",
 CellID->7226],
Cell[650238, 11471, 192, 4, 70, "Tutorials",
 CellID->22574]
}, Open  ]],
Cell[CellGroupData[{
Cell[650467, 11480, 319, 9, 70, "MoreAboutSection",
 CellID->718141252],
Cell[650789, 11491, 145, 3, 70, "MoreAbout",
 CellID->3548275]
}, Open  ]],
Cell[650949, 11497, 27, 0, 70, "History"],
Cell[650979, 11499, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

