(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    625584,      11310]
NotebookOptionsPosition[    616983,      11016]
NotebookOutlinePosition[    618633,      11060]
CellTagsIndexPosition[    618493,      11054]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals and Elliptic Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals and Elliptic Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"JacobiDS" :> Documentation`HelpLookup["paclet:ref/JacobiDS"], 
          "InverseJacobiDC" :> 
          Documentation`HelpLookup["paclet:ref/InverseJacobiDC"], 
          "InverseJacobiDN" :> 
          Documentation`HelpLookup["paclet:ref/InverseJacobiDN"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"JacobiDS\"\>", 
       2->"\<\"InverseJacobiDC\"\>", 
       3->"\<\"InverseJacobiDN\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Functions" :> 
          Documentation`HelpLookup["paclet:guide/EllipticFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Elliptic Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InverseJacobiDS", "ObjectName",
 CellID->3578],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InverseJacobiDS",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InverseJacobiDS"], "[", 
       RowBox[{
        StyleBox["v", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the inverse Jacobi elliptic function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox["ds", 
         RowBox[{"-", "1"}]], "(", 
        RowBox[{"v", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
      "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5656]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["ds", 
     RowBox[{"-", "1"}]], "(", 
    RowBox[{"v", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " gives the value of ",
 Cell[BoxData[
  FormBox[
   StyleBox["u", "TI"], TraditionalForm]], "InlineFormula"],
 " for which ",
 Cell[BoxData[
  FormBox[
   RowBox[{"v", "=", 
    RowBox[{"ds", "(", 
     RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->11362],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseJacobiDS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiDS"]], "InlineFormula"],
 " has branch cut discontinuities in the complex ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " plane with branch points at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"0", ",", 
    RowBox[{"\[PlusMinus]", 
     SqrtBox["m"]}], ",", 
    RowBox[{"\[PlusMinus]", 
     SqrtBox[
      RowBox[{"1", "-", "m"}]]}]}], TraditionalForm]], "InlineMath"],
 " and infinity, and in the complex ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " plane with branch points at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["z", "2"]}], ",", 
    RowBox[{"1", "-", 
     SuperscriptBox["z", "2"]}]}], TraditionalForm]], "InlineMath"],
 " and infinity."
}], "Notes",
 CellID->461907696],

Cell["\<\
The inverse Jacobi elliptic functions are related to elliptic integrals. \
\>", "Notes",
 CellID->18694],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["InverseJacobiDS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiDS"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->163373648],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseJacobiDS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiDS"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseJacobiDS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiDS"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->160925632],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->39610659],

Cell["Evaluate numerically:", "ExampleText",
 CellID->125373990],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiDS", "[", 
  RowBox[{"1.3", ",", "0.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->434514784],

Cell[BoxData["0.7762227451402881`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->254109312]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiDS", "[", 
  RowBox[{"%", ",", "0.5"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->33244989],

Cell[BoxData["1.2999999999999998`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->90261202]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->452968241],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"InverseJacobiDS", "[", 
    RowBox[{"x", ",", 
     RowBox[{"1", "/", "3"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->471471100],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->497848107]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->391202108],

Cell["Series expansion:", "ExampleText",
 CellID->576334791],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"InverseJacobiDS", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->40049435],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"ArcSin", "[", 
    FractionBox["1", "z"], "]"}], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SqrtBox[
         FractionBox[
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["z", "2"]}], 
          SuperscriptBox["z", "2"]]]}], "-", 
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        SqrtBox[
         FractionBox[
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["z", "2"]}], 
          SuperscriptBox["z", "2"]]]}], "-", 
       RowBox[{"z", " ", 
        RowBox[{"ArcSin", "[", 
         FractionBox["1", "z"], "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["z", "3"], " ", 
        RowBox[{"ArcSin", "[", 
         FractionBox["1", "z"], "]"}]}]}], ")"}], " ", "m"}], 
    RowBox[{"4", " ", "z", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["z", "2"]}], ")"}]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "m", "]"}], "2"],
    SeriesData[$CellContext`m, 0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`m, 0, {
    ArcSin[$CellContext`z^(-1)], 
    Rational[1, 
      4] $CellContext`z^(-1) (-1 + $CellContext`z^2)^(-1) \
(-($CellContext`z^(-2) (-1 + $CellContext`z^2))^
       Rational[
        1, 2] - $CellContext`z^2 ($CellContext`z^(-2) (-1 + \
$CellContext`z^2))^Rational[1, 2] - $CellContext`z 
     ArcSin[$CellContext`z^(-1)] + $CellContext`z^3 
      ArcSin[$CellContext`z^(-1)])}, 0, 2, 1],
  Editable->False]], "Output",
 ImageSize->{476, 65},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->189197912]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12793],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->55645938],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiDS", "[", 
  RowBox[{
   RowBox[{"0.2", "+", "I"}], ",", 
   RowBox[{"0.1", "-", 
    RowBox[{"0.3", "I"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->266251706],

Cell[BoxData[
 RowBox[{"2.1501216660804077`", "\[InvisibleSpace]", "+", 
  RowBox[{"2.8916488706797465`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->102277232]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->268824359],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->132691703],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"InverseJacobiDS", "[", 
    RowBox[{"3", ",", 
     RowBox[{"1", "/", "2"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->866802414],

Cell[BoxData["0.\
3334363465332171666393630203947404377327407123418739535291581935501`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->212904662]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->36479535],

Cell["\<\
The precision of the input tracks the precision of the output:\
\>", "ExampleText",
 CellID->579439215],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiDS", "[", 
  RowBox[{"3", ",", "0.50000000000000000000000000000000"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->632752147],

Cell[BoxData["0.333436346533217166639363020394740437732743572692`30.\
845031134925023"], "Output",
 ImageSize->{235, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->61060713]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->688497564],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseJacobiDS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiDS"]], "InlineFormula"],
 " threads element\[Hyphen]wise over lists:"
}], "ExampleText",
 CellID->43876107],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiDS", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u1", ",", "u2"}], "}"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->271543877],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"InverseJacobiDS", "[", 
    RowBox[{"u1", ",", "m"}], "]"}], ",", 
   RowBox[{"InverseJacobiDS", "[", 
    RowBox[{"u2", ",", "m"}], "]"}]}], "}"}]], "Output",
 ImageSize->{332, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->878473131]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->255377976],

Cell["Simple exact results are generated automatically:", "ExampleText",
 CellID->328717422],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"InverseJacobiDS", "[", 
    RowBox[{"z", ",", "0"}], "]"}], ",", 
   RowBox[{"InverseJacobiDS", "[", 
    RowBox[{"z", ",", "1"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->617758456],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ArcCsc", "[", "z", "]"}], ",", 
   RowBox[{"ArcCsch", "[", "z", "]"}]}], "}"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->253698890]
}, Open  ]],

Cell["Parity transformation is automatically applied:", "ExampleText",
 CellID->368884824],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiDS", "[", 
  RowBox[{
   RowBox[{"-", "u"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->508781695],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"InverseJacobiDS", "[", 
   RowBox[{"u", ",", "m"}], "]"}]}]], "Output",
 ImageSize->{156, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->141287473]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23210608],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->471035179],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseJacobiDS", "[", 
   RowBox[{"z", ",", "m"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->179888293],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["ds", 
    RowBox[{"-", "1"}]], "(", 
   RowBox[{"z", "\[VerticalSeparator]", "m"}], ")"}], 
  TraditionalForm]], "Output",
 ImageSize->{59, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->1659560]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6058],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseJacobiDS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiDS"]], "InlineFormula"],
 " can be applied to a power series:"
}], "ExampleText",
 CellID->120235099],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseJacobiDS", "[", 
   RowBox[{"x", ",", 
    RowBox[{
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", "m"}], "]"}], "+", 
     RowBox[{
      RowBox[{"O", "[", "m", "]"}], "^", "3"}]}]}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->77454719],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"ArcSin", "[", 
    FractionBox["1", "x"], "]"}], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SqrtBox[
          RowBox[{"1", "-", 
           FractionBox["1", 
            SuperscriptBox["x", "2"]]}]]}], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SuperscriptBox["x", "2"]}], ")"}]}], "+", 
       RowBox[{"x", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["x", "2"]}], ")"}], " ", 
        RowBox[{"ArcSin", "[", 
         FractionBox["1", "x"], "]"}]}]}], ")"}], " ", "m"}], 
    RowBox[{"4", " ", "x", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["x", "2"]}], ")"}]}]], "+", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"320", " ", 
      SuperscriptBox["x", "5"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["x", "2"]}], ")"}], "2"]}]], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "5"}], " ", 
        SqrtBox[
         RowBox[{"1", "-", 
          FractionBox["1", 
           SuperscriptBox["x", "2"]]}]], " ", 
        SuperscriptBox["x", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"6", "+", 
          RowBox[{"5", " ", 
           SuperscriptBox["x", "2"]}], "-", 
          RowBox[{"44", " ", 
           SuperscriptBox["x", "4"]}], "+", 
          RowBox[{"25", " ", 
           SuperscriptBox["x", "6"]}]}], ")"}]}], "+", 
       RowBox[{"125", " ", 
        SuperscriptBox["x", "5"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["x", "2"]}], ")"}], "2"], " ", 
        RowBox[{"ArcSin", "[", 
         FractionBox["1", "x"], "]"}]}], "+", 
       RowBox[{"16", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["x", "2"]}], ")"}], "2"], " ", 
        RowBox[{"Hypergeometric2F1", "[", 
         RowBox[{
          FractionBox["5", "2"], ",", 
          FractionBox["3", "2"], ",", 
          FractionBox["7", "2"], ",", 
          FractionBox["1", 
           SuperscriptBox["x", "2"]]}], "]"}]}]}], ")"}], " ", 
     SuperscriptBox["m", "2"]}]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "m", "]"}], "3"],
    SeriesData[$CellContext`m, 0, {}, 0, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`m, 0, {
    ArcSin[$CellContext`x^(-1)], 
    Rational[1, 
      4] $CellContext`x^(-1) (-1 + $CellContext`x^2)^(-1) (-(
        1 - $CellContext`x^(-2))^Rational[1, 2] (
       1 + $CellContext`x^2) + $CellContext`x (-1 + $CellContext`x^2) 
      ArcSin[$CellContext`x^(-1)]), 
    Rational[1, 
      320] $CellContext`x^(-5) (-1 + $CellContext`x^2)^(-2) ((-5) (
        1 - $CellContext`x^(-2))^Rational[1, 2] $CellContext`x^2 (6 + 
       5 $CellContext`x^2 - 44 $CellContext`x^4 + 25 $CellContext`x^6) + 
     125 $CellContext`x^5 (-1 + $CellContext`x^2)^2 
      ArcSin[$CellContext`x^(-1)] + 
     16 (-1 + $CellContext`x^2)^2 Hypergeometric2F1[
        Rational[5, 2], 
        Rational[3, 2], 
        Rational[7, 2], $CellContext`x^(-2)])}, 0, 3, 1],
  Editable->False]], "Output",
 ImageSize->{548, 149},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->72588153]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12314],

Cell["\<\
Plot contours of constant real and imaginary parts in the complex plane:\
\>", "ExampleText",
 CellID->147991225],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ContourPlot", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"InverseJacobiDS", "[", 
       RowBox[{
        RowBox[{"x", "+", 
         RowBox[{"I", " ", "y"}]}], ",", 
        RowBox[{"1", "+", "I"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
     RowBox[{"Contours", "\[Rule]", "24"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{"Re", ",", "Im"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41283476],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyMnXVcVUv3/2mw69pdV6967a59bMW4dnvtwsQAG7FRUURQFJROExOLffTq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     "], {{
       {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
        GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl1lslFUYhk9bSqcz7QBGmNJlJtqpXdQLTLxSk6KSCC0kGpGSoBiNWIvR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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwllE1IlGEQx0c3dXd1TUX31VbfpXxtW+sUdBLCQx3CFspI7FBGUZFJEVkR
pViH6JSBHgL7kMoIijSKDkafa36Uhl6jsmKDoE+KrDSr3zCHged9npn5/2fm
P+/8LXtqd6eLyBpsDlZfKvIX8/tFRnwiYUfkrSfyOCiyPUNkJl+kM0/kCs7H
eU/w1ox18t7I+3CUOGxDQGQx+X7y9oIcE7yPY59ckbpiESdb5BsY9/i+i1Vm
ipzOEjkREynEvx1SeTkiRY7d6bkFzEfkHguJxMldFzAuf/CZyjBOPbkioyHj
FiHn3gqRpQUiT3yG+QGsI3A6A5duYq5Sa1ZYZBlcXoH/0TUfffvK3Sl8g2De
1vzEhEvghIXSRGLkH+PtGbYRLkvgtC4icnOuxdaTz4XfUXKcJ3aQHPlwTYL5
nPNWLJvYHGxblmG0wddxrNcr4FtDvtUR620+mAnHatTa2rlrIbYVi4G/MGC9
OQn/Lr/1SGvfVC6yIGg9+OzaDLT337G1YcuhseozS/5/3DUFracNcO0Bvwvs
ETgmmN0I+EnO1XAYYjat1HcW/3NYnNwx7AGzWOk335cRm63GtOG7E4yLGeY/
yHmSu2TQNKbYvcQP+I1DX5nIDWyS2ENo4g2+rz07a0wfvvfBSInF9IHVi03D
9wIYpfhGPOud9mQ413qsvdUZHlbu1DSRaZpo8YyjctOaDuJ7AHtPrnnEzNKP
5WDW+21HrsMtVWTa1JlO0esfWEe6zeRaqWlMtaU1qNYWudYb1Vwb56pi05Jq
oBms/RWGpTVVcx4PmbZ0R7S378hfFbQe3+G73zUt+YjvUL0xz3jAOOzzTDOq
Fd1RrbXdMy1rzbt4O8Z3P+dL+CSJHcDWE18J5ijnp1HbZdX4L3xvoe+ZNNvp
Id4Go+arO78Zbg3l9u9QDqvgtsOxWSiGzuaLa9rTGelulOVZv3VHVGuXI6Yt
1VyKXIUlVpvWnCC2yTGutdz9Jn7as3+Lzkhnozuou6czasS3xjVf1dxDuAYK
7N+hNWot3cW2m1rTf3NMwfs=
           "],
           VertexColors->None]}]}, 
       {RGBColor[
        0.32098659016125425`, 0.10534221043893108`, 0.5681657997689129], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXlw1dUVxy8heS/v9xKzkORleXmPmESWinWwAygoqBAViiIg7YhLcRRE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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3mQ1nMcx79tzz77PE/btrvV83u25+l5NvtEmXFMjKtoRTm2VI4YUmqQ
CulwVptr3EJLW0ajIZFSW/6gyNGhJDEoM+jUUkjGOHJkvN7e/vjMfL+/7+e+
f91GT7jwxpIQwudADCirDmFOOoS9XJ5rG8L47iFckAmhfbsQyoEBdSG8WxHC
PnA7pkL4LBdCDTS/loXwC/BeFMKeYghXc/6y1LxuqQrh65h5boS2cw2yeB/D
+85CCBH0E5Mh3ATUQP8wNKMSIYzl/TL4r+gawqnc10DzLPgvAvM4D4uHsJnz
JuAFdB0B/b3ouhz6fry/yvtk9L8ZyKL7YO7bOoTwJPcx3LMY3pIN4TpkXgf/
26DZh30PQn8mttUDP/A+Gp4Xxy1zS3tsRN7lyCpFv0Z4tYF+MOdT4DkwH8L1
3K+H33hgEL7owv1meE0BukB7hGyGPg0sh34771vQfzr0PyJ7EDKHIqsPPEtq
8QP+eQrcJuD1o0JoLtj2GeUh9IT/PHy0GPwr4d8XXWeCc1S5dVrK2w2VIdyN
rbvAORb99nBv5d6Afh2RfRX8S3i7Gvxm5Gci+14x24q/3oPfBvjVQDMo45xQ
LnRsE8Ik5A8EvwnZs4DDnB8Bvyv4DfC4HdzN+Oxk8uUIaNLEvg88mhLOgVHg
z+S+Enuawe/IOQuUc48BLei7LG9e6xO2rZ73Y+K2sTP0X3cO4QTeril1biom
ioVy9AHsWY8P9iNrI/b8Rnxn4L9WzgPQdyj6d4XHVM53AHHwZ+Gf53mfBXyE
7h8UnFtx+G/gvB5Y0NY50IrsnOoDfRpjzpXH0fGYcufMj+h+MO/c6s/9ryr7
RL6YjT/rOZ8OzWFk/52y7BzxP6nMOvRH355p11o1cBH6Hou+jZynpxybRr5t
LHeM8rwlwO/A2wT0/Qrb5yD/xYRrdB33C9K2bR/3Ocj7iRzbiS2L+bYL2wrw
uyLlmnyZ2tuLjSdCf3zCtbOafOkUcw1VgLujg2tJOfpQ2jWk2ukHvIR+LcC1
6HYHOG+DvwQd3+LtTWAO50KlfbcJfd9E19XANmRtBYbCbwT8fsZ3C8H5tgu1
Qw6VonsvYDb8ngZWwOv9UvuuOnIuy4e5yDFWbIci/xpkbeC+mvtU7kuxbxo2
F5O2cQayexOPWZyfSDi2B9OuRcX4EPFbioxb4V3KfQ3+nAp9HfTfyJ9F6yRd
liPj1u7uQeo9Ofy1Gd3j+Osd7t3AP4P7SxXuVe2578fWTeQcLvuvBymXLs/Y
d8op1UqnjGWrZs5D3w+gz1CLYxKu5UpsHl3qmt4Lv1bgbN7i4PRC19fQbxW8
PwXnDeg71fjtE3AynDdXOHfi0Ddgaw/0PwD+EO5peEeRe7d6/CvYvxwfnpJw
vqp3LergWlYPGwT/A/ivd6l7omL3doVrWTHcjS47i54V65BxIeeVxOijEtek
esnfkWtFPaUn/HoATTHbpNpWTiuXVeNv8bY9696kHFqArMV8ez1hn34Jr1u6
Oxb3g9+C7sOR90XcNswHaW/Os0w5Oxl9phTdu9XDloC/GChr43pQLQyocexU
E2cQmx3If7TMPUq9STUkXPWoHmn3ZPXik7jv4X3R/++9Ep51I4lXXcozrwp9
ByJ/EvdvoRkJ7QigL7wnlrmXf1fnWlNPV29VDit31WP7cq7PW1axrXP39yr3
VuXwnbxN41umxDm/jfM4eOTb2Yax8B5V51rRzBqHPudDMxbcccB0dJsBXMJ7
/+Be063oWaSeo1n+PfRnpTzTNWvPBefahGfu7+D+CXzC+35y4AfeXiV/DuHf
g7xX499zoO/E+yL0b0f+poDDvP0DfEa8aitd20Oom95Z0whXO4Biu6vo3FKM
JXtM5FqRDktyzmHlrnJKuj6S9myUzken3YPVe6WDeuUBYHvSPVO9VjNds1w9
V725tsa1ox49HNrB4LwQc80rlqvyrjXFdCr3acX/bQVnFbxWAme1dc6qN63N
OfbqUQeR3Vx0b9mRdK+uBYan3LN1bkHeF2X+pt1jYNa1qx1kfeSepV6lHrG1
wjzFSzb9F9vIsVSM30X+OuBS3p5HpyHwvrLOs1Q25fHvbPCP43xuiWtXO412
GdXwKs4rgIXQ9kl6V9sCjEx6Z0tVe6fRLiMczdb3gSuSnrE57JmJTjF0HZZy
rpYXHHvlbD/OpxXcy+7FplbO3wDHJ71TpQvOEeWGfHIY2//JeZdUjl2FLXdq
p4y55rQr7eY+KemdSb2rIe9cVw8bT+08VrAttfBvAv/XOu8SR/PtcfR9rOhY
KkfHR94JtQvOT7lWtFNpl1LNbNCuVGnfaYY3RN6ptEspB7TbPQXkSrzjLeNt
FD57Muke/kfRPU29TDWkWMynfrfGHRPNple6urdoRmn3aSx4lmoH0ixem7Xv
NJMXRJ7Rms2akYc4fxW5NsVTsyBbdCw0E+Zybub9njLP4CMj7yjaTaTzM5zn
Rp7twpHu2mm1y8oG+f6ugn2nGKwteMfWbq2cW8M9We3cUw7cV/DOol1FMd5Y
8I6m3Uw58yH3j9t7l1KOZar9j6F/C8VUu+qHNZ692lm1e2nn0K6hHUz/Oguz
7q3652mBdnKVe2c99BOxf1jGu5x2kindvZNoF9E/hnrnsoJx1UM1m+8uOvaa
0dptE9X+t9KO+y/iut6D
           "],
           VertexColors->None]}]}, 
       {RGBColor[
        0.3545898522468671, 0.16376920814076587`, 0.6153992497179909], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmWtw1NUZxv/JZnNjF5IFNosbsrFsRCCDrZV2xJlq1V7UGkhQAbWdVmda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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJw1lntM1WUYx19B7sERzHMOt3NADiJgWF5q002tnK6couBWaraJy6WWtZrm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           "],
           VertexColors->None], PolygonBox[{{5810, 6332, 1767, 6971, 5809}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.3881931143324801, 0.22219620584260077`, 0.6626326996670691], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHtwlVcVxU8I9+aS5CaQdMiFhEtoEkBboC0qIxJejuOjQJBQLQUcHzP+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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3twVdUVxjcNN++ScGOTG+7l3jxuCIIKMyh0BKvT2lFHB2LA1keLLXTU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           "],
           VertexColors->None], PolygonBox[{{7007, 7011, 1784, 4666, 7006}},
           VertexColors->None]}]}, 
       {RGBColor[0.421796376418093, 0.28062320354443554`, 0.709866149616147], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl11s1eUdxx9aek57XqAvyjlN239Tcxqu1FTMhG0uAsrmskHLvNhcALPd
rBctTipGFG/mlmnUBKuAMXHDLIWOGgN9QWi7JZpd7GKKkUFhCdti1GWImkwn
gk6/n31/jV788zznefm9fn/f33N6frJ983BdSumnS1Kq13iimNInWrikry+X
0oqGlLZp/a2mlM4UUhrXuUfzKZ3V/D3tzepSu8brtX6xklKxN6UF7V0vORWt
T2h/TvOZomU+qXGH1v8tmTPdKU3ru6LfP+pM6eXMezdIb1eDde/XPNN4V7L+
hbDhJMZK3oVYxz7sGch5vEVndhZsw2adKUv+NyR/Qrbfqm86571rSjqn+TJ9
zeFPTXen9Pvq8P3mXt/n7t/l42sdKb2rvY21lPr13Vfwhz50rZaejorn8yXv
IXNpOaV7de9bmp9uS6nQ4ljj97rwHb8586HWdzemtEVfXZ19vdxgf3dKdr9s
OKzfN2v8pr71su0RnX200ee4u73g+6tylols7rD2hvwczPkssheWpfSKbOiT
baMan9L3fMi6EnqJFz6Su4N57w9ofkjjpbxxcL5gG7Dl1/Lxf80p/Vfy9xQd
W3BCTvfpq+p8Tr6sl66t4evWsO02yXs2cLBL8f9r2fm4UnMOiP8/NH6q3xc1
H9c3l/PdLp3v7LUtZ+TXHZn35rR3Im8b8AUMgM+3m4wfcIWOf2n9cL2xBNbB
E/uc26T1l6uKVdXnFvc2av03K5VX6RuSD5+3C2/LLXO0aNy/UG8MNOj7nubH
ip7PRH2wBzau070XFbtDmjdJ3p81H06+Txyxf0/IJBfU2rqS8XaPcDqi76Ts
3iRcTC83fj6V7AckZ0hnTknmtR3G5Fje2KHWFjpck+R7Y09KN/bYZ/wZa3DN
Ie+FqmUOgNmKY1/QmT9JzhKtf5L3Hc6frzhn5AscMH6k8aUVzivxBkt7I+bw
ypnglpOy5/UO5+BVjZ81++5rsrGt1fEYaHA9k88DOeMGzFDLF3LGHHEaDd4h
J2t7nJfvau32ou1G7vmc6267dK3VtyFvPisHp/1HOf1nxXg7qBgcqvrOEcXh
1lbHgDpbGvldov37M9cD+Pi4zrz0q5pxCSapmbmoC2K8Ied6PF1v/1gfks5d
mffqNF+b2e9f1rzH+oi+HXBYzpy2XOMP6xyD9uC1X+j89or14DP75Aus/L7g
nB4pOhbEAd6Ai8Ek46rcl/y06ivrfTH/epNzRd10Sc4a/e7POcaDYc/qJu+x
frbks8SE+ULJ69xDFntgcVOj+ed34svCVa7BDcHZxOom4f0mxWQqb265o9E9
A47ZGzW+teB1OGef5DyvWvh+vfEH7uD5dcph6nLsiRu8RuxaNW/JuQeRMzgU
nrmc91lyRD4q0deop6nondQCdUCOx5Tzr2XmTHwdCbnscQYf4ZSBRtvUEvlE
L7+ZY+fBZe4x1PsBjZsy5/vj6Nnbou/MlczXo7Lhybz9yMIfZL6oGtybuVbu
1Lglc99Yw5g5XsMV4wbM3Kv5DzL7P1Jx/Y8HL4xFH/m51jdq/VCDe3uqBp9o
7Z6K1y90O9bE7gbJ7qs5P3DnwzVzR4dq7pkVzv1cm3NGvsAQMsDtq53OPXl/
SHrOls0BR6XrdsnZHFilFsEz/i2t2MddeduOHPoOPoH/9a22D9syybym1zgj
ltQQ+aWHzEW+wPUj0SeJDb0ZWdd1OL7E9kGtP5Q59nfK3sku199W2bul7D7U
F/mjjuCrPdEv4KyBwBU+1Vfs11nFaqrL/fq3mXEABrC3q2qbP6w6Fpwn//2B
N+arozaPyq8jJZ8ZKphL0ffjHtcbtcY7YrE/wxO7402Cft4N2DDW6JrB3wH5
2K9vlh5Uc7/5/5sq71oE//DrLcGxFel5rNs29QXnUDvN0RPA6mz0PuKAveNR
gx9Iz3MrXWet4VtL8D45Qy/jfMx5i81HXYAL+A5sbCs7H7zx3oo+D2d/3ul+
Qy5Ol/0WnIh+ORW19qDivH+l3ytHi5ZJn3265B4PbnnrfdDm9x4c+mz4SI/9
WfRZYjEafpwqmcfJ4x8k449FvwHgDbgSzoQnzwVnwiULsU7vxHbm2LW7an34
TCyI4bmQw9032/zm4L3RH3KIIW8K3hbkbUfgE3+J9/udjjk2nop+g43YSuwY
jxdtB3rOBdc/l3eNEvN+YfPuimtxKuJGTsar7q/01ovS816n35fwOfUCh2+J
fDHvUc2+220+pjYvxxuvOXoiNuMDvoA/anG4w/WI/s2ZbdgZvROOgcs5D8fS
8//W7r7/HeH52zXXCj7DRZynT1wKXpgOOyei5++IHgc2eAN9FGsjsX4g+iox
wYbB6Gv4ty18pE55X8BXcAc9Fb2MvGOowcHotczB3UuBPfiJPdbxYfEt1hI2
NEcv3Rl6J4Kb8ON4/G/DD96qS+O9OhjnseEJxf7xbuNxMfeL751LwWnEaVe8
D+kr++P9T073Rz8i/0fj/bE3/iOwDnbHouaon7mwCR4gLshEH7ai87M2v5uH
4//s8agdeu9fOs0/8B3334h7J0LmPp05VTafjccZ5KNnMnKAbbxZkXM8MI98
bJ+MHG/4Sr+dL9pmbAcX++JNQk2siXcO+mfjzHTR9UDuJsNH7OUOutE7EzKp
Wd4L2ANXTkYM4R/25+MMuTsW9XU+6hC8zUbN0MvAy7E4X+r1fxjeyYdDL7lg
H15DzmzEDd+xdzr0Hgn7h+L8TMh8us3/Q1inr8+GXuRNhW1TIR/fyQd3wQ//
I99pd2y/ABDmS5A=
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3twlNUZxg+RsCEXkuyCWbqbTWI2ph3FQoeWCqEVAW8zNcAgHbEVNLRi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           "],
           VertexColors->None], 
          PolygonBox[{{6619, 9470, 9469, 6112, 1517}, {6319, 7282, 2000, 7286,
            6318}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.4553996385037059, 0.33905020124627044`, 0.7570995995652251], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1l1lsVVUUhjed7m17b6G1tNCRy+21QY0WIRBbIggIhMgkglAa4/BmYhuN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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHtwlFcZxg+BhN1cyW66yXY3Idu9ZKxcxClSJaCBtlzGKVYnCRBkCAVt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           "],
           VertexColors->None], 
          PolygonBox[{{7774, 7772, 1363, 5892, 7773}, {9486, 6656, 6655, 9484,
            2778}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.48900290058931883`, 0.3974771989481053, 0.8043330495143032], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFll1o1nUUx8825zM3Zzpqc3PP4+PWnEJIL0682Iws3yCKVtu0zHRCFyK9
qBEYmFBNQbroMi+0i7BELQ0yZaRYGfMiUEFQu9EgejEtpTe1tO/H75Eufjy/
5/c7v3O+53ve/lMGX+x9oTIifteq0jpbH/HJuIiXtL9YE9FZG/FDRcRU/U5j
jYpY2x4x0BixT/s+/a5p992eUsTs1oi51RGLxkTUjY04Jh1NhYgVku3S2qt1
j84+lNG7dL5OsvfpbEB2H9K+XeuxOyO2N0cM6vzZcsSrWt9IX+Uk4ZgQcVNv
PxLYDtmcof2ByRGfTbbN1+siTujdv5W+n5qYe2qMF7trixEPak3X2by7Ix7R
WiW5vRMjdjUYT6P2V2VrdZX56C6Zk47Uh9196Q8694+O+Fj+TBH+WTqbrf8z
9fbd8RHPFy1zbYL1ovO4sN6rs9FaZ3VWKZlLetMj/N1an0vXX+L1mtZC2bwo
/xYI2xm9bau27OHU06Xf+YrR9YLfPVDh+BxrNUY46Mg4YpM4YHdawbiJzYhk
d0y0P9yvSB+3S/82rSthHAu0Lodtcw7Pjys+I50Rh8b4Hjl8nF5w7InjUvG3
TGuDOL8puag1ZuL5XZtjOloc1GiNl8yvOhtus9wG5cIM8bhUMueUA+snmNuC
ZP9pM7a+etsGzyblXYdsfi/9IVtTc1+r80WJn3y6UGOd6GgpW8974nig7BiT
I0syTyYWHNNZycus5LBVsoeFp7fKdrBXqvRvRe7/Vgy3Ntr2ouQHDF/rfn21
bY3ofkuz8wde4R2d38qvKa3OrUOpE9/4rUz9Dytu5ycZ341K5wP6h+rMCbEg
zui+XTf8kg9fKm7bG6yTWoUj3lK7tVm/1AN1ii1sPl3w/gviX22/t3QYBxhe
0/6g/GnR3QxhPy8f9hbsJ/7CHzrIhWH9HxH/l8Y5H7qSX7h9udm8gHuVeD4v
mXmS2VlrHHBwtd11hY/4u6nO9dEnPqqbbAd84CQH/rgjYnez6+At3b/SagwH
m913BhMj8SbGvB9O36m9obGuL+7IQXCS49Oyx7UL4/0t7hWbxzoXeQcXvAUD
PWpbxncoZTgfqXHs0PmB8v1P+bAz83lz5vTyWtcPcR7O3gk2uIjMjY11ttGb
NcqeuuB3Y/bH/nrXDHtyBH3EPVI/9QiP1DlvV9TaNv0ZjuEazvGZ3CKf6JGf
Fu37uXHOCfIB/UOJgXzCT7ijrnpyFjxaNHe87VfM17X7rllxL5ZdD3B4Pftb
ddH9gl7xnGK3rNnzBH/wC1v84ueNnBfUOjk/p9q64ByOd4w3z+DsS/mBfIs+
eio9GS6w15P9uUL256t2TldZljfwwxwbyLfI8obeskZ5sbrFfZE8I2/Id3Qj
hwzx6s790bLzlVztzFkG/v60A07yek76Qh96v9FxP6XfmZprg3qzu+TZzFxe
2+o5R97gD9jhc798mZO9jtnCOfe/MefH2cYvNe6ZcEU/frNsTp8puZbIR+p4
V9m1/JR+nyy7T4DrUPZJ+Jmbs/4J3fdqHRljm3tGGc+ksmNP3Ddr9o0q+m6J
zhaX3TvfKfv74HYvBx/88C1QaPL3wMpa5y62unJeUl/8X555fzNnKPsj6odf
dbre8O1C6tyZe/oPOk7k/ObtrZrMHKNX8a47axwOya++snWAZTDl+3X2Y8m4
8e1MxoLcOpz70/Xup+Tr+ur/5w++Hcs6+kk6fi75e405/EaTZ8VgznJwHpCt
bWXjpv54S70vbvT33L7s8UdyXi5P3sCJLnouPYZvN74R4AE+4J79upwDpZw/
8HKrn1fZHrZ6hPFyo+MPlpOJhzl/Kmc9ebEy4zWvwTVGXsxMPcSuI+csOb9R
91uLxsU33MrUsbDB30xwytw4WjJO7B1PbPReeIXnK43GBzb8I1bI09+IK5wz
w6gN+mJV0XlJ3E6WjAMM9Oqh7PnE9WLmz1DOJfrS20V/F9L3/gPV5YCN
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHtwlOUVxl8CIcnmsskGNtnd3DbJ7mIvXEQpzHCpIMjFjhYFggYcAqQl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           "],
           VertexColors->None], 
          PolygonBox[{{6706, 7189, 7188, 3546, 112}, {6499, 6316, 1073, 4779, 
           6498}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.5226061626749318, 0.45590419664994014`, 0.8515664994633813], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlU1o3FUUxW9NxmQyMTFhOkkzk2SatH6ARJqKCGJBjLgrbRIpUk0gSnGj
ojULcSGIurbdxZVN6kaDIoqi0Bpak7R2pWIt0kZ0oUJRmgnFbvw4v54bsni8
93/z7r3nnnPvnZ0zL4w/f0tEfKjVpPVGc8RlHaZ0+VUxYkH7vNZae8QVrT0l
valEHOyJOKu37xW9f6c3c30Rq7dHfK/zky0Rf98aMVmI+KAa8b7WrO6u9kd8
rrWvNWJM/kblb1TxZgciXtR6S/ffaF3Q2gjH4/sZnUdui7hXa04+97dFnFDs
9Wb7+zZ9fiIfnw7Y/pp+a2hNyH9hKOLxTmHZFvFwq+04Hy367X06zxcdi7jk
OpKxyiWf4WF7yRi4my1HPNIhH3p/Q/G7B+x7X8Ym7uqwf+P+t2FzB19LRfNL
7mAkHzCdkb/9OyL+lM+fdJ7SeVTY/hX+wXrESdm8I0zTbcZ8Tf5e6bIf7IlD
3F8HI+7udn43dgqb7DeK1gNd8F8pWRNyfLUW8ZrWXvn4WnjvV+yX9GZB/s/s
dj7/Kc5D+u0X2R/osd5ofZfifKF3S022+6PPtte1/6j7XQVz/+WwOadGXi/b
9qNuxybuzwXjo+bg9XDZ3L4r3E1trk24PZT8nhf+cyX7Qbc7Sq6TU/kGDIvS
ZL3iu0bF+WDL2zvz/dvKb6bHvC52+pvzwbo1gP+1rFVqgH1P2hKXM1pc740Y
r5nfz8Tr6cRAHOLBzw+Kv3eXOeGb+8e2OWdyR5fj7a4P4qLraMZC/6PdrgF0
AyPaEedUxmoUrTM8U6fUK2/YqVn8T8rPgbpjRLN5pd+ruuurm+8HpdGgamZa
98+W/c0ZHbpat2yYFeA/1m4NyYM47MQCw0j2yz1DrkXw/aX6/GfIvXZEs2Gm
6pnRSEz4Bjc5wm1BOi51ubY3Y6AFPcvsAUNBtTlRM6/kW8nc6eW59EO9LJds
Q12f7tqqB7TED79Ppc/NuiQm++EW6wSWtX7jgS/4APd2xSq3u8dr4rK/7jlF
j6/nTFjPt2j0svT8fdhzdKHoHWwrwrBaMucriZle4G4lz9QduZHXmxXPF+Iy
PyZ7zT8zBm3AP637xV73L3OWXMgJ7Gh6OWttLec8tjdndJPjcA/n2MML9QnW
5dIWbyvJ3dkOa4y+YIIT3oKF+saWnW/izGf+vCFn6gA/xDmW7+GskbW9kDYb
2YOcwXAy/XA/tuk7OcQvPsGCTswNeuB4vnt6h2fczfkm3cazR9DrRNYl9VNO
W+oYPPhlHjNr0eIJ1fJTVfMLp0vZI9Qms5JveuJK8nlJ54873OPLOdPQl/18
ni9K37GcG4fyP4Z+Z/ZP1K3Ro/r9gZpnDzPmYs5eNCc38nqu6jnFjLqQ/7Vg
blEtt/a7DsjvXPYI87uzaj/Uxlhi/h/H3S5V
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJw1mHlwFdQVxm+CEcj2kvfCy9uybzB1BERF22FR6LQVpIJ2BBHoUEgsQZAE
KtYWbEFUFqdirSWWTcFOSWKHRSQIIYggjNgZkpFCoVrCYkEtWYidsZb093Fu
//jmnffeXc4995zvnHOLZs6fNC/ZOfedJOdu4vOTPOc+ByP7OfdgH+daK5xr
Tzh3DpxAPhtwrq7MuXXgDHJH0LmLyBfAVeRNJc41ggawEUwscm44uBM8AL4p
dq4v62ezfp9UxuYzFuznezO4qwC51Ll9YDjyW+y5G7wNGkFmzLks9gqADOTX
0OsL9PhceiGX8ZnMPkmgFPkEe70PapydKcheKfl2tnv4PrbIdJRuY8D32XM0
GAW+B1rYZw94BxzQvozpKXTuGsgsMt3eBFu9jt2c+S+M+wh0IY8M2B5aewRy
NZ/TwTQwBxzDZqcY+1dwFLk6i7mc/TiYg7wt17nDyO+DPyF3hlkH/R/uZzZr
QI8msAfUg8cizv0OPV4BVcg7mHMsztpgO/I05i/kv1rwKPKDzHkItPR37jZs
8h/Wfhc994KvkZeE+L3cuaHgl8hrGTsdTAMvgZ58m6Ox18B/ud/rYAvrdTtb
63V031xqaw7EpkPAYFBRYLbK4tyBoNnsR+hcj66L+joXTsOu7DmKvUeCLciD
sFkCxMFAsCCbs7LOb8ETyJ9EuXvWceDvyP9gzJfgC/ApWIqPLAOfpjg3DIc/
wJwE59iMvhNSzffeBru8Dz7HOqXYrQSsQG5j7BFwGLQWmu7N2HJ/hZ0hVmg+
Lt/exJo5rHGBc58HIeTV4Bes9TRYhZyRw11wthqQjhwHS5GXgBjyZ/jQs9zT
IXTdynp7kds5ay3yDPa4nXXKOWcZGIa8mP2rwRzwJDiOzaaw1mTwIXI3qESe
DbqQx7DHauRV4F7kSKZzy7HTMpCLvJf9PyixWKmHI6azzwxw7mb8gu87s83G
su2ObLvrg5y1JWB33sbvR8Bh0ApWsFYvuK5zea54Ciz2nDGWOd8Fu7n/Uu7o
5RKbo7FrS+wum8Aef6fS9SXwG6/zYGLmWc69HNyK3JxlnCQu2o/8Tzjj7oSt
L05QbCtmFauK8R3YZDy2GAe2Izdi6yv442XQgPwiXFLHOuvAGuTt2KgjbLEz
i/Wi7BsvtLsXoe4iJg5lWix8iA3n4yNZ/B8A85A78JV94F1wFfwkyzhPXDcT
uZYx+Yx9o7/F1C3c8RTsMxl8C3kS/00stLtQDLez1xH2PAzOIWeiWyF6F4CM
sPl2FWtWBs3HzxebDtq7HQzi9535pqt8rCLbxui/cuT52KkKVIJ5YANjK1in
HKxHPsm4Y+Ao+LjY/hsMbv3/GPTYCraAPxTYXa31XKI7a2ONX2HXZ0BrvnG5
ODfTc7p078e4voV2hnp+2wDWg22ghjsr5+7KwIKQ+caT4GfeR/7G3RfIpuB0
wrhzI9jgOfTXxMAW5h6De9qSjWu7sFvHTca5A3PM5+XrFTnG5X9EfjPbOH1L
2DhFXNLFnK+Ig0bipQH0IDdn2xj9pzVlmzfQ4/WE2agAm90CuhXf7H+aM2Qw
Jx2cQp7NOlX4cCWYFbWzx/kvlm02+DZ+ejsYBu4GByP2m+SWiM3dhV/szLQ1
lNt1h7o75fjR2GUuY6vBKOQk1r3CPpeBQ17N51KwBKwCc8IWY4qtn4bNdovE
ac5sqLuSz8vXdWezxUEZnB/MChkX9vjcIU5UbXGIse8FrcaQL11F139lmk/d
j1+UIpeA8cgriZMHcu2uBqSTf5h3ibUvgm+QP8uyGkW1yaUs46YXOOfzCeOo
kizjQHFfcZZxlThQ3CfOEhccQM/mkHFCXqHFuGJbOUPcvplzbwobxzvWSWdu
GugNWa0wyOeqa97X2nzukM8plsXh4m7FdK/yDfNKwPUy8y3lCOUG+VhX3HK8
cnsncl225UjlxnXIj2PHWs5RA+Yqlvgtlf/6g2eQX8y2GFFsrEH+PZ+92Oo6
eBX5DnTow7rJ8iPktIDVDKoVUpGfRqdTGcZ1FWmWu3RmnVU5rDPXajTVZh3I
E3PtjnQ3ymEn/Z3oLj4Oet9lbDRmPjyVzwngfvBIzO56GJ+3xezOxWUDfe0g
TnNR81n5ai82mSlfR/43+enRvlYrJjM3KWY1o3LfJXS9GLIcKF8bzxrjouZz
yu2KWcWqcvxIxl1D124wAvkj9gjhO0FwHHks895Cr0YwJmq59E7scUeO5dQf
M+Z57uE5MCNitepydFwWt5r1nbDFqGJzN/LXfFbGTfeHyH8zcy3nK9fXpRgX
KIcrd4sTlAvbfG5VTtymPBWwsaqhNqFTLWevARujZlv5vHxdNlYttAjdVvSz
mki+J5+Rr8gHlZtOei5Xjno8Zhwk7pkbMy5QzlWuFSfsBT/k7BNAU9Ry+8s+
dyvHK5bks/JVxdQ9rLGf8+0Do2Omq/aY63VegG5TONPUvqZjPmu2YusTIA/5
voDVTKqVfhCw2nK+z02qMeXLymHKXfLpcML21F4DkFeFjOPEbSuRp7LOq9zb
B2nGYaolW9nnRNRqStWeiiHFjmpQca1iTrEmzp3MGlHmR8DDIeN29Sh1nuPl
Sxqj/+RTFfjcWeLjDCgPWu4SR4oblcNUeyjmO30NorXH8d99IdtDsasaXbW5
YljcpphQLIjjxAVtyK0R4wTVirJhnq8Z5auyoWwnn72QazW0aufzyBUxi2nF
crnsBuc+AqaAUXnG5UPZe0jIOF21gXoY9S6qEcSN6hnVK4ojVcuLc8Q1qukP
xq3nutFrIQ8NWA2m2msIchCfSym22lM58auo6SjdeqLGtapxVduKcxWLaZw7
NWExqVhTzaRaSTGn3HcWPc9kWA7sxxluBmf7WE8qrpGPyDfEORpbjFyUsDlN
YeNAcV8Lc0Yw989B6yVUE+suxRHiBt2pbJPOOdPKzUbi4i7md5YZJ+eGjPPF
9eGQ5boG38sp502LGyeICxQDkYDN0djcgHGbekz1luI4cZN6DPUW4ij5yo05
AfMZxY56GvUyiqHzQeN4cXs78iTmvMfvXzrj0J+zd5J8CjwlPcATzB2QZmPu
SlgPr95dNbW4VXeouxPHKnbUk9/oxaN2NytZ44WI3ZF6HdVUqqXU84iLxalj
PCeLS8RhN7grx2rvKmxemWc1uHpl9cjqjdUzq7dVTaJaRD2uel/5WIvvgeW7
qiHGex9WbSOf6vE1zrGw1TiqbY6GrfcVR4gb1AMvzLMYkO/X5pkuC70sncRl
U33uEqfJt1LyzFfkY6ptX1MP4Wtc1aJ6Y9HbimpS1cbqORp8jay3k2r/VqA3
FPWiqulVy6snVe+53tfS6kHla8pZylXyuSsJq3lV615O2NuG3liG+zcOvT0o
JysX6w1CvcbCoPWa6jn0tnHFz9Ubh94WlNOUy/TGoNymnkW9inKcfEWcJi6T
z6gW0xuH3jZUk6k3VY+i3kQ9qt6O5IPyPb0hKTZUw6l2U4yoV1IPrd454N8e
FvveVm8Q6uV6YtYryv9OR8xn5aunIuZryrHKrfI5xXINd7sgajGt3lg1tmpr
9ciNPoc1+ZpdtYk4sNzXKMoNj+VYba4cIW497fdq9bGhNwy9XShG1HvU+95E
PYjuXj3kGu8D6tXU87T6nk1vPXqz0VuN3nxqvE/KF6XzK/5NSm9RevP4H3+E
+Ew=
           "],
           VertexColors->None], 
          PolygonBox[{{7020, 7021, 1783, 4665, 7019}, {6927, 9269, 9268, 5845,
            1316}},
           VertexColors->None]}]}, 
       {RGBColor[0.5562094247605447, 0.514331194351775, 0.8987999494124592], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFll9ol2UUx8/+77f129xc7tc2Zv0youtKLbASJLIrW3mVgzVwu8kMWm2T
aFqtVLyoCJoMgsK8SOuihHJJsawb3T83lSJC8iIrKgoyqVH0/fA9o4uX93nP
c55zvuec7znPe1P/7p4nKiNiRk+Vnj/qIzprIuYrIiolWGyMqNB7vtHr9yS/
Wm+9ah28KN3NdRGr9b6+2nLOvtkW8cCqiMekMyn5uN6/yv6QZBWt/v6qI6K2
JL+1EZfXRkytieiSne/qbJdzb6+L+KTZvrB9NfFt1/NXreVvXBexIGwXtL6j
M+LuTmO6nHbANttoPXSuFSL+LBgbMS1lXAupc17y21sifm5zDmr0fUT7O4V/
omhcxHJI+HvaI16T/ePC+K78fk/etP+Snj6dm1Z8H60xhuqGiOcK3ntH2H4R
/k+r7Pdc4md/RjF+K/lyt+LtdszPFIwBvyNg0LNV32d07myjff2mHG5VbvcV
vM8eOvgBM742NTj245JvF7Ynb4nYov3xeueMfH0t+VLJ58gR+n35vpZnZ9Lv
UPh9JtfU87MO15Scz6WcvPJNbiu190odyrZLrOAMYX9BubpT60Xl/vwq5wS/
4Cav5Go+6wXupjrzDgxgAi9YZtMvugvp91yuOYvtj9tsfyxzOyD9f8sR/5Rd
K+oENjB23xjxVKsxVHRF7Cm5htuaIl5ts6/9sn2g0fjfKptD8Ifa7U/5/ZL3
NzuHl3Rud7Px7BJ3HtfTK5v3yU/cYH5T+6MN5vzn8tUj36fqHDdv+oBewj7c
QG9j0T14uOj1St3vzRyOK8dXbvY33L2nwXh+En+u6BkuuA7fNBnzo43mNTb/
LjimiuyLDUX7xc+G9Bu5v17ruxTvw2XzZilnCOepf0WtOXCszXkkh/DxkZJr
+4F41Cv502E9bGIb/g8XbX+q6G/4A4bBjBce0//kBh4zU+gBdEeL5sNonsXO
i/XWp0+pz1iHcwIv8EXvU6sv21yv08J1otu9ejZ5B0/g22jaXK1azZZcE3K4
I/MIjonECbcrc1aQv4nMJ+/DqbMx1+yf1DNdZTzYgvvzOQcmMy7qgj/k+GSN
PrN1R67hNdixhaw3se1Rrd7Xsyxcxzo9I7bU/n8HEBd82ZScYQ8MnO3NGPFD
veAK575QTeda3Pe7yuYEfBjOeMCDP/SpNfyjZ+Ae+E5mfU/LTnXJvNmmuXvw
VvOX/anU2atzzxfME2KcztnyoHrq97XeG2p1P5P3QdXwRLvrT+/Rc/QUda/J
O4szlxps8/WycwTeZ3Xu0Dr350hiIKbpZt9b3E3EtJw9Q56wjZw5Qc/Cz/kW
34XMTGLjTR7AwGwi59whB0vmJ3OJe4L4wEVewTbb4hxhg3N7Mw/7cj2QM4rc
EtdczskL2QvzOSdnc56zZg4d6HJeprJew3m3wNmVnI+l/bH0uT55fjHnE2eI
B3ll9j16cJM871zp8YwdriOHw+AdTvtH8nsg/1XIKflkVv241pypKZlz+FnM
+wIefqha39ZqTmzW+wfpjxTcWxPZX5M5E4idu/1ohznGv0xf2X3elHMX38wV
7k7iBONIYqPukbEM5hxmDuCb/iBeZtvLZevw79Pf7j14/VD+V/wH6HhS0g==

           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHlw1OUZx9+EJJzZI7sl2U1Ckt1NNnRwBERQ23JU7IgKVlo7BQSPVoIF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           "],
           VertexColors->None], 
          PolygonBox[{{6822, 6810, 6809, 5968, 1426}, {7180, 7172, 1299, 6282,
            7179}},
           VertexColors->None]}]}, 
       {RGBColor[0.5829308667870252, 0.5582698880206565, 0.9099343904467191], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl2to1WUcx5+zc862s3O8bPrPTYdH3WyFU4KIECrcC91WKZGXOV+Vb6Z0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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJw1mHtwlOUVxt+wuQhJdrPZXchusiZLkg3Y2lqghVAtYhsKLXgBLYOCRNsx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           "],
           VertexColors->None], PolygonBox[{{6860, 6873, 6872, 4559, 853}},
           VertexColors->None]}]}, 
       {RGBColor[0.6076370399422379, 0.5979658337152826, 0.9104976150986046], 
        EdgeForm[None], GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwtmH1sleUZxl8QhGS0p6enFc4pp7aFnoq6LZOyAe4DdIIuMgVZtqEguCUC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          "],
          VertexColors->None]]}, 
       {RGBColor[0.6323432130974506, 0.6376617794099085, 0.9110608397504901], 
        EdgeForm[None], GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwtmHuQlXUZx1/kIs7EWc6ePdie3UXObnsWQatJoEC6gCZUIwqyTQWCUM0o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          "],
          VertexColors->None]]}, 
       {RGBColor[0.6570493862526633, 0.6773577251045345, 0.9116240644023756], 
        EdgeForm[None], 
        GraphicsGroupBox[{
          PolygonBox[{{3552, 3768, 113}, {6763, 6505, 113}, {3768, 6763, 
           113}, {6505, 6769, 113}},
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmH2MVOUVxi/fQsIyszPDlmGB3Vl2FkVpmwq0gP0AqdA28qFg2oIgtE1a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           "],
           VertexColors->None]}]}, 
       {RGBColor[0.681755559407876, 0.7170536707991606, 0.9121872890542612], 
        EdgeForm[None], 
        GraphicsGroupBox[{PolygonBox[{{3632, 6507, 113}, {6553, 3632, 113}},
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHmMleUVhz8RBCGdOzP33gEu3HFmgMsiSNtUoAVsLWiFthEQoWmrsrVN
irLYJgIKNBE3hiaAVsCoYFmSYpvKkKJNBCxgE2UEukSGANIE2oJAi1WQTdPn
4bx//HIP37zLec/6OzROmz1hVrssy4rXZVl7fq+UsuxoXZYdAZeRf5HLss8K
WXYVLEae0ZBli8BCMB08VsW/i/wbPIp8onuWdeyTZTeA48j3sm8TvxvBROT/
cObXe2bZbeAs8rvlLBvBvuHgHeS5nPOPmiw7BuYgP8+ebZUs+wP4FfLcRnQA
08Ec0Mya8awdB5YiD+iVZfcj3wf6Iw/i91RTlp0EA5F7sWY0v6NAE/I93DmA
u/uDCeV46ynuOlmJN89E737o2hfMxT6bOHMraAEbweVq7stzH7iEfBP7xiOP
A/XIH6PjTrAD/A88jB63gZFgLhiGHh9xzzkwFHkqNpkI7gFTwFj2TAaTwBjQ
nzvGsPYu0A/5u+BHnDMDfAf5LLhQm2XnwRnkW1j3R859AwxCvvQF7kG3IeAi
8gxs0LNvlvUA05GfYl01f8uBJ2virYvBovRmbf87vv+2JnwwG7vVsa8IZiF3
5vfv/O1v4Ebk7dy5GzvsAm8iHyyHz/X1+6Andv0W77wT9EAu8FtH7BRBHvkM
egwl7oaA08gjGyMG9P0IcA7/XAVXwH/BVvAW2AlawPlK+Fxff4L8Cnc+B54F
68px925ifVdd6HBjj4gZY6VTj/D9PM55pHvEgL4Yme7WJzXoNZ2900A1cpFv
V8iLy6CA/GHXyAlz4RRyl25Ztsc7QWfkO9FhCngA3AF2oucofPFNsKMYtvUN
6q6Nt5fDhtruTTAzHz7Vlz9F/jN6n+D7cfB2Tfj+X+jxz8aIAWP9q9w9rBQx
3wEsYd/joD3yu/joAHftB+8g76mOmDfWdyMPrMSd3nUz8gXibhf4EzgP8txx
ydgCtTURK3nOqS1EzCxjzRqwGjQ3he0W8Nb5fcOGzdhtNVgFloKj3HGCvcfB
kUrUkvnoPq8UNcXYeIO7Xs9HjJgbK1m3ohI58hq4l3dNBL9HPoQNz6LHGdCG
fD37zmC706Ad8rSq0FHdpiK/x5ufZt9ToBW5lm9/Zd1fQA3yVL6/xF0vgimF
0G1N96gV6nikNnLSXDxcG2dtZu1vKnHmo2AM59wFFqhfPd/x3ZOgDflYPmyq
LT9AHowfm0AjuAW8Xgqd1XUb8g+wwVv4aif4PvKDlcghc2dmJWqvNd7abg1+
jnPn8bdHwLPIQ/DDauyyCtyKvMG7+N4A1iuj4xOcswQ0IPfBTl8GXwK9wRGw
H+wDh0Er54zjnLvBXuSRoB3ydWAE8nvo+bl1F7T2ilzbTxzsq4ucs5ZfYt3F
YtR0934ReXAxztB3+7Hrvtrw4RrOWAaawWrwcj5i3Nh+STtQV06x9iT40D5V
CJ/qyw6FqA3r8NXa6qgROe4Yy11jQBXy6HzUfGv9qHzk2kfgXMq5emxe5ntP
UEb+ZS5qrLV1WS5qvTFtLFvzN6UeYO3f2BS9bCNrNxSjp7Vhg5vZNwActI+S
E4dAG9igjE9awV7QBn6eixw2d3+GvI4zXkWXzWAt8h2VsIm2GI08uRhv9G2T
inFWPbYoV8WZF/tEjpgbn/aJt25Ptcc320v1qb60p1pbrOnWcmvMSnR+AiwB
K0A1PimDniAHRueix9nbRiHfp0856zT4Yd/oZfpMX9nTvo2NfsK6H7uvKWq9
HENuYc2fi01Oovu/wZyG6LXfA5NTz11fiJ5pr/w1cksxOIzcZUsxepU1w1ph
z9L39jh7mzGgLzqha8fG8Im5Zgy3ppyzlg5j39BK1NQHKpHD5u79lYjNDr2J
x94Ro/MrEYPG3rxK1Bb3uNYac0A+Zh0B+0uRW+fR5ZOqyDFt9QJ6rMmFzQax
5lP6zAUwsBS9xDf6NnuKXORQihU5ibFmzl/L9WJwg1rurqkER1A25o11vy0o
R8+yV803Z+ujZlmr9tZHLn6Ar472iZy01i8Gi1LNVzd7vL1dHReiwxbwGnjM
WMZnV3nLFbA3cU19OidxTrnImpTbchJr7yxs91AharC13R5q77TG6yt7ciH5
zFpkD7D2W5OM9aV8f6YxYl4uYc+2V8spxqQab223RttL5KRyUXuKvU0f6jt7
nLXUHmlvtKZaS60B5r41Va4xNXE7OYfcS84r15WDPVMVOWJuPF0VXNgcNTeP
pV7+ceKS9nS5ehGeUugRnF3uKgeTe8lhjcUV6LE8HzHZsSY4k1zphpqotStT
blpztzZFTbIWtTSFL+1h9i59Krc7kGJRjvd2PmqMtWUP8u3V0RPsBd+oDi5g
D7L3yAmu9RL23lSKnqLv3ONafWjvn5FmCzmAtd4ZxNnDmq+vVoHnk8+sLbey
9yvVqcZw7mR8NwksL0WtWMLv46WoGcN7B8eT232td8wu/bF7v74xwwzIBweW
+/bPB7d+OHF1Oba6m2MD0xvsFQ+RBw+Wo2cY61uT7Yx5ZxtnHmcdZxx75efo
/Vlj9Ey5jTXbWi3H0ZfqqG761NywB69PObKzIXqAtX9HQ7zNNy9Pb7Q3y/nl
+vZoZxNnEmcRZxR7bTfytGt99Fxjw5gwFowRc29r4s7moLXFHm7vtsbIXeQs
chU5jFxEDiF3kJPMqQvOKFecXRe1/nrQLtV8ueVB9r5fCI7ZDRt0AZ1B16bg
xnKabYkjD+0VM52z3BAwLhccRO5xdy5mQ2u6tdwZ0d5oDdmbemSnUvQYe0vH
UsTOwlRrjKGWhrCpttwCJlQipo3l8ZXgCnJ8ub2cQa7uzDghcXZ92S3prk+N
JWdSZ1FjylnKHmrvdKaSq3qHZ8tZtcUhbNVWHTbpUIkYNPbaV2KWGJy4njOF
tpLjye20mbPthcS9nXHlSvZQe6ecyV7Rkt5mz9AXQ5Mt9Ym58ip22VyKnDGX
mhP3Nqfspa2ptttTnc20qbZ0RpOrvpJmKTmrZ60FL6czzY0FqVeYI3Ij3+jb
5Ej+X4EcR27j/xk4CxhDxo4zgVx+BHYZXghOr2wM6Hu/7Uqc83CaQYztLqBz
inFlZyJnIb85WztDOzs7Y8sN5BRjE0ew1zqjOZsdSW9xBpD7+ya5lBxK7iSn
cta/xvlyMfPrS2deZ119+n/KGp1p
           "],
           VertexColors->None]}]}, 
       {RGBColor[0.7064617325630888, 0.7567496164937866, 0.9127505137061467], 
        EdgeForm[None], GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwtmH2QlmUVxp/kW3C/3n132ZVd9t3Fd+NTtEmWErACLahGEIGmAkGwZkRw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          "],
          VertexColors->None]]}, 
       {RGBColor[0.7311679057183015, 0.7964455621884126, 0.9133137383580322], 
        EdgeForm[None], GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwtmH2Q1WUVx58K5EW47N177y67usuyi8sECGJNAsVLFvgC1Qii0FQgCtaM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          "],
          VertexColors->None]]}, 
       {RGBColor[0.7558740788735142, 0.8361415078830386, 0.9138769630099177], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl1uIlWUUhr/Zs2ec+WfUaXbs8die0dl20UEr1FIsifLC8TTj2MV4SHQs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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmH1wlNUVxi+wEJKQDZvdbJKFJLvZkDAlmUQog4QW0GrQJigFBIn9QL7S
0hFQYjsDKMF2iIBgHRALwZGPinFGbEcIrdgWCQXsDCSCthSSMYhTtCYFKqBY
EPt7eu4fz+xJ9n3vPffcc57znE3MWTx1UV/nXGUf5wJ83pvv3FwwB9wD1kWc
21Pi3GtgLXZ93LlVoBEsAP0GOzeU5/IHOjcg1bkRQ51bnufcMvAN7K94Jifh
3Hm++x4bvM0aR1nrCDiIXcgz342xLyjAvhl2bjHfLQI3sPtGWSPo3Cf98IX3
f57p3AneOw5+hv0gn6+yVwuYiX0WX06A4+AM+BhcBVfABbCFZ95k7T+AX2Pf
zHZudqlzPwI3sHPwI2+Yc7kgin0yy7mLGc7tHICfAdv7Pd49VWI+/DVke2jt
d7AfDNoeWnsm9gX86s1xbk2Kc0XgMj5nFhJr4lFM4PcRm1fAbrAXFHLmOM+0
sd9k9rvKOufYqxtcwa7Gz1b83Afuxh7L8zfwbxfP38fz/82xM8j3L7GPcj+P
EcN9fNcGnmedCawzHmzSmvhSwxm7ie+w/uzH37fwOy3NudX4eCd3cou1vgJ3
YD8cspgpVrOx01l/K/sc592D4HDSuXdBB2gDI7j/layfxt7LQHPccki5szVu
Zy9mnWTIYqDYnsW3MxGLcTa+/I0zvg8i2K280wYOgX3gviLnFhKvn4DJ2HN4
5zzPfggexr4d/zbw3HowBruJc2wCG8FqsIt9X+fZPWAn9uli5/7EeU5zljpi
uoz/b+b/vfg+BYxjzU38byOowm5M2B3q7laCc8Q6dwh3ALqxm8L2jp5djf0U
Pu4HrWAVeJRz3oVf3wFLIhbLMPbv0yymaaxZztkOD7Aaus46JcR+GPgCuzJm
d667rsAuJ2+H53KPvH8FBNnjh7z/A5CB/Z+Y3anu8jL2czy/h+8+pf5np1PD
3FkVGAv6Jy32iqliqTtYQp4/AVaAxfkWu3v4blKJxbCMnNyAb+vBCOwp3H0D
8fswYDWsWrvEdxezreZ+Ca5GLfdSBzn3Amvu4vw7weZ8u+sW5Ym/8+s+B3T3
X2BPx//vg37plmPpnGkS56kGaTGrvVvUYDLFanCN6oEcTxDLf7BnOd+NBo3Y
84nBWvb8jXwAa8DTeZZD/88d7Cz8nYzvtSCEvZ772Qq2gGfAJeUFe48FF7Ev
c/Y2nj0ELmEPIi8q+axQ7WAf5ezz8HMuOBI131axVzzVfGzmDlaBvZytgvvc
RDxHc95r2PGAcVN/9qkNGEd1DTaOFbd2Djau2439csQ4LxmznFGuFIFf4Wc9
vi0Az2JvL7GcVC6+hL2TZ95lnQ6wA/sUPj5PHDaBk9gfcY463p0FzofsrrpA
p7+z21jnj/z/LVCJvTdiHClufCNia6vHqLdoD9VaMXH8KNVqTlw1Db+mZhpn
ae0O0O73eA+fzoFu+RYzLnwkbLUqThxSQA2ADBADtew7j3XmghrsUew1EkQD
xskLif8csD1gdzCKc/2CvZ8CI7EX5VmPU297BPtOfKiK212oB9az1u84w2/B
Auz+pbaG3g2UWm4pxzf7HFtPDF9mrTPkZjtr5GVbjau2c7Gj+LkCe7m4EPvj
iPVA9b4L2Pvx4TBoA63gsaCtoXcfxe7gzF2gE7QXWO3e63u7ariYNZ5m7Sbl
BnZtxHqEekMN9sCgcZi4KwX7VThkHGer0l0XWWzVA9X7FOMacnU8ZxpKfg4B
zdmWY8qtrdnmy1pfW/JpJndWxr2PADOwW3OsRlWb4mD17rfBQd/DxeXNvneI
0+t4/nXe2wNmYW9m7wrWHZNinHMXtXI3fBhIN47YRoxGcY6RoDnPckE5r1xX
TvTymYGfg0APdiF31oC9FBSUGjct8dwnjnqoyHqQek8dOIYfB8Cb4GjMfFMN
7fA+1pETE8EEMCthXPEWsT0QNs7YVmQ9Qr2hGdxkj+qw9fYTAeMSaQD1fnGK
tJZqUrUozTWfcz3LexvAPOzH+bwDTAQNoDxpPVy9uwx7Cuv/mP/Xg/uxr0SN
k8XF6gkv4lMH+7SDbZmm1cRZ4ippttMhq0HV3t9D1rvFQeIe9XCt/bjfW3us
xKdVrNUInsR+MmI1qVp8ImJc1woq04zzGhJWU6qlpQm7G+2pvQb52nR8fh2x
GlVvnMR31SHrkcqds14LKoe0t3qUepN86MWnL8F10ON7s3K8xffoNvbsAp3g
UMK0l84g36XB1AtUc6o19QRpNdWoalOabULQeq567Xjs8cXWA8T93y42bSXN
IK0gjbWr2DSTtJI0gO5ym88F3Wk0ZBpZ2jg7ZFpDa2otaY4469Rztsvk+gus
MZp3+gAHvllkXBmkHjJyjTOVq8oZ5YpyVtpzGmvfHzANGubvHnpODX8fGmBa
q8lrJ2muuTmmIaQdxKHq7coZ5Yp6vLTL2TzTvtIw34qZ5pfWH+e1mGpYtStN
1kGME/gSB+0J6+WT+axNWE8X10nzS+uL85Sb0zjv1FLL0eeIwRZwHu7Y39dm
gxWsuzxmM0I3MTgFToIPiqz3qcZV2+qB4iJxoLhPnKRe3etzQz1bXKCep14n
TtBspBxW7r7mtafuSHcjDZoaMQ0r7TowYlppB//fHjbN9A7n/jd3988B5rNy
8Qj4i89JaQNx5AyvEdT7viYOtzKtB5YHLaaKZVnQYlXnuUUxU22I08RlqhFx
t2YKzRLi8Cz8WMNnT8A0hGK/3msZ3YF86faxkk8PyGfeOQaml9isOAM84GfG
Ht9z1Gs+DVovVA9T71JPFNdpDb0rzhM3PeS5UxwlbmzwtS6O7IIL6ujHB/Ct
inqYH7WcVC5qppH2avTaWxpMs6M0mLSXZkhpj3/x/08SpkGkXaTpmryGUS9Q
T1cvV08YXmQ1o1opLbLYlIVtFlOMPk8YJ4gLriVMa/8012YFae6ubNN80nqd
2C1gLLl1O3gl27SSNKS0ozSTeq80krSRenBD3GKo2C3Fnh22HiDuV01q9tYz
S/0MrrvQDKPZRXeykfcqhtosto7rvy1hM7hmb2kq5b40tLSzamCM+i31sjDF
NPBnxPpaoc1+mgmlPZTDyl1pENWazqizqeYu4dsHWTYbHweVuTaDaPaQRu1T
YBpM2ssV2OwvDSjtp98AxE1DQMxzlO56aqFxl+5csZOGkHZQDDVb9vFracbM
x/euXDuren7tMOMA1b56vrSjNI60jTTkaPJnmt5LM42ns+s3DP12oRiIG4/5
3i2OVC+ZyN4Tsq2n6LcFcbq4XL8xpFC7G5KmzWvSrFeIw9p9zxAX50ZtthAn
Kxc/97mjnNRsdtjPyprRdnN3b+TabwPShKot1bhqWzW2l+/eT1otiDNakjbj
a7ZXz5wespxTrk3DjidtptMsV5j0s7bX/pq59VuHZibNSvrNQ2eVZpVW1Zn1
W4B+g9FvL/pNQNpuGfhzwDReddQ0n7SeYiqulcaSthLnarYd7mtJM244aT7J
l6ykcdl+r13FaZ/xmRoyLayZTbOkzqSzaKbUbCoNU+Zn1OtZloPKPfUocas0
q7SqOFazjzSOtI1moGeC5oP2Xhe03NOMnOFz8H9ubtDt
           "],
           VertexColors->None], PolygonBox[{{5012, 5773, 1230, 4361, 5011}},
           VertexColors->None]}]}, 
       {RGBColor[0.778750646556691, 0.8523734726034635, 0.9068094127879437], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlkto3FUUxk8nk5n5O0NGZ8pM0o4ZE9qJBEFQdy5E4qIgFTM25rHSxmpT
wdpSxUWzMqY0tqLQZlMUhNSdT2hcKK4SEFwoCYJgC5JOUTAvbX0s2uD55TvB
xeV/597z/M53zp2ew8ebr6TMbNFXm68HKmatTrP302YXymaPNsyavj+YM1vP
6nzd12+J2Zh/k91mp11m1PdXus3mfY22m62kJd9wo3XfrxbM8il912J/smRW
us9sy2VS7nerw+zFXWYv32X2hNs47fEczZv1+v2yn694PIfd17Dbu9/1q2md
n3V7c/570tczftbKmJ1znUKX2UzN7WZ0P+A2l1z+fJv00W1PJI/eC3nFNp6X
XMNlHtulfMfC55B/19K6e9xxOrPX7JGM8l8Pme+KZrl97j+l3P9x7H4Ov6Mh
86v7XczI7ob7XC9I5t+c5NF9KxEW4DCRFxb9KeWPrT7fv94uHLB5J86I+UJe
Nj/1s82C7Ha73AmPN1dVjchzNfzicyP2YDcUOf5QNzvgGD7vsVyOPPF9CSwz
wolaDUS9bnjNn8qp/hfd/gf+/duE2bNhE/t8t2tREc/gGDGBF9wYysrHQMQ5
TX3dznGv/22XH3G5NzyXk76ey4qDld2KD478WBZOU31mNyuKEazBHL4Ry0JG
mGEbvIiT+7VEMtiFO2Pt8vd9WviS2/XohdfuNvuspt8px+p2t7BuZYUF+X/o
sRxoCNPp4Cm5dHq88z3yB1bEQL2IaSR8feEc+6gmjh7Ji6O/tImv4AiGxDUc
8tNe23c7JYMf/JHXRlnYjURfkgPxz2UU17ngzvnotZc8rlM96nPqeT10PnZu
v7dftaFXVqNf4NSV6H24v1gUh2cK6s83E335DU/gJnwkX+qyFT35uc+EFZ8J
PyXq2bMhzz1c3+Z5h+YFs4KzYlY9UMqqVnAIzsNneM2MOVGSDfroWGA4lSgu
7PzeqdkHJtiip/uDFxeDG7cq4hNcosbE2B1+vwnfgy7bzMsm8+xWXXt80c87
uWOXXsP/YMg/6THerEtuuKT5Bf+uuZ2Z/YqJeToY8YDlVNjkOxM4T3tP/FFU
/PD8TvQbetyj2xv8YFY85HV+2Fcr+b9O3N2ImsNhMMY/2MwGJtSOepM/mDMj
4D3nCx7zoZpwgSfwlr4Gd/bwH7vkQzzwuxk8PHWP2dMl3eFnNuYIekfCDr9X
Qp86bwafiHsu8vrWOT/UEAb0B/MLfjNTkNmpxUbocn4p3gjquxn8aUafEBv5
zUbu5EzN4TmcYGZhg7kyErgvxduCTWLbxt10Dt7cMdcnAhNyHI89vYUPeHIs
ZKgpC53leKPwQ76Xa5qnxPuO41e5V3nh82jYnAjus2dOTFb1mzkxHpx80Pt4
tqI3Hx+9YX/BOfXqXuHfF+8n52AAT8HhS9c91CVOMPM+KWu+MDPGq8K3y/fV
PWb76Bnn3cEevYd/Off/rIvL1O2rsmoHJydjjlEPMCnE+98fcRRdb7Oo95xe
4W2Gr/k98oevss+Bqx2aGcuex5Kvt7P6j3Mm3qCvHcP5mupMH9MzcGwu3qud
txW8wAoutGLO/wc180ty
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJw1mHeQl9UVhi/FRYLusr3C7rLLrkZAUCGKRrCBQbDAIgJ2QYhkLCjqxAoW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           "],
           VertexColors->None], 
          PolygonBox[{{6705, 7123, 1931, 6138, 6704}, {6372, 6942, 6941, 5675,
            1181}},
           VertexColors->None]}]}, 
       {RGBColor[0.8009384668844154, 0.8597725194673506, 0.8968692891643528], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlUtsjGEUhg+9TKcdrbRDp3WbCUPaxgJricvCosQliKBaTSRY0Nq0G5eV
y6aJiCI6EhZiZ0WbuKwEiaDBRsNGu0AlVRFFpPU+zmksTv7v/7/vXN73vOf7
c+1Htx2ZaWY3ZEWy34vMfsjOJs26SsyaK8xGZ5j1LzS7K3tZ5vs/48zJjNmq
tFlrsVlpndn2+WZ/Ss16FKxJgd/It32W2X7Zh5TZ9yqzX/Jdrr0zSY9xQnmf
yPeiYj2Ub0Oxx5jQ94LyF8m3T89zS83yyrVP+4tVyyLZetVzdp7HJeag9vbI
GrSu1dlX2tur9+Z6s6xqW5ow69S3Dlmr1ve09yzhOfMJ9+c89d4W/p2q/4Fq
uR9ruOhNOi744Z3vYGHN9yGt38oOz/T4xB7QekK4+6sdL7mJv6vEn+RjPVnu
sYgDZjgj/iPhu5D3s3yDk0OKOVXuPhnleC1MK+odB33bKFsr345yz0f83eJ5
h6wm4Tia48xUpdljfT+odUF5vlV5T4m3JGLOls2o8FynleuM7GDCe3StwvGy
PxX1UBdr+nIp6fnIRf3gBRf9exZ9oK9ToRvwEReM+OFPTx+rF21xjnd0Blfr
8q4Dcl2O8+Tq07O7xM/TQ+qlb3A8GbVN10qcWzmzO7Iv2j8gvRySNWp/XO9j
erYUe28vpBzvLnFzQLYs+GwIzd8Wf/vnO7Y+1TZe5fmZFfhtjTjoAozDKZ8T
uBlU/veyrzEf1EqdL8q8l/QRjfcEBxM6+znnNcJre2ipV/OyKe18wQE44XZU
526Wegw4Bgs1oK/jta6xpuAFLB+zip91XXfP8zlnPq9XO0fwc1X5e3Ie+1LG
Z485Yqaf1vlckwfM5OLb+Zh3OOA72vuUdS2yRqN/4j4A+/MyvxPoZXfUiMbR
MD1tjDnDd7Piv6t0DcB7V8wv/RsLHr5kHRu4RlLeg+eR59+8KteVpOOA5zVp
57QttIoWqWWuYszJutY2JPyOob+na7335Kf+kYh/qtj1whk4WLHAeaD+e4GB
WjhPH3nizxpdXwmdEWNDxMGH2HBLb9EOWOkl9xfYj6lfd3Puzz2HxtEA9Uwm
HdeO2eph1rVdFHrkHhqo9j2+jwV+OMSvEL6ZtPcevtDgcNTPvbu63nnpi/8J
d+D7Su8TPVorntbn/b6oUf7Oap9j9IkP5x/p/PY67wv5yAv/5PmQ+o+9JWYD
bDfjX4ReuL8ysdcS9dcqVybrsbjDCpFri/JsrXOflWn/94AZjocjF//CF6FJ
NNgb/wDwD4ZmRuPfQMzRuNPpxXS/0SraHwr9MyOFuEvpKdon/l/m4R0L
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHmQVNUVxh87iMw0Q8809NAzDDPNRIpFLIUoJLKoYFhcAi6s7gHFuBBA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           "],
           VertexColors->None], 
          PolygonBox[{{3631, 6718, 1830, 6717, 3630}, {4689, 7027, 7026, 7032,
            1788}},
           VertexColors->None]}]}, 
       {RGBColor[0.8231262872121398, 0.8671715663312376, 0.8869291655407621], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lk2IlWUUx587H773Xr2aQzrzzr0z3iwTLNGxdMaPkZzJKKgoWxi0CBUX
UVREXRBLMxfheMcRN5FWi4iy3IgbnUUL+xJKCjXdFNoYBNkQZEIfavX/+T8t
Hp6P9zznOed//uec95aNz617tiWldEmjVeOfOSl9OiOlkg736mBkakqTBc+7
NdYXPDc19rSltIF1yfLNkOHelnbfQf4ZzU9r3CmZ/SWvzxY8821M8ldqKf2m
cS1Labn0bpZsUWN7T0ovaNxRTKmvnNKiOO+R3CbJrdJYozEhHRWdX5P9/2qM
6p2F0vd8nlKe+fvH7bZnbbttxK9z2C69I9Lxss4LWu/U+jWtv9O3Ia076yn9
PsP2n5+e0izthwv25UDJ5wtl30mtByRf1JxpPCEdP0v2Ut26tmr/teaVktk4
1djdwK3kNZjg0xntB9uMD9hw/rgw2KyxQO882Sv7O1M63u576Moln4Uu5L+U
77uEw2Rm7I7oe79GTfsFmXFrFTbjHfJF64M3yUfd+Ug6Ppjid5BfoO+XdX49
7vXE3dvbrYv1O9Kzrdv7xZWUZma259u5wn2uMe3W2f0RW2KMvrLeml5N6Z7b
Uro7cwyqmle0WTYP+R1tvs8aP8AanCeF6y8a34Ofvr9aNCbwYVfJMQenfTWf
/yE8/pzjb0Pz5LdGEnZPZZ6Xyu81Ohvq8hqd3BsmQSrGFoxfLxpXeHJSuls6
zKcNisvGXtsxGH7iI34cyYzZfTXfQf5DYf5V1ZiTc0eq5gM8RD/ncBb7yCfe
H41ce0hvXpUvF1vNkf6IP/gMxProrSm9OFvYlp2ryML/pWXHDdsuFM1L7uRh
4/+YM5Nr5N1LFedec5pyfJp1FXTWqBiblor36NmneI4J90NxrxF3kWN/RcuR
kn0jRuAEXviL3Mp4FztXRy1oCNcTnca+N3N+wtu9NfN4OGoRvDsb9QrMyHHs
nQjfs8hpakUzakcl3twR74LNpsDnc+k+lpv3cHPlFPNzTLhum5/S6bBvRdw9
IdkvctvI9z2zLUP9+GmWawUxJJbgsF1cW93tnIN3j+bm3s3idVfd9eW8fD/V
61i9qRrwfo9zoCHd44rxQNkxXqLR3+p44g9Ywh30gUUj8CcO4AQ2YLUneIU9
d5W9Z40+9qwno97dwLbN/uI3fFkVa2xFhtrYF/ZwF5vYgw/v98U5tRddxPh0
ybyHB9+UHAt8uC6OP9xhm94Snuty1xcGdRw/tihvyp3OVzC+HLWaGA5GHOEL
cSeXl5XNrXKsB4JnLWXHirymPvWHDLLLQgZf2eNvf5wjU4oaNBw9DrzAgZ5w
IeoVMSAWnKNrJHAj/oummwMNxXxn3X1iMHoSeXFM8R/vdU+hX1WjXg5Hr+Ld
5VGX0Um9qUU+FyLm1IRG5Omi4Cx8Jj5nVPeOdjgfjnV4z/qq7GrOsxy8aokc
3x39n5xaUjIfqT2P5Y4T8aGefRL/EtQL8hD5iViTd+Qj/RL7x/XWu/LxkHR9
JgyO1s0L3r+3yzYcj7xHfnSa6xG6r6rP/DrXMXwld++nnp2SjvN191Tq5YMd
locLzch9eteh3Hh1SqbUY9/I0RT1Cn+wC87xJnGoRD0cjf2E3vmhbl4Py/ch
jQcy9/H98Z9ALwYvsMKGLHzvj96WRf9lPxY1tiXidVH6ts50vIgdMzn1SO7/
EnjFHXSQp4fl64W6uUYu9kV9IGfWRm2kBm+J/yIw/rFqnOk/cI9ceFs69tad
l/xrLI76Qe/ivwF+woeR+PebXXf9OhD/QPgIVvT57qp7PT27GRgcrBl3MP9b
819z3B+one91OSfhXCE4TF8phm7mUmC4O/jAW/iGX2CyXjrOzbfdI8Lqjdz/
E+AKp8H2P6P7S7M=
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHtwlOUVxl+SlWRDSTYxm2STbLLu5tKGQiCKSQUck3AJVq42wXIRudkm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           "],
           VertexColors->None], 
          PolygonBox[{{6913, 6979, 1865, 5858, 6912}, {4793, 6601, 6600, 6293,
            1091}},
           VertexColors->None]}]}, 
       {RGBColor[0.8453141075398642, 0.8745706131951245, 0.8769890419171713], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl1FsVFUQhs/utru920LbpYLQ7bbQAipgUkqF8gKihRKpEIwgCgmSIi+i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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHtwlOUVxl/JQrIbm2TX7G4gu0nYXYgKcovaxBaoIYKACEJNULkZA6ip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           "],
           VertexColors->None], 
          PolygonBox[{{6808, 7079, 1906, 5981, 6807}, {5897, 7779, 7778, 7777,
            1372}},
           VertexColors->None]}]}, 
       {RGBColor[0.8675019278675886, 0.8819696600590116, 0.8670489182935804], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl29sleUZxp/2nJ5DD4XqSctpe05LbVrdhOGHtRU02cK2zOg+qETQRBoN
tK60BxhzEwW3Kvuw+Qccw1h0IkZRUdFoUHFuY2xD9i/Lhi4pH5btw4B9WMQt
UtqyLez6cd2EfXjyvO/zPO/93H+u677v97JV65etq00pDdWklNF8QPPVWviK
5q25lLZpfEnvVc2jGr+sS+mzep/Q/g0aNY0p3daR0q/yKc0u6aye75yV0h2z
PM/OpvRoS0p/Lqf0C307FntzJaNV8yqNb2n9zTqvc358tuWdkkJ/adJdl+t+
rT+u9/WaF+vbdZr/pNGv56H6lFZrHNE3U/r2jMYs7b2jO2+VPtdL7w1zUvr6
HMtcrrWxku88rXNfC5nTDT4zpblJuhySvJnke/4r+Wuz9gE+GclZr6NN1m2Z
vlmuez+qsW9OhX/K0qGtR+f1/E6sf0cyj2n+uMZ+vkXfDRVSWqnnRbpze952
duiO5pzP/VrztHRYk/Xe6dC5rjmlBa22AT3Xhk9GulMa1nhIcn8kHa5QDOZL
xn8k49Vc2KL9FxS/gzWOQz7vWKyWf+pLjhXf3B8YKGe9j13/kN3HL3ccZiTz
u1nrtk8yX9V4V/duyhlD5/Gjvd/oOat5Yd72ZPT8T8nINlt/fL8h/D8yV/f2
2P7eOfbdgMZNsuOxK1JaGn5hH8zur3OcG2v9vCFi/UIxpb523Zm1Tltk04Ma
i7Q+XUnp/YzlPxF3cDffImdnW0qPaCyQvlfxjcaI5BzSmZ9rtGf9/eu6dzxj
f1fD5//KO57bFes3tPczvVdrjBt8Ah6QhUz8OlhvHIPhvYrJth7vgSnw8bbO
/1VxmZHOJySvXzYNyIZzknU2Z7yf1Pom3b9H3/8+fL0u8PBNnb13ns+tjrvQ
C7t7a237fuHkaKO5+WHONqPjlcJXf8l4Gwgcg2FkDIac3XW+E/6SPw7EGXz/
YtH+n2nweeKyR7ackS1X1pmvk7OtP/b2z7HNOzO+DznzpEuzxkcZY7IauQiZ
8HZVvbk1EeeJB/KIwW+FscPC66h02KG1vshf3y45F1zIPczYjtzRwNKRjO8k
dvBmUXCTOA7U+cznFasbi84ZxAPcf1LjHEYuI6ZwA46QOycjpuiGrX1hL7y/
KuSTR5ZH3Nnn3JZkvarBqUrWHDgWcjjPGTgKl+HXtsjbnOfsgcg5xBXcEXvw
vj9sIT7oTIyqsutm8e0LOdvCGdZHI/81Rpz/nrHP4dVIYPtdYWlSeFuh7x6T
718qm0djBedxsPSM5LWFrei7MHTm7M7gXWp0DkVmVj7OFI2LqyOG2MId4A+f
g7Nz4X/itT7qBjwFE2eT9bquw99Rk5g5f3x+Sn/T+Ea94wRWuAN5z+Ud158K
S7tkzzByhZ9/l42XzZEnkfcp8eXTrbYJbE9FHDcULtZG8tbjeftva2AGGz8U
J/5Qcf6Ykuzpsu9+rSul97pchyajxiETPp8J7jAmA1e3BKc4s6QzpdpLUrqb
2hp4AydPFsxz4kD9IQ/CN3LPS+3OP8/qzh1drhuNWpvb7rr9ZItrD3n7ldxF
bpFr8DeYHI+82hv45l7uIffDB2INF8lTxPFW2b2i4rp7XPGfaDMflrUYi+Dw
SHCROH6v4Jh+X88r9d3tFXMNPO4MTJKbT0bs4QV3Ur9eLlsuMjeH/+EIeYRc
TU6b0Lyv4JzAnYcDP8ha0uB7iRPP+Bz7R8OmD6Tvw0VzdDh8A6YGhZmN3fb5
dum7o+J7WqMPgpPU5L1l12VqJjkcH6HXuagj6P1x+IO8S+4i935ZuB4qmQ9g
c0fJ+CQux4Iv6Ph+6Pla2Tqhzz3S9/VG8/GaBtuFfddpb7hgbJwUd74o/b+q
97sKnqlx1I3aVvuK2vhAwfVxgWQu7bbe9AvTTbaHfXIBeeCP8sFTqunXNhg7
rKPrfcJdtcv9BfpcGz5Hx31l63kq6hExpcf8QckcJB5DoRt8BgfkgM3BUfgO
/5ZG/zAU9nC+LzDL2nCsYzv9EByGv22RO+ERfromdCN3DkYdpw8Ao6xTu1ZH
rWR/VTwT4yOBq4PC++/aXGO2XegTcq7nKzoc54Wt7mnIc8Sf2sT3bdGDXqgb
PKMb9fVwcGZt5EKwwNqJuPd2xWeg2zE5EbmS9UeKxnEl8Ncf/wUT8Y8Av8h5
88OncPV09KdgER3xM7jF3png49ng5EZh6flG56j7g4dwMBN18oaIbW8848uD
/8f9h+L9h+oV13SH/zPe48ylze4vyVFP68wHFceX/o1cCMZ2CXeF9ou9BTNx
maq438IfP57rc+zBE3Im/u7JueZjF7GYFzL453iv7H4UX/WF39h7I2JxffQv
1NBJ3fWZomOyWDnpcz2WTX/BjHzy6Hjk7cMttue8LXn7lzPDkYvJNQ9LhwdL
rtk/0dkz88xjeucbW4x7fFAJPzyvs4Md7o/hHz5infw3Fv9rcBg8VaNPRj/u
rQYGiN0JYtrhc4tVd7YWnQdWKj6PxvPuyFVgg/+SrfFvQs5GR7iGf0eCY4wn
wnZq49GojxfqARh4oGSbsRcck4PGYj4Uz+iL3vgcHfeEnuiFruh2oMn9Ijny
Pul8b7frJNyhn4A/d5WcZ7ED7o9Hn0meGIpccXf8JyCTf823ys7RvfEfBZ7B
ETa2RT9J/4SO1eBbX3BhTfCBPpd+lx6ss9M9/azoK4fjTF/ghPx1Z4f/5Ygf
mFrSYjxtCq6d75eKxh/Ye6XJ/Q2y4OjeessnX81Ej71M+fiOLv+Lbiobr8gE
T9Rdcin/uxs73M+gMz4HJ5dJ565Oy6X+VMPGSvzr0p+St/AHseb/r7PFvRL/
htNhO3pMh0x8tiX89j9EkEtH
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3lwldUZxk8guSEJk5ukuVtyQ7YbgohCgFqDLYwCUojDpiWxgCBL2FJC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           "],
           VertexColors->None], 
          PolygonBox[{{3976, 6297, 1136, 5380, 3975}, {7316, 6405, 6404, 7313,
            2007}},
           VertexColors->None]}]}, 
       {RGBColor[0.8896897481953131, 0.8893687069228986, 0.8571087946699896], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmH2Q11UVxu+yu7/fj32TAX770sIuyCIvu6vmoJOmNFNA8mKkzSiNCcsq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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3twlOUVxt/AJl+INFlWNrtxk2xMdqFCsYjgWGzHznAPcYC0SiJUUAEp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           "],
           VertexColors->None], PolygonBox[{{4694, 6489, 6488, 6493, 1789}},
           VertexColors->None]}]}, 
       {RGBColor[0.9118775685230375, 0.8967677537867856, 0.8471686710463988], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmX2Q1VUZx8/u3fcXdrnI5cJddknuzZm01CEzagwoECXrD5kskNhFYJFM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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlnuQzWUYx9/dPbtnd9mr/PZw2INz1k4U1l1LUW7LalgzitUQ1q3s2hrV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           "],
           VertexColors->None], PolygonBox[{{6949, 5682, 5681, 6384, 1777}},
           VertexColors->None]}]}, 
       {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
        GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmXts1tUZx8/79t6+LxSib1taaBGxyebcdGYuC2BwmxcomLi/pjNmE6Wg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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwllW1o1WUYxm/POTtnZ2e4s0Oc/5k7ttnZaZBFWZIVmzCLMrOg+jSthErn
ipRGQTWwtNiW0Np6Ack+1MQXlkYQWZTSC/amhUWRoRHV0qAM+mBfclm/i+vD
Dc/zv+/nut+v/4K7N962IRURQ0gGuXp+xBLkwsaIbuT2esTKSkRPNuL+XMT+
YsQbfBsuRHzEw0xLxK/nR5xq9JtNpYiLOiNey0fsRfZhvwf7R7B/H/vxJOLK
asSbYF3cEHED93VdESNNEQfRv479F+3c0d+Cz9EyduAXuH+SMfYIPvbl7WNn
3ZjC2oCPn7H9BXkA+zG+3YT+HqSh4ByOYftKu3M5gs9S0Rh6uwz/k9wf64i4
AOyt3Bs5jxPfbmzfAu8hajGFHAPrVTBemhsxw/2vrHO6kfgWUr8qtdgPxmrV
AsyDxH6Y+3p8rUOWYp/H527y29wdkWqOODSH97WIj8GcpRcJPv9AvwV9A/rv
iedr3gaYE2Bt4/27+D5DfIex3YT+R87neLOcWD/k2yD2T1OvZmJrwv4o+Z/G
5vMmv1GsNaQv5ZhPUrsZpJf4ftMMgJUgRWy3ZRzbNRXXVjEOdLnH6u0oNruw
fYJ4/8PXmnTEWvTX4/MpdE8iq4j9jk7X4hLw7lJs+E/wNcm3R8ueAfX+QMaz
tplvUxnP3POc17dGnOD+AzLBfRI5znklGIuVOzUs46uCXAr+iprPn6Zdy9PY
1NKu6XfEdyhxrT5ADiT+pvNYyr3ZU3Yu6tFznLeT/9GsY5gB+0TNtZ+fd61u
ZWaqedfsd2wv59tVOc9IvsMzpVmaJd5rebsMeZbeN2Ofwbav5vNcZKDVOStX
5bi67h3Tbmmme8ueWc1qd9q++zsci2LYgv4d9EfQT/B+aeKeqBfquWZTO69d
14xuB7uv07M7zrd+4j81L2IR8Q9nXNsryp5N1XhOp3uo3mkme9AN4r+Dcxv6
fmZpln3PgTWMnK26Z+pVFhlstQ9hJ2nHel3NuSvmf7C/rGTbBuRm3q6qGVsz
cZZ8Hm517qPU9OWKd0q7pB5pFndyfy88k4tKxhSWYjpJbrvgsK+yzvFt/O+A
HzZy/jPnXVhLzbMF78R0xTbS/ZS17UDdu6w3K4gnjc058RH3KfQp8D/LmZOG
sP22xb2vFMwF99W9m+KEFG+ni559YSxuo5Zl714T779sNweJe8SR37QYU1ji
JO16uuxea+df4Pw4Nfi34Bpo98WB4j5xwELyGymbW1WDafTziuZCcexWerm3
aG6uEPOdVddctVZOwn6x7N7JxxL9K+qenQXgPdPlGVDvxaFniP/vdtdOO9jb
Zo4Tt4nj9a84npgb9M/Qv2F5Ym7RP0Jc0tPmWohT9O9Jt5ir9A8S9w1V7Fsc
WG83B2j3tYPnlcyh4k5xvLhnTcm5iYMeJN+xondfM3xv3T1VLzUD/wNNBvl+

           "],
           VertexColors->None]}]}}, {{}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{4278, 9648, 5761, 5701, 9042, 5709, 9050, 5692, 8041, 8049,
            4232, 8057, 4240, 6076, 9430, 6084, 9438, 5886, 6258, 6191, 9524, 
           6199, 9532, 4763, 8257, 8265, 7467, 7459, 4106, 7056, 5950, 9317, 
           5958, 6460, 6452, 5663, 10094, 5671, 5655, 8017, 8025, 8033, 9187, 
           9179, 6330, 9460, 6095, 9452, 6103, 7072, 7064, 9555, 6220, 9547, 
           9571, 9563, 4734, 8234, 4742, 8242, 9386, 4122, 6049, 4114, 9637, 
           6030, 7222, 3738, 6371, 6948, 6378, 5682, 6949, 4655, 9034, 5684, 
           9032, 5683, 9033, 3781, 6202, 5961, 7904, 7905, 7906, 7074, 3842, 
           7261, 6139, 4469, 7035, 5901, 5693, 4241, 8058, 10176, 4628, 9681, 
           8192, 8193, 4702, 7436, 4703, 7437, 8074, 4268, 7073, 5959, 9318, 
           5960, 9319, 4269, 9640, 6106, 4775, 8282, 8284, 8283, 4267, 7481, 
           7479, 7480, 3844, 7908, 3843, 7909, 7907, 9573, 9572, 5962, 6147, 
           10125, 6146, 4266, 9639, 5753, 4270, 7116, 7117, 6260, 6306, 4051, 
           9586, 4052, 7945, 7944, 9358, 9357, 7769, 7420, 4657, 7418, 4656, 
           7419, 5776, 5777, 4455, 5779, 4456, 5778, 6299, 6300, 5799, 10113, 
           5800, 4598, 5798, 10112, 5797, 6950, 5780, 10111, 5781, 4458, 7124,
            4457, 6233, 6886, 6885, 4006, 7723, 5766, 7722, 5767, 7724, 4744, 
           6461, 5867, 10114, 5868, 6274, 7156, 7157, 6315, 6314, 4279, 7075, 
           9575, 9576, 9574, 9578, 9577, 4745, 5635, 4187, 5762, 4280, 9028, 
           5636, 9025, 9027, 9026, 9196}],
          "3.08`"],
         Annotation[#, 3.08, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{6986, 3774, 7847, 7846, 7845, 5866, 6342, 6341, 3744, 8157,
            8158, 8154, 8156, 8155, 3743, 8153, 4630, 8150, 8152, 8151, 3742, 
           6984, 6985, 6181, 9511, 6180, 6983, 9510, 3773, 9509, 7854, 4629, 
           5865, 9597, 3741, 6982, 5864, 9508, 6179, 9507, 6178, 6981, 9326, 
           9327, 9325, 9329, 9328, 3845, 5983, 10123, 5984, 5982, 9582, 9583, 
           9581, 6227, 6419, 7469, 7470, 7468, 7472, 7471, 4186, 8267, 8268, 
           8266, 4764, 3783, 6418, 3782, 9599, 5902, 6105, 9461, 6104, 9462, 
           4050, 6305, 6177, 7161, 7162, 6309, 4185, 7809, 7803, 7781, 7782, 
           7337, 7338, 4183, 6994, 4184, 7961, 7960, 9390, 9389, 6298, 9364, 
           9365, 7956, 7957, 4124, 7093, 4123, 7955, 7954, 6037, 9363, 6272, 
           6273, 4796, 5860, 5859, 6980, 4182, 6050, 7281, 6407, 4694, 6489, 
           4693, 7031, 4700, 6417, 7311, 4048, 9229, 4042, 7943, 7937, 4790, 
           8423, 4755, 7451, 7445, 8149, 7245, 7361, 7355, 4224, 7733, 4218, 
           7349, 6384, 5681, 6377, 6947, 6370, 3737, 7221, 6029, 9636, 4113, 
           6048, 4121, 9385, 8241, 4741, 8233, 4733, 9562, 9570, 9546, 6219, 
           9554, 7063, 7071, 6102, 9451, 6094, 9459, 6329, 9178, 9186, 8032, 
           8024, 8016, 5654, 5670, 10093, 5662, 6451, 6459, 5957, 9316, 5949, 
           7055, 4105, 7458, 7466, 8264, 8256, 4762, 9531, 6198, 9523, 6190, 
           6257, 5885, 9437, 6083, 9429, 6075, 4239, 8056, 4231, 8048, 8040, 
           5691, 9049, 5708, 9041, 5700, 5760, 9647, 4277}],
          "2.8000000000000003`"],
         Annotation[#, 2.8000000000000003`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV01tozmEcwPHfnJKJkcMcdjCbY4o1YsnKsLCY5TCNljPzZruiaRklaTay
jcw5prjgghEvF5KSJKe5kN3sZuRGCTcon118+z6//+/wPM///76TttaU70uJ
iD84PSwifXJEHlJRhHzsHBGRMiZix9SIn6Mjrg2P6OIKcQ//kn/BK8VJPmrO
MZ4jbuWN8rd5kfgqn9Gf4FxxHX+Vr+Kx4nI+oD+T/02JmMml8kt5iPx8Pq6/
PT1ioPXMcREzMG9sRGVuxGZsQtNItdkRzbyA+6VFnLB+nxfRyEl7VKNenG1W
Fspwyh6r+a/cAHX98cT6t/t/wWKze7mYn6u7KPd+YsQHvME7tJvxls/zBfk9
aquxGwnsxQ13uDkh4hbKzUk4xxr+jNSMiMf6LukfYr3KrE2oRIq+isyIw+7b
yEf4gRkbrJPcJv7DrfyIp5rXjCZ0i1s8f8i/3KFEz07xMt7BB52rw/z14kPi
ddzAnerv4Z1cP++6zTkG8mPv5lVfbHaBc3aId8slUIsp+nNwV992carazajA
WrX7zazkNPHJvvenbqgzvORBWX6QuC/f6/u18Hh7jEKX56XqnyKJBt+2wD51
3Cn+7jyz3e8r59ijh895nwVyTe5z3btOU3vFOp1v2nO2PY7aYxrX80Y1W7Ac
K/Sv4bNmXcZHfd/0vOYf/FD+k/9JD6qcbQNWY7Qz5CHhO2ZwvnsWYom+bfoW
8knzBjvDJPeajhL7F6HdGQrtOdfsfJ7FtX2/S3O69T7T28XJvhn6D9jvGNfw
LhSqq3CelVzGxdyAO2Z1qvsPA0qPXA==
           "]],
          "2.5200000000000005`"],
         Annotation[#, 2.5200000000000005`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV02lozwEYwPFHkZjMPebaGBvmWHMt2XKGldsmORZDmrZXtiHeCC/WsM2x
N85hYpQobYWUJKQ0RSlWSFIi10Tx2Yvvvv/n/5y/37bUjWXLSztFRLIfR3pG
JI2MSEN35CILm3srGBBRnB7xrX/E2cSIVi4Ut/F3+Qe8SNzM+8zZz5PEtbxa
volnik/zUf0lPFJcyR/k1/MA8TIu1z+U/46OGMv58nO5m/w0Pqi/M3+R782v
5F8kR7xDn4ERj/kOtplTNyLiDA6gBVeRp769n3r9n3i3ec/4hfg1t/WKuM+P
xLd4rTkn+bb4Mq+U327OTszDBixHqTlV9tajcXDEYbX17jnCYwZFZGDesIie
QyMSUTREHR8aFXFJ7yWfG7kyzWxUoDjJzWY14ZpceZ+IBq7w+9jT8f54h+9S
UiJGIBWd7Kl189vhnhHt9kxQ85vf2P+Lx4t/cCb/5PO+b8B782bZO873q3xf
gEIsEee5M8fz5PJ03uWmHu4r7ujlK/qaUCmuQLK6wWrCvcfVt/v8C+vMmupZ
L/IUvsCZbj7Ic/UlmJVvTjfeJC5Cjc917qhBZ7Utah9xnbnZZjSIt8qVoAyj
9KTiut2bxN3VrkUhVqjd4Y41nCiuln+qLsHOh9zFO/un96b8e++zhgfZ0Ret
cvnq76IZe/0tZKut5Bviz+6Z6B1+4FQ72viE30W2XJVnOOedJKo95XMSN9o5
0Y59dqTzbl6tpggLsFD/Uj5m1kk81/dRzxP+yrfkX/ofbcN6txVgMfq5IQ0l
/kaGcJbnzMEcfRv1zeBq87q6IcVzZWC+/bmod0OOnZPNzuJMLsMfc17pvae3
lZs7Zugvt28/l/IW5KgrdM8iXsKzeS+umnVD3X+FBaKW
           "]],
          "2.24`"],
         Annotation[#, 2.24, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV0mtIlmcYwPGrksg+mG8Ha+ugZSkVNHEQEiuWHayobEpKhEXuFEbuw7RW
0WDRgkLK3qL6YCetKNYHMzCFGiPZpMMgFAyCeNcaFcFoqyCotfq9H/7+3+u5
Dvf13I+Ta7+pqB8UEbP9OZAVkZMfkY9MzEURvkhEvBsT8XlhxHM+NSKij6vE
KX4h/ysvFXfxLnN280fig1wt/xN/Ij7Bh/TX8RTxVn4kX8NjxKu4Uf8EflMQ
MZ2XyS/gYfKzeY/+IfxMPpvvyQ98GPEQiXERN/kaNpqTnBJxEj+iGxcxT/2r
0er1P+Xt5t3hAfF9TmVH9PANcSevNaeFr4ovcKX8JnO+w0Ksw2fYbM4+5x5F
zdiIS3wW/er362vX/wOXm/c1t4kbuEx+pv4SZGASEthg3m/uvx8ZkzxHArft
/3Sid0AP7uMOSs196bxFEyIGjXdnKMVjd3QgJ+J797efz7ijNmwxq9eeN9Xv
zfVu9ril/jy/8Owl/sWMkb47N+rtsssW7uZ2z1N5EQ/wBz717NgHvps9mqa5
G2c8NO9P7LDzFfkGvZ38Lb915koz/uN3+B893rlD/XVOmlFtxoC9K81t4Qru
Nr/V7mV2WozbGGxOr/rzfo81J9N9rPDsjd/L+Xr6f1NPN5JT3Yf3zpZLYJvz
hos3yNViPZrFSbOaMSR9phk3OGmfYrNbxV/J1aEeU/Xkod3eteJMtWtRhQq1
Dc5Yw1niJvnf1Q23Ry9npN9d72X5v9xjM49zxkj0yS1T/zO6sNO3KVa7lTvE
f9tnlrt8xHnOSPER91Mst887nHYnWWqP+53D55w5yxm7nFHA27lazXqUYYn+
cj5sVgv69T3Rc4v/4U75u75fCjV2W40VGGWHfNS55/Fc5D1LUJq+V31zuMm8
oXbI9V6FWOT8uThqhxJnfmx2Ec/kerw2557eX/T2cVd6hv5G5+3mzfwlStRV
2Wcpr+T5vBMXzepQ9x6Xwr4T
           "]],
          "1.9600000000000002`"],
         Annotation[#, 1.9600000000000002`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV021olmUYgOFLR2Q/1Dk2pzO3trkZgzVmjNGycFN0kppJE5EVS5uycCkq
C2G2ZAWZfThDQ9ZWRovYftiE8Q4qglE6LZB3bsFAXlCxWpqRhjYj89iPc+fu
XZ/38zzL37Jzw6vTIqLKj/dnRWQVRhRgBpaiDFvnRNzLitiyOOIv/mR2RJLr
nFN8U/x7rnVO8AF92vkx58O8UbyXn3Tu4iPqmzjfuYWvitdzpvOzvFf9Ar5b
HPEorxav4QfFK/gt9dP5hvhsHhcfy4m4jPR5EWf5G2zXp6MgohtvYhB9eEr+
7Uz56id4n37necz5IqfSI4Z42HmAN+vTyV87f8kbxF/R5zUsxwtYjx36HDT3
GOqzI77izzEi/z11J9W/wev028afOe/hleIl6iuRhoVIR4N+P3j+I0jL9Xek
40f7Tyx0BwzhIs6jWt9b5q142Atd4H5zI3J42aKIWbxE3Q19/8UZXMIo7qpL
POIdohcpJDHNXoPz7YDN9uzj1/Xv5go1u7jUrP08atZH/A6q1B1W34UmtKMF
f6hJ2j+Fd+37BY6jR/5ubsMzaMQmlMl/2rw27/Rx87uKfGueyS/e+S3O1nMe
MjEXWVO7q1lvh+dQo65azXLU4G3P4G91k3nujNv4B3eQyIi4IGeQ6+xzTa/r
+A2/YwL/631a3zM4qvcwd3C5XU+oa/QsmtCMQnfMw0nzXnKeMfUMUTe1m9w9
dtnEM50Pif8k7yHv6TSn2ec/tafEr5j7AWebMQdJsdXyv0UCrXYtl9vC/c7X
7VPqXVzlPDNSfNTe5WIHfZOfuuNMuR/7PYt7zCw144AZRbyPN8p5ESuxSv06
/lCvToyo+1XNOf6TB8R/9n2mUG+357EGGXYoQJP/2Rwuc89KVKtrUPcEH9Lv
ATvkulcxVpi/FMfsUGnmEr3LuISbManPuNrv1CY5MdVD/V7z2nkHv4xKeXX2
qeW1vIxb0adXv7z7ju/AZQ==
           "]],
          "1.6800000000000002`"],
         Annotation[#, 1.6800000000000002`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV02tszXcYwPFHI+YFitalbmtpJ5JqVKSZW3Qzl6DEdsSkRBhSsbBWKk3c
azE6t21uacuyIKYvXBJOk7kkwsa2RE6VRMJJEFmEWZCIS8h8+uLb73n+v+f2
/53TvIUrPl/eLiI+82d7l4jsQRF5+ACjUYSF3SLe9YhYMDjiKR/MjEhxQpzm
Z84v8SRxkjfoU8tDxTt5lvNjPErcyD+or+BccTU/cF7OWeLpvFJ9H379UcRg
nuz8E+7gfAR/q74dP3HehW85v9En4h4ye0dc5bNYos+ugREHsAnNaMIY+S+y
5at/yDX6XeMb4tuc7hpxka+IT/Mcfer5N/FRnul8qT6r8CnmYgaW6bPF3D0o
7xVxgg+hRf42dcfVr+cy/RbzL+IqnuB8iPoSZKAfMjFfv8vuvwUZAzxHJv6y
/8P+3gEXcRvXUKrvc/PG94v4v+0+ekbk9I0Ylx/RmYvVPdH3Df7AXbTitbpk
ru8Qx5BGCmGv5hw7YI49m3itvgd4hJoVXGjWGm41ay9vxUh1O9U3ogK1qMa/
alL2T+N7+x7BfhyWX8nrMAWLMBtF8seal2vGVL5ixmL+EkPVlNlprzss5YS7
KuCt4uF83rs+yot4iUtII4WBeu7gBmzEGfyKAvn5+haj1V1dRy999vk99eak
nKruEd29RyVn8R29ZnjfNNcV+I3K/U7dZjyzT6Nnm/0Odnm+ln8SX/b8G+eV
6OjZGXeRRDMSbXetV8L7dvC5Rk4VZpvXSVzn+d/qO/o+f+eMDyPeqjvl/L59
dnBP99YVKWeT5Z9DEqvd1zC51XxS/NhOhe7zAQ8wI827zR7mbIu9frZrJ7kN
PmfzYTMLzdhgRj7X8Cw58zABE9WX8Y961aNF3T9q/uT/+LTzm37HaZTb7QtM
RTc75KHC/3YOF3nPEpSqm6/uY67Tr70d+nuvAow3fzT22KHEzGK9i3gIf41X
+txSe0FtipNtPdSvNK+Wl/FXKJGXsM8knsbjeDWa9Dop7z398sJ0
           "]],
          "1.4000000000000001`"],
         Annotation[#, 1.4000000000000001`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV02tolnUYgPF7hqGk8zCdWx62uaXCHM7GMKc4FZ2HTVlOTVZITWVh4ImF
YKYuhZmmKU7FQ1KtpvugRjpBLRAjM0Le4QFBXlCMkMjQcqaJab/3w7Vr93P/
78NzePPqls9ZlhYRlf58kh6RkR+RixdRhiK80yfiaf+It4dH3OPPekUkuEac
5Pvy57lC3M7r9WnkkeLtPFf+CI8VH+Ad6us5R9zAv8rXcl/xLF6lPpsfD4sY
xtPkJ3JX+RLeqD74rnxPvi5/5eWIW0jPiviJz2CJPp8OjTiIj3AKbRjnfGc/
59Xf4dX6XeIr4huc7B1xji+IT/ACffbxaXErV8u/q8/7mIQ3MRtL9Wkytxm1
AyKO8ZfocH6ruqPq13GVfov5c/FKniI/Qn0p0jAQ6Vio3w+efwfShriOdPxs
/zuD3QPO4QYuoVzfv8ybPCjiWep5ZEZkDYyYUBDRg4vV3dX3X/yIm7iMx+ra
c71DHEESCTw3/1S2HbDAnm28Vt+DXKJmGRea9QFfNms3b8Zr7me7+gOoRyMa
8IeahP2T2GLfr7AXLc6v4A8xA4swH0XOjzcvx4yZfMGMxfwGRqqpstNuz7Cc
a+xawJvFo/k79/p7XsQ/OI8kEsjTcxvvxwacxGEUOJ+vbzGeeHcDOPuViJd4
mt6znKnFRDSgHt+oyTRrrZndub/e1zIi6sS3OTP1u+Hl4ntcps9Znie+yC3y
x3i6+Avupr6Jx4mbeZv7/dq9t+Jb3/V99b1yfAMoMf9VHHJ9kX132vWo/Ove
8wN1m/xWOrnCu3/gfGXfiL/5ITrxzKwu8v+lnofaavkG+/xi1h7XR3lHhTxY
v6QZu5wbJddk1qHUc/H89/s/g1vMKPR+1+uRz6t5rjNvYQqmqq/inXrtQ4e6
39Rc5D/5hPxV33gStXabg5nobX4u6t1LFhf5tkpRrm6hujH8sX4v2GGQ76UA
k80vQ7MdSs0s1ruIR/B7eKTPdbXfq01we6qH+lXmNfJSrkOpczX2qeBKnsBr
0KbXcef+B61bxl8=
           "]],
          "1.12`"],
         Annotation[#, 1.12, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV01toznEYwPFHEcYcxmyGHcyhnEkxckqGkJpTU3KeXDBMLpy5IOcLa7Ep
TNgFKawcLjQ5XWiapHjL6WLJOZLDDJ/34vt+e97n9xze3/v/5y0rLVrbIiIy
fbTuE3E4P6IKu1CLGtzrFLGhW8TW/hEruUvHiPdpER/7Rvzkz/Iv+JW4gT+l
RrTqEvFbnMb7OkcM4tb9InI4V/0czhMv4T/qC7mruICb1K/hIeLNXKG+T17E
cDTnRmRwCgbr87x7RFtzGvlDRsRf/pr8Ts1RtWP02JOc3SHiFE8VX+Rq+fs8
V3yDC/T6xGvFTZwu/5qXip8kd1PfpmvEFnE6X5IvsUMZJqAYM1GoT0qW+7RT
N/5lp6HcG/lqzjlzBTtwHAeRq3c9J1CH73iLm84PM2uvmflcpPd4LhfP4IHu
bb6+y3HX/zKds3tGjOVBes7rFbEM07AVpahWU8FnsA+JbLPxzvkyd7sTJajE
IYxyfq/7LEeDGZt5gBlreISaKt5iXg0vsNNtrsVfu9arT+A86nAVP9Q09Pa8
4A5+4j2G+q3tekSM8wxm8EuzmvWdZNYXHq/uoX2f4Ra+oREP1KXaPwuBR57X
21hkfqq+WQiMRH9M9nvW2fOkO1zOM/TdxhfE+/mR/GnzLqLYf3eU92C1frPU
L8REbMQqzHb+rLpr6o/xAv0u813xLU7IP+PH4oe8SZ9Gfin+xmPsX6NPLXah
CoexQp/r5t5Daqbz/BhPnW+f7s7U/1O/W78R4pbezQlcKN+Xf8hn8np9ZnJn
+WJ+I1/G2eISPqK+kkeLz/Mc+UM8ULyTt6u/ylPEdfxZPsFF4no+kXxveLG4
iZck33X3X4BWyEEaDujzH0rzqrY=
           "]],
          "0.8400000000000001`"],
         Annotation[#, 0.8400000000000001, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV01toznEcx/GviDmbnZy22ZxijimnnJIhkzKsKTmMyYXj5MKZC3K+IGHK
KezCUlg5XIicLtY0SfGU4WLJGJGcT69dvJ93n+f7/36/v+f3PE9OyerCVc0i
oouXvR0ikntFZKEFRiEPC5MjfqZFLOgX0cgnOkbU8Cw5wR/Ub/Nk+SpvMWcb
D5D3c6H6BR4pH+eD+ks5Uy7j1+rF3Eku4DX6M/hr34jenK8+npurD+Md+v+m
RjSot5Wfqj/uFlGHdl0i7vN1LDHnQG5EObajChUY7fnP+uv01/N686r5sfyM
E50ibvE9+TIXmXOUr8nneKb6MnPWYQLmYQaWm7PT3kMozoio5NN45Pk9+i7q
38zTzSvhk/JqnqTeV/9w/MuJ6MrtMN+8O+7/Ef5lej/L+3jo/PXyZ9zCM1Rj
nLkf7ZvYI+J3032kR6R3jxjbO6IND9bXYO433MUL1OKrvqs9fYe4gARq8Mf+
qq7OgCLnrOCN5pbzMD0ruL9dG7jWrsO8CyN8nv36j6MU21CGt3pqnD+B3c57
FkdwxvOreBOmYjHmIM/zY+zLtGMa37OjhOdigJ7pznTYHY7jWc6ay7vkIXzT
Z33jLr/gNhKoQbaZ+/gYtuIKziPX8znmDsZ3310aZ/SJaM35Zhd4phjjUYZS
XNKTatdGO1txitlPUiIWya84tel/wyvlRh5lzg2eLT/gM+qVPEU+xS317+TR
8iFOUv/kPv/gnTPVc5IzPeeBZrV2hnT8drdDuReO6Nmgd5AZK/hne3s5Rc7n
X+5tIfeUCznbnKym3XIe79afzD/sacGN+ms7R7yUX/AH/d/4vdzAnfUv9b1s
8t9cy/fVK/xeq7Ad5TiAln6D/wFiv6uc
           "]],
          "0.56`"],
         Annotation[#, 0.56, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV01toz3EYx/EHOcdmszltY86bY8opQzKElNOaktNMLjAmFzbHC3K+IGHK
KeyCFFYOFyKnizVNUvzL6WLJGJEch7x28d67z//5Pc/z/X9/+2cXrZ1b0iwi
uvqzp2NEcp+ITLTAaORicaeIX2kRiwZENPDxpIgani0n+KP6bZ4sX+XN5mzl
HHkfz1E/z6PkY3xAfzFnyKX8Rr2Qk+QZvFZ/On/rH9GH89XHc3P14bxd/9/O
EfXq7eSn6o+7R7xE+64R9/k6iszZ3zuiAttQhUqM8fwX/S/11/EG86r5sfyM
E8kRt/iefJkLzDnC1+SzPEt9hTnrMQELMBMrzdlh70EUdom4yKfwyPO79V3Q
v4mnm7eMT8glPEm9n/4R+JftXXB7LDTvjvt/hH+ZPs/yOR46f538BbfwDNXI
M/eTfRMzIhqb7iM9Iq1HxLi+EW15iL56c7/jLl6gFt/0Xe3lHeI8EqjBH/ur
ujkDCpyzksvMreDhelbxQLs2cq1dh3gnRvo++/QfQzG2ohTv9NQ4fwK7nPcM
DuO059dwOaZiKeYh1/Nj7cuwYxrfs2MZz0eOnunOdMgd5vFsZ83mnfJQvum7
vnWXX3EbCdQgy8y9fBRbcAXnkO35XuYOwQ/vrjOn94tow/lmz/BMIcajFMW4
pCfVrjI7W3GK2U9SI5bIrzm16XfDq+UGHm3ODZ4rP+DT6hd5inySW+rfwWPk
g9xa/bP7/IP3zlTHrZ3pOQ8yq40zpKHR3Q7j3jisZ6PewWas4l8d7OUUOZ9/
u7fF3FOew1nmZDbtlnN5l/5k/mlPC27QX5sS8Up+wR/1f+cPcj130r/ceyn3
21zH99Ur/b9WYRsqsB8t/Q/+B/viqoQ=
           "]],
          "0.28`"],
         Annotation[#, 0.28, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV01toznEcx/EvMYdidnLaxjanzTHlFCMZMinHpuQ8uXCcXDhzQc4XW2JT
TmEXpLByuNDEuNA0SfGU08WSMSI5H8prF+/n3ef5/b7f7+/5/f9P7vL1c9a1
ioiuPvZ3jkjuE5GF1hiFAixKifiZEbFwQEQzH0+OqOeZcoI/WK/lSfJV3qbP
Ds6XD/Is6+d5pFzJh9WXcqZcxq+tl3BnuZjXqc/gr/0j8rjIeiG3sj6Md6n/
mx7RZL2D/MT6o54RL9Cxe0QdX8cyfQ7lRVRhJ2pQjdH2f1b/Qn0jb9TvAT+S
n3KiS8Qtvitf5nn6HOVr8lmeYX2FPhswHvMxHSv12W1uOUq6RVzkU3ho/z51
F9Rv5Wn6LeUT8lqeaL2v+uH4lxvRjTtigX633f9D/Mv2fS/f477zN8qfcQtP
8QDj9P1o3oSsiN8t99E1Ij0zYmzfiPY8WF2Tvt9wB8/RgK/qruZ4hjiPBOrx
x/yaHs6Aec5ZzZv13eB9GWDGJrnBjAregxF+x0F1lSjFDpThrf71zp3AXuc8
gyM4bf8a3oIpWII5KLB/jDmZZkzlu2Ys5bnIVzPNWSrc3Tie6Yw5vEcewjf9
xjfu8AtqkUA9svU8wMewHVdwDjn299Z3ML57Zmmc0S+iHRfpXWxPCQpRhlJc
UpNq1mYz23KK3o/TIhbLrzi15f/Cq+VmHqXPDZ4t3+PT1i/yZPkkt1G/m0fL
5Zxk/ZP7/IN3ztTISc70jAfq1c4Z0vHb3Q7lXBxRs0ntID1W8c9O5nKKXMS/
3Nsi7iXP4mx9slpmywW8V30y/zCnNTerb0iNeCk/5w/qv/F7uYm7qF/uuWzx
n1zPddarvac12IkqHEIb795/iHWoag==
           "]],
          "0"],
         Annotation[#, 0, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV01dIlmEYh/FbysZB5mqpDVvaJCiLFpEVFoEtDKJtdNC0OmjXQdE+KKIF
LUoPiqASWhBF60AUI4L6oEVIZFkU0bQ86OfB5eX/e577vp/3eb8vt7Rs5uqk
iMjyZ09KREqviGwkoQD5mJcW8btDxNy8iAY+0T6imovlBH+yfofHy1d5sz5b
OU/ex9Osl/Mw+RgfUF/KWXIZv7Fewu3kybxKfSZ/7xuRy4XWR3NYH8zb1f/L
jKi33kZ+av1xVsRLtO0c8YCvY5E++3tGHMc2VKICw+3/qv6l+jpep18VP5af
cSI14jbfly/zLH2O8DX5HE+1vkSfNRiD2ZiCpfrsMPcgSjpFXOTTqLF/t7oL
6jdxkX4L+aS8ksdZ76V+CJpyIzpyW8zR7677r0FTV5938zkeOX+d/BW38QxV
GKXvZ/PG5kQ0Nt9Hx4iM7IiRvSNa8wB19fr+wD28QC2+q7vawztEORKoxl/z
K7s4A2Y5ZwVv0Hctlvl/Bd9S+7ZdRF8z1/us1sxDvBNDPdc+fY6hFFtRhvdq
qj1HAruc+ywO44z9K3gjJmIBZiDf/hFmZZkxie+bsZBnIk9NkbMdcpejuNiZ
u/NOeSDf9Mzv3Ok33EEC1cjRcy8fxRZcwXl0t7+bvgPw0ztM58w+Ea24UO/J
9pRgNMpQiktq0szaYGZLTtX7SUbEfPk1pzX/fni53MAF+tzg6fJDPmP9Ik+Q
T3EL9Tt4uHyQk61/cZ9/8cGZ6jjZmZ5zP71aOUMGGt3tIO6Bw2rWq+2vxzL+
7R0VcKpcyH/c2zzuKk/jHH2ym2fL+bxLfQr/MieJG9TXpke8kl/wJ/U/+KNc
z+3VL/ZeNvqNruYH1it8byuxDcexHy18F/8DFleqLQ==
           "]],
          RowBox[{"-", "0.28`"}]],
         Annotation[#, -0.28, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV01toznEcx/Gvswuz2QzbmPPmmGLklAwhZVhTMqfJheNwwRwvyPmC5FRO
YRek2MqpRE4X2pqkeGpDWjJGJOfDBa9dvJ/38/n//t/v9/f//Z+n5+LVhaXN
IiLTx672EUm9fUcgD7ko7hDxIz1ibm5EIx9Ljqji6XKC31u/xePlCt6oz2bO
kfdwgfVzPEw+wvvUl3CGXMovrRdxO3kKr1Sfxl9yInpwvvXR/E8ezFvV/+kY
0SC3kZ9Yf5QZUYe2XSLu8VUs1Gdvr4ij2IJKlGO4+z+pr1Nfz2v1e8iP5Kec
SIm4yXflS1yozyG+Ip/hadYX67MaYzAbU7FEn23m7kdR54gLfBLV7t+p7rz6
DTxZvwV8XF7B46z3Uj8Ef3tGpHNbzNHvtvOvxt9urme7jgf2Xy9/wk08xUOM
0veDeWO7RvxqOo9OEalZESP7RLTmAeoa9P2KO6hFDb6oq+jhHeIcEqjCb/Mr
M+wBhfZZzuv1XYOlvi/nG2pfJUX0NXOdazVmHuDtGOq59uhzBCXYjFK8UVPl
ORLYYd+ncRCn3L+cyzAR8zETue4fYVaGGZP4rhkLeBZy1Ey2twPOchRPt+ds
3i4P5Oue+bUz/YxbSKAKWXru5sPYhMs4i2z3d9N3AL55hx04rW9EK87Xe4p7
ijAapSjBRTUpZq03swUn6/04LWKe/IJTmv4/vExu5Dx9rvEM+T6fsn6BJ8gn
uLn6bTxc3s8trX90nr/x1p7quaU9PeN+erWyh1T8craDuDsOqlmntr8eS/mH
d5THyXI+/3RuxdxVLuAsfTKbZsu5vEN9En83J7hRfU1qxHO5lt+r/8rv5AZu
r36R91LmP7yK71kv97utxBYcxV4091v8D2sjqhI=
           "]],
          RowBox[{"-", "0.56`"}]],
         Annotation[#, -0.56, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV00lsjWEUh/FTNSzQak1tKUpbikgoMUUUQSQ1VCViLhbGthZmFsS8IGJK
TEEXRIImpkSIaSGViki4iSnSiJpCxDws8Ovi6dP/fd9zzvu937058yonVyRF
RJY/W1IiWnSLyMS/rhGFnI/paRHf20ZM6x7xlg+kRtRwsZzgd9av8nD5HK/W
Zy3nydt4vPUT3E/exzvUl3GGXM7PrZdyc3kML1Gfzp/zIzpzkfXB/FfuzevV
/24TUS83lR9Yv5cV8QTNMiJu8gXM1me759iPdahGFfrb/1H9E/V1vEy/O3xP
fsiJVhFX+IZ8hkv02cPn5WM8zvpcfSowBFMwFvP12WDuTpS2jzjFh3HX/s3q
TqpfxaP1m8UH5cU8zHqO+j74kxPRhpthqn7X3P9d/Mn2eSef47bz18kfcQUP
cQeD9H1v3tCOET8b7qNdRFqHiIG5EU24QF29vl9wHY9Ri8/qznXxDnECCdTg
l/nVmc6AEues4hX6VmKB/xfxZbUvWkbkmrncZ7Vm7uKN6Ou5tumzD2VYi3K8
UlPjORLY5NxHsRtH7F/EKzESMzER+fYPMCvDjFF8w4xZPAl5akY72y53OYiL
nTmbN8o9+ZJnfulOP+EqEqhBlp5beS/W4CyOI9v+jvoW4Kt32IrT8yIac5He
Y+wpxWCUowyn1aSatcLMRpyi9/3WETPkZ5za8PvhhfJbLtTnIk+Qb/ER66d4
hHyIk9Rv4P7yTk62/sF9/sJrZ6rjZGd6xN31auwMafjpbntxJ+xWs1xtDz0W
8HfvqJBT5CL+4d6mcwd5PGfpk9kwW87nTepb8Ddz/qU7t/pafio/5nfqv/Ab
uZ5bqp/jvaz0G17KN61X+d5WYx32YzuSfBf/A6MbqvY=
           "]],
          RowBox[{"-", "0.8400000000000001`"}]],
         Annotation[#, -0.8400000000000001, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1GtsjmcYwPGrdE2EVuswStGOai2RGDazLDELi/OhEonDGFmoqEOmFnwh
xJAQGcK2CirWLUEb51O0zKFSQaJNMJFGHIqy6XTEF/F7P/z7f67nvq/Dcz/v
05zZiwoWJkXERH9+yIjY3iPifG7EKTT3jLjBGe0iqvIidlkrQzkau0a8wrzO
ETuszeIN3SO+T4+oEJ/AH2jMiriLbDVqxQ9c77Yvv1dEP+wT78SLthFr1evb
KWKq+59yXmZED9SmRaw3R657bT+MyNG/Dz7BYjMWokjf6/L223OZj3CNen9h
pH1DMRiV1o6j0DytsuVzBnd075EZ9qp/j0v0u2htrP7DUWGGNuZMxlzzH1W/
wnWxvkn2XbY/eI38u/Y+1esZGhK93X/Ch5zRSx4p/pdHcRN3l/uBtYt83Tu4
Y+ZrfEGc7P4N17e7RKS4ruLD+FaPdR9FbMMKlKMUA+x93sH+3hH1vMizXOKr
4ptcZ96TXCnezxPU+ZkPiXfxCOvfqbMAgzEJ32C2Oiv13YgCz17Gv+GK/Wvk
/S7/Rx6m3nT+RTyPv7SeLb8v3uZEtOcUTFbvjPd2BW+7ue9MU3De/PXi5ziJ
m7iEQYkz1e8LZ/6abzvndOf0mfeWzPnyHqrbhLO4hRq8lHfQ+z2NPahDNd7o
X+69nsEEc5ZysboLMcd1IR+Tey81oqeeS9yr0XMTr0I/z/WTOlsxE8tRhAdy
qj1HHVabeyc2o8T+Ql6KoZiGcci1f6BenfT4miv1mM7j0UvOMLNtcpaDeLSZ
s3iVuA8f9cz3nek/OI06VCNTzbW8BctwALuRZX9XdfPxX+Jb4gy/sZY8RO3h
9hTgcxRhJv6Uk6ZXsZ5JnKr2tfa+UfHfnGa9meeKG7i/Okd4rPgcl1gv46/E
v3LIX8kDxBu5hfVG5/kGj8xUzy3MVMu91WpphnS8drYfczdslrNEbp4ac7jZ
O+rPqeIh/L9zm8JdxGM4U53Oid7iXF4tvzW/0uedb7BBfg3fEd9KfKvym/ix
+CG3kT/De1nq/9d8rrJe6ndbjhXYhnUIv8X3aCfQjA==
           "]],
          RowBox[{"-", "1.12`"}]],
         Annotation[#, -1.12, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1Gtsz1cYwPGnRLKMal1CqbUu1T+JBJuZWWIVXritVplkJhMhVlkZ0y6b
ZZmQuq6RIW4Vl81KgnrhMtRailWasGRt4pZGpKxbOjbTVSTi8vm/+Pr2Oec8
l3P82gHzlsz4LCUiJvvn824RW7Mjzg+OOI22QRG/cXr3iJpExG57FahEa2bE
IyzMiNhmby6vy4qYnx5xVPwzDqC1X8QtZKvRIG728x7nEjkRw7FfvAv30yJK
1RvWO2KW9VGc2yciCw1dI9aaI8da114R/fUfghFYYsZCFOl7Vd4hZ37lY1yv
Xi0mOZeHMai2dxKF5nmlv3xO557W7pnhB/WbuFy/i/am6T8RR83Q2Zwb3POU
M7U8Vu1RWOw+xfo3WruJr5HibEJ+kztfFfcQl+nxjbnanX+Ks/r8aK2W19sP
ffLkLErWRLu8GdYv6J1v7wPxUnPN5MP2D+GI3O+tzVO3ylzN7jhUjePqn8BF
uf9YezYw4jmy3bXYfhaX8J/ebrW8Fi7lAnU2mPl93tk34rJ7reoZ8VNuxBc8
Qb3ZvF28kN+xn63uMDwZENGdO2GmuarUvIwnr1k3Syec943dFv+NU/gdlzBa
3b/0e9t92/m6WdLc703v05ET8u6q+xC/4Brq8a+8I+5yBnvRiDo81r/Sm1Vh
ujn3cbG6i7HAz4V8Qm5TasRAPZdZq9ezjFdguHutVmcz5uArFKFZTp17NGKl
uXdhI8qdL+QS5OEjvIcc59/Qq5ce47laj9mcj0FyJpitzFuO5ilmzuQV4iF8
3J3veNMHOING1CFDzVLehC9xGHuQ6XxfdRP4L/m7wum+jQ48Tu2JzhTgLRRh
Dg7KSdWrWM/gLmpf6eF3UHyTU+238SfiFh6pzjGeJj7H5fYr+F3xDn7hPb/l
18XfcYr9Vu/5GPfMdJtTzNTAg9XqYIY0tHvbodwPG+Usk5urxgJuU3MkdxGP
4/+924fcRzyVM9Tpneyd/BvBK+W/yo/Ez3zjLfLr+Yb4WvKbl/+Q/xDf5c7y
P/b/UuK7/5Rr7O/z3VZiObZgDV7gJW32zC8=
           "]],
          RowBox[{"-", "1.4000000000000001`"}]],
         Annotation[#, -1.4000000000000001`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1Gto1WUcwPHfBO+XmZpzm1Pn3JkQmDatfDGXqYiXxBuk4RSWnXCFuomp
SCbMbo5BhSIT71pgnSGzvJWXIQ4G2osNpqsRomYwEnVL38jQPufFd9/ze57n
d3n+/52TX75h6fqMiJjpz8aXIvaMjbhSGHEO3QURv3PmsIhLRREH7J1ACp25
EV34cFTEXntr+MsxEeVDI+rFZ/A9OkdH/IExarSI7/h80LnEhIhJOCbej38z
I6rVeyUrYoX1Yi7MjshDy5CIL8xRYG3wyIix+hfhVaw3YxIV+t6Qd9KZa9zA
zeo1Yq5zpXgDF+39gqR5+o6Tz5k83No9MxxRv4Pr9Ltqb4H+s1BvhgHm/No9
zzrTyNPVLsbH7lOlf6u1dmxDOJuQ3+HON8TDxDV6bDfXE+ef4Vd9jlpr5K/s
v3CuVM5Hak7nck7imfUyXolKeZtR7fxn2I5Tzpbkyff+3jdryvk1vBp/mnuJ
+y3FYizHMmxz9rF7NNhvH6yO+14QT1RrmZq91euDfuiLnvEROfJykY08jMYV
dU7Iu8xX1TjuczdKzNjFKa7Hm2rOcdfZuGm9mNt4Kvdyr4T8u3o8wm9oQzMe
mu8nfc7jEFrRhKeeWcr9LmDRiIjDXJXjXWCtz0n+WW6Hu+XrXWmtWb8a3oFJ
3tcudb5FGbagAnfkNJm3FTvdez9qUed8kjehFCuxEAXOv6bXy3q8xRf1eI/f
wXg5b5utJhExjeeZOYd3iIv4tDvfzo94gPNoRROy1Kzmb/AJfsRB5DifrW4C
j9PfBc70zDO4RO1ZzizG66hAGX6QM0ivKj1fDI8YqPZ1XiFu50H2u/kD8X2e
rE4DLxBf5rr0++UZ4n383PP8lKeId3PY7/Q8n+Kemf7iMFMLT1ArwwxD8MSz
nci5qJVTKbdQjbXcrebk9GziEv7Pc3uXR4nnc5Y6I9O9078BvFN+f+4S9/h/
vS+/mW+J2/gf+Y/4b/FdHiB/lfeyyXdxHV+yf9hvRgpb8R0+x3P8D2t4w4E=

           "]],
          RowBox[{"-", "1.6800000000000002`"}]],
         Annotation[#, -1.6800000000000002`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV02tolmUYwPHLsnSuzTbn3EzNtYMglCEqBmuSkZkEA2knHAO1RVvUnAeU
kQWreSoIKcJK0phHJjGPUzyMMcPV+jAhWoyobS1Yiuk0qhm6fu+H//7P9dzX
4b6f+13OmrqVb42LiGf8qUuL+PjxiEv5EWcwkhvxPaemR1yYE/GFtWa0YPix
iFt4LSviE2tVvG1WxOpHI46JT+EAhmdE/ISZevSI+z3vlZefF/EkvhJ/hmuT
Ixr1mzstosz7+ZyXHTEDPakRTfbxhHePZEbMMr8AT+FNe6xGjbnd6o7I6eRW
vqJfO5bJK8IinLd2EtX28/Bs9ZzK6d4N2sM+/ft4j3kd1laYvxTH7CHJPnc4
52k57bxY7/l4w3nqzb/qXS+2YMz7fPV9ztwtTlO7y4wG+7ojfxTnzNnvXTtv
t35fXpGaWrWLeTVXY9T7Si7HOnUb0Sj/HTTga7mFM9W7vzX22iJuVbPB2iY0
mblKTRUq8ZC4RK8U32O3+e+Ju+yz2HfYp7bT82V04EXxDXnLebwZOzw/yMvE
4/gFfoD7zBtIcSfmTfX8je83aj+Znu/yqDu6i3/wue/3Lzfpvw0TzG/T9ywa
5Pbb2wCeV/uBPv2+fa1z/crl9liBMuw3e70+JfrV8yt8zfn+wDBK5ZTgkLv5
W7/DfEjPLnv8FmXyN6gr541cykXOcganUajHCTP7nCtD/pLpfj9yKvhl5Oj3
XIZ7LYhYwMvdYzZvFRfwcWf5JSfiOtpwFZeRqWcjf4RNOIq9yJafpW8+biZ+
65zq/MGFei+VU4yFqEElDqpJNqvezPtTIibp/R2XiXs52foIvyoe4nn6tPIK
8UXeY72ZnxV/yvec9W1+WryTx5xx2Lf/C4P29DOP+c30cK5eYQ8puOM7z+Hp
+FDPdWrz9FjLI3rOS+xNXMi39SzlaeKXOFOfqYnZif9xflf9RL4l/s8dD6m/
wj+Kf+Df1f/Jv4kHOEn9Kvey3m/pdb5g/Uv32YLN2I33cQ//A0ymw0c=
           "]],
          RowBox[{"-", "1.9600000000000002`"}]],
         Annotation[#, -1.9600000000000002`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV02lszlkUx/GDsZXa17QdHi0imSGECEUUE60XtgRRkWA6GURaW0YaSyL2
WCJEbLGkJpmkIqWLyBiN2BK8aGWidLwwlqQRWy0vRKr1eV58n98959yz/O+9
T2JZ0dzCVhGR8FPYPeLQgIhrgyOq0JgZcZ+m9oi4OjTihFgJStGQFvEev/WL
OCy2mO74MWJJt4jz7AqcQ0N6xCOkq1HDfmp90r6srIifcJZ9DK+6RmxVb1jf
iPn8I2lm/4g01HSJ2G6OBF+nPhEZ+g/Gz1hlxgIs1/eevL/suUHL6B31qvGL
fRMxBn+LlaPAPG0HyqeptDvfMzOcVr+eHtXvulie/jk4b4YO5tzlOyvtqaZj
1R6Jlb5ntf61fHXYgGb+LPn1vvkeu5vcPXoUm+uj/V9wRZ8zfNV0p/g3+ybK
WSF3LF1CC/CFfxFdgCJ567DV/s0oxgV7szPku7+lZi1ll8lZK7Ye2/XMl7MY
P1jP0LMdncoebe9ne8ut8/jb8N828yX2NLF8+RVq73Ee9c6g0voxvSl+Cxn8
6WilRjG7Rf5jc1521lUI/jTx485sjlqzMQsJtd+IT6Wv6RQaareI1bB7smvl
LWTfUHcKWqudQ3PNOR2T9LlolrpU55Z8p/Zmiz80/3g6KvmOMM56MzZhCwqT
54gcTMYT/Ie+zm+f3ntxAPvRj69W7AHe6Z+iz9vkO0z2Q2e0OPNsd5iTiJiJ
0ViORfhTfkov72OI++kZ0dG8d+l8dh1NEW+kv7Jf0OHqlNE89j/0qHgJncA+
Qpt860Y6gr2bNnt3Dfp/wjNzPaHNvrmGDlKrxdvubI6PdAjtj71qFsnNVGMZ
bVRzeHI2djb9oOY82oedS3ur0yvZO/kfpFvkt6fv2V/d0wv5d+hD9r/0pfy3
9Dn7f9pBfr77X+NefqdXxU/5z5biDxzENjThO2LTsPg=
           "]],
          RowBox[{"-", "2.24`"}]],
         Annotation[#, -2.24, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV01toz2EYwPHHEmLM2djBZk7FtAuNFnGhuNpmRpFymBySbU5LTskpcSGH
nE9zgS0mpxyyhCTKX2mGm82h5IKNq6Uhn//Fd9/f877vc/j93v9yl1aVVXaJ
iBR/1vSLODQ84uGoiNtoz4t4yan9Ix6MiThprxZ1+JoR0YZl6RGH7S3k3dkR
i/pG1Itv4iK+ZkY0I0ONhLjF8ynn8kZGjMN58XF8S4vYod7YIRFzrRfwiKER
w5DoE7HLHDnWeg6OyNR/JMZjtRkrsELfF/IuOfOYG/iZeo2Y4dwUTMR9ezdQ
YZ6uOfI5lfta+2iGs+q/52P6PbI3S//pqDdDd3Pu9Z63nGnkQrULsMr7VOn/
2tpb1OCv9Tz5773zC3Ga3H16bDLXL+c7cFefc9YaeY/9P85NkbNSbiEv4gp0
WF/A81Apbx12OL8Vm3DV2aIs+e5vsVnrxA3JOexd4zvql8gtRY3+c+Rv5HJ+
5732mmG9eLZ4A5dxNZcme3Exr+USrsUFvPReWWqP8J2yebO1Nc7sUauKd3El
7+ZmPc47326ec/yTv6MNP/Cud8RzNZr4uDrHcN03nmDefDTJL1GnFMXIUHey
M5etn1ZvkudJ6iTwCoXiS/aO8hGkWGtQ76keT5J3pM9mc9+zdiD5zfWYii2e
t+GEmlt5mrUPzm73vB5XcBl1yft13wn7r9Fqnk5ztfCf5O+I/3LCXeT69v/8
vnrluncexenY764qB/h+oyOWcLs++dxDXMQ/1S/nQeKZPFCdAdyZ/D/gbfK7
cZv4t/v+LP8ZN4nf8Bf53/mTuJW7y5/vfau923J+YP+M/5s6bMRB7EQn/gPR
RqWO
           "]],
          RowBox[{"-", "2.5200000000000005`"}]],
         Annotation[#, -2.5200000000000005`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{6954, 6331, 9240, 5801, 9239, 5802, 6275, 3745, 9238, 8123,
            8124, 7848, 9241, 3746, 9242, 5803, 8125, 4613, 7849, 9503, 3747, 
           9504, 6951, 6952, 6167, 9592, 3529, 6953, 3531, 8127, 8128, 8126, 
           4614, 6169, 10185, 6168, 6955, 5804, 9505, 6170, 7819, 7820, 7821, 
           6956, 3537, 7824, 7823, 7872, 7871, 3786, 5966, 10121, 5967, 5805, 
           9245, 9246, 7825, 7826, 3538, 6385, 3539, 7829, 7171, 7367, 7366, 
           4245, 8246, 8247, 8243, 8245, 8244, 3776, 6386, 8270, 4765, 8269, 
           4766, 5715, 10095, 5714, 4010, 6303, 6142, 8115, 8116, 4472, 7127, 
           4471, 8113, 8114, 8066, 8067, 4246, 7089, 4247, 8069, 8068, 9444, 
           9443, 6287, 9333, 9334, 7910, 7911, 4011, 6990, 9514, 9515, 9513, 
           6182, 9516, 4659, 6387, 4776, 6232, 4078, 7095, 4079, 6018, 7287, 
           6390, 4666, 7006, 4661, 7015, 4667, 6395, 7300, 4028, 9373, 4022, 
           7926, 7920, 6007, 9351, 7182, 6344, 10199, 4642, 7164, 6261, 6356, 
           6350, 4206, 7784, 6959, 6965, 6332, 5810, 6277, 7174, 3753, 6463, 
           6471, 4798, 9621, 4055, 5788, 4063, 9231, 8203, 4714, 8195, 4706, 
           9392, 9400, 7987, 7995, 8003, 7100, 7108, 6061, 9408, 6053, 9416, 
           4198, 9058, 9066, 7979, 7971, 7963, 5641, 5919, 9602, 3789, 6425, 
           6433, 5935, 9300, 5927, 7039, 4071, 7318, 7326, 9258, 9250, 7833, 
           7389, 10189, 4634, 7381, 7397, 10145, 10161, 10153, 4190, 7811, 
           6235, 10129, 6243, 7149, 7141, 8104, 8096, 8088, 10169, 4619, 9673,
            9198, 9651, 9659, 8080, 4460}],
          RowBox[{"-", "2.8000000000000003`"}]],
         Annotation[#, -2.8000000000000003`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{4459, 8079, 9658, 9650, 9197, 9672, 4618, 10168, 8087, 
           8095, 8103, 7140, 7148, 6242, 10128, 6234, 7810, 4189, 10152, 
           10160, 10144, 7396, 7380, 4633, 10188, 7388, 7832, 9249, 9257, 
           7325, 7317, 4070, 7038, 5926, 9299, 5934, 6432, 6424, 3788, 9601, 
           5918, 5640, 7962, 7970, 7978, 9065, 9057, 4197, 9415, 6052, 9407, 
           6060, 7107, 7099, 8002, 7994, 7986, 9399, 9391, 4705, 8194, 4713, 
           8202, 9230, 4062, 5787, 4054, 9620, 4797, 6470, 6462, 3752, 7173, 
           6276, 5809, 6971, 4626, 9031, 5674, 9029, 5673, 9030, 3777, 9598, 
           5889, 5888, 7135, 6207, 10126, 6208, 6206, 7134, 7125, 7126, 6250, 
           8111, 8112, 4467, 6996, 7743, 7744, 7599, 5672, 7342, 4205, 8161, 
           4632, 8159, 4631, 10187, 8160, 9247, 9248, 5808, 7335, 7958, 10196,
            4128, 7037, 5916, 9297, 5917, 9298, 4281, 9649, 6109, 7873, 8165, 
           8166, 8071, 8070, 4248, 8432, 8429, 8430, 3797, 8431, 9367, 9368, 
           9366, 9370, 9369, 6039, 9372, 6041, 9371, 6040, 4127, 9638, 5605, 
           6172, 5871, 10115, 5870, 6989, 4009, 9615, 5985, 6286, 6164, 4600, 
           7086, 4599, 6163, 6171, 4616, 4615, 5784, 4470, 5783, 5912, 5913, 
           5771, 9195, 5772, 7726, 4322, 9194, 5770, 9192, 5769, 9193, 3530, 
           3748, 7851, 7850, 8122, 8121, 4476, 7076, 5963, 9330, 5964, 6605, 
           6604, 3846, 9052, 5711, 9051, 5712, 9053, 4321, 5768, 7365, 7364, 
           5710, 5637, 10086, 5638, 4242, 6940, 5906, 10119, 5907, 4704, 5904,
            5903, 6085, 7362, 8059, 7597, 5602, 7593, 7596, 7595, 7725}],
          RowBox[{"-", "3.08`"}]],
         Annotation[#, -3.08, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{5908, 10120, 5909, 5603, 7594, 5604, 7598, 8060, 7363, 
           5905, 9292, 7866, 7867, 6420, 9188, 9189, 7719, 7721, 7720, 5639, 
           7339, 7340, 7341, 7601, 7600, 4188, 9440, 9441, 9439, 6086, 9442, 
           5910, 5911, 9600, 3784, 6421, 6422, 6204, 7807, 6203, 7808, 7036, 
           7948, 7947, 7946, 9360, 9359, 6301, 9339, 9340, 7915, 7916, 4019, 
           6995, 7742, 7421, 7422, 7256, 7602, 9055, 9056, 8064, 8065, 4243, 
           9205, 9206, 8063, 8062, 8061, 5713, 9054, 4658, 9585, 6230, 7917, 
           7918, 7919, 7087, 7088, 5992, 7752, 5991, 7753, 3787, 9346, 5995, 
           7756, 5996, 7757, 5869, 7755, 5994, 7754, 5993, 9344, 9341, 9343, 
           4053, 10182, 9342, 10183, 4125, 9345, 4126, 6038, 6304, 4020, 9464,
            6108, 9463, 9466, 9465, 6107, 9590, 9591, 9587, 9589, 9588, 6887, 
           6423, 3775, 7856, 7855, 5887, 6141, 10124, 6140, 4244, 4603, 9593, 
           3532, 3749, 5965, 9331, 9332, 9293, 5914, 6988, 6987, 9512, 9243, 
           9244, 7822, 3533, 8130, 4617, 8129, 8132, 8131, 3534, 8134, 8135, 
           8133, 8137, 8136, 3535, 8139, 8140, 8138, 8142, 8141, 3536, 9536, 
           6205, 7868, 7869, 7870, 7133, 3785, 6221, 9579, 6222, 7078, 7077, 
           7263, 7262}],
          RowBox[{"-", "3.3600000000000003`"}]],
         Annotation[#, -3.3600000000000003`, "Tooltip"]& ]}, {}, {}}}],
    AspectRatio->1,
    Frame->True,
    PlotRange->{{-3, 3}, {-3, 3}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyEnXVcFlu3x2mwu7s7sHseuzuOdUzs7j6CYmACAhKipAjYiYoO2I15LEBQ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     "], {{
       {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
        GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmGuMlVcVhvc5wzlnzuHMDJN05jA3CHMzcrHxD0YG4x9jGRJKYkzTmEKY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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlFFolnUUxs/mvr3f+21NB77f195txva6hTatbuqiiy6KwosILEqCjXK4
UbTUEIowuijUZiAalcOBLguKIkgQKqmFglqZWiDoTUpiqHMlas0CW7+nx4vD
9/6/8/8/5zznPOd0rVy9/IX6iBjCGrBv8oh7WiPeTCI2Ya/VIu7nfHBOxLNc
2JJFjLdFnGqMOM15oiNiN7Y18Z0fiojvsHr8/RXu41s2N2IV/iPYjZ6IFjBH
CLq5KeIEeGf4b4DvQfA24Lt4S0RnKWInGE9XIy4Q70XOa7E95Hc3+bwB1utY
H77D8yOGefsg9y+Dt6c7YjKNqBHj4bnOQbEHsb+bI9qJ8RVYi+CbgdXSG3GU
+LvI/2vO+/F/ClZdg7n8iA1UzOmTzojPsKVgzYLRWjMncbnBeT35TJHPYe4e
x67wPcD9oTK/5FQi1he5c/+SNx/Db5Y37YlzSloiHiDfSc6PYpvhchc57SW3
93i/gXMHnKpwmwazg/j/NJtLQrx9vP2JfIcq7mGZeE29jqWa/4L/HTDGwarj
fRtYrQvBrxjzc3wXqeFicrkD+4Dc3sd+BfssNjIv4kP4jPL2NnJqIVY/HP4A
bxq7Kn2Q0wR3v03NJeH8V8mcDoC1H6vWOcYo8bZl5vYuthvfcvDOpY7Znd+s
cck1H8SXFe61NLE1M4be9oB5gXMPb+7k7lXubMO3BXsJbmPcmQTrZ/S1otE9
/pPaHQNvJfwJHYd4+2RuLUvT0pI4iYs0pV4+gw2X3dOlPHo8c6/Vc2FNkOOp
BmP+S6zz/LexYs4znL8vPBvLEvsmq54l3VlH7LW5tXsf/t7cPVZvxanMdyPW
l7imijVGDicbHbMevLrCtTibuje/4U8T96ir8Explq5xPsL5XvQ1mljjI3B7
Dltd8psy/sfwX4LrVOreRGFs9UjaFSdxkYafqloT0sLvqbWlmdIsSWOa9aPU
a1O9Z15avd7s2kuz4lbBZkrmmCyIeKLVWp/CXs29k7SLtFPUqxW5Z0U9OyQ9
oOmXS94h5S40Pd+7Rf+Nk99G7o9wfyfnW4m/qupaXMHGwJ6FT1/JGt7RZk1J
S9p5e3PPkGZHO2h7t3umXmmmhqldU+Fa/V/DmmdIsyNO2/l+fp5jq2eqvXau
dq16oNykKWlJOWr219Q8i9oB09nNnZI6x/Wa38K11iJv53tBYS7S/BLevs2b
Hak138/5ldy7UDtTvre6PRu6M0O9rnUZSxpX79UD1V4aWEw/b1/oXakdoN35
Uad3oXboQ5l3uHb3rgbvwkcyf4vTf/HW7wQ=
           "],
           VertexColors->None]}]}, 
       {RGBColor[
        0.32371487383106967`, 0.11008595892680509`, 0.5720007325155253], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmH1s1eUVx59b6X3rLRXpvV2rLfZepPqHuswXnM6XTadG57I5tRj0jxFi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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3uQzWUYx99Vezm7y3HYs8c5ztm1ezhMJZVhXGJ1Q2aYqUyUELmUXJtM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           "],
           VertexColors->None], 
          PolygonBox[{{5962, 6525, 6524, 6531, 1653}, {7328, 7326, 511, 6854, 
           7327}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.35707562181269903`, 0.16809129009638446`, 0.6188932995537934], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlkts1FUUxi8wM52hL8bpzDBNZ6S0kLgQY0zEKGh9gOjCBFZ0UYkEEkMi
RBf4pkqMMWp8LXgYNQYLrbA1CCYqaEtETRSMUZSKbWiTLky7EzVBvx/fIS5u
7v3fOffc73znO+dO9+YdG7bPTyn9qrFAo707pV/qKZUyKU1nU5rSuFHj25gX
y3h7Z0qPaGxs8vdF7c9wNuv15LyUxptTOq/RVvDeVOw/V01pl87uy2mtsUU+
NsjH77rzrmJKpwXija6U1rV7/7BsOoTlX+0/nPX8jfw8VUnp87L8a6+0PKUB
nd8mu53NxgSebFtKa3tS6pX9F7I9p3VJ9n1F4wDD47J/otl+3tW9n4XP97R+
X+N8k3/HDp/rs+blCheNlKoaf+VTuk4x3SyfA/L5is6NdqS0VXiGFX+/zh7S
fGah17sVw4j89urcCmG7IOxzOrM4b79TwfPftZROhp8lWn9SNR8nhHG2Zr6v
0fg6b94uyVfKmJ99ivGPTt8zqjGm8ZVs2nR2bZe/39F8rG48PXnbgWdYcy1j
n6xHYv8Zcb5HeXlBd1YztsfnuOa9OWM5lXcci7TeUfA92E20KP8ardr/oMXf
4CSnE7E/u9D3cVep4DUYjsj3Q03m4YS+m7OO9cqcd8yT4RPfpRbnizxOKL7J
ujlaJJ8PtFgnrTnrEg6ntd7cZCxrpJH7NC7L9knx92qX7+6PnPwzz3nridy9
nbNGiP3CspRWV6yRQZ29dbnvW9NuX/g5GNiIN6Mcbaq6DtjbGRojDrDAz+3S
12qNovBs1F62yRiInbjhYUgYD3Q5D8QBX5yfyVnjaB7docXdwefWqCk0uzJ0
C9/kgNzfImw/1c03tugOezR4U8Pf1B810xZ1CRYwU9NohPqFR7RPDa7q1f1F
95ZudFc1f3CJVtDJfP3+g/gfXOA6uBi8Ux+zUSPEdiTwPC1eHwwOzxQcI31m
OO5ljR7IMZzvyVmbYwusFe6BT/Q7E1zBwVzwsK7H9YZOzi6Mnqf9PsXymrCW
M46B/KPV54XlWsW2P+d65wz2+CUXcNIf/ZS4yOePBe/Vwhd+qrq3Q2Ou4JrC
H7X2/VL5XeoznEcz4J+KvkS8cIa+0dJRYT8g+xHZn1YvuV5945R+e1Y4j9TM
B/iY4YQ1M/n6WOeOaYwWjJeZ/kTMm3LWBnoeajEO7hyIe8nzpx3ONe8AnK6I
vIyEDq/2RO6CJ9bsH6/7jYHrc1r/rHEyb3v0RC7eKjoHYDlcM+9wxJmz4Yc6
PBMaOKo4LpWNH1/UD/g5Qy+D273yeUfDeSAe4oLbyYgR/fwpDbaWrVn6fnPG
dTgs/x/WrDN8LKnbD2/XS1Gn97f7bUMDaPxy6I/zzdG3v5OfNRXrYSj6GRiO
a/+jcsQUmoK3u2U7u8y9YTA0jR963Xi8v+hifWiDd4l3hZquCf/rTa6Htqg/
uCBX5Iw+WVYslYb7bEMx3dawzVD086s1xP3gBMs9FX+vEp+PVa2nOd1Zq1oj
5Kg/6og64z7u2lV0j0AzYCeGbaGf8cBDH2QfDHBNbdN/+oRrf9HvBnyXg/Ns
9G6w8f5Pt7oW6U+l6FFguVoH09E7yTV809PhDp2cyv/PFZjQM337YOh/VJod
6zSn1Ecp3ivwtgVm7EuhJXoZPtHeSuF/s93YX1QcNzSsnXL4IJZDoX3yeKds
fqv7LH5qga2iGLdU3DfQ1GD8X8Lfy0X7fLTq/0boh5yDjVh4I9AW93zZ6fyR
O/wSE2vyfjDw0387gud7e/x2Up//AYydZ1k=
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3lsVFUUxi+0tJ22w7S0M8PUTm37phUDolgQRVlkFxNU4kbYq+IKCKgR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           "],
           VertexColors->None], 
          PolygonBox[{{8980, 5920, 5919, 8982, 2544}, {5309, 8465, 8464, 8463,
            1043}, {7569, 8983, 2544, 5732, 7568}, {5920, 6443, 1734, 6445, 
           5919}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.3904363697943283, 0.22609662126596375`, 0.6657858665920613], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHtwVdUVxk8u9+Z5A0mTcJuYOAlBXgoBfP7RVu20tBhQSkcM1qktWEWn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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3lw1dUVx2+Sl4QkvDyfeY/X9yQZkgfYzNgEBggOYIVWqQszuMwo7aCd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           "],
           VertexColors->None], PolygonBox[{{7309, 5317, 5316, 7307, 1995}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.42379711777595763`, 0.2841019524355432, 0.7126784336303295], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1l1ls1FUUxm+XmeluyzK10yrTKfgGHW2hJBbwAUQlvhij0ZgYNSYmGjdA
EUPQBHFDBVETd9QobhhFDYmIVhRLNZQ2cY9LfFBBoahRlCLi9/M7PNzcO/d/
77ln+c53znRees05V1emlOZWpFSludycUldHSkfZzKb0USalpzV6alP6RvMF
2v8hl9IVGrfqwkBdSu/W+fewvnfX+szXjSnd1pbSUol5qCWlHa0pbZK8iRoj
OjdLY57O7peMwzo/qv0PNDqlR+HElKpPSGlmTUqP69xYdUrztT9N36dmrUdv
jfcvk/z++pTOaEjpC+nxfCmlNt1fLpnbtH5bY0jvDE5K6aQ2v/FWe0qfaGyR
zocmp7S1ZH0atB7vTOkuyV2j93/ReoneGda522vsk+lar66xzou0bsxZZ/Zu
i/2heq9fRU7BPuXuar25Un5ZIp0Htf5I+2dX2cebwvb7u2S3/LVWvxske4bm
FRn78o7w55O1tn24wv75Luvfp+utvYrd/JztXBS6XVjp+BGXnzvtI/yDvDtD
5hbZW6F3X5S8N3RvV7V125FXLKeltFv7fRrPZB2zxyVjvs5/XOW30YkYbaj1
Gt3WFIUl2fiP3tonmdfmrC9v4OOHtF+uNWYWS4eSzk6bar91Z217s8a90u0e
jaXy6Vs6c0g6n1Xl793hH+JzXc5+Rvfdof8WxfSZkr/xJpjl3SHJmaG3hrX3
pXz2qca4zlRJzhPS51md68MO5FUat9jP+nrFcOMU6zyasW/Az5jivloybqr0
e/NDH2I7GvEFvzeGH4YjnxZo/6Def1N6ljPGa1/IXJbzeez9rMP2s96cMUbA
P7YOh71gZ3Grv/14vGLQ6PguEq4eKzk+qcEzsdtQZ2xsrHAciAd4eUP2PTLF
v7n3RNxd0G77sR19/5psnefqzXkaV2atC/MLkjlJGPhacnp193Wtn2oS/irM
F/AG8a2VXa80+fzCBvsRH95dcPzw5eW6+7BGv+S8IFvezztvGluNGzDTr+8l
jdk6U697F7U65vwmlry7XTK3FhynDyVnUON86XGyxil1jsVLXeYs4vazdF/f
ZP+g14F64+e0WvMX2F5V45ncXyjZDxcc+7LkHa23n8kJ1uQIMzH43/8RD76j
+3mh/2u6X8oaf2dqb+A4r3k/02AdwAi5CCazDd4nFr+GnrdUmxs2B4dmpNeA
/DYl5zzG7nF9e082Xn6c444MZJGjyEAWMruyoU/G+mIDOjdHnp6r7Z3yW32r
OXK3Yjqp1TVkusbMrOsIvLgqeBK+Jt7EmriyDzfCAZdMdkxb4u6KsJU4Yi+x
4C42gl9wTF0oKG6DJzh/+X5GnEGHppzlLJMPxtr8G74HK+AEPlg+2fhF3lMa
32asQ3dwEX6HQ7CX75wDG3D+znrbQN2iPsGxa+WTdRoz6pzr5cAYfhiK8zdL
n7O6zJk75bcHFYv1lY5Jtui4wGnIxyc9gVfwU441MvFDb+RyX9RWME+sx8N/
4AFdwARvIxOfMw+F/B3SpaHVd/B9S8TuPu0/m/dd4s/b4BkfL4z6+470f69g
/4CfscDhI/LroyVz64jOjGoczPlOZY3jBWfsypkH0HVe5Cx5Ccdi40jwJmv0
gkPw1e+qUV9J5pGcOaa76Lsfam9Q4zftb8+bO471NMxwMvkwIWs5fxTdH9Ab
wBHEG1vgRt6F9+CPbcEh5AS5ASapT/QL4JlcLcU+dfzfqOXUF+yFt5fEmvML
pON22TCn3nz5d3Amd7AJHajPhzudm+ByWvRC1BTqCbGoDNwhfyTyFr2X5u0j
ZMEFxJAzzysu75TsX3o5/IQf4OOfio7FniZjFHyCQ/oDMEOe4CfqDj0YsSSO
1Jzv21134IAXu8wDm7R3U7vvF3PeIw5j7eZNOBOdJ4bftskni/PuN/tif1bk
44S4Sw+1od06dAdWyXHqC/lKrmLTQPSoxLon4r2y6LoC99CXXV+0XfvEDTfk
HTd49+J2x/MqzbPbzc3U5H1Rx8kTOA9Oew6uLro+gM2BwCc15NQ25+aqNvej
9GhgcyjwCW+1tdiH/+idvPa35pwTWyMv8POcyCnytz9q0J8d7iHg6rvky0nN
7rde1vqlgvsIuP1A8Dk8fWLBetOj7SpaDu8MR98Cr5SDZ/ZL5xvz7nfB8pHA
czl4DezhU+L6dGASfNKrHMMoZ8jp0yKv6fEz0efjq5bgWHw7Ne6CL3CG7eUO
+wUdHxCmNubNheg0O2eOx+bvIh94fzx6J3pYsA7OJwRO1geXN0f9wn70I47w
IVhfEnk0Gv3Y7ljDP9j9TeQd7zeFDo0x//+/IGcOhEe4NxJ3M1Fj2e+K/0Rg
Ht4DT4eDP8AanENeVwVPTg/sI78ncgmb6Pmqg1vYOxg5tkd++qLDnFEdcjgD
b/cHluAEahY5fpn8tK7DONib933ugv1zAv9wU0/0it0x4w+4Br3RmRo0O3ro
yuBGuIle+/Pot3ujXvLuhqi3+PSronMJrNCHDkcvihx4Bs6cGb0F+Q6vrA9u
4Y3esJE3wAFyyb/7o5f7D2LOE7g=
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3twlOUVxt9cl2BumM22uwTJZrO22qkEIUjHgJKBzggyKjpaHcGpLW1n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           "],
           VertexColors->None], 
          PolygonBox[{{6539, 6374, 117, 6537, 6538}, {6437, 5471, 5470, 6532, 
           1732}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.45715786575758693`, 0.3421072836051225, 0.7595710006685975], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlmuI1GUUxt+9zO7M7K6u4Kw706jNbnvTpG9BRFZuCl3QUDBCJdhSKG+V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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHlwldUZxg8kuQkh253cm3DDzXovVnEcElsiKIGaCKioVeJAEUc6tFLb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           "],
           VertexColors->None], 
          PolygonBox[{{6431, 6077, 6076, 6434, 1730}, {6460, 6473, 1503, 3730,
            6459}},
           VertexColors->None]}]}, 
       {RGBColor[0.4905186137392163, 0.400112614774702, 0.8064635677068656], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl1lslFUUx29n2hk7MwUHmHY63akWKjwpqVHcoCAhriEB1ycj+iYoFKMJ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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJw1mHlwleUVxt8kJNcsN7k35GYj19xsiKWLSWmilEVN1LKKCKKEVtqyFDtC
WRQtBcFC3QiChgEJdUZki6XAyBJaEgo4oxUQ7CC0QKKhlAQMRew0KK3Y/h7P
6x/P3HO/713Oe855n3POV/STGaOnxzvnvhXnXA9+Kwqc+7KXc9dBOfLpdOeW
ZDm3GJxCfqbIuXrwMvgNGJvj3L1gJBgDKkLOlTGvFJQjn2OdK+AT8HeQHbI1
NDeCXJTrXBYYhxL/RIFXIs49X+JcnxTnLvJ/ctC5bzD2ZjAJuYrfKCgAleA+
UAOqwShQwdxBYCAoL7G5VX6s1ngS/Bw8Ap7wZ/kR+KE/0zp03Aa2gtfAsqCd
QbrXBe3dPPBLP+YOdB8JhqBr33g765B8536Qb2fewXmu5nHWAHbtYXs96ffW
nicZ8y74MzjRy2wnH5R7Gx5gzAawHuwHq7HxS2AFWAX6sfcp0JJkOsSh4zd5
/gD/R+PPm9CjD7iT/4X4+BDyUVCPPu8kcGbm1oNG3lcy/q1C56ZmODcFHERu
Y89j4ChoBTvLnHufWDgGdiBv4mybQUoiNmJ+PPN+wfrjWT8Oexzk/48510Rw
AHk1c6Yx92dgFfJ2fs9go9NgG/KRkPlAtj+MPJ3f/uA28ChYCZ4Fz4B60BzG
vuzXDfaGba/pfqz2zMWGqSAF5ID72eev7HsSjEaen43/iJPtycQkZ9hRZDaX
rd8EF2OsD7rBBTCGNe8Bd4P7pRd7tkWJX+x3EHv+lvWeZr0o8VsI9gRtTa3V
hJyJrZ5i3wUgjLyC+dWlzl1mbCb+6SjGf6zXF5xH3sWer3Pv1oGdyBOwyYfY
qQ3UIudi0xDzM0AO8h75g/03gSbkd0B8uvn+M3T8G+eeEDFda1JxGHOaWWsS
sZMJdqNPCmslg13II9mjlvfjwQjkS6ybwHox1qtD5yP5FlNfxRI+35dtMarY
bEE+wZkTQSfvVrDfr9h/MGsNAvOQt+CTubl2d9oZUxsxHaWb9nibdY7wfi+6
bwWXiMmV7F8PupCbWCeAbZPAbuQa5h7rSbyC6jLz/XbGbku3GCjgdwLr1YJe
yFf5rcNGS0E38n5+/wTS2bss0bhvI+tsKDMOjHrOGeU5SLE3ETzsY3AJNhuM
7S5hm+Gc6WnW+pR5V8Ai5BGKcfY9DIYjH+hpOkvX/chtYB/vWkAr8j/Q+RxY
jH0DN3Bmno1m7H3gY+QAa0xEfhgkIUfAdORHQZaXS/gtzrJnst1A9BiQZzYs
zzKfyBe3+LO+zO9LWXZm3XXlAHG/7rxi4XmeP1dmMdGPdfqD28B3wdwsu+O6
249n2buxPjdozK3EzxPE3FxQhXw1ZHM0tht5A2eqZO73wHrkTuLhLGgHHRGb
2+/rvZDTiLEl+G0xSEW+EDKbyBadIVtrB+u82dPWlC/EAbr78olyl3wk3yiH
3QPauXcfgbuRp+DP+WG7G+LIqdzBBrAGTIkZ1zeANZ7zr7HPWuK9AXyOvD/L
YkKxoDt2IddyinJJJ/K6ErszuiuvIfdlz++wTlXAOHwoenXx7mMwBPksY95D
9yOyCbJjnRnMqUsyju/B3IR84+K3iN8Z0o39GwPGyfGMP5xvd7Wa8VelB+t0
gG7kvwRtjN6J02p4Pou9Z4Jq5OPw0gnQQizuISZf5/mzPO+dYjl7OHJS0GI1
nv+L+f/rEssF4sRobxQD1ezfJ417x7sXwFh0TYGDHyywnK9cPw759pDFvGJ9
cMi4bQ97NmUbx1XcSCxyvjTmpoJHci0mFAvTkF/k99uctzJgOVh7x/U2LpIO
n2PTz/Is941NMm6fw96zg8bxusuLwsbNutNa6+YcG6s118JB74NjoKHQfLOc
uHwxw3wk301i/Z/mmQ9rmdug+oS1FiSZ7/RMsnzY3MtqAtUCe8Em9rsLzGev
2QHjfuVg5V7lgFJi8EEwDpTELLcNZ99hEctxldinhfXvcmYj5ZqVnKcu3nLO
/+CwTMY+zrs5yabrOPCA13k6c7dyF5p4txT9lvL/Crb5BLyQY7n8DeTGoOX0
fcxJ4+ypoAX5pGIBDED3h5Istq9GLBcpxpXLF/F+YdByumqdNl9rqOY5jc97
sE4COBWyWqGDc50vs5pBuUF7aG3lCHG57pjuljj9eK7lEOUO1UjXGftv4ipK
fPbEp3fgk8usNTXVYvCLNDuzzrol0WzRzL57Q2aTYTGraVTLDEUOocN19JyJ
fWaDDP5/AQYwd1aycb04WVwszhd3KgeI+8Whf8S2v0Ofj7DF24wPR8wn8sVj
yZZbOkGHzzGytThbXC2bi/vFOeIa5YANxXYG6b6F+Wc1h/UbQXu++fpe3dEU
8/ljnGtjvsXWcmxyqdg4UNzXhXzd31HdTcXQf5n/Lna4lmRnVC7VnZvmc6q4
Vj6Tr8S5l1k7JdtyuzhIvlQNFPY+VS5TzlOuU05Tba4crdysGr0cGw8CA8Et
4L1801m6qoZt5M7tBrvA5kLjbtVQ5z2HyzfyiXwhH6UXWc2gWiFYZHeroLdx
ke6Yco04T1ynnPMha/4HXFMtDLZwn/4A8pKtZ3kVeTm4M86efT9sNZJqo2tx
1kvl+tpTPZVqP9UcqjVUAypXqAZQ7lfOmFxgHCjum1RgsTeL35kFFoPPlViN
/1Vtn2LvngIL/Ji1vF9TYtwvjhE3r8u2seJojR0Ghvo54rpGbztx3iC4/V/Y
7VMwMGq5bRmo8znuUJ7VuKptFQPjI1aDqvZ8KGLcrJymXCaOVu0+5utauZf1
ZqoBqnyPplpHOV+5XjWPYl0x2+5jXrmnwvdyykHzfA9Q73sw1TLKkUN8TbNZ
9xMcAJtiVstmols4w2pa1crqGdQrqGYWVysmFAvibPlaNWaX93l2zGJAvo/E
jFvFgeI+cewo9BpRYr2D7pRqzYu+V1DNKVtP9r6UzVWrqudRr6OaVXdTnCmu
1B1tjdkZpPsZkIieXxYZt6gGVC/S7HODepI09nDFxhWKwTJi5BjPj4LSkNlC
PcRObxPZQj6Tr2QTjW31e2mOuGg1OBEwTprDs0VgIZgNaqIWI4qN6qhx9xz/
Thyu2mgZqPM1kuZO9bXSQn+XS32u0p1WL6AeQ72FegL1CqohVDuoZ9BaOpPO
ojXVi6oHUu9z1Pf++qagbwn6BqBcKI4e6nOiegHVEKod1BOot72B54GY9bjq
rco9t6jHquBMt4IqUA4+iBpHi5tV86hW6vS1qGqmk7zvF7Za6FCC5aYPeHc8
YjmqlfdnosYFyjl1YatZVKsEky333J5tuUg5aD17bSw27lZPfU52DtvaWYmm
u2Iy4s+g2kM9+0Ffg4gL1/paRJyobwvqqdVL6xtDHXsty7ZvEepxVOurBlft
rZpfvWeFP7t60AruYCDXvs0oh79CbKwqsG8zihH1Fqq5VWurx3ij2HSWruqp
ZUv1pOpFZdN6bN7/Rju7ahDVEqppVcuqptjG/N8XW++lmkPco29K+pYkDtK3
D9WsqlX1DUS1Ro2PRdUc4i7lsC7PYf8Hcv7JcQ==
           "],
           VertexColors->None], 
          PolygonBox[{{6073, 4534, 4533, 4454, 1705}, {6277, 7340, 2016, 5642,
            6276}},
           VertexColors->None]}]}, 
       {RGBColor[0.5238793617208456, 0.4581179459442813, 0.8533561347451336], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHts1WcZx3+c056ec3qAFTk9tOlppdcZiBiGCQNkIDjAyy6yW8ISO2NC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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHtQ1WUax1/1AOeggOg5hwNyuB0PVjpToW1MWyqGW6JhabbYZVebNNNd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           "],
           VertexColors->None], PolygonBox[{{6093, 6106, 1341, 3596, 6092}},
           VertexColors->None]}]}, 
       {RGBColor[0.557240109702475, 0.5161232771138607, 0.9002487017834017], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmEtsnNUVx++M3/N9NjPfeOIkfiQZC/VB1QYhCkLghGCDCkmMEKs2YKlU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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHlQ1VUUx2+ExAPeE97GA4XH0sOmZVqwfTF1qFTK0jYttcxQE5epZLRt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           "],
           VertexColors->None], PolygonBox[{{6335, 6667, 1829, 5849, 6334}},
           VertexColors->None]}]}, 
       {RGBColor[0.5835103547292549, 0.5592009638995847, 0.9099476009869547], 
        EdgeForm[None], GraphicsGroupBox[PolygonBox[CompressedData["
1:eJw1mHuQlnUVxx+hRNBd3t19F/bWvruwC6jQ4AiJFspFceQuWMqiYJogCCbJ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          "],
          VertexColors->None]]}, 
       {RGBColor[0.608038223902243, 0.5986104247083867, 0.9105067608572293], 
        EdgeForm[None], GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwtmHuQ1WUZx38oJYK757BnWc7unvaCu1xUaGSERArlojgBy0U0FUQ0i5vg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          "],
          VertexColors->None]]}, 
       {RGBColor[0.6325660930752313, 0.6380198855171886, 0.9110659207275038], 
        EdgeForm[None], GraphicsGroupBox[PolygonBox[CompressedData["
1:eJw1mHuwlWUVxj9MS4XNPux95Fz2kbM3nUOACo2OEGiiAooTclMsFeRSFpcj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          "],
          VertexColors->None]]}, 
       {RGBColor[0.6570939622482195, 0.6774293463259905, 0.9116250805977784], 
        EdgeForm[None], 
        GraphicsGroupBox[{
          PolygonBox[{{6091, 6360, 113}, {3340, 3547, 113}, {3547, 6353, 
           113}, {6353, 6091, 113}},
           VertexColors->None], PolygonBox[CompressedData["
1:eJw1mHuQlmUZxl9RK5Bll28X+GA/9uS3S4AKjYwQSIEcDCfYBTzkYRHQLJCT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           "],
           VertexColors->None]}]}, 
       {RGBColor[0.6816218314212076, 0.7168388071347924, 0.9121842404680529], 
        EdgeForm[None], 
        GraphicsGroupBox[{PolygonBox[{{3422, 6145, 113}, {6190, 3422, 113}},
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHuQ1mUVx3+oaal7Yd934d19l72xCwSI0OgIoZTKTRyBBRRLLgKaKbBA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           "],
           VertexColors->None]}]}, 
       {RGBColor[0.7061497005941958, 0.7562482679435943, 0.9127434003383275], 
        EdgeForm[None], GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwtmHuw1VUVx38QJiX3cJ9w4MA5FzhXMV5CIyMkWioPxQm4gGIhFwHtAYLQ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          "],
          VertexColors->None]]}, 
       {RGBColor[0.7306775697671839, 0.7956577287523964, 0.913302560208602], 
        EdgeForm[None], GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwtmHuQlXUZx1/wkpZ79uw5y7KysLvHzpIQN6XREQIpFQFxhAVRLHG5aRY3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          "],
          VertexColors->None]]}, 
       {RGBColor[0.7552054389401721, 0.8350671895611983, 0.9138617200788766], 
        EdgeForm[None], GraphicsGroupBox[PolygonBox[CompressedData["
1:eJwtmHuQlnUVxx+INK3dfdl3gXd51333pV1MCBChkRECNZWbOHERFApZRCyL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          "],
          VertexColors->None]]}, 
       {RGBColor[0.7779900334375245, 0.8521198283954757, 0.9071501667837201], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmFts1VUWxnfpsaclR5LaU5GbFElflNYBHRW864OA9kBbGVBOq1HRREYd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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHuQl2UVxx/dHyyXYO+wyy77+y0ul4QgEBsJBMFSkJsCK8iawgJqF1lA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           "],
           VertexColors->None], PolygonBox[{{8155, 3954, 3953, 8141, 2354}},
           VertexColors->None]}]}, 
       {RGBColor[0.8000177246875297, 0.8594654764787338, 0.8972817808434506], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHuMVdUVxve87r3zQDJl5o5M5yrD1KaNWIODKE0A0xTBaAIMoDz8o0Bb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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJw1l3twlNUZxk8wyW6CSUxCkt2FzbIhhFhCbbk5MFOElhEoIPdbYaaSAMJM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           "],
           VertexColors->None], PolygonBox[{{5322, 8581, 8580, 8553, 1134}},
           VertexColors->None]}]}, 
       {RGBColor[0.8220454159375349, 0.8668111245619918, 0.887413394903181], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl1mMlFUQhS+zdE8PDc6ozPQ008hMoz64svioImjABTWo6ECixgfDgxlQ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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHtw1NUVx28IbBIl2ewubHY32V2y2SCWxAqCUBhrUGmCCFheCVRHiJLY
DiqIyIy8glrsTCkJ02m1PLS0tSKvjmIhTH1Mh1Aqr1IEC04VW8tLqRDkKQL9
fHvuH9/Zs7/93XvPPc/v2fLGJ8Y+3sU5l81xriufr2edmxV27kmwBvnWns6V
Rp27u5tzCwqc+zzpXDDlXGe+cwfBUN77Ge8tAUOQG/h9LPg+qAedlc6NYv1s
9p9xo3MjStivnGfsNZ0DY4XO7Qo5txOUIN+bce446/7O3i28cx/yFZ59DUYi
1wSda0KnaeBO5CEgxtkl4DvIlyrQqYjn4CLyBwn2AvtznVuex7kx5/rz3hTk
twLOtbPPVhDgfj8BXbjbNzoT5CDnoO8F7nAeOOQD3KWdfbdob+S/sfedYBn7
v8iec3jnFZ5nb3Du5+w/lL2noPtDYAjyumLnHow49wBYizyAO6/DbmvBbcj9
WXuSs06AfsjjWTefs+aBcRmzrWwy0tt4B+uauWsT+EvYdL3Cuq+jprNs8RY6
bSoxm7zAmsnsMwksRu7Ne9d6OHcVVEZNl+3YsiNrOjVw7kieP4RtUvgjwF3z
wHXuVsWdE+x5mL0PgThyedq5CWA86AX2svZd9ngH7EFu4twN2H89mIb8V2y8
Gt/3Yu80GI48gucLkfeyfzfWNcgmfD8BRvF+M2gC94HnseOznLsIPId8nrXd
2eNGcA45gL8fxq534Js3AhZrE7jb+KzFnPaaDCb5Pfuwzxziczxn1XDnGdyh
jWet4AnkBLrsihMjAcuJavZ/Db9+wvc3QYY9H+f7NmJ7PfoPRKfZrH0KDEC+
jk1Pc/aX4BryCXxwLGl3VcznBi1HlBu5JOYy1vTDj7eCNuR2YubmUvQEW5D7
9nbuduSB4FvIc9lrEWgBz4AL4H50Osren4EYvouDGej6Xo7FVjNo8jH2Mbaa
CfLzLSdKOfMqun4DEhGLpYG6S5HF1IK02Ui2mQ+Oc9ZIfrsXHEO+jE2PgE/A
JRDhnQDoBsJpy8XnsOHmgOXkl+hby7rDnH8IrMeHVeh1GX+UoU8juj8KmsFU
yTHzmXz1R/ao4ftq9HwXeROYh45TwbPIvwCO37/i+1lwHZzDrpfx6XTWL6Q+
9cN3dcq5AotB1Y6DYEWe1ZAV2KEev00Ey5GrolZzVGv6Irdyx3VgLVgKzvD8
FvkfWy+nJnQW2R2k+5kiy91W9loathxegk1+BV4CPwUfx22N3v0ncoD99uKf
9c5yQrpM4reGItPp23zmYsP++VZzlXv/YN2HcctBxf5h7HsoZDnwKs9/Hzfb
XndWewZzj0FRq0Ev8jmLdU+CXyJfLDKdpMsF5R0xGOLcYtBSbGtV81TrtMcF
/HuQ3w6A88jfLeNMas3vwB3Ib6Drm6AVfZeCETyrBa3E/w5svhNfRPg9DN7P
WO4U4t/uEcuhY5yxE5++D45G7bdV6LGy2N5RLEyOWa1XTNzP97uw3zAwJmK2
38I+m7Pmgyx3nsPzp0EFcpI9q/HVwDyreat4p5W9l+oM5Bi/Px2z2LsCZnHv
2di2f67VgFMpywHF/hegI2N30l22Zaw3DGNNTU/rEeoNJZwbrbQe8YeY3VF3
2xgz332EHQ8HzYd7ea+atVVgD3IBz85gq4/yrSddUn0pslxXDYgnzYfyXSxp
vfMVfPFyD+uhjeTERZ7/h3fbiIc+6NCVu+aCmyLW60dw77qw9XzVJtVg1V7V
qL7EyXR0ndPNcjZJnKTAuIDFrGJlJutmZC1mtoYtRhQb7cibOHtP3HqLYkK5
0Aim+pw4hn4F7J8vmyC/w7pB2O128DZyddhiUrFYhfwvzvmMz3+DT7NWi1WD
VXtVk1Ur1RMX+5qpsxb4WqYzm9nnFM8/RJetXa027iMeXsqzGqlYWKTYD1tM
bCd2t4Ht3P8077yMnj/GJuXkfgVYmDUdpdsC5LMV1oPVezuRh2et56rXnuX9
F5AXV1gv0B4Pcv4t6FUNHii0u4lDiDvojvLVXfhiWMR8thO/vodtdhVYT9vF
97oyy60d+CTd02JIsZNCnlphOa9cn1JhuaGYV6wrR8RtlLPKVXEcccXenF1Z
aJxR3EycTFxMHE25JM4jrqOcCtKnxvDuaFCEXMc96nl3IqhNWy/WHXU39eRH
eN4rZr1VPXF0yGqqaulXxPTd+OKehNX2i12Ne2jPWs9ByjhjMH1xECgttdrQ
iZ5nwlYjHquwO+uu00G42Hquem2o2NZKZ+mqPR7OWo9Tb2tEnoA9JkbtbNX4
euQ89vm8wHrKB1njaOJm+5Gj6Po29/kT6IkcwUY5GeOKqnmPcuY+7l3O+nCu
2WaJ7wWykWpnin2SWauh4iar2evXMeMoR8SnwVj2q8XHT7HXItACZqWsdpwX
NwpZDVHtUA4pd1RDVHtUI1UbVYPUa8WJxYXVc6eFrQeq9z2CvJvnOzhvlTMO
Jy7SBeR4TiLuLk52znN49ZJl2Kgtaj1lVco4pLjjypRxSeX4Uc8pVStyOadL
2GrGpKhxQnFB2fi3Qbuj7vaboPXCNO+mwtYTj3jOIa4hDiLbaYbQ7CAbngja
nXSX40HzjTiWuJV8pNo/ET2eCVgPEPcS5xLXEgd7HTt+j33OEY9z8f9g5Jkh
k0/ybA1rN4IN4LUS801HmdUG+ajT1yjVJsVkOe/cFDLuqJqps1uiNptIB+Wa
Zi7NWso5cTHVENWOAf7uqjGqLbJBva8pqiXykXqpekDM91TNOurJ6sWaecaE
jDOKK6oHqJfpTrqLetqnnLkbbEafHwSstyvGFdvq8T+KWA9V7/whcl3IOJ24
nHpSTYnFqGJTHFSxOcpzecXospj1VPVScULFqnJOuaaY1eypGVGzoWZQcZsG
P2uK45xOWg9T7xKH3OhnNs1q8oF6k+4g3dWjxA33J2w2FEcUF37M1wJxYnEL
5axyVRxDtb+j0GY99QD1InFKcUn1pBsqjfOL6xcgt/saptpVis45rHcJ41rq
EZpdZDPZSjOMuKliWrEsjqreoplcs7h6jGZPzVSapTSDapbTjDjOz3TqhcPB
Pb4nXsMmV8Gfc8xnyj3NtJpl2/zsN9fPCpoBxUU0o2k2EycJ8bw4abVWnPJm
npeCBOiTsdojjrLR1yDNnmt8rGsGPcnaL5L2X8E+4mdo2mZEzYZD0sYllIPK
PXEKcWfVhJWeQ2u2isRsdtOMdSlqnF1cXXcqzJhO0qV7xnrLKc+11GPUC+UT
+UI9cXTU/pPQfxGaaTXbiOOI22jG0WyiHqDarxlFs6o4vri9ZtYDCeME4gKa
CTQri8OIu2hm1uyg/0z0X4lmCM1C6rHqrZqJ/t+Le1jvVU/WrNrhuaBmVtU6
/Sei/0JU8/6bNBvKduIg4q6ayTSLicOq9mwIWa9QDXo1ZDO1Zmn1kN1x4yDi
HppZE8y2K0IWi/oPRr6cD+Z5n4pbDPW+EcfQ7HxbzGYpzdCKrUJva8WYar16
bKmv+f8Dk+Kijg==
           "],
           VertexColors->None], 
          PolygonBox[{{4507, 7823, 7822, 7877, 2331}, {5279, 5921, 1619, 5926,
            5278}},
           VertexColors->None]}]}, 
       {RGBColor[0.8440731071875401, 0.8741567726452499, 0.8775450089629115], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlk+I1VUUx+84M+/fjPOn8D3f0/ebZqasnGlU3OgIUjiaOeMsJDNnoxOB
4EBBSYsISiiDwZKebqSyTYtRF2lQCxXaBaWgjROZgdLG0lFJEiIh6vvpexaX
3/3de+6553zP95xze196ddsrC1JK/2g0a5wvp/RVf0pbSyn9ooXdrSktlMBz
fSlt7E5ptqA9ydx7zHtX8ilN6fuyZNZpb1ijRfOsJaX1Wl+u+e62lBr6n9H8
fDWlms4PSHddax9qLNB6Uz2lyrKUVur8WMn3r5JMl77Pa9yTrm59OzU+0PxO
LqUj+lY1Mtn1pvROa22n5p9o3NfZQi2lL7V+F1mdO6wxIvlZ2bO1PaV35O+A
9mpa+1vznZJvLNb9rbZhVONx2TdX8Bnkb8vOPV0plaT/dZ3drP1Hwo8sfAGP
q83G5GKcfUrffvn9WtX6pyopvVuzzcd1zxrZcy8ZP+ZgWAv/sA1dzPc22Z87
YTc4TQRWKxfJnj5jfalgH7l/vGR/8IWBX8R0ec5zzh5QzN/X6NP/kl7Fu2L/
qpov1hgryveIAfiPSM9+7U/r7PIspVsdwkm2vScdx+Tn55Jp5KyPOXZ8pPnp
JmPR0HxHk3UR2zOyZ3XBnIJ317R/PTi4qeB5V4ttvhbrJ/Rd22788Gs+9CCH
DLh9kTMPic2I8N6g8Uze3JnMGc+hsA27NkhuS/iV11ohOMMafGV9WNisq/j8
aGALhiOxDw7sFUvWj45S6Hlb2Gzr9/8N6fi5YhtHtf5iv/mNfD7Ogg0cwS/2
ugL/WfkxqbOHku8phHx72N3WbFvqwUmwASPiTu7tajPfuHPjo9Y9FjJnImeR
QbYR2MD5N6rmMbJLyuYcfBuUjT+1mpNT+n+yaCwntD6Qtx/fS36wZjnsfDpv
XhMP5viyWT4dfthYIvtd2fJ/aj0pN09J380Ocw6cLy+1XmQ+Vt7Xep2PvylP
t/Q5Z8mJVWEn+Ueej4UN4HQo6gDcWhX4sQeeD3KOD/wB77cC87PNxgYMyf1T
IXNT996pu2bgU3voP5r3XWBIbpIP1MOlsv3bsrkBT2tF21+NmgqH4V656FiC
JXwAT+pZI2Jdlt8VjVHJfa2YXig778mdXwvOF3hAPcbmXXnHiRg9UfQdzCfb
HPuBqL3cA9+wiVrH+XM55zb/f+iu8W7XO/IQzuBXXhgU6u4J7JGT+IIM+6cj
9+ejv1wuuGazDh93RC5kcSe23w5bkF+tOKysmF+z4sCcxl/yaaYzpX1Vc3hX
+DITfJ6MPkR9ulB1XYJrG+vmG5iA31TUNv7BhDp4LvxdH1hgEz2HOk48Tmv+
Wd11eWHmPoQ/tehV1ajlR6KGH5PsgZr/qfdro+ZzB9jCL/jbmZnD/GMvcYFr
D4Jv8P5u9AJq5+3AZ3/EkxpQKZqj8Gexeuy/wmpF9Bn6DXygvg+F7/QNehYc
hYPEj9iNFxzPlugdcIq7qIH8M6eWUiuo7fMRL2IBxpsCZ+r2yZL13I86Ttyp
wRfjfHv0z//rc4d5djX6AndhDz4MxV3EdTZy6gfhernmnOM9sSJk0DsXdWxd
j872mPvogH/YcChzHSHGqW68OA+3BqM+bNJ+R+YzvFlaFvmeF8Sr7WX3/wnt
78mct9h1KWzrk86HlhlLas5gxO5Zre+uOG7DgTP1bSbeENg2HTnMOviBG/iB
x0BgMhhz7CTvV0fuT3Sbl8jf0F2/120T/LpVN8eI+VzgP193LZuLdwSyyOyX
/L7MnOIucIGDzZJd0eH7sH9B1BneJshgD2+K5k7nEzXraNR8evu16O9gs7fb
+MCHofAdfcOBCXhX4634zVL3Y/ot+XSw7Jyi9l6J/sJ7ba7muJNf5BL5ez3q
I/h0yf7uuv+5P8tsA7lI3p2NvkCdbou+Qe0tha6z0QuOilMHe5xL5PSJ4Plm
rW3vcV8cidqNDmTWxBsG2eORC5/q/pOZ+wGyR+K91Ih3LPMfa+Y6OPJGnoi+
QN1DD/bwTh8vuzb8B2W2Zcw=
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3uQ1mUVxx/YXdhd28v77vLufRd2Vy4iyCVuLWMCijcgJRFZx+JSgjGh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           "],
           VertexColors->None], 
          PolygonBox[{{5012, 8035, 8034, 8089, 2350}, {3528, 5939, 1626, 3550,
            3527}},
           VertexColors->None]}]}, 
       {RGBColor[0.8661007984375453, 0.8815024207285079, 0.867676623022642], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl09s1FUQxx+w3d1ma7Es3bbQLSnbFiiaADEUKG0BBYGLQuQiQowmgtFI
1ItoAppA+BMjpqBeiBowXjSKRiVUqxdjJEhMQAETDx4UBUKxIIaAUL8fvkM4
vPzevj8z35n5zszb1sc2rHxmdEqpdVRKY/QdlU3pVFVK72u0t6f0VDGl3kxK
w4WULmp8oMPjdebpXEqDo73G3hadWZtPaY7G1Fi/pHFMcpbp/ELt75CC3pqU
BjR6NO7Q2iF9s/rO1pkZGq/p/K4ay9wkOUvqUrrRnNKPursl1sFwKfBsCRkD
IQe5U4RhgeyZmvd8leZLG1I6W5vSc9JxV0dKnRNTOiAbenRnjb7bJX+bdP8y
xvJz5ZRaWlIa0f1mfdcLRyZjme8VLLe+NaUGjeXVKd2v80s01uTth2vhC85O
DZ+wNjfW1wvHYsk7J31to+2b48K5vxB3tLa1xjb36/cG6T8v/DW6c0z+qG9w
rOqEfWb4jbjcnCuOXwnLlxp78/bn6zX2Ffuz4jz+n6/9qoxt+FN6lul7ueDz
/+i7QHsfZYxxj7jQ2Grc7CGXGM0Ju8Cfn5DS4VJKk4XrTM48wafDcR4MpwvW
NUV35yoWZcXiY507qbVW7W9O1n854ntGdufLxgqPjmh06O5D0vWKxuKcz/4b
5+vDRvwBH+DHOTggGXUdjg9xP6xRGW1/74+YJp1p6rCsPzT/T76enrd8bIaH
8Bm8YNmY9zp+4FynxmbNM2M12mzPbq0NZI37g8kp/V72mTf0vSB/vpi3n17O
O6fIA/KBHCR+OxWT7oxjnfKO4ZN15iWcHGwUDydYx4M6c1Tf52XvnRPtX7B+
Vknph5JzGz4RE3hyM3dr7MP+mMN/sCJvkb5Ls/YXOVLK2r/gbFR9WFv03kD4
GX9/XbBN2FgftsC3rDAPlC0HHAcD5zTJuNFmG/sy9i/5gAz8i2+HYg43Xsp7
j3VyGP+C9y3JfrPs/a6JznP2Zwlnf9Fc/kbxfLVkbnbVS3+T/TXU6tiA+YD8
uU/jkNZPFBxT+EPtIGeoM+D5O28+ZCI/4D8cgkvUn2y1OcudK7q7Nme+gR0f
Yc9gwXP0Em/8gk+QOa/Kcsl5fiMfHJ1R02ZFLPAtekYilztDLjI7crZjUeRF
KXj1l+ydVms5g2Ejvn1XMepvdGx2F1yD4EVukvJJo102bZb/VlRcL8lZfIRe
akBN4CxJfttY53hfjev+au0/LPm1LfYdXNsa3KO2lVt8n5y5EHhu+Yg5NaUU
3OustQ3g5+xQnD8UfQU/bYx1YkQ92RU17ao4sLzsutyVdy0hXkerHCditKdg
+8kRcqU/+g5r/bF+PWsfsJ4R18Z0+B42cQ67zo4x74jjefns25L1DGn+Xcn9
Ef6tyDnuByOHmWNHVdhCDxyJPghe+gaYN0lGd4Nx0BM+r7gvkA+Lok7Sv9dl
jYXaUsyZM+gcF7qIJ7KQ80LRvZ97x6XzJ40rOfNxX8ihXlFf8c2UyA9iAa7V
0X+J1z0Rs/nC1qPxRHDxXNiB/rk54xqlmEyvtU+aWt1fb/UlvnBpdnAeDndW
OyfJR3DhV7CBaXz0Qepnd9QufEAsOIPOYuitj14Br6ivI7nbfXJm7NHXH8kb
A/2QPOiLvknPXBy1a0f0c86CD2yVnGMC5nmBkTP0Qc7hr2WyvX2s+z7cmRZ5
QV5Oj3ynlhHXhRFb3hD4cafidqnJ9pBzjzYYZ1fUImQOBx83RT6iF2wFxfle
xXu+5qvUQ1o6rPsBZKoe/lbturUmate1ZucPuXNROneUHMObcag2Z6nlzUX7
fUfEmZrQEZiYo78vagJ9cm+d85460RdvuXERH/h5pOQeRn0clt7tJfdDfHB3
9e03ycbId3hEjsEldCB3QbyvuoKf9Pbr0d/HC8N94YfqWucqfBqI2gUeeN4T
bwliyD4+uao+8n2Ta8fjk/xOAg+18VS8aajxg4GvWdhXVlw/8Cs+hp9fVFx/
qQH453S8keAXc+z4RHo+bTJXkX2ycLvmn4g6eSLWmWM/eqhRnGMP/D83uf9R
e5CPbLjUG/mBXZPLfseAvzveAeCcE3UTXmEn97n7rGzfPMnxmCge/drsXOqN
dwE+X1H0u6En8uJK5AbvsnV1fpvx7qBvwXFy/3S8S7vi7Qx/qCuVqC2VsY4f
sdtWsu5bOcyXOsD76EijZc+IXIRXs4vOAe5eVf85r9FW7bj0xPuQ99eH4YO3
5ZN3yn6rwe2FUWO3Fv3OuPVe7ouafxNfzvqQy9uGPXry+qiFF+N/EjHiTdob
ev8HajWuFw==
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3twlNUZxg9ks1mKbNhdsskmuwF2l1tULIVqA6FeKBextmpFJSqjYE2C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           "],
           VertexColors->None], 
          PolygonBox[{{5668, 6613, 1741, 6514, 5667}, {5949, 4865, 4864, 3702,
            1638}},
           VertexColors->None]}]}, 
       {RGBColor[0.8881284896875504, 0.8888480688117659, 0.8578082370823725], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmXts1uUVxx/etm/fXhD6Qtu09EVpCwu4BEUQijNZFoe3LCiCm4ZLgXLx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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl2twVeUVhj/IPkmImsM5nORMTtixhwTH0AsakkLAOF4oggx1vKBjwcuY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           "],
           VertexColors->None], PolygonBox[{{4384, 6520, 1743, 6523, 4383}},
           VertexColors->None]}]}, 
       {RGBColor[0.9101561809375556, 0.896193716895024, 0.8479398511421031], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlkts1FUUxq92pp1pS8cxtEP/TEeclloacWHiKy5IiNFANbFlZbA1slEg
4iPGYGBhgtUoJCZq4gZQSTFtMYG6cCELJURNKEmN0FKQSiIkRham5REfK78f
30lc3Nz7v/fc8/i+c879373l5aEdt6eUftJo0LjamNJhjfZ8SifbU7rQ7fVK
jeZcSiUJb9becxp3NqfUJtl12mvRWGiwHDKlRp+t0HehmNIY3zmPhUJKsw2+
tznvu9e6Urre5bOVGoeaUqrobFFjm9b7Yr2qNaWPNE9qntDY1ZLS3o6Ussz7
M5Idlr3vNE/p7CuNc7L1vWK50Wl/hrsdA/4PFSwzWLDvuaLjzGvuy3m9o5zS
Qz0pFbXe3WIf9uaNze/LjA/3sbf1tpSWpPdXrQfyXjO/oP1LkskKjqtJ/i3I
xkje98H8a+Fwvi69dZ+VZG9/o7H6pppSvcO6ZjXmi8ZuVOfvaUxI5rTwO6Vx
VDZ+lo4nOixzRuuzdd/praV0T81xvl1JqUfyB3R/VOtjwueg1kva21i23QHN
N/Q912D799XsA3EQD/vM6GDNfClifFzyv0lno2LtzVn3vGSel85DFcf8fsRP
7PBMPHCN/FRwBz9TwdHlVp9fFJ6f6GxN5ORbiu9f+VnW95j0T9d8dlyjP2SG
tP9Pl/P06YL9wc4ZyW6/w7LIwTn64b8Y6526+0a79W+T7292GvfJJvMEVvsj
x1mjGwyIt6novOaMfCXv/1atHe00B2BGLNjGVkk+7qlY33irfWgNv/rCn5uS
uVY1D9QFmJCT7C3F/lndP63xbc5xD5YdOziuiLojP6mV1TnXKL62RdzDedvd
IB4XV/v7SemYy8zLZ8Era2ruRJN1rZJMV+acvNJqzoiDuqF+qNPdwT283xQO
WcU9A31gRh29Ij3LuozvcNQM/pALyCEz2GiewQ8MmMFnVD5/UbKNteL33pr7
0FPS+WLFNrql+8eaY9/SaG7BZ2vFHMMvNkcCh4tF1x7f5Nd42bbBk14CptQb
+Q624L476rpadK6QG/Styegh6CIf0H8lehr7xIw8feOw4vi4aj139QrvzNj/
IB8Olq2bOD4tOxbyiXkubF0J/DcV3O/wDVzbAtvx4AjcPii6h2IXriajx14O
PfhGLmzsMCfEuil0Xl2e0mNV5wFcXA55fKXe4Ox8Zg7A/wFhfGqZOdzZ6bwh
Zw5oXpTckSZjcCT8mYg4wIr+sSdzD7mg+ZfMb0a78PljuWOAE7ghT7J4V6jJ
afl4SuN69Btskjd/tkm3MFlfcP6PByYDwQc+zESOs35NPWNtj3l+V/6/0+ma
A3tk5hr+70HUNjhOhP/4gb/ggOyJkJ/PzDGYzaunnas77+gF66OHrBHXfTW/
UbN191l4gNvB4OKYMNzQ495H/+SMOp2NHCXneDOfqbgeH9b8iMZI4DEYPelW
rba4X62LGPCfvV2xT91yj/XnwuDZbmM+GfVODsDzTM16+zPb48608O4q+83i
f6EUeh5Ur3210/1rX7xz+MM7/FLZ/PRHvYIt/eb+in1/XeeP9rie4Wd7uzmi
/yxGn+Scno4M+UXewymYfVm2bjDb1GzcRrr9D0GNwxd9E3needZw/pd4ONnt
O/TSq/EfNRJvNvgx2iLGqQ7/u4Axucj7h3/90Y+IjbofK7n2P6w6v2/VZ8VY
gzM+oRPe/wOZakdE
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl1lwVFUQhg+ETCYgGQaTGQiZ0cxMgERRC0iEUkEQS2XRsKOQoBiUEMCw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           "],
           VertexColors->None], 
          PolygonBox[{{4209, 7627, 2223, 7626, 4208}, {6513, 4209, 4208, 6512,
            1740}, {4381, 7625, 7624, 7628, 2223}, {8837, 8832, 1041, 5494, 
           8836}},
           VertexColors->None]}]}, 
       {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
        GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmWtwldUVhvc5J5dzTmKSYyEh0ZOOidDW1o4zrU5VVBCdVkalVUSno/WC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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlWtolmUYx6/3/Dxre19fyOd1Y89kz7um2YEgXBmWDLRQxMPQIWKZoYnp
1G2FhEWyk99DoWU0KLWk1MwvprIPCiUEVmulMwj0Q1liFB6yVdjv4t+HG57r
vg73/zr9n+YXtnVsTZtZDyfL+ahk1tJidrbGbBTFfOQEeRS5HXl/xWzyXrPX
MD6YN/uH7zuc50PdLYrMfr/PrOseszU5swsNZtNbzZ6oNQvwfw//dWV8MmZv
Y78c+3Zs5hXMbiM/gzyW4Ee8iVC+F9G/W1CMM+iasfkK3XnOJeSJRG/9gNwG
3gi8n4H3ybRymTPVbCirnK6DrQ3/2by/Hox3+Z7kro/vvpTZvthsNzF24ft6
YLYX/Y6q2TR8h3njSr3Z09yt5vvXnHxzFek8Rox/hbMCeSH+O9Hdpj5rwbaH
eh3Bd5h418nnNDYtTWbXyO8AcgqbNFhnYbME3TrkL9BXibeUWDHyDORWzr/0
KhOq9q+g3xaoB98TazH1HSmoZg9jmxDva3RhKGznqddYKIyPUZ+t2BfJ9ydy
7AbbZk4vcoS8gu8B/It813I+JZ+PK6rVRE65dRNzS6Ac91O7PY1m3/D2TvLd
hO9MYvwZqqbneHsK7w3lhaEv0hseu44ziL6HGtwk/pvox5G/5XSnNBOt+LaB
+VKNbJagW+x6Ym8PhHWcHqUKwvw++BqxP+39o+ePEnsZ9v3E2p5WL79LNGve
0zz64Vi938DdenLtrAqbvzGnaHaCuw/z6lGZ+q4F0y3sbwSaPZ9pn2WfQe/N
jljYvEcdvPXyFHoClgHiP4j/Q5z2QDtR57Zl9Wo+d7N4+xSYCrx1J1Tt/iLG
5VA1XO4yPj8HmokX6f8tMHaS/0rOXWyXod+Yk08v37tKyt179hL6BcQfAe9e
bGrR/4b/Hylhcqxd6D/ICPMj5HasJNulnH5qUcJnQSCfz+vMXq1o1n2nnTsO
0YMfM+IQn40D+G8qaEa8lvOKiuU1deyX6V+2oBw8tw5yvBoox0/QDVbEJdew
70ZuA99b4B/NajYeKKvXPiMXyO9iIm7wGXoj1o75bvX4TmH7ZSxfz/HZsnrq
vbzJGSlrB333roBniPd212u2/c0WfAf+x+M7Oj0SRzk3zU2LCxdy946JEz23
v4viBs/Rd2NzpN76jniso/XKzWOeQT8WadcyBXHFLw2K7ZyxBXxJk7jDOcW5
8WBF3OwceRj/45xF1GKcGIOxauC593L6G8TJzsXek7O+q5G4zTnkKPK5SL6+
Uz6L0yriLp/JY1XVzGvlb2SRHy+Je30nfNdmT9Ws+86tQn4u0dvOMcVYM++z
7jPkXHWyUbV2zupEtyZW7j7DcyNxuHO3z2xXWRzm3OU1NmqRb9Ls+8ztw35D
VVzmHO5c8FRJ/zLnhEnfh0Rc4zM2E9/7m8Stzok1YL/RLC7wf8h/lz0AxA==

           "],
           VertexColors->None]}]}}, {{}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{4011, 9252, 5433, 5384, 8689, 5386, 8691, 5382, 7577, 7579,
            3975, 7581, 3977, 5737, 9000, 5739, 9002, 5563, 5912, 5804, 9111, 
           5806, 9113, 4460, 7714, 7716, 6891, 6889, 3892, 6608, 5663, 8898, 
           5665, 6054, 6052, 5370, 9664, 5372, 5368, 7541, 7543, 7545, 8782, 
           8780, 5988, 9046, 5762, 9044, 5764, 6612, 6610, 9135, 5832, 9133, 
           9139, 9137, 4445, 7697, 4447, 7699, 8964, 3896, 5716, 3894, 9238, 
           5713, 6721, 3526, 6009, 6011, 5366, 7537, 7539, 3968, 8685, 3970, 
           5427, 8784, 5429, 8786, 4212, 5485, 4380, 7625, 4381, 7627, 4209, 
           6513, 5430, 6534, 6535, 5975, 4004, 7316, 4005, 6787, 6050, 4449, 
           6574, 4448, 7724, 7725, 7435, 7436, 3822, 6019, 7439, 7438, 7437, 
           4464, 7726, 5666, 7354, 9748, 4511, 7879, 7459, 7460, 6020, 6575, 
           5572, 6576, 6021, 3845, 6871, 9759, 6872, 6870, 4428, 9155, 5879, 
           7461, 7462, 6626, 5702, 8917, 5703, 8914, 8916, 8915, 3629, 8919, 
           8920, 8918, 8922, 8921, 5704, 5706, 9712, 5705, 4461, 9271, 4462, 
           3846, 7720, 7721, 7717, 7719, 7718, 3561, 4433, 7673, 4434, 7674, 
           8832, 8837, 5490, 4390, 9270, 4395, 5925, 5283, 9244, 3902, 5482, 
           3908, 9250, 5289, 7234, 7680, 7686, 6764, 6758, 3829, 6625, 3835, 
           7453, 7447, 8910, 8904, 4368, 8953, 8959, 7504, 7510, 7516, 6619, 
           9154, 5842, 9148, 5848, 6066, 6060, 5887, 9722, 5893, 5781, 9079, 
           5787, 9061, 9073, 9067, 9089, 8792, 8798, 7563, 7557, 7551, 5378, 
           5674, 9206, 3641, 6072, 3647, 9212, 5680, 4017, 8810, 5445, 8804, 
           5439, 5692, 9709, 5686}],
          "3.41`"],
         Annotation[#, 3.41, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{4010, 9251, 5432, 5383, 8688, 5385, 8690, 5381, 7576, 7578,
            3974, 7580, 3976, 5736, 8999, 5738, 9001, 5562, 5911, 5803, 9110, 
           5805, 9112, 4459, 7713, 7715, 6890, 6888, 3891, 6607, 5662, 8897, 
           5664, 6053, 6051, 5369, 9663, 5371, 5367, 7540, 7542, 7544, 8781, 
           8779, 5987, 9045, 5761, 9043, 5763, 6611, 6609, 9134, 5831, 9132, 
           9138, 9136, 4444, 7696, 4446, 7698, 8963, 3895, 5715, 3893, 9237, 
           5712, 6720, 3525, 6008, 6010, 5365, 7536, 7538, 3967, 8684, 3969, 
           5426, 8783, 5428, 8785, 4211, 5484, 4379, 7624, 7628, 7626, 4208, 
           6512, 4210, 9261, 5483, 5976, 5765, 4006, 5571, 9178, 3559, 6049, 
           7723, 7666, 7667, 7665, 4426, 7878, 4510, 6895, 4509, 6896, 5476, 
           7314, 9749, 5353, 8681, 5354, 7236, 4427, 7668, 7669, 7410, 7409, 
           3560, 6874, 6875, 6873, 4429, 5992, 5991, 6561, 9052, 9053, 9051, 
           9055, 9054, 5573, 6644, 6645, 5914, 6698, 5944, 5945, 5808, 5809, 
           5771, 6682, 5977, 5978, 7371, 7370, 4007, 5989, 5993, 5994, 6521, 
           6520, 4384, 6685, 5938, 5941, 3530, 7887, 4516, 7883, 4520, 7891, 
           4203, 4528, 9289, 4524, 3635, 4468, 9275, 4472, 5494, 8836, 5489, 
           4389, 9269, 4394, 5924, 5282, 9243, 3901, 5481, 3907, 9249, 5288, 
           7233, 7679, 7685, 6763, 6757, 3828, 6624, 3834, 7452, 7446, 8909, 
           8903, 4367, 8952, 8958, 7503, 7509, 7515, 6618, 9153, 5841, 9147, 
           5847, 6065, 6059, 5886, 9721, 5892, 5780, 9078, 5786, 9060, 9072, 
           9066, 9088, 8791, 8797, 7562, 7556, 7550, 5377, 5673, 9205, 3640, 
           6071, 3646, 9211, 5679, 4016, 8809, 5444, 8803, 5438, 5691, 9708, 
           5685}],
          "3.1`"],
         Annotation[#, 3.1, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{8831, 8733, 8747, 8719, 8775, 8761, 4031, 5423, 9680, 5409,
            3661, 4585, 9317, 4599, 4060, 4571, 9303, 4557, 3354, 4613, 9331, 
           4627, 4227, 4655, 9345, 4641, 3675, 4697, 9373, 4711, 4074, 4683, 
           9359, 4669, 3368, 4725, 9387, 4739, 4241, 4767, 9401, 4753, 3689, 
           4809, 9429, 4823, 4088, 4795, 9415, 4781, 3382, 4837, 9443, 4851, 
           4255, 4879, 9457, 4865, 5949, 5948, 4932, 9236, 3875, 5472, 3874, 
           7611, 7612, 7610, 4358, 8947, 5711, 6775, 6776, 6600, 5626, 5828, 
           9197, 3593, 6047, 3594, 4456, 7708, 4457, 7709, 3821, 4463, 7430, 
           7707, 4455, 9745, 7496, 3877, 7497, 7498, 7418, 7419, 3625, 8680, 
           3626, 7421, 7420, 7653, 7652, 8875, 8686, 8687, 7573, 7574, 7575, 
           6784, 6785, 6740, 9758, 6741, 9730, 9731, 9732, 3523, 7388, 9755, 
           5767, 7389, 5768, 6641, 5766, 6643, 5770, 6705, 5769, 6642, 6746, 
           6515, 5431, 6613, 5668, 6519, 6517, 4009, 6789, 5996, 6523, 4383, 
           6684, 5937, 5940, 3529, 7886, 4515, 7882, 4519, 7890, 4202, 4527, 
           9288, 4523, 3634, 4467, 9274, 4471, 5493, 8835, 5488, 4388, 9268, 
           4393, 5923, 5281, 9242, 3900, 5480, 3906, 9248, 5287, 7232, 7678, 
           7684, 6762, 6756, 3827, 6623, 3833, 7451, 7445, 8908, 8902, 4366, 
           8951, 8957, 7502, 7508, 7514, 6617, 9152, 5840, 9146, 5846, 6064, 
           6058, 5885, 9720, 5891, 5779, 9077, 5785, 9059, 9071, 9065, 9087, 
           8790, 8796, 7561, 7555, 7549, 5376, 5672, 9204, 3639, 6070, 3645, 
           9210, 5678, 4015, 8808, 5443, 8802, 5437, 5690, 9707, 5684}],
          "2.79`"],
         Annotation[#, 2.79, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV02toz3EUx/GDyUr7Yzbb32bYzGUuuWQMJWQkiolcSm6ZS5G1liQ0lzyQ
GA880MgDoTWXTCg8sjYjuSZKknIpEjWX2Lz+Dz57/z7nfM/5nvP7/Td47baK
rV0iIuHPhH4Rn4sjynBadsSawoiZWImNvSJGi/8ukktENOVElOIPfph4Z1bE
rgERtXSIVqpZQrvlN9JWWksnna3GOuyqx0/3/fV8wfMleu75pvwjvIsvkxHL
9VtMC+ivnu2U0SfiHrZRlnh/+mWeN85/x3X9IzZRt4KIf3LT8yPOmXHgkIgZ
dqm011RM8mfEC909XM8JfBFuk6/Vuxpr+DLxKhyn90Wcwzfipt4Rj91xznMr
nsWH2JKhl55jKc8cBeI7zbaF38+fd3c1X0NFdq1K7Slel2seZ6/b/YH4NWzD
JsxW+8Qez+gp3RcfpaYV0/GqHlfotH3r6aDY4dR7dHaK2qm0m1+k1x6swHxs
pq+eR9qti7qcoRFp9k5i8LnYqUcHlZstYb8VmIHL8RSleR9pdip0PtP5zWIF
8j34dPqkdwn/Geea43jfiNni5TSHVosNUd9vsPspm5KUSyecXTfQzLSdjulx
1nu6TB/M3oY5dr2NN32PkjzvxQyTsBsNoDK+Ny70Xb6Y4w+9pSz9elBfdXXu
Ge/3eAD3uWMLFvM7sEF+Febyi3CWPvnYYe8R2F1+FvaUL8Ua9YHf5BNYL/89
M+Id/x4nqm/AZv4W/rT7C3zGt+BG9UfxBl+PR9XX4kW+Goepn4ZH+Hn4Sf0G
PMUvwxXqB+FefgzWqs/EqtR3wqT6B77RUv4Vvlbfjuv5jzg/Ve838Mg+Y/CO
/GT/D+WUoBLKT/1/03+6r5UJ
           "]],
          "2.48`"],
         Annotation[#, 2.48, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV01toz2EYwPHHSJGZGTb7D20Ycho5LEqMyZyTGSvFxKSMNcuFU3853NC4
kjRaUmbhRqFwRYTkmCgktYNDjJxy/Oziu+/7vM/7PO/h/1tuxaYlVZ0ioq8/
4/tFtA2NKOSpfSNW5UXM4HV8Ni1ilPkfg+V6RlzIjJjIn8X55v/2idg2ICKJ
/ShXsxQ75CuxEatxxNoaPsyd9Phmv1/Gp43P4bHxJfl7fI2f9o9Yrt8SzMcv
Pb+iR3rEdb6NDPP98d15XljfzhXZEeuRMjDit9y0nIhTzjhwSMR0d1nnXlM4
S3zCfK69h+k5XpzHVfJJvWu4VlxovpoL9G7k2eKzvL5XxH17nDK+xQ18l2+m
RrzEdXdYgTIUq1nO89ytnOfzQrR7gwU8Vu/OzpqCdPTCR3ML9fxk/RjjUuuW
4YxzFbnfTMzCdudfjYfGj/AAT/AYlc74Xq8PaMM7vEWac851xxbjVjSj2F4l
5sbpP4cLOGG/FmfM5jve9y6OG+91pv3Yh9qOvbOc35uWGCdyrccx/ers04R6
ZLvDM/lmdNMj1HwxPqlui3wSC1CJcqz0hmMG+eaQi1LMQZn1B/goKrATm3FI
/wY9z6NZ/9vczxtc4UveYUQiYmR+xCROQQ4KxWm8yF7v7fkTr5ChX1f0Vnc4
w5t4gz282x4beIh4KzfJr+RM8WIu0ifBf/zew7mLfBF3l5/Iter/9fbbyqeK
6+Xbxa/Fb3iC+ia+Ib7M39z1CT8S3+RK9XV8UVzPdeqT3Ciu4Xz1U/mguIRb
1a/lY+IyXqF+EO8Sj+ak+nSuFnfmLPV3/G6l4mf8XP1XXiNu4Xkd9b6Le+4z
mq/KT/atFCMVI5Do+N/Hf9E2oAg=
           "]],
          "2.17`"],
         Annotation[#, 2.17, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1G1IlmcUwPGjkSUzZ5r5lq5WmiyFVW5RsKkw0L1WW2iG0HRlDSLLRoOx
4onYvmyYfRljyN7YVkgFKyjHGvuQBbVpY71g0BuDMgg2F2ZmWf2eD3//17mv
c65zLu+bZ05r+9ubUyKi0p+FMyNulUYs4WW5EWufjajh9Xzg6YgFnt+bay8z
4kheRBX/Ly71fGJGxEfFEQl8iiY17+Bj+23YhHfxhdwO7uJwxl39xq33WR/E
Oetj9vv5N75YENHovJV4HePOHMFT0yNO8Glke56PUfNclj/MLYURG5BSEvHA
3kuzIn4wY/G8iGp3We9eSzlP/LXnZXqXqC3GwLSINL1Xm2EyN/EUbuT7GDHz
GA/pMyH/EfaLL8r5U+11bBIvEFfggBlP6feTvB+Raq5IzobD8k6Y7ST68Ifa
a6gxTy0K5OTjpl5j7rHCvUd5Od/jVjn/cZ34X67nYU7nanVnccEMfc78y3or
X8GgZ7+YqRcJMzQ4p9J+sfWAGadYp6Hf+ojzDuNnfGP/Q7nbkeJeOerrzP0q
6pPz+1/+7vkZ/mSOXJSbfWO+GuSr38u9cnfzIu/gTV6D73Lcm29gMd5Lvgd+
2Rw5vE+vSp6Ndep6vduT6EQPulGg16DZbmCqXo/5Dr6Xv81+Am+gDU1o1qPy
Gd80ZmMV6tAg/zP+Ei3YgXbscf63+h9Kzun805xrvl/5WJa7FkU8VxbxAqeg
CEvEmfyWXrf1HMNVZDtvMqar63L3531Xu3mXHu/zXPF27rHfzDPFy7nWOYX8
0Lc7nyfZr+V0+1X8gfpH2b4H+xnibvvD4uvif3ix+h7uE/fyXXc9z3+LT3Gb
+k4+Ku7mTvUJ3i/u4FL1y/hzcT0PqV/HX4kbeLX6Et4pruCE+izeIk7lPPVn
fJ+rxIN8Sf0It4pv8mvJeu+6330q+Lj9F31TryAD5ShM/rbgCT/rr/4=
           "]],
          "1.8599999999999999`"],
         Annotation[#, 1.8599999999999999`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{5553, 9694, 5554, 7406, 7405, 7634, 7633, 3535, 3553, 5551,
            8863, 5552, 8864, 4399, 5997, 5550, 7632, 4398, 7631, 4397, 5549, 
           9175, 3533, 7404, 7403, 7402, 4396, 5548, 9693, 5547, 6833, 4385, 
           7629, 7630, 7323, 7322, 7353, 8896, 6830, 6831, 6829, 4362, 6832, 
           3628, 9199, 4425, 5545, 5694, 3813, 9214, 4443, 5657, 7711, 7712, 
           7433, 7434, 3819, 8291, 8292, 7614, 4359, 7613, 4360, 7615, 8608, 
           8609, 5324, 8155, 3954, 8211, 8225, 8169, 8197, 8183, 3744, 6472, 
           6485, 5878, 6511, 6498, 4295, 7293, 7306, 7254, 7280, 7267, 3440, 
           8501, 8514, 8488, 8540, 8527, 4129, 8594, 8607, 8553, 8580, 8566, 
           3623, 6247, 6261, 5655, 6288, 7351, 6274, 3889, 6220, 6233, 5024, 
           6207, 6372, 6194, 3426, 6149, 6717, 6162, 5542, 6188, 6175, 3939, 
           7863, 7876, 7821, 7849, 7835, 3608, 6103, 6116, 5639, 6142, 6129, 
           4001, 7794, 7807, 7755, 7781, 7768, 3419, 7980, 7993, 7967, 8019, 
           8006, 3925, 8074, 8087, 8032, 8060, 8046, 3726, 6303, 6317, 5860, 
           6344, 6676, 6330, 4278, 6951, 9769, 6964, 6912, 6938, 9782, 6925, 
           3405, 7914, 7927, 7901, 7953, 7940, 4112, 5007, 9519, 4994, 3712, 
           4968, 9506, 4981, 4265, 4955, 9493, 4942, 3392, 4889, 9467, 4902, 
           4098, 4928, 9480, 4915, 3699, 4861, 9453, 4875, 4251, 4847, 9439, 
           4833, 3378, 4777, 9411, 4791, 4084, 4819, 9425, 4805, 3685, 4749, 
           9397, 4763, 4237, 4735, 9383, 4721, 3364, 4665, 9355, 4679, 4070, 
           4707, 9369, 4693, 3671, 4637, 9341, 4651, 4223, 4623, 9327, 4609, 
           3350, 4553, 9299, 4567, 4056, 4595, 9313, 4581, 3657, 5405, 9676, 
           5419, 4027, 8757, 8771, 8715, 8743, 8729, 8827}],
          "1.55`"],
         Annotation[#, 1.55, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV03tozXEYx/FHhOQ2jGHN5jKy3ClFbrnfygwLYSe3yJhLCR0tUWOIxFox
qa39QeSyolxCo0aJmiZJmVshTfwh4nX+eJ93n/N8n+f7/f5+5+QktuYXt4qI
bB/3O0XczolowGV8RBPWd4341CPizqCIV9zcOeI4X5HPcqRFlPIFeQdfN2cC
H5LncKH+dXxKXsaN+vvxbnkYt6in8Sa5Ndfob+gesVBu4rnqP3ml/JEf67/M
U+Tb3KzeuXdEJsrSnYfPoCUjosKsr30jfmNxn4hqVGCinhGZjPboj3TcMvtH
thnuXa/nLV6g0fqLfBMHUYWTOGJ+0vojKEE1KjDC+ib+gKt4gru4ZP4Eno3h
SGBJqt4lYrN5uzEdq7AISfOv9Yu4hxq8wlOUWN9NXzY+yW34F1eZP8vdC/Cz
Z0QxF6Heefa5XxmWYCsSKZs/1l2nYjBWYCGyrT/B57ARB7ALueav91x3oqf5
x7nOnFIe6UzzuBBV3sskfodRKLJPG57o2adxtfeUx1lI6KvLiniActSiEr3s
1djLDLS111/+jvPWl6gnMRdrsQzL7ZHnGYxHFvIxAwXWl/FprMZebMFR88/Z
/2LqnOY/4u7Od5NvuH+u5z8kN2IM//N9bx4nd+T59vpsz194ja7mtUYXfcfc
fbjfZinvt8cGzpF3cq36cu4hL+DJ5mTw74ERg7iV+mRupz6at+v/0y3ii3oH
uVL9m/xGfsuj9NfyfbmOf7jrc34mP+S1+sv5ulzJ5fqTXCNv4wH6x/NheSa/
15/gCrmAl+rP5H3yUE6m/mtcLAen63/s/58vN/JL/S28Rm7m2al+77rBfYby
LfWx/SOmoQNykYE9+A+W4agL
           "]],
          "1.24`"],
         Annotation[#, 1.24, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV02tozmEYx/HLhCTMcRi2yWjLmVLklPOpMLaQwxwjhzmU0KMlagyRWCsm
tbUXRMxqyiE0apSoaZKUORXSxAsRPs+L7/Pd77nu67rv+//fk7Vm+6JtrSIi
08e9jhG3siIacAUf0IT1qREfu0fczo54yc2dIk7wVfkc/1Mv5ovyTq4xZxwf
lmdxgfo6Pi3nc6P+/rxHHsIt6qm8SU7hKv0N3SLmy008W/0HL5c/8CP9V3iS
fIub1Tv2jkhHSQ/n6RVx1t8tXGbWl/SIX1jUJ6ISZRivZ1hfRjtkoTtumv09
0wzU63mD52i0/hLX4RAqcApHzU9YexRFqEQZhlnfxO9xDY9xB5fNH8czMRSF
WJysd47YbN4eTMUKLEDC/OsZEXdRhZd4giLru+jLwEe5Nf/kCvNnuHsefvSM
2MqrUe88+92vBIuxDYVJmz/aO56MQViG+ciw/iSfx0YcxG5km7/ec92FHuaf
4Fpzinm4M83hAlR4LxP4LUZgtX1a83jPPpUrvadc7odCfbX9I+6jFNUoR097
NaaZgTb2+sPfcMH6IvUEZmMt8rHUHrmewVj0w0JMQ571JXwGK7EPW3DM/PP2
v5Q8p/kPuavz1fEN98/2/AcPihjFf33fi8fIHXiuvT7Z8ydeobN5Keik77i7
D/W/WcwH7LGBM+VdXK2+lLvJ83iiOWn8a2DEQA71idxWfSTv0P+7a8Rn9fZy
ufpX+bX8hkfor+Z7ci1/d9dn/FR+wGv1l3KNXM6l+hNcJW/nAfrH8hF5Or/T
X8hlch4v0Z/O++UcTiR/a7xV/tfFb0b/I14oN/IL/S28Sm7mmcl+77rBfXL4
pvroARFT0B7ZSMNe/AfFaKrn
           "]],
          "0.9299999999999999`"],
         Annotation[#, 0.9299999999999999, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV02tozmEYx/FrQhLmtGFmNkbkTClyymGOhTk0clhziBzmUEKPlqgxRGKt
mNTWXkzErCiHEGqUqGmSlDkV0sQLkcPnefF9vvs9131d933//3tyiorzt6ZE
RLaPOx0jbuRENOAi3qMJaztHfOgecXNAxAtu7hRxjC/JZ/ivegmfl7dznTnj
+KA8k5eqr+GT8hJu1N+Hd8lDuEU9lTfIKVytv6FbxDy5iWepf+fl8nt+qP8i
T5JvcLN6h14RGShNc56eEaf93cLlZn3uHfETCzMiqlCO8XqGZTLaIhvdcN3s
b9lm4L6e13iGRutr+RoOoBIncNj8hLWHUYwqlGOY9U38DpfxCLdwwfxxnIeh
KMSiZD01YqN5uzAVKzAfCfOv9I24jWq8wGMUW99ZXxY+yK34B1eaP8Pd8/E9
PWIzr8Z959nrfqVYhC0oTNr80d7xZAzAMsxDlvXH+SzWYz92Itf8tZ7rDnQ3
/xjXm1PCw51pNi9Fpfcygd9gBFbbpxWP9+xTucp7GsyZKNRXnxVxF2WoQQXS
7NXYwwy0ttdv/opz1herJzALRViCAnsM9gzGIhMLMA351pfyKazEHmzCEfPP
2r82eU7zH3AX57vGV90/1/MfODBiFP/xfQ8eI7fnOfb6aM8feIlO5qWgo76j
7j7U/2YJ77PHOu4r7+Aa9QLuKs/lieak88/ciP78z1knchv1kbxN/6+uEZ/U
28kV+r/Ir+TXPEJ/Dd+R6/mb/qf8RL7HRfrLuE6u4DL9Ca6Wt3KO/rF8SJ7O
b/UXcrmcz4v1Z/BeeRAnkr813iz/7eI3o/8hL5Ab+bn+Fl4lN3Nest+7bnCf
QXxdfXS/iCloh1ykYzf+AzYeqsY=
           "]],
          "0.62`"],
         Annotation[#, 0.62, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV03loz3Ecx/H3QhLm2jBzjLlyjClFrhxzFjYTcixX5JijhH5aosYQibVi
Ulv7g8ixohyhUaNETZOkzFVIk/0hQh6/P56/516/9+f9/nw+3+9+/ddsKyhO
iYgsH/c6RtzqH1GPS/iARqztHPExLeL2oIiX3JQacYwvy2f4r3oJn5e38zVz
xvFBeSYvVl/DJ+VCbtDfm3fJw7hZPZU3yMHV+uu7RcyTG3mW+g9eJn/gR/ov
8ST5Fjept8+IyEBpuvP0jDjt72YuN+tLZsRPLOwVUYVyjNczojejDfqhK26a
/T3LDNTpeYPnaLD+At/AAVTiBA6bn7D2MIpRhXKMsL6R3+MKHuMOLpo/jvMw
HEUoSNY7RWw0bxemYjnmI2H+1X4Rd1GNl3iCYus76euDj3IKt3Cl+TPcPR8/
ukds5lWoc5697leKAmxBUdLm53rHkzEQSzEPfaw/zmexHvuxE9nmr/Vcd6Cb
+ce41pwSHulMs3kxKr2XCfwWOVhlnxQe79mncpX3NJQzUaSvtm/EfZShBhVI
s1dDDzPQyl6/+RvOWV+snsAsrEYhlthjqGcwFplYgGnIt76UT2EF9mATjph/
1v4Xkuc0/yF3dr4bfN39sz3/QYMjRvMf33fnMXI7nmOvT/ZswSt0NC/QQd9R
dx/uf7OE99ljHfeVd3CN+hLuIs/lieak88+BEQP4n7NO5Nbqo3ib/l9dIz6r
t5Ur9H+VX8tvOEd/Dd+Ta/m7/mf8VH7Aq/WX8TW5gsv0J7ha3spZ+sfyIXk6
v9NfxOVyPi/Sn8F75SGcSP7WeLP8t4vfjP5HvEBu4Bf6m3ml3MR5yX7vut59
hvBN9dwBEVPQFtlIx278B6uxqaY=
           "]],
          "0.31`"],
         Annotation[#, 0.31, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV02tozmEYx/HLIQlzHGZmbJicKUVOOZ8Kwxo5LEbkMIcSerREjSESa8Wk
tvaCyGFFDY1Qo0RNk6TMqZAmXogQn+fFd9/nt+u+rvu+///nySrctnhri4jI
9KcuJaI2K6IeF/EOjSjsHPE+NeLmwIjn3NQx4ihfkk/zH/ViPidv46vmjOUD
8kzOU1/DJ+Ql3KC/N++UB3Ozegqvl/91i6jSX8/z5Eaepf6Nl8nv+IH+izxR
ruUm9Xa9ItJQ0t150iJO+dzMZWZ96h3xAwvTIypRhnF6hmYwWiMTXXDD7K/9
zMA9Pa/wFA3Wn+fr2I8KHMch8xPWHkIRKlGGodY38ltcxkPcwgXzx/IMDEEB
FiXrnSI2mLcTU7Ac85Ew/0rfiNuownM8QpH1HfVl4L0c/J0rzJ/u7rn41iNi
E6/CPefZ434lWITNKEja/FHe8ST0x1LMQ4b1x/gM1mEfdiDb/ELPdTu6mn+U
a8wp5mHONJvzUOG9jOfX2OF44zzzFJ8rvZ9BnI4C62syI+6gFNUoRzd7NPTU
i5b2+MVfcNb6IvUEZmE1liDfHQa5+xikYwGmItf6Ej6JFdiNjThs/hn7n0+e
z/z73Mn5rvM198723AfkRIzk3/7fnUfLbXmOvT7Y8zteoIN5/7i9viPuPMR3
spj32mMt95G3c7V6PneW5/IEc1L5x4CILP7rrBO4lfoI3qr/Z9eIj+pt5HL9
n+WX8iserr+a6+Qa/qr/CT+W7/Jq/aV8VS7nUv0JrpK3cF/9Y/igPI3f6C/g
MjmXF+tP4z1yDieSvzHeJP/p4rei/wEvkBv4mf5mXik38Yxkv3dd7z45fEN9
VHbEZLRBNlKxC/8Bm4WqLA==
           "]],
          "0"],
         Annotation[#, 0, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV021I1WcYx/GrIkZlD2plZmsem7LsEQJjbaNtzUqobEZFD2IZRQ+mQbQ4
Q8YGLlsUYxMhjUDxRVGUCQZtYVGBDaLAUCqE7GGwjTDqRSwqqs958T1ff+e6
r+u+///bk6isKaseEhF5PrpGR1xIRHTjFB6hF5vHRTweH/FHfkQfD4yJOMSn
5aP8Wr2Wj8vV3G5OEf8kf8Or1Dfxr3IZ9+ifzHvlT3hQPY23ym8zI1r1d3OJ
3MvF6s94rfyIr+k/xZ/JF3hAfUR2RBbqJjjPpIjf/T3IDWb9mxPxAismR7Sg
AfP1FE5hDMOHGIfzZj/NNQNX9PTjFnqsP8Gd+BHNOIID5ietPYAqtKABhdb3
8kOcwXX8iZPmF/EiTEc5VqbqYyO2mbcXC7EOy5A0/+xHERfRij78hSrrR+vL
wWP5HZ6j2fyvPXspnk2M2MEbccV59nu+OqzETpSnbP4cd/w58rAGJcix/jA3
YQt+wB4kzN/svdYg3fxD3GFOLc9wpsW8Cs3u5VO+j7u4keUdcr/90jDfHaTJ
Le6rgLNRrr9jasQl1KMNjciwZ4/++xhiz5f8BMesr1JPohgVKMNq8wu8i3nI
xnJ8iVLr6/g3rMd32I6D5jfZ/0TqvOZf5THO18nnvIeEe5hWEDGbX/l+PM+V
P+Al9vrbns9xB6PMe8sj9f3iHUz3P1rL39ujkqfINdymvprHykt5gTmZ/OLj
iFx+46wLeKj6LN6t//+MiH/Uh8uN+v+T78n9PFN/G3fJHfxU/02+IV/mCv31
3C43cr3+JLfKu3iq/nn8s/wVP9Bfzg1yKX+rP4v3y/mcTP3meIf8Ot1vR/81
Xi738G39g7xBHuBFqX533e158vm8+py8iC8wHAlkYh/eAwVHrV0=
           "]],
          RowBox[{"-", "0.31`"}]],
         Annotation[#, -0.31, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV02tozmEYx/GLJMxxmJnTtjbnQylyyvlUGBZyWE6Rw5gSerREjSESa8Wk
tvZiIocV5RBCjRI1TWhlToU08UKEyOd58X2++z3XfV33/f/fe7LWbssvahER
2T5udYi4lhVRh3N4iwas7hzxrlvE9dyIZ9zUMeIwn5dP8m/1Yj4jb+VL5ozi
ffI0zldfxcfkhVyvvydvlwdws3oKr5P/do2o0l/Hs+UGnq7+lZfIb/m+/nM8
Tr7GTeptekakoaS786RHnPB3M5eZ9bFXxHfMy4ioRBlG6xnUm9ESvdEJV83+
kmkG7uppxBPUW1/DV7AXFTiKA+YnrD2AQlSiDIOsb+A3uIAHuIGz5o/iqRiI
AsxP1jtFrDdvOyZiKeYgYf7FfhE3UYVneIhC69vry8A7+R++ocL8KZ49D1/T
IjbyCtx1nl2erwTzsQkFSZs/3B2PRxYWYzYyrD/Cp7AWe7ANmeav9l6L0Nn8
w1xrTjEPdqYZnI8K9zKGX+EFHvXwDrnRfikY7Q5S5Er3lcvpKNBf2zfiNkpR
jXJ0sWe9/lcIe/7kzzhtfaF6AtOxEguxyPxc72Ik0jEXk5BnfQkfxzLsxAYc
NP+U/WuS5zX/Hndwvit82XvIdA/Z/SOG8S/fd+URcmueaa/39vyG52hn3l9u
q++QdzDQ/2gx77bHGu4lF3G1+iLuKM/iseak8veciH78x1nHcgv1obxF/4/U
iA/qreRy/Z/kl3IjD9FfzbfkWv6i/zE/ku/wSv2lfEku51L9Ca6SN3Mf/SN5
vzyZX+sv4DI5jxfoT+Ndcg4nkr853ij/7uK3o/8+z5Xr+an+Zl4uN/HUZL+7
rvM8OXxVfXh2xAS0QiZSsQP/AXHOrDs=
           "]],
          RowBox[{"-", "0.62`"}]],
         Annotation[#, -0.62, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV03loz3Ecx/G3JMw5zAzZxtxHKXLlvgpzy7HccsyV0E9L1BgisVY2qa39
QeRYUY4QapSoaUIrcxXSxB8iRDx+fzx/z71+78/7/fl8v5/9sldtnbulUUR0
93GzVcTV7IhqnMUb1GJ524i3HSKu9Yx4yvWtIw7xOfkE/1Iv4FPyJr5ozhDe
K0/gOerL+Kg8m2v0d+Jtci9uUE/h1fKf9hEV+qt5qlzLE9W/8AL5Dd/Tf5ZH
yFe5Xr1pRkQaCtOcp1PEcX83cLFZH7pEfMOMzhHlKMZQPX26MhqhC1rjitmf
s8zAHT11eIwa60/zZexBGY5gv/kJa/cjH+UoRh/ra/k1zuM+ruOM+UN4PHoj
DzOT9TYRa8zbhtFYiGlImH8hM+IGKvAUD5BvfQt9GXgr/8VXlJk/zrPn4kvH
iHW8BHecZ6fnK8RMrEde0uYPdMcjkYX5mIoM6w9zKVZiN7Yg0/zl3utmtDH/
EFeZU8B9nWkSz0GZexnGL/EcD9O9Q66zXwqGuoMUudx95XA68vRXdYu4hSJU
ogRt7Vmj/yX+Wf+DP+Gk9fnqCUzEUszGPPNzvIvBSMd0jEGu9YV8DIuwA2tx
wPxS+59Ontcz3eWWzneZL3kPme4hu1fEAP7p+3Y8SG7Ck+31zp5f8QzNzfvD
zfQd9A56+x8t4F32WMGd5c1cqT6PW8lTeLg5qfwtJ6Ib/3bW4Rzq/Xmj/u/t
It6rN5ZL9H+UX8h13E9/Jd+Uq/iz/kf8UL7NS/UX8UW5hIv0J7hC3sBd9Q/m
ffJYfqU/j4vlXJ6lP413yj04kfzN8Tr5V6rfjv57PF2u4Sf6G3ixXM/jk/3u
rtrz9OAr6gO7R4xCY2QiFdvxH8CQrBg=
           "]],
          RowBox[{"-", "0.9299999999999999`"}]],
         Annotation[#, -0.9299999999999999, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV03loz3Ecx/E3CXMOM3MNw9ylyJX7KszRyLFckWPu0E9L1BgisVZMamt/
EDlWlCOEGiVqmtDKXIU08YcIER6/P56/5+/1+3ze78/n+/n8vj1WbM7d1CAi
snzcaBlxpUdEFc7gNWqwNDXiTVrE1d4RT7iuVcQBPisf45/GC/ikvJ4v6DOE
d8sTeI7xJXxYns3V6jvwFrk31xtP4RXy73YR5eqreKpcwxONf+Z58mu+q/4M
j5CvcJ3xxh0j0lDY3n4yIo76Xs/Fer3vHPEVMzpFlKEYQ9X06cIIdEJLXNb7
U3c9cFtNLR6h2vxTfAm7UIpD2Kt/wty9yEcZitHH/Bp+hXO4h2s4rf8QHo9s
5GFmcrx1xEr9tmA05mMaEvqf7xZxHeV4gvvIN7+Zugy8kf/gC0r1H+fZc/A5
PWI1L8Jt+9nu+QoxE2uQl7T+A93xSHTDXExFhvkH+TiWYyc2IlP/pc51A1rp
f4Ar9SngvvY0ieeg1L0M4xd4hgcdnCHXWi8FQ91BilzmvnpyOvLUV2ZG3EQR
KlCC1tasVv8Cf83/zh9xwvx84wlMxGLMRq7+PZ3FYKRjOsYgx/xCPoIF2IZV
2Kf/ceufSu7XM93h5vZ3iS86h0z30D07YgD/8HsbHiQ34snWemvNL3iKpvr9
5ibq9juDbP/RAt5hjWXcUd7AFcZzuYU8hYfrk8pfe0V05V/2Opz/yf15nfpv
bSPeyQ3lEvUf5OdyLfdTX8E35Er+pP4hP5Bv8WL1RXxBLuEi9Qkul9dyZ/WD
eY88ll+qz+NiOYdnqU/j7XIWJ5LvHK+Wf7bx7qi/y9Plan6svp4XynU8Plnv
7qo8bxZfNj4wK2IUGiITqdiK/yBCq/U=
           "]],
          RowBox[{"-", "1.24`"}]],
         Annotation[#, -1.24, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV0mtojmEYB/BLoU3OOzoNY6N8UJYocirl1GQiiyViyWlFqznVQsuclb2j
thBhtKKGqDlsQ6lppMTCF+f4oOQtEr/3w2//977v677u57mfjV5bUbK1R0Sk
+3MwK+J1QcQhOWhQxP0REW08oDY/ojwn4lffiK4xEYfVjDMeT9Jcu5rB9nwY
HvGRo9a79ToiH1rLsNYhM+Vxc8/1+GPfI3O55j7Z85mufhH/zDcOiejp9wt1
F7IjEvacMVcv69Sdkgl5nyo1Ozir1zl6D4zYabyLNusP2OT5t7KFzVweGvHK
8zXJFnuyvcdT9Tf8vkm6+T6pGmffzXUv8rysY3//iHUjI7axnCNUs3BAxHQ5
nywmks8S71GcF7GS2VSygXr1n5z7k7+pu5ed9Nf/hPUz7OMOzZSqz3J+Pg3q
02SRZ0zT/yWdxo/tf5F6XiaTyIhYLOcwzv4q2ew+amQ/77RJljHCmZtHuzdW
U8cBctzlXFlCHlOZQLnzSvUpZxHVbKdV/QrfaT3f9F8oZ5DQ/7u7+MM7cka5
YzZ4pg7jZzRyiytU6j9vWMQyplHBWtrVL7KvlAJmMokL+t+U7TTxhi4KPc8x
2ZA6i71UplL/Wv0S7OYa5+lU/0S+pJWk2q9c17+v9xvCP/NFspCiVH/foIEF
/LD2nmP6f3GvR717Ulb7Xhl+96LbnhbfZYr/v4vynt5v5VLjb3K29S4517hN
Nur1W64xTsvU1/pYWWGcLTvtL5aHjFfJxdZnyT3Gk+RV+zfK08ZVMmn9pLxk
XCO77X8mbxi/k2Wp833jt1ykjRZu6/MfTaSoLQ==
           "]],
          RowBox[{"-", "1.55`"}]],
         Annotation[#, -1.55, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1G1IlXcYx/GrBzDKWrkyt3LNylZOGh2kSZBbTJDNVVtbJFNGi2JsgUEE
NVpEgfRAWawkndILnc3sQcFyFmJPUASOgpyRZcwFzagXbS/OaozW57z4+r2v
//+6fvf/3Oc+5qzZsKJyREQs9KdvSsTD3Ii73D45Ii0n4heewAdfifjV+tCs
iKfjI/ZNjfhYfVv/Z/yXvp2vRSy3vhKLXBdgi7lCM0VIYGNmRDEPmfkzheuk
vB/M1KLHfqO1Lm5JWUZhtlnk4+HMiN9RovcJ/40i68VId68e/a3T5b8uG6uR
RPekiImzI7L0fOG+GTxW3Wn9nKzDWRGH8I/5Z8izNg/zzR5wlqS1DnPVrvfj
mTNfsHYRw9ZPOUcbTqPS3H/pEc2uj+EndOtp0fsz/jA7Su5otMn60edsQD3K
zW5A6MnmuXrewsgJEdfMJuW8o37bXj5G6NtjrlHObm7ivVyn74jnUIdanMB5
5+jznH7DLRT47P08TvZz+x+oH6hb9R3HMjnb5C3lT7AcGXL/9z5M4tCTbrbX
OcbzwTcijmInzuEkyjznyZ5rDurNpHHC+dOcux+96qvmb/EdFKDmVffmJZhj
fjOfdL4qTneeb7kC091zvbN8hy9xGLuQOdH7wJ8iG+8iD+vcr0zOOpRiOzai
W/8qz3YtHsv/iBejRv6TGRH/4j4y34wYg6+d6Yr6JhrQiePYJL9kWsTnWIRK
fIXL+kvNlWE2irAATfLP8mW04B5uINd5qrk+dS/swKaU5e+WV4OtaEMjevVf
5350I6n3Edrlj/P5svDCeoJzkUjl+w7q8SGe2nuAavnDnuv+1HvG21O/E9ej
MWCmw/ey0O+9mXtkD/IK9WN+3/4NLlZf4gZZz3m1Os3/hmH7s7hSPYV7zS/l
vepyXmb/Pf5evYBbzX/DterNnLR/iI+pq3jA/E0+o77PFan7+44H0YxL6ECX
nJeJ4cGi
           "]],
          RowBox[{"-", "1.8599999999999999`"}]],
         Annotation[#, -1.8599999999999999`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV021sjmcUwPFjjS4U1WjVS81oTcQXJSpYlTxZ43XZEDIlFaRB4i1eY5kw
NhG6pVSatNkHgs6XSbpZP9ST1D6NUpHForTReClBxkITohW/58O///tc1znn
Ptf13B2zZsvizX0iYrw/jQMjGsZENOMM2tGKssERHdkRv4+LuMFtgyIO8Vnx
ce62v4trxOv5vD6T+FvxLF5kfwUfES/kFvXZvEk8lh/bT+dy8ZshEXXqmzkh
buUS+0/5a3E7J9Wf4aniBm6znzY8Igv7cswzLOKY58dcqdf9kREvMHdERC0q
UaimII/Ray+X++OC3k8+1QNN1m/hb7TIP8W/YS+qcRj79d8udz8qUItKFMhv
5buox2X8gdP6T+Ji5GM55qf2MyNW67cJ07EEpdiu/6+jIy6iDjfwFyrkf6wu
Bx3it3iGav0/d/Z5eDo0Yi0vQ5N5tjnfPszHOixPWf8JfuMi5OErJJAj/0c+
gVXYg40YqX+Ze92ADP0PcX/+L3W3WRFbeCs+Mt8J/XfkRhzMl4fv8Yvcq+a5
gnd+qx5kolfvwfye++rzQO1DpJtvobq+fAt9PvOxYhTy8IV31WOW53O809zX
uRVXcQ0tqXnU3kTHKPerf7O1GbzSO2/7jso4zdmee9dM60nxXbnteGWO16nv
RP3s1Fnlz+ES/CT/KI6hd4DfntPkjXa+pLMXfeK7128yV/IMrnY3Jz0nCiKq
uEf+AS4R/5Cazf9Ctnu4xCE3zfp31itwEf3EWda/MWMuZ4qbrHc7Uzm60Inz
Zk6aI0NOwjmK8f9Y3wlKzXaPH2Gi9UJMQ6P8emdodLZTnOQauVXoNmeXtS7v
7UTC8zb7hVyMadjtXVP0mI6lar7EAc8vnWWxmn/d3QI+av2Ffp1qrol/VjfQ
mf+Ul84X+I71R/L/4Q9j1LcN
           "]],
          RowBox[{"-", "2.17`"}]],
         Annotation[#, -2.17, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV0mloz3EcwPEPmtymzTDnNpN4YITIeLBacpWjhByllidCRBERkmO5xso8
mdzXao6pmWZkc7Q5csyRReZ6gAdzE689eP/fv8/x/fy+3+/vn7Zw6fQlLSKi
l5+yjhGlaRGVOIznqMWcxIgXyRHnMiPquL5TxCY+It7DTeoruVC8iE+YM4TX
iMfyZPXZvFU8iW9bn8SLxWn8Vj2B54u/J0UUWV/JOeJaHqf+gaeKn3OF9Yd5
uLiU69Vb9ohIxLqu9tM9Yofnt5xv1queEZ8wPjXiAPKRZU1GL8YftRRuixKz
3/UzA+XyD1GD2/qL+SxWowBbsN785XrXIw8HkI8M/bX8DMdwFedxyPwhnI10
zMSE5nrniAXmLcYoTEculpt/vG/EBRShDlXI09/aumS8EP/ARxSYP8bZ9/Lf
DPeWEvEe9c72FI/wBI9Rbo8/9Z5xH6dxCsV6t3Ny83nVdpuxB7twVG0vj+gS
saJbxGszXqHInR9Mj0iVr+kd0YOrfJtctWvcSj1lQMRX8Tdc1PtdLlXukv4W
+n/7n3WQ+8Xtea75reSv6F/hvRvtqdpzDW7hJva7gwT5q+qDuYrvyd/HXSSb
ccp+r8mf5Ot8mgvNvaE2z3synXEBD+KBqDNzm1n9Pe80o9r/8o/n65zOFdaN
6OO/bMZQzufRXGDdPs85/d1Z83l8tw08TryZK61PcrbL/M+3aSm/Vj4PF9BG
nGjGrOa74k7icvkme5mPRjTghD1V2Ec7PTnuLhtf3OdH5NrbS36DQfJZGIky
/cecu8z5i7mCC/XuRpN9Nso1em8DcjwvU8/ibIzEKu8aZsYozLBmCjZ4/uws
06x55BtP5O3yn8xrsOaOeKd1HZz5or4ELuGn8m/0P+D/OSK5TA==
           "]],
          RowBox[{"-", "2.48`"}]],
         Annotation[#, -2.48, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{3509, 8624, 8638, 8610, 8666, 8652, 4185, 5339, 9649, 5325,
            3799, 5250, 9635, 5264, 4339, 5236, 9621, 5222, 3495, 5166, 9593, 
           5180, 4171, 5208, 9607, 5194, 3785, 5138, 9579, 5152, 4325, 5124, 
           9565, 5110, 3481, 5054, 9537, 5068, 4157, 5096, 9551, 5082, 3771, 
           5026, 9523, 5040, 4311, 6401, 6415, 5500, 6387, 6538, 6537, 6536, 
           6533, 3548, 7401, 6726, 8867, 5559, 6795, 7588, 7313, 5475, 7163, 
           5474, 5951, 5950, 5498, 9262, 4297, 5499, 4296, 5473, 9253, 4130, 
           5901, 7586, 7587, 6686, 5899, 9160, 5900, 9157, 9159, 9158, 6048, 
           3592, 8892, 8893, 8891, 5625, 8894, 5544, 9692, 5829, 5798, 9107, 
           5799, 9108, 4420, 8861, 8862, 8860, 9035, 9034, 5755, 3816, 7429, 
           7428, 7706, 7705, 8872, 8682, 8683, 7564, 7565, 7566, 6844, 6845, 
           6843, 6850, 6849, 7358, 7386, 9714, 5749, 7387, 5750, 6636, 5748, 
           6638, 5752, 6704, 5751, 6637, 6742, 6438, 5319, 6532, 5470, 6441, 
           6439, 4045, 6792, 6435, 7309, 5317, 6651, 5314, 6433, 6075, 7732, 
           4487, 7728, 4491, 7736, 3986, 4499, 9281, 4495, 3578, 4479, 9277, 
           4483, 5310, 8466, 5306, 3838, 9217, 4475, 4452, 4531, 9223, 3855, 
           5463, 3861, 9229, 4537, 6899, 6749, 6884, 6878, 7335, 6587, 3849, 
           7489, 7483, 8943, 8937, 5956, 8925, 8931, 7465, 7471, 7477, 6581, 
           9125, 5813, 9119, 5819, 6037, 6031, 3571, 9188, 5604, 5598, 9025, 
           5743, 9007, 9019, 9013, 3957, 6449, 6455, 5970, 5964, 6527, 5358, 
           5456, 9684, 5449, 6025, 3565, 9182, 5578, 3981, 8459, 5300, 8452, 
           5293, 5592, 9699, 5585}],
          RowBox[{"-", "2.79`"}]],
         Annotation[#, -2.79, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{4207, 7591, 9260, 9257, 8817, 9265, 4375, 9744, 7594, 7597,
            7600, 6689, 6692, 5907, 9727, 5904, 7374, 3963, 9738, 9741, 9735, 
           6842, 6836, 4403, 9789, 6839, 7392, 8855, 8858, 6774, 6771, 3873, 
           6598, 5618, 8884, 5621, 6046, 6043, 3585, 9195, 5615, 5364, 7520, 
           7523, 7526, 8697, 8694, 3966, 8979, 5724, 8976, 5727, 6632, 6629, 
           7535, 7532, 7529, 8973, 8970, 4437, 7689, 4440, 7692, 8840, 3870, 
           5497, 3867, 9235, 4543, 6084, 6081, 3540, 5935, 5525, 8846, 8852, 
           8849, 8998, 3973, 8989, 8992, 8986, 5735, 8995, 5730, 6635, 7572, 
           7569, 8983, 8980, 5920, 6443, 4356, 5983, 6780, 5756, 3990, 5570, 
           9177, 3558, 6014, 3557, 7649, 7650, 7648, 4418, 7744, 4505, 6892, 
           4504, 6893, 7416, 7415, 5389, 8700, 5390, 7238, 4417, 7646, 7647, 
           7408, 7407, 3556, 6852, 6853, 6851, 4412, 6002, 6001, 3589, 9030, 
           9031, 9029, 9033, 9032, 5568, 6639, 6640, 5913, 6697, 5942, 5943, 
           5753, 9715, 5754, 5567, 7325, 5566, 8871, 6569, 3910, 6078, 3909, 
           6777, 7308, 7307, 5316, 6650, 5313, 6432, 6074, 7731, 4486, 7727, 
           4490, 7735, 3985, 4498, 9280, 4494, 3577, 4478, 9276, 4482, 5309, 
           8465, 5305, 3837, 9216, 4474, 4451, 4530, 9222, 3854, 5462, 3860, 
           9228, 4536, 6898, 6748, 6883, 6877, 7334, 6586, 3848, 7488, 7482, 
           8942, 8936, 5955, 8924, 8930, 7464, 7470, 7476, 6580, 9124, 5812, 
           9118, 5818, 6036, 6030, 3570, 9187, 5603, 5597, 9024, 5742, 9006, 
           9018, 9012, 3956, 6448, 6454, 5969, 5963, 6526, 5357, 5455, 9683, 
           5448, 6024, 3564, 9181, 5577, 3980, 8458, 5299, 8451, 5292, 5591, 
           9698, 5584}],
          RowBox[{"-", "3.1`"}]],
         Annotation[#, -3.1, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{4206, 7590, 9259, 9256, 8816, 9264, 4374, 9743, 7593, 7596,
            7599, 6688, 6691, 5906, 9726, 5903, 7373, 3962, 9737, 9740, 9734, 
           6841, 6835, 4402, 9788, 6838, 7391, 8854, 8857, 6773, 6770, 3872, 
           6597, 5617, 8883, 5620, 6045, 6042, 3584, 9194, 5614, 5363, 7519, 
           7522, 7525, 8696, 8693, 3965, 8978, 5723, 8975, 5726, 6631, 6628, 
           7534, 7531, 7528, 8972, 8969, 4436, 7688, 4439, 7691, 8839, 3869, 
           5496, 3866, 9234, 4542, 6083, 6080, 3539, 5934, 5524, 8845, 8851, 
           8848, 8997, 3972, 8988, 8991, 8985, 5734, 8994, 5729, 6634, 7571, 
           7568, 5732, 8982, 5919, 6445, 5321, 5982, 6779, 3912, 7312, 3914, 
           6782, 6016, 4416, 6573, 4414, 7330, 7332, 6857, 7328, 7326, 6018, 
           7457, 7456, 7743, 4503, 9284, 7517, 9747, 9786, 6783, 7740, 7741, 
           7742, 7739, 7454, 7455, 6017, 6570, 5569, 6571, 6013, 3841, 6765, 
           6766, 7609, 7608, 7324, 8866, 5558, 8865, 5557, 5693, 9695, 5556, 
           8889, 5624, 8886, 8888, 8887, 3588, 5701, 8911, 8913, 8912, 5698, 
           5700, 9711, 5699, 3326, 9171, 4354, 3820, 7703, 7704, 7700, 7702, 
           7701, 3555, 7640, 7641, 7639, 4408, 7642, 8463, 8464, 5304, 3836, 
           9215, 4473, 4450, 4529, 9221, 3853, 5461, 3859, 9227, 4535, 6897, 
           6747, 6882, 6876, 7333, 6585, 3847, 7487, 7481, 8941, 8935, 5954, 
           8923, 8929, 7463, 7469, 7475, 6579, 9123, 5811, 9117, 5817, 6035, 
           6029, 3569, 9186, 5602, 5596, 9023, 5741, 9005, 9017, 9011, 3955, 
           6447, 6453, 5968, 5962, 6525, 5356, 5454, 9682, 5447, 6023, 3563, 
           9180, 5576, 3979, 8457, 5298, 8450, 5291, 5590, 9697, 5583}],
          RowBox[{"-", "3.41`"}]],
         Annotation[#, -3.41, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{4205, 7589, 9258, 9255, 8815, 9263, 4373, 9742, 7592, 7595,
            7598, 6687, 6690, 5905, 9725, 5902, 7372, 3961, 9736, 9739, 9733, 
           6840, 6834, 4401, 9787, 6837, 7390, 8853, 8856, 6772, 6769, 3871, 
           6596, 5616, 8882, 5619, 6044, 6041, 3583, 9193, 5613, 5362, 7518, 
           7521, 7524, 8695, 8692, 3964, 8977, 5722, 8974, 5725, 6630, 6627, 
           7533, 7530, 7527, 8971, 8968, 4435, 7687, 4438, 7690, 8838, 3868, 
           5495, 3865, 9233, 4541, 6082, 6079, 3538, 5933, 5523, 8844, 8850, 
           8847, 8996, 3971, 8987, 8990, 8984, 5733, 8993, 5728, 6633, 7570, 
           7567, 5731, 8981, 5918, 6444, 5320, 5981, 6778, 3911, 7311, 3913, 
           6781, 6015, 4415, 6572, 4413, 7329, 7331, 6856, 7327, 6854, 6855, 
           6743, 6744, 3591, 7235, 5895, 9723, 5896, 5894, 5898, 9724, 5897, 
           6564, 6562, 6563, 5714, 8960, 8962, 8961, 3590, 6558, 5521, 8842, 
           5522, 8843, 4400, 6000, 5612, 8881, 5610, 8880, 5611, 6595, 6594, 
           3582, 9192, 5823, 5519, 6556, 6554, 6555, 5609, 6693, 6694, 5916, 
           3322, 6593, 3321, 5915, 5802, 9109, 5801, 6655, 3575, 9162, 9163, 
           9161, 9165, 9164, 4407, 6846, 4406, 6847, 7355, 9169, 3320, 7356, 
           3317, 9167, 5793, 6553, 6552, 4204, 9254, 5788, 6791, 6446, 5460, 
           6531, 6524, 5355, 5453, 9681, 5446, 6022, 3562, 9179, 5575, 3978, 
           8456, 5297, 8449, 5290, 5589, 9696, 5582}],
          RowBox[{"-", "3.7199999999999998`"}]],
         Annotation[#, -3.7199999999999998`, "Tooltip"]& ]}, {}, {}}}],
    AspectRatio->1,
    Frame->True,
    PlotRange->{{-3, 3}, {-3, 3}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{390, 185},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->73949602]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8300],

Cell["Compose with inverse function:", "ExampleText",
 CellID->196753002],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"InverseJacobiDS", "[", 
    RowBox[{
     RowBox[{"JacobiDS", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], ",", 
   RowBox[{"JacobiDS", "[", 
    RowBox[{
     RowBox[{"InverseJacobiDS", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5296189],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"InverseJacobiDS", "[", 
    RowBox[{
     RowBox[{"JacobiDS", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], ",", "z"}], 
  "}"}]], "Output",
 ImageSize->{269, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->75441682]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " to disregard multivaluedness of the inverse function:"
}], "ExampleText",
 CellID->785308763],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->81233632],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", "z"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->301115029]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->390870124],

Cell[TextData[{
 "Differentiate",
 Cell[BoxData[
  RowBox[{" ", "InverseJacobiDS"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->715886131],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"InverseJacobiDS", "[", 
     RowBox[{"z", ",", "m"}], "]"}], ",", "z"}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->809586479],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"JacobiNC", "[", 
    RowBox[{
     RowBox[{"InverseJacobiDS", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], 
   RowBox[{"m", "+", 
    SuperscriptBox["z", "2"]}]]}]], "Output",
 ImageSize->{249, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->74697067]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"InverseJacobiDS", "[", 
     RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->192074691],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", "m"}]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"EllipticE", "[", 
      RowBox[{
       RowBox[{"JacobiAmplitude", "[", 
        RowBox[{
         RowBox[{"InverseJacobiDS", "[", 
          RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], ",", "m"}], 
      "]"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
      RowBox[{"InverseJacobiDS", "[", 
       RowBox[{"z", ",", "m"}], "]"}]}], "-", 
     FractionBox[
      RowBox[{"m", " ", "z", " ", 
       RowBox[{"JacobiNC", "[", 
        RowBox[{
         RowBox[{"InverseJacobiDS", "[", 
          RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}]}], 
      RowBox[{"m", "+", 
       SuperscriptBox["z", "2"]}]]}], ")"}]}]}]], "Output",
 ImageSize->{504, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->249438699]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20875427],

Cell[TextData[{
 "Obtain",
 Cell[BoxData[
  RowBox[{" ", "InverseJacobiDS"}]], "InlineFormula"],
 " from solving equations containing elliptic functions:"
}], "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->322808586],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"JacobiDS", "[", 
       RowBox[{"x", ",", "m"}], "]"}], "2"], "+", 
     RowBox[{"2", 
      RowBox[{"JacobiDS", "[", 
       RowBox[{"x", ",", "m"}], "]"}]}]}], "==", "a"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->554970152],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->333102073],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      RowBox[{"InverseJacobiDS", "[", 
       RowBox[{
        RowBox[{"1", "-", 
         SqrtBox[
          RowBox[{"1", "+", "a"}]]}], ",", "m"}], "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      RowBox[{"InverseJacobiDS", "[", 
       RowBox[{
        RowBox[{"1", "+", 
         SqrtBox[
          RowBox[{"1", "+", "a"}]]}], ",", "m"}], "]"}]}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{520, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->201061828]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22981],

Cell["\<\
Machine-precision input is insufficient to get a correct answer:\
\>", "ExampleText",
 CellID->3979231],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiDS", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"10.", "^", "5"}]}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->563558634],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->478779260]
}, Open  ]],

Cell["With exact input, the answer is correct:", "ExampleText",
 CellID->260060486],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"InverseJacobiDS", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"10", "^", "5"}]}], ",", "2"}], "]"}], ",", "50"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->289346646],

Cell[BoxData["1.\
3110217060782482165338710747419267324690077567971982266157098567088`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->183928292]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3446],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiDS",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiDS"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseJacobiDC",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseJacobiDC"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseJacobiDN",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseJacobiDN"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26254]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21057],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "Tutorials",
 CellID->24592]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->339207203],

Cell[TextData[ButtonBox["Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticFunctions"]], "MoreAbout",
 CellID->368405459]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InverseJacobiDS - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 50, 22.9016562}", "context" -> "System`", 
    "keywords" -> {"inverse Jacobi", "inverse Jacobi elliptic function ds"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "InverseJacobiDS[v, m] gives the inverse Jacobi elliptic function ds -1 \
(v \\[VerticalSeparator] m).", "synonyms" -> {"inverse Jacobi DS"}, "title" -> 
    "InverseJacobiDS", "type" -> "Symbol", "uri" -> "ref/InverseJacobiDS"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6436, 226, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->160925632]},
 "XRef-2005-4-26-23-37-1.8558342"->{
  Cell[609343, 10713, 192, 7, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342",
   CellID->715886131],
  Cell[611634, 10805, 238, 7, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342",
   CellID->322808586]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 618074, 11040},
 {"XRef-2005-4-26-23-37-1.8558342", 618231, 11044}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2058, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2681, 79, 52, 1, 70, "ObjectName",
 CellID->3578],
Cell[2736, 82, 778, 25, 70, "Usage",
 CellID->5656]
}, Open  ]],
Cell[CellGroupData[{
Cell[3551, 112, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4029, 129, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4152, 135, 533, 21, 70, "Notes",
 CellID->11362],
Cell[4688, 158, 876, 30, 70, "Notes",
 CellID->461907696],
Cell[5567, 190, 114, 3, 70, "Notes",
 CellID->18694],
Cell[5684, 195, 262, 8, 70, "Notes",
 CellID->163373648],
Cell[5949, 205, 232, 7, 70, "Notes",
 CellID->31226],
Cell[6184, 214, 215, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6436, 226, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->160925632],
Cell[CellGroupData[{
Cell[6821, 240, 147, 5, 70, "ExampleSection",
 CellID->39610659],
Cell[6971, 247, 64, 1, 70, "ExampleText",
 CellID->125373990],
Cell[CellGroupData[{
Cell[7060, 252, 138, 4, 28, "Input",
 CellID->434514784],
Cell[7201, 258, 176, 5, 36, "Output",
 CellID->254109312]
}, Open  ]],
Cell[CellGroupData[{
Cell[7414, 268, 128, 4, 28, "Input",
 CellID->33244989],
Cell[7545, 274, 175, 5, 36, "Output",
 CellID->90261202]
}, Open  ]],
Cell[7735, 282, 125, 3, 70, "ExampleDelimiter",
 CellID->452968241],
Cell[CellGroupData[{
Cell[7885, 289, 297, 10, 28, "Input",
 CellID->471471100],
Cell[8185, 301, 2274, 41, 133, "Output",
 Evaluatable->False,
 CellID->497848107]
}, Open  ]],
Cell[10474, 345, 125, 3, 70, "ExampleDelimiter",
 CellID->391202108],
Cell[10602, 350, 60, 1, 70, "ExampleText",
 CellID->576334791],
Cell[CellGroupData[{
Cell[10687, 355, 251, 8, 70, "Input",
 CellID->40049435],
Cell[10941, 365, 1762, 56, 86, "Output",
 CellID->189197912]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12752, 427, 216, 7, 70, "ExampleSection",
 CellID->12793],
Cell[12971, 436, 73, 1, 70, "ExampleText",
 CellID->55645938],
Cell[CellGroupData[{
Cell[13069, 441, 208, 7, 70, "Input",
 CellID->266251706],
Cell[13280, 450, 273, 7, 36, "Output",
 CellID->102277232]
}, Open  ]],
Cell[13568, 460, 125, 3, 70, "ExampleDelimiter",
 CellID->268824359],
Cell[13696, 465, 70, 1, 70, "ExampleText",
 CellID->132691703],
Cell[CellGroupData[{
Cell[13791, 470, 215, 7, 70, "Input",
 CellID->866802414],
Cell[14009, 479, 235, 7, 36, "Output",
 CellID->212904662]
}, Open  ]],
Cell[14259, 489, 124, 3, 70, "ExampleDelimiter",
 CellID->36479535],
Cell[14386, 494, 113, 3, 70, "ExampleText",
 CellID->579439215],
Cell[CellGroupData[{
Cell[14524, 501, 167, 4, 70, "Input",
 CellID->632752147],
Cell[14694, 507, 228, 6, 36, "Output",
 CellID->61060713]
}, Open  ]],
Cell[14937, 516, 125, 3, 70, "ExampleDelimiter",
 CellID->688497564],
Cell[15065, 521, 231, 7, 70, "ExampleText",
 CellID->43876107],
Cell[CellGroupData[{
Cell[15321, 532, 185, 6, 70, "Input",
 CellID->271543877],
Cell[15509, 540, 342, 11, 36, "Output",
 CellID->878473131]
}, Open  ]],
Cell[15866, 554, 125, 3, 70, "ExampleDelimiter",
 CellID->255377976],
Cell[15994, 559, 92, 1, 70, "ExampleText",
 CellID->328717422],
Cell[CellGroupData[{
Cell[16111, 564, 251, 8, 70, "Input",
 CellID->617758456],
Cell[16365, 574, 273, 9, 36, "Output",
 CellID->253698890]
}, Open  ]],
Cell[16653, 586, 90, 1, 70, "ExampleText",
 CellID->368884824],
Cell[CellGroupData[{
Cell[16768, 591, 153, 5, 70, "Input",
 CellID->508781695],
Cell[16924, 598, 242, 8, 36, "Output",
 CellID->141287473]
}, Open  ]],
Cell[17181, 609, 124, 3, 70, "ExampleDelimiter",
 CellID->23210608],
Cell[17308, 614, 203, 7, 70, "ExampleText",
 CellID->471035179],
Cell[CellGroupData[{
Cell[17536, 625, 173, 5, 70, "Input",
 CellID->179888293],
Cell[17712, 632, 321, 11, 52, "Output",
 CellID->1659560]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18082, 649, 238, 7, 70, "ExampleSection",
 CellID->6058],
Cell[18323, 658, 225, 7, 70, "ExampleText",
 CellID->120235099],
Cell[CellGroupData[{
Cell[18573, 669, 311, 11, 70, "Input",
 CellID->77454719],
Cell[18887, 682, 3539, 107, 170, "Output",
 CellID->72588153]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22475, 795, 223, 7, 70, "ExampleSection",
 CellID->12314],
Cell[22701, 804, 123, 3, 70, "ExampleText",
 CellID->147991225],
Cell[CellGroupData[{
Cell[22849, 811, 716, 23, 70, "Input",
 CellID->41283476],
Cell[23568, 836, 583931, 9796, 70, "Output",
 CellID->73949602]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[607548, 10638, 232, 7, 70, "ExampleSection",
 CellID->8300],
Cell[607783, 10647, 73, 1, 70, "ExampleText",
 CellID->196753002],
Cell[CellGroupData[{
Cell[607881, 10652, 379, 12, 70, "Input",
 CellID->5296189],
Cell[608263, 10666, 339, 12, 36, "Output",
 CellID->75441682]
}, Open  ]],
Cell[608617, 10681, 246, 8, 70, "ExampleText",
 CellID->785308763],
Cell[CellGroupData[{
Cell[608888, 10693, 106, 3, 70, "Input",
 CellID->81233632],
Cell[608997, 10698, 203, 7, 36, "Output",
 CellID->301115029]
}, Open  ]],
Cell[609215, 10708, 125, 3, 70, "ExampleDelimiter",
 CellID->390870124],
Cell[609343, 10713, 192, 7, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->715886131],
Cell[CellGroupData[{
Cell[609560, 10724, 225, 8, 70, "Input",
 CellID->809586479],
Cell[609788, 10734, 379, 13, 52, "Output",
 CellID->74697067]
}, Open  ]],
Cell[CellGroupData[{
Cell[610204, 10752, 225, 8, 70, "Input",
 CellID->192074691],
Cell[610432, 10762, 1060, 35, 84, "Output",
 CellID->249438699]
}, Open  ]],
Cell[611507, 10800, 124, 3, 70, "ExampleDelimiter",
 CellID->20875427],
Cell[611634, 10805, 238, 7, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->322808586],
Cell[CellGroupData[{
Cell[611897, 10816, 359, 13, 70, "Input",
 CellID->554970152],
Cell[612259, 10831, 453, 8, 70, "Message",
 CellID->333102073],
Cell[612715, 10841, 665, 24, 43, "Output",
 CellID->201061828]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[613429, 10871, 226, 7, 70, "ExampleSection",
 CellID->22981],
Cell[613658, 10880, 113, 3, 70, "ExampleText",
 CellID->3979231],
Cell[CellGroupData[{
Cell[613796, 10887, 185, 6, 70, "Input",
 CellID->563558634],
Cell[613984, 10895, 170, 5, 36, "Output",
 CellID->478779260]
}, Open  ]],
Cell[614169, 10903, 83, 1, 70, "ExampleText",
 CellID->260060486],
Cell[CellGroupData[{
Cell[614277, 10908, 246, 9, 70, "Input",
 CellID->289346646],
Cell[614526, 10919, 235, 7, 36, "Output",
 CellID->183928292]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[614822, 10933, 310, 9, 70, "SeeAlsoSection",
 CellID->3446],
Cell[615135, 10944, 724, 26, 70, "SeeAlso",
 CellID->26254]
}, Open  ]],
Cell[CellGroupData[{
Cell[615896, 10975, 314, 9, 70, "TutorialsSection",
 CellID->21057],
Cell[616213, 10986, 192, 4, 70, "Tutorials",
 CellID->24592]
}, Open  ]],
Cell[CellGroupData[{
Cell[616442, 10995, 319, 9, 70, "MoreAboutSection",
 CellID->339207203],
Cell[616764, 11006, 147, 3, 70, "MoreAbout",
 CellID->368405459]
}, Open  ]],
Cell[616926, 11012, 27, 0, 70, "History"],
Cell[616956, 11014, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

