(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    680978,      12192]
NotebookOptionsPosition[    672072,      11886]
NotebookOutlinePosition[    673721,      11930]
CellTagsIndexPosition[    673581,      11924]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals and Elliptic Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals and Elliptic Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"JacobiSC" :> Documentation`HelpLookup["paclet:ref/JacobiSC"], 
          "InverseJacobiSD" :> 
          Documentation`HelpLookup["paclet:ref/InverseJacobiSD"], 
          "InverseJacobiSN" :> 
          Documentation`HelpLookup["paclet:ref/InverseJacobiSN"], 
          "InverseJacobiDC" :> 
          Documentation`HelpLookup["paclet:ref/InverseJacobiDC"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"JacobiSC\"\>", 
       2->"\<\"InverseJacobiSD\"\>", 3->"\<\"InverseJacobiSN\"\>", 
       4->"\<\"InverseJacobiDC\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Functions" :> 
          Documentation`HelpLookup["paclet:guide/EllipticFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Elliptic Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InverseJacobiSC", "ObjectName",
 CellID->3062],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InverseJacobiSC",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InverseJacobiSC"], "[", 
       RowBox[{
        StyleBox["v", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the inverse Jacobi elliptic function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox["sc", 
         RowBox[{"-", "1"}]], "(", 
        RowBox[{"v", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
      "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14981]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["sc", 
     RowBox[{"-", "1"}]], "(", 
    RowBox[{"v", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " gives the value of ",
 Cell[BoxData[
  FormBox[
   StyleBox["u", "TI"], TraditionalForm]], "InlineFormula"],
 " for which ",
 Cell[BoxData[
  FormBox[
   RowBox[{"v", "=", 
    RowBox[{"sc", "(", 
     RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->20276],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseJacobiSC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiSC"]], "InlineFormula"],
 " has branch cut discontinuities in the complex ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " plane with branch points at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[PlusMinus]", "\[ImaginaryI]"}], ",", 
    RowBox[{
     RowBox[{"\[PlusMinus]", "1"}], "/", 
     SqrtBox[
      RowBox[{"m", "-", "1"}]]}]}], TraditionalForm]], "InlineMath"],
 " and infinity, and in the complex ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " plane with branch points at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "+", 
    SuperscriptBox["z", 
     RowBox[{"-", "2"}]]}], TraditionalForm]], "InlineMath"],
 " and infinity."
}], "Notes",
 CellID->17076495],

Cell["\<\
The inverse Jacobi elliptic functions are related to elliptic integrals. \
\>", "Notes",
 CellID->28289],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["InverseJacobiSC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiSC"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->851816954],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseJacobiSC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiSC"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseJacobiSC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiSC"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->49381918],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->373519508],

Cell["Evaluate numerically:", "ExampleText",
 CellID->705017992],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiSC", "[", 
  RowBox[{"3.5", ",", "0.3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->151794200],

Cell[BoxData[
 RowBox[{"1.3830436305000104`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{91, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->814232634]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiSC", "[", 
  RowBox[{"%", ",", "0.3"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->327044294],

Cell[BoxData["3.4999999999999973`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->6759144]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->615017572],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"InverseJacobiSC", "[", 
    RowBox[{"x", ",", 
     RowBox[{"1", "/", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->141027997],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5355588]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->526408911],

Cell["Series expansions:", "ExampleText",
 CellID->52392619],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"InverseJacobiSC", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "7"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->648348344],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"z", "+", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "+", "m"}], ")"}], " ", 
    SuperscriptBox["z", "3"]}], "+", 
   RowBox[{
    FractionBox["1", "40"], " ", 
    RowBox[{"(", 
     RowBox[{"8", "-", 
      RowBox[{"8", " ", "m"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["m", "2"]}]}], ")"}], " ", 
    SuperscriptBox["z", "5"]}], "+", 
   RowBox[{
    FractionBox["1", "112"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "16"}], "+", 
      RowBox[{"24", " ", "m"}], "-", 
      RowBox[{"18", " ", 
       SuperscriptBox["m", "2"]}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["m", "3"]}]}], ")"}], " ", 
    SuperscriptBox["z", "7"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "8"],
    SeriesData[$CellContext`z, 0, {}, 1, 8, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   1, 0, Rational[1, 6] (-2 + $CellContext`m), 0, 
    Rational[1, 40] (8 - 8 $CellContext`m + 3 $CellContext`m^2), 0, 
    Rational[1, 112] (-16 + 24 $CellContext`m - 18 $CellContext`m^2 + 
     5 $CellContext`m^3)}, 1, 8, 1],
  Editable->False]], "Output",
 ImageSize->{489, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->823460035]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"InverseJacobiSC", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->423922134],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"ArcTan", "[", "z", "]"}], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "z"}], "+", 
       RowBox[{"ArcTan", "[", "z", "]"}], "+", 
       RowBox[{
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"ArcTan", "[", "z", "]"}]}]}], ")"}], " ", "m"}], 
    RowBox[{"4", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["z", "2"]}], ")"}]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "m", "]"}], "2"],
    SeriesData[$CellContext`m, 0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`m, 0, {
    ArcTan[$CellContext`z], 
    Rational[1, 4] (1 + $CellContext`z^2)^(-1) (-$CellContext`z + 
     ArcTan[$CellContext`z] + $CellContext`z^2 ArcTan[$CellContext`z])}, 0, 2,
    1],
  Editable->False]], "Output",
 ImageSize->{336, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->97302418]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5772],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->509366112],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiSC", "[", 
  RowBox[{
   RowBox[{"1.2", "+", 
    RowBox[{"0.3", "I"}]}], ",", 
   RowBox[{"1.5", "-", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->261814282],

Cell[BoxData[
 RowBox[{"1.1076677535845447`", "\[InvisibleSpace]", "-", 
  RowBox[{"0.11558051171577473`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->324984126]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->167176234],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->271907475],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"InverseJacobiSC", "[", 
    RowBox[{"3", ",", 
     RowBox[{"1", "/", "2"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->156064659],

Cell[BoxData[
 RowBox[{"1.\
4064119939931454762424804332354813869497562233184484691505658391065`50.\
15051499783199", "+", 
  RowBox[{"0``50.00240243638868", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{447, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->548708064]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->93714622],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->213315987],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiSC", "[", 
  RowBox[{"3", ",", "0.5000000000000000000000000000000000"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->67253859],

Cell[BoxData["1.406411993993145476242480433235481391954187804466`32.\
357391310949104"], "Output",
 ImageSize->{242, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->171198811]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->401201374],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseJacobiSC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiSC"]], "InlineFormula"],
 " threads element\[Hyphen]wise over lists:"
}], "ExampleText",
 CellID->367335492],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiSC", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"z1", ",", "z2"}], "}"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->212944832],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"InverseJacobiSC", "[", 
    RowBox[{"z1", ",", "m"}], "]"}], ",", 
   RowBox[{"InverseJacobiSC", "[", 
    RowBox[{"z2", ",", "m"}], "]"}]}], "}"}]], "Output",
 ImageSize->{332, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->33690680]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->147858719],

Cell["Simple exact results are generated automatically:", "ExampleText",
 CellID->98266840],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"InverseJacobiSC", "[", 
    RowBox[{"z", ",", "0"}], "]"}], ",", 
   RowBox[{"InverseJacobiSC", "[", 
    RowBox[{"z", ",", "1"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20890801],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ArcTan", "[", "z", "]"}], ",", 
   RowBox[{"ArcSinh", "[", "z", "]"}]}], "}"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->274875174]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"InverseJacobiSC", "[", 
    RowBox[{"0", ",", "m"}], "]"}], ",", 
   RowBox[{"InverseJacobiSC", "[", 
    RowBox[{"Infinity", ",", "m"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->211875868],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"EllipticK", "[", "m", "]"}]}], "}"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1071452310]
}, Open  ]],

Cell["Parity transformation is automatically applied:", "ExampleText",
 CellID->328138587],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiSC", "[", 
  RowBox[{
   RowBox[{"-", "z"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->291795526],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"InverseJacobiSC", "[", 
   RowBox[{"z", ",", "m"}], "]"}]}]], "Output",
 ImageSize->{156, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->386017234]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->414636117],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->211330550],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseJacobiSC", "[", 
   RowBox[{"z", ",", "m"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5847741],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["sc", 
    RowBox[{"-", "1"}]], "(", 
   RowBox[{"z", "\[VerticalSeparator]", "m"}], ")"}], 
  TraditionalForm]], "Output",
 ImageSize->{58, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->44330635]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31171],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseJacobiSC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiSC"]], "InlineFormula"],
 " can be applied to a power series:"
}], "ExampleText",
 CellID->364782583],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiSC", "[", 
  RowBox[{"x", ",", 
   RowBox[{
    RowBox[{"Exp", "[", "m", "]"}], "+", 
    RowBox[{
     RowBox[{"O", "[", "m", "]"}], "^", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->313682697],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"ArcSinh", "[", "x", "]"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"ArcSinh", "[", "x", "]"}], "4"]}], "+", 
      RowBox[{
       FractionBox["1", "8"], " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{"2", " ", 
         RowBox[{"ArcSinh", "[", "x", "]"}]}], "]"}]}]}], ")"}], " ", "m"}], 
   "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "m", "]"}], "2"],
    SeriesData[$CellContext`m, 0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`m, 0, {
    ArcSinh[$CellContext`x], Rational[-1, 4] ArcSinh[$CellContext`x] + 
    Rational[1, 8] Sinh[2 ArcSinh[$CellContext`x]]}, 0, 2, 1],
  Editable->False]], "Output",
 ImageSize->{388, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->499707855]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14468],

Cell["\<\
Plot contours of constant real and imaginary parts in the complex plane:\
\>", "ExampleText",
 CellID->147991225],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ContourPlot", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"InverseJacobiSC", "[", 
       RowBox[{
        RowBox[{"x", "+", 
         RowBox[{"I", " ", "y"}]}], ",", 
        RowBox[{"1", "+", "I"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
     RowBox[{"Contours", "\[Rule]", "24"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{"Re", ",", "Im"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41283476],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyMnXmcj9X7/2fMYkuJSouUNZVKoSzpvFHZd5VdoghJCUVC2cuayJYlS1LI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     "], {{
       {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
        GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1l1lslVUUhU8Hett7gUIHhDJICy3UtswBhBd4UFARjFolGkiAFoiKRGOk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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwllW1M1XUUxw8X8V6414R7L4Q8KODlovKgFzYofYMvSrQCZxGshpsPKavU
zVBEHWhZ9qaGlthsjNUi25xu+sbyoUg3y2orS6LU3rlayXThA9mL7HP2fXG2
3///+/3O+Z7v+Z7zK129acXGgJn1YVOwdyrN9mOf8PN4ltnZlNnBQrOBDLPn
ImZp+WYp/t3i+1a62dZizs42ezVodod/1Qmzc3GznpDZB/w7P9fsV6xvqtkb
aWYrWB/Bx8uZZi9hzxDrwsNm98Jmm4l3rMSsK2b2B76OcefnOrNEttla/F2f
ZhZPmuVihXz/h7+L3F1VrNgeI7HA7Ldcs33468f24utyjVkn+4fJ6YUKs2bs
UdYfge8Cuc0B/2LWffy7McvsQI7Za5DRi7/qArORPLP3iPcQPu6S+072vwHr
WvjYDN6qAu0Ncf5mtVkrMQs430b8LGKPTje7D1cdfN8ug7dys2nsbyBef6nZ
d/j4lLuXsF/YmzsHbCGdOUPuj+BjJXefjwjLMvCuDApTiLMD4Bkk/kG+22eY
RWrN1nG2MyJfjtmxus8fiN8A50+BPxsfLWD9C8zbuL8LPI3c76CGH7K3PiJs
8/E/kiWMb4Gnl39HWa+Hox7wL42anWD9Nf/a8LURm+T8PexckdmVImklnXr9
BBdt1OhQWJyvAU8xOf/IepL766jd7gqtH4Cnhb0u/Fez/htbDfZVlcK6C/91
7O+Dj4mp8nGb2KU14nqQM0OcHU1Ju9vAWI9WtpDD6SxpeAn5h9FTFG6e5s7r
3F8Wlba8hhH2qqvMvuV8jO/B+WYlYJwMqKbOtXPmXDnnheh1B3iSaLUceyUm
TbuWfydeCbk1wkcTvbYjpFrUY09mqSYHiB1n/35AGl2KryasI6iav4nWtpeK
6y8i6r3D2O6gevB8vnrMe2uD91dMmnQtegzP/Qlyqg+Jg2b4W45dC4rjxAxp
zrXWA18PwNZOzntcu+w3kPsi6rc/LA7eRivdCfXSMFYDV1v4PpsmzsZrhdmx
fo41c793pmr7T0DaGYmrtq6h5VH1lPfSqSnq5eGEfHtPe62dY+fWa/448drB
8z57dwPq3Wedw4B6+E6uZoLPAse8iVwyc3X2RIa0eHm6tOSaPFkpzbhWXPOj
xBqr0+xxjlKsF2VrlnmNh7PFmXPViaUVSlOuJe+psXlmFfhfSL3Hwfsitfmy
WL3gM/BarnL2XDPTNev+Rb/dYc28FHev5mrPc5qgdleSmh0+Y6vonzjWmK4Z
573XgMZ2htSD7qs8W7PcfX6Fv9ZKzdobYMrk7NW4tLgdi3kvJLXnM7aW80vK
lJtrtsz1QT9d5LvbH4x8ady1fRMMi+G3JypuXTN5VdKQa8dn5kCJNOra9BnS
nqeZ4bPCa+hvwfgszV5/E5pyNKN9Nh+Bs5Ya9bj3ts/EQrTbz3dGWD3QRa6f
obmTaO1dzh9Ha4dmSms+Ix9L6I3yt8ln3J/ET9RqVjqH3ntn2P84qB7cWyAN
u3a9hkPkOl6jXP2NHJutmB7L3yx/K6/mazb6mzkRF8fOrdckBbcLksrFe7oI
/N+XaRZfCqp3tiakFe+h08Q+VSuur8PZQvDsmae157gGX3VJvW3e0z7LmmKa
VT7TWqOK4b6do6M5ejP8rfAc/wcUTi4J
           "],
           VertexColors->None]}]}, 
       {RGBColor[
        0.33193700324150577`, 0.12438202146215689`, 0.5835579300576339], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmG1s1eUZxp9zyunL6TktlIJwaK3l0OIohZaasS28aCEBBNfyLpvJNkfC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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3ts1fUZxr8tF9vTlpbSQy+0hdN7Lac9vUTYdArMUaaFMlek3cVN7CSB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           "],
           VertexColors->None], PolygonBox[{{5058, 7678, 1546, 7696, 5057}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.36456689527554076`, 0.1811165915174827, 0.6294231906477145], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1mHts19UZxg+Xlra/S6FAS2mhUqSU/mjLfYs6oAJORScThhk4MNs0i5oh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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHtwVdUVxncID5MAIcANNwkkcENCyM07cQAHVHDKQ6XQClawBUd5jVCC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           "],
           VertexColors->None], 
          PolygonBox[{{6986, 5743, 1579, 7951, 6985}, {12280, 5572, 5571, 
           9657, 2049}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.3971967873095758, 0.23785116157280867`, 0.6752884512377951], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmH2Q1lUVxy/7+uw+++yzsLALK+sDy76yPOwLoFDKP06TYIBJ4EyoTbma
qaPEm6JQM2aKYKXyYmVTWShiQES8zFiYTUADKbiAmmM4NSM6ppNTAzmjMPX9
8D07zDx3fve5v3vPPefc7/mec3/jv3b3dXeVpJT+NSylUj3fqU3pD2rZypTe
HpPSwPiUdpaltEXvP1S7Vu1TvTundkr9R5pSWlNMqbc8pQNat1vj70vgBy0p
vTQipavVv1vrV2n8J5q/pyul5ZK7RmO/0rqtalXZlM63prRf4xs1flaKrNT8
1Vp7tial+6TXHWrzKlJapndL1DblpJue92t8rNYc0dxPJP+I5uzV/z1qmzJ6
hp4LSy3jBrUxeveQ/ncPs46fb7SeZbKhUc9VmvM56f9MZ0ofSd5qtW9LzoOa
P6g5q6Nfr3nNmi8RaZvs2KGWky2/0fO3asPVXz8lpb81pDRJ+70q/zxe4j2Q
sSrkDFTJjvDP0onyo/R5XfPfKPX4d4b5yX/m3N2b0jfVfib5Op7UKnnj9OzR
nMN6P1nttPaaovlderdJdtwkuTmNL58gH6rdV+m2MuTPkKzL1W7V/wHZeFmp
5XLO+BEfLpeMFWqD0ve89junVpeMG3yBH/Klxgfzj1V57hn5u0o4OdcvH6h/
neSdqLIti+Jsb1eb2p1SiWzvKfH+PHs0fpn0ukTrZut/XnbVqs1Sf6DTOOPs
XpNebXnN1fxG+fwv6n+k/sfCz39r4nz7UnpM8k9LXoMUPtmmvTX+Tiaemn9U
8p6V3CtKjfmTavqlL8ln8yfYP+1Z6/0FfC5sVFandEj6PTs6pWuE71tkW7P2
Pz7R7yrxk9Zoanqm3LqDATD1rcAAmF2Xsf/69OxVe6LE58mTM90ivfZL/zMZ
x9mjGccaMg6VWA599t+m/4Py0y9KjLkhO8HA2JzXITs/Unq3O37QbX619VtZ
SOkz2uuLFfYXa/HPl7Oeh8yO8os6Tsr7DPA/8UvsslevzrRPrUX/P1WMf9Lq
mNymfXoy1u94rc+YPpiCY+CkKd3GBDiYq/N6rc1y9xQdY8RXjWQcq7R9Hwhf
Pe32386iY5J43NMh/3bYv81Zn9uVakuk76VNxinYnJU3Pk81OG6J2evlq4U5
x/niMnMZuH2q3ByGH+GIrkr7h7OhD35uzHmfyWpfUf+mnG0B+wOB/w3l5lf8
/3Ptf0W3z2CunvPU7lB/uHDX0u74zmQda2XEnPD8p+AK9mQuOrwnf76r9pz2
O1hrXj6hfm3GMsBSc8444P9/5Kd/F322C3LmkuHBK8Qf//8hn9wnzpkGPmXv
n6VAn/rHMpaLzDbt06r2U8kpJK/F9pHEW7oYB6OSYwHMg3e4okXr1leby8HH
7uCQutgfeR2aK3OTtks1kiPoJrkvHb4kpbc6fCbLpeMytV9mjY+62Juz+l2F
sbpdthbyXg//3VxlXG1W/M7q8v8GvR+VN492iWRHqr2k9bu0dlzeNvxe/cdE
egXtMTdn3sOe9VnbQr+/1H6SeulgmW1Af211YRx7VuicV3Z7TWPYyfvqrDHI
eWMPfkfei+rvzzr/8SSPkQc584bQmYb+7MuTcXL6RuF8g9o6ceJfK/2O8V3a
5P7x5g3y7P8i186cKgxPdU2wUTZuyEUuLXHcgbcfSfcfq+2T/q8obl5We17z
DhCD8k9n1vmL9+QaYgwZ5GJ06A//bM8Zs8TOy+LhV1qcv94qc86nDmBP4o19
d+S8hv9HM8YiOKQeeSRqkpGK76f6LWO/gHSw0fl8KzxRdL2xVs+14107VGhN
udrDUR88FDXG1xVrC0a7drhaMm7p9Lu1wtqjvT4TdMRn5DJkna82xmcLU8+M
dsxv0NxZjZbfGjka2wfls8nt5v3psml65OKFo703+75ZYd2oU1p0bnPavJ75
8Cn8CR/PjnzROpRHk/f8Rqf3hdORhZySyNvE+zz54NIRrqMeqLUN1FETtNcL
RcsiVy8JG881S1a9ayI4FW6dk1wnbom8uTpyD7lgcbU5lDqGfH40zmtFzmNg
g3iG48oiNs/GODViJmK+Qn5qrDfvwAO5GD8q/RvGmKMrgiOQR6w/X/Qc8A7m
8PnJ0JNaBhk1wU2j4IzgDWrSsnHGCftXBf9uiVqYfLVUc/ZNNL/ADb8uWk5d
cBD9e7od58Q48uFEYh151SGTsVGxbyb+w5lnoibOBR+ei/N6TLh+U5N7te94
7bu76LVw4cBw82FjyGwMfngvanv44N3oE3P0ibXFwuddI5yvz4ed7AffN4Yc
zvnSOOtC9Geqf6/se67dHP79XsfGi8GNjIEr4ouzL6rfVGZcE2fnpM9tfR6j
xmuKcWLu1k7Pu1N67Sv6bMA4csAP/NIR+uzK+j/99hiHZ66a4D2Qu1Hynux0
TbM1Z5/gA2IJ3uwIX50On3QF58BL2Dou5D8uffYX/R8Mc0bk4kWxN/sO6UF8
zAzfUROgV1fMIa/+vcG5FX3eiXOBt+qbzF1vKNZfb3O9cyhqPriaXNsX+eJt
yciO9Z2AGhk/4kPqRLBArUIdTD0Mp+Uke7ES653J8bc4aht4i1ppb9yTWMN8
4ndBjefBC7w/FVxxMme+JW/viXH4iBrvQq2YtR/mBOdvzpr3axSUT7f7TtBR
a7xw//qh9MqOtK3o+3HcA6kF6gL/zwX/U3OejFqHOmeSQPq9XudH8ie1W33U
pcQSZ3Qs7iXEFLGyt8s+olZCDjbs63JsE9c1Ub8Ty5z3rrCFvIg9nBfcC3+D
TfgbXsYHL0z0PRn/1DVZP3Sj5p0edS+1E/c54g6dby633vcKs6ea/B8bHwjd
qNuo3w7HnZdx5GNnadSH4Im7HHmgZqxrOMYmyd/Fdp/NYdn31f6LNejOiNP5
iuUDeZ/50hHOx8QCnAQ3wQNP5523sJn6jTgfuv/RR05dcBi8tEJnck+vzz4T
3Awnk4e4G3MnIo6m1RqPYOlA2Hs27nFgYK/8+WCT7x/gPBdrwcKOwMOyMf7W
sCbW8r0ADFNDra0xnw3VT4xTj1DbkN86QibvRsm+himul3lPDUS8PCGfre+3
LPzHt5KdsdeGmANu0JEzmt3o3P9wxNnKcuepQdmSmnx/hF/ANH6Gk+ACcNWh
tbVN1hE7noxvHzw3xV7T4r5O7G+NOgo/YA98dEPU44WIIeI+3+S12JkLrsjF
/Zr+vQXXT/AP9dzWkImvmUecfla6/UB2/THruAGjnFdv4JU7OLUmuQOfl0V9
Bf/zrIg+d1UwQP98veOf2MeX+BQ74PuKqM3IUb1xr+S+WhsY4K7GHYaaBs7e
HvUkvIXP8f3t4v7bOl1/cCfjnoZv4EfwwnlhM3XwkqiX0Bt7S3TXODbesvrj
LgT/Uk/hA2wiHi6PHEV9tHGsayTweza4d518tqRgmdjJe+7v1zbbfsbw34nw
4YoRvg/3RN6DO/DVkby/dzCH70lgCjn4six8uyl8yFkjj5jCVur9zfXOI+Qi
6nJwMiVqU3yLf7i7krvaZXtLwfPhnubQDT+iE+cyX+S8ot/3WnyKbycH5jgX
8AnnXRb+GRHj8DnfUg7FHYlvEnUjzUnMKQleIy9xv4JnmEvtMzq4He6gVvxu
kzmC2INTyZHM6e923Yx9V4Zu2MW9f6Bg++Ee5JAjqK2uKXiPx+P7SGN8rxgM
rHL2yKdmeLXCNgzd89CPfWcEz2PvjfEdgH1Z1xr1xsG8sQWukHmh3ko+x8H4
bsj5kifJ0eTJjuAoakr4F59wR8X31KsfirOPqT6ZljUeZ4QOfF9gjLjBP21x
Z8dfffHdCRxxTwJLyELmkfimdDy+K52IbwgfxZ2AGIWfuYuQ+7i/cM7Hw1f4
Bf/gG+L0+sAD3zv5lvF64K4tsNcc8cz5D9WFs+IbUUnUAAvi+wxyqM2aoxYl
/+AT6s5F8u09Bes2NmLq/eCwjuCx6eEfdOZeyPdo7O6JGADL3B3/WbBf/g88
xsV2
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHd0l+UVxx8DYWQQAuRHAoSQTUhCJlZQ6BHao0BlOlpo1VMDYkVB9h5H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           "],
           VertexColors->None], 
          PolygonBox[{{4824, 9586, 2043, 9631, 4823}, {7972, 5042, 684, 7970, 
           7971}, {4638, 11586, 11585, 9608, 506}, {4802, 5699, 5698, 9607, 
           2044}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.42982667934361074`, 0.29458573162813445`, 0.7211537118278757], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmGtwldUVhncSEk5yThIINMFMNDdzIfHoCcgo0Fr5QWsil1YsCVZsS8v0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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHl01NUVx59JiCGTMFkniyFhQkImJEOGTAIlKLYVWxI2QUWRuHFAxCoC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           "],
           VertexColors->None], 
          PolygonBox[{{5118, 8089, 1634, 8088, 5117}, {10762, 8197, 8196, 
           6589, 2454}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.4624565713776457, 0.35132030168346023`, 0.7670189724179562], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl1lsVVUUhrf0ljt0koLW1pJKWprbi7fSYhBBDALGiRaos9SpiQ+SWG2i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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXlwl9UVhi8ECCRgSEggBEIkCyS/EExQQQGVKnQUUDarVcGFjhu2IGqx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           "],
           VertexColors->None], 
          PolygonBox[{{8985, 10456, 2304, 6132, 8984}, {7306, 5902, 1595, 
           8023, 7305}, {10437, 7550, 7549, 6132, 2304}, {10757, 8985, 8984, 
           10756, 2451}},
           VertexColors->None]}]}, 
       {RGBColor[0.4950864634116807, 0.4080548717387862, 0.8128842330080369], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl21sleUZxy/bnrb0HNrSU2SUMiqn1PbUlZ5jjB9g0VJCYpwWUBOEsgm4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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXd01+UVxl9DEkYCmUA2hAyy+JGhgAdQAkqPlRXAiii0QouiVFFRlrKi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           "],
           VertexColors->None], 
          PolygonBox[{{5078, 10438, 10437, 10436, 690}, {4142, 9057, 1515, 
           7412, 4141}},
           VertexColors->None]}]}, 
       {RGBColor[0.5277163554457156, 0.4647894417941119, 0.8587494935981175], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVltslFUQHtput9uuXdglbNstbGWXdS/c2vIglpsm+mCC4VIjWIJETQxC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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXmc13Mexz9qpklGzV0z09RUU81RMx2OQlntYh9WVikrUY72Qal133Sp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           "],
           VertexColors->None], 
          PolygonBox[{{7022, 7771, 7770, 5228, 750}, {8161, 7424, 981, 6082, 
           8160}},
           VertexColors->None]}]}, 
       {RGBColor[0.5603462474797507, 0.5215240118494379, 0.9046147541881981], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlmto1XUcxr+6i2eba+wsOLvUpmfueM5ZFi5hpuWGqEEGyTSojCaRboUX
KOqFrkmFkJfZi4JIFHS9KbLSsCxf5N1uLyUqcpPoonSFnBH0pufT84Ne/Dj/
y/f6fJ/vc/6zH90ysHl6RPyoU6HTtyBiX2vEw1UR3Z0RP7VFjOv6yIyIP2oi
iro+U444q/O37ldkIpbpfDUt4om6iOW6vqo4B6v8vl+/p2X7Uquvq+dHzNC5
KtulivmPkp5TAb3NET/f7PutNyiHznXF2iif5/R+QDGb6/18kZ6vkO8J2a7V
+U7v7041fFvrmri+WOHaqGdQcc6rnonKiA2qZ6js+yO5iMMdEcPVETPzEc+0
ROyUzRn5btSz0/rdcVPEPU0RXyjG06phgWrYI5t35HfLHNv1lSIOqIeHFPPZ
QsQh2d+h3HvU9ynluiybXXr+W5Pr69Czos5e1faJMJ6edx8vqP6T091zQe+P
5VwDdb3d4dp2Kk5xgbFep5q2VLveUb3br/vj6n1Vd0RZNpsUrzfjeNv1vL/a
s32wwrNkTmCyXvNYnDG29Eh/YDiY3pO3T76LKu27LNlhAzeItavS2PAc7Pen
Z9Qzpvo/bXNcOLUma169Itxe1hkVbivbxZkm8+Ex1f9rg/EAp552Y1UQnkd7
It6cqTnKZnfBs6ce+Hc18WREdeTq3dO2xBnwok+uf5mn+Dr31/n9SLLBh3uw
eq3V+wBe+MJL4sNJ/MAUPm5Nvl3sTTFiWpVnsa/Gs2ucHZHV+bja/V0uukdy
bkt1Tmr+axqM9wM15uMp+fZWGXuuW+o9T/ZiXJzc1mhst6ZdoTYw31lj3OHE
qzXG7QPhfVE5lirvsVpzkx4XCsOJsneJnbxS5xlntaOncp4jHJxddi+vq/7R
wv+4Lk5xHumKKOW8j3CS3OTtlN/csrGAhwsz3mXy9ybfKfX6bsa8opfliYdr
hdNtijlUYax7k+944m+7fK9IMxY2WzfolbzUeU19bE5Ysbf0AT5gcCxrHOB+
f+L3kHAY1tkhnwvq76zOUMb+xMEXveJ9bpp5zL7Cf3j6563mKrNkf5/XGav1
HOfK5i1x40CrsaGXk2kfq+Z7BifSPsIRZjclnFvbbNctjSnOMafgG/ymLjAd
TfuVLVnLyPehrj8qmQfs1f7ERzCiB+rfoLyrhFtTpWeOnoJnfY2vmSOx4CL1
b662zoHvilkRvzfY/rius9rt9/RuUnVN1LvvOdrXxhsVT88P3R5xX8p1SVwY
7HJ8Zruuy/NFN8kFzw/KflxnVLG+0bwaS7bZ3mHe0+9B4TNSMJ8+qzNu4HdF
nFnS7D7ISZ/kPVGyBjG3C+l/jLnT64u17gVeoY9wi90a6HGuAfVxvuB5o21o
DXyqzFvfL6fe99Z69+HNcMY4r5bvuYLvwZkdY9ZH1cuRDuMKf38oej74omfk
ok56o1Z0YDBpwZfK+3Xa5cM5c4iY1IEdGK7u8e7BkfXKs7vb+s2e9aUeydmb
dmd7m/UXXWKGYA9uYNSf8t6rWV9vMB/Q48EG7zh9o8f0/pTyPNntZ5dU40Te
NaHTY0mrr4nLnzf6f4M60Bvw5xuhPu98+MMjcsEh9oZcGxV7U7dnhi5PpV7Q
IXSNnWpX37PK1oPr1bZBN3bJb2Wn88Ft4tMjcdB0bPJl++OL1qK57PKGDuMI
duxfS9rBFuFWm7cNv6uafH06Zw2FJ+wwukBt+DWnmPQ4mfZlrNV4gdVI2nE0
kP/58SZrIjqElqFFzOc/riX84BYYgu9Q4t5U+q8fSPYTyedx9TdcNr/4RjiZ
c698g8B1uEf+XKoTv8nkix3aSu98E71RdE3f67fUaX2hn4nEn78azBvmWNT/
7dx56RtthmuGt3xXosXwfJ1qGMx7bugNuoWe36n9XVKyRryf9Q7A/7tKzkH8
fwHZjnsW
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXdwllUWhy9ICSKQkIQAAQIRUkiCQFgpruCiIjtrW4oFUFgVQZpjXxuC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           "],
           VertexColors->None], 
          PolygonBox[{{8114, 4697, 4696, 8128, 1647}, {7045, 8376, 1714, 6418,
            7044}},
           VertexColors->None]}]}, 
       {RGBColor[0.58525673649502, 0.5620069134612743, 0.9099874131122847], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVUlsjGEYfmnNtKW6/KWjC50ZM51/GluFG3VBLRFaqYTo1NKq3cXJ0ib2
UjdtbWU0BGkiJJLiQBM3iYOD2Emo2Oro4IDn8XxJD2++7/++d33e5/3+8Mbd
dbtGm9kNSAakNYg9DraPMvs81uwrJIWz/mKz4Cx9r8jRXQHO18Lo2RizDtic
yzTryTbrztQ+P2D2FOd/S83CRdrXTDZbMFl31+CniT4Qaybs4uPMpmNdAtkQ
lM/1iNk4y+ll6Jz6U5JmFUnFm4o1BjmP/cWg1h7E34kYF9w+D/vebOW1HLW0
Qv8E/L1C7o9x3maqu9XFvVCGfPKFwzrP7M90s9fQ/Zgwew/Jhs3ziFlzzGwC
bFLI8RvO81gHfFcmFTsdUAz6X5SQX/ocgM1Fh9WagHwzn3fw+RYyCffDEA8Y
bYDtvFyz61lmN5HbG/h+m9RdArU0RoTNS6wvIBNhtxCxFidksx29Ogzd39DZ
UmXmR7V/NFr+mM+cEPIs1zljDeB8L85/oPbjcX2zP+U56tEH5HwGMhd5Pwiq
n8SWGPc4nO8H1QPiv2OcesP95dngjm82A3pJrN0h9XxTTJgSz7HIoxa530Pc
LmC2Py6edZYgb9T+C/qhoFbmQC6mHDfS8H8F0oY6ulHvwbhqZe48Y9xe3F+C
7M9V3x85HFjrsKd692QrD+YwjP5f8YQXeUs7cvIU9DvjyjUxTd/cdwWEEXNr
AN7tcXGLeLD37LtXiNmYqu8h4PMJsse08pt9ZK5D7pyx//cTedaEzeZDBuEv
AjzCkLPQPQw8exLqHTlEjMg9+qAv+iQO3NNnHXQ9X3vOIHv7EDXXV+OuWn0j
f8lR8nMUelRUqN5uRczmpObnLs5SMXGW8WtdDl+wrkyIw5tjisdYP4HlUV/Y
tkwRj8nhQccj4vPfLiZb9oH9oE/qkHPUawOupaWaWfaD80cuEAtiTT+cy+9u
Nie4uaLPpQnNCTEll4kV+1WMvG4XC4cf5ZoNzkUd1hJ/RJcrseWadvs+T1xh
rzgTp7P07nHWB10++RPNnlTqjrObcvPLGeWsEhNyaIfbn4hrDsnJz+49Zo18
k/rK9HZ0QKdymnD65LjDWg/ENQPkdxtwboc0BNw7mjGCW4GbnTuoux862xx3
uRIHvvkFDjfacgao3wzfrVXKvQPrScjVHOXOM+bfFNEMc375Zq1wb1pBWG8x
ebUmqjnhjLCeBsc31nrVxboV1b+EeJKn5DG5lI+ehHydHcJ6xBdXWGthWL7y
HK9oyzw48x1unvjekVddrmbWS06/cm9yIfytDGk+qFs8Xr045iseY2VGhB3x
IkdWVYgXLVXCiFjQhv1hLP4P75con33oUdpTTgH8R5ZFVXcLZmt1nnjFmIxN
XhX5qpn1cv62uBmsQ8z6kOq47MkvfUaxrvVUT7pM39z/AzzAE6s=
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXt013UZxz9gbA4vu7INdh9jbD/GhE1MoCOUlnhJzQsUXoAUVEDwZJbl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           "],
           VertexColors->None], 
          PolygonBox[{{5113, 10464, 2313, 10463, 5112}, {7731, 3936, 3935, 
           7730, 1551}},
           VertexColors->None]}]}, 
       {RGBColor[0.6092472574323882, 0.6005530051741717, 0.9105343230978423], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lU9slFUUxS9lKh91Oq0MpWOYTq20w/d1AgkQ0YQKRpNqjAEciESRGrAY
YCEB1IUC1cR/JBgjiRhcoMaERFogbEASY8KCNQvDQje6Eo38c4eywPPzPBYv
35337r3v3HPPfTO0bXf79Y6I+Fprttadnog3WxFHuiJGOyMemxsxUIr4qIj4
UGuvfo/qu3BhxFSn11gWMa0kO++LWKHzPvm/oxxva32uPKfKOtdaqbOGYgcL
582194i+/SXbi7Um50Q8vyiirbVd9onBiB1ag7Pkp7ha4Tu2LIv4aoWwKWbb
SMT5eRE35X89j7im1Suft4Tr4P0RG7W/uRrxnvJ82uHfB7TfTt/9yT5Wj+ju
ly0i6so7VvG9/9coe1XJ/uS81uG4A8kmnt/kf1V4to4Yz13F/iAOdpXMHb+x
Twrb1cx3vdutu0vmebrLdT8p+8uauHjI9kzZPMLhdLJnK9cl8bSjN+KQYn7S
93jL94EX3OCfJSyhdUE+z4qbZ3Lf/6LwFpnvW608//YkHrp9H3dtUZ6W8vyq
PM/J54uaeQAv+2Amnjzg5A54Bxs8YcMP/tT5m/KMV2wTC+4HxMHlDmN+PPHM
OX4N2VeU61anNcY+e+Rpi5uz/dbd2oGIdQP2Q1tLys5PLUXZWgbvaMJMbrRJ
LnSH/tDhPsX+nrlHvQsinmgY3w3p5++l7t9RxW3OHDvVFKamZ+BP8fqXVkU5
nhK2nwfs/6h4uy1u186x3vOkc2omN7UcTFpCm5vk31Qvd8peL3vdIvvnmfuD
xurMYOEeVaX9M4Pu0Suaiwmthu74rMu1URf3TiZdoYWRUffqBcVtqppj+IAX
+GGu6AVzcEj3fFyYm/f1/UBrT+KJL1yNP+z5Qc+Hhzy3aG++fKtay+Z6Js+i
Dfl/L85Oa72ceQ/O2Icj+skbQsy5zHafcizQWq69P3JzXUnny9ObA15wox/q
xybnsGptDluHa4TtxwfTvJVdHz594nD1kHtBX+kNNnHf1h17RFo7lntu8UED
+KGLX1KvT5Y9M/SC+s6kGtmHb+ZiRnunmo4/rjfscMuY4f9o0iTzh3bRa5Fs
ek2NY6kvk8y14m8p7zd1vxf0t1O92FBz33nHp9NbMVFx3ns5mRNs8HKGfX5x
xEWtTzJr4rv0RuXpvWDWqYN6qJE9ztAks77xXo1l+2C3a8YEHvBuHzFm7uRu
/G72WDdo5h/Zb7Ss36k09+yjX95HakQjnPcnriZSHuZg/jxjY36upHjeA/hF
2/wPvFQ15gvyfS3hAT+10Ws0cnfYOuGtnUm1FIkHYtc0rBt00ko8wiFvGvwx
2/SWd3NVei/JB7Zx6ejp3PzCGX0i/3+yhelN
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXeQltUVh6+gIkXZylK2L8vutyBtBRVQwIAKSaREwQYKsYKIxl4SRZom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           "],
           VertexColors->None], 
          PolygonBox[{{6198, 8259, 1535, 7642, 6197}, {4791, 8919, 8918, 9571,
            2031}, {8919, 4793, 2032, 9573, 8918}, {9146, 10188, 10187, 5648, 
           785}},
           VertexColors->None]}]}, 
       {RGBColor[0.6332377783697563, 0.639099096887069, 0.9110812330833999], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVEtIlGEUvabOjFqOqDmaY2MzjDgzjDRqmRU+Eoqg8jFWEGY+KHRTJBWR
G2lT0ipbmAVtW0wGuVGxllqLgkKh2rQuKqJNLws6x/MtPubO/9177r3nnu/u
GLrQc36Tmd3AycY5XWIWrDa7g4/tHrNhnCVcLOWYTeSa3cL3V/i25uyrm82u
4MziviVp1l8v+2KBWbrQ7DHsxZTZAk4v/FojZm04aa/ZvaBZUVRY1UVmnfje
n6WcLz3KuZqrfMzVhft9OF2IbcLvLpyjsLfHgF1uVg5/H/DSqH8aMXs9imfs
KZ9qWoW9VGP2OiKb9fcWqoflCjMP4jPAGQ2Z9aXEAXN04sRQ27JP+WkTj7gp
2PuB14PTjbs59NWMGj7kioNex8PhWrPbAbN58NkO3z9+s3iWYsgH7U9VZvmo
YzRHNTGe+KzpuPNZ9yuedhC9H4jobjxhVoX/TXlmb/DtSVA1kF9ySR7YM79x
vgOY1Zl6ccD8Uz5hPgI///zK24aZ5kdV/1Zg70T9I6jfj28PQ8JlHOtjLOc2
4fJxJpUxzYV41xLCZF+skToh3rmoMMcKxClzHQybzYCv7x750Z846Th6C0uT
pWVmR+LKT11cSmg2g7hPofe+bMUxH/OSj7iby7TDJeaPOrOfdcqfqtYbID8n
0N+WgHR0DHM5WSIOiTHnuG3Mkz5Y/xo0/BF+M1l6Q2cdziHY69vMOmBngPnL
L/3wPfi9mjW1NhKS3vagl+aINEc9ep0mp5HzblCajqOuL7XqcRV537u834Ad
rNQMnjZofuRz2L0n8jYUVTxjFzDrTI10TJ2m3VtgTVNeYZLvIcc5tXY5Ib21
u91AHGLMOpzZgObEuw70vhs6mPQIk/1S/1MBvQfaccT1gaukT/oNOQ3/9osv
csV8GTevSdy/i6i+++CjKy6NryD+uU87ZIMvj/wXi83ehsV/K/IO1sqXu+pF
hXRA3ay4WPrOF8u/Arm6yzVn8tpZJW6Z/0FCNXRHtL8Yu1CseTN2ys2WPbKu
pMMnR3yH1MZ6nnbKhh4K9RY5L86ed/zOOO4Ixn6t1W4i99x/ZTHpj3Pj26HO
yQd3Kzn5XCVdzrh9NeZ24ABwWgLKzX3ZmhRf3D3XY6q7sVS7kv6cG98ie+EO
uxmTzf3xrEF1/4XGx8N6Cy0R7UTW/R+WvNjN
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJw1mXlwltUVhy+boGAJIQsBQhICJCGQEEJFVkGFVtAKWBUVlaUqjorQ0brV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           "],
           VertexColors->None], 
          PolygonBox[{{4965, 9904, 9903, 9902, 659}, {7662, 8260, 1673, 6198, 
           7661}},
           VertexColors->None]}]}, 
       {RGBColor[0.6572282993071243, 0.6776451885999665, 0.9116281430689576], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVUtsjFEUPq12/vlHpXQm2ulD25l0/DNVUhrxCLUQCZGgHivvWFdFRESQ
WFiYVohnQiJsiBCPeGuptrQsRC0sLK00ohJDPYr4Pt8Vi5u5/73nnvOd833n
TO3mrS2t+WZ2FWsM1p1CsyW+WUGB2elKs29xs07szTP7ETLbhu38BrNmrE8R
szjuu2vMbod0T7uJsB+CnxlYK3H0Ht9p2O5FgM6M2cfpZjlftmMisr+M7+w4
szLYHC+Uv0N5iBGYfcaK+cI2gvPNplhthcLDOC9CwtlcajYnabYHfpYD1zKs
Y7hrR6x7EfnclICPhHx11OKsVu/bwrLJwnZ7tdn4hPyfRB2mFSsXnq0u1vnP
crPRcuGgrxJP2E5UmK2ZpDz6Ef9whfbE0YcYi7CfkgbWMtX5OWryDOs36w6b
NyCkF+tRRvVirUYC1YJ1KK4DDqwBT7nOL1W+eWPNDhSZ3YTNBNxH61SbLSHZ
RuCzGfbzsA5j/zgF7EnF2upic38UtiGHY1bMrCelff5YxaAf6uJUpWr+vsps
YY3eMLfFhcLDXLnn2SDivEyKh3PI4zYwf8D9+rDq/Rm8HEEtZydln0HMBaXS
DGt/ytWf/l6H5L9zhlkXVgd0szHQe77NRXTWC7/9qN8A1i9fWiMH1Bux8Yz+
RpHLQ9g8KhCHN/z/e9aenA5Ds10Zt0e+bwPlG5sInEnplvernA213O3pfBix
+n3lSK0cCon3bIX0QW2cRb47ouob8nfLYdgW1j11OyUsf+SuqQn6i4uPX/hd
k9EbfvM9OSLvN52fkak4gx76PGn9ui/umsDvV9xtx7sn8LMUfi75isWeZDza
XnX2zOmSO/8O+xbYX8P3hrB8k0vm3o51GfY9nuZELk/35IZ16HZ2tLlbYtZY
qf5uiWhWcGYw5jWXyzrUvz8ue/LPe2qAcf768dW77Q7DEjcvyEUV/M9tkE2r
L61T58ecXqmHWeBwZlJ75sJ6EC/5aHX27A/2BnvhXqPZ/rTuiDHf9QV1erdR
Wp1bb3amWDmxP6ibkJsz5JWcMuaKMsUdhAZepXRfD98NaeXBHmbt6fNghXqS
GPZhFu1NaI4Sx5Cbtyn4mIxVH1b/8JeaYX3aXNxcoBnHOUaNUCvET52yJ8kR
+29TIB/ULWcP7bPlmi/ExXpvcD0cB97dCc1mziHqkb4518jZYqd98lLgeDxb
JC45C78EOmecNmdDLfzL4w7wnA/UT9TVsMO5Cz52Fqnfb7hcqHn2LnuY+/uo
x9SYcmOfPcioXoxN39QSe3o0Ko6YT5+bSzVN0hD1E6vTfwZ7iDGpbWJ5GpdG
qc+OBvUne3EInL+rknZWZ8QrOSVWvudb/ldk3X/EB5cb+4WzeSQq7e3AnAtS
6st0St/cb0TMgbhqwP7oqRaGK6jVhWrVgvN+bdTNfE+9l3M9SFvuL8DPxeni
I4wcvTrZsl97XR1Yl9J//0+ecPL8D4xxM7I=
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXeUltURhy8KLCBG2MqyvbCwsCxlMUERUEwwKokCUaxUS8xREDz22BAp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           "],
           VertexColors->None], 
          PolygonBox[{{8228, 8235, 8234, 7345, 398}, {7043, 7759, 1559, 7758, 
           7042}},
           VertexColors->None]}]}, 
       {RGBColor[0.6812188202444924, 0.7161912803128638, 0.9121750530545152], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVl1slEUUvWzL7n50t4106Xa3pd0W+rEdqNhtoxHkAUKNoSS2W6lF30w0
IZEfTQwkoCKWBzXWKMZo4w+agCZQE2NsBRew1AAtqRWeTXwzqQ8iCBilKudw
puFhMvvN3Llz7rnn3tmmp3YWd0TM7DxGGcboIrOn42YHFph1LjSbiZpVwuBW
xqzf6ftI0mwz9roxVrWatWF0B2YPtZmtw7gKH29iHsIowGZNoLVr8HkOfr7r
MPsD3zVYv1VuFsUowu5oUj6HMI9hbxzrxwLZ8uxi3D0cM/s1Ih9r27T3VsFs
LiP7RxrMnq3CGmJ5v9bspybgwvrqZWYbanXXJHxcg9+P4eeNLHw5fdfj9yR+
/1au+Oawtg+kbGsxq8PeLNYb6syas8L9eUFnaP8o7n0Ve4dwbiQQ7gmc3RMT
p+SzD/gfxPp+0/k7nGEeAK5cq3jqSGpmvF9j/tnbHEyYPYxxPdB8IKk95or+
d+Oe/gqzWnynMRrz4KPG7IO4+GQeqiKaT5Xr9/Pg5LllwvgP+Btq0t4vGD+U
icN5TA5+suAhgzEd06A+qI1ZxLWJA98LYvruXajBvJJD5pa/aROplE/G+A74
u+i0fiOQvui3hP1TSXG7tVIxML/r0uA6J588N+PPEnMZ7r4UUe6oUebrRex/
2S6uehfJZw/mxoT4Zx6Ic9bj3+zv5r1dyOl0aJaK6kzJ+1yz0uyLgvxRIzxD
e+pij5PPEOf6q5Trk/idzgpjrxPX5LkFejkObN977Jfjwt+F+IqLxe0S8F2D
cTEm3XKuwPp5Jy7Iw8vNZluqxP28PqgdxteVkH4C+BhNK6/J5YqNcf0JnVzH
WALbV+Bnf/NdLKw34qHW6JM4qSfiYO2cqDd7e6l0wlomp4x9Pe7Z2yi9E+9H
FcI8HJdGqc9J1O+hrOqdNfNVVDVCnnmOvA0mpDPeS90NOH23w/+0k+aIkf2A
OHvA27tZ5ZNx7oqqBteuVM7u5B+Yv0lrfRwYzzbKbsrzS5wl+HnN1/I9yNVo
Tvh4nviIjXeTM/YT5pIxsaY41/rffdWYQ32XI+4TgdaHfY3yLva5bwPluieu
Oia3xDTie0iXzyfzyBoY8/b0N+Z9sgewjnn+P2B+wskvuR/2d/V5HVPD7yG+
gZS429ggTVAP48B7NlRfeaATOutQLc2gT9ybEs+0y3reafeMfy+oBfZf6mEO
sR+Gn14fE2fGxfojj6yXEP6L1cLHt6Lo1J9YNx/62pnnjjGyd7IPcZ11eV9K
WM7h3AWnWiQf7BW0/ysvrTBXxMh8Eif7NHPM78ed6pAaeyGh94S9m9xcDhXj
vxm9MeR+A+Jb3yDd8W1ZWqe85BBLPlRvY60c9PXCedD/3u5UG8wDbdiTmNdW
nFseKrZLobgmz2dgf9qpL27B/JiT/ZOY/88o/xeQn6kO9de/M+ov1GMuL37J
LX2v8P4HPTb2iZuwuZFX7fJdTfmckj/2XOaCOqU/6mfQn2N//gT+blZLs6xJ
7nGdvYN9jhpgz/ssr2/2dfJH3U455Yz5SqGuq1tUf6/X6R1lXj7Nqz5ZB2Np
9S/WNPVT8j18pF39nTwW/Xuzyb+/zCXzyH7wUvPdt6jbv0e7nf4TsH5L/v8M
66LbvwG0+dHp7ec6457wMbJ/nKxXbf4OXVwpaI/4Jvy7yd52f6f83QYQ7U/w

           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXd4ltUZhw9RglFZ2QmQBRmEECFB6gKsYLUqrYIDxS04qyDUbR0oyqgT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           "],
           VertexColors->None], 
          PolygonBox[{{7762, 7052, 7051, 7766, 1562}, {8151, 7423, 386, 8144, 
           8150}},
           VertexColors->None]}]}, 
       {RGBColor[0.7052093411818605, 0.7547373720257612, 0.9127219630400728], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVU1slFUUPUzLTAulExhpp+208/+1HVJkQsUQcCFCqCUsLISiXUhdGElE
ghs1SoCkJhITKkiCilETY0ADpisSCCzAEn6UsqG0ddNGF2oiiXGjqT/1HM5L
XLx877vfffeee+8578u/sH/glRiAL7hquPY0AsNcRxcDG5YBEY3L6HAlAv5c
zW91QLYLKLUB79CnuR7oSwB7a/xtZRyYp/06z/TzfXARsG058HQHMMZ9axkY
WAFMJOyrM/fo+1TC+ZRrZaP3I9xPNwFNZeOQTX6yv0c8u9Y4/vedwH2uUcba
nQbK/JatBWb4TJaA0wljFSb5b68AlzPAHG2PPcJ9ZAyKMR3iPEgCp4i5hf4f
8/to5HqwBHicOBZY9xvNwOECcJzY7vP9COPl6D9ZZJwQM0nb86xnnng+Yd/u
9LhXDbQtYqzN9HmV/gvE8yt9B4n1q1rj30jfXLffp7JAvN0+N9cCd1lDTFh6
gXVcLzLeBG031jruiVbmqvyPV0/l/Y11nc0a58EU8CNjfhrz+d6lPjvLHAc4
m5Mx16Y5qRblU93C/A0xraffP/y+M27cwjwSZqm+vRu3n3wUOxbqrQ2zfxib
s13BVeI+1+V5a9aagWyaVym8ixt51tVTdD8nieXoEvMvzRiVonMPse5R9m6c
Ps9yv9BiHAdZ91tZ493U4fkJQx1nuD5tnP3k6pOBq6eJZ3XR8cX3zyLzSLyb
6TQ28eJ44Iby711lDMeIs77gHqm+q02uo4Nx2tvMFXHz7irz8wHxDqTcP/kp
j+LvCVoc4v4EZ/ULff7i+9987i+a0wucaZ4xR2g/XwU+Jwe2NlBzOfdLvRLX
xSPN9Fv27XfmPFRjTv2UNa8U70CIqXl+We8zwiAOi8vCcoH2a7RfyVhLit3I
WpZyfchzg7TtrthP/vIVftU8HTceYTxXNc5b3N/mOkOePsO7obnsWSu3ahLm
I+zly0lzZ4K9+q5iLopXOiduvUbb6xXzQkuaFM93pNxf9fZn9TjyHbWF/Xmu
Yp6KR5PBX/r4qMv7IrX1Utn9klbeTlkvmpm4I11Iu1Ohh9LNXMB8LXBfteu+
Ux7ZZrPWnuLoHnqix2f+bTFfxdU/mH9T2ver7j3diVHQmnSm2dVVfadI1xcZ
51LG2hX3k5H5P9Xpnqqf40Gf0mYf+z7W4JmezfM9Z5ziq/LLZx+xtLWaL4mC
Oa3vuiN0f6knlxg732tdK97WEPMDYv+66jyPZpxD8TX/vuCjPOMhl3RWX7XW
FK8QYiqXZqz9D8RQ6HbtepbCXnxV79VPaWM29F+aXpPxDNS7UviX6V6PF5xX
/4rBtHsqfoqbmrtsb2Zt39zhe0F3gjQxErSk+YsHY6GuZDgvrUgzqrfc7XtH
c3uf/NmXMrbh4KMzujtUw0M+RP5/3As+6qc0pOdw8BeHxCXVJd2fbDem/wCa
aQoU
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHeQ1tUVhi8LsoLCUrawve/Csiy7gBAVARUULGQGNQrYFRQLiJBoLGMJ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           "],
           VertexColors->None], 
          PolygonBox[{{9227, 7750, 7749, 9229, 1945}, {9883, 9874, 671, 4997, 
           9882}},
           VertexColors->None]}]}, 
       {RGBColor[0.7291998621192286, 0.7932834637386587, 0.9132688730256304], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lU9slFUUxS+ddmbaKZ3+IXastS0z/ceMpeAI0cQ/NDHRWhMTExeuJBhT
aiIarS6MS2XBQgpqola2mriAosYQFRa4RY1YBVyYtCZCSShlJ6ZRz6/ndfHy
fd9799177rnn3m/7gZefPtQQEZ9rZbTODke8rbUvH/FALWK+GNHXEnGgP2J/
NWJti555n7+bk73WU1u9/2hjxJmmiHv1vpyN+FPrfn3XCxHXZX9Lth2tEUWt
dQU7l/P7TdlXFWNc7w82RxxV3Gcq9ldps/87Mn7y3a33r+X3iPw/JPAZ+Z+T
/3Oyv70z4ok+2evsWN723H242f4HZDOn/I5pTek8V484oRxXdXZatgttxnRY
eNoTziXF+kLfXypWZ6tzYB973ol7Su9NRcfCR7bovX96Iv4Qbz832pb7F3L2
3Zn8gJ27+PlxLOKNujmbzTuPq4r7bW/ESpcxbNH59JD5JB94gvPvdPZpo2tx
sOAaYX/87oiXupzH69o7mrNPeIQD7r0nm/e11mWzXNZ9+b9Ldu+Ip8NaE7Kb
2K69Tter1i77mnnBL/e+anD9seU9Ix97xqwR8jjf4rhwQf2o3YcF12mzvhu2
GXN1OtWCOi8nLcHTXLLv6TQm8LySMw7iXhqJuDxiu8p9EYNaBfn6q2pNo+cz
yRbeyGG6YK6WlHu27tzhDx7ROecHkw2Y0C61y8u+uWx8lR3WLvXYV5KmRoW3
0X2wlPAvou+s978R/gtV1xHNkC8ayO+WT63rqW94ns04j3LKhf2rrb57SDE/
Vqxr2tuzLeJv9cCs7jQoj0zddvhHj3A1Li3t6nUN6LP5kjHD/anUL89p/552
8zrVEfFTzfWj92eTtsDR0mauFmX/S8VcXeuyXje5WtiM2+o+pMfhZqJkHl7N
Wbfo8IbqO1Nz/5WzfsLzapoNxKK3FhJXRxKvaGlKXP5bdE2bpL3GIdeJ+fDm
Vvcdvbg2ag2+oLuP5YzhYtZ8sN82GDGZZgi+wbGOVnR3cdDvJfnuHrLPuup+
o9OaQrfEAtuuqnsAXtFtNvX4jGr7bMm9+7t0emXEPbB3m+cXcRfVc79qvZZ3
X9Cr9DV4iE++l3T+27DnxJAwDO4wv6uKe7PqmYomyBP9oN/ppGc0SK7kzjzY
n+Y5nNWr5o351J7mFTnBI/g3+MgYB3zs7PX7/Ki1uKFD6fTxAcdZU95jFXPN
P2Q8/Uce0XNS67NmYyBX5sPkgO9zFz3CH/o5KY4/6HPuaIZ76Iaav9XvusMT
OsL/cXEzr/Wk/P5XtD6wmRGWve32ASZ6sin9a6gDPj5RLie0VvT9/Z0Rz/c7
FvFv9xjDLZ2f7Da/OeZG2X0O9y/uNv98l5OOPip43m74HzY+sNEX2KKHK9q7
POw5DecdiX+4uJhqtvnvhHNmGbOA+vLf+GHM/w4wraR95iBzlr4mP3CAAT02
pf/U//0ZGmg=
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJw1mHeQleUVh1+WsosQd1m2wFa2XlhYFlmsaARHVCyQxDZ2bCCKsQAZjWVi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           "],
           VertexColors->None], 
          PolygonBox[{{8525, 6595, 1190, 8033, 8524}, {7754, 9228, 9227, 9230,
            1558}},
           VertexColors->None]}]}, 
       {RGBColor[0.7531903830565967, 0.831829555451556, 0.913815783011188], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VUtslGUUPdPX8JdCy7RmhtrQx8Aww8BYOsVN5bkhooKRBSlGkGkIkZhO
WkVYySNRE1eYYJBgpS2iJNiqC+ICtCaERBGDSSkkbIwLSdUgJYQFEIVzPJ+L
m/+b+93vnnvPfUx7qfxSfwWALyiVlO4lwArKZxFwoQb4oxb4tApoTlC/zL83
Udp4P0j7XzLAZUp5FjCPulbKeTra2gX0UgbrgDHar6T+1Rh95IB/skAf365P
AY+yfiO703HgVJVxha/z34xlSz1wkPZrqBuvtZ+z1cDntH/I4A/ngQ/yvivS
/3H6fZG2I3OBYcql2cAQ799jnCX6LNDnMsoobXYQa4oyTf3FecDkQvv9gfms
jox7me93zvHbnshxKIaVfHeRsrnSfIiXJN9eJ84kZZA+erqJz3M/z792ALsW
kUva1BFnwwLgd8a/i7+bmM/zPN/j+VadbcRnIjJXfzUCMwXmTZsm4pSrrW+M
bCfOJ+LmTrydpG6CcqXK+Zd59z5t9jKPVZTpSse0h3dT9PldC7C0ARiIme+h
wHkfbd4KNqPU3SFvA8S+lgaOFs3Ly+Q7kzMvW5qAHzPOaxtt3s0Y+x1+byWc
4/oFzl82V6l/g7iHiXuTvm90mMM8z0spI5F1Q1nru6grUk5FrrG4k884Y6kp
mrvxnPtM/IwTs9DifhEX8qd+Ft96qzpuTzvW/zkqB59Ny4H7SXOlnHUn/Qn2
VH/cXN0k3t2463Ugcl3UkxWMZWO9Z6SbczORMZcNtY5BsWgmekIvqSapucZS
D+5f7D6UvwOhB37rcA8JS5xNps0bmOuzrEF7FGYozE6KsR9pcX8q17EwO6sD
ruqbb3DtlcvX9DOWM95u9um5hHNbwdk5xlyeq3UP/tnoPlR/aQaUy44wQ8Lq
pf3WvHOR7krQ673yl66txjURVzufAL7K+XyIte1sdn0qGEOR3H1C+7Nd7j/V
QXcDYV6WN/uNdK+xXrsphTpzq6/yvMPeWZvyrGgfaC9olp/hbH4f6nK0FTiT
dB7fMu/XF3kWxd/CpOP/r2Zh3r+ZZW5U3xLf9rX6TnWWX/nU7GpWVbunORfX
Mp4j1Vn1FodXWcNX0u6nGHumsuieAnON1TtO7RbhCUu9pzu9fbPN+Sv3e2Fn
qabiXr0r/pWv3qi+8jccchfmkbxxL8wHXmj3LlNOwheW7hSnekz7bCrsNO3D
kbBXdS87xSOd7kph5wwHXM2k4lNs++Z4B02HXaTayv86clzKOgf14JehD2Wz
L9ht5n0xaS6EqbyEm6Ztb8o1V47i50TgeG+IX7Oh/aE9Wc3aPpnwvnx7sftP
vac9/bDgvag8hal6/Uvc21nvWel0J5+a7+NhxjvZg08t8d7VvpQPvf2ok71F
+Zm6j+ljPOkY1jDemax7RDOueVAM4iwW4h8N/8HaV3uCT+1MxdAX/J8Mu0Q2
D9gL95vtT3iqhXaWvpfCWbOnGdQb7TnpVaOfMv6vEsYM8/iw0/aPAY6jJuo=

           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXmU1mUVxx9mABnTmBkGZoPhHYbZB2bFo4kKeAS3glIydwUVNUVBoTSX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           "],
           VertexColors->None], 
          PolygonBox[{{6047, 8653, 1749, 8652, 6046}, {9932, 5171, 5170, 9935,
            2159}},
           VertexColors->None]}]}, 
       {RGBColor[0.775697801304095, 0.8513554300576651, 0.9081770847253524], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlm1o1mUUxo9u7vF5NpVt1ixrc3Nu+z9zMn3U7OVLG6VhaunEtILSsHcN
iiwweyE024cmURq0FFeQBZZlCWUh5SsWRaBEfUlrUUmUWURZ1vXruqUPN//7
uf/nPuc617nO+T+NS1fOXzE0Io5olWn9NTbitpqIbcMintWLruERG4ZEbOqM
eEbrcGXE7Vrdw/3uVtme1p2XZX/51Ih1Lf+/m6P1m3zOS3v88ZybzonRXR5R
GuLnFWl/t95P1P4z2R/L23ef7PvaI1oy221ui6icHHFCtvcXHA+fTyuJoTnb
c9ad8GfC9kOtbV+ri/hH95dXOA7xLpPNgqqIm8vto3dkxJNaTSMiVivuQ1ob
dXezsKyR/RlhW6/3B7WuFMbxI7xfqncnas0FsQ8Msz/w7KuO6LhAT8U6fWHE
Sw0ROWG4Lmff5L66VbFaHWONng+ztG+s8JO4xFmfYp1WLueIh+9T3sQiX/D0
JvyZOFs2xrn+rtqtUqwZst2d82/2OeFZK9w/Cu9u1fTrJvGsWJ/IdpveP667
L6i2p2pdz8Xt5hQ+h06I6C/Z3x3al4TpTuHYWW6+yHea7HuV703KY4bwXKK1
MG+Oe1MuS6ZETC5GvJi3ziYWnBM8vlNwXg8qn375Pa59PzUp+d2e8yIGx/od
mNAo9b9Ree0Q5pPDzAXxuNuXs298okfyRj/En5YwwDM8Ul/qtr/auXyoPPY2
uF7oBV3j51Pxc6jFeurRnfl58/aKuL82sy31BktPmO8v2hx75viIe2rtKzJr
dHmyfbPc9vh9oNJa/a5gvsnlUtk/rxiLFG/RaGliku22580/dUBrhdGOX9Lz
oxb3F9z1JR7mpL4FwzWZMbE/I4x/a9Xn3XuNqU/bZHOD4nbpfImeS9v87khz
xNFm6+ZL6egqvavS+dVV5oXzBbKdlc6rzxUXqmVNmes7faTrWJCut7RZS0XV
ZKLWFt3fp/t7K8wL95kB2KztiBgxwflSP57Uq0tc3qXzR2Szf1xEg7SyS/cP
i4P3W6w9dAk38FyfajdL91cKwwqtkrC/JX12nh/xhvZZ0ZoD5zfSXVmT8YOH
ujUr7lThKXW4VvsaPFuZeYPS5C2pH+lXdAH/xBgoWG8fN6p2dcZF73bX2578
yXug3DMAW/SwWLWaPc6Y0eniKc59Yb3rTa3J6dGkye1oLPNvfBAXP6/mPGuY
MzMV9yfmbOpjzvCJn57EzxOq2/p230d/9DT234qP1sycM5uYMfRXY2atoBPm
AXmSI5roSdjgDz9w+JX8vFvjWUSf4As/y1STssw21B/e2Zdn/jZwhi6ZrWCg
V2akfqGnDiX9PDXWHMHP9WOMD2xnNQTPzEtmCnF/Vt1PFj2bmA3NaT5crHu/
jDIG5grvmfnM5j/rjJuaM4up46SiNX22njzRXrvOOkd5P1Dhbx/fRubxYJrJ
4CMvepCc6Bnyom/YE4t5/Eed875PurhXa2uFFz2MT3r0oszc7xLOtyf7G9ib
5h59QY/Sw/CLdsHE3R2697rWY3l/445UWsv0057UU2A/kL7d5PRcyuuU/kf8
2uk7nwvDwWrrbnpmHaMreoxvP3fBwuymvzg7njeGD9R/HUXXCD7ghVr/NzMm
eCa8V2MNwRu1Gp/8gO1Y8kPvMoM4P8rM6/RMRI/MLPDUJ72jbTiGd3gGy9bE
CWerkk6YTztTn04tGit75kVTqhd1x45zYm5Mcek/vrv0Ar/5FqIp9IXu0ViX
+mZdh+83pW8i+KkH97lLzTe0Gx/9RF+Bv1LczK7xHJ0nbHOL/lb8C1fxX4o=

           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXd0l+UVxx9ICBJUIIRAAoQEMsiCkABW3KCCxQFaxYELZYlgVQSPC+tm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           "],
           VertexColors->None], 
          PolygonBox[{{6431, 7061, 7060, 8395, 1719}, {5056, 8585, 1737, 8584,
            5055}},
           VertexColors->None]}]}, 
       {RGBColor[0.797242917368115, 0.8585401521750683, 0.8985248920359529], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNlllsVVUYhbftbW9veylDDe0tLS0thV5rA71UxDFRiFAxjmHUGKMPGIYy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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXd0luUZxh8yiSAjIZJBki+LJCaBDEAKiiwPIGgFW4YVFyg7QYbQI7bW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           "],
           VertexColors->None], 
          PolygonBox[{{6136, 8256, 8255, 7352, 998}, {7969, 5759, 799, 7001, 
           7968}},
           VertexColors->None]}]}, 
       {RGBColor[0.8187880334321351, 0.8657248742924715, 0.8888726993465534], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFV1lslGUUvbSztbQdQoHSvWUozAzW0Cnbgw8FtRqQarG0U9ColPgAtBQx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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXu81/Mdxz9O51IcO9VJ9TvnVM6lOrdOdUrswZiUETFyKcZQbqXbkIQh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           "],
           VertexColors->None], 
          PolygonBox[{{10430, 10410, 685, 5075, 10429}, {7334, 4209, 4208, 
           9165, 1501}},
           VertexColors->None]}]}, 
       {RGBColor[0.8403331494961551, 0.8729095964098748, 0.8792205066571539], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1l2ts33UVxk/p7X9p++8KobCVXfqn7t82xfUSJgsrwgYLxcwLZpCoYTL0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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXeUl9URhq+s2yiuuzTZAuwuuI0FFklQDioq5QQUc8QYSyIK2IAoEJBi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           "],
           VertexColors->None], 
          PolygonBox[{{7541, 6110, 2300, 10430, 7540}, {9156, 7178, 7177, 
           9145, 1928}, {8974, 10685, 2445, 10686, 8973}, {6110, 8974, 8973, 
           10431, 2300}},
           VertexColors->None]}]}, 
       {RGBColor[0.8618782655601752, 0.8800943185272779, 0.8695683139677544], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHuQ1lUZx89eYF/Y9wIL48JCsLjC7vL2DvvCLteAuGgTAt1AkRKUCRsB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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXl0VdUVxg+DZAASCBAgAyRAQkiIJBEsaKEikxVEreDcijjVAa1aEbDV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           "],
           VertexColors->None], 
          PolygonBox[{{8194, 6544, 2450, 10755, 8193}, {6841, 5150, 5149, 
           7728, 1377}},
           VertexColors->None]}]}, 
       {RGBColor[0.8834233816241952, 0.8872790406446811, 0.8599161212783548], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmXtwldUVxQ955yY3UYIEbpAEgSsJRsKjM0VkaqdCaylgO6OICi2ghNgq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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHeUltURh6/ILlvApbh92aK7yy5LXVEDotjABrGcgCJoxIoNolhAwKCg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           "],
           VertexColors->None], 
          PolygonBox[{{10135, 10112, 533, 8824, 10134}, {7828, 11379, 2768, 
           11378, 7827}, {7788, 7804, 7803, 4710, 536}, {10136, 5500, 5499, 
           9454, 1964}},
           VertexColors->None]}]}, 
       {RGBColor[0.9049684976882153, 0.8944637627620843, 0.8502639285889554], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmH1s1lcVx+/TF/ry9On7y9NS+/SNjvYpUNpl4LJkJq4McDCHWwELy1im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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHl0ltURxidA9tCEJJCNfPmykuQDDAHtIh48YkpQoYIlSIGeQ7RWBAKi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           "],
           VertexColors->None], 
          PolygonBox[{{5337, 9969, 2168, 9992, 5336}, {7769, 7038, 7037, 5227,
            1564}},
           VertexColors->None]}]}, 
       {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
        GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHtwldUVxc+9yQ0hj0sgSBIlITzVBAIIFDtOp05NGkBQQMWpU/8wjGJH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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlX9o1WUUxs/dj+vcJm2727y7a9P9dNv13u6uswyJJCGk0nTOgsg/uoOE
tMxyJS6z+QPKZok6ZrYZmTQaJRQFKTVFihGCWcnaloYVNLeMbAtLotXn4fTH
udz3+77nvM95zjnPW5Ha2PxEmpntxDKw8qjZyZvMDvM/kW2Wmm12PGF2Lsds
lPWHDWaRPLO7AmZXZpp1xsxOFZuF0nHgzAD/9y8wa55lFuTb0kqzg8RbzPav
QX6I92692XZ8F7A+XWHWmm82SOwLrLOrzV7H56css0Mz/Gy00n3lM859V7Ah
Qq3kvkQjFmaRazbNugP8O7Be4vVgU2CZ02T2F3jSiNkeN+vDHuHsWyReGDL7
OeaxVmFV+FZiC/G9Fesjnzz2R/h/npzbkmaXSsye4752rID97ojZQ5nOQW6B
WW3MufqK8x3gPwO+RyF3mjMl7C8h5zPkc5RvK+bAD/nvyHA+JuD2W2LWEOs7
8N1WaNYFf3H+D2NT8LevzOwGsTo4Pw3WMawm0zkUF7/fDEeZzomw3QnejgzH
GIDLx/g2DpcX8Y/MBRP2MljXcmYL8T+j3ufhYj3+DeDJL6e0nN2Hfy/1Xx3x
2o9hV8nnSA342LsXfBeox1XsFFiGWCfZbyXfQfz/yPa7FUO+wrABrDXUvIda
T3B+Pb4bGr12wrQVbt6fZ7Yry880gy0kzsHXhcXZn6jwXCrBkAuf18H7N74l
cPgi+UxzZxt7o5xfDnfLiP+v/DkTDnsPqXf0rZ/902XOvWagBW5egN/D4FnE
+RvzzX7EhrO9JwaozVPYsXS/42LEe1q9nGK9jPwfLHZuhKkePpfTE+vI/VX2
Py+lNhHH3o1VcNdc7DK1eJr1Ivipjnov9oPnE2p5kp7eQz//lub/3+bbiYB/
uwwfVXD0CrnshrP7C3xGNZtBzn9A/b+QEfsomLeAdRL/bbleoz309zowvhTw
Hv+IXP+8hRj4Z3J+G3z1wVcvZ5vAeHa+n9HeEBifB+s88jmO72us34O/Lqw7
4DPwTdxnULOXyvHeH6XHJ9N8Bo4wj/fUMn9gb2V/Z9RrIO4105v4PxufT7Md
w272Dby3s/8G3w7WeY7KTRrSVuAzp1nTDG2POkZhU0076Y+xmM/+IKGWhrwn
1YubJIy6K+5Ye3KcK2mAZl+cnSPW3Zx5J+A9L637Je7YpXkNcLe/0Gt1DdtK
bqla7z3l+D292l/kWqmarIXfXVHPpZH4axJeQ9VOPf8M+T2LjWR5zp0lrjnS
mjRifJ30nlIvncB/Nf4tCZ+VFs6cBc+BIj/bnulcTlW51orTNmJvrvNe0x17
4aeHHnuS3kqB4RhcT4Z9tlVTaaVmTLMlzZQWjSf9bmnSJbjNC/3vm+5vgzRV
Wqo3opxZW1jmvaQ3RVryQMy1Qpqi3l6VdC1Sj29kvTjpWql+OZDvGqq1NG4W
uQa5bw337ZWmw+/Kcs/9Tfar+P94qWtZbtBneaTIz2qmVzCb99W7FmpGZzb5
TGmW9IZ8DL4va/wt0R1L4HOg0GurN0XaHi7wu6Tx0nL1kHpHml7H/h0Vrt2a
Mc3q9XyfHc2sZuefiM++ZmiEXhwu87dDmj4W8hyEXW+A3uasqL/VeqOl1dIY
aYs0W7VTj6u3VcOw9DfpvSWN+QH84VLvBc34DGrfUOzaKc29RvzRhM+C3oSH
0erN1c69ZvY/0rI4KA==
           "],
           VertexColors->None]}]}}, {{}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{5175, 3989, 13073, 4725, 4633, 8512, 4632, 13172, 6593, 
           7761, 7760, 4123, 12371, 12372, 12370, 5651, 12373, 4687, 11660, 
           5823, 4630, 5650, 6807, 6463, 4499, 8014, 4500, 5338, 13177, 5313, 
           9969, 5337, 9284, 9308, 9332, 6487, 12835, 6511, 12859, 5888, 
           10668, 8747, 8771, 3988, 12011, 5022, 9802, 9850, 9826, 4236, 7501,
            12616, 6168, 12592, 6192, 7409, 7385, 7640, 10625, 6338, 10601, 
           6362, 8365, 8341, 4260, 6386, 7086, 12756, 12780, 11190, 11214, 
           4422, 8419, 8615}],
          "1.4300000000000002`"],
         Annotation[#, 1.4300000000000002`, "Tooltip"]& ], 
        TagBox[
         TooltipBox[
          LineBox[{6876, 8640, 4451, 11262, 11239, 13033, 13010, 7109, 6785, 
           4398, 8682, 8705, 6762, 10909, 6739, 10932, 4122, 7454, 7477, 6292,
            12688, 6269, 12711, 8305, 4375, 9203, 9226, 8859, 10388, 8882, 
           8905, 7299, 7902, 5546, 8009, 5569, 5822, 13202, 5799, 11536, 
           11513, 11490, 5593, 12301, 4870, 9656, 9679, 13299, 13343, 13321, 
           4576, 12323, 4598, 11467, 11445, 12279, 12257, 6936, 12235, 5523, 
           11401, 11423, 6540, 4620, 11558, 5986, 12462, 11016, 11038, 4026, 
           7594, 7616, 5198, 13171, 4330, 5847, 4352, 11965, 11987, 11899, 
           11943, 11921, 12096, 5310, 12074, 5266, 12052, 5288, 6588, 13242, 
           6566, 12881, 6008, 12484, 12528, 12506, 4909, 8464, 4931, 7276, 
           9253, 4474, 10161, 10247, 5674, 10225, 5696, 7948, 7926, 4680, 
           5719, 4822, 9606, 4844, 9630, 11606, 4658, 8547, 8568, 6642, 12917,
            6621, 12938, 4199, 8488, 8509, 8216, 10781, 6131, 7568, 10455, 
           5095, 7715, 7021, 7787, 7038, 7769, 4138, 7697, 4137, 10573, 10574,
            10572, 6311, 8218, 8217, 12969, 12651, 12652, 11137, 11138, 11139,
            8276, 11136, 11135, 11134, 6695, 6909, 4027, 11041, 11040, 11039, 
           6680, 12957, 6237, 11140, 11141, 4096, 8134, 10404, 10358, 10359, 
           10355, 10357, 10356, 7224, 11044, 11043, 11042, 6024, 6910, 4030, 
           3954, 11741, 4880, 11080, 11081, 6029, 13212, 6028, 11751, 4884, 
           11750, 11753, 11752, 12547}],
          "1.4300000000000002`"],
         Annotation[#, 1.4300000000000002`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{3922, 8047, 10978, 10977, 10976, 6668, 8046, 8045, 6666, 
           13247, 6667, 4785, 9560, 4784, 9561, 10469, 10470, 6203, 12634, 
           6204, 12635, 4125, 9761, 4950, 9758, 9760, 9759, 3916, 11759, 
           11760, 9755, 9757, 9756, 4124, 9753, 9754, 9750, 9752, 13263, 9751,
            13264, 3915, 10975, 6786, 13034, 6787, 10933, 6512, 10676, 6514, 
           10674, 6513, 10675, 4548, 7138, 5501, 9455, 9456, 9457, 7805, 
           11379, 7828, 5476, 7856, 7879, 7137, 4524, 10270, 4547, 9426, 7210,
            4779, 8442, 6903, 10084, 10107, 9357, 9380, 9403, 5619, 12346, 
           5642, 12369, 5453, 12188, 5430, 12211, 4075, 11808, 11831, 11785, 
           11877, 11854, 4306, 6458, 4283, 13149, 6409, 8797, 3912, 7254, 
           10038, 5361, 10015, 5384, 10061, 11652, 11629, 5742, 12398, 11356, 
           11333, 5407, 12165, 4751, 12119, 12142, 11285, 11308, 4498, 12811, 
           10303, 9710, 9733, 8969, 9968, 9992, 5336, 9283, 9307, 9331, 6486, 
           12834, 6510, 12858, 5887, 10667, 8746, 8770, 3987, 12010, 5021, 
           9801, 9849, 9825, 4235, 7500, 12615, 6167, 12591, 6191, 7408, 7384,
            7639, 10624, 6337, 10600, 6361, 8364, 8340, 4259, 6385, 7085, 
           12755, 12779, 11189, 11213, 4421, 8418, 8614}],
          "1.3`"],
         Annotation[#, 1.3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[
          LineBox[{8072, 8071, 12964, 12965, 12963, 6682, 12966, 6030, 8070, 
           11050, 11049, 12962, 12961, 4882, 11742, 4881, 11743, 6025, 9680, 
           4876, 11738, 4875, 13209, 10360, 13210, 6014, 11099, 13358, 6142, 
           12567, 11100, 11101, 8135, 8993, 8992, 10459, 12566, 10460, 9030, 
           9029, 4097, 8277, 8278, 6242, 12653, 6241, 13220, 10563, 10639, 
           10638, 11096, 4045, 13266, 10637, 8986, 6134, 10457, 6133, 8219, 
           9134, 9133, 6312, 10575, 4695, 7788, 7804, 5244, 7161, 5227, 7037, 
           7786, 7020, 7714, 5094, 10454, 7567, 6130, 10780, 8215, 8508, 8487,
            4198, 12937, 6620, 12916, 6641, 8567, 8546, 4657, 11605, 9629, 
           4843, 9605, 4821, 5718, 4679, 7925, 7947, 5695, 10224, 5673, 10246,
            10160, 4473, 9252, 7275, 4930, 8463, 4908, 12505, 12527, 12483, 
           6007, 12880, 6565, 13241, 6587, 5287, 12051, 5265, 12073, 5309, 
           12095, 11920, 11942, 11898, 11986, 11964, 4351, 5846, 4329, 13170, 
           5197, 7615, 7593, 4025, 11037, 11015, 12461, 5985, 11557, 4619, 
           6539, 11422, 11400, 5522, 12234, 6935, 12256, 12278, 11444, 11466, 
           4597, 12322, 4575, 13320, 13342, 13298, 9678, 9655, 4869, 12300, 
           5592, 11489, 11512, 11535, 5798, 13201, 5821, 5568, 8008, 5545, 
           7901, 7298, 8904, 8881, 10387, 8858, 9225, 9202, 4374, 8304, 12710,
            6268, 12687, 6291, 7476, 7453, 4121, 10931, 6738, 10908, 6761, 
           8704, 8681, 4397, 6784, 7108, 13009, 13032, 11238, 11261, 4450, 
           8639, 6875}],
          "1.3`"],
         Annotation[#, 1.3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[LineBox[{5500, 10135, 10112, 10136, 5500}],
          "1.3`"],
         Annotation[#, 1.3, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1HtM11UYx/FHp3Ep0bwQJYLkJQhCvNBCizIRTXFpS13mnGY3LWJlGorl
WpZNG6JubYrNpuIK2XRmDcmp2aq51ZZN09JKK5fRQmiWWl56/f54/z6/85zn
nOdyzvfkPFb10HOdIqLZz/e3ROzLiZhzY8Tl/Igz+G1YxNf4tG/EMvMF5s7y
uYanjetvj5hCd9GMHhGZ/SKGY21GRO3QiBraQKv6R/SxtmNARPLAiPW38smN
2Em/wKuZESezIt7rEzEuO2I/3ZseUTfcepp2R8SFgohTOGbu+qKILr0iPhoU
8RU6+PUbEZGEH8XJMX+eHuL/Af4eEvET0tVxiK6xxwr2d7Dy5ojUnhEDxZh9
U0STtdepPRPN3eWknn2o6B3xvDhn1XlUTlfpx4URh7EYDViNUvvv5ZtL62hP
uo22iNNs/Vb6oJ4uEuugWG04jnz1pOnraDpfPwboU7UadtwW0VWvcsU8538p
TdWj8/pVLu+pxkfocn1opRvpw2op8n+O/RahXcwFYp6gb9In5D6YfRTSnU1f
59chn1p1HhXrjBxy7P+Mfs2jS+l8NVykNbSG7Un775dHo/NvRhb7HppNh5qf
Z/4K/yZnvh392RsHq4PPdDFnuRuL6Qjjz/SlmG5i2+m+7JHLDbSFdqNb5JRs
7RjnO1ZuSf6nIgXzxXlAzRMxARn8f+Bfg6U4qRcn0M26TWp/F4Oc7WAscL6v
q2ERLTDOxyVncRG9+E8w/tf//3AFl3HKXqcx0dxV4wPWXqM/s/2CCvaQwyfs
neivbGcwib2z8Wo19VDvS+bvds73YBVbd7aFbPsT++nFSrY0theNR/G5IMYK
tu/slSq34zSFvpzoFb8qfuPEKMdYtOvLET6z2Ecb34d70ca+zl7l1q2lY+kr
elBG08VNsdcMaxayTaFdjXuyF5tfr3cb0Oq+/IHJ5tuNO7Ax8R7gfXdqpHN8
RK0X9b/M/9n+j0mctzVLUOQ+VMlluvPakbjDdBrucr4jUYJhzvaQ/ffwf8O+
hWoZkrjX6CVGD+s2+B7qsR4f+s5246w7t9Xabu7bZppGG2hB4g3xTdX5Bjq7
d215eojJvoVyNdbJqYhuo+Plso3/MFrtfXrb/jXejDbrX/BmrHO/5xrvoJ/j
lJjbfav91HuQHuaX58wa5XhJrH/kP9ceS/CWuS1owV/2KHEGKb7hybTCuF4N
xXQXbVV/tjflTiTjcUxKvDlyLlFHC50p52T/Z8pzHP+p4haL067uLJpkrwr6
mnqeRaVYlWI9qo4yZJlfLlatXKfRSvRmz8cataQ621J1/akXXfQxWX/O0SR7
HhPjfnXMSPQFU+WRw7+SltCrYjXqcZ7cRifefPn9Lv+N7u14e1RjNlaqY6K3
p9w9SXdPCmkhPaeWY/jW3DL7HGB7KnFudLu+rsNma9uNm5zBN9a1Yre79SXK
5H+aT4P78j8nnBQv
           "]],
          "1.17`"],
         Annotation[#, 1.17, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1GtM1mUYx/HLUaI2MFMyDyhqBoIEGCW60UxDNyntQAdzTaO0TGZiEkrq
WpTNNdTcbE1crcQKKJq6xszQ6cq51YyDado8vHAZLcFm2cHp+jwvvs/vf5+u
033dz5jylx5Z1iciPvZzcnhE25iIhYMiruZEnMcvkyJ+wKEREeus51i7YM91
PG+8LTviIbqLDr05YkR6xCS8c1tEXUFEDW2gyzIihjh7aVxE8u0R7421Jyvi
C3oYr42M+HlUxCdpETNHR+yn+26N2HSX8zQlN+LKxIizOG5tQH5E0uCIL8dH
fI9L9o0sjOiL0/xkWL9Mj9i/G3/mRZxBmjyO0M1srDe/HRuGRfS/JWIcHwuG
RjQ7e6PcR6B1oJjk04bSIRHL+bkgz2Niuka/ujOiHavQgI0oZn+fvZl0Ex1E
d9K9/LQ6v4POUdMqvg7ydREnkC2fFHWdRpeox1h1qpZDS2bEDWqVyWeP72La
X40uq1eJuMuMu2itOnTTevqoXPJ8L2SvCr18ruDzFH2LPif28eanIs3dDHd/
l8RTJ89jfJ0XQwb7L6rXC/RVukQOf9MaWmNuEfv7xdHo/luRbj7f/FI1u5d+
a26iuQFy+ca9X3d2u5rW46hxbqImd4hRjzwphgV0LS1y7rA6TaGTUSu2FeLt
dGaN9Ub7OsU9lr3dctmD5XpskfmVtAqVeBkrcFQ871pr9N2MJmw1zmH7ED/Z
9FNz1ViFV7DY+mpaqyZX3M0we97np0Isneo7XZ+lqlGH74G0i2bKKwtT5DsV
651NYb+S/za8YVxv/Cbt58waepPxMmv3OzcD09Hl7jrxtPmGRC3NFaPDXDvm
mfsAv3k33TjgHp5wZ5PZe5zeQyvcSw4tMy6ka+3713eeuAuQjxI5PiPHcly1
9h9Gq/NKZ0fROer9IJpwUpyN9BR92NpP9OsJ+ls/TRBTNnIw2/00q9NnaEIL
PkeKHt3hrlPpHj2ca+9AcZ/TJ6n0H71+BYfYPIg2pPJ3RuxVevI0TVL7Puxf
tHYCc8VRIo5N9uXRnXSWe9jJdgGtlvNWvmq89YtsV3rrW/grN25J9CfO6qEm
b2yk3A/Sdvuy3F1jIia+/nLv5WysxtvWPsJe/MFGkb7oJ5+5tNR4m3deSHfR
bvczyn/B3UjGs3gg8V8h5iI120vniznZ93xxzrS/jN9Cfnq9i3Tal61S+rp8
lqKCrwq+npLHDKRbr+WrTqyP0QoMNp+NzXLpr+7F8vpdLZLUPll9emhfNo/z
cZ885iXqgjJxZCT6mxbRa3w1qnGW2KYl/qvF96v46/XtLDaqsQAb5DHb/ZTo
oTT9lEtzaY9cjuNHa+vYOWBuceLeaJO6bsGHzvYaN7uDDue6sUeff5d4C+I/
Z0+Dd/4/kggK4g==
           "]],
          "1.04`"],
         Annotation[#, 1.04, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1Hto11UYx/Gn2XSjiaZLc5uuedmampdtMIKFIdNolYH2h0koXirbyG0x
1K2Guaws1kyIUqNQN0QFwyRkim6LCsMgpbl1wewPSRftouYchEGv7x/vfX7f
55zz3M5zlreuevmmeyJijz+/ZEWcyYtYc3/Ev3MiruLPoogf8XV2RKP12dau
2fMfXvK9d3bEs/Q4nTQ+ImtqxEJ8+GBE88KIetpKX30oYqKzQzMiRs+M+GS6
PQ9HfEG/w7aciN+mRRx6IGJJbsRZenpSREux8zTjkYjhuRFX0GMtfUFEysSI
r2ZF/IAh+7JLIlJxWZxc67foOfu/xD/zI35HpjrO0V18vM3+KXZOiUibEDFd
jNWTI446e6/as3BynJzUcwYVmRHV4lxTZ7ec7tJT8yIuYAta8QHK+D9tbz5t
oeNpG20X56TzB+kzelonVpdY/ehFoXoy9HUR3agfefq0WQ3HCiJG6VW+mAN+
l9E0PbqlX+XyXuH7J9qkD310H12ulnl+r+GvDoNi1or5K32Hrpf7TPZHkelu
pri/Ifk0q7NbrKtyyOX/Ff16mTbQjWq4Q+tpPdsG/s/K47D7P4kc9vnslXr2
GP2WbQ5bulpOufceuX9Dz9Mu1MrhkLXjGBG7jWZbz8FkeebSaehk3ySfTnlW
06WFEU+gHPvN1xK6R18b+Lipj6/TKjUstbeBvum7nm5L+s1XLXu3ugvlN0M9
KfIo4WMUfUs9O1ClH5XY7swwn020kY+LbLPM2Bg+7ujjCH7W61704GM+d5jn
Gj0oFavamRpswmuoxU3rNzCkfwfd1S0+X7C/FUPsgzjAvh8r2T5HH9v1xC9b
Nf5ypg/vyu097ESRXnXrw0J6id50rsYMF8n3aX3a4B2OUWc60lCkpvV8bMAb
if/kLTvzmbwraANbPYbN4W2Mle8W87EVGWZunDj30RPJffLXie+dyxS7w++x
yd2p9yg6UOfcZTFTxAl32W9PL5bpe7kzLfbPo210qRrb9HMB3SyHj8So92b7
5VHjze42X2t9H0vmDFfc4xFvJVucLnrBvgJ1HJbziFi33ctaPrbifWsH0I4b
fJTq3Rh1LKMVvvd6r8X0OO1Tz1RvugSjsQ5PJW9ezqVmtJ2ukvNov1fJc4n9
K8QtFmfQ7OfQVL4q6Hb1VKJKrCqxnlfHYuRYbxKrWa7P0SpMYC/ELrWkmbEy
df2tFyn5YunPAE3ls0eMx9WxMukLViTvxv4qWkrvinVYjwvktij5nyu/6/Lf
l7wjPjZjNXaq40n3U25GMs3KXDqXDqilB5esNfLTwfZicm/0iL7uxn5nB30f
dQcXnevDCXN3Hovl/4c9rd7b/5ODBBI=
           "]],
          "0.91`"],
         Annotation[#, 0.91, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1G1M1lUYx/ELA3GzpUiWgiJIGEo+BMbcdBZDN7Vsi1LRpplaJinanEmb
q7QHVwiRrYa9yIQ5tNmoNQOHij3Msk1biqum9sJpbgk2Ba2mrT7/F7/7e/7n
XOd6OufcecvWVlSnRMROPz9nRXTkRSzJiPinKOI8XSiOOE5HsiM2WR9r7SKb
W/SM78ZxEY9iKw4dHDF8ZMQkemdYRO39ETXYhKtzI4bYeyU/Iu2eiA9GsymM
+BS/pZdHRPyaE7F7aMSMUREH8cBdEXUl9uPA8RF990Wcoy5rAyZFpGRGfFEQ
8QNdYZc1OSKVzoiTY/0qHmX/GV2bGHGWMtVxFOv5eN38h7R1eET6kIg8MRbf
HbHX3tvUPpz2D5KTejpo9p0R1eJcVOdJOd3E9gkRJ+hFaqJtNJX/A2wLsA4H
YTO2ibPf/l34iJ6uF6tTrMt0mgrVM1Bfp+NK/cjVpw1q2HdvRD+9KhCz23gq
puvRVf0ql3eF759wsz5cwh34mFrGGy/hbz31iLlOzF/wDVwm93zzUyjT2Qxz
flfkU6vOk2Kdl0MO/8/p17P4Eq5Uw3WswRpzy/k/KI8W57+fss1PML9Kz6bh
N+bGmRuglnbn3iX3r/EYdtI6ORz33Wq9bYw7Ima+XFbgFHyI/pbTbusj2b0p
x2l8njE+S4eTvNWzfayzwwbMxXdxCt83jOvU+hfWYy/WqrdWb+7Qo7f56jHf
l8zjddyGnbgAK+kJmk/zaDSfpfZ8adxObbTL/R5pbohzPajuhXJaRGV0S+4Z
7va/2Jf4p2v0PvterFbPar1eQ1vYvUZr+ChV7xZ9nYwPJL2zvwQHiFGMy9mX
m3tBDYedwQX7qo1Tra/BedZvUT99mCO/FHwYP+FzL/WKMVn/Sqi/tTQa5Vw3
yrlS7z8S43l2VdRhrV4/nmS7iCqTc2RzhP+vaLDv+d7JAmp05ply2IHfy+92
uXyXvCd2T7lXS+kVdzWP31niDWJ3iq9D1tdbO8M2RU/+s35Z3NM0V8/L+awT
Zzw240x+m53hRNyg9vfcpRrv+bL3stZ7buB3qe99yR2kc2Lt8Y6yxOnEE+zG
qLFF726oudd5LOVjI71l7WNqoz/5KPUu+8t5Ls723egtF2MrXtLHEd57CaXR
0zQn+T9I7ometeFCOacZL5TnDPYV4haL0+NdZGMqX7PxVfWsoiqxqsSqVEcZ
ZVvfLFatXB/HKsowX0j1akl3j6aq6w+9SPGG0vSnG1P57BLjQXUsSPpCFfLI
YV+FpXhTrBY9HiO36cn/sfx+l/8OZzKTjw20mLaqY5bzKfc/nukeFWERdqul
i05Z28TPIXMrknPDPfraQDvt7fG91xn8aN8l+txdOUZl8v+NTZM3+T/LcwSN

           "]],
          "0.78`"],
         Annotation[#, 0.78, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1G9MlmUUx/FjkG66TElTMARJQgxEKKRwlkMWNKzEF6WbZkmpzCXNabQp
5VZDM4ytzbTN/LemLhu2xtCpI8ss2rSlmDqyF05giz/N1LYGrfV5Xnz53fd1
X9c5v3Ou8zBtZd3idSMiYo8/V9IiTk6LWD4+4p9HI27gZlHEeXwzJWKT7zN8
67ZnGK953zUz4jnaQieMi5icHlGAjyZHbC+MqKcH6NrMiPHODj4ckTw9YmeW
PTMivqRn0fBQxLWpEZ9PjFiQEXGKnngwoukx5+no/Ig7eRHX0enbqNlMPxDx
dXbETxi0L/XxiCR0yZPu+y16zv5j+Ksg4jekqOMc3SHGe9Y/RWNqxMiUiEw5
lk2KOOLsPWqfjNb7eVLPSVROiHhDnm51XuRpiB6fFXEBG3EAH6JU/BP2TqdN
dCw9SNvkaXV+P63S0/VytcvVh8vIUc9ofZ1HV+lHhj5tUMPRnIgRejVdzn7P
pXSkHt3SrzK+q73/QrfoQy/dTRepJc/zcvHWY0DOOjmv0vfpq7xnWS9BiruZ
5P4G+dmuzoty3eAhXfzV+vU6fZuuUsNdWk/rra0U/xQfh9x/K9Ks51tfo2dz
6XfWcq2NUstx997J+7e0g7ajjofz3lt8b3vEjMiZxUsNLaFP44Rvs2kuzmEq
/zt5yKA/eC8Qf4FcNeYsN9dM0h41dOMD97cN68xfHbZ6TtP/Rjpez5LMXbdY
PTgjXq4e5JufIX2YaP8w7dKLRn5GiXebfsbnHbqXvkkr+F8kbzW+kLvNueO4
7T7v4g7K7RuWY7V+beR5Df03MYd69z3OooGnzSgXb5k4M8TLQS+PPbiJ086t
dbf7eRotxxjs85xsXxJqEnn1/knPpXgCe8SaS5+hVXIvFX+O92P2ltArZuxX
/GjOPtHHDnrN+1U0uKPNuMnr83rzAu6Tv9FsbUWZ2aniaYy1lxP99n5GrUXq
adbfOc69Q5fSTGsVdKwcl+w5zfd6Z7r0OMT9z/c+fi5jobkoc09NvObRg7Rc
joNyzqIb9OJjvur9hvv4XOc33CzuCu9HE3OH63IdVkuqPO30gn3ZZukQv3/r
w22zuUKMt7DNt31ow59iFLuze/leSCu97/L7LaQttFd/p/iNFyEZr+DZxP8A
novNUBtdwnOy5yV8LrC/Wt5CeQbMahpNEquSvqueNaiVq1aul9QxH2m+b5Fr
O6+LaS3GWc/BDrWM9PstVdcfehHmMFl/+mmSmJ1yPKWOFxN9QTUf6fbX0mI6
JNchPc7mbV7ifzB/PfzvdiflYmzAMjSqo8L9lJmTFLMzk86k/WrpxCXfNolz
2lpN4t7oYX1txl5nB7wfcQc/O9eLr8x2B+bz/7s9B8zK/8o3ArM=
           "]],
          "0.65`"],
         Annotation[#, 0.65, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1G1M1nUUxvEjpFttTkkTMdRIQ5AHIW7cKMuhm1i2ZTUj0awskjmjMYw2
V7rZnBlmuZnoCxJq6GZDcwyZOtScZYUuhWUze+EytgQbWm2NnNnnfvHl+v8e
zznX+d1krXzz2doREdHqz4+TIo5kRSxPi/gnL+IKfn04ogfH749YZ32Gtav2
/ItXjXfOjHiKttNxYyPSJ0cU4sOJEVuKIxpoC139QMRYZ69Pi0idHrHjQXty
Ir6gp/BOZsRPUyI+vy9i3tSIo7RrQkRjifP07oKIP/MjLqPX2qiiiDv3Rhx6
KOJbXLdvYiIiBZfEybQ+RE/bfwA3ZkX8jDR1nKZb3bHR/C5syogY6a6pYixL
j9jn7Ai1p6NjjJzUcwQV4yPWiHNVneflNEwPF0acxVq04AOUub/L3mm0kY6m
rbRTnA7n99AneVonVrdY19CH7HHq5OscWs2PKXyqV8P+GRrEq2liDvguoyN5
NMSvcnkvNv6BbuBDP22iT6slz/dy99VhUMxaMS/S9+jLcs8yPxtpejNB/67L
Z4s6z4t1RQ6Z7n+dX6/Rt2m1Gv6iDbTB3CvuPyqPNv3vQIb5fPOrePYI/cpc
jrlRajms771yP0nP0G7UyqHHuN16Z7Y3ImaWXFbS2fRxdFmbRXNwGpPlv0MO
Pb4/okvEKRHjrPPn8R0qjW/pw/e+H/UeeuhxnMQc4xM0wZ8SpPCqWU+G1T7e
O63S86XItW9AHjfcM0jLjTc712ytyf6L8t6pZ03YhU9wg4c38Zn6O3lcpP6N
xsV0rXzrsd35j5Gd6635bWTRKrqS5/PksEY+3Xy94jdxjK42LjH/nPWF9l02
/wQN5w6av2O+wniI/ofbKLV2ILmOdhzCl6j25tfzfQP6vK2vva0C/n5Dl8q3
CsXyLUUCp3hdQAsxE/nIQ5H6dqNUHY36f84b2iOXW95Om/E9/H/R9yG+vW/t
BC02v807LdWzd+kLdKq5BXS0Hl6w55jc65y7lKxLvretX6N9WOStlPO9ke95
tJXO502rHhbQer5sV1eDGq+p7Q2/623uXWG8P/kWcVmsvWqdKE43PWvfdPW3
8flvvbmpTyvc8RY2W/sUnfjDHQn9vUvei2iF8U6/6SLaTvt5Mck7KUYqXsLC
5P8FOSd42Ekr5Zzqu1Ke8+xfLG6ROIO8yqAp7qqg69WzCjVi1Yj1vDrmIsP6
BrG2yPUZWoMx5rOxVS0j9a5MXb/z4g5S+TPgvaa4s1eMx9SxJOkLFssj0/4a
mqDDYrXxeLrc5iT/L8vvN/k36cl8d9RjGTapY4H+lPudpHlzuTSXDqilFxes
rXPPseR7TvaN7uXrNjQ7O2i8Tw/OOdePg97PGcyV/y/2tHgr/wN5wAmL
           "]],
          "0.52`"],
         Annotation[#, 0.52, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1HtM11UYx/EHxC4bS7JUFDUUUUMEAmk2y4GbOG1Ja16Whhc0mZXFMNpc
5VYzI8xq88IfirCGbpY559CpI6ux2YYuRdGMtpzGCrFQa2vqGvX6/fHm8zvP
Oee5ni/jKt944fWkiGjwp2tUxLFxEUsfjvhnSsQVXC2M6MDXGREb7E+0d82Z
u6i03pET8Sw9QIemRQwfEzEVH6dH1D0RUUub6NrMiCHu3siKSJ4QsW28M5Mj
vqDf4e3REZfGRnw+LKL0sYjj9OjwiPoi9+kDUyNu50Z0o9Pe4IKIgaERh7Ij
vscN50ZMi0jCZXEy7PfTdue/ws38iJ+Qpo52uoWP99gbsGlkRApfY8VYMiJi
n7uh9uE4PERO6jmGskcjXhXnmjrPyukOPZIXcRrr0YSPMJ3/o86Op/U0lTbT
VnEOu7+HztXTarHaxOrFeWQ/ok59nUFX68cYfapRw/5JEf9hvJjX6XSaokf9
+lUi73LrH+hGfeihO+l8teT4vZS/avSJuU7Mi/R9ulzumezFSDObYeZ3Qz51
6jxrLlfkkMH/y/q1ir5FV6vhL1pLa9lW8H9cHi3mfxjp7FPY1+jZU/Rbtkls
g9VyxNw75f4NPUXbsE4OHdYH7LdO9EbEzJTLSlpMn8FRe3l0EtoxWv7b5NDh
9yd0gTiFYpx1f47fqXo2j941hyfZL7H/iAu4iC6sF/eCuF2owHZznsJ2Uqxc
upxtGTY7+wH+VGfR4xG7vOWF7J86n2X9ovVab/sV3NS/fixWeyPuN+f7cNXb
voIqM0myHoRkzHdmV6JPfP3mXrczjfq+GwfN4TYt5b+fltBb9Bfn7unp3cR3
p8aD8sqTc5eaC+0VIUWcwciwV2q2o2ixtzCIrcB+Plag0txWoV0/n3MuXczt
fE2gDexf0jPse+g9b6KF7UH9fMnvQ+bzob2TtIB9q/c3zSzeoYvpWLbZNFWO
55w5Ifdq9y7zNaBv/9rvpecxT79L9KNeX3NoM50l12Y559IaffnMW6n1vfaq
8zXf61Z+K6z3J94YusXa6zsZIU4bPe1cllpa1P63d3JLvyr4eBOb7TWiFX/w
UeS7GyTvebTMeodvNZ8eoD3mM9I7KkAylmFO4nuXc5G+tdJFiXn6vUiepc6X
i5svTp9epdMkvsrou+pZgyqxqsRaqI6ZSLe/Uaw6uT5Pq/AQeza2qCXFtzpd
Xb/rxQCS9ee6N5nEZ6cYT6tjQaIvKJdHhvNVtIjeEatFj7PkNiPx/1Z+v8p/
p5nM4qMGS7BJHbPNp8Q7TvPWJtPJ9LpaOnHO3gZ+TrCtTMyN7tXXrdjtbp/1
PjM4414PDnrTpzBT/j870+St/A+O/P61
           "]],
          "0.39`"],
         Annotation[#, 0.39, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1H1olWUcxvHfmuREclm6s6bLztw0p246NcsSFZy4rEWZgmblSw4tc6xW
SDkorEyzrPkSpE5iCisLkTnUphUDAzXnpMzNPyQd5GasLAiNmPY5f3zP9Tz3
y+/luu/nJJdWPrU6LSLq/fyUE3EoGbFwYMQ/oyMu4teSiBM4OiRijfkCc5es
uYEl3rcWRjxK99GBd0YMzo0Ygw+yI9aPj6imdXTFfRED7L06PCItP6I2z5r7
I76g3+ONoRHn7o34fHDE9GERh2lTVsSGCfbTvmMjro2J6ECbuT7jInrvithf
EPEDrlqXNVEjOC9Pjvke2mL9V/ijOKIdmfpooRvFeMv4dqy7JyJdrFw5FiQi
9tp7Sz+D9X8gU036OYTSQREvynNJn61quk4PFkWcxCuow/uYLH6TtUm6gfan
u2mjPAfs30Vn87RSrma5ruAs8u/WJ1+n0GX8GMqnKj00jIy4iaScXXQyTedR
D7+mqbvc+2law4dOuo0+rpdRnheKV4luOVfJ+TN9mz6n9mHGJyLT2QzS71X1
rNdnq3O5qIYc8V/g11L6Gl2mh79oNa029rz4h9VR7/wPIGG80Phynj1IvzM2
wlgfvRx07m1q/5Yep81YpYYT3veZbxzhjsg5TC2L6UT6CJrMjaUj0IIh6q9V
wwnPH9K58oyXo9X+WZ7782wAyjzP4d0ZZ5jpvcN8O87Jd5ROsueGszrm+R10
ydksVzet5cHLdAvdiqQ8t/Q0h0c36Vo916BglDNDHi67wyv4Ptz9y0cekviG
Rz/a1+o8Xnf2p2kdfzN8E/1QpJ4d3ler8zPaIO41OcYaT/KvTJ+TxJlNG5xV
sRrH4SHfVYac/fCRdX3p7fhU3z32rxSvUIxsNSXwpDrO87wdv+ACOjDfvftY
/59gM3aiFjvQK89KMR5wTtP0UIYl6ntMHQl3ZYv54XS7sS/pKeO76L88qzeW
weNnPO/n5XvmjtFi45vc1wk8fZPOp7nGZtL+aj9jzRE+VNp3Xqxe3v5n/go9
i7JULXzcoK5RdDedob/dfB1Nq3iwWV/Vvu8rzv0l3/cmcRd5b0jdSXTItcfd
yJKnmZ60Lk8v9Tz6m89/8nORGK/iXXM70YjfxSjh123qLqOl3rf6tovoPtrJ
92x3qhhpeBazUv8Pai5xbxvpPDWneZ6nzunWl8tbJE83rxI0xCqla/WzHBVy
Vcj1tD6mImG+Rq71an2CVuAO4/nYqJd03/Zkff3Gi16k8afLWYaYbXI8rI+5
KV9Qro4c6ytoCb0uV33qPqttSur/WX2X1b/NmcwQowoLsE4fM53PNPc30z0c
SUfSLr204Yy5NeIcMbY4dW50D183YYe93d73OoNT9nXia3f1OKaq/4I1de7K
/8djBJE=
           "]],
          "0.26`"],
         Annotation[#, 0.26, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1GtM1mUYx/FL3WxziaaAoYigQHhARQtnmUdYdKAXaPNUaSYrs/BAm5m6
zKVptpqiWzNlDtwsMsbQ1EhrbLbAQlw1pRdOsyXStMPWtDWSPs+L3/P9/6/7
vq/j/fyzlq0qq+gVEQ1+vh8acTwrYuE9EX+PjbhElydFtNAXwyLWWc+2dsWe
27TUe9WYiEexDgcOjEgeHjGW3rk3YltBRCUewBcyI/o72zVKsOyIXSPtyYv4
CL+i9ekRP2ZEHEyJmDEi4gQeS43YPtl57Jsf8ce4iA5qt9ZnYkT3oIj6nIiv
qcu+lPsjevCCOGnWb2Cz/Z/QzQkRFylJHc24g4832PfSlrSI3nyli7FgSMQh
Z++oJ1n9DQPkpJ7jVJQcsYL/K+psk9MtPDo+opXW0AF6mwr5P2ZvJm7HfliN
jeI0OL8fH9HTCrGaxLpG52nUYHXq61Rcph/D9Gm1Gg7fF/EfZYrZiYXYW49u
6Nd0eZd6/w436sNV3INPqCXP80L+Kui6mCvF/AE34zNyz2CfTElmM1i9XfLZ
ps42c7kkhzT+n9ev5/BVXKaGP7ESK9me5f+EPGrMv4FS2UezL9ezKfglWw5b
H7UcNfd2uZ/GM9hEK+XQ4r3OemOuOyJmhlyW4GR8iI5ZG4c51ExD5b9LDi2e
38UycSaK0eZ8sef+elaEj+nbLJxN69W12R17k16WWwnbLnV+zncTfWb9NJbq
wSl8WO+mUeZo98H9zeF7Pm5Q6yx7X7FvmNpW6PM5z9+Y6RR3r5Cq2Fu9n6UW
arf+Le1mb8MC52/r72z+Jqh9HdtrNNJ6hnqG03kz+cB6vf/NJmufYi1fRzDH
+ny2BZQm/lAqM4di/VjEdkd/FmIPLsb31TFA/nP19KbnMsyVZ6YcOtybVOdT
aBA1ex/Bni3GQWe67V0lxzW0lnr05qIe9NW7TrxMm+z5xftW3Jc4Y8+L9j5g
ttPFL6Gl9j2uplS177Y+EveyfYxn2ffjP3zUsN1llos81/O31dopHM++U26T
5PU6PoXpbHOwn1mes+ekvCucu8BXt7n9a/0anqeSRC76t11eeViNM9VbrR9j
cLV78Z77WOmbcM39eck3YSe/i70fTtxj6hCr1p1KEacJW+3LUkuN3v+l97+b
32I+1tJb1j6kRvqNjwL/7V7yLsEi71W+B/lYh1fdxyG+GeMp6GkqTnxT5Fxg
ho04T87heZ48Z9hfKm6+ONf1KhV7sAg3qGc5lYtVLtZcdUyjVLE2irVNrk9i
Od3NPop2qKW370Ghun7Vi24K/ek0yx5q5/tBdZQl+kKl8kizvxwL8JZYNXqc
JbepiW+6/H6W/x4zmen8alpAW9Qxx3ymu8NJ7nYu5mKnWtrpnLV1/JxkW5KY
G9bq607a5+x174fM4KxzV+mIb/MZmib/n+w54K78Dzf9DXA=
           "]],
          "0.13`"],
         Annotation[#, 0.13, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1Xtsz2cUx/FTiSWyiUtb6tIpSl1aK2MxTTVhmWWzmHtnw9DsIrFahWyz
EMFQYYZITBtpJS5bREpUqmXFomzUWLA/hFmmtdhYZixW2r36x7uf7/e5nPM5
53m+v/aeWzjpw4SIqPLnYveIw70j8jtF3B8ccQ3Xh0XU4WiPiCXm+5q7Yc1D
zPa+eVDEK3Qf7dAxIjE1YhDWpUSsHhpRREvou2kRz9h7u29ECzb1sWZAxB56
HB/3jPjp2YidyRGje0VU0kNdItY8bz9tmxVxNzPiKurNtcmOaOocsb9fxHe4
bV3S8IhmelmeFPN3aK31X+OP5yKuoL06aulaMZYZ34oV3SISxOohx/SuEbvs
faKeRPUf6MCTeg5jbFLE++LfUOc5nh7Qg0MizmAhSvA5Roh/yNpedA1tR0tp
hTwH7N9BX9bTBXJVyXULF9AnUZ36OpLO0Y/u6RGFatidEfEYveRsoCNogh7d
0a9cvsd7/4Eu1YebdAt9TS0ZnvPFW4BGOefLeYkup2/znmp8GNo7m87qvc3P
anWecy7XeEgRf65+vUMX0TlquEeLaJGxmeJX8lHm/A8g2fgA4/P07AV6zFi6
sTZqOejM63mvoadoFebzUOd9n/mK/u6InKm8zKLD6CgcMjeYpqMW3fjfxEOd
5/V0mjzbaL48l8S4iAtiDvF+1HNXHsrVc0Rt7fSlkpZ5P8H3SdSJN1M/TtNq
Z5Ojb6nqSnOXBti/2NhAmo4M9Mc09ZUgx/0Yhb3270FPuc7q4/c4jTOoQ66c
E/h9A1utWea+L8dUMTrSRXzc5+kf/I2HeIA8307mwIgsDMZUsabgGO7Kdw81
nr/FcTSpYRp9Qr8w95gOV8cGNW3EJHOPjE2k/9GNzn4DkvQlEZ2wnr9q84ud
wU61PqQL9fOE55MYqa/F+j1B31fSGjWto53Eq/T8o1quoK171ECv4zMxfvW+
im4Xo8mZvifmcOefK9c4zLbuVV6S9epL873pVmN76VnjO+i/YpQZe4qHNz3v
F2+VuWqaZbzYdzCUl0/oFNrD2Bjajtfz1hzR0wX2XRarST8fmb9FL2Bcqxdn
vYavDFpK8/SjVN8G0kLntMGdLfK7cct3+YHfjWJxZ3jf3XrXcVWuct9rkjxV
9Ix1aWopc5/+0ps/9XaGGB9hpbmvUIHfxcj2/Qff4+hY75v9ZmTSffSme9LF
70oWWvh5i77U+rvDc7a+V9DJPLe4L5P5HG39eHkz5WnUq2TaTMfST+2fhwK5
CuSapI4cJMu1VK7VvL5OC/C08T5Yq5YE92mEun7Tiya0yNPgLJtRL/aL6pjY
2heM5ynF+gKaTR/IVabHafaMbP3d5+8X/rc4kzz7CzEdK9Qxxvnk+n/RXi39
aD/aoJZ6nDe3RJwjxma1nhst19dibLe30fsuZ3DWvpv4xrd5Cjn8/2xNibvy
P6BIHaQ=
           "]],
          "0"],
         Annotation[#, 0, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1Hto11UYx/FHsBomOedszWxzalM3ay5X6tB5qZSahG6gWV52oYswZguk
UgpR8wJBqX+03IgpmBYm23AyUxGMVNKZC7U/RLPaxbQMwkw2t3r9/vjsvfOc
c57r+f6yKlaVVA+IiAZ/zo+IOJgVsXhoxN+5EZfpylMRJ+nwoxGr7Y+2d9WZ
f2i59baciHm4Dx9Kjkh5LGICbXkkYmN+RA3W4WujIh50t3tMRD99PNqZ8RFf
4DF6Z2TEjxkRnw+PmJEZ0YLND0dsmuw+Dnwi4s+JEZeozd6ASRE9KRH7H4/4
lrqdG1YQ0YcXxEmzfwOPO/8l3cyLuEiD1XEcN/PxPvsOWpeuAXyNEGNRWsRu
d++pJ0X9B4bIST0HaU5qxBv8X1XnGTndxqYnI07RKqqjD6mA/2ZnM3ATJmE9
NopzwP2d+LyeVonVKlYHnaOsYerU1ylYph/pYyOq1bBnXEQvZYjZiQUYenRD
v6bLu9j6e1yjD9dwO76olmz/L+avirrEXClmO36Ar8p9JHs+DTaboertls9G
dZ4xl8tySOO/XL9W4NtYpoZbWIM1bEv5b5FHg/kfoFT2cewVevY0HmUbwzZA
LU1m3ib3I3gCW2mlHE5a77PfmO2NiDlSLsswH6dRs70cbMJ2Z8/TEWcL+P1X
r+/QIPXOUu9RvT1GK9RXRqfVuhyL7M2kUn6SnH2A7qfv7M9Xd6r+zeJ3Js2g
peLniDFLP8r1YiYWshdhmfU2dU2znkrP0EJvPH1CxFrv+J69XponVqv+5Mu7
nL2C2qlUvK/52atvQ+SQTDudWcBeh3flVIufUp4+1lKr7+cwrRdjkP3fzeg6
XdC/m/icWLfwV7n1yv0lvV9vTkfYt2CyOy3+/0HMizTQ2U68Qmud/8V6A9aq
uUfc19U0me/pcppLy517wTtJlfcn9kfhDra9eJp9J97ho4HtPnN52f/7+dtg
7xucyL5VjyfJ5V0sxRFsszFJrmedOST3qkRNfPWo8679DjxHcxO5mOsmeWVj
fWIW+lZvpuOxWl8/8p5qfNMdvpk3fdNb+V1ivSfxDumSWLt8S8PEacVTzmWq
pcGM/tKbP8xsCR9v0Xp7n1EjXecjz7f5H87FObjN95yL+/Ca+Qz3BidSv3xe
wWcTvwlyztP3RiyRc783UiLPGc4Xi5srTpdepWIfzsH33K+gSj2qFGuhOgop
Vaw1Ym2U63yspEHsWbRZLeGNF6jrN73ooX5xOs2yj9r4nqqOBYm+ULGc0pyv
xDy8LVaDHme6MyXxmyy/n+W/3UyK3K+mRbROHbPNZ7p3OFgtY3Esdqqljc7a
W83PIbZlibnhLn3dSrXudlnvNoPT7l2jr/y2nqBC+f/kTJ238j/oqwiO
           "]],
          RowBox[{"-", "0.13`"}]],
         Annotation[#, -0.13, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1HtM11UYx/Gn2ebKOQWUJOQmoQaFJIZzYBMLl7ZCXaKVZrIymlNpo4tW
c2oorVbqP4Su0M2iRoROHWrNzTZ1KXYZ2sVpVCLN0lqzVihkr98fH96/7znP
ea7nkFO9cu6KGyKi0Z8vb43YkxNRlRTxZ0HEGTo7MeII7U+PqLOfY+8cm79o
ke9N+REzsAWHDo9IyogYTxtHRay/K6IWt+KT2RE3O9ubGzFAb45hMz7iPfyU
nh8d8XVmxDsjI8qyIvbi7tSI+mLncdCdEZfuiDhNnfaiKKIvOaI1L+Iz6mWX
PCmiH7vESbV/EQ+x/4B+nRBxioao4xBu4ONl61toTVrEdbZpYsy7JWKHs9fU
k6T+tmFyUs8eKh8RsZT/c+o8LqcruKsw4iitoK30KhXzv5ttBtbjYNyG7eK0
Od+E9+npMrE6xDpPJyk7RZ36WoKL9WPUbRHL5bVzXMRVyhCzB4vxul5dpFI9
mOX7c1ylD924GWeqJc/vKv6W0QUxa8T8Cl/BR+Webr2IhpjNcPX2yme9Oo+b
yxk5pPL/hH49js/iYjVcxlqstfYY/3vNqtn82yjF+ljrS/RsEn5ibYy1UMsu
M++U+0E8jB1UI4cjvlvst4+N+Jj2Uyu10Uc0wNdqc3iJMm6PyKJMeti9SsfR
NJ2P5+xfY1vu91W8B8toLs2hbLEqcTaVUh37Pnat8v8XJ1u7m1L5G0lFerFU
Hw+o8Vv3swOrfedbv6Q/l+kZZxe62zX4Pr2hl3/wNVqPKvXxIZqvj1X2hjrX
pM4ZfDU5u8X3TNyMDeK9Rt+J/668uuT6vbP3mkuJOi/7/RPbq3w9qK9r+T9o
byMOM8+9fn8hxikaxLYHz9Jq9j/6XoeNetkn/lNiTOS/1LwraBG7++WdIo+3
7GfhlkQ9eMx6E/7NR7O1G81yvt+t/K2zdwALrDe4fxPk8gLOxTRr03CwXE+w
2Sf3Zc518dWnzn/sn8eTVJHIxZuol1cebsOp+rzN/R2Hy/XrdXel1ns97z08
7b028LvA987EHaPTYm33TpLF6cCj7DLV0mxmv+vNb+7hAj5W0lp7b1M7/cJH
oXf3H1ZgOW7yVvOxBbvNcoT3XEAD8nkEpyfeu5wL9b0d58h5wIzmyLOM/Sxx
88W5oFcp2I/l+KLzS6haj6rFmq2OKZQi1iqx1sv1Aaymm6xn0wa1XHe/itX1
s1700YA4PWbZT518T1ZHZaIvNEtOqd52NRbiFbGaE+/FmZLE/1v5/SD/zWYy
1fnlNI/WqGOa+ZSKNUQtuZiLPWrppBP26vjZZ21hYm64XV8bqNHZC753mMEx
57rpQ3f4ME2R/zdstror/wOTswZm
           "]],
          RowBox[{"-", "0.26`"}]],
         Annotation[#, -0.26, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1HtM11UYx/FHW65YS+SSpCJeAINCE6M5dEFL8zJXaCrlBSW1NmfS5ipb
zRBBtlap/ygwhzrKmmNo4uw2W23pUuwytTbTqASat1pZa5iEvX5/vPn8vs85
57mew+inq+atHRARjf58PSzi4OiIBUMi/rg34izOFUZ8gQ+GR6yzPsraeXv+
whLfW/IjptO99I7kiOTMiHHYnBFRMzGiijbSFaMibne2Z2xEH94cY889EW/T
T/DCiIhvR0bsTI+YkhXRTg/cFVE7yXk6sCDiyn0RZ9Bh7eaEiN6UiH05EZ+j
x74hD0TcoKfESb8/4iI9Yv+7uGT/aSSp4wit4+MV9m3YcHdEv70ZYswfGrHb
2X/Vk6z+1sFyUs9BlKZFrOL/vDqPy+ka3T8+4iieQyM2oZD/A/aOoLV0EG2i
beK0Ot9AH9HT1WIdFusCTiIrVZ36WkQr9GNodsQaebWMi7iOEWJ20ULar1cX
UawHs3x/SdfrQyfdSmeqJdvvBfytRreYz4r5DX2VPiX3YewTkGQ2g9XbI58a
dR43l7NySOd/mX4tpc/TCjVcpVW0im0R/+1m1Wz+rUhhz2FfrmeT6Mdso9lu
OrPfzDvknizXUmslSHf+IfFL8Km8bqo3lW0/n2l0gDoCOXLLRq71Fn3p1+PF
8tto3yI6NjdiD3uTuzZXLcPyIub5fat79QSdx/a+2oayZyAZaUhN7FPrykQc
c1lFv3dmBa1EmbWLuIQruIxl7nIFlmKXM814wz2Zo74dYuXzOVy9r8mpGgvZ
y5Gr3zvl+CgfMzAdszETDah1rg6bUI/N+F1tf6r1BzMp4vsq/dne6+xz9K9a
nI/UtpneqX/tfn+lJ6cx0N4ueg4v2/+T7410u5x65bFSThPlVKyv07DEvhnm
kKJPb1kfSbexvUOPsTfQv/loZrvFTBf6vS8xA2sf0nz2erMdL5cX6VyawVZC
B8n1hD2H5L7auVN89arvH+sX6ElMS+Sil7XyyqZNdKoZNLnHuXSNubzu/lR5
txfcg2e823p+y323JO4azoi1y3sZIs5hetS+TLU0u0u/6c1l97Gcj7WotrYD
bfiVjwLv7z86jZbSLd5sHt1LO93nVHPIR598nqQPJ969nAv0vY2WybnPjMrk
OcX+WeLmidOtVyn0Bi2lLzm/HJV6VCnW4+qYjBSx1otVI9fZtBK3sWehTi39
7luhun7Ri170idNlljfQwfeD6ngs0RfMklO6N15JC+g1sZr1ONOZosT/Xfn9
KP+tZjLV+TWYjw3qKDGfYrGS1DKGjqFdaunACWvr+DnEtjgxN7pLX+ux3dlu
37vN4JhznXjPu/gMk+X/nT2N7sr/yEoClg==
           "]],
          RowBox[{"-", "0.39`"}]],
         Annotation[#, -0.39, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1HlM13Ucx/G3LTPXiiPSTEQRjx+FJkYzddOWrWxWOCE7TGGWKLNwc5Ut
MyCU5e0/CqzhgVlzaiZm19xyS5dix9TaSMUCbHbomrWGQbQevz+ev9f3+zne
9/eXPX/JrIo+EbHdz9d3RBzIjihOi/jjrohWnB0f8QU+Ghyx1P5Qe+ec+RNz
vG+4M+JBuovelBqRMiRiFFbdHlGdH1FB6+n8YRE3unsxJ6IH64Y7k4jYST/D
S5kR32ZFvH1bxKShEc10/4CImnvcp33GRPyWF3EGLfb+uzuiKz1i98iII7jo
XGpBRDc9xU/GuIhL9LDz7+IX50+jvzwO05VsvGZ9E1YMiuh1diAfRQMjtrn7
j3xS5L8nRUzyOYCpGRHPs39OnsfFdJW+PzbiKF5APd5EPvv7nR1Ma2hf2kD3
8bPH/Tr6gJqW83WIr3acRNat8lTXAjpXPQaMiFgsrqbREdcwmM8Omk971eoS
JqrBdO9f0mXq0EY30oflkuO5mL1ydPJZxuc3dDl9SuyDrI9Ff725Rb4XxVMt
z+P60iqGDPbnqdezdAmdK4ffaQWtsPY0+8161aj/e5BmfYT1EjUbTxNsDsUw
ZGE4svEhP6PoaOSgSDyzsDyZq7wr2axCutjS8Kjzi5wrxwIsRBmK+blgdtpw
HuvFcMT6Onq992b39rLzAU3PjZhpFsvMYiHdoQ9N2I40ez8434rvcUheJWp4
nq023GcO+rq3l51+9AbMMMNrrK/FAj7KkLA/z/0SlGKLXF4fxYdaLqc76Apa
584bdKf3K+aliSbM7mprlz2/Ra/QNXS0PiawzvN6rEVZ0icWYSFyxdKpZz/i
mnsz1L5Snz7R11X0Zj1v9vyVGE+jjx530LN41fkL3qvoZra7xPwce+PMx0S5
T8Mc5x5K9kJ+6+0PoZusvUOPWa+jf7HRaO06M/CE593sVdn7mOZarzWjY8Ty
Mp1JB1qbQvuK9YQzB8Ve7t4ptrr042/77fQkpiVj0acaceXQBjpZfxrUZSRd
rNarfRcVvul238wC33Qtu7O9N9FPcYavreYrlZ9D9KhzmXJp1OvLavOrmZnN
xouotLcF+/AzG3m+zX/pNDqVbvA9J+gu2mYG0/UwFz3ieZLen/xPEHOeuu+j
hWLuMXOF4pzk/HR+E/x0qlUa7aZT6Svul6BUjUr5elweE5DG1zK+qsX6CC1F
P+tZWCmXXvOYL6+f1KILPfx06GU3Wti+Vx6PJeuC6WLK8K2V0jx6la9GNc50
pyD5nyy+8+LfqCeT3V+MIqyQxxT9mchXf7lk02zaIZcWnLC3lJ2D1p5J9o1u
VddabHa30/s2PTjmXhveM7efY4L4v3Om3qz8DxqFCIk=
           "]],
          RowBox[{"-", "0.52`"}]],
         Annotation[#, -0.52, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1HlM13Ucx/G3zZVzHiBpimJIHugPg9KZuoBlS1ozM9AONSm15UhsZtlq
Lk1layvlj8hr6mZac04ZGBnmlgeWQsc8/nCaLQ6Hpc6ZGSbR1uP3x4snn+N9
f76/YfPfKF7SLSJ2+vNjekTNsIiS1IjriYhzdP7hiGP01eCIpc6HOrvgzp80
23rdmIjHcRf2TInokxExgtYOjFj1UEQ5bsRXMiPuYdv2QEQnfZTlTnbEZ3iQ
lg2J+HloxJb+EZPuj6jF6gERq8exxxgb8UdOxBlqdPZfbkRHv4jdIyIOU5t7
fcdH3MFT4qTlRbTjIfc/p8vun6Ye6jiEa/h4134lrRgU0eXuADGK74vYzvYf
9fRR/56+clJPDRXcG7GA/wvqPCGnG7jvwYgGep020geUx3+1u+m4GrvjJtwr
zh72G/AxPV0kVp1YzdREGWnq1NdxOFc/+g+PKJPXjlERtyldzBbMwy69aqeJ
elBk/T0u14eLuB6nqiXL/yX8LaJWMV8V8yd8D5+X+0D7Y6mH2fRWb5t8Vqnz
hLmck0Ma/y/p1xxcgnPVcAXLsdzeC/wfMatOe7VYQ9WUI+8EZVPV6IhPqMmd
ejxIN+3/RU1qqxe3EY9hAx2lSu+ptzfRi5bLdx+fX8qtkO027+lRLKB86jCf
afL/G5eZ15s0kn2tGkfgXLXMoVz2L+vLATmf5bcO51mPtn/ZeQG/Od7lYvbl
NJXP63wm7LXLfab7r8ljM5+F3tkWbKar+nyNFrBZSNfY3PQGbulfOrtB1FO8
GdYznI9he1jMVN/Es9YV5vyUs91yOGq/n/0jmHDvG/WtU/9JPk7QXfwU6/13
I82bGqjE+ji2m9tlmqiOS3w9glesb/P9tVr68bOWj15Ya/2DWk5TuNOC5+kd
d3+1XolVfHbIbb76c72VieYyhWa794Q3kyLHj50PwUp7O/G4/Q14k4+t9rrJ
bab/d/O30tkBzLZf4b3myOUtfAYH2MvH7t7USXf2y38Ru1N8dejBLefNyTdE
U5K5+IZWyysLN+Fkc9xkBsOxTI8+9I2U+76bvbGFvu8KfmdZ78B6OiPWNm+u
rzh12ODeYLVsNeOrevO7uc7iYzG97+xT2kuX+Ej4Tv/FKViA63zbo3AXXjT7
VLPPpk75PIeFyd8HOSf0fS9Ol3On2UyX5yT3i8QdJU6rXqXgHSzAt9nPo1I9
KhXraXVMoBSxlou1Sq5PYindbT+D1qily/vJU9dvetFBneK0mOUdauR7vDqm
JftCRXJK852UYgJviLVVjwezGZf8fZbfL/JfbyaT2ZdRMa1QR37yrYnVQy2Z
mIktammkk86W8rPf3ovJueE2fa2gKrat1tvN4Di7i/SF7+BbmiD/s+5s9Fb+
ByknEAk=
           "]],
          RowBox[{"-", "0.65`"}]],
         Annotation[#, -0.65, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1H1MlWUYx/GrkVJLOYbgC2pKmigilObQCQ1c0R+Fm6alYlTW5ixXrrLZ
LF7M1qbi2kzI1M205pw5NXQ1t9iCJVg2X1ZOoSXSrNYyNKIgK/ucP77n9zz3
fd3X6/2c7GUvzH/+pojY5+errIiD2RHzb4+4MiXiHM5Pi/gcR0ZFrLI/xt4F
Nlex2Pum3Ig5dA+9dUjE4DERE/DGiIjqeyJW0nr65LiIgc52jY/ox4Y72UyK
eJ9+ihdHR3x9R8S2zIiZYyMO0QPDImqnO09v5EX8jDNos/dPQURvesTeuyKa
0MUu7d6IPnpKnPS7Iy7TY+w/wI/sTyNVHcfoOj7WWN+MtSMjrrPNnBoxb3jE
Tmf/Us9g9e9LyEk9B1GcEbGM/wvqPC6nbvpRfkQznkU9alDA/wG2I2ktTaEN
dL84+5zfSkv0dLlYjWJdxAmMHqpOfZpGK/QjY0LECnntyon4EyPF7KQF9Lpe
XUahHpR5/4Ku1ocOWkcfUEu25/nmtByXxHxGzJP0Vfqo3Idbz0OqmIPU2yWf
anUeN5dzckjnf6l+LaEr5f+avbXIlddk5KDC+iL7I9T1GB1utsMwFC38NONb
vtLMeAlfFVjgTOvEiElyWMpul1oXs1kjj3H2y2mJWc6l29yfI/ItcMfqzGMz
quWa772K1qIGmd53sPvV8xVcRrnZ3bD2H/7FN3I4i0Z9Oak/FfrUzq4D77Ht
46NYvDz5TMFUaw2oMZtalKhlDkrRYv2Ee/olmvQtwe8Q9zyBNLzN17vIZ5dC
m/TnZro7WY/9oziMRnyM0+x+o924gmu4itnm1SD3gc7W0wFJv/QW+oS8U+lC
OQySwx/si9n/TotoD52lxxsnm4f3DTSDbqK30UP6267/FzCbnzf5G+S5R+3N
/HXyex6vmM135l5Ft5hbr/2n2OXzXehMKRazu99dSji30f4outnabtpifSu9
xsd2a2H+j3jey1+VvaM0x/p693iK+b9E59JMa0U0xb1qZXNY35c7d4qvXjX0
2L9IT6A0mYse18ormzbQWebbYM7j6Qrzecu3s9J3f9G9fdp3v57fBd530U9w
Rqwdvrc0cRppM7sstWx3X37Rq5/0aAEfz+F1e+9gP37gI9f9+JuW0mK6yTc/
ke6hHWY7xP9CDvrls5Del/zfkHOuOeyn5XLudzfK5TmTfZm4E8W5pFcJ2keL
6cvOP45KPaoU62F1zEBCrNViVcv1QVqJAdZHY51arrsLBer6Xi960S9Op1n2
oY3v6ep4KNkXlMkp3R2rpLm0W6ztepzlzLTk/7b82uVfZyaznF+BeVirjiLz
KRQrVS1j6VjaqZY2tNpbxc9ha4uSc6M79HU9tjh7yftOM2hxrgMf+tY/wwz5
n2VT7678D/F3ECA=
           "]],
          RowBox[{"-", "0.78`"}]],
         Annotation[#, -0.78, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1G1M1lUYx/Erl9REUAQM1AjlodBEQadu0qKUNhNS0JZzUssWo9wiy00z
Ix42tlLfpLCmbpQ158wJs1Zzqy2ZKCun9qJFtEDKam0NnEGQbdXnfvHld5/r
nOtcT+fP/O0NNS/dERHt/nw1J+LM/IjqtIg/FkV8i+9KI77Ex3MjGuzPs9fv
zCi2WO9fGPEIPU7vnhkx/d6IPLRkRTSWROyg7fSZ3IipfIfzIibx1gJnHoh4
j36GnfMiLudEvJsZsfK+iC56enZE0zL+9N8HI37DNVyy98+SiLFZEScKIr7A
sHMpyyMm6BVx0pZG3KDnnP8Avzh/FUnqOEeb3bGb/SD2ZkfcdjZjccTGeyKO
8f1LPdPVf3KGnNRzBmUZEc+6v1+dvXIaoR8VR5zHC2jHmyh2/2lns2gTnUI7
6ClxTvI/TB/W0zqxzoo1iD7MTVenPpXQrfqRnh9RL6/O+yPGkSXmEC2mt/Xq
BlboQYX1BbpLHwboAbpWLbl+V5tTHa6L+ZyYX9M99Em5z2ZfhCQxk9U7LJ9G
dfaaywX0I9usptrLlvdlvUjy+y5ksmdgFob47eX3GtbJt6UwohXNGNWPEXSq
Z0lRxFIUoxQlKOObTKdjGp73Vqq8mWVmuVP/x8Tslm+eN9ZF8+k+8V9HMd9q
OW5T78/WtXQrNrA9gTY93WS9GTWJnrCtQQt7K6rZDutRj14donn28rHWe+x3
30KxO7DBe9yImWrY7Vyf3xfs96LQ+SR5FNAG65exEzXOVOMq/0F7aXxnoURt
j+r3HvekWz+txgV6uM7MU/Qrk6bS9TSPPR8FGLf+Ux/HMYYq6y73VNI290xz
JhmZ5vuDOYyy32K/mXhTdAyLzXyF3MqxRW5rzD5V7m/bm0MPsr1Pe9gP05vu
OcL2nztq/D5B37D3CS1kb/XuFvqeXqFVNINtNZ3iXV50plvddfyuuGvMbG/Z
H6R9KE/k4k01yTmXdtBV5tFhFgtovRm0ees7fKeDvoPtvtNW926y7qSf4ppY
R723FHHO0vPOZavliN7+rje/eiub3PEi9tk7hFP4yR1F5v83LadldL9vtIAe
pwNmNkOPCzEpn830ocR3Luci/T1FK+U8aZaV8lzpfIW4BeJc952n0glaRl/l
vw21elQr1np1LEeqWLvEapTrY7QWd7LPRbNabvsOitX1o16MYVKcIe9iApfc
XaqOxxN9QYWc0nwbtbSIjoh1RI+z+ZQk/s/K73v5HzCTVfzrsRF71bHafFaI
laSWHJpDh9RyCRftNbinm+2pxNzoUX1txTt8r1sfM4MefgP40Fv+HMvl/40z
7d7K/4P7+Zo=
           "]],
          RowBox[{"-", "0.91`"}]],
         Annotation[#, -0.91, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1HtM11UYx/GHhHkPgUy8RRgmapSXQIWWbdKWooJYmommbsxyRZlbTUwx
NjdT11KhUjeLnGPmzGmrudVSSsHLzLZcxgqhUNfWrDlMwpXr9fvjw/v3Pec5
z/Ucsle8Ul6VFBEN/pwZFnEoO6IsLeKP8REX6cdJEcfp6PCIKvvD7V1i8yct
9L1lXMQT2IC9B0X0Hxkxit7KjFg/MWIV1uHS+yOSne14IKKbNo9ikxvxIX5B
r46IOHdfxPuDIwqyIj7Fg/dG1Ex2Hv97KOIaXaBme7cfiehKj9g/OuIr6mA3
4NGIW3henEETIjrxGPuP6Qr77yhFHcdwIx+vW99Ga4dG9LDNyIsoHRKxx9m/
1dNf/Y2pclLPISq6J2IZ/5fUeVJO1/GThyNO0AtURxsoj/+DbIdgDSZhPR4Q
p9H5nfi4nlaKdUSsNmqhYRnq1KcJuEg/0nMiVspr75iImzREzMuYhz161Un5
elDs+1tcow+tuBVnqCXL7zJzqqR2MVeIeRbfwKflPtj6OEoRs596O+SzXp03
MdOMkq31ob70r1zuUBqfvdin4yQxTj8YsUBtjfgMLua7ggrsTaER7OaKUej3
NJpKJ+Uwi8+f9aJcHm241F34BZ/HJbRdP96laneh2wzuHhuRSgNprju1iM1U
eT6L0/A5zMPV7K/wvZzS3MsVeFQOZ8U9R3PYzaZNfJ/2fYZOUQs1U431E9hE
X9MOZ49jcqI39lJwA7bz3cvvHrWOlV+qeXWaQ70ariTmZL/aerZYv/mebSar
E3m46xVyWkJJbObI96r9dXxewx+sX6QcZ1txPN4W4y62vcWb7S3NoZlUQrPo
GzalWEZzqZzmUR/28/nvi2Pk0Q9z8QP3ulDfq82xypxfppdon74+pb9ZYr1j
njfcw2XW69m/R5vVuJC/t3EoX9v8/gibzHcn/uXu7LJ2x7l5fu/HN+19hqOt
16pvrPe3OtEPzLBWiEnu8Sk2h+VW6dx5vrrkccN+G7bQdPnm622NfLKwHqfo
ab3ZZONKfd3kbazyrtvc0+XedS2/5b734ud0Qazd3tMAcY7gCXaZatllLr/r
xVV1l/PxIq2zt4MO0K985JrPPzgdi3CLN52DDdiauJ/e/Wjqls98fCzxf0HO
ue76ASyRc7f+lsizgH2xuDnitHszA/EWFuFrzi+mCj2qEGuWOibTQLHWiLVe
rk9iBfWyPow2qqXHvPMSb0gvuqhbnMtmeIua+Z6ojpmJvlCxnAYl3inm4nWx
dulxpjMTEv+X5feT/LeayRTnV1IprVVHofnki5WilpE4Ei+rpZlO2avi57C1
BYm54W59raXtzrb73mMGTc610j536kuaLP/v2dS5K/8D5A8FOQ==
           "]],
          RowBox[{"-", "1.04`"}]],
         Annotation[#, -1.04, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1Hto1lUcx/GvNoTcbLp0a2bTOW1aT3mbghMNsqBpzFSKaEQXxnTV0uZt
XtIGQTm7qHsUJygaOtTUpk0FzbS8UF4WUV6gbZoVQRiE5TJQ6PX74/18nnPO
93xv55xf4atzZrzZLSIO+vmmf8TuwohpfSL+eDjiB1wYHfEl9t0fUWO9v7WL
bP7Ec8YrH4p4jG6hPXpH9HwgohDv3BexbFRENW2kLw6KuMveK0URXXhvMJth
EZvpAcwZEHGmIGJ9v4ixAyP20F25EcvH2E9vpyJ+QxtOWftvRMSNnIhtQyOO
4Aq7zJKIm/ScONkjI67RQ+y34hf255GhjkN0BR8LzK9CXX7ELbY5j0SU50Vs
tPcf9fRUf3O2nNSzG6V9I17i/6I6T8jpOt35aMQxzEIj3kaK/11sc+lyGjRN
d4jTbP9aOlFPK8VqEasdp5F/rzr1aQR9Xj/6DImoktem4oi/kStmB03RW3p1
DSV6MNn4a1qrD5dpA31cLQX+T3NOlegU8xUxv6UL6Uy59zU/HBliHjV/R7xR
9u18MKK3fJtpdpI3rdOLxViIRWiVx0EcQHkSk58Ge1fi/UTdicN6eFb/8tR8
hubSfhjMXx93IE+dPfyfqg+z3YXXUI0y47R+TKGzjD/2f4L/34tRShe7H7VY
Zf4DNOAjfIiU9d5ifyVONp3Lrhc9bnwPLbZeaa5MPrf14W5ze+R/Qs676Uma
yeYoXWN8hK6mX9Bu5tfz052W6MGYpB/WDlsr4m8xrjqLJfL4mWY5w0x0+p+2
70pyfuLVsWv3v9FcB32dj518fIpdGGh9D92b5IQWfIZB5vfTz7EPB9CKQvOH
6Bv8HKQ1NK22dViDRqzF0+qeL7cFmIdFWIha9hO9nUk46y2eTd4QzmMo3xec
Y4q2GW93Hk+ymWnPRffsEn5ErrO8QMtp2XDv0ruf54znYwGWumMb9asp6Znx
dutT2A3Sj63uQJZ7tsh8Hdbp2fTkLXhzmeY3yPuO8TPG2+hS92A/HWK+Xv+G
edNz6VSaY248DW/jJJu98q2075wzuyHeX9bb6WlM8gZK1LRczAKapuPUkE56
TavU+a77Xe1b0e5tvOxbUc/vdONNtBVtYjV5o5nitNBj7PLkv0F/flfzr+qb
zsdsLLG2BjtwlY9ivf+XTqKldKXvRBHdQi/rdy/fkiHoks8MOiH51si52Fvd
QafIuSvpozzHsp8sbpE4nXqWRW/SUvqW/S+gQo8qxCpTx2hkiVUr1jK5PkEr
0N18Plao5ZbvdkpdP+nFDXSJ0+GsbuIU3yPV8VTSF0yWU7Y7VkGL6XWxNuhx
nj0jkm+9/C7Jv8GZjLO/CuXJd0Ud451PiVgZahlAB9AOtZzCSWs1/Ow192xy
brRJX+ux2t5O443O4Lh9l/GJ+3UYo+X/HZtGd+V/8w0XYw==
           "]],
          RowBox[{"-", "1.17`"}]],
         Annotation[#, -1.17, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{3923, 8054, 6675, 12955, 6676, 8056, 8055, 3931, 13066, 
           5959, 4800, 8939, 10340, 10341, 5960, 10342, 6229, 12647, 6230, 
           12648, 4092, 9027, 4801, 11727, 8940, 11068, 4000, 7145, 11761, 
           11762, 9771, 9773, 9772, 4129, 9043, 9044, 8941, 9774, 13265, 4001,
            9775, 13035, 6788, 10934, 6789, 10935, 6515, 10679, 6517, 10677, 
           6516, 10678, 4452, 10203, 7113, 5647, 9465, 9466, 9467, 5697, 9607,
            5698, 4659, 7905, 7927, 5675, 10204, 5653, 10226, 10140, 4453, 
           9232, 7255, 4910, 8443, 4888, 12485, 12507, 12463, 5987, 12860, 
           6545, 13221, 6567, 5267, 12031, 5245, 12053, 5289, 12075, 11900, 
           11922, 11878, 11966, 11944, 4331, 5826, 4309, 13150, 5177, 7595, 
           7573, 4005, 11017, 10995, 12441, 5965, 11537, 4599, 6519, 11402, 
           11380, 5502, 12214, 6915, 12236, 12258, 11424, 11446, 4577, 12302, 
           4555, 13300, 13322, 13278, 9658, 9635, 4849, 12280, 5572, 11469, 
           11492, 11515, 5778, 13181, 5801, 5548, 7988, 5525, 7881, 7278, 
           8884, 8861, 10367, 8838, 9205, 9182, 4354, 8284, 12690, 6248, 
           12667, 6271, 7456, 7433, 4101, 10911, 6718, 10888, 6741, 8684, 
           8661, 4377, 6764, 7088, 12989, 13012, 11218, 11241, 4430, 8619, 
           6855}],
          RowBox[{"-", "1.3`"}]],
         Annotation[#, -1.3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[
          LineBox[{8591, 8010, 3869, 10962, 10961, 6656, 12944, 5849, 8011, 
           5850, 12399, 12401, 12400, 4718, 11056, 11057, 11058, 3874, 9549, 
           4723, 8908, 8909, 8910, 10406, 10407, 6077, 8946, 11086, 11087, 
           8073, 12548, 6032, 10389, 10391, 10390, 10846, 10866, 6686, 10869, 
           10870, 10868, 10867, 6084, 12563, 6083, 13356, 11090, 11091, 4036, 
           12730, 4037, 6914, 8655, 8654, 6422, 8381, 6085, 8170, 9082, 9081, 
           6310, 10571, 6950, 7970, 7971, 5760, 6951, 5743, 6986, 7953, 6968, 
           7679, 5059, 10413, 7523, 6091, 10737, 8175, 10715, 10693, 4157, 
           13107, 9085, 13085, 9107, 9525, 11667, 9503, 8805, 10115, 5480, 
           9435, 11359, 7808, 5456, 7836, 7859, 7117, 4504, 10250, 4527, 9406,
            7190, 4759, 8422, 6883, 10064, 10087, 9337, 9360, 9383, 5599, 
           12326, 5622, 12349, 5433, 12168, 5410, 12191, 4055, 11788, 11811, 
           11765, 11857, 11834, 4286, 6438, 4263, 13129, 6389, 8777, 3892, 
           7234, 10018, 5341, 9995, 5364, 10041, 11632, 11609, 5722, 12378, 
           11336, 11313, 5387, 12145, 4731, 12099, 12122, 11265, 11288, 4478, 
           12791, 10283, 9690, 9713, 8949, 9948, 9972, 5316, 9263, 9287, 9311,
            6466, 12814, 6490, 12838, 5867, 10647, 8726, 8750, 3967, 11990, 
           5001, 9781, 9829, 9805, 4215, 7480, 12595, 6147, 12571, 6171, 7388,
            7364, 7619, 10604, 6317, 10580, 6341, 8344, 8320, 4239, 6365, 
           7065, 12735, 12759, 11169, 11193, 4401, 8398, 8594}],
          RowBox[{"-", "1.3`"}]],
         Annotation[#, -1.3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[LineBox[{9609, 4823, 9631, 9608, 11585, 9609}],
          RowBox[{"-", "1.3`"}]],
         Annotation[#, -1.3, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{5201, 5199, 13175, 5200, 4631, 8310, 6706, 13252, 6707, 
           7950, 7949, 4131, 5209, 12028, 5210, 12029, 4428, 11216, 6462, 
           6075, 6076, 4978, 5776, 4684, 7903, 4685, 5594, 13178, 5570, 9657, 
           5571, 11468, 11491, 11514, 5777, 13180, 5800, 5547, 7987, 5524, 
           7880, 7277, 8883, 8860, 10366, 8837, 9204, 9181, 4353, 8283, 12689,
            6247, 12666, 6270, 7455, 7432, 4100, 10910, 6717, 10887, 6740, 
           8683, 8660, 4376, 6763, 7087, 12988, 13011, 11217, 11240, 4429, 
           8618, 6854}],
          RowBox[{"-", "1.4300000000000002`"}]],
         Annotation[#, -1.4300000000000002`, "Tooltip"]& ], 
        TagBox[
         TooltipBox[
          LineBox[{12402, 11687, 11688, 11053, 11054, 11055, 3870, 13048, 
           5851, 4719, 11704, 4720, 11705, 12409, 12408, 7181, 7182, 5864, 
           10274, 5863, 12412, 3963, 3878, 10966, 8722, 8999, 8998, 4049, 
           8074, 4050, 11104, 11103, 6194, 12629, 6196, 12627, 6195, 12628, 
           7230, 7231, 5926, 10315, 5925, 12420, 8020, 11115, 11114, 12630, 
           12632, 12631, 9067, 9066, 4151, 8168, 8169, 6302, 10560, 10562, 
           10561, 7143, 7677, 4135, 7951, 6985, 7952, 6967, 7678, 5058, 10412,
            7522, 6090, 10736, 8174, 10714, 10692, 4156, 13106, 9084, 13084, 
           9106, 9524, 11666, 9502, 8804, 10114, 5479, 9434, 11358, 7807, 
           5455, 7835, 7858, 7116, 4503, 10249, 4526, 9405, 7189, 4758, 8421, 
           6882, 10063, 10086, 9336, 9359, 9382, 5598, 12325, 5621, 12348, 
           5432, 12167, 5409, 12190, 4054, 11787, 11810, 11764, 11856, 11833, 
           4285, 6437, 4262, 13128, 6388, 8776, 3891, 7233, 10017, 5340, 9994,
            5363, 10040, 11631, 11608, 5721, 12377, 11335, 11312, 5386, 12144,
            4730, 12098, 12121, 11264, 11287, 4477, 12790, 10282, 9689, 9712, 
           8948, 9947, 9971, 5315, 9262, 9286, 9310, 6465, 12813, 6489, 12837,
            5866, 10646, 8725, 8749, 3966, 11989, 5000, 9780, 9828, 9804, 
           4214, 7479, 12594, 6146, 12570, 6170, 7387, 7363, 7618, 10603, 
           6316, 10579, 6340, 8343, 8319, 4238, 6364, 7064, 12734, 12758, 
           11168, 11192, 4400, 8397, 8593}],
          RowBox[{"-", "1.4300000000000002`"}]],
         Annotation[#, -1.4300000000000002`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{3880, 12732, 6434, 12731, 6435, 12986, 12987, 10884, 6714, 
           12985, 4212, 9175, 7361, 4980, 8366, 4979, 6144, 6143, 12012, 5023,
            11154, 11155, 4133, 12026, 4132, 13270, 13271, 13269, 9552, 9550, 
           4724, 9551, 5311, 13176, 5312, 4681, 8569, 8570, 6792, 13036, 6791,
            7300, 3964, 3879, 10967, 8723, 9334, 9333, 11310, 11309, 9740, 
           4936, 9739, 4935, 6913, 6912, 11754, 4943, 11105, 11106, 4052, 
           12375, 4051, 9000, 7110, 4424, 8715, 4423, 9776, 9777, 9032, 9033, 
           9034, 5824, 6701, 13251, 6700, 8306, 4688, 5596, 13179, 5595, 3889,
            13051, 4694, 4501, 8171, 8172, 6086, 11092, 11093, 4039, 7303, 
           4038, 9746, 9747, 9745, 9749, 9748, 4682, 11653, 9744, 4949, 11758,
            4948, 13351, 11062, 11063, 8912, 8911, 9500, 4693, 11664, 9499, 
           9127, 9128, 7542, 7696, 5057, 10411, 7521, 6089, 10735, 8173, 
           10713, 10691, 4155, 13105, 9083, 13083, 9105, 9523, 11665, 9501, 
           8803, 10113, 5478, 9433, 11357, 7806, 5454, 7834, 7857, 7115, 4502,
            10248, 4525, 9404, 7188, 4757, 8420, 6881, 10062, 10085, 9335, 
           9358, 9381, 5597, 12324, 5620, 12347, 5431, 12166, 5408, 12189, 
           4053, 11786, 11809, 11763, 11855, 11832, 4284, 6436, 4261, 13127, 
           6387, 8775, 3890, 7232, 10016, 5339, 9993, 5362, 10039, 11630, 
           11607, 5720, 12376, 11334, 11311, 5385, 12143, 4729, 12097, 12120, 
           11263, 11286, 4476, 12789, 10281, 9688, 9711, 8947, 9946, 9970, 
           5314, 9261, 9285, 9309, 6464, 12812, 6488, 12836, 5865, 10645, 
           8724, 8748, 3965, 11988, 4999, 9779, 9827, 9803, 4213, 7478, 12593,
            6145, 12569, 6169, 7386, 7362, 7617, 10602, 6315, 10578, 6339, 
           8342, 8318, 4237, 6363, 7063, 12733, 12757, 11167, 11191, 4399, 
           8396, 8592}],
          RowBox[{"-", "1.56`"}]],
         Annotation[#, -1.56, "Tooltip"]& ]}, {}, {}}}],
    AspectRatio->1,
    Frame->True,
    PlotRange->{{-3, 3}, {-3, 3}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyEnXmcz1X0/2e1L2Ur2XdKIqWE7qeFUJaoLIUQspNQlrTYI2VN1rIvIcqS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     "], {{
       {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
        GraphicsGroupBox[{
          PolygonBox[{{2737, 1729, 1177}, {8809, 6979, 2200}, {8451, 4856, 
           1012}, {739, 2036, 728}, {3996, 6026, 420}, {8066, 6856, 2145}, {
           6964, 4855, 1012}, {1177, 1013, 289}, {6535, 6530, 2036}, {7737, 
           8065, 661}, {7488, 7482, 2478}, {7946, 4178, 2737}, {2478, 2477, 
           1263}, {1730, 1263, 1013}, {5739, 5611, 1561}, {1013, 1263, 289}, {
           1012, 1596, 289}, {2477, 2193, 289}, {6410, 7737, 661}, {8452, 
           4415, 1596}, {5611, 5616, 1561}, {8065, 4362, 661}, {3099, 2049, 
           1178}, {6965, 7789, 2194}, {4179, 7948, 2740}, {1561, 2145, 728}, {
           5416, 4052, 443}, {1729, 1178, 1013}, {6489, 3947, 2014}, {1178, 
           2049, 443}, {6581, 6582, 2049}, {4855, 8451, 1012}, {1177, 1729, 
           1013}, {2448, 2144, 661}, {1156, 1013, 443}, {6063, 6070, 1779}, {
           729, 1012, 289}, {1540, 1779, 1156}, {6026, 3991, 420}, {1156, 
           1730, 1013}, {6849, 6850, 2144}, {1729, 2740, 1178}, {1561, 2448, 
           661}, {6681, 4153, 2063}, {3948, 8809, 2200}, {1263, 2477, 289}, {
           739, 2200, 729}, {4443, 6965, 2194}, {6490, 4434, 729}, {1596, 
           3098, 1177}, {8561, 8562, 3098}, {2865, 2194, 2193}, {739, 729, 
           420}, {2014, 2201, 739}, {729, 2193, 420}, {2193, 2194, 420}, {
           7470, 7476, 2476}, {4052, 7069, 443}, {7078, 5541, 1540}, {1540, 
           1156, 443}, {7434, 7433, 2447}, {2063, 1730, 1156}, {2036, 739, 
           420}, {2201, 2200, 739}, {1596, 1177, 289}, {2477, 2865, 2193}, {
           1013, 1178, 443}, {5541, 5803, 1540}, {8564, 8563, 3099}, {1730, 
           2476, 1263}, {5108, 7434, 2447}, {2036, 2408, 728}, {2014, 739, 
           728}, {4954, 7332, 2408}, {5803, 4317, 1540}, {2145, 1561, 661}, {
           2193, 729, 289}},
           VertexColors->None], 
          PolygonBox[{{5113, 6851, 2144, 2448}, {6850, 6410, 661, 2144}, {
           5974, 7470, 2476, 1730}, {4153, 5974, 1730, 2063}, {7948, 7947, 
           1178, 2740}, {5552, 6681, 2063, 1156}, {7464, 7488, 2478, 1263}, {
           8563, 6581, 2049, 3099}, {6979, 6490, 729, 2200}, {4429, 5739, 
           1561, 728}, {6980, 3948, 2200, 2201}, {6582, 5416, 443, 2049}, {
           4437, 8104, 2865, 2477}, {4362, 8066, 2145, 661}, {5973, 4179, 
           2740, 1729}, {7947, 8564, 3099, 1178}, {5616, 5113, 2448, 1561}, {
           7476, 7464, 1263, 2476}, {4434, 6964, 1012, 729}, {3947, 6980, 
           2201, 2014}, {3991, 6535, 2036, 420}, {6856, 6488, 728, 2145}, {
           4856, 8452, 1596, 1012}, {6488, 6489, 2014, 728}, {7945, 7946, 
           2737, 1177}, {7069, 7078, 1540, 443}, {7482, 4437, 2477, 2478}, {
           7433, 6849, 2144, 2447}, {6070, 5552, 1156, 1779}, {8562, 7945, 
           1177, 3098}, {7332, 4429, 728, 2408}, {8104, 4443, 2194, 2865}, {
           4415, 8561, 3098, 1596}, {6530, 4954, 2408, 2036}, {7789, 3996, 
           420, 2194}, {4178, 5973, 1729, 2737}, {4317, 6063, 1779, 1540}, {
           6851, 5108, 2447, 2144}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.3418611427144007, 0.14163741984277348`, 0.5975075086398081], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVEtIlFEUPuZr/EdxJnXG+f/JccgK3NTCalcLgwh62EyCtbPQFkXRYxeF
DkPtRAgMehmWixZlFM0ErSpM6UW0j8ha1M4WUa3q+/pOtLjc+5977r3f45w/
f/B44dgKMzuHUYuRipt1YLxvNNsemF3D3FVjdhZJYy1mS1hfb9R6Auv1DWZF
jBYcHkes5PGb9WbDdTr3oVF7XDOvgns/Iuc53pnHeOt3j/vZo61m2yKtLyF2
L1DOfcwPMH7XCNd0TNimWpTHnLlA32XE6/JmP1eaLeKNsF6YiOFyyuxd0mwA
uGs7zQ4ngAvxDc6D2Pgm7+R9d9Nmo+26g7pQH2rA2Je84pxHPIecphxPyXlR
g3jOrDknDlWMR4HeXUD+JLjM4t1nwLsETI+BYxDvFhLieygm/lyXcEeQlFcv
Q9wDrQbh3RusX4TKJf45z5/shuaRtNqJeXck7Tbj7jtpeTqUgU6h+M3ExI/5
Oez3JaQJ9xinLxWvDcbJjboS/7qsWS/GD8dLLMT2zf3jmnXRX6f8EXj9OpRf
59P6Ljtf4i97vbEWu3xNfMTcBB1O5sWVHu6JpOdXxNpa5XchEk/mdwPXDYzv
MWGvuP7U+5NrXnFvGKePrNFZr9UFX0/7eeZchedXUE9jeOshNDyVF1f6SV2Y
HyD+NNSZnqxwEEPo9bjkdT7l9VYF5r2ReC46BtbSZ2Bck1LPsQapCfVgbtHz
N+L9TRjL2O/DvKVNWrPmqD+x7YpUE9Rzf0be01v2A3nQoyfA27RK/hIXtaAX
7PWeZvUJe/RIq+qBb8y7PnPuO2uPXhML9+nHr7hia8Hjdlo9R73/eoE7O0Lt
Mb6vQVwZPwEuW5PSgdqNNsmvIfCbyeqbXC+k9dYBcOqP5AE9X+2a8z7WJs/y
n0P9qD95UxtyZ7+O+f+KXKuOrRP1lsmpb88AYxljh2vGmedvITabkk5BTjXK
+mRfvvLeLCbU29SHeizH//8rh70vTuf1v6Bv7O+JlLANROph1mAf5kJStcYa
vNguLNS1NykN5117evdPU3L5A40A1ZE=
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlEtI1WEQxce3XRVfXfXe64NbRuoiC1RQFxUuooUmviptVRSEZfTYtSmL
jAIJWhShBqZW9DICb9CqjBJ6UFFLix6bqEVCYrap32H+i8Od+/2/mW/mzJmJ
7z7UMZBsZt0gFfTnmu2MmM1nmA0nmXVhV5aaLWaaPUoxa4iZDZSbHQT12OeL
zS7jcwmcwz4SNzsM3hB0OmT2ttCsuMIsgV2ZbbY2HxBviXi16Wb3w2bRqFkE
TIc99iixRnL9jaY8s+3E7QGN2H8KzFKI/yzLbA7UcRbGdz2xPpNvB/9DFf72
P/4PF5ldAe3pXuMS/nXkfYH3n+P/l/ye4j8LlrGPEvsYeID/AjVsLjNrBk1g
U5nXehZOhiJeczU5f+D3PajCXiRGFvdC4HdQewl4GHIOxnj7OpgCozGvRTkp
F9U0w1kCjJNfeZLHHgvu6o1EsXMmrmawT1PbhrDnupUaa+B3irOudOekusxr
UO5V4DbfPsLRPLiFfYo6+sizFwxiH+DsJ/F+gH7smlLXgHqvnunbAvgV3Pla
YvatxHupO2vwmQCd6X42iX8bObWCCeypsOegtyexxzmbLXDffSvMsuGqM897
px7coca7IJpm9oWzvSvNvsPZtTQ/q6WmelAH1oEGvtWBFsT8Cz438m5q3LUi
Ta7mvR2F/pY0LS6miX+v2DkJcf8kOYS5X5TlXEqzqkWcTha5pqVl1fiObyPk
dCLNNSbfRnS7JeQxxJU0Jm2Js0762BHzWtTjm9zfRYw+cAN7iDzOqK9JXoNq
qw56pxqfoNPHUdf6KDPaTG31ca91GXQQp5d+fcpwjSu2Zlazqjde4fsa7Mn0
NxIR17C0OxMJtBn23kij+1ehiVzfBYM5Zi/xfRH1WVKMNu60xlyrV/l/ES6O
F7kWxYm4CEU8V3Gi2dbO0K7QjEt70oi0IQ3OEXuwwrnXDlJvpPmZoEeaxR7q
6M73mZS2pFlpVRqL4JuCHnOSfea2kVt7zHPTmXzFubhWDO0e7RjtFu0gzbZm
YjCYce2e2kBb2kGFuc65uJYGtTs085p17ZCWgDNxpR78Bw2VxLU=
           "],
           VertexColors->None], 
          PolygonBox[{{7435, 5919, 481, 7433, 7434}, {5425, 6583, 6582, 6581, 
           753}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.37360888901751166`, 0.19683817670871118`, 0.6421328066892509], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNlUtMnVUUhTdw2/K4iOVSLhcu1KuxOtCZj6TGRwkzxQfGqIkEpVQaBxCU
QZGJ7UDjwDpxoMYnUKImOtEIt2m0Cg6Mj/hMp2p9xKQRbQ0xMbGuz7WbOvjz
n/+cffZee+21918bnx6ZaoyIup4mPcNbI443R1T1Mbct4oCen7X/k/ZLWl/U
oLfWIZu61qfTZlHru0sRI5WI0ULEhNaDtYhTsn1be+9UfGez2efYTxV8flTr
y7c5xu4tEUvaP6v1gt6dxNrm9XhR8fR9UOtD+JCv3wX+ue6IXZ0R/U3GQgz8
X9sW8X7a7BGeJ8uOcVzPET1nZP+R7l2p/WV9N/VEVHY69tPy+ZcwN8jmt4Lv
YD/bGvGD1kPaW280FvATFy6OyuZx+XuibLtTXRE3b484IdvBgvODwzn52RC+
X5TeFy0R3VvM58SAMIu3eZ2XheVL4V4s2NcfbfZxk84ntT+t9Uaj7/6ju+9p
/6GOiKcazMWa9s/qvPFC5Vn1Nz420s8LwvbVducILrgB21DGw4YzNIGfM5kj
3L6kWN8Jw0rBHO+Vz4psRxX/b/k9Jn/XyabU4RzByh6cUTdqQ11274j4OjGs
qRYLVdfvGfH38XbH7UwtoMNf5XOf/D9QdO5oBd4OqlaPVYwR28W053whbR7R
nYeL5gctU1fy7ZG/uy72N3m80uxcVtv9htu3hOfNsvW3KQxzXfZH/qsF2xzu
j/i25nqCmx5q0Xv1gogbarYD9/1Fc/JBs2tCreqt1h14e3a69uRA/Y90e71f
+pzsca/QoxPZp2PpEy0+22idEpd8WJMjWoZreOYOd7Ed7ou4tc85f9Ib8Wmv
z4Zlf0vqdrnVNaPn1lWjK8runxHdu7PPZ/CEj42MzzkYeC/n+uqaNUHu3+j9
feoH7GPJyYHsIWp3j84vqXpe0C/YoJ8P6fWq7Zgp9xVd3x/Fzckez63LVIsu
1eiNFt+dKVrPM6kB9E7c8eSNvZnUxvXC9mDJ8wnNnm5zXGoPF/DwaKv9sr+v
2T0Dn7eLj9v0vKq9ncI4oOdPrT8Xr5/12pZ+XUnN3FjzrGQOrulevc+6WNH7
3T73Fr7QB9qgZ1baPXNmi9YCucA/3OMT+6XC+VqACw2Ag16Ct+elqcPd7m3y
xCd399Tcw8dSl+iY2r1cs47R8B0V6wNtHEpM4CEvYlIL/FbzPrN5s2J/HdLg
i2Xrnv4iLvfHsg7wOZ1vfDL7S9n/8E887Ort5oa8Z7Ke1Pe1FusFbPR0uct9
QH1n025/yTOUOGicGY09emSureTMIC65bJXNyR3+vkrn19Q8Q3nQwGDh/D8J
zNSY/8Q5TQzlnLmXWS49TKYm0RB6I5fV//HAGb2Arpkl//1n22y/nvOefXDi
ezD9Mz8WEzs1ptb0ETObmOzxH6AG5/iv54zbO+B/z3zimk9s8Pl6i2c+fNcT
JzqYSg1XU2PoZF/J/cNZSbzu6vf9mcwLnyuZL3eXpMFLu42TXiXeidT4VPJJ
b0znejRrDJ5/AZzwSUU=
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlVlsVVUUhhft5dJKE7i9w+nt7W17E0oHJFZD20QIpH1VWloRMEqihVJC
tE2UBxkSJSJDGDSRhwIylk5EiKCh1RhBWx4cYwjomxqqgglKqNIHecDvzzoP
f846Z6+91/Tv/+Q6ezt68sxsB4iA3YHZ0rjZvdlmN6NmZyvM1sbMXgAj2I05
swZwC9+7+PyK7wnex9g8CtYnzA5mzX4oZE8RYH2wzGwAPI/dgu9Gnr343uH8
3nKz43PMjoEe7DfSZs+x3s3+qVlmcb7/yZ6XijymcluU89jKsT1DXHC5wKyJ
963E31hiVsPezezZwvt9/F/Ffg10s7+Z989meg5drN/m/cUij9E91yyf/Q/J
7ZNHzN6tNFvO+Sc5fx3n11DHAlAHqsFl9n4ODsww24Z/C7UvAYtBM0jTsxLQ
H/Ezp4lfxPfZ4D72A3C11GwC/Ie9gXzOM4MpfDvJ5zQx1vB9LfunyWET/ZjO
eS2KeQP7es57r5634NtJH7eSyxT5NlFPB/n3s3eQb0vx7cKnJ+Izq8t6zsq1
FiSIX8VzmLPOgtUx54Bmvwq7OsU7+Y2A+SmvVT5aU831oBE0gMey3qtnmenK
tPfsBLkMgyFwHPRxxmGQzTcrhIiHqW8vvntAH3ZNzHuuXldjX8r4TDQLzfzH
OX6mzrqB3ZbxGWp2p1h/n7MPUdN74Cj2GOvf0Ov1rF0pCHNJ0puk5zSU8piK
NYg9AM6AP8xnuDDwnJXrIDM6h/0L8X4GH6R8tpX4VAQ+4/mgA7ufWY0Uem07
wVthjQfDnJTL8qjflTZit8b8zmxn/W2wE2wDC2Keo3Krw36F51/kfge8jL2S
WBPF7OWsK+IwZ+eR2zh8/4IYOc48BU6CSrCYtTXsWQ2exG4AKfqTBIvm+tlT
4F4YQ7VewPfDwGse01z5XgtGsS/yzLC3FFzAnkmOEe6TcR+Lo76mmIolnw1w
cVnOtUCcVO+Ug2Krh8pFnBPXlJO0qImaGjOuSf3U8CX1fprvmlFe5jEV698C
514V3+aVOQe/44wueLIZfnQVeO7ikLijGr5i7zvEmsF5D5nx/sA5KS7uw34i
6TWr1seTzvW68O6I8x18bwc/5fmdnaT2m+B16t8CxgLvkXoziv1MxjVM2qU7
qlkrhs7WzB/F52qxc00zFXekqdJScUh3fV25a4/uvLgsToqL4nQrZz8N7ua5
hrWFnBFXWsNeSoOlveqptFIaKu2UZu7VDHiPk/vvxA8SzjFx6++Ia0U84dyW
ZkwS8yPyMmLFo66t0jRpmTT247T/I/RvkI96M17s2qYeSQulkdJGaaJmlwu5
qhk+SLjGSduk4eKmNFTaKY5Km3RHdDekUecC10BpnzRV3NUMRkMOq7aShNei
GvUv0sw1a/2TxN1ozGsRh3VX6kNt0515M+3/LP2r/gHd+DfHvVf6B11j75GU
321xSlq0PbzL0qRp9o5n/G5KA7PUWFHm3BWnNbsVGdcyzfBrevJ9qXO3j/dv
S/2bbGmauL0r8H+3OH4M+1DgXJYGPCVty7q2i6PSph1pz10aVUVev5U4V6V5
/wPfwyWc
           "],
           VertexColors->None], 
          PolygonBox[{{7329, 4951, 1117, 7203, 7328}, {4563, 5788, 5787, 5276,
            769}},
           VertexColors->None]}]}, 
       {RGBColor[0.4053566353206227, 0.2520389335746489, 0.6867581047386939], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlk1M3GUQxge6XyxLYNmFZe0CCwY4qJd6gQpbS2Nba2ILYuoXHlCKtn7E
xIPVg5rowVRp1YueqNa7SfFCYmkFvRhTLxpr2kSTejA1SEtjL23B5+cM8fBm
333/8848M88z8//3TL08/lK9mf2otUVre85sSOsB7deyZvVN/iDfaNaq9YGM
DybNzmktJMwupM3uks0v+j3fa9bXZvaDnv3TY3a06LbLW81ulM0yGbM5nf9e
8Dg1+ZrX2q0QB3X2WcVsusGsmDLrT/r5bvnc0+sxDrd4DPy/mHBM4BlIuv0e
4SwoZl+n2RU9f0Lxjqfd5vu04z+t/XMdZq8HthH5rWmtyL4QOWJ7QHn8KsyX
ZLN4h9lfsv8y6XfIe69Wt/B2aq1l3M+w1tfCsFO5zHS4ze1697Gr3mODmdpO
ZT0OZ2Ds0/my9oM5P8OmpWr2yla/+45ynxaOEe23NZu92m5WqTO7v9tsh9bf
8nc16/F2hZ8jCbd/MOG1pp79uvub7hZ0d0m496ec3w3hfUq5fCgsN8TR4Wbn
+LZw3Wz0en+ie/eU/E4+zsEJ9pWs41+PPN6Q/6Pav9bosdDHWe1PpD2n0W7H
CW8DwTX1Ggge4W9HynOk9jPtXn9qjM8/ZV9t8hjnZfO07Fd175j2z8r+K3FX
kv19Of+lFvBE/FnFHRVHN2W3L+HxwAHOaZ3XlP8t+W3X8/dKro2GpNtSS+o8
1+QYTLx8XHIMD3eZTTQ7t980er7kDcZq4D7Z5H1FzfnlP/7Ajq7B3ys/d2qN
Zh03nMAjPq7l3M9azvfEPVV1HOzRAT0F34faXSvU8HrW41HzT9udS3ikxtQV
GzTV2+Z7uEDn8EKPkwfYzmzx3MF/pei9wX3OTjb9n9fViEUvV9JeX/CSAzjJ
9UL4RLPYU0/4Ie+8zofE4fay98mYcJWr3kvkjy/s6ddCzIGR6GP4pPcL0csd
ReeSZzvF7Yw4Nt1fTLnOqD2aIDZx0Ri+8LMaWqQm9PZw8F4LG87Woz/AALbh
uEvNTkSOE9JIqej29N9Eq+uNenKGz+fF1SPK92Lae4iegscxnY3H+Udp1wM4
0V1d8P6d/N1dcn/UBn1Q18eV65tl7486/VrZfcDXmYibypslOrwGI+rLWrfH
vizbDWFKZbzXb0W/P6qz/V2uM2ZEQ8zEZ3Q21eV9cjpmELpdkZ9ci8//ee0v
i8sXEq5tfsllXfH7mmMWan4XizEDxNehgs+hlZi71BZMaIEc6evrGa9zUrl0
VTwXZsne0PBy9ARzqRYzkT3cbQR/vPcG490Hb2vhc0m1PVXxGCxqyTk1I95s
vMfQOrE2pNPVVp8B6L4t5VxnZPtHm/9/XzU+plWVzbetrg90QD3wR02uBYdw
xLuIHiDncdn2d7p+6WF4pO/g4rGc8zHb6XOQ2fd22e9gD3Z+0fXmvEa3P6nO
P2tN5nxmTsbcHNO9A+gq5d8CcEisAfl/KO/zYyHmIrmjk3zUcyHmJs/Ik/rM
x/uO2MTF31L4JN6mLoYCB3v0+1ZoGK7ADHe8D99tcY0tCvvZHs8fDTLf0eFg
fM/g58mKv0exn1TtJ7p9Lt6r99E2reMZ91+Xc/zMs7mYz/TckdAq86wtvlGY
8cwr9AK39WV/9rk08EXVZz/57wu9MR/++06p89mV3/wmEd7RHo/N3GJ+UR/m
1EbkyzcL31V8g8AHMxQe/wXJn0NQ
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlm9MlXUUxw8gcA3scrnceyEuXC6OBC9tYUuTv4orW7QgB6ElvrBEc6m9
delWW7RpJuW0zZbgsinpqgW9gJZaLtxyrTdZttWWzV65wA02sinS59t5Xnz3
nOf5/X7nnN8533POk966Z8PubDM7AhaByw+Y/RM1mwOTyG/FzR6Jma0AA8jP
lZk9mDSrAT3IzUVmmxJmG0ET8rWw2clys2HwC/KdErM+nq9lmT2FgX50PlNp
tvU+s1EM72TtQprzhWbf5Jotxc6z6DqfZ3Yrx+xLbIyBVzibYL0EfcsqzNpY
v8m35pTZGjCNvlb03Y36HeT7HeQWdG/jebeAd/AYfr2K/T1gFfInYASbZ8AI
8kFsDYA3wQFwintu4vwWbM2GuDu2oyVu+wI+5HDny+yZBNlFrnuYOw2F3YbW
itAdjvmebr6vRu+VfI9BB/IT1WaZJWa/5nvs/vcpiGEWOhtYnyE+PxLDTmKT
xZkj7I3wPn4/+7hjI+uPk793ydG/rN8Gg8jniM2WCDkAZ5Hnq8yq8asd2xeJ
RwU+XSr2u82Ai+h6ifXFuZ6TNPZW4sOjoAp5M/tfAC3E+j18SBDnWuwsA3Hk
OtbqQQbUgk50HcJuFbbGONOa8pwpV1P4kC0+EZMod4kRzy783I2uXaATuZ29
fWCWves4U4b/RVUu/46PK4jRTfLxOfIg/m9AXy/52rbY7Df86yF2paxPka9W
Ynwl4jFSbL5HXsB2V8x15XG+hvf3sVeDv4OcN/QtlPpdFfMx9ia5ZzkYjfne
lpTfRWca4McqsBI8DAaKnPPiumK2D99ulLmted4nEq5TusaRMzGvIdXOcuT+
gMPi7jzYzvsa3heQrdB9UQ2q9uSTarEhsK2aXM/97xGva/nOsf1xr2nV8j5w
JukxV6xPI19HzyjnvgB/IGfQsw60g+V6ih/4sIt4ZmF/iH3HwFFwIuHcf4fn
oYTXQD16R2QHZCLuywL4tsB9Uq31oW9z1Guugz1/B/lUjW/nXD9IZvm3A+hd
y94nF3lOxTX1JPUicW5JhXNWXC2scF8+wI/jYfdJvWht2mOnnjRNjGfBDJgC
J7B1DPtHwYdxrz3lTLlSDbYorvjYC5qRG7E7Dz+eD3lNN6HjKms/gUbk65wd
wt7qQq9R1co5/Dib8JrpgDt/oSOb3MzAoT/Zf5X9fextKvRamA58U00olnXo
ro14TJWLtrRzQzlpQ19P2GtNPbGb2v6IeO8t8Brrwu5O8vpDrvdY5U41oVpQ
Dm9gJw/5cLb3XPk2BUIh97E75T7LV9VkPns3cv8kdy9RvpB3gN5cz1ElOUkl
vbdIp2KnnqRe1Bvk+umI167yq9rJBFxTDSkX+wOuKifq1Z8hfxr3nj2n/sEd
L4Xcx4kyryHVzjjyMLZfDnsvUE9Qb1SOlJvbQe7ulXqtK4fq1UMBl9WzxU3V
iGpDHNUslA3p1kxULe6Iei2oJjU7xUFxTzNUvVczR7NGPThR4j1JvejrHOfm
wWDWiKOardUgHcxY9eIXK312qieLS+KIuCFO7UXfXNpnp2L+Mbk+VeWzQjl/
O+U5Um7Ug9XL1bPVq9XTxVVxXlwXZ5dW+ozRbNGMqEf+rth9PZ/jvUE9azzo
Ecp9KOK9Wxx4iG+Txb63M8+5WhfMAnFW3FdPUC9QDXxV7jNUs3MCuTXtM02z
TDO7Oub/BPoXUA+4VewzTLNLPaQm5jNUs1OcVi3rH0CzXzX9M/oOV/i/g2pK
3FGPU28Th9TbVNPNQY8Tl47H3Xdx6nV0v1Hms17/AP8Bv4tB8w==
           "],
           VertexColors->None], 
          PolygonBox[{{4108, 7098, 7097, 7107, 2056}, {7202, 7327, 2405, 7329,
            7201}, {6483, 6478, 6477, 6481, 2011}, {6478, 6963, 2191, 4428, 
           6477}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.43710438162373366`, 0.30723969044058663`, 0.7313834027881367], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl0tslVUUhU+ft7TQS0tbenvhtr0IAUQCmEDwRVtABBJAhGICMUIJhIeA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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmts1FUQxaddaAsLbEt3C9ul2+5KK0hNKBgp8hDbqokSKZWKChQpakOV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           "],
           VertexColors->None], 
          PolygonBox[{{6609, 5458, 5457, 6617, 2053}, {6676, 5673, 5672, 6679,
            2062}, {5673, 5002, 1777, 6059, 5672}, {5922, 6680, 2062, 4150, 
           5921}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.4688521279268447, 0.36244044730652436`, 0.7760087008375797], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1mG1s1uUVxm/aPtDy/NvSpy22ZfRpeZltN6MTit2WaKFVl2xmmyybDBVf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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl2lwjWcUxx9ZJIQkd5NcV1ZiYq19a0VkwXQfaTtVlcQyFEUbRnQmqKFq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           "],
           VertexColors->None], 
          PolygonBox[{{6970, 7788, 2689, 7793, 6969}, {5857, 6519, 6518, 6517,
            1113}},
           VertexColors->None]}]}, 
       {RGBColor[0.5005998742299557, 0.4176412041724621, 0.8206339988870226], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHmMllcVxu8Ms37fN/sMs32zVVqhA7QsA4VUVqnR2pgUE6EwloCUlkKN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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJw1l3uQzWUYx9/szbL27J7ds3t2z+7Z3UQRq3ZFGddE0xTNYKjMxkRKLmUQ
mUJjIjWmLELZ6DaT0EQoSi5NRaqZahLrUi6lCE0zUdoun6/v6Y/vnOc97+25
vd/n+VXd8+Cgic1CCIdBOiirDKEAREECTL08hJngMTAFTCoPoa4ohIzLQvg0
O4TKZAhnoiFsaxlC7xYhfFkRwqG8EJplhtCL/4ZGQvg7FkKS8WdZIXwQD2E2
89XNQxjB+HnW17LmrYwQ2rE+H/mushBKOXsq8/Xo0IPz72NuDLitOIRuBSF8
z3lbwDLGn+dzNliK3KokhFzwDkYtBV+wtjN6X8wJ4QLjl4q9R2tXgV7M/4l+
Cc46AV7k7uXodBV3zUXHrpw1GJ32oMtusBh9eqHPlWnYib3TGbdinAOmIY/A
tn/Z/w+4G3kGuJ3zr2B9J+7vw7olrBvH+RPAbHw5HzwJZoGGUu4Ai8CKUtva
vjCEzAzb3Jy9b2LrOpCFfAPxqAXHiccafHaK88uxdzv2ZnHffvx9fYl1z+W+
yZx3C/NdWnE2Og1Ez5PM/wgGIH+UG8Lv6FvKXT3Zs4v9o9GjE74YxXhf3DFS
bKaAe4n/GFDJ/K0k0HjOPs36U2Ac8rAK36Gzh8ovnL0RHZdlOidac1aSdTvR
Nxsb+qPHw9xRwXlfc/4T2J7DOAt5Bj5oqgrhZvZ3xbbZ7OnHmSPBCHBThc86
zXxjms9cjo/6Mu6Q5v/uQq87wM4W1nkT528GndN85ibs/zBuW/vyHt5hPJ+c
GIxvu/PfQe6YR0zngkbkCehfh85HmVuI/iuIy3n+/x28kO9YbcA/65OO2TH5
ErkaHEVexe8J1h4HK5E783sd+A79mA4xdDuFz+L4Kqr3gj0vVNr30nl73G9K
b2kkeBz5KfQdku34vcadZzjvF/Aq8mLOqs/329QblW93Y8OTLezjZazryfy8
5n4DDazfig+2gBXIHbl7C/Pvgg7IO0p8ps5KZ09P5G+Z2wd6xJzbXfi9LuYc
r+X8GsC2Sza2ZN0p/h/P/ufwfwFyGdifZo7RW5IN0l1vajT6PoRPxhHbtujb
PmKdpEs75Fps7wwuNvebqEqao8RNfUDbpPdobRvkJvZV8HskzRw2JGYOFPcN
Rl5U6TestysOeh/Fq+UH8B5yJnN7uG83yEDeyFtcU+63tSDD3LQIe+qLzFGd
sOHRPHPHQfA2tiytNBfUcEcD+X2EN7qZt5TB/m2M2xVaFgd0Yf9M9p9g73FQ
zbgjKFKuMB5F0qwlVm2COTYZNSeJi8pT3NOb3/EtzUHLCs1B4p6lyLPyfIfO
/gHU4O+u/L+XfCrOcmxXsXZlkWP8WJ5tki2HQXmCmIJd2DKH+9O56xB+OgjS
ouYGvYGjKY4YiK3HOOsoGIA8JeE3rbc8GfnBSp+hvROR/0aX3iCCL3Zm+C2K
E8WFepPdo64ZqhXyya58c7S4eSfyTGI9FcQynPMzlAtx26Yz7yd21YWubXvA
Ivy/D73WEY86cnRxlX0k33QgB+sZL6myrDUNZa4hqh0R8u8B9u4u8dv4hHFP
9iaxOzPT+dmL+/qVm7sPNjMX/wrOpTj5NLH8rdyxVUyV+2e4b2yO38AVlbZR
trVGnoQ9hQn7flYLc7100N3i/P7svcCa86Af8knyeDTyZNYWo9NfjD/mzt74
o5zxj4x/iJkLlZN/xFzTVctVM1/hrrVgDXg5Ye4TZ4grxIE/8zuAOrs10xx2
Dv3PFvqtq0bXoveCCr8V5YxyTTGQ75Vzqt11ea5lquG/EN+L2BnP9ps9ztwm
zt8IjiGfw6azVfa9fCTb+pW4lsjGjYV+c3prquHitkeI//S4OU65rTeht6Ac
byoxp4nL/kIuiLmHUO8QRb6DWO+Im3ulUw3ja8tcC8RBqh2qqeJi1ZDGiH0m
Xx2QbsTmGc4aiW8HpLv3ifJ/SbZ7oG0Jc4y45f3/fc29b8Ts8wMJx1Sx3J8w
10hn6SrOieT5DO3NRe7G78h855ruVK5pjeaUc+L+n2LOBdWAx2UPOnZIdw+0
Ptc1WLW3LTnRldi9metaJU5qn3BPp15uPvufZf9NBbZNOVVH/C6k+gtxvnLj
1mL3csqRs8yPipvb32Xcp9g5rVzenOneoSnm3FQPMR2d5zE/F0xDXl/knFAu
vFXk3kwcIu5Qj1aDLnOKfbZsWoK+X7PvK9WxhHtfcZC4Rz2wckMcJW5SjtzH
/wvz3Uuq5unuDdi4vsw6iMukk3QRp9UrF8CgNPcI6lWGpXoh9SyqHcop5ZJq
yDp8eU2FuVQ1ciz3NXLvAXA/8p1l7unUyylHlAuyWbYqJ8S1skm2iHPPFLqH
UO+gHlu9z9UJx0Y90HtJ1wjVhq1J13ZxirhENV6xUk+h/FXMbmTdN0XmQvVU
TXHXWNXWBay5gHx9nrlNHKde9PKIezv1pN9GHVPFUjVevY96qsZUD/Qc9/4c
dW6pRik2qsmqxYqRuHsv+Tc8xxy+OukeSr3T6+DZiL9Z9K3yTMTfLupJx6W+
YfZgf06+vw0UE/Vi6gnapHoy1Xa9Ub1N1Xj1Lqr5qvXqYdSbTou7F1SPqtg0
pHp1xUi5IB10t3JCvfOcPPtGPfSuKtcw1S7ZoN5MPaN6RfVo52P+JtG3iPz9
NGcML3FvrZ5O3wZ685feeql7S8Vwa6rHFLevTvlCHP8frmz0xQ==
           "],
           VertexColors->None], 
          PolygonBox[{{8146, 7017, 7016, 8145, 2879}, {6069, 4325, 1542, 6075,
            6068}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.5323476205330667, 0.47284196103839987`, 0.8652592969364655], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlkts1FUUxi9taTvToY9ppy8GOgNaBaRSoIUgxUSiGxEfC8EajNZnYtSN
mPAwaMANPsGICQZpYiJRXOCCuPBFMJiYiLpQU0igjYCJFESQBBWMfj++Q1jc
uf+599zz+M53zr3loWfueboipfS3RqXGg8WUzudTOqs/27tSmjk5pSkTUlpW
ldKu6pTe0Pel2pQ26v8+yTxXl9JDWr9Z30XNX2lc0Pdf9Sk9MC2lTZLt1v9+
GblG+hsnpvSS1g7o/0A2pSUak6TzuPQc07hF6xdlv7HDepq0vz6X0nSd7ZS+
7+TfsxnZaU9pr2ysk77pkuvVuYJkJkzSj8ZYpc89H2dfaEzpi3b7cVr6S1Mt
c3tbSndoDMuHVbL5VENKv9Sk9I30jmq/XfI7ZW9qrWP/p5TSKZ3/VL4ulNxh
yWlKqZzSOa3vrzN2p6qMG/5tqbCeA7K/tdExzgn/wORrnetpM75N8qFPPrwn
peOKY77GSukar/I3fq7sTGmw0z5tlL5H9L24wpiCN/p36vwQ2Ev+JulfKuzK
sjlf+M0rOofg9F/O+B/VPKqxpMr53KN5XrLvb9XY/201/u6U/KHmlEZaLXck
Z9vYRQe61ktms+y8qJjvIlblcazGGK6bktJajW8zPns0zjMfibOLpH9Zm/0h
b19G7uAIMtiqF1aTNIal9/WicQTD2doT7KlF42fZLVV6rS/n88T0sQTWCIMu
2co1Kd+dxqtfevo0/q013uAO/uC3KG8MT4pohZare+OR63LYwS452d/uvEzT
ek+FebI5+Hr5v/grdy/zlj3W+P+47He32TfqDtzAkHzBb3SuVd7fLJl/w5p3
llyLHyonx7W3ocIcKkY94vsNXfZxt+yerHddZDTns/b5B9n9XmO18rJX9o+F
HmRq66/WIjO8/V2HzrQYy2LGNdMecaGPHIA3tQ1neqMHEG9OeXuiaJ6OZO0X
Z9bI5owu43i+zhwB4wH5v7VkLBngCF47tPauxuo6nyHX2O1SfV8qub/8mXdf
oy6pGWbytTjrHgT/0b04b93gQYzgQ58oR6/oiR5Djoj1szr3CLgLT6nNoYz9
xue5lbZBHSGHj/TJm2Mdu+QG/Mg1tXKh4FzfWXCOyS/2L7XbB+Jh5uy8Bvdo
YkEO3+ERPaen3jzZEjUD/vgP94iBvkgu6UP0AOTJHTGtjrgWyv4F2d6Vtb/4
TSzIj4YP9BH2uQ8Oq2a3ld0TGHNC/kjUHXVNDc+Ndb6Z4QT2bwyfZyumHo1D
WfvLDHfIy0hw9VblaqTZNuip15fdE56sds2A4WPy/dGp7j0fSffDnb6LZnGv
dbk3zJrsfgovsME+/nygOvqpxfwvC7BSwTmnBvHzCmbrgvMTxeeqDvfIa+XL
dWXznvsOfsCN1qz190Yv6o9eN0N2Ppf8ipzrjPohR6eiv5DfV8Xf1zTuFb8G
Nd6XneVxJ2AD/TPKto3dwZzvWfZOSNmvGq3V9pcZXizI2Q++jwrLHWX79Id6
85kpxpv/K8JPanE87iPueXgLf+mFp6MfNne4tqlruMA9AReIZShq+aD8ui9j
/+nXd+d8LxQafMdzv8OXvrALt1jjvbFFGGwt+jx9jjxtiDuKOOA5HAAneIDP
YAEOr+jc0mavU8PgTEqJCTlkzinu8Xrnqib6HnxDPz2OXI9GDcP/Xvk81mq7
+1SjK4vmN3fJwbh/T2q/rsm9eCBqCRn6LHER3x7Z+bHVPaehw28gsO1Fn8ZF
6TrR6L5MvKVqr+0LX7izqSX6x6q8+X+b5rfL3oOzPcFb3jecXx65YMZP+LIp
3mZwZMEVbsS7gHXwyAQmvJt+K5h79Mva4C21xJvpbLwJyQf+5HSoKHyHM+ZW
Ju4U7jdyAgc4Nxxn4QX/WcffweAMb6+BwHBO1Cuxg9/uuNd4E8BB+mq/cpTv
cIwzW/y2IJ7usvNH7u7X/stF+9Ki70KHa2ws7l1y/UnBuroj3kL0Lt653ZON
Hf5xDhneF8PhA+9C+E8d8LYgHnK3XTbfKXrv8nsj6nk0+jJ84y0wv8F6yGOK
N8D/fWBegw==
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3lsVFUUxi+00L3TdmbKDDPtTFGLFFlkT9w1YlwCakQRAQXjiruUWFDR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           "],
           VertexColors->None], PolygonBox[{{5810, 5802, 639, 4323, 5809}},
           VertexColors->None]}]}, 
       {RGBColor[0.5640226858004354, 0.5278897024325269, 0.9095033421582183], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNlktsVVUUhjd93NLXbbm9Bdqe2t7G8mjlpUBUQiIqjhxhQGMwEbVI0OhE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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3lsVFUUxi/QTmktXWemlM50Zohll7ZSkCVGAQUDJhAMiAm7AdlEZQ3U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           "],
           VertexColors->None], PolygonBox[{{5549, 4629, 1622, 5810, 5548}},
           VertexColors->None]}]}, 
       {RGBColor[0.5873646255042074, 0.5653937045726831, 0.9100354664893073], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlllslVUUhTe30t7bllLa2/Z2spShJkahUkygIG1iEcIMaqIWMKFSZkzQ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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3lsVFUUxi8Fu7B0mc5Mt2lnyq6ylM1QMFoFoQoJFBUjS9GyCC2UyFYC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           "],
           VertexColors->None], PolygonBox[{{5763, 4204, 1487, 5771, 5762}},
           VertexColors->None]}]}, 
       {RGBColor[0.6107065652079794, 0.6028977067128394, 0.9105675908203965], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHtslXcZx39toe3p4Zy2p7fTyzmcFiPGxTkXk0H5x8ukQKCzxAtpaSss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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl2tw1NUZxk8SNyEJJJvNZrObsJvd4NRLiwK22oF+sUYhjliT6VRKEAy0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           "],
           VertexColors->None], PolygonBox[{{6656, 6657, 1488, 5441, 6655}},
           VertexColors->None]}]}, 
       {RGBColor[0.6340485049117515, 0.6404017088529956, 0.9110997151514856], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmH9s1VcZxg8tl9veci+3pb/X3vZuoM5oMibbmAiMX4bRRWFgdTpsEVQW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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHt0lNUVxW8SCHlAJhMmyWQmmUwCFPvQCqWARPoAQnkoLUGpCLYouOpa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           "],
           VertexColors->None], 
          PolygonBox[{{6659, 7110, 7109, 7108, 777}, {4107, 7364, 2419, 7373, 
           4106}},
           VertexColors->None]}]}, 
       {RGBColor[0.6573904446155234, 0.6779057109931519, 0.9116318394825748], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw9l2uM1dUVxc88Lnfu3LnDnRcDM3OduWgVME3KQLW8qtHWCJiIRWeGRCn4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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHlwleUVxt+QhCSEhOzcm+Qm915cWDpFAxSQMDoiyFadCrVlihYErBZl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           "],
           VertexColors->None], 
          PolygonBox[{{5717, 4457, 4456, 5750, 1593}, {7067, 7058, 764, 6616, 
           7066}},
           VertexColors->None]}]}, 
       {RGBColor[0.6807323843192954, 0.7154097131333081, 0.9121639638136638], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmGts1Wcdx5/20J6ec3racujltD2H9hwWpsYYE2IAxeDUBIbTF5SxqckY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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHtw1NUVxy8JCXmRTbKbZLObTbJLCkKdKW1EwAJKS5UgqKNJwLYC8miL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           "],
           VertexColors->None], 
          PolygonBox[{{4757, 6080, 6079, 6078, 897}, {4949, 7324, 1641, 5864, 
           4948}},
           VertexColors->None]}]}, 
       {RGBColor[0.7040743240230675, 0.7529137152734644, 0.912696088144753], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHts1WcZx99eTttzaLtezqGHtrQ9wNyMZH+4RiCzzm2FrDpdBMfmyG5c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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHlwVfUVx38syUsgkJC8JI/3kkcSFqm2nbYii5UgWtaKigiMMJXKUiAo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           "],
           VertexColors->None], 
          PolygonBox[{{7362, 7353, 760, 6599, 7361}, {8583, 7397, 7396, 8582, 
           3105}},
           VertexColors->None]}]}, 
       {RGBColor[0.7274162637268394, 0.7904177174136207, 0.9132282124758421], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHuQ1lUZx8/L7ru7717eXd8Lu8teeHdFp+kPCUproNT+cFlCpBqskVIK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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl2tw1dUVxY8h70Bycx/JJcnNS+jU2tppK+romDB1BCxqaKeCj055+aga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           "],
           VertexColors->None], PolygonBox[{{5835, 4269, 4268, 5843, 1627}},
           VertexColors->None]}]}, 
       {RGBColor[0.7507582034306115, 0.8279217195537769, 0.9137603368069313], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlltsVFUUhje9zkzbsc7pMG2ZoZ2iMcEXDQkqPAgJRkIIifjii4kiEROh
CAjlotQot/iClAKBqNECARL7IhiM3KpCIggRFEGDSkCL4jXgG23Q/+PfhIed
c87e66z9r3/9a+1dnjV/ZmdFCGFYo1Jj5ugQxpZDGFcVQkshhEvZEPo0/3sS
wru5ENbKqElrh2pDuE8/zmoI4aF0CN2yubsUQlp2Ga331IewgaH5K7I5LPuJ
I0J4Ws/emhD2BdvM0Npy+XxS892a79L7So3Tmn9e/vdoz91l/3NCfjfq2av1
n7PG1xf9bNRYofmqrL/x+bBwjU8bDxh+jTh48k2MO7Tep3FZ71k956ZC+Er/
7pTfTRqbNVbXhdAYbUYJz0BeHMhmKBPCVvYO3r8nxjs15dhnC/+mOsfSq/m8
5tdX2f/H8velYvlDnKTEWWfZ3890hHCqw7wORpzwViebl4vmmhwchWP5XNwo
zgvOxRXZrMuZh4maW5Mzn/PbQligMZxx/IdiLrpaQ/hU/09JGeOZyDk56Yl8
Hqj1N+/kZ03MERoZn5hDONhWb1xnNFZVGw8x79DYrvGevuv17yo9H9WeK/X/
sWrr5Ysm56hJ78uK1hd40AE+Fgr7LsWyEYEqhrfqrTfy80KFc3Rc/0zSPGL+
TX6qSuao4S7lsuy1s9LG8qLxvd0svHnrhFyCJam0z50R95WYg3FRd5PrvQ/8
gREO4Wcw5gg99MZ48YFO8fNXewh/anwkLRwYGcJejadq/A0WOMMW39jPlr9+
7bVIvlfXWnfYLFEc+xTbO1XeC22xX0kxlkq2BeOkiPOlNtcJNUJuN9c5vyP0
7wW9P5I2T1cTc7U/bV2iyTeEtyVnTj5Je433H1LWN9r+IDEm8LAf3IP/sHg9
kne+G4Rh7yjb9Ma6ovavNxs3mNEadUvNfCZtLG01TnQJB+h8mebOZ60J7Cqz
xkDu9kfMleL1mvyOqfE6PsnvE+ppD7ZY+/CAtuAOPnhSv92yG662nioy5ug1
zTcXrCf4oUdVxPl1im9vu//5ResV4nGNcNwv+4FGY6NW6C3UC3WLdtEtehqM
NXUi8rIvaq436vof+dxV9jpa2Brri/06K41zrOK90OSa4r85Ff53eq2xMI/d
2tjHjgrXi222uylukpLxzNM+jxXd/8aIp3taXK9Llf+TTd7vdv8FJ1j6Y987
lbUv/DxXcC+jj+XlsyExj1cbjRU8aIQ6pkao6YEOf5Pn/hgjvNFzL8fegtbR
MJxRb7d6Udr9lF5aIx8Xs+699Ffm0QNa/TFl/WBHbyeub6Wlc63+/illO/J1
pN36Q3uLxUd94jOkSzg/bDcPIzX3itYmp63HuW3WJP3gbI37AJoC861zQWs3
M44XH3CKn2LBZxu8To0YemIOu2MfKis/2SafUdP13tbkWnxA+fm+1X0IrRMb
cbHncOTqZnxnX55D8f1IozVKvHD2atG8XdLz/cS8btdzbtlcflNyLsljp2Kd
p3Ej45jnRN2hMWJCZ+QHbqi78ylrkbyjCfyRF+qyMtY7vZy6wO7eFvcO+kZ3
1Dg8UENoAj1wPuQT871C70li3r9r9VnIubNc7yta75zDW+K5jO2Cgu2rRrpf
wN+MqCswn5SWFhZ9b6D+/k6sezARD7Fw3i6Jex1WTgfa3UvQMPolj/jIleyH
Xjsh7X47pD0X5t1DtsW6Jl9r0+4v9Ir/srbDZoP62elm89Oac1+mD2eFq6to
v+h9T8bctpV89uOHeuIsQYfsPSHehTjr6Mf4Ia+ssRdny1DBa5mC74L0qtHy
2V66c0/iLnT7nCcP8LAl3vfgnF45LeqZnkbNo71qcVvbYVt6/Oex1g7Wmn9q
53HFNLXoPeiZ3IPg8GLKscAxfevZDvecG8I4NNrxo+VzsQ9Uy+ZYo3HM6vC9
Cl/XdBa9mXPd4w+/8BPIqeZfr3Euz8QzYn28F97qH9JDX+K5SvkfTJy3Edr/
60bHyVnEmZTE+xI5hVtqpjvWDD1vd7zPoMWDMXZ61ZTI23Xh/HeU8XFXIGf4
5R5yPJ4Zw9LIopz3mRbPZf49nvc9Ffv/AafPpHg=
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3dwlFUUxV8q6Ztk09jsJtnYxq6jxvKHwogSARVs4KijYMEZKSoqCkgT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           "],
           VertexColors->None], PolygonBox[{{6139, 7951, 7950, 7949, 1181}},
           VertexColors->None]}]}, 
       {RGBColor[0.7729310689576631, 0.8504327985423241, 0.9094165783371948], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl1ls1UUUxofS3vYuvS33Vm7hdrFVEUUREmOMS0xsE6PGBI0kosYHHyAQ
EXdcQQ3Bggk0RMAlQSpYEROCFn1RIxVJ9EFkR0EruGPigsHEaIx+v36H8DCd
+c+dOXOW73zntOvOBTfdXZNSunBMSmM1v60/KzIpLdV8QZf2NY7nU3qhNaXv
yyltr02pqHm89gta31yf0sG6lPp193zNy7IpDWg9O5fSj7p3g74PFlKaX0xp
QUNKUybonMY7unex7t+rvfl6e19jSpM05kuZtTq7Xu/vkJzu9pSaWlL6Tmff
0JuDpZRWSb9+jVU606dRr7dWjvW7laJl8tZMyXtZ+9uT5zW6s07zs1nrOa/G
328mn9kk/Zfr3kmtt0jnqzXOlexzJKeu6DN7mnWuZD2va0vpgNZlyXpO6zUa
t2s9rSrfVS3rFcnI6O5AwTYfztuHHZWUNndZJ3RZHn77Vr8NaP2n1t/Jz/3y
+we1vo8Ow8lzJvRBd2zYGjauC3sH85bN3g+SU9Otu7XW7xnt79b+I/L7LRp7
k/3LHu8OZawH3+h8edaxxu/ZnN9ibog1oy/8OCx5tfLNLM3vn5HSlYp1Xvd+
lg4N0mGn5JynvcubUtom2VX5bHvJuAM/UzTWS04ubxvQf578P1fjIr33/pn2
Oz6/X3NBcvO19gux+lDz5JzXb2n9X87frF+Xv//Q+V06/7F0+6dDWJZuvfJl
T9FxHkl+5+vww4asfQGuwDB4Btdzcl5jT19g70XF6reqcwL88O6Q9sfp3CHZ
9bDOHZX+lYpz7LiwVNNu/0zPeH63xnhuCEx36vcz261Hh+Zii/U5oruLO2W/
dFnQaVyCSXLi35zX92j/3k5/z5BtCxudF+vBY9H5RW6yf0Dz5xNT+kLj7gbn
H3m4WvMx+fl32bZEdi0q+j6YWRxy2LtLer3W4viRx73hTzCIv8El59fGu0/L
B0eLjjWxwv/EaFrONn2mdZfsbWxxPgzEu7y1JznexPpX+fuZkn1LPIgLfEK+
cGZ3MpeR67wFJ5CTC/Xd3GJ+AftbJeNws/fJlYNF50ud1o/JJ9c2GIfoh27j
a81fvPWg/JMTrj6VrVPHCT9Vx/FR3dvZ7LfRYVSG1mP15tKS8xB58wLbF+re
tqr5h28wj/5g4aqC8QDXEp/BGv/OXfT5Sfo2Nxm/2D439v/KGOMrpOug8F+t
GJMjsv0rjdclr5S1D8h9+HVixbl+q2y/vfs0dmYETr7UvSMt5kti3HOKl2TX
8bL59YPgd/y0OmJPvIjdosAP93oj7osjtpy5TW+OFF1TfpG8jV22f638fI2+
78gaF+3txgb14bKKbfg5b/6/OPjr27CrR+euzlqf65X7DzU7J8HV4sBkq2Ss
k/0rZft9ypu9zeaP4ZJ5Co4akl0jWXPOIp15otNcxZujHDHGPv0rfA5P1wX/
/ybdN8mW3oJzvC94m1jxO7Gm5vQU7DPm3ljvkrxcvWsB+OU88e2JOkVMsacv
41ygxoCvS6XP2cLhQNn6nCibB8lJ/PF8wbjk7FDUhVM5RizgE7gEbscv8B1c
Rx2jNlAXwD1+wSfosiX0AQP0DsRiQ8F6ozM8Wol+YLX8ekWT9UQeerOGO7dE
/QVn04MbbxRn7+x2fwGHEk9ya3rVuceZjM7UdTi3Dsv2IxP9Fvn9eKdzfG3E
Hd9epvcnT7AN8MeyjOO4K2re1uBJsE/eUeP+1jiWfHY4eID4wOHECB6knpGz
G4WfJyte0xNgD3qSO6dqOPUf/w5EPeft0XfrXE+IKfEdF73BcOQSmKGGH43v
QwXrip7k0OY259F+6XBWu3N9f7v7OXy9V+sH2qzzFRPsR3SjvvLWw8E52N4f
/Aw3wTMZxaG+2xiqDb8cCz4HB+Cnscm8MxQ9wqroE8AbvQixhlvQmRiBL3o7
zn5TdJ2At+donl1xHqBXKfyA/dhOvYYXkLk78gWb8pEvG4LzwR5vUSvw1eyo
47XjzWvEBk6ihsFLgy3Of3Kfs4fCt/gDPuyPnhMZoxiInoW3uAM20Z8ealvk
y0Xyx9QucxUYJk/AcU729ZWMqT9azVPEnDwlR5E1Rrh+tcv5Ae56gtPIiUvK
1hHOwWawtTfwsSd6s1nR890Sa3y3Q7Z/pDEr4/p0fvRg1J363On+jjX4BPvI
on/c1248gaXh4Hv8QK93rOh4TgNXE+w3+lkwR2xWRs+HTP6faCzbP29XXZ/g
0acq7i2mxP8WnEdH+uup0WMTCzCKfPB+IGpHvuweEQwgC/47GRxL3oNPYgJ/
jcYlZzyBJeK/LzAA34OnfNhHPIjFJ2e4jzxVX+mPkE8vsLDNctuk/3ut7qeW
0A8H173U6n6R3D4aOCZGcCHnOFMXPRS5Dq8fjB6SGv5r2TlFDSXfOEPMZzae
/n+HNTikdzsR/RvYPxT4/7vDtQHdH4mYggts513yFO6fFOv/AcDJ848=
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3uQ1WUZx19gd2GXhXN2z7KHZc/usttMGcjFmUKDHFgvE5tZwHQRoiZp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           "],
           VertexColors->None], PolygonBox[{{5828, 5569, 5568, 4635, 1625}},
           VertexColors->None]}]}, 
       {RGBColor[0.7938937150540132, 0.8574232824459713, 0.9000253316713411], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl1ls1VUQxg+0tLd0hS6X3kJLUUApi2AgEQvBB4uYaBAlKspmUBS0gCgB
3FAiJG6xgPpgfChQNoMikRgeABONMSaAQouBgmxG0UQWX8D44vfLN018+Oee
//znzJn5ZuabcxufWDKjtXdKqa5XSnn6bapNaVJ5Sl8VpnS9T0rDC1KaoG/t
pSm1SeGgdCqqUrppUErbilJamE3pDb0vl+7YfNnQ7zHpzSpLaWpJSoekv1c2
Zmi9sZdl94S8uS6lqn4pbZED00r8jTNWNaS0Uk9BcUrj5ccLfWx/Sd+UWvXs
6G29lhL7c60ypV2Ntru51L4u620f/i213hn5+WdFSm9KPln+dMn3Tq2/qUnp
ashPSd6mZ6jiGBexPCufn8ukdLbIfnD+JfnVLPkg+T5a527X3nbJLuiZp++P
CL+WOu8dqe93lVv/LcV0f3VKJ/v47MOKbbHkzWBe6/cROv9ysWO8JIz/0PO9
fOkl+W7JOxR3t/zZpPUp/W4s9nqV5NvzrLdKe1/VWS/rKfqfHvnZUOw1+j3v
+FkvfLoGOy9HCi1Hp7PEa2R3COcH6+VrvvMBHvgPvpli54LzitHX+nCy/Ej8
FsX6ivxZp70je/vMVxp8LtiS4zWyea7E76x/yanehPUe6V9QTrer3tZr/7B8
/5IvfNnf44+wf7jccVFHnYNdS+C6JOpnteQv6SmU7F35M1K/NRnji2yFdJqK
LT+u9Yt9/c56b9QjfYEt/CS/5H6+nulad6um+gir1fp+JrAg9gOSr612b40r
sF1sLpS/s+v9TpwnAx/qF9zAryzf+zj3i/4plQ5xzsk39k/rmaQcfSf5MupQ
9n7QemlfYzQ3fLtP8tsb7Sv5fChy+n6edT5P/p0X+u1R13zH1rLIC1gujfVt
wnyMnneE4Q3la3Kta+Ze/T6t2E5oXavcLc24Xzrl/7SB5gr6jH5jfSrnvkJn
ZOQGfDqV8+N6Nkt3nmzO1fOrbB5QbtfLVpt0R+n80Xreznjf27F3pc65Lru7
ehlbcCUucvxJcNpu2diQ8/uiIvu5Ns9xz43Yp+eby+AxerEw+rFS/v6cM0/A
V/xSj+SF7+SGWJqixqaqBoZLP5sxX2EbzMcrd6NqjAXY0X/4TO7gJXS2ys+t
jX6HF9pi71+V5gtkPwmTb4c4byX6/U24b5Pece2dmHUMPRhVSz5TZy3I93mt
0j2v3pui95v7uffADL+zoQ/f31LrHqAGfy9zHcIrG4Jn4PKW4HPq/L2MOY9+
2JnnniCX7OtO9vG1Bvv5T5WxAIdZst+dcz6aJG+utG/wNzWFzYZCczc4URMX
C50jOKa7wDxBXeIH9XBD8h8L3E81A1J6KmvegKezWffywagf4n1dsjVZn/G8
9JfpmaAzJkr/yaz7EZv7Cj3L5sDndfaD73eWWydX5h6A26ili6E/oMz4rw1u
nxm5z6gWDlbYNjPqdNZzap9sf1lnH69VeLYhBw9iBJMD1Y6NuM6pHr5W7j9T
brYJw3Nlxuaa1lerzGdwNtjDUcz8vcEz1NHoStfS/phb2CSfhwN/sNgf8wAe
2RP9hQ36gTqBD+6uc10zSyfEXIe/yR+5g6serTenwGGz6s01JxTj8gbP9KPy
tzruDGPUB02NnsfF6vFD2nNM/bRJ66mVxpheJ//4s6XU3+m3TTEHmY2Li9zz
C2IeMvOYHbfK5/JK1wnzA26AM6jBJVnX4ZxC1zE13Jo119Cz6OIv3MJZ5LVn
RsML6HPHIrfY/2ig+5PepI5mF9l/7hTzg4s/Vax/V/qulBf3LfwkvqERY1vE
xLcPZPPDgbY1N2YAXEF/U4PwNj4RNz5Td4sDhz39zR3UBLhtjjsVc4k7CnOv
PeTY5H7XUeS+Yw99Ti09oxpeVOM7F3liVsLtzDN4EXzAAkyYX9TR5KhhuKM9
7BeoFirUR2P72g/k7IXDaqJPc8FdayMmcsqaM4mXc8nZ+YgdDrge+A8TxwzN
2VaZ/D06xHHi45mYrcS6Jeqnh3/xjTtaLuv3nnlP7HBPzz2Fe1lH5P4x2X5c
zwOl7v0pgf/ljO9G1Cz+whXbA/MdMbe4L9MD1D9czX5i5Pvl2Ms8P5tzL8Kb
taGzLnxBBwxywUX0VleFccVea/j0sfijq8x1QU1Sj5wLj3BWc9znuWe3RP7h
bGqAM3NxLncYdLjj0U8jao05udwZtUKNT4oaxhZ7qBFyCE7EsSL6iZxwPjHj
A/cj9LF/WRxzpc49gD/8R+Fe0RG9y1587Ag5/DEqOAR+PVNlLgWf1vCfe0pX
f+tTV2BEvqiR8hrXycXAh9j/A6CizdA=
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3twlOUVxt8EyG0hu5vdJCSbbJLFFisQxE5RgXSAjlJopRKmBUKhFTpS
Ubn0Zos3NKgzBLwQWlorf7RqEBwlpFAvNKAtVDoS22qCU6JA0XLpjGhoK3G0
0t/T5/vjmT37fe/lXJ9zvoYlK5tX5IcQBsFQ8HR1CBcSIXwIdiDvi4dwd2UI
d4Fu5EXZEGZWhTAmFsIPS0J4dGQIvwRfLwyhvyiEcbkQ7smEsBaMRZ5cH8Lp
dAinwCTk1vIQKpIhjC7gnmEhvM3zY6B8SAj3oUgL8lc57ytgAfIguKkihC+y
/gXW96PTUbCNtau47yPuya8JIQ8MIn/A+lXs/QL6dLH+E55PY/1U8DFySNpG
2XYx4bu+BKZHd6Z4Pr4shEZQhryU80rReQRYgpysC+E/+OLfIIHczvPj2PUM
/shDx23YvIF9baADeR3vp+C3PegziD7TuHNtAz4FU5F7wEb03gAOI88DV7J3
IvgGcidnvACeBzsjWXd0RM90Vyu4N7qzndgsxF8tYBNyJ2f8C7vPg50Jx1Y+
k68U4xi6/aM2hHdBifSssI7SbTfyEfR/FF/8AvQhH+TZ7/l9GRxAPl1qH/zf
dmL4Bj7aVWb519i7CZ2OcNZq4rWVZ7NZW8q+y1j/N97XRTbKtizydN5dDa6S
HuB5nr3Gbw94DvmdpHNKuXQSOc7zyakQzsV85vJ6n6mzbkI+SJySihU4AN7P
OGeVq0fBQNw5q1z9AHk/v0+i/8Po+vqIEOZy/iwwEzSDE+T/WXAGHAd7OasL
7AIvgsNZ6yjdXs3aV93s+12FfZYhDi9z/vvcfa7IuTadO6flnHOXErNJ6DEx
L4Tv45+H2VOCD4vBQ8hVnHmRsz8FI5F7Ms5Z5eph5JXYuALsYP9UCvoiz4t4
Xgg+rXYu/hQdFhU7J3PEPUHMOvj/JPgn7+uwIwvOIvcR3x2sv7nYNa7cWsnd
K5LOsd2cOw60Ycs+8Fti8V/u/wTsQe7Cnu3gKbALbMbOTs7dCdqR72NNH3b0
gnUp2yqbZIts3kuN3c5da8CLyN/ijMXgHXR5t9C6zI1iI52a4q451dpzvG8U
D4E38q3jAnLiHOveA/ORb8H2e9D1KLlTx/pu7O5NO3cXFzr3VEOqHeWguEY1
oVoQ54hrUpx1a5E5R7HtYP/9wxzjq/h/gfcfgiuR0+zZzp6ntK/G3HIMLni7
wRyjXNIavVNOrUW3J9j3SIF1vJf/J4nJA+JC/p9m30P47kFwCvlOzmhm3xxw
B/KbrP8Tfj0EjiC3c9Z51g6ATciz8ddGcmADuA559Uhzrrh2Ivbs4Mws+/ZD
nV8eHsIo/o/lrDEghzyaGP253Pxdib3L8dEP2N9XbM6+VX0jYa7/S4F1U02r
lqXjd7lzDHuu4N0R+bvSOkvXnkrnSq/il3HOKJaXiy+LHNNq1nTIP9x/aKjX
bmNdR9x79pJjsRrX8uMjzJXiXHGtOHNrzjmpXHwMjMIPvZz3+hDXxL6EbZDu
yqmXsLsNu9eD/SnXSif27ky7ZqTL07ybOdw6iZvm4euVJeaoGzlrWaVr++Y8
c81fycNfxcw565LOeeV6a9K5oRifinLk8+BqzmzC1hs481C9Y6pYvlJvrlfP
+zjifOVaV1R7yjnlwls8769xTsiWs8hnamyTalc9Tr1NNbwRHXqQD4MNyNfg
0wb81It9rxGvWezr5t5H0H8COjVyxnhwJuYerVnhs/i5osgzw7Ws/RqYDa6p
d+/fkzF3KId+njUHiXu2ZM0N4tRXI46oRKcT7HuWs6bgv5fKzKniUj1TL16D
roUx92RxxwH+/6HOHPKdjDlRXLgU+W6e9xPjNejawf1H1Y/KLMfYPw89PkLH
K7DtFu47j8+2Y9+M4Y7xVv4v4/+N4DHkGWAL+nSRL9ez507OvwsUx1xDT7Du
vZRzVTUtbhAniYvEEaqdWVWuBdXQW7WOsWLbX2vuWoJ8Q705bKnqJ22uX4t+
t3HXT0AB9/0Im3o1m5S59+qZZrFrI99rJlMsTkS9TDERN0zAB5cnzBGN6HoJ
Op+MOUfX1XpG02zWWutepB6l3qSe1Mrz7400dxwvNrfM4dn1aXPM7mrPYJq9
foP8StwzlmarPyJPBp/D/tKh7oF31DkmioV8eHudbZRtivExuHAh+TiH2l7O
fcPQuUA2lDim8bR7nHpb83D37ks5b3TCPVy9TWdor3pcOboVVbjWH8/3Ws0U
miW05wF8eS7j2UE531fmGlDuizM0Kx2MZg3NTG05c4y4ZX3OuTOQMpcqh8RV
mtk0q4mzTpSa48Xt6iGaDdXz1es1Izaxrrvc3NGDj+dWmzPFlc3Vnq0H0p59
NWNr9tnMfe0pz0CKrXqueq1i/Cy/P0an28AzKdf6Qu5pybjmtXcx7xY1RGeg
4xl03D7EPtYsqzO0VzOtZh3NkLujmUe5ehJ9/17unFWvGEh41le9fwadZyTc
O8QRmq01A2v21YytvXuj2UpnaDZWj1Nv04w8CnvX13mW7Mx3L1kW97eJeopm
N824mm01w8kW1axqVTapdsW54lrVsL4VZoGZ0TfDOPaMBe155oBG1k3ANw8W
+XzNquqh6p2aWZt4NyXj3NGMMqnSOajcEydo1lZN90czt3yvmUmzkmLwZrVr
SLWjmeIyfWtVeZZRTYxT/20w94ljj7P+kqRtV0/4JjnWkvO3kWqiJWuOEDes
LrFtypnmyEbV9nVZ9xLV+KiUe7x6ey7lXj89msXV82X7lCrnnnygXBGnLo1y
ZnzGPpJv1KPVa9Qz1SvVczQL6ptS35KaCTW7iPO3RDOMvsXECeICfZPJ99+u
8qynGKiXzgerStxT1bs0w2t2Vw/7GdhcY+7VjLuAtU0p26496l3z4+Zy9bC+
hGcEzQb6RtG3rnwg2/XNK+4S54nrxGGapduiWtZMrW9dcZq4TN+8F/gdrHZv
1Ay+Le0ZU7OlZjbN+poJNQtq5ldvUo9Vb1WP+h/4EFnJ
           "],
           VertexColors->None], PolygonBox[{{4330, 5829, 5828, 5827, 645}},
           VertexColors->None]}]}, 
       {RGBColor[0.8148563611503633, 0.8644137663496185, 0.8906340850054874], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHtsluUZxp+evn7t1349fbRfawttQRSlSuISPMa5yTbN0BWKCDhdJBVq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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl32Q1VUZxw/7eneXZe/de/fuvZfL7t1FxUpgippQQEeaoCBNdmnAl7DR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           "],
           VertexColors->None], 
          PolygonBox[{{6115, 6110, 6109, 4337, 1551}, {4302, 7045, 2224, 7053,
            4301}},
           VertexColors->None]}]}, 
       {RGBColor[0.8358190072467134, 0.8714042502532656, 0.8812428383396336], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmFuMlVcVxzdzLjPnnJk5Z64ww5y5pVVJQJrwQgPR1gTaSiswQGN1fNBo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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3dslHUYx5+ua68F7torLb3eUVqNSiLUyB9CYiIjLNlQtCgEYwQpGFBA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           "],
           VertexColors->None], 
          PolygonBox[{{5890, 4062, 4061, 5894, 1668}, {6549, 6540, 741, 5724, 
           6548}},
           VertexColors->None]}]}, 
       {RGBColor[0.8567816533430637, 0.8783947341569128, 0.8718515916737799], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl1tslFUUhU+HXqZlhtIiLTNtZzrF6IMSUCMXSfASEQQEJfEBhMQQo4FE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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtllls1FUUxm9LN0plpp22085MN0jcCeiDAiagUC1rqwjGoiTYKKYkKghG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           "],
           VertexColors->None], 
          PolygonBox[{{6126, 5643, 5642, 5035, 1789}, {5643, 6704, 2074, 6703,
            5642}, {5593, 5908, 1674, 4764, 5592}, {4174, 6123, 6122, 6707, 
           2074}},
           VertexColors->None]}]}, 
       {RGBColor[0.8777442994394138, 0.88538521806056, 0.8624603450079261], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlkts1FUUxk9n+hhKX2Onnf5LZzrTVrvQUqmPhERBDUbTgDZCTBStprbF
RJSGqgxd6EKDrcFoNO5ahUTBRFJM3Itrq4IYARN3xEAsJhDakJAu/H6cY1jc
zP3fx3l833fOnfLYvmfeSJnZWY20xqOJ2SMaZ+rMKo1mm2vM8tVmRf1+pt9P
NQrrzT7U4cWUf7M+VWU20Gl2b7t/H7nD7KeSn/tIa4c1hmvNxprNvmo1e1fn
u3RuTWOb5j05sxcK/j0ov5fkv14+55rMejVW5Wu+3uc3FOfpOveN30yH4pfN
dJ3HhM95nVlQnEWNw/r+oNvsULfHvir7dzX4/afkY0jj+7SvsXenfu+RraM1
vl9RbN/kzZ7VfDpjdlBn9mccH+b7FMMBxTYpe7NVvjYT69jC/4I5lpVY//8+
2Hatd7usrTR6DMT2l/AcL/jeHsWwsdN5+EM4dlT73Vnh0aLvQylfGwib7S1m
xxTzOfm6UDQ7r7GgGKeE/+vi94rym5ffixnH6zWt7Y31TWWz97rMvpXNx2T7
Qo1z9IX2v0w8z4rsj3X6Xk5+/mzzOE5pf1U+0rL7nez8Ll5GhMG41l9JnNes
cnlH9v+WnY2NzjN8fVzwPMnxss5dqvW9+3Tvfo2k2jnqD+7+kf1ljfFY45e7
3Nul/Z0aY60eNzGTf1/TbR31ha5G5Xci67leUzxXNdpl63rKY7wR3HGP+R5h
OZG4D/SGH/S8VWtDZddmEvxwfrtwPik8FoNf9sEWm2gKjs7J9921XhPoGP2h
vYHQGrZu5lyL3KE+sYP+iTEJXz1NHjdzsOU+ujhf67WFfe7jGx2+Ke6m8+4f
zuAQTLCDttDVUsrxOJny/dnAjd+5mINbvsHrqKJaf7zZNdMfnMAX+9gBK2qC
uqMuWO+Iu1+Lr6myf8M19cOZ3vDVE7z1Bo9gvyvw75SmTqnv/Ks8tqj3PFxy
7NHcYOPt+gAX9DYkzuvVO35MOcYDsc7+YOhyMM5zl1jgD+62SwMjynE0tNQT
feltfS9n3Ob1wBEMsUWs89G7VqLGwQO9gS0cwwt2HpCW9ue91tkHX/B5Qn7z
ZY+nPrSOXc6AJ3ZOK+9fS97/4A6Ngs8nsvdq0e8cVy8cLXq8Q9HnwJn51fA1
EhywDl/kT+7p0CZnJkNT9D14vBa1AwbYZp26q2lwnVA3w63OGb2H3gf2k6FR
bL2lOF8s+DcYPFl0HNA4v+B0PO89jtqZC62CNTVGrYE9/X6p5D1/VvO5bn8P
0MPleF/QEvERG/0yHzZ5w+BwKt4papNcflP9nc3520BO1Ax339+gt6/H/dMX
d7R5b1zUPJ11DYDZ0cC5o+w9kVhK2m9pdx/gD9bw+Lz0NVHwOqUfP5g4/mh2
U9bjg9/d9c4x78ZKvF8vC+MTurN3ndnTsjNc9HO8sb057wVol/v4OtPmfZz6
5p2mp4DhL8Lv55K/FTdbPB9yIdeVZs/3FjbrHB9qcnP0tJ3RH9E870NNl9vf
Kqy2aHye8VzhhBiIpz80m2/1vp9E38YuNmeE07boLbxbaAj7M/EWT4fuDoT2
Lsa7yhl60q37Vc7PwXbnCL0uRY2AKdqFd36vxJy4dgdeP6jHJF2+R970G3zx
uxxz/u/0FRxLuDrW7bbBnXeGGLqz/sZPh2Y5C+Zw/lyz8762wXEHc+pmLee1
85L4fKjseR5JvGaoFzRSzrpOwKMS78d/Gs9Jhg==
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlWls1GUQxqcntVR3l+2ebHe7aCQRNUD0iwd4bCO0lTbY1iixmoLVWEKr
GMVbQ1U0Khpi/GIFQxUMCaiA2KKC8YhHK3RVIKKhxlSMPfxAPFOP3+Pshyed
7vv+35l55pmZbEf38jXFZrYJlIKVCbPugNlPM8xOgodn8XvMrAQ8hP0nf1cE
za4Hf2D3h7mfNYtVcV5k1lzDGbgONIH+arNvzzA7DrZi/8I3VVGzmWAq5r6e
5e/JcvdZFDeLZMyqgWF/Xmu2Bb9PlpjVzDRbiK8FYAdBH5rhby1Ims1P+ptN
xDXBe+NgGfZm3smFzK4EL2FPpcwW8WYjb+2sMBvCTnP2A/aL/HYx7zwSIW9w
EfYXnG/guzRnfeDWtNktoKXUY36BsyZyWFFpNpfzH/H7PRgFY8oLfpL4nOT9
DafBC3f/goe2MnKHr8GscyauBrC/w+ehWvf1FDnn+b4LHs4l1xJQR0693FsP
ckE/G+G9l8v8zjv8loeHEbAfe5qzjoDXRjHvIJYe/p/g7mriuRRfY+S/q8I5
OZP77cRyBblNc/8C9HAh+Jr/E6VeG2lAtVeN1vK3lu/ncX4E5Pn/OPgGjICj
cPUAOZShjz44GsYeJYYTYAh7I3lMYk+AZ7CjfHM5/g4TXw8x54j1FDGl8J3j
/+2cbwNHipzDXzk/TK2C+C4hhyeIqQGfu4q9Zl/i4znePRv/zWB2yDUo7SVD
/vadMY9dPrIhr4G4l8Za4aKL89tAC/Zn8DVc61qRJpfi6/GMa3Mn9/uxl/LG
ErAV+0HyioWduzHQTW5t/NYK1mA/yp0Md9cSe4o39lCz3zn7DewOeq9Jk9Ki
ek69dAe1vT3qPTXFb59ifwImsWPgWNq5/p+juGtCWmjFjsFFPOu9HS91X0Ze
/xZ83oA9p9prfxRO7ufuIPEPgPuwXwt7T6uXt2PvI67e2d5Lp8j/AL0a553x
Ctd8MOo9IO1LI72c74O/t8B67GV8fy1oA1cnXYtP8019uWvyw4JGpI0PsJtT
zqG4a0o5l9eA5QVOx7m3kRzSaGMV9c4TZyXoM+8R1UYzQbNANeqcA68B78V7
T6cH0FInvz+P72PcX42fm8LeK+qZRMo1Km1OcOeftHMiLv5Oey75gvaVk3r1
Tc7eCHvPvorfbeAu6nMQvnr47V142I2W4sRbl3ROxEUu6bN3lPhOBHwGS9uN
oL3SNb436zNEs2MPeB/uBsDb4CAozniMiq0o429Jo9Km3tSslsZbCjN7ccx7
RL2xqDDLpDFpSzMtHvI7OovpDrVfF3SuxJl67StynVvlPadZoJ5Xr2smNHB3
HnmdA+qDXpvXs96bqpFmrzQrrWoGr8THfrQyCDpCXmvFIN+q+aoar6Fqpx4S
lxVxn5XidDP125JwLXei6flwsjDk3G8q9V6SD72tnmqHpxvB3ZVeo5tDrgnl
p5nYHPCZr1mvGpxPHucl/S1pTrFK49K2YtZu0k7SLtKO0q5Rz6vXtXOkDfWY
eksaUW9o52rXqke0y8q5X5bxnXYJ9zrCnoti/DjiNVetP4r4Ln4l7FrSTi6D
o2lq9Fixz8jGlPeQeqch5VrRTtEukWZUu5+z3juq4WVwtzjhu1YzWbNbPale
1Aw/C/5D1T7b1LOaFdrh2t2aGdpFmmmaZdpJykWaLCrkNBzxnaldORTxWVRX
0L5mknbHgYTPdu0Q7fK9Ba1rp2vWvDfLe1EzR9rSm3pLGtNsFEfiRjOyq6BB
aU8zvSTkM0yzSxzVp32ma5Zrp9/DN+uivnukgSWcXZX22amd+B9zXVdo
           "],
           VertexColors->None], 
          PolygonBox[{{4454, 6504, 6503, 6975, 2197}, {6504, 6507, 2028, 6509,
            6503}, {7340, 7244, 7243, 7339, 2412}, {7405, 7406, 2222, 4084, 
           7404}},
           VertexColors->None]}]}, 
       {RGBColor[0.8987069455357639, 0.8923757019642072, 0.8530690983420725], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlkts1FUUxo90Hp22TK1DZ/qYaWeqLozUECmsoIkJRheGBRvdUDp/QmmC
sS5cmWjiQtu0EqzBWDbqAq0CNS66tI8oKxL7RBKjEjcYwVgXxhcR9Pt5Duni
5t6599xzz/m+75z/1JKxIy/sMLNVjQaNDwtmYzWz6ZTZesVsM2/2b87se/0e
Spu1yniu0eySRkoXFnf6/PV9Zstavybb92R7uMPsq11miezvtpitNZndyJpV
5KMk+19lf7LHbFTjFZ29oztF7W9p/2bW997V+lbGbEB3NnVWbza7mPL7j8jv
l1l/dzDtsc3qLKW9C5o/0ViVj/Umt71ZMvtJ47b8Ja1m/yi2pbSfr4XNWtgT
Z6PiX3jA7Lzsj+rd7ohvsmo2pTEce8QCJuPam9AYavZYwIt4sMEWO3LkHD9f
ZD0ncjyte29WPb/1nGMEPsdyjsUV+e9VzKOK+S9xtDft+9zlnT79/jjl9/qC
I3xjh80b8v161fOYzzimnMPXkkZa6x75f7vk/m+0mR2s+v4e3dkn+2s7tvnO
aH2ixf3fi2cg1uC3GhhezjpHTwSn2JELWFQizlvS2tWCx9/VKz4Lzh/4PNfk
dx/N+2/W07LfDHt09aP2j2h9R/PtZo/zLeUx1uq5J7I9UPMz9o53+j5xrYR/
eF8JDaDr1Vj35/0M/8TI27y7IF4WNS7p7kzeeUW3J+KM/UTv1Dsdh6rezRXN
/hY+7Tm3w+aHsmqk4PUypFp7EE3mHHdwRtun5GNU43rgT1zso8vpePeQ7szm
fL9NPh6q+O9zeY9vWGNLb/1S9vpM9HtE2J3V/T+k8981JhTnB3rnfY27Wu/T
PNDpHMIbfMMd91jDNeuT4acs3F5qcG00KYaNXdvaZIbrDuFX0vhOXHTK/niL
65ycwY0cTxddf2DQJx9HK441eqE2wJ/463mPYzzrnIMtWH5bcjz/VK7z93v/
OaYeM9Tjds92qTdpVBq9DukdYEjsqYj/Kdk+3eP6oyaoPfIF76XQ8GDVMQVP
6n0w9DwYfQifZxT7zzWPmzojLvyjWbSLNsCAc3Do7vUaQP/gSq86Gz2GvocN
tUhvI1+0iR/0uSHcPo98Z+Xjo16v3csF1xlvX4y+iB/mC+GH/j4X/BHnYvSE
J4WTVZzbxegVxF8PTV2JPlCPNXmjy62IM531d6jp3zr8PeoUztD/AWF7sOQ9
6Zp67adlr49n2uW3zfUA3vRB/KOlSvS6ifBD/PBM/kn0cOp2JWp6d95rnHkq
772krngOl70O2eMMDJn7Yw321DX4owv6ArU3GX6wqSunROPhrNcaOGBPXO3R
B3bHm8RAD2O9GborxrcDXf1fo7JZl+ZPdTiW1OGdwArsl3du85gKbBein4AV
+gZ3MBlWjs93Rk8Sti/WnJt+cfpYl9dfTu+Ue91XQ5/Zy92eJ373Z1wncLg/
NIc+5uK7/03e72Bf0luvlr0PjbQ5f9ejVyRRp3wf9sZ3nPw2Cp4jvYA6Axtq
Eq1l4tt+KHraZzXvKfQR8JsMDMH7XGiR/yznC44luHZHz5kJG3ih/52pec1y
N4l98uLdJGoTPcLv48plT9HzZ28yeOf7CefkNBXx3ItrPr6t/aErNDgcfRh+
eXs56ms8+IU3evxIaB578kDzvA1XcIEvcEGHaHMm4v8PS0xewA==
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlVts1FUQxqftdrdLK3XZf3f33912d708eQkg+GLxEqkXLlK8tEagtVtq
ayBAUF9UjJhWUCHog/FJ4KG1CsUY77QqEYlGEzCUSGIEFRNBsIqJVxoFf19m
H77s7DnnP2fONzPfFEtr71xTaWYDIAKubDQ71GB2EFyBfWS62WNZsz01Zhfi
Znew1gpy/G8ChwKzw02+93CVWUfO7G5wF2gHD6XMVibMesD6lPv6Gp+jNe7z
5nqzZwtm99eaZQlgQdKsNzQ7HTPrwuefGbM/wCb+bwaz8DON/9XYc6NmgzPM
3uf798AAdom974hpTrXZ5Zzpxtca7jiJ/SM4gT2cNxsC32OfSpv9AE6Ak2A1
WHSx2UKwCns2b23DXgJmYcd5w18Zj+UcfE1xZjl7y8A57J/AYuwXecsU8YXE
eyNrN4BM2c7xm0342sHAORR3JRKxGM6WgjawCFQR54Vms/OgMu++N/HWzlq/
Q7H9gp/JtMc4WTR7EH99dWYPgD7sbeTnMFz21DlXG+HpyRnO2e+8pVDvb9mF
v6sb/RudDcnPN/idAFFi287+HPi8BnzC+w+ANPfdSmz3TjM7RkxnieELOPoc
/Io9k9+rGt3XtVGP7XTauVGMQ+S7xP37yNcL+P+MutvPNx+DT7HnEeP1ipn4
q+FojPVb8NsK9mK3wuO7xPAOmI99UcpzplzVYcfyzqG4i4IW1p/C70ZwHfZz
+H4GpKu8BvsD51Dc/QMnl8HdFvx8VWE2Qgw/s3cGvBpxTlVbLbzn7ajXmHrn
VLmW1EOqtQXEdXvCa065XQd/a0PPcSX8p1hvABXY/XD5PN++xH0b4DTHejbv
uYnEvDf6mn1PPaJeU42pttRzL+OjFHqtf8mZefjqguMzUY/xt7RzJG7OYm/n
bIn9Kd7+X8zPdme8d/TNbdy1nnM3VXiOn+COROBczI97bXQ0uhaoRrbBzYGk
14pyNp70N+ptY9j95C2e8bfs5swK+H0EH6P4/yjuvdtc79yrh3uIbyXYH3NO
VOuxci4ny70qzZJWqWelFUep7Ya4a8Zy/F8SuO8PwaWBr8neF/fe2kVcryW9
x2QPc2Yo8DXlqqOsZcrZloK/QbF3w9lSfC0D94G2Judqbui9Ic5Uy6rZveWa
ltaoR9Qb0hx92w7uKfuY4M4a3jAE9yPcUZ12zZJWRbDXwe9w0ntFZwYLrqHS
zhXE00sddDb5274lHxPS58B9HY/4XdI4aZvu3BF6DSj352POdabovSzO3+Ku
Dfx/HLyJvTPvPade24G9J+eaJa0aBf8GruHSbvW0uDyO3h+b7pxKO9JJrx1p
iLRCPa9el2YcYe+NoseqHtPs+IA3jhd8hrSw10WejlZ6za7G36rQ39rL+deJ
oTvptmpAvaeYFat6ULFoJmkWKSZpoTgWt9JEaUMH/LdnXCNUmztD50Y1qtkz
O+FaphnUSSwj+J5Z6zGNF70mVAtjRdeOrSnXLmmItGZrwWtHmiNu1SPqDXFs
fPd3zmeBZqy0bpD1gaJr3qNZ73H1tmboAL6eLnjuU1WuhYphrKyJmwt+Rnua
GfKlnCqX8qlZJE2QFmgmvZL3GavZqjdptkkzpZWacdIqzTzNOmmWcqMZrNmr
HP0PrgYxwA==
           "],
           VertexColors->None], 
          PolygonBox[{{7246, 7341, 7340, 4960, 1125}, {6231, 6222, 610, 4284, 
           6230}},
           VertexColors->None]}]}, 
       {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
        GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlTlM1FEQxge5hN1FBNxdYJddOzWKiQ2NaGFiYZSo8SgkMawNFmphp5WJ
gBdHITQeHYlx1cZoAVvZmJgoMR6JhTHaeGFUPBItjN/PGWIxeW/nP/PN9c3b
laVju48uMbNLkmrJwYTZ9UazZinvpc3urzBL1Zl9qTIbkW5KZ7nW7FCN/57T
t0qD2Xf9ft6iM2v2TEAHEu6DfVfS7FvKLK/zUZvZQ8lVYezLyy7v/g8U63Oz
x7ojWSV5KpwXTWYnO81GldvtVrOhlWYF4bTJ50iDx+L7kya32dAhDGGtlv9x
nS+lH1KsIeVWKZpNKK8B4dzKuf+s8O5K9gpzk2w3S16qrt4m/839mmqYlPRI
xhKup67xhNujO6ya5smt1utMqR/zVe5bqnH/c4q/ZZmkynP8kvE8X8m3pL5d
l+/HOj8X+8sJxkLKe/ihyuP3Rg70mfsa2b4Wdq0wK9JP1LgP9o/z3nd63lkw
y0kqjT5b+k7PEXywb015TesSXg95MMtZ+cw0+lyGVctpSX/CdXDmq2zWqv/b
NcfsUvFEuhuhb0/6b/JEsKcP1Ee99AhdOew3CqdfOJ3CeaOa3kp+1Xms2eDn
qqTfyYezEvpSu9kV9XN/vWPOhL5rmfeaePjMRCxmvyfpHKbectTMrIaKnueg
crlQdBww2RP08AN+UdOovp8t+jf4mw5+siNgw4mtwplJe5+7Zbc+4fOCH/PB
sYvK5XLwh1l0hw05cu8JXjGfqTjH4g4f4SV5cU7EnVmdiXnBmf7Yz+6YM5jw
6EDgLNptCcxNwfOb2pu+nO8fPIdjqeDaRNRI36mB/N9nfDfoa1q8W6K5/Klz
O3pCXPZmMGzGoxbqpQfgsNfV8q0vOJ/QTYae/OkRNYzErpL/Qe14b8Z5xU6c
anHMhqzPkjmOhS963q0f8XbxXuVjBsVaP4kFF8kd3UDWY/zb7aTnRN30YC7q
K4o/32Q3XO97fifeNPawo95xfme8L4u4nMSDP/hhv0P5vsv4vOD1iU6P9Um6
nc3O4V2ayY6YSzneEXarjz3Iejzem9xyz+Wochtod94xZ/jLrDdm/Bt63oRf
8S7AcXYYO2LPB2d/Crsh7fmOFD1X8tymONMF5zdvwVzgMHN43BO8vRacJ/eb
kT/vHDNgR/71JWZBP9h5eoKuK/SchbDHdyH1f3754CH/A9NtXscexdmf8/3s
jTeeusrxjnFfHbOit+z0+dhrsFLBW+bIzOAGvS7FW/0XpMj6fw==
           "],
           VertexColors->None], 
          PolygonBox[{{7255, 6512, 981, 2326}, {4452, 5747, 1413, 733}, {4335,
            6114, 1785, 1549}, {8581, 4166, 490, 3103}, {8325, 8326, 2908, 
           323}, {7964, 6153, 528, 2748}, {6497, 6498, 1879, 405}, {8332, 
           8333, 2911, 528}, {6389, 6390, 1576, 981}, {6512, 7249, 2324, 
           981}, {7943, 6125, 497, 2732}, {8331, 8330, 323, 2911}, {7342, 
           4822, 981, 2413}, {8096, 4426, 2863, 2862}, {6119, 5582, 1168, 
           1785}, {3795, 7633, 1438, 141}, {6242, 6241, 1122, 1450}, {6146, 
           5051, 3104, 1790}, {8376, 4741, 2960, 2959}, {8328, 8327, 496, 
           2908}, {7962, 7963, 2748, 2747}, {7935, 7939, 2732, 2731}, {8380, 
           4452, 733, 2960}, {6387, 5077, 3112, 1926}, {8630, 4421, 3156, 
           3157}, {6034, 3870, 1450, 1771}, {6231, 5506, 1312, 1818}, {8707, 
           3801, 141, 3221}, {4421, 8096, 2862, 3156}, {7505, 8635, 3157, 
           1268}, {4380, 5952, 1717, 1577}, {4737, 8376, 2959, 444}, {5506, 
           6716, 2075, 1312}, {4172, 5996, 1743, 2072}, {5224, 3871, 1451, 
           1311}, {5582, 6700, 2072, 1168}, {7246, 4961, 2413, 2324}, {5285, 
           5034, 3097, 1413}, {5996, 7510, 2492, 1743}, {4176, 6706, 1577, 
           497}, {3871, 6034, 1771, 1451}, {5325, 6222, 1818, 1438}, {8573, 
           5043, 3103, 3102}, {7515, 7505, 1268, 2492}, {4188, 6138, 1790, 
           2075}, {5641, 3872, 1926, 1576}, {5952, 4377, 1576, 1717}, {4377, 
           7252, 2326, 1576}, {7034, 8707, 3221, 1879}, {5051, 8573, 3102, 
           3104}, {5034, 7935, 2731, 3097}, {5949, 5948, 405, 1122}, {6120, 
           6121, 1311, 496}, {8101, 4065, 444, 2863}, {5077, 7962, 2747, 
           3112}, {5818, 5826, 1549, 490}},
           VertexColors->None]}]}}, {{}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{6128, 5645, 6706, 4176, 6125, 7943, 7939, 7935, 5034, 5285,
            3805, 5747, 4452, 8380, 4741, 8376, 4737, 5893, 4065, 8101, 4426, 
           8096, 4421, 8630, 8635, 7505, 7515, 7510, 5996, 4172, 6700, 5582, 
           6119, 6114, 4335, 5834, 5575, 5826, 5818, 4166, 8581, 5043, 8573, 
           5051, 6146, 7958, 6138, 4188, 6716, 5506, 6231, 6222, 5325, 5326, 
           7633, 3795, 7035, 3801, 8707, 7034, 6301, 6498, 6497, 3950, 5948, 
           5949, 4959, 6241, 6242, 5343, 3870, 6034, 3871, 5224, 8684, 5225, 
           6121, 6120, 4173, 8327, 8328, 8324, 8326, 8325, 3907, 8330, 8331, 
           8329, 8333, 8332, 4200, 6153, 7964, 7963, 7962, 5077, 6387, 3872, 
           5641, 6390, 6389, 6388, 4822, 7342, 4961, 7246, 7341, 7245, 7249, 
           6512, 7255, 7252, 4377, 5952, 4380, 6128}],
          "1.54`"],
         Annotation[#, 1.54, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{6451, 4887, 7294, 5137, 7460, 5772, 5773, 4581, 8253, 8254,
            7406, 7405, 8591, 5060, 7392, 5069, 6107, 6098, 6743, 6734, 6725, 
           7424, 7415, 4276, 5842, 4284, 6230, 5505, 6715, 4187, 6137, 7957, 
           6145, 5050, 8572, 5042, 8580, 4165, 5817, 5825, 5574, 5833, 4334, 
           6113, 6118, 5581, 6699, 4171, 5995, 7509, 7514, 7504, 8634, 8629, 
           4420, 8095, 4425, 8100, 4064, 5892, 4736, 8375, 4740, 8379, 4451, 
           5746, 3804, 5284, 5033, 7934, 7938, 7942, 6124, 4175, 6705, 5644, 
           6127, 4379, 5951, 4376, 7251, 7254, 6511, 7248, 7244, 7340, 4960, 
           6508, 6507, 6504, 4454, 5452, 4453, 7518, 5155, 7516, 5154, 7517, 
           6005, 6560, 6559, 6558, 4962, 8508, 7775, 7774, 8103, 8102, 4401, 
           6154, 4402, 5680, 6701, 6702, 5223, 7567, 8683, 8682, 5076, 8593, 
           5075, 8624, 5130, 5330, 5329, 6251, 5074, 6152, 4797, 8560, 5029, 
           8559, 5028, 3938, 5372, 4938, 6501, 7783, 7784, 6032, 3951, 6499, 
           6500, 8472, 8471, 7751, 7752, 6002, 6453, 6452, 6451}],
          "1.4000000000000001`"],
         Annotation[#, 1.4000000000000001`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{8073, 7755, 7756, 3920, 8087, 3919, 7754, 7753, 8071, 8070,
            8395, 4768, 8394, 8397, 8396, 4382, 8069, 4383, 6876, 7524, 8806, 
           3930, 7525, 3929, 5370, 5240, 6056, 6055, 4118, 6054, 4119, 7896, 
           7895, 4989, 6591, 4085, 5584, 5908, 5593, 7173, 7164, 4346, 6830, 
           4355, 6839, 7044, 8752, 4084, 7404, 8590, 5059, 7391, 5068, 6106, 
           6097, 6742, 6733, 6724, 7423, 7414, 4275, 5841, 4283, 6229, 5504, 
           6714, 4186, 6136, 7956, 6144, 5049, 8571, 5041, 8579, 4164, 5816, 
           5824, 5573, 5832, 4333, 6112, 6117, 5580, 6698, 4170, 5994, 7508, 
           7513, 7503, 8633, 8628, 4419, 8094, 4424, 8099, 4063, 5891, 4735, 
           8374, 4739, 8378, 4450, 5745, 3803, 5283, 5032, 7933, 7937, 7941, 
           6123, 4174, 6704, 5643, 6126, 4378, 5950, 4375, 7250, 7253, 6510, 
           7247, 7243, 7339, 3952, 6509, 6503, 6975, 6974, 4216, 6754, 5453, 
           5753, 5752, 3909, 5754, 3908, 5363, 6004, 6003, 4384, 5648, 5095, 
           7194, 4799, 7192, 4798, 7193, 5910, 6465, 6464, 6463, 8498, 8497, 
           7299, 6454, 4385, 6877, 8399, 8398, 8072, 8073}],
          "1.2600000000000002`"],
         Annotation[#, 1.2600000000000002`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{5023, 8553, 4486, 8125, 4477, 8134, 4495, 8143, 7005, 7014,
            6913, 6922, 8845, 8863, 8854, 4018, 7126, 4009, 6549, 6540, 8337, 
           4665, 7965, 7966, 4201, 5751, 8496, 8334, 8335, 7944, 4177, 4400, 
           8760, 4399, 3906, 5404, 5405, 5243, 5403, 5402, 8565, 7394, 7395, 
           8474, 8473, 4888, 7432, 5100, 8611, 5099, 7431, 7430, 6799, 4307, 
           6798, 6801, 8713, 6800, 8797, 3812, 7300, 7301, 4919, 8738, 3931, 
           6021, 3932, 8739, 4920, 4304, 8526, 8527, 7924, 7925, 7926, 5909, 
           4769, 8400, 4770, 8592, 5072, 7425, 5071, 5650, 4386, 6985, 4465, 
           6555, 7796, 4020, 5649, 4021, 6557, 6556, 6987, 6986, 7295, 6983, 
           6984, 6554, 7794, 7795, 6552, 6553, 7975, 7976, 7974, 7527, 8640, 
           5165, 6502, 6505, 6506, 6033, 7786, 7785, 6513, 4940, 7320, 5362, 
           6129, 5035, 5642, 6703, 6707, 6122, 7940, 7936, 7932, 5031, 5282, 
           3802, 5744, 4449, 8377, 4738, 8373, 4734, 5890, 4062, 8098, 4423, 
           8093, 4418, 8627, 8632, 7502, 7512, 7507, 5993, 4169, 6697, 5579, 
           6116, 6111, 4332, 5831, 5572, 5823, 5815, 4163, 8578, 5040, 8570, 
           5048, 6143, 7955, 6135, 4185, 6713, 5503, 6228, 4282, 5840, 4274, 
           7413, 7422, 6723, 6732, 6741, 6096, 6105, 5067, 7390, 5058, 8589, 
           7403, 4083, 8751, 7043, 6838, 4354, 6829, 4345, 7163, 7172, 5592, 
           4764, 6087, 5907, 5014, 8544, 5023}],
          "1.12`"],
         Annotation[#, 1.12, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{5022, 8552, 4485, 8124, 4476, 8133, 4494, 8142, 7004, 7013,
            6912, 6921, 8844, 8862, 8853, 4017, 7125, 4008, 6548, 5724, 4464, 
           5716, 5707, 3852, 7654, 7645, 8393, 4756, 7923, 4146, 4998, 7894, 
           7885, 4580, 8252, 5352, 8263, 8272, 7905, 7914, 4137, 8299, 4128, 
           8881, 8890, 8872, 6797, 6788, 4302, 7045, 4303, 7175, 4767, 6303, 
           6304, 5001, 8755, 4147, 5000, 8786, 4999, 5917, 3921, 8735, 4911, 
           5364, 5239, 4909, 6249, 5297, 5298, 5104, 7660, 7659, 7658, 8407, 
           8406, 4311, 7682, 8408, 8409, 4782, 8410, 8052, 8053, 7683, 8411, 
           3855, 8412, 8413, 8054, 4312, 7684, 8414, 8715, 4783, 7661, 7662, 
           5522, 4313, 4780, 8714, 3813, 3854, 4778, 8402, 4779, 8403, 4308, 
           5521, 4771, 7176, 7178, 7177, 7196, 7303, 3873, 8732, 7302, 6395, 
           6842, 6841, 7174, 7296, 4889, 7519, 4890, 6006, 4881, 6245, 6246, 
           5233, 8688, 8690, 8689, 3904, 7343, 3903, 6445, 6444, 4880, 5679, 
           5678, 4019, 6550, 6551, 6302, 6902, 7655, 6901, 6971, 5639, 3843, 
           8708, 5328, 4939, 5510, 5509, 3902, 5637, 5638, 5030, 7446, 5126, 
           8623, 5125, 8787, 7447, 8788, 5127, 7450, 5129, 7448, 5128, 7449, 
           5895, 4733, 5894, 4061, 8097, 4422, 8092, 4417, 8626, 8631, 7501, 
           7511, 7506, 5992, 4168, 6696, 5578, 6115, 6110, 4331, 5830, 5571, 
           5822, 5814, 4162, 8577, 5039, 8569, 5047, 6142, 7954, 6134, 4184, 
           6712, 5502, 6227, 4281, 5839, 4273, 7412, 7421, 6722, 6731, 6740, 
           6095, 6104, 5066, 7389, 5057, 8588, 7402, 4082, 8750, 7042, 6837, 
           4353, 6828, 4344, 7162, 7171, 5591, 4763, 6086, 5906, 5013, 8543, 
           5022}],
          "0.9800000000000001`"],
         Annotation[#, 0.9800000000000001, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{5296, 6175, 4074, 7832, 7823, 8679, 8670, 5390, 5219, 4039,
            6211, 6220, 5210, 7556, 5201, 7565, 3918, 5689, 5698, 4908, 8483, 
           4899, 6015, 4030, 6569, 6578, 6313, 7188, 6322, 6331, 5602, 8290, 
           4590, 8281, 4599, 4664, 8770, 4655, 6675, 7117, 6666, 5520, 4607, 
           7705, 7053, 4301, 6787, 6796, 8871, 8889, 8880, 4127, 8298, 4136, 
           7913, 7904, 8271, 8262, 5351, 8251, 4579, 7884, 7893, 4997, 4145, 
           7922, 4755, 8392, 7644, 7653, 3851, 5706, 5715, 4463, 5723, 6547, 
           4007, 7124, 4016, 8852, 8861, 8843, 6920, 6911, 7012, 7003, 8141, 
           4493, 8132, 4475, 8123, 4484, 8551, 5021, 8542, 5012, 5905, 6085, 
           4762, 5590, 7170, 7161, 4343, 6827, 4352, 6836, 7041, 8749, 4081, 
           7401, 8587, 5056, 7388, 5065, 6103, 6094, 6739, 6730, 6721, 7420, 
           7411, 4272, 5838, 4280, 6226, 5501, 6711, 4183, 6133, 7953, 6141, 
           5046, 8568, 5038, 8576, 4161, 5813, 5821, 5570, 5829, 4330, 6109, 
           4337, 5583, 6695, 4167, 6693, 6694, 6473, 7773, 3943, 5675, 3944, 
           6474, 5236, 5738, 5737, 5368, 6257, 6258, 5251, 6871, 4371, 6256, 
           5360, 5361, 4374, 5507, 4285, 5997, 4286, 5640, 4373, 5327, 4372, 
           6972, 6973, 6494, 6495, 6496, 5676, 5677, 4917, 5369, 3927, 6982, 
           3928, 8737, 6981, 6462, 6904, 6903, 7288, 5998, 5999, 4924, 5163, 
           3939, 7770, 8902, 4925, 7769, 8906, 7768, 7767, 4923, 5647, 8911, 
           5646, 5454, 8074, 4387, 6878, 4388, 6879, 7764, 7763, 4921, 8499, 
           7757, 8484, 4910, 8900, 8401, 4773, 8895, 7179, 8891, 4309, 8051, 
           4310, 6802, 4781, 8404, 8056, 8057, 8055, 8059, 8058, 8415, 5523, 
           3815, 8717, 4785, 5331, 5332, 6333}],
          "0.8400000000000001`"],
         Annotation[#, 0.8400000000000001, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{3816, 3856, 7686, 7685, 4315, 8063, 3814, 8716, 4784, 4314,
            8060, 8062, 8061, 8405, 5918, 8618, 5105, 8617, 5106, 8619, 4774, 
           5914, 7657, 7656, 5101, 8612, 4772, 6016, 6017, 5228, 5287, 3810, 
           6018, 3808, 5286, 4801, 7195, 4800, 8416, 5911, 3905, 8492, 8493, 
           8491, 8495, 8494, 4381, 6874, 6875, 8794, 8796, 8795, 3806, 7338, 
           3797, 6299, 6298, 7151, 7150, 4743, 8381, 7242, 4821, 7241, 4820, 
           7459, 5136, 7458, 5135, 5946, 4819, 7319, 4935, 7316, 7318, 7317, 
           3900, 5508, 3901, 6443, 6442, 4879, 6441, 3899, 5989, 3898, 6440, 
           5250, 5991, 5990, 6166, 5565, 6461, 6460, 6961, 4398, 6959, 6960, 
           6956, 6958, 6957, 7092, 7093, 5342, 5341, 6108, 4336, 5827, 5828, 
           5569, 5820, 5812, 4160, 8575, 5037, 8567, 5045, 6140, 7952, 6132, 
           4182, 6710, 5500, 6225, 4279, 5837, 4271, 7410, 7419, 6720, 6729, 
           6738, 6093, 6102, 5064, 7387, 5055, 8586, 7400, 4080, 8748, 7040, 
           6835, 4351, 6826, 4342, 7160, 7169, 5589, 4761, 6084, 5904, 5011, 
           8541, 5020, 8550, 4483, 8122, 4474, 8131, 4492, 8140, 7002, 7011, 
           6910, 6919, 8842, 8860, 8851, 4015, 7123, 4006, 6546, 5722, 4462, 
           5714, 5705, 3850, 7652, 7643, 8391, 4754, 7921, 4144, 4996, 7892, 
           7883, 4578, 8250, 5350, 8261, 8270, 7903, 7912, 4135, 8297, 4126, 
           8879, 8888, 8870, 6795, 6786, 4300, 7052, 7704, 4606, 5519, 6665, 
           7116, 6674, 4654, 8769, 4663, 4598, 8280, 4589, 8289, 5601, 6330, 
           6321, 7187, 6312, 6577, 6568, 4029, 6014, 4898, 8482, 4907, 5697, 
           5688, 3917, 7564, 5200, 7555, 5209, 6219, 6210, 4038, 5218, 5389, 
           8669, 8678, 7822, 7831, 4073, 6174, 5295}],
          "0.7000000000000001`"],
         Annotation[#, 0.7000000000000001, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{6332, 5916, 4777, 8616, 5103, 8615, 5102, 5915, 8614, 3853,
            8613, 7681, 4306, 8050, 4775, 8896, 4776, 4305, 8047, 8049, 8048, 
           3811, 5913, 3809, 8712, 5098, 4766, 5912, 5096, 7428, 5097, 7429, 
           4293, 6778, 6779, 8709, 8711, 8710, 3807, 7293, 3798, 8706, 5094, 
           4744, 5898, 7762, 8490, 4918, 8901, 7761, 6449, 6448, 6873, 6872, 
           4213, 5897, 4214, 5451, 6386, 3869, 7453, 5133, 7457, 5134, 7454, 
           7456, 7455, 5947, 4742, 7427, 5093, 6297, 7636, 7635, 8469, 4877, 
           8470, 4878, 7287, 4874, 7285, 4876, 7283, 4875, 7284, 7634, 6288, 
           5092, 7426, 4329, 5674, 5339, 5340, 5636, 5635, 6385, 6384, 7393, 
           5025, 6692, 7930, 7931, 5576, 5577, 4635, 5568, 5819, 5811, 4159, 
           8574, 5036, 8566, 5044, 6139, 7951, 6131, 4181, 6709, 5499, 6224, 
           4278, 5836, 4270, 7409, 7418, 6719, 6728, 6737, 6092, 6101, 5063, 
           7386, 5054, 8585, 7399, 4079, 8747, 7039, 6834, 4350, 6825, 4341, 
           7159, 7168, 5588, 4760, 6083, 5903, 5010, 8540, 5019, 8549, 4482, 
           8121, 4473, 8130, 4491, 8139, 7001, 7010, 6909, 6918, 8841, 8859, 
           8850, 4014, 7122, 4005, 6545, 5721, 4461, 5713, 5704, 3849, 7651, 
           7642, 8390, 4753, 7920, 4143, 4995, 7891, 7882, 4577, 8249, 5349, 
           8260, 8269, 7902, 7911, 4134, 8296, 4125, 8878, 8887, 8869, 6794, 
           6785, 4299, 7051, 7703, 4605, 5518, 6664, 7115, 6673, 4653, 8768, 
           4662, 4597, 8279, 4588, 8288, 5600, 6329, 6320, 7186, 6311, 6576, 
           6567, 4028, 6013, 4897, 8481, 4906, 5696, 5687, 3916, 7563, 5199, 
           7554, 5208, 6218, 6209, 4037, 5217, 5388, 8668, 8677, 7821, 7830, 
           4072, 6173, 5294}],
          "0.56`"],
         Annotation[#, 0.56, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{4726, 5888, 3841, 5324, 4728, 8370, 4727, 8371, 5512, 3800,
            8045, 8046, 8043, 4292, 8044, 3799, 6777, 4291, 6776, 4290, 8383, 
           8384, 8382, 4747, 7155, 7154, 6357, 4289, 6775, 4745, 7152, 4746, 
           7153, 4288, 5931, 4287, 8903, 5511, 6300, 7292, 4886, 6446, 6447, 
           6001, 4883, 7291, 4885, 7289, 4884, 7290, 3796, 8428, 8429, 7238, 
           7240, 7239, 4724, 5896, 4723, 5884, 5490, 5883, 3839, 7286, 5320, 
           4873, 7441, 7442, 7282, 8908, 8909, 8800, 8802, 8801, 7443, 3838, 
           3789, 8705, 6352, 6289, 4720, 5567, 5566, 6437, 6436, 6435, 6870, 
           6869, 7237, 8557, 5026, 8556, 5027, 8558, 4872, 5987, 5150, 7499, 
           5151, 7500, 4633, 8323, 4634, 7091, 7949, 7950, 6130, 4180, 6708, 
           5498, 6223, 4277, 5835, 4269, 7408, 7417, 6718, 6727, 6736, 6091, 
           6100, 5062, 7385, 5053, 8584, 7398, 4078, 8746, 7038, 6833, 4349, 
           6824, 4340, 7158, 7167, 5587, 4759, 6082, 5902, 5009, 8539, 5018, 
           8548, 4481, 8120, 4472, 8129, 4490, 8138, 7000, 7009, 6908, 6917, 
           8840, 8858, 8849, 4013, 7121, 4004, 6544, 5720, 4460, 5712, 5703, 
           3848, 7650, 7641, 8389, 4752, 7919, 4142, 4994, 7890, 7881, 4576, 
           8248, 5348, 8259, 8268, 7901, 7910, 4133, 8295, 4124, 8877, 8886, 
           8868, 6793, 6784, 4298, 7050, 7702, 4604, 5517, 6663, 7114, 6672, 
           4652, 8767, 4661, 4596, 8278, 4587, 8287, 5599, 6328, 6319, 7185, 
           6310, 6575, 6566, 4027, 6012, 4896, 8480, 4905, 5695, 5686, 3915, 
           7562, 5198, 7553, 5207, 6217, 6208, 4036, 5216, 5387, 8667, 8676, 
           7820, 7829, 4071, 6172, 5293}],
          "0.42000000000000004`"],
         Annotation[#, 0.42000000000000004`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1EdsznEcx/GvWVtVS2mpVokRB4kVosKhMSJCQhMHexN7RsQ4oEFaiZpH
aYw8RokIKrFp61B6ERFi1IpxEIlZXs/h3c/v992/7/9Jc+esmLK8UUT09mdf
ekR6ZkRt+4id3SO2oC43ohrNMiLG8u/gGyhmOEa5r+wWMYRuovM7RWQhH+/T
In70iHhBx3Xml5edFdELHTGiQ0RZTsT3dhGVci/iNCaL39yR5kWsprVdIm5l
R1zBUTkpZsrka0Ffqf8SrZ3boCVa4VrXiJLUiNHql9KF7vvNWOEdaXSImKEY
hh7e0aDPGb5/9JZ5GpyLzHFI7hI1DtNlatSb+w2W2MVDs9agGovEJsxxV+0P
Sb/7O7qYvqcbxdeqW6bXBufT6vVxPkXPy6vAOawTf1bvpsnvoG4TmkH72d9X
8V/wGY/E/bPjBoS91ohLM/tKcSfVXK/HajHV7FX4K66cfQ37Kvb7bPcwT/w6
71qLY/o0Zqux2zw9Ppn7AFsZ8t17ohd+qbVCjZ8017fJw2x15qB5cgbfqRld
RQvpYTmHcBBrzVCh7gXs8N7t6KzWdT0LfItRSPf+FHm32UYmvzX/RLmZZu+C
bPdNtE7/hHpf9fmBkd5QiEmoNksd7qrzhK+S7lK33vmzffVVe4sZzov9o8YJ
+o1+Z2vAY/UP6nNTjbYolT9d/hE6l27zO7zsd7GB3qDFtIoWyZ2F3+o1pbv0
OYJSJPStZTtOS+ysyPxL5U2ihUhhf2nXT3DHXkr0/+L9A8y1Xd9Hzg/wQs5Q
/te+1Rg6Ac/Y65EvdoF7Fk3oeQnHsds8W1HFXmyGDLG/1dnrnc2Tdrb2tL+e
BeIH0W/8U9X6SGfQ52Iv+w5nkWqP5cmzd5Tjqtk321OOOXPspw8t8KbBGM9X
7E0TzbuNTqNjk/87cJtvpnsrtZ/Ke409ZjuAt3xZYhL8/wGiXLOp
           "]],
          "0.28`"],
         Annotation[#, 0.28, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1G1o1WUYx/FL0kUQzqalnemcrtyKEKGcW6hgD0xFRdQdiKjVyrCFmzqV
GMMHcHOYbNAMFlrUPCiyxBAdjF6U9mLnQHXWqEQl0bGQmr2RobZQ/PxffPf7
39fzdd+Hzatv2tA4KSIW+nN4RsT0WRH5woi2kohWDM+LyGHykxE1/Pv5Fomp
xnLnpjkRi+nH9P2nIlIow82iiLulEdfoypn88oqLI55BEV5+IuLI3IjxqRHf
yT2LU1gvvmU6nR+xneafjrgwO2KQHjXD5/Jm8l2Wu02dG+bIpPhw3XmtWR/o
9a3ZT2JM3Ag6p0UUmue8/AH2i3hWrw/YC9i/YR8Xd5zepxm9Lphtn/q15jhm
hrT4KvWrsQRp9nf0Oiq+jqbVrMVSNTah2pwbk7pmG8agejm2NjUPYKveW+R+
iP/sPoEcexZvim+npfaeiyr16/nL3fW7tIK+RxfQrJp3aR29Q3PsWfws/ycc
xna9XrXDa1iBIbu8QvNmOsK/y74nxTznrU7Qnc7dSR7NON/zpsfpNudPk9lp
r3Oj72az7sAxPfcnvwm2r+kStarQ7PsWW7EdKp1TdJX81ZjsDlfSJrPU0Ly4
XzDmLRvN+A/dSn/j/x3z9SlDtTrD7FPEFmC3HlcwW+0Fzo8m9ygmhy/N9QW+
0qvBu32EP9Qqd19j4i/5bmcbpbecK9hb9T2jz/92PEFv03G2+/jVnJ/p/YPa
j6NL3Tfk99B6uteb93vT3fR72kGzNC23DhPqPULb9elBF/r0zbP10k7vnXbf
DfLW0ddRwH7dDpfwo99rp/7/+q29YK59+g75HsQ1OZX8I+5iBV2Nq+yjKBO7
2TlF+/Q8h14cNM8eZNk7zDBD7IQ6n9hzSmJnm0qf13OZ+Bfp7eQ3rtbf9C36
p9h+d34ahe4xk3zbI4MBs7e4pxJzlrifcrrMTi9hFV+HndaYdy+tpTXJ/xZc
5Hvb+TG1L8sbwSGzdeMvvpSYPv6HxZG5Uw==
           "]],
          "0.14`"],
         Annotation[#, 0.14, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1G1olmUYxvFzM8tmm3tJ69Gt6QwlC4xMdDbND2JFRpCaC3K6VEKQzYQR
spx+MIfGM3PB5gtCayCxBJE0Rg51KptQPdMZIZHoLGRqftDpQHHR7/7w33E/
13lex3Vc532zKZ/UflCTFRHl/nz1bETh8xGZcRHbX4iox8UpEecxanzEYvVt
ajP1zMV8v2tKIl6nn9M1EyJSKMONwojhyRFX6FvPqds3cVLEVBSgvCDim9KI
obyIn+09iu/xvv7NRbQsYiPNpCJOF0f00P0y7LVvgtple2v5XJOjfaIarvq9
RNYRZx2R/RBu6RtAOj8iT55j9nda78aLzlpnfbT1H6wP6fuOPqbtzjot21b+
y+QYdKcGGdK8O+VpofVybMcm3HX+IGbzfQWvqs/ie4rfDHqeNtAiZ9bRHHqd
3wGZm/GT+td0D5qQpb5B327P9/gOoQ8XcQFz+K821xIexZiU4D104ZHcZ83y
DLrRZibfoprn0zQHT2IMnkKK11p3WIc1WMW/CpPNYaP5lNIRPv/hF/PIcka+
5y5+88ziDczBTXkHcd+sHstwTt+netab5bC1B6j1nFHbQGuwTc8+XvvRgr1o
xa96bvG6jQW8F+JN/MZvPu2jFTRDd8vUhDSq5V6Nz5DvbgUYhyIUItu7zKV5
GJt8134/Q0/I0oUv+N0x83p6zNlZZlxuPtPMdzouOeN3rDCnSnyEflkvyJzm
9SGvFbgkWz8O8jnJ4xTGoklPpXorraYN3vtx862jJ2kj7aXLZajCQ/fIpl86
pxVN6JAnY62NpmVabq7r7XuPLsJo61fl+SP5BtwhLcO/vsmXvcutzu3z3IMr
9sxWH/AOFtJ38Kf1v1Gmd63fKdrhzB/Rhh3ybEGv9UYZivQ+5LPL7J5I1q3l
0peS96P/NXpXfWnybdCP6V96j5vhYeSZUXvy7B7t6JR9c/Jdy1liPtNohTvN
wttqje70rrwNdBldnPwfQrfaSr/H8L5s3wB2ytaMf9RSejrU/wf0+rvo
           "]],
          "0"],
         Annotation[#, 0, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1F9olmUYx/GrORCxrW267bXm3DsVLKM/c5WhErhmc0oHrg6kCTqnDKKN
mtqSpgczKd1BChEWxHpBYglmGgyl3PwzJ8LMgaIjsamsVetAFkNhg/o8B9/3
9zzXn9993ff98KYbWjY0PxYRz/o5MDciPxUx+ERER2nEblxLRwwgqzCiWn6v
3HNqXsFK7+/Nj1hGd9GGoogU0hgtiJgsi7hN1xTL65v3VEQ58rA8P+LwgoiJ
3IjTek/gO7ypvm0OLY9ooYPzInpLIvrpETN8qa9Q7qbeZj6/myPzpBzueF9n
1mlrHTf7UfylbgSdeRE55jmlv0e8Dwut1SieLf69+IS6b+kUzVir12x7+NeZ
Y8ye2s3QybvHPF/Q3ebowPt4YP0xVPJdiuflK/ie5fc0HaDttMCaO+gsepff
V2a+RTdaLy2ewkditWbYhnrU4R81k5hr3vPys+lFcxTSCutf8PxQfoDvKI8/
kGuOHBSZ5W3nUkyH3dVO/OJOfsZl9S/QtNnL8Ja6OgzxK+WXZ+7ryd6sc8aM
B53H5+7pXR4bPW/WXyW+Opnf+xJeKeuMe/4br/JZju3qLuhp5nWePnSeXTyb
9G2TOyfWl3xPer4RbxRvFO8VO4uX+H4tvln8X70TmDbHFK7oKbZGEVrU1Fuj
mW6if9Kj9Fd1V3HfXWbs7x6t9T6fdw0toWuTfSXfOdZgn1gr7w94vO4931m8
7KwLaKtY2r2UI5zxf3qz7HvIN1PDu0bdWvqhuoVqFmMRjmOLuhP0R/yAUziJ
VXx32VcTXU+rkK32Du8bOOdOO53JuPWe4buH/1XP/bitp1J+xMyv0RoMi99D
Wu3W5Nui3eY6iS584lw+xiXx/b6pArWP+HxmrzOSuNjjdIk1V6h/kT6Q38Br
jL5Df1P7kzM6hhznn0mefTcZ9Ji9zb2VmLPEmS+mK+ypAm/I7benWvO20zpa
nfynoE+u3vtM3jf1jeBTsx3CfbmUmm75/wEuXLBp
           "]],
          RowBox[{"-", "0.14`"}]],
         Annotation[#, -0.14, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1Hloz3Ecx/H3XAnZxvixn2OTIkWMyPjDsa0of9hfMjflD2ZKjmmOHLn+
oeTK9SvkyBG1lCvMXFuaPyiLSRpyzLJypTx+fzz3+n4+7+v1+Xx+LX9RRemK
jIgY6M+unIisPhF1mRFbBkRU4ll+RC0yekUUiW8UGy5nLCZYL+8fUUBX04W9
IxLIw/seEW15EY20OCGurk8yIh+ZGJcdsW9gRGv3iOtqL+MMZshf25MOilhB
6/pG3O4XUUMP8XBAXY7YC7Xl+rzhI5UrhtfW03n9a9ZF3k/ho7wm7MmK6MbP
VfXV9u9gkFmL7be3f85+q7yT9A9NmXWbtw36l/LR7ExVPOzRu5qf/bSSjy1Y
iRbzmzFa32EYIT5K31v6DaW1tIpmm7mKdqZv9TvM80s6y7w8+wmsszeNhyUo
Qyk+y2lDT37vineh9Xwk1J12v0fRYMZBPoOPDIwXq+HlPtpZN4oX+r7HbzhT
R3c10XoCbtrrzdMm8zfjihmX02+lZoE76E638bEVbep+4IZ3P45jmC3nhvpv
5n9FLq99MYavOvvz6VN6Uu4J7PPWFbScrwqsxBA5J5xrKd+79VtMj1l/0e8o
XWi9y/58esR6sPxqPedZz8Uj77VT/Im9D/QjPqFAXrYzZuGDsz0Wv+u8mdYP
+ajFBfvn0+/FUy81h/Wfo2er2d/xV+8H8mqwI+1Nj2b3k5J3Sd1y64t0Gf0n
9ynq5a5xrgtyGtQ8x3rxIrMraZ5Zk3iYjCkYIl5Ep6bfw/3mixf7LkGBu+zg
Da7r91PeL/zBb/QX74dv5rcg6TtpRi4Nc2r4fICu6Tu2LhQbSVv0mym/mc6m
r5z3mn7n0c1vK5X+NjeFar/nte4x6XeT5G0wLXQvo1Aitt1Zp/FbRUtpUfr/
A+6IlVl30vuFuibs4Gsv3okl5JwV/w/dCazk
           "]],
          RowBox[{"-", "0.28`"}]],
         Annotation[#, -0.28, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{4706, 5871, 5466, 5467, 4696, 8703, 3779, 3833, 8358, 8038,
            8039, 7670, 8359, 8360, 4697, 6760, 4243, 6342, 7139, 4698, 8704, 
           3780, 6762, 4244, 6761, 4245, 6763, 7616, 8361, 4699, 8894, 7615, 
           4246, 5937, 5303, 5304, 4700, 7262, 4849, 6408, 6409, 5923, 4789, 
           7439, 5120, 6343, 7671, 7672, 5414, 8419, 8420, 7213, 7215, 7214, 
           4702, 7189, 6274, 6275, 5474, 3785, 5477, 7266, 5478, 4794, 6238, 
           6239, 5234, 6237, 6236, 3786, 5939, 7277, 7278, 7275, 4865, 5561, 
           5560, 6424, 6423, 6867, 6422, 6472, 8807, 6471, 8808, 3942, 8529, 
           5003, 8528, 5004, 8530, 4863, 5982, 5145, 7494, 5146, 7495, 4467, 
           8116, 4468, 6996, 4204, 5763, 5275, 5795, 4570, 5441, 6655, 5782, 
           4560, 6043, 6052, 5398, 7372, 4105, 7104, 4114, 6643, 6634, 8017, 
           8026, 8035, 8008, 7031, 8214, 8223, 5463, 6614, 7064, 6623, 4615, 
           8306, 4624, 8315, 4549, 8231, 4540, 8240, 3885, 7721, 7730, 6885, 
           6894, 8815, 8833, 8824, 3987, 7349, 3978, 6523, 5861, 4945, 6268, 
           3773, 5536, 8185, 4511, 8176, 4520, 8194, 4194, 4641, 7870, 7861, 
           4529, 8203, 4234, 8158, 8167, 7843, 7852, 4090, 8521, 7132, 6807, 
           6816, 6365, 7020, 8149, 8723, 4501, 5527, 6595, 7357, 6603, 4973, 
           8780, 4982, 4684, 7589, 7598, 7607, 3824, 8080, 4406, 6926, 6944, 
           6935, 3956, 5956, 4826, 8435, 4835, 5663, 5654, 5728, 7540, 5169, 
           7531, 5178, 6197, 6188, 3965, 5187, 5376, 8645, 8654, 7800, 7809, 
           4043, 6159, 5256}],
          RowBox[{"-", "0.42000000000000004`"}]],
         Annotation[#, -0.42000000000000004`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{6261, 5846, 4676, 5079, 8698, 3759, 5847, 3763, 7993, 7994,
            7992, 4225, 7995, 3764, 8701, 4690, 4226, 7667, 8600, 3830, 8601, 
           5853, 5084, 8602, 5085, 8603, 4691, 5854, 7614, 7613, 4693, 8357, 
           4241, 6340, 7137, 8718, 3831, 7138, 7261, 5156, 8790, 5157, 4915, 
           6020, 7760, 6459, 4916, 7298, 6407, 6406, 6845, 6844, 5266, 5971, 
           4203, 5415, 6373, 3860, 5867, 5925, 4791, 5935, 4792, 7270, 4858, 
           7268, 4857, 7269, 8449, 4853, 8450, 4854, 7267, 4793, 5981, 4860, 
           6250, 5305, 7273, 5306, 4861, 7274, 4862, 7276, 4326, 5631, 5335, 
           5336, 5634, 8729, 5633, 5736, 4416, 7068, 4628, 6687, 7928, 7929, 
           5550, 5551, 4629, 5549, 7086, 7077, 4060, 5424, 6590, 5432, 5771, 
           5762, 5274, 5794, 4569, 5440, 6654, 5781, 4559, 6042, 6051, 5397, 
           7371, 4104, 7103, 4113, 6642, 6633, 8016, 8025, 8034, 8007, 7030, 
           8213, 8222, 5462, 6613, 7063, 6622, 4614, 8305, 4623, 8314, 4548, 
           8230, 4539, 8239, 3884, 7720, 7729, 6884, 6893, 8814, 8832, 8823, 
           3986, 7348, 3977, 6522, 5860, 4944, 6267, 3772, 5535, 8184, 4510, 
           8175, 4519, 8193, 4193, 4640, 7869, 7860, 4528, 8202, 4233, 8157, 
           8166, 7842, 7851, 4089, 8520, 7131, 6806, 6815, 6364, 7019, 8148, 
           8722, 4500, 5526, 6594, 7356, 6602, 4972, 8779, 4981, 4683, 7588, 
           7597, 7606, 3823, 8079, 4405, 6925, 6943, 6934, 3955, 5955, 4825, 
           8434, 4834, 5662, 5653, 5727, 7539, 5168, 7530, 5177, 6196, 6187, 
           3964, 5186, 5375, 8644, 8653, 7799, 7808, 4042, 6158, 5255}],
          RowBox[{"-", "0.56`"}]],
         Annotation[#, -0.56, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{3753, 7978, 7979, 7977, 4217, 7980, 4666, 8771, 4667, 4219,
            7663, 7664, 3818, 3755, 5844, 3760, 8699, 5080, 4677, 5848, 5081, 
           8598, 5082, 8599, 4678, 8351, 8352, 8348, 8350, 8349, 8443, 5408, 
           5409, 4848, 6403, 6404, 6405, 5856, 3889, 8486, 8487, 8485, 8489, 
           8488, 4242, 6341, 6950, 8798, 3832, 6951, 8641, 7546, 7547, 7321, 
           7323, 7322, 4850, 8448, 7265, 4852, 7264, 4851, 7452, 5132, 7451, 
           5131, 5934, 4806, 7311, 4931, 7308, 7310, 7309, 5865, 5626, 3893, 
           6417, 6416, 4859, 6415, 3892, 5926, 7271, 7272, 6412, 6419, 6418, 
           3894, 5559, 6421, 6420, 7315, 4365, 7221, 7222, 6374, 7374, 8730, 
           3861, 7375, 7376, 5334, 5333, 5801, 4324, 5802, 5810, 5548, 7085, 
           7076, 4059, 5423, 6589, 5431, 5770, 5761, 5273, 5793, 4568, 5439, 
           6653, 5780, 4558, 6041, 6050, 5396, 7370, 4103, 7102, 4112, 6641, 
           6632, 8015, 8024, 8033, 8006, 7029, 8212, 8221, 5461, 6612, 7062, 
           6621, 4613, 8304, 4622, 8313, 4547, 8229, 4538, 8238, 3883, 7719, 
           7728, 6883, 6892, 8813, 8831, 8822, 3985, 7347, 3976, 6521, 5859, 
           4943, 6266, 3771, 5534, 8183, 4509, 8174, 4518, 8192, 4192, 4639, 
           7868, 7859, 4527, 8201, 4232, 8156, 8165, 7841, 7850, 4088, 8519, 
           7130, 6805, 6814, 6363, 7018, 8147, 8721, 4499, 5525, 6593, 7355, 
           6601, 4971, 8778, 4980, 4682, 7587, 7596, 7605, 3822, 8078, 4404, 
           6924, 6942, 6933, 3954, 5954, 4824, 8433, 4833, 5661, 5652, 5726, 
           7538, 5167, 7529, 5176, 6195, 6186, 3963, 5185, 5374, 8643, 8652, 
           7798, 7807, 4041, 6157, 5254}],
          RowBox[{"-", "0.7000000000000001`"}]],
         Annotation[#, -0.7000000000000001, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{5253, 6156, 4040, 7806, 7797, 8651, 8642, 5373, 5184, 3962,
            6185, 6194, 5175, 7528, 5166, 7537, 5725, 5651, 5660, 4832, 8432, 
           4823, 5953, 3953, 6932, 6941, 6923, 4403, 8077, 3821, 7604, 7595, 
           7586, 4681, 4979, 8777, 4970, 6600, 7354, 6592, 5524, 4498, 8720, 
           8146, 7017, 6362, 6813, 6804, 7129, 8518, 4087, 7849, 7840, 8164, 
           8155, 4231, 8200, 4526, 7858, 7867, 4638, 4191, 8191, 4517, 8173, 
           4508, 8182, 5533, 3770, 6265, 4942, 5858, 6520, 3975, 7346, 3984, 
           8821, 8830, 8812, 6891, 6882, 7727, 7718, 3882, 8237, 4537, 8228, 
           4546, 8312, 4621, 8303, 4612, 6620, 7061, 6611, 5460, 8220, 8211, 
           7028, 8005, 8032, 8023, 8014, 6631, 6640, 4111, 7101, 4102, 7369, 
           5395, 6049, 6040, 4557, 5779, 6652, 5438, 4567, 5792, 5272, 5760, 
           5769, 5430, 6588, 5422, 4058, 7075, 7084, 5547, 5809, 4323, 6069, 
           4325, 5558, 7927, 4152, 7219, 7220, 7216, 7218, 7217, 5632, 3949, 
           6493, 6492, 7314, 7313, 4703, 6857, 4364, 6411, 6413, 6414, 4397, 
           5359, 5358, 5980, 4363, 5866, 4701, 5623, 6273, 7306, 7307, 6491, 
           7781, 7782, 6745, 6746, 6744, 6955, 6954, 8090, 3891, 5357, 5141, 
           5610, 5609, 5965, 5963, 5964, 4922, 5162, 8740, 3934, 8637, 5161, 
           8605, 5086, 8604, 5087, 5606, 5605, 3765, 6339, 6338, 6756, 4227, 
           8757, 6396, 7713, 7712, 4845, 8444, 7711, 7710, 4844, 8442, 7256, 
           6336, 6335, 6334, 4224, 6755, 3756, 3819, 7666, 7665, 7982, 7981, 
           3754, 3817, 4668, 8338, 4669, 8339, 4218, 5455, 6260}],
          RowBox[{"-", "0.8400000000000001`"}]],
         Annotation[#, -0.8400000000000001, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{7984, 4221, 7983, 4220, 8340, 4671, 7127, 4670, 5300, 5299,
            8343, 4673, 8341, 4672, 8342, 4841, 3761, 8700, 4679, 5301, 5302, 
           7583, 8346, 8347, 6359, 6358, 3857, 7258, 3858, 8719, 7257, 6360, 
           6456, 6455, 3923, 7297, 4913, 7520, 4914, 6019, 4846, 6243, 6244, 
           5232, 8685, 8687, 8686, 3876, 8506, 7325, 7326, 8089, 8088, 4414, 
           5608, 5607, 3940, 6469, 6470, 6262, 6263, 3767, 7305, 3781, 5621, 
           5622, 4927, 5625, 5624, 3926, 5629, 5630, 4788, 5628, 5627, 3782, 
           7312, 4932, 7337, 4933, 6031, 7788, 6970, 4448, 8109, 4442, 7487, 
           7493, 7469, 7481, 7475, 5979, 4158, 6686, 5557, 6075, 6068, 4322, 
           5808, 5546, 7083, 7074, 4057, 5421, 6587, 5429, 5768, 5759, 5271, 
           5791, 4566, 5437, 6651, 5778, 4556, 6039, 6048, 5394, 7368, 4101, 
           7100, 4110, 6639, 6630, 8013, 8022, 8031, 8004, 7027, 8210, 8219, 
           5459, 6610, 7060, 6619, 4611, 8302, 4620, 8311, 4545, 8227, 4536, 
           8236, 3881, 7717, 7726, 6881, 6890, 8811, 8829, 8820, 3983, 7345, 
           3974, 6519, 5857, 4941, 6264, 3769, 5532, 8181, 4507, 8172, 4516, 
           8190, 4190, 4637, 7866, 7857, 4525, 8199, 4230, 8154, 8163, 7839, 
           7848, 4086, 8517, 7128, 6803, 6812, 6361, 7016, 8145, 4316, 7015, 
           4497, 8144, 4496, 5070, 8756, 4189, 4842, 8733, 3874, 5962, 3875, 
           8734, 4843, 8441, 8345, 4675, 8344, 4674, 5845, 8595, 5078, 8594, 
           8597, 8596, 4223, 7990, 4222, 7991, 3758, 7988, 7989, 7985, 7987, 
           7986, 3757, 7984}],
          RowBox[{"-", "0.9800000000000001`"}]],
         Annotation[#, -0.9800000000000001, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{6978, 6515, 6516, 3972, 5412, 3971, 7787, 6514, 4455, 6976,
            5262, 5263, 7669, 7668, 5107, 8620, 4969, 7833, 7834, 7835, 5966, 
           7838, 7837, 7836, 8516, 8515, 5353, 4912, 8736, 3922, 5850, 4786, 
           8773, 4787, 6337, 3820, 5849, 6235, 5229, 6252, 5230, 7571, 5247, 
           7570, 5246, 8696, 5244, 8695, 5245, 8697, 5083, 6155, 5851, 5852, 
           4680, 7584, 7585, 3762, 8353, 3766, 5264, 5226, 5407, 5406, 3879, 
           4389, 8759, 4390, 4049, 8741, 4466, 4050, 5749, 4051, 8742, 4963, 
           6517, 6518, 3973, 7344, 3982, 8819, 8828, 8810, 6889, 6880, 7725, 
           7716, 3880, 8235, 4535, 8226, 4544, 8310, 4619, 8301, 4610, 6618, 
           7059, 6609, 5458, 8218, 8209, 7026, 8003, 8030, 8021, 8012, 6629, 
           6638, 4109, 7099, 4100, 7367, 5393, 6047, 6038, 4555, 5777, 6650, 
           5436, 4565, 5790, 5270, 5758, 5767, 5428, 6586, 5420, 4056, 7073, 
           7082, 5545, 5807, 4321, 6067, 6074, 5556, 6685, 4157, 5978, 7474, 
           7480, 7468, 7492, 7486, 4441, 8108, 4447, 6969, 7793, 4000, 6030, 
           3995, 6539, 6534, 4958, 7336, 4433, 5743, 5615, 5620, 5117, 6855, 
           5112, 7438, 5922, 6680, 6676, 5673, 5002, 6060, 5365, 7304, 4928, 
           6487, 7776, 7777, 6024, 6480, 6479, 6476, 5164, 7526, 4361, 6847, 
           8064, 6848, 6467, 6466, 7772, 7771, 6468, 6953, 6952, 7263, 6977, 
           6978}],
          RowBox[{"-", "1.12`"}]],
         Annotation[#, -1.12, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{8753, 4988, 6627, 4095, 5456, 6617, 5457, 8217, 8208, 7025,
            8002, 8029, 8020, 8011, 6628, 6637, 4108, 7098, 4099, 7366, 5392, 
           6046, 6037, 4554, 5776, 6649, 5435, 4564, 5789, 5269, 5757, 5766, 
           5427, 6585, 5419, 4055, 7072, 7081, 5544, 5806, 4320, 6066, 6073, 
           5555, 6684, 4156, 5977, 7473, 7479, 7467, 7491, 7485, 4440, 8107, 
           4446, 6968, 7792, 3999, 6029, 3994, 6538, 6533, 4957, 7335, 4432, 
           5742, 5614, 5619, 5116, 6854, 5111, 7437, 5921, 4150, 6679, 5672, 
           6059, 4396, 5800, 4393, 7209, 7212, 6486, 7206, 7202, 7327, 3945, 
           6483, 6478, 6963, 6962, 5354, 6846, 5355, 5735, 5734, 3890, 5748, 
           5410, 5411, 5969, 5968, 4202, 8910, 5413, 6475, 8774, 8775, 8446, 
           8447, 4847, 8445, 7714, 7715, 5967, 6401, 6400, 6399, 7260, 7259, 
           4228, 6757, 4229, 6758, 7758, 3924, 6457, 6458, 6397, 6398, 3877, 
           8086, 7997, 7998, 7996, 8000, 7999, 3925, 7759, 8076, 8075, 4359, 
           6232, 4360, 5604, 6402, 3878, 5855, 4692, 8354, 8356, 8355, 4096, 
           6035, 4097, 8753}],
          RowBox[{"-", "1.2600000000000002`"}]],
         Annotation[#, -1.2600000000000002`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{5671, 6058, 4395, 5799, 4392, 7208, 7211, 6485, 7205, 7201,
            7329, 4951, 6482, 6481, 6477, 4428, 5356, 4427, 7463, 5140, 7461, 
           5139, 7462, 5970, 6529, 6528, 6527, 4953, 7331, 4802, 7197, 7199, 
           7198, 4357, 6148, 4358, 5603, 6579, 6580, 5220, 7566, 8661, 8660, 
           5089, 8606, 5088, 8607, 3768, 8510, 4965, 8509, 4966, 8511, 4964, 
           8514, 4968, 8512, 4967, 8513, 3933, 5371, 4930, 7778, 7779, 7780, 
           8639, 8638, 3946, 8694, 5241, 8693, 5242, 6248, 6247, 4929, 6025, 
           5142, 5144, 8789, 5143, 5972, 4804, 5932, 4805, 5933, 5784, 5785, 
           4646, 6646, 7107, 7097, 4098, 7365, 5391, 6045, 6036, 4553, 5775, 
           6648, 5434, 4563, 5788, 5268, 5756, 5765, 5426, 6584, 5418, 4054, 
           7071, 7080, 5543, 5805, 4319, 6065, 6072, 5554, 6683, 4155, 5976, 
           7472, 7478, 7466, 7490, 7484, 4439, 8106, 4445, 6967, 7791, 3998, 
           6028, 3993, 6537, 6532, 4956, 7334, 4431, 5741, 5613, 5618, 5115, 
           6853, 5110, 7436, 5920, 4149, 6678, 5671}],
          RowBox[{"-", "1.4000000000000001`"}]],
         Annotation[#, -1.4000000000000001`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{6057, 5670, 6677, 4148, 5919, 7435, 5109, 6852, 5114, 5617,
            5612, 5740, 4430, 7333, 4955, 6531, 6536, 3992, 6027, 3997, 7790, 
           6966, 4444, 8105, 4438, 7483, 7489, 7465, 7477, 7471, 5975, 4154, 
           6682, 5553, 6071, 6064, 4318, 5804, 5542, 7079, 7070, 4053, 5417, 
           6583, 5425, 5764, 5755, 5267, 5787, 5276, 4562, 5786, 5774, 7096, 
           6859, 6860, 6858, 6862, 6861, 3941, 6022, 6023, 4926, 8500, 8502, 
           8501, 8507, 3859, 8681, 5221, 8680, 5222, 6062, 6061, 4151, 6994, 
           6995, 6993, 7095, 7094, 8336, 6989, 6990, 6988, 6992, 6991, 4199, 
           6147, 7961, 7960, 7959, 5073, 5797, 5796, 5669, 6372, 6371, 6370, 
           4803, 7330, 4952, 7203, 7328, 7200, 7204, 6484, 7210, 7207, 4391, 
           5798, 4394, 6057}],
          RowBox[{"-", "1.54`"}]],
         Annotation[#, -1.54, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{6850, 6410, 7737, 8065, 4362, 8066, 6856, 6488, 6489, 3947,
            6980, 3948, 8809, 6979, 6490, 4434, 6964, 4855, 8451, 4856, 8452, 
           4415, 8561, 8562, 7945, 7946, 4178, 5973, 4179, 7948, 7947, 8564, 
           8563, 6581, 6582, 5416, 4052, 7069, 7078, 5541, 5803, 4317, 6063, 
           6070, 5552, 6681, 4153, 5974, 7470, 7476, 7464, 7488, 7482, 4437, 
           8104, 4443, 6965, 7789, 3996, 6026, 3991, 6535, 6530, 4954, 7332, 
           4429, 5739, 5611, 5616, 5113, 6851, 5108, 7434, 7433, 6849, 6850}],
          
          RowBox[{"-", "1.6800000000000002`"}]],
         Annotation[#, -1.6800000000000002`, "Tooltip"]& ]}, {}, {}}}],
    AspectRatio->1,
    Frame->True,
    PlotRange->{{-3, 3}, {-3, 3}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{390, 185},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->395381796]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31524],

Cell["Compose with inverse function:", "ExampleText",
 CellID->196753002],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"InverseJacobiSC", "[", 
    RowBox[{
     RowBox[{"JacobiSC", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], ",", 
   RowBox[{"JacobiSC", "[", 
    RowBox[{
     RowBox[{"InverseJacobiSC", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5296189],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"InverseJacobiSC", "[", 
    RowBox[{
     RowBox[{"JacobiSC", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], ",", "z"}], 
  "}"}]], "Output",
 ImageSize->{269, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->261362716]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " to disregard multivaluedness of the inverse function:"
}], "ExampleText",
 CellID->785308763],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->81233632],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", "z"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->185674578]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->390870124],

Cell[TextData[{
 "Differentiate",
 Cell[BoxData[
  RowBox[{" ", "InverseJacobiSC"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->715886131],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"InverseJacobiSC", "[", 
     RowBox[{"z", ",", "m"}], "]"}], ",", "z"}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->809586479],

Cell[BoxData[
 FractionBox[
  RowBox[{"JacobiND", "[", 
   RowBox[{
    RowBox[{"InverseJacobiSC", "[", 
     RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], 
  RowBox[{"1", "+", 
   SuperscriptBox["z", "2"]}]]], "Output",
 ImageSize->{241, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->532103514]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"InverseJacobiSC", "[", 
     RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->192074691],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", "m", " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["z", "2"]}], ")"}]}]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["z", "2"]}], ")"}], " ", 
      RowBox[{"EllipticE", "[", 
       RowBox[{
        RowBox[{"JacobiAmplitude", "[", 
         RowBox[{
          RowBox[{"InverseJacobiSC", "[", 
           RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], ",", "m"}], 
       "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        SuperscriptBox["z", "2"]}], ")"}], " ", 
      RowBox[{"InverseJacobiSC", "[", 
       RowBox[{"z", ",", "m"}], "]"}]}], "-", 
     RowBox[{"m", " ", "z", " ", 
      RowBox[{"JacobiND", "[", 
       RowBox[{
        RowBox[{"InverseJacobiSC", "[", 
         RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}]}]}], 
    ")"}]}]}]], "Output",
 ImageSize->{579, 55},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->54399601]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20875427],

Cell[TextData[{
 "Obtain",
 Cell[BoxData[
  RowBox[{" ", "InverseJacobiSC"}]], "InlineFormula"],
 " from solving equations containing elliptic functions:"
}], "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->322808586],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"JacobiSC", "[", 
       RowBox[{"x", ",", "m"}], "]"}], "2"], "+", 
     RowBox[{"2", 
      RowBox[{"JacobiSC", "[", 
       RowBox[{"x", ",", "m"}], "]"}]}]}], "==", "a"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->554970152],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->352271322],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      RowBox[{"InverseJacobiSC", "[", 
       RowBox[{
        RowBox[{"1", "-", 
         SqrtBox[
          RowBox[{"1", "+", "a"}]]}], ",", "m"}], "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      RowBox[{"InverseJacobiSC", "[", 
       RowBox[{
        RowBox[{"1", "+", 
         SqrtBox[
          RowBox[{"1", "+", "a"}]]}], ",", "m"}], "]"}]}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{520, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->254232337]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24551],

Cell["\<\
Machine-precision input is insufficient to get a correct answer:\
\>", "ExampleText",
 CellID->3979231],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiSC", "[", 
  RowBox[{
   RowBox[{"10.", "^", "25"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->563558634],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->329085650]
}, Open  ]],

Cell["With exact input, the answer is correct:", "ExampleText",
 CellID->260060486],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"InverseJacobiSC", "[", 
    RowBox[{
     RowBox[{"10", "^", "25"}], ",", "2"}], "]"}], ",", "50"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->289346646],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "-", "1.3110287771460599052324197949455597068413774757158115814084108519004`\
50."}], "+", 
  RowBox[{
  "1.3110287771460599052324198949455597068413774757158115814084108519004`50.",
    " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{379, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->119123740]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31871],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiSC",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiSC"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseJacobiSD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseJacobiSD"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseJacobiSN",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseJacobiSN"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseJacobiDC",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseJacobiDC"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25673]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32062],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "Tutorials",
 CellID->15628]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->228501892],

Cell[TextData[ButtonBox["Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticFunctions"]], "MoreAbout",
 CellID->37649325]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InverseJacobiSC - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 50, 49.0742012}", "context" -> "System`", 
    "keywords" -> {"inverse Jacobi", "inverse Jacobi elliptic function sc"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "InverseJacobiSC[v, m] gives the inverse Jacobi elliptic function sc -1 \
(v \\[VerticalSeparator] m).", "synonyms" -> {"inverse Jacobi SC"}, "title" -> 
    "InverseJacobiSC", "type" -> "Symbol", "uri" -> "ref/InverseJacobiSC"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6526, 226, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->49381918]},
 "XRef-2005-4-26-23-37-1.8558342"->{
  Cell[663867, 11564, 192, 7, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342",
   CellID->715886131],
  Cell[666359, 11663, 238, 7, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342",
   CellID->322808586]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 673163, 11910},
 {"XRef-2005-4-26-23-37-1.8558342", 673319, 11914}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2187, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2810, 81, 52, 1, 70, "ObjectName",
 CellID->3062],
Cell[2865, 84, 779, 25, 70, "Usage",
 CellID->14981]
}, Open  ]],
Cell[CellGroupData[{
Cell[3681, 114, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4159, 131, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4282, 137, 533, 21, 70, "Notes",
 CellID->20276],
Cell[4818, 160, 836, 28, 70, "Notes",
 CellID->17076495],
Cell[5657, 190, 114, 3, 70, "Notes",
 CellID->28289],
Cell[5774, 195, 262, 8, 70, "Notes",
 CellID->851816954],
Cell[6039, 205, 232, 7, 70, "Notes",
 CellID->31226],
Cell[6274, 214, 215, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6526, 226, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->49381918],
Cell[CellGroupData[{
Cell[6910, 240, 148, 5, 70, "ExampleSection",
 CellID->373519508],
Cell[7061, 247, 64, 1, 70, "ExampleText",
 CellID->705017992],
Cell[CellGroupData[{
Cell[7150, 252, 138, 4, 28, "Input",
 CellID->151794200],
Cell[7291, 258, 256, 7, 36, "Output",
 CellID->814232634]
}, Open  ]],
Cell[CellGroupData[{
Cell[7584, 270, 129, 4, 28, "Input",
 CellID->327044294],
Cell[7716, 276, 174, 5, 36, "Output",
 CellID->6759144]
}, Open  ]],
Cell[7905, 284, 125, 3, 70, "ExampleDelimiter",
 CellID->615017572],
Cell[CellGroupData[{
Cell[8055, 291, 299, 10, 28, "Input",
 CellID->141027997],
Cell[8357, 303, 2354, 43, 129, "Output",
 Evaluatable->False,
 CellID->5355588]
}, Open  ]],
Cell[10726, 349, 125, 3, 70, "ExampleDelimiter",
 CellID->526408911],
Cell[10854, 354, 60, 1, 70, "ExampleText",
 CellID->52392619],
Cell[CellGroupData[{
Cell[10939, 359, 252, 8, 70, "Input",
 CellID->648348344],
Cell[11194, 369, 1367, 43, 51, "Output",
 CellID->823460035]
}, Open  ]],
Cell[CellGroupData[{
Cell[12598, 417, 252, 8, 70, "Input",
 CellID->423922134],
Cell[12853, 427, 1006, 32, 62, "Output",
 CellID->97302418]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13908, 465, 215, 7, 70, "ExampleSection",
 CellID->5772],
Cell[14126, 474, 74, 1, 70, "ExampleText",
 CellID->509366112],
Cell[CellGroupData[{
Cell[14225, 479, 208, 7, 70, "Input",
 CellID->261814282],
Cell[14436, 488, 274, 7, 36, "Output",
 CellID->324984126]
}, Open  ]],
Cell[14725, 498, 125, 3, 70, "ExampleDelimiter",
 CellID->167176234],
Cell[14853, 503, 70, 1, 70, "ExampleText",
 CellID->271907475],
Cell[CellGroupData[{
Cell[14948, 508, 215, 7, 70, "Input",
 CellID->156064659],
Cell[15166, 517, 325, 9, 36, "Output",
 CellID->548708064]
}, Open  ]],
Cell[15506, 529, 124, 3, 70, "ExampleDelimiter",
 CellID->93714622],
Cell[15633, 534, 113, 3, 70, "ExampleText",
 CellID->213315987],
Cell[CellGroupData[{
Cell[15771, 541, 170, 5, 70, "Input",
 CellID->67253859],
Cell[15944, 548, 229, 6, 36, "Output",
 CellID->171198811]
}, Open  ]],
Cell[16188, 557, 125, 3, 70, "ExampleDelimiter",
 CellID->401201374],
Cell[16316, 562, 232, 7, 70, "ExampleText",
 CellID->367335492],
Cell[CellGroupData[{
Cell[16573, 573, 185, 6, 70, "Input",
 CellID->212944832],
Cell[16761, 581, 341, 11, 36, "Output",
 CellID->33690680]
}, Open  ]],
Cell[17117, 595, 125, 3, 70, "ExampleDelimiter",
 CellID->147858719],
Cell[17245, 600, 91, 1, 70, "ExampleText",
 CellID->98266840],
Cell[CellGroupData[{
Cell[17361, 605, 250, 8, 70, "Input",
 CellID->20890801],
Cell[17614, 615, 273, 9, 36, "Output",
 CellID->274875174]
}, Open  ]],
Cell[CellGroupData[{
Cell[17924, 629, 258, 8, 70, "Input",
 CellID->211875868],
Cell[18185, 639, 242, 8, 36, "Output",
 CellID->1071452310]
}, Open  ]],
Cell[18442, 650, 90, 1, 70, "ExampleText",
 CellID->328138587],
Cell[CellGroupData[{
Cell[18557, 655, 153, 5, 70, "Input",
 CellID->291795526],
Cell[18713, 662, 242, 8, 36, "Output",
 CellID->386017234]
}, Open  ]],
Cell[18970, 673, 125, 3, 70, "ExampleDelimiter",
 CellID->414636117],
Cell[19098, 678, 203, 7, 70, "ExampleText",
 CellID->211330550],
Cell[CellGroupData[{
Cell[19326, 689, 171, 5, 70, "Input",
 CellID->5847741],
Cell[19500, 696, 322, 11, 52, "Output",
 CellID->44330635]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19871, 713, 239, 7, 70, "ExampleSection",
 CellID->31171],
Cell[20113, 722, 225, 7, 70, "ExampleText",
 CellID->364782583],
Cell[CellGroupData[{
Cell[20363, 733, 246, 8, 70, "Input",
 CellID->313682697],
Cell[20612, 743, 911, 29, 51, "Output",
 CellID->499707855]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21572, 778, 223, 7, 70, "ExampleSection",
 CellID->14468],
Cell[21798, 787, 123, 3, 70, "ExampleText",
 CellID->147991225],
Cell[CellGroupData[{
Cell[21946, 794, 716, 23, 70, "Input",
 CellID->41283476],
Cell[22665, 819, 639356, 10664, 70, "Output",
 CellID->395381796]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[662070, 11489, 233, 7, 70, "ExampleSection",
 CellID->31524],
Cell[662306, 11498, 73, 1, 70, "ExampleText",
 CellID->196753002],
Cell[CellGroupData[{
Cell[662404, 11503, 379, 12, 70, "Input",
 CellID->5296189],
Cell[662786, 11517, 340, 12, 36, "Output",
 CellID->261362716]
}, Open  ]],
Cell[663141, 11532, 246, 8, 70, "ExampleText",
 CellID->785308763],
Cell[CellGroupData[{
Cell[663412, 11544, 106, 3, 70, "Input",
 CellID->81233632],
Cell[663521, 11549, 203, 7, 36, "Output",
 CellID->185674578]
}, Open  ]],
Cell[663739, 11559, 125, 3, 70, "ExampleDelimiter",
 CellID->390870124],
Cell[663867, 11564, 192, 7, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->715886131],
Cell[CellGroupData[{
Cell[664084, 11575, 225, 8, 70, "Input",
 CellID->809586479],
Cell[664312, 11585, 356, 12, 52, "Output",
 CellID->532103514]
}, Open  ]],
Cell[CellGroupData[{
Cell[664705, 11602, 225, 8, 70, "Input",
 CellID->192074691],
Cell[664933, 11612, 1284, 43, 76, "Output",
 CellID->54399601]
}, Open  ]],
Cell[666232, 11658, 124, 3, 70, "ExampleDelimiter",
 CellID->20875427],
Cell[666359, 11663, 238, 7, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->322808586],
Cell[CellGroupData[{
Cell[666622, 11674, 359, 13, 70, "Input",
 CellID->554970152],
Cell[666984, 11689, 453, 8, 70, "Message",
 CellID->352271322],
Cell[667440, 11699, 665, 24, 43, "Output",
 CellID->254232337]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[668154, 11729, 226, 7, 70, "ExampleSection",
 CellID->24551],
Cell[668383, 11738, 113, 3, 70, "ExampleText",
 CellID->3979231],
Cell[CellGroupData[{
Cell[668521, 11745, 161, 5, 70, "Input",
 CellID->563558634],
Cell[668685, 11752, 170, 5, 36, "Output",
 CellID->329085650]
}, Open  ]],
Cell[668870, 11760, 83, 1, 70, "ExampleText",
 CellID->260060486],
Cell[CellGroupData[{
Cell[668978, 11765, 220, 8, 70, "Input",
 CellID->289346646],
Cell[669201, 11775, 390, 12, 54, "Output",
 CellID->119123740]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[669652, 11794, 311, 9, 70, "SeeAlsoSection",
 CellID->31871],
Cell[669966, 11805, 983, 35, 70, "SeeAlso",
 CellID->25673]
}, Open  ]],
Cell[CellGroupData[{
Cell[670986, 11845, 314, 9, 70, "TutorialsSection",
 CellID->32062],
Cell[671303, 11856, 192, 4, 70, "Tutorials",
 CellID->15628]
}, Open  ]],
Cell[CellGroupData[{
Cell[671532, 11865, 319, 9, 70, "MoreAboutSection",
 CellID->228501892],
Cell[671854, 11876, 146, 3, 70, "MoreAbout",
 CellID->37649325]
}, Open  ]],
Cell[672015, 11882, 27, 0, 70, "History"],
Cell[672045, 11884, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

