(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    662800,      11978]
NotebookOptionsPosition[    653902,      11672]
NotebookOutlinePosition[    655552,      11716]
CellTagsIndexPosition[    655412,      11710]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals and Elliptic Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals and Elliptic Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"JacobiSD" :> Documentation`HelpLookup["paclet:ref/JacobiSD"], 
          "InverseJacobiSC" :> 
          Documentation`HelpLookup["paclet:ref/InverseJacobiSC"], 
          "InverseJacobiSN" :> 
          Documentation`HelpLookup["paclet:ref/InverseJacobiSN"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"JacobiSD\"\>", 
       2->"\<\"InverseJacobiSC\"\>", 
       3->"\<\"InverseJacobiSN\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Functions" :> 
          Documentation`HelpLookup["paclet:guide/EllipticFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Elliptic Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InverseJacobiSD", "ObjectName",
 CellID->24837],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InverseJacobiSD",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InverseJacobiSD"], "[", 
       RowBox[{
        StyleBox["v", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the inverse Jacobi elliptic function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox["sd", 
         RowBox[{"-", "1"}]], "(", 
        RowBox[{"v", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
      "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28861]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["sd", 
     RowBox[{"-", "1"}]], "(", 
    RowBox[{"v", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " gives the value of ",
 Cell[BoxData[
  FormBox[
   StyleBox["u", "TI"], TraditionalForm]], "InlineFormula"],
 " for which ",
 Cell[BoxData[
  FormBox[
   RowBox[{"v", "=", 
    RowBox[{"sd", "(", 
     RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->7278],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseJacobiSD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiSD"]], "InlineFormula"],
 " has branch cut discontinuities in the complex ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " plane with branch points at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{"\[PlusMinus]", "1"}], "/", 
     SqrtBox[
      RowBox[{"-", "m"}]]}], ",", 
    RowBox[{
     RowBox[{"\[PlusMinus]", "1"}], "/", 
     SqrtBox[
      RowBox[{"1", "-", "m"}]]}]}], TraditionalForm]], "InlineMath"],
 " and infinity, and in the complex ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " plane with branch points at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["z", 
      RowBox[{"-", "2"}]]}], ",", 
    RowBox[{"1", "-", 
     SuperscriptBox["z", 
      RowBox[{"-", "2"}]]}]}], TraditionalForm]], "InlineMath"],
 " and infinity."
}], "Notes",
 CellID->60102941],

Cell["\<\
The inverse Jacobi elliptic functions are related to elliptic integrals. \
\>", "Notes",
 CellID->18175],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["InverseJacobiSD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiSD"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->58451189],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseJacobiSD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiSD"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseJacobiSD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiSD"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->106417767],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->713940417],

Cell["Evaluate numerically:", "ExampleText",
 CellID->350008984],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiSD", "[", 
  RowBox[{"0.4", ",", "0.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->498082285],

Cell[BoxData["0.40025668519812685`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9880443]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiSD", "[", 
  RowBox[{"%", ",", "0.5"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->36360218],

Cell[BoxData["0.40000000000000024`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->163072896]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->171468804],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"InverseJacobiSD", "[", 
    RowBox[{"x", ",", 
     RowBox[{"2", "/", "3"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->501785274],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWEtolUcUHnNvYtXamJfRxMf1ca/xXTVtGk1iNCa+EbVWQVzEICQLtWjc
2E27aTftpt3UjS5sC9UulIpFUBAFURAFURAVREF0oRQqXQSE6zfnzPx3Zv7z
33sRFwby3/nn/+acM+c9s7l/eHDf/v7hoYH+zNpD/V8PDg0czvQdPISp1Cil
1Dn8D09SGOcxov9z+Tx+3ec2PNP4VKnfUhpDf+or+rrdmVWJqBqaPXH85tUr
j/XwC0MzHaDDd3f177/dPvbrDT1cFaBSeFTgdaeDBqNvjl5IQifxeP16ZOuW
kyMjb1QXiVNAJe2slmZ/+fna6VN39LDLyFJVBP38+X97dv+pufSJqDpNA8rq
8/ZVT9iDB/6+feuZHq4R19bbfQzs/Qt8ElANVg6ggFU9ImoizT588HJo8Iym
tVpENTqoJ0/+JX0XpJ5kOeHrjetPVbdIY7KV+sjweWxcrRRRzdaLoIRXr/5X
nSJqCs1CSdgbnqpDRE0l+4IKaMGtYIzlntzTrc+Byr27L1S7SCVDVLBr7O6n
H69iA20ibibNnj1zD3bXWvhcRM2yMkEL3317EYNWEZel2UsXH4EaJFTLPMlz
RAWiYFsAQAVLRCotVnZogLktFnHzAm6afioxHub73LHZbICTY3yhlQZ7R+DC
YbS1k3JEYbckcxrRDmZsxxll8fuUPgGOLe3c8Qe2lylr3VJrI6gMRodrTCtr
HVkyDTh7Cgg054tlCvKQNHsMRBT2xbg2X99QRMbTD/ltGuqEUmFohGkoL9NZ
QTiOGpZviojrjMnVJOK6YnJNFnHdjnwwPRyg0ZOfck4abgS52L4NIp0e357g
Vy/ieq39mB8Y14q4KuN9c/Ls7XVWDvYzbGxCsC5rkDnXb9VoB6XrY0uwqs6R
G6Sh2Gqz/zkBMhdQYvpczvivwr46qzJGmnC+weoBxmY/Hl+Enx6G8jDjMSVW
UXUwfo8qCb2NK7Ei1FBFWXzYu1CEocR/zt9XY9+JC8WiV/VDXJPV2w/fX0Y8
wV8/KsEpG6NZ8IwKw0H/UlyaCGRPrzJfcgGSMi/1ZY7nwDXljPxl3kRYlFnl
DoieVZxJUWNBmKXdRT8UjZWYxCdTxKJvmt5Z8sAwl4USfTDfTS173/TfNz3H
K4tEIvloJd7doq/CuhuuYtq79XN0NOu2A+xhjAjXmX4A6UptFVHkYzr/c35B
3dki4mjHOj/A6zk/bBZxnEcL8b1JRFEsmuhkrhtE3NgY13Ui7uOA69oIpePw
kxi3XpFKdYxbj4irsdxQwPDk2hdD1VrNghSbulvEUf3z+rsuT3rOzLAjuHEl
7xDpMA6fo0q+QsRRBvY6jXYRR128yXNQHORqE3HcoUPrUafxmSf/dKuHSK5W
kU4mJtdSETfTkYt7eeoR6YQr9buz6R0RAP3pOKBOlLNtkW4wa6WO6u7CxHUp
2wWY+slWnF8Wn7mOdTmbzy1r3TxrbSziPqqlrHUL8vmor+K6mIu0J3W5i6y2
o759tmddPrNEpY3PRjGbLbG2RW1jX5oh4pbRO/uSjuOMiGq1tgEpEAS1aSKO
T2/cC2pqU0VUW4xas4hrt9Tgd3qnTSJqOb3z2RD64miLoTqs1oDS5/pGEdVp
OZoT+0QRRdkixWdbXU8aPPvwOR482Ik528RoRCgOPO52Y6hVAapWRPHtA98k
6OpUI6L4JgPygpYeTvCkpvycQhwhMPSwWqSxxuoaAaBvaRiVdA/GNOH25m6L
qkLJezFeVbil4lWloqzXamrj+hOFVTsClK69+pVvl1Z2HjPz4xPR7juvgh28
Vdxtul1s8n1g8qk2fruoRr0FqSHQkg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->118807388]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->76976753],

Cell["Series expansions:", "ExampleText",
 CellID->97765718],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"InverseJacobiSD", "[", 
    RowBox[{"x", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "7"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->404168808],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox["1", "6"], "-", 
      FractionBox["m", "3"]}], ")"}], " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{
    FractionBox["1", "40"], " ", 
    RowBox[{"(", 
     RowBox[{"3", "-", 
      RowBox[{"8", " ", "m"}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["m", "2"]}]}], ")"}], " ", 
    SuperscriptBox["x", "5"]}], "+", 
   RowBox[{
    FractionBox["1", "112"], " ", 
    RowBox[{"(", 
     RowBox[{"5", "-", 
      RowBox[{"18", " ", "m"}], "+", 
      RowBox[{"24", " ", 
       SuperscriptBox["m", "2"]}], "-", 
      RowBox[{"16", " ", 
       SuperscriptBox["m", "3"]}]}], ")"}], " ", 
    SuperscriptBox["x", "7"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "8"],
    SeriesData[$CellContext`x, 0, {}, 1, 8, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
   1, 0, Rational[1, 6] + Rational[-1, 3] $CellContext`m, 0, 
    Rational[1, 40] (3 - 8 $CellContext`m + 8 $CellContext`m^2), 0, 
    Rational[1, 112] (5 - 18 $CellContext`m + 24 $CellContext`m^2 - 
     16 $CellContext`m^3)}, 1, 8, 1],
  Editable->False]], "Output",
 ImageSize->{468, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->253645566]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"InverseJacobiSD", "[", 
    RowBox[{"x", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->497017224],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"ArcSin", "[", "x", "]"}], "+", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", " ", 
        SqrtBox[
         RowBox[{"1", "-", 
          SuperscriptBox["x", "2"]}]]}], "+", 
       RowBox[{
        SuperscriptBox["x", "3"], " ", 
        SqrtBox[
         RowBox[{"1", "-", 
          SuperscriptBox["x", "2"]}]]}], "-", 
       RowBox[{"ArcSin", "[", "x", "]"}], "+", 
       RowBox[{
        SuperscriptBox["x", "2"], " ", 
        RowBox[{"ArcSin", "[", "x", "]"}]}]}], ")"}], " ", "m"}], 
    RowBox[{"4", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["x", "2"]}], ")"}]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "m", "]"}], "2"],
    SeriesData[$CellContext`m, 0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`m, 0, {
    ArcSin[$CellContext`x], 
    Rational[1, 
      4] (-1 + $CellContext`x^2)^(-1) ($CellContext`x (1 - $CellContext`x^2)^
       Rational[1, 2] + $CellContext`x^3 (1 - $CellContext`x^2)^
       Rational[1, 2] - 
     ArcSin[$CellContext`x] + $CellContext`x^2 ArcSin[$CellContext`x])}, 0, 2,
    1],
  Editable->False]], "Output",
 ImageSize->{461, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->471140130]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12793],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->55645938],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiSD", "[", 
  RowBox[{
   RowBox[{"0.2", "+", "I"}], ",", 
   RowBox[{"0.1", "-", 
    RowBox[{"0.3", "I"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->266251706],

Cell[BoxData[
 RowBox[{"0.21050379760273705`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.8671395189929242`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->629888079]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->268824359],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->132691703],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"InverseJacobiSD", "[", 
    RowBox[{
     RowBox[{"1", "/", "2"}], ",", 
     RowBox[{"1", "/", "2"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->866802414],

Cell[BoxData["0.\
500786382597628245410102852397702513702554250792439530530812120525`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->71261095]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->36479535],

Cell["\<\
The precision of the input tracks the precision of the output:\
\>", "ExampleText",
 CellID->579439215],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiSD", "[", 
  RowBox[{
   RowBox[{"1", "/", "2"}], ",", "0.50000000000000000000000000000000"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->632752147],

Cell[BoxData["0.50078638259762824541010285239770251370255610616`30.\
840803685149847"], "Output",
 ImageSize->{235, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->369454230]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->688497564],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseJacobiSD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiSD"]], "InlineFormula"],
 " threads element\[Hyphen]wise over lists:"
}], "ExampleText",
 CellID->43876107],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiSD", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u1", ",", "u2"}], "}"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->271543877],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"InverseJacobiSD", "[", 
    RowBox[{"u1", ",", "m"}], "]"}], ",", 
   RowBox[{"InverseJacobiSD", "[", 
    RowBox[{"u2", ",", "m"}], "]"}]}], "}"}]], "Output",
 ImageSize->{332, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8012795]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->255377976],

Cell["Simple exact results are generated automatically:", "ExampleText",
 CellID->328717422],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"InverseJacobiSD", "[", 
    RowBox[{"z", ",", "0"}], "]"}], ",", 
   RowBox[{"InverseJacobiSD", "[", 
    RowBox[{"z", ",", "1"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->617758456],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ArcSin", "[", "z", "]"}], ",", 
   RowBox[{"ArcSinh", "[", "z", "]"}]}], "}"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->818000416]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiSD", "[", 
  RowBox[{"0", ",", "m"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->658205930],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->15150148]
}, Open  ]],

Cell["Parity transformation is automatically applied:", "ExampleText",
 CellID->368884824],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiSD", "[", 
  RowBox[{
   RowBox[{"-", "u"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->508781695],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"InverseJacobiSD", "[", 
   RowBox[{"u", ",", "m"}], "]"}]}]], "Output",
 ImageSize->{156, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->19374188]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23210608],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->471035179],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseJacobiSD", "[", 
   RowBox[{"z", ",", "m"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->179888293],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["sd", 
    RowBox[{"-", "1"}]], "(", 
   RowBox[{"z", "\[VerticalSeparator]", "m"}], ")"}], 
  TraditionalForm]], "Output",
 ImageSize->{59, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->21097131]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6058],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseJacobiSD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiSD"]], "InlineFormula"],
 " can be applied to a power series:"
}], "ExampleText",
 CellID->120235099],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiSD", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "+", 
    RowBox[{
     RowBox[{"O", "[", "x", "]"}], "^", "10"}]}], ",", "m"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->77454719],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "-", 
   FractionBox[
    RowBox[{"m", " ", 
     SuperscriptBox["x", "3"]}], "3"], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["m", "30"]}], "+", 
      FractionBox[
       SuperscriptBox["m", "2"], "5"]}], ")"}], " ", 
    SuperscriptBox["x", "5"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"19", " ", "m"}], "630"]}], "+", 
      FractionBox[
       SuperscriptBox["m", "2"], "21"], "-", 
      FractionBox[
       SuperscriptBox["m", "3"], "7"]}], ")"}], " ", 
    SuperscriptBox["x", "7"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "9"],
    SeriesData[$CellContext`x, 0, {}, 1, 9, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
   1, 0, Rational[-1, 3] $CellContext`m, 0, Rational[-1, 30] $CellContext`m + 
    Rational[1, 5] $CellContext`m^2, 0, Rational[-19, 630] $CellContext`m + 
    Rational[1, 21] $CellContext`m^2 + Rational[-1, 7] $CellContext`m^3}, 1, 
   9, 1],
  Editable->False]], "Output",
 ImageSize->{332, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->180356385]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12314],

Cell["\<\
Plot contours of constant real and imaginary parts in the complex plane:\
\>", "ExampleText",
 CellID->147991225],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ContourPlot", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"InverseJacobiSD", "[", 
       RowBox[{
        RowBox[{"x", "+", 
         RowBox[{"I", " ", "y"}]}], ",", 
        RowBox[{"1", "+", "I"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
     RowBox[{"Contours", "\[Rule]", "24"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{"Re", ",", "Im"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41283476],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJycnXd0VUXX/3NTUREEBUVQql2Kokh1DlgQUbCCiCJIkeaDglioigVFRCmK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     "], {{
       {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
        GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl1lsllUQhk//WqD0//+2lGqBrpACbY1rYsKFRgNESksqQgtYxLAouEcS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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwllF1o1nUUx7+5PW72uNncs/Y49+zZZs/cnsEiL4IuiqKJ+cYjY+3FlaJt
rlYodBGE1E1i9EYYFJo62hRGK99uvOiiReXLFpnFxIvQVBBiuGmzCw2CPt/O
xYFz/uf8z8v3e36nYfuujp0LJL2AFCMftEpbclIWY+1D0t60tCwvdZdIbQul
A1XSWJN0a7E0hySJrayUrjwgzSSlS8Tvb+QbehWyn9iDTeHLF0lT+Jsy0mOl
0kC5tIncBSSVkDrJ/xn5lyyTvkGfJf8k8YP4XyK2H7mxUrqJ/JmMmp+S+0P+
+Rv7D+LHm6lRQW3yfVQmLchFjH3+Z1suZvRs65AC+h7kcfQnlki7G6SL1dKb
/P/2g1IXegc595BrL1KF3UVP/+J/FbuPWX9cLh0Cn2vED4JFPzWWUm8N9gli
P28MLNYz0yPk/4n+2vA9ihzHfwrZgG8N882h9+J/WsHBsXppH/PdLApM2rPS
F9TohLR5epjMRs/u9ZNFzIb9PrKU//uwj9RIFyqCO3OYINe2Wul2Sdg/ZKNn
97qP+AP0ugp+kuRP0XMO/Tz+O4ngbDAXGBo7z3iO2a/C1xvFgcEZam2k5rPo
h4nvygQGnt0zDoDfDiRLvjliJuD2RZo9CZcXmf/X6oixzxyYS2NmrMypd8E7
5N3xTjyM/U465pvln2+rI6dzjYJZO/ozyAz9zdLP98QOwffHcD1NvufI/XI+
dsuYvUK/b4HJk2DRRfz9luDI3GSQe9i96dBrkUmw2Yh9l1x/JWL3p9OBnd+A
a01gk/L/mo6dqgzu/E+B+a6D3+KS2KlfKoIzc2OMLtDPVDa4Xc08J8l3Nhtc
3YODfrgcq4lYczpCf8MtMXsZ/EyjX0b+YVcXwelWavfkwleKPUo/T+WDq3Yw
HME/3hRvuxf/l+z+V83xlvxGe9Cfb45cfhMp8K7AHiqLnfyO3nakoldjfhg8
hhtjF/mkqTrpZ+S3ROy09S2N8Xb8rYPeCrno7S743Wa++drozTvi3F+3xuyu
0Q0+PZm4Hd7Z1yHxWF1wfZr41dmYybOY0/Xp4Mxcead9y3xzfGt8095tjR5c
2zehPhc3wrfBN8az+gb47Xvm98jXXx275x28AZeb+VZXHpyam6M10Ys58lsp
pOIW+s1chZvfW2IXzdGKhuDcs/lGbKqJG+Tb4zfVyX68lond9I1wLe+kd9E1
/wNBFNSS
           "],
           VertexColors->None]}]}, 
       {RGBColor[
        0.31934402427624725`, 0.10248623196446309`, 0.5658569747113968], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmH1s1dUZx4/X9rb0vnPvbW9hbdM3aAmJShZkOrbsJRlDUcAXKPEfjViM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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl2lslFUUhi8tXWinLWVKZ6bMUApMpUUDKFHEBUVwYSllaWlpAYtd2CoJ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           "],
           VertexColors->None], PolygonBox[{{6155, 7263, 7262, 10667, 3552}},
           VertexColors->None]}]}, 
       {RGBColor[0.3530932922183052, 0.1611670944195839, 0.6132956535544763], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmFlslVUUhc+1vW1vL723LaVF2toBWqYq4JBgnFsKShQVBZWaSDRiEEGD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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3uQ11UZxg8ssLA33Ptvd3+wN3fZi43QQFJWJqakLOxyWZBlgQ3iFonN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           "],
           VertexColors->None], 
          PolygonBox[{{8494, 5753, 5752, 6519, 1749}, {9531, 6890, 1053, 9529,
            9530}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.38684256016036317`, 0.21984795687470482`, 0.6607343323975559], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHuQ1lUZx8/Kvrsv7Ls3YO+77I1dYZcyFUUBZwTFy6Byv4ilKEqQiFCi
1OQ4mTpCqExq7mheEFCwBiVNLQgQVMQLOFNQptnqogziBVInxKy+H76P4x/n
Pec9v3Oe81y/z3NO82VXT5x/TErpZP30Un9ReUoHq1O6vyClC7MpTeyT0i/z
Unpb/88pSel89a9qzdnNKTVo/l+lKR1Sy2n/bZmUxmnNhyJUmvN8qeantqf0
c+1Zq727NfdT0azT3merUnpG7Qfat7AhpQVqM3TmzTq/uiOlkaJV3FvnaP0p
ovNOk3is1Fx+Sh+3pnRSX/EpOgf0/Qa1zzU+Umae7tC+O9Wu1/xBzc9uS2lu
P/N5VmFKo0R7tPjJFqV0psZjNF4vPp9Q+1S8vz44pZ1qh4tT+pv2HtC4R3x2
ir+vNLdb49s6U5qlb+Va/6z6hgZ/HyDev9XhM9rFz7FqT4qHP+Y8/oP6l9WG
ibenpKu94vc9tfPz3fO/W+vHl1if72o8Q3ydLPn3SKauMn/bmXE/Icb7RKtH
e4eoP6uPaUGnJ2i+H2f1xPzxonVq8PBuifcwf0+Z9Ykd10hn5zRKf9LbCb29
B1vs0nklva1z+uIYY5viWLMj5/XQv7olpZb6lN6S7o9rMF1oPqjx99UmS28r
srYZ9pogWSeq7df/58XbNrUejadr7kK1jzTel3EP/ScGyJ4V0qvGzRnve1Lj
gfKTVrVrZOcuzb2vtk7zY0XjvCb/n5OxnbDRFeJ5vOa6j7G/vNBonzmAP/Ux
7XXid77k+Uyybim1D+1T7PxDPtI92P5RoLlCtUVa/wvFyiXy8xqNzyjxt5zO
OrPQY9ZAZ7Pacp0zUr5zcayfJp3U69ze+f6+KXz7Usk7U22Pvv9bLdPHdsff
C8Lnby5zbGCX2eI5X3G1QjRPlUzDGm3PF+tS+p5keTvPfokelmo8osTxVybZ
h8j3rupv37t3kORRWyoZ+6qVFTvGiXfGYMIoxfpotcU6q7bc/8EQMKVUa/Zq
fV2s4ftPMl7DemKiU2tGSt7vqu0T3b2Sa614uK/CPl6vtX8q9fqHNb+8wmtW
aPyQ2t6c45k12OWA6GzUeJnWrNT3Ve2mW14jnwiarN0Y61fr+10Vjpfnj5UP
HGueBgp7emtcrvEUrdkgnSzRmmkaT1fbJJqPZNwzj28S5/gncUA8INdvtG8y
+3P2v+05+ySy74j16LI89HmXzl3bz/iADVZrzT3qH83YBuj/dvF7j2i+08s4
gy2HJuMN/7/Gnw0xnlwrmuJjjHywQrSLwTj54lPhB/jAAuFravL6Q6JzsMz+
97jW7VG/Tv3p6keVGs8X5/t/r16OtRdKzOdfSz0Gq4nhbTE/Ovay78as90KH
78T8WNEpEi8jNP9wxmvZc3XGfC4osYynldhfV2r98Bjjt+Sv4THeLTlP1Pgj
nfWBxqdqXJkxjYVBBwzi//y8b2jht8Tk5oi74aXmJ5vv8YlqxyVjwJbSb9Zu
CV9Cb5tjDH1ov5esu90h7xehV+yIntAXeuI7egYHOGd4nIvutmrd/uR+W+gK
/AbHv9A5U7Legz/MynkebGduaMyj0+HB/8Qi04LOb+VHK+UTZ+usW5TjJnT6
3P8oXi5s97kvBB7Dy57omT9b/nJuk78R1+gRHR5T6fxNfjhQ6DipCv1jS/TS
08sxDxbdVOY8wnpyMDmGnINsYDP4dod8/oH22Fdo7CeOsP/w8AfiG+zYF7TB
CegPDdshF36Cj4wX/1eKTquw491extWeWH8U53K2EbYCUxi/qLlFRc4Lh4RL
t3YYZz4Xfi8S5i7TfLfkntDsOob4RybyIzH9SLvjGt8+PWKBvI0tme+KfHV/
5HHkwI5gIBgKZt2o/rH+9mFy4KIa64LaZG7UJ+ARcYme54ivB1vsI91au0M5
oEhy9806J5GPvlJ++J/a9t621ZLYuzfqFLCRnIjc5Nm1wpPZyu/Ttb9UdOZm
nFfBn/aoeT7Q+oGFXk+NRb1IjYHcxD/8VUZsgz/YmbyHrc/Lt02oGXqiliHf
nayc9nSb6zHy29Y657h5hZYJe8/T/HcabNfiQtuUvd3gZNiamoq6h3qrX9a+
S34p1/jajHXynGx6RLXEdRnj9LCwJzmMGha7E9dgzH15rtfIncTHB9p3Woex
c32R421s+OvLYV9wvStiaUGR4wNdUDNR61BvdA50rcOeEYEJxPFn4u122XJp
xniwNTCW2G1ps59TR5CD0Sk5knhAF2U5+zZ5eYv85/F22wWbcT5+tT3qJHLB
dJ01UfbO6f9k0V7SaZw+Sjdic62+rck4rgoke3+1H0qmhUXua/Ocr/LbjEXw
gJ9Sa92v+XvbbR9wmj34xdH7RKyZ2eb6uzx4L4t56rwfBX3i8tqIzZfl76+o
TSiyr9GDw/+Vj78k+1XkRT6IHAiNBUFnQdDEHtsj3rHbgpCHNbtkk1fVDmdd
45SFPsFQ8JeYfUL+8OsK12c36NwrG1xrXp5z3Ym/o2N0DT/jyx3b6B9bo2Ps
OFex/kqja2VwGJ/Bfx5S7blS7U2d/5j6k/r53naRxhtks83Fxs9ZcRb95THG
x8bl7Gc9Tb7zcN8htp6J+CIGqRGIl32qg/aqnRL1HDagVpkuDJhWb4wnDvBz
YoHcOyli42huabRu2A9NaINtzKGr/dq/OmMfo3YaGZjJ/Y58iS9QG+Nz8N+Y
dRwQ+8iEbNDKKPZL5CerMr5fwCt8fiJ/XDzAWDRVtK4r9p0HjAOH8A3uusTT
ErWOrPMP9yz8FX7BopqsMZ413G/Bb/YTf8hOTuR+szzuONTjnMdZb8gue9S+
1Nl1woZbq13LVCvGh9e7TlkiPrtafVeF3qSgCQ71HmgsYm5yzL8mH9/Z4v93
V7iWBSuH9vWdGT/BBuAUtUdepfMTuWliYBP2wlfWB0YdaDV+gV0fi6/j+3oN
/9fF+kf1/Z/1xv49USNStxArL0Z9y71/d9Qz5J53As+XKTcOqfL3MZF/lue5
vzbGL4j+063OK2dIV2d1+N4+S2cWVjjXEzt8J3ccjnsRufsS8ftch2n1RF4H
/8lLc2L9OPGwrdY+Bv5/EjngU/n4G5W269tZ15HUn12Kywca7CdDtLez2flg
VNSn6BZfw+fAQ95RyBHUQuiDegWd8I7yWrl9Eh63VJlPMOlntcYB7s3NcXde
p7khA70f/si3yD5V86vqjEXs2xGYRs2+MeqVmS3GKXSTq/U9lpyyRngyqfab
+yg991PsAVYiy8qILWxBjiR38y7B2wOxQVxwF8V+ywP/wR5yAPEAHXQ1jDeY
TscMuZd6CzwZp/O3l/tc5MgLWaq0fk5dnNXf9Qp5nbs4OmiO2oTY4xzwfn/U
JT+W3b7d7DeOO8lrTb4nYx9iALkO19mW8AY/86JmQAcPZM0PsYefoM/zZKML
OvwWdn2Hawvqig/lmx+1OmbYB96w9zl9nyd5LymwHBuqLQvxj84+j3s69S54
iy6gR1xMFr+Tmlw3tYt2W6vjCbnxIWScLxtOLTcWPi7bXkOcZ43lX7+RjNGZ
A+o9Jt9Mixoavp6vNm+F6i/r9J2St7oVLdbpW8KBm4uNxbNli9JOj8mF1IXg
JRhMXXEUW3VOSa3rPHI/9qeuhna22vSZA1vBzFOafWfgvoC/nB8+g7+ylhr7
Ksl1Yl/H31StndLk2pMan9qdmBoqPZwbmEn+rgreXtP8lFq/+dVrXNtgfwVz
uwuc115SLvqd+BsguY/Ivy4o952IWn5jf9d1eU2uicnN67R2Tn/f9T7TmYfq
XSdyBr6Cn4DLlYEtr+vMXQ3GAmy+K+zOnZF3Cu6GqyLX4TOn69xV1X4r+lW5
/Qyf4G0UedHnnwsck8Tak8rP69tMlzsN2Ar/i2tse+yOT4BrnLcwahv44+7L
HYzcxPvl2Ea/YWKbZWG7SVGvHo2ZeLNBJ+RgcjE2mtDmWpAahbfSUdX2Z76T
s7k756Sn4npj6Oi4v1BjP9RinAVjx/LOKj/bW+Dv9bHm+EGyd5XzJ3hWFzzg
i/gnuiOmqOF3xpicTh1LvfVF4PCYuOeQW85t9F0IfYGT3NWxBff1Q3EnR2er
y6w3zj0Ya0aIlxMG+YzJg1wTw8M0jWcMMk/kqzVVzklgzu6oiW4pc8yjH/pb
4p2O98Ly4G2m9JSrNo7eFOvxmZ74zx0SWbtCXjCZ/8jLvfmmWL9G+uwTdKhh
7yh2bBCfbxYa/2fIbpdK5yU5+/XWRvs2NQhxRUzxpn4k6q5GzTfVez95oCb8
BR+mbjvqx9U+m3O7A0ew1abwGfyBfFgbb4PUDLvjTYm3Cuo3bLYpdA4eUF/8
pdU1xqSIVfz8HMVmY41rFeL7922Ocd7Gu+JOx/tefdyXeVvlTZY6hHiFHvg+
sM33KGq+u0Xv74PNO7FGTU28gX8F1ZYFmvjG4qhTWEc8MoffMI++qYXROfql
ToXObVEzkguoNaZHPifHUsci1wl9XW9RX1HDcXelbrlYcnxZ49gEaw+22p7Q
hT40qHmv6GebgEXYsDLqI2ILXOoRjQfbTRf7gn/YBf6RDZ8fFe+z2GhN8My5
xOhlg01rdLzxYktyO28fYMcjtX4XQDb2LQ15ya/kcGoz9l8XONneZhuw7v9A
eLL4
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3lw1dUVxy9C8hLyEvJeFgIkvJe85EESUEEoUNBWsAoShUAgrAVc0mER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           "],
           VertexColors->None], 
          PolygonBox[{{10332, 10394, 3466, 5979, 10331}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.42059182810242113`, 0.27852881932982565`, 0.7081730112406353], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmFtwldUVx3dOLoTk5JCTQBKQhOTEBAIIiKNWQW2LJdVgEsBKKEKFeuGS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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3lw1OUZx18IIQeb4Ca7yyYkm80v2ZAEAY9Ky1XsoFDkUMByVHA0Wo4c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           "],
           VertexColors->None], PolygonBox[{{6743, 7077, 1938, 7076, 6742}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.45434109604447914`, 0.3372096817849466, 0.7556116900837148], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmFuM1VcVxvc4w8zknDmXuR8uM8McmMsZUN6aUFtjo0VmWi6pMRTagaRW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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3uQlXUZxx9Y2rPtYRfO2bOH3bPsLufs/ehAV2ZQ1rESg0XIdApIFhtA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           "],
           VertexColors->None], PolygonBox[{{9964, 9952, 1002, 9487, 9963}},
           VertexColors->None]}]}, 
       {RGBColor[0.4880903639865371, 0.3958905442400674, 0.8030503689267942], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1mHts19UZxk9vP1p6L21pC7+WXwuFlojyB7voXLJMkZtQLk4UNnXiNjIF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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3tw1NUVxy8khIQkkN2EZLPJ5sEmu0soJPRlawtO68hTgYG2UrRiBVRa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           "],
           VertexColors->None], 
          PolygonBox[{{10280, 10270, 1264, 8913, 10279}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.5218396319285951, 0.45457140669518836`, 0.8504890477698737], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl21slmcVx6++0D6lffpCW2gpDw8tpfTp42BGE/2wTabAEmMy05mJi6wI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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJw1mH1wlNUVxm8ChHxDdjebTTbLJpuEbJLBglJwBuXTgSmlhUbsILYJQpCP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           "],
           VertexColors->None], 
          PolygonBox[{{8328, 8312, 8311, 5346, 2517}, {7792, 6678, 1832, 7799,
            7791}},
           VertexColors->None]}]}, 
       {RGBColor[0.5555888998706531, 0.5132522691503092, 0.8979277266129531], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl2tsVVUQhXcf3N5bWkvlUin3Xm5pbcsjEktFDFgUS4wW/ENAIRWtgo+Y
KJpIEDSo/PWBwR++QIgKBo2JghojmIiSUBUjKlHwFTVoRE3UmAioRdfXNYQf
O2effWbPnlmzZvacCdevWHBbZUrpnIqUqvQc1Mu5dSnN0fNPjYtHpDRL3545
K6WLJqW0VO/ralLq07Oo789p/eCElK7R+yrNcxO9Z0c2pZcl16X5tQ36rtGt
+XuZlJbpOUPj/Hg+pHM31lo38i1jUxpVSulNzbunpPRie0rTZFNLo/SOSun6
6pT66zzflLyHvSsrvLYzZK6u8/yU7CshX5DOPaNTWiKZcZrvbkppseYLc5bB
72vDvrWSP9yc0v2yp0b+bNO4Q+MByR/oTGm7bOuq875yo/deIpzmaLxW73Ox
m++9Wvuy0dggyzp2fqz3Oo3ZGZ/bnfHZs7PGi/fXJxpfsD2o85br+YEC9sQZ
0suZGv3V9mO95s3aU52xnT3SMxi6iduGKsduv+yfVdZZOZ/BWcQDnW8oXk/L
91tl4yONjtHxjpR+aEmpVbG6QP7M0MjJx5v1/cFGY0Ws8YP5graU5mrMyphP
2NhXcdpPZDbr7KQ9vyevgwPfPijKvqLf72yVHUXHd1nIXyS/KvSsjHlW8Tku
fEpZf6+I9S9qPeecY/qekVwxa87Az2eqjelr1eY5MSlHvNZozwNZn7t0pM/m
faO4k5eeWfC/xvqOVJhvTQ2O6X5xuDTF75yfwoar5MvMsm27JvIEW07UmF/E
/S/ZmR8n3DWvkOznBc+fl/4tOeshtuQHNhDDLe2O4/Sc12dqvSwbFrX6HY6S
17OrHDM4Q3zXR1zukf33Zj0nVr/ozJPKi9UVXusNmUrZlp1ovIg/PBiSzpd0
7pUay0I/3+BYleR/Llh+auxBvrbee5EdDI4T9xM6c23JcYHf8Jxz4SV1A3vm
NVgfnHxPsu+X7NeS4P6wfGAEPlN1Rle98UH2o07L31Z0/SIO9+jcDzstN7nO
e8CyPM4xAP8hcb9Nsf864zq5T3jt0/NCYdyjsVtcW1Vy/JAHCzCBV9SMP/X+
m8ag9u3Nef/f0v1P2e+Pind/lB2X+8S3x+pdMwvjVac0Dkh+Uc62U8e+1pnn
iWP9kp2mGnxh3hzdoLg/XnTe9db6PPJuruLwb8k1AOyJwVDYsy9k8B2/4c8F
OeMIhqydH3PqJHUOv8gT3rGH56KYw7npIQ8GCwOH+Q2OH3F8UjZfPMm1n7qF
rcN2ttkH7AePuiZjkhMGNykefTXmNfcE58BNahYyxKZUb67NVDyPjvF9NVrz
c5q8Do4fR70FY97BuQWZTu+HO/hO/YT/66N2vSoO7NTI1Tqe1EJiyrnoBk/y
c0tgOLX+dF4eki+HNbZqvlqx+rRsOTB7OOJa2ewcgP/UDOJJbdwl2d1ly1GL
tsY6sd8c86cmGFPwJKe4P8irFbW+D/Blg3SsFHbLc853cMO/nYrDqxo/yt5J
dX5SOxmbw5d/Vf9Pdpg32VrrRSc1EX3UyYPi2JEm18WqycJRo/MM51hX3NEt
ktk3xvgNqW5l8uZTa2BKLeWeORp3DbIHx/sbuGcD823Ks18Lrgv0IM9GLpNr
2bDtcvnUp7Gr3nX37ibX3s/G2w50cu/xHT3rznKekCP4h+1g15M3dvhJ/aOu
UYM2KZ9+LxtLepA1gcN/Omdd3jXge33/ruwaeankV4rD82TjZZPsA+f+o/W/
S85FcvquvGN7qt5R6/Yobu+02h7ydTA42a99H452LaLGd0X/BrfI55mxjjy5
uVd4DhSMIfl4RYPtJAfo0+AeOVWMWjpbtveUXQ8K2vf5eGNMbq0pOr/IoYHo
8dA3P3L8E8ncUHBegBe+UAduES9Otvuu7M27xzp1//GkN/he379r973aLP+O
dZgb4Ppt2TbfKN2PNjv/xkrmSLNlyFdqSl/gNz/OpT8ZiB7lsPYeKrinmx8Y
INOdOd2f0j/uiB6S+6U/7hhwQhd2wjXwAE90H4jasixyldzEB3QQo8WyfX/E
a4RiV6VRyDqu7SNde9aeqZp5tuIauY4e8myy/Pum0fn9tLDZ1O58pXYQ403R
w/fH/DrJbm+1XvhED0E+05vC1aXRD3LXEmtiviHmbzW5V14S/fbwnacx1OG4
EtOfWswnfKf+wQV0zIi7Gt4OBFZwoybvnCffyQH84+yvZOe5bb73esvOK3KK
Ws89gE1faH1HY9S6dvdS5DL+U6fg+Qvt/meYFvbOiRx5e7R7fThRGT0Ze24X
f1cU3X/Ra/ZE//lVrXlBDaHe0adwv5AXzId9HGWfh+c570H+m1bfzeBNL3Nv
9DNwCR7AefoacAVnuEAOg+3RgntucOOu+DLuC3pV8EPPu62OKzFlHcy6o8eb
Frl/s2J0U4f/FcAZjMGQugamzMkbehpyh36fuwDMuWMH2k5jPy/k/we+aM0u

           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHlQlecVxt8AAhchBrhcdi6yg40tplWbKC6kjTW1TYwQE9PUundTLDhR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           "],
           VertexColors->None], 
          PolygonBox[{{7320, 7496, 7495, 6289, 1595}, {8766, 5862, 5861, 8764,
            2748}, {5862, 7432, 2077, 7431, 5861}, {5235, 7428, 2075, 7427, 
           5234}},
           VertexColors->None]}]}, 
       {RGBColor[0.5825819854975866, 0.55770933286578, 0.9099264370278889], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1ln1o1WUUx8/mdu9259xdzrvNvdxtd9O9KNkM1Eotxd7+KOiPkAjUoPor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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHmQVdURhw9CZoYHiLMyy4NZ3gwzA6hkMBExiAgazYIRIljRlGCiaCou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           "],
           VertexColors->None], 
          PolygonBox[{{7000, 7004, 1833, 5235, 6999}, {8433, 4900, 4899, 8445,
            2603}},
           VertexColors->None]}]}, 
       {RGBColor[0.6073955067418573, 0.5975777570695987, 0.9104921088855683], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFll1o1WUcx5+2NnfOXO1so7240/Y/5dyc0UxT29nagm68SfAq6mLqLMqF
remFlr1YYEbEICiwtBfMhrCNXtwLRQUJwQbd1TIQukg2ynyrucwK+n72fUYX
D//nPM/v9fv7/n7PSXY8uXV3QQjhO61CrZPpEL4qCeH4DSF050Iobgghkwrh
Ga3XdL5eQn8vC+H94hDyRSEs6LtH33kZWaX9T7q7Jt0Kye+6OYSHJf94Rrpa
z8v+gXKfvy6dkZtCGNXKS+bt5bqTzrB8tOtuv75nbwzhsmwOR5nCUssX6Lsr
5fN52TyTDeHF1dY916iYbwkhSft+JOpih7iJ+dWUfy/6LQthu+JZTx5JCLlq
+/13RQjrbgthWjondb6v2tjM6+wPrXHF0F4XwhOS+0sxdFaGMKP9n8p9U5H1
sDPRHMK3kvtM5/dKpn6F8ZnMWB/d84q/p9VxoEf+6HbL5305Y1qp1a2zDYo5
Lzu31tnXL7WqTZVx7khbDpm7FfMGrS6d3Slf12Pu65V7RbT1lnxulo+pUuP3
Y9YYvqHv3sQ1qJTM+VrrzKh235e7jkfK/Jt9lWR+q7XvRdms5Y+ljQW5HJW9
dxKffajvqYxrh539sebwAn58KZmLxdbtl8yJdKyXfp+Q7lDis7aMcyOmp+pD
GKh3nn3K8WP57BQ+Xyi/lnpz9Nda57OUP1/4nFG8D1Z5f1l4X9J6VJjsy7kG
4H+h1nmSY6vqfybjOPsU+0CR/dErrSvdL+jAcWoNx34o/x8z9vCNHiJ28iKX
mXiOLWzSg/TVnrgfl7+hYt+hR+7o9irWnaXmEnG9tNqxDaWNEzLgxx7Mn1Ze
AzXiuH53324ewIGt2m/Wmi714gzeYr9f2Hyg/T3KvV3r5VJjPRTtMx/o4eGI
B3ETMz7oG/aXUp4Xk7KVqA/O5jwzqDvzArzwMxl9gRPYgUlPk3uJeJhP+Ke+
1PqxtDGjbluaXTs4Bd7w85DquzvjWu0Qd3oT69ylPD5pNvfW1HlOIY9PdDk/
Wubf7C9kzTPyPiYbj2TMzwMxd/jTIx6NNXi2wF/4jgxziHnE3OpQ/27JuX8X
ZHNOdk6XePa8m7hfwIQa0tdjivFUs2PhDIw5p0fyaff7gup5R505NRrnHnNy
LutZxlzhnBlKbHvk61zWMTLLqDGYE9eBxLF9pPv+GtcILrxQZp5NRb5RC/x3
xBh4H5g39NYmYbtR65DkZktcUzhBbxyUzJVC3xXEOl6R7O9aY6WuX2/k86D8
H8w5bmZGvskc7o1y8GWj8vs6Y/k3s55f1P909IsMMYzFHCd0/2nG8e6Mvshl
rfDbUGGZIy2yV21ODqr3u3KO+bD0pla5pvAQ3sFtuEV/DsR+HI82O2XjucQ5
51XD+5uNI9w5HPkDBiORG9OyvTYxrvTKN2Xu/8qU68A8oW+oDb/hInOAHnlA
tgernO/VGnNiacbwhdsT4uZ4g9/AiynjQl3gFDyGV9uU+/YW+35luXuM2MCT
HgZTfLZFvz0tnrPEyQxrizOZWv3c4HrBtdnIN2K8mnWcKd2XNDg/3tVtTcaO
d7Kr0vmSJ/fgn49vA7gxi3nP4BvvfUWMn5qxX3xnY+2p6fVq15V75ij5k/t7
id8nenWdvp9nzWd6mrlGXzOLZuIM36v8/qmxDTiEf2SW/pfAZ3gBP9jPNppD
xM9/BN5v+qtWudY0GeNRYXCt0rmBx1yjcyaWh6ocD7b7on3ygh/EPxDzYY+N
44ntLJOdNSuNxbM6K4r/5ZhDvAfU5T+B73lv
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJw1mHlwleUVxt+wQ2A09+ZmIQnJTW7ITYJQyiKCyCLQwWmlBVqoQhG0Cjql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           "],
           VertexColors->None], 
          PolygonBox[{{7020, 7031, 7030, 6967, 249}, {7940, 4924, 503, 6686, 
           7939}},
           VertexColors->None]}]}, 
       {RGBColor[0.632209027986128, 0.6374461812734175, 0.9110577807432477], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlU1sVGUUhg+00JnpD71Y0mnpWGamjA3VRIWOShBiwtoYdmCkplhJXKBR
KhBAwb+wMLLQlQs31IoxVi1OS4m03YgaBU3c6IKFYvwJaoLRgMRE38f3My5O
7r3fOd/5ec97zi2PPrptz9KIeFPSJMkqERd6I8ZaIs4XIsb1/KM5YjCLmO+M
aMhov2weK0Zcl/67/ohLkql8xLG2iJzs18hms3Q7WyOO5yLu7Ir4pEf2y+U3
7/MrinXwxoj6kHyviCjKR6/krWUR1b6IAclF+fpY97Z0R1xttu5iymehYH83
L4lYp3w/kt2v8vmecnhX8lCTcyGnMb2vL0dsKDsv9MSklqv63iS/dfnZdENE
s3LozNv/YsFxryv+PRV/nxqMeF8yp7oOttqOHIarEd8Ko+d0drJDeHb4/KtS
xLPr/E2+C8lnQz6mJa+2RyxVzPsqjsv3M/JxWv4/UE1PC6MzTe7Ha9JtVa4P
CM9p3dmo81n5b0helP3bOtsu3RH5OatezUh/XJgsdLpm6v1dedZX6l6rayAe
sVaucjxigQe44L/RYx3nU/LxSM7YHlZe2SrHgBs3ZY75oXpxTrKrxT6uJT+f
qfZZPXdLVve7x/TymPztaHXvzi53bOyp89M23+HuaIvfNyj/O2rCVHcOq5+H
JEcK9gFX8UNfvmw31iPi6b6K84C/5AgmcKGe+HBOdTxV9v01Hc4bPryTmVv4
JHa9xfnvU+4HxIm/9X2b9L9Vrds2oJlJs3O39Mv6zdVf1J+fJWdyrgtswLOn
5vlhdqbbXD9cndBM/NntOuATPOZ8bZ9nCR6BO7XsTn2ZT3VRNzyl9o3yf1fN
M8HMUStzR//oI3M6Iv2DNWPNrJALscCbXKl7q2IWa7YfT3sBTK5UzQNygX8v
5ewfXsEpMByquh5qmRDGe1XXhO4P6/1UZnv4+3Xi8BPSn5DuRMF2DZ1d1oKa
yfl9eInxoAby+VH3fpLMJv1ssgHruZTDlDDeoRqOqrb9BeeGzS3i9qXM/GI+
mBOwXFH0PmLf0NeZxNtDqvXWXs8RtvPJnnln5sgfnNlx7D3m46+i77freS+7
tWDef14wN04r97mSsQPXCwlb9OeTzQvSP19yz15WXpu7HGNcOA10u6ax1C94
xV5mrtgz9BJeMVPMCTXhk/cv0vcP8v19yRhfk889mbkETgfSLNyuPq6v/r+b
eILhf9wdS/uWuaQ3cPT+tBvBdirt5G8yzzB26MENG+Iwe8QCu4fz7jv6k2mX
lld7VuEgeOwqG5NxYfB4n3fHFmHzSr/vM3MjQ+YCvRpMO4r3hfQvY7/mK8bt
csn7Hd4cTT0kB2KQP5gw8/Dl37lL/zx4OKlc3pBMqo7RsmeGc/YicYm1Vnk+
WXat7N962ml7M+OOf/b6zq60e3OeA3Kgh5PpX7WY8w6h38zpYtor1EY8cuNf
wUxzTp/5t9Dr18vGCz//APBYL8Q=
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJw1mHlwltUVxi+kaAgBDdmXL+uXhCRYcUnUEAUEQ8VRqUILtEAHRIFaLIsE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           "],
           VertexColors->None], 
          PolygonBox[{{6690, 7938, 2320, 7940, 6689}, {6862, 9290, 9289, 9298,
            1893}},
           VertexColors->None]}]}, 
       {RGBColor[0.6570225492303987, 0.6773146054772362, 0.9116234526009271], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VE1LVVEU3Zk+31PTrKfvQ6+3e/W9JJGCsnoROrBpUdGkQfbxA4qg1FIz
fX6EYQQ5D6JBWfKQMrSBo8qiSYpNGhSV0gfNhEAIba3WbXC49+yzz9prr733
8c5dOH4+z8xuYm3E+pRvNlRkdh3/FjbLhMxaC8zGseoiZr9xXuWaJbFqsU9F
ZN8CkBdJs6/lZs0bzDqqzQaiZk2F8vMDn71ps31YuRKzu8AuR9CLCJUHPB/3
S4Gfxb1l7HO4s+iY7ag1Owm/A2nd593JhNnuet2l3wg430PcGdx7gjUE22XP
bK3K7C04bI6bHfPNFuC3FBbGbFj3Jgt0l3kwT/LcjziZtHwbkorHWJuAc9iX
XzdwV0LKN4N9Flgfwb8U98qw+koUm2e0/9lqNpfUnRT0aYnBjvMcsGeQ5y/Y
dxZKY+bLs1XYIvivhe+QJxzq8d6RD/VdDot/dw30adCevGcDOzHORISTAs5P
R3Uew3cI9eqE3zw4LGCth8RjPagNfeti8u+N6KwJ9inE2ZVUfGIzV+JPQPtv
lWaj8P8AvC/APwgOn8u15/8wuYTUYy2o9XNHsdqha1tcZ1ejqj1zJD5z4D+5
Epux6NvuyZ+2axFxuxFR/RnrGTGisq8G+hLnv0bUh/VvDXrgIfiPu8Ji77PG
rG8OOHMJYbDOrCn7gV/2Mf+/w2fZke0QNDvhq79Ox5UbeZIX82fup8Crw9d+
IqE+I84AbFmsgmJp0xyVPk2o+1NX+U3B/1XQS8Nh9SP7Jgs9Bj3N8OuEeJNz
M/gsuvLZDnt+pWaNc7lWpJ5/V4GZwrz0FIora06ePeCScOVbhlyOYj9fpD2/
xEnhvLNabwb7jjNJPXOo+xFfHInHeWAPsw60kc9tYG5zpfcI/rt8cbqPPFbi
0ncA/w888eG7wv5j73XVaFZZS+bU7YsPZ5mzTvzBYnFiP7yEZkvBG1WLmHWu
6j8akd+//vSkIzXs8zR75ExtGgN92C+MzxxZ80sx1b2gUvqSQw2wHVdvZEVc
8RiLb9IPR1rccjWH7Gu+K6Vx1ZIz9Cahvmbe065yf4zvI1ezyDvpYvkQl9qT
F3ukLao+Ya58l5lvL3D6PfUv/TLB28WeHA3m5Szn0dW+EfGvxOTL2vb7ikFd
WEtqcsfV+8V3gf3KeSHutKPZ49ztqVdsxiVfzhY5M9e6auXLOo+5qvVfamXm
ZQ==
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmH1wlNUVxi8kAkkDmM0um102m2x2s0kWo1BNFAhYBQwVx4oFWuhArNJW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           "],
           VertexColors->None], 
          PolygonBox[{{7007, 5637, 1038, 6690, 7006}, {6855, 5395, 5394, 6581,
            1779}},
           VertexColors->None]}]}, 
       {RGBColor[0.6818360704746695, 0.7171830296810551, 0.9121891244586066], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVMtL1GEUvZna+OghPif9+XN+ozOWhkVmmwqK/oFMDMqQXPTY5NI0B0pN
K7KCNm1dFKNOJVRi0WMVbYIemC4KMiOQxERalBHYOZ5v8THfnO/+7uPcc2+k
rb3xbJqZ3cJZi7NSajYTmL1ZZ1Ybxd0zO46HDTGzG77ZcMhsB97mM4V3hITV
rDFripjNhXXvyjFLOvw1fDzOM3uBb2ZDwoeAv/QUj7Hqcf6lm52Ez4wis1bg
A8AGEXMjYrdmIQ7ubfDThjzj+L8z22wZ9nHYxyL6/2Cz2SRsKuE/gH0Epxq2
F/Heg3MJNlvxfwtOEQovx/vpMrMlxOpab3YF73/TlRNtl3EfyBa+N8Osjz4i
whaR/1JYeBRnLlN10XbA+XmE97eFynMIMXuyZfMr32y8Rt/0FsCPp9pbcBaA
/UgTv/PuPgY/26J6e4/773zh93C/H5bdMrALyG0R933FZocCxSO3t0Pil7n0
Bsqnvhqc4ZxD3ctxs2Z8exT2VeD7LnjpRL4DwPpxLgPfVGJWBjyVodxHw8q/
sxz5xNVbxhnLUKwp1HQH9iPAYuD4AHKaQS5VwCp99eFUmbignwL4ry3V98/B
SQn8DiLPPuRb4avnJ4A/xH0P8CR94ySAj6PnhwPFv5alntCGObEmau6zJx7J
Ifs/la08R6CZZFiaYWy+ES9EPk2B7G7i3oN7eo50zF7RPzk74nhrDFQDfVC/
x5yGV7Ub0qxwPqbzNBfDuYibqxqnPfFFrlgn41CfPz3pjPVModZPnjSSdBoj
zrn86CnGCrB+xKxDjjHEGkNtrzIVh/H4LXtSGVOsEZfXaj6wP1MsLXMmzgea
i2lf2qKuFtzcU3spp3vqmf7ZB84me0yOyA+5JB+shXE6nA19cY/QV36JuKNd
M/qbViE75kYN8jvONPvEHnXBZtLXPDEO9c1+UC/tUfFJ3adcbtQu55nzuLp7
soRz5hqi+pZ7pd/tFvJHzhiLPsgB6ywMa5cxZsqX/hKut9x35JD7MlGgup7g
fcKXHvl9nfP5jD487RbWyXwZt7tAPWaPiJFT4kuun/TBeEnXxzr0cHtMfX1X
qF3DueYsfXM79iq4Dfv6vgv8NNXojXU/9VX7F3C/q1r8cL49N+O0m3V+ErDp
DqQv5tDiNMC5/+Nmfzd8NFRrj3Lnxt2OZf1Jp9WD0Nd3X/PFnMg1Obnua9dz
VvYXiyPyw91ErfDO3obdTuD+G/WVw1dgE672KvyOO81zL35wu3FVR05L/wFP
ew0R
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHuQ1mUVxx9wuQfI7rv3ZS/vXt5ll4sXkkrEERUhccobFFagI5piWpMg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           "],
           VertexColors->None], 
          PolygonBox[{{6584, 6964, 6963, 5584, 1017}, {5391, 6438, 1733, 6838,
            5390}},
           VertexColors->None]}]}, 
       {RGBColor[0.7066495917189403, 0.7570514538848738, 0.912754796316286], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VUtsjGEUva3S6VSjo7SmOjP9R00rVKUJdsRji4QiRREbqQXahEw9EhEL
EYl6S3ceaajQkmBRz9oJRl/pwqNIsBFBCILEOc7t4sv/z/3vd75zzz3fnWDT
tuVbs83sAtYorFTUbNxEsy78iBeZvY2b5eSZFeaa1YfNDueY1QVmKwP9foPv
qUA5G5BzvMAsOdqsEbHSErN+5F+PAS9idiiEPfj2FM9a4N9D/C7WUfw+ka94
c5ZwiEEOL/D9OdbVkDjw/FmIvx9j1s4nyIeSwCrVvrZpZn9w7gB4nAenDPZd
wdoFnpdRWxNwTyfMNoLfXJzVgXM/OFZfoVkv1hLsbQFm0ySz36gxAF4z8neG
VVOkVHW1AvcY1lfoNjOivcSPlqh+5syvMLvl3IqAtwK4A2HVSi1Y70TwWog9
v5G/PoXzy5EHzHdTzGrGiyNryLg+3Xi2gONxPA/inDlVipFDNdYz8OgKie9H
6DOEevdOQI+hR2qy2SP0Nw0+nYivRXw/4km8T8e33bnCIjb1OQL87eB2EljD
0LAMnshGfj3y2kPqUxNyypGzIyxNDvi5M8C/GmsP+H8LC4P86YM1o9THc8C6
PUa/L3uP+c6eUD/291NMdZJXM/RrmCS8VBn6CP7F2FNYKu2o2x3EsqHhozzV
2Y/c74j34PkwLJ0ZG/D4E9SewWpD/mmcsTFf8bXAW4f1YKzq5JM+GQaH11gb
8qUTn/TAYFi4P9xLSwvkh2UFeqd3f1Wa/axUjLxvu86X4IGLUfn6qnu2Okvf
uz2HGEsch/5hfbxHz6BNL1ZnWH5lDaxxAXqyL1A/WBv3Uh/qzVz6j56gV9iv
p9CgboL6UgY9d8Z1B8mzx3Ujr07nxu+WVA57e8X9mcGZZ0uET090ef5L9PFV
TPtrgH8jIp03o4+NyP+cK/8Nuob0WS3eq3LkzRnuz6Xl6hlregC8+YHuIecW
eZMPe8jeE/8x4i/jwuyAxlsC+Yu1XoupXs6KjrG6Y/Qffch4AucECXHg4vnE
oYbpPOWuAk57Qr2YB+yTCfmh3X1MD7Ov/+8MYp3kiNWQq3s84iNiUjPi9IDX
mYTi1PLFZH3j/eY9p684b2b6fec8Xu0zOe13ijinEsIiDn3FOtknzoDucmlE
nVkb68r4LB65p+e8xnqfyeTP2Uo/0JN/wW1xUvdqD72Tko68B2nXiv3nDKAH
6EH2jR7m4jt15j3+EpXXKoulOzmxNs4B+nYu5tzsKmk2FedUYLXhrBo8o3Fx
5x3p8xnO90XjpBW5U296g9x5DvlTQ55BfP4Ptfo8Z7zP5zmxej2HuewBe8q5
2ep3p9+5Mt4CLnXTdfYQtB+KaLbdj8mv9Cq9/t69wTna4PrS7zneD9aW9jvO
/9WROXQzovtDb/8D4xggJg==
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHlw1dUVxy8k7AgkL8nLy/7ykrckQChK0Zallc1QQytQFsERnRGrgCxT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           "],
           VertexColors->None], 
          PolygonBox[{{7906, 6585, 6584, 7905, 2308}, {9278, 9279, 1887, 6847,
            9277}},
           VertexColors->None]}]}, 
       {RGBColor[0.731463112963211, 0.7969198780886926, 0.9133204681739654], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lk9slFUUxS+20zpTmjK2MJ3S6fQrbdOmGmFh/BMjIm40akQoMRGM0QhI
kD8lmrhVN0YDaKBQXajUihhEykJj1Egbk7IwFmmUIEIl0RDRiDGyMGLi+XGe
i5dvvvfuu/fcc8+932SPb3lo8zURMaVVo3V8bkRvfcS4Xl6oRDyvte7aiLez
iD/KEUOy+bUzYpd+X5bN4jptNET0zIkYk92Y9lZoHde9ba0RfTr/XL8faYm4
WfvL8hG18r+iNmKyKWJCa5D7OfvCz8ZSxOiA/VaaI7oXRlzQ/oww7NIaLshf
b8ThvohPtL9Deztlv1v7LwnDKj2X1Pg+e/hcr7j3Fhz3DtkvzfxObDDsBr/O
NsiutcY+BpOf2QUR92V+vz7n+N/X+h45kC8Yo904e4VrsdYzjbJT7ltLvre3
GrGv6hgPiMP7tS7kzdmmgjEM63xP1Xin6n2PWC315g78S+Rzi7i9Tbme6IqY
1lqtPNoVc1uL8axPtuSyU9jXyj4nfv/Sc0jvb9W5Nufl92/FPaL4h7V26M7F
Ov++pJTeEZZRrWfz5nJV4vNr7U1rvZG3Pp4suL4fVh0D/wvyjoH/z8TBQvGz
Vfm8rPOnBlzvM4o3UrCuzndZN9wpyM8NPRHz88a4O2c/9zS6DuA4KtvximvO
+bqCazgi37co3pQ4OdcR8aPWnLz18nGbNQNeOAXzgzXG9ab2x4sR31adO3zB
xxOUVthvlc/TutOkWo/K7qL2h4T5jN7f0/7BBuuJOqILakItJgrOA2xXZHuu
4tr2JY7oI+493GCfxPiz3j1xOj3BtkjYb+83HnjDB9roabLNyhr7wBc5zijO
TNF9ib6eThoDC3yBp0P91ZNZt2id2pN7Vbnuy+w/0+/ZimMyGzYXzBn6opfR
GLlOpl4uy35j5nhHNSeWNbt2aAKtwPm/slneZRwtaR6wj87AAJav5kd8qh5p
LDjmphQXjZ+smFvyJn/4mau6NVTN6V3y/U/J3BODnMHA+W+dtiHv9mbnfmez
sWLzujh+LLOeehdal9RqKtUIboczz0R02zXPGOD/O/koDZiX1akW1JR+upj0
xBzdWPRdZsZHZWOo1fPFiuuC3S91rvWxTusYDW/Pu+eI9ZxwLS+5P5gjzG7m
9mXlcqjs+5f0bB0wx69mris15by7zTZLuzUTtY43eK5/0WlNMlcqfc4DH7+X
7Ye5gy7hnLjkD56zFc87ZhY9jV6IRX+Cm7mBfk9mzutLxZ5sdO8Np9nKfp1w
7U/9hXZPpRn5QdFn7P+8KOKnRe45uAcDuWOHX3RCTx5JMw3tjKVeXysMj/Y7
NjlPpZpyPpHmOVyju8tpjzN6h9lwpOge4ZtzboHn4sr/tTjH+aJfbAal1f1V
v88T9mKbewiM5A2eE5nnDvZo51TZ+iFv7IhNbty7qv/Mc4T+Z0aRJznSo50l
8858faXVM3aP7Pdmrsmxir/H9Boz5uo3N+fe5B6aRLMHEyf06JWSe+imbs9W
+JqVHs8mTdInG9J8oxZgRRvo9N255oY7fA/pn1XpOw1XB+qtQfBjeyFpG13f
3ZVmf8Fzn3t8/19L/wGoOfbEm9beN5n7DP6qFXM4nmoOHmYPeZJjh85ryp5d
7+t543Wu7/YUH2zoMZd6kBn/Q5rz9PGBxDkaXNNrvtb0+ztHXUcy8w7n/wE8
I07Z
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJw1mHtw1NUVx29ISJoAAwnZLNkkm91kCVkCJohWsYVAi4KhxMGCQgmO4hSE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           "],
           VertexColors->None], 
          PolygonBox[{{6582, 7907, 7906, 4894, 487}, {7595, 6927, 234, 4514, 
           7594}},
           VertexColors->None]}]}, 
       {RGBColor[0.7562766342074817, 0.8367883022925114, 0.9138861400316447], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlltsVVUQhkdK29NTjqcNFNqec9oeSk8pWAkJqIgxyKs+GQhJLSYSjQpo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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHuQjucZxh922bWyDrv2+K21354+u+rUMlOiTtMEoZFJokIxg3SIONNi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           "],
           VertexColors->None], 
          PolygonBox[{{10205, 10206, 3332, 9938, 10204}, {5122, 6961, 6960, 
           6966, 1780}},
           VertexColors->None]}]}, 
       {RGBColor[0.7792085744382576, 0.8525261793500455, 0.906604261507366], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl21s1eUZxp9C305pT+kLPYeevtCWc4o2I1mASdmHOQWsiQoYMWpYlFIT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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHlwleUVxl9uSCARw2S7N8vNRnKzUmjYZoC2BJRFmrCVzshSlBinUJAQ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           "],
           VertexColors->None], 
          PolygonBox[{{8381, 5577, 5576, 8382, 2575}, {7169, 5123, 5122, 7170,
            1998}, {7490, 6260, 1581, 7254, 7489}, {5577, 8567, 2682, 8569, 
           5576}},
           VertexColors->None]}]}, 
       {RGBColor[0.8014928006357854, 0.8599573750026865, 0.8966209481404956], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmH9w13Udx9/7bmy08WXM0fbdvhtj4GAb5t3GDyMVO8MfRaOAjkAJGSJ1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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHl0VdUVxg8kJAwGyHsheSHJy0AgJEFlECytICAIBRIbagcgMllc1VKR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           "],
           VertexColors->None], 
          PolygonBox[{{8042, 5090, 3170, 9717, 8041}, {7815, 7814, 7813, 6594,
            1781}},
           VertexColors->None]}]}, 
       {RGBColor[0.8237770268333134, 0.8673885706553277, 0.8866376347736252], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmGts1uUZxp/C29PbAy2U8ralLRRsaTnMKVBmhkPOSFwCU2ELm1AyhmSR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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3ts1eUZx9/C6Wlpy6X0tPS09oZtT0+rRLmVLFOBgeJYYYIim+DamoyJ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           "],
           VertexColors->None], 
          PolygonBox[{{8932, 10317, 10316, 10307, 1281}},
           VertexColors->None]}]}, 
       {RGBColor[0.8460612530308413, 0.8748197663079688, 0.8766543214067549], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1mHtslXcZx39d29PL6Tm90tIW1nK2lV5wBoR26KCUFTZkZglG5eKAcpFd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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl39s1eUVxg+U3rZcWi0tt+29lNsWaWlpMPIjwBZXxo8qyzKYTp1hwACV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           "],
           VertexColors->None], PolygonBox[{{7911, 8480, 8479, 8468, 1022}},
           VertexColors->None]}]}, 
       {RGBColor[0.8683454792283692, 0.8822509619606099, 0.8666710080398846], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmFtwltUVhjd/zjHkTwgkIeTwAyWERAKjrRTkjArMoBcwPWFBzlMqUcBW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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3ts1eUdxt/a2+kRWtrScw6H055TlJaezo2JQFtxRVCQxDnUed0EbCkR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           "],
           VertexColors->None], PolygonBox[{{4586, 6772, 6771, 7701, 2249}},
           VertexColors->None]}]}, 
       {RGBColor[0.8906297054258971, 0.8896821576132511, 0.8566876946730143], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1mXlw1dUVx28gLy95LzuBl4UkLxjCoqiliiRq64q0WIodq61jqxWhLbRu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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3lwleUVxt8QbnJvNkhy4d7sNwm5WUBhKKiJQgu0oGWGsjguTDsuLFVs
EQSkog7FSgBL2bTwD5YplrJloGKlDAUEEmhHi8AIjNS6TRVwmE6LAgkCtb+n
T/44873f977vOc/Zz1f96JMTZ/YIIWRnhNCT528SIfyxPISsaAgTIiHcYH0w
HsK47BASfLuzNoTPC0NYlhvCUujWkhAmN4ZwID+EOZkhdLBuqwvhKHcv8a25
KISr3LkcC2EzMhqqoL4hDM0JYQDfllbACyqB/z4AdDWEkIRHAupkPZK7I6AV
yFoJfVYZQnsqhELuR7j/e+Rvg99WaBPrm+BdhczFyE+Cdw3fBxeDhbtj4X8e
XuegrWBtRuaC0hD6wvPtqHXc0S+EDdALEdugk72bfeCFvFzkPc35+VA7vN7A
XsPBMgr6KGaeJWAog3qwP4L3zdiiD/oNx8gD89Arid5gKsU2u5CxjfcVNfAG
3+gCbMnZB6FpnP9hFn6B93L2c9g/hoyv0e859Ps5d/uC7x3OXmV/JvvreT8B
9o3s/xY6zjqBDevx6WzkzYI29Udvvr2NPs/39tkj8Owo952JnO2bNLYI9Hfk
fwCV5BjTH+pDaMWei6GdrPN4zofnJ71COIV/Y6xbsddiKMr6tTIwYYPj0EbW
1/m+jTvjetpGDdUhPIaNt2Q6Jr7AN4PAsRZebbn2/Uow/S7fMXCB+GkBz1nF
U6Z9VwHe3RH78Br7kzi/Al7tnDmo2Gw0NtmgBd63oet5fL0317yX8t4zahkz
0OkFsC6CHmf9Lr56gzu7oGOslyHvjiLH8j+QP533aZXGcjs8k2DZibzP4FUD
z96KVei4sHDnLXwylPch0AHWT5NLncRLKXf3YI+NxNZK+K+QD1lXYK898LsI
v8PI2IlNsxI+W8Hdl8jNYWlylth6DH2eAMsR6DKyO/j2QFMI9zU5lu4lvkbh
g1G1zqWx4LmBjHn4YyD8ZoDhTnDdVevcbs9z7CagjohjONpojMKWzXo58v+N
zf+Efm9yfhL872+yrBfh9xX789BhLvRl3L6eUWlbyeey3Y8rnYuyYQa65HCu
C1llYJoAv6m8l7H/C+gZ5P4M2p/hHKwo8RntHULH1bxXo88F9jeAuaPQmF7s
3u8Ca2etfT83Ytv9Ev67Y7bh6ZRzWLmrnH8rbR66G/BBPTqf4Px4+G3Pd62S
TbK7a1aM+/Pw0ce9nBPt3P2yxr75OjgXVoNnVZlz4j/4chX3Tma55vwUbHNL
7ZvV3JnOehq0hrtVnJnA/kO13lsFfQXvy9BP5HvoVdU6eP8ZfEPRZy/8L9Q6
l1SjFdsvQ2u6Y/xQ3DVetf0H3GlP26bStwfnb4AtkzzIVzzj03XFrgHK/bWs
x/As4PlP+Fdx5gpYxpRaV2GSrgfY319snXt339HZ97OMRTzFS5hawXOXak7M
MaLarhqi2qEa38a5Q2DM4P572Gsp57cjb3K2Y+gZsB9udO85A/9m9oanHZuy
4Q72ysnRNyOW/2C9c165/gD0Ghg21blW3wrNLXaOKDdUY2LEdhTqxd1bsMdT
5PAiKIL9FrFfBI+jYLgb/5Xku1ZPQf7JPNds1f5CziTz3QPUK3fU2VfqmevB
l8OZl5B3lv2HwXqdbytzLDML2Y8nHQvHOdOJvaP477/BPaCBvX2cT8Wcs6VJ
21y6SufX1Z8bvVaNGoLswXXOlRPwm8PZQeTIQO6XgemVuHNGuTIv07GlmFAs
KMYWsf40Yd0Vw7PgNbvOtU8yurBNZ7/uWsn5kHQPUu9Zz/6ScsuULNXgb7BV
vvojuZ0Hvu39XfNU605GXCvnsz7Q0zXzhmoPNmhB9x2wn1Bin8qX41k/Qiy1
QZnY7xgyFhS5h6p3jslyLp+lH27Od06nk44B+V41dx94rlK7NBypZ73C+3fg
9yH2+TDPvVAziGaP//dEdF1Y5Fr/HpjmJJ2jys07sNlCYul5aBz7H2GTf6FL
otKyx/NtD/x3Q5UxzzjPYtu2atvqe1A52I6knZvZ4NmrXKi3rYSxvdIzgHr/
4UrPFm1gyMv1jHGA8wfTrmURzVvU9l/H3SuPRD0b/Sjt3qF5Zgm6zka3WVAr
62lgmVrtWU0xEuXuJ/WerVSzq4o9o2k2Uw3uhW0LErbF9HzX7l3sX4q6hrfx
PqTUtV85rN59CjmJHPfw77PXyLenuDsi22vNNJpl9G1Yyj1LvUo14wq8B4Hh
YoZ7xr0Jz0iajZRDEfXduGepv0FneX8/5VlOM87DrNeTY38t8Mx6hvUk/D8R
Os36C/x1rcK2Uo4f5fwm5DUjP879ZdjmJGevo89y3rtYXwZTLGadtrO/IGFf
thB/z6HfhoR7iWJAs9h+2bfaM9lInt+F8mLWaUrKMa1Y7owZm3qseqswroh7
htPsNhMMu5OeSZSP9yHvPDp0EJ/t0DnW61L2sXy7FmrBtmMSxr4QTB/g9wHk
2C3Cj3+n9jEP3Z3Sx7Wsf1/XOtW0NGefLPZZ1TDNgspJ5aJmwgHYYitytkD9
u9fiKV769i661vCslo6sm1PuCeoFmvm096liLu4z8tVDKf97yGcjU+4J6gWa
yTV7dHGms8kzSE7CPUS9QzXkcNo5oVxQT4mgz211nj3U80akPOMrF5Tz21Ou
Acp91RT5vme5a7FiQLObZjzNdprhypB5rtC+OARd0Ozd4H8r1Zxe8CtIOfc1
Iy7Bfkuh+2Ou6dJVNpOtpPMmZG3An98ucM/RrJGbcixr5tAs82jKsaGZZmyN
e4p6yTvg/RX75X2MZQ/7LTWuGaoVzTWedRXzinXNvIpF+eRYd0y24OvlJe4n
mhnPFXnm16z/OevT0CrOrIROsR5W65hXrOuf8SK2uKfJ/zqqgbeXu0aqNmom
1ywpjMKmmfImdrzez7VSM8ZkMA5Ouhd8nONY1oyu2Vwx3cr9xVXuBbKhalcj
dxpqXMMUC8IobIqJTs6+HHdv0z+oZvN13bmgGV2185ty/0uqhj7Be3aTe7/+
UTqwWw4xcCXqmVu5LozCppzfXeMaqNqnHjWas5Fy91r16G8hf3CVc1M52lTl
f2T9GyvnRieck8pF/bNJF/msuVuna5X+R9W/qWqE/hW3JN3b9M94KeGZSLOQ
/omnEbuPpP0voZlE2M+UujdLhyPo/JeUa5lqmGJNM6dmTcXc68h6ttSzomp4
ZZ17knqR/rHVu+8uda1WD49XOQYVe+ppig3FjGJFMfI/63tlhg==
           "],
           VertexColors->None], 
          PolygonBox[{{6047, 10488, 10487, 10550, 3499}},
           VertexColors->None]}]}, 
       {RGBColor[0.9129139316234252, 0.8971133532658923, 0.8467043813061439], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmFlslVUUhU8twx3a28HSUtHeezvQAYMmzqJRH3xwelAKqNFojAJSqC8Y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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3lwleUVxl8CZLtJSC6EfPcScpes301LUQTsNl20LYt2pgi2dmrrwuKA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           "],
           VertexColors->None], 
          PolygonBox[{{9663, 9681, 9680, 7075, 1109}, {5673, 7785, 2267, 8488,
            5672}},
           VertexColors->None]}]}, 
       {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
        GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmFuMlVcVx/c5ZwrMcM7MmQ7MhcIw0M7lMKlGhwLRB2gbA2gbI1D0Qalc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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwllUtslGUUhs+003HaztCWzlDaQqetTKd/J2gQtUQXKoSAF0xUxI1hQRAv
FcTEC4nGqCRuTDQtwUs0YFwYCRiNEZva1GpLuzF4S2ShQCKuTASJ8damtj5v
3sVJvv/7znnPe65/z67H7t5XExF7kTRyrj3iwZ6IoYaIhisibu6LuAU51Bjx
UirizmrEfDFiCd0NTRE1KyPWlSNSuYgf8xGbCxEJ9tdjX4/9I52+0/lVZDff
jSsiijhLkBqwb23FNyQeB2NpDcDgHcXfT/i7A9s94E2gW6mNONwSUW2LmOX7
NKqnsJ9FLqO/kfez8N8PXrXePm/vAB95F91fsDnC24fgX4uvLficwPY4d0Oc
/+Pu766IOTBq0W0AYzABf1VENhtxgvg+x/ZN+N/AeWPOug8U7Fs2Y70Rn/U6
d+J4HfoZ7FPg16C/UHQOlTv5jAr3yELOHLPgDXU6V8rPIvlogt8ZcnGBGPvh
+2cJ3nA7gk0e3wcGIl5ZFrETnfP4m0X/KNjbeX+D79eR0TrH8Cu+DvN9Tdox
pDgvb3WupVPiez3fF1POqWozyF065xp1wX8XHL7h+1skODcWXLv9yPPk+mV0
znO+ixgy+EtXnGthTMP1GD2Twdf3cB4h1u/A38TbU+jc3x3xBDoHeXsUvjeB
PwL+JPF+is5k2TVQ7mXzPuf3kGnw+tHfRK+sa3XtttGDU+CdQjJ8z1OjBs4H
yP853r7mrhf9XvTPZiLWcvcb/fVch7l/Bd4Z9BeJJ02+vkCnox8/be6lGXwe
J5bbBqy7lff7qM0O5B1i2Qr+HvjvRsZTztlYnzmJyxzfWc6TxDdc65zMwOWe
km1VQ+XiSTgNh3MyT38uIDvT5tTd6hjEXTGeBH+0z9j/Ihnwc92OVT7eBntb
wbM0hf3V5G4Fd4GvJepdLBlDtppR1XJhjXtPNd3O+73IW1nHOIDvCjKQ9sz/
QW5m4PwDXE/XujefbfGsqkf3XRlxqcW9qp2yBf4TzNilvGfkmeXuEfWGcnYj
szZE/+yoc89WyffK1a7179gkfI9jfzFvDOluSDyrshG3Zu6KeXPUrlpf9ixq
Z41if4x+eK054pM6cx+Gw1TKMVRK3lmaRe2ULxP3gGp/GcyHepxT5VI7swlf
D3fZl3yKmziLqzj+he5VZedaPf0x7x8l9n2B9050P0h81syPtHgnyL96QLVq
K3k2VLND5OdnfA7mPbPqjc097n31yEi7d7R2s3r8BWI9iJSbvUPy5H8ycSya
ifqCZ1qzLMw8sS7r9y7RDn6a+s21+F+gHV2Fy9qSd61ingFrOnHttWOV25P4
nw7nWP+OVe2eJf1DxvH1T9G7VztQvZX0ebepx17EfhhOexvNWWftBO0C3VXA
Hku8i7QDFtm1sdqzqBr+D+xU8vc=
           "],
           VertexColors->None]}]}}, {{}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{5055, 7058, 9681, 9663, 9662, 5785, 10217, 9621, 9620, 
           5691, 10091, 10552, 10551, 7366, 9624, 9623, 9622, 6174, 9473, 
           4882, 9471, 9472, 9078, 9079, 4601, 10641, 10256, 9792, 9793, 9070,
            4590, 5133, 10872, 4476, 4501, 5931, 5904, 8888, 8889, 8890, 6621,
            8551, 8552, 8092, 5197, 9760, 5196, 8550, 5897, 10253, 10254, 
           9693, 9694, 5062, 7177, 5061, 8019, 8018, 8023, 8022, 5063, 8020, 
           8021, 9769, 9770, 9768, 8180, 11137, 11139, 11138, 5265, 9791, 
           5266, 11188, 8181, 9518, 11041, 9519, 7958, 7959, 7559, 8284, 
           10868, 4469, 8285, 4465, 4498, 6408, 7019, 7018, 5189, 8489, 8490, 
           8487, 10000, 9998, 9999, 7785, 5673, 7977, 7979, 7981, 6620, 4976, 
           7975, 7012, 5643, 10653, 8780, 7957, 9909, 9911, 9913, 8386, 8388, 
           7909, 4896, 8482, 4898, 6546, 6146, 9521, 9523, 9525, 7174, 4935, 
           10685, 6185, 10683, 6187, 7448, 7446, 9640, 9638, 9636, 6183, 
           10681, 5406, 9826, 9830, 9828, 4733, 7419, 4731, 10947, 6313, 8845,
            8200, 5311, 8198, 8204, 11126, 8202, 11128, 4877, 10687, 10689, 
           10266, 5928, 10264, 5930, 6731, 6729, 5646, 9984, 9986, 9915, 5623,
            9917, 5035, 5628, 11086, 5626, 6428, 6426, 8406, 5630, 7928, 7930,
            7932, 8517, 8515, 4913, 7926, 6649, 5221, 6994, 6430, 9924, 9926, 
           9501, 9503, 4915, 5779, 10209, 5129, 9728, 5131, 9730, 4937, 9527, 
           9990, 9988, 10749, 7154, 5022, 9647, 9645, 10693, 10691, 6522, 
           6130, 10949, 4753, 7422, 7424, 6317, 8847, 6315, 10826, 4588, 6782,
            6784, 5515, 9468, 9470, 4879, 10056, 4881, 6171, 10669, 10674, 
           10672, 6169, 6327, 11177, 6325}],
          "1.54`"],
         Annotation[#, 1.54, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV0ltMz3EYx/GnWeuAhFI559BJs9ZouDRznAuHGzaEwtg0F2Yasxk5zAgX
bpit5tTMYZLWCPXPja11kxs3bFbMXDRTkcari/f/8/s+x+/z/L/5e2o2H06K
iBQ/zbkR9xdFtNBcPC6OeIqHmO6cOTViTWFEBh1dEDGCi9kRp6ZHnMT3yRHr
SiKaxF6eJ4/+mykW9VMiEnwDORHH8yI61EyM1V4Y8Qi31ByYEfGXbZweyahg
X8ueVBCRnqWWcyr9xHdtWkQ532y2megS04lZam9Sp0rcsO9fsyPKxK3Mj1iF
EeffGMKou/fOjcgTNwO/nTeaf4Q2yXmp3qDvNpqk5z86Ud+1Zl2PYrPkFEUU
0jz6xt3bMUHuMXXS1D5Kx9NktLtTCr1kN/ftpsM+au3lj/2coHvVr8busTn0
bVWrQFyj+e7gHrJn6YkS9jb+IvqSrtYzWZ0lYspRhiS+q+bK58s3+xz6xdyd
7vAWrfq0oBlZcyI2uNdNtdLNuNcOC9hq5HxUo9R3CYrG4C9S74BaB1FuF/to
Nfajwrl/fkQfdqh9iK0LCaSr94F/2NsZwju2C2a9QJfZQZdey+mg3J3uWImb
9rSLLubb7n5t9v2V/xvKxKaY+5BZU8SlIRXPzdKMSvYROVvlvLe3QbYhpMqp
NcM585zHGdThLP7ihZgWTPK/Zsh97K6n9Mp0j8mYiEnIwCpcM9MP7z/HHCd8
35YzLDdX71Q0sF2R/1qdpeJv4ByOmKlYnxXolNvD3zC2B/d75X7dmCfus7dT
yv/Ad5V99ZsxIa7bf/GMfnDewv5T3FE67NzLXs/fR9O8wzr2Tfpt85YP4rQ3
ch03/CdPnOvoXf4mOY3+/x6+q7Sd/T/MT6KN
           "]],
          "1.4000000000000001`"],
         Annotation[#, 1.4000000000000001`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV009Mz3Ecx/G3TZiD/wrlT/6TAzGUMrHJwYHMvy7+JFs2/yv/Th0iRI1w
sDG2/KtlzJH8z2ZrsWX+XThocUGobA4ev8OzV5/3/8/7+/mlb91dsKtPRCT5
kzk+Yi4GjY3YOyViD3YjbVRE04yI6tER2ckRQzMiyoZH/BsTUUqHOI8Vkzwu
4jDboxF8aRGP6RHnO+x3cdD/hzA4JeIALcdKvJsQ8R5v8REfcF3djeYoRLPa
62ZGbMB6rEmNeDY04uFUvdCMJ3iMRnkD1S8Xd0BMj5nLaZlzP/bbZm3ANXHJ
NFPtwokRv83XOzKiXe814v7awznz9+r/F1/VWJ4e0aLesGkRGYk90Fk0RY0i
tZJpgdzT8ir165CTquYKvjR6iv27utV0sVmz3L0Y27FDbpKcEtqP9rW/ejO2
mOcFnuO1GsfNkK9H9nTz0Cxar37Iu+gbLXRuFHOE7xY9TBto7qSIL+ZZRHOw
SL1c5OCoebJoNjrNN0CfeWZqRAOq+JfyLcNi5GEJ6tyhgTZiC4qwFSfF5/Kd
oDn0p/124an++er9Sewbv7Df3AvcdT6yh/leZus1Q53cbnqW9tBuez/uO1Rh
m/sUYw77bOy3p2Pyq1DjvnlqLMWyBN7KN31L9d3pvAmrcVnfevFr1btAKyZH
7EMRPqtRYZeb9aylP5xr2S+jCffEX2J7adedeI9X5pwmdj56nFNof1zR97R7
NcubZzfnE/vGHrWnu38Wnnh7bfxXxD1T+767tSJd3Cd1M/hvJPbru3R4G0/F
tXp3d+kb5wL2LnGltMe5nb2G/wsd4G1Usq/Sb4P3WoIKv+kzOG9vt50raT3/
TTlX7auNr5Y+YP8PzmClDg==
           "]],
          "1.2600000000000002`"],
         Annotation[#, 1.2600000000000002`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{5884, 10247, 10246, 8900, 9751, 9750, 10242, 4494, 6405, 
           5883, 10243, 10245, 10244, 10736, 4467, 10851, 10852, 10850, 10854,
            10853, 6343, 10848, 10849, 10846, 6344, 10847, 4466, 10425, 6015, 
           10424, 6016, 10426, 6012, 7289, 6014, 7517, 6013, 11104, 6354, 
           6395, 7466, 7467, 6358, 6548, 4932, 8849, 4933, 11129, 8848, 8432, 
           5641, 9979, 5640, 10769, 10770, 10766, 10768, 10767, 7207, 4931, 
           7955, 7954, 8001, 8000, 9634, 9633, 11081, 7999, 9873, 9874, 9875, 
           9872, 9461, 8169, 5253, 8157, 8167, 8166, 8248, 6707, 6709, 6424, 
           5257, 6645, 8255, 6644, 7668, 7667, 8283, 5402, 7816, 9205, 4663, 
           6712, 8586, 8178, 8179, 7671, 8292, 10886, 4584, 8293, 9024, 9023, 
           9022, 6017, 10427, 5674, 9581, 9582, 4978, 6726, 4977, 7982, 7983, 
           7910, 8392, 7911, 8480, 7923, 8457, 8444, 4911, 10028, 10041, 
           10015, 5689, 10054, 5621, 7302, 6030, 6992, 7688, 7701, 6771, 9068,
            9054, 9040, 6302, 7332, 7508, 7318, 9344, 9329, 9314, 6112, 10624,
            6495, 10639, 6127, 9359, 9374, 9389, 7347, 6045, 10441, 10471, 
           10456, 5327, 10534, 10549, 10486, 10518, 10502, 6816, 4749, 9405, 
           8243, 8341, 8325, 6511, 8743, 8760, 7873, 9422, 4768, 7363, 8635, 
           8652, 8224, 5343, 7722, 8359, 5474, 10981, 4802, 5836, 4785, 10964,
            5457, 5361, 5491, 10998, 4819, 5774, 4836, 11015, 5508, 6479, 
           10071, 10088, 9600, 9617, 5013, 10158, 4996, 6564, 5800, 7073, 
           9678, 7055, 5052}],
          "1.12`"],
         Annotation[#, 1.12, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{4427, 10859, 6229, 5841, 10742, 10743, 10739, 10741, 10740,
            7103, 10224, 9735, 9736, 9734, 5169, 9737, 5846, 11090, 5847, 
           5170, 8891, 8892, 8893, 4434, 9738, 5171, 8894, 8895, 8896, 4440, 
           10865, 5851, 5174, 9740, 5175, 9741, 5857, 10230, 6605, 6606, 5865,
            11093, 5864, 4487, 4451, 10866, 5866, 5184, 10237, 10238, 10236, 
           5875, 4490, 7549, 7548, 8541, 5876, 11094, 6355, 6444, 7492, 7493, 
           7144, 7143, 7465, 7142, 4600, 9077, 9076, 10567, 10566, 5186, 8777,
            6143, 7952, 7953, 7373, 6053, 8776, 6142, 8773, 8775, 8774, 8778, 
           4464, 8880, 8881, 9871, 9870, 5512, 8503, 5758, 10190, 5757, 11146,
            9462, 4873, 11019, 8158, 11018, 8159, 9781, 9780, 5248, 9778, 
           8930, 8931, 4535, 6951, 6952, 6423, 6422, 6711, 5219, 8173, 8174, 
           8171, 5255, 8172, 5401, 10251, 10252, 10250, 5893, 7151, 4875, 
           9466, 9465, 10643, 10642, 7806, 6725, 5264, 7210, 5960, 6724, 8932,
            10317, 8942, 4545, 6723, 7029, 7040, 6978, 8403, 5597, 7221, 5608,
            8468, 8479, 7922, 8456, 8443, 4910, 10027, 10040, 10014, 5688, 
           10053, 5620, 7301, 6029, 6991, 7687, 7700, 6770, 9067, 9053, 9039, 
           6301, 7331, 7507, 7317, 9343, 9328, 9313, 6111, 10623, 6494, 10638,
            6126, 9358, 9373, 9388, 7346, 6044, 10440, 10470, 10455, 5326, 
           10533, 10548, 10485, 10517, 10501, 6815, 4748, 9404, 8242, 8340, 
           8324, 6510, 8742, 8759, 7872, 9421, 4767, 7362, 8634, 8651, 8223, 
           5342, 7721, 8358, 5473, 10980, 4801, 5835, 4784, 10963, 5456, 5360,
            5490, 10997, 4818, 5773, 4835, 11014, 5507, 6478, 10070, 10087, 
           9599, 9616, 5012, 10157, 4995, 6563, 5799, 7072, 9677, 7054, 
           5051}],
          "0.9800000000000001`"],
         Annotation[#, 0.9800000000000001, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1GloD3Acx/GvmiOeYHObc2PO3EruI8SmDbnPQglzLLmaM8QWax4IkRXK
kTxwjGKS1PDAmVy574VZ1Dzg9X/w3me/7/X7fr+////fdn5uzrIaEZHqz4zk
iM/NI8alR1TTNo0jdjeL+NMw4nrHiDr8lWkRr7GrQ8RaDOFPahRxoHNEXXFX
5LROiejVJaIH/dqU8p/hH8e/in8mveo8jH11m4gcdU6IHS1nUKuILLQQ87Jl
RFe6s33EHLbfbSPe47U+FreOeEPX0w3YkxqxRM3MBhGbcNO905yn40OniE/4
iIHsg7EgcRfdr0ZyE3XEbZZX1SKiDA/1WWnmR3SSuEXiJ9IKfMNs981BBjri
ibip7LnqZKtzQ40pdLnzDPbbzuWoUvOp2LHm2KhmH3PXM39fWmCOV3yZfJv4
BrDV52uAIr69mMr3wM7XuXMt1uBnYqfs/9xzUl7wr2efx1bJ9869P5xHmn8U
VtrnKvzRX6r+ftOhco7K7yauK7ojh+8SWzYtpRNpe3pRjXR6nqbRC/Svz8sr
dbqos9o+87zdZv331nt3vlFsnfRx25t/9+bPvOcvsfPFlDpfxhfzXaIXUKRW
LqrVT5J7Q+wV7JC3HfXbRTTFI7WzfR7HoMTs2WJHZESMRwV/mRrDxeS5eyOG
4b76z/XRR48fabI9tcJPdWvTav5uPhedvVV/pCbUHkfSX+K3yStwT5ZateQk
Y4U7FtvpTGThkL5LxOXY4z6ar79czMVLufl2Nss8hbTCuZD9EE7hnPiDbLfM
8B6Pcdee0sT2RpVzCk3CYffuTnzv5PXUdzG2Yqna6ebvh2v6u8N/OPE9VrvU
jOWJmcW9UDeD/5j/55rtrTcuE1du3rP0vvOExJuJW0GrnO+xF/C/oTXtfAt7
pvsm289C5Pv92INiOzztvIWW8B+Xc8TO7vAV0svs/wEjAbSv
           "]],
          "0.8400000000000001`"],
         Annotation[#, 0.8400000000000001, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1Gtsz3cUx/HT/A17sIkaNXdjzCWxERIhQiUjrLTiCerWEZeJ1qWZSFqx
RQS1ZDzgXyGp61YiEmEjKTKXpGouGXFrl6paFsH4C1nxwOv34N3P93zP+Z7z
Pef3/bd3UfG05VkRMcafmR0i/u0SMenziBbas1PE5k8jXmdHnOsf0Yb/Rd+I
RmzqF7EGY/hTHSPSAyM+FHfamR6fRHw1KGIIfdyZ8h/hn8S/kn8WrWGPtV/a
K6JAnoNiv3ZmdI+IPHQR09AtYhDd2Cdijr1XvSOa0egeS3qy3XMtTfP9imKx
P7v32i/cG0vxC9I4Lf9gNUdhh3wHcQJP1Wiif+ECTuZEzBigTzVK6DV2W/3m
oB8mis/tHrFaX8PoAvVWqNvi7P+odKc0Kp0v1Wu2ntLWE8TPk2s2ez5dzfct
LUrqyTkT08S8ULOAZughs/3P3K86/0jOZlxP5ivHM/sP2b2sM/zvrPd+FrEP
y+TMJLlQ6I7fsa92jfgT13BZ3jq8tX6DkWZzhf23dQOKnLnt7AJ6hxarcY82
8T1P7m3/LvsBuxHz2YvYi7GpvW/tDodRjbfu+QaFapwXdxGX0Mp3T6HCt9+K
auvh6pQnb4e9jtb7tjX6yqM71R3n26+Tsxyl5pVvfyqmYJTaH9Fcsziul3bW
H2Og+7Vxtt776MqX4btnfQc1atZ6g9/Luwa/sS/K3SJXSv4spNxjqBxZyYx8
687i/5Bjg/PtxObgpv18b2MCqvSQb9653txkPOE/aybjxKySpxxjcUOt+3IN
U+Mfmq1+dzyXtzVt4R/svgPMbgS6JaqP8TQj/kfntqiTJ9cHzmSjRI0l3uAs
5GGXPqrEFZj3dlrmfssxFw3OlnljhXqpoE/YFfZ3oRrHxFfau6SHZtzCFTPo
I3YoXrI70BR2q7s5+e0796V7b8MPWCZ3X/0Pxxn3q+Pfnfwvkft3PdYmPYur
l7c//37ruXpr8hs9K65Wv0fpDfYU+8/EldCX7Ov2t/A/oK3MfL39b9Sbbj4L
Uebd/IRtZniYvZ5W8R9wZo+Z1fFV0FP23wMhIM6N
           "]],
          "0.7000000000000001`"],
         Annotation[#, 0.7000000000000001, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1GtolnUYx/Gr1azeCPMwnad2cNMcmJN84UQ8QKW2cGSGWQlOA2Pqcgo6
WDDFwjmCZkunzXw8kaaSg0JnaxElDkVdm77w3JgiOk0dilPf+HlefPe7///r
fN33nqySsveXvxARs/z5qH/EzSERM3MjeumI9IjqjIhH/SL+HBXRh/3+yIhr
2JAXsRqT2VMGRtSPiXiFX5OY4QMixuVHjKW3BlP2A+wz2Vewz6fNzlPcr8qM
KJZnL9+3xEwaEVGEDD6Xh0WMoV/nRHzq7mFWRBeu6WPJa876rKD1bPuwnO+3
+q4YrW98jp9Qjyb589UsxGb59uJX3FGjk7bjb/w2KGLe6+ZUo4yecX7ZvOnI
xTv8pw2P+JCuM1uqmP7IwiK1G4dGzDBjXzqXttD95txhfyXOa+gmfIUruIoO
89eyzeX7AfaovUXtetRhM77HJ2n2Z0fl+AI/mn07EtiBc/bRgXZ0y3sbh/R6
EDlqZGMnv1XOD9X413M72pJ39pMwT7X99KhzwnytSJh/otqTUIjzbE/0ONBO
01HqfSzDUqzMjviO1qFTjR+c18t3QUyD5y5xjWJWyLmLTzldqkYprvApsMMu
cY36ydPrKBz2/I+7qfy32FGR8yK5msyYYQfH6A19XcfvnpuRyT8LheZZyHci
LaGfYTEW6qMEve4f41W+z+zjrm/xf9zGU7WfYIj7ZufT3uEF39gZ2uLcSiv0
lCtPnjmOJP8PzJFijwXugp7yPQzi9xfberF91U5Hh/vZvqW3kTDDbPHT7GUW
utlb7GIqn3J5vsQUtKl5Ua7xatygaWoPwz15U2kve75eR3vnEzA0qfY1nT7g
v07cRnWK5HpJTBrK1Fhi5/NRhG12keBXbB+baKX+lmEBLouttOOPzVJDu51r
3G/DfvzCf6u742bowjmcsoNsvgXoce5HU9CgbnXyt0LcG/quxVqUyp1j/jfx
h/5Osjckf3vkPmLG1uTM/C7Jm8e+2/MCs3X6xlr4tZr3EG1zfs/9XX5ltMf5
rPuN7P/RF+28yv276s2xn8Wo9N18g1o7/Nm5iibY94jZbmcn2WroUffPAUAv
1O0=
           "]],
          "0.56`"],
         Annotation[#, 0.56, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1Htoz3scx/H32KEOOswZs4sZczC5dU5OJGdObse0legcslP4A4sh5aid
GgdhR2zKmUUWW8f9dDpHjs6xQ1KaYvxW5NK2kDRiciv+OOfx++O51/fzfr8/
79v3u1/e0jXzylMiotCf7/pHPM6MmD084h3NGRCxY1DE67SIf0dEfMT/Ij+i
Dds/i9iAKfwp6RG1BRE9xZ1zJ/vTiHGjI8bQJxmU/wT/bP61/AvpP85T2dcP
iSiRp1HsdHcmD44oQoaYe9kRo+i2YRGL2V7lRTxAmz6W5zrrcyOt5TuK1WL3
6HvjSH1jBX5FLc7JX6DmJOyTrxF/4qkaHfQmLuHMwIhvR5lTjXJ6zbmHedOR
j5niC3MiFtDNZkt1Jw1DsFTt37MiZpmxD51Pm+gxcx6yvyXOP9AabMV9JMze
jiyzvKWduCA+Q/4zNNP9k+p9Qhv6RdwYGtGCHDNlY525EvytSfi/tM8ELdX7
91iM82bIki8TE8St0Xe250nsK+nPzivtfhctY2vwvNue99A2Pb/RZzudy7ZA
vSN23ogGvLWnu3p7Q0/5FvLtYBimqJsQ34pq7EUNcuXfT+uwD7X4BYfR5X6Z
3rfo8Se8V/MFW4Y+ntPTatyiA51v01wxg9Hdcyq2ev7abj6o8bHexthpoTt/
8E2jvdl64ZkdPUU1+wV6EW2+nw7kiMs3T9jLWf6HbH/TiWzj8R//VfMN8G4u
sm/h76NmOhLsxb6RGajXY7E+Cr2jb9DJ32S2r8Ssk+dHTEWL2nfkmqDeI9rX
HrLwXN5U+o6/QM0R3sEXyEyqvUyjXeI3u7dTnSK5urvTF+VqLPc9LkQR6rzX
enEl9lNDK/S3CqW4526Fd7XILFW007mKvQ7H8Jv4/WyXzfAArbjqG8gTOx4v
nfvRFBxQd0fyN8C9scn9YhPK5B5q/s9xXn/N/AeSvynJHZvxSnJmcXflHc5/
xHOp2Tr8rzaJu2LeU7TFeS77M3Hl9KXzdfad/O20m51Xss9Rb579LEOFb2AX
qu3wuHMlredvcOegnTXzVdG/2P8HIAXH/g==
           "]],
          "0.42000000000000004`"],
         Annotation[#, 0.42000000000000004`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1GtMFnQUx/FjVq/cgMIQJC6pJJnCdG42J7RhUTTcTJc2yJEvdF7wwqZO
2shVC1lb+KKAaLGBK1NnKC5ZiZW6OXSK0tamIDBU5rCpLC+vrPV5Xnz5Pf9z
zv/c/s9D7tqt726ZFBGL/Vn1fMRYRkTprIjHNPOFiPr0iAfPRZx6OeJp/nsz
I4bweV7EDizmj6kRTa9EPCuu253pqRHz5kS8Sm9Po/wH+Uv5t/Kvpr86L2Gv
yYlYJs9+sSXuvJYVUYY0MQOZEbPpZzMiKtj+yY0YxZA+1mU763MXbeL7AZvF
fqnvXbP1jfX4Hk3olj9fzUX4Sr796MIdNUboFZzG8bSI9/LNqUY1vej8jHlT
MQNviC9+MWIl3WO2ye6kIBsfqt05PeJNM06hK2gPPWDO7+yvynkn3YdPMYh+
sw8jwyyP6Dh+E58m/3Ga7v4h9TpS7Ff+I3TwpYhCM+Vhkf6+sbeFeitCMbrF
/cRXIVclbultDAX2c8h7bbTDdPc20AyaIj4Za8SWJ94Dl+z1Mvqw0u6O6aEL
R9X/i+0YveJ+Py6jXZ7reh1Ejf4+sJtG9m3sA+4NYRhP+Lez57CPOOfSGueH
4jvlrVDrFPsfOI1iviJ8nXhnnGFroc2oYm/1Rk/kKFHzX7qUltDddLucveJH
fc5T94J9njTbRTrk+zKCTO88S54sesP5F/tZKLYA/7Gdt5ep4n9n/4R/ilyp
6Gcvt+ulaLP/cjWL7fwtjPP32E+RmG3yfIQl6FP7qlyF3vYmTUrsH3flnUwf
8+ermed7sQDpCfWdeZ3eF7/Hvb3qlMn1lDtJqFZjnbddjTK0mLlN3DJz76O1
+tuESgy4W2tf75ulgY47N7C34ACOiG9mO2uGUfyJ894jR2wBJpyTaaBV3frE
7929ufpuxMfYIHeu+efjpP56+VsT/z/k/tmM5xIzi7sm70z+dp8rzTbid9kj
7px5D9M+53fY/xZXTSecL7Hv5R+mk+y8jv1t9Zbbz1rU+g19gUY7/NG5jrbx
d7jzrZ318jXQE+z/A6Qxxws=
           "]],
          "0.28`"],
         Annotation[#, 0.28, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1GtIFnYUx/GjbRAEts3LtFqmeSst12grRjXWWmUYhJZGvlgb1G6SDJpg
zNqFlQxWL4Yrx4QVaTfZSkoquzEQhRY1GJnNymIMN0ppLTZfDPd5Xnz9Pf9z
zv/c/j5Pzlt1FVuSIuJ1f6pSI36bErE8P+IxnZoRsTMr4q9nIs4VRkzgf5AX
MYjPCyK24mX+8bSI5tkRT4rrcmeK85ziiGL6eyZNjzjMv5x/C381PeO8iP2D
GRGr5Tkgdqk7C6dHlCFDzMC0iEL62cyIDWwPcyKGMKiPTdnO+qynzXxteF/s
l/quL9I3NuMgmtElf5GaC/CVfAdwAn+ocZtexSV0PhuxbpY51aill52fMG8q
crFM/JLnIirpDrMlu/MUpmOj2t9PtUszTqIVtJu2m/Nb+3vD+UO6B5/iJq6Z
/RayzPI3HcZ58Rnyd9JM94+ot/9p+5W/g97MjSg1Uz4W6G+fvc3X22JcFDOR
P1BvJ9OcJ8tT4J2O+/wDfpHjKD3MdgTvyvG2eo/M3CXXMbZt7q71uYH+o89/
MYYq+6/GOqzFsNh++fr1eB1t3iPPDPlo97nK3pO98XmaKVedPWXRUv7n8RH7
dXG/ujuI4/LNEVOCIedG/n7+Mb19rN6rej3HfgEXMW4/Q2a9gxcT+8BLaBI7
wj+Kh3JulKfAjEvdT3fuZT+l71J76KKV7qd6zwqaRkvkLUau2jnIRqH3K5D3
rv5PyzGffy7+01ufPGn2fIH9E/5JiXy4xl7uXV5Dq32Wq79EfyswzN+t9mIx
dfJswyJcsa9+uUr1e4+mqJmF+/Im08f8RWrme48XkJlQvb1CR8TvcG+XOmVy
JbmTglo1NtlpNcqw14yt4lbbwx7aoL/3UIMBdxv87683SxMddm5i34t2dIj/
mu1HMwzhZ/TZb7bYuRh1nkzHaYu6OxO/C+6V6Hs3tuMduWeYfx7O6q+XvyXx
OyP3STP2JGYWd0Pemfzf+Vxjttu+v93iesx7lF5xXsX+p7haOur8E/su/ls0
7LyRfaV6a+znTTT4rn2B3XZ4yLmRtvLvd+cbO+vla6Kn2P8HTPjIfw==
           "]],
          "0.14`"],
         Annotation[#, 0.14, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1G1olnUUx/GzmgTCtpyubeqmc5urLaVYLEIdPtbCQShqtMCpLMqGFtRg
5aa5RxQ3I5YZDXLUcjoVhxrbKiMQhZKmYqmoiEhMSaXRoDehfu4X3/2u8/A/
/3POdd3L2/Deys1JEbHQn9WTI25NjVhWGDFOpz4V0ZodMZYe8UNRxGPidwsi
rqJldsQHeEn8wZSIruKIZHknnMlmP1sSUUz/yqIZEfvFl4lvEl9DB9nz+N+f
GVGpTo/cRc68mBtRgQw5l6dHzKZN+RFv8P2TF3EDV/VRM4OtzzraJfYt3pW7
S991T+sbb+EbdOGE+kXuLMNn6vXgKG674zr9HT9jIDNi1TPmdEct/ZX9uHnT
kYcl8hfkRKykW82W5EwaclDt7sPTIpaacSJdQYdprzm/sr+17A9pJ7bjCkbM
fg1ZZvmXjuJH+RnqD9BM5/vct2+S/arfT6/MiphrpgKU6e8LeyvV23yclPOE
+EN7qrOTaexUdb6nhd7Vm+pVY4JeitjJtEF+I7LtcqeZtnh+x/257BxMx5P8
K/jL3XeR/bF9XtRXsbn/oLv5UvWehg7PnYn3wt+m3w04wD6IPhxCP/6z4/N6
uIAjOIwSfQ7QUrO9gG3maMJ25Lu7jbajGa1oQR8G1RvCMazX2zAt09uYHpoT
3yF7aeLdmiHDLPnsAhSi3qxN/J/yz2S3eG7GiL0d18s5Wmpnc/C/ns/ocTLf
T2Kf2PFEuemJfP7l3sFidHsny923wAwvY1R82B7my9mszkeYh7O+/z/VmquH
mzTFLFn4W90kOi5e5M4C38rzyEyod1ZO78nf6lybeyrUCmdSUOuOGrOvQQX2
mKtbXqVddNJ6/W1EFS47W+87f90s7XSU3c6/B73ol/853y9muIFzOGOfuXLn
4D47lT6ge93bmvgf4FyJvjvQiLfVnmH+5zCkv9PiexP/U9Q+ZsZTiZnlXVJ3
lvjXnqvMdt1vdVjeKfMeoGfZr/LfkVdL77N/428Tv0Yfshv4X3Hfa/azDvV+
VzvQYYffsRtot/g+Z760s9Ni7fQ4/yPjGcI7
           "]],
          "0"],
         Annotation[#, 0, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1G1olnUUx/EzhUBwytbcs7rncjaUcFPnbJXWREmWpbRgEzKihjXQ5a3M
YdEcQe5FzCccpNSsEGWypjkrCWyWifbKlClSOjczJXGvXX7uF9/9rvM/53+e
7uta4Vstaz5IiYhaf15/MuJmbsTy0ohxmpMZ0ZET8SA94vRTESn8/5ZEDOOT
sohNWMT/KCOiuzxisrgBd7LZc+dGzKEj2XRGxNf8y/k38q+l37OrnbcURKyS
55DY592pmhVRhwwxV/IjSunHxRFvOPuvMOIGhvWxYTZbn620m+8rvCf2M323
Pq1vvI0v0Y0B+cvUrMTn8h1CH8bUuE4v4gyOZ0W8NsecajTT8+xJ5k1DAV4U
XzMz4lXabrZwZxry0aT20byIZWacQuvpIO015wH7a2Rvpl34CFdxyezXkGWW
h3QUP4jPkP84zXT/G/UOptmv/Efo1aKICjMVo1J/e+3tWb0twU9inuCfsKdW
O8llp8pzgpb4rd6UrwlF7El2Vy92ujmyPeciD8Vql2Ca81f4U+lq2qd2uXu/
ytOnp99orfqlYhfZ73n2mBmPydHAPinmFAbRx9ft/Dnnp9m1dDd7XO7eZK/y
3HZ+B/9gQo8fOi9xfpddSrewm8Rv0ct6mqCN8vTL00QHaKXf4aY+h9X7my5g
L7TTKlRjcfKdRZvdVNnbdjrfTCc8d8iRMMs2tSrcv+X+L3wjdIieS8Y5T7fP
H+kOd6foIQ2X+Fba/wvokWulHDV+n5cwyj8oxxIx75trK6pxwbt/Wa4KNf+i
U82XhbvyBh3nL/MeFntP5iMzqfa7lN4T3+7eTnXq5Prfjqa616zGBjOvRR32
2FOPuFX8XTShv3fRgCvuJrzj68zSSUfZnc73oBdHxO929rMZbuAPnLOjmWKf
wX12Kn1E96nbkfz+3SvX9y5sxztyzzL/PJzS3xD/vuT/E7n7zXg2ObO4P+Ut
5P/Cc4PZrvtOB8WdNe+39AJ7hfM74prpffbvznfyX6MT7DbnL6u32n7WI+Gb
+hS77PAwu4328B90Z7+dDfF10u+cPwazcMH2
           "]],
          RowBox[{"-", "0.14`"}]],
         Annotation[#, -0.14, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1GtolnUYx/HLSAhUyObmltoOunQHDHUauoXniYNYTCMNbfFI1ChW22qF
bRWbK0hfyDzhQEdOJxJoua0tKwQxMclelXMeiNAp5SpcvZixaZ/nxXe/+/pf
1/863fez7MSbFdXjImKFP+tSIn57PGJlbsQwTU+LaM6I+PuxiK9nC+L/Y1bE
AJqejKjB0/yjUyJa8yMeEtflzlR2fkHEHHojnaZGHOFfyf86/3r6FXux8+qs
iDJ52sUudWfhExGlSBFzaXrELPrRzIgXnP2VHXEdA/pIZLL1WUdb+Q7hNbGf
6rtujr6xBZ+hFV3y56pZhJ3yteM4bqlxlf6I73BiakRFnjnVqKLn2ePM+ygy
sVx88YyI52iD2R7kRExybxo2q/35NLs04yO0nPbRDnPut79N7Fq6Ax+iHxfN
fgVpZrlLB3FKfIr8J2iq+53qHZxsv/Ifo/1qFpopB0X622Nv8/S2BN+KGc8/
Zk91dpLBnihPN53pXW2UbzOy2Q/bXYk5y8U3iG/EeGfPyPmB53PuZYu9xv+F
Ht4y73uel/Evp//R/XZ0jx7WQ4EdXNZfsx1fFt9EB2gPetHFt1DeRSjCAnzj
/EXv5ri6I3rpSPYt303nt3AbY3pYIPd8nDRzD7qT7xR3+CvVHqJ/osbeavGO
HEfkOopOdKtdbLc31LmJDM/pWKV2gn8LWtz/GNViR9hv01EzT7aHRru8q/4w
5tndIt/av57/wcvyVKJXPxf5KryHtViGNr2t1Usx3yoM2lufvEvEvWGud7EY
F/wOflanUO+/0gnqp+F3dR/wDSPXfnJ8M08hNam+pxJ6R3yDe9vUKZXrvhkm
uFelRkJ/61GK3WZpE1fGv4PW6+9VbMAld+u9y+d9Iy10kN3ifDc6cEz8Lmen
zXAdP+F7u5sutgBD7Il0lO5Vtzn5v8C9PH1vx/t4Re4Z5p+LXv2d5d+b/N8i
95dmPZOcWdwv8mbxH/C8wWxXfUd94s6Y9yi9wF7j/La4KjrE/sH5Nv4rdIy9
1flq9Z61n5dQ7/f1Cbbb4WH2VtrGf9CdfXZ2lq+FnnT+P0jXzMA=
           "]],
          RowBox[{"-", "0.28`"}]],
         Annotation[#, -0.28, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1GtoFnQUx/EzDGcaiHNT07m5uXIXJ4WRU3EuacEgFC+kpGGTyimUtjnJ
DdTpEHPEWDZp5OY9L5DUQmekwVLImb6qDRURiWXqXE1BX6SZn+fFd7/nf27/
c87/eZa1Ys2Cj5IiotifBSMjboyNmPNCxD06elTElucj/k6JODUp4n96Oyfi
MupejFiLV/kfpUY05Uck8bfLGeWcVxAxif4xhqZFHOSfw7+afyE94VzE/uGE
iDJ12sQWy3klI6IUKWK60yMm0k0TI95i68+KuIbL+izPdNZnJW3i24eVYj/V
d2WuvrECe9GEdvVz3DkVjeq14Rv86Y6r9FecxvHREfPzzOmOCvqLc5h3ODJQ
In7G+Ih5tNZsT7IjnpM3FsvcfWxcxGtmTKZzaQfdb84v7W+p88e0ARvRg4tm
v4I0swzQXvwgPkX94zRV/iH3tY6wX/WP0B53FpgpC1P194W9vaS36fhRzDP8
j+2p0k7GOA9T53ua7a2WqLcME5wH2V0GnWnWHrZZtEAfg9lL1JiNRjk3vdFf
GML+LGaLSxdfTCeLT2YbbLZeMbX2fFvOYbYlPo/Qewr62Ebq8w79St5dmurc
T2vkvqzfC/bRhe1mfB+tbG3Yjb3Yg2zzVtF1aFZ3Fz4TuwqTzVKIh97lAars
8F93ndRLB05guZ7qEnPxb6bTvFsR1ifelU7HfTU/cc/RxA7F1YjL5c/DGfbl
vhfleBfn9P92Yj/ufyjvARrdMdfbzMM/cgfwM/80O1uPInTJ+c27FKh5nQ51
VxpuebMnfPeQo/cs+5iC1ITa00x6R3ytvK16KVXrP3cOlVdh9nL9L0Qpduq9
RVwZfwOt9v34AIvRLbda/4v0X097nevZd2I/joj/nO0nM1zDJZwz1zix+ehz
HkYf0Wb3bkn89uXl6nsHavCe2ulmL8RJ/Z3lb078L1H7W7N2JmYW97u6mfy7
fV5stqt+ox3iOs37Ne1yfoP9prgK2ud8nn0r/xX62HkD++vue9N+3kG17+U2
7LDDA84baAt/q5xddnaWr55+x/4UNo7EKQ==
           "]],
          RowBox[{"-", "0.42000000000000004`"}]],
         Annotation[#, -0.42000000000000004`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1Gtsz3cUx/EjSsYE1RZt0VZda8ukIkaG0S4pyxYqSvCgJjSSjTUqwbKF
NpLxQKq1kGht5pZuZGhd4pJQgiHZsrUp6cJcKphl9mAhaO3VB+9+fufyPd9z
zvefZn2ysnBFl4iY4c/spIjbaRHThkc8pf37R2xIjfi7X8SJkREd9OGwiBas
HxGxEuPFXyRHVOYoIn7EmRT2qDERI+idgTQlYo/4NPHl4oW0gT2B/9PMiAJ1
auVOdmbckIh8JMppGhQxlH6VHTGX70lWRCta9FmcwdZnKa0U+w7L5H6t79JR
+sZifItKHFE/25252KJeLQ7ivjtu0qs4jUMDImaNNqc7Sugl9mv+3mYejKny
Jw6O+JiuM1v70Ig3xVOx0N116RHvm7E7/Ygep7vNud3+FrA/p5vxJZpxzew3
kGyWf+g9nJSfqP4hmuT8XvfVJNqv+gdosztzzJSJXP1V29s7ensXp+R0FX9p
T6V2MoDdU52jNMtbzVNvlV0kqJnB18X+WvimOPNAf2/wP1ezme8Z7c5OtYtn
+nqONu/1CA9xUd1ieQ2+63EUg5zpascJOK9mIy5gsb7raBEy7G0uzaR91e+D
XeavRb2dN6DGd4q5dtJ5cifp8wv95ZrrPf3XOzOZVvGvFi/DZ3a2Anv10CRv
D81Tq9Xdbfr8g471TnedTbebNPzHd82Z69iinxw7usWXJ+c2neH8TBRgv3pP
1PkLHXqZr7/XtFwff+rjLu6gG7uCJtDT9Ax+Vu8qfvHmv6LOXD9gnBo/0uly
8lAr5yldxV/t/n9993LHK7vvQDt+s/eleliGav2223u2N8pU920kdaozk+gj
uevMVq73fPmv1O9h7hJvX2wXhchHldl3yCsQ30zL/JaWoghNzpaZf467Kug9
dgV/FXbjgPytfGf9HltxHRfMniZ3NB6ze9IXdJt7N3T+n3BupL43YS2WqJ3u
Dd/CMf01im/r/L+j9k/e8hyS5f2u7hDxnb6LzHbT7+y4vHPm3UevsD/gb5NX
Qh+zL/OXi9+gL9lr+PPc96H9LEKZ/W/EJjv8nr2G7hCvceYbO2sUq6CH+f8H
RcbTAQ==
           "]],
          RowBox[{"-", "0.56`"}]],
         Annotation[#, -0.56, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1HtI12cUx/Ezo5nBoKk10yy1ZbVAcEQNsrILBaPRfdWCbcTmpFHKJCzY
yiSooLDLWKCyzIUbFMsyHYXRHGyxZQymeBvJZsZwG+u/QF2X1++Pt5/nnOc5
5znnPN+fubvKNu19ISIW+bMhLWIwM6J4TsQjOnVaRNX0iH9TI9rmRjyhf70a
0YND+RF7sdD+aHpEzWsRz16OaBaTzp67IGIO/SODTo1otF8svtT+RtrCXsT/
cU7EWnnqnS0S8/rMiFWY4kzXjIhc+tnsiC18/+RGDKBHne/NYquznNbYO48P
nT2q7vJ56sb7+BI1aJY/z52FOClfPS7hgTv66M+4icuvRKyfr093lNAf2U/5
X9LzDCxz/o3siLfoAb39nxcx2X4G3nH3N1kRy/U4ka6jrbRBn1+Y3w52GT2O
T9GNX/TeizS9/EeH8J3zU+S/TFPFf+W+OrN9ZtZNtNud8/U0C4XqO2NuBWpb
jBtqSLI/Zk7lZjKNnSLPVZoj/m35PjGLCXJORDr/YzkqrZeKK8JDdSazh2m3
88PiMsyjW747cuXw9Vj3Isu6D/3IM48i77EUy5AuR724Br0tYXfq916id3nv
0vP8XfwH1FOg7/10oV7uq2EQ1/Q6YP939KMP1+Xc5twKb7MSy9Go/mJaq+c6
VDlzCAcx6q4k9b8r7wn5SnGYv59vlTxl5lyOZPYpe3swope/MUHeSWacRFNo
JW2jL4p7ovZk2iLvU+vdvqts604z+JM9hHt63+muTrpd7TswjrEE/OOJOtXX
jkyx3zv3q3UHzWLfsv7anR+ZTSk2e98tOOg73+fd1og/7b619LgeKux9gK3o
EldhJpv0VU2H2NX8p9GAJudP8bXrZwB38YN+pjs7DyPsFDpKz7qryp3N4vL9
Xo9hP3bJnemdFuC6b6HD/tnE/wq5v/UOt5Hm3G/yZtuvtd7q++kzq1bnbuvv
Ir3DXs0/7FwJHWH/xH/Yfi8dY1fyr3Tfm76bnagw3yM4ZlYX2JX0nP06MZ97
uw571fQK/3NNccad
           "]],
          RowBox[{"-", "0.7000000000000001`"}]],
         Annotation[#, -0.7000000000000001, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV01toz3EYx/FnckFNy2bmMGOM/Z1JDiWEIhHCBS4cJ6a2f7nY5Hwo5LAc
ctjmfEgR0xziRi4QynFti5JM5JBxhzBe/4v3Pnu+z/N9Tt/fP39JclZpWkTk
+TMjK+J1l4hxvSOaaYeOERs7R3zJjLheGPGHfiiIqMeGPhElGMb/s0NERb+I
lvYRNe5ksfv0jyigbzrR7IhT/OPcX84/k9ayhztf2SNikjzVYke7MzQvYgIy
xLzIjehB1/WKmO3sc37ES9Trc0F3tj6TtILvOIrEbtN3MqFvLMQxVKBG/nw1
h2C3fNW4gCY1GukD3MLFnIjpfc2pxjJ6l/3XebqZu2KM+JHdIqbR1Wb73TOi
LX8O5ql9vmvEWDO2plPpNXrCnAftby67lO7AWtThodkbkGmWr/QtbojPkP8i
be/+afWq7LbFrs/ROjUTZsrDEP3ts7eBehuBm3pI4/9lT0k7KUe2s254ITaL
rrODTDpa3CL5ztIyNVZhtnuzUtjXe/Xq3L/uje7ppbte6tmF7pbzZ4nPt4OE
uAZ5ivn72kMChdjDl6tWUt13djmK/ZaOpE201I436H2zN1xPt9BNKNbPCnwS
80rewXINwpXUO6bmlu+NWt/s85E9NdN6PYzX00K9/2QvoD9omvhdcixHpdxV
OKzvI6hEjTrVzia7W8WuxlHUOr+Kr+o0Y4mez+txMf3OXkpXsItoG/20w152
Op3hbCbS5dwp1y5U8O1OKfZgjX6eiClx/pQ+xnOUsp/RE3YzkBaxB9EBSLPL
Vqnfmb0E/UfXynPE+xSgN3qhSd1yuthOOpuhX2oW73bH97E/9Vu2s0v2cxuZ
4p6Lz+Wv9P8c79wo9zVxt+3vDL3Pnuj8nbhl9CP7nvNN/A30F7vM+Xj1pvim
52OV73krtpvjJLuMHuKvcueA/d3h20wvO/8PLxGyxQ==
           "]],
          RowBox[{"-", "0.8400000000000001`"}]],
         Annotation[#, -0.8400000000000001, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{4478, 10874, 5906, 5905, 6245, 10873, 4477, 7155, 4473, 
           4500, 8905, 8904, 5198, 9761, 4472, 10871, 5899, 5195, 9758, 5194, 
           9759, 5895, 9757, 5193, 9755, 5192, 9756, 5888, 11097, 5889, 8903, 
           8902, 5190, 9754, 4460, 4495, 6406, 5885, 10867, 4459, 6616, 5877, 
           11095, 5878, 6401, 10239, 10240, 8877, 8878, 4454, 6612, 8538, 
           5868, 8537, 5869, 8539, 5917, 8558, 8560, 8559, 4595, 7369, 4596, 
           9073, 9072, 10558, 10557, 6441, 8369, 5571, 7889, 7890, 10220, 
           10221, 9686, 9687, 10733, 6216, 9695, 9696, 7123, 5859, 10746, 
           6236, 8871, 8872, 4447, 4485, 10207, 8505, 8506, 9997, 9996, 5670, 
           8509, 5782, 8508, 5781, 10216, 4973, 6696, 6697, 7460, 7459, 5238, 
           6694, 6947, 6946, 6941, 6942, 6419, 6418, 6671, 5203, 8522, 8523, 
           7539, 7569, 7570, 8843, 10823, 10824, 9255, 9256, 4728, 7417, 4729,
            9258, 9257, 10610, 10609, 7790, 6664, 5228, 7193, 5935, 6663, 
           8913, 10279, 8914, 4516, 6653, 4505, 7585, 6928, 5546, 7182, 5557, 
           9952, 9964, 9489, 9941, 9928, 10194, 10106, 10119, 10093, 5719, 
           10132, 5534, 7091, 5706, 6915, 5693, 7078, 6744, 8982, 8968, 8954, 
           6263, 7243, 7478, 7228, 9242, 9227, 9212, 6083, 10596, 5093, 10573,
            6058, 9144, 9159, 9174, 7393, 9129, 9114, 9099, 10799, 10784, 
           5294, 10381, 10396, 10334, 10366, 10350, 6789, 4707, 7837, 7821, 
           8046, 9705, 8029, 5076, 8664, 8681, 7762, 9083, 4639, 7377, 4622, 
           7745, 7728, 11066, 5274, 9797, 8297, 5428, 10929, 4687, 5734, 4670,
            10912, 5411, 6366, 5155, 11045, 5138, 5806, 4605, 10893, 5367, 
           6450, 9836, 9853, 9428, 9445, 4859, 10164, 4842, 6526, 5651, 6893, 
           9534, 6876, 4942}],
          RowBox[{"-", "0.9800000000000001`"}]],
         Annotation[#, -0.9800000000000001, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{5867, 9747, 5179, 9746, 9749, 9748, 4452, 6607, 6608, 5858,
            8869, 8870, 4445, 4484, 7120, 6342, 10843, 10845, 10844, 6246, 
           8852, 8853, 7571, 8854, 8855, 6347, 10857, 5991, 10412, 5992, 
           10413, 5915, 7274, 5997, 7520, 6397, 6398, 5998, 6322, 11021, 4921,
            7426, 4922, 9907, 5570, 9906, 5569, 9994, 9995, 9578, 9579, 4971, 
           9580, 4972, 6162, 6161, 10735, 6218, 10734, 6217, 6693, 5237, 
           10732, 6214, 9690, 9691, 9692, 7437, 8850, 8851, 8817, 6212, 8816, 
           9689, 7458, 6210, 8813, 6211, 8810, 8812, 8811, 4526, 6667, 6669, 
           6420, 5232, 6631, 8272, 6630, 7116, 5853, 8695, 6073, 7780, 9187, 
           4654, 6666, 4653, 7778, 7779, 7633, 8261, 10881, 4560, 8262, 5750, 
           10178, 5751, 10179, 5631, 9513, 9514, 4918, 6665, 10267, 9901, 
           9902, 9486, 9487, 9963, 9488, 9940, 9927, 10193, 10105, 10118, 
           10092, 5718, 10131, 5533, 7090, 5705, 6914, 5692, 7077, 6743, 8981,
            8967, 8953, 6262, 7242, 7477, 7227, 9241, 9226, 9211, 6082, 10595,
            5092, 10572, 6057, 9143, 9158, 9173, 7392, 9128, 9113, 9098, 
           10798, 10783, 5293, 10380, 10395, 10333, 10365, 10349, 6788, 4706, 
           7836, 7820, 8045, 9704, 8028, 5075, 8663, 8680, 7761, 9082, 4638, 
           7376, 4621, 7744, 7727, 11065, 5273, 9796, 8296, 5427, 10928, 4686,
            5733, 4669, 10911, 5410, 6365, 5154, 11044, 5137, 5805, 4604, 
           10892, 5366, 6449, 9835, 9852, 9427, 9444, 4858, 10163, 4841, 6525,
            5650, 6892, 9533, 6875, 4941}],
          RowBox[{"-", "1.12`"}]],
         Annotation[#, -1.12, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV0klszVEUx/FTs6TmeWjrdTC3xhhKImJB1Vy0xmhDDamWhYVgZUO6YFFD
kA6GahMxLZCwMNRKa4oIIhG6ILESaYKS+LzF9/3+595zz/mde1+irGpNZUpE
dPezNCOiEGlpEfdyIu7iDmYNj/gwIeLUiIgevvtNiigfFDF3dMQO2lfc3Xqr
c0UjI5oGR3TYa6ZrxdvSI0rxaFTEY3STWy53xYCIP2oW0brMiF3WCvRfgiZ1
p4inokL+kYkRp+X9U+8MPTkk4uLYiMu4hCfy62kDanHCfh1tV7/G9xXfp2gj
bZZbMzRiXiLiJV8XrN8cE5E7LOKZ3rv5fqHvS7TptVheK+09LiLbuV40J6l8
lZm9J81z9oFzx/j8Ifeu+B4+yqtSZx/2o5OfrfYP+O6wn+r8bH5SxHPoTf5u
4QYe8jV9PJ/yNsnLp9PEjb4X6vndm7zzPu28d9XnM+1Cv9CnPLZgEu+TUWxt
A0rQok/C+2Siyr1X4rr+qe52jLWM5LpZiuSuxUqswWq84j0nK2IsloqXoRCV
8nN53ksn01nWNtIN+Gvm53q0oTXZj/c+eqRixkBnvEEFisz1nv+ffNfLa8BR
/darcV/ddbQExdhjhmLnS7DFvWTyk4VspPiPXcZ68wwW98AvtQ7oWyB/plnz
6fBsb4o/9h+pUeY+29UtpE3iO9af4g0+yb9Kz+I4cr1zOq7xVe1NzmEzDqMC
R/UuNdt5c1Un5/O/+uqtNtHXerz1Jl+xyt5B9dLkvkjeCV1gLQ9z3MdZ9ReZ
d6f7nO7/cEPP5XK2u6f5tFacsP7RbAm5Wc70p9fsd7q7avsd4qneYI86h/Da
zO347fxtd/2NHrY/wJnvfM/n8wNdxud//u+aBw==
           "]],
          RowBox[{"-", "1.2600000000000002`"}]],
         Annotation[#, -1.2600000000000002`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV03loz3Ecx/H3SinmGOYcm2FuIgs5ErmyMDZkYUxDE/4Y5ihZueZI+YMI
K5przZW/JPcxt0RJJIlyTu2PRY7H74/n7/X9fN/H5/V5f76/rotWzliRFBEd
/FxvH7G8b8Qtmo03vSPe4Tle4SUWt46oorN7RcxFHua0i5jRMWIa7qZEjOkT
cVz9tsyIE7Q+LeInFrSyh9g1+aUdIir1OZbo1UMvLNQ7uXPEfJprnYcd/GxF
LjKtc+ie1Ij9WRGNrBvjU8+ID0hV18y6CQ6LH0RT+0Qn9W2cxXOt5zuYx1sh
nnSJeIha7NP3bEZEc3kpOGB9So9DtJoe039iekSD/r+xyXMJvyswy7nfqi2g
dc7cra095BRiN89FdBmKE6rPbbUbvb9HL9CrtIYu5fOG5wrexpnVBFTzdhal
5tdgjmtplVmfQrF1ERrz2Enudnun0i20PZ0nVohk65Nm3YSeptk85IhPRS+e
stAd9e5mj7O3E19qTpfl58u5QtOcsyMuybuI83iq12MEz395THLud+aQ29X3
gJs8DhcbimysEx/g/Rp7lGG8vl34G2nfzrS5/LpuET9Qpt8svfKxW02NWL/u
EX1xTmysM6/WY4h5fJefTUvNcJjciWom4xDvk2i6vAI+L9vnq9xvGJyos+cg
+sX6M0bJH4n58nbqs4Duov1opbPfdy8P0GA2B9z1Ee+OYgn2Jr4FtdO9L8dp
dznTd3OG5tFV9glekvDHLP4lZoZ7cjc7Wy19pEe+5wL7FfhvbUAJyr0rVH/Q
uStQou5j4n9Dn7mrFzx+TMxcrMw50uQ+dramdLR3/THUbPbzMpaXYh4GmV8N
vzlyitzLCHrYOsP71+4lQ26mmhb0jPgv/irE660Hmucyfdbjmft4jwb15/0P
P9EN4i3VfOZ7BJ+v6BQ+/wMJrquQ
           "]],
          RowBox[{"-", "1.4000000000000001`"}]],
         Annotation[#, -1.4000000000000001`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV0ltoz3EYx/FHY7INs80OjNmYOaRRS+OGFBcOazOnrTFNM024WKEUNxjh
xgWRUtMckoVcSWwO29icpsUF7UK5cGOarJR4/S/efX7f3/d5nu/neb7fwoYD
G/ePiYi/WJsZ8WlaxPLiiGUox+TsiPElEb/mRIygdWrEmbkRVfMiKlGeH1Eh
bgPWIyk3YnNOxIUssQsihqdEFMj5QcfKG4ckTLL/znkFCyPe0ho5db5r6Qdn
/nTmAD0mbz0aZzhH7XwxfeJ/T4/IFltrnUO32ttdFNGEqoKIQV6eihsVl2s/
g9csZOL7/IgViXi5K2mqHlKQyu8+6xQ6EWlo5nMhv3tpv7rb1K/BYnF96iyh
/bSUvqSv0I1e9OCOeX5EJ7owwM97pJtJaaE6WIRe/XajB4fyIg7rvcx5S1GO
p3IrxFViaJbLsv93ZsQ/vHbOW9zV8308QJ55Tccjvjbp4yFtSszMTM6pP2Im
s8UVoyRxf2LWocz+LbUmiL9BU2m92dQhx/5x6yzaSqfRZH002GvETR7bcTDD
3K1baAd/t7Fa7CqcNrsu/TSZ5x3zf+z7Hu2hR+hzuoeHRp72oAFn/a+ndSjS
9w9n13oTX8xhM92nz2YclftHzCjW+G5T57a7u8zjTXqRput9Ijrknrfu5a0P
b1DPWx1emFMvhsRV8vlPTym+L6lxBRPUT0OW+l/d1zckJ94+Ltg/p+46ngut
K+kJnEJ1Yo3t8lL53Zl499Zb0GbWV9HinCfuptOsdpjfsDmO4LqeT/J2ja6w
163vCr6qsFV8tXddgy1oV2eX2oP0EwYwhM8ok/8Me/nppP8BcE6YEQ==
           "]],
          RowBox[{"-", "1.54`"}]],
         Annotation[#, -1.54, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{4426, 8861, 8862, 8073, 8075, 8074, 8520, 10856, 6345, 
           10855, 6346, 7462, 7461, 5064, 6219, 5065, 6221, 5066, 6220, 8004, 
           5024, 7157, 5908, 10257, 5909, 6230, 10861, 4431, 6625, 6626, 6234,
            10744, 6233, 10745, 6318, 6321, 6320, 7510, 6319, 8858, 6357, 
           8856, 6356, 8857, 7474, 7511, 7512, 6323, 10832, 10831, 5980, 
           10409, 10411, 10410, 4554, 8484, 4555, 10878, 8483, 7630, 8138, 
           8137, 8571, 6096, 11105, 6097, 5989, 5990, 10880, 4559, 6819, 4558,
            10879, 6281, 5988, 10667, 7262, 7259, 10774, 6275, 10771, 6278, 
           10777, 5381, 7265, 7268, 6823, 6820, 4725, 7414, 4722, 7853, 7850, 
           10820, 10817, 8840, 8128, 5222, 11180, 8125, 11184, 8134, 11130, 
           8131, 4967, 9572, 9575, 9569, 11147, 9566, 9563, 5665, 6382, 4441, 
           8412, 4436, 7532, 7529, 8061, 9721, 9718, 8005, 5025, 9898, 5529, 
           9895, 5526, 6415, 6412, 8365, 5521, 7879, 7882, 7885, 8798, 8795, 
           7108, 7111, 6622, 5199, 6910, 6409, 9880, 9883, 9480, 9483, 4883, 
           10210, 10213, 9477, 9474, 9877, 5516, 11082, 9504, 11087, 11140, 
           11143, 9554, 9551, 4956, 7434, 4959, 9560, 9557, 10657, 10654, 
           6514, 6078, 10943, 4701, 7407, 7410, 6309, 8837, 6306, 10814, 4549,
            6733, 6736, 5974, 10322, 10328, 10325, 10660, 4962, 10708, 10711, 
           10705, 10718, 10715, 6195, 6338, 11114, 6335}],
          RowBox[{"-", "1.6800000000000002`"}]],
         Annotation[#, -1.6800000000000002`, "Tooltip"]& ]}, {}, {}}}],
    AspectRatio->1,
    Frame->True,
    PlotRange->{{-3, 3}, {-3, 3}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyEnXmcj9X7/2cfKmVPSZaEKEKkT7hvJVtFWULWkhCl0kKypCIhpUWSJdlL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     "], {{
       {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
        GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl1tslVUWx/d3zumN0p5DS28URNoe6cHLTOLg6NQZffCuL2rUqESwKhFl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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlElIFHAUxr9xaTSdnMZ00prUGUdnbIX2Q8shWm9FK6Ehtkem0W6XgiAQ
WyCyQqGF7FbRRrSAmRAtlEkdKqig5Vy3KLLf63l48F++//d/y/deRX3j0u0Z
kmqxLKwlLI0ZLXUEpRU50rW0tDcuvRwqzQpJFQmpGmvmPpwtTU1K07COPKkH
og2F0g3ezAX7eYgUqpHGjYArUzrNWX2ltAkrAV8Avjbqfxh3FmelcJckfJ2N
NfD+O5gX/LUYzOG0/2Hck9jng41gAbDDwLzC/zujpB1BPzuA7/uxPvx/jd1m
fQ0LgO0EEy+WHoJvYn07V/oL/3WsGn+PwH8TvsxS6RP/NZGPrWPgjnisz+Fo
IFctcefeHJAS8K2KSYVg78B3rFxqw76CT5HgbrgfYZn4to8/9sWdw95ajjcT
y+zh0peA5ygMX3e1dC6fHGNlKWkn/5/Bn272T8lFgBwdx9dl8C2Ee5Hxs1+N
f63wJ1OOHeD/B8T6lpgKsj3m39TiD9YT9BzPAdtR7LU9O8S5d4M/G/A/yrnL
IB8fuWsMeq738N/EkOfctHMI/JehrqHWIukb92tDnoOprJPYcvgH8GkB6/kY
KfrvcxPro2mvbRuYbNZFacdGeN9E7D/Ix0Viecy+jvgb8fFlyDWWiRabI35n
NXzBeiP3j0Mew1XuLxd67i0HR4lnbGowVvZBsLfw/wHYU7y5F3YNm3bt7AN8
0+E4T20uYuuqpDVVnvvR7PvR6n3w4WEeY5r9YvwP8j4Hq6QXdnP/JuQxXyiQ
Ziadiyt9Jra+ao/Vaj6Duydp1/4FMD9LXBOmBavBZO7f4VNnnvdgEpIJYNq5
ewRHBdjjfHQo13PWiR4uxV37V/BvCdypqGslN+S+97Avk8ewMuY9Yr1hmv5V
6T1g2t/Pf0G0sAELwBclP73gn8V8dnSBmYeWdyU8N6bpbWCnlTrW3owv8R6z
3jKfrXfqsKIc/+9k3DVs2jVNmfYnU6/efO+B9TH3wfjszciEzxCbHdZjMbhr
B/vRMKYV89F8M82YNvrh7M5wjXSh3y0Rj816wmZHXdRngc2QmSmfOTZrzIe7
5K897rm0mXcw7Ro27VpPWK2tJlYLq3lWqfeQ9Y7NFNNGTdRzbxqZknTNmFas
pifKfYbY7LAaWi+ZZkwr1lOmxfcR14ZpsneUzyCbPTajq0a4pk3LFuM/DHPE
AA==
           "],
           VertexColors->None]}]}, 
       {RGBColor[
        0.32510159911678954`, 0.11249709969270466`, 0.5739499426609359], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmG1s1WcZxh9aegqc01PWUnr6tvW0nIPFwHBMmC8jkwlzalwETXUccMxt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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmlslFUUhm+3aSktTGege2k7nXZaFjFCyyIisroQieDCJpQdmkhZFMpS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           "],
           VertexColors->None], 
          PolygonBox[{{4108, 6627, 6626, 7505, 2061}, {6711, 5079, 5078, 6766,
            1776}, {5073, 6711, 1776, 6764, 5072}, {6768, 5031, 891, 6765, 
           6767}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.35833908262857705`, 0.17028810723864848`, 0.6206692465751674], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lkls1VUUxk9Li6XTe20ZSvte3xAKlBJSKAgIImMMxAhthWhJIIFEQVII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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl2lQ1WUUxl9BXAjiXi5yIbhy74XLBWwzTMrUMJe+NKW2a1lqictU2qZo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           "],
           VertexColors->None], 
          PolygonBox[{{4006, 8740, 8739, 4070, 64}, {7068, 7671, 2147, 7674, 
           7067}},
           VertexColors->None]}]}, 
       {RGBColor[0.3915765661403646, 0.2280791147845924, 0.667388550489399], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNlkts1WUQxQfpA3ovbQly+4TSW1raahMfjRrAEk3QhNYHRFBhYVIWKhRc
+QguSEqURI0G6UIlvqIxsYpSEpdGXbmQgjExwUdCWwMuaXsLa8/PMwYXX/7/
//fNN3PmzJm5t3P0uV2Hb4qIb7WWa20uRCzWRZS0+eqKiL+KEe/r4I9SxHu9
/q5eGTFZFdG8LOKczu7VnWbZ72qNeETrek3ERdkvrpUP2U1tjDijtbXgtaVg
/8fq/Y5NoTbiZLViyF+fntN6NsnmRF/Edvl6XuePlSN2NkVM6Hy/nt/p7L5V
ET9o/3utBeGu1Bn/Ud2f0XOfYlzSs0qYv1Ccfu2vazdWcN6xJuL8eu//2Blx
Qe+3yW5xk3CUnGdFPha1rsrPVdkPtwhr4nylxliJsVc2V8KxdjQ4HjmO15tX
cJMHeZHThTZ/c44dPDypPJaEbX2t4+H3c/G8TfdfqDXPD+jutU3+/ky2p7SK
tY5LbagL3H/Qb5/DDcbD/kK9cb2p99/k5xnl3FttfOOJf7DWuYFzrMG5w8lT
8nfPhohRxZgrOnfs0Elv2s/XuSbYU9tj9Tc0xRP/sxkLbFWKdaTGfGK/ObXx
i/Tyt2JtqXYt4fajZbbjm/cB4bhWY31yzj7+8T37v1gz+f64uH1C66zi3qrc
r8j/l3r/SXUY6IpYrVi/dkd0NEac1v7tqvVb+p7T/YfF8UOtjkdN8EldeM7l
+7R8X6R+6HC5eaI/FlOXk7JpKvodrNSMOGi+S/vdRb8PrzbX3Icb7mDPvaX0
A/f7VzpOuegY7F+mR1LbRzM2uW/tiHhZ+dTozrz65tEm9xvapmbUi7zQHNoY
lM+7iuYfXmZzn36ir+Af38SmXpzPpA17XZnLds2M18s+Byt8oGF4u5TYZlLn
3N2Ydycz1t7sX/bKuY8mDzZYy+j395L1R//PZ7+Maf+QVkHfP7e5Z+iX14Rl
qtsx0TnnaJhcyfm/ecY7/TKfnODz7uQEm53SyKcdrg8z4t8ZKJuvtfdVxw1t
rqq1Pvt65PNm53d8hXuGfiEP8oH/A8J7Yq1xDRXsE9/visN3et1zh+RnrMdY
mDsT2Xe7y56PfH9In5asrdM5W6kF9pXkf0OjdYAG0NFoaoleH0tuyZtv6vKG
NDXe6n7tzZ4nL3gCJ5wwy45nXuizkjGZZRM508upCzRzv/ydbHRNB0rGDV7m
8Z1rPJNf7PcsQIdgWUg81JI+Jhe0fL7Nuexp8YxmTjDnsMcPMxAf9Pspcfmn
4l0uuobfNLuOzLYDPeZiStie7XT9mKOV/C1rF7ZPSu4J4k8nnxOax7tb3BcP
ljxrzmZ8agwGfhvpT3qTXi9mXeBwJOczet+Xs47fgT1l80c+R7KnmeXkQy68
V+XMZ57dUvI+uQ2lfuABvPDG+bk22xxWftfXuY5nup0DcanvYP5OgWsw58CO
jIm/t1W3p9vdF9R/KP8DVORjSevjjL8t98E7kjU4KI5f6ncvrUo9gQG+yBVO
mcdwDe6RzJcc+X3DN3nRm5XUKTxSf3SFTir5m8W8gx/4/we/fTr/
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHlwlFUWxR+QsIRAOumQdNLpQHc6SXcHHB1QsFAQBLFKZ2qCpTUuqAQd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           "],
           VertexColors->None], 
          PolygonBox[{{5688, 5092, 5091, 9685, 1197}, {7195, 7197, 1782, 5045,
            7194}},
           VertexColors->None]}]}, 
       {RGBColor[0.4248140496521522, 0.2858701223305362, 0.7141078544036306], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlM1LlGEUxU+ZjTOOpTFJ6tiMI5pYBFkWbYNooQYKfewiN+E3FKEtjNq0
sAhqVVARRTuDxKD8C1z0sZGSYqpdrVq0amedH/cBFw/v83Hvueeee+/bMToz
Mr1V0oxXjdeNOmmxQfroQ7ZeupKRVrdIE93SpNeC37/lpapXuVaq9fuT7dIH
g/Rtk/p9PuTvujEWd0h/vF8rSYcL0rIxj5elwSbptzHn9kmzXpeMdbZFOtMS
WGBccOxTxn/aKP2sSH9z0lVjZWw7b5wxcxn36s+Hz818vNc4zka772zzIx9c
4Qk/3oedYy4X2HCY7JDu7Q7Od1qlAXN4bLwFx7xdiVjwfdAT9kf3SMe8Bm3z
1farOwOzmmKxX8lK58z/oGN+du4XO6WK412uCy5gvsgEP87kOpQNThu2/1eK
M/bUAP3B/p7wseOdGq01S7d64o268cb9uzaptznqV29Nhs31aU3UD82oc7Fo
X9s8ss2w9yPF4EXd1lMPYMeeXMiBdzgPNEUt0eRNKXRBE/DxwX77Xul8S9QC
Lu/bUj/lIzd06N8TNcOm0fb5QvCknplU05cNkRu4o53BFR5H/B1M9SonfdGK
fTX1CX74w3M9YZAXPQI/4j60fhMdm32xmOyJXU2av+qSlrqCEzoQg1jU+XND
5H13l7S/GL120pjPmyNXZoDeR5PZXvd9b/hMu3/nCsGn3X5txajFvPvueiX8
0AJdRxQYlRS3mrQhR/JnDomLzdtsxDrdGrUHA54LqS5odiLpNu68v5pnNhda
gEG+GZ/rchGXuc6kPV/OzAu1fJYPPswwc8sbWk4lPcHFB/sl8xlqDZyp7phh
epH8Spm4hzs5gFlKeNwThzfu0eZTKfTpK8T/BR/qyx058k9AH/LBbyVp8sW5
jnVEbvc998vlzf8WtYfnNWO+Lkf8A7b/VQ5/5nKme3NWcymv/yZ7sS0=
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHtw1NUVxy+QEPKQbLIbdHeTrLubbDYbopUSgU5bEAR1rG2JrXbGijW0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           "],
           VertexColors->None], 
          PolygonBox[{{5766, 6739, 6738, 7197, 1948}, {6466, 6787, 6786, 6796,
            1693}, {6736, 4256, 2807, 8933, 6735}, {6338, 7196, 1948, 7195, 
           6337}},
           VertexColors->None]}]}, 
       {RGBColor[0.4580515331639397, 0.34366112987648, 0.7608271583178621], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VE1IVFEY/fybcdQcHcfR+dHxGWYSFhTiX1BtXDRjqK0qCJ2oRYESUlra
okVWu2gRhRC6qK1mUa1aGNgyQS2INgXVNrSxLJHO8VwXl/fevd/POec793mZ
ob7BXDMbxcrDGg+b5daZ9QTM+hNm03GzmRyzzaDZk6jZD8RsVpq9aDTL+M0W
kPQS6wti/uVrj/EXkDtQZfa0wGzVZ3YW+3fyFesVKL4bdVLotQv7rz2zLsS3
FpmdwF431ggwfEiaHQKm9oDyF33CcDRm9gwY1vA9iudzxE8gpjlkdgaYUyDV
iu82rMvodRA1VpL6Zi2eEUNNrdk58Jr2idNUXBw6XAxzT+0x+1lmNlwofJs4
vwssB3B+EXuL6JUA3/lqszHUuVSofepwBPW7y81u4rsKeSmfNMgC/3RIuZnd
0AqrqthsEL2GsNpKxGOkUVyaalArJi2nQspnLnWlBtRmKWJ2a6/0/YbzhyHx
KgOG7/XCxG/iIIZPiJlAfMThirj9r8h7xLn7pCnnQwzUfsbpfyymGay5PPZk
Lvn78X4P3Ns8Yd3mGJXW2/2LNQPqT04zFeL1t8EsB3OKgftn7L3Fdynel8Gr
L6EeLdD4XVB49+N9Nqn3dTyvhOXHMfQ6nRAGfnNuxMY5UxdieIPa8zv1MdOl
Is36Fzw52yg9OTNyf58n3pw7ua86vfl+n3cB3rsNPq+AoSQsX1A37jF3Kylf
UkN6pMWTTlPwVE9MPindBx+HhYN92I8e+4jc42H5kffvT1B9ias3oJq58IsP
Kw4u6YDuLrnQywMJ+ZmxaRe/DszjUdXfggYbDdJ80q9Y3uPrUfmAOIgp7Wpu
wIeP45oxF2tQ5xBmW14r79+oFx/m8b4tO22pa7ZS2hHjittPgd9v8OzEXrZG
PVib96/T+YR3KF2nmVwNa96cbTNiu+qlGWMX3L9oDr0OV8izJ+nziHixZ4fj
wrtCb9FX/E9NOu7XUL+1WrPjP2zB0znPODfy3ebm9N454/5ck1k0oVpB6NHu
6d6xRr/7Hw67e0hP8h/X6+7Yg4j4kzv9e955mGcTzkv/AVGd0EU=
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmGlslGUUhV+wi4UaZjrTdjotTGHa0nYQ3KCLK4soAkZBE01UoBSX1gIG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           "],
           VertexColors->None], 
          PolygonBox[{{9667, 6465, 6464, 9662, 3086}, {8112, 5124, 5123, 6197,
            1611}, {5121, 9717, 9716, 9726, 3098}, {9717, 5122, 3099, 9734, 
           9716}, {6465, 9722, 3098, 9721, 6464}, {9658, 5084, 3086, 9666, 
           9657}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.4912890166757273, 0.40145213742242386`, 0.8075464622320936], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl12MlVcVhvc5Z3rOnDlTZpgzA/N3mD+GzvBXNBIZURCKAlYMpdJSEiwM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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmGtwlOUVx59cyG1DcZPdTbLJht2QbLJJILE1XJIqQtCoFKejgsCHkgRo
KU6DOGoVkiC0WpWLdDolWAkQHBFKZwwWhlQ7LSggMm1BWkO4tKMyJBGD09oC
CvTy+/e8H/6z533f5znPec79bKx12QNtyc65vCTnUvldHnHuUVCU4VwEfFDo
3Clw+yjnPmfN1jLejXWuLtO5L3zOdeQ6dwfPGTzf4Hlx3LnHxzl3LMW5mmzn
RosXKATZYAJr/13p3E0wHvpwwLmuYuc2gXeh8/KdOxR07iAIQaflGg/tHQXd
XuDcVb4tSHeuN825ZHgkgU4u8TBnPpLnXD6888BS6M/8zvnYkwUuQQdYuxw+
j4Jc6I3cpw56gLteQP5glXNNpc7dDQLQw7c493TYuafAEPSPc5y7DV7fAD+C
XggqoX0o7xlkeJx15+D3ErL8A/nmlzhXwr5okp3xKs/dYDALfmAHcjaEnKsH
PdDnkfF4kXPvg3PQXaz9CftfYf8F1q9DrknINRGshR7irD9yhz+AQehO9t1E
bzdAB/RtuXZH3e3/NuLON8G90FOQtyqBndFTEaiE3sRZ1diwCvwcej48VhaY
rnvR+Ye8y8O+Dn6HkKmj0HQiXbRD/4JzXwHzuP80+PdHzCayxYfQ+8uRAfut
RV/r8Y/t7Jscw6bIs4MzjsJ/GWe2gSPQw5z9JbgGhkCM9VfRcQxZ1mWYbXWG
eMvGC9FhC76UBf+3R/Oe+z/C+otpZpNtyLYdtEA3Id9d8PsYv/sIzIBeCp9F
YFeq7elj7Vfw+BIcgN4Nr62gG+wCvxzjXAU2Kge7oWfz7qGwxcpJzvgPd63n
fte43yJkPo6ODoMjSXZGF3b/eoXdPZMYy0D2+dxjHkiHbkPXS8AEdBVG537e
5RQbL62X7J3cuaPS7vD6WJNZsu6EPodcdyHPDHAWOsodp/I+E3nGJ9s32Vy2
1ppi8ZYeQQT6bfYksEU38l7C/8bw/DWwhLPnI3MPd2nme1+6yXRnFBnYe5z1
3+eMjZw3nu/V4CXol8F5xQjYDD0LH5/KOa+mmc6+FbV3op9k/52smwa2oMs9
SeYb8vEOz0eC4BO+53N2F0hCB9fx9y1ptkexpByg2FdM7S03nuL1Ijp1xaZz
6fq/2H0wbDJKtovQe9H9DtADesGzsi+6elC5QGu5/yesHUm2nPQuZ59XzKWY
DPKVWmxcEzKfea7Ycppy2bPQZ+IW84r1AehO3t+OfdIzzUYHOec+fCgDX9kL
z8vY1c+7W8AIdCm+U1lhueEIMsRkW+TJAFHoDXy7Ae/rYH2F7R32Ykk8GuE9
A6TBvzbdbFMD3wn5ZiP5omwo28kn96G/m178rkN/E9Hp/byfBeqgZxSYjqSb
RuizZZZDlTvPQM/CvveDJ7jbB9ynj5gpQ4el4AD0VWR+Ehvew/cmcCVsOULx
EUW+f/J8K7lkHPeNpFsukA/I9soJPTm2R2vlU4tyrWapVs0mXwyWmUyS5SI4
WWIxotg4ARaQV6tyLHe1Ic8GbLIfefaB9dCX8YG/gb+CkXFWC28NmG1UE1Xr
ulm3JW4171f8HmTd78Ee6G3kgq0xy70x5X/03JNvsaiclA6/OcgwG6RBr2Ht
T8FGsBpUItt25L7Kfeag/9/ELMco9ibDbzhuPiVfGgKPUSNq+V4DlkM/gO6+
nW+xO5X19diz0W+5ZXa2+YqPOpCVMJ/ZiwyjuF8q6B1rdzkB/uTdSbWyj3UH
/FYzC9l3Az+7DsLQi4ushqh2/FYxiu13gtfAJvAX7P5YxHoN1ci57HkYPI8u
g+Tv56E3gAnQc9FPC7y2s+eFUZZzPsa+x8qs1irmCvj+JuunjjYfXQPdnrBa
JR77OfNn6GJJtp0xJ2Fn6izltFWlpjPpqhN8E/5voqO1rK+Ff0PCaqZqZX3C
atmvyy0WdJ5k2+c9S0bpUjoJezp9j29DYBAcBQ3Yb1LMcrlqhHTX4PGWDhXL
LyPH5lKLadWCH0DX+awmKDe8RWz1pliOSLBmJu8yUy2m1Vut8XxHPdZTfPsO
OljJWa3sv4ZNZ2LbAykWczOVf4OWexWj0tVp5fRM01k3vrMl33od1fi12P0h
7vEgeNFvvZFqqmqpeiTVumpkzvBZzZuDDHOLrXarp5SvqydULyifV25VDVPt
Uo79M7It47w2cCpgd1MMyPd1x1U8r2TdemQp4rmFdSHkDYJm6DfAgrj1oj/E
R55hfSv7w6yNgF7k/lfQasELWhO0nKhcqDVXkGNK0GqZ8pFqvXpU9aaq+TtL
rSdTL/ZaqeWm7pjFtnLUEwHLadpbnW21WnfSXVSzP2XPCFjmsx42jq6iIN1n
OhvgHv1R65VkA/laU4n5lnxMuVoxqthUzl5YbjVLtapVPoYsLcjUiCzTwS7q
UCPvpoPXoc/w7R3kOAQGoBPctaHQcuvnKRarqlmqVYpZ9UJHOP9wifVE0rV6
ePXu0nkoZD4u3w6GrJZpRtBsoJomWb5bZLlAMt3rtxyk3BPxWa1VzlWuVc09
kWs2lO1k4zA+VZ1jvZt6bs0aK8bZXs0c6hUlg85Wz3gfcp1Ghi9SzcdVi9Vz
q9dWTXbIvCJgvZpqjGJtp2fLzV6vvcrLBeq5NRsphyp3akbSrKIeWL2vZhbF
gmzQ6sXEPVWW05XLm6qs1qlnVK+omvc9+Pb7TdeKafVKqql1Xs+k3F2mOp9v
OVyzgnp+9fqaGU7lWAzI9z9KttqjmrPHq0EXqIX1fF+aaT2SerndJTZ7qKcL
FVjNU61Tz3yOWIqjmzJwVj0hOaiTM96D99Fsm93UY6i30Ayn2FTMNXsxKt84
6dVS+UgVuvXz/u40y1HKPU8jT3um5SDVtsteLVWN0ywinxzwZhLV2i6vVqjm
xrjTdHhOA9G41SLlIOUe1aRk1rUHrLeQzVW7nNfbqYaplmvG02ynmn4H95tc
Yb2TZhrNetKB7q6ZT7OkZhLNIpopT5dbT6Veqr/cbLMYXouqzEazWLe83HLr
wiTrjdQTNXo9ku6+Omi5RzqQbgZyzHbS0d/ZPy9uuUI99O+oA30Jq32aGZvz
LKYVy6pxsu0VL7/IxqotkrHfqzGK7ffZcyzPYlyyqudSryWZZdta7vJOttn4
StByonKhat51eH811u6imXEDPvcGdv00y/ZolpaPy7c1U09BtjHFVs800ymX
7QiZ7yinae/+EpslxEOzhnpu9dqaOdRLTFbclVpPsRp9nIxY76YZ+DPeXwJt
PsuZmnXVE494M698VzlOuU0+rLXNxTYLao98Z7c3u8mHJgXMp+RLEwM2Sw96
vaFmavX2Kwqs9qvHl2zDXm8lGXtYs63M/ntQT1aDrG/FrBdTjlau1X8O+q9B
OVeztc7UWZqx/wc1D4gY
           "],
           VertexColors->None], PolygonBox[{{4337, 7710, 7709, 6498, 458}},
           VertexColors->None]}]}, 
       {RGBColor[0.5245265001875148, 0.4592431449683677, 0.8542657661463252], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl1lsVVUUhve9lNsBbUnhYlusvb1SKy0JERTT1gFRcYqGoCLKpBDji0yO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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJw1l3lwleUVxt8oJLkJQgi5N/cmZLkhySUJm1VBwC6jINiO4ChbsbUSpI4j
sqmIVAFb1wEBF0Ro2UdAXGbAAiGoFaoCWimuEEAcsSVJQWdqa4tKHH/PPJ9/
PHPP/d7tnPOe85zzphunXzvtvBDCWdAJfNMjhDerQngDfI3cjd/WbiFcx1hj
XgifFIZweyaEKV1CeDE7hHU1IawFP2aT/+aHcF4FY6z7Cvm73BCay0LIqgxh
dCyEa/j/QVEIM5IhTAfvIzcztjIewk84/DX2u4HzfgPm5oTQxLdixt9g3usg
gRxrYC5nNJ7PuV3RMcWcBGPgLPK80hAeQMf7wb3IG3qFsKQ2hMVgPXJhQQjt
zGsD3ZHb0PUg+r8DWpHP9Q7hsroQhoJvkb8sQWafDPrkygdJ6yRdJiFXcs5f
eobwN8YXo/+F2FLL9xowALmVfY+Bo+AUeLQ6hEuxYRBYhDyW/X9XZP/8n/Uf
838Aa/uD48jt6DiX37tBW4F9u6bGvpaPE+wzkn1GgLhk/PCvSvtyJ/77BJuf
5v9ycEK+wKZz3bENLEb+J3f7DOjD3F+yph+2DAIDQV8wEdtXp0Oo4u4vwsYl
cceA7r6eNVej09fcx8/Rfw7fHmH8BOMvIFczPhl5N/scYO2TfFuFXVOx4STy
NHCY+JhaHMKt4CPk7+o5i/3SoAM5yfy97LkHFCN3oGs/5nWwX3vwWYsZq+vk
M8cSmzeByWBMxr7dXebYk48Vi0097Gv9V6y/Cw5FMf8zxgezXwfx9U62x46D
Y9Gck+w3H73mgU+R+7P3SL4/lWedFrD2PlCKPveQE2Pxz2Zs2QTGIG9j/61g
OLrfz/l56L+Su1sBYshfJB2jis3Pkfdgbyv+a8nxmiri+ArOvRykke/ExtkZ
73Wa87qk7FP5Mh85cNYt/D6WFcIo5jxYYp2kywPIKzmjmf33s/9t2NuCDg+j
fy/0fz7buu9iTlPSNhxhv8PgIsY3st/KQsesYnUF8hzWzsw4FuSDf6D/hm6O
lQl8O4rOHxN7x0ELci3x9RzjW0BNqe9ePpEvFANDuKsRfG9Av4Osv162MLYU
TEReGLfO0rWmk2N9E9gYxfwMbJsP5oHp4KHyEHLYMxs8iHxZwhyg3B+asK3i
QHGfbH6bNWfQ9TR4q6dzcxt6ba1wjq7g/Huxd2COOayJM3eCkizfWZx5s9hr
JihC/i05ugtbm8AU5EPocAljDcTbDtZ/y5ze2HMDuf2LmLlSnDMp4szhKd+h
7m4Ycv8K54xypR/yZ+y7rptzbzw++ZJ7ruCMcvBv5DXs8Sp2vI1uMxj/K+ve
IvcOgL315s5L2PfilDl0dMpn6qxRYCBcsCSKp6/Qbzu27gBHchwT8k02sdm5
yD4Sdx3n3GMF5rBdrG9OO1cWMX8N8ipwc2dzTEfSOaDYPwdWEyMvgOfBqlrn
9jZ4bGsv5/iGet+h7m59vWvVNaxb1tk1ayZ5MAvcneNvudg5Hl8shA+K8sxF
f0w69sVJR4vtE/mipdi2jacWFF1gG/cVOKYUS28WOLY6Il0VY+OY27XKtVJr
GjmrPmXuW5br2qOadTaqQVfik+Xs8xQYjpyq9xnaO4kcQ4f3iP+7FEvsuTRu
zhZXN3Rybv8IHn+9i+/kLsYbC809nRlfjl8GpX1XmqO778P449mOAeV+A/+X
ZJsD0sgTIv/0Z4+eda6JqoWlyHvw+yHwd/BaL3NpGz5qjuqXck85ptxSDj4a
Nwco98XRqo3KAcW+auSRjGuSatHhjLlBOadcE0eotq5j3sxs19iH4o5xxbY4
qg86leOjMtCA3JcYuZTYGwT6IF+YcIwoNgYgx8rNIeKOXORviNGz4MD5rmHD
0s5Z5eoVaXNNv6gWinNUS+YWmUtVU7ryvwz0BBeA7djwUaW5cVmea79quGq3
eoD/MX5Vwr3N2ph7l/1825dxD7Oou2uYatfC7rZNMdkS2Sjfa47GdAeq1aN/
yE3ktox9Kl+2gmnoNDvtWH+JM+uqXFNVS3sjZ5XbJ/JFKDcXa47GxMm/4vf6
KvcS6snkq3MV5ib5bGKVOUzctZkz5hEPP61wL6Qe7UN8MQq7XonZJ6qlinnF
umrqFn7XgNXgWXBxD/d46u3EiaqtI6rsS9XY9lrXENWONnB7tXsu9VqzkB/H
1i/wy+fgsbS5Qj3g+ogzctFtPPuPAzmRLA4Vd+rb0ojjlC/iJ/WCirGGqCdU
79SF3/w691A6Sz3WiejMO/D5rIxzUz1ya4lrpGrjKeRx5c5p5bJyTL1na9Qb
qgdVbzMn6bPFkbs4Y7B6RtCEnEC/SezxZK5ztiRljhG3KKc1tz3yjdbcgz/X
Js31p5Sf1e5B1XturHZvpZ5ZvbJ6rM/Q8WSJc189kLjyfeZNyLe+uivllHJJ
d/Zr1o1GfjXmGqhcWB1xtXJCtfBgpWNdNVG9+A7yZ3uRe/KrGnwnuouRyJPJ
0xs584lc23gf9r0c9W/itwXVvnPd9XzwgXqGAseeOF5cKg5Q7otTVeu7Rrmp
mq9arDN1lmqyeqktUeyppxJ3qMdSbyUOWZ+0D+U7cdC7nDemxFwnTlZv+6ek
e1n1uMcqXHNVa48i34g9w+Lm4j9TDzLEVm3avatyQr3fpuguVkRvgwWRbXoj
/KfEbxC9PVQj5Tv1/Or15cN25mVV+K11W75r95XE2vBC13D1Eurh1burp1At
3RNxt2rqswlznrhuc8KxLc4vjWK8rtA2SHe98YYyb0ja8akcOc35Z6p9tu5M
sfJcyr2aYkbc1hZxkThOvUFWxDXqEdQbZNi/tt49gt4CqoGqfXoTqPdST6te
Vj3YH9LOceX279NeKxuku/ZQrzOFuTel3POoV9ebU29N9exPl3sPrV2OPISc
+7TQvbPeQPKdenz19vKh9lIOK3e1p2L9w4jfFfPq5dTDqndVT6dedXAPvx3U
s+ptphxW7uqN1s7aqWXmYtVMvW2lk3TRG/d7oGFZSA==
           "],
           VertexColors->None], PolygonBox[{{8158, 8155, 8154, 6567, 1741}},
           VertexColors->None]}]}, 
       {RGBColor[0.5577639836993024, 0.5170341525143116, 0.9009850700605567], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNlkts1VUQxqe9l1K4bS+23EIpfVxiuZSXmKjAbX2A2vIIQpFIQSmJLV0p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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl2lsVHUUxS9UW1oKU1q6TLfpAh0WBUpEEHBBoFBcQBRQQE3Y/CLKJioG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           "],
           VertexColors->None], PolygonBox[{{6892, 6894, 6893, 4921, 815}},
           VertexColors->None]}]}, 
       {RGBColor[0.5838048954293846, 0.5596742088478716, 0.9099543156077199], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHtsl1cZxw+ll1/bX1to+bWwAm1Zf1BcvG2JbnOWwnRDGAgMuhYTLlPY
2JwSZWEDhALJZFlGYybjojOZK3HtbhGIJtNSyiRO46KADpBViHOKc8AubAsm
gN+P32fZHyfveZ/3nOc81+/znLfpzm/P+1ZBSumlYSkN1/OLNSm9MCalw8Up
PaMPBypS2ib6k6NSmnhVSse1qKYwpU+Wp/SG5gu07qyee5PXDmr0ad+2kSl9
eLV4al7cnNKGxpS6SlP6SSalJzR2ajxQmdJqjXLNf61vW7MpPSreB7W3OW++
i6tSWqLxq6KUeqA3++zbm72ONS/o/Qbte1tn9TZJbo1PlaX0PY3zJSmt0d5p
16T0n0afs18y9oecgzp7hb5/V/rnpMsojeWirxf9Mc1fFT2bsYz/lY67NWaI
1qPnb0us/wnt79fzXxrLhpv/gEZ7oc85EGfdLXm3yiYTJG+N1j4e/A7IBp/X
2nbNy6XrJo2yKu/rD/u3Fnv+kOYbY83q5HW8P6B5V8yhs3Z/rO+VXdeV2Q4D
QUeeRVW2LzqWVtrOLxb5uTjmy0rsl37J95rWnNRYpb0r4ry79XxUz60aXcP8
5H2f6B/EO/Mh7bm3wHEyd3RK8zS+Jp0Kg45tNwzzXuzbl/W5+AudukLHNu2Z
Umz79epbd8TMfeO0X3G7R/QB0WeXmH6Pvq/QWBDyzNdZc/TszNgeTw6zDMeK
LNuujGOU+JzG/iL7BV9eKbA9fyj+s+K9c6zkr7Y9iRHi+X7NV2rfS/LzXVp/
QbQ1EevQBoO+OXKAfaxhTr48Kz2e0/gj8SS/XV/iGB3UeFrzvNYc1Z5T5ebR
pJzdkPf7Sj2njjcd/aYUWsc/S87Hcyl9Tu8fSN6OvOVfWp/S72Xb5ck2OB52
uLZONhtt/YkT6Pj3+xGL2IF39uAvfNIaMX1xuGMcrGiT/Osl8w7k17O/yLk8
scD+wBeLJcORydazR+c2X2NdX6myfMh2nehP5OyTTbLNjzWfqvlthbY19iQW
eWeOvddqHMnYV9DJC+zIOW16v+kTyvE6y4TtHwz7rw1/MV8d8z9lnKPk6jnR
a0d6P3uJL+jECb49EP49NDGlX2jcnDWNb+hya0tKt2i8LHpH8rc7kvFxbZzb
K/88rXFJ3/6gcy6PNZZhW+yK/U6Ev8hf9EN/dDwvnf6i9Q3yx1HFwrXKjSva
W6M4+YFsN1DsczgP+4BZ0L4jPjP1PiNjPCTOTgy3j75Z7VgnzsFFsI/zp2vt
rRnvvSx/HdF5bwaOgU3ECXGI7MRiV+ATsi6pd5wRY2vCV9i5gRokPoczziVo
T2n9VsleXWOsnVpiv6P3XtFnj7AMN4q2pdhyD2WMBxcKLCPnswZ7fDZsAu/D
wZ84nRm6g/lHA/cPSeZZ8sWN2j9Rck3SqCny/ssl1nej+HVp5DP2KfoRA3zH
nu8VGpcOlHr9GdnyRznL1B04B16hx8/HWM4zOve6CSk16ttgqfezZleR84kY
nlMr2zaa70it/V2VMQP8G4iziD/0oV7jr8pS22OPztlYY/9PbZBv8/5GzPVH
LesW/xbV07Oiv1zlWMSX1IXBkAdspycAx6nzK6PWrx9jXMYHE0qtB74Ae+FH
TcFXxDT+wueNE+wP8ooaTGyfrbA9O5Nz8HyBcw3bYld0xE4PN/iMcxXew/p3
C/zOHPkKowaR7xcCk+HN+hWBGxciB/sV87m89eN7rsprVgceEJvb5MM1k8Q7
axyEP70Bcs2O2IDH89XmUxZ1DBxdUuHcBxOoU/AAWwYr/c6cPMpGzrxfYKxB
d+p/edDpdbYXGQ/BOtaD7dDAe2pfbZXtsFDzg8q5v6l/mldkPhsjV6/EeeTs
Q9FbICdYA+bMjPzCV2ADPcKi6BOGKs2P3ok5vcLcItfKlVnLRf7gD3zxM9lt
3XjXVfAYrCKeyRX8Sg6CSdMDW5B3KGS+nd5hrG1M/hDL1Lg69aetIyznicBI
sKtP8btFWNMyzD7EFtjhn/LJjpxlejHqHDVtb7llfafA/Qg0fHs81rwadQ9f
Q0eWTbWWp02x0JFzPmBvziJ2wJLNgSfXR68K5mcqLScy3xBndkSNpabS+83J
up6SJ49Fv4kMq5VbP613LlLzlzb6DOQ8EXW8Zbz7CXqJ2bLDVzUuySc3KSYP
Vjmf6Cney9q3+ApsxV/1Ga8F6+rF4zPVPh9el4NOv5wLOduif2b+iHLxlzXO
+77oP8l3fLwj+u2dRcYyaPSV7O2J3rU1+OyPPpp4PCT9ftPomHow+qXNgWvZ
6M/bFQNnqo0zxP/OyAHs9FTYChxgD+vBEvyBL8Bu+pUdIRd7iRl8yXr24Tf8
hI/aYz97J0nOiRWuI/Nl2/a86z25OCt6j0uKk3+HbPSXubhrXNCaKXXeO7rJ
8f0RfvQGxv5Vep9s9Ptp+X3LCMf8R7IiZ6d6qIUatciitXmNRaW2AxjBGnIo
V+c8Ar9WRe89U/LOyDv218XdibqNTXYE/2OKpdYa11V68764FzQWO3+xMzZr
jPnSCmMc+MY9C7nov+jdnm0yXs3Rc26T4wmey6Jv/4b0+LrG+Ar39Xdc5Tpy
TrIfnuzzkLM3ZOBJXWG+qN53DO4Xo3K2BXY4WOmcfDdqEHvWRB5jA2IPvo2B
RcfE5+GwM7VxWoPrI+f2Rc2er3N66o3Nb8i3t+XNn3vpUNQavk0NHG6T/PdK
/pYKYznfoBND0+IOeFpynqp0PCETd53dQSfO5gYGXwyMw+bbw0fYhv4PPZ5r
8n0Y37OvJfZeUO9513jfdQbjfspd/z7J/+k6zy8pTlaM9129PGodNgInu6vc
u/O+Kuod8Yi9sBUYBn52Ro0ezHx8v4Y3eT0q7nDsRU/4E//YCV2wCevJE/bs
k8wvtRinyL13oo6w91TcSXmejrqDvqfDhq+FPaHT77Q1uLd5Xfp+Ie86S7wS
L5w7P+4m+wKf0Zl3+tT3o/eAXhrfztS5nrUH5hNnC+MuifzkOJh8LO5Q5MS0
wBywZE+59aHuc48gLojBnYGN3VFju+J+vCFkWxz/RagF55Qfb2nUl/j+jmx8
444BjoPV3Kv21vlutSDv+xW5SQ9GjSGe8AtYvDywgXlP9ADojB1ORn1nDedA
p37RswyG/OQtd1169Frh3is54xn6DcYdit4HW2CH7viHAP+hKmMi8QD/stDl
VJyLXPOi58Cn0IZCng1Rq8kX/s3MyjoXwWDqGveFD3UnK57kb9noo+h9uqK/
oz8rC//+v5coMi9ymfymbyDHN1zt/2L0Rtul45axvuM+U+6aQm14XVj993HG
m8vNzity6h7l1pVm/2ug1tFncXdm3/PlrjPo3B/+5d/SQPTkN0uGL+W9jjvE
vjHug7Dj29E/YJ9dEXtTtbYtb7nIM3ICG9JftEWdxTbjKuwv8H599GBLhSd3
Tva3eepxjtf7227l4sVa9wy3iPeX8/4PBxa+We08wZ/d0T/tjP9+5PIe2WNM
k3u9USEDWPBWo//TgavTxe8reedGTfRC2KdVtCkafRE7SyOX6Pvur7O/yOl/
VDvGVkQOoQt9DvLSu3bm3U/QSxCHHXFfox+CN76jd8tVfXz/6Ig7yP8ANNry
Yw==
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHtwVdUVxndBk/DM4ya55J0LuckljDw7ClggoBCEgQKVl22tiIBCVaRa
x5ZCQFtDO4IUrYDa2hFmgPCohNEOlKEBLGB1FKgtCAEsOg2JPCy0TrWE/r5+
549v7so5+6y19trr8e0k7n90yiMdQgi9vhbCTfyejofwdnUIB8Ep5O2lIZTF
QjiaEcIH4LeFIQzKD2EgeA35hUQIV3qFcBmsQb6ndwhZPUN46OYQ8ruFsKUg
hHNlIZwFm5FXZIVwviSEmdKFzcOsPQ6OgUNgDTb7YXMJ7/ei42B5CHVVISzs
iq1OIexCRyNYxLcjcPhIZgjfKwphcHoIczqHsBW/n0HHHr7t3N26ili/Js06
W3NCWM7fI/n2X2x8UF4IqR4hVIGByGPZ0zp8XAtqkSezthaMAZPAq6y5D3vz
0T8KHcfQfxzcwH4r8duDnv8Sr6/AbuQ2/P86+1qMb3/A/4qKEPLApx1DuKVL
CPvxf3iSOCHfhr4k68v59hi+3sv6g8R0CrFegv4adLQQ30Fx255FfLuyn1fQ
9zLognwAfXegbzv6BrMm0SeEl/D5HnzbTzzai9FR7NhdRucuzm0j2AAawSns
nwSriPdm7E9hDy/w/VS+/zYxnIG8Idu+x9DRgG9j8HE02II8h/i34N803u3D
v4OsryNeS8EB5Pn4X8P7FO+qwHRiPA1c4yx2or8Ge19UhjAB+1P5+yD7Gct+
dmJvCDpb2OMvyKWenfzNA6wvwN8eYDbyWXQN5HcAOINcD6ZzltPAs8h9OItC
fQOqkedxdvPBr4n3+gzn4hnQHOXkevRuBpvAOpBiH9vwaSuoKnKuvUQ8m9Kd
c4vR9W98vNHBMdC3K3hWX2odVfymwPvsLcb6LsjfJa++Azojl8ddg6q9MtDM
3tvwvRWcTro23+X5n+Ou0U9yQ1jGbx04j1wu3/Ht9eCaXU5ePAEeB8sqvDfl
uHJbe5zMuU1I2Jd2YtpIbe4E4/h2PLjAXv6GX80ZjvdU4nZ3D9eOauAh3j3M
mgb+fpU1i9F7Bl+bwY+RvyCn0rBbh+6OrJlOLc8Fc8C0Kp/VLs6zscxn9nEv
x1yxPoe8g7g8ij9F6D6a5ljIhnQrJnW8HxbzO+XPXOLwffzZgq0m8quVv1/M
tu2nyP/bWD+W97XgVuR67L7J9wn8KwdLifFC8DT2zpJzHUt9RjqbDmA73ywp
sC3ZPICPx8BRsB9cwu9J1MEf0bVP9U4uj+Zc7gS9kMdTj52x2QmMQy4g9j3A
1Zsc8wbVEUjR3/pS7zeIyRVwGbSDGfg2M+leqBxTL97IHjdUuyerFg5h60+5
rokFOa5J1aJiol7cDE5HPbkm6Z6hXtHAfu+jPh8ApaxfyPlu5/uaKtd6M9+P
TromVYs7WP972WEfcfAW8ih0fsx51bKX7vgYeF7Bs17gRrVzrTZF3+/qnOtd
7R6i3pGq9l6GIw/L956G40tfcAsYBsapBrA/FPuN2N/GWUzEblG6a+oD3l8A
LeB98E3sVZba1nX8uUxM2jPdq3VGy4odY8W2Dvmv6FqE/Bj4EPlX9Kx7i9z7
bsVmHrkys7dnWxN7nICNT4nRPzvYJ+WWalK1qBy7QJ6+wu/LoAX5dXRNZm9N
2J6DzxV8vzfHsb3Y0bkxk5jN6OMcaWXtLuJ1lXhtYv2b5NAo4tsV23fwbG2e
e7x6u3zQrJyLjZHpnpmyrZ6oXigfrlEzCfUZcDXLs0YzXrNdM2dHpXNaubwd
+UNi8pdi770szWepmaNZozMdhv8jk86dy9jfQ63dTr0PBbuRR/FuTNK5cqWD
Z9/blfZdM7CA/b2Dz0dAD+QhxZ65mrWDkd8Dl9BzEbyL/ETcM16zfTw1Uovu
8UnnwufoH1DmnFOu9Ud+Cr0vEqMF2JsP6tGRn21uoZ6tWlnP/teVumYaij2D
NHsO8f4T9vmNpGfzJfTP5uw/15zt4hrZSn5tS7hWxSk2sfY5fN/L99e7mFs8
iD/z+phjqFbGEYO7KlwzOqtZ6Czp5jNLoeuHnO9edF3s5NmwBnu/zPGM6K7a
1HrQDTTGnSPKjSb29E6mOYK4wVxCMQ1/piYtN+FP/xLnsHK3Pd17uTvpd9rT
74hDbp65h/JBttrJv+sp20wjnt+qcK5qRndCVxY6M0EG8vCYe7L6o2ZGe7Z9
lq/XkVdmewao9z+HHOeMHuebH4B89Qh0t1d4lmgmi0tm9zS3E6f8O3ZW5Ts2
4pCarfJBtjVj+xc7h5Q7/cDQPp6Bmn1DkH+E3fM5PkvlxBFqYBHrHgOHkUfE
zVHETTRDM3I9A9T705GXYzuftRPT3bPFDcUxxC3EEcXFNoNNESfbk2nOIK6w
G/kz1t0ec69Sz1Jud+e7bgXO8Vzs7wdT2OtkkId8LWVuomealfJJvmhm1pWY
I4obJjM8e9VT1Us1gx/h+yLkQvBw3Fxoi7h4mTmRuN9q6vH5SnNAzeZdERfU
jO6f45pQLYhDi+trRp+LOH8bfn8FvgStBc79n5d5nqoG6tn3shL7ppmWw967
EYN/pPm9uJQ4mbiYONVKdC4FJ8ivnuTjG3w7ssyzZKz4CGsOZ5q7/qSzZ0Ur
Oi/EPDOUq8OjWaGcVawnJcxtFPOthb7D6O7SUOizWgVWRmcmLqUZoN4vTqXY
KUeUG4qhZqd6qHqnZqi4r3JYuSsOrLM8ic8nSnymmiXiqLOjmaK7gPYg33Un
OICPG8HQm93j1Yt+ip5nEu5JknXHWhM9W1juGlVtilMp9uqh6p1fRrZ15jpr
+fAfnj9JXtWn2YZ6bSu4EPVc9SL1bPVq9STNhnnomVvgGaHepRxW7qqHaXaJ
44jbaIZp1p8r8V1OM78feTSU2A0BfZFHJD0jNBt0x7m/tzmGuIV63hvqFWBO
R9/pThSZg4p76s7zWqVnkmbRbyqdOzHOdF+ac2h1gXNEuaFndyY9czRrdAe6
K+kZodmgO8QKzul6sbms+N6C3q451ZruJDWqjaR7t3xSLDTDNbsVE/UqcThx
N/UscQ1x9NMR59Dd73B0l9Ud8DQ+nyW2Z8Ap5LIS70l7KS1x7qlHqTcpB1Wb
ukPq7qgafY9e/FG572LqObq76E6lu1RBxA1zycVYljmiuL7utLrLivPHOeMH
s11Lk8ivWeXmxOLC4rjq3fKpNOrhx4jHpbhnve7Uq1Pu4erdz6fMTTRjNVvF
UdoqvUftrbXSd8fPyn3X1R1Ss6t/1Is1w5R7H4GTUQ7uI8cSMXPt48qfuDm8
uLvuFNpbW9RbtMe3YubsOjvdAXU3mJgwt9MdQXd35aByb23U28Xx6qIeP4Y9
JLK8VhxU3H9lNK/Vs3RW4hziGjoz5bI4vLi7clq9rSXT9rVe3H5r1EvE8TW7
nywxt9MMF1fTHrU3cbZK1sULzV3U49R7xaHFndWDVas6M52VavbZHN9ZdFf5
WY7v0nomWXdq7UV3Et1FtCdx5fLo7ijOrFjrDHV2irnuKprBmr26s+huL44k
bqQ7/oAScwRxg///TyNmTi0urR4rbtcWnbU43v8A/qjAmA==
           "],
           VertexColors->None], PolygonBox[{{5198, 6570, 6569, 6894, 1819}},
           VertexColors->None]}]}, 
       {RGBColor[0.6082421366946406, 0.5989380558264313, 0.9105114094408359], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmGts19UZx09bSq+0DOidXmkr7V7gQh3MOWFjWSiIJShmW3DT3rBl2t24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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHlw1dUVxy8QEgIJWUjekuUlL8nLRkfCYlFA1lYJtNKyCFigZakRqKyy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           "],
           VertexColors->None], 
          PolygonBox[{{8231, 6270, 804, 8229, 8230}, {8161, 4341, 4340, 8157, 
           2366}},
           VertexColors->None]}]}, 
       {RGBColor[0.6326793779598965, 0.6382019028049912, 0.911068503273952], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl2uMldUVhveZ6znjYeY44xznwjlz5gzDcBy1FjQlCijqDwGNWkorVm1E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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHl0VdUVxk9iQgaCZJ5f8l6Gl8mWeVUFyuRSxgWItIKKa6GtQC1jmNrK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           "],
           VertexColors->None], 
          PolygonBox[{{4345, 7144, 1932, 7156, 4344}, {6884, 4766, 4765, 6890,
            1817}},
           VertexColors->None]}]}, 
       {RGBColor[0.6571166192251524, 0.677465749783551, 0.911625597107068], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl2tsluUZx+9BS9v37ds2dZSV0pe+LeVkokTKHOI2zczwgx/QaHY2bNlW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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHd41tUVx2+IwJuQRDLITsh834xW2VaGEqBlU3ZlSNG2ggxBggU6wCQg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           "],
           VertexColors->None], 
          PolygonBox[{{7694, 6496, 6495, 7693, 2152}, {6351, 8130, 2356, 5144,
            6350}},
           VertexColors->None]}]}, 
       {RGBColor[0.6815538604904084, 0.7167295967621108, 0.912182690940184], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHuMlWcRxl/KXs5eztkjC7tQ2LPs2T0sZxfTUP9QiJfYugtKS4UlGgmJ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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHd0lVUWxS8kQELRlJfy8pJAekMZwLJ0lCrNggIuWfZxlgoIggUVdZYl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           "],
           VertexColors->None], 
          PolygonBox[{{5109, 6335, 6334, 8109, 2348}, {8708, 6148, 1605, 8698,
            8707}},
           VertexColors->None]}]}, 
       {RGBColor[0.7059911017556644, 0.7559934437406707, 0.9127397847733001], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl29sllcZxk/pv7f/Ky+8LZT3bSl5LQUcBSZEIwTHpDQhgoyxD6iIAWnj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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHd01+UVxl9MQhKGZpFfxm9kkoULEKx1IGE4UDBY8RQV7REZQrAWtKDH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           "],
           VertexColors->None], 
          PolygonBox[{{6785, 4323, 4322, 6784, 1795}, {4947, 6801, 1800, 6800,
            4946}},
           VertexColors->None]}]}, 
       {RGBColor[0.7304283430209203, 0.7952572907192305, 0.9132968786064161], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmG1slWcZx+++97Q9PV1LT2lLT2mFQSk0YrLCBwVhkKDy0k0mJpMuA6du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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJw1mHlwldUZxg8mIYEASW6Wm+UmuYEk5CbiH1UCM21dWNSiLEqsWiW4tDqo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           "],
           VertexColors->None], 
          PolygonBox[{{4238, 8165, 2370, 8172, 4237}, {8208, 8223, 8222, 6249,
            787}},
           VertexColors->None]}]}, 
       {RGBColor[0.7548655842861762, 0.8345211376977902, 0.9138539724395321], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl21s1mcVxu/S56UtLU9LW1ihlBYoT7tVxodtYsaLcySLExrRymQrwgqb
OFFYlFKYyZTNjbagMWEzIIkiG26i0wwH08RtDtimvClTZ6If5pwuMIVCEQYz
0evHdRo/3Pnfz3nul/NyXeecu6VnzSe+OCql9N2SlEr1XZJP6XMa38mk1FyV
UovGIs0Pjklpgf6fo3Epm1JF1mvu1uit1F5tXjBZ/09KqbwspfaC97P3rOaP
FL3uWHtKRzU69V+Z1u3Q/8M686bxKd3b7vs6JTs0OqUHJH+9PKUpkn1I+r3S
nNL7Y1P6RS6ln0ifZzSu15otE1N6T3IMaNV/03OWz56S0mXJR0l+RvqOkfwj
mr9ckdJ27f10xt8dMT+lO2rljJy+Q1mfczbreUHznSGvifORVYd8oWys0xmr
tf9A1vL9WQ/WrdKagZz3sn5d6LNP89dk66ujrf+aCs+36md+lM/7m+aflY3n
GlO6Q3fcLj8/XJtSvXyzpz6lf0nelfH5J/O+40H9vrnMfuMe7sP2u1pTurPV
dz6jve/K5/dW+U7uRof9DYpfdUo34HPt/WCZ52srvDZXap9xBn6bXea7ZpX4
7N+0+79/lDpO+Co3LqW3mx1vZD/V+HPEizhiZ2fB/yF/Q7b9odwYOyzZIY0V
WjNTa5ZJj8dGGausAT/fbNJenf/LMsv+GPKVujfX4t+r8j6XM09q/L7cfkJX
7MEH6NIa8T2q3+srjfFtum9lxCIf37nJnIAbC3FdwXrODdmhkIOLv5Taxh7N
+3RmptS2ZAo+F52XBO++JVumyZYXZcvCNt2hcbTy/+fOibvYi0+453DcdX34
CzlYBtNVgetdGWP7VzUpfXya4wOGviR7b9P8nM4bEE83Vprji3Lm+YqMZVmt
6c95H/75teJ88zXGQJW4VqmxXLEZ0jmbi7bzHfHvivA5rPuPyZ8bKu2Dpfq2
jbZv0L80bAF3jzQYb3CoEDzq039nS23LXvmpRDhcDLdqHXviDscqNWZEnmKO
zwbJCVnv3yT9JmvvYDK3iTXx/LB0vzLW2P67fP+7eseDHMb6r2h9t7D9ddl1
ZLRjhs6c3yP5j+vtp6064z35doPWDOi/jcl5DF1qQrfzVZb3k28zzmfwndw2
0ODfYAXMgLPFoTs+gNv9gU84BF+Ixx1l5j+5ZYJ8ePEax5q92M9+YoNecKdD
a3ZNcuzhLnmWXFErX96jXPys9u3V/KO1xgY63V9hPdHrSt66zdDaTundFff8
tdK+3q7z/l3mva/Kn0/XW/ZJcbFLI1X4jt15Ywz9wCjx/ZT+X6xRQp4Wf+c2
et2sMu+rz7omFCus87KMczz+xD/kaPzQqzUPVTh2byhWp4XXC3nHHP8Sd+LC
lziC0/cDqy9p3fNZ53JyBPuWRL2j1hHbCzp/uMp3rxYulhaN64eKrj3Iz8mH
55vsC/aUhp5nJRviP8nfmq51GvO1923l+SeqXRfAPfwljpfzxvh/S5yLXtB8
XvL/qwJXjza4HlALqmudR8gh1NkTUQvgdHuF68G8yA8z4px54f/Jile1xp3l
3oufydv5VuMbDB3MmodgcpTy01rZe1Drzst/T9XbV9RZZNQF6uzLgZ+R/2ZF
PYWH2JDLO+bEt1frmzR/SfdfJzs6miynvvVHHcUHL4YfehrtO/yWlT4ZjZ8F
Fsl7YGvdGJ/Hvh7hKtNi3NNrgBN4SozIEeSHr+q7WvsvRr5fGTipk58v1Jhv
9Duzo+d5Ut8nJrkeUsvoCagnj2v9JMXjkNZfnCpfttg26uqCCvcmbwozQxo7
pfMtleYXPDvXYD6DgePad6LFe7YUnbPIV7P0/VrRNtC7HY46ciZqPrmUugCu
qRHUjdKoO18eY3+AqdkZ29qtNbdMc50gt5wSx4+3+9wjiu2xZp/3pHLM0gnO
IXCFHATvft7geOwLDpI/r+Zd+bxkguNxRvG8rdb6dUiH68a4/8A3g+Gfbbr/
T1NdJ8hd1H1izXd59ADM0R35F+SDfQXP6TXy44zb8uAA/QC4h3Pc2y89PzbZ
cnSgv8Gf+AS+wTV8uimwQUwuR96jhlHDwQmybYERagB1covmz4nTe6Y7npy9
JvA/0uexhv2ZyCfk17WxhhhhHzWxWPCZrP1+i3upHdGTYD9xhKNlwXH83Rs1
a7Douk79xpbeiEVN1ErqJH0P/OReOIL9V21XfKoVr1PRU8PVkb53KDjLgL+c
BS56m4yNW/PuHbsCd2ALXIGhS/F2gFvz9f188vmt0W/DW3ozerQ26d5XsA/A
RG/oxu/1BfvwUWGtr9E5G/17g+ffkz7vTPV6emD4ACZf0b7OVusEB5HDkfVx
F2+WU8L77nq/RagbpZNcA9BvpG7whiGfYk939ILwi56xN/rGm8TN0wXnEuKM
jFjTB/VFL0QNoSfoj36B+Ybk+jEc8vNRazZr3nKtYjTenCPv3h+5ty98gm+O
F2wD+p/U2iPXOmfjb2QPxF3zYz5Na+s0ku54M+9cRew4sy18cppz2m3vHPl7
z0T31CeqrRP6wOkDDeYXb68f1dsO8j15H4xtFaa+McH5HlwXI47ozvuGORjm
3sGoTfsDb2BzXeSstrB1MHps8i1vBzj+bLxR4SZ74MoHmnw397K2M9bDtZnB
N95YmxusxzJh5DOtfgfcre/yVvew9IS8b0d0bA//wMWZkVdvkJ/mt7tPXdrq
3pG+kT6ePoZaNkN+2zrRdfBAvBXJ8/Rl5FbyKvLno5+hlqA3vQv8pz8djjje
l8wj9F4f+qBrT+Qj4v/WeGPgqj2Rv/6ptZuKzhXotyz6mzl54wR84FtyMPWI
PuK5SnOzN2IBv4bk17MajdrXre/t0TeCI3LB1Z4k7MEW3lvb483FmZxH7uIt
cDDeUOiBPuD/0li/88mdPxSmHi76v28rv+6d6ji+qzU3TnENe63FvSN9I7kE
7tLHNUmv7Q3OTfSqO6NHuCv8hx95P5HD4DIYWhX1lL6DHo2auCje1CO9K2fQ
Y3AGZ5EPcupB8m321/ngLrw+Vucei/5qarPrFjULzK6LHEVPjr5gg1pBfdwS
9YU5dYpvR8zbg6cjtXYg3h2sWRGc4rwlcSY9IHWQ+9AdP1CXd8lvu1tcT35b
dM1G3iP8jBvvPh+MpahxxBVfkj/hD/9Ts8hHcJ634YLwB34hzg9GrMkfP4gc
Qt3riB4AvIJbeD0c/cjCwPlAvJvoPRfHuxD83jPRGOZ743jPL0Y8uiPPbYwY
U3fAN7L74lzi8p9G1wbqwgt1xha4IifytuE+cvCFiCVv35I223hGe18vOHc+
JR2enuhejLcRvuuKPpK70YF3W2f0h/8DPe+E1Q==
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHlwltUVxm/IHkITzJ58+cgHhCyA/aNsHUFHQHBBRjDQQkW2othSkNEB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           "],
           VertexColors->None], PolygonBox[{{6373, 6896, 1820, 5201, 6372}},
           VertexColors->None]}]}, 
       {RGBColor[0.7776034308797819, 0.8519909067438585, 0.9073233643831415], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVm9M1VUYfhG4Vy/3cpnsIhe4xmW5i6RbmyhKYX/W/ED2xS3QiiIHlKjg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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl2lwluUVhg8CCWQxgezJl+RLMIsJ+quiMOLYgYJSbEfapJ0ikgZxWlyg
jhY6QjchUEQSRakhqNWpLBL6o7jFQO2PsqUtdAHB6qhQbGcIIMFqbXGSXnfv
98c933nf73nOc56z3eetaV867/4rIuITMAbMKYi4ozzi84yIt8H0yoi51RHF
4yOWjI7Yx/Oblf5vNc8/qY34MTiRFXESvF4WkZEf0Y18gjXXV0VM4l0tmIL8
0dURfUUR+exdlhtxKB2xsSFiVU7EYgxYxlknmiLeAkuRe1n7n4kRA9kRbfyf
XRKxoiZi2riIm8dyHv9vZe1n6MpF51HOeRe8A46AH02IqEZ/Ffgh8i2lESP1
EcNgNvKSioif1tr274+KGEKuLmQ9uIj8AP+34pMW8D3kDt63oOfrYA3yJvQ+
AXbhu79g4/P4ZjL3n4Kuqdj4S+Qz7FuXGXEvz3di+97iiH6wAHlFXcSt+OUW
sBz52+g9w33+DtqQf8sdLqDzvPyO/GS530nehPxxKqJLd8N/d4/x2i7O7Mz3
nqn460XOaeJ+k8Fo3p0lBovx1xls2s26h9D1IOhF7sefz3D25VzHaAsxeBx0
gW5wDJ8d5PcA+CvyTnxwLXZcA3YU+qwbOLM5y2euYl0raAErwTnpx96tYLDI
e6tBVaLjxkrnnHItDcrRVwF6yL+3uN+5xoj3wXtgEOwFvwcDoD/5Tz6U77Tm
pQbv0dqdyN3cs4pY1qB7Jngdv6ewowK8hryVO/yA3FgBepD3c/Y3ueco1n6R
+8zm/dfAPDCr3r7+J/f6R7V9fimP3AMPsLaN/D+Izqs5rxEcQJ6AznfR+Q7I
R97GXVtLrHs6+XGB2Lxa5Fy+jxhsI3emE+MXiNW0Uc5NxUC+V46qtm6gPq6f
6Brbyd6DadfnfPw1v9A5q1z9VqFj8SS2bCpwTFS7a8jFN3Ncwz0lrlnV6hbk
z2tdE6qFy+C76L5EfgyB7yCfx949nJmDvUuw94M8v5OsmpjDnvHcdcNY94TH
sWE1fntEvkMeIObHwTFwGLyCrh50f5prnfLdWuqio84+HFXimlYtB/IyfjdP
ingKLEXuxwf34LNZmfZBJXs2l9kXivnaSc5Z5WoHci7nteK7FpCDPK3ePpOv
piJ/tcA9QLX/FeQ5lY6pYnmr+iB3PU18ToGTyIuqXeOq7Xbk++Ub9maD+5DX
ELdN4AmwutS2/hz79mfY5kF0/Ip1d2Hvyhz3Lt1Rd1MPG8GujfjnMTCM/A1i
MILfhkFr2mfpnWSdeTP+39BgXV34/1Kxa0a1MoQ8l9/bwMh496wdnH0p5d7w
NO9+U+876677kP9Y73eS/wC21biHqneq5q/krPlX4T+Qi3wqzzmtXO4Tx3DW
WLAHezbyPML+U/z/ARhGPo2uUxXO9eP4YIQYXSldYBg51eieoF6gnO3mDod4
nsXZ2eTYAH6aTK40g8Pq99jQxp0WgtkN7n0n8ny2emCv1qO7GexCrmTfq+TC
KyBV59j+DbydxHh7hWtS9h0b496wvca9VT1iPWcMob8H/RuzbMt+dP1uom3q
L3EM5Ps3kLvQWaVzQSfyBt49x++z4FHkEXrKBc47D4bzzW3qoeqd4rgu9Dws
HiN/nss0tykG8r04bk/KnCeu+zXyTSn7TL5STxEXTSGXrmsyJ6m2n8GWrRNc
4zNT5gD1/hnIC8izF0vN/ZoRTueZ08XlB7nzv7D5M2rj3+DjEvtePpZvFyZc
/VqR14qzxaUDSe2LU1ek3ZPVi5cjr+YeL7H+IWL9YI656Q2ej4c5StwxC798
Kd8cMrPJPUy9a0aTe8nLRc499RRxuThU3ClOP8xdbuNec8Eh5FStOVVcqh5e
eZVzXrmeQs6eYA5Q789CXod9F/HBFvRvYH0Hzx/x3M3zep7vxa59nLUX3IO8
G1vayYMjzAoPc59WcqcFbB7tGlQvU4/qSHqaelM5sS+rcI/670TXtGpZOpSr
ynHltnJWsVTOKFcU08cazEniIs1YI6xZxPl/Yu+fQWeD30nWDNHO3fvIq5Os
7yM/5lW4h6l33Y6cga13FTv3+zLM5e/z33tF5vSXm5zDyt09TZ5lNNNpltNM
s5j3BVWehVSzd2DLgjr76ml8dhT9R2rMzbJBsV3FnpUljrG4cx+69labQz+s
cc4p184g34muhXWOhWIwkPaMqdlSM8Rl7nog7d6WyRmfsmeEvcPgE+RBcTl5
8CE4i5w5yRwo7suY5FlIe7RWM5H2juO/zFrrGFfqnqZellnq2lZOKhdV45ot
xIHiPs0Y4mJxhrhCnLy70Rwnbutt9N3lU/lSPrg2bQ4Rd1yjeyQ9QLUvDlEu
q2ZnJDmtWU05qNzTzJaZ7xlds7l6hrhInCIuESepdsV54jrVsHJ3EXva853D
6k3qWZ1JjxJ3a2bSrCQOF1drpl2ecHabZto690LViGZN+VS+1Myp3i8OPZlw
gHwpH8p38un6MsdMsRInDmFXZ7lnf9WMcjkKPHsrp9V7H21wbakHa7bWzKJZ
RTO2ZvH/53imZ/IX4LVfVHpW1zeFZjnlwNlkplPvFieIC9TDhwpdE6qFi4Xm
DvWIVMIh2ys902mWu2mcufk61n6hwhwtX6rnqNfIp5qN7i4212lGWpt2D1Tv
60i79nWmzlIPmNxsDhF3NDd7dlVOKBc0w4or1yZ7xZlrGlxjqi31UH1L3Yhf
12X5m0qzozhC3KAZUrk/hJ0Xy10D6vXPJ/5Rz9esrRztTWbuc0kNqvYGa/zt
tiqZ9fUNp1lFM5ZmK80svSW+g2zfhZyJjoxGz/qaCVTb5xJdqnHNAjsq7Utx
7pd597My9x59k6r3aMbXbK8eJF8fTb795HNxt2ZuzdricM0mmhE0G2hG0Syq
byB9+2gmFfdp5tCsIQ4U96rnq9eLg0dj1xU19oV8om8BzYxTk28C+faRBnOV
fPw/pUVvEg==
           "],
           VertexColors->None], PolygonBox[{{6897, 6371, 918, 6895, 6896}},
           VertexColors->None]}]}, 
       {RGBColor[0.7995497321176306, 0.859309413426776, 0.8974914410953819], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmH9s1VcZxo+37b29Le0dJXe3pS30Nhf50Q4cf2k0WRAwg8xRumRhbIAO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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3tQlFUYxk8ILAQCguuuuOwusEoKaDlT2W2aGjWlSVMLMlDzUlqZl8oG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           "],
           VertexColors->None], PolygonBox[{{8168, 4236, 1666, 8171, 8167}},
           VertexColors->None]}]}, 
       {RGBColor[0.8214960333554795, 0.8666279201096936, 0.8876595178076222], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmGuMldUVhjfMMLdzzjf3wWFgOCMDzgURG/qDpi0SK7U1XmZQKUhqmTqA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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHlwleUVxt+Q9UKWm5vc7Lm5N/tCQtqh1aijUktMoLIklIBCEQhmWlQg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           "],
           VertexColors->None], PolygonBox[{{7664, 6588, 420, 4241, 7663}},
           VertexColors->None]}]}, 
       {RGBColor[0.8434423345933283, 0.8739464267926113, 0.8778275945198625], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVE1IlFEUvebk6KRZjs448+k4n5qpLSpaRSZCWhq0KEfQ1KjoZxFOuckW
KaS1Cl0ktGiTFW6CaB+Sku2TIiV1EQSZBSr0Y7SwzuE8afH43nffu/eec+69
zz9/9VR6i5ndxsrE6gya3dhqditg1pI0m42YVeI/FDXr880iIbPxbLM82EYz
zA7jP4T/hwH5/nT+V7Jk/8WYCbPTWCP476g268aazTVbyTcLlMpnDd9XMbN5
+L1F3ndFZo9z5MOcGwA3UGHWj1W2DTb41+K8Bqu1ELHKzBqxv1Nulr/HbAE+
Kfgu8xxfH9gT1frvLza7WSyMX5F3GesM7rxHzuue2SC4vIZtulQxPuM7gbhd
2PfhvKLAbD9EG8e3zpceGQFhJc5VYEkBUxNyTe0G9zDwIFdlgfzpS+zUdQ0a
du8w++RJz5e4nw/NxxBvHfFSIdViDnl+owYHsmRrD2lfDF2fe6oH9eqGz1Cm
+HD/JEP8u9z+DbRNJ/7biZ15y4GtCWfD+D8bB19g3kD8bGCbjqmOvfCbKpXf
WEy46VsKXSt85ShMCBPxULtWF38anM65uhP3TFC8GqB5Y1L6pYG/LUf6sK6s
Zx98GzxhIp5juHsUqxdn89DgQ0h32BPUm3ouhlR/2nmPcRm/x/nQfgh52+Oq
1w9wveyrJiex/5OQ9uRd54n7R5x/iwp3R0J6Uasl2Fd81YN82Pvd+DYH1cvc
EyP7dZPTosMwjR5s9lSvC8Ayidr/hc9eX2e010PvE+WapWHXZ8RMvdmX1Jzx
a5xWKdcXxMJe73I1GHG+1JbaHMyV1sz/IqxcxM7eJ+ZrVdCuSvdWd5l9Dzse
sMWxko5PrdN8PaoeZe4mN5e0s+85Z9SQPb3g9jsRowgzUoY4F+PiT+6XEKPH
k345Sc0MMeegfx7F9M7wnbgfl76c42eecrQEVTdy53l7WHcmYnpfuJ9E/ONR
vVt8JwYKpUelqxsx1yPm0xJpwZ5LB4WdNWAeYviCeDNJzViL62X68y558P5d
zEdtiWZte0SzTTtngzE4F6PAfs/T27k5A+S74WJQK9apx9WXWNvcfgkY9vnC
wNyDDv9QuWrGepEH3zWezTuNeHcuovedvAtQi7wq1YL93en41MPvSFK5ea/Z
+T6IaM7J4x/0L9pa
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHtw1NUVx++uPMJSwu4mu2xe+whh4waHJFOYmojBGZE31ZoEEyCZigU6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           "],
           VertexColors->None], 
          PolygonBox[{{10333, 10325, 10324, 5827, 3286}, {9741, 4210, 4209, 
           9745, 3103}, {8671, 6135, 1587, 8127, 8670}, {4210, 10329, 3286, 
           10337, 4209}, {9754, 9737, 9736, 5142, 3104}, {9737, 9746, 3103, 
           5141, 9736}},
           VertexColors->None]}]}, 
       {RGBColor[0.8653886358311771, 0.8812649334755288, 0.8679956712321029], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VEtIlGEUvenoOP9vPscHTs00DYqCrUI3krMviNCyhznRLIIiyqAHVEoE
tmnRy20LF0ERbSKKVkELV4Wh0tOohc4EgdEqNY3O8VwXH//3ff/9zz333HP/
dP5s35kSM7uOVYpVqDIrYo3hMFNmNot1B/eP/Mz9fIdZyXazocBsepvZy3qz
5XKzo1HF5yJm39NmS01mBxHTVS7cVX9HnE9I2otnEd/cBua+LWZvms1GEDtS
oTjGLGH/cbPZTux3R5WD71rLdOb+QsLsYkLnH1uB32B2DfdZ4EVw7gfmV+Av
YD1AHfG4ztxnwX9vrdnvTWYPwbkHnHcE4sqaN2ofD8WnB9iXENeJXDF8G2AN
xFQT4xiThDYprPOB9Jjxug/g3A0ua2Xiz7sp5M1in8C7kzjvAudZ55+JqRfU
bw/yHQ4Vyzu+Y494Xs9fKjxqR8xXpcqxsf8Sk4Z8zvn+eaXOjDndaBam9e5F
i9nnavWF/aiPKhfzFpzPdKVysd4x1HoDazkiT7BGaku+5EaOw21mo3HxpF8O
tcgzvc3qU7/rwm+pPXkMhuJ5GbyupqUR3y1USetbFdKFPpqMCoN6syfn2pSb
Z96zj/TRkyrxvAe//GxSzqJjUH9yJUf64V8SNYDrCvIsI/94Srq/Bve37lXi
EZffjGbkRfowAPaRpHCnwOcd1kRMfLOeq4DYU9D9Ju4GEZupU03EI0fWnkcf
jler5k7nyb5cAZ+nDcKhX4aT8gy5cmb4LXHZY/b3F7iPZOQJ6kgOrLEfPZlI
ySMf2qX1us5JzQZj+nD/rFE9/4v7taRyLILX3YS05VxO+vxT01X/V9AvCz77
9BFroZc4c+/bhc+5P1EjPanxfdeZnlpMSYtj0DyHtVauORoI5DF6qNP/IdSG
+lKTmlaz2lbNLfvLWWRMEEoXatLtWOs4EWmwMSPcMyYEtxA8coH+C0XHp2b7
44rjHBCX8exXwf+ff+CBb2lxZW/IlRzY82JCPOgbakkdqBPro7c5Rzn/d5Ln
kO/5PyVnakwtqSm/4b9trkO1EIfveM9n3jWvhh6P6zSzxOzyWSPfvHuMM7fi
/qEPyY0c/wNQrPCa
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHmMleUVxl9nWGTGArMxy2UG7gxchk2WBFLZpEmNla0tyMCADBVo1VR2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           "],
           VertexColors->None], 
          PolygonBox[{{6849, 6850, 1661, 4198, 6848}, {8401, 7791, 7790, 8399,
            2465}},
           VertexColors->None]}]}, 
       {RGBColor[0.8873349370690259, 0.8885834401584464, 0.8581637479443431], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNlU9slFUUxS8d6rQzX9ppaWdop7Z2ABk3LGRZagwr20AxXWjYaOLGGEEK
iZqJRjfVAIFNG3ClLiBgRlkAJlijiag7ownaogIrEmAJCSFTIm08P88jdfHy
vb/nnnvOu+8bfe3A9FttEXFKLaf2ez2iVImYbI/ornhMf1KLO/UdXxdR6Yv4
dWNEU3N7sog2tWX1lzZHFEe9b6Yckens8XzEgs4c0fpJfR9q78dPROzSnl15
f3eLwM8bIj4f8b7Jos+NaH6uS/s11xK3xkDE+VLEN8Jp6NzJjoizWvtecb9T
e1Hnrq0Xv3bH+qTDe8Bv5j2mPy7u17ojpsXjlDjeEte74rW903NglrdG9G91
fr+I118684HW3q2Jy2BETXiLOWsDZpe0emnIcchrqODc3pMe7496PCj8BeHd
EMdOxS3UPd42HPF12bz7dXZJuF+prQ5bU/Rk7UrmvFo5+4E+BWG/qbPXhTmW
+VxN84eejvhJPPuE170lokdtXvq8UPRZfDwk/ANqZ6RLbJJ3aqvieVEavzFk
37ZtMj/ir2jtUcF+7Cs7NnHxrJD8nZJWh+VlVbk+EMZYxV7Nd9nLOcUf6LRP
nLms/T+MWPvP9M0/6flHirmi9lDc9vZEHO2zLqyv9noPscEhly/E5UK/tSfn
T9utBR5w3/BquGZOjbTGHrT6Wzr9NmjtDyqvt7Xv5nrrfj3ho/GdqseHpe0J
8RmX3v+I494N1hQtrzxlPbm/YOARWl4oWU/uwI2EiQ6M6ZPHQOqTG2P0REfm
mcN39CAWOq7LjEl+rJHjs4pz/xnn9qfu19W6a45a5f7i3UzJd5oxfGfSHfhI
/syqTQn7W927hc2u6x+lzWW1XuX0eqc5PI7XSvfwucz6oSv18UfdNYIGj2sF
//rSnob8qgy71nry9oT+GXF7RecvpRrHT+oLDGoNHHjAnZyo70aqwVcH/TYx
f0n9kZqxqWm+4Je2OAb4x+TbOY1zmbGbKRa65pK2eEXN4EuP7vKS8lrW2vO6
Ax+mO4n+6NJKvnAO76g3xv/VRdG1w33bU7TWzL0szFbVfnUIe3/ZMfGQNebh
Aw5v4I7MWqMh+POpphbrfoOaSfPF3Nr7yR7yZR9jcEYz1zP3AUzeDt5VONKH
J98dKdbtqt8C3gHuCPyX050CCxzaXIoFNm8JmLeV02nxu5cZfyXNw4sc2M/b
Nv8/rWYTT/4tsykWXqP92VTX5IhfxAWX/dQGfpH7RHrv0JP3faK45udE2sM/
Az/I90HV/y1ql7joDibvwTvpTeDcZDrLuanimqf30n8QbRgvJ15TybuxlD+5
T0uPL3ud952N/v/xjjaTjmgynvRnPxq0JT7/Apn8Ekk=
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmGuQlmUZx2/Y5bhb7PkIu+wu8L6s4bAwA5O7gDhTk7CAQwVyiCUOnibQ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           "],
           VertexColors->None], 
          PolygonBox[{{5216, 9792, 981, 5258, 5215}, {4776, 7618, 7617, 7794, 
           2214}},
           VertexColors->None]}]}, 
       {RGBColor[0.9092812383068748, 0.8959019468413639, 0.8483318246565835], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNllts1FUQxgfa3bbrblu6LSCULdsuduHFRKMxsOUWTKwt28REQ4ImRa4v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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl31sleUZxp/RlkIpcr5P4dhCe9qe0y7D0LLRaAvC3BQphX1Iu1GkuEHU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           "],
           VertexColors->None], 
          PolygonBox[{{8285, 8271, 162, 6916, 8284}, {7707, 7090, 7089, 7706, 
           2159}},
           VertexColors->None]}]}, 
       {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
        GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHts1tUZx8/bvi+19H1beldpK5UCBbxkQoxmY0ZdoiYrSCkXw9Vlmsic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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwllW1o1XUUx8/c/rtt87rdh+0674O73t3de1c0mHuxqCU6QQvnyjQWbjGr
7UWZk3JZFpYl9EAjQpvarBQfIB8S7EVvzNDWA5TgjAjSZqWEgUYUpb4I+hy+
Lw78fv/fefye7zn/7CMjK9bNMLPnkApkf8zs1blmf3LZWG420mTWmzG7xPnF
KrNo3uxo1GxHjdk4cq7BbH3R7KVKs3Rg9gTnM3xLBfo2gH00adaAv03Yf5vF
V8JskvdPQmZfo9uHzfczzX5A7sZ3qdHsFPEeILEmbPv59jTnZvQnU2bXsO+t
NpvivnCe2SJkG/cqbGL1ZttbzabDsrk/Z/YgEiPXDDE768xulMxe5n1pGTUR
+9fZZlvI9TzxN5LPcFG5/EbOD+FrJG72Jr4/xGaMeuLNZq34y/LeQy6nqelJ
chnDfw58viHfCd7fRWaR7x7i3YntdnTuQf8k+hcqpf8p56UJnd3HILH7kXfK
hMmJqHy6r37uF2rNhrCpoN6VlcLiLPeeamHyJdjVUON71YpRTvwBdK6Q69v4
X01/F4NpKaT3TUVh5Nj8iP84+qUI/fL+orOMtyU59XZbSL7+o56tYflczdvW
orCbi84H+G/gfpL7NfyvL4BfQb0Z9G9g9wdyBF9fBMr9Kj6XV6uGJLYR5GqF
fIR4+5j7X5yvg0mA7b6IuOg9qI8IY8fWezyFv/nUv6RMPr3XLzSol97zCe7H
kLs47yH+OOc+YrwfiNOr4HoczNNw5yfy/ygN35FFt5h1I2eJt4YcOtANo1PA
9vOUuHgU6QSPrpyw9hk4VBImjoXHPIyvI2lx32M+RW436cdb3H+mpi3cq1LC
2jGoa6FGJDNTnIjBhXhes9fNfRm15ueAKf4Xk98xuDpG/CzvC7C5CF96mzR7
v+OzndyPU0NA7rehM4R+LxzfHxbH/yX29ZR0D+HvK/QbwaOA/gr0NzdpBpz7
l9HP8DaFzqoa6VzifKVZus9zH8fXAeQEtZ4n38/A4lHy/Qfb15BoVpxzrv1C
jm34G6IHO4m9Bh8dxJpXr1hrqfEx9I39tJb45b4D4MZp5I5AHNlAPQ9Tz2Hq
eRabSbD7rkW15rnPp/aVvB/kfbpMszRdK18+U50RzbzP+kXeB3PiuHPbZ8K5
4D3zXjknRtF9PaZenAsrdldEtp7DZfhxJiuu+85zrG+PKLZj3pcSh5w7PhOv
JNRT76VjNpxRT7wXjkkbs9RaUG2O+Qaw6UtqN/qOHea+vKBd4T1OU3tji7B2
DgW875otLG+asHg8rl3vmLTnxXHntu+wN2Kq0WvrQecU+bXfSl2zhPnftdpJ
vot8B/suHS1ql/hOvRfb5oh6vxcfo8RfV9Au8Bm7j929MK395zsrzltQ0O73
GbuRFCecCz4jvnu66rS7fQd1zBHnnes+AxNgvTurWfUdcKCkmfdZ9x28N6Gc
PBf/x4xRb1tM3Jiu0b8vkRUX/R/otR73GTfV7P8Wx9Cx83+M79L+mHaF79Td
cOWZiHaVz6BzvRudYkicX5DUjvbd69/837o5r9j+j3VuD8SEtXP8fyHaDiY=

           "],
           VertexColors->None]}]}}, {{}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV0l1oD1AYx/FHWpLXbX9mZjN7waYs2y7cjIbyEhvy8pd5t11Qm2SURPIW
2o20EoVwg22F1DSTTUasNm69FC5cmBtiLobPLr79znme5/zOOc85M3Y2rK0f
ERFD2JEW8bkg4iu60INMsfJZETm03/w1SsyL8WBKxIFExNbiiIrUiI2TIubT
TeYN4i/TI2pptflc8dPyZXSd+R7xn9Mj2rMjbqo7Y5wxIyINiWkRReq250ds
xsnZEcfwyX6N9DDWiG/AJHXj1V8ririFy2jDbVzlO1ltFlJxfHLEaLUrrVuK
RXgjtk/uPe+9tNe8THw+KvA3K2KkNVsy9IhnxUSeU+XpoPkR9YdQZ+0LmqTb
UYNGNRNnOiPGIhuZ6Hauh3yf0F28FhsvxPPMiDHWrM6LqNSXVfbs0o9xfO/J
Z+VEtNLHYsvkOuhy2kk381oiV0N7+KxXm/BmjXpe7632oQFDYpX8F+HHhIh3
qLX+A/3mPruNw1ts4fOPx1Z6Do3e7Cyd53zphbyRhhZ+zdYlneO2M9/BXWzT
s9e8Pou/ol9oLx3wf75jo3wSs8S76TMMGPep+Ub7aZm9LtMraOPZihbs148/
7jqIEvvXOmcdfvH4jY/uUp3rDkhTc0APkvS3P5c73CNr0sUuulMKveTtz6Nc
fZ55J6+jxk1IOGsKbvhng8P/Wqx6OO/uTSjRk17z1c71zNu+Rb76Utyzpo5f
lb532DNf/StaSvvkdqhJyKWgyv7tzr5Avsj7VfC8rg8r7FmgtlnuFi6IPRI7
QVfqT6H/U442d2vyX6/goPpCnqfoKHX3/cV+dGFQ756Klc5xPvof8diV9A==

           "]],
          "1.65`"],
         Annotation[#, 1.65, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV02toz3EUx/FDy2VumzEz180wRG17oJjrAyW7iGwysjaEcjeSXHKPPZGU
WyZWKJe2JXPN39xCuT/zhFzyUIs9QV7/B+//53fO93zPOd/z/f5zatbNW9sp
IrL8VPeN+JwX8R0JPEEWX9HoiCH0NfsFJrDHoCUrYlO/iCVjI4rTIyr6R0yk
C9lr+Z9lRCyjZezx/PutF9L57FX87cMiWodEXBB3wHdmTkQ6MgZH5ItbOiJi
EfbmR+zEJ/U2022Yy78A/cT1Et8wJqIRp3ANl3FW3v5is5GG3ZkR3cTOsW8W
ZuAN3zprH+VeTV+yC/knohh/B0V0tmfxgIg/chanyZltnXawt4vfguX2PqWV
dCmqsFlMn1F6RA8MRhYe6uuGvPdpjVwzfU/F44ERqfaU50ZMN5cSNRPm0VPe
JuvZQ80IZ9hT+S+6k4fiLtF3w/XmDA/MMYEB4raJ+aCPdHlq2ctQ4Sy92e+T
M6FvaR/6jnboZavaW1CHDer05F9Pf6nf6u5v4iv7Av+a5DxpKrrjoPOUqn2I
ltF/+uqqv7O+G/CI/7sem51xlT5a6NWREfX8V+iR5H15V5m4pc5tNMr7TZ07
vu/iHn7rpQOV+m53B4XytOl9o9nu8q6m02o6jS5ECdK8k3Z7Uuhk7y8hZ635
rNTXSXWr6B58tFZHf9AVYr+o/xPX9fTF+z1Pf9JP7uo9JiVzYrH5p9NN1irp
b/WH0Soz6Mt3TL4UesL5D6NIfA77njvZ4bseGc6WgvPqdiT/Q3xlyfXkjDBB
ny/Z5Wba5kxvkSu+AE32LJevVH931MwV/5wW0FfWqsVkWEtBqfqt5j/Fer4z
FMt5zixnqzlC7HFrjTjKd4tvD51jxnlmXIRrzlbvv3EadeLz5NxHu4hrNqvX
SCTfkxk/4CsYpz/6H0wgo4M=
           "]],
          "1.5`"],
         Annotation[#, 1.5, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV01toz3EYx/FnLYnJDszMYcww52YXir85XCgxUwtroy1DzqxtyjE5FXYj
kVPOtZSIpUhkWw6xGDnbDSlcSm03Dnnt4v3//J7D9/k+3+f7/edWby7dlBQR
mX6qMiK+jIz4hmY8QhZfYX7EENrOfoaJ7DFoGhhR2z9i2biIRHrE4syIKbSM
vZH/Sb+IFXQBewL/fvHJtJS9hv/XsIjbQyMuyTvgOzM3Ig0ZQyLy5VXmRZRj
75iIXfhsvzq6FQv5F6GfvD7yz42NuIxTuIYrOKtuf7nZSMXuARE95c6zbg5m
4SXfJrEOtdfSNvZk/ilI4M/giCRrlmZF/FYzkabmIHHaxd4ufwtWWvuYLqGV
qECdnL6j9YjeGIwstOjrlrr36XK1ZvsuwsPsiF7WlIyImGku8+3ZbB4p6t4Q
z84xI5xhF/E3upMWebV8m/FqeEQNfWPORc7zKdV81R+mXg46nSOh5hVrm+Ts
oDuxHe/1+w4l5jlTnT/q/MVvlOvzH33r7lPkbrB/b7qeftfXOvqNTjKvSfJu
sUvVuqq/1FER6UhDo7NV6qcKWe7/uR5bfbegRqzNG/jAlyfWqd9QLwXbzOWm
+EGzOy62i16gH617gXI9H2ZXYYZYGeYjlf+XvpLpNG+uWV/V+l5tn5POVEH3
oEOsnv6gq+R+1ftPXPfGv5rTRfqTftbHa0ztroml5pRGa8WW0E7759AK507n
O6peMj3hTIdQKH84+54Z7fTdgAwzTcZF+3Z1/2/4FnTHzasBE/XZxi5xz63O
9Aq58gtww5qV6hXr7649c+U/pQX0hViVnAyxZBTb/7b7ny6e7wwJNc97C3Pt
OULuMbHLOMJ3h28PnWfmeeZbiGvO1uAuTqNefp6a+2gPeTfNqh3N6DLjB3wF
4/VH/wO9jp+5
           "]],
          "1.3499999999999999`"],
         Annotation[#, 1.3499999999999999`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV03loz3Ecx/G3XxJbzJiZY2zDnDX7QzHH/KHkzN02Wa7wh2uuEZb7+keO
XDlXUqKRokU2OWJhIpFoElHKUpbrDx774/l7fd/H5/1+f9+f7y97/oppy1tE
RB8/pR0i3veO+IQa3EM6X37fiG70KfsRBrH74mpGRFlaxOwBEQWpETM6RQyh
s9hL+R90jJhPJ7IH8m8XH0ynshfzf+8ZcT0z4py8HZ7TsiNSkNo9IlfenF4R
RdjaL2ITGvRbRcsxmX86OshLln+qf0QljuESLuCkuh3lZqAdKtIjWskd59wY
FKKeb5nYG7WX0Dr2YP4hKMDfbpbjTEnniD9qFrRXs6s4bWJvkL8GC5y9T2fS
OSjGKjltc82INuiKdNSa65q6t+hctUZ7HoG7XSJaOzMpJ2KUvYzXs8Y+ktSt
Es/oYUc4wR7Bf96d1Mor41uO+qyIZ/jC98Kun3uu1qNIj+Hs8uZaapbInY1e
zper25u2kZuEMvOtRIX7SRkYsdMsu/DN/UznO0dn0Ea62X4qsFaNdXipx0W7
GmWXhWhpjm8pEQfFDuGr3u/N8Iu+oj9pA01T751zn/DWTj8ioWeyGsk0QX/L
O6znKYyVNwWP+RfZV633W0HrxF7x5aj3w7l/SDLfenu9Ir7bex0W20TP0NfO
PUGRb2gvuxQjxWZhPNrxfzd3gg7zzdbY+zxzLNLnqL0W0y14I7aafqYL5X5w
94247D/ywU7O0kbaYI7nGNpcEyX2nULLxGbSH/pn0mL30Z7vgHoJesQ77UG+
/J7sm+5uo+d9SPV/TOCsvk3N/zu+ic3xPuIYZM469iR3ccc7PUOW/DxUObNA
vQnmq9YzS/5DmkefiJXKSRVLYIL+1+18uHiudyhQ87T7G6tnttxDYpXYz3eD
bwsdZ+c59puPS95tn7s4jtXyc9TcRlvKu2JXT1GDJju+zZfn26ui/wEzAqnn

           "]],
          "1.2`"],
         Annotation[#, 1.2, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV01toDnAYx/HnTYqV2cxx2LzYsNW2C8UkFGZOYSabrBjjwvkQcsgxLCWR
Qznuxo3jDWmxyYjllBsSTSLiYlZbwgU+u/i+v/c5/J/n+T//901Wrytbm4iI
ET6qekV8GB7xGQ1oQh++ohERmfQ5+wny2bm42T9ife+IRXkRxekR8/tEjKYL
2Kv4H2VELKUz2Xn8+8QL6Vz2Cv627IhbgyMuydvve0YyIhVpgyJy5C0eFrEQ
e0ZG7ECLfhvoFszmL0O6vBT550ZF1OE0ruAyzqrbS24/9MCuvhFd5ZY6NxkT
8IJvtdhbtVfSZnYh/2gU48/AiH+o7BfxW83iNDUzxWkHe5v8Tah29iEtp010
Kd0gJz3XDt21G+1La5xdjkb7S5XXQHvS+3SReXeZYyeu6dmdv26A/aBKrU98
D+2rCUl7ytJjMIb5/oXv7tCII/Ly3PE7+xu+oki8EE3qlqpRr0+lGSqzIoZ6
16lDIiZ5myl0Gkowkd2NTqCT6QG19+NHTkS78220g65U9405p8t5TVew1+hx
18xtej+gp/SqkLuZfx79o+9P+/wqtxWN3r6FZtjPe7N/xju7/YSEninmTqEJ
+kveCfnnUCJvDp7y17h3oz5rabPYa76keu3O/UV3b7nVLDfED3qLE2I76AX6
xrlnWOi3dJhdhfFiCzAdPfjbzJ6gY/12G9xziTlq9DnlPhV0N96KbaRf6DK5
H71NK65624/2eJG20hZzvMKYzpqdvy27S6Xrxcppu/6DaIW36cl3TL0EPelO
h1AkP4tdb4/bfa9Fmv9lAhf17ej8//HN7Ix7p1rkm7OZPcub3Henl8iWX4Dr
zlSrN8N8d/TMlv+YFtBnYlVy0sQSmKH/LTsfJ57jDsVqnveWJXoOkXtcrA5H
+W7z7aaldp603yJccbdab3EGG+Un1dxLu8i7YVfP0YAOO77HV5BvPvofjDyt
+A==
           "]],
          "1.05`"],
         Annotation[#, 1.05, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1F9M1XUYx/FHp4gLwlDLlD8HAzXgpHZhtWrONkpo8rcklYkShbopYzq3
3CJvCtpyjVIr/1BXTSuttppzS1IvjIVz3USGOlkN1g2jQHRtuvn6Xbz5nO/z
PN/n3/ccilra63dNi4i0P3vnR2xYFFGBF5H9SERzQcRgccSS3IhX8yKW0gdT
ETl4ANnIwvuLI7rRhVRZRI1cq5dG1NJ6HC6NqEts7m/1udrnmgUR78i/H53Y
Ik8zptR7U9wseTKRgW38d9hvYxtf/eMRDahFWp91NEd/1/mvYQhz2SeXRVwW
f4l/xHmCfRK38KX4/+i/GMco/y/i2sTX0HLndbSMVtMZ4v8UdxV/IDfJJ/83
4ssfjXiDXhTTSsucj8yNOGnGEzjP3vaQXsz3vdlvOefbVUZ+xEy8bb677u2y
m5POe/hWzInY7h167PFbdwbc/Y5+Lncv8ovs++GIPFqIArzuXExLkIlu58U0
hY98LqXlKEOP80r6JJ7Ax8nZPE3qrlHrObX69PI83bQwYiNu6mcYWWZv0vNm
lOi7km2BmT4V8xlecGetHGtoFf1Azn8K1aTjcl7Q/yFxjXa0291a+r9cU/KO
6mUMfeJv0Nx53lTuvzHkHf5C2M9se51Ng95J5hN/FBXiqvEre6t6ferspP18
v7Ol5Jtw7x4yH/O918tp/neXyMG3jx6ng+4NYL1363JuwrN8r2AtstjH9R70
Ke92zv6a9dGqziHzNNJOXOXroCO0ReywHY/ha+86bD+9dIze0MdvWJXkxGvJ
74u28zXQCfUX0cbkN8j2oXxBD5rpPSwXn+981h7f8rk7+Z36ngZ61Z0Uv4Ot
KvGX8KNUn/3OL3uTn810BQXi0zjlzlb5KvV3Rs0C8Zdomg7wNYnJ4QtUqv+D
nT/DX2yGp+U85i0r1CwU28P3BQ6w/cjWSV+y85T9LsdXZuv2Fp+gQ3xKzv10
urjTyW8Y5zBpxz+xpf1POEXvAy5Irvw=
           "]],
          "0.8999999999999999`"],
         Annotation[#, 0.8999999999999999, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{5562, 10909, 5563, 6235, 5561, 10735, 4066, 6540, 5559, 
           10908, 5560, 6234, 5558, 10734, 4065, 6539, 5556, 10907, 5557, 
           6233, 5555, 10733, 4064, 5936, 10130, 10131, 9572, 4864, 9571, 
           4863, 10127, 10128, 7411, 8732, 4059, 4082, 10125, 10126, 8392, 
           8394, 10959, 8393, 8475, 8474, 10268, 5765, 8832, 8833, 8834, 7018,
            8614, 5944, 8613, 5945, 8615, 6232, 8645, 5974, 7590, 7591, 7592, 
           7137, 7138, 5735, 8455, 5734, 8457, 8778, 4102, 6584, 4103, 8489, 
           6267, 5776, 6552, 8493, 6551, 7019, 6587, 7615, 7613, 8258, 5051, 
           8450, 8451, 7584, 7586, 8568, 5899, 7773, 9428, 6799, 5105, 6986, 
           6371, 6897, 6374, 8171, 8167, 4240, 7662, 6592, 6804, 4950, 7026, 
           4943, 7928, 6132, 8677, 8684, 8125, 8668, 5137, 7386, 7394, 10713, 
           10721, 8703, 6152, 8712, 6143, 8694, 8081, 8090, 7236, 7245, 6345, 
           4195, 6845, 4204, 8135, 6356, 5151, 8945, 8956, 8967, 6517, 4269, 
           9860, 5265, 9849, 5276, 6869, 6858, 4437, 5254, 5211, 9786, 9811, 
           9799, 4363, 7150, 4351, 10806, 5820, 8542, 8035, 5012, 8022, 8061, 
           10967, 8048, 10980, 4449, 10463, 10476, 10154, 5599, 10141, 5612, 
           6620, 6607, 6965, 6911, 8279, 6924, 5486, 6994, 5361, 6938, 4694, 
           5389, 10894, 5375, 6291, 6277, 8238, 5404, 7864, 8312, 8327, 9230, 
           9215, 4509, 10994, 8297, 7753, 9592, 9607, 4905, 7879, 7498, 9918, 
           9933, 9245, 9260, 4524, 5472, 10056, 4790, 9501, 4805, 9516, 4554, 
           9307, 9998, 9983, 6216, 7347, 4664, 6435, 7735, 6043, 10820, 4382, 
           7312, 7327, 6028, 10932, 6013, 4166, 6687, 6702, 5289, 9095, 9110, 
           4464, 10015, 4479, 5889, 10413, 10443, 10428, 5874, 6075, 11052, 
           6060}],
          "0.75`"],
         Annotation[#, 0.75, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV0ltoznEcx/GvsBXWnNnpcWaMO4dkGyXnUZbtQo5PlBJLKS7kBmNGk0WG
lHKajQuSbJMbzSFxQQ4pkcPF1vKMJNST13Px7vP/nr+/3/83LllTubNPRKTR
MiLi7LSIVvpnaETp+IgDUyIO4jrfIbpuUsR6lInVsr/nRhymG/g2opz/CDvF
X0c38W3GfP6j7F7+enpDvyT/X3MWiB3j654acZM/n12Qyc+L+CfeOTbiGv+P
woi+RRFd8t7o04N+xRH90RfZyELhsIh58kpRhooxEStQp1/WuIgtI9XQrfRq
QcQVlOl9hl1Om+jjTHxUxLBExKXBEV/kJMXu6dGGF+LPcUH/JnbCzG1yiuhp
dp79f6pttvcj+y/nX5fv7nB5dMRFddP1zWXPoBX2XolKPatRhZSa7+IpfFXT
5Qzf0CC/R/0DcxrFquTtMnsV/W3mT3t/Ud+NDvnv6eDhEe/s/wlv3d9HpPmz
9c22a1rNL/YJ+U1YKK8Cj8WT5nWYs512ir3kS+iXUvcPWRMidtulVfzAZD3E
9tJz9JW6J1gzxPthr8VcsUosxgD+Hrun1c7y9trd/Xp7JM1pdJ4qug+vxWro
Z7pJzQd31Y1m7+aDOz6feT/0vT2eY2amp7nV7n6g7x1iq2nK/Dxa5V0N4juu
X5rvpDMdxAz5Bfx33eMe37XImSjHGc+b2yt/G9/STNz7rUWxPTvZy/yT+870
DIVqStCiZqN+S+x3x8xC+Q9pCX0itlZOjlhazRLzb7nzOeLjnWG2nmf9l4Vm
FsltELuAer7bfPvoIveWyLwhXHOOWnueQo38hL77achrdVdP0Y5ed9zGV1Ji
P/ofvOCiOA==
           "]],
          "0.6`"],
         Annotation[#, 0.6, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1Ftsz2ccx/FvF4fMurSMzlpVpZjq3NCS7IoYRtbU1IXDtqiYTChisSXi
gum2mLYjFhsRttZheiGbU5RIlsWmqrZpRCcR0mmkf6WtSCe2f3j9L979/J7v
8fk+z/NvfsXadyvTIqLUn2uvRjQXRrTTcZgyIWIm+qEAQ1PfQyL2vB5xZ3xE
D/5EXlZEWnZE72sR2ZkRfcMj+vv+YkTEp/iDLV/dj9W8nasO3+PBEa18HbR9
nFxML4j4xbqMjpwYcWGoXuwNYyIasVqv97BbTJt1E07xH8ZYdbOQ8UpE7ciI
46MiDuKemD7szY/4Cgf5WtTN48vEYPFfs2XSnbSAbQzW6HMiI+Ll0RHpGDg2
otrsT+ztIzrJLKW0wlxZvi8Pc3ZokbtRnXt8T833H/7Hb2qVqnGfvVi9EiTY
mrE8J+Iq7XS+dWo8EjONf4s9dLFvpSvEFOuzQkwJ/ZDWi13J3qv+l870X3k7
rJ/QJXotxmVxTXjTnaS5txewTu31mOReqsUfcm71qEOFu+znnKbq8T2tww8Y
wH7XbANpB/1L76Nyf0Sn2Kt6JFLvh7bgCtrsvV5ut/PowUPMds5n7PU0Juj/
eeqd4LB6D8zxEK3yvmH7m/bKeYQGvC13bl7ENlpvns9opnd3wL4X6FOOieKK
8Aaq+Wow333fFd8ptwM1+nbJuaDHLv5yddaZ4x3al+pnjn/USuCc+Js0Q402
e7uDG2a7jWTqXNQd4CyTch5b14r/FjPEzcPv/Mv0O6fPKnqR7xpbrnrd8p6i
v/e5wV4a+Ld6y7V8n9C9tFXeJSzw5rdZL8I0vvl4Cy+yd9l7Uu4Ub7HR/Sy1
j2X67DJPOd2E63yVtJ1+IOeWd5DAUW/rlrPfRxP0pn20YHKqpr4L3fUg36v5
ymi3/sNpuTf2EtsO9ZJsO1P3gSLx2eynneNG31VI95tJmnGfvj3iV7LNTvm9
zyqMt8+L1nPcyXkzNSNHTiGOyXlfvVn2d1LPHPG/0kJ6iW+RmHS+pJxZ+v/k
zEv4881QrOZ37mWGniPE1vDtx3a2n9k20ZnOLdecRThijir73I1K8bnqbqbP
nGmDs2pCI3qsz8ot9D/qGH0O6OnbaQ==
           "]],
          "0.44999999999999996`"],
         Annotation[#, 0.44999999999999996`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1H1M1XUUx/HTgK20NCIlHkTMh7owW8uC/ujJAdXKujewdFOJtWoRA7Ya
OdGtTLKViaElYm3WVrlYEWZtiXNzzaU5l+FazuVwYLURkBqRud1lL/548/l9
zznf8/T7XeY81VzddEVEtPjzaW5EojTiG3puZsS+myOOoBv/Oa/Ljii8KaKR
bpsb0YZPro8ozWdHxbURre7uKYl4g75fGLEZBeIXs+1gu70oojgv4o7rInr5
qm6ISC+ImCrv8nkRh8Um5kd8y59P99IqvlUz9DfpE5OPo+7sxwOzIg7JuSBH
P+JbcL/zs8VmUHOnO2l9TnWnja0FX/PnyVfq+VX1357swRybxE9hr1EztyDi
T7YkbWC7ii4VnzbnbZ6PmeEUhvl26u803U2H7eo0atUdlK9xdsRPtJXWoEOf
dXTFHPu100V8aXsbkfNKdyrNlEI5lqu/AdXsh9U9gS7nl/ja6Xra7e4L+sg0
46Ub9YxCvn4zHVKnnr/PvTr6HdtDdr4YnXztGNdH2nvJci9rcg/OA4mIn3FG
3ElMk+8Ue5/4YTqEC+5M2OMS8zTrvYZ2qHNALyPeyWb1RsVf8Fzt/pjnv8R0
iqk392/uPEcfs6u99FGaQhIDfNniLspRokYCKTma5G7EB3Il+cLuPuO7rNfP
abN334QCdcacq+h76j9vti7ayraM/2/vd63ncbqGPihuB38ntqLSeZT9I/4v
zHqPWbew3017nNv1twV1+j7rm3iSXqJtdJkdPoFV9rbBOZf+6NsY4s9y3u8b
yZz8bdE+hHkv02f0+K+YWr4JehH/YJM6GWYtU78co/LNFHt8esTTfCPOf2AY
K+1hBcb0nTTnKE3RdfKvRYXc3XZWSZv4gu9x8UvRIHe/mcvMvpW9A71sZXoo
R4kZ3nW3lL4iZjf/y3SK/xfX4GoMOS+xnz3yr/f+zur7Fnd6nR9mL/Te1ohJ
iZ3uuZaW0SyaoNl6+tDvtAfv4F7212kr7lR3ob02sh00+0Kzf0lvtYvZ7N/z
v8b2lhx3+UYeocO+mY3q/0JXi6lHkVmOOe8y65t66sKE387v2MXXg3a+afqc
Yf55+Njv7CscEXMS2/weV9pnA/Y5d2M7/wF5Z+kvqd+DYu6j59kH8avzCe9o
nObob0DeF31Pxfr7wZ5W821EJt+EPvPYznsOeyyyv+NqncMZbPfNZJgvx3ub
iwxUYBHmyzmIo/L20/8BlJbrDQ==
           "]],
          "0.3`"],
         Annotation[#, 0.3, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1HFolWUUx/GjW1mCZXPp5pxLt9VtWZJW1gKTqbPVUpqBUIkU6e7kMitM
WkFYZpS1WpszrVxSztofoqWWVrBC0sSKSWaSKNNNGIZb2CLrJutz//je3/uc
c55zznOe972THl9RUz8sItb4+WRcROKmiC9o/9iIvYmIg+jAJevnr4kouCEi
RZuL7UF7bkTZeHZUjI5osHdnWcSr9L0JEW9gvPhZbO+wTZ8YUZQfcVtOxA6+
OXkR6esjRsq7qCTigNhEacS3/Pn0MzqH79Fr9ZfxicnHIXu+RGVhxH45S8fo
R/xKzLVeep0zqLnJnrQ+R9qzhm0ldvPnyVfm+UX138r04BzrxF/JXqPm2IKI
82zz6XK2K+hC8WnnvNXzYWc4jj6+Tfo7QbfRPrM6gcXqdsuXKor4mTbQGjTp
cwl9eJL5muk0vrS5nZNzhD2znWkB7sAi9V/Cg+wH1D2CjdbP8DXS1bTD3qf0
keWMFyfrGQV8Xc60X50k/z77ltDv2KrMfBY28DXigj7S7iXbvuzMHKxP3hjx
C06JO4ZR8h1n3ye+j57GH/YMmuP9zlOv9xrapM42Oeq9Qx/Tz633YKra2WZ3
GbIwApfjFnNO2ZtUqw61KJe3V50eHL1aHfUHcNY992KdXPfyVWEu5qES2ezP
qVmpj3fFvY/NWG82W/QbGIb1bK3YkMmldp1zJ9Fi/Zj7GNJXuTy/O9tsud5k
b8LbSMlVK3YZGq0r+M+Ja8/cPc23vpP9LpSjhP1Pd1RKB2ke/1Zx42h7RuXp
csYWeXM9j0EOPhD/gnepjabpQ/r6hy6k/9Ihe+rNap5ZfeVMT3pegQf4/+av
phcz8fzN7Mt8E7VYijokUWxe3/A9IeaSXnvU7c3Mwqzb+P5jS2OX2N3Yk/kW
8aFZf4S/nKHTnMK78YN9v+IMqt33ZvunO+9MvgStojvZ2zFDbx3e+QraL8dR
Oc/jNAbsWy3mDL1ZzA4x9zlfgXrPil3gvbrK82J6e+bOaYKO9h5t8X1vRwtm
sr9CGzDDDKfoM8XWaW5T3PmndKpeJ7J/z/8y2+ty3O0eqmmffteq/xtdJSaJ
Qu/FYes29/aanjZi0Dd3Fm1829HIN0qfueZWjK3OvgsHxRxDs+/4EfeyHHut
O9DK/7W8E/Q3X7+dYu6hA+zd6LE+4k4u0Bz9nZT3aXdWpL8fzWkV31pk8Q3q
M49twPMQCs3vJ7X6cQqt/peGO1+Oe5+M4ajANJTI2Y1D8nbR/wHqW/QK
           "]],
          "0.15`"],
         Annotation[#, 0.15, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1H1M11UUx/GDbgnlQ2QEImKIhUhrqWmraUbWZplOyNky56y1OQdIpS5W
bZbhrHQ5C4G5jBSdZKQ9TKhZrEzMyII0axkMURtZYpl/tMi01++PN597zzn3
nof7/ZHzWHnxsqSI2ODPzvSIvIKIJtp3XUTzuIiDaMBF+2dSIzLzIkroxtyI
1dh+bUR+JjsKr46ocHbP+Ii1dHNWxDqMED+drZptYnZE9oiISddE7OabkRHR
f2NEinvnj41oFZt3Q8Rn/Bn0fTqD75E09SV8YjJwyJmPce+oiP3uHDtcPeKX
4x77x6/Xg5y1zvSrM8WZ1WzL8SF/uvvyrZ+X/9VEDfp4WXwye5GcaSMjzrLN
pkvZBtFi8f36vMW6TQ8/opevVn3H6Q7aa1bHsVDebveVjI44QitoETaocxF9
OMd8zXQCX7+5nXHnFc7crac5mIz58r+Aueyt8nagxn4F33q6ijY4+4Q6Bujx
7zFqRiZfu572y7OE/yPnFtEDbDPNfDo28a3HeXX0e5eBzvVbH82P+B5/Wv/D
/gfd4Wyj+pZbn1LzU/Q0XUGbzHUvtul5Kx5wzywk87/jzC48p7ZncZe5H2Nf
K65cTI23qsVv1mdQL08v/RUlKMV4tnNiCugy+zJU22/CJ+b9KSZ7l3GJd3N/
sVp20Uxz3knfRgOODPMuavkZU/XVRTvR7tx/zl9KvC0u4l98J36vuR6mt5vb
GutK1Ps2etx3Et34Badxm7p+F/ut9zxlf9mMi9T4IIoxl62Mr0h9f3m3XHlH
+611ytWshya8Lq4Ki931KPL0PEjsVWyDcSWGYgi28pUm7kSKfTLq1FbuTbrM
eB77V9aFcrTRbXreJ389/cL7nhTzlnfooaX2ZWjFAaTps5124E0xdTgh7nM9
dSfupnVmV6eGh8QOlWsxrZZ/Et9UzLO/H+t8ewvEvetbazHHy97la739gJ7E
t8L/Bv9EfU7z3ebRmXQP+3ZMka9B3YW0z9mj+jyLEzjn3CoxPfQmMbvF3KfX
TLmeFjtH70OsF9Jb6UCaR4eps847NOI1TGNfQyswxbsUqLOErcV7FujzPXqz
Wkexf8n/Itsr7rhDf7Nor3or5f+JrhSzBFnetc1+i9m8pKYaXPAbOI0tfI1Y
zzdYncP9DxuDer1/gINijmGj3/0C38VSNNs3oIp/n3tHqm+2elvE3EnPsXfj
pH2H+Z+nqerrdO+T3jxbfYfNaSVfJQbwXVBneuL3ZX0JWeb3jVx96EKVd0/S
X6rvIAdJKMQE5LqzG4fc207/BzyxA/k=
           "]],
          "0"],
         Annotation[#, 0, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV03tM12UUx/FDzXJdCY2LSIraT8K1vOAfCjo0t9LpwsxNJGtZaw4rzUvo
2jDFKZdqGAEr0T+gxcy7GWtt6No0ZzVdThykI1yNbEIZlRsrXS/+eP8+v+ec
85znnPM83+yVa559IykiNvr5NC0iMSniC9qXGtGWE3EarfjXevNDERkTI0pp
7fiIrWgZGZEzih2FyRFl9h7KjdhBPxodUY108bPZ6tmmPBKRlRExNSXiIN/c
9IjBRMRweZdOiDglNvFoxEn+NHqEzuVb/rD6hnxi0nDGni8xLyviaznHj1CP
+HV40vrlsXpwZqM9g+ocbs9WtnU4xp8qX47/W5z/3lAN+qgUfzd7kTNHZkZc
Z1tIV7HdRReLH9TnE/6f1cMl9PI1qq+LfkJ7zaoLJc7tlq90TMQPtIwW4X11
rqDLss3XTCfzDZrbNTmH2TNHT4uQh6XOfwfPsJ9y7nk0WK/nq6HltNXeNepI
0uPNcWpGBt85PaXTDXrdp5/19DO6kR519hG8YP4nxLdjwBxXup/jtEjOJjn3
4E55dtOP0fFgRL7YmZiBC3repe7aodrtuaX/5/X0H11Bb9MSWv+YXuSuo8/R
D+kH8l1Ty2/4Fb0IZ99Q4019TZT7H5qgeezT0CLmdff7GlbjXbZX1PG3e1nu
nAFaTP+iVWqq4a9GJZax/8neLP8mef6gb7P/TsusV6tni3U5eqw30QpsQ47e
Kvh3+r8D2zHHPW42m+DrEv8jOnEFl9HM3kEv4SK63Hkn1pp7oW/sTdqtpiZv
ZQ+Oe58palniTkbQWWqdjZkoQD4myHnMG/gcL6mnUdwv/u+lV2meetqccY97
H+bM+/GiuHr+qfLmY4n1fFSLL5bvgPh2+27r51uz7EAPFvDv5p/iDgrkS9Cn
6CH2FkxXe6u3W0j77L3gPq7jJ/TbVy6mh04Sc1DM0/rNcNZbYhfp/z7/S+g0
egdN0AfUudcc9mMXCti30zJM9w5y1VnK1u4d5rrfw/RxtY5m/4Z/G1uVHDP0
t4D2qrfC+Z1D34GYV5Fpjmetm8xmp5oaMODb+RlNfPtRw3evOlPcczaa9X4U
p8VcRK3vsdjbXoU261bU8X8l7yj1LVRvu5hZtJ+9G1etz5v/DZqsvsvyrvUt
ZKnvO3PawFeBJL4Bdaay9ft/C5nm972z+nAFdd5L6C/ZdzQWgUJMxjg5u3FG
3nP0f4jG6ds=
           "]],
          RowBox[{"-", "0.15`"}]],
         Annotation[#, -0.15, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV039o1VUYx/Hnrh9SU0xtc86Vbnpd00itBZLF0km5ZihqaWIKi7D5h8PW
RkWWLTZbFIqoSCLkxP3htDQaKi4zNbFCqTanFXebwki3QS0yRhTrdf9438/3
+XGe85znnJtfUbV0QyIi1vs5MD4iOSPiC9qfHdH6QMQ5NOMf9utjInIKIyrp
1ikRm9F0b0RhLj9K7omotfbw9Ih6ujsvohHj5T/Bt4Nv1v0ReRMiZo+NOCQ2
LydiaFrECHWXT404KzeZjDglnk0/o/PEXsjSXzomJxvnrTmG0vsiTqtZME4/
8jdiPrtisjPYc5c1Q/ocYc1mvo04Kp6lXqHvt+3/YboH59gi/07+xfYcNzGi
j6+cruO7gy6RP+ScD/m+4AyX0Su2S39X6X7aa1ZXscq+KfUqJ0X8QGvpYnyk
z9V0Rb75mulMsSFz+0vNM+xl1lYXRLyKTHdRL7/FmRroTfEW+TdojfW/0Q49
XbH3Tnt30p/429GJy+jAKFTJzVR7Ay1QN0f9ztERF9UbKZ5hjgmUit1y/jPq
nsXXaFL3HfUr9Pgl+xTacBpfIUP/B8QStEzdR9W5zT7XxIrd+YtFEWuxBgn+
42pl0B7xS2p302Cn6DC7i2ap87Oaz/Ov9k5W0C3sBrwkVoFG+zzH/4f8Oe6w
y70+aU5v8r+FTahjLzDvUrzBLmGn5H1in3r2PnrS+mz+ffzrzbqJ1ogN6vc1
+ied5mzH1UjS/fZ61tuYKi+Jv/mOeAvteisz42ewEJ/rrTxt006xctrv/Syy
9nr6PdAp1l/zfUuNAt+vqNMnZ6876KGP2KtV/C65t4uPxBo5O8Rnm8tjWMpe
iEb5K9Vpkd9m3X/O9K05daAbZeIfi8/yv5mrXpI+RQ/zN6FYf83eQ0m6T2t/
NIs+dGHAuk1yuul0OYfkPO3d5NirRu4i7ybT9yr6ME3QJB2lz73+ewexDXP5
36O1KDb7In1W8rV5i0Vm9Cl9UK8T+b8Rf5fvfTXmOF8Z7dVvnf2v0Go5LyPX
/V1g7zGbBj3txKD//HXsETuID8Tu1ucY9zk5fe/OfgTn5LRjq//rSu9yHVrZ
zdgufkLdCfor12+bnMfpAH8KPexL5v87Ha2/X9St8t7z9PedOVWL1SHEBvWZ
xTfg+1/kmt/39urHr9junQyn63hrkzDMLqEzka9mCufVvUj/B8/M4WQ=
           "]],
          RowBox[{"-", "0.3`"}]],
         Annotation[#, -0.3, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV02uIzmkYx/FLW1pL1jJHY80MjzEog9kSuzuGcogip2WScj6fEnmjzEy7
7dhiE9uGUZSJOTnNJDVtipnWypQo5xmrvJiDRE0ka+znefF9fv/7uq77un/3
4clds3PRjj4RMdfP2fSIxLiIBtqVFtGYH3ETVfhgvO+biPTREZvo4ZERB3Am
JSJvqDiKBkXsNbdubMTP9M9hERVIU/+D2FGxguERWZkREwZH1MoVZ0S8z4vo
q+/iRMQNtYlREX/Jp9ILtFhueSp/yZyaVLSYcxUzvo24rmfuEH7U78J049U5
9mDNP8x5z2dfcw6I7cIl+RT98nyPQo65F8Sy6UWaMyKi7euIHkzjecsYHuhW
mkJvoF2/tqQX3z3OZ6N5W/BZrBefsNl4O/8Fajbwss13iT1vpeuNO8TP8bFf
3Tux5byXoIWnZpTa94Yse7HuGqzCOqzFW/VL1P6EpWjldbXa27RDvlDvU3qv
Epvke6lzXoKzxl3mlruDSvm63Ih6VKMWNahQU+ZcS9FsvMjdPxJrML6CTLEM
LNZvhf2Uy6fRVv2e8P0Uj/EKM7ynbvqdM+3k7Rbu2Huv+g6cNKeRlwbM934u
0ysocxfF2XzZ23kcEvvNuMP8Qr0O+v5kfqe9PHR+RepL1fyYvEO6k8/5PC5A
nvxo5KNOrj65lndbQ//Vpw091s6V3yjW6S1X6vucTrLHRvkv1X8h3x8r1RyV
n2D9KVhoPBsV6pfpU6O+ybz/eLnF6320Y478cfkC73aqfgk6k9aJn0Ghc6xy
NkW0y9y79t2JNnSbt19NOx2jplbNLHtLt9YetfOc81e+S+hEGjRBB/BZ6S1W
43dMFS+ne1Ho7PP53CTW5Fzz3XE9HcfrUPFm+VKxX/WYbH9z6Et+y6z/gO5W
sw6Z7vdv4xPO5heejuGN/9wLnJCrxkG5fnwOci/ZOG3vF3FTzT0c9j9dlnzv
aDSuwhH5a/pm8DeX3yY139Nu8Wd4btzq/F/Tgfw91neHt57F3z/OabdcGT7z
+AYpYt3qPiLT+d22Vhee4Ij/cG+yj//OcPQaF9HxyNHzGVr0vUP/BzzD0BE=

           "]],
          RowBox[{"-", "0.44999999999999996`"}]],
         Annotation[#, -0.44999999999999996`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{5527, 11041, 5528, 4838, 9548, 4837, 9549, 4037, 9546, 
           9547, 9543, 9545, 9544, 4036, 9541, 9542, 9538, 9540, 9539, 4035, 
           9536, 9537, 9533, 9535, 9534, 4034, 9532, 4836, 9531, 4835, 10106, 
           5525, 10105, 5524, 6226, 6225, 7006, 5526, 7380, 7381, 6127, 10705,
            6126, 10706, 7007, 4041, 8721, 8720, 10586, 10585, 4885, 7472, 
           7473, 7474, 7891, 7890, 4094, 8431, 5712, 8430, 5713, 7075, 7074, 
           7543, 7542, 8488, 5775, 7650, 7651, 4233, 7127, 4232, 7648, 7649, 
           8002, 9642, 8001, 7601, 6545, 4883, 6669, 4882, 6542, 5046, 8072, 
           5047, 8075, 4840, 6742, 6743, 6527, 7533, 6526, 6574, 4129, 10310, 
           10311, 8525, 8529, 8528, 4923, 6892, 6894, 6569, 8159, 8156, 4339, 
           7712, 6502, 6888, 4763, 6878, 6193, 8115, 5127, 7682, 7690, 6492, 
           4754, 7215, 7224, 6480, 6470, 6791, 4182, 8105, 6330, 5115, 8903, 
           8914, 8925, 6727, 4248, 9774, 5177, 9763, 5188, 6827, 6816, 5682, 
           10916, 5693, 5097, 9679, 9704, 9692, 4330, 6779, 4317, 10792, 5802,
            8517, 7958, 4979, 11082, 7945, 11096, 7984, 11007, 7971, 4619, 
           9371, 9384, 9358, 11065, 9345, 9332, 5426, 6183, 11111, 4026, 6951,
            4012, 8746, 6169, 5571, 7039, 4742, 6454, 4679, 5347, 10880, 5333,
            6257, 6243, 8216, 5318, 7833, 8580, 8595, 9199, 9184, 8345, 8360, 
           7816, 4872, 7439, 7454, 9887, 9902, 9154, 9169, 4493, 10070, 10085,
            9139, 9124, 9872, 5303, 11031, 9289, 4538, 9274, 9962, 9947, 4574,
            7372, 4589, 6413, 7640, 5997, 10778, 4296, 7281, 7296, 6398, 6383,
            4115, 6634, 6650, 5656, 10185, 10217, 10201, 10384, 4605, 10509, 
           10525, 10493, 10557, 10541, 5919, 6107, 10948, 6091}],
          RowBox[{"-", "0.6`"}]],
         Annotation[#, -0.6, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{5514, 10904, 5515, 4825, 5512, 10903, 5511, 4067, 4001, 
           10725, 5513, 4830, 5518, 10905, 5517, 4068, 4003, 10727, 5519, 
           4831, 10099, 10100, 10098, 5520, 4069, 4005, 9530, 4833, 8753, 
           8754, 10101, 10102, 8368, 8370, 8369, 6525, 4033, 7399, 7398, 8376,
            8375, 8398, 5580, 10230, 5705, 8797, 8798, 8799, 7125, 8796, 8795,
            7539, 5704, 8426, 4884, 8378, 5530, 8377, 5529, 10109, 7004, 7005,
            5711, 8405, 5710, 8429, 8487, 8486, 6670, 4093, 7470, 6264, 5629, 
           6544, 8502, 6543, 4187, 6529, 7612, 7610, 8193, 5048, 8424, 8425, 
           7532, 7534, 8566, 5896, 7767, 9427, 6571, 4922, 6983, 4921, 6893, 
           6568, 8158, 8155, 4338, 7711, 6501, 6887, 4762, 6877, 6192, 8114, 
           5126, 7681, 7689, 6491, 4753, 7214, 7223, 6479, 6469, 6790, 4181, 
           8104, 6329, 5114, 8902, 8913, 8924, 6726, 4247, 9773, 5176, 9762, 
           5187, 6826, 6815, 5681, 10915, 5692, 5096, 9678, 9703, 9691, 4329, 
           6778, 4316, 10791, 5801, 8516, 7957, 4978, 11081, 7944, 11095, 
           7983, 11006, 7970, 4618, 9370, 9383, 9357, 11064, 9344, 9331, 5425,
            6182, 11110, 4025, 6950, 4011, 8745, 6168, 5570, 7038, 4741, 6453,
            4678, 5346, 10879, 5332, 6256, 6242, 8215, 5317, 7832, 8579, 8594,
            9198, 9183, 8344, 8359, 7815, 4871, 7438, 7453, 9886, 9901, 9153, 
           9168, 4492, 10069, 10084, 9138, 9123, 9871, 5302, 11030, 9288, 
           4537, 9273, 9961, 9946, 4573, 7371, 4588, 6412, 7639, 5996, 10777, 
           4295, 7280, 7295, 6397, 6382, 4114, 6633, 6649, 5655, 10184, 10216,
            10200, 10383, 4604, 10508, 10524, 10492, 10556, 10540, 5918, 6106,
            10947, 6090}],
          RowBox[{"-", "0.75`"}]],
         Annotation[#, -0.75, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV0ldszmEUx/FTiRWxtfZ4UTrs2I0RI5UIEaHEhdHqhRDFjV0juCFCJBqj
Si+suBGpVCVWjJCIGrEjQdLWukAIWuLzXnzf3/uc9Zxznn8iv2j2ypSIaOMn
MzUip2vEty4R3zG0Y0RpIqIMx7CAL6NdRH3PiAb8wh/8xow2Eav7R6xTY2Gv
iPV0G7YiX85aOhlTsDjLXWzT/c+ix9MjTqAMhe0jGqmXgg99Iz7jEz5icY+I
ArlLaFrniEXZEdnyq7pFHO4UcQQr5JfSo7jMXsCfJTZfThc6wPkKexn/cWwS
X05P4Cp7L/4J7i5mH0c30/G0ubuG+79PjyNotXoLekf0NvcTe1nT3fxYhdn2
Nku92tYRrcW0Ql5mxHzMw0X7qcAB8z+jz/E0abO/erYLNFfONAxWr8ruL+Ef
31iag1EoSYsYlhGxzFwhf0MHM4vfSOd6vzl4qLdHaK6nPD3PR8KMP/lSzfuO
vsdYtX+YcwydqNYpNV86fzVfDzlLnWvEHZL7mg4233n+xu4K/mbJfYjZxz9Q
3ZGY6TwFO5O9qHNKfKW83/Z3y2zVeIWp/Af5B/Qzl3oJOomeYT+GIeYs9+45
tFbufW9Qg5eok7dezCvaT8xpMZPtpoO7Voud5t2a+p9HB9G/YhLJ99TnId/U
SezBKP4tdA2G2EG6PgvZKr1huv2dpRl67ch+nX8z2w41hptvKn2r32K1H9Mi
MUuQZo83nUvsZrue9uNLn4g3KOE7iV18TfTZ0rt1Q6nZz+GamAfY3dbufA8F
OO9cjr38Feqm6i9Xv5ViRtM69hd47XzP/j/RFvp7qu5y799Jf7ftqYivGA16
/IK2bHXifiHN/u64qxbPsNf3VZ+s47vtinrnHJqN7mq+wA1179L/cLGmQw==

           "]],
          RowBox[{"-", "0.8999999999999999`"}]],
         Annotation[#, -0.8999999999999999, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV03loz3Ecx/E3udKKjZnbMNfmTK4RxiLnH+QPSmbmyDEUEhu5InL94Spk
NEf+MKIJOXKE5MoYo1Cs5A9/GBri8fvj+Xt938fn/Xl/3p/Pr2P+0imFdSIi
w8/L5Ij5GRFLsKBzRCFG82V3ixhH17BXYG7XiFk41zLiSbOIBpkRa5tGrE+N
eJ4SsZhdSZPFs5pHJLGviI8Xv0lT2P34n3WIONolokCNFXwP20U8xQY5ndtG
bKUHOkXsRWZ3PWK1uoPpcCTrJQ0V8q61iSjqEbERq7AL27BI7cv0Oo6ocwJn
0EP9q/QSzmFXi4i+aq5TP5ceZ6er3RU9cUf9h+jOP1OPBViIpNb2QIV9htKq
xFnoWXrf2T7QK/QtvU1zWkXU0jrOX0Pr0hz5I3HenL+bURmtoRfoMOvWWPNR
X4fs/4O/iL0WM5xhLuZhdlrEvY4RefSCs7bi+yP3ohrHrJvNzkOJ75T2Zocm
GGLNYBxTv0YPJXSh2iPEJrnzielUnQl0cuIbxXr+6+6KaF32evN7xR7PfkEn
0J90Ff1BV9Lp3ss395Svdju159BP9jtovyra21spk1tP7j9zbShnupzd4j31
PQCT2KOxWf5UtU7KL7fulxnd0cMTvEGu+D7xLHsOVC+d5tDT/EfQxx2WeG/Z
9LO1j9zDJ7xGtXWr5byhXeSckjPKfJrZa5ncsVneu+9ptBf9IyedNtLnQf+b
UuzAQPF1dDn6mF+GPgv4ypv4dgdnaDe9tuC/mbhTvk1q9He+XPpev8VqP6eF
cvKQata32fvNZoOe9uCrt/kO+8VKsUWsvj6TzLANDjv7WdyQ8xjb3elUbyIf
ZewS7BS/qG5z/Y3Rb7mcQbSavxJV7Afm/4U21l9F4u17Z2n6u2tOhWLF+K3H
r2jKVy3vJ1LN7569PuMldvpv1SbqeKOtUcvOpploq2Ylbql7n/4H7VizJA==

           "]],
          RowBox[{"-", "1.05`"}]],
         Annotation[#, -1.05, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV01toz3EYx/HHOU2MzZwNs7HNKYym5LAsygXjQhExkcNQ0pxzFjklp3Jo
ZMgFFzSnHNpoJKdsxlJcsJJbp6Hx+l+8/5//83yf7/N9vp/f79d3wcqiFc0i
oo+f2o4Ri/pHLMfijIgSTJTLHxAxma4Tr8bCrIi5uNI14nlKRKuciPXJEZs7
R7zqFLFMXEeTreekRiSJb1mfYv0+7SgeJv8yPeJ0ZkSxHqvlnvSKeIEtavr1
jNhFj/WLOITsgREZKNV3NB2LZLOkoUbdnR4RG7IjtmIN9mM3lup9g97FKX3O
4RIG6n+bXscV7E+LGKrnJv0L6Flxut6ZyEWV/k8wQH6OGYuxBEndnYEa54yh
9Ym70Mu02t0+0lu0EvcwvltEI23CN7TmY3NcU3dC/6t0nP3Zev/qEFGu/i8t
NONgucIuETf7Rvzm5Rn1jXLfccxcefKVPO+Z8E48Q59pKONPg/3JvSPa8f0G
30epG4114ut9Ig7rd42u9axLMVvvwbxoUvsPK824AmvVt8/lk36bUWttuNxr
OoK+ofP5tQDTzVGEGrPs5OlruovWm6nanfKc38KeJvO3Ntssdz3gzFx7RmKq
eCK2qy9yh3K9K+z5yaMqZz/HOxRYP2I9x3x5+qXT8fSi/CkMcW6Z9yuffrb3
Kd8/4S0a7CtV8472V3NBzQQ+dkrcWW2hu7byfyYdRP+oSadtzHncd3Iee5GX
8ISuwhBeZpizWK7CPTN4eYlmmbWz/H3rG+S26THc/QroB/Nu1PsVLVEzD6me
R6X4KG+2mOkgvvL1PY5aO48d1lqaM4mH3XHS3S/jnppn2OO7LfI85+OquAz7
Eu+bvinmm2TeCjWjaIN8HerFj/n/hbY1X03iXffepZnvIZ9KrG3EbzN+RYfE
+6XuB1L598hZn1GLfZ53Y6KP768bGsX5NBs99KzDA32r6X/fcLG0
           "]],
          RowBox[{"-", "1.2`"}]],
         Annotation[#, -1.2, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV02to13UUx/EzMokFzt3KbbrcTXc1ghkTRG00CrRkk3wSXZgUu/xVGKLm
hVlSpBtKOLNaorKV+EBxxswiF5tiYluONpYz0Ac5C5/0QKvNCHr9H7z3+X/P
Od/P93zP77uCxs0Nm1Iiosif8fSIt4ojWvF2UUQCz4nVLI54gW63bsOGRRGv
4fS8iJHMiFnlEe/MjdidHTGaEdFiPUHT5MuyIlKtL8i/KD9A51o/LX79qYjP
SyIaebSJXV0Q8RPa1RTMj3ifHi6MOIjS0ohCbOX7LF2ONL1kY0zdt3kRO8oi
9mALOvEBmnmfp9+hm88JnMRi/t/Qr3AanU9ELOG5i38tPW6dz7sY5RjifxWL
xF/VYyOakJrrDIw5ZxmdTN6FnqJX3O02vUAHcRErcyKm6X+4j0fNMQXn1B3h
f4ausL+U9z9pEb3q/6V1eqwUq3sy4uuCiBmzPKp+WuwBDuurWnzQzPPcbQEa
+KzFlL319HEzf5m+hL5k3+on7WuiN2kL/Yhvgm5EKz41i0+wxvdftjBiNX3D
t6rxu0XfzdiIBFqxXW4bfvaGfldTyfcuraDD+i2nP9IqM52fH9FjXce/Q4/7
0WcmZ9Hlzb3i7uvxp5mspp16fg/1vnevt9Pvrn/LDdk3ghuolT8kX6aXavfN
pyvpl+LdqHLesWT/9I6915z1G37BlH1b1dygRWq+ULPKDNKdtUltXYW37vc6
WkEfqsmns72Zj923B/tQLb+LbkaVeRbqs1Gs33csdPeTtESvWeID8jvE3uXx
jDvW0lv63cl7lCbUvI5MMxy07jKzdj0dwD0z/BVdcj3YK/eIPlO9hxx85u6n
cFHNMD707erN9U2csT6GjuTb45uhv+f1269mKZ0Sn8Ck9Q/e0h/0Mf2NJd+9
N5itv0vmlJDbiRk93sMcsSl1fyHT/C476w7G0eE7Tyd9/C/Ow7R1DS1FLs8J
fM/3Cv0f8AGy1A==
           "]],
          RowBox[{"-", "1.3499999999999999`"}]],
         Annotation[#, -1.3499999999999999`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV011sz3cUx/EzJtILD61aPVX7V1qtWVgtJJiJbm61xhCL1EOKRkUWGe2C
CCFEFw+TKLGlRFx4atcO8VSkGkG7VGrN2C5oIu6k7VpbduH1v3j30+/5nt/n
nO/5fv+J1ZtLKj6IiGx/nqZGrJ0YsRHrciLK8YXYzLyIr+j31luwOjdiJS6M
ing8ImJgQcS24RE/jIxoS4vYYN1Bh9qfnB6RYn3V/kL7t+gw60/EW7MiTk6K
KOWxRawlM+IJdsjJHhexhx6bEFGNvMkRCWzl+xmdjaF6SUe7vOtjI7bnR+zE
dziIvVjPu5HeQA2fX3AOufyv0XpcwMGPIqbyrOI/n/5snck7B/m4y78Fk8RX
6LEUZUgZowba1ZlFO5Nnoedps7P9Ta/SJtzE56Mj+un/6MaH5hiok3ec/0U6
1/d5vPuGRZyR/x8t0uMUsaKMiN8SEe/M8pT8frEeHNNXoXiTmY9xtkY+DXwa
6CVzvow+eRVyapzvufyS8RGL0cbnS+vDZlTM/2u1lmApenksp8vwDRbK+yf5
HujvvvvVW6nHC+uTfPNpt/1e9KBS/dlqV9E5tJC2qvkpLZ6itv9b9HRH7TVq
31GjCXdR5hxH3O2P5jRdfjWdRnuc/bT30k071bus/hXU4YmeWrGI11ue2b6v
cYYs2uH7V75/SF/iGbrEt9r/g07geZbfPP0M1+smuUV6HOj/ElpA/5WTSQd5
Jz+pV4v9KLRfRSvwsb4S7qFUrMHdJfRzjk50phHit+xvF9vFY5r7nU//8nuo
5N1Gy+V8i7Rss7A+akY79HQIb7zFP3HUXi122xugzxR3OwonvKXzuCnnEfb5
3S5yD6tw0fo0DiTfG99U/S3Qb4OcGbRLvAOd1g/M/jUdrL/25Fs3z3T93TOn
cnuVeKfHNxgi1iWvF2nmd1+tV3iKA95Ef9LHXWSg33omzcNonh24zbeZvgcG
3LeV
           "]],
          RowBox[{"-", "1.5`"}]],
         Annotation[#, -1.5, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV01toz3EYx/HHae3CYQdsGNts5pwLbMzZ4kIicyiRnHLYBUtiIyRSRDQU
k8mYQ3aBzYjJ2YXDamu1FCVquZVsORSvXbz79Bz+n9/zfb7ff/b67cXbukXE
X7QkR2zIjdiKjTkRJZgllz8yYh7dJS7FuryIVbiVHvE2NaL7mIjdSRF7B0Q0
pURsEbfSPuoj+0ckihvU56s30r7i8fLvMyMqR0Ss5VEq93poxDvs05OZEXGI
nh4ecQJ5oyKysJPvJFqIPmZJRbO+B0MiykZH7McOHMNhbOZdTx/iPJ9LqMEI
/vfpHdzCsYER43ju4T+bVokzeA/HKDzl/xq58ivNuBabkDjYN9DsOwW0ress
9Dp96WyfaAN9gkeYMSiig/7Bd/Swx3/0tr6z/GvpdL/P4/2zX0S1/l+0yIxj
5IrSIu5lR3Ta5QX9v+UqaZ3cHLW7dC6tpwW8zqhNodf4zBwWscA9TnefC/1+
Gp2JGdjtPjaZZQs2Y7IZWtzPVBRiCgrwy94+21GNma+hGldxBRnuYbl5VqCX
OAE98cIsp+x/sbmK1ZZiGTbwWupcxViCReon9WV5NzfUbiLd3GkYhF5mGuIb
VeqP1RqRaZbsLPeErC7lk412O8uhKXobnbXMHg7oncBnNv3ovOXeXBMt0bMa
yX7/RFxhT/vMfBzf3P0HVKhdxkG1bvaZaP40nLOr63ik5w2O2O9i+1yDWvFF
HFW/zTdprLvx36rTM5F+lW9Fm/iVs7TTBPM1d70tu0g13zPnLVErR6cZv6G3
3Fd9P5DsPT73rS9owVFvt6PLxx4HokOcT/OQzrMVj/m+pP8BRX+WIg==
           "]],
          RowBox[{"-", "1.65`"}]],
         Annotation[#, -1.65, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{4561, 9314, 9320, 9059, 9065, 4414, 10037, 4420, 9077, 
           9071, 9824, 9818, 6314, 5066, 10753, 4214, 5498, 4813, 10855, 4819,
            6156, 5158, 10759, 4277, 5445, 4283, 10765, 5164, 8140, 9625, 
           4959, 10863, 7621, 7627, 4220, 7198, 4226, 8850, 8844, 10277, 
           10271, 4723, 10291, 10297, 8972, 8978, 4304, 7095, 10615, 10621, 
           10609, 10633, 10627, 4966, 10675, 10681, 8856, 8862, 8868, 7204, 
           8886, 8880, 8874, 5769, 10283, 4729, 10303, 5789, 8987, 8993, 8999,
            7103, 7109, 5667, 7512, 7519, 7525, 6663, 6758, 5072, 6764, 6710, 
           4126, 6662, 4125, 7518, 7511, 5666, 7102, 7101, 4310, 9647, 5030, 
           9646, 5029, 10689, 10690, 8984, 8986, 8985, 11043, 5982, 10672, 
           8824, 8825, 7268, 8828, 8827, 8826, 5983, 10750, 10673, 9475, 4722,
            9474, 4721, 10225, 5665, 8336, 8337, 8335, 8334, 7416, 4829, 5516,
            10726, 4002, 9529, 4828, 9527, 4827, 11104, 9528, 10696, 10852, 
           6119, 9466, 9467, 9468, 7335, 4714, 9465, 7787, 4720, 9473, 4719, 
           9525, 9526, 9523, 4826, 9524, 5929, 10570, 5930, 10571, 5928, 
           10568, 10569, 10565, 10567, 10566, 10572, 4004, 5156, 10870, 5157, 
           6446, 6445, 4276, 6659, 6660, 5664, 6658, 7505, 6626, 6642, 5648, 
           10177, 10209, 10193, 10376, 4597, 10501, 10517, 10485, 10549, 
           10533, 5911, 6099, 10940, 6083}],
          RowBox[{"-", "1.7999999999999998`"}]],
         Annotation[#, -1.7999999999999998`, "Tooltip"]& ], 
        TagBox[
         TooltipBox[LineBox[{6766, 5078, 6767, 6765, 6766}],
          RowBox[{"-", "1.7999999999999998`"}]],
         Annotation[#, -1.7999999999999998`, "Tooltip"]& ]}, {}, {}}}],
    AspectRatio->1,
    Frame->True,
    PlotRange->{{-3, 3}, {-3, 3}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{390, 185},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->237354432]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8300],

Cell["Compose with inverse function:", "ExampleText",
 CellID->196753002],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"InverseJacobiSD", "[", 
    RowBox[{
     RowBox[{"JacobiSD", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], ",", 
   RowBox[{"JacobiSD", "[", 
    RowBox[{
     RowBox[{"InverseJacobiSD", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5296189],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"InverseJacobiSD", "[", 
    RowBox[{
     RowBox[{"JacobiSD", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], ",", "z"}], 
  "}"}]], "Output",
 ImageSize->{269, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->467165849]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " to disregard multivaluedness of the inverse function:"
}], "ExampleText",
 CellID->785308763],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->81233632],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", "z"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->369950224]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->390870124],

Cell[TextData[{
 "Differentiate",
 Cell[BoxData[
  RowBox[{" ", "InverseJacobiSD"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->715886131],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"InverseJacobiSD", "[", 
     RowBox[{"z", ",", "m"}], "]"}], ",", "z"}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->809586479],

Cell[BoxData[
 FractionBox[
  RowBox[{"JacobiCN", "[", 
   RowBox[{
    RowBox[{"InverseJacobiSD", "[", 
     RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], 
  RowBox[{"1", "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
    SuperscriptBox["z", "2"]}]}]]], "Output",
 ImageSize->{241, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5875746]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"InverseJacobiSD", "[", 
     RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->192074691],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", "m"}]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"EllipticE", "[", 
      RowBox[{
       RowBox[{"JacobiAmplitude", "[", 
        RowBox[{
         RowBox[{"InverseJacobiSD", "[", 
          RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], ",", "m"}], 
      "]"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
      RowBox[{"InverseJacobiSD", "[", 
       RowBox[{"z", ",", "m"}], "]"}]}], "-", 
     FractionBox[
      RowBox[{"m", " ", "z", " ", 
       RowBox[{"JacobiNC", "[", 
        RowBox[{
         RowBox[{"InverseJacobiSD", "[", 
          RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}]}], 
      RowBox[{"1", "+", 
       RowBox[{"m", " ", 
        SuperscriptBox["z", "2"]}]}]]}], ")"}]}]}]], "Output",
 ImageSize->{504, 64},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->410022661]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20875427],

Cell[TextData[{
 "Obtain",
 Cell[BoxData[
  RowBox[{" ", "InverseJacobiSD"}]], "InlineFormula"],
 " from solving equations containing elliptic functions:"
}], "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->322808586],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"JacobiSD", "[", 
       RowBox[{"x", ",", "m"}], "]"}], "2"], "+", 
     RowBox[{"2", 
      RowBox[{"JacobiSD", "[", 
       RowBox[{"x", ",", "m"}], "]"}]}]}], "==", "a"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->554970152],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->135483614],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      RowBox[{"InverseJacobiSD", "[", 
       RowBox[{
        RowBox[{"1", "-", 
         SqrtBox[
          RowBox[{"1", "+", "a"}]]}], ",", "m"}], "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      RowBox[{"InverseJacobiSD", "[", 
       RowBox[{
        RowBox[{"1", "+", 
         SqrtBox[
          RowBox[{"1", "+", "a"}]]}], ",", "m"}], "]"}]}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{520, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->486970286]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22981],

Cell["\<\
Machine-precision input is insufficient to get a correct answer:\
\>", "ExampleText",
 CellID->3979231],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiSD", "[", 
  RowBox[{
   RowBox[{"10.", "^", "5"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->563558634],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->96858820]
}, Open  ]],

Cell["With exact input, the answer is correct:", "ExampleText",
 CellID->260060486],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"InverseJacobiSD", "[", 
    RowBox[{
     RowBox[{"10", "^", "5"}], ",", "2"}], "]"}], ",", "50"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->289346646],

Cell[BoxData["1.\
3110217060782482165338710747419267324690077567971982266157098567088`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->3028337]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3280],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiSD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiSD"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseJacobiSC",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseJacobiSC"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseJacobiSN",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseJacobiSN"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22871]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17363],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "Tutorials",
 CellID->1902]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->894643060],

Cell[TextData[ButtonBox["Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticFunctions"]], "MoreAbout",
 CellID->447616875]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InverseJacobiSD - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 50, 58.0119300}", "context" -> "System`", 
    "keywords" -> {"inverse Jacobi", "inverse Jacobi elliptic function sd"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "InverseJacobiSD[v, m] gives the inverse Jacobi elliptic function sd -1 \
(v \\[VerticalSeparator] m).", "synonyms" -> {"inverse Jacobi SD"}, "title" -> 
    "InverseJacobiSD", "type" -> "Symbol", "uri" -> "ref/InverseJacobiSD"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6543, 231, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->106417767]},
 "XRef-2005-4-26-23-37-1.8558342"->{
  Cell[646217, 11367, 192, 7, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342",
   CellID->715886131],
  Cell[648610, 11463, 238, 7, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342",
   CellID->322808586]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 654993, 11696},
 {"XRef-2005-4-26-23-37-1.8558342", 655150, 11700}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2058, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2681, 79, 53, 1, 70, "ObjectName",
 CellID->24837],
Cell[2737, 82, 779, 25, 70, "Usage",
 CellID->28861]
}, Open  ]],
Cell[CellGroupData[{
Cell[3553, 112, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4031, 129, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4154, 135, 532, 21, 70, "Notes",
 CellID->7278],
Cell[4689, 158, 983, 35, 70, "Notes",
 CellID->60102941],
Cell[5675, 195, 114, 3, 70, "Notes",
 CellID->18175],
Cell[5792, 200, 261, 8, 70, "Notes",
 CellID->58451189],
Cell[6056, 210, 232, 7, 70, "Notes",
 CellID->31226],
Cell[6291, 219, 215, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6543, 231, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->106417767],
Cell[CellGroupData[{
Cell[6928, 245, 148, 5, 70, "ExampleSection",
 CellID->713940417],
Cell[7079, 252, 64, 1, 70, "ExampleText",
 CellID->350008984],
Cell[CellGroupData[{
Cell[7168, 257, 138, 4, 28, "Input",
 CellID->498082285],
Cell[7309, 263, 175, 5, 36, "Output",
 CellID->9880443]
}, Open  ]],
Cell[CellGroupData[{
Cell[7521, 273, 128, 4, 28, "Input",
 CellID->36360218],
Cell[7652, 279, 177, 5, 36, "Output",
 CellID->163072896]
}, Open  ]],
Cell[7844, 287, 125, 3, 70, "ExampleDelimiter",
 CellID->171468804],
Cell[CellGroupData[{
Cell[7994, 294, 297, 10, 28, "Input",
 CellID->501785274],
Cell[8294, 306, 2075, 38, 137, "Output",
 Evaluatable->False,
 CellID->118807388]
}, Open  ]],
Cell[10384, 347, 124, 3, 70, "ExampleDelimiter",
 CellID->76976753],
Cell[10511, 352, 60, 1, 70, "ExampleText",
 CellID->97765718],
Cell[CellGroupData[{
Cell[10596, 357, 252, 8, 70, "Input",
 CellID->404168808],
Cell[10851, 367, 1350, 42, 51, "Output",
 CellID->253645566]
}, Open  ]],
Cell[CellGroupData[{
Cell[12238, 414, 252, 8, 70, "Input",
 CellID->497017224],
Cell[12493, 424, 1381, 44, 75, "Output",
 CellID->471140130]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13923, 474, 216, 7, 70, "ExampleSection",
 CellID->12793],
Cell[14142, 483, 73, 1, 70, "ExampleText",
 CellID->55645938],
Cell[CellGroupData[{
Cell[14240, 488, 208, 7, 70, "Input",
 CellID->266251706],
Cell[14451, 497, 274, 7, 36, "Output",
 CellID->629888079]
}, Open  ]],
Cell[14740, 507, 125, 3, 70, "ExampleDelimiter",
 CellID->268824359],
Cell[14868, 512, 70, 1, 70, "ExampleText",
 CellID->132691703],
Cell[CellGroupData[{
Cell[14963, 517, 241, 8, 70, "Input",
 CellID->866802414],
Cell[15207, 527, 233, 7, 36, "Output",
 CellID->71261095]
}, Open  ]],
Cell[15455, 537, 124, 3, 70, "ExampleDelimiter",
 CellID->36479535],
Cell[15582, 542, 113, 3, 70, "ExampleText",
 CellID->579439215],
Cell[CellGroupData[{
Cell[15720, 549, 194, 6, 70, "Input",
 CellID->632752147],
Cell[15917, 557, 228, 6, 36, "Output",
 CellID->369454230]
}, Open  ]],
Cell[16160, 566, 125, 3, 70, "ExampleDelimiter",
 CellID->688497564],
Cell[16288, 571, 231, 7, 70, "ExampleText",
 CellID->43876107],
Cell[CellGroupData[{
Cell[16544, 582, 185, 6, 70, "Input",
 CellID->271543877],
Cell[16732, 590, 340, 11, 36, "Output",
 CellID->8012795]
}, Open  ]],
Cell[17087, 604, 125, 3, 70, "ExampleDelimiter",
 CellID->255377976],
Cell[17215, 609, 92, 1, 70, "ExampleText",
 CellID->328717422],
Cell[CellGroupData[{
Cell[17332, 614, 251, 8, 70, "Input",
 CellID->617758456],
Cell[17586, 624, 273, 9, 36, "Output",
 CellID->818000416]
}, Open  ]],
Cell[CellGroupData[{
Cell[17896, 638, 134, 4, 70, "Input",
 CellID->658205930],
Cell[18033, 644, 157, 5, 36, "Output",
 CellID->15150148]
}, Open  ]],
Cell[18205, 652, 90, 1, 70, "ExampleText",
 CellID->368884824],
Cell[CellGroupData[{
Cell[18320, 657, 153, 5, 70, "Input",
 CellID->508781695],
Cell[18476, 664, 241, 8, 36, "Output",
 CellID->19374188]
}, Open  ]],
Cell[18732, 675, 124, 3, 70, "ExampleDelimiter",
 CellID->23210608],
Cell[18859, 680, 203, 7, 70, "ExampleText",
 CellID->471035179],
Cell[CellGroupData[{
Cell[19087, 691, 173, 5, 70, "Input",
 CellID->179888293],
Cell[19263, 698, 322, 11, 52, "Output",
 CellID->21097131]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19634, 715, 238, 7, 70, "ExampleSection",
 CellID->6058],
Cell[19875, 724, 225, 7, 70, "ExampleText",
 CellID->120235099],
Cell[CellGroupData[{
Cell[20125, 735, 248, 9, 70, "Input",
 CellID->77454719],
Cell[20376, 746, 1257, 40, 54, "Output",
 CellID->180356385]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21682, 792, 223, 7, 70, "ExampleSection",
 CellID->12314],
Cell[21908, 801, 123, 3, 70, "ExampleText",
 CellID->147991225],
Cell[CellGroupData[{
Cell[22056, 808, 716, 23, 70, "Input",
 CellID->41283476],
Cell[22775, 833, 621597, 10453, 70, "Output",
 CellID->237354432]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[644421, 11292, 232, 7, 70, "ExampleSection",
 CellID->8300],
Cell[644656, 11301, 73, 1, 70, "ExampleText",
 CellID->196753002],
Cell[CellGroupData[{
Cell[644754, 11306, 379, 12, 70, "Input",
 CellID->5296189],
Cell[645136, 11320, 340, 12, 36, "Output",
 CellID->467165849]
}, Open  ]],
Cell[645491, 11335, 246, 8, 70, "ExampleText",
 CellID->785308763],
Cell[CellGroupData[{
Cell[645762, 11347, 106, 3, 70, "Input",
 CellID->81233632],
Cell[645871, 11352, 203, 7, 36, "Output",
 CellID->369950224]
}, Open  ]],
Cell[646089, 11362, 125, 3, 70, "ExampleDelimiter",
 CellID->390870124],
Cell[646217, 11367, 192, 7, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->715886131],
Cell[CellGroupData[{
Cell[646434, 11378, 225, 8, 70, "Input",
 CellID->809586479],
Cell[646662, 11388, 452, 16, 54, "Output",
 CellID->5875746]
}, Open  ]],
Cell[CellGroupData[{
Cell[647151, 11409, 225, 8, 70, "Input",
 CellID->192074691],
Cell[647379, 11419, 1089, 36, 85, "Output",
 CellID->410022661]
}, Open  ]],
Cell[648483, 11458, 124, 3, 70, "ExampleDelimiter",
 CellID->20875427],
Cell[648610, 11463, 238, 7, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->322808586],
Cell[CellGroupData[{
Cell[648873, 11474, 359, 13, 70, "Input",
 CellID->554970152],
Cell[649235, 11489, 453, 8, 70, "Message",
 CellID->135483614],
Cell[649691, 11499, 665, 24, 43, "Output",
 CellID->486970286]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[650405, 11529, 226, 7, 70, "ExampleSection",
 CellID->22981],
Cell[650634, 11538, 113, 3, 70, "ExampleText",
 CellID->3979231],
Cell[CellGroupData[{
Cell[650772, 11545, 160, 5, 70, "Input",
 CellID->563558634],
Cell[650935, 11552, 169, 5, 36, "Output",
 CellID->96858820]
}, Open  ]],
Cell[651119, 11560, 83, 1, 70, "ExampleText",
 CellID->260060486],
Cell[CellGroupData[{
Cell[651227, 11565, 218, 8, 70, "Input",
 CellID->289346646],
Cell[651448, 11575, 233, 7, 36, "Output",
 CellID->3028337]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[651742, 11589, 310, 9, 70, "SeeAlsoSection",
 CellID->3280],
Cell[652055, 11600, 724, 26, 70, "SeeAlso",
 CellID->22871]
}, Open  ]],
Cell[CellGroupData[{
Cell[652816, 11631, 314, 9, 70, "TutorialsSection",
 CellID->17363],
Cell[653133, 11642, 191, 4, 70, "Tutorials",
 CellID->1902]
}, Open  ]],
Cell[CellGroupData[{
Cell[653361, 11651, 319, 9, 70, "MoreAboutSection",
 CellID->894643060],
Cell[653683, 11662, 147, 3, 70, "MoreAbout",
 CellID->447616875]
}, Open  ]],
Cell[653845, 11668, 27, 0, 70, "History"],
Cell[653875, 11670, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

