(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    629125,      11324]
NotebookOptionsPosition[    620048,      11012]
NotebookOutlinePosition[    621738,      11058]
CellTagsIndexPosition[    621598,      11052]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals and Elliptic Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals and Elliptic Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"JacobiSN" :> Documentation`HelpLookup["paclet:ref/JacobiSN"], 
          "InverseJacobiSC" :> 
          Documentation`HelpLookup["paclet:ref/InverseJacobiSC"], 
          "InverseJacobiSD" :> 
          Documentation`HelpLookup["paclet:ref/InverseJacobiSD"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"JacobiSN\"\>", 
       2->"\<\"InverseJacobiSC\"\>", 
       3->"\<\"InverseJacobiSD\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Functions" :> 
          Documentation`HelpLookup["paclet:guide/EllipticFunctions"], 
          "Inverse Functions" :> 
          Documentation`HelpLookup["paclet:guide/InverseFunctions"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Elliptic Functions\"\>", 
       2->"\<\"Inverse Functions\"\>", 
       3->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InverseJacobiSN", "ObjectName",
 CellID->8056],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InverseJacobiSN",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InverseJacobiSN"], "[", 
       RowBox[{
        StyleBox["v", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the inverse Jacobi elliptic function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox["sn", 
         RowBox[{"-", "1"}]], "(", 
        RowBox[{"v", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
      "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18518]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["sn", 
     RowBox[{"-", "1"}]], "(", 
    RowBox[{"v", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " gives the value of ",
 Cell[BoxData[
  FormBox[
   StyleBox["u", "TI"], TraditionalForm]], "InlineFormula"],
 " for which ",
 Cell[BoxData[
  FormBox[
   RowBox[{"v", "=", 
    RowBox[{"sn", "(", 
     RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->14109],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseJacobiSN",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiSN"]], "InlineFormula"],
 " has branch cut discontinuities in the complex ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " plane with branch points at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[PlusMinus]", "1"}], ",", 
    RowBox[{
     RowBox[{"\[PlusMinus]", "1"}], "/", 
     SqrtBox["m"]}]}], TraditionalForm]], "InlineMath"],
 " and infinity, and in the complex ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " plane with branch points at ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["z", 
    RowBox[{"-", "2"}]], TraditionalForm]], "InlineMath"],
 " and infinity."
}], "Notes",
 CellID->51178553],

Cell["\<\
The inverse Jacobi elliptic functions are related to elliptic integrals. \
\>", "Notes",
 CellID->17300],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["InverseJacobiSN",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiSN"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->268397156],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseJacobiSN",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiSN"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseJacobiSN",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiSN"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->15022297],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->505450076],

Cell["Evaluate numerically:", "ExampleText",
 CellID->435904782],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiSN", "[", 
  RowBox[{"0.5", ",", "0.3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->732399037],

Cell[BoxData["0.5306368995398674`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->81309148]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiSN", "[", 
  RowBox[{"%", ",", "0.3"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9511832],

Cell[BoxData["0.5000000000000001`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->73565171]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->623105011],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"InverseJacobiSN", "[", 
    RowBox[{"x", ",", 
     RowBox[{"1", "/", "3"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->379613509],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->384442841]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->119939810],

Cell["Series expansion:", "ExampleText",
 CellID->155193858],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"InverseJacobiSN", "[", 
    RowBox[{"x", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->63397604],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "m"}], ")"}], " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{
    FractionBox["1", "40"], " ", 
    RowBox[{"(", 
     RowBox[{"3", "+", 
      RowBox[{"2", " ", "m"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["m", "2"]}]}], ")"}], " ", 
    SuperscriptBox["x", "5"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "6"],
    SeriesData[$CellContext`x, 0, {}, 1, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
   1, 0, Rational[1, 6] (1 + $CellContext`m), 0, 
    Rational[1, 40] (3 + 2 $CellContext`m + 3 $CellContext`m^2)}, 1, 6, 1],
  Editable->False]], "Output",
 ImageSize->{275, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1005325631]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"InverseJacobiSN", "[", 
    RowBox[{"x", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->468065359],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"ArcSin", "[", "x", "]"}], "+", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "x"}], " ", 
       SqrtBox[
        RowBox[{"1", "-", 
         SuperscriptBox["x", "2"]}]]}], "+", 
      RowBox[{"ArcSin", "[", "x", "]"}]}], ")"}], " ", "m"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "m", "]"}], "2"],
    SeriesData[$CellContext`m, 0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`m, 0, {
    ArcSin[$CellContext`x], 
    Rational[1, 4] (-$CellContext`x (1 - $CellContext`x^2)^Rational[1, 2] + 
     ArcSin[$CellContext`x])}, 0, 2, 1],
  Editable->False]], "Output",
 ImageSize->{309, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->240735698]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19903],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->55645938],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiSN", "[", 
  RowBox[{
   RowBox[{"0.2", "+", "I"}], ",", 
   RowBox[{"0.1", "-", 
    RowBox[{"0.3", "I"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->266251706],

Cell[BoxData[
 RowBox[{"0.09689212763397494`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.8911019500147381`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{147, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->282308603]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->268824359],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->132691703],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"InverseJacobiSN", "[", 
    RowBox[{
     RowBox[{"1", "/", "2"}], ",", 
     RowBox[{"1", "/", "2"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->866802414],

Cell[BoxData["0.\
5356227328054033197042673653904139231723174591529788272034566332981`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11594910]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->36479535],

Cell["\<\
The precision of the input tracks the precision of the output:\
\>", "ExampleText",
 CellID->579439215],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiSN", "[", 
  RowBox[{
   RowBox[{"1", "/", "2"}], ",", "0.50000000000000000000000000000000"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->632752147],

Cell[BoxData["0.535622732805403319704267365390413923172319636388`30.\
841534529575004"], "Output",
 ImageSize->{235, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->789671288]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->688497564],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseJacobiSN",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiSN"]], "InlineFormula"],
 " threads element\[Hyphen]wise over lists:"
}], "ExampleText",
 CellID->43876107],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiSN", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u1", ",", "u2"}], "}"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->271543877],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"InverseJacobiSN", "[", 
    RowBox[{"u1", ",", "m"}], "]"}], ",", 
   RowBox[{"InverseJacobiSN", "[", 
    RowBox[{"u2", ",", "m"}], "]"}]}], "}"}]], "Output",
 ImageSize->{332, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->41582739]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->255377976],

Cell["Simple exact results are generated automatically:", "ExampleText",
 CellID->328717422],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"InverseJacobiSN", "[", 
    RowBox[{"z", ",", "0"}], "]"}], ",", 
   RowBox[{"InverseJacobiSN", "[", 
    RowBox[{"z", ",", "1"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->617758456],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ArcSin", "[", "z", "]"}], ",", 
   RowBox[{"ArcTanh", "[", "z", "]"}]}], "}"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->346357462]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"InverseJacobiSN", "[", 
    RowBox[{"0", ",", "m"}], "]"}], ",", 
   RowBox[{"InverseJacobiSN", "[", 
    RowBox[{"1", ",", "m"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->658205930],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"EllipticK", "[", "m", "]"}]}], "}"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->401719724]
}, Open  ]],

Cell["Parity transformation is automatically applied:", "ExampleText",
 CellID->368884824],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiSN", "[", 
  RowBox[{
   RowBox[{"-", "u"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->508781695],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"InverseJacobiSN", "[", 
   RowBox[{"u", ",", "m"}], "]"}]}]], "Output",
 ImageSize->{156, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->337110699]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23210608],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->471035179],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseJacobiSN", "[", 
   RowBox[{"z", ",", "m"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->179888293],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["sn", 
    RowBox[{"-", "1"}]], "(", 
   RowBox[{"z", "\[VerticalSeparator]", "m"}], ")"}], 
  TraditionalForm]], "Output",
 ImageSize->{59, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->104953947]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29214],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseJacobiSN",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseJacobiSN"]], "InlineFormula"],
 " can be applied to a power series:"
}], "ExampleText",
 CellID->120235099],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiSN", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "+", 
    RowBox[{
     RowBox[{"O", "[", "x", "]"}], "^", "10"}]}], ",", "m"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->77454719],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   FractionBox[
    RowBox[{"m", " ", 
     SuperscriptBox["x", "3"]}], "6"], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["m", "30"]}], "+", 
      FractionBox[
       RowBox[{"3", " ", 
        SuperscriptBox["m", "2"]}], "40"]}], ")"}], " ", 
    SuperscriptBox["x", "5"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox["m", "315"], "-", 
      FractionBox[
       SuperscriptBox["m", "2"], "28"], "+", 
      FractionBox[
       RowBox[{"5", " ", 
        SuperscriptBox["m", "3"]}], "112"]}], ")"}], " ", 
    SuperscriptBox["x", "7"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "9"],
    SeriesData[$CellContext`x, 0, {}, 1, 9, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
   1, 0, Rational[1, 6] $CellContext`m, 0, Rational[-1, 30] $CellContext`m + 
    Rational[3, 40] $CellContext`m^2, 0, Rational[1, 315] $CellContext`m + 
    Rational[-1, 28] $CellContext`m^2 + Rational[5, 112] $CellContext`m^3}, 1,
    9, 1],
  Editable->False]], "Output",
 ImageSize->{341, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->128711151]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14269],

Cell["\<\
Plot contours of constant real and imaginary parts in the complex plane:\
\>", "ExampleText",
 CellID->147991225],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ContourPlot", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"InverseJacobiSN", "[", 
       RowBox[{
        RowBox[{"x", "+", 
         RowBox[{"I", " ", "y"}]}], ",", 
        RowBox[{"1", "+", "I"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
     RowBox[{"Contours", "\[Rule]", "24"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{"Re", ",", "Im"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41283476],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyEvXd4lcXz/52EJEQElN4sFEFBEKSIFN1Dk6oiKoiAKGKhCSoCCqKigCAg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     "], {{
       {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
        GraphicsGroupBox[{
          PolygonBox[{{2130, 2129, 485}, {4601, 5443, 830}, {2081, 758, 
           739}, {4935, 6457, 1186}, {4425, 6135, 758}, {2848, 1650, 1116}, {
           6883, 6880, 2625}, {1665, 758, 403}, {4039, 6613, 1506}, {1806, 
           1186, 414}, {2093, 2510, 414}, {6196, 6195, 2094}, {5404, 4400, 
           739}, {3261, 2512, 2129}, {2129, 2093, 485}, {6813, 6814, 2565}, {
           1177, 724, 403}, {2510, 1806, 414}, {1116, 1650, 724}, {5413, 4401,
            739}, {1839, 1177, 403}, {2081, 2889, 403}, {5229, 4064, 414}, {
           7837, 4825, 3261}, {6861, 4928, 1177}, {2093, 2331, 485}, {4064, 
           6546, 414}, {2564, 1665, 1115}, {2094, 2093, 414}, {724, 1115, 
           403}, {6131, 5413, 739}, {6144, 4425, 758}, {6547, 6196, 2094}, {
           6272, 6271, 2130}, {7104, 4012, 2848}, {4929, 6861, 1177}, {2331, 
           1116, 485}, {6611, 4601, 830}, {4427, 6144, 758}, {6880, 6882, 
           2625}, {2331, 2565, 1116}, {4823, 5812, 1806}, {1177, 1506, 724}, {
           5162, 4935, 1186}, {5767, 4823, 1806}, {7912, 4039, 1506}, {1650, 
           1115, 724}, {4010, 7102, 2847}, {2129, 2512, 2093}, {1506, 830, 
           724}, {4936, 5162, 1186}, {1116, 724, 485}, {4600, 6611, 830}, {
           4408, 6527, 1665}, {724, 830, 485}, {6811, 6809, 2564}, {1115, 
           1665, 403}, {5807, 4925, 1839}, {2611, 2081, 739}, {758, 2081, 
           403}, {2512, 2510, 2093}, {6860, 4927, 2611}, {2889, 1839, 403}, {
           1650, 2847, 1115}, {4925, 6862, 1839}, {4401, 5404, 739}, {6270, 
           6762, 2129}},
           VertexColors->None], 
          PolygonBox[{{6546, 6547, 2094, 414}, {4927, 6177, 2081, 2611}, {
           6809, 4408, 1665, 2564}, {5230, 5229, 414, 1186}, {4824, 5767, 
           1806, 2510}, {6862, 4929, 1177, 1839}, {6763, 4824, 2510, 2512}, {
           6762, 7837, 3261, 2129}, {6527, 4427, 758, 1665}, {6882, 5230, 
           1186, 2625}, {6271, 6270, 2129, 2130}, {5442, 6272, 2130, 485}, {
           6543, 7104, 2848, 1116}, {4825, 6763, 2512, 3261}, {6063, 6811, 
           2564, 1115}, {4012, 5444, 1650, 2848}, {6457, 6883, 2625, 1186}, {
           4400, 6860, 2611, 739}, {7162, 5807, 1839, 2889}, {5443, 5442, 485,
            830}, {4435, 6813, 2565, 2331}, {6194, 4435, 2331, 2093}, {7102, 
           6063, 1115, 2847}, {6177, 7162, 2889, 2081}, {5444, 4010, 2847, 
           1650}, {6613, 4600, 830, 1506}, {4928, 7912, 1506, 1177}, {5812, 
           4936, 1186, 1806}, {6135, 6131, 739, 758}, {6195, 6194, 2093, 
           2094}, {6814, 6543, 1116, 2565}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.34484715620308104`, 0.14682929088184948`, 0.6017047118251869], 
        EdgeForm[None], 
        GraphicsGroupBox[{
          PolygonBox[{{3111, 2655, 723}, {4929, 6862, 2613}, {6177, 4927, 
           1176}, {3352, 2612, 379}, {1532, 2612, 1175}, {1051, 1804, 1049}, {
           6860, 4400, 1663}, {5764, 5765, 1804}, {3901, 5484, 126}, {5399, 
           5504, 126}, {6883, 6457, 2290}, {5808, 4213, 1532}, {5442, 5443, 
           1649}, {2374, 2372, 723}, {2372, 2373, 379}, {1649, 2374, 723}, {
           6455, 6460, 2290}, {5230, 6882, 1529}, {4824, 6763, 1051}, {1974, 
           2511, 1228}, {7104, 6543, 2330}, {6547, 6546, 2333}, {4600, 6613, 
           2373}, {6454, 7557, 2290}, {1176, 1663, 126}, {7912, 4928, 3352}, {
           4435, 6194, 766}, {7558, 6467, 3111}, {1649, 3110, 1228}, {6194, 
           6195, 766}, {3387, 1974, 1228}, {1532, 2043, 379}, {7162, 6177, 
           1176}, {1175, 1176, 126}, {5398, 4386, 723}, {2655, 3110, 723}, {
           5484, 3895, 126}, {6763, 4825, 1051}, {6099, 6100, 2043}, {2511, 
           1974, 1051}, {7837, 6762, 2511}, {5504, 3901, 126}, {2655, 3387, 
           1228}, {1974, 1804, 1051}, {6193, 6548, 2092}, {5765, 5769, 
           1804}, {6544, 6542, 2330}, {3110, 1649, 723}, {6460, 4207, 2290}, {
           7457, 5235, 1532}, {5768, 4822, 1049}, {4213, 7457, 1532}, {7557, 
           6455, 2290}, {4437, 6197, 767}, {6543, 6814, 2330}, {2612, 2613, 
           1175}, {6197, 7179, 767}, {6879, 6878, 2624}, {3110, 2655, 1228}, {
           4209, 5231, 1529}, {6924, 6923, 2655}, {5802, 5161, 1049}, {7179, 
           6545, 767}, {2333, 2092, 767}, {2612, 1532, 379}, {4936, 5812, 
           1843}, {6813, 4435, 766}, {5229, 5230, 1529}, {4436, 6477, 766}, {
           5807, 7162, 1176}, {4822, 5802, 1049}, {6270, 6271, 1228}, {6272, 
           5442, 1649}, {5767, 4824, 1051}, {5075, 4926, 1175}},
           VertexColors->None], 
          PolygonBox[{{5231, 6193, 2092, 1529}, {7989, 3969, 1974, 3387}, {
           6271, 6272, 1649, 1228}, {6611, 4600, 2373, 2372}, {7103, 6064, 
           6063, 7102}, {6613, 4039, 379, 2373}, {5414, 4402, 4401, 5413}, {
           5443, 4601, 2374, 1649}, {4927, 6860, 1663, 1176}, {6457, 4935, 
           2624, 2290}, {6612, 5398, 723, 2372}, {6132, 5414, 5413, 6131}, {
           4928, 6861, 2612, 3352}, {5235, 6099, 2043, 1532}, {4402, 5405, 
           5404, 4401}, {4409, 6528, 6527, 4408}, {4426, 6136, 6135, 4425}, {
           5161, 5811, 1843, 1049}, {4428, 6145, 6144, 4427}, {6762, 6270, 
           1228, 2511}, {4386, 7558, 3111, 723}, {4039, 7912, 3352, 379}, {
           4601, 6611, 2372, 2374}, {6923, 7989, 3387, 2655}, {6467, 6924, 
           2655, 3111}, {6528, 4428, 4427, 6527}, {4825, 7837, 2511, 1051}, {
           4823, 5767, 1051, 1049}, {4013, 5445, 5444, 4012}, {4011, 7103, 
           7102, 4010}, {6145, 4426, 4425, 6144}, {5445, 4011, 4010, 5444}, {
           4926, 5808, 1532, 1175}, {6546, 4064, 2092, 2333}, {6064, 6812, 
           6811, 6063}, {6810, 4409, 4408, 6809}, {6814, 6813, 766, 2330}, {
           5397, 6612, 2372, 379}, {6548, 4437, 767, 2092}, {6545, 4436, 766, 
           767}, {6196, 6547, 2333, 767}, {3895, 5075, 1175, 126}, {6862, 
           4925, 1175, 2613}, {5474, 5399, 126, 1663}, {6812, 6810, 6809, 
           6811}, {6100, 5397, 379, 2043}, {6136, 6132, 6131, 6135}, {6195, 
           6196, 767, 766}, {4064, 5229, 1529, 2092}, {4925, 5807, 1176, 
           1175}, {6878, 6454, 2290, 2624}, {5812, 4823, 1049, 1843}, {6477, 
           6544, 2330, 766}, {3969, 5764, 1804, 1974}, {6861, 4929, 2613, 
           2612}, {5769, 5768, 1049, 1804}},
           VertexColors->None], 
          PolygonBox[{{5163, 6879, 2624, 4935, 5162}, {6881, 4209, 1529, 6882,
            6880}, {5811, 5163, 5162, 4936, 1843}, {6542, 4013, 4012, 7104, 
           2330}, {4207, 6881, 6880, 6883, 2290}, {5405, 5474, 1663, 4400, 
           5404}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.37632947908497605`, 0.2015685480998694, 0.6459569251470406], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VEloU1EUvY1t0pDEn/n3/8TGBgSHRVWwRXBYaF05BkVwIehCFKtxWIlY
FEpbEUTFlQYcFm6kJVJx5QDVrbqo3diiCO4U3RSMQ8VzOM/Foy/v3nvuuefc
357D9drJiJmdwFmE0/TNXpTMZmP4ETcr49xpM1ubM3uF2JV2s6HFZtWE2a9O
s70Zs+uB8vjG2AwAL3lm6ypmPwAzGDUL23U/njU7iPwnaNboNruN8zSJ/qGZ
n1HuaFTxLxHFUjHV9yTEawP4FJB/AFhD6LsNeAM4v8GnEWoG5o0W1I9YLcTK
jgP7H3HvE8i9Fyp/ZAlmAIefyD2HnPM4WeC/R+5gqHryex0Xn17kdeO+AJ5z
ebPnmPk0uO0Dxs1AMXKaAu8Sci4EwiXmALiNe5rlLrD7UfM5oj6zWfUqB+rN
+yfk7g7kxTQ4n81L5+VJ6c47/WqLC3O4KA84L9+oHd8/An8Vauc6wDUNXOqO
2vmU/GxGFFsZk9dVaDLZZfYS9fc75A194W/OxrnGgfcmJxzGx2LSdnVMNcyZ
Rrzf0++j6HkslI4TeHtQUW/qvj8qDuTDO+fqhTa7As3xFji1jDQnx5TjeQM8
G4G4ce8SJc2+FLkb8T7fqVnrafE8lRZv3vsQ/xDKu4eevKFW9OdqoDv9+ePL
I+4cvScH7n0tIV/2IHdnIB9abh7OMgIvvvviuh04F5GTQ04OPQ8VVDuGnMs4
Xkxv9JvvmzOajXNxZ88UpC13ouXwieu5b6SA+Dtf2vXBt3wortST3yZ1pgfE
oy+PkLuQFk4Smm0JhMud5W5R//XgcCvU7GuAWc9rdsan3B5Q+8ddwmVv9iNm
EzNtymkXqBO5cK5ryN/htOI+Tha1d1XXl5jci62BOA9Dgwp4LEPsq6//R/Sd
dSvcPnM+9p1xO8w4Pf3/3XIfitQnEEf+pV68f/OFy5pnnr5n1tLzv873fz8Y
ul0=
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtkztoVFEQhv9djZtlIzfJ5u7uvfuABFS08YURITGFj0LwtShCyqRQIbpG
iWWIkJcIomClAR+lgkQUKx8YbdUiahPRxk7QJmKiRPyGucXAOWf+mfnnnzmd
A4362bSkPmw1tiGUtrdJ27D1nA9H0quy1JmTUllppFWaLUhbMlKZwAsd+KrS
HP6P3K+Cv4YJbE9Kugx2AotJHhDzq+g1LPci50NgN7d5bosp8X4JG8OK2ItA
Gif/uhZpmHxDvPXyNk2uqTVgiD0VS2+JHeI+Rr5dvH2DS563hXbpTOy+Chx6
8Z+jhyL+xWZpZ+A5Lde9JilXkXaU4ISvTk9fiP2KfW7y+hvp9z79bMr42wF6
mCL+6SrndKsmTeJfy/kZnM/j64PP97Rj/oEfjZybcTRtH/K2kHGNrfZx8LWs
c3iJ/0HgWhpmL7GPwM8S+wf/E/AXW30WVuMx9/1g/uJ7Tb67cL8Tey2Ln7N6
gcd25XzWNThWQ5/5u7z0HltJu0YNcvdErpXdT5PrZOzzNM07OOex2ynn+wZu
zwPX6gqYfZHXtFrG6SbYmdi5GCfT8lO762Wa7qb2fN5nYTtWh1MIfjTrnKz2
TM21NQ7LRd8p26UlbA/1JtmXZWotNftujiT62I4Ohr5jtlsDoWvXVXWtDHOQ
+GPUrCT7aNoMJljTqMH8h5P9MT4fqDlf9N0/wQ5dj3yHbHcsxwrYSuS7ZzPr
p9fuZL+spy5qFUKPNc72V8ax3/L+jhB7NPlPpvENzltLXtt2xLSbLvjfMg1z
aN1S9t4txwS9dUc+D/tDP+H6o+izMfx/sxeEBA==
           "],
           VertexColors->None], 
          PolygonBox[{{6456, 4384, 2292, 6460, 6455}, {6526, 6146, 6145, 4428,
            2323}, {6523, 6137, 6136, 4426, 2322}, {4383, 6456, 6455, 7557, 
           3109}, {5505, 5962, 1928, 3901, 5504}, {6146, 6525, 2322, 4426, 
           6145}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.40781180196687095`, 0.2563078053178891, 0.6902091384688942], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lU1slFUUhg/TaadDmbbTaRm+aTsVEwj4RwxKQNJo8GdjIlpAEhIWsAES
EURiAggbiDGEhEg0LEBRdkCCkrrViLIxafjdkALFqeCiCZBAQBIVfB/e28XN
d+6555z7nvece76ZazcNfZiLiG+0mrSGKxGv90YcmBqxPx9xoRixZ0rEg0LE
w2btZXxd3/ZSxD6dn6xGnJb9asnbeyL+7pON5DXyPz0toiH/o1nE11qzi/bF
7/ecY19M8S8VvUfP+UiSl7RF3JDPXtl80B1xots4linekFaT7M4Jy4Rsvwdb
PeKPuvFt7owYzGy/eCBia8XY3pJueEbEjtaIgy0RR3S+Sbkfb/Ie+ZB8v1Q+
byvmWeX4W4c5GJH+mjAskt3z0yOe0xqVvL4WUS0b8yr5lXocZ6HuGiibt6fK
3iO/IPmg5F3yPSdcZyvGcULxXpL8rO76V3ft6HdefP/ptLxRd13pMme3ZDcb
rqX/RfqX5TtH+1LR8cA/s931gMN8q2uL/bey/06rMNV33qz7Xvz6WuybL/qc
+sJ1S5Ifi5MRcTJN8fqUx3/Cdlnyq8pri3L/XP7tkudmvmtUeV3Xek3xr2oV
Wl33V3S+WOue9r+qj96UPCh9v76PFfNUznjIBz4PS/dxZmznS6498faIn5+F
53bBOJ7oFKehnF5UbnO1vyH5T60u+VxRPwxr3Zc82Oa8sacfLydsxAIX9SLG
semOc1gx1tXco/Qqut1T3KfkR49RE7gm9+XCuyIzl9SG3KnjEcW52eXazNLZ
PL2XZvXgJ8rxR/Xnp7Lr0T1DZfflmLBeK1lP78INXJ1SLd7InPOjTnPH2UbV
odLnWnwm7IfqxklNOsrGRh/TQ8g/ib8zVe/B3tJqezjKFT0gbuv8TtVn5N2c
bAqJc/ICJ/nQb0/3Ox8wg515AHbe+v40B8aEa37FXPJuVqe3Q+x8is8cICb8
LBA3q7r8XuGcM/SbldeWzL3CrOEMPX7YPMFTMy9wwrv4Ib2Nr+R3V3mN55wH
fUUu7eJvcIbjzBNn72S24Zz+g3/ij6W6TKQz9Cc73NPIz2SeHfA9yQU8LFDe
43VzQV8yH5HpR770IW/xYXrL1GFZm2uxNXPO5DvZi3BFb25I/ckM483gC/fc
Cw98x5JM7XgD3PWF6vV+2fGZa8wneGbGL8389umtidR7xBwvWgePjVT3nDjb
lXk+8B/AppFqAu/Y/KUabqv5DB1nvJ2dmf3x5X/C7Eb/UebZSm/AA31JLVaW
jRvMcNpIeMC+s2j8vC1qTh3r1LDXOVB/7iY+fMM/PQkHowOOydwjb+4ip0dV
Y2MW5ifPFK83c8z39H03M8aK8uuuGQd1AxMx/wc1jAdX
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlElszVEUxg+dtHR4fX19/b++viJRNTYxVBAhMSxIDK1EIkoMMUTNNsbE
ECwkEolYIC0LCY0ptSVqWEjMNtJWq5MFihBi5vc5b3GSc+8Z7jnfd84dtGJT
1ca+ZrYESUW2BmZbkE3o2ZlmRyJmtflm65HD6I1FZoNLzHb3M9uFzMR3VuD6
lD4I9nOcy4hNSzGrT5i9JraTc9MAs0dhs0sFZvF0s7o0szP4VnLuTvOYZZzX
4L8aWYq+Hf+uUrOrOWZPKbAj12w5dewlvrq/WSn6KmQlkkDG4/8xapZBPeVZ
5OBuVKFZM/4XqaeRXCfI20nTX7LNevK9RtW2HP8u9Nu80U49+dibscfxf0G+
Z9R3gVy95E/jPCzDrBjbrzyzK+R7g2xTzYFjN4fzSfRFIcBM8ZofEvsI+Urs
U+zv0N8j6eRLRVp4rzaGjfjnyCvqaUOO0nsO9cyJOifiYjb6OnzXIvfJ9QD/
HnwrweAY/iN44y+1JQKv7RryiZhqzimZjsFc9AVI3+RZ2LUVw2N/x3BM2GtU
bWXgU8dbC/FPxT89y30bCv0txTTA5ak87/0bGB5nVqbS/xF6rwDjr+Qqp/ah
yBf0KmyPwz4LJ/EZF3JOxeVY9Hv4TOK9z7z/njc66a874dyox5tw1cqbE9Pd
XkrMwRLXha9mpy7h3GqGotg3xBxbYSasxbG4FeaTA+dIsXpzJL2NDjl3mqEP
2A5xd6CPc/aTXm/FfNY0A9oVzbBmVzujXtWTelHPmt0w/nsyPed19uU0vkMy
fafOYrvMGzX0lkHOmojPsGZXO7k/4jMg7vehvyxwjNSvMPhNPdc4t2b4zJ6i
99MJnw3VHEQ8h2KLkLtR51jc9hIzHT5zqLWJXo5zt5geIjHnRjVModaBIcdH
/GqXN+e5rp2egK0+5rVrRrQrb5Pzo535EfUZEPffkZ3k263/A9mBzA98x7Xb
msl5nCtCPpvCpBk+W0p9d7VTiv2RzKUcM5Dz2J9kOwbSL+f636S7cJz+4v43
aSZ3UOufPN8N/VF38K0t8H60o/pbgiRW+mPa4X5nxP+iadgLiK8scmzE6Viw
7Ej436CdrQp8Z7Qr2rn/f0vCd1l/jLBpDDvWwkh/YXOh59afqNm+kevciF/N
inZKu6SZyQWb4YHbxNk/gKLVhw==
           "],
           VertexColors->None], 
          PolygonBox[{{6485, 6141, 6140, 4407, 2308}, {4044, 6522, 6521, 6525,
            2060}, {4711, 6690, 1672, 5490, 4710}, {6141, 6143, 2060, 6142, 
           6140}},
           VertexColors->None]}]}, 
       {RGBColor[0.43929412484876595`, 0.311047062535909, 0.7344613517907479],
         EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlm9olWUYxp/N7ezMc7ZztrNz5ntOO3MKDqKEUKM/pLSC/nycSvTBCoNC
iYnLpdlZJZHQIKEo+iDkNP0QgkgL8qNog2BaIKW0kaX7UzCEirnIWnb9vJ4P
D+977ve+n/u6r/t67uf0bN/VP1AfQjintUzrSjqERzMhvFcXws9V2XMhDOn9
fCWEr7XOyPlAUwhvaw3L/+CKEE4XQ+hT8Cq9v9ylp/aotoWQlf07+efLITzS
GUJNMWOFEOb13tcYwuYkhD/13iz/fEsI7zfIJv89sr+qlWv2qqRCWJC9KNti
PoR+/b7Z5L33CdtW4bwk+ybZayl/v6ZvzwjDJ4rp0R4f6znWHUK33pOs67ys
9WPaNVFvVhi+0fupemNarfWR7BvFx0rFvVtnjNQOTuxrs/62KeO98eE3OcEw
mjE3S+IqL9veWMvYMuOFwy3CdqTsXNQx1+FvO8T3Tq2vlpuftsgRPGIbCO7P
dNU96hP3x/PGRh3Ug524fHzfLN8X251/PtrxPyGuxoRjfeT7yYxxtsr+mDDM
iotPFTtYNi85xbVojQjPSuHNdZq3f5W/kpjfh/Qcl/2c7A9ICxv0+yXtPd7o
J/Yj2nNafTmb9V5gPhWxt0TM5Hs6Y35O5F0nmIk5KvsaxV0Vxt+V61CDOcc+
X+f64IJ99ir/Pq021fiFnsdV2zq9Pys+2lVXrdm40BXYdstnUKs19o0nnNzh
YIVx3VDOz0vW8375XlA/Dta57p86vA/c8Z1+oTm4p+/oiJzUstBkXDf1frLk
eqjlrHL9o5p71e/t7e4f8V3Cvj4x1pTy1HLmFa0dTVlvj6v2Y5GL3gbrHPug
Yt8o26+k954Oc8S5zUTNo4EPU8Yzk3YN4K8q523hmeKMp+2HD/1ZFWPXas97
Stb/VeH9pepewgE9Zh/2RGvv1Lv/ewruJ5ygcfihj5/F87Mm9hX82EZjf/E9
FP3rpYulu/z9ljDmytbSg9p7izB80OAFf5z3BfVwMnG/poRhUuutVmtmPuoG
zoi549/kWpk5nM8DcQZeUK8nOv09J51P5DwHntJ+T+SNc6ewLTIr054ZzAfm
xHPy31b03GLuwiu5DpccT+yi9r6ltTztXo5GzTNrd8R5O5c2p/BJTRejDuEU
HRB3X+J+UxfaYUajH+blcJyZQ0XnJm9r0TOX7xeV/+HEc5c6/oq1cH5mojbA
cTpqiFnIfISH74Xl74pnCmd0Q8E9Yy4V4kxDa+WoJfgbKTkW3WTjnOmOc5bZ
zLzsT6y3UfV2tt2c7C57TnE2v+00bjCPV6wDeskZvBJ5fkXaP59zT2/Ld6nT
+J9X7S8UzQt6uRz9J9POgw7v136zVdfATAYjetslDH/Ee406BsquhfPWG2PR
aWPVWuVssz9aos+1xL1Ge9xP+NPP1UX3FNtktH+Z8r6ckVSb72ni6PexeEZ+
Ezf7y87NjGAmoRO0vjHeWyPxXqGP3M834h39n/T7etn50ApcEg9m7lFwz7W7
B/Ayo+f1qntblUZ+yHlOcD9wJuFnQs/hkjFck++6gu+Te0s+D5yFw/I52WFN
vFnyjAM7uiE3XE3F+5u+TCvuetF8/Co8w12uN1T9HwV+XhOvQ4nvYXTG3vQd
bojB/27+d7T5PKGFrYn18D8kOkaR
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlV1olnUYxu+9bvOdc+/HttfteefefVFqlCA6i0TFFRTV0dSiIBT7nOhM
c2pu60uKCgoMq4MyyfQgFJMW1KFUQuCokyJy1HS6EXhUaBaL7Hd1PQcX3M//
/7+/rvvj6dqyo38wExF7QDVoTyL+LUScz0b8DFZ1RFxfGHG0PuLuhoiB9oit
4DR33aCf9+tBHfKhqogP0D1Uini7NqINfMjd7c0RK8Fh5GPcf4rNK9haj+Ov
8xHftURcmxuxD/0Z3vXx/RLfa9Ff0xrxMXpHwWrk5U0Rv1YiGtDPg+ucXQP1
Wcf0B7rv8LajzjF90xZxFhwkuS/xdwL725rtq4z9GmwF6JuDH3IcJ54bLbb3
Km8WY+t4MWIF9i5zNkVuu/j+CN3Pa+37aqvfSmeM9+fI8UDGOr/gazz9/grM
Ig/DXzI/YtG8iFHk2qJjW0SM5/C9FxtFdK/CwWn8XSrZl2J8gPvX+X4N3N9i
bsTx4ZQjcf9+wbmpBvL1D98/Ze1zuBzxW6N9KQfVZmIB9V7gGu3DRrs4zTiG
Wzm/DYzw9iJnd8HlGDXoq4mYxuZz2JvB3s3V7plGvo8XXNsR9J/B3m6QVz4Z
264IWftoprfyIAeaQBcxdIJT3H0LFvJ2D/qFVF9v1RPqBemMEtvz4GyNOf6L
syE4uFLlnu1BnoWneWk9/26zTdm6l/sy9wfAyyAB9WC8xdyrRz7B9jLyfaPa
Oc+i393q3r8P/e3kvpn4NoFtjebyAphMOb0HLjLt7i3FtLvJM6VZOkM9fsfX
Tjjrybpfe5AHiWE76EZewfsT2HkL/2+CAufv4quzzvV4D3lp0XIXZxvo5S3E
MTbHPT9FvBXeTGB7HTE8yNuDxLMU32vq3Zu3cD+TNX/zUw6U+/d8/8n9Jr5H
qX8/aEB+BOxNv6crjlGxNTU492Hu95fMgWLNI79S5ZifKJlzcf046Cz5THJH
yVxfrHi2xfkU8som2y6CJbzp1TyCxWksO/GRq3NM4q457SVxqF2yDrw41zvl
EvYuV2xriJgeg6uNFe+a/zmDm4eK5lIcbcT2hsS7TfP9aMkcKHfNxOaSayL+
xdFqfA3A+RfM9gj+JpF3lF3btfA9gq39iXtRPdmreSua6ycVA70xAV7IeYdp
Vy5LPAvamceK3knaRcvrzEVnyp04Od/hGqu2svEj++xks3exZi7P3ZJUXzWX
nCt6lnUmrh5u9OyKszyxF8rORTM5gL3PEvseZHU+m3jny75mfLDsnJWraq7Z
eBp7TzV6RkbQv6PkXDWzvdT2TNm7UD2+ijd3Jt6V+idoNrXztOs0ozcRay7l
X/UeSnwmWTtia5tjVGyqwQVqO1lxrfXP0O7UzGpWtUPbEs+IZkM78kbB/0D9
+zQz4u6HvHeFcuxp9Q7Q7GtmdyXecdon6kHlqhnW7CrnaXCk4lnXjvwPoHP1
FA==
           "],
           VertexColors->None], 
          PolygonBox[{{6139, 5417, 5416, 6134, 2058}, {5499, 7416, 2978, 7415,
            5498}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.47077644773066096`, 0.36578631975392895`, 0.7787135651126017], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlkts1FUUxm8LtNPpDNN2Osx0pvMfkUJ0IeACIRASCy5EVygSy0IMgoQ3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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtllts1FUQxoeWbrdl62633Xa72+5SW3xTMbG0ShAhJgLqA4LEGhMQW6DQ
m2gL4R7QqtUHffClGiRhi8CL94RorNqKYqqhYMHQEqMp0UYrFzEViBJ/X2Yf
JnvO+Z8z8803t61e2/Foe46Z9SEzkUyx2QcVZh/nmaVyzX4pM9sRM9uO/Mz6
TJjzuFlV0Oz1GWZl3L+L+1PsUyGzEwmzr5FYkdncQrOrEc7LzZryzQ5jKLfK
7Gal2X9IDus63jag+yq2L6Ojj/vTvF/O22Xcv540Gw27rcqg6x7j7N5ZbmMr
77cgIzmOaTd60+Ac5P6z3OnhbXParJ27/2JjiLcBMCfBWsP37ejbzL4IXy8U
mEV4vxD/7kPCrI/y9jByE/xj6BjHlwwyEvSzL1j/gM46dP3O/kv2t5XgM/j/
YL8yZXYP+1Le9ogf8BxJu647uJPE9+eRfUgCySDn4OCBgNkBpIi336DjIm8v
I61wdg1s72M/yH4e2Kt5MxupY/1rqdlp3vfCxxF8mmYdg59T3D/KWS3cLMb+
0iLn6G6+VRU795eQTvj4KQp+kiEC/jD+zEbnGfLhcfZJfN0Kplawb0LOl3mO
KDfGkQwyxJsp7nai/y/8HcDGAridRMdG3rcgB3I9x84lnRNxoZguxr9+ML8B
lgn2HfgVIw6lSDvrzeDbDx8D+P4jOufx/iB4kugqyHcuH8H+w+XO6SG+zefO
K4WeA1tK3AdhFwfX0dvNvS7kGusbcDEO3iLs3w/GEOcpzq6wX048Mnx7G9mP
HESOJTxnlauKubjZU+ZYxFEntjqQz1gPIEsiXgPK/QdZv8XdZYoH8ibrdvT1
ljn3o/g3DDdhMKzAdhAMucqHhNdWkjtX8LMj4XfPIvl8Pw4/c+HjCWI4ReyO
xjyXQvjzonKH/XtID+uVvF+EjVfNc26as41gC8BvDz514WN3hdfeOPu93D2F
vXrsH8P+59hLY2M0z2t8NOk5oNirJj5l/wlyO9+T7GekHINsG+v1+L0u7VgV
owb0DSXc/9c4awHLeiQv5JgU+2cS7qty4CmwtZCvG5A1rDMRzyHljnrSWe7P
QedudN0Jhvaov9HdNtYj6NqQ1d8302v1OHhrZ3nN1oJtTtpjJ47+iTtH4ubd
oNfaY/Ip5DUXRt8NzlbB5TYwLol7DMT9/KD3vgD381LeA1fwuzbqveEF5Omo
n2ktncqdZs5eCnkORdHfGPXaVo0I+8mE45EPq1mf5HsUXx4KODe1nNUknCPF
og1/uos8JjXkwfdhz/fGgPeSdUhztqeodv8MO3bV8B7yZW+5x149QrG5Ne7c
yb5qowF/60u9RgKKZ8q5b+TOGGd/x527pQXey/bFvdbU0z7ke3+xz56GgOs6
n+0t0qna7gXXyzGv8da014RqQT7pm2Ks2OrOMHe+K/fa1YwQF+op6iXiRL0+
k61l9fyauPcY9Rb5pFq5gExka+arpM8QzQ7lSHWpz0DNPvVI1bJqXLWtmlas
lfOWjfkm+Gqr8t6tmJ1I+YzSbLqkHEffLnwN4k8x9iexeTHmvVMzSr1KPUO9
Qj0rF7y1MY+dYrgT3b/h+2DIZ9xO7g1HnEvpPJ3wnJdvquGFmjlhr80O7hyC
q3fKvfY0L9bwfXXM1+pB6k3qSepFqtEdYccsrJrhT4JnV6XP3kVBx7INexMF
jkmz6JaY9xLNpMFyn5malZoZqh3NHM0a1VAT779N+ez7CP9XpfxMa9XEoHgt
8dxSz1MuK8eUW+KjtMJ9En7NbGGZjPqsFybN1lCJc68Z21TiPgi7/oM8Rwy7
0j7b1UP0X0gzQ7NC/4kWoDuS8FrXTCuM+X8e/ddRDfaHnWNxqx6pWab/GOHs
TFOtJbOzXzWXwX590mtXM02zRzNas1kz6H+Ag03I
           "],
           VertexColors->None], 
          PolygonBox[{{5604, 4467, 781, 5602, 5603}, {5479, 4406, 4405, 5417, 
           1625}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.5022587706125559, 0.42052557697194876`, 0.8229657784344553], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl21sleUZx+/2nHJ6+kJLT+lpz+GcM7XgwLB9WFYMurAXwjIymIOCZBJr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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtllls1FUUxm87bYdhCW2nM+10mREpRiDRB8Mii4BxAYyIpCxRYimKhH0H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           "],
           VertexColors->None], 
          PolygonBox[{{5510, 5509, 5508, 5403, 1624}, {4314, 5687, 1765, 5697,
            4313}},
           VertexColors->None]}]}, 
       {RGBColor[0.5337410934944509, 0.4752648341899687, 0.8672179917563091], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmGtwVdUVxzdwb3IfeZF7k5vk5qFlrAjMtJ2RMG3RChGVRx9QCoIlCeig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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3tw1NUVxy9kk93sxkk2+0h2N7sR0eJrxv7RQaW8JKgl4AsQGBUQtO1U
ZgQEKtqW0RI7RRLACioiPoJJhSBY1PpWxscATrXCtMH3g4e0OkqBIIh22s/X
7/5xZu/v3nPP+Z5zz2sHzJw9/sb+IYRPoQi0vBDC+roQ9iVCOBAPYVU2hJXQ
KJhSVSEcT4UwpxTCmpoQrmfvNM7+nAxhI2f/gJo5f7o2hLkImx/xen59CFsr
vLcX/kWZEH4H7WG9uSmETdBi9LVBP2bvHGgJWKKVITzIelxzCGOhtaxbkH8M
/c0ncYa8tsYQ1uVDiIF1Gt+XcHYZ9DmyfoOMH3HnmGREQ/gn+N7hrIiMefB+
CE0EWxuylyJvF+d5bL8TPEugHOvHOR+Y9dnRKp/dAbWVeW4psg/f32MhZPFJ
E7JPTtn2AehcmLENwn4z6zfhnYy+GegL8H+ctU/ki4+gK/H/Un4r8e06bBrM
elXKvtiH/nn13tNaPp2IrJP5PqNfCNcg8xfYtwie+5G9GjrM3UtkP3SI9Xn8
DoOGQudCG9F3N7+ncz+R8PrehhC2R73XkwuhExt/gqwJMftqAvJvrbHPRmPP
7Y0+W8P9U7CxA2oH31fYcC13Z0D/SxhjlPUzyDy3OoQu9jq5P4K9T1l/BjXg
03ooCWWh8dgzA31bsPUA54vrbaNsUww2c38X93dCJdbfcr4Bm+Lwfljj2Gll
f0ydY+jSkmNEsbEHnoHszwJ/K/h3gO8p4nU79wdxNo7vzXxvwR8d2DO8n20f
WTRW+eBVYi8H/694q17efCzn1ewtwL7ZnFfCG2Q/tkSKxqI9rYVpMPKXcX8v
92+FtZ27L5SMfSU2d/BmE8B9Nb6eCr3Fve3QNuhv0BXouwj+hfDP4v5z5OL9
6FoEvhb2hsMzrOizPej4Bt6j0NnYUkTeA+hfjX1vRr03qc45o1x5DBmj0d9X
Mq9yTrn7HfJPNDmHE/juOt4zVu333pzm/difyP0evm8C+1zo/Er7dBW6ToD5
OPzb0DkFfSuQcTX+70P/Br5Hg3d/wjkcQ3cF1B+KQkPBexf++lfcNeJi1aas
3+40dHaiuwV5g5EXx3+rwLlCWBP2yXPcfRY6Gzyt6H8K+44gt4Btt0FR8MWg
I5ynwH83eF5t9FuM7O/Y6ik4VxRj3dj+CPQw1AUNAssT+KAEll5oAbZOgP8R
8C7H5i/B/y58P6s2xhHw9rF3BBqedm4e4/ebtHO0r841RrXl9WrXnrfKb/9D
DQLbk9i8Bfpjo2MtVvaVYu5w2jmi3DjE+gPlGnQb2P+EPTMaHGOKrdX44+fI
eD5tX44B30FwtbI3Bvqa9Xtg3w2NqLAN8u0mYm5kjX18A/bOLMfDEuUA30vB
tlS1s9q+Vg1X7ZbPTyc2zgDb27zfYL6vx1fT0DMVU7bEHeuqYapdivl1Gdcc
1ZqHkNmddA9S7+mB1jc5BxT7tyuG4F/A93xov+IS+S+nXFs74+49T3I2qsY9
aHbSMaTYiUHLsHtynWNzN/JXFNwj1RsVg4pNvYF8rxjtIH/fSDl2FOPyVS+U
qLDPxuGPIfh8Ib6+mfOH0P9ok7HqTfaiKwL/i/j+ZehR5FWn3Nt+j/4MutMF
Y1POqHauq3MtUw1V7vTUuVYqh37KWy5sdmz/N+JaMR4Mt9S4ZkzhbBL0fcQ9
SW/9NXe+SvvNJ6FrcsG+Ug7fB/Z9yH8l5ppRy9lQ7l/I3Zlx1+4LuDey0TW8
B+yzmt07lXPDWMfAuCviOyuRVZWzrT/MGMh/iTsPI+uqqGNhdMm1VDERVZ6l
PYtsjRlLhPdqrTKmvQXXJNWiFuz/Q8Y9Sd+KwQT+jOedy6rRilXFqGJTMdvB
/faCa6VqcmfeMadY04whbJdz/mDcGKcUnDPKla64c30Q+N6rdM43FlwTVAvU
IwZyNiTpt+yFJ8/5r1PuHUnsHc/3FQX3HunYDr7Xcs5V9ahusHyAze9DXRm/
1UZ+ezJ+s5aie4p6iWa4v3L3aaiP77e5/xd4rqw3HtUo9fYNOce7evxZ+P/M
BsfKWPB8Au+8vLE1s3cMvVn40xHXd80q7ap5VZ5ZFiB/ftq9UjGvXqEZSLOP
esY0zqbXutYcxv4z2X+n1m91FTL64Zvl7C2r8vfcjGcCzQJzWE/n/hr4d0Rd
o4ekPUNpdjo/7VqsPa1Vk6dCA/KuRXrfexrcg9R7NONoNjyata2aEQ+wnlTv
XG+JGsspab+VMMl34tGZfCgsiknFojB9D+8TTZ5lVdMeQ1dXg321O+rcv67g
2qYakMo5h5Q7miGV+3vw8Usx14B3M56ZNCtpxm7j/uIGv8XaKudSddG9Wjml
3Osu9yLlYG/RM7tmddVoxWZ9g3NLMaresxXeV3LuQXPw//qcZSsm1FtUQ/eX
e4xq6Rf8/jvjmqrZSzOzZmXNYOvZq8851jTjPZ50jig3FCOj+D4r47eVP6Vb
PUa9RRhWaN7IujerJp2a9p1l5XwZo/jMu5dqJtRs1J7y7KsZ6T8Z91T10oOs
Z1E7fplyb9FMXGK9s+TZXP8BZIvuHCzbdEHSOqVLM596eXet3075sintGUfv
qZyaXvRMr1leM+7Fmk01b/Z3jW3POKZlr2ZindXkXfvFo16vHn2o3PMr8cH7
/F4bHANJ7q+ts27NVBUZ55ByRzVPvLsz7n26o1qgGtFVrgkX4Z/fpvxfRz1O
teO88uyvGrJT/Trv2UI5/X8YgPuO
           "],
           VertexColors->None], 
          PolygonBox[{{5709, 5713, 1573, 4269, 5708}, {6689, 5489, 5488, 6693,
            2441}},
           VertexColors->None]}]}, 
       {RGBColor[0.5648520632339729, 0.5292222811914961, 0.9095222494091855], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHts1tUZx0/L274tpe/bO23fvq1oTbxNbhbUbRJvUENBJYEq6jBTp3Nm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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl2tw1NUZxk+STbIBks3uZpNNNhex+aDUitBysVUUQggavCQzFu2UkakI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           "],
           VertexColors->None], 
          PolygonBox[{{4968, 6260, 2124, 7976, 4967}, {4416, 5860, 5859, 5854,
            748}},
           VertexColors->None]}]}, 
       {RGBColor[0.5879988553063243, 0.5664127353883655, 0.9100499249753411], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmGuMlVcVhvfAXA9z5nJmztwOM8NQLtOWy8xA9YcRKzMYUy6DQilYK9eC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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3lw1dUVx2/M8vIehpe3JW8Pq+JWIGg72hEVwVECRIJKGGUTIUFZAtqC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           "],
           VertexColors->None], PolygonBox[{{5613, 5612, 5611, 4470, 1698}},
           VertexColors->None]}]}, 
       {RGBColor[0.6111456473786757, 0.6036031895852348, 0.9105776005414967], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1l2uMlVcVhjdzOWfOXDi3GeZymBnrwMxIoq0dqok/moqWECVAKaiUKYUh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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3tw1NUVx2+yeZOwm2zCbrK7SZGS0MdUKbSd0RmLrTAjRaEEq5GIGMYW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           "],
           VertexColors->None], PolygonBox[{{4319, 5545, 5544, 5550, 1605}},
           VertexColors->None]}]}, 
       {RGBColor[0.6342924394510272, 0.6407936437821042, 0.9111052761076525], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl1uMlOUZx1929jizOzPMrjOzM85uRE6WKBARm5q0RlqWNU1VAsZCIaRR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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3tsVvUZx399C73Svpe+tG/fWzcEitt0IjK3mWxGBNycOKcsChGJURZR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           "],
           VertexColors->None], PolygonBox[{{4726, 5311, 5310, 5716, 1767}},
           VertexColors->None]}]}, 
       {RGBColor[0.6574392315233786, 0.6779840979789736, 0.9116329516738081], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXlwldUZxk/IvQlJbhJyb0hubm7C2LpB0MZdVGJtHZeK2goqinZalLpX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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3tw1NUVx2+yIYQkuskmbDabzW5pVcQIpcgodCrU1hEdECzlndqxzDAj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           "],
           VertexColors->None], PolygonBox[{{5144, 5601, 5600, 4536, 815}},
           VertexColors->None]}]}, 
       {RGBColor[0.6805860235957301, 0.7151745521758431, 0.9121606272399637], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXlwltUVxm8SspCVfInk48sCiEVFywyKCipqx6UqUEVEQZbp2CkgElCQ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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3tw1NUVx28ICSRZ3GSzkGU3yWqnDQo0UwQBoRGdEStIeChY5NEWHF8h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           "],
           VertexColors->None], PolygonBox[{{5558, 4503, 789, 5256, 5557}},
           VertexColors->None]}]}, 
       {RGBColor[0.7037328156680815, 0.7523650063727125, 0.9126883028061193], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl1uM1dUVxjdnZs5l7nPOmTlnzjgzMSogSaO2jRITbglenmA0XgIpbaeN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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl2lslUUUhocuty1t6W17S2/h3l6MgRYUEYyAIlsiixrKoiAllChGRURF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           "],
           VertexColors->None], PolygonBox[{{5334, 5568, 1702, 4508, 5333}},
           VertexColors->None]}]}, 
       {RGBColor[0.7268796077404329, 0.7895554605695819, 0.9132159783722751], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl1lsVVUUhjct7b2l0F5u29veW0rDAxoT44Bj1EQciNQ4AIoDTgkvEk2g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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3ls1GUax99p6UnbmU6n02mZGa2JCh54wAoKohAR6sFRLi0CUTcRdQVE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           "],
           VertexColors->None], PolygonBox[{{5651, 5656, 1554, 4241, 5650}},
           VertexColors->None]}]}, 
       {RGBColor[0.7500263998127844, 0.8267459147664513, 0.9137436539384307], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmG2QlWUZx+99Yd/P2V3WPXvOWXd3HOsDwzo22YvREhOloAUFMUuK5RIG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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl2tw1NUZxk8SyG1JsptNNrub3c1Axw9cNFZihSjQQiWARjBQoMYhjEgF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           "],
           VertexColors->None], PolygonBox[{{5821, 4512, 1706, 5825, 5820}},
           VertexColors->None]}]}, 
       {RGBColor[0.7720986038226679, 0.8501551936016223, 0.9097895219716735], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmH2Q1VUZx8+y7t29+3b37i5798W9F5EZU0HC0ATNLBQmCN00EwXvLvvC
5ChQmVraiyyOS+OkaIBITmkizujKrhqpmM1EaviCjjLTlFNYTuOMimVigqnR
97Pfp+GP3/2de37POed5/T7Pc47pX33+qkkppTr9VOo9vzul65pTel5/3syk
VF+V0h6NuxpTmqXxqqNSGmgXvWiWaH6l5kYaUrpC72tifHRFSi9ov/NFu17j
j0T/sZ5HarS2OqUtortYz249j+mMr8VZQw0+72Od9ZGejcn7rYs9/5xL6ZPJ
KW3W+EXtc2XGZ9S1pLSjkFK/xru0bpme32jPVaJfVkppsMFncP6I+DpGdOWs
51bp+5jWz9a5S9pSukPjBo0PaM33tU+PaD/SPndLLznRLz5aZ+pZUZfS8dqr
SXOj4ud7+ZSeLPl/Y53XPq/vm+olh54Bjb8qHfToOUN8zJT+phZT6tO3Ax0p
vd9hnsa0folob5Tsl2qPt7XXPRrn9L4qY36OEz8/0FkLNd+r913iuVU8/1jr
f6a9f6L5OZ3iKezYq31u1rcNyTJU67m3wrpGN/06b31tSh+Il4LeZb3Xas0b
ou8Xv5mulM7Rvu9q/C89ozVHzuOsPeLrYu2zvtLyjx9lnfxWfA2X7CPzJGt3
m2l7ZKtviredos1Umif42aRvT2rtUxrvaUqpo8Nn4StL9AyLrlxn3q4VzzNl
h9l6+jQ3pLNe1P5nVnsP3uzzb30/iXM1d6FkO7HG3+8XP9v1vCBZXxbvN2n+
atFnxcNWPTO1/9PS4VztO6PW+tnaaP8var5P/I+Ln+9Osgzw36u9bmi0/nrl
D4+V/I3YYS0+Nq3SvDwt+pdlx99Ln7doPE98nqlnoM6+h52ZJ8bGMl6HX9Tk
7BucndG4rLljpc/PSV+vVTh2Pmn0fDbn/9BPy3gN83xfGjTEGXuOJNNmYv+v
aM/zC44jYqJcclx8SXGwSM9+8XmK3gulh1tFc7jSfnSb1m5K9nfid2nww3iW
aI+Vzq8W7Vyt7dH/n2q8VuOTZetjpbfl2veXkmO7njY9Y3q0ZEK/jP/O3nqP
x3hI9IN1ttfxDbbBQ/q2o8J2wIdfkv1ntab0qmgOxj7sB7/EBzwTs8QYen9Q
9K/kjF3bqo1/+PlU7TdFT4d8ZY/s9lS7/aYhMJI47aow/9M1XqBvo5q/ZZLx
8p5223NOtX16OHR2OPbnP34+WOE3NHM1X9D/GXqfoed26eqyvGOY858JHnbE
Gug5Hz6QfZqU96NW+/WI3sN6qjPW+wKdfZloHpY/d8jGqyX7/nrjAH7eL32c
Wm+ce1Y23N1ouQZDv+yP7hlzLrprr7Hf3iX9FXXWXvH0D+HHAT3zRbtgsv0e
GvSIPt+TPq6Xf23IGefvEM15eePBHyd5j7v0nqT4qNZzbp39cXNgNTiGHtFh
OfwH3rZJxh7Nf0fj5aL/VrMxC7w4r94+9l/p87Cexfr/+azfc7XuTs29Lx7m
VFru8bAp79HwvcXdjgdioV+yduad95CHN/5DbICLl4h+tGjcAXMWS8ZzJxvT
h7S2K38kZ14Zcv+n07gGlp3W5Dgnxt8S/VXS5zzRPV9vv8Em2OLEBsdCIXwA
nvFBfBHMuV70++qsmzfCX0/Ht7KmwVexI3wRL+PCvbFay4DfDoTv4ivQLtT6
S8H/atcHTeIxX/B//OvWkL0s3W8sHclv2ATMeSdyTp/2Wy6Z+rt85nTJcVKD
sYIxcuFjy6SPtpK/MTc9aKgpZgQNOvqDzmiu8Nz0mL9faxvF20XV1gn6QwZy
wgW1kXtanLfIWT0RH/Ca1fgD7bdPT52w6qlO2+gl2aVlsuuKYfnmWj1XSb+9
dfZF8tRA+AsxTL64N/4Php+i/3Kj8z04wre2iPmXKo2lYCp54C9Z1y/E/77A
MeoL6gQw9k35RnuTbf0k+TNv28JDIfxhebvzOjl9Xo3f5Er87OwYH5J8H3Za
L/fJx2/UPqcQq0XHITFIHkOPnIWtsTP6ekjrxjttV3I8/oGfkGtGIj+MVJkf
MG1KxB5xQ93UGDhMXiYWqaPwGXwWW+Cb2BD/JIec2m08I27ACuyCL5J3OZfc
2xW5e1i07XljObUnuqQO7JQ+OtqNSTn51wnNzifg9bSQsSt0iL3gd2+DeUb3
2I76CvsxJheAy+TyWyKPlMO+m2Wf2d3W2YPS5xebo7ZpdK22IWq/coyfEc29
nY4VatzDGeeM12WHz3RYR19vNE+Mwa1FrcYu/GRO+MpDwtfjRH+Wxu3y8Ue0
55Rq50kwnLx5ub63thvH54v+ojbLslrvvpLPrlKMrmmzn2AvZMRG5NgVHbYL
uExNj7zUPZyDLbq09yGt76pxTYq86OYkzb+n54Qa2x15kGVvzvkYLM1q77ea
nAvoNy6vcg1MXVmM2pLctT8wpVbvvVHzYyv0Q403KWM9kvczVcYexjXif23O
fUkmaqdyYBh7r498gq/h59ShN0Qt2t7tPoce40/CmHeKxqCSeH4gbx9CB+Am
esBvXmkw5i+Legxb40tLo17qbHFuZg112LKgWRo9DrwhE7pCLuruldGPXF5j
vMB/iYnTstYbsUAti01Yh65ZSxzMzZrPneL5iQ7/h8e9QUONUN9qfk6OXhBf
uilshg9Qf5WjBpvw1aivmKfXQVc7tM98+cCGWteGH4e86HdRMo48of03R99U
VWWbsQ/5Y2rGeHCdfOG+Tn+jdnig6PrhcfFY6nTNS09KjgRrwTrORA/gPtiE
LfAZdII8XxBfq0v+/+0u9yrQgbvlwN6Hdda1rZZ9VHZfL/t+tt55KBu9A3FC
j4T87fXuY0Y1/4D2e73VY2oJagvsRZ1FXUathdybQnb6qvHIvzzkYnS0MWi2
hs9sjPFE3V0fuaDJMYO8rGMf4oW4GYvxo1XWKTU/enoh6omDtbY/8j7X6PqP
2ny3eF+Q81nDba7VqNPIxdQf5NkdUYvgA9B+udv0zA3FPDzvj96WOCJXkguJ
mcV1zt28yTP0+98oGbOIIfDstcjF1HqspZYj5/bFGDmQB3+gjl0e89hpKPqF
m7RnIeeYWdhtvIMf+hByEP5MfPeG33IvQl9Nz7BWa39Y8t1ET6tjHt7/Sn/c
5D4c3jiXnItt6Y2xL7XnQPCDbvvjLoEaA7mQne/9QcM5a+IsfHpX4xE82BU4
sDtsxD7EB3Ue+bJd9i90GAfpB+n1yMPEFDGMD+MrzJGXnxb/g62O9xXSyYuS
5Sjtdafkuzvne5e50sGyorGT3E6uJY64qyHeroh+fcIPwO3AYXwebCXfgsn4
IfkffybfkPNfjRqY/LA+am1qJmoi8sXN9Zad2BmIeqYQY+ql1snGcc65VDyW
i15Dbl/T7fw+M+O+nH2viX6LnE49gN/j8/T88EAtQT45OfIE/ohfYuvtLb4/
mh21xuzQAz6zNu4B2AN52GdceDLWZd8Ca2aF/sFmsIk45Zz90X8RVxdGXUo+
Yx4eDkr/K1o8z39seVvUHvRC9EH4aCbmK2TD2qLvnT5UzB7Ss7javvls9HTk
u/HAgd5m33Hw/+yoEcn12Hxbp/flrm4w7uuIH3SKPqfo+z9bjCv473OBG9Ta
O6MXxo7YkFyGb22vcd4vSjdnF1xT/rzFd1tgKDw+F769tNl0o3Hn0BryHog7
HGJ2sGicAnPG4h4B/yFWiB/i5RD3JYHDnxLPVXn7MvqvClufGL0FWMG947tt
xiLu+dbkHc+9UadRw/xCPlbotn+DMSsC6+iXtkRvPkff725yHTFRY9W5PhyL
WpT8u0uy/67Fa+CRnDEaMY4OiAnuO38Vd57g4AdxT8Kd02De/g2+grPoAXuT
J5GNfP5K1K7E6rqopagNyW1nxX7Z6KFuw2+b3GNDNxJx+1rQcD69I30PdfL/
74KJqZnSyYyo66A7GD3Lap1zsMV5nlr49ibXw2NBgyznFNzr4jv0QdCS38B1
9gfbLyg432PXkZCFc1dGfKOrLdLH45N9rwcOTeTjuAvaF2eB19gQX+KO6tPN
tn05ejlwmB6dPp+aDSwG7+gTwdRs3JtxLzsl59xKv3t6LmqWZucb+BrQ/kNF
5+91gZfwDG5vi/54adz9EiOPFlx/U1P8usN3mvReOzV3SYv7cnqz3ug3qUGp
fcFYaqtsYP5EDoj5rbJJX1PUibW266K4M+F+AP88XXY5o9v/385Y/9hhVd73
UPQWYO9I8I8e4J0eb134Cfv+7Wj3KtTz4C9+B7aDL+AEelsZekBv/wNa5SNk

           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtl39w13Udx9/7Cfvuu32/332/27777vvdl4irRGFgQrIhYEPo0AmhAgvY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           "],
           VertexColors->None], 
          PolygonBox[{{7690, 4612, 4611, 6228, 2108}, {5845, 5839, 730, 4388, 
           5844}},
           VertexColors->None]}]}, 
       {RGBColor[0.7928859941011244, 0.8570872343598586, 0.9004767897551836], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHuQl1UZx88uy95+P/bCXtll94dNmTUp4BQgu+RAUGQ1gdSAICA3l4vQ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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJw1l2twlOUVxx9yhWxwN9ndLNnN7ptqW5mO2IRRQILKdUA7ToOOVasCCZRL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           "],
           VertexColors->None], 
          PolygonBox[{{4295, 5567, 5566, 5571, 1588}, {5448, 7146, 2885, 4049,
            5447}},
           VertexColors->None]}]}, 
       {RGBColor[0.8136733843795808, 0.8640192751180948, 0.8911640575386939], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl2tw1OUVxl8gKyS7LCGbJcku7pJEC2OJFzpTi+NUuRg1VTHMQG0ZP0gC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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmtM1WUcxx/wiHAO5IFzwwPyV9C0Jpr4InVtSSFeMg1f2MX1IsDLUuuF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           "],
           VertexColors->None], 
          PolygonBox[{{5584, 5093, 5092, 5578, 1704}, {3939, 3882, 1438, 5101,
            3938}},
           VertexColors->None]}]}, 
       {RGBColor[0.8344607746580371, 0.8709513158763311, 0.881851325322204], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lluI1VUUxrdzO3M7M3PmnJlzm0s5Y1J5j6hwMAN1HkofQoJq6EFnLIKK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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlm1M1WUYxh+P0BE6BOf1fziHAzNANkA0sVWTNXWiy9I2a72yPgBarWlr
sUq0XJltbeVWbS3pQ6mtXEFDRI20xQdNAbOkFy1bs2a8CCaHTRGt1u/afT7c
O8/zf57nvq/77brP7Man12zwOefeQ7KQ6ii/Qee6+VjKhxr2f4ac+z3HuYYb
nNtY4lwrckuecw9wf2nSuaP5zk35nXsr17ll7J/jfAvn77A/5jlXEXauhPUE
dz6POTdU7FyM82XZzrUVOrcDGcXeglnORQucG+BOHXdHOR9kvTDiXC1yinVP
wrlc1q/7TGcVtvvR34dUsp6Hrkl0fIuuMeRi3Llx5FXuf8K+kztP4dNr+HIa
/cPg7ee8DxlinUauIJeRCeQfsF5DPiYWpWBOYb+BeHTMBCM6HsbXR5CXwDLN
t+XoubmIOzc6dwf2TmKvnfPfeFvPnaVga8OPHciSAsNyvdh0C1Mc/R6ycwYx
JOYj6HqIOw8iw6yP5FvMFetz2YbtP6QszzAuJ3cXiMUoUs/6XNIwyPZiMO0F
Xwt2E8RjI/iawbEWmQR72lmsnySGTxRazO9FTw/nt5OP1ei4gu9fYu9sAJ3Y
u4yN77jrQ9cidFwA+whSDp4V3B/Hdg7+V7Dfg0+NKe6AYQ/3fehoZv83+0/Z
z2R/Fpt94HsZfF8hF/F5Ekkj40WW+0vovzvXamCb9POtHSzXwH8SLCNxy/Vi
4vch9ZdG3wn2g/iwgXOP8xiynnU6YT7Kt1W5lvuVxPquqNXAOnT355t/U8T7
nrDlWLkVhm3ob+PeVdaH0B8kVh/xZjuxGCCf5WAuQzqyLIbyRTWg3Msn1W4F
MZwTtBr+gthOEeNficUvyPvorouab7LRAN4PuJtC/2H86+PuPOJbgxxnfdyz
nlOvpZHN4PmZ9z8hm1gf5fdI1Hq3M9t69xnwXs+2Hq4mJkH0j+DfMLIX+11I
iNoJIldDhlHYVAOLwBzD3mO8fRcfi3h7gPtR7pZxPhd98wutF4/5LFcHwXGb
33KmWn2TGngjZTW7UrWbsNq51W9nzWBsyrc7qt1O4r81y2pYXCIMsi1OUS+r
B1T76mnVWkncuEY1J24rA+86v3Hcv8VmU7bUQx7Y/gpbbE6QvwPsvy+wXhfm
Ls5qItZ78rmXfXnEuEQ6HwX7QMhycwg5EzMOE3edRlaHreZUa+qJhSVW46rt
2hLjvkDMakcceB6/6+LGjeIEccGZjC5xwm58qSq0XP3ot1qQztpMTXTxdhCb
Q/jayp3+kGEUtoMBq/Vx8jWWtJr/mnjM4P79xHMaaWQ9Gz3z84zz1dt/JI1L
1OPdrMeJTwG6Inzr4f2mfOMS1fAY9jd7xr+Kv7i4KWW9r2857HPjNls0A4RF
nDyUwaReTWe4WD07B18DQeMG9XRLynySL8LwPFhf9CzfmkGV4D8M5iXZVjMv
sD4fstnWjM1ucrcvYrWkHtCsU0+rlzXzxE2tceM2cdQq9E0k7K16eoB1Xab+
ZEO1qplUmanZPHTdR1zXIAHPelE9q15VT76CX1uTFmtxsHQNE0Mvz3TuT1qM
FVv1lHRpJmgWSKd6dRd6f/Bbz9YQn2jQeu1OMPZSJ9/EbJaKMzQbVTOqFc3I
anS/jc0tuTbDlnO2wrO3mnGaBeLM9ZmZ0EF8P0NummUzbTtY94ds9k3z5hKx
WpsyLld+fejuLbYz1ZRmn2KiWGgG7ksaZ4grxDGjfH88Ylwrzj0VthpW7SpH
mg3Poj8/YDNC3CzOF9fr/liBcZa4SndKS2xmaVYtAG8Wuto9m33yoQoMfZ5x
ZQv9NTdp37RWTFT7TWF7qx4oJN+JhM1m9ZS4vihmXCHO7+OsPmn/fZRD1eJY
Zt6pJkvJ266YzUL9R9jp2YzSbFIO/weWUWou
           "],
           VertexColors->None], 
          PolygonBox[{{4391, 5224, 1527, 5467, 4390}, {5751, 5756, 5755, 4515,
            797}},
           VertexColors->None]}]}, 
       {RGBColor[0.8552481649364936, 0.8778833566345674, 0.8725385931057142], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lk9slFUUxS+lnc50aKfttP1mOv2nEjdoS6LRKCwaFhpZuNAFUTEmJRoT
EgxKJIIxKGmoCzemotQFtk0s1cTEFqvGBSyQ0AoqLoyKxFAJEQRUSCSu9Pw4
z8XL981799177rnn3m9uGXnukW11EXFSa6XWTEvEIa3nV0Tsq0YsliL26D1f
iWjUas1H9GuF1pvan2uPeLYr4oYun9L7gb6IUn3EL1nE67r/b2NErjmiQetv
2XzeJP+FiB1yUZFNpvWUbL6W7VKKdUqAJrV26r1L5+vKEYOyWZL/Hb0RLfI/
r/fTmeO2C8tKPcdk3yCMOa2S9g62RWzujpjNRdyn+PuLEW8Vbcs59s31Pv9T
eKabjQ2fhY6IUeFZbIi4S7ajOd+bqjM+sC0Lw2BnxK3ysVFx3ujzfXDBC34O
tipv2TysO+NFxyNWvzBeqpjLI7q7Xnd2NzrOHvn4UHdf1Nl17e3SOpF3bOLe
K5veVRFPy0+mu5Vu3+nWs6r1asF34BCbV/S+V3tjda4BtZjR+1/C9p7ivq/3
Ju19oLoX9Nws7L3dvrNWdblT62Le9XmmwzWCs5aUyzvKe7k/4jNhWtTd7zud
Jz7xh5aO1fmdWPCFjo7rfZPujCjOSyv83FIwVy3y80/Vv79T/efE1WSDdTCQ
tNfYaBzEoq7U9xxabbbmyHWdsHxTcq1/q1hn4F9U7mc6zOVcLeLjmvnapv0B
aexo0b85h8PFvHVNvrsL5hQ+0fNoo39zTo2x4fl2qjc8UTv2qSm+qeuE+mZD
qzGPJ23yDo/old/XeiKu9NgX+pxqdu9Qj6mUI0/O0NtYvXUE5qW8dYNmFpRf
T5u1i398l5LtrmSPdqeTfzRCzdDJ6oL7Bf3DCfb4XKu6nFXti7K9rDwO15zn
aObeoM490lFN67WC9YUm9tVb97NpjjAzTrYbz2XV6ErFZ9gWk/167Z0vuRfX
qIbTmbGh9b0598tEzbGJCz9wgw0an0w6R3ecowfwfpIww+944v9LxdlQsyYP
KNaE1m0Fz6lz0uBwg3lFE9T00y7PC2YFOc6mPnpQMR/IrI/H5ON4Zs33S19L
mTXA7MI33MLRaMoFvZ8uW/PsrU42Z8TVmrI1PpBmMb2w0GBbeueqzreWvAcP
l/KuKfiIj25fFuadXe4hcj1Wcr6d0shg1XcGldNc2flS8+up7jc6HQP/h+Tj
bM26e5S+z8zhzRnTYg1dkzaGqq5Fq55/tFqb6I3+oXeGU2+TC7Nke9k6/Va2
C13GDPfMC3DOC9thrYGc+YZ3dPKD+Pmpz/1PT//eas2ikS+azO1X0toT3e5L
4uIXn+jgRKrp/eJjW8130Bo5gH97h/WBPT74JuFnS6+1i27P5Y2Fnrqgu79m
1jn1AS81apJtoeL6zyS9wFWb+L+j6ne+DyO9rjEcX8rM8xHFHyp7rt5TNJfU
hf6er7nHrwrvk93WKFjGEh6+pRf6zPV+nQ93mnP44rtP3eCTHOgXbD/qsj17
s4lnvj/8xif6po5ojFl1d7/76cc+YwUnc4bZh47og/Md1iL/KR6vui+H+v39
+H+ej6cZVUiYwDOVmaObXAn/pnbP458z/+fg/wZ5zKRc0CNzFk2yn0vfI7gc
LJuX9eLgXfG2NefFfADbkDCu7bA+0D5cw3MhaRs/1HZj1fVlDl9MvTaV5jEz
CJ6WE58v9Prbw3eFfiQesR6quh7UYpXyu73qO/8BFOBXBw==
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlVto1nUYxx83d97c3vPJ162yA829G6RFbdAqUFrQRV2YYQQzYyq8okUR
RVgyXBd20UUHvZB5UUpQ5GwFXtiFRNuSsig062JmNU+FBltd1efL9734wvP7
/57z8/09/5tGdz5WrYuI58Fy8FdXRGch4qvmiFmwozNiHZhsiJgGB7lryKPD
3eqWiOFcxEgx4gjyq00R93PenIzYWztv5m6O8wqcH22M+AT5/KqI5o6IxfqI
7ZmIHDp70B/n/koq4s1yxH5wGflcNuJ78B04C55NR1wgxn/43rOMvNG7Ss6H
6xzjQeQbKyPeaYuY536JfFcQcwv+R8FY1jko9hK4VopYAH+Aq+Af9HcR46Vl
1l/bHdEPOpbb553Iv+L/beR7qeFip2tQ7nfRkzPkPIV9T6N7pt6Ncb+3dh5M
UEvKsr7NId/Bt9vBLPIM+r9TXzS7Ptnex7cTrdZ/il6dJv9O8plB5xKzWMhb
VzYV9PvABOeb0Vmf80w0i3HwL/UdokeP1rknjdgO1vQ104P04EDJtjuI9wuz
6iOvfZzbqLfK3UP4+7DeOQ0lzInVtfl9jL8q/r+gPy/g7xS5V+jHcIN7Osf9
BmzWq17kYWI/kPH9W9x/g34z37uanVOF2Cep+WVynyCHKeIfA5Pkfxrk0b3B
+TrIIW/Ffg3oBc+ALLZF8FqLc95ZsI10q8ij8GcLOEq8bnCRXM+Q/wS+vwQV
dH5L+31c5r6NvG/l2zxyuT3ia2bxLj36vN0zke6GnHstm0LRM9fslINmvQ2d
sbRnrlgJ1dfimLvT5qC4pxmpN3n8Pd3kHg2S91DeXKunnjXo9oIP0D0FFuDm
4xlzXxztSPoNyN9Gcjyedgz5Fkdn8f0Dvbsb3b+J8RO1nAO7sW9k3rtS5ry4
rhpbiP0e/m7BX5Ic8kX3WL3VG/4Z24GUudIKzqfdM/XqHuKt47wd+21gLfJ+
9KeSfovaIeLWSvy9XpvXUM6cEpfEgY1J7xzxWT3rJdbZVc5VO+VAwT1Sb5Rj
qWiOipvy2cOsu8uuVRzN4aufPOYb3OOBtHumXumbuH8ka+7pDZTx922NH9px
x7jP4qNSm49qE8eqtRq1W8R5cV07pj/lHqk36nEP37vz5l4PuA2b6/h/H/8X
OI/D4aGM3+IM/ieJdTjnWUvnRXI7lPBubWoy97VTtEv0BhaxXcp4d2vmffjP
JMzlS+ANzvsK3h/aqdP4+yzrWKpRb1U7WbtYb1a7pTXv2et9aldvrb017ewr
5P5c2bPWGx3B98MFv23tJ+1ycUCz106/lvcO053e4KaMd752/RPIP4JXsq5N
O7gfXwMF5y7O6y22J9wrvclP6fF0ybtB/wRxu6vgf5k4/kjGO1+7fgT5o6xn
oN5rhksl6+huEflJbDcVvAu0k/Rv/LPLu1f/SO0e2SzWdtD/3n38wg==
           "],
           VertexColors->None], 
          PolygonBox[{{7395, 5465, 5464, 7400, 2966}, {5225, 6108, 2047, 6114,
            5224}},
           VertexColors->None]}]}, 
       {RGBColor[0.87603555521495, 0.8848153973928036, 0.8632258608892245], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VUloU1EUvU3apGmSJj9p8/OTmioqOOCAIKK22urKYeVCadGFglIUqqKi
uHChFhV1rSBatMVhoSIFRdAWEQqOtU6t08px44BCq4LgOZ7n4pH337vDueee
dzNu3eYV7SEzO40VxppQZfY7ataFjzsxs7tYe8vM7sX0fRvGzbVmTVhbImY3
cTaUNNsDmzj2w9j/gf/OMWbrA50tg+1o0Wx7RLEvJRSftryn74OM2ZqCWW9M
/ow5gN8WxGjFiuD8AGIur1Wcg9jfSpl9hY2H+29pYKyEPe7f1pn1l5sdKhdm
4p8U1Tf39GG8TyHVEELNK8uVc9jVQts3Fap3FDFHsK7D1kOOjRH5dsDmJ/a7
YX/BN7tRVJz5sI3kZdeGtR/rI+w/wuYIsJZVqjZy143zP/gOOww863XnXahv
OexnIf5ZxEuAo5aw7h6GdD6K+yTOW3Fe45mtDpS3HvyMxeqLm13BfVtOWOfi
+22FajwGvo8XlJtxe3C/zWTDvvwIiRNiIt4m4F+VUe9aq3TOOOM99YZ9CaOW
hrh43oec/SnxQ26aAtXI/GOr5VudUQ3Efw1+9RHtGxCzWBBvF6tlz57exFna
U1/S8HtWFBe98L2fFCc9jnfW8h33+bxq6UGuoyXprxH3wxHVMi2LXpekkUWI
2Yw1ijomA/+UnOzIx7SE4rA+2rJG4mI9xLYKfo2etLEvKgzEz/5vdHvqf05c
nDwHtqGivueBp7ZaYU7EFJO5Uoj5Na2esz7WOYgYhwPpiVqiRs6kVDvfK98B
sVEXM2vE57mYcjPvP91GxSH1+N7FOYXfk756XQHOTgTCTN3Qn76bqa9AGAdg
21tQLHLD/hPz9YQ0TH2wP3d99WgcuFkA38chvTnqnnog3kHH5+ei5gVjJWG7
a4zmwZR6s61Z8bwE50sD+RMjtUKcM3H/uqS3y/6xbuaqA8bFvnryXyvkijm5
z+FsLTgOkOtqXL7UIv3zvuYd5wTfP/XZ4mYj85BDYtzhcLYjzuW8YnKWDLl5
uAEYnmY0Rx/54o68hV3ttJ+LPBlPumH/F0ZV7wfY3kmpR8dR3/2M3h8XuSbP
X9LSCnUysUpxGZN4WRMxE1eDr3POtmhSWiD2l75wUuv8D+C7eIFcL0uy6wP+
6VnFrkScgZRm4TDup2YVh1z2OT4Hgeddjd4Zz3hH7mfDb1NKOqfeZ7u9V5AP
7QcdL//fF+vkrCAv7CHtn+BdvsiJo05gXxbIbwS/I55mAHXc7eYk3y/nGuNQ
IzOy6l8ncv4KxBM5pw01fD6nucB3zv8T6q/f/Sd0uL4vLWgmkiv2kud8Iws8
zQLOAequvSjcr0qaxXxPrOuiq43a4jugVmeAM9/X/i8o6Rly
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlEtIVQEQhifNe6+l3Xv1el+lJhVkWUYQUWmvTa9di8KoRYJiBloUBG0r
0qDHqmxRQvZc1EKhaFESgZBalkapJUYFPdEo0AqCvuF3MZw5Z2b++ed1Sqob
tzdkmNkuZDqyPmVWEjXr5+MOPkwUmLVGzIoDZveReuwrYmYfssxyss2Gi8wG
kRP4BnPNEgmzJHIgIIwvs816k2Y9yGf0R2Fiia/EPh4kH/jn02YZMxQzic9P
5Bexh3mvJnd7TPnvzTT7Q/5ZefDN1Ld+cr3CfyW2v+BNwH0VmHXYOpDZYM9B
jmH7BObSfLOvxGSGzBaQczd4a4n5jK0e/9PUshX/NvDv5JjVYD9XaLYEfSb1
/oBPK/EvwOsBowK9My2sOBilYNXDdx+yEH0t8RuRyZD6sZj8b8jxO6Cefef9
LPhnkG/oI9RyM04s+BXU9A78U8Q3I6PoY/hMFmgWVXDcHBWGx25CX0J/e9F7
kDL0nfQqmla/vaYkc2hMaXbe4xzsEyn1yvE81mtw7o7RTc5iuHXC5VmGZuk5
PZfPtJJnU6Fm6T3ckNLMfFZecwCfrKR67/19Sb4a+Dwhfw+yDf9rxeDmqqft
2F8kNMsb2LvQq/AJZCvHJd5zef+H3oekyH09Ke53yVkbVg+89pqwdmuL+4e0
Y/vD6qH7HzLl6sjTrD3nONwjKdV6FVnGHMtjmp3v3MeYODkX72kvsReZ533i
d82Q/pRvD7P1zXdhBP+3Ce2Ez7p2ipvPfBGzLoPPfGIHA7qtAb6tC+rGvFcD
4HVnq2d59Hsf8z8e0I53gjNUpNsbwb8F/1sJ3W4mmCPYloHfPF075bs8L6rb
8p2OoNemNYvHGeLqOzc6xdm59U/Nwzn2kW9NgWYZDYlLLKp35+RcoyndhnN+
z2xbitSb27N4YgsmtSs+U7/tvRHNzu+5C/zn5PtNvqPTtPtNyMmpG/B/R2lc
vfL+v+ZejsXl6/+Ah9TyIK1aHKMurp3yXfKb89yhpLg7B/8X+M35rfk/YS79
aYjoln3nG7CtDmtX/B9Snq+ee6+9p1fQLye0i8vhcDBfNXutXdgX05sLac3C
d3AY3yOF+pf4Dg/Br6pAvj7zPfiORbR7vkN+G21hYfuN/AeMENjU
           "],
           VertexColors->None], 
          PolygonBox[{{6536, 6539, 2049, 4041, 6535}, {6117, 6116, 6115, 6118,
            2049}, {5452, 7145, 7144, 7149, 1652}, {6116, 4395, 2301, 6474, 
           6115}},
           VertexColors->None]}]}, 
       {RGBColor[0.8968229454934064, 0.8917474381510399, 0.8539131286727346], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVE1IVGEUvVk588Zn45s3P37zkhBBcZz2KmV/i4SCqEUrN0oWQRQU1KoM
NBkmgna1qSAZo5bRok1Ri6RFC7Po/2dRLYQWFTRRRHYO51t8+M39zj333HPv
s3vi2L6jLWZ2HGc1Tj1jVsOZWWN2ssssdGa50Oxn2qyJM7jKbDwwO4L7JiSs
bzN7lVI8QLwK7A8Q3siaLTrFG0WzeZxe4L63m+WBiXDeJmbrgPkI/JNOs+VE
udOIjRWUG3vsX9TrD1WDmMWS2QJq/AZnd2S21Ukfa9S9/r2IX0DcIaeJv2FO
2gdRZzhRnz3AXESfr8FZQs6hVmDhwxT4z+DcAd/dNvWbAWa8w+x2XnfmE89a
89DvuoSbRq8vwd+Wkm7qn2tR7+yHtWrQU8fpDNQDseSpQs85xN8Dcw31v6Fe
A/cPa81m8X4CnvR5PH+vgP9fWh5+gq6HWWGuIvc6ZwBcDbo2g3cglK+cDb09
WDbriNTDaegfLmimlVBeU+dTaNniNH/GKn4GzOnxPk9A4zYnT9hrwfc7BA/O
ZuUnc2I/x5vQdrmsvVnCvRqrF86P+0Rt7LfP90i+hbQ42Xev9yr2eqjzvJOn
9JN8laJyT6H3NyXtHHvYEUgnZz7plDsaaf+4VwO4fy7J/6+x3hhnfXpJDbfw
PuOkn9gvHt/YYLbLaR6sx3mTPwMfprwP5OCsyHMYfufA/wj3NDAb8+qbGrlz
Gb+T3EHuAL0kF3nykfKZG+MeJLo/ACaVaAeYx3zit0PXiJ/jrFMP1B+AI42z
p1V7zVmybn9R+0SeEfCPIScVyO/Y78A9zPB+WXtA7VWvP/a9cxeGwN2MtFf8
vncX5Cfr0Qf2NQrunU678TjQG+OXypoHvSWWvjLOb+xAIM65rHzn24tE+8S5
/0LekpOX9Ga/kz/0f8V/L9xhfsP0J4v/DX+ceOkbdbBWhNiznHychJ7n/s4Y
f/NO/94l0t0O/JWS9iXn952z/g+Csru9
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtk01sjFEUht+O6sy0w/Sb+Wam34xZNE0qU8O6GkFZkGgisbBhU6k2oWEh
fjZ00apqiCUbJJqp2FtYICw0FkSJfzpY2JGIxAgRPCdnFm9y7j0/97zvObd7
3+Fdh2KSBkEr2B1Je0A8KT3AUSxLtS5pPCHd6pBOcF6Bf4FzLkVcSUqA+nLp
SIs0lpbWgbVgFNwtSk8K0hTFe9qlU9jPMtJD6t+MS8+xR4kZa5MKxAxQaz1o
0MsM8Sn88833h8mJeH+4U2qP+V0mID4nbVjm/dayUn/Jc2fBC/JreamXtzrA
aXqfBq+xl4h/Sz9HqRnAJQQ78F3lrobvL/WvwWGIu3/Yi+T0UauSd67Trc4l
yfs725zTXmLDwHsxDQfwZZtn6/Ex/fVxroBH2NuIHwFJYv/wxmXevlLwt0xj
iz0YSgdCzzlPbDXw3iNyNnH+yXkr9o+EzypNTyNJ18d6n0s7F+NwG21uFJz/
KuZ5Fu730s5nDfzn866haWeaTeCbKPisbCZT1JsE/S1eo5O37xR9tjbDV9R/
WXJtTO8z1O8h5g39Vqj/jdkFkc/aNDbus8RUU67Be3LfgQ8x17RBbiPy2Zt+
KeztkWuVIWcl9ldqzsU85zO9notcG9NoP/bxss/WerDYY2XPtZzNkWtiWjRs
xpyfRq6lcbwP/5mya2MaDeWck3H5HvPdXgS/4r7j1/O+c8Z9NbhA7JesxxrH
BepN5t1vOXVyP4GPYMn+RuR/zv6azbQaek2rZX9sI/7uwHu1Hi+h/cWic7V5
DOLf0uzf/ojtTr1Z23bIdt3+sP1d2/nfxJ7scm1tZ+zv2o7abtof/g/2SpLU

           "],
           VertexColors->None], 
          PolygonBox[{{7562, 3943, 3942, 7567, 3116}, {6491, 6488, 6487, 4414,
            2311}, {6120, 4433, 2329, 6540, 6119}, {4432, 6120, 6119, 6539, 
           2328}, {6488, 7561, 3115, 4413, 6487}, {6113, 4432, 2328, 6538, 
           6112}},
           VertexColors->None]}]}, 
       {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
        GraphicsGroupBox[{
          PolygonBox[{{4599, 6463, 829}, {2370, 1111, 829}, {3886, 3943, 
           100}, {2245, 413, 100}, {4396, 6541, 1657}, {4333, 6414, 2247}, {
           2245, 2247, 385}, {4821, 5799, 1048}, {1111, 1659, 736}, {5799, 
           5164, 1048}, {2247, 2875, 385}, {6609, 6608, 2370}, {1046, 484, 
           385}, {7131, 7132, 2875}, {1659, 763, 736}, {2327, 1657, 763}, {
           2370, 2845, 1111}, {764, 732, 413}, {7450, 6610, 859}, {2128, 859, 
           483}, {4032, 7561, 2309}, {4433, 6120, 764}, {4432, 6113, 764}, {
           6488, 6491, 2309}, {1657, 764, 413}, {6110, 5227, 732}, {763, 1657,
            413}, {736, 763, 413}, {7562, 6500, 100}, {1641, 2128, 483}, {
           5029, 5798, 1308}, {6500, 6471, 100}, {5797, 4821, 1048}, {413, 
           2245, 385}, {5385, 4818, 1046}, {2845, 1659, 1111}, {5227, 4394, 
           732}, {6269, 6650, 2128}, {829, 1111, 484}, {3943, 7562, 100}, {
           1227, 1479, 1226}, {6491, 6486, 2309}, {1479, 2697, 1308}, {6969, 
           6970, 2697}, {6968, 5029, 1308}, {736, 413, 385}, {6120, 4432, 
           764}, {6531, 6532, 2326}, {4371, 5434, 1641}, {1225, 1641, 483}, {
           7561, 6488, 2309}, {2653, 1641, 1225}, {1973, 1227, 1046}, {1226, 
           1308, 1048}, {859, 829, 483}, {4818, 6014, 1046}, {2652, 2309, 
           1225}, {1048, 1225, 483}, {829, 484, 483}, {6472, 6412, 2245}, {
           7542, 4333, 2247}, {6920, 6919, 2652}, {6534, 6533, 2327}, {1046, 
           1227, 484}, {484, 736, 385}, {6309, 7450, 859}, {4394, 5069, 
           732}, {1226, 1048, 483}, {4623, 6309, 859}, {6015, 3967, 1973}, {
           413, 732, 100}, {1227, 1226, 484}, {1111, 736, 484}, {484, 1226, 
           483}, {2309, 2653, 1225}, {1479, 1308, 1226}, {2654, 1479, 1227}, {
           1973, 2654, 1227}, {1659, 2326, 763}},
           VertexColors->None], 
          PolygonBox[{{6058, 6534, 2327, 763}, {6463, 6609, 2370, 829}, {4007,
            5468, 1659, 2845}, {5069, 3886, 100, 732}, {5384, 5385, 1046, 
           385}, {6414, 7131, 2875, 2247}, {6541, 4433, 764, 1657}, {6919, 
           4032, 2309, 2652}, {6921, 4371, 1641, 2653}, {5165, 6920, 2652, 
           1225}, {6533, 4396, 1657, 2327}, {6608, 4007, 2845, 2370}, {7132, 
           5384, 385, 2875}, {6650, 4623, 859, 2128}, {6610, 4599, 829, 
           859}, {3968, 6969, 2697, 1479}, {6922, 3968, 1479, 2654}, {6486, 
           6921, 2653, 2309}, {6471, 6472, 2245, 100}, {5164, 5165, 1225, 
           1048}, {6532, 6058, 763, 2326}, {5434, 6269, 2128, 1641}, {5468, 
           6531, 2326, 1659}, {6113, 6110, 732, 764}, {6412, 7542, 2247, 
           2245}, {5798, 5797, 1048, 1308}, {3967, 6922, 2654, 1973}, {6970, 
           6968, 1308, 2697}, {6014, 6015, 1973, 1046}},
           VertexColors->None]}]}}, {{}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{7542, 6412, 6472, 6471, 6500, 7562, 3943, 3886, 5069, 4394,
            5227, 6110, 6113, 4432, 6120, 4433, 6541, 4396, 6533, 6534, 6058, 
           6532, 6531, 5468, 4007, 6608, 6609, 6463, 4599, 6610, 7450, 6309, 
           4623, 6650, 6269, 5434, 4371, 6921, 6486, 6491, 6488, 7561, 4032, 
           6919, 6920, 5165, 5164, 5799, 4821, 5797, 5798, 5029, 6968, 6970, 
           6969, 3968, 6922, 3967, 6015, 6014, 4818, 5385, 5384, 7132, 7131, 
           6414, 4333, 7542}],
          "1.3199999999999998`"],
         Annotation[#, 1.3199999999999998`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{6116, 4395, 6807, 6808, 6057, 7100, 6464, 4385, 6462, 6466,
            6465, 4194, 5298, 4193, 7449, 6310, 4620, 6646, 4598, 5433, 4370, 
           5481, 4372, 6492, 4414, 6487, 4413, 7560, 4033, 5347, 5673, 5674, 
           4908, 6098, 7126, 7127, 5763, 4038, 6096, 6095, 6846, 6845, 4368, 
           6758, 4820, 6757, 4819, 6417, 4336, 6047, 6475, 8101, 4003, 6476, 
           4002, 6046, 6045, 6413, 7544, 7541, 6106, 7543, 6501, 7568, 4387, 
           7559, 5452, 7145, 6348, 4424, 5100, 7567, 3942, 3885, 5068, 4393, 
           5226, 6109, 6112, 6538, 6536, 6539, 6119, 6540, 6117, 6116}],
          "1.2`"],
         Annotation[#, 1.2, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{6474, 6115, 6118, 4041, 6535, 6537, 6111, 6108, 5225, 4392,
            5067, 3884, 3941, 7566, 5099, 4423, 6347, 7144, 7149, 5451, 7159, 
           7154, 6168, 6511, 6506, 5173, 5843, 5849, 5465, 7395, 7978, 4977, 
           8162, 7832, 4812, 7833, 4813, 6749, 4334, 6415, 4335, 6416, 7125, 
           6090, 7455, 7456, 4206, 6319, 5948, 6847, 4910, 6122, 7133, 5800, 
           4909, 7901, 4912, 7900, 4911, 4031, 7897, 7898, 7896, 4907, 7899, 
           4785, 5736, 4786, 6097, 4787, 7821, 6730, 5952, 4695, 6673, 4305, 
           5348, 6086, 6489, 6490, 6151, 6152, 4047, 5435, 6150, 6149, 6555, 
           4412, 6683, 6684, 5955, 7022, 3898, 5480, 3893, 3947, 5102, 5623, 
           5622, 4255, 6649, 4622, 6647, 4621, 5168, 5167, 5911, 5912, 5441, 
           5440, 6806, 6473, 6474}],
          "1.08`"],
         Annotation[#, 1.08, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{7092, 4332, 7540, 4810, 6747, 4811, 6748, 4511, 5751, 5756,
            5590, 4809, 7983, 7988, 7405, 7410, 4162, 5786, 5901, 5459, 7400, 
           5464, 5848, 5842, 5172, 6505, 6510, 6167, 7153, 7158, 5450, 7148, 
           7143, 6346, 4422, 5098, 7565, 3940, 3883, 5066, 4391, 5224, 6114, 
           5222, 4042, 6606, 6376, 6377, 6381, 6380, 7523, 7522, 6378, 6175, 
           6176, 5806, 7910, 4923, 5910, 5042, 5166, 4036, 6978, 4037, 5233, 
           6648, 5234, 5300, 5299, 5073, 6322, 5074, 4411, 6681, 6682, 6678, 
           6680, 6679, 5482, 4068, 6204, 6203, 6554, 6553, 6153, 6154, 5421, 
           5422, 4834, 6021, 7066, 7067, 5436, 3973, 5129, 5815, 5814, 4304, 
           6685, 4700, 5951, 5958, 5959, 5349, 6446, 4373, 6445, 6448, 6447, 
           4338, 6051, 6443, 6444, 4369, 6050, 6049, 6048, 4337, 6438, 4364, 
           6437, 4363, 5339, 4297, 7539, 4331, 7089, 7090, 7091, 4380, 7094, 
           7093, 7092}],
          "0.96`"],
         Annotation[#, 0.96, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{7872, 4866, 7870, 4865, 7871, 3887, 7043, 7042, 7041, 4780,
            5733, 5732, 3963, 7865, 4855, 7864, 4856, 7866, 4854, 7971, 4963, 
           7969, 4962, 7970, 8058, 8057, 5572, 5573, 5094, 5584, 5093, 5655, 
           5660, 5284, 5649, 5644, 5835, 4117, 5190, 5830, 5824, 4515, 5755, 
           5589, 4808, 7982, 7987, 7404, 7409, 4161, 5785, 5900, 5458, 7399, 
           5463, 5847, 5841, 5171, 6504, 6509, 6166, 7152, 7157, 5449, 7147, 
           7142, 6345, 4421, 5097, 7564, 3939, 3882, 5065, 4390, 5467, 4205, 
           5223, 6121, 6607, 4597, 6268, 7411, 6266, 6382, 7524, 7525, 6383, 
           6012, 6379, 6013, 8055, 8054, 6980, 6981, 6857, 7911, 4924, 6859, 
           7895, 6844, 4906, 6842, 4905, 6320, 4212, 6321, 6060, 6148, 8107, 
           8109, 8108, 4046, 7136, 7137, 6888, 6890, 6889, 4938, 7933, 7934, 
           7930, 7932, 7931, 5483, 4016, 5157, 5056, 5924, 4356, 5420, 4835, 
           6775, 4836, 6776, 4365, 6896, 4941, 6215, 7204, 7205, 5816, 5817, 
           4943, 6897, 4942, 7945, 4076, 5794, 7203, 7202, 6214, 4940, 6895, 
           5130, 6841, 4903, 6087, 6088, 6089, 5675, 6957, 5010, 6956, 8026, 
           8025, 7048, 7047, 4789, 7822, 4788, 7872}],
          "0.84`"],
         Annotation[#, 0.84, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{7863, 7080, 7081, 3993, 5778, 3992, 7078, 7079, 8158, 8157,
            8144, 8100, 4848, 4680, 8138, 4681, 7746, 4246, 7044, 7045, 7046, 
           3888, 7480, 4256, 7049, 7050, 7051, 7752, 7753, 4696, 7755, 7754, 
           6067, 8140, 6068, 8051, 5041, 7115, 7116, 7117, 5909, 4025, 5160, 
           8099, 8112, 8113, 7122, 7121, 4026, 5795, 7120, 7119, 7118, 4899, 
           5426, 5425, 3904, 5423, 5424, 4701, 7760, 7761, 6899, 6898, 7946, 
           4024, 7992, 7993, 7991, 4979, 7994, 4978, 7990, 5047, 8059, 5201, 
           5932, 5933, 5866, 5865, 4195, 5864, 4196, 7452, 7451, 8008, 8007, 
           6943, 6432, 4355, 7548, 4354, 6773, 4833, 6772, 4832, 6426, 4345, 
           6061, 7101, 4009, 5345, 4008, 5342, 6843, 5344, 4904, 5127, 6858, 
           3966, 5528, 6011, 6010, 6755, 7834, 6756, 6265, 6264, 4163, 5594, 
           6803, 6804, 6267, 4864, 6805, 4397, 5219, 4203, 5438, 4204, 5289, 
           5290, 5064, 5101, 3938, 7563, 5096, 4420, 6344, 7141, 7146, 5448, 
           7156, 7151, 6165, 6508, 6503, 5170, 5840, 5846, 5462, 7398, 5457, 
           5899, 5784, 4160, 7408, 7403, 7986, 7981, 4807, 5588, 5754, 4514, 
           5823, 5829, 5189, 4116, 5834, 5643, 5648, 5283, 5659, 5654, 5092, 
           5578, 5583, 5279, 5274, 4112, 4961, 7963, 7968, 7735, 7745, 7740, 
           4294, 5567, 4295, 5332, 7292, 7291, 4509, 7622, 8036, 8035, 7862, 
           7863}],
          "0.72`"],
         Annotation[#, 0.72, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{8085, 4702, 5103, 6688, 4704, 6686, 4703, 6687, 5305, 5971,
            5970, 5969, 7774, 7773, 6697, 6001, 4268, 6368, 4722, 8033, 5024, 
           8031, 5023, 8032, 5743, 6071, 6070, 6069, 4875, 6823, 4219, 5880, 
           5881, 5243, 5242, 4018, 6439, 4017, 5158, 5905, 5904, 4357, 6696, 
           4721, 5968, 7028, 7029, 5354, 5957, 5956, 6942, 4699, 5678, 7413, 
           6588, 4523, 6431, 6587, 6586, 3972, 5621, 3971, 5128, 5396, 5395, 
           4303, 7534, 5346, 6059, 5343, 4344, 6425, 4301, 6387, 4302, 7526, 
           6386, 6190, 6192, 6907, 4431, 5529, 5762, 5761, 6917, 6918, 6242, 
           6241, 6239, 4522, 5150, 4000, 5446, 4001, 6044, 5437, 4378, 5218, 
           4379, 5221, 8103, 5220, 6341, 6342, 6340, 6349, 6343, 4049, 5447, 
           7155, 7150, 6164, 6507, 6502, 5169, 5839, 5845, 5461, 7397, 5456, 
           5898, 5783, 4159, 7407, 7402, 7985, 7980, 4806, 5587, 5753, 4513, 
           5822, 5828, 5188, 4115, 5833, 5642, 5647, 5282, 5658, 5653, 5091, 
           5577, 5582, 5278, 5273, 4111, 4960, 7962, 7967, 7734, 7744, 7739, 
           4293, 5566, 5571, 5337, 6233, 4102, 7695, 4107, 7290, 7285, 7621, 
           7616, 4238, 7606, 7611, 7270, 7275, 7280, 4953, 7956, 4668, 7725, 
           4673, 7730, 4289, 7601, 4501, 7255, 7260, 7265, 4612, 7690, 4097, 
           5257, 7716, 4656, 7715, 4657, 7958, 4956, 7957, 4955, 5059, 5058, 
           5917, 4954, 5818, 4674, 7853, 7854, 7850, 7852, 7851, 3988, 8064, 
           8065, 8063, 8067, 8066, 5057, 5060, 3872, 8062, 3879, 7010, 7009, 
           5003, 5662, 5661, 7747, 4682, 7477, 4247, 7476, 4248, 7478, 4688, 
           7482, 4257, 7481, 7484, 7483, 7756, 5303, 3899, 8085}],
          "0.6`"],
         Annotation[#, 0.6, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV0Vtoz3EYx/FnJG3T32Fj//8YOVw5NMdickrNcSwtJmzLTHHxnwvJsWyK
CylJjIg5loYhhSxitBvK4YIokRuK5lBjjq9dvH+f7/d5Ps/zfL/f39DVtUvS
GRGR4bN8QERt74iOnIgd/SKqB0fUYA3aciPmyC0siCjBPCzAfBSLL1NbjiNq
K4ZENNCl9qus0/Ir6YGBEZf78KvZpv+U/IjttIiuNOMczVL30Pqs9RU0Y5a6
WvWX5NL0Mt1Ak/SafD69SlO0l3NmoyUV0dTX2ZMR9YMiduGDeNL8arFsc0/T
M6gSe9U/YpMe39R9xynxPOdM4pf1b3QiKZeHreLt9l+wNi+ikI7BG3f9oc9P
dGCtM3XSGvrYe1TxVOC6fbF7fTA7U7+PNJu28j5AkfxAvh88z/S8qPYpzRdL
oc78+q7zueNO+kjtX/oPb931HSaIpeR3iY23bu56f5zQp8R9F+GCOQnnH8H3
3IwysfdqF9NM8UNi053tc9f7Yax3H4UH3u8pz2b5k2pb6H3M9sb9+NusM5FA
o1iK5uKdeW3qHuG4eAMS/JXiKX0HY5L/PwNFaJVr4b2HF7zl7t5DLCGXRbc4
00a0uuMd7BO7Tm+hRnw9alGuf47eU517tNqZdBy9y9/Me9AdlvKtQBW6y5eZ
VYp95h6Vv+kMe/ib+Pfbz+UrwRKU6d9b/5HqCvQtpMPobf7z/Lv5R/IVYiL+
2c+m0zEFe+33mFOP7V3vqVcdDfXD9Nprn+e/PZGvFL9hv4b+EmvUP219mK6j
x+h3uoB3svrh/uM0Wmr/0vqTc31FN3N74rUef9yt3f/5D0n8kuI=
           "]],
          "0.48`"],
         Annotation[#, 0.48, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{4897, 6838, 6837, 6724, 6725, 6723, 6722, 6002, 4279, 4776,
            8098, 3923, 5724, 3922, 8097, 5022, 4771, 5021, 8096, 3921, 5723, 
           3914, 8089, 5020, 4761, 5019, 8088, 3913, 5722, 3909, 8087, 5018, 
           4272, 7495, 7496, 6716, 6715, 7778, 5685, 6707, 6708, 6706, 6710, 
           6709, 7771, 7770, 6789, 4845, 7843, 4844, 6830, 4886, 6972, 5133, 
           6831, 4887, 6076, 7110, 6401, 4312, 7535, 6400, 6585, 6584, 6645, 
           7699, 6640, 6641, 6639, 4618, 5302, 5301, 4191, 7446, 6635, 4616, 
           6393, 4615, 6634, 3892, 5992, 5991, 6352, 4254, 7479, 6353, 6188, 
           7178, 5527, 4429, 5836, 5837, 5526, 5525, 3881, 3937, 7537, 7538, 
           6408, 4326, 6410, 7128, 5383, 4328, 5804, 4327, 5382, 3962, 5377, 
           5378, 4804, 7830, 7831, 6916, 6915, 7977, 4061, 6984, 6985, 6983, 
           5049, 5875, 5874, 6955, 6900, 6901, 6234, 7293, 4118, 5819, 4119, 
           6235, 5585, 5825, 5820, 5826, 5186, 4113, 5831, 5640, 5645, 5280, 
           5656, 5651, 5089, 5575, 5580, 5276, 5271, 4109, 4958, 7960, 7965, 
           7732, 7742, 7737, 4291, 5564, 5569, 5335, 6231, 4100, 7693, 4105, 
           7288, 7283, 7619, 7614, 4236, 7604, 7609, 7268, 7273, 7278, 4951, 
           7954, 4666, 7723, 4671, 7728, 4287, 7599, 4499, 7253, 7258, 7263, 
           4610, 6227, 6223, 5260, 4505, 5560, 4230, 7595, 4495, 7239, 7244, 
           7249, 4947, 7950, 4649, 7708, 4654, 7713, 4283, 7590, 4485, 7209, 
           7214, 7219, 4606, 7234, 7229, 7224, 4490, 5254, 5249, 4475, 8124, 
           4480, 4095, 4641, 8074, 3862, 5328, 4446, 8119, 4451, 4090, 7584, 
           4461, 7574, 4456, 7579, 4595, 5194, 4151, 5922, 4156, 5199, 6104, 
           7916, 7921, 7169, 7174, 4059, 5628, 5871}],
          "0.36`"],
         Annotation[#, 0.36, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{4775, 7514, 4278, 7512, 4277, 7513, 4770, 7511, 4275, 7509,
            4274, 7510, 4760, 7819, 7507, 7508, 7504, 7506, 7505, 7798, 6370, 
           6371, 6369, 6712, 6711, 7777, 5684, 6704, 6705, 6703, 4730, 5314, 
           5313, 3903, 6000, 5999, 5998, 4794, 6829, 4885, 6828, 4884, 6028, 
           6027, 6024, 4311, 6399, 5078, 6362, 4264, 6304, 6361, 6360, 6642, 
           4190, 6303, 6300, 6637, 6636, 5072, 6354, 6355, 6186, 6351, 6350, 
           6530, 4062, 6185, 6182, 4430, 6529, 5062, 5063, 5095, 5381, 4245, 
           5288, 6043, 3998, 5639, 7749, 4686, 6669, 4687, 6670, 4296, 6795, 
           4853, 6035, 7077, 3990, 5777, 3991, 6036, 5269, 4240, 5873, 5087, 
           7536, 4321, 7075, 7076, 8000, 8001, 7437, 7438, 4186, 5750, 4798, 
           7824, 7826, 7825, 4510, 6575, 6577, 6576, 4241, 5650, 5088, 5574, 
           5579, 5275, 5270, 4108, 4957, 7959, 7964, 7731, 7741, 7736, 4290, 
           5563, 5568, 5334, 6230, 4099, 7692, 4104, 7287, 7282, 7618, 7613, 
           4235, 7603, 7608, 7267, 7272, 7277, 4950, 7953, 4665, 7722, 4670, 
           7727, 4286, 7598, 4498, 7252, 7257, 7262, 4609, 6226, 6222, 5259, 
           4504, 5559, 4229, 7594, 4494, 7238, 7243, 7248, 4946, 7949, 4648, 
           7707, 4653, 7712, 4282, 7589, 4484, 7208, 7213, 7218, 4605, 7233, 
           7228, 7223, 4489, 5253, 5248, 4474, 8123, 4479, 4094, 4640, 8073, 
           3861, 5327, 4445, 8118, 4450, 4089, 7583, 4460, 7573, 4455, 7578, 
           4594, 5193, 4150, 5921, 4155, 5198, 6103, 7915, 7920, 7168, 7173, 
           4058, 5627, 5870}],
          "0.24`"],
         Annotation[#, 0.24, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{4773, 8143, 4774, 5123, 7820, 4772, 7030, 7031, 5324, 4276,
            4769, 8095, 3920, 3958, 4767, 8142, 4768, 5323, 5322, 7817, 4758, 
           7816, 4759, 7818, 7060, 7059, 7503, 7502, 3908, 3952, 4746, 7797, 
           4747, 5319, 5318, 5717, 5315, 5316, 4795, 5747, 4270, 5312, 4720, 
           6788, 4843, 6029, 7069, 7070, 5741, 6026, 6025, 6023, 4842, 6787, 
           4218, 6638, 4617, 6305, 7444, 7445, 5239, 6302, 6301, 6299, 4614, 
           6633, 4211, 6877, 4934, 6187, 7176, 7177, 5735, 6184, 6183, 6181, 
           4933, 6869, 4202, 6745, 6746, 6009, 7065, 3961, 5731, 3960, 7857, 
           7858, 6793, 4851, 6794, 4679, 6954, 5002, 5945, 5984, 5944, 5943, 
           8171, 5212, 8170, 4200, 5776, 4201, 5213, 6033, 6034, 5774, 5775, 
           4852, 7859, 7861, 7860, 3878, 5330, 8042, 5032, 8041, 5033, 5894, 
           5893, 3989, 6031, 6032, 5983, 6402, 8153, 3933, 6403, 6623, 6624, 
           5562, 4507, 5331, 4508, 5333, 6229, 4098, 7691, 4103, 7286, 7281, 
           7617, 7612, 4234, 7602, 7607, 7266, 7271, 7276, 4949, 7952, 4664, 
           7721, 4669, 7726, 4285, 7597, 4497, 7251, 7256, 7261, 4608, 6225, 
           6221, 5258, 4503, 5558, 4228, 7593, 4493, 7237, 7242, 7247, 4945, 
           7948, 4647, 7706, 4652, 7711, 4281, 7588, 4483, 7207, 7212, 7217, 
           4604, 7232, 7227, 7222, 4488, 5252, 5247, 4473, 8122, 4478, 4093, 
           4639, 8072, 3860, 5326, 4444, 8117, 4449, 4088, 7582, 4459, 7572, 
           4454, 7577, 4593, 5192, 4149, 5920, 4154, 5197, 6102, 7914, 7919, 
           7167, 7172, 4057, 5626, 5869}],
          "0.12`"],
         Annotation[#, 0.12, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV03loz3Ecx/H3zB9CuY85JsXQWHJTjFIoV445hlDKTVgII2JTkjuR+w/8
46g5hlGONKFcMzflaHJTyPn4/vHc6/N+f16f9+f9/vy+az55zrDZKRHRzJ93
9SN+1osorxGR2iTib+OID+kRFbjXIGJg3YjuNXmtO9F+4k+1IrY3jZhCN9Pp
dBf9rsZE66JmEbn0Bm8duQJxeu2I39bL5IvFi2i+/VUosO7s7h7Ixi9xe5qJ
DKwUH1D/tPvT9ZWpVhrNoNXUGlonYjDfAPTFOv5D/Kv4T5it0B3b5DqarRM6
YL8zk51NNVd13mqoirPyg+xv1mtJw4jXPOfpGZzDe/FZetj9m3j28+7DIfFB
tNRTSiPvyhd0rPrF/KfxNy0ix5k0jHMmy14L/n/ya/Wayt9VXIl2oRnqjeOd
wDsercStscC5+VhoL8/vt83eVuTJlTh3jOcLPUo/00L1HuvnkvUWua0YLjcM
h+VG0dEYgRyMxCRv9oPvJ+6K76MMR/gfJfVQjod4gLn837x1Nz3d9YY7rXdg
kbnumb0M0/Q3HTN5uiffgnP5WIoVWI5i9QfSQZiReDErmdd887BF7VyzfORb
L79Hbm+y5x0GO9MOWcjEYp629IrexvCOxigUyveU/6NWH7pW3Iv2RjZK+fvr
77We3+AljpvjFS2yf9ub3EGJWudxKplZfJJe00splvuW8rFGviDZc9dT3+Yz
PEdl56aa46B8T/5s9EKR77Sh+194uwb0gxpX5S47U4qbuCW+QM/gBC6KK/gq
8a9Ofl/zLKEb6Ao61x1P+MpxB9f5m/Ku0+9z66v6eEWzzPiIXhSX0Tz7Q7Bb
vFutjvb/uOejva/0Lf1BN/LkqDfUfhtzjaS5yf++90p1tgqauLc5Kngn+a1S
+P4DQcKytg==
           "]],
          "0"],
         Annotation[#, 0, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{4633, 8137, 4634, 4224, 4630, 4629, 5082, 5081, 4632, 8136,
            4631, 5245, 3858, 8070, 4636, 5083, 3924, 7003, 7002, 7001, 4637, 
           7700, 4226, 7465, 7467, 7466, 7704, 5262, 3870, 8078, 4661, 5084, 
           3931, 3871, 5265, 5266, 4796, 5748, 5085, 5086, 5942, 6737, 4802, 
           6007, 7063, 7064, 5730, 6726, 4778, 6008, 4779, 6727, 5007, 8060, 
           8061, 8003, 8004, 4985, 6940, 8168, 8169, 8167, 6289, 5734, 6728, 
           4783, 6290, 4784, 6729, 5009, 5532, 4440, 6884, 6199, 6200, 5238, 
           6356, 4262, 6201, 4263, 6359, 5077, 6785, 6786, 6022, 7068, 3975, 
           5740, 5742, 7883, 7884, 6826, 4883, 6827, 4879, 6825, 4882, 6824, 
           4881, 5371, 4320, 5080, 5079, 5682, 4220, 5244, 5025, 5890, 5744, 
           5745, 4880, 7882, 7886, 7885, 4891, 3949, 3906, 8086, 5015, 5884, 
           5883, 4028, 6435, 6436, 6433, 6434, 8150, 8152, 8151, 3907, 6908, 
           6909, 5974, 5973, 5110, 4726, 5311, 5707, 5702, 6914, 4135, 6255, 
           6250, 6604, 6599, 5138, 7647, 7652, 7331, 7336, 7341, 4541, 7326, 
           7321, 7316, 4530, 7642, 5116, 7796, 4743, 7786, 4738, 7791, 4971, 
           6263, 6259, 5376, 4536, 5600, 5142, 7661, 4550, 7363, 7368, 7373, 
           4560, 7358, 7353, 7348, 4545, 7656, 5121, 7812, 4756, 7802, 4751, 
           7807, 4975, 7388, 7383, 7378, 4555, 5148, 3979, 4575, 8134, 4580, 
           4141, 4570, 8129, 4565, 3956, 3918, 8093, 4765, 4146, 7676, 4590, 
           7666, 4585, 7671, 3984, 5205, 4175, 5928, 4180, 5210, 6162, 7938, 
           7943, 7195, 7200, 4072, 5728, 5888}],
          RowBox[{"-", "0.12`"}]],
         Annotation[#, -0.12, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{4628, 7461, 4223, 7032, 7033, 7034, 3856, 7462, 4225, 7035,
            7036, 7037, 3857, 7463, 7464, 7038, 7039, 3925, 3864, 6335, 6336, 
           5981, 5982, 3930, 3869, 5636, 3877, 7008, 5939, 4677, 5268, 5267, 
           5638, 7827, 4800, 6736, 4801, 6802, 4863, 7869, 4862, 8160, 8161, 
           8159, 6801, 7515, 7518, 7517, 7516, 6316, 8114, 6317, 6953, 4990, 
           6318, 7454, 5867, 4989, 6991, 5052, 6990, 7439, 7440, 6632, 4187, 
           7441, 6631, 6291, 6312, 6311, 4197, 6947, 6948, 6946, 6950, 6949, 
           4937, 6886, 8110, 6887, 6885, 7180, 4066, 6568, 4067, 7181, 6567, 
           6202, 4442, 6552, 4217, 5241, 4309, 5681, 4310, 5352, 6075, 4019, 
           5793, 6074, 6073, 6072, 5037, 6976, 5104, 6961, 5011, 6958, 6960, 
           6959, 5683, 4027, 6079, 5429, 4362, 5914, 4361, 7776, 4728, 7775, 
           4727, 7974, 7975, 7310, 7311, 4136, 5773, 4846, 7844, 7846, 7845, 
           4471, 6572, 6574, 6573, 4319, 5545, 4318, 5691, 5696, 5370, 5365, 
           4130, 7637, 4125, 7309, 7304, 7632, 7627, 5109, 5712, 5716, 5310, 
           5706, 5701, 6913, 4134, 6254, 6249, 6603, 6598, 5137, 7646, 7651, 
           7330, 7335, 7340, 4540, 7325, 7320, 7315, 4529, 7641, 5115, 7795, 
           4742, 7785, 4737, 7790, 4970, 6262, 6258, 5375, 4535, 5599, 5141, 
           7660, 4549, 7362, 7367, 7372, 4559, 7357, 7352, 7347, 4544, 7655, 
           5120, 7811, 4755, 7801, 4750, 7806, 4974, 7387, 7382, 7377, 4554, 
           5147, 3978, 4574, 8133, 4579, 4140, 4569, 8128, 4564, 3955, 3917, 
           8092, 4764, 4145, 7675, 4589, 7665, 4584, 7670, 3983, 5204, 4174, 
           5927, 4179, 5209, 6161, 7937, 7942, 7194, 7199, 4071, 5727, 5887}],
          
          RowBox[{"-", "0.24`"}]],
         Annotation[#, -0.24, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV0ltoz3EYx/FHGi6YbdjshBFWbjRDuSBCOU5csAhRDI2syA3mMCNnKXJs
LuSQ48Umh5ZjoRzalLCpmUkohJw2Xv+L9//zPN/n832+z/f7++ctWDF9ebuI
SPbTt1tETVZEJbp2jajoHbFFXNMzYm1KRDVdR8v5mtXW0589IjbQOvlG2i0t
YjN9K99E29QraH2iF81WnybeKp5KK2kR/cfXT61Hr4gMpGOrs2ZnRMxBsXly
0D6dj87LjhhsvYP5klBobyc6nhZaH4oiea18tXiP+Jw9T53Vau26/uflh9QK
ciOG4Lb7LZAvxG6+PZjvrHyU8BbQvdZyxSN5yszXmhmRpt8fmkr/0jnWD+p1
ACnOSUUa3qgl8TTTJqSI++iVh9O8Z7DI3hZ3XExzzXTWWr76QIwRH/dOxakR
S3mW4Zh8v5mO0jXdI95hpDlL+YvMONC9B6DY+bMwE531aVYvtKeTXpf06UiH
yK/YP4wOx3vzVfGfQDJ/F/zI8cZmmySejIm46hvmOCs78Z3UGvV/jZdowCs0
uu84te3iC3p/wkd8xWhn/jDzLZ4vdDLPZ2vn1U6hwb4RZhyFX9a/Ic9avffJ
oTvMVInH8gf4lvhP8c7ADd4JdCzCrP35S/UvwQPn3U18B54G+5pQpc9JnMU1
b3KEHsA+XJQ/5/mtf5k3qfA+JbScltIl1lfpuxJtelbzN5q/u/iDfXfkN/W5
h4d4JL9Oa3AZtfIWvn/6bNRvn75r6E66lpZaf8H3DE9wnz9L723erEF8x/+g
iQ5yx+e0Vl5HyxJvisPyw3oNVv/tnI9qn+k7+p3u4pmh3xT1Ab7ldDpLnuI+
YW8SMp3bCy28c71pG/4DFKKjQA==
           "]],
          RowBox[{"-", "0.36`"}]],
         Annotation[#, -0.36, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV01toz3EYx/FnmtOFjY1hM4y5kdPmSmpku1B/U1biZiVhDsshY5FCSQ47
2LAyF3YjUhI5hUQoh1AsS/13oYwyjEZZtvH6X7z/n9/zfJ/v53m+32//grXb
KramRcQIP0NzIhrHRpxAcVZE3ZSI3MyIVZgxOWJWfsRsHMiLWGFttXwFDfvS
cDQ7ol6cJz9EXEDnqp+HOWgcHVFEp6Xy4yNK9UjPjZhPh9MyWiRfjEI1C2mV
Xi94bqDr0aDHSnG52kZ7+mkD/UuHmjsd1ydGXBwTUTnBrJMiDuKCfIGZpmEv
jzPWWlFppvfjItbw6LLvE07JZ5kzG6d9t2CdWdajWe+T2Gy++dhipmqMRhbG
YBf/HDoe2VikvgRf1H/V5xu6kVD3nd40+yZz3aJlet1Onc19J6xNN0OtGQvp
DWujkIG31pbYX+h7QI8O3td4vKP94kH5dvsGUrU06VydqBPXo9mZS93RRGe6
zadJfAJt2IkaZMi38Vys7iPdL9fvLvfQc+JyZ0rwHma2NIw0czqO8b+u5jN2
29tNf2KxN/htvofm+EET6nrkLlu7gCSvBXxL8Ee+F1Pl3vLOo8f1PoxX4mfo
Nd9ytRW4p3YpLcU/d1Oovpp/FZ7p9xiZapL2fUAbn/O4hDtmPEtb0IQr4g41
ffx3OM8h71FF99NqulG+hu/21N3zvKG+0/zZvr/Y90j8gM8TPMdL8V16E1dx
X9ylbpDPQX5NfGtpHd1Hq+Xfq2vHazxNvRPvI+4s6fuRe/9AZzpjB70vfkN3
pO4UreJWXnOt9+nTba2HfqK/aH3qf8tvmfUZ3n8FXSXOdJ5/qTe0f4K++ehS
W+lOB/AfzmGfVA==
           "]],
          RowBox[{"-", "0.48`"}]],
         Annotation[#, -0.48, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{6338, 4243, 6337, 4242, 6666, 6667, 6665, 4683, 7748, 3934,
            7012, 7011, 5946, 4684, 6668, 4249, 7751, 4690, 7750, 4689, 3944, 
           3889, 7485, 7486, 7052, 7053, 7054, 3894, 7491, 4265, 7055, 7056, 
           7057, 3900, 5679, 5680, 5014, 8149, 5013, 5686, 4723, 8141, 4724, 
           4021, 4895, 4896, 4892, 7889, 4894, 7887, 4893, 7888, 4987, 8005, 
           4988, 8006, 4531, 7342, 7343, 7344, 5372, 4137, 7976, 4967, 7787, 
           4734, 7782, 4739, 7792, 5112, 7638, 4526, 7312, 7317, 7322, 4537, 
           7337, 7332, 7327, 7648, 7643, 5134, 6595, 6600, 6246, 6251, 4131, 
           6910, 5698, 5703, 5307, 5713, 5709, 5106, 7624, 7629, 7301, 7306, 
           4122, 7634, 4127, 5362, 5367, 5693, 5688, 4315, 5542, 5548, 5358, 
           6218, 4079, 6592, 4084, 5183, 5616, 5610, 4469, 5606, 5555, 6281, 
           7683, 7688, 7424, 7429, 4170, 8012, 5790, 5496, 7419, 5502, 5859, 
           5854, 5178, 6561, 6566, 6209, 7186, 7191, 5489, 6689, 6493, 6499, 
           6155, 7139, 4048, 5418, 5419, 4418, 5156, 4417, 5518, 6066, 4015, 
           5523, 5236, 5237, 4465, 6213, 6614, 6615, 6617, 6616, 4075, 6211, 
           5538, 4463, 5813, 5180, 6932, 6933, 6287, 6288, 4184, 5861, 4183, 
           6286, 5672, 8146, 4694, 5863, 4693, 5297, 4253, 5393, 5394, 5295, 
           5294, 5619, 3965, 6581, 6582, 6418, 4521, 6583, 7431, 5592, 4519, 
           5669, 4518, 5591, 5338, 6405, 4322, 6404, 4323, 6406, 4244, 5780, 
           5781, 5286, 5285, 6407, 3995, 5215, 5216, 5896, 5895, 5061, 6797, 
           4858, 6037, 6038, 6039, 5779, 7084, 7083, 7082, 4857, 7867, 6796, 
           6338}],
          RowBox[{"-", "0.6`"}]],
         Annotation[#, -0.6, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{5858, 5501, 7418, 5495, 5789, 8011, 4169, 7428, 7423, 7687,
            7682, 6280, 5554, 5605, 4468, 5609, 5615, 5182, 4083, 6591, 4078, 
           6217, 5357, 5547, 5541, 4314, 5687, 5692, 5366, 5361, 4126, 7633, 
           4121, 7305, 7300, 7628, 7623, 5105, 5708, 4269, 5306, 6245, 7000, 
           4525, 5596, 5772, 5771, 6997, 5054, 6996, 6999, 6998, 5040, 8049, 
           8050, 7111, 7112, 4020, 5908, 5882, 6993, 6994, 6992, 5053, 5907, 
           5906, 5159, 6995, 4725, 6698, 5961, 5960, 4705, 7762, 4267, 7492, 
           4266, 7493, 7759, 7757, 7758, 7489, 4259, 7487, 4258, 7488, 4691, 
           8068, 4692, 5667, 4781, 8043, 5035, 7095, 7096, 7097, 5876, 5008, 
           8022, 8024, 8023, 4298, 7519, 7521, 7520, 3994, 5664, 8020, 5004, 
           8019, 5005, 5985, 3935, 5214, 5379, 5380, 4324, 6040, 6041, 3996, 
           6625, 3997, 7925, 7926, 7924, 4932, 7927, 4931, 7923, 5044, 8056, 
           5179, 5930, 5931, 5878, 5877, 5879, 5670, 4182, 7433, 7432, 7997, 
           7996, 6927, 6419, 4341, 7545, 4340, 6754, 4817, 6753, 4816, 6422, 
           4343, 6053, 6056, 4006, 5296, 5671, 6936, 6937, 6850, 4982, 6938, 
           4829, 6771, 4831, 6017, 6019, 6020, 5537, 6569, 4464, 6570, 7586, 
           6571, 6274, 6273, 4164, 5539, 6818, 6819, 6276, 4873, 6820, 4410, 
           5155, 5154, 5519, 4353, 5516, 5517, 5410, 5510, 5509, 5966, 5515, 
           4719, 6498, 4714, 6693, 5488, 7190, 7185, 6208, 6565, 6560, 5177, 
           5853, 5858}],
          RowBox[{"-", "0.72`"}]],
         Annotation[#, -0.72, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{5918, 5055, 5151, 4005, 5439, 4004, 7099, 7098, 8045, 8044,
            4867, 6855, 6856, 6854, 7130, 7129, 4040, 8105, 8106, 8104, 6107, 
           6052, 6420, 6054, 6055, 4919, 6849, 4920, 6851, 4828, 6768, 4830, 
           6016, 6018, 3970, 6865, 6866, 6864, 7528, 6863, 7531, 7533, 7532, 
           6392, 6275, 7412, 6277, 4602, 6619, 6147, 5412, 4352, 5479, 4406, 
           5409, 5478, 5403, 5508, 5965, 5514, 4718, 6497, 4713, 6692, 5487, 
           7189, 7184, 6207, 6564, 6559, 5176, 5852, 5857, 5500, 7417, 5494, 
           5788, 8010, 4168, 7427, 7422, 7686, 7681, 6279, 5553, 5604, 4467, 
           5608, 5614, 5181, 4082, 6590, 4077, 6216, 5356, 5546, 5540, 4313, 
           5697, 5355, 5972, 3905, 7972, 7973, 7025, 7024, 7023, 4709, 7766, 
           4708, 7881, 4877, 7879, 4876, 7880, 3974, 8037, 5030, 6971, 8039, 
           8038, 4872, 7876, 4871, 7877, 5036, 7874, 4869, 7873, 4870, 7875, 
           4868, 7894, 4901, 7893, 4900, 8052, 8053, 6080, 7123, 7124, 5796, 
           6083, 6082, 6081, 4902, 6840, 4250, 6902, 4964, 6236, 7294, 7295, 
           5663, 5668, 8002, 4983, 6939, 4984, 5760, 5759, 6966, 5027, 6965, 
           5028, 6967, 4325, 6751, 4815, 6750, 4814, 5386, 4339, 5918}],
          RowBox[{"-", "0.84`"}]],
         Annotation[#, -0.84, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{5856, 5499, 7416, 5493, 5787, 8009, 4167, 7426, 7421, 7685,
            7680, 6278, 5552, 5603, 5602, 4466, 6779, 4840, 6778, 4839, 7549, 
           4358, 7107, 7108, 7109, 4921, 7764, 4706, 7763, 4707, 7765, 4306, 
           5350, 5954, 5953, 4697, 6674, 4261, 7490, 4260, 8111, 6449, 4374, 
           5153, 5152, 5903, 4346, 6671, 6672, 5949, 7017, 7018, 3945, 6578, 
           4516, 6440, 4517, 6579, 4299, 5757, 5758, 5126, 3964, 5432, 6453, 
           4381, 6452, 4382, 5388, 5387, 6092, 6091, 6519, 6520, 6173, 6174, 
           4053, 5292, 4052, 7161, 6172, 6518, 6517, 4389, 5390, 6421, 4342, 
           5471, 5472, 5392, 6550, 5391, 4043, 5770, 6766, 7135, 6767, 6129, 
           6769, 7838, 6770, 6179, 7163, 6178, 7527, 7529, 7530, 6390, 6391, 
           6389, 6388, 6618, 4045, 5411, 6139, 5417, 4405, 5408, 5477, 5402, 
           5507, 5964, 5513, 4717, 6496, 4712, 6691, 5486, 7188, 7183, 6206, 
           6563, 6558, 5175, 5851, 5856}],
          RowBox[{"-", "0.96`"}]],
         Annotation[#, -0.96, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{5855, 5498, 7415, 7995, 4980, 8163, 7839, 4837, 7840, 4838,
            6777, 4350, 6429, 4351, 6430, 7138, 6427, 4348, 7547, 4347, 6848, 
           4917, 6128, 7134, 5803, 4916, 7909, 4918, 7906, 7908, 7907, 4034, 
           7903, 7904, 7902, 4915, 7905, 4913, 5801, 6125, 6123, 5043, 6979, 
           4366, 6441, 4367, 6442, 4300, 5341, 6085, 6458, 6459, 6093, 6094, 
           4035, 5228, 5291, 4251, 5524, 4252, 6515, 6516, 6512, 6514, 6513, 
           5466, 5389, 5469, 5470, 5677, 5676, 4398, 6551, 4439, 7569, 4438, 
           8154, 8155, 8115, 6549, 6130, 6483, 6482, 6815, 6484, 6485, 6141, 
           6143, 4044, 6522, 6524, 6138, 6134, 5416, 4404, 5407, 5476, 5401, 
           5506, 5963, 5512, 4716, 6495, 4711, 6690, 5485, 7187, 7182, 6205, 
           6562, 6557, 5174, 5850, 5855}],
          RowBox[{"-", "1.08`"}]],
         Annotation[#, -1.08, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{6140, 4407, 6816, 6817, 6062, 7105, 6479, 4399, 6478, 6481,
            6480, 4065, 5473, 6675, 6676, 6198, 4698, 6677, 4434, 5071, 5070, 
           5293, 4208, 6461, 4384, 6456, 4383, 7556, 4030, 5340, 4029, 6084, 
           4914, 6124, 6126, 6127, 5766, 7835, 7836, 6759, 6761, 6760, 4375, 
           6765, 4827, 6764, 4826, 6428, 4349, 6065, 6468, 8102, 4014, 7106, 
           6469, 6470, 6323, 7458, 4214, 6324, 6556, 7570, 4415, 5490, 4710, 
           6494, 4715, 5511, 5962, 5505, 5400, 5475, 5406, 4403, 5415, 6133, 
           6137, 6523, 6521, 6525, 6146, 6526, 6142, 6140}],
          RowBox[{"-", "1.2`"}]],
         Annotation[#, -1.2, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{5808, 4926, 5075, 3895, 5484, 3901, 5504, 5399, 5474, 5405,
            4402, 5414, 6132, 6136, 4426, 6145, 4428, 6528, 4409, 6810, 6812, 
           6064, 7103, 4011, 5445, 4013, 6542, 6544, 6477, 4436, 6545, 7179, 
           6197, 4437, 6548, 6193, 5231, 4209, 6881, 4207, 6460, 6455, 7557, 
           6454, 6878, 6879, 5163, 5811, 5161, 5802, 4822, 5768, 5769, 5765, 
           5764, 3969, 7989, 6923, 6924, 6467, 7558, 4386, 5398, 6612, 5397, 
           6100, 6099, 5235, 7457, 4213, 5808}],
          RowBox[{"-", "1.3199999999999998`"}]],
         Annotation[#, -1.3199999999999998`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{6194, 4435, 6813, 6814, 6543, 7104, 4012, 5444, 4010, 7102,
            6063, 6811, 6809, 4408, 6527, 4427, 6144, 4425, 6135, 6131, 5413, 
           4401, 5404, 4400, 6860, 4927, 6177, 7162, 5807, 4925, 6862, 4929, 
           6861, 4928, 7912, 4039, 6613, 4600, 6611, 4601, 5443, 5442, 6272, 
           6271, 6270, 6762, 7837, 4825, 6763, 4824, 5767, 4823, 5812, 4936, 
           5162, 4935, 6457, 6883, 6880, 6882, 5230, 5229, 4064, 6546, 6547, 
           6196, 6195, 6194}],
          RowBox[{"-", "1.44`"}]],
         Annotation[#, -1.44, "Tooltip"]& ]}, {}, {}}}],
    AspectRatio->1,
    Frame->True,
    PlotRange->{{-3, 3}, {-3, 3}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyEvXWYV8X7/78NUhJKqZSEKFICAoLn0CkognSnINIpSEmnNCIIiICgkgJS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     "], {{
       {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
        GraphicsGroupBox[{
          PolygonBox[{{9652, 4161, 457}, {8286, 5228, 815}, {1906, 1905, 
           457}, {11036, 8920, 815}, {1607, 1242, 945}, {2210, 1905, 815}, {
           4504, 7248, 1425}, {8326, 9465, 1905}, {4779, 6865, 762}, {6234, 
           7311, 1333}, {1759, 1970, 1758}, {7243, 7244, 1553}, {11914, 6127, 
           3030}, {10646, 8637, 1970}, {3990, 6950, 413}, {6721, 6720, 
           1425}, {6146, 9665, 1242}, {1333, 1606, 945}, {7290, 6234, 1333}, {
           7311, 6214, 1333}, {2322, 1607, 945}, {9668, 9667, 2330}, {6950, 
           7593, 413}, {6886, 4779, 762}, {4798, 7087, 1525}, {1425, 1553, 
           815}, {7490, 9666, 1607}, {8103, 3990, 413}, {1333, 945, 126}, {
           6846, 7269, 126}, {7248, 6721, 1425}, {945, 1242, 126}, {2330, 
           1759, 1242}, {8900, 4504, 1425}, {8920, 8286, 815}, {7059, 7610, 
           1525}, {775, 762, 413}, {1759, 1758, 126}, {7610, 4798, 1525}, {
           1553, 2210, 815}, {7594, 7059, 1525}, {6493, 4832, 775}, {1404, 
           2321, 945}, {2321, 2322, 945}, {762, 1758, 413}, {8306, 11056, 
           1905}, {1242, 1759, 126}, {4850, 6493, 775}, {4832, 8047, 775}, {
           8636, 10646, 1970}, {4413, 6619, 1404}, {2321, 1404, 457}, {9464, 
           9652, 457}, {7491, 7490, 1607}, {1758, 762, 126}, {8028, 6886, 
           762}, {1404, 1906, 457}, {1525, 775, 413}, {3030, 2321, 457}, {
           1606, 1404, 945}},
           VertexColors->None], 
          PolygonBox[{{6128, 7491, 1607, 2322}, {7244, 5918, 2210, 1553}, {
           7269, 7290, 1333, 126}, {7593, 7594, 1525, 413}, {7087, 4850, 775, 
           1525}, {6214, 7470, 1606, 1333}, {5228, 8900, 1425, 815}, {8104, 
           8103, 413, 1758}, {9665, 9668, 2330, 1242}, {8047, 8028, 762, 
           775}, {9666, 6146, 1242, 1607}, {6127, 9658, 2321, 3030}, {6619, 
           8327, 1906, 1404}, {8637, 8104, 1758, 1970}, {9658, 6128, 2322, 
           2321}, {4161, 11914, 3030, 457}, {7470, 4413, 1404, 1606}, {11056, 
           11036, 815, 1905}, {8327, 8306, 1905, 1906}, {9465, 9464, 457, 
           1905}, {5918, 8326, 1905, 2210}, {6720, 7243, 1553, 1425}, {7816, 
           8636, 1970, 1759}, {6865, 6846, 126, 762}, {9667, 7816, 1759, 
           2330}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.3347548659336615, 0.12928152367772175`, 0.5875187769567893], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lmtM1nUUxw88wPPAA/KEDghB5Nbi7oJ80+gCmUskGlnZZV1oba3UWutN
NrVcIIn1os2aNTfNTC2Xq7ZAIbCiTRboInvV1nzRi9raslWblrW+n87hxdnv
9/9dzuV7vuf8/jWDTw9syTazC5KE5NlrzR6S1BeYrck1+1LjuA48VWS2XjKn
7zrJrCSl9XdzzEYLzRayzF5I+vwdrf3VaPZ3o99nbU+cuT5ldlBrczo7s8Qs
u8nsLdmd19pZyRXNbysxSzb597kC38NWjtZarvI5gi/npHNMdr5udL34OR96
3qs0+3iZWUWeWfsqs+0Z7en8a4rrE9kfkI6NdWabJTfKr37dvaPIfXu73ux4
qe5ovaXWrFVSpvmGpN/NE1gdCY9nj7lO9ll/Xvs3aP44fsrntSUex0fy5V7Z
6tLetqSPnOnWWqrG8Vsolz19v6r1fTpfVue6+gL/6gK3P1Tg/j8qe2fyzU5q
vqJMZxRzRvjPtZg92Ob4vKxxSPJt2mxpno9TOjOyQvlpcD0HtD6V9tyR+5FC
z/Mp7f8qvae1ficYSQZl83K+Y0G8h3Q3o+9pnSnXeLXkX9mdSLseYilqN5us
8/vZivGLBj93VuemE45hZ8J1J3X+Ypnbxu5q8bFWslL+rNP4ZOSRfPLNfG+R
cxKf62Mk9t3K4c52t/GV7JWmHTP84hy+jQurC5KetNsAY3SC3+sZ14Of1cGr
73M9fmLfUGz2zDWeg/t0/gHJZNpzBCfygiNwihiXi4c9q5xrT4gXH1S5vld0
b0Tyne7+pNhn5fOniv0R6e6TjYl85yY+4EtXwmuPmgJ3bJHHAd07scz30cU6
+1uk565ix4B65C65vi7hXCBfu2R/WHI+7TFMBB/Ajl6A/6yBNfgW57iPf+pu
juzeLf2n5MNu6bhFuG3O9e8DOe4zMf1c5newOxZ3yc9oqduZUc4/b3AeFUoO
pvwcPEAf925tNtshDj0s3b3i+80VZpfMeTgdsSRUd1lNzgnyTX3Aq03NXmPk
/R/1jCuSmQKP6Y0i70Wb0u4j8c3GHuvUH3WIXfoFPY2aHZe/Jxu8BvARv/F5
m85kaX4+uEP+4NUaYVC/XH0hx3XSs+AVHOEMWKEbG+SX8aaYs98feoZXes1T
79gDK+bz0Qfpj/C5L3jD9/rwvzrm2AUbYgVD8g4O5PmSeuDletf7pvIzXO8x
0bsYiQs+gS9vxOqUc52+SF4zoZNaQx+cIQfYYx1OcQ9e9VR5zZPno+LOj3Wu
vzvjvWOx7/SH/ueS3o9YW+w75H3nEn9XyBe9biq4drTa7LMa71nFwTt8mAke
4xM4gRf4zAdevDO9oYM7+HUs477d3+b2sAVfRvP8DGNv2Nhf4fFwnh62sdlt
kOv/82weQ0f0ve4SryXqhpxmQg+9aW7RN/XtoeDP6fCN2H8XH36QbJXu8pT3
FfpPp+K+XbIj6Xu8TwvBsdHg8GPy88PoGxeVi9+q/E04IX33ZBzvDumoqvH8
1wU29EYwpvbwAZ5uDf1d8Rbyxplw+6XWOTIh3cclu3TnfY3HJEOBGTkjnqF4
58hXebwtA9FL6BNgR20RE9iuq/E4+d4eHMUusdHDqPcXFV93hb8znYE3HBiP
d5Tv8egT5IW34kzwG+zJAfHSHw8Ft+jLS8N3uETvgE/7WsULyUja+cDYGz2X
WsAfsAEjsOI/5Uil/6tQf3ujBqeiF3OP/NDfuQM/wID6/abcecMaeRqM+PiP
e6nZ3zn65R8tzp925aGt1jlypNprA5zJAZyBV2DQEe/y4Ur/l8I3+hb8Wxv9
eCz4h++H40yq1d9U8KIH50Yf5s2BU8QyWeP/H+SUeImROvoPerF0Ew==
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlWto1XUYx5+dnW1ns3JbY/dTuhs659nC8k3McktX2cXMyjRdFErE5mT1
Ri0japslXUjQpgRGgZTCKjRva6uclKSZtqAwwt50gbCLvdBu9PnyPS++7Lff
7/k/t+/3ec70h/qWrE1ExHqQBN/URXRPi1gFvub8VnHEnOkRTxZETOZE3D01
oqIlonxKxLFC3tMRTTURZ/MiBvIj9vD/goqIrqTvtlZG7GyI2JSKWJ2w796y
iJ4yx+iojhjh7+P4vzY34jHO18yKaAP92XMa1GbveusjPuHbG/A3D9xMrOHZ
EZvJZwvxvy+NWHd1RB84x7mDfDrBh+TzH/l3cZffHHGyKOJUkX1dIM6GAvvc
1xhxkXxf53wZ9eVhmwQpcj+OfS7fH5jJO+frsLmdftxRG3ElsY9gv4987s9E
jJLPGLiK3m0vp38p93AFb8vBjrDNJWINEr846Zg7qKW7KWJR0jWpdnEiLtSD
f4j9BDY9vE2Qw2Z8tdPDF+n1V9z9UuccldtcMMj7eXJ6g/wmeX8UPufOiJjG
tyfpxxf0s4O7O7FdDL6twif5DIGznEd538l5Tq5t9uPrVmp6ilpyCq2FpfTg
00JrYm+5a1at4vxX7J8nh948c5DibVm9uduIzXt655tx/O9KurafuHs/6Rq3
4Xs3XC7F9lKhazkIR8WFrmkL325CYwvy7OM2uFgELoZ7+hG2Cd6rsK8Egw2u
QbmLkz56/e9M9/IQHC+jxzeB7oR7tJve/IZ+dhHrzaS5ebDJXIujp7HtAS9g
34B9Swk1Nltb0syqKmtSWlzJeYBePAPG+PZL6psFX62gklzyyf8zcpmkRycK
rLEEvnKbrT1p5m/ee4l/EN9Hufu40RqXtlXjIf4/AMaT7pG4i3prQRwexnZr
jedziJq66E0rdxmwkPMHxN5GjIEi93x2nXNUbhUp5z6UsZZUwwC+jqSzvpKO
/VzGWlQOf6KPFJx2TnFPz/H/CXAqx3c3ot351Z59caba1jZ5t6jGDLEfKfUu
UY/E9V8zXbs4fwV++me49/I5v9gzrNmV5irqvYO0e65PubZRalyScI1r0MpG
sAGsBgX0+vwVzBm5fM77vBLPhGahnXOL5qXe2hXnaXy9yw5pz873zxXeSdpF
0vB39P84WF/gHaPdd4yaJuq8A+8t9gxq9rQDj5L7RKO1qhxvwf9r1d69mrn7
sN1f4noUc6TMGpU223OtnZo2ZvVya6iTc2ubZ113L9eac3H9Uq1rPc35cMI1
r6i0jd6Wcx4m1l2cF4NXS7xrWuqsBe0c7Qrt7P7szpC23k77t0B6kLbUQ/VO
GjvD9+NgDJwG72B/AX7/ACM13qXPZjwb2qnq3XCZuVMPxZVyVG7iTLt+JXgg
u/Ple02WS8X4EezF9x7wQ7V/q7RTtEukqd/T3tna1ZrxdU3eCdoF2mnKTTOs
2VWO8nUmm7t8iouHq917caJcFFOxlJN+axaWWkv6zRkvdc2qdazUWlCP1Vtp
4p6p3onaheLkf2N8Hcs=
           "],
           VertexColors->None], 
          PolygonBox[{{7596, 4799, 4798, 7610, 1671}, {7249, 5248, 820, 6721, 
           7248}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.36713428128394926`, 0.18558058242499736`, 0.633031962266945], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl29s1fUVxs+95QK995YCo+1gQAOG/u8lke0FkaJ7MUGSlpSCtnV1i27R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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmtM1mUYxm9OCUKK9HKQsyAE+AJmWuuDZqBiuFYiJp5drrQU0uxDLc/L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           "],
           VertexColors->None], 
          PolygonBox[{{6814, 5299, 5298, 7334, 1452}, {7336, 6375, 654, 7333, 
           7335}, {8501, 6814, 1452, 8521, 8500}, {7886, 7046, 7045, 7885, 
           1813}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.39951369663423714`, 0.24187964117227306`, 0.6785451475771007], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHuMlVcVxc8wzHvuHZm5MMzDeXrnJXfARLDDw8ZIjdEYsQj0SdW0aRgM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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHtwldUVxU8wCU3AvIGbkCchIcnNTaAtKAIiJXRsZVrL+xmw/0BFQxWc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           "],
           VertexColors->None], PolygonBox[{{7019, 7901, 7900, 7899, 1096}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.4318931119845249, 0.29817869991954865`, 0.7240583328872564], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmGtwldUVhndycpKcEMIlhHMC4RByJZKchGm1drwwUynqjPhDqYBNAFFb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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXl0VdUVxk8CCRnghQwvee8lJC9kTkhe1BpkVgjUCVcroygQcCIMAgm4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           "],
           VertexColors->None], 
          PolygonBox[{{6467, 7104, 7103, 7113, 1383}, {10977, 10190, 808, 
           5206, 10976}, {8839, 4464, 1412, 8859, 8838}, {4464, 10956, 10955, 
           10997, 1412}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.4642725273348127, 0.35447775866682435`, 0.7695715181974121], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmGtslmcZx+9SCvT0YottOaylh7eFt5QyoUUgyBwbxKkRLS3dnDuIazls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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJw1mXeYldURhw+7YVkEd1m2wS4L22ALuwsWBIwRCyX2KCCgRBQNKkoXTFQk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           "],
           VertexColors->None], 
          PolygonBox[{{7223, 6334, 639, 7221, 7222}, {7116, 3970, 3969, 7115, 
           1537}},
           VertexColors->None]}]}, 
       {RGBColor[
        0.49665194268510054`, 0.41077681741409994`, 0.8150847035075678], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl2ts1eUdxx974Zy2B7A0a8EKLaWnp5fTni3LBNGF4o14eeEFJRubMJiC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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHl0VFUSxi9ZmwSTNJlspkO2Dkk6nUVRCCJjEEhwVPAoa9AjiwoSCIsg
nnGUyGrYBMWRA4LAYVHQICi4zohsjgqIjoCISgB1BBzBIQqC4vw+6/3xna68
vHdv3bq1fFW5w8beXh/hnNvQyrkofkcXOzcKdOFhXZxzjdnOnS117gx4HLmw
yLm7Spy7E7RH3tTWuUNXOncQvIy8n28P5zr3GfgIeQS4F1zHeiNYb0WQb1J5
FzyH3CHHuTW8uxpcjbwg7NxIMAI8Eba1d4Id3h6typ3LTnduF8oOa+PcT6yz
I8m57aAFuaU9uiY79wM4h5z2J+eeDDm3EKQid+adiXzfJdq5KZHOTeDZB3nO
vQ/GIy/lu5G8OwIsQfaxZyTPI0Ascn2Bc3PRYQ4Yg7wohf2xxXbwFHJXzno9
aEK/jpx3NjZq5tujoBF5P9/VJjjXHVtfQP/bOOOf0akr6INcwR6VqabbDHQM
ZTpXjr4VyF9F21lPs9epEjvzbtb8HBwGu4pM14pCvik0nb/mN4r3IsEJ5D68
Mxa5HvRG/iGL+8TuY2P5vpXd7U2gl3fH05LsG707FfkK7umufP4H2iD/jm4t
nOccuIy8Ex/ZjC03gR3IEzKcW4dd1oLxyF2KzIfkO9eBI9jjc3ASexRd4dyL
Ac7HOqfABuQJ7LOHc3wIxiP3Yc/OoBL0Bh3RMQ/kgmvBHWXO9QVjOM98bLiZ
PZaDZfJVMNPP/XM/k7ibJp/5yqPc9SMh85kS9nkA3SeAEHI//P4r7uNL0Bf5
vUTnbuW9W8Bu5KH8lvFtKRiC3Mj6C3mvjPuvwecrOEddW7s73eE+bL2cdZeB
vchD+P/TnHMRuBt5HT6wBixG92vjTbdtrPmO33QM4A+d2bcSZCJPYs/+PO8H
JiL3qnDuGtAB1IDmds715N0e4CjycNa+B3wdg2+yRzUx0hOURpnO8t2HsN/u
ePPhtDTnviVOF2CrJ8Hj/H0P6w4Hs5BHF1qMKbbqkHfz7SXu+iLYhbyRO2nh
f+dAU4nZSjpLV9msFjs3Ib8EBiEXYOcg+uWDIPIhbHIV914BDiJfyTki0Wew
9GmNrVjjJLb5DqwOWWwOIi4HFliMfsrzs3x7Bvwb2c+aaeiVCpKQl3GGDPw6
HTyL3JZv3uXdbcBfbmv/DV0eDtseisVRxMzgGLvPrdhuFVgJtrQ33bWH1tYZ
DuMLu8BO8Bk4XWY5S7nqFPItrHcN63UANyPn49PP8r+lIC/XcsdS7LakxHLI
J9zhbO69EXyMvAibN4Ap4CnQnzisK7bc3cD9buKdgei1CVv5Yu3ulMOUu3SH
nbH7KHLO/co7yXZ3R7Dx54l2h2+EzMay7etgaaKdWWddgjwxzXTQ3g8g92P/
+4ot1z/K/q/i44OxbS14BbkbNtjHe3tBFXIpz3vxvAaEkyz3d8MuVWVWA3RX
2kNr6858KZZzlGtiUyw2KnmvU9hiJJFzdeTdSnz3NPcznXsMomc5ua0bPhPF
GnvRfQ+IRI7j/WPovIn/bQbz0WkuKOL7BmIgDl+7GlwFWgctt/YA3b0c24m9
NmLjWGz7Gt9XppnNZevX+XtQguV05fJZkRZLqbyz0Gcx1R09VvN+Pvst5o72
4XMOnXL4+6c2lgsVQ4od5cRjvP8K59kMmpHryBsNYAoYBXw8X0qeXQJikQPo
6AOxIBN8jz0Ol1uu7c/+y7FZf77rB5Yhb8MH/so9x+PfV6Lv1nKLecX6lnLj
ArKhbCdOUFpmMaTYCcu3eac1fuUDLcilrLk2bLlsJ2eaw/nf5N03wOyg1f7J
+MuDxcYBlJtn8c36WMvR/TlHDDpFg37IJ9BtP+f4CBxHfr7QfFS+uQ45XG4+
LV8uQa4iZtph/yxwA7IP25aydwhdSqIsdg97sakYVq2MRt+osNXMY+XGUcRN
mpFvDFnOV67vhtwtwXKecl0V8jj0r0f/68n9j2G/F/l7A3gkwnzs7WLjSOJG
b4FvqQ2TqJMTwTfIx1mjGbvM4d05+MMFng3n3MPAecmqYfjCDDCsyLhWDrbO
rjDONZs1Z/ut9qiGzBUPQ+/z+NJabPoodhiEHQaCR+SX/NbwWw2mIw9Dj++R
T4OhyA+TZ+I5awT+8CM+XIAO/wlaLVjBHkHWXqM8hPwse9RipwvcQ0ac1WDl
FtlItlGOKcXOH5Db3gdh5BLuIgs/vRxjMfcP7P6N6hN4O2xcSTGhWBBnms8d
1fP+dOL5e+xzFvlt9nsLnEm02FaMNHsxrrOIo4qb6kyr+N1Drv0QrESen2A5
Wbl4HnIZtmvhf6tjjGMe5awnwFzOexl7fknOWU8MvQC+QO7NvZwjdv4HbkU+
yLf12GwMOIB8ivuYyrtVfP8SNtnGs03gZfAOWIVOr2H3rWCluC46beHbV8EO
5Ihiy3nKda2KjZuopqmWiaOsxDbT8OmpYAXy+ykW84r1fyF34p3KPMtHV2Gz
l7mrKO4zy2fPNuLjPXivO2hKslqiml7n1ZQdvDuW7+OwR2ak+dKcXOOu8qmb
uKO/gL4+8/kw9/kE97oq2mIsCj27suf1IBL5FHsUIReCk+KTpXbnuus2pZbL
xInEhZTT1CuoJqoWqmdYnG49hHqHZ9LNduKM4oqyobiUaqpqqTjVq6y5pdR8
RT56Isc4mLjX8RzjFjWg2uMYd6QaJxcXvx05mmc/cv6zIAp5Ht88BCaDucDX
1mJasRyLHOL8c9hvHPYqjDJuoZyoXCiOEWxrPiFfaIg1Lisf0N2L06rXqfNy
uXqej/lufq7F7sU2xnW/Qpcv84zzDuF/d+faWo+BF1jfX2C152fOe6jEaoJq
wUHxedUN1j4KpiYaNwkQ55nZxlFUC5QTlAtUE5JVe3k+PN5i7mbsckvYakdP
Z73SLHxkZrL1TOqtOqVa7VePlYAuT/P9jHiryenE5AbibD1IQ97I+mOImzre
veyzXL8X39+TaTlfa7/HXe8O2h6H+W3DN2cizSeVu8QxxC2Uw67lf0kFVos7
RVntV8+oXlEc4BPW7ZthtlFOU+z25O8eGRbDJwMW04rl75Brg8YBVPsHBc12
euc7z4bqLQfj17V+6zFV2/p4vYlqXDu+WYw+z4As5EXYYiZx/1CM2eRgkvVI
6o0OILss41jiVr8HjAuqZqpWihMGUqynUS+Tibw903Kactm7yPdyN6NSrfdR
Df0lbDGm2LoQNl+Wz8pX5dMv8Oz5sNVC5TjlLvUM6hWUw9S73w9GxlkPr15C
PYh6D/UUqvWqkaqNqvl3iu+B+ljrKXV2cTxxO9lAXE81SLVHnE+xp55SvaRi
ULOHejA6zmYQqgUfg/1eTVDvqZ5wvNeDNicYhxN3+ybGaslUbDg2xmqKctsA
dOtfbjlOveQF9j2fYz2leilxanFp9VTiCj9q5pFtnGFuO9tDa6tneg6bNYLH
wXKwMcNmJJqNNCEv5Bz1sh1YkGuzgQb2nZJiM4Lp6XYnuotp6VbbxQFU+1Xj
1Wss8GYf6jnU62vGoNmCev6BhZbjldsHFFqvpx5dvbl6vnp02p5suVoxJV0n
4Jvj/aazuI1qpmqlOE5Wjp1JZwkgv8G6l9gnDt+Mj7feXZxHXEc9vLi5OF/Y
4+j35NgMRbOT4TnGZcQhhnqcJoK7mYcdLhF/633WCxzg3j7Nt55AvZ9mBpoV
qAd8J916QvWC/0ROJUeE2luvpZhX7xzg28x866FVyxoyjZuopmmWI04rLquZ
jnLbTOw6I8Ny3G+c7dcS47Y6o7in7kx3JQ6q2cV5zvpzyGYYX2TbTECzgCPI
NXk2I9JsqDrPuFcvr9cWB1Mv8kcPm2o9ie5eOVi5Vz4g7lVJXHcKGAdT7shH
zgtYDpGvD8WuQ8rM59Xba+agWYN6fNWejt6sQzVoX8g4sbjwXrBDHAQ9h4s/
Y5PRKVbjVdvrUsx2qqGqnbJhut98WL6b5jffj2XdmByLAfWeL2oWk2496Mhi
6zHVWyonjOHvAQnGdRWzumvVLNUq3fnkIuOs4qoPFlluVw1S7VGO12xGM7JG
b0ajWdYP4L/eTEu9vHxUvqme/liG1WDV3uYMu6s49GpdYnd2yW+cVFxUnHty
mdVI1UbNNNTbr5DP51iPL1s/g23+nmQ2V2444XED5QjN5sSxxK00o1NuU81S
rVKOE/dUD7LO46Baa7J3Vq2pvcQhxB205/gSm2loljGuxM6qnK5crjOHsGcq
SAHF6uPL7Q51d6OQB6bYM8kDkKex7psp1tuKY6o30B7jvB5BvZJmgCe8nkmz
vy7e7E0zwCP4cRVr3aA5XLLNttRDqXfSjOtQtuUE5QL5lN59T7OvZPtGsz/p
JF00A7zEHgmsfQW4WGjcVD2kekdxVJ1NnLaVd8an8y3GFFuL8q1X1QxXs1v1
rDd5OVO5UjPJKOpgBGiMtBlQS4bNaDWbPYdcgR770GMvKPdyv55JVg34FR0u
Fdjsq2u09fLKqQO8nl6+pDNId/mUYlM9pHpHxahmI7KZbKUZibiYcqBynziZ
uL04vLi7OP6sLOMk4iIbo6w3FycWF1aPrlxYwz1UJ1lOFDf4Lclmx+IIZXy7
gNq9NcZmdBezjCOIG/zCby1IotYkgkFZxq3FKcQlxLHVq8jGi7yeZSQ+PCxs
Z5cN1YtpJqNZjHoycXXlBOUCcfY12HFSus0ubmPrztzLde1tdqqZbSBgPat6
Vc0MVGv2eblINUezv93ebFozQPmO7kx3JR8awFoFidabaIai3kc9r3pd9UDq
1dRTHfB6NuVy9RDqHZTTNQvb5vVSmonN5hzFaca91YPItprpaZYnG6u300xC
swj1eMeC1uOpt1PP3d1vOUa55Ua/cYlAos1mxCnOej2CegPNFDUbEsfL8mZE
j2XZjFKzyXre/6XQZuyarasnVi7VTFmzZOXU6qBxTHHLnkGLHdUY1RbFkHxZ
Peo8z6c1y7sv02ZbmulpNq2eWr20ZtST+J1Yar25OLtmlR38Vgs0s9TsLeTl
Fs3gisC8Upt1/dGz8HdkgdVqzaRUC9TzqtdVTdCsUjaSbTSzPIUNTuZbL6Ae
UFxanFRcVJy6Cn27tTdbaKZ1u+dT8iX5tLhStXd2cSbVRnEA1X7VyCZ0OZ5m
saOZmWZf8nn5umZg/wenEgtk
           "],
           VertexColors->None], 
          PolygonBox[{{9396, 9752, 9751, 9750, 1007}, {4875, 6486, 6485, 7122,
            1538}, {9415, 9396, 1007, 5900, 9414}, {3755, 3678, 1328, 9770, 
           3754}},
           VertexColors->None]}]}, 
       {RGBColor[0.5290313580353884, 0.4670758761613757, 0.8605978888177235], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlklslWUUhr/23t7e9vaKLdofpLcN5LbSkVaixZgYjQvnhcYhMSoBqjHG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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXmYl1UVxy/DzDDDMswMMAvMb4aBmWGZ+Q2DWogVCi5gZS4pJijFYo8m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           "],
           VertexColors->None], 
          PolygonBox[{{4716, 6598, 1398, 6955, 4715}, {8115, 8119, 8118, 7040,
            780}, {3954, 6596, 1398, 8019, 3953}, {8002, 4882, 2078, 8762, 
           8001}, {8761, 3954, 3953, 8762, 2078}, {6598, 7984, 7983, 8019, 
           1398}},
           VertexColors->None]}]}, 
       {RGBColor[0.5614107733856761, 0.5233749349086513, 0.9061110741278791], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlk9slFUUxR90Op2hHfpH6Exph6GkM3EoLdNSErTqwpUobiBgooBY0OiG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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXd4l9UVxy9CAoFIBpmEJIwkhATCcFRBawVFwK1VEVAU0KdaEBScRRwV
caFVK4qCKPg4WidBxaJYUBAnripuRYZVaJUq1vW0nw/n/eP75PD+7nvfe8/8
nkOPCVOPOWu3lNL8Nim14+8DpSkd1JTSMHA/cl1zSp/2TOkT0Av5i+KUzq9N
6TywFblrUUqPVab0KKhEfrEgpSO7pHQEWIc8FbSwdv/2Kc3mG6c1pnQV+8wB
k5A7ssfKPik9A/KQ7+O7X7HPl+Be5NO7pzSjJKXp4DTk9r1S+g9n2QFykUv4
7kTea9shpTE5Kd3AmovAheB6kFuVUmk5z/n9VX7v3pX3Oc8OUIt8Db+dPoC9
wdXlcZY3wRvZmfI55y+9U/oZdEL+vj9/WdsR7EQ+riylY/qmdDT4LfJ9Pfg2
710A7kV+uiWl5ejxsLYpFeSnNLQkzuC3D0Qu5x4TOP8HGOEY1rTjvY6szwNt
kWfxnWrWbEV3z+ye0hD2vId3l4DByKfxbkFVvPsRe0ziXv/it+1gIvKP/H4a
OpoEfkA+qTCld9HbO2BcYdjuWtZdUxs2dO+nONfykvjGAGxwPrY8D/RH3sKZ
5mKbh7HnAx1DF5+jh439Qyd7sO9IMAIMAsvYdzl4ErSCY+vxCfT8PfbYCebw
nZF8ZwS4Enkz+3fnnPN3C5352xPY8fHusWY4dhgDTgQHg6M483fdUvoWHIn8
ATrpyTl6gPeRX+DZQL47AKxF3lCd0jT0NRW8i3wxf3fnbvlgZlX4tjqcmPn4
OM46pD586+x24Tt5nKVD9/Chj0E/zt0XfIR8N7a6FlwD7gJ/rEnpePBUbkrv
gUf5zlrWrQGPII/Hpw4Fo8DJ4GtiogbbV4N/I/8ZnZ+EvseBm5HXsOZyfrsM
PI+8mXO8DtaDTWAaZ70eW8wFU5HPxyen1cXZ70WfPzSFT+vL/0Xui74rQDlo
BlN47yz2ngImIw/mWVNF+O5A7H02PrM/59oPTEMezroTWTcaHIycy7P2xEIu
yCmMs77HtzY0x5mNpULeLWiMmPqe861h3fNgZ1nsNYh1A0tjz47YPAfdtgN5
yN04cw16zcN3Puc8lSWhI3VTgdwGG+/sjE+AhLyVc7wF3gRbwGus+RE9/QBe
RR6LjmqRa8AY5IXY5Ez2OgMsQK7BTlexzxxQrR/jU+PxrYV5KT1EDLxXET6v
r29A/rAxbKjtPgD3Y/vrimJtG1BLPhzVkNIi3u9DTF/YGDnRXHgBmMUZbwI3
govBBPa8Fd+eB05FHog/Hsr7i3l/EDbtwhn3Qx9DQDHyc5xjMXe5G6xGHkb+
6Q9awFBwLuve4Tz/ADN6Rq4zZowVc95vsMES9L4YHFAWthrJuhE9w2bH8f0W
9PQI8TCR739eGTnXXLsR+T7uW0v8vpXd9y50XMM5qsGikthLHatb91yJD/wF
PACeAX0aIyaMhUbkZT3DZ/XVVmOKZ9eBa8Ei8BH6/Ii9PhQFYatt+NJXhWGz
k/CDPfCbOZx3BfE3pjR8XN8+sTR87XXWrO8cPjcK2+4N9gIjwSz0cgj6XoC+
53OfYbWhc3U9FHkU976U/S8BI5E3c843uccbYFNT5Ma9eL5n98iRReSYtryb
OMs7OZGLNqKzz2oiJ7nXWPQ0piT2nNErfFZfnY6cg+6Px07H4vu3tY/aV8E5
9mkfNdDcMwPbTi+KHHQ76/ujixYwH3mg/waTsN3brJ/YJXK8uX1Cl4i1QZx9
YO+IOXOVNlD35ixr283o5KYeUeNeJLc8AR4H6+qCO7ine8khrNXWeGu7NXs0
NunAb+3BCcitPH+Pe24AS5HP6h0xbSxPQX4MP9iJ/B14FLkFHQ7h3cGgH/Jj
WQ4y9zyKfDE2e5Z9z0G3rdTL2Tw7Gj85ClyhDgoj5oy125B/IsYK+qXUGfzY
N3KpPquvmlMPwadqsEs1GF4QuU8fbcxy4LrGiHlj/QWwihgdxz3Hgr8jzyuN
nG2uvqU0cuMO9vmmIHLklRVxBr89uyJ8eSj3OrB/+LS6nqZv1ITOzVV3Z7XF
nHUpOl6NrVeBS5BnUNOuQAcV+jM23onvfsM+X4PvGiJ2NnK3z0oiho7uEZxC
LnEU2Kc5OJ9c71fNoTtzvrleHQ7h3G9zlrfAYOTxvcJH9c2TQUGPeKbcuUfk
2s1ZbTLnjszW+NsujsCdp2D3yWAg8rLGiHFju9VaiA90BHmgGhxQE5xTrvnr
mogtOZdcyxj7BB0/yL5/BR8j746v54M7qH2tHcLWz6LrlX3D5nexz2hy6wlg
UVFwk+KqiE05irZameUmbSYXkUPJneQkleTU83jnXFDRErWuI+vyCqLm5fJs
PXp/DeQgf4Z9Bhmf7H9jbnAJz+xZ5RSvVQdHkZu8Cq5l7Z7Exu1yITjR8v7B
WeWqTyI3cI8u5OliUG/dLQodqZucouDSs7JaIqceyblLeK8LGFEYtWERe91Z
HjXiOu6+mu+u8ttVsdaaYi3xnfbEeA6Yy3lO6hC1Yjb6vaI+asbH1u/60PVe
xN856LiYvX9hfY92cVZ1pq4884zK6DnsNaYjr2iKHkDu/zfwMHbZjl9sAw8h
TwGXg8vAZLC2azxTXtM1csW6LBbNGa61hlo7fec8/t5HbByb4g73FIfO1fWS
4vAFOalcVJ+QS1gzrBVyCnNdV2xZ2RA571v9izvPzI8cfAT7781ee4HDkT/m
7udw19Wd0COYzBmHsc9Q8HvkqejnbHBKp9BRfbfoEewN6rpFLRjM3327RU2Q
K5ozzBVyxpGcoxtyTn5wiouw2dPk6RXmauSqwuhZ7FW6Fga3XJbFlhyze13U
CGtDbV3U6tvZb35F1OxW/YrYqgNLy6K3MGebq+0xLmTdBRXhm8bY4ZynmrM2
w22W5MXZzYnmQu9gb2gON3fbI45gfQ2x0tgmOJW51hxjbjHn3sE9FoBziZVL
5Rvqnd+WgY0N0bvsQH/f9Ise5hXOOAx5KHgZ+U/oeTv63wZu6Bx3uZPnC8vi
Tv4mB5V7usbeyBgxNuyR5NJyRLmhnPph7nECex8PHkJ+iTNOKo7ey5pu7Rye
9SbWULm7NtWWcvgz+wYnk4udgTyV77ai98s7RIxP6xecRa6iT8xoCc4n13ue
f29ibQn/vp71c8EqYmY12KNd6Hwp6weUR+7XJ8xFC/l9QWXkJHOtPZG9kDk3
n/32BHuATuBLvv9Vv+jNZrUJXY/Dl8dWh85HsGYcGAsOqQsubo9qbyonn8ed
LweXgVt6R67dmnFvc65cRM4kV5KTyJW2gM0ZZ5o5IGq4tdue6We+uxtoA36q
jtnBdHBONkOQCxhTxpKc4OXSqBnWipdKg+vuwI7f9ArO67fsUexN/GYTeXKD
PTHoUxN3LeZvUU3c2do6mHPv2zdq7GbufH51zDK0Qbv64GRyMXOKXMactCbj
NNbahZxzQXPUXLnZ6+S19U3B0T7F/v3Rdwv4JJP1YX3XZ9by6XxvS5uo6Uv5
fkfsexnfvhTcyDdu6hqxMYc1L6KDnfbEYB1yK++uxc5rjNnqsLUxX5vZXN04
w3B2oY7kyrl1kdvlzPbGcja5mj3yC/2iJ7IXWtsvbGEPZO+jTay9t4J5WQ02
lyxmv7vrIqeY+9bhoy+0RA5cnM10nOXYs9hL26PYm9hTy4W8k3eRE6k7Ofam
TIdyGzmQ3EeO81W3mAk4C/gSuXdZ1EhrY0NZcAk5kVxITmHtsqZaS61hW8A/
wX7kov+h05ms+0ND9Do34Y/V3KGVs+fmRw/m7OEQvjW8MmYQ1lJzrrnWmno2
976gLHpve6a5/Ptpnq8A19VFbFqzrdXG6MSW4Khy0wktMVuyJ7MXc8Zkb6PP
6qv2OOYy99y1V5b7Xmfv9eWRA51tORNwFuCM6x7u8gHP3wdLkGebRzn3Z+CK
guj95dRyaWcA1hJnJM5GrCnGthx9ShbjzpacCToLdMak7Z2JOAvRB5y92DMN
zWYw9lZycrm4PdZZnHkyZ5/QIWaE25uDM8uVtzWH71iDrD36kL2xOfSMrEd2
NjUa25/QFDMqZ4Wv4Dsv94yZobMNZ2ptsxmHs6FRWW/njMhZ4T4Z13VmeBxr
BhRFr2ePJZd3ZuOsZhen547Xo/utucHh/LYzT2ednsFedkXGXexpnZU5A7AX
dmam7//C3X4ujRhwNmbNtlY7I/PsclK5qHew1pgjzA3WHGPbmYizEGPc3LTL
x8siR/2EXof0iVmNM8OLsfGshvBdez57iRFZ7p6a5T45mNzLHKgvGENfZj4h
FzSHLM04obnMGmjtM6fZO1tjb8h6aHPTgProLc1RzlKuRndXdYmZylZ+q6mI
2LKmf8G/z8R3huRFzClXNcVsx2frq8JH9c3XqiKXPcnfJ6oip3Uqj5xoLrSG
ysV+VxC1S04mV3uIcz3YOTibs1VnRM6GnLE+XxUcUO73XFXMFq0h1g5njPaq
nsFv27M6SzJGjU1nSsZa32x2Zsw9y31W1sdsxxmIsX501lsZ8+aOwxqCG5lD
zB2ewW+bQ9TVi1kvrc68qzNcZ7feeRPf2donZq/OSBdy1+Xs96QzioKozflZ
Ld9VoxtiJqP/OcNwFi6HkDs4E5+DTzWUBzfXp80N5vi1WY6QW9nD2LvIseSy
n5QHF5HTnsq5Cptitu4M21mGPbO9sjONUzpHj2dvN75zzPqMcWPbmZ+2cc34
zEbOnuX8cn1n0M6+5NRyaWdg9lJywI1ZT2Uvas9ir2JPKldQJ+pCznAumN4S
3Nsaaq5xJuss1pyzRv1XRu2UQw0sih7N3swZgtzUnsZeRo7q/4X4fxL+X4T/
J2IsO4Ny9mRM2wvOy7iPPaG2MecuyWxkL+NMw1nGtqxXOJhvHlQUPYOyMzVn
aT77P0BH49U=
           "],
           VertexColors->None], 
          PolygonBox[{{8764, 3955, 391, 8761, 8763}, {8117, 8116, 8115, 6929, 
           1494}},
           VertexColors->None]}]}, 
       {RGBColor[0.5858552510377083, 0.5629685597929315, 0.910001057400408], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVV9MlnUUPnzC9w8QoQIE34++D97PfW7yVy+ULrxqSX7UarXcYCzdqJEL
WROIyrXpnBoNjbG25MaL/LcxN8HFWjc1b+qqcnCluMoQ0qUXzkRn63l8Duvi
7H1/v/e8z++c5znn/NJ7+l97P2Jms7A1sNao2WCJ2d9YPCk3+zFt9ikcHoRm
/8B2Jcyuxs1+jpn1FZh1Yv0KrLHIbAV7L+M9xPsd/HcPNoe9fEJ+9LkB7AXY
PDB+SwhvpEB4vzhmB/Z2Os4fObPfYWeSZl9j/UNM8byawrmwGcR7As+dofaz
+D4H7OZCs1FYO76fAeZpPC9gfR6WKjN7KasY9laYPbve7Br+DfAeySiOAfi3
RYXDGPMeJ8+7WqRc8p7Tavzk7W1TzmOlyCOiM5gvcfh9yLn9vtisO6F4yCf3
ibGMPBZh2/BtusGsv1KanEX+52B7gZ8OzOoD5TYZ1ZO5LsH/L9h4XHExTub1
EHgroTQg1tEixbkfvkPA74X/EjjOIP8u+NzC+82cziQXVyLSJY/v69ZrPVsH
LmDd+L6LusO+hM808LdHpV0KXG7YZJYE/qZq7AOzAvsDjTi7URwE8DnYLJ/7
OHsiLpwtNWaflSvWd2vNpsqk41bs1wbaPwfdPy8Xz8POLbmc9xplzCVNwA1V
T9/i3/3AOVIgbkLnh09+5/tB1MUnWWGchIYnYL3gtgkYLaFwx3yf5/Ib1+8B
8zDiOhSodpjHuOfyAc58AXn2MJcyxfS0vp3biYg4m3Qdq+tUl4yHNUtuFiOq
H+pH7WafM/sOHMaLVRd8sjZYa+wxxlWYla7UtBNc5VPSpxPYBRmdnQnEL7lt
TapPqBGN76xP+lL7Kx4PYyGHw9D0Q9iOIvXdgp/LXDq8f3/CDJjKqW9ZI3fi
6lOu2c9vrlFvs85Y/8Qmb8RnToyDeVUgxv4q8VP/DDjZYBZlfGvRfx5DF7i9
XCMtqM+Ya8cZxhnBc9lz5IOYfdjfkVMM7Xg+XicOasBJQyCeOaPYHy0x6fdi
XP69Pr9GvJY4+5jvJfRUcZV6vBH18gbef40L78BaYXJN7al7CrHfgt92YLUl
pTU5LgXnu8H5o5hyTXi+5I+8MRfW+6DPDfq1OOYX4OBkjfyoH/GO+AzkGatz
sNt5qEWP9lWI+9Fy9RVre2NMupLPhSbNzXmfLaxN5s6aCH1uvwWMkoy4+Ai1
9zFszu8Hzk3+Rw1fD6XjMGbPAPh6x2ckz+Kc5Dzg7CAXnEGcp4xnuUE9zFzo
S20Z28Vi1dyoz2rqQi6Y01KovHgvTftc6gH+N2n19/Pw+TOnHuI5Z33Gcv5S
E/bvbZxbXaWeLgFeKWwG7+14dmH/elz+496nnEmLOcVMDdJR1cztzZjPmxUv
59DGQLkwVnIw4ZoO+x3BeolkVTO8i2b8XmvGuUmvMdbvvrTwW0PpRI14Bw74
/TVSqTuj3Xub2jPHScyZU3X/z+/7ni/7g1zQh3fCss8Q5sm6f3oP4r/LPv+P
1Zsdr1dvsOfmvGZYF9SftUEOerzf/0V9PUmpvjoQ81d1On/ceWQMzI+9xBzv
ptXbxPwP8zksLA==
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJw1mXuc12MWxx/JNJemmenCzFQzTdNcmqlmlFhld63aru5eCKVcyr5cUqtI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           "],
           VertexColors->None], 
          PolygonBox[{{4013, 8125, 8124, 7034, 422}, {4884, 6425, 1375, 8764, 
           4883}},
           VertexColors->None]}]}, 
       {RGBColor[0.6096616136542492, 0.6012187603268575, 0.9105437691434662], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lkts1FUUxg/TaaedTh+OPIbWTpkp0we0NU1wQbCQuNNEIC6IaOKCxBh8
oKiQiDEsJKJujInRpBpjTEwfSkLUWhOiCQtYuKIsaMJCEtm0lFLdSKlA/H79
Loub/32cex7f+c65/8qh1585komIWY06jYHWiN6miBvZiGwu4oIOv8x4j7Pt
9f5uS/M7LZ6v8NX6Uc416qoRU+WIMd19MevvobAc99H/RCmiWIsYkfxeyQ5q
3a/5c7L1vMacZPKdEdcl/4/uLuns8YaICTnaov19unMpY93oQP9jHRFHN0Z8
JZmHpfv3R3R3XUSr/GnX+E8xLRciNmhsbbI/2ETPpOaXc45jl2xn6q1nIsVG
XD9qzDUZF/wtVH1/SPPbNct0dEV0auyQr39UIl7V+FB6T8ivRe2PS+d3ecdJ
jJd0b7ZmjLGLTWI5qflCg2Pfo+9bWk/V2Ud8xyfO55PMYqPX3Gss2D66Vmr2
b81/YfZz2XZatwnnYsQV+XJL8otZ+3ZG93ZrTGq+R7Zm6m0bX0fTPucTDd77
tjnicKNlSpsjmoT5vPD5qMdr5t8Iw2NNtnE+ZzzwG2zHNb6QzHvy5Wan5eHU
QOLVcd272uC7qzof1rgmn5oKjpM85Qv2G9/I0YXEi6rw7ukyb64PiJe9xn2/
MBguma/k5J2Njp3v02XPs5Kt7zXmW9o0r7omJuXX5i7naHFrxGe9xnxa97aU
7M9dze+VzX24PJqwIo9gClZPKS9P1pw38NiVN1fB9Wy95X8Vn/uEy7TWK83G
kNq5L93THY51fcFxwAf4fVlx962zbc7BAX/fTz4T952a75B3+IvOUzo/sMn3
mgvGl1g+ka3TPc7XvOItSaZeMjPDwrZk2QXt3wALxfKvdLd02w+4wx7yRyrW
hZ6yYsp1Ou/ExjkcXm1xbdJb+BLbg77CnDr9SXHXdRsjfCT35B1f4QOcX5Kt
WxpXcq6DxiTTVrVt7E7lfb7W3xR7rcu8pj/cbrYP1Cl2Ps+45jYkfw4qjnc3
uhfR5ypF40xeqQU4syz7f2vMpT46l2zNDEX8MuS6+aDHPY7Yny26rxHjkDg1
2Ot8U5/klZy+LH0f685prXducj1Ty/D0jWHbpZ6QJ8YFyc9X3DPIycGi8/Kb
5mfE6RdyjnU59UPqFE7cSLW+I9UUMvQnMOlPvKFGqEkwYM45HOUuOC2nPJJT
3gnyBzZgPpV6CBxHP/k/mTiwVz5mlKdbklvK+Qv+IZ/36+xixmMp7R9V3P1d
ri36wrlG95DZvGXAjfO+JLPWP1IPgXsvNdg+35nERWp6rNs+URN3Uy3DBWxj
F5zpqeD5prj/ddFv1KB0DyX9b6tX/Dns/tWYaop4wQ+swa8Kf0ruX/g1mO6S
++OpZy5W/F6OpLpYTXh+WnaPmE61j0/4A047O+zr2cRjsB5Jbxt9gD7IPrGA
GZwCN+qTfkQv4i09UXJN0bfH8j6jj2ZSL6VXk9/t6T06n3r7K/J5fc16eTMf
1ME++Zaten5TMgvqy9/nHQ964D+YnSobN/ZW0j75vJj6GzxkH76Rt2vpDRqV
zd01r7tk668Bx9imt6hd44Bkfyi7p2dTv2QPncdSDaCTfB7udE7vt0e8VjEm
/CdMpDeLuppM8/G0DyeIlZiod/Ym0z/EvYeU5wHjSL8/nXBeq4m86yLTba4T
J7m/mv55+JfBD+TBZDVh3lJ1bMTAgPfE8j/tzGfD
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmWd0lVUWho+hEwyBFCExJDcJuSGhKrYB24iKYHeWIwiMONZRQVBQYdZY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           "],
           VertexColors->None], 
          PolygonBox[{{8121, 7039, 7038, 8125, 1886}, {7179, 4733, 744, 7177, 
           7178}},
           VertexColors->None]}]}, 
       {RGBColor[0.6334679762707902, 0.6394689608607834, 0.9110864808865243], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNVUtMlGcUvc7A/DPAPCmIjDD+//gjEKYp4MJHZSF24UYTXag13Wisbeoj
qaSPWEKbND7wiRvXbbrzgaYKvuPCtUox0ZUbm6a0ESRx6aLn5FyTLr7839zv
Ps8990645/C2Qwkz+xUniTPQbDay0qyaNvuuw2xVyew3KHy6zCyPtyyUxlrN
9pfNruFeTpkN1ZmtXmIW4/55vdlb6OcbzU4GZjug80kEe/iZhfyjJvmmbXdJ
Mei/A7ab09Jvgt01nCROF97DNtzhdyhjdjSl+yzif1xW3KkP4RM6dZBP1yCP
zV7C1w+Q/Qn7LfC/D/lM4T2FXM9Uzc5WFW8atiugtwG+L3eaXepU3DH4vl1R
vbmKamD+C3h7g9OLuNZndhp+ivB9b7nZ/RbhsRV11UfSY8y5hGosIs5j5DaH
HCLEjjO6/wObGc+tyesehP91S4Fhh2pmbcxxAPIIOUZe7xLk8LBFuOV6zda0
m52CfDQlTNmbq9C/glMfCLOuvHC7Dr13kD1Dbo2B8CW2/E0fxK0ReWYD1TBR
NLsVmk0GwnjIcR4M5It2NxA/X9HvTXgrAJvtyG0OdgFiP4a8G/rP0/JPjL8s
C+cvIHuQEn8OQf9gKA6RL+TNYUBegP7evGL+CB5+H4pL/U3SoT2//a6/ExgO
xor3/o36Cdi/wIkQq4p+LYb6vRE8/2u5eMxe/R2qRzeB3w2chkDcLji/+WWd
vJ8AFz4rqZfEeKvzcwJ2r3Lqcw682F1yzCGP0d8D0FlAzEctmiFyf9J58C34
/E1N/GUPiDe5tAl+Nkbi0WvkeGSlODMNn1Od6uddfO/g5NzXpPOWmHGGiUND
s2ab+JPHrI1col/WTc4XXM4+kl9rnWOsedxn/BbinOsRf7vBo4xj+1OD6qF8
OC2s6IdzNh8qrz343muR/DhwmykL/2bg/wHOnbQwHXbb84hzoSjfT/A+E2uW
GHOVz0jWYxIT4pZ9f68TB1kX54n9pD6/Gb8vBuIo+XkMPT1eVewel7NfjEeM
yDF+q37nnhv+3674JSOucd8k+rRz6KPX/bA33Bnkyb/AISQ3IEuA58mK9DjH
xICzzF3Q47av0fN5nIt4yyNmIdI8j7sN+3IfvOvrUm6/t4tztF2LuSgBt9s+
F+QC5464Z/0+i/fmNvVzF+x+7pQue8GY3FdPY+014nqqql6yR8SSviPnLHtA
/L9GvkdbNevrkUOtrLq+CvWbd2K24FwlNqO+x1agvkqknVRCzD9i9Zs7i7uQ
vaMt9xwxZ37cv5yXJOzqIvl95u/MbUOs/yHqjIB754DVfEb7lf8r9DuSE47E
sNYlzsUeh/GYJ+ct6TlwNhadP/z/OV/Unf+fY77rqMteshfMkTGJEed4qias
yNPrztX/ANUp4W4=
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXd01+UVh19mGCGQQYDMX34BAjFscFVoi4oiuOlxAopV8VQFR8GBPVax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           "],
           VertexColors->None], 
          PolygonBox[{{7136, 7123, 308, 6956, 7135}, {7398, 7397, 7396, 3975, 
           1382}},
           VertexColors->None]}]}, 
       {RGBColor[0.6572743388873311, 0.6777191613947093, 0.9116291926295824], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VUtIlFEY/XSccdQYG8V8zKtfHUHNCWoRiVFaWovAiBZBmpCVlfSCSnos
ojaFVlbYomzVIloU9KBSG8swWkYFhS1qlUmYZrsWYed0bovLf/97v/s9zjnf
vd6Og5sPZJrZHQwfxnG/2UOMQSxeqDAbLTLbgo0+rA0EsJ+F/4TZpSqzxmzt
98ZkM18LO5xZHzSrKTV7GzWbgZ97+bDDmQ7Yv/HrWwD7oTKzY3Vm5zLM1pWb
rcWoxNkp2JxCrFWIdbHA7HpEftJxs02YT2L/GXwPx2XzFN8hjFuZyrHJrzwf
Yq2wxGwa8x+VZu3w9QE2V2GT51fc0AKzT9n6p69oQLWkU2bPMcLYz1hilolR
kGe2MlffDchzP+quwZiFny/41iJWiV/1047rl8PIzTNrRdxlhcitXLXX58qO
NvXAoT8sjPtiqpn1Lkxoj+u0P4s8z2QLm6jDhz64x/UeYDmNOq8FlffCBcrH
kPuLIuU0hb3JoPAhDxuDymd90qyzWPsjqHs4JWzaAsJvzid/XZg3YLyC/WuM
SI7ZgyzhQdxqUMcxcPQHdd3Okz/GOgddPEMOzUHphniTr1HknK6T7RPw1R1T
zE/gty0iLXzFfBKjEus7gWWnJywWQWO7oK022LwEVsGI9LUVdczHlesgfEeR
53hQ2uI+652Fv5vAeRr/y8HLc5wv9Am/GYfhCHy0Or3dw3yiVP1RgXN34uqR
majyY2791egLjNPA+X62bMk7c613egght88x4cmYYy5uPda/J4XtKehoeVI6
Js/El9iyzqNZ0jC/1DE1zDrJzSFTf1yLKWdyQx9cJ+ffME5mKM7juGKNgufj
IdkMIM/GXHHX5M6TuxHgPeyppo9LzX5hPoH5b9T9E6MqIP99ru/GUuofapA4
3XVYnV5kdgTYdsP2N3R9AnEPI+4O1N6SVH7UNHOn/sn/NqeB3grdL9Q7NTvg
7pB9bs6ceQckyqUr6ot9zfkjxOrMV+0FJboXqOkQsM/HWAa7eFLckBfqJeE0
w74K5Ajzr9g/EBMf5Izn6JP75IY25CHsuKA21yS1t9vTeZ5tdn5p3wy9tFQL
98fI80mZ7t+iUumScd7Dxwr0VY9femXNrLcsqn7jnH3zLqneYe3sMWqDHHON
dR3J153Ldd4LDa6vR0PilZxSu/y2Oo2xD5gnsSBmh51Out29sbhc70Gju9ur
gsr5Y6k4pj3vvyth+STnN+q0zh7NSEi/vJs2uPuQ70navTv/cyKPPe5d4tkp
d19TJ9TvjZQwH0zpbqJ2mTtrYL1pYLXXUz/t8cTH/3uLX8ZdjXMdxTpD/TMv
+mRN5LrQvYOTro/Yfy05wrsJ9Y4j5zaf7pWuiLgib3Oecuf98dTTvUAsiSnx
JwbnY4o3hxx+JeWX78mLlLhqxFp7sWJS1xNO2/RD38SEdtTfP859ik9tbC9W
bayLbynfZuL2F/f5Hmk=
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHmU1/Maxz9RtGimZppparZmppkWzUzKlksUTaQ4F93jalWuyj0oos1y
L3KiVLhyZTkl5HC5srQLXVvJRSVblkSypVBu2e7rdZ7vH+8zz/y+3+/n83ye
z7O8n6di1KVnXXJQSml2o5Qa8/f8Vil9UJXS+2Ak8rMFKa0uSekEHp5zcEqb
i5HB8WATWNgupeatU2oGFiBv6ZTSV+BL8DZoybfX5qV0DTgM+bcOPAM7wa9g
0uEpfViU0lZwJfIz7DmAPU8DTyNf0i2l/nUpNYCLkd8BY5AvBFuQh3ZN6fXc
lDaAIcgnl6VUhi6loC9yeWVKHUCfQ1NaxEEfR6fneG8NeAz57PyUetSndAQ4
C3llR76v4XuwAnlraUoTOefl4IPSOKt7uLZnfpXfH+Zsi8EryP/jjGdjh6HY
quaQlG7kHB9yrq1gOnIr/jbqjKFBLvJbvP8+2NkkpV3o15nfPkPf7aAT8rrD
Yw2/fRW5oTqlCzjrNO7ri6acHZ0PsN9+sAF5Mjpt5mybwCTkx/juVOT+4F/I
c7qktLwsbPG35im9yT4P8N4i8AZyb2x6eGFKXcEJyM+w7pxy/AM8jXwe5+zH
ezXs/QY6P4ydPq5N6SOwGHkCZ7kRTAfjwQ7QN7NHR+xxL3d6NWe/CtyDvIz1
PmyPfcBS5PPRowvfdAYjkV9C56kVKd3B/Q1kz8u4s9I2KZWACcjD+GYGvtqP
Z1s408bSuDPv6i2wne+f4Pm/wafZXeRgv5a5cSf6wqPgkcwnPuObq/DFvpzt
DvR9gXOvLY+z5nOGP2OXP2GXweBc5DmceSJrzWgUPvYMax5At/3gaeRXuK+X
wRTip7hZSrfiU8+3ZV8wF3kWeiXW6sVd9OcMr/D/Q8TFg+Bl5GG8t4fvG/j2
dvTZUxR7uPZu5O08L9S+6HcI71yLTlMye13UNHyloF3ors88T9y8AFofllKR
PocO33YM283j/ZnoPYi7GAhuRr6bd++pC93Ho+oG5EbskcBrdRFr+oi+Ycxd
SQxMKo77/pX9PsKeH5fGXnv47TF873Ewhf/vcc9uEePG9h3gZ9Zdh1+8Cg4g
b8YOD6DHIrAJ+Ur8bFJt6KrN3Wt/ScSaezbjvaPxi6NAU+Qvu0ZOMhft7Jr5
Nvt06RY+fn5F2FDbXYfNrmGP47HtH8DVyPPQfVZpxOaOJnGXa/T1FnGn27Dv
NuLuE4HclPjKwc9agkORG+ojRo3NfsijeacV/jSrSdxHAzp2xNZVoB/yw/x9
lr+rwWLkI9F5Gt9OBT2Rd7P/Kuyew/21YI1Z2H03tvoOzETuhc6PcqZHwLEd
Ijea48xt5siunOUCnl3PWb9rFLlqV0nEpvabS1zuYO/PwRzkcWAWtpgJxiK/
xvtHof+RYD3yLaz7Ov6zQV9GnpAX7/hsPPJlBZHTzeUTCiLXH4NfH10VOX9y
u8hR5qZJyJXc54no2RtUINey52j2HgW6IT/Pe424u7wWETOn4XNf8N0OcCry
bNa9pSpq1alNY69BYGC250jOX4j/FYARyCV8V4Pe1aAYeTq/r8I+S7DPmdz5
LnT4BfwMvgUrfV4WvmBNXIq8DAzFfsfz/xvoV4mvVYD/Im/BBz5mvY/A28g3
cKcjsO1wcD3y3fjSPeBFdJ1AWN1fGDnC3LAQ+VjOtJT3nmoSMWPtNCY2ZTXU
WNljLjg8YuZdzvBOu1jL+FqNDqMqwrfNkdbm5rzXrFXUaG17Jjgjs3EdZ9kq
BwC1yLex/9wuUSu0x03432r8eBWYgdwb33mJe3wRnIA8kW8Govvp4HLkf+Sg
H/66G9yOvKx96Khunuk71r+O+/w72IVcZe6zJoFK5InscRt73QouR/4UvzsC
23UH25CP645O6DoD9EJ+nzX2cc97wXvIbfCZQaw1EOQjP9A5fFzfXgRebh01
z1r3EvIybN4Fe3UGSwvjLCPBiOxMK3LDh/Sd5blx1znynOzOh3cKH/DuhyGf
hM7DyS9XNI4c/RM6t+Rch4F9yP9h36/BV2AtaMDW7Usid/bB5u9iw7n43Rzw
DvKcyqjx1vbZyDd0jTOo+/XIJ+LH47HxpaA38tFFEZPG4lFFURv+xrn+2jRq
RCV2uo/f7wUVyJ/xrCf+2ANsR17bKTiTXOmFTsHNhnEXQ+uDo+W0j5xrrm2J
/DR7rudc68BTyP/sGjXdWn4n8kRs2IPf8w4OHdrmRwwae4XI89njRjAd3AVe
ZI/vsMc3TSI/fV8RMaovvof+J1cGJ7E+d2S9S7pGTjIXXYy8kDtaTY1eBRbk
BrcdhK8MbBUc11zWHzRkOW1ym+BEcqFJyCs7BCeWC6/oENzEnG2ulqMYe/PR
8a6CiMGevHcG7w0CPZAvxK5389588BfkEdXh4/r2cOSFfPMkvy8BC5A350TM
GCubQClxMxX/mQJKkKdUho/r25ORe7LGuTwb0zg4yxc14aP65o6a4DpydLm5
nKd/TtRwa3dDTsTuSNYZURkx7FnknHJNz3Qs99URVIFjwAHW3IttfwT7a4Kr
XsRZxnUIztoPfUa1DW66w/stjDOoeyHyMuJmPfe1DixFboHP70OvvaB5t4i1
ViA3izl9Qc43IfOJXHlo+6idPbj/TTVxZs+6ETzUMWLY2H0QeUx+1FBr54XI
e/CfqrzIP5OwV0mXqNnW6mKwGd2787cebEJeWRE52NxrTbioe+Qkc9E45Eps
tJw8sgxUFESuk8PIXcx5+dh0U3Xs9U3jqFW3Y6vbOkTNshaYQ82d1oSbscmz
yCXUk6vAgCynmEtOA8eVRs2z1vVCHlMcnE+uZ4zcxG/HtY1apE/IJVvg582r
glNa6+zJ7MWsedr62Oxutbm9wFCeDSmJnsDa1x3UZzXwkNKIKWOpSWnElj3A
4izGzM36qL5pjjbXycHl3uY8c9nLfPdSaeS05dj31tYRz9rYXuI1sD7rKX7g
+ZqciPX3QfO6uHPvulldxHIRuahtfcT0kNrIYeau82qj15DDjM16jhru7Aww
CFR3Dy6oj+qbcsJp+NdYMAZMBfm1kaPNzXm1YRs5stxYG8mN7GGvzDjScs79
K772C1iGvK04emZ75U+KI3bM2eZqY8haOpv7uqVt1NTF9VFjra0P1UfvcjeY
n/Uw9krrwbqsZ/Is1sBe2Zl6YpNFrHU/6FEXsW1ONhcb43NbR49jbyMHvRo/
vxMbzwNXdYnaYY4wN1hD7P32ce69tdEDmovmZ7nZnKTt7VnsVbwDe1FrgrXA
ntTaPi/j9tZ4ZwG7Mi7lTEBuMrMqeh85yji++YbfvwZj2wUXNUeaG+WkfToH
J5QLngRyeG8ter8AWubFbKITvlmTGzMKubw9daeM0+dioy/QcwfI6R69vzXT
WukMYDBrXoEfTQTndA7umI+OeRXBIZdglwvAaPBETviyOW1p5tPmyvu4u3ur
I2caO9uyuzeGPNu0zLc847PYtT/v7mwaPcUIbNqnOno9OcOa8uiB7X1HYJ9y
9PpZO4OyVpFLV8lLiyOnmrtKslxmDtvYJmYuzlreahO5xx7n6iwH2SvoA969
PYNnkzPIFTyjtuiT2VqbLM841KIs51nr5LRyWWuetdSabi23pk6ojx5A7j++
PridHGZ2xvHU/Tf0/jUvzmAvJEeSG9kTDUanE0FvcE5F3J09jr2Nd3h6bvQM
9goDkEdXRE+nL9nj+K09lb2Ua1irrPHWdmtWX3Q4pTK4g5xkHO+MBU82jhyc
yiLnmet+L43efXCmiz38Qd2i57DXsCfpXxs1xNrRUBu1bW3Gnaxxclk5gLVf
Tutso1+X4HryMXOHMyJnQ+YQc4M1x1pjjhheEDbVlsMKoleSI8oN7Zmcvcg5
5BrOYEaj22QwCYwCK+sip5pL7SG/bx8zGGcve5CbEHMHuPf9oHEmu6d7+dsG
7vwT8LG9IBhSHDXLWuUMy730OX3NPY0FOZFcyJg4vV3MzJyVDWgXsxd7ALm/
MxhnVdZsa7Uzq6a893hu+L4c7+iC4Ehyo6MKIjZHZ2czRp3NnEIuP7kwZjTO
qnLKgys4sypHh7LqmEXYc9krONNxlmPPMLptcBi5izFp7+2M0dmiPXhlefTc
9toV5dEr2LPZq9kzOJuS88p1nVGZi41ZY9WcbK8gh5I72TNsZK+8ouAG9pDO
7pxZ7MxmeM46nZk5K3Pm6WxjQMYFnHE4S7THyc9mivY6C9FzQX70PN9Xx8zA
WYEzJO/uR/BDdofayppjrdFm5nprrLXVnP9mYfi0vvxGYcxi7BnsFZzJyF2t
udZaOay1yh7N3sya5ezWmtQjm+H2zNZ0LXuMS/Cdi0tjFmHMOXtdkuVWZ7Ce
RU4vl/dM9qo3s89NRdGzOmvbkPmiMzdnsRuz2Z8zWWdVzmiczTiz2lEWOcNc
8XlZ1NIJ2azSmmovaQ0w99tT/lQZNcbasq8yeiU5ptzSnsnZiz2zvbIzGHX7
Hb/7rVvoaK8tx5Xb2nP7TE4hl/Ade21nIM4+7Lmdvdlz2GsMzGZBT6LbkpKY
CTlLqMm4izMFZ0/OmJwtOYM6qyg4otzwj0XRi8lJ5CL2ZK7lDNHZoWs629Ym
2sIZt74hp5XL6iNfZzP3LVmPKjcyZ5gr5EhyS22kbeSYz3HHa+piVuiMUW7h
TMBZgBzD3tEYNnbtIc391nxrvTXAXskzqLs9k7M0c5K5yJmasyZn9CuymZO1
0JpuLbcmygWcubydcQK5pDFrrMop/w/8qN6K
           "],
           VertexColors->None], 
          PolygonBox[{{3879, 7869, 1510, 6991, 3878}, {7408, 6475, 6474, 7416,
            1574}},
           VertexColors->None]}]}, 
       {RGBColor[0.6810807015038721, 0.7159693619286354, 0.9121719043726406], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVUtIVVEU3aU+r6WFr+z5vO9du/Su8AKb2HdWlEZlEEEj0/JDP/pARJk1
KVJInAQNihrZpCZlCQVGmkXqsIIotI99iKKf2Y+CoLVYBxoc3rnn7LM/a629
X9i0b+PeqWZ2ASsH64Bv9jRt9jnP7G+Z2baZZkenmC2aZfYM57NhlC01qys3
K4TNRMasLGF21jM7kW/WgTUB+yacVUdmR3LN/sDPsrjZHdpj1cHHDwQ95+n+
FOx/BWajSbM23PdXmg3hbarArCU0m4+4K2Jm7bCZxPcY9gHuy7GG4KMT93W+
4vJ9D3zPmyq7q27fgzjLY6rlCeLcQE6tsH2WMtvlq976mPyth+3bQFjw/Pgc
s2motxd5v0ZdjaH8zUnqm/t7JcgbNvU5qs+LCavtFWbfAuXUCSxzfNV7fgHq
x/o03exmqNqYb5L547cWPlegvi3w/wo5fcf9z0D13EfOXcDzDWxLkEML/NZh
fwfxB7EawcFVvO3FmgYM20Llx9yOopZsWlishe/3geq9Folj5nwY+E9mxA9z
XxxX/mO54pz5k7citz8P+3NYJ1FLP2oawIoXgv+sYjPuMcT9EwrDwTz97jfV
2uXqXYjz246/dk+cT8KuPV/aIr9VefJNnFZF0iJzuogcR3zpirkx90fY70at
TRXi1iuQH/qkFk/j7ABsv8JPfUJ76m7Yae8Nzg6jlmHUdQb+RvB7aYowZU3c
n84X1+T8Ct51BPLPM9oQz4+B8mAOkSeumBt5q4n0TS7bXY2rcXarUviy5xY6
XsbAyWhG2NxKSfe031AoPKmNb7jfHJf/HcB7Z6ieJJYNDs/qAnFA/JfC9lBG
38Xl6lViQyzXJYXnHsTZm9b7y8jZ81U7+7s5IbzJW6vjjnod94Rnd0xaY4/w
jL55Tq0zb+bMfmoO/9u89NSn7DnqhrUdQsyDvuZHI/h8F0gzo8DhAdZc+PuK
Or5kxBV5Jm+slz3XWimtLomrlxj3d0p+6bPB6YP2m3LEB7EdgM0wVoD738ix
ulQ6pebYD6256sVaX2+WFpv1hZo5/TPARyicqfF6p3NqmPrlW+JOPogJbfsW
yL4MMWuy0hHrJ1Y8f5iW1slLFvwMlCjfIpcPa6SuBx3OrI0apT5nF8kPsee8
3povnSQR626JbJgTc6t1/c0+oF/OqSoXwwfvjQnZUlfdjl/6ZgzmSX7WJOSH
fjlHmXMDzpZH4ngkJXyJ7U3UPREJC2pk3GlgEOe3sWYVqk+oNebM7x43L/lu
0r0lP+lIHHEe8Zfzjb3IvmUfvQCGz9PihHqlbue5+VbleHmc1P8E7zgLv7t5
mExIZ2ccfpGbM5yjH9ws5ZxgLPYIZzHtuOf/244K/UcRv5WRYlGLbS6H62XS
EPd8xzh8y16cSAnDf3uuIx4=
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHl0lOUVxl9QMGwzCUmYTMhCloEsEMAgiFbBqoCsVqs9LSCbyuIpFtwS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           "],
           VertexColors->None], 
          PolygonBox[{{7018, 3916, 3915, 7910, 1518}, {6443, 7378, 1568, 7377,
            6442}},
           VertexColors->None]}]}, 
       {RGBColor[0.7048870641204131, 0.7542195624625614, 0.9127146161156987], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVUtIlGEUvfn6/98pxREdx9GxsZkBA7OF9EKkF5WhRa9FJFJCGi6SkDLD
NmUtXBU9FtGqRZsWodku0hCJqEW0KUqDzBAqe6BWFknndL7Fx3xz577Oued+
k2jt3Hs8w8yu4WTiLJaaHc43O7HELKgxC+H0LDVbiJv9wqn0zD7j8xNOFPeC
iNl40uyirzi/QrHH8X21p/uxkNnTbOTKMvueY/bc3ec9+QyigX7YA5wG2KPI
OYI8uVmKO4PPZ/C5gZyX4H8f37N92TuRf6LMbLTIbAXio7jXFpp5uO9OmXUg
1zdf3/td/ibYd+B0Ae/7crP1YfXQHZh98WVnDO8zsO8BrsKo2UH0stwT1k2o
u5AwW4PYd7AlPP1G+37YqmLqeRbczOHc9IWbn8ROfKURYWwPCRvv3+DbHJZv
F/Jvj6hnz/Veh/xT8B31hb0FvZ1P6z4Onz2Y1ShiA+Sfj6unfvgcwvdtnvJe
ClSLs6xwPb9z9zR6joGbhohqFC1D7UCcbIV9C84H2IfR29UCzAIxE0np4L8G
gPsWamVkanasyTm9oUbi6pE8M+cA7H3ovaRS87yL3D2r9NtzzHEYM63IUQwx
3clULvqS2yOIbcV5AP/N8BlzPoxpzdbstgfql3GcZ7erG/EUVw/s16nnPGlz
XViaoB5ya8QvuQ05LbIuMTEvc5KzkUAc/kSeH3FpgfPfF5Z/GPgKcRZhb0e/
x9KKiVZKK/T5g73bEBbOU+D2ZEJaJybGvcxQvSk3d2KacrjWIu43/Ce5j+C+
DT3X4n4Adg815nCfwnyOJoSdc+VOM89f1K0qV50Z9D4dFzfU+rzbTeqzLaR+
eC67HWS+dpdzyFMd8tmN+rdjmsGrsDRBPTShhyRm/MQXb/yk3riLvXnSGHGy
NuueK0Yu6KbTl44n3XtShV18XKb81E6p0w93pS+mPSEOr0JYqKdup2G+MY98
+WxEnyti2qkoeihN6Te+I9w32omb+LkvjA0Fwt4I310paaqn2ux0td451uLO
jDsNEjd1yLeyxPHDN+9tICycA+fBPtlLY77q3nf+5Kc5Ln1QG9xv5ieWK9i/
hwlxz/ej3c1oAH1NR9Qn59MY04wKwFNLWBxzR3e5ubyArS6qO2dLnIztBf+z
5dop9sw5cC61TpfM8xFzq0/rTeFpc1wRR4fjlnPj/wHxki/2Qk6Y+2yx8rPf
r0nVJU7uM+35K/X+UhPETfzkltyMOf1cQP2LaXFKHNQcsdBnyHG+E/nLU4ph
zddJ5R+E7V5Kc/0HsPvtfg==
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJw1mHm4l2Max59OdM6pdPbjbJ3F2c8phVKWIXuRyj4z1rIlLhkRkcGgXIiy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           "],
           VertexColors->None], 
          PolygonBox[{{7360, 3959, 1378, 7367, 7359}, {7043, 7898, 7897, 3904,
            316}},
           VertexColors->None]}]}, 
       {RGBColor[0.728693426736954, 0.7924697629964873, 0.9132573278587569], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lltonFUUhXfSTCaZ3MyE5jJjJk6ajKRi44sXWo0giARsJQ1eoKWI+GIh
LXjpQ1tESGLzoim2FZ/EoI8iQqttI14aRBpt8yCCWBpbLw20IpZWY4q1uj7X
8eFnzn/+c/ZeZ62195nyUzs376iOiI/1rNJTPxiR7Ym4PRtR0HNaH9/Vc7I7
4rVixO+ZiAc1PtsXMVwbsaUQMd4ecUSbR2o8x3hHU8S5XERulX8X9fyoOF9m
PF5Wrn11EdsaItYpz7ea+1u/D1RFXBuIuKc/4oy+X2oWpqLXn885FnEa10Y0
6flG78dz/v1K80vCNiE8Hyjv66WI6qJz3qb59fmIw1rzkdZ+n/W5PtP4C30/
onG+N2JDWsP+zzMetyvPrYPO/V21cTJ/XWfv6PG6Kzr3vOYv67dWuH/Q2p+q
zd+5lKtG87sbze0ZYRtPfOYUu2HQ37Zq/sa6iDnFaVDsx4RnQXunElfLwrWr
HHGo5FwbFOtUxrn2ZKzBS+Jqp/g/W++cY03GB4fPaW9B3L6qfRXlfLNijeD4
l2avOanvNZ3SqcZawR+cj2h+XJj2av5AS8SMxiOKs/uOiJWyz3kh47lJrZlS
7NXi7mfhmM8YKzj/LHsP69H57qR1ptO5ydum2E/mzffXWv+8numsdSskPjcJ
Q7bX72jCWvzzTqPPjR/wGP56psbj87XmcGOHOCmZLzSY07e/qu0F+MYPcHY5
8UbM+cTzauU81BqxP2PcbzQ4PjpwVri6IW+8XHG8mUZ7FDzwiR7ExE/UCXPE
u7/gmOS/kDUGzsQc56qSRlE0DrRFY/CAjTFn3ij+Nun5TeN6cVjX4/OTk1xo
vZgxVnDC9bTGoxrP5ZyXXEPi/ro4X8p6binhuVjn2Oj7a8kawP9D3a4HauG+
nP11tcq8MoZb6mM61cjTHfYTXsJTw90eF2+O+Ocm751RHQwVjA8txhJ+9k+n
+Kx9oewxtYweaPGwYm/vMM5W6dXWa49QV5yBXNdK7mX0rMl29w7qHr1mFeto
zn45kTzT1W985NraFfFe0eeC17GkI3voL/iT2nq/x5iHUwx6Ix5mDX2gVriu
Dtgf6DebfLKsM13R/DG9XxLOg63WiJo5luKTazbFoU+0ddk7aIBv6FFwRw8a
TT5CY/RFi7dy5jG098MBv5/S+Hi3z3Ux6QxX92p+ZcAeeFtnOijdN2ftb3iH
c7hnzJpHxNUrefcDeir99/D//T95j++bil5T7nf940f64kTqjdtb3Eeoq2Kd
fQCf7T3uEZyzRT1mW953yGjqg/RA6hL9wEbNUCdwu0d9bkvJunJ+/IqmB1rN
NTEWdb/9UXLf/VRarG91XPo6tUfdcR/Sx8E5WXG/Xkg1RQwwPC7/vtjs8WK9
9Tud7qCjSbsJ7R2vOO6zyrV/jWuGfbf0e+/0GnsOXfAKHmU/uPr6ja2LXtjr
+4f7YajiWuEOHM2be/jYl2qE3ocf/4ufMT6w0RuIwRlnky/BSR8ZTL2Uu2gq
9Vb66ErqpYPJE6zB7yfS/4FHlf+TsuPPJvxosavPfQ19uPf2NrtG6WfoBQbe
8SC12SmtO9b6vwD/O54oOD49aiH1f7BxRvLfJT7u7LV3/gXstmrn
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmGl0ldUVhg+DBCJDEkiABDOREJIAsSoKCqK2VUEQcKh2aZFBbQVtVXAC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           "],
           VertexColors->None], 
          PolygonBox[{{7009, 8099, 1874, 8098, 7008}, {7086, 7102, 7101, 4812,
            763}},
           VertexColors->None]}]}, 
       {RGBColor[0.752499789353495, 0.8307199635304133, 0.913800039601815], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VVtoVFcU3THJPJI7StMkE8fOTGb0pkxoo0gzY4Laqh/GViEUi6+CVSwm
Jj4QK4iICuqHIIpK7YNoxK9AEqyQfpaOIIb0o9Rv9cf456PGogYl6Vqs7cfh
3HvOPnvvtfba5+R27v963xwzG8OoxJiImfUEZo+iZkPV+Md8BgbL68ze5cwm
8R+0mr0smPXD9nZcZ9ZUmL3C/huMB7A5vMjsB4y97m+3+5zC/48R+Kwy+yw0
e5YxG50j20Sr7DPweRdzN2zS+O7BfAD+t6UwYH8Zef2C759TyrEducVb5GfP
PLOqBWYnYb8V+6MfyH4D1i5j71es34e/WwB73OS7GMj/liR8hVpjHsRHuwHE
bMZeA9ZrEOcIcj2IvXjCrCMQ3vKnZn9iDNeCA+x1BrIx5PZPThyugI8babMT
wL8JuW3GuITcNiLmN6HOjSDfLb5OboiNuK63AVeT2YtacTkOHyfhvg+YzPE+
x15XRPgW5IFviVkMPl9GlSfxfovvbRiDsB9MKyfm0xuoTqzlDDjf6ja9wBuG
wj4dk2/64cxY5CeHWH8jzwT2y1WKOYmc7wH37wVp6BzyXAq7PdXi40pGnHRi
74u4YpUCcUo+WRPWgdg7fJ18DoHjUijs+Yj8ba6UD/piXGqGGqJ+dgHf47Q0
x9p0RaW9HtcWbbh/PSubt8htBbCMwc9X+L+CcQw2EeT+oiAuI6jDBHJoxvls
XDP1z/2ldbLh+ez79VrFosZyfmaj+6fvYxXSMfEQC/d5njankNf3Sdn1oxZ9
Leq5+eiV3jrhvTRP+qa2xz6RnqglcrLKuc1jbSHGONaLwHIzKx3ciWiNPITA
9TTUGfp+Fsp/E2LVYzysUS2HnPOD4Gp1Qd/lGt0N7PFu5FPE2bRzTV6Z278Z
7XGd9Sx5j6wF/6caxUcD8qrHKMLmFubfstIsdUZtUef/xZQD9VOeK01QD9RJ
p+s8x/qEukeIc8Z5OL/Q7ALGlzHFX+Y5bEdeK1Oq0QD8XcU4Wyt90ZYY1yO/
qbhqcXSuYjPuT+C+Lyms9DmSkH45hhPyyXnEtc1cbgTqMeLiPcOc2dPsbfZa
y2KzjxfLjpxynbGeA9OTULVlD7XnvY8C1Zx+RpxbxrqGe+Nqm+4G3gcf5b0/
XaPUJzW+3rVIPniWfUe+WX9yTh6pFeqk3+8UxiLu7lDYX+fEI/FSo+SP9wnr
zX7jWda1PSrNs1emvKcakNd3+DfYr6xTHzK/09DFurTyY19+ntJ6l78ljLvb
7y7ydh7xL7aoTqtrhJU4/kCNRjFmqhWDObC/Sl4n4mWfJeeLB/rrdZ9/AV+0
Sb3biD5Itqp21P6hnLRBfyXHRb1Ro6wL8bN+5Jn6JFbWhfXqcO2xXsOume3A
WA8uZmHTCO0ns/I7jVhvCuoz6oRvGvVQ8aGwEdcs3qUdGe3zbi77O3cAuAbb
dH/zji56nsx51nngm8m3hLWmjqZdS+z7Bu99Yu70d4H+yS9j8H3gG0muqK9U
q3gn7knHPul3Pf1XgsuBNr0h9Enf3PsfsMgmrA==
           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXmclmUVhp/BAUFh9n0GZr5vmBmWWbQEBJcUywW0ALVELWQplMXKwA1w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           "],
           VertexColors->None], 
          PolygonBox[{{8754, 4848, 4847, 6508, 1386}, {8100, 7005, 411, 3988, 
           8099}},
           VertexColors->None]}]}, 
       {RGBColor[0.7749122146162534, 0.8510934578299685, 0.9085290268575157], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNlm1olWUcxu+z7Ww7njMPDnPbOe7YZufgzK0l5ddmiiRiymAuBya+FVo6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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJw1mHl4V9URhg8IQRAJ2QiQhBBifoQkBFxYBBUBa1UQBbdCH5XVDUWrFUXZ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           "],
           VertexColors->None], 
          PolygonBox[{{5950, 7063, 1528, 7587, 5949}, {8752, 8755, 8754, 3981,
            402}},
           VertexColors->None]}]}, 
       {RGBColor[0.7962919440091488, 0.8582230278994356, 0.8989509272485715], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1lltsVVUQhldLe9pNPW04NbRQTmPNOSdUOYWIMdEYiyS+eCVEK2CsClSj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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXl0VdUVxk8ggxghw3uZkxfy8jKRvCR1QBAsiNjWAoIBFaFFgRBFmRQk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           "],
           VertexColors->None], 
          PolygonBox[{{8066, 3980, 3979, 6884, 1470}, {7042, 4797, 4796, 6903,
            1470}, {8046, 8066, 1470, 6903, 8045}, {8753, 8065, 8064, 4849, 
           2073}, {7586, 7013, 1088, 5950, 7585}, {3980, 8753, 2073, 8752, 
           3979}},
           VertexColors->None]}]}, 
       {RGBColor[0.8176716734020443, 0.8653525979689026, 0.8893728276396274], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl31s1eUVx5/b3vb2HblCy4ReqNx7RxntOjddFpeorG4RB0y3BdzUTjIr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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXl0leW1xt8EMEyGnJCJQMKQEyQJSbBYEcSCCr1XLaCCdSjeW6mAtY5r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           "],
           VertexColors->None], 
          PolygonBox[{{7309, 5268, 821, 6252, 7308}, {7289, 7288, 7287, 6864, 
           1469}, {5269, 7330, 7329, 6252, 821}, {6465, 7084, 1532, 4828, 
           6464}},
           VertexColors->None]}]}, 
       {RGBColor[0.8390514027949397, 0.8724821680383696, 0.8797947280306834], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmH1sltUZxg+0b6V9+1bfDvr9aaX0RSka2XRxgVWYGmlEK3MtsGVTB+pE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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXmYzvUaxr8zYzSDZt5Z3pkxwzD75h1DdYiEU8kpEQ2p1NWJGHFI51S0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           "],
           VertexColors->None], 
          PolygonBox[{{3965, 7077, 1531, 7083, 3964}, {7247, 7268, 7267, 4523,
            601}},
           VertexColors->None]}]}, 
       {RGBColor[0.8604311321878352, 0.8796117381078367, 0.8702166284217393], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmWlwl9UVxm8Wsvw3koAJhEWTQMZAElFqoWo/tFNQO0UCYalQZ6pYW6d1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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXl0lOUVxl+zZ4LZJjOZLBAIycDMZAhqUTZBPVWgtSYkBGoRW2WvW1st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           "],
           VertexColors->None], 
          PolygonBox[{{7075, 7076, 1379, 6450, 7074}, {5272, 11157, 11156, 
           10353, 826}, {9025, 9024, 9023, 6373, 1363}, {11136, 11158, 1363, 
           6373, 11135}},
           VertexColors->None]}]}, 
       {RGBColor[0.8818108615807306, 0.8867413081773038, 0.8606385288127952], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmH9s1lcVxm95+7b0LS30d9nWQqHt2nUvU7Ns0zQqBQxlOJZppjBsmU5h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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHt4l2UZx5/124FtuLHzyTnG2ImdMEkTBxNQQUQZqEMww8tMGCVKeYlB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           "],
           VertexColors->None], PolygonBox[{{7879, 7868, 1087, 7001, 7878}},
           VertexColors->None]}]}, 
       {RGBColor[0.9031905909736261, 0.8938708782467708, 0.851060429203851], 
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl21s1eUZxp9zTgs9PZyelsJpaS21LbSWnbaKSo0ydb4kQpOp3RCdMVET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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlndslWUUxk83UKAtbW9vb8elt6WXlttbQFAjo2UkQmrEVqbERBwoJQEX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           "],
           VertexColors->None], 
          PolygonBox[{{6971, 4880, 1539, 7147, 6970}, {8195, 8194, 8193, 6702,
            1411}, {7198, 7220, 7219, 4459, 567}, {5201, 7199, 1411, 6702, 
           5200}},
           VertexColors->None]}]}, 
       {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
        GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlluI1VUUxvfMmcuZc+Zy9EzjzHh0LjozzqWZKSKQygs9aFqZlqaNwhRF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           "],
           VertexColors->None], PolygonBox[CompressedData["
1:eJwtlEtI1GEUxY+O5mgPX5Opo+mM4/ge7UEQlRW1sKI0Q8vaaBhBRq40hMBF
tSmi6AFRFPSE0kIoJagokjCClkU7NYgWaYvoQbWo3+W2uPD//vd+5z7OuV9k
b2/roWRJHVgK9jAhLVsk9c+R0uZJ66LSyRzpQ6oUCUpP8qWnWDwgDXBxQ0wK
Y2c4d+J/UyElZRGTJIUypBGwIpnS7XTpMgnCYA3VSivnSvfBLMO3uUjKIt8w
MX2cG8lZClYn/lVh6sCfgn8BOZ7lSj34W/AVcP6F/wSYU6ke82WhlF8q7UuT
toFxl1zt9PSIfFeJX8vdNVhWwHMEiC0sxJ/kd07z3cG/g3zXENOW8B6sdsP4
SX8/sHHi26l3LCJtJP4tuYe405wndZGzgtg/4O8iV0mlVMQsKjkvAX8pNs7s
PjPvcI0UrPFewsTcKZfqYz7Lv9gM87hFvuwMr3GqyjHs7g3+vS+RWkNSA7Hd
5J+ol86Xe+4c/BeZ10C19I3vo/zbxCwPhLw3m2GC2g8Q/xvf/jSvdV6l12I1
GzdRariT7hzNku92mbT1f77jUdeEacFquMSsKpnZA/ofxXrItZv7L/DXkvMb
tUxiazjngb865JiGVc/9QWrpa/DaraZqsKqwJjnmbLHnMOwrppla59i4NU1N
xPlHvgD3kzOc6/VR165xfq6OeRGzAj6PzXWuuuGsI+icfczmf9RrsZ7W01vv
AmLI/4lzIVqbhIPrYN/EWsAaTfiuiHluj/s/+7aZNeJrxWrBfg5/eezGTLHX
foEaBheDFXHtvLN+6P8uNowvwP0tOb4ztis2Q8tdkOPcWw1tIcc0LNtJ0+JX
NNA03zW5M+Y5DLsr6LvaE/Nv29lL9DoSde6Nk7VgTVd5b6bxvoTvpO3iS3pY
iP97hXNnO95Mr9ts5hm+49Nwsxw7TL57Kd5Lf8LvWk9B9JSd67tsb8qeTNeI
acN2Ih//EvyZAd9p42pH3N8G48x2oaDU9WI7YVxPLfJcxvkTuKqKu9aNsz2c
FfddNQ3ZLgzn+i7aTjRm+c7ZrtnOX0MPp7Ajyc6Z9fYq7lqyHlvR6roS14LV
mBRzzZhWTENj4L+u9rfPMArR8pwG5944eVzmb5S9TbZDNquzda5Fm5m9vUPl
zr29wf8AIvS5+g==
           "],
           VertexColors->None]}]}}, {{}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{10721, 4634, 10719, 4633, 10720, 6705, 6706, 4684, 12039, 
           3931, 5227, 3930, 12038, 4683, 4635, 11435, 11436, 11434, 11862, 
           11861, 6064, 3873, 9807, 9806, 9928, 9927, 4012, 6112, 12232, 6113,
            5940, 11666, 11667, 9810, 9811, 3875, 7242, 3874, 9809, 9808, 
           11957, 11956, 5939, 9643, 9644, 9642, 11894, 11893, 3957, 8766, 
           8767, 8765, 8769, 8768, 4747, 7176, 4881, 6984, 4880, 6971, 7175, 
           7161, 4746, 7192, 4913, 6439, 4898, 8018, 8000, 6614, 4732, 6209, 
           3695, 3772, 9769, 9413, 9432, 5016, 10873, 5036, 8792, 10271, 
           10252, 11035, 11016, 8899, 8149, 5055, 8811, 6352, 7241, 5226, 
           6799, 8281, 4158, 9641, 9263, 9283, 9243, 9323, 9303, 7807, 8610, 
           10632, 8630, 8260, 12274, 12314, 12294, 4138, 6062, 11838, 11858, 
           11385, 11425, 11405, 4602, 10934, 10954, 10169, 10189, 4097, 11286,
            4117, 10229, 10209, 10996, 10975, 4483, 8858, 8880, 8238, 9578, 
           12189, 9599, 12405, 6041, 12231, 9620, 12210, 5711, 11361, 5732, 
           9217, 4581, 8836, 5180, 8173, 9126, 9147, 5614, 8216, 8194, 8195, 
           6682, 7444, 9621, 4076, 10149, 8217, 8152, 5202, 8837, 6332, 6333, 
           5204, 12113, 5205, 4118, 7660, 7661, 6042, 11816, 11818, 11817, 
           6911, 6834, 3675, 9728, 9727, 10231, 10230, 4159, 10721}],
          "1.54`"],
         Annotation[#, 1.54, "Tooltip"]& ], 
        TagBox[
         TooltipBox[LineBox[{5201, 7199, 7198, 7220, 5201}],
          "1.54`"],
         Annotation[#, 1.54, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{7446, 3752, 6263, 5739, 11426, 11428, 11427, 6711, 3697, 
           10637, 10638, 10635, 4495, 10636, 3696, 9729, 11438, 11437, 6267, 
           7716, 4494, 6710, 5746, 7453, 12029, 9771, 5901, 11626, 4404, 8575,
            8577, 12243, 8576, 12244, 12246, 12245, 3702, 12242, 9538, 5984, 
           8021, 8022, 8023, 5998, 9554, 3958, 6440, 5991, 9878, 9879, 9880, 
           7656, 3985, 9877, 8652, 4607, 8651, 4606, 8741, 8742, 8094, 8095, 
           8096, 6986, 6987, 5948, 6985, 7868, 7879, 3889, 6983, 7134, 7147, 
           6970, 7174, 7160, 4745, 7191, 4912, 6438, 4897, 8017, 7999, 6613, 
           4731, 6208, 3694, 3771, 9768, 9412, 9431, 5015, 10872, 5035, 8791, 
           10270, 10251, 11034, 11015, 8898, 8148, 5054, 8810, 6351, 7240, 
           5225, 6798, 8280, 4157, 9640, 9262, 9282, 9242, 9322, 9302, 7806, 
           8609, 10631, 8629, 8259, 12273, 12313, 12293, 4137, 6061, 11837, 
           11857, 11384, 11424, 11404, 4601, 10933, 10953, 10168, 10188, 4096,
            11285, 4116, 10228, 10208, 10995, 10974, 4482, 8857, 8879, 8237, 
           9577, 12188, 9598, 12404, 6040, 12230, 9619, 12209, 5710, 11360, 
           5731, 9216, 4580, 8835, 5179, 8172, 9125, 9146, 5613, 8215, 8193, 
           6702, 5200, 7219, 4459, 10914, 5159, 10108, 10128, 10148, 6020, 
           11815, 5665, 11316, 5685, 11336, 4560, 10894, 5119, 9988, 10008, 
           10028, 5593, 10088, 10068, 10048, 5139, 6680, 6660, 5079, 12112, 
           5099, 4075, 5643, 11990, 3665, 6778, 4937, 12092, 4957, 4055, 
           10854, 4997, 10814, 4977, 10834, 5559, 6530, 4326, 7736, 4346, 
           6550, 7980, 11733, 11753, 9906, 9926, 4011, 7440, 7690}],
          "1.4000000000000001`"],
         Annotation[#, 1.4000000000000001`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{5897, 11625, 10665, 10666, 10662, 10664, 10663, 11621, 
           8646, 8647, 8645, 9393, 9392, 9517, 11685, 11686, 11684, 11688, 
           11687, 3929, 8704, 4682, 10761, 4681, 8713, 4695, 8712, 8715, 8714,
            4266, 7713, 9697, 9698, 9696, 9700, 9699, 5296, 6374, 9025, 9024, 
           9046, 8476, 9068, 9089, 5339, 8455, 8434, 8413, 5293, 9003, 6311, 
           9391, 5824, 8498, 5803, 9370, 6089, 8542, 8520, 6833, 5318, 7355, 
           6394, 11198, 5379, 10453, 10473, 10493, 5419, 10433, 10413, 10393, 
           5359, 11178, 6331, 11620, 5869, 11580, 5849, 11600, 6109, 10553, 
           10533, 10513, 5399, 6414, 3843, 5479, 12154, 5499, 4286, 5459, 
           12134, 5439, 3805, 3741, 12026, 5892, 4306, 11258, 5539, 11218, 
           5519, 11238, 3863, 6570, 4371, 7756, 4391, 6590, 8088, 11775, 
           11795, 9948, 9968, 4034, 7529, 7711}],
          "1.2600000000000002`"],
         Annotation[#, 1.2600000000000002`, "Tooltip"]& ], 
        TagBox[
         TooltipBox[
          LineBox[{7779, 7780, 7501, 9736, 9735, 9734, 6154, 11938, 5767, 
           7500, 6152, 12234, 6153, 5758, 11928, 6145, 11927, 6144, 7469, 
           7535, 3775, 12031, 5904, 6137, 11918, 6136, 9819, 9818, 10735, 
           4653, 12377, 9855, 3933, 10644, 10645, 10641, 10643, 10642, 10762, 
           3813, 10733, 10734, 10732, 4652, 6806, 6805, 7468, 11705, 11706, 
           11704, 11708, 11707, 4651, 7655, 4650, 6844, 6932, 6931, 8743, 
           3812, 7826, 8654, 8653, 10672, 10671, 10670, 8093, 9881, 7002, 
           4817, 7076, 7075, 4759, 7573, 7583, 7001, 7878, 3888, 6982, 7133, 
           7146, 6969, 7173, 7159, 4744, 7190, 4911, 6437, 4896, 8016, 7998, 
           6612, 4730, 6207, 3693, 3770, 9767, 9411, 9430, 5014, 10871, 5034, 
           8790, 10269, 10250, 11033, 11014, 8897, 8147, 5053, 8809, 6350, 
           7239, 5224, 6797, 8279, 4156, 9639, 9261, 9281, 9241, 9321, 9301, 
           7805, 8608, 10630, 8628, 8258, 12272, 12312, 12292, 4136, 6060, 
           11836, 11856, 11383, 11423, 11403, 4600, 10932, 10952, 10167, 
           10187, 4095, 11284, 4115, 10227, 10207, 10994, 10973, 4481, 8856, 
           8878, 8236, 9576, 12187, 9597, 12403, 6039, 12229, 9618, 12208, 
           5709, 11359, 5730, 9215, 4579, 8834, 5178, 8171, 9124, 9145, 5612, 
           8214, 8192, 6701, 5199, 7218, 4458, 10913, 5158, 10107, 10127, 
           10147, 6019, 11814, 5664, 11315, 5684, 11335, 4559, 10893, 5118, 
           9987, 10007, 10027, 5592, 10087, 10067, 10047, 5138, 6679, 6659, 
           5078, 12111, 5098, 4074, 5642, 11989, 3664, 6777, 4936, 12091, 
           4956, 4054, 10853, 4996, 10813, 4976, 10833, 5558, 6529, 4325, 
           7735, 4345, 6549, 7979, 11732, 11752, 9905, 9925, 4010, 7439, 
           7689}],
          "1.2600000000000002`"],
         Annotation[#, 1.2600000000000002`, "Tooltip"]& ], 
        TagBox[
         TooltipBox[LineBox[{5272, 11157, 11136, 11158, 5272}],
          "1.2600000000000002`"],
         Annotation[#, 1.2600000000000002`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1HtM11UYx/EnvM8SxfiJiiCFF9C8Nc20KNvSWi0UwdycbZUiTtPVH6ZO
C2zYZeRmooY1NRQaiUZRTUXmZdpFV87SdSPcLDOradbSWKa9+OP9+5znnOdy
nvM955f1xOKCRTdExH4/XTMiegyIqEuOODw4ogHnbov4CrmZEZV9I/7pGTGO
30+0lP1hasTU3IjFvSPuoi/QOfSUHLOMJ4yMmEKX9ovI7xFxckREt0TEeevn
zT9i/RRNsp5Ar5sj8oZEFKAYX8ufSxNIwn98K+T/olfE5OERt8s1hmbSQXKv
6hNRzW8NlmOQfFv5z+c/Ol099nB1rusndWDEb/LvvjViG341d6f1slsizvC/
Zu5xeR+T/2H6rr2uHeRs6AZ1nhkVsYK9iT2PDpNvp9iNKBXfou4ltNrHn0hx
Zr3luqb3o+yP8In1Rlzh/4q1zViCfL1MxA51hojroFYfXFRrkjqNWRHlORFb
6ArfozA7ogRpuBfDUWtPE8XO4F+h53l6m+wMPk/ja4/7nOWXej5g3GmYWHQb
GpGOInN11pfY23p6Sr5DGOxO7PEdFyJPnmUp7od7cLc8+cjkm80eQVPVetH6
5f4RHY3H0/Nowf0Y6RyO2PtM483uXSU28K9mj5HjWzET6HH6MVbyr7H2HM2x
v1wMxWkxlfpbh/XWUvkk0Gp+qPP6gc43X+o8F7rLT2EBkp3tIppjvUlsFR2g
30xkYBq7o546oTMOuiur9F+GUhRY785voxwbkOa79UWB7zIdhbiixjQ6Fa+q
f5n9rO9YYfy38RLjZt+pCfuw1BmX2XOD+1Al5j261t07w7/Mmb9h7gNzI9Uf
hdFYbX6r+d3mx7LH4YiYcnkO0zl622vtovFqcxfoZ2Jexs/y/sHeZ72r/XRB
iV7mYbw8NfJuRzG7lf8WXBXTmV+xvHOx1VyRb9eLf08kt6u7UWhuOmr5v40a
bMcd1pvU6yTHv+zN4gv4vUTPspPF7rH+lrrbUI0s9afxGUAzkI6D9r2NFra/
eTqd3ij2mB6700PeRqM8m8S/T2c66+vmZtEHfLudavXjt4P2pfW0tH2/3kyW
HI3yVagxQ4/14vPdwTlY5x0VmTvkXc3n+6P/iSI6UMxx413me9Pr7mZCnaPq
t+Kc2iPUnoH7sFbMbG9tJX2QjsUCb/BRvGY/XfTUH8fcqb9wGovbz5F/Od+n
Ucn3eZzlf0/7PtBfnQW0FN/Za2f2JXtqQT0713wt/13u2n79jbb+Dq1if6rn
2ewpaNDjEf579dzGv1mdJG/gpLq/4Cpy2QdoPV7HBf51/Pbyf9Lef5d3Iv2G
5tMW+cc7i2z0REL8Td54kvdZbLzMGS6nzXosoHPZebTF3XgTbfrvIMcJ623q
VFs7QdfQszQhT518Kb7XQ/5bBtNm9kbv95r6KeK/d/8u4iDfEt87g9//g1cT
lQ==
           "]],
          "1.12`"],
         Annotation[#, 1.12, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1HtM12UUx/GDdvGPUjF+WpKAclEkr9lM0ZKJrmlimmaZboWJzjbMP0xM
F6VYa84NU9AuZFhuFF7SecnlMu9a6ixZVMy20pnlRKtZbKX1+v3x5vOc85zn
nOc53/OjZ+n8yeUpEbHTn9szIu7sEdHQKeJQXsQ2XOwX8Q3yMyPW3BPxd+eI
B8Sdp5XsnYmIiX0jyu+KKKTL6CzaJMd062EDIsbSRd0jSjpGnO0f0aFrxCX7
l/gn2G+iKfYT6JwWMbJ3xCTMxrfy59MEUvCv2JXyn0qNGHNfxGC5BtEMmiP3
q90i6sWtwmLkyLdB/FzxA+9Vj12gzk3vScuK+E3+PdkRG/Er34P2X+kV8ZP4
G3zPyDtT/vF0q7tW5+oNrVFnwcCIJey32GW0r3ybna1FpfMt6l7DOff4Hal6
1kWuG95+gr0LR+3vwF/i37BXh4Uo8Zbh+FidPOfaqdUVrWqNUmdHz4iq/Ij3
6BLf4/GciDnohodRgE3uNNzZqeJXenOZt43Rg5N3i3XHz/Tya2/eb31LgbPo
0CciHVP4GuwvdLe1tEm+A8g1E5/6js9jpDwVXcyHORghTwkyxGaz+9E0tV6z
fz09or31UHoJLShGf3047O7TrOvM3RrUiK9nD5LjO2eG0dP0CJaKb7TXLKaI
f7N1Id1C1/MlvLdIv07I+RW68Zfx7+K/wr9IryrQR683qZVPi/VwNJYlZwe7
xVaJGWFvGS2ky+lBc7LaPEx2h/a+QW9v/1POCc6WYCKuyzlA/HjrRzHT95qR
nBHx49jTrce4T+jpi/q4CE/L8RJdjApMTs6v31u1eZso37O+Wylq2FXyrKVH
9X4FzrtvLXuPmofoQRzn7+P8ELk2JOcDvdnH+PPo/fx1fO8ih52LbPTCYHu7
5cq0zsJcPTypHxfUed35U9bL6Xxv74jt/Ol0K/0E23DVfl9xBah3/n1sSH4L
7/5PzWJ6M9lzOk38kzhiPrPMXE9c9ebj7GM4iu36Ue4bjzLHCf2vNcNpdB3t
Sie57wdmo4a9kT7lPkVyPMbf6tzbcqzAaLM9AJfN9QJ2pfhm60Zxs5x7kz1F
nw/Ym6vWz3JPoZl6ftp6C38XetOZhLuf8IZzuGg2+vmuU1GEamdmeMdS+ggd
gnnqPoHV7nabvnbHl37jf+BHlOvBh+KrxL6ANWJfxgXxDyXvge7qzKOV+N5d
b2Vfc6cWNLLz+TeJ3+I3+rk5GGj/I7qefUwPZ7DHYps3Hha/15vbxO9TJ8Vs
n1X3F/yDfPZ+2oh1uCK+Qdxe8aXuflne4bSZltAW+YfqRTY6IeH8HXqf4rcy
27pCDxfTfd44iT7HHklbzMo7aPP+dnKcsd+mTr29M3QVvUAT8jTIl+pbjTNL
uXQfu9b/mxvqpzr/g9ltxRdi5/j+PcT9D+SUC4w=
           "]],
          "0.9800000000000001`"],
         Annotation[#, 0.9800000000000001, "Tooltip"]& ], 
        TagBox[
         TooltipBox[LineBox[{7289, 5268, 7309, 7288, 7289}],
          "0.9800000000000001`"],
         Annotation[#, 0.9800000000000001, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1Ht0z3Ucx/E3XfyRy+RHrYzY1CyXFUcmNUecTp1WQh0dlVo2R4fMSXE2
5jI60aKGLloOcazmkrUOTjvkNDqrOGSZtUOn2kHJjjqnrMN0evjj+Xt93p/P
+/a5fH99cmeNf6ldRFT7ub5XRMeUiIouEV/dHrEDpwdGfI/03hFlyREXkyKG
8vuVFrOru0c8mhExs1vECLqY5tJ6OZ4yHj44Yix99ZaInM4RxwZFdOgRcdb6
WfOPWK+nYT2BLomIkXdEjMNUHJc/nSYQuMx3hfyHukaMGRBxl1yZNIWmyr3o
pogN/EoxD6nyrec/jf/gnuqxM9S5Yj/dbov4Xf5dqREb8Zu5e6wv7BvxM/82
c1PkfVr+h+l2va7q52zoGnUKMiMK2e+x82h/+baKXYti8U3qXsBJffyJJGfW
Va42e69jf46D1qvwD//XrZVjDnLsJQufqNNPXDu1uqNFrWx1qvpElPSP+JAW
uo/xaRH56IH7kYHNesoSO5H/CnvOs7cxzuC7m/nq8QtnedSe9xlfc6dYdEh3
FZhgrsL6HL2tpvXy7UeaN7HbPb6IkfLMvdH78A7ulScHKXz7sgfQbmots/73
rRHtjYfRs2jCAxjoHGr1/qRxuXdXhjX8N7Az5TghZjg9TA+giH+ltQY+o8yf
pFPZW9SdQj8Sn0eznVmdvN/ibjFrzA25+h71fshcmr7/cDaj+W0RM9sZFuAM
e6f5nvSivabQVpqtzk7fQBWWy7ECM+QrEjuTlrLfQLX1z/Cat1IvX3tx69XL
kvOUe2txZiOMf5KzGIvc50I6H6vELKDPuadpYvKRh2XmlqJR3Gz1XlFnDl7G
4/orsbYEB+VuVGOx8XJxB9SvxSL2arlPiE/Y9w+0AcdRIN8k/W/T83ZsxafY
gTIxm7y/TmI6qtUJnVGuv2flfwZFcr/Jr0TdQuNd3u1uXDH+D5fQhss4r78c
d1gu7gOsQ2/9F6kxH4U4xz7grdbiX3WGOr+VYobQxe5wCfYaN1s7irnWSjFD
jxvpJDrKnh7zLbV4H+/LsxSjvetBOOdNF7CLfQcNxpX8csW9zZ4g335r03wv
v/juJ9Be9nXYeJv5rvSKmIT6db67kzjtfAe4w4kYhVViJvt2iuiDdAimq/sE
3tLbdc41Gd84o79wCjPtexP/Er6zUMZ3AZr533e1DySrM50Wo1Gv17Iv6KkJ
lex085v5b3POe93HYOsf03fZXzvTyeyx2GGPtfz32HMr/xp1wv/fMXXP4BLS
2ftoJd7Bef4V/Pbwf17v5+TNog00hzbJP8xZ9EVnJMTf4OzDu5pqPNcZzqM1
9jiOvsAeSZu8h3Votf92chyx3qrOBmtHaCltpgl5KuRLclcPXf12aQ17rW++
Tf0k8T96ly34km++++/J73/bZhYv
           "]],
          "0.8400000000000001`"],
         Annotation[#, 0.8400000000000001, "Tooltip"]& ], 
        TagBox[
         TooltipBox[LineBox[{8046, 8066, 3980, 8753, 8065, 8046}],
          "0.8400000000000001`"],
         Annotation[#, 0.8400000000000001, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1H1M11UUx/FjpX9kiYEmhlaICSQqy5mU5UO6VklSWGm0kQI6WworF06T
h5nmHJupaOqsaWkkmsvVymSaS2u2Mk2WFaNlMaScTHMJLrHo5R9vPvfce57u
+d4fqUVl+aU9ImKnPz1vj+g9OKIuIeKLYRF70Doi4nuk3xGxdmBER9+I0fx+
pxXsj/pHPH53xPykiPtoNZ1NG+WYaT12VMQU+sptEbl9Ik6OjOh1a0Sb8zb7
U5030m65kvj06RcxLj0iD8X4Qf50moRu/Vzhu0r+b2+JmJwVkS3XKDqIDpG7
akDEVr41WIQh8r3Nfy7/kYPUY2eqc9V9Eu+M+FP+T9IituEPe/c6rxwScZp/
l71CeZ+T/1H6gV5X32U2tFadsuyIxeyN7BKaId8usetRIb5J3fNo1scFJJhZ
X7m63P0o+2N86XwvLvFf6WwLFiLXXXKwU52h4kKtfmhXa7w6e1MjlmVGvEUX
+x5PDo2Yg/54EJnYrqccsdP5r3LnEnebbAbfJPPV436zPOHOB62vGy4WvTIi
BiLfXp3zhXpbRxvlO4Q03+BT3/EFjJOnPNH78O3ulycXg/imsofTRLWWO/87
JaKH9RjahiY8hCxzOKz3p623eHdrUct/K3uUHD+KGUuP0SNYwr/e2Sk+E+w3
02L2e+oW0nfEjzevjdYT6Q72d3zS1DhON9ifZGZlZrbEm34VKfw63GsTn83X
3j+fm5Dsbr+a3wB6mi6Va436te7/n/hJ8v1LJ9ItZtuDlvJdgMf45vueF/T4
Id2lToE6K8XOlqOancquoFWoxDQxR8y0Gr35FelltTf3vNyFWG4/Sx9VdJaz
19VegQL3eRYzcdH+XLGXrC+jEx24Yj9DbE9v5xn1M61n0Jf5voQMPe/31p7Q
U6U+VnhnFbQKlfbPXeuVttMqmkuLxS3mN0zsZ/ZK2HOww3fKkzvR3afyO6P3
VtTYy/amRuOiWVX7Zgtw2dkBdgs9gXLxNXhR3m10Bp2gj2nm2C7nJm/5NUzy
VkfgrHxl7Apv+5R1Pb/Z4taw8+U75Gyu38Bvfsv5dLAZHLPebb8vvSomSf2j
5tSMVjMd7l7TMQGrxRT4PSyhD9N7ME/dp/CG3m7w7ZLxtd/sX/gF883jXf7L
+JZiLd+laOH/wLU+kKzOPFqBn/R6Pfu8nppQz063v53/bm/zgHcw0vn79E32
V+ZawJ6CPe54mP8+d+7k36BON/ukumfwD9L9jztI67EB55zX8dvHf5bez8qb
Q0/RXNok/xizSMXNSBJ/o9l3e3vF1uVmuIg2uGMeLWKPo03ON6PT/UOO4847
1dnq7DitoS00yVuoky/Bt3rE20yjDez13kOX+gnif/aW2vE53zm+fwq//wEE
Owmh
           "]],
          "0.7000000000000001`"],
         Annotation[#, 0.7000000000000001, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1HtM1mUYxvFbzZquMF8xFKhAEw0Uy4EUJSvt4KKcmNVwcyrqTFFqLp0u
zFmtOTeUsMws0SyKzGK6dDHNSTWbMk+LilkrmVEuEl1FK9ywD398uX73cx+f
w0tm2TMzKvpERK0/19wSMfDmiLpBEUeyIvbg/LiIU8i6NaJ6eMTfN0ZMEHeO
VrL3Do14NDuifEjEXXQtnUvPqPGU74njI6bQ51IjipMiTudG9L8pop2/3foj
/Gdoj1oJMTckRxSOjpiGMnyjfhZNoMc8/4ldr/7xwRGTx0aMVyuXptFMtV9I
sRexG7ASmeq9LX6h+HHp+rHH6HPFfgZnRPym/qcjI3bgV2v5/GtGRPwkvtva
bHVnqT+VfmTWqlHOhtboU3FHxCr2FvZ8Olq9D+VuRqX8Vn0v4qw5OpHkzAap
1W3vR9n78CV/A/4S/wrfNixHsb0U4AN9Rsq7qscQ/TroJH0aMiPW3R7xFl3l
PqbfFrEAybgXY7DLTAVyZ4hfb8/z7W2yMzg2TKwZP3OWJ+35kO8+OXLRf0zE
MJRYq+NfbrZX6Rn1DmOEO9jvHp9GoTorEt6Hu7tbnWKkic1gZ9PBer3E/2ea
B+Y7j7ajFfcjxzk0mX2m723eXTVqxNeyc9X4Vs5E2ky/wGrx9XwtYoqsn6Vl
7Pf0nU13yp/kvN6lW9hbUc6e7hyavOEj2KjGVP5NtMZeXpa7UEyKeousZdr3
KXWHWk9GAnPYydbX2G+zWtfRY/RaepwWq7dUrXJs16MWS3z3dVeL6Sgx2+0z
Q5+rznCe71nu4xN3/pDcj2kpe471EWJH4pLvy733aqaJ7FK5+TQPndbzzTRA
7TZvZCBdre5+72Ym/xN4VvxOvn5m3E53oBYP6JejX5r9rPWe0mmqOx6OxWp2
9vbGHxgl9yI9J2efc9iLBixTe5t538SP7qXKjBPUuSx/Lf9S/MN3kN1GT2KF
uA1YouYO+iQtUvcxs3Q4+ze80Rdxnzc4FhfUq2BXerMtvuvFzZW3iV2i3mG+
hd72z36jJTTdWTf73m19EL0iJ6H/Ub+Rszjvd5JtvzNQhCo5pd75avogvROL
9H0cG83Wzx2m4Gtnegk/oNz5vSN+ndhlqBb7PNrE39M7B1L0WUQr8Z1Z+7Iv
mqkV9ews67vE73ZfB/1PGcf/Pn2d/ZVzLWVPwR57bBJ/wJ67xDfq08M+re8v
+BdZ/ncdovV4Db/z14k7IH6O2S+oW0BbaDFtVT/PWWTgeiTkD3D2PX7LZb5X
OMOVtNEep9F57ELayr8VXfZ/Va0T/F361PKdoBtoG014B3XqJbmrh3vfMm1k
b/YeuvVPkv+9t9qBz8UucP+p4v4HVFoBzA==
           "]],
          "0.56`"],
         Annotation[#, 0.56, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1H1M11UUx/FDUaslJiKgWAEWko9ZBkqJpnM5KRbYKpstn5gt1JoF6aSc
Zc7YLHzMWYPFoojcmK0sp1las5nTJKkYbRUz1MWsllqCifXijzefe77n3HPO
Pff+yF7w9KynEiJiuz9X3hRx7Y0RDddHfD48YgdOjIn4BjmZETVDIs4NiLhd
3C+0ir0zNeK+kRHlKRET6Co6l7bI8bB13m0R0+izGRFF/SOOjY1ITIvo5O/0
fSZ/C+2VK1lMv0ERBbkRxZiP4/Ln0GT06qdb7Dr5v06OmDo6YqxcY2gGzZL7
hfSIWrHVqESWfG+KLxM/+gb12LnqXHSeAVkRp+T/8OaIOpz07U7+54dF/CS+
x7fH5H1U/hn0fb2uzzEbulGdpeMilrO3shfQ4fK9Z+8mVNnfpu4ZtOvjdySZ
WX+5epz9IPsDfMHfjLPi1/JtxzIUOUs+3lVnmH2X1RioXhedpE5zdsTqERFv
0OXu44FbIhYiBXcjF/V6yre3VPw6Z17gbFPN4NBgsXr8xCyPOvNe6xhlLxJv
jUhHiW8N/Mv0toG2yLcP2e7gI/f4BArkqRjofbi7ifIUIUNsJnsEHaDWS/x/
DY34D+PRiTbcg5HmsF/vD1pv9+5qsFF8LXuMHN/Zn0cP0wNYIb6Rr1VMoe/t
dD77bXW38BVbb6b17JNylZldqRmsYc9kr3WHp+jLdAa9ZCbpfGlIwTz5Up17
q7uYwlfI/td8J9NLdBLtNvMeTJR3Apr8Ng6YRRXmOMsc+9bIP5s+glW+Z4nL
xlXmdYgm0np3O5l/rn4vyL3S3XbTf3BW/jv65kav1s852s89JKHSHTyHBGcN
LLY/kZbTV9xNqphBGIx0pCHXmxmOOv6dzpkvZx626fdb9UKtj9U4bl2BadbP
0A3ef03fb8Csm9X4DAnudQn7T3tWybUYfzvHHnYHPYoKd1WNJ52zjj5EC837
fnPtsvd17/FFTPHeRuG0Xpayq7zPVutGcXPte41dIt8+vjLv+Ge9lNChznLY
usn3/vSiPcnqH9R3O07ofYR5lqIQ6+2Z7U2voNPpOCxSdxZe1dsV7jANX/nd
/YEfUe5+3hK/WuwS1IhdiQ7xd/X1gTR1FtEqfK/XBPYZPbWhkZ3je734Jve1
x5sYzf8O3cL+0tuc3Tdr7HDG/eJ3OfN58bvV6WUfU/dXXECO/1N7aSM24zf+
BnG7xD+u99Py5tNWWkTb5B9vFpm4Dsn2X2P2vd7jfOsKM6yku52xmM5jF9A2
/m047/yX5TrCf16dWr4jtJp20GTvrUG+JHd1r3eUTXezN3kPPeon2f+D99aF
T8UudP9DxP0PCTT8vw==
           "]],
          "0.42000000000000004`"],
         Annotation[#, 0.42000000000000004`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1G1M1lUYx/FLe4GKxg2kCZZgIYlgOpMydKZrmhSCmmZbRYiz5cPKheki
nTWJuZnkI7OGy0WRublauRxmWs2WTtJlxahpzCgLzVbSAy7UPr748vtf51zn
ejrnZljl07Of6hUR9f70HhrR5+aIxpSIg7kRu3FmVMSXyMmKqMuIuJiIGMPv
B1rNfndgxP0jIxalR9xJV9NyekKMub7HjY6YQp/JjCi+PuL47RHXDYrosN9h
fbr9E7RHrASf5Bsixt8WUYIKfCV+Dk2gRz3/8q0V/0hqxOSCiFFiFdAMmiX2
qhsjGviuw3Jkifca/wX882+Sj50rzyX9pGRH/Cz++7dG7MBP1u6w//wtEaf4
d1t7RNyHxZ9G31Hr+uFmQzfKs3RMxAr2VvZ8Oly8t53dhGrnW+U9jzZ1/Ib+
ZjZArG69H2a/h0/t78Gf/GvsbccyFOulEG/JM8y5y3KkytdJJ8izZ1jEmryI
V+kK91GaE1GJNBQhFzvVVOjsTP61ep6vt8lm8MVgvmr80Cxb9Lzf91U1pOW7
mxERg1BmrdH+Muuv0BPiHUC2O/jAPT6B8eJUpXkf7u4ucYqRwXcoewRNketF
+38MibiCsehAK+5BnjkcUvts39u9uzps5N/ALhDja+fH0aP0E6zk32TvJJ+J
1ttoBfsNeUvpBnaZnhebWQktxQxMxyr1XjHPR+X7zyyK+ObLN4Gm6TUdqShn
p+h5llzpcjzEThb/JX3X4oqzFfb6WOuLv8U7bS6pcp6iU8W8ZK0bFzHDeo78
Re73kLvaSs9Z30IPsueKnyRvqZgXrP+CpGux3XMy+qHc3lq5azCYbyYyMMfZ
PH0/SHvTemfP67Ov73N0Ev9t1lbI8yyuegtDzDFDPZmosnaf+mr4r8X3fDfT
I3poRou4H7PDXS4xi9/Zq9W2GH+ZQzO7nbagStx1eNKb2EHn0IliPKDPTme3
eYMvYJI3NhJn1b+UXe1NnvTdxK/cuQ3sMvEO2Fug3tN+g2U00xyO+t5lfQC9
5ExC/sN+A204o5cRfh8zMRHrnZnnHa+k99LRWCjvLLystl7+pw3E535rF/Ad
Fnkfr/Nfw3cJ6vg+h3b+d1+rAwPlWUir8Y1ag31eTa1oYudY38l/l7fQ7H9G
vv036Rb2Z2Y9jz0Fu/V4iP9ePXfx3ydPD/u4vD/iH+T437SfNmEzfrXfyG8v
/8fUflbcQnqSFtNW8ceaxVD0Q8L5JLPv8RYqfFeZ4XK6T48l9HH2eNpqvx5d
+r8s1jH7XfI02DtG19F2mvAOG8Xr766meivZdB97k/fQLX9/57/15jrxEd9K
9z+Y3/8CRfld
           "]],
          "0.28`"],
         Annotation[#, 0.28, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV03tM12UUx/FjbbXUgRQmaIiGhoBpJormSla68JJ2m22lKUyDsMXCWVJk
txmbRd5q1nC5UWZuLqcsh1lqo4WTZFoxS5OZl0lqU8HERLOXf7x/n+d8n/Oc
c57znN/AorLHX+wWEav8dOsfcXNaRG1ixHd3RWzAkbsjfkJGekR1asT5XhHD
+R2mFeyvekdMyo4ouS1iFK2ks2izGE9ajxwekU9f6htRkBCxd1jEDbdHHLV/
1PeH7TfTLrES+XRPjsjLjJiC2dgnfgZNRJd6LvJdIn5jUsT4oRFDxcqhKbS/
2K/1iajhW4UF6C/eJ/yL+GffIR97sDyX3CdhQMRx8TdnRKzBMd/utf/qnRGH
+Hf69rS4T4k/kX6p1qWD9YYuk2f+PREL2avYc+gg8b5wdjkqnG+R9xQOqOM0
euhZT7E63b2BvQm77G/EOf7v2FuNMhS4Sy4+l2eAc1fk6CVfG71Pno0DIxZn
RXxMF3qPRwZFFCIJYzEYa9WU6+x0/kvceY67jdeDH1P4qvFrvWxy523W/6kh
KcfbDInojWm+1dov8/0D2izedqR7gy3ecR7yxCm/1Xx4u9HiFCCFbxo7kybI
9ab9s/0irmIEjqIFD2CIPuxQ+2PWq81dNZbxr2HniPGz8yPpbroTjchi7/Rm
+6zf5zuVb7EezMNxvarQs03u/a64h9R7EK97uw6xK2kWvaoXz8mdpN7L1mPF
Oeb7GPoK/7f5dbf3Fr0sbp7vF8S7iE4cVEOJPhSjgz3a/r/8JupHmtyT1fGX
76dxBi+IXcS3EG3sSfb78SukD9EJyHL2GTmXqutGd1rkP1eBdvVcQAdmynOO
9nVuF99Uep59FietN4tThy0Ypf+H5c2lqXrVoGeHaanYU+XIoPn0d/WssG7k
W48mOb5lX6Ol7vk3rZTreXToVT27lTahXLwqFKt9DX2CjhNjslluc/ZDc/cG
7jdXWThhpuazK8zhfut1/GZdf0f2NPG22ysyr3/4302jqWZ9t/V633vSS84k
yt9g7g/giJ5n+k9MxzgsdWaG2X2ZPkiHYa68j+I9tYV+JuMH/68z+A0l5uVT
/ov5lqKa7yK08h9zvQ4kyzOXVuAXtV5Tzym0YB07w/e1/Nd7h3ozk83/M7qS
/b13mcHOxwZ33MG/zp3b+W+Vp4u9V94/8Q8yvNM2ug4rcNJ+Lb86/jPVfkLc
XLqfFtAW8UfoRRpuQaLzN+l9l//nbOtyPVxAt7rjFPosO4+22P8I7e5/Raw9
9tvlqbG3h1bRVppoRmrF6+GtJpiVdLqVvdw8dMrfw/lfr881vuFb6P378Psf
rPQDzg==
           "]],
          "0.14`"],
         Annotation[#, 0.14, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1H9M1lUUx/HjHzXD+UihYgaYSCiYRlFkriRXQmlas9nWRPFXKm5ROkrU
WVszN83UylkTc6PM3FyuXKZhoNLEJFlmTJxpRprMagVUOrGsF3+8n8899557
zrnn3u8zeNZzk8t7RMSW7p+MiOvTI6r7RHyRHbEdZ0dEfI3MQRFrbo5oT44Y
ye80rWR/1C/ikdyIeSkRd9NltIQ2ifGk8V13RBTS5wdGFCcijo6M6NE/otV6
q/ki6020S6wEnxv6RhQMjRiP6fhG/EyaQJd6/ua7QvyGGyPG3B4xXKxcmkrT
xV6aGrGJ70osQrp47/CfyT8nTT52ljyXnaf3rRHnxP94SEQVfjJ3p/UlmRGn
+F8y97S4T4n/MP1Qratu0xu6Vp4FeREV7DfZpXSIeB/Yuw6V9jfLexEn1PEL
kvSsl1iXnL2evRP7re/AH/xfsbYR5Sh2lny8L88g+67K0Ue+NnqfPDsGRyzP
iXibVriPx7IiZiAZo5CFLWrKt3cS/xXOXOpsY/Tg0AC+avxULxudea/xv2pI
Hu5uhkX0xURz1dbLzb9Om8SrQYY7+MQ9zkGBOAtv8j7c3T3iFCOVbxo7m/aW
62Xrv98S8Q/y0IpmPICh+lCr9ieMN3p3a7CW/yZ2rhjf2n8KJeypWG29ll3m
zPMxFz/rT7n5Z5GLOeZmYybOWesvzjPyPKgX09mFtJSOpdNoB+1EO/bpdw3+
tLfO+Vr0utP4VTXuozUY5Z4+08s9OCl2C64YL+Vf5TvZjDSxBiEDCTl+UNdZ
DNevA+IfRC32ow5LuvfSzThkz2E0oE6sWhQbzxZnHJ1Fi+gcZ+ond74+79f3
g6hHT33aaa3O+JC3vVTN47yTIgzUu1z1v8hnMa6w2zFBnK/Y2/X+uDpPo4J9
wbkniJVpXEhPstcbN1jfg0b++9jXaJkYv9Fl8s5HZ3eP2GdoIxbKsxJz9aCK
TqajxXhUPW32vuWNvoT7vcFhOO/9LWBXerPHjLfyK7HvNfZE8WqszfS2v/eN
TqQD3NVh423me9HL9iTkr3fuEzirD9m+n0kYjVX2TPHOX6Bj6QjMlvdxrFbb
f77BFL3/kv6KFsxzP+/yX863DGv4LsYZ/vd214GU7vdHK3FcrdfUcxHN2MrO
NL+F/zbf0h7/KTn836NvsA+42ynsQmx3xlr+u5y5g/9uebrYR+X9EX8h0/3u
pVuxHhesV/PbxX+q2s+Lm0+P0WLaLH6eXqShJxL2X6f3Xd7fdOOFeriI7nbG
8XQau4A2W9+ADue/KtYR6x3ybLJ2hK6kZ2jCG6kWL8ldPeStZNDd7HXewyX5
k+z/zv9HGz7nO8P99+f3PzGPC0M=
           "]],
          "0"],
         Annotation[#, 0, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV03tM12UUx/FDq5VOxCC1UtSfpKJpGEamJWuYlIa1jDaneRkuL2smTibp
7DbHhqGAtnK62Cgzl8vKybioWbYsTZZTZs1kRpnMrFBXurCMXvzx/n2e8zzn
ey7PeX6JomUzXkiKiM1+utIjbkJtSsS+4RE7cGZMxDdIDI6ouCPiYp+IMYMi
TtNS9od9Ix4dFbEwLWIcXU1n02YxZljfmxWRS5fdGZHfO+LoPZL1i2hz3mZ/
ivNm2ilWMp9bbovIGRExFXPwrfgJmoxO9fzFd634h26NmDQ6YpRYI2k/OlDs
Vf0jtvAtw3IMFG8z//n8MwfKx86Q56p+eg2J+Fn8jzMituIne2Odvzg04hT/
K/ZmivuM+JPp+2otH+Zu6AZ5loyNWMHeyJ5Lh4r3nm8rUer7FnnP46Q6fkUP
d9ZTrCt6P8jehQPOd6KD/2vO3sRS5OslG+/KM8h31+ToLV87fUCenYmINSMj
3qIrzOPxuyLmIQXjkYEaNWX7djr/tXqeq7dJ7uDL2/mqcY+7PKLnBut/1ZBy
t9lkRqShwF6t86X219Nm8ZqQbgafmOMC5IhTnOp9mN194uSjH98B7GG0l1wv
O/9jQMQ/yEIbWvAQhruHJ+k+9e/Ffv6fmkeFN3iAbnD/lbjBfSThc3tB19vr
UmsFLdL/fvvl1nO6c6mxA7+j1LtdiSa9l8hVpfZCNQ7R22A0ydmIKvdYjU1m
0CTeRtpIT+njI+e78AEyxL9sf3z3bN1tmv732E+lJ9jPq7uBXY8L7Ilmt85e
kpxd9mayx9lfw/8X+9XiTFRbH+cL1FdnnWLdG1PUN0u+yfQR5CHbnZbo61Vv
cZU6XqGL3F8Nv4vdc3UPeWputz6HDjzN/ptOo1/z3cH3uNynsYJ9Tl3T5E5Y
59Lvu+/D+pDzehzhv5d9nS4W4ze6Wn2LcFm99exWegTF8pThOf1tpU/RCWI8
ps92327yDl/Cg2Y3Amf1tIRd6l0es97Gb7bvXmcXiNfkbL73+4PZFtD+3v5X
1tvt96RXfZMs/0GzO4kz7mSY/8h0TEC5bwq95RL6MB2NInmfwDq1/ectpXof
X9AL+A4L/efe5r+G72JU8F2JVv73d9eBVHmKaCmOq/W6es6jBdvYCfs1/Leb
Vb0ZZfJ/h1azP/MGCtm52KHH/fx36/kS/zp5OtlH5f0RfyJhpg10G6pwznkt
v938Z6n9rLjZ9BjNpy3iZ7mLAbgZyb6/0d13+r/OsS52h8tpnR6n0mfZObTF
+Ru4pP9rYh12fkmeLc4O0zLaSpO9kVrxephVnreSTuvYld7DFfl7+P6E/1k7
GvnOM/++/P4HWqgEIA==
           "]],
          RowBox[{"-", "0.14`"}]],
         Annotation[#, -0.14, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1H1M11UUx/FTWqISiIqVqP3ABzARpaywpJaL0rBl2tZ8ni7TloHDIh21
mmNRlpqtmk4XRcZmunISD9Z0tixJFymzVjqlDKdWaitcWGa9+OPN53vuPfc8
3Ht+ZC4onVZyRURs9Ofy4IjuqE6N+GRERC2OjY74CokbIlZdH3GuT0TukIgj
tJy9NT3i3hsjFvaLuImuoDPpATEe8j12TEQhLRkYUZQSsT8v4j9n2uy3Wb/H
/gHaKVYynx79I8ZlR0zCbHzNN0GT0ameP/muFH9vWsSE3IiRAyJyaDrNEHv5
tRHr+VZiKTLEe4v/PP7Zg+RjZ8lzQT+9ExE/if/h0IgN+NHaGPvPZEV8z7/D
2iPiPiz+RPq+WquGuxv6qjyLx0aUsV9jz6GZ4r3n7GqUO98q7ykcVsdpJLmz
nmJ16H0Pext22d+Cs/xfsPcGlqBIL/l4V57Bzl2U4xr5TtLb5NmSGVExMuJN
WuY97h8WMRcpuBVZ2KSmfGen8F+p5zl6m+AOPr+Orxp3uMtmPTf4/kcNKaO8
jZr65kQUW6u2v8T6K/SAeE0Y5A0+8o4LME6c0r7mw9vdLE4R0vkOZA+jveV6
zv5vGRF/Iw9tyMVo3KG3J9TfX539sJv/ZfU+aa0Ea/VV5Q1eRC/+P8u5zlqT
XrLFXW5Wc2ihs3diAhrNagOWqfWsGOew1ZltSLj3q/T1oDPdaTd8YD2T/Su/
ifrpK8Z4de2w/jHqu85Zb/QWQ2kDzaJZXefoCDUMR292nbq6uYMrEZgq7nhr
BUhxj7PYKXL2QSqGsHvo64zcp9Eid5qYB+khfIPR7jsXu/T+FI7LXynXDFSY
yTJ9vi3O4+LslPN5mtr1G/QGveghdpW+293tWUyz/hedTL+0V+vsQfUfQRm7
XdzJ/BO+C+l37DW+99qvRzP/nexLdJEYv9AV8j6G3/VZzz5Km1EqTyUe1dMG
OpUWiHGfWT/p7Dpz+SxuN3cjcMKdLGaXm9MW3zX8Zjr3MrtYvCZ788zHD+ah
mA7wW/jC92brPekFZ5Ll3+N3cRjH3Okwv5kpKECVM9PN9jJ6Fx2F+fI+gJfU
9q/fXZrZ+YyewbdY6L438q/guwir+D6No/xv6aoDafLMp+U4qNZL6jmFVtSw
E9Y38d/sreq9WTb/d+ha9m6zNp1diFo9fsp/u57P86+Tp5O9X97j+AMJ/68a
aA3WoN1+Nb/t/Geo/YS4+bSFFtFW8fPcxUBcjWTnu7n7TrM023epO1xK6/Q4
ic5ij6Ot9l/Hef1fFGuf/fPyrLe3j1bSozTZjFSLl+St7jYrg2gde7V56JA/
yflD5vckGvnO9f79+f0PqRD81w==
           "]],
          RowBox[{"-", "0.28`"}]],
         Annotation[#, -0.28, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1H1M11UUx/GjZqiIYmLxoCGiQipIkbkma7YoDfMh25wkOivTlgXSooy2
mqNRmKYtm043yozNauZymOVytixJllNmrWRmGcwkDSudUD6sF3+8f5977j33
PNx7v7+sRyvmlveKiE1+ro6I6IP6wRGfj41owIm8iG+RmRlRlxbxZ3LE+Jsj
jtMq9ofDIu4dF7FkaMStdCUtpc1izDGeODGiiD6dHlE8KOJQfsQ1e05aP2n+
HuvNtEusRD7Xp0QU5kRMwwJ8xzeTJqJLPf/wXSX+gSERUyZE5N4YkUNTaLrY
z98UsZFvDSqQLt7b/BfxHztcPnaWPBf1M2BkxK/i78jWP34xl2/9uVERP/K/
YG6euA+Jfzd9X621Y5wNfV2eZQURlex17DI6Urz37F2DKvtb5D2NY+r4HQnO
rJ9YF/S+n/0RvrC+Hef4v2ztLSxHsV4K8K48w+3rlmOgfO30Dnm2Z0VU3xKx
gVa6j/tHRyxEEiYhC1vUVGDvDP6r9FymtynO4KtUvmr8xFk26Xm38X9qSBrv
btQ0JDeixFy99eXmV9Nm8fYgwx187B4fQaE45Td4H+7uNnGKkcI3jZ1NB8jV
H6nsOme5Gk+qd6q6n6LN2GF8Ve+HjNf39KHmEmwWa4NcZ+VMdQZn6B/owF69
rHCGOd5qLiqd0wr05X8dzog5Sl0d9Jy4f+E8yuzZbe81ea7iCuaJ/YoYNUjD
B/qq1lel+57EN8NcOkajylpv8fugTezfMEKe3s5qFu1FZ9Jk/Q5GEruUnaSX
S3rqQp7Y3fRf5BvPUcNsJGVEzOc70J4J5meZm4kX1HFW7mqaRbMxCk/w36Gf
fWK/ZDyo57uTsz89yq611ubsz+FB85fodPqNtQZ5johxvOfs2G3yTOefaVxE
f2CvNT5gvRFN/D9jX6ZLxeigK+V9HOedUSO7lTahXJ4aPKaHTXQ2nSzGfe64
3d713uKLuNNbG4NT+l3GrvI2Dxtv5Vdq32vsEvH2WFvkDf/k7ZTQYd7/18bb
zPejF+1JlH+/uziGE+4523cyA5NRa89c7/kZehcdh8XyPoBX1XbFt5bs/+1L
egbfY4m3tJl/Nd+lqOP7LFr5395TB5LlWUyrcEStl9VzGi3Yys40v4X/Nu+1
0d2N5f8OfYO9z5ubyy5Cgx738t+p507+u+TpYh+S92f8jUz/UbvpVqxFm/V6
fjv5z1f7KXEL6GFaTFvEz3MWaeiLRPt7O/su73eBcbkzrKC79DiNPswupC3W
30Sn/rvFOmi9U56N1g7SGtpKE72RevES3NVUbyWD7mKv8R4uyJ9g/1HfSDs+
5bvQ/Q/l9z+3mP1D
           "]],
          RowBox[{"-", "0.42000000000000004`"}]],
         Annotation[#, -0.42000000000000004`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV03to1WUcx/GvUWpns9m02nQepznNpZuaSWxF0cpbUGmI5iVDc8RobuLK
SykirCy10kLRWi0TrCjJ5i0SI8vlSHRYlMM02Zqz1qJmTlKDXueP9/n8vs/z
vT3f5zmD5lVMXdgtImr9XB0QcQ1qMiL2D43YjlMjI75FcmDEmuyIP3pH5Ccj
TtIq9oc3RTyQHzG/T8QouoTOoA1yPOK7oDCimD7TL6LkhogjBRH/iTlt/7T1
++030C65Enyu6xsxZljEeMzEd3yTNIEu/fzNd5X8h26MKBoRMezmiKG0D82W
+7lbIjbxXY2FyJbvTf5z+OflqMfOVeeC81yfG/GL/B/fGrEZZ6yNtP/s4Igf
+XdamybvVPnvo+/rtTrPbOgr6pSOiqhkv8qeRQfK957YtagS36huK07o4xy6
m1kPuTqd/SD7I3xhfwfa+a+0txFlKHGWQryrTn9xl9RIU6+F3qnOjkERy4ZH
vEEr3cfEIRGzkY6xyMVWPRWKncx/lTPPcrYiM/gqi68ePzXLemfe7ftfPaTf
7m701Pu2iEnWauyXWX+ZNsi3F/3cwSfu8UmMkac80/twd6PlKUEfvneLXeyM
p9TaoO5GlDrHFvtv4W1Ue2dt+kvKcY7+hvMok6+/mjlIyrPSmQfQq87RKeYK
LXbuIuSLPWBG+91hKztX7K+0Deew3kw/MJt19Al59pnVXDpdL2vMcaKzJPV5
xvcYtdPQC+modN/L5F+KHHXXyjHWOSqs15lDmhyf0QQdxb+nHKNT88YKeVei
WdwL9Hlc0cc0vgX2c/S5SOxSudLNYgmtTN2f/WL78/TU10zn88uy/0+qJ/mf
tn7Rd668v/tPtuMxdoW4zP7uDXtS94n9WM4+QFfQXqn/pZw96XF2tVzN7qcd
j1q/SCfQb+xtV/eYGidRyW7W+wT+Sd/F9IfUTH0fsl+Hev772JfpAjnO0yXq
PoU/zayO3UTrUa7Oaswz1830YTpOjgfNt0Xsa97qctzlLQ7BWXdfyq7ydo/6
ruU3Q9xL7Eny7bU3x5v4yX91Eu1rTl/73ma9B70gJqH+Qe/hBE55A4O9gckY
h2oxU7z3RfQeOhxz1X0IL+rtiv9ihjl/SdvwPeZ7c1v4L+O7AGv4LkYT/ztS
fSAj9dZoFY7p9bJ+WtGIWnbS+lb+29x7nfvP4/8OXc8+4D6nsIux3Rk/57/T
mTv471Kni31E3Z/xF5Le/25ai3Votl/Dbyf/6Xo/K28hPUpLaKP8I8wiC9ci
Ib6b2Xf5T8/0XW6GC+kuZxxPH0/9P2ij/dfR4fyX5Dpsv0OdTfYO09W0iSa8
kRr5urure72VfnQXe6330Kl+d/HH/SdasIfvbPefye9/yGkDZA==
           "]],
          RowBox[{"-", "0.56`"}]],
         Annotation[#, -0.56, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV1HtM11UYx/HHKRjZQPB++UkmkqYiWK5hzRalqd2sJeYlmyR/uFBMyHBp
jElBWrZqutwoMzeslctBZst5TZLplFkrmZkMBrWZrXThsvqj1++PN5/vc85z
nts5P8aWlD+5uk9ENPrzbyKiDxoyIg7kRuzGhSkR3yKRHVE3IuK3gRETx0Sc
pxXsj4dEPHBHRMmgiKl0HV1IW8V4zPeUqREz6PMjI4rSI07mRfznzEX7F63f
b7+V9oqVxqff4IiC2yNmYRFO8U3QNPSq50++1eIfy4wonByROzRiPM2iw8V+
cVjENr41WIXh4r3Lfyn/nNHysbPluaafm26NuCT+p+MituNna5PtV94W8QP/
q9aeEvcJ8e+jH6m1drzZ0NflKc2PKGe/yV5Mx4j3obObUeF8m7zdOKeOHqSY
WapYV/V+iP0JvrbfiMv8N9p7GytRpJc8fCDPSOeuy3GzfF30Lnkax0ZUTYx4
h5a7j4dyIpZgAO5ENnaoKc/Zufyr9bxYb4VmcHQ4XzV+bpYtem72/bcaBkxy
N2rKmBAxx1qD/ZXW62mrePsxwh185h6fRYE4ZVneh7vLF6cIWXzvcbYQa/V5
wl4LpunjOD2GhBoeFecRNOsxIU6V3h5mF/CrtNZB19JLtCJ5r95lBWr5VdJ8
603WRzs717l5yJavR8+HcQSXzSZbfXuS87H/CjvfnBeYWzFS+PRDvfc9RMw9
elon3kp3naLX/khNztPsnrG3ht8LKEdWsj46Ss4isXPZdeytch3V4yZ1TpOr
U9wC+jL7iPWNdAMW8CvGJpTJsVrOanc7xQzzUC7uS8722BssdjcdQlNHqQ0D
3ctyvQ015xI6jM7UU4a9Una9syvoKXZfd5JJm8U9gPW+D9IN9Jbk71Vd/elZ
dq28ne7nMh63/hedTb+xt1u8M+KeRzm7U+2z+Sd8z6Dfs7f4Pma/CS38v2Tf
oCvE+JWuk/c5/G6mTex22oIyeWqw3Py3J98HnS7Gg2bX5exWb3g97vZGx6FD
v6XsCm/6tO+d/BY69xp7jnj77S319n/0G55DB5ntcd+7rKfSa86kyX/IzM7h
grcx1r3MxXTUOjPf72ANvZdOwDJ55+FVtf3jN5ruvg/TX/AdSrzH9/hX8V2B
Or5r0c5/WrIOpMuzjFbgjFpvqKcbbdjJTljfwX+X+27yJnL4v0/fYB90//PZ
M7Bbj1/x36vnK/z3ydPLPinvT/gDCf/bmulObEGn/QZ+e/kXq71D3Dx6mhbR
NvEnmcUw9EWa82H2vd7+It9lZriK7tPjLPo0u4C22X8LV/R/XawT9q/Is83e
CVpD22maN9IgXoq7mumtjKD72Ju9h6vypzh/1m+pC1/wXeL+M/n9D5kk/qA=

           "]],
          RowBox[{"-", "0.7000000000000001`"}]],
         Annotation[#, -0.7000000000000001, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV031M11UUx/GjYhJNQy1R+2k+EYiilJa6Vkpq2FbZavmAs6XwB1OHCzVd
NkdZGgj0MF1uFJlLszQJU5vOlibpckraSmaaAZbNaKULl4WtXvzx/n7uuffc
c869534Hz1/8eHGniNjj888AA1TfHLH3jojNOJMd8SUSt0es6Rfxa2pE5sCI
07SE/f6tEQ9kRczrHTGKLqMz6FExHjEeOTpiAl3QPyK3R8SRURHt9py1ftb8
JOtHaZtYyXy63BKRkxExBbPwFd8ETUabev7gu0r8gz0jxo+MSO8TMYz2pGli
L02LWM+3FIuQJt4b/OfwH5qQjz1QnivO021QxA/ifzg0YgPOmRthfcmQiG/5
Xzb3hLiPiX8/fVetq9PdDX1FnsKciGJ2BXs2HSDeO/aWocT+Bnkv4KQ6fkKS
O+sq1mVnP8Dehn3Wt+AS/+etvYYi5DpLNt6Wp599V+W4Ub5mOkaeLYMjlg+P
eJ0W68eDwyLykYK7MBAb1ZRt7zT+q5x5trONdwef9+Wrxp3ust6Zdxn/pYaU
EXqjph6ZEXnmqq0XmV9Lj4q3G331YLs+PoUccRb2cme3RWRhNHuB9zPGWQ7r
52mxG7HPHbeL/S+u45B4i8Q/SJ8TP6GmFvGaxG/Gj7iAFnzgLrYhueMs7qIb
HUlf9SZXOlM5Hc4uo1l0Hc2klbQKFRjBHuDOX1Rbgk52hvfcWYb5LuJ1QmdU
ustT7reKlqMCX7PX0ZM0X40NNPim2ztRnEnIxQti9xe7i5qT0BlF3sx8tW+1
77o97ShgF6JS/go0WUsx30zPdfTYeIe+bke7exxmbgu/rdjtLHtQKV8ViuV7
Vt7eallifhmWIl1PfpE/zfxF2ofuFLeFfkQnir3WvrvZqexxtFb8mWKmi9lD
L8fpz3h8bD5Jn0rN7dXLFXQ/XUlv6vjX9fkGeoK92t4mvbyER83/SafSL6xt
VtNxOU+jmN0k7lT+CeMJ9Bt2ufFB63Wo57+HfY0WiHGRLpN3Pn7T9zp2I63H
QnlK8bT3t4E+TMeKMdn9Ndtb6f2vwD3e3hCcd65Cdon/4ZhxDb8Z9r3MzhNv
t7U5/pvv/P95tJceHDLeZL4rvWJPsvwH3ONJnPE+Bvk3p2EsVtsz3T+0mN5L
MzBX3ofwktr+1v/u+vQZ/RmnMM+//ib/5XwLsIbvM2jkf2dHHeguz1xaguNq
vaaeC2hADTthfiP/TXpe5+0N5f8WXcfer8fT2ROw2Rk/5b/DmVv518rTxj4i
7/f4HQn/7C5ag3I0Wa/mt4P/k2o/L242PUZzaYP4We6iDzoj2f7/+LZ517OM
F7rDRbTWGafQmewc2mC9Cq3Of1Wsw9Zb5Vlv7TAtpY002Rup1sskvbrPW+lL
a9ll3sNl+ZPsP+H9NuMTvvn6n8rvfy9NEDc=
           "]],
          RowBox[{"-", "0.8400000000000001`"}]],
         Annotation[#, -0.8400000000000001, "Tooltip"]& ], 
        TagBox[
         TooltipBox[LineBox[{8019, 7983, 8001, 8762, 3953, 8019}],
          RowBox[{"-", "0.8400000000000001`"}]],
         Annotation[#, -0.8400000000000001, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV03tM12UUx/FDmuRmXjIvhWYiaiqK5Up0OikVK82WiSjZJJyS2A+kSNua
c8MrVkun5STN2LzMuQy6rbJlQbqcMrvpRHM4qw2xxIlLbdN68cf79/me5znP
Oec5z/n1LyiZUZwUETV+bvSN+K9PRGWXiM8GRVTh1PCI75HSL2L1PREXukYM
vi/iBC1l7+4R8ejQiPzuEcNpGc2hh8WY5ntYRkQmXXRvRFbniEMjIv515rT9
09Yn2D9MW8VK5nPb3REZgyMmIhc/8E2hyWhVzyW+y8U/2C1idHpEWs+IAbQr
7Sn2K70iNvFdgcXoKd5G/nn8U91tAruvPJfdp8P9Eb+Jv3dAxGacsTbU/sup
Eb/wb7E2Q9ynxR9PP1Br+UC9oWvlmT8yIsF+gz2b9hHvfWfXodT5ennP47g6
fkc7PWsvVou7H2DvwRf2d6KJ/+v23kYhstwlHdvk6e3cVTnukO8cfUienf0j
lg6J2EAT3mNyWsQcdMSD6Istakp3dgr/5e48291G68E3vfmq8UO9rHPnGt//
qKHjMG+jpjsfiMi2Vmm/0Poaeli8TmppoFvZJfbraILW0uI2270S3vEjfs/J
ORfP45K5uiHudeSxZ7rXs7ilvpso0tsF7rxWD8rcaQ1d654d7I315mPQaHZO
WzuDBvzlbS5imnNT0V2OC+xmNOFJa0+gRKwSMYvpEporTqLNRhFewmLMsv4i
XYQFKMRC5FhvUOtoNZbp2xi6vG2m6Ug9nWP/jP1C9qv2d7FneI9nsMH/ZoRe
TFL/ZGQjg73ReoV6KsRfT9fThPO71LsHuzHc+lV3GtE2t/Jdca6f+Em+0/R5
lTt+ZXZX0vK2e4uRdlfEQPvzzEQ+lqnrNYyzNx43zcIaMTfL/w466+8j4nah
25xdmGJG1Fij9kzr3azvtb7V+kzv+jPNobd772O+y9XRaJ6a8JT1K3QS/c5e
lXNH5TqBBLtRzEn8U3xn0p/YFb4P2q9GHf9P2ddogRh/0jKz+QIu6nM1+ySt
Q5E8KzBPPzbTqXSUGI/p1Tln3zRjy/Cwee6Ps2ZzPrvU/B/xvZ1fjnOr2Nni
fWIvT29+1cds2k0Pv/W9w3p7etmZZPkP6OFxnNLbfv6LUzAK5c5M958ppmPp
IMyV93GsVNt179lJv7+mf+BH5HuXd/kv5VuA1XyX4CT/kW11oJM8c2kpjqr1
mnrOox7b2SnWt/Df4T9ZbX5S+b9H17O/9H7T2ZmocsfP+e9z52b+++VpZR+S
twF/I8Us1dDtqECj/Up++/jPVPtZcdPpEZpF68Ufohc9kIRk52/xbTX/ub6L
9HAx3e+OE+ksdgatt/8Wmt3/qli19pvl2WSvlq6gJ2myGan0lu281Tiz0ovu
Z68zDy3yt3P+mFk9h4/5zvH+Xfj9D0L2D9g=
           "]],
          RowBox[{"-", "0.9800000000000001`"}]],
         Annotation[#, -0.9800000000000001, "Tooltip"]& ], 
        TagBox[
         TooltipBox[LineBox[{9770, 9750, 9751, 3754, 9770}],
          RowBox[{"-", "0.9800000000000001`"}]],
         Annotation[#, -0.9800000000000001, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[LineBox[CompressedData["
1:eJwV03t0z3Ucx/E3TqtzlFvb2MxlG8KEnHDCoTC66ZzYjKNcVjk4w2ZxTloL
uSw6mSnlktZZdWrnOLqeOpxDEyeHHTllZ8jhqA7pQkZTlNPj98fz+/q8P+/3
5/3+vD+fzzezcOHEBS0ios7n7y4RNzMiNreN+KxXRDUa7474GundIlamRfzS
LqJX14hjtJj9XkrE/X0jZtwZ0Y+W0jx6QI5HjPsOiBhK56RHjGoTsb9/xD/W
nOA/YX4k/wHaJFeSmBbJEf3vihiNyfhGbDpNQpP9/CG2TP497SOG9IvITo3I
om1pityLOkZUiS3HPKTIVyl+qvhMvY1kZ6hzST+3dI/4Qf4PsiM24qS5Pvwl
WRHfib9o7nF5H5N/BH3bXpf3dDZ0tTqFAyOK2GvZBbSzfG9ZuwbF1terexZH
7ONHtHRmreS6qPdd7PfxBX8NzotfyvcqZmOUXnKwVZ2O1l1R41b1ztB71KnJ
jFjcJ2I9LXIfY3tETMFtGIgMbLKnHGvHiS/Tc4HehjiDwfhXvdXyVZrP5V+n
1mW1xsv5IB7CIu/hQ/MpnZwRTaW1tFMH8WquxUH1z8mVbV817DS9hXEPubKw
2tvJpsOc30lrp3gDHeTNo+8ixZ0mY7IcXfV9zX10oc20vbgN1lShEq9hI/LF
zrK/PFpIR8hzI9ETbqi1Xsx1ep3dLMc7/MX2fjnxluT+k3ZOqDc3nG+GHDPx
JCbJOZ0OM79PnitiS6z9i5bp6ypNc2YT+Rv5b9fXIv5STDJ33Nwd5orkeUqe
+fRpOiQRR1eyS+gqWkqfMV8u72xaYW6ZM1yOFZjvDk/J94S8C4yXiXtW3ELj
JfSK+11Mu+nxqn5fcBdleB7nvd1zaK/H39Tp5c7ynHN+4qyxWx+r+Au8gcHq
FiT2mPhHvMUsdMcWa8bqawyy2VvZldZuwIvu+WaOPdE5au91z3PpUnt5DlXm
33BOb+KodVn+iR7IRgXf4c76pKfd0Xk8ap+X6Rj6FV+1NYfkOYYi9mnnMUZ8
uvFQepRdYbyHfyf2if+U3UxnyfEzLfU/z8Sv9rCT3UD3Ya465Ziur430YTpI
jgf0f8badf6HJbhXf91xyp4L2cX+n4PG28TlWfcSO1e+T/im+s++d565tJ17
2mu83XwresmaJPV3OeMjaHQ/XZ37OAzCcmsm9Hbf9D7aE9PUHY8V9nbNW23t
fHfTn/AtZngXr4tfLHYWVopdiAbxAxL7QGt1ptFiHLLXZvs5i3psY6eb3yR+
u/e00zvKFL+Fvsz+0l1OYA9FtR4/F1+r5wvid6jTxN6v7nH8jnTv6SO6DRU4
zb9ZXG3iv7D3U/Lm0IN0FK2Xv7ezSEYgyfr/xDZ565ON5zrDeXSHHkfTfHZ/
Ws//Ci4k/k256vgvqFPFV0fLaQNN8kY2u8uW7mq4t5JKd7DXeA8X1W9p/WHv
+Aw+FjvF/bcR9z9+2xWl
           "]],
          RowBox[{"-", "1.12`"}]],
         Annotation[#, -1.12, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{5618, 11292, 10587, 10588, 9746, 9747, 3746, 3641, 8583, 
           8584, 7785, 12417, 12418, 12236, 12237, 3747, 3645, 11650, 11651, 
           11649, 11653, 11652, 3864, 7842, 4439, 8585, 7786, 7787, 9722, 
           11295, 11296, 8240, 8239, 4077, 7712, 9690, 9691, 9689, 9693, 9692,
            5203, 6703, 8859, 8838, 8860, 8218, 9558, 12169, 9579, 12385, 
           6021, 12211, 9600, 12190, 5691, 11341, 5712, 9197, 4561, 8816, 
           5160, 8153, 9106, 9127, 5594, 8196, 8174, 6683, 5181, 7200, 4440, 
           10895, 5140, 10089, 10109, 10129, 6001, 11796, 5646, 11297, 5666, 
           11317, 4541, 10875, 5100, 9969, 9989, 10009, 5574, 10069, 10049, 
           10029, 5120, 6661, 6641, 5060, 12093, 5080, 4056, 5624, 11971, 
           3646, 6759, 4918, 12073, 4938, 4036, 10835, 4978, 10795, 4958, 
           10815, 5540, 6511, 4307, 7717, 4327, 6531, 7961, 11714, 11734, 
           9887, 9907, 3992, 7421, 7671}],
          RowBox[{"-", "1.2600000000000002`"}]],
         Annotation[#, -1.2600000000000002`, "Tooltip"]& ], 
        TagBox[
         TooltipBox[
          LineBox[{7763, 7764, 7447, 6140, 11925, 6141, 11926, 5740, 7448, 
           3698, 11997, 6142, 5747, 9664, 6143, 7767, 7768, 3699, 7454, 3703, 
           9495, 9496, 9494, 5955, 7592, 7591, 9822, 9821, 9820, 5956, 11672, 
           11930, 11929, 10673, 10674, 9787, 9788, 3814, 9789, 3815, 4654, 
           10736, 4655, 6716, 6715, 3892, 10789, 10790, 10788, 10792, 10791, 
           4657, 7657, 4656, 12384, 6845, 7827, 3816, 9547, 3817, 7828, 8656, 
           8655, 10677, 10676, 10675, 8105, 9882, 7029, 4866, 7113, 7103, 
           4767, 7625, 7635, 7019, 7901, 3906, 6937, 3894, 7887, 7047, 7613, 
           7598, 4801, 7090, 4853, 6496, 4835, 8050, 8031, 6889, 4782, 6868, 
           6849, 7272, 7293, 6237, 7314, 6217, 7473, 4416, 6622, 8330, 8309, 
           11059, 11039, 8923, 8289, 5231, 8903, 4507, 7251, 5250, 6724, 8369,
            4184, 9170, 4164, 12047, 9150, 8349, 8962, 8942, 4613, 10681, 
           10701, 8662, 12317, 12357, 12337, 4224, 10316, 4204, 10296, 10276, 
           11098, 11078, 6273, 11510, 11530, 11450, 11490, 11470, 11870, 4244,
            10356, 10336, 11139, 11118, 6356, 9006, 9028, 8458, 9050, 9071, 
           5321, 8437, 8416, 8395, 5275, 8985, 6293, 9373, 5806, 8480, 5785, 
           9352, 6071, 8524, 8502, 6815, 5300, 7337, 6376, 11180, 5361, 10435,
            10455, 10475, 5401, 10415, 10395, 10375, 5341, 11160, 6313, 11602,
            5851, 11562, 5831, 11582, 6091, 10535, 10515, 10495, 5381, 6396, 
           3825, 5461, 12136, 5481, 4268, 5441, 12116, 5421, 3787, 3723, 
           12008, 5874, 4288, 11240, 5521, 11200, 5501, 11220, 3845, 6552, 
           4353, 7738, 4373, 6572, 8070, 11757, 11777, 9930, 9950, 4016, 7511,
            7693}],
          RowBox[{"-", "1.2600000000000002`"}]],
         Annotation[#, -1.2600000000000002`, "Tooltip"]& ], 
        TagBox[
         TooltipBox[LineBox[{10976, 5206, 10997, 10955, 10976}],
          RowBox[{"-", "1.2600000000000002`"}]],
         Annotation[#, -1.2600000000000002`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{7504, 6748, 6749, 5768, 12000, 3709, 3778, 11439, 10647, 
           10648, 9774, 11440, 11441, 5769, 11442, 11444, 11443, 4502, 8640, 
           4503, 8641, 9510, 9511, 5966, 11679, 5967, 11680, 4409, 7770, 7815,
            11999, 3704, 3776, 8692, 8693, 4778, 8024, 8025, 8026, 5615, 9189,
            3977, 6491, 5996, 9883, 9884, 9885, 7658, 3991, 8110, 8109, 10770,
            10771, 4711, 10769, 8756, 10793, 10794, 8106, 8107, 8108, 6951, 
           6952, 5958, 6949, 7899, 7900, 3905, 6936, 3893, 7886, 7046, 7612, 
           7597, 4800, 7089, 4852, 6495, 4834, 8049, 8030, 6888, 4781, 6867, 
           6848, 7271, 7292, 6236, 7313, 6216, 7472, 4415, 6621, 8329, 8308, 
           11058, 11038, 8922, 8288, 5230, 8902, 4506, 7250, 5249, 6723, 8368,
            4183, 9169, 4163, 12046, 9149, 8348, 8961, 8941, 4612, 10680, 
           10700, 8661, 12316, 12356, 12336, 4223, 10315, 4203, 10295, 10275, 
           11097, 11077, 6272, 11509, 11529, 11449, 11489, 11469, 11869, 4243,
            10355, 10335, 11138, 11117, 6355, 9005, 9027, 8457, 9049, 9070, 
           5320, 8436, 8415, 8394, 5274, 8984, 6292, 9372, 5805, 8479, 5784, 
           9351, 6070, 8523, 8501, 6814, 5299, 7336, 6375, 11179, 5360, 10434,
            10454, 10474, 5400, 10414, 10394, 10374, 5340, 11159, 6312, 11601,
            5850, 11561, 5830, 11581, 6090, 10534, 10514, 10494, 5380, 6395, 
           3824, 5460, 12135, 5480, 4267, 5440, 12115, 5420, 3786, 3722, 
           12007, 5873, 4287, 11239, 5520, 11199, 5500, 11219, 3844, 6551, 
           4352, 7737, 4372, 6571, 8069, 11756, 11776, 9929, 9949, 4015, 7510,
            7692}],
          RowBox[{"-", "1.4000000000000001`"}]],
         Annotation[#, -1.4000000000000001`, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{8307, 11057, 11037, 8921, 8287, 5229, 8901, 4505, 7249, 
           5248, 6722, 8367, 4182, 9168, 4162, 12045, 9148, 8347, 8960, 8940, 
           4611, 10679, 10699, 8660, 12315, 12355, 12335, 4222, 10314, 4202, 
           10294, 10274, 11096, 11076, 6271, 11508, 11528, 11448, 11488, 
           11468, 11868, 4242, 10354, 10334, 11137, 11116, 6354, 9004, 9026, 
           8456, 9048, 9069, 5319, 8435, 8414, 8393, 5273, 8983, 6291, 9371, 
           5804, 8478, 5783, 9350, 6069, 8522, 8500, 8521, 6813, 4264, 9188, 
           4265, 8499, 8477, 5297, 9047, 4533, 6755, 5294, 12114, 5295, 4263, 
           7664, 7665, 6068, 11865, 11867, 11866, 3714, 3780, 10754, 10755, 
           10753, 10757, 10756, 4396, 10760, 4679, 10758, 4678, 10759, 3822, 
           6353, 4674, 12036, 3925, 6066, 5770, 12162, 5771, 6270, 10746, 
           10747, 9837, 9838, 3923, 11287, 3924, 9840, 9839, 10749, 10748, 
           11644, 6120, 12233, 6121, 5960, 11673, 11674, 9823, 9824, 3917, 
           7246, 11908, 11909, 11907, 11911, 11910, 6126, 9656, 9657, 9655, 
           11913, 11912, 6717, 8748, 8749, 8747, 8751, 8750, 4712, 7595, 5957,
            6948, 7885, 7045, 7611, 7596, 4799, 7088, 4851, 6494, 4833, 8048, 
           8029, 6887, 4780, 6866, 6847, 7270, 7291, 6235, 7312, 6215, 7471, 
           4414, 6620, 8328, 8307}],
          RowBox[{"-", "1.54`"}]],
         Annotation[#, -1.54, "Tooltip"]& ], 
        TagBox[
         TooltipBox[LineBox[{7334, 5298, 7335, 7333, 7334}],
          RowBox[{"-", "1.54`"}]],
         Annotation[#, -1.54, "Tooltip"]& ]}, 
       {GrayLevel[0], Opacity[0.4], 
        TagBox[
         TooltipBox[
          LineBox[{11056, 8306, 8327, 6619, 4413, 7470, 6214, 7311, 6234, 
           7290, 7269, 6846, 6865, 4779, 6886, 8028, 8047, 4832, 6493, 4850, 
           7087, 4798, 7610, 7059, 7594, 7593, 6950, 3990, 8103, 8104, 8637, 
           10646, 8636, 7816, 9667, 9668, 9665, 6146, 9666, 7490, 7491, 6128, 
           9658, 6127, 11914, 4161, 9652, 9464, 9465, 8326, 5918, 7244, 7243, 
           6720, 6721, 7248, 4504, 8900, 5228, 8286, 8920, 11036, 11056}],
          RowBox[{"-", "1.6800000000000002`"}]],
         Annotation[#, -1.6800000000000002`, "Tooltip"]& ]}, {}, {}}}],
    AspectRatio->1,
    Frame->True,
    PlotRange->{{-3, 3}, {-3, 3}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{390, 185},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->400907272]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20632],

Cell["Compose with inverse function:", "ExampleText",
 CellID->196753002],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"InverseJacobiSN", "[", 
    RowBox[{
     RowBox[{"JacobiSN", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], ",", 
   RowBox[{"JacobiSN", "[", 
    RowBox[{
     RowBox[{"InverseJacobiSN", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5296189],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"InverseJacobiSN", "[", 
    RowBox[{
     RowBox[{"JacobiSN", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], ",", "z"}], 
  "}"}]], "Output",
 ImageSize->{269, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->121316302]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " to disregard multivaluedness of the inverse function:"
}], "ExampleText",
 CellID->785308763],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->81233632],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", "z"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->574903724]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->390870124],

Cell[TextData[{
 "Differentiate",
 Cell[BoxData[
  RowBox[{" ", "InverseJacobiSN"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->715886131],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"InverseJacobiSN", "[", 
     RowBox[{"z", ",", "m"}], "]"}], ",", "z"}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->809586479],

Cell[BoxData[
 FractionBox[
  RowBox[{"JacobiCD", "[", 
   RowBox[{
    RowBox[{"InverseJacobiSN", "[", 
     RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], 
  RowBox[{"1", "-", 
   SuperscriptBox["z", "2"]}]]], "Output",
 ImageSize->{241, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->113794501]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"InverseJacobiSN", "[", 
     RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->192074691],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", "m"}]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"EllipticE", "[", 
      RowBox[{
       RowBox[{"JacobiAmplitude", "[", 
        RowBox[{
         RowBox[{"InverseJacobiSN", "[", 
          RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], ",", "m"}], 
      "]"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
      RowBox[{"InverseJacobiSN", "[", 
       RowBox[{"z", ",", "m"}], "]"}]}], "-", 
     RowBox[{"m", " ", "z", " ", 
      RowBox[{"JacobiCD", "[", 
       RowBox[{
        RowBox[{"InverseJacobiSN", "[", 
         RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}]}]}], 
    ")"}]}]}]], "Output",
 ImageSize->{500, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->242318997]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20875427],

Cell[TextData[{
 "Obtain",
 Cell[BoxData[
  RowBox[{" ", "InverseJacobiSN"}]], "InlineFormula"],
 " from solving equations containing elliptic functions:"
}], "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->322808586],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"JacobiSN", "[", 
       RowBox[{"x", ",", "m"}], "]"}], "2"], "+", 
     RowBox[{"2", 
      RowBox[{"JacobiSN", "[", 
       RowBox[{"x", ",", "m"}], "]"}]}]}], "==", "a"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->554970152],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->761595092],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      RowBox[{"InverseJacobiSN", "[", 
       RowBox[{
        RowBox[{"1", "-", 
         SqrtBox[
          RowBox[{"1", "+", "a"}]]}], ",", "m"}], "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      RowBox[{"InverseJacobiSN", "[", 
       RowBox[{
        RowBox[{"1", "+", 
         SqrtBox[
          RowBox[{"1", "+", "a"}]]}], ",", "m"}], "]"}]}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{520, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->639450188]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22797],

Cell["\<\
Machine-precision input is insufficient to get a correct answer:\
\>", "ExampleText",
 CellID->3979231],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseJacobiSN", "[", 
  RowBox[{
   RowBox[{"10.", "^", "5"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->563558634],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->388939420]
}, Open  ]],

Cell["With exact input, the answer is correct:", "ExampleText",
 CellID->260060486],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"InverseJacobiSN", "[", 
    RowBox[{
     RowBox[{"10", "^", "5"}], ",", "2"}], "]"}], ",", "50"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->289346646],

Cell[BoxData[
 RowBox[{"7.07106781204225193931347739517578891968238671545340348890686`44.\
88238777542462*^-6", "-", 
  RowBox[{
  "1.3110287771460599052324197949455597068413774757158115814082620192713`50.\
150514997825674", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{386, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->715164997]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14166],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiSN",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiSN"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseJacobiSC",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseJacobiSC"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseJacobiSD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseJacobiSD"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8929]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5364],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "Tutorials",
 CellID->30967]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->248606618],

Cell[TextData[ButtonBox["Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticFunctions"]], "MoreAbout",
 CellID->502973678],

Cell[TextData[ButtonBox["Inverse Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InverseFunctions"]], "MoreAbout",
 CellID->358196468],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->3342151]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InverseJacobiSN - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 51, 0.6682480}", "context" -> "System`", 
    "keywords" -> {
     "inverse Jacobi", "inverse Jacobi elliptic function sn", 
      "Jacobi elliptic functions"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "InverseJacobiSN[v, m] gives the inverse Jacobi elliptic function sn -1 \
(v \\[VerticalSeparator] m).", "synonyms" -> {"inverse Jacobi SN"}, "title" -> 
    "InverseJacobiSN", "type" -> "Symbol", "uri" -> "ref/InverseJacobiSN"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6611, 227, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->15022297]},
 "XRef-2005-4-26-23-37-1.8558342"->{
  Cell[612114, 10701, 192, 7, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342",
   CellID->715886131],
  Cell[614302, 10790, 238, 7, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342",
   CellID->322808586]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 621180, 11038},
 {"XRef-2005-4-26-23-37-1.8558342", 621336, 11042}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2337, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2960, 84, 52, 1, 70, "ObjectName",
 CellID->8056],
Cell[3015, 87, 779, 25, 70, "Usage",
 CellID->18518]
}, Open  ]],
Cell[CellGroupData[{
Cell[3831, 117, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4309, 134, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4432, 140, 533, 21, 70, "Notes",
 CellID->14109],
Cell[4968, 163, 771, 26, 70, "Notes",
 CellID->51178553],
Cell[5742, 191, 114, 3, 70, "Notes",
 CellID->17300],
Cell[5859, 196, 262, 8, 70, "Notes",
 CellID->268397156],
Cell[6124, 206, 232, 7, 70, "Notes",
 CellID->31226],
Cell[6359, 215, 215, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6611, 227, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->15022297],
Cell[CellGroupData[{
Cell[6995, 241, 148, 5, 70, "ExampleSection",
 CellID->505450076],
Cell[7146, 248, 64, 1, 70, "ExampleText",
 CellID->435904782],
Cell[CellGroupData[{
Cell[7235, 253, 138, 4, 28, "Input",
 CellID->732399037],
Cell[7376, 259, 175, 5, 36, "Output",
 CellID->81309148]
}, Open  ]],
Cell[CellGroupData[{
Cell[7588, 269, 127, 4, 28, "Input",
 CellID->9511832],
Cell[7718, 275, 175, 5, 36, "Output",
 CellID->73565171]
}, Open  ]],
Cell[7908, 283, 125, 3, 70, "ExampleDelimiter",
 CellID->623105011],
Cell[CellGroupData[{
Cell[8058, 290, 297, 10, 28, "Input",
 CellID->379613509],
Cell[8358, 302, 2343, 42, 127, "Output",
 Evaluatable->False,
 CellID->384442841]
}, Open  ]],
Cell[10716, 347, 125, 3, 70, "ExampleDelimiter",
 CellID->119939810],
Cell[10844, 352, 60, 1, 70, "ExampleText",
 CellID->155193858],
Cell[CellGroupData[{
Cell[10929, 357, 251, 8, 70, "Input",
 CellID->63397604],
Cell[11183, 367, 914, 29, 51, "Output",
 CellID->1005325631]
}, Open  ]],
Cell[CellGroupData[{
Cell[12134, 401, 252, 8, 70, "Input",
 CellID->468065359],
Cell[12389, 411, 868, 28, 52, "Output",
 CellID->240735698]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13306, 445, 216, 7, 70, "ExampleSection",
 CellID->19903],
Cell[13525, 454, 73, 1, 70, "ExampleText",
 CellID->55645938],
Cell[CellGroupData[{
Cell[13623, 459, 208, 7, 70, "Input",
 CellID->266251706],
Cell[13834, 468, 274, 7, 36, "Output",
 CellID->282308603]
}, Open  ]],
Cell[14123, 478, 125, 3, 70, "ExampleDelimiter",
 CellID->268824359],
Cell[14251, 483, 70, 1, 70, "ExampleText",
 CellID->132691703],
Cell[CellGroupData[{
Cell[14346, 488, 241, 8, 70, "Input",
 CellID->866802414],
Cell[14590, 498, 234, 7, 36, "Output",
 CellID->11594910]
}, Open  ]],
Cell[14839, 508, 124, 3, 70, "ExampleDelimiter",
 CellID->36479535],
Cell[14966, 513, 113, 3, 70, "ExampleText",
 CellID->579439215],
Cell[CellGroupData[{
Cell[15104, 520, 194, 6, 70, "Input",
 CellID->632752147],
Cell[15301, 528, 229, 6, 36, "Output",
 CellID->789671288]
}, Open  ]],
Cell[15545, 537, 125, 3, 70, "ExampleDelimiter",
 CellID->688497564],
Cell[15673, 542, 231, 7, 70, "ExampleText",
 CellID->43876107],
Cell[CellGroupData[{
Cell[15929, 553, 185, 6, 70, "Input",
 CellID->271543877],
Cell[16117, 561, 341, 11, 36, "Output",
 CellID->41582739]
}, Open  ]],
Cell[16473, 575, 125, 3, 70, "ExampleDelimiter",
 CellID->255377976],
Cell[16601, 580, 92, 1, 70, "ExampleText",
 CellID->328717422],
Cell[CellGroupData[{
Cell[16718, 585, 251, 8, 70, "Input",
 CellID->617758456],
Cell[16972, 595, 273, 9, 36, "Output",
 CellID->346357462]
}, Open  ]],
Cell[CellGroupData[{
Cell[17282, 609, 251, 8, 70, "Input",
 CellID->658205930],
Cell[17536, 619, 241, 8, 36, "Output",
 CellID->401719724]
}, Open  ]],
Cell[17792, 630, 90, 1, 70, "ExampleText",
 CellID->368884824],
Cell[CellGroupData[{
Cell[17907, 635, 153, 5, 70, "Input",
 CellID->508781695],
Cell[18063, 642, 242, 8, 36, "Output",
 CellID->337110699]
}, Open  ]],
Cell[18320, 653, 124, 3, 70, "ExampleDelimiter",
 CellID->23210608],
Cell[18447, 658, 203, 7, 70, "ExampleText",
 CellID->471035179],
Cell[CellGroupData[{
Cell[18675, 669, 173, 5, 70, "Input",
 CellID->179888293],
Cell[18851, 676, 323, 11, 52, "Output",
 CellID->104953947]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19223, 693, 239, 7, 70, "ExampleSection",
 CellID->29214],
Cell[19465, 702, 225, 7, 70, "ExampleText",
 CellID->120235099],
Cell[CellGroupData[{
Cell[19715, 713, 248, 9, 70, "Input",
 CellID->77454719],
Cell[19966, 724, 1265, 40, 54, "Output",
 CellID->128711151]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21280, 770, 223, 7, 70, "ExampleSection",
 CellID->14269],
Cell[21506, 779, 123, 3, 70, "ExampleText",
 CellID->147991225],
Cell[CellGroupData[{
Cell[21654, 786, 716, 23, 70, "Input",
 CellID->41283476],
Cell[22373, 811, 587895, 9809, 70, "Output",
 CellID->400907272]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[610317, 10626, 233, 7, 70, "ExampleSection",
 CellID->20632],
Cell[610553, 10635, 73, 1, 70, "ExampleText",
 CellID->196753002],
Cell[CellGroupData[{
Cell[610651, 10640, 379, 12, 70, "Input",
 CellID->5296189],
Cell[611033, 10654, 340, 12, 36, "Output",
 CellID->121316302]
}, Open  ]],
Cell[611388, 10669, 246, 8, 70, "ExampleText",
 CellID->785308763],
Cell[CellGroupData[{
Cell[611659, 10681, 106, 3, 70, "Input",
 CellID->81233632],
Cell[611768, 10686, 203, 7, 36, "Output",
 CellID->574903724]
}, Open  ]],
Cell[611986, 10696, 125, 3, 70, "ExampleDelimiter",
 CellID->390870124],
Cell[612114, 10701, 192, 7, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->715886131],
Cell[CellGroupData[{
Cell[612331, 10712, 225, 8, 70, "Input",
 CellID->809586479],
Cell[612559, 10722, 356, 12, 52, "Output",
 CellID->113794501]
}, Open  ]],
Cell[CellGroupData[{
Cell[612952, 10739, 225, 8, 70, "Input",
 CellID->192074691],
Cell[613180, 10749, 980, 33, 70, "Output",
 CellID->242318997]
}, Open  ]],
Cell[614175, 10785, 124, 3, 70, "ExampleDelimiter",
 CellID->20875427],
Cell[614302, 10790, 238, 7, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->322808586],
Cell[CellGroupData[{
Cell[614565, 10801, 359, 13, 70, "Input",
 CellID->554970152],
Cell[614927, 10816, 453, 8, 70, "Message",
 CellID->761595092],
Cell[615383, 10826, 665, 24, 43, "Output",
 CellID->639450188]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[616097, 10856, 226, 7, 70, "ExampleSection",
 CellID->22797],
Cell[616326, 10865, 113, 3, 70, "ExampleText",
 CellID->3979231],
Cell[CellGroupData[{
Cell[616464, 10872, 160, 5, 70, "Input",
 CellID->563558634],
Cell[616627, 10879, 170, 5, 36, "Output",
 CellID->388939420]
}, Open  ]],
Cell[616812, 10887, 83, 1, 70, "ExampleText",
 CellID->260060486],
Cell[CellGroupData[{
Cell[616920, 10892, 218, 8, 70, "Input",
 CellID->289346646],
Cell[617141, 10902, 392, 10, 54, "Output",
 CellID->715164997]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[617594, 10919, 311, 9, 70, "SeeAlsoSection",
 CellID->14166],
Cell[617908, 10930, 723, 26, 70, "SeeAlso",
 CellID->8929]
}, Open  ]],
Cell[CellGroupData[{
Cell[618668, 10961, 313, 9, 70, "TutorialsSection",
 CellID->5364],
Cell[618984, 10972, 192, 4, 70, "Tutorials",
 CellID->30967]
}, Open  ]],
Cell[CellGroupData[{
Cell[619213, 10981, 319, 9, 70, "MoreAboutSection",
 CellID->248606618],
Cell[619535, 10992, 147, 3, 70, "MoreAbout",
 CellID->502973678],
Cell[619685, 10997, 145, 3, 70, "MoreAbout",
 CellID->358196468],
Cell[619833, 11002, 143, 3, 70, "MoreAbout",
 CellID->3342151]
}, Open  ]],
Cell[619991, 11008, 27, 0, 70, "History"],
Cell[620021, 11010, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

