(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29027,       1028]
NotebookOptionsPosition[     23886,        848]
NotebookOutlinePosition[     25264,        885]
CellTagsIndexPosition[     25179,        880]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Power Series" :> 
          Documentation`HelpLookup["paclet:tutorial/PowerSeries"], 
          "Making Power Series Expansions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MakingPowerSeriesExpansions"], 
          "Operations on Power Series" :> 
          Documentation`HelpLookup["paclet:tutorial/OperationsOnPowerSeries"],
           "The Representation of Power Series" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheRepresentationOfPowerSeries"], 
          "Composition and Inversion of Power Series" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/CompositionAndInversionOfPowerSeries"], 
          "Solving Equations Involving Power Series" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SolvingEquationsInvolvingPowerSeries"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Power Series\"\>", 
       2->"\<\"Making Power Series Expansions\"\>", 
       3->"\<\"Operations on Power Series\"\>", 
       4->"\<\"The Representation of Power Series\"\>", 
       5->"\<\"Composition and Inversion of Power Series\"\>", 
       6->"\<\"Solving Equations Involving Power Series\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Series" :> Documentation`HelpLookup["paclet:ref/Series"], 
          "ComposeSeries" :> 
          Documentation`HelpLookup["paclet:ref/ComposeSeries"], "Solve" :> 
          Documentation`HelpLookup["paclet:ref/Solve"], "InverseFunction" :> 
          Documentation`HelpLookup["paclet:ref/InverseFunction"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Series\"\>", 
       2->"\<\"ComposeSeries\"\>", 3->"\<\"Solve\"\>", 
       4->"\<\"InverseFunction\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Series Expansions" :> 
          Documentation`HelpLookup["paclet:guide/SeriesExpansions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Series Expansions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InverseSeries", "ObjectName",
 CellID->18748],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InverseSeries",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InverseSeries"], "[", 
       StyleBox["s", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]takes the series ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     ", and gives a series for the inverse of the function represented by ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InverseSeries",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InverseSeries"], "[", 
       RowBox[{
        StyleBox["s", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]uses the variable ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " in the inverse series."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->23251]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseSeries",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseSeries"]], "InlineFormula"],
 " performs \[OpenCurlyDoubleQuote]reversion\[CloseCurlyDoubleQuote] of \
series. "
}], "Notes",
 CellID->32134],

Cell[TextData[{
 "Given a series ",
 Cell[BoxData[
  FormBox[
   RowBox[{"s", "(", "y", ")"}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InverseSeries",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseSeries"], "[", 
   RowBox[{
    StyleBox["s", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " gives a series for ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"s", "(", "y", ")"}], "=", "x"}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Notes",
 CellID->28406],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InverseSeries",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseSeries"]], "InlineFormula"],
 " can be applied to any ",
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 " object with the appropriate structure, whether or not it has been \
generated by ",
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->11831]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->18910891],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->173277972],

Cell[TextData[{
 "Find a series for the inverse function of ",
 Cell[BoxData[
  RowBox[{"x", " ", 
   RowBox[{
    ButtonBox["Sin",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Sin"], "[", "x", "]"}]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->16917],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseSeries", "[", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"x", " ", 
     RowBox[{"Sin", "[", "x", "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17323],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SqrtBox["x"], "+", 
   FractionBox[
    SuperscriptBox["x", 
     RowBox[{"3", "/", "2"}]], "12"], "+", 
   FractionBox[
    RowBox[{"29", " ", 
     SuperscriptBox["x", 
      RowBox[{"5", "/", "2"}]]}], "1440"], "+", 
   FractionBox[
    RowBox[{"263", " ", 
     SuperscriptBox["x", 
      RowBox[{"7", "/", "2"}]]}], "40320"], "+", 
   FractionBox[
    RowBox[{"23479", " ", 
     SuperscriptBox["x", 
      RowBox[{"9", "/", "2"}]]}], "9676800"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "5"],
    SeriesData[x, 0, {}, 1, 10, 2],
    Editable->False]}],
  SeriesData[x, 0, {1, 0, 
    Rational[1, 12], 0, 
    Rational[29, 1440], 0, 
    Rational[263, 40320], 0, 
    Rational[23479, 9676800]}, 1, 10, 2],
  Editable->False]], "Output",
 ImageSize->{313, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14009]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7823],

Cell[TextData[{
 "Find a series for the inverse function of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sin"], "[", "x", "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->27319],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseSeries", "[", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26416],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["x", "5"]}], "40"], "+", 
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox["x", "7"]}], "112"], "+", 
   FractionBox[
    RowBox[{"35", " ", 
     SuperscriptBox["x", "9"]}], "1152"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[x, 0, {}, 1, 11, 1],
    Editable->False]}],
  SeriesData[x, 0, {1, 0, 
    Rational[1, 6], 0, 
    Rational[3, 40], 0, 
    Rational[5, 112], 0, 
    Rational[35, 1152]}, 1, 11, 1],
  Editable->False]], "Output",
 ImageSize->{217, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19233]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ArcSin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24234],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["x", "5"]}], "40"], "+", 
   FractionBox[
    RowBox[{"5", " ", 
     SuperscriptBox["x", "7"]}], "112"], "+", 
   FractionBox[
    RowBox[{"35", " ", 
     SuperscriptBox["x", "9"]}], "1152"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[x, 0, {}, 1, 11, 1],
    Editable->False]}],
  SeriesData[x, 0, {1, 0, 
    Rational[1, 6], 0, 
    Rational[3, 40], 0, 
    Rational[5, 112], 0, 
    Rational[35, 1152]}, 1, 11, 1],
  Editable->False]], "Output",
 ImageSize->{217, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->17325]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23743],

Cell["\<\
Find the series for the inverse of the function represented by an explicitly \
specified series:\
\>", "ExampleText",
 CellID->1133],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseSeries", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], "+", 
   RowBox[{"3", 
    RowBox[{"x", "^", "4"}]}], "+", 
   RowBox[{
    RowBox[{"O", "[", "x", "]"}], "^", "8"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4901],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SqrtBox["x"], "-", 
   FractionBox[
    RowBox[{"3", " ", 
     SuperscriptBox["x", 
      RowBox[{"3", "/", "2"}]]}], "2"], "+", 
   FractionBox[
    RowBox[{"63", " ", 
     SuperscriptBox["x", 
      RowBox[{"5", "/", "2"}]]}], "8"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], 
     RowBox[{"7", "/", "2"}]],
    SeriesData[x, 0, {}, 1, 7, 2],
    Editable->False]}],
  SeriesData[x, 0, {1, 0, 
    Rational[-3, 2], 0, 
    Rational[63, 8]}, 1, 7, 2],
  Editable->False]], "Output",
 ImageSize->{190, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31336]
}, Open  ]],

Cell["Invert again to get back the original function:", "ExampleText",
 CellID->23626],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseSeries", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14798],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SuperscriptBox["x", "2"], "+", 
   RowBox[{"3", " ", 
    SuperscriptBox["x", "4"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "8"],
    SeriesData[x, 0, {}, 2, 8, 1],
    Editable->False]}],
  SeriesData[x, 0, {1, 0, 3}, 2, 8, 1],
  Editable->False]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->31031]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21115],

Cell[TextData[{
 "Invert a series, giving a result in terms of the variable ",
 Cell[BoxData["y"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->32526],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseSeries", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"2", " ", "x"}], "+", 
    RowBox[{"3", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{
     RowBox[{"O", "[", "x", "]"}], "^", "5"}]}], ",", "y"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19186],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{"y", "-", "1"}], "2"], "-", 
   RowBox[{
    FractionBox["3", "8"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"y", "-", "1"}], ")"}], "2"]}], "+", 
   RowBox[{
    FractionBox["9", "16"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"y", "-", "1"}], ")"}], "3"]}], "-", 
   RowBox[{
    FractionBox["135", "128"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"y", "-", "1"}], ")"}], "4"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"y", "-", "1"}], "]"}], "5"],
    SeriesData[y, 1, {}, 1, 5, 1],
    Editable->False]}],
  SeriesData[y, 1, {
    Rational[1, 2], 
    Rational[-3, 8], 
    Rational[9, 16], 
    Rational[-135, 128]}, 1, 5, 1],
  Editable->False]], "Output",
 ImageSize->{341, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27229]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21451],

Cell[TextData[{
 "Find higher-order terms in Newton's approximation for a root of ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " near ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "=", 
   StyleBox["a", "TI"]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->8947],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseSeries", "[", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "a", ",", "3"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31724],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWktPU0EUnvb2WpCoRW1BRKyPGBLBjQtRl0Zdmbj0mdgQElgYDfAfDCTK
HzCujHtRY5QFa9e69Td0yXK884Lp13PvmXtpCSok7fTMPeeb85ozc2e411qe
n3veWl6YbTXvLrZezi/MLjXvvFhMuqKSEOVBIcSlUZH8lskv/XF/Q8lnhzTU
avJdTpiGbPsB6A3NdRl676veaBtb9/v0e+b5t23ULK5ryVeckLFtB+B5ZPsj
6F9LvhR5yD6vBsoZrSZyjqa0FLHvZ2HH9rkGgS6TUhXgehOEjZqGYRtrz/ZE
zxmg0eP/tvXXgeZirzKo0jN709DCLEyTvgF0TMhl0WGeU1yqnqxaLaiZ2oWa
exRE+RTkmTDsm8RYSgg1pfwV2drm9yP+K6CrKfjUeBS+z6fs+azbiRTUUK3D
aiAV/az6j6OvEL7owu/S4gijxbqksoHLb9R1xnpmwGv9FRN9sWL5ql7r81ds
+0Vr17Rc1HzwpWYhuuvAb6L9Dno/WvQli9IE1Ni2eoZooR+AgN5D76DPdeS0
9m59959+BboNdCy9LKz48S7bHFbtMYtOVQNqHad1NGzGoZivKMHpTecnOSt2
rEp+DBP2569U+e1z8TG5u7m5KczflPqKJicnt7a2HDLFNwd8UQrfb81Xq9Xa
7baPF+avyMa72oHeH28p2QoxRm8i7yw5zliQtmb/nxmsZF3nRjpOoToRskIb
LX5B72ugHwRZOML4iaurTueSxr8qO+v4RaAR7YzsXoPwuU+vETY6jyn5U5au
SHo9UbOoZLXd0TjL3vPMc9wbTzD8uAaMMxa+lWbmGW3rcncrzgnbfziQX2da
39a700CPQdQuAE3tEnx5tGpcZmfXU48W1i4hGp0296yWnAQaMyMMBXege1X5
xpjYoTXnmOfcPMHxcZ5hZeDmmYq1y12hq17vV/D+RHhvdhsYX1fX3YlWaMWo
y3wnYO6kDX2Xa8+cWqGOyt1VKJU1neuFy5yiOyYuR9Lk0rKiVzs3jD+dRZh7
xTK8AXSx8zTUpV4IJX99rTEeLzbuM813sPZQvsHc5E55ilmnpKj6up+z01UB
V6X7szaY3Myz93R7cmrv2Z01oQjFd6MUGvUOqUiMVN5sS6u4XNVLk+NiytG5
3t2J3OLmdCi+ySK8gePeN6l9QXb2cG9oGAdOA+5cFvPFvXuiP/fTWsnFnjxf
+cvW0ilJnwWMSO9ku0ObCDgxYo0URBwfrcAcxmh03OAUqoyudtUkfasSelcT
Z8hTb9xF75iK79pDK7nCeaKduMFEI2ynm7/uoA+xjnI3jYhHasTN2Qz+vG/c
WOfy1k3kf6jd+N3rVX7Heucy291y8bMWxxmmJUFq0HKF3EdSq2TomVRdFqsh
jySVyxiTK0Djf0lwOYKnwbfJmP2E3mmIob7Jr8KMss/Qf6NA3wKsx7rFs+5p
oPWIXXOYGwutMz52COa/lUTpD93MrxM=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{521, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->324632830]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Normal", "[", "%", "]"}], "/.", 
  RowBox[{"x", "->", "0"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14543],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlWEuLE0EQnknPmF1XcWHXGDWaqOBNr74QchCF1T2IID4ObgzLJuCirHv1
JN5E9Bfkf6iQoz9r7Ge2/bamHzMJLG4g01PVVdX16prq3hzsj7Z3B/vj4aD3
aG/wYTQefuw9fL/HUSxNkvRNkiTX2wl/L/ib/IvfFv+rV/U25s8Gn1zR4xeA
n0mqa4C9JbDMyCwk3oY/e+afzqS6qC7zR87BXI9LMM80ngF+lz8EeCKST2nV
iuQSWib5DJYy1No21TLADZIrA6p3C5StrD03F1ldgJvHyvoewD4NRQZlc7O3
TFqYhWXcVwDOCT4XHOY5QSXqyUhrgXkzn1WQ63GQZ8JkXyXWEkyNAEuYrm02
HuVvA9ysKd/mE/Y8kWOrptSwGkhF31X/cfUdwhd15CP9RkHlhS8HUWpX+2jJ
Gu1vJ3plR9M1S+gzPW5K7dqaitoJNtcGxPkH0Ku4fwLsdy1dzQqU6hKEdBPe
l0oiUwPlZ/F44aUyMpU/ptNpon4d8WD9ft+KkukCbLoHko7DVlwoeb/5P51M
JinHpzNrMq3IqwhrGto7AvNaYv4A7VeApS6yltqx6QLcAfg+SPkGcD6T6srD
S575C575e0FatLXXqZpLdUvrkfQrGn8ykB59uUpYbc9jZ4uxwUqnrD5PYaO/
HWfnIuWUJ45hUjoeKacBvuihr5udqF/2n/p9rYjbDxgH80U2Z53QfWL2Yegp
x5zB1gLpq8WvrBv1RayMzxejMr51z3phscVY0VzYD1TLI/RQtW4WdUE/hEk5
Lnt3MVni65qr6Wq+o6jj0csTV0fBCAtcHQVFb7o4UzGlrtnBfNzKVapS3YiH
VsnQsz6uT/Y8Dv3K5FarA2itb8eT+8GCyTsFZ7xR4mL2uTnXoX5Hqf7jvO9+
ps6+F505Sw7Ou6YDb5fgMQrm/Hw4vgw4ha9iK4bgQ5+it/65+6lUUUxtOlPU
u4/JS/iNJa5bIZdcOnJDwN4htHFluC8Lw/qm+H2NVuNZMfbmh9TIYScVnRg/
Ke+/tbDCL+LcHrJfsPM3uWfurfz7CCWuFmF3U8uaLiS7XXLoszlm43OAsYbd
BPh2ZNRapBY/ISpYO27A/F2pGuS4nkM/4A2lWvEXYF0rile54qFd5VtL3WiJ
1y3Fkf4FbU0tew==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{351, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->177889920]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18702],

Cell["\<\
Composing an inverse series with the original series gives the identity \
function:\
\>", "ExampleText",
 CellID->17491],

Cell[BoxData[
 RowBox[{
  RowBox[{"s", "=", 
   RowBox[{"1", "+", 
    RowBox[{"2", " ", "x"}], "+", 
    RowBox[{"3", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{
     RowBox[{"O", "[", "x", "]"}], "^", "5"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30773],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComposeSeries", "[", 
  RowBox[{
   RowBox[{"InverseSeries", "[", "s", "]"}], ",", "s"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17194],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "5"],
    SeriesData[x, 0, {}, 1, 5, 1],
    Editable->False]}],
  SeriesData[x, 0, {1}, 1, 5, 1],
  Editable->False]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->26479]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1021],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Series",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Series"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ComposeSeries",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ComposeSeries"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Solve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Solve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseFunction"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19280]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5426],

Cell[TextData[ButtonBox["Power Series",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PowerSeries"]], "Tutorials",
 CellID->30232],

Cell[TextData[ButtonBox["Making Power Series Expansions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MakingPowerSeriesExpansions"]], "Tutorials",
 CellID->31271],

Cell[TextData[ButtonBox["Operations on Power Series",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OperationsOnPowerSeries"]], "Tutorials",
 CellID->720780250],

Cell[TextData[ButtonBox["The Representation of Power Series",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheRepresentationOfPowerSeries"]], "Tutorials",
 CellID->31832],

Cell[TextData[ButtonBox["Composition and Inversion of Power Series",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/CompositionAndInversionOfPowerSeries"]], "Tutorials",
 CellID->5053],

Cell[TextData[ButtonBox["Solving Equations Involving Power Series",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SolvingEquationsInvolvingPowerSeries"]], "Tutorials",
 CellID->13840]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->706713485],

Cell[TextData[ButtonBox["Series Expansions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SeriesExpansions"]], "MoreAbout",
 CellID->586312960]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InverseSeries - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 51, 9.5591006}", "context" -> "System`", 
    "keywords" -> {"inverse of power series", "reversion of power series"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "InverseSeries[s] takes the series s, and gives a series for the inverse \
of the function represented by s. InverseSeries[s, x] uses the variable x in \
the inverse series.", "synonyms" -> {"inverse series"}, "title" -> 
    "InverseSeries", "type" -> "Symbol", "uri" -> "ref/InverseSeries"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6805, 216, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->18910891]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 25037, 873}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3042, 69, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3665, 96, 51, 1, 70, "ObjectName",
 CellID->18748],
Cell[3719, 99, 1125, 35, 70, "Usage",
 CellID->23251]
}, Open  ]],
Cell[CellGroupData[{
Cell[4881, 139, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5359, 156, 257, 8, 70, "Notes",
 CellID->32134],
Cell[5619, 166, 614, 25, 70, "Notes",
 CellID->28406],
Cell[6236, 193, 532, 18, 70, "Notes",
 CellID->11831]
}, Closed]],
Cell[CellGroupData[{
Cell[6805, 216, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->18910891],
Cell[CellGroupData[{
Cell[7189, 230, 148, 5, 70, "ExampleSection",
 CellID->173277972],
Cell[7340, 237, 269, 10, 70, "ExampleText",
 CellID->16917],
Cell[CellGroupData[{
Cell[7634, 251, 282, 9, 28, "Input",
 CellID->17323],
Cell[7919, 262, 958, 34, 54, "Output",
 CellID->14009]
}, Open  ]],
Cell[8892, 299, 120, 3, 70, "ExampleDelimiter",
 CellID->7823],
Cell[9015, 304, 242, 9, 70, "ExampleText",
 CellID->27319],
Cell[CellGroupData[{
Cell[9282, 317, 256, 8, 70, "Input",
 CellID->26416],
Cell[9541, 327, 811, 29, 54, "Output",
 CellID->19233]
}, Open  ]],
Cell[CellGroupData[{
Cell[10389, 361, 215, 7, 70, "Input",
 CellID->24234],
Cell[10607, 370, 811, 29, 54, "Output",
 CellID->17325]
}, Open  ]],
Cell[11433, 402, 121, 3, 70, "ExampleDelimiter",
 CellID->23743],
Cell[11557, 407, 142, 4, 70, "ExampleText",
 CellID->1133],
Cell[CellGroupData[{
Cell[11724, 415, 259, 9, 70, "Input",
 CellID->4901],
Cell[11986, 426, 700, 26, 54, "Output",
 CellID->31336]
}, Open  ]],
Cell[12701, 455, 86, 1, 70, "ExampleText",
 CellID->23626],
Cell[CellGroupData[{
Cell[12812, 460, 105, 3, 70, "Input",
 CellID->14798],
Cell[12920, 465, 478, 17, 36, "Output",
 CellID->31031]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13447, 488, 239, 7, 70, "ExampleSection",
 CellID->21115],
Cell[13689, 497, 156, 5, 70, "ExampleText",
 CellID->32526],
Cell[CellGroupData[{
Cell[13870, 506, 299, 10, 70, "Input",
 CellID->19186],
Cell[14172, 518, 963, 36, 51, "Output",
 CellID->27229]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15184, 560, 223, 7, 70, "ExampleSection",
 CellID->21451],
Cell[15410, 569, 341, 13, 70, "ExampleText",
 CellID->8947],
Cell[CellGroupData[{
Cell[15776, 586, 253, 8, 70, "Input",
 CellID->31724],
Cell[16032, 596, 1708, 32, 70, "Output",
 Evaluatable->False,
 CellID->324632830]
}, Open  ]],
Cell[CellGroupData[{
Cell[17777, 633, 146, 5, 70, "Input",
 CellID->14543],
Cell[17926, 640, 1387, 27, 70, "Output",
 Evaluatable->False,
 CellID->177889920]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19362, 673, 233, 7, 70, "ExampleSection",
 CellID->18702],
Cell[19598, 682, 130, 4, 70, "ExampleText",
 CellID->17491],
Cell[19731, 688, 277, 10, 70, "Input",
 CellID->30773],
Cell[CellGroupData[{
Cell[20033, 702, 169, 5, 70, "Input",
 CellID->17194],
Cell[20205, 709, 387, 14, 36, "Output",
 CellID->26479]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20653, 730, 310, 9, 70, "SeeAlsoSection",
 CellID->1021],
Cell[20966, 741, 955, 35, 70, "SeeAlso",
 CellID->19280]
}, Open  ]],
Cell[CellGroupData[{
Cell[21958, 781, 313, 9, 70, "TutorialsSection",
 CellID->5426],
Cell[22274, 792, 134, 3, 70, "Tutorials",
 CellID->30232],
Cell[22411, 797, 168, 3, 70, "Tutorials",
 CellID->31271],
Cell[22582, 802, 164, 3, 70, "Tutorials",
 CellID->720780250],
Cell[22749, 807, 175, 3, 70, "Tutorials",
 CellID->31832],
Cell[22927, 812, 190, 4, 70, "Tutorials",
 CellID->5053],
Cell[23120, 818, 190, 4, 70, "Tutorials",
 CellID->13840]
}, Open  ]],
Cell[CellGroupData[{
Cell[23347, 827, 319, 9, 70, "MoreAboutSection",
 CellID->706713485],
Cell[23669, 838, 145, 3, 70, "MoreAbout",
 CellID->586312960]
}, Open  ]],
Cell[23829, 844, 27, 0, 70, "History"],
Cell[23859, 846, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

