(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     68654,       2671]
NotebookOptionsPosition[     51472,       2091]
NotebookOutlinePosition[     55908,       2210]
CellTagsIndexPosition[     55353,       2195]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integral Transforms and Related Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegralTransformsAndRelatedOperations"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Integral Transforms and Related Operations\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ZTransform" :> 
          Documentation`HelpLookup["paclet:ref/ZTransform"], 
          "InverseLaplaceTransform" :> 
          Documentation`HelpLookup["paclet:ref/InverseLaplaceTransform"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"ZTransform\"\>", 
       2->"\<\"InverseLaplaceTransform\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Discrete Mathematics" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteMathematics"], 
          "Integral Transforms" :> 
          Documentation`HelpLookup["paclet:guide/IntegralTransforms"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Discrete Mathematics\"\>", 
       2->"\<\"Integral Transforms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InverseZTransform", "ObjectName",
 CellID->27800],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["InverseZTransform",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/InverseZTransform"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["z", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the inverse Z transform of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19287]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The inverse Z transform of a function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"F", "(", "z", ")"}], TraditionalForm]], "InlineMath"],
 " is defined to be the contour integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", "\[Pi]", "i"}]], 
    RowBox[{"\[ContourIntegral]", 
     RowBox[{
      RowBox[{"F", "(", "z", ")"}], 
      SuperscriptBox["z", 
       RowBox[{"n", "-", "1"}]], 
      RowBox[{"\[DifferentialD]", "z"}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->20379]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->402736608],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->592435989],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseZTransform", "[", 
  RowBox[{
   RowBox[{"z", "/", 
    RowBox[{"(", 
     RowBox[{"z", "-", "a"}], ")"}]}], ",", "z", ",", "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->624396848],

Cell[BoxData[
 SuperscriptBox["a", "n"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->316890616]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseZTransform", "[", 
  RowBox[{
   RowBox[{"z", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"z", "^", "2"}], "-", 
      RowBox[{"3", "z"}], "+", "1"}], ")"}]}], ",", "z", ",", "n"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->436482074],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"3", "-", 
         SqrtBox["5"]}], ")"}]}], ")"}], "n"]}], "+", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"3", "+", 
        SqrtBox["5"]}], ")"}]}], ")"}], "n"]}], 
  SqrtBox["5"]]], "Output",
 ImageSize->{209, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->221138552]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->577833616],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseZTransform", "[", 
  RowBox[{
   RowBox[{"ArcTan", "[", 
    RowBox[{"1", "/", "z"}], "]"}], ",", "z", ",", "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->376791086],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", "\[Pi]", " ", 
   RowBox[{"KroneckerDelta", "[", "n", "]"}]}], "+", 
  FractionBox[
   RowBox[{"Sin", "[", 
    FractionBox[
     RowBox[{"n", " ", "\[Pi]"}], "2"], "]"}], "n"]}]], "Output",
 ImageSize->{225, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1528934154]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30678],

Cell["Constants lead to impulse sequences:", "ExampleText",
 CellID->704945854],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseZTransform", "[", 
  RowBox[{"1", ",", "z", ",", "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->979169548],

Cell[BoxData[
 RowBox[{"KroneckerDelta", "[", "n", "]"}]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7006276]
}, Open  ]],

Cell["Shifted impulse sequence:", "ExampleText",
 CellID->222538303],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseZTransform", "[", 
  RowBox[{
   RowBox[{"z", "^", 
    RowBox[{"-", "3"}]}], ",", "z", ",", "n"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18788280],

Cell[BoxData[
 RowBox[{"KroneckerDelta", "[", 
  RowBox[{"3", "-", "n"}], "]"}]], "Output",
 ImageSize->{143, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1790363794]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->283603540],

Cell["\<\
Rational transforms yield exponential and trigonometric sequences:\
\>", "ExampleText",
 CellID->226259125],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseZTransform", "[", 
  RowBox[{
   RowBox[{"z", "/", 
    RowBox[{"(", 
     RowBox[{"z", "-", "a"}], ")"}]}], ",", "z", ",", "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1884544],

Cell[BoxData[
 SuperscriptBox["a", "n"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->103423994]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseZTransform", "[", 
  RowBox[{
   RowBox[{"z", "/", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z", "-", "a"}], ")"}], "^", "2"}]}], ",", "z", ",", "n"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->718751205],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["a", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "n"}]], " ", "n"}]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->932796735]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseZTransform", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "3"}], "+", "z"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", "z"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "z"}], ")"}], " ", "z"}], ")"}]}], ",", "z", 
   ",", "n"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->293124369],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "36"]}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "18"}], "+", 
    RowBox[{"9", " ", 
     SuperscriptBox["2", "n"]}], "-", 
    RowBox[{"2", " ", 
     SuperscriptBox["3", "n"]}]}], ")"}], " ", 
  RowBox[{"UnitStep", "[", 
   RowBox[{
    RowBox[{"-", "2"}], "+", "n"}], "]"}]}]], "Output",
 ImageSize->{247, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->884102045]
}, Open  ]],

Cell["\<\
In some cases additional simplification and transformations are needed:\
\>", "ExampleText",
 CellID->152918565],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseZTransform", "[", 
  RowBox[{
   RowBox[{"z", " ", 
    RowBox[{
     RowBox[{"Sin", "[", "w", "]"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"z", "^", "2"}], "-", 
       RowBox[{"2", "z", " ", 
        RowBox[{"Cos", "[", "w", "]"}]}], "+", "1"}], ")"}]}]}], ",", "z", 
   ",", "n"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->34269052],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"Sin", "[", "w", "]"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Cos", "[", "w", "]"}], "-", 
         SqrtBox[
          RowBox[{"-", 
           SuperscriptBox[
            RowBox[{"Sin", "[", "w", "]"}], "2"]}]]}], ")"}], "n"]}], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Cos", "[", "w", "]"}], "+", 
        SqrtBox[
         RowBox[{"-", 
          SuperscriptBox[
           RowBox[{"Sin", "[", "w", "]"}], "2"]}]]}], ")"}], "n"]}], ")"}]}], 
  
  RowBox[{"2", " ", 
   SqrtBox[
    RowBox[{"-", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "w", "]"}], "2"]}]]}]]], "Output",
 ImageSize->{384, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->663716722]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"%", ",", 
   RowBox[{
    RowBox[{"Element", "[", 
     RowBox[{"w", ",", "Reals"}], "]"}], "&&", 
    RowBox[{"Element", "[", 
     RowBox[{"n", ",", "Integers"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->235689019],

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"n", " ", "w"}], "]"}]], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1056884136]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"InverseZTransform", "[", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["\[ExponentialE]", "\[ImaginaryI]"], " ", "z", " ", 
       RowBox[{"(", 
        RowBox[{"4", "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["\[ExponentialE]", "\[ImaginaryI]"], " ", "z"}], "+",
          
         SuperscriptBox["z", "2"], "+", 
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", "\[ImaginaryI]"}]], " ", 
          RowBox[{"(", 
           RowBox[{"4", "+", 
            SuperscriptBox["z", "2"]}], ")"}]}]}], ")"}]}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "z"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", "\[ImaginaryI]"}]], " ", "z"}], "-", 
         RowBox[{
          SuperscriptBox["\[ExponentialE]", "\[ImaginaryI]"], " ", 
          RowBox[{"(", 
           RowBox[{"4", "+", 
            SuperscriptBox["z", "2"]}], ")"}]}]}], ")"}], "2"]], ",", "z", 
     ",", " ", "n"}], "]"}], "//", "ExpToTrig"}], "//", "Simplify"}]], "Input",\

 CellTags->"Ex--22034125732586953448,8",
 CellLabel->"In[6]:=",
 CellID->389565038],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["2", "n"], " ", "n", " ", 
  RowBox[{"Cos", "[", "n", "]"}]}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034125732586953448,8",
 CellLabel->"Out[6]=",
 CellID->1214429415]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->347975477],

Cell["Elementary functions:", "ExampleText",
 CellID->280411919],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseZTransform", "[", 
  RowBox[{
   RowBox[{"E", "^", 
    RowBox[{"(", 
     RowBox[{"1", "/", "z"}], ")"}]}], ",", " ", "z", ",", " ", "n"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->409895383],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"n", "!"}]]], "Output",
 ImageSize->{24, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1230596817]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseZTransform", "[", 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"1", "/", "z"}], "]"}], "]"}], ",", "z", ",", " ", "n"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10683884],

Cell[BoxData[
 FractionBox[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"-", "1"}], ")"}], "n"], 
  RowBox[{"Gamma", "[", 
   RowBox[{"1", "+", 
    RowBox[{"2", " ", "n"}]}], "]"}]]], "Output",
 ImageSize->{94, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->225699062]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseZTransform", "[", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"z", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "+", 
       RowBox[{"z", "^", "2"}]}], "]"}]}], "]"}], ",", "z", ",", "n"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->768419250],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"Cos", "[", 
    FractionBox[
     RowBox[{"n", " ", "\[Pi]"}], "2"], "]"}], " ", 
   RowBox[{"UnitStep", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "n"}], "]"}]}], "n"]], "Output",
 ImageSize->{168, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->868014432]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseZTransform", "[", 
  RowBox[{
   RowBox[{"z", "/", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z", "-", "a"}], ")"}], "^", "p"}]}], ",", "z", ",", "n"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->232432138],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["a", 
    RowBox[{"1", "+", "n", "-", "p"}]], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "+", "n"}], "]"}]}], 
  RowBox[{
   RowBox[{"Gamma", "[", 
    RowBox[{"2", "+", "n", "-", "p"}], "]"}], " ", 
   RowBox[{"Gamma", "[", "p", "]"}]}]]], "Output",
 ImageSize->{163, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->862144553]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseZTransform", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"1", "+", 
     RowBox[{"z", "^", 
      RowBox[{"-", "2"}]}]}], "]"}], ",", "z", ",", "n"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->382399106],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ImaginaryI]", "n"], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "n"}], ")"}]}], "]"}], " ", 
    RowBox[{"KroneckerDelta", "[", 
     RowBox[{"Mod", "[", 
      RowBox[{"n", ",", "2"}], "]"}], "]"}]}], 
   RowBox[{"2", " ", 
    SqrtBox["\[Pi]"], " ", 
    RowBox[{"Gamma", "[", 
     FractionBox[
      RowBox[{"2", "+", "n"}], "2"], "]"}]}]]}]], "Output",
 ImageSize->{318, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->991335962]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->774038213],

Cell["Special functions:", "ExampleText",
 CellID->227365593],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseZTransform", "[", 
  RowBox[{
   RowBox[{"PolyLog", "[", 
    RowBox[{
     RowBox[{"-", "k"}], ",", 
     RowBox[{"c", "/", "z"}]}], "]"}], ",", "z", ",", "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1012532746],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["c", "n"], " ", 
  SuperscriptBox["n", "k"], " ", 
  RowBox[{"UnitStep", "[", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "n"}], "]"}]}]], "Output",
 ImageSize->{141, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1205379908]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseZTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"z", "^", "3"}], " ", 
    RowBox[{"BesselI", "[", 
     RowBox[{"3", ",", 
      RowBox[{"2", "/", "z"}]}], "]"}]}], ",", "z", ",", " ", "n"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->153676862],

Cell[BoxData[
 FractionBox[
  RowBox[{"KroneckerDelta", "[", 
   RowBox[{"Mod", "[", 
    RowBox[{"n", ",", "2"}], "]"}], "]"}], 
  RowBox[{
   RowBox[{"Gamma", "[", 
    FractionBox[
     RowBox[{"2", "+", "n"}], "2"], "]"}], " ", 
   RowBox[{"Gamma", "[", 
    FractionBox[
     RowBox[{"8", "+", "n"}], "2"], "]"}]}]]], "Output",
 ImageSize->{181, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1606871605]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7275],

Cell["Solve a linear difference equation:", "ExampleText",
 CellID->3797937],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "[", 
      RowBox[{"n", "+", "1"}], "]"}], "+", 
     RowBox[{"2", 
      RowBox[{"y", "[", "n", "]"}]}]}], "\[Equal]", "1"}], ",", "n", ",", 
   "z"}], "]"}]], "Input",
 CellTags->"Ex--22034138112425334325,28",
 CellLabel->"In[1]:=",
 CellID->121364303],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"-", "z"}], " ", 
    RowBox[{"y", "[", "0", "]"}]}], "+", 
   RowBox[{"2", " ", 
    RowBox[{"ZTransform", "[", 
     RowBox[{
      RowBox[{"y", "[", "n", "]"}], ",", "n", ",", "z"}], "]"}]}], "+", 
   RowBox[{"z", " ", 
    RowBox[{"ZTransform", "[", 
     RowBox[{
      RowBox[{"y", "[", "n", "]"}], ",", "n", ",", "z"}], "]"}]}]}], 
  "\[Equal]", 
  FractionBox["z", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "z"}]]}]], "Output",
 ImageSize->{448, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034138112425334325,28",
 CellLabel->"Out[1]=",
 CellID->2084204210]
}, Open  ]],

Cell["\<\
Add an initial value equation and solve the algebraic equation for the \
transform:\
\>", "ExampleText",
 CellID->222969517],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"%", ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", "3"}]}], "}"}], ",", 
   RowBox[{"ZTransform", "[", 
    RowBox[{
     RowBox[{"y", "[", "n", "]"}], ",", "n", ",", "z"}], "]"}]}], 
  "]"}]], "Input",
 CellTags->"Ex--22034138112425334325,29",
 CellLabel->"In[2]:=",
 CellID->801988935],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ZTransform", "[", 
     RowBox[{
      RowBox[{"y", "[", "n", "]"}], ",", "n", ",", "z"}], "]"}], "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "z"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["z", "2"]}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "z"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"2", "+", "z"}], ")"}]}]]}], "}"}], "}"}]], "Output",
 ImageSize->{293, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034138112425334325,29",
 CellLabel->"Out[2]=",
 CellID->1614391253]
}, Open  ]],

Cell["Get the solution through inverse transformation:", "ExampleText",
 CellID->304050393],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseZTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ZTransform", "[", 
     RowBox[{
      RowBox[{"y", "[", "n", "]"}], ",", "n", ",", "z"}], "]"}], "/.", 
    RowBox[{"First", "[", "%", "]"}]}], ",", "z", ",", "n"}], "]"}]], "Input",\

 CellTags->"Ex--22034138112425334325,30",
 CellLabel->"In[3]:=",
 CellID->187986390],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "3"], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], "n"], " ", 
     SuperscriptBox["2", 
      RowBox[{"3", "+", "n"}]]}]}], ")"}]}]], "Output",
 ImageSize->{112, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034138112425334325,30",
 CellLabel->"Out[3]=",
 CellID->1765392973]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["RSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RSolve"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->384615724],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "[", 
        RowBox[{"n", "+", "1"}], "]"}], "+", 
       RowBox[{"2", 
        RowBox[{"y", "[", "n", "]"}]}]}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", "3"}]}], "}"}], ",", 
   RowBox[{"y", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->18133952],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "n", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "3"]}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], "n"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], "n"]}], "+", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "2"}], ")"}], "n"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], "n"]}], "-", 
       RowBox[{"9", " ", 
        SuperscriptBox["2", "n"]}]}], ")"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{310, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1325630259]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->171275395],

Cell["Solve a linear difference-summation equation:", "ExampleText",
 CellID->118160315],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"y", "[", 
     RowBox[{"n", "+", "1"}], "]"}], "==", 
    RowBox[{
     RowBox[{"2", 
      RowBox[{"y", "[", "n", "]"}]}], "-", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"2", "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", "r"}], ")"}]}], 
        RowBox[{"y", "[", "r", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"r", ",", "0", ",", "n"}], "}"}]}], "]"}]}]}], ",", "n", ",", 
   "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->186475048],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"-", "z"}], " ", 
    RowBox[{"y", "[", "0", "]"}]}], "+", 
   RowBox[{"z", " ", 
    RowBox[{"ZTransform", "[", 
     RowBox[{
      RowBox[{"y", "[", "n", "]"}], ",", "n", ",", "z"}], "]"}]}]}], 
  "\[Equal]", 
  RowBox[{
   RowBox[{"2", " ", 
    RowBox[{"ZTransform", "[", 
     RowBox[{
      RowBox[{"y", "[", "n", "]"}], ",", "n", ",", "z"}], "]"}]}], "-", 
   FractionBox[
    RowBox[{"z", " ", 
     RowBox[{"ZTransform", "[", 
      RowBox[{
       RowBox[{"y", "[", "n", "]"}], ",", "n", ",", "z"}], "]"}]}], 
    RowBox[{
     RowBox[{"-", "2"}], "+", "z"}]]}]}]], "Output",
 ImageSize->{572, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1872409035]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"%", ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", 
   RowBox[{"ZTransform", "[", 
    RowBox[{
     RowBox[{"y", "[", "n", "]"}], ",", "n", ",", "z"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->254970391],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"ZTransform", "[", 
     RowBox[{
      RowBox[{"y", "[", "n", "]"}], ",", "n", ",", "z"}], "]"}], "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", "z"}], ")"}], " ", "z"}], 
     RowBox[{"4", "-", 
      RowBox[{"3", " ", "z"}], "+", 
      SuperscriptBox["z", "2"]}]]}], "}"}], "}"}]], "Output",
 ImageSize->{263, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->353288107]
}, Open  ]],

Cell["\<\
Use the inverse transform to get a solution to the original problem:\
\>", "ExampleText",
 CellID->95345382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseZTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ZTransform", "[", 
     RowBox[{
      RowBox[{"y", "[", "n", "]"}], ",", "n", ",", "z"}], "]"}], "/.", 
    RowBox[{"First", "[", "%", "]"}]}], ",", "z", ",", "n"}], "]"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->123479445],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "7"], " ", 
  SuperscriptBox["2", 
   RowBox[{
    RowBox[{"-", "1"}], "-", "n"}]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"3", "-", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["7"]}]}], ")"}], "n"], " ", 
     RowBox[{"(", 
      RowBox[{"7", "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox["7"]}]}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"3", "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["7"]}]}], ")"}], "n"], " ", 
     RowBox[{"(", 
      RowBox[{"7", "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox["7"]}]}], ")"}]}]}], ")"}]}]], "Output",
 ImageSize->{367, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2068414041]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["RSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RSolve"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->684234570],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", 
       RowBox[{"n", "+", "1"}], "]"}], "==", 
      RowBox[{
       RowBox[{"2", 
        RowBox[{"y", "[", "n", "]"}]}], "-", 
       RowBox[{"Sum", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"2", "^", 
           RowBox[{"(", 
            RowBox[{"n", "-", "r"}], ")"}]}], 
          RowBox[{"y", "[", "r", "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"r", ",", "0", ",", "n"}], "}"}]}], "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", 
   RowBox[{"y", "[", "n", "]"}], ",", "n"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->394304764],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "n", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox["1", "7"], " ", 
     SuperscriptBox["2", 
      RowBox[{
       RowBox[{"-", "1"}], "-", "n"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"3", "-", 
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["7"]}]}], ")"}], "n"], " ", 
        RowBox[{"(", 
         RowBox[{"7", "-", 
          RowBox[{"\[ImaginaryI]", " ", 
           SqrtBox["7"]}]}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"3", "+", 
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["7"]}]}], ")"}], "n"], " ", 
        RowBox[{"(", 
         RowBox[{"7", "+", 
          RowBox[{"\[ImaginaryI]", " ", 
           SqrtBox["7"]}]}], ")"}]}]}], ")"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{439, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->369509451]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4370514],

Cell["A discrete system transfer function:", "ExampleText",
 CellID->518826324],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"h", "=", 
  RowBox[{"1", "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"z", "-", 
       RowBox[{"1", "/", "2"}]}], ")"}], 
     RowBox[{"(", 
      RowBox[{"z", "-", "2"}], ")"}]}], ")"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->54909429],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "z"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "2"]}], "+", "z"}], ")"}]}]]], "Output",
 ImageSize->{111, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1970119480]
}, Open  ]],

Cell["Impulse response:", "ExampleText",
 CellID->54347968],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{"ZTransform", "[", 
   RowBox[{
    RowBox[{"DiscreteDelta", "[", "n", "]"}], ",", "n", ",", "z"}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->221966527],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1895230914]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseZTransform", "[", 
  RowBox[{
   RowBox[{"h", " ", "u"}], ",", "z", ",", "n"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->153199285],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "3"], " ", 
  SuperscriptBox["2", 
   RowBox[{"-", "n"}]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "4"}], "+", 
    SuperscriptBox["4", "n"]}], ")"}], " ", 
  RowBox[{"UnitStep", "[", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "n"}], "]"}]}]], "Output",
 ImageSize->{200, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1668519294]
}, Open  ]],

Cell["Step response:", "ExampleText",
 CellID->289235704],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{"ZTransform", "[", 
   RowBox[{
    RowBox[{"UnitStep", "[", "n", "]"}], ",", "n", ",", "z"}], 
   "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->542785599],

Cell[BoxData[
 FractionBox["z", 
  RowBox[{
   RowBox[{"-", "1"}], "+", "z"}]]], "Output",
 ImageSize->{43, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->962311732]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseZTransform", "[", 
  RowBox[{
   RowBox[{"h", " ", "u"}], ",", "z", ",", "n"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->266411996],

Cell[BoxData[
 RowBox[{
  FractionBox["2", "3"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "3"}], "+", 
    SuperscriptBox["2", 
     RowBox[{"1", "-", "n"}]], "+", 
    SuperscriptBox["2", "n"]}], ")"}]}]], "Output",
 ImageSize->{108, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->873934167]
}, Open  ]],

Cell["Ramp response:", "ExampleText",
 CellID->143280841],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", "=", 
  RowBox[{"ZTransform", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"UnitStep", "[", "n", "]"}], "n"}], ",", "n", ",", "z"}], 
   "]"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->163324656],

Cell[BoxData[
 FractionBox["z", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "z"}], ")"}], "2"]]], "Output",
 ImageSize->{62, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->1570882936]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseZTransform", "[", 
  RowBox[{
   RowBox[{"h", " ", "u"}], ",", "z", ",", "n"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->526588735],

Cell[BoxData[
 RowBox[{
  FractionBox["2", "3"], " ", 
  RowBox[{"(", 
   RowBox[{"3", "-", 
    SuperscriptBox["2", 
     RowBox[{"2", "-", "n"}]], "+", 
    SuperscriptBox["2", "n"], "-", 
    RowBox[{"3", " ", "n"}]}], ")"}]}]], "Output",
 ImageSize->{129, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->665549134]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18508],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ZTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ZTransform"]], "InlineFormula"],
 " is the inverse operator:"
}], "ExampleText",
 CellID->213738623],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZTransform", "[", 
  RowBox[{
   RowBox[{"InverseZTransform", "[", 
    RowBox[{
     RowBox[{"F", "[", "z", "]"}], ",", "z", ",", "n"}], "]"}], ",", "n", ",",
    "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->148348612],

Cell[BoxData[
 RowBox[{"F", "[", "z", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1789461562]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseZTransform", "[", 
  RowBox[{
   RowBox[{"ZTransform", "[", 
    RowBox[{
     RowBox[{"f", "[", "n", "]"}], ",", "n", ",", "z"}], "]"}], ",", "z", ",",
    "n"}], "]"}]], "Input",
 CellTags->"Ex--22034138112425334325,15",
 CellLabel->"In[2]:=",
 CellID->87244332],

Cell[BoxData[
 RowBox[{"f", "[", "n", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034138112425334325,15",
 CellLabel->"Out[2]=",
 CellID->2119479946]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "^", "n"}], " ", "n"}], ",", "n", ",", "z"}], "]"}]], "Input",\

 CellTags->"Ex--22034138112425334325,17",
 CellLabel->"In[3]:=",
 CellID->10323952],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "z"}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "z"}], ")"}], "2"]]], "Output",
 ImageSize->{62, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034138112425334325,17",
 CellLabel->"Out[3]=",
 CellID->1788199633]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseZTransform", "[", 
  RowBox[{"%", ",", "z", ",", "n"}], "]"}]], "Input",
 CellTags->"Ex--22034138112425334325,18",
 CellLabel->"In[4]:=",
 CellID->628545852],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["2", "n"], " ", "n"}]], "Output",
 ImageSize->{27, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034138112425334325,18",
 CellLabel->"Out[4]=",
 CellID->237592066]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->84095718],

Cell["Linearity:", "ExampleText",
 CellID->166713152],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseZTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", 
     RowBox[{"F", "[", "z", "]"}]}], "+", 
    RowBox[{"b", " ", 
     RowBox[{"G", "[", "z", "]"}]}]}], ",", " ", "z", ",", " ", "n"}], 
  "]"}]], "Input",
 CellTags->"Ex--22034138112425334325,19",
 CellLabel->"In[1]:=",
 CellID->347181749],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", 
   RowBox[{"InverseZTransform", "[", 
    RowBox[{
     RowBox[{"F", "[", "z", "]"}], ",", "z", ",", "n"}], "]"}]}], "+", 
  RowBox[{"b", " ", 
   RowBox[{"InverseZTransform", "[", 
    RowBox[{
     RowBox[{"G", "[", "z", "]"}], ",", "z", ",", "n"}], "]"}]}]}]], "Output",\

 ImageSize->{432, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034138112425334325,19",
 CellLabel->"Out[1]=",
 CellID->1037753489]
}, Open  ]],

Cell["Shifting:", "ExampleText",
 CellID->161387210],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseZTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"z", "^", 
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}]}], " ", 
    RowBox[{"ZTransform", "[", 
     RowBox[{
      RowBox[{"f", "[", "n", "]"}], ",", "n", ",", "z"}], "]"}]}], ",", "z", 
   ",", "n"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->760524999],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"-", "1"}], "+", "n"}], "]"}]], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1808192336]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseZTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"z", "^", 
     RowBox[{"(", 
      RowBox[{"-", "2"}], ")"}]}], " ", 
    RowBox[{"ZTransform", "[", 
     RowBox[{
      RowBox[{"f", "[", "n", "]"}], ",", "n", ",", "z"}], "]"}]}], ",", "z", 
   ",", "n"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->160313680],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"-", "2"}], "+", "n"}], "]"}]], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1247502455]
}, Open  ]],

Cell["Derivatives:", "ExampleText",
 CellID->410428224],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseZTransform", "[", " ", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"ZTransform", "[", 
      RowBox[{
       RowBox[{"f", "[", "n", "]"}], ",", "n", ",", "z"}], "]"}], ",", "z"}], 
    "]"}], ",", "z", ",", "n"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->122133652],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "n"}], ")"}]}], " ", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "n"}], "]"}]}], "-", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"-", "1"}], "]"}], " ", 
   RowBox[{"KroneckerDelta", "[", "n", "]"}]}]}]], "Output",
 ImageSize->{289, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->890915524]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseZTransform", "[", " ", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"ZTransform", "[", 
      RowBox[{
       RowBox[{"f", "[", "n", "]"}], ",", "n", ",", "z"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "2"}], "}"}]}], "]"}], ",", "z", ",", "n"}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->33214361],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "n"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "n"}], ")"}], " ", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "n"}], "]"}]}], "-", 
  RowBox[{"2", " ", 
   RowBox[{"f", "[", 
    RowBox[{"-", "2"}], "]"}], " ", 
   RowBox[{"KroneckerDelta", "[", "n", "]"}]}]}]], "Output",
 ImageSize->{343, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1361224984]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->141045244],

Cell["Initial value property:", "ExampleText",
 CellID->257312360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseZTransform", "[", 
  RowBox[{
   RowBox[{"z", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "-", 
        RowBox[{"1", "/", "2"}]}], ")"}], 
      RowBox[{"(", 
       RowBox[{"z", "-", 
        RowBox[{"1", "/", "3"}]}], ")"}]}], ")"}]}], ",", "z", ",", "n"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->195765601],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["6", 
   RowBox[{"1", "-", "n"}]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["2", "n"]}], "+", 
    SuperscriptBox["3", "n"]}], ")"}]}]], "Output",
 ImageSize->{89, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->965014597]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Limit", "[", 
   RowBox[{"%", ",", 
    RowBox[{"n", "\[Rule]", "0"}]}], "]"}], "\[Equal]", 
  RowBox[{"Limit", "[", 
   RowBox[{
    RowBox[{"z", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"z", "-", 
         RowBox[{"1", "/", "2"}]}], ")"}], 
       RowBox[{"(", 
        RowBox[{"z", "-", 
         RowBox[{"1", "/", "3"}]}], ")"}]}], ")"}]}], ",", 
    RowBox[{"z", "\[Rule]", "Infinity"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->610848703],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1203829635]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->315551876],

Cell["Final value property:", "ExampleText",
 CellID->628458910],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseZTransform", "[", 
  RowBox[{
   RowBox[{"z", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "-", 
        RowBox[{"1", "/", "2"}]}], ")"}], 
      RowBox[{"(", 
       RowBox[{"z", "-", 
        RowBox[{"1", "/", "3"}]}], ")"}]}], ")"}]}], ",", "z", ",", "n"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->482810108],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["6", 
   RowBox[{"1", "-", "n"}]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["2", "n"]}], "+", 
    SuperscriptBox["3", "n"]}], ")"}]}]], "Output",
 ImageSize->{89, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1321237058]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Limit", "[", 
   RowBox[{"%", ",", 
    RowBox[{"n", "\[Rule]", "Infinity"}]}], "]"}], "\[Equal]", 
  RowBox[{"Limit", "[", 
   RowBox[{
    RowBox[{"z", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"z", "-", 
         RowBox[{"1", "/", "2"}]}], ")"}], 
       RowBox[{"(", 
        RowBox[{"z", "-", 
         RowBox[{"1", "/", "3"}]}], ")"}]}], ")"}]}], ",", 
    RowBox[{"z", "\[Rule]", "0"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32701609],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1050323826]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->51225179],

Cell[TextData[{
 "Find the ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " series coefficient:"
}], "ExampleText",
 CellID->51032862],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseZTransform", "[", 
  RowBox[{
   RowBox[{"E", "^", 
    RowBox[{"(", 
     RowBox[{"1", "/", "z"}], ")"}]}], ",", " ", "z", ",", "n"}], 
  "]"}]], "Input",
 CellTags->"Ex--22034138112425334325,22",
 CellLabel->"In[1]:=",
 CellID->197148709],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"n", "!"}]]], "Output",
 ImageSize->{24, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034138112425334325,22",
 CellLabel->"Out[1]=",
 CellID->476965242]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SeriesCoefficient", "[", 
  RowBox[{
   RowBox[{"E", "^", "z"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "n"}], "}"}]}], "]"}]], "Input",
 CellTags->"Ex--22034138112425334325,23",
 CellLabel->"In[2]:=",
 CellID->710918272],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"n", "!"}]]], "Output",
 ImageSize->{24, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"Ex--22034138112425334325,23",
 CellLabel->"Out[2]=",
 CellID->1945851690]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2151],

Cell["The inverse transform may not exist:", "ExampleText",
 CellID->393177065],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseZTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "z", "]"}], ",", "z", ",", "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->136675837],

Cell[BoxData[
 RowBox[{"InverseZTransform", "[", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", "z"], ",", "z", ",", "n"}], 
  "]"}]], "Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2048377314]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19865],

Cell["Inverse transform for a hypergeometric function:", "ExampleText",
 CellID->320629407],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseZTransform", "[", 
  RowBox[{
   RowBox[{"HypergeometricPFQ", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"2", "/", "3"}], ",", "1", ",", 
       RowBox[{"4", "/", "3"}]}], "}"}], ",", 
     RowBox[{"1", "/", "z"}]}], "]"}], ",", "z", ",", "n"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->148893045],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "\[Pi]"}], 
  RowBox[{"3", " ", 
   SqrtBox["3"], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{
     FractionBox["2", "3"], "+", "n"}], "]"}], " ", 
   SuperscriptBox[
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "n"}], "]"}], "2"], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{
     FractionBox["4", "3"], "+", "n"}], "]"}]}]]], "Output",
 ImageSize->{290, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->767171341]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ZTransform", "[", 
  RowBox[{"%", ",", "n", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->148059233],

Cell[BoxData[
 RowBox[{"HypergeometricPFQ", "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["2", "3"], ",", "1", ",", 
     FractionBox["4", "3"]}], "}"}], ",", 
   FractionBox["1", "z"]}], "]"}]], "Output",
 ImageSize->{251, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->356911599]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23744],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ZTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ZTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseLaplaceTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseLaplaceTransform"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10245]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29624],

Cell[TextData[ButtonBox["Integral Transforms and Related Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegralTransformsAndRelatedOperations"]], "Tutorials",
 CellID->32082]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->311294565],

Cell[TextData[ButtonBox["Discrete Mathematics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "MoreAbout",
 CellID->314887556],

Cell[TextData[ButtonBox["Integral Transforms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegralTransforms"]], "MoreAbout",
 CellID->795962662]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InverseZTransform - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 51, 10.3247452}", "context" -> "System`", 
    "keywords" -> {
     "generating function", "impulse response", "inverse Z-transform", 
      "inverse ztransform", "ramp response", "series coefficient", 
      "step response", "transfer function", "ztransform"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "InverseZTransform[expr, z, n] gives the inverse Z transform of expr. ", 
    "synonyms" -> {"inverse transform"}, "title" -> "InverseZTransform", 
    "type" -> "Symbol", "uri" -> "ref/InverseZTransform"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4569, 150, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->402736608]},
 "Ex--22034125732586953448,8"->{
  Cell[12737, 498, 1255, 36, 70, "Input",
   CellTags->"Ex--22034125732586953448,8",
   CellID->389565038],
  Cell[13995, 536, 286, 9, 36, "Output",
   CellTags->"Ex--22034125732586953448,8",
   CellID->1214429415]},
 "Ex--22034138112425334325,28"->{
  Cell[19934, 788, 352, 12, 70, "Input",
   CellTags->"Ex--22034138112425334325,28",
   CellID->121364303],
  Cell[20289, 802, 668, 23, 49, "Output",
   CellTags->"Ex--22034138112425334325,28",
   CellID->2084204210]},
 "Ex--22034138112425334325,29"->{
  Cell[21131, 836, 387, 13, 70, "Input",
   CellTags->"Ex--22034138112425334325,29",
   CellID->801988935],
  Cell[21521, 851, 699, 24, 56, "Output",
   CellTags->"Ex--22034138112425334325,29",
   CellID->1614391253]},
 "Ex--22034138112425334325,30"->{
  Cell[22351, 883, 356, 11, 70, "Input",
   CellTags->"Ex--22034138112425334325,30",
   CellID->187986390],
  Cell[22710, 896, 448, 16, 51, "Output",
   CellTags->"Ex--22034138112425334325,30",
   CellID->1765392973]},
 "Ex--22034138112425334325,15"->{
  Cell[35938, 1445, 295, 9, 70, "Input",
   CellTags->"Ex--22034138112425334325,15",
   CellID->87244332],
  Cell[36236, 1456, 228, 7, 36, "Output",
   CellTags->"Ex--22034138112425334325,15",
   CellID->2119479946]},
 "Ex--22034138112425334325,17"->{
  Cell[36501, 1468, 231, 8, 70, "Input",
   CellTags->"Ex--22034138112425334325,17",
   CellID->10323952],
  Cell[36735, 1478, 338, 12, 54, "Output",
   CellTags->"Ex--22034138112425334325,17",
   CellID->1788199633]},
 "Ex--22034138112425334325,18"->{
  Cell[37110, 1495, 188, 5, 70, "Input",
   CellTags->"Ex--22034138112425334325,18",
   CellID->628545852],
  Cell[37301, 1502, 246, 8, 36, "Output",
   CellTags->"Ex--22034138112425334325,18",
   CellID->237592066]},
 "Ex--22034138112425334325,19"->{
  Cell[37767, 1523, 337, 11, 70, "Input",
   CellTags->"Ex--22034138112425334325,19",
   CellID->347181749],
  Cell[38107, 1536, 494, 16, 36, "Output",
   CellTags->"Ex--22034138112425334325,19",
   CellID->1037753489]},
 "Ex--22034138112425334325,22"->{
  Cell[45564, 1851, 271, 9, 70, "Input",
   CellTags->"Ex--22034138112425334325,22",
   CellID->197148709],
  Cell[45838, 1862, 238, 8, 51, "Output",
   CellTags->"Ex--22034138112425334325,22",
   CellID->476965242]},
 "Ex--22034138112425334325,23"->{
  Cell[46113, 1875, 266, 8, 70, "Input",
   CellTags->"Ex--22034138112425334325,23",
   CellID->710918272],
  Cell[46382, 1885, 239, 8, 51, "Output",
   CellTags->"Ex--22034138112425334325,23",
   CellID->1945851690]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 52684, 2118},
 {"Ex--22034125732586953448,8", 52837, 2122},
 {"Ex--22034138112425334325,28", 53088, 2129},
 {"Ex--22034138112425334325,29", 53341, 2136},
 {"Ex--22034138112425334325,30", 53594, 2143},
 {"Ex--22034138112425334325,15", 53847, 2150},
 {"Ex--22034138112425334325,17", 54099, 2157},
 {"Ex--22034138112425334325,18", 54352, 2164},
 {"Ex--22034138112425334325,19", 54604, 2171},
 {"Ex--22034138112425334325,22", 54859, 2178},
 {"Ex--22034138112425334325,23", 55111, 2185}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2115, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2738, 79, 55, 1, 70, "ObjectName",
 CellID->27800],
Cell[2796, 82, 664, 21, 70, "Usage",
 CellID->19287]
}, Open  ]],
Cell[CellGroupData[{
Cell[3497, 108, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3975, 125, 557, 20, 70, "Notes",
 CellID->20379]
}, Closed]],
Cell[CellGroupData[{
Cell[4569, 150, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->402736608],
Cell[CellGroupData[{
Cell[4954, 164, 148, 5, 70, "ExampleSection",
 CellID->592435989],
Cell[CellGroupData[{
Cell[5127, 173, 221, 7, 28, "Input",
 CellID->624396848],
Cell[5351, 182, 181, 6, 36, "Output",
 CellID->316890616]
}, Open  ]],
Cell[CellGroupData[{
Cell[5569, 193, 283, 10, 28, "Input",
 CellID->436482074],
Cell[5855, 205, 588, 23, 65, "Output",
 CellID->221138552]
}, Open  ]],
Cell[6458, 231, 125, 3, 70, "ExampleDelimiter",
 CellID->577833616],
Cell[CellGroupData[{
Cell[6608, 238, 205, 6, 28, "Input",
 CellID->376791086],
Cell[6816, 246, 408, 14, 59, "Output",
 CellID->1528934154]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7273, 266, 216, 7, 70, "ExampleSection",
 CellID->30678],
Cell[7492, 275, 79, 1, 70, "ExampleText",
 CellID->704945854],
Cell[CellGroupData[{
Cell[7596, 280, 146, 4, 70, "Input",
 CellID->979169548],
Cell[7745, 286, 197, 6, 36, "Output",
 CellID->7006276]
}, Open  ]],
Cell[7957, 295, 68, 1, 70, "ExampleText",
 CellID->222538303],
Cell[CellGroupData[{
Cell[8050, 300, 189, 6, 70, "Input",
 CellID->18788280],
Cell[8242, 308, 223, 7, 36, "Output",
 CellID->1790363794]
}, Open  ]],
Cell[8480, 318, 125, 3, 70, "ExampleDelimiter",
 CellID->283603540],
Cell[8608, 323, 117, 3, 70, "ExampleText",
 CellID->226259125],
Cell[CellGroupData[{
Cell[8750, 330, 219, 7, 70, "Input",
 CellID->1884544],
Cell[8972, 339, 181, 6, 36, "Output",
 CellID->103423994]
}, Open  ]],
Cell[CellGroupData[{
Cell[9190, 350, 251, 9, 70, "Input",
 CellID->718751205],
Cell[9444, 361, 248, 9, 36, "Output",
 CellID->932796735]
}, Open  ]],
Cell[CellGroupData[{
Cell[9729, 375, 482, 17, 70, "Input",
 CellID->293124369],
Cell[10214, 394, 493, 18, 51, "Output",
 CellID->884102045]
}, Open  ]],
Cell[10722, 415, 122, 3, 70, "ExampleText",
 CellID->152918565],
Cell[CellGroupData[{
Cell[10869, 422, 391, 13, 70, "Input",
 CellID->34269052],
Cell[11263, 437, 895, 33, 80, "Output",
 CellID->663716722]
}, Open  ]],
Cell[CellGroupData[{
Cell[12195, 475, 291, 9, 70, "Input",
 CellID->235689019],
Cell[12489, 486, 211, 7, 36, "Output",
 CellID->1056884136]
}, Open  ]],
Cell[CellGroupData[{
Cell[12737, 498, 1255, 36, 70, "Input",
 CellTags->"Ex--22034125732586953448,8",
 CellID->389565038],
Cell[13995, 536, 286, 9, 36, "Output",
 CellTags->"Ex--22034125732586953448,8",
 CellID->1214429415]
}, Open  ]],
Cell[14296, 548, 125, 3, 70, "ExampleDelimiter",
 CellID->347975477],
Cell[14424, 553, 64, 1, 70, "ExampleText",
 CellID->280411919],
Cell[CellGroupData[{
Cell[14513, 558, 234, 8, 70, "Input",
 CellID->409895383],
Cell[14750, 568, 197, 7, 51, "Output",
 CellID->1230596817]
}, Open  ]],
Cell[CellGroupData[{
Cell[14984, 580, 243, 8, 70, "Input",
 CellID->10683884],
Cell[15230, 590, 327, 12, 54, "Output",
 CellID->225699062]
}, Open  ]],
Cell[CellGroupData[{
Cell[15594, 607, 294, 10, 70, "Input",
 CellID->768419250],
Cell[15891, 619, 368, 13, 59, "Output",
 CellID->868014432]
}, Open  ]],
Cell[CellGroupData[{
Cell[16296, 637, 251, 9, 70, "Input",
 CellID->232432138],
Cell[16550, 648, 444, 15, 56, "Output",
 CellID->862144553]
}, Open  ]],
Cell[CellGroupData[{
Cell[17031, 668, 251, 8, 70, "Input",
 CellID->382399106],
Cell[17285, 678, 673, 23, 70, "Output",
 CellID->991335962]
}, Open  ]],
Cell[17973, 704, 125, 3, 70, "ExampleDelimiter",
 CellID->774038213],
Cell[18101, 709, 61, 1, 70, "ExampleText",
 CellID->227365593],
Cell[CellGroupData[{
Cell[18187, 714, 254, 8, 70, "Input",
 CellID->1012532746],
Cell[18444, 724, 319, 11, 36, "Output",
 CellID->1205379908]
}, Open  ]],
Cell[CellGroupData[{
Cell[18800, 740, 292, 10, 70, "Input",
 CellID->153676862],
Cell[19095, 752, 464, 16, 60, "Output",
 CellID->1606871605]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19608, 774, 222, 7, 70, "ExampleSection",
 CellID->7275],
Cell[19833, 783, 76, 1, 70, "ExampleText",
 CellID->3797937],
Cell[CellGroupData[{
Cell[19934, 788, 352, 12, 70, "Input",
 CellTags->"Ex--22034138112425334325,28",
 CellID->121364303],
Cell[20289, 802, 668, 23, 49, "Output",
 CellTags->"Ex--22034138112425334325,28",
 CellID->2084204210]
}, Open  ]],
Cell[20972, 828, 134, 4, 70, "ExampleText",
 CellID->222969517],
Cell[CellGroupData[{
Cell[21131, 836, 387, 13, 70, "Input",
 CellTags->"Ex--22034138112425334325,29",
 CellID->801988935],
Cell[21521, 851, 699, 24, 56, "Output",
 CellTags->"Ex--22034138112425334325,29",
 CellID->1614391253]
}, Open  ]],
Cell[22235, 878, 91, 1, 70, "ExampleText",
 CellID->304050393],
Cell[CellGroupData[{
Cell[22351, 883, 356, 11, 70, "Input",
 CellTags->"Ex--22034138112425334325,30",
 CellID->187986390],
Cell[22710, 896, 448, 16, 51, "Output",
 CellTags->"Ex--22034138112425334325,30",
 CellID->1765392973]
}, Open  ]],
Cell[23173, 915, 183, 8, 70, "ExampleText",
 CellID->384615724],
Cell[CellGroupData[{
Cell[23381, 927, 456, 15, 70, "Input",
 CellID->18133952],
Cell[23840, 944, 853, 30, 51, "Output",
 CellID->1325630259]
}, Open  ]],
Cell[24708, 977, 125, 3, 70, "ExampleDelimiter",
 CellID->171275395],
Cell[24836, 982, 88, 1, 70, "ExampleText",
 CellID->118160315],
Cell[CellGroupData[{
Cell[24949, 987, 576, 20, 70, "Input",
 CellID->186475048],
Cell[25528, 1009, 777, 27, 51, "Output",
 CellID->1872409035]
}, Open  ]],
Cell[CellGroupData[{
Cell[26342, 1041, 345, 12, 70, "Input",
 CellID->254970391],
Cell[26690, 1055, 560, 19, 53, "Output",
 CellID->353288107]
}, Open  ]],
Cell[27265, 1077, 118, 3, 70, "ExampleText",
 CellID->95345382],
Cell[CellGroupData[{
Cell[27408, 1084, 314, 10, 70, "Input",
 CellID->123479445],
Cell[27725, 1096, 884, 32, 51, "Output",
 CellID->2068414041]
}, Open  ]],
Cell[28624, 1131, 183, 8, 70, "ExampleText",
 CellID->684234570],
Cell[CellGroupData[{
Cell[28832, 1143, 741, 24, 70, "Input",
 CellID->394304764],
Cell[29576, 1169, 1069, 36, 51, "Output",
 CellID->369509451]
}, Open  ]],
Cell[30660, 1208, 123, 3, 70, "ExampleDelimiter",
 CellID->4370514],
Cell[30786, 1213, 79, 1, 70, "ExampleText",
 CellID->518826324],
Cell[CellGroupData[{
Cell[30890, 1218, 292, 11, 70, "Input",
 CellID->54909429],
Cell[31185, 1231, 368, 14, 60, "Output",
 CellID->1970119480]
}, Open  ]],
Cell[31568, 1248, 59, 1, 70, "ExampleText",
 CellID->54347968],
Cell[CellGroupData[{
Cell[31652, 1253, 209, 7, 70, "Input",
 CellID->221966527],
Cell[31864, 1262, 159, 5, 36, "Output",
 CellID->1895230914]
}, Open  ]],
Cell[CellGroupData[{
Cell[32060, 1272, 170, 5, 70, "Input",
 CellID->153199285],
Cell[32233, 1279, 438, 16, 51, "Output",
 CellID->1668519294]
}, Open  ]],
Cell[32686, 1298, 57, 1, 70, "ExampleText",
 CellID->289235704],
Cell[CellGroupData[{
Cell[32768, 1303, 204, 7, 70, "Input",
 CellID->542785599],
Cell[32975, 1312, 220, 8, 49, "Output",
 CellID->962311732]
}, Open  ]],
Cell[CellGroupData[{
Cell[33232, 1325, 170, 5, 70, "Input",
 CellID->266411996],
Cell[33405, 1332, 357, 13, 51, "Output",
 CellID->873934167]
}, Open  ]],
Cell[33777, 1348, 57, 1, 70, "ExampleText",
 CellID->143280841],
Cell[CellGroupData[{
Cell[33859, 1353, 225, 8, 70, "Input",
 CellID->163324656],
Cell[34087, 1363, 273, 10, 52, "Output",
 CellID->1570882936]
}, Open  ]],
Cell[CellGroupData[{
Cell[34397, 1378, 170, 5, 70, "Input",
 CellID->526588735],
Cell[34570, 1385, 372, 13, 51, "Output",
 CellID->665549134]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[34991, 1404, 233, 7, 70, "ExampleSection",
 CellID->18508],
Cell[35227, 1413, 206, 7, 70, "ExampleText",
 CellID->213738623],
Cell[CellGroupData[{
Cell[35458, 1424, 254, 8, 70, "Input",
 CellID->148348612],
Cell[35715, 1434, 186, 6, 36, "Output",
 CellID->1789461562]
}, Open  ]],
Cell[CellGroupData[{
Cell[35938, 1445, 295, 9, 70, "Input",
 CellTags->"Ex--22034138112425334325,15",
 CellID->87244332],
Cell[36236, 1456, 228, 7, 36, "Output",
 CellTags->"Ex--22034138112425334325,15",
 CellID->2119479946]
}, Open  ]],
Cell[CellGroupData[{
Cell[36501, 1468, 231, 8, 70, "Input",
 CellTags->"Ex--22034138112425334325,17",
 CellID->10323952],
Cell[36735, 1478, 338, 12, 54, "Output",
 CellTags->"Ex--22034138112425334325,17",
 CellID->1788199633]
}, Open  ]],
Cell[CellGroupData[{
Cell[37110, 1495, 188, 5, 70, "Input",
 CellTags->"Ex--22034138112425334325,18",
 CellID->628545852],
Cell[37301, 1502, 246, 8, 36, "Output",
 CellTags->"Ex--22034138112425334325,18",
 CellID->237592066]
}, Open  ]],
Cell[37562, 1513, 124, 3, 70, "ExampleDelimiter",
 CellID->84095718],
Cell[37689, 1518, 53, 1, 70, "ExampleText",
 CellID->166713152],
Cell[CellGroupData[{
Cell[37767, 1523, 337, 11, 70, "Input",
 CellTags->"Ex--22034138112425334325,19",
 CellID->347181749],
Cell[38107, 1536, 494, 16, 36, "Output",
 CellTags->"Ex--22034138112425334325,19",
 CellID->1037753489]
}, Open  ]],
Cell[38616, 1555, 52, 1, 70, "ExampleText",
 CellID->161387210],
Cell[CellGroupData[{
Cell[38693, 1560, 354, 12, 70, "Input",
 CellID->760524999],
Cell[39050, 1574, 228, 8, 36, "Output",
 CellID->1808192336]
}, Open  ]],
Cell[CellGroupData[{
Cell[39315, 1587, 354, 12, 70, "Input",
 CellID->160313680],
Cell[39672, 1601, 228, 8, 36, "Output",
 CellID->1247502455]
}, Open  ]],
Cell[39915, 1612, 55, 1, 70, "ExampleText",
 CellID->410428224],
Cell[CellGroupData[{
Cell[39995, 1617, 320, 10, 70, "Input",
 CellID->122133652],
Cell[40318, 1629, 485, 18, 36, "Output",
 CellID->890915524]
}, Open  ]],
Cell[CellGroupData[{
Cell[40840, 1652, 370, 12, 70, "Input",
 CellID->33214361],
Cell[41213, 1666, 554, 20, 36, "Output",
 CellID->1361224984]
}, Open  ]],
Cell[41782, 1689, 125, 3, 70, "ExampleDelimiter",
 CellID->141045244],
Cell[41910, 1694, 66, 1, 70, "ExampleText",
 CellID->257312360],
Cell[CellGroupData[{
Cell[42001, 1699, 387, 14, 70, "Input",
 CellID->195765601],
Cell[42391, 1715, 348, 13, 36, "Output",
 CellID->965014597]
}, Open  ]],
Cell[CellGroupData[{
Cell[42776, 1733, 527, 18, 70, "Input",
 CellID->610848703],
Cell[43306, 1753, 162, 5, 36, "Output",
 CellID->1203829635]
}, Open  ]],
Cell[43483, 1761, 125, 3, 70, "ExampleDelimiter",
 CellID->315551876],
Cell[43611, 1766, 64, 1, 70, "ExampleText",
 CellID->628458910],
Cell[CellGroupData[{
Cell[43700, 1771, 387, 14, 70, "Input",
 CellID->482810108],
Cell[44090, 1787, 349, 13, 36, "Output",
 CellID->1321237058]
}, Open  ]],
Cell[CellGroupData[{
Cell[44476, 1805, 526, 18, 70, "Input",
 CellID->32701609],
Cell[45005, 1825, 162, 5, 36, "Output",
 CellID->1050323826]
}, Open  ]],
Cell[45182, 1833, 124, 3, 70, "ExampleDelimiter",
 CellID->51225179],
Cell[45309, 1838, 230, 9, 70, "ExampleText",
 CellID->51032862],
Cell[CellGroupData[{
Cell[45564, 1851, 271, 9, 70, "Input",
 CellTags->"Ex--22034138112425334325,22",
 CellID->197148709],
Cell[45838, 1862, 238, 8, 51, "Output",
 CellTags->"Ex--22034138112425334325,22",
 CellID->476965242]
}, Open  ]],
Cell[CellGroupData[{
Cell[46113, 1875, 266, 8, 70, "Input",
 CellTags->"Ex--22034138112425334325,23",
 CellID->710918272],
Cell[46382, 1885, 239, 8, 51, "Output",
 CellTags->"Ex--22034138112425334325,23",
 CellID->1945851690]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[46670, 1899, 225, 7, 70, "ExampleSection",
 CellID->2151],
Cell[46898, 1908, 79, 1, 70, "ExampleText",
 CellID->393177065],
Cell[CellGroupData[{
Cell[47002, 1913, 177, 5, 70, "Input",
 CellID->136675837],
Cell[47182, 1920, 278, 9, 36, "Output",
 CellID->2048377314]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[47509, 1935, 224, 7, 70, "ExampleSection",
 CellID->19865],
Cell[47736, 1944, 91, 1, 70, "ExampleText",
 CellID->320629407],
Cell[CellGroupData[{
Cell[47852, 1949, 392, 12, 70, "Input",
 CellID->148893045],
Cell[48247, 1963, 521, 18, 62, "Output",
 CellID->767171341]
}, Open  ]],
Cell[CellGroupData[{
Cell[48805, 1986, 139, 4, 70, "Input",
 CellID->148059233],
Cell[48947, 1992, 383, 13, 51, "Output",
 CellID->356911599]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[49391, 2012, 311, 9, 70, "SeeAlsoSection",
 CellID->23744],
Cell[49705, 2023, 485, 17, 70, "SeeAlso",
 CellID->10245]
}, Open  ]],
Cell[CellGroupData[{
Cell[50227, 2045, 314, 9, 70, "TutorialsSection",
 CellID->29624],
Cell[50544, 2056, 194, 4, 70, "Tutorials",
 CellID->32082]
}, Open  ]],
Cell[CellGroupData[{
Cell[50775, 2065, 319, 9, 70, "MoreAboutSection",
 CellID->311294565],
Cell[51097, 2076, 151, 3, 70, "MoreAbout",
 CellID->314887556],
Cell[51251, 2081, 149, 3, 70, "MoreAbout",
 CellID->795962662]
}, Open  ]],
Cell[51415, 2087, 27, 0, 70, "History"],
Cell[51445, 2089, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

