(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17805,        615]
NotebookOptionsPosition[     14125,        490]
NotebookOutlinePosition[     15389,        526]
CellTagsIndexPosition[     15304,        521]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"String\[Hyphen]Oriented Output Formats" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StringOrientedOutputFormats"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"String\[Hyphen]Oriented Output Formats\"\>"}, "\<\"tutorials\"\
\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Spacer" :> Documentation`HelpLookup["paclet:ref/Spacer"], 
          "HoldForm" :> Documentation`HelpLookup["paclet:ref/HoldForm"], 
          "ShowContents" :> 
          Documentation`HelpLookup["paclet:ref/ShowContents"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Spacer\"\>", 2->"\<\"HoldForm\"\>", 
       3->"\<\"ShowContents\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematical Typesetting" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalTypesetting"], 
          "Textual Elements in Notebooks" :> 
          Documentation`HelpLookup["paclet:guide/TextualElementsInNotebooks"],
           "New in 6.0: Formatting & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60FormattingAndStyling"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Mathematical Typesetting\"\>", 
       2->"\<\"Textual Elements in Notebooks\"\>", 
       3->"\<\"New in 6.0: Formatting & Styling\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Invisible", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Invisible",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Invisible"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]displays as space that is the same size as the \
formatted version of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->785]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Invisible",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Invisible"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " spans both the horizontal and vertical dimensions of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23893],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Invisible",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Invisible"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " has the same baseline alignment as ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18080],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Invisible",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Invisible"], "[", "\"\<M\>\"", "]"}]], 
  "InlineFormula"],
 " gives space that is one em wide in the current font. "
}], "Notes",
 CellID->32742]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->159501406],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->293198368],

Cell["\<\
Display a blank space the same size as the formatted form of a given \
expression:\
\>", "ExampleText",
 CellID->397610484],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{"Invisible", "[", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{
        RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
       RowBox[{"\[Pi]", "/", "2"}]}], "}"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->801539716],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAw+AOxoQQDkP0fyAJj
////QTQzBwcHAwR4ATEjkMsIlQGpAgMGLyABMmZUZlRmVGZUZqBkJCQkGCAA
XFYBuRAZaFnGCAAtN0Os\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{79, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2997688]
}, Open  ]],

Cell["Here is the expression in visible form:", "ExampleText",
 CellID->825112979],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{
       RowBox[{"-", "\[Pi]"}], "/", "2"}], ",", 
      RowBox[{"\[Pi]", "/", "2"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->106834265],

Cell[BoxData[
 FrameBox[
  RowBox[{
   SubsuperscriptBox["\[Integral]", 
    RowBox[{"-", 
     FractionBox["\[Pi]", "2"]}], 
    FractionBox["\[Pi]", "2"]], 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], 
    RowBox[{"\[DifferentialD]", "x"}]}]}],
  StripOnInput->False]], "Output",
 ImageSize->{83, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->491309768]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->293129727],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Invisible",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Invisible"]], "InlineFormula"],
 " objects as column-width regulators in a grid:"
}], "ExampleText",
 CellID->3367364],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Invisible", "[", "\"\<xxxx\>\"", "]"}], ",", 
       RowBox[{"Invisible", "[", "\"\<xxxxxxxxxxxxxxxxxxxx\>\"", "]"}]}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "\"\<one\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "\"\<two\>\""}], "}"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->451990286],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAw7AZiYwkGIPs/kAXG
u///B9JQkgEMmEHiYMCgDCKQ+BOBBOMgUMULJFiBXEE01fZAAsRlRhIHaWWB
ijvhNI2BFc6H6kE32w5EcKOpwiQZmLCa5ojVZj40O4Sw2YnEZ0Yymzwb+dFM
xOpLqtoogGYiOh+fjQizSbER3U/ofrb9D0k9DKxQY8AApghkE1XSChI/AKtZ
fFCb0GOdNvln6ORuysoAO2iowuIRnPnhsQwSZSE7d4BSDrFpkwlNr/MwtZGV
BqHJBLORBaEatVQHMe3JshU5fTAxwIyFAPz1BCGTsadTPqg9wkSpHs3lo6oG
UhUk/UDagwyMAH+eAv0=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{187, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->767068423]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15962],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Spacer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Spacer"]], "InlineFormula"],
 " to display a blank space with the size specified in printer's points:"
}], "ExampleText",
 CellID->269402137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{"Spacer", "[", 
   RowBox[{"{", 
    RowBox[{"70", ",", "50"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->690690949],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwBACxnQQDkP0fyALj
gP//QTQzBwcHAwT4ADEjhMsMUgEGDD5AghGiYFR0VHRUdFR0mItKSEhAWJAS
EcyFlpaMAPifMBM=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{80, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->239026024]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->451],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Spacer",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Spacer"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HoldForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HoldForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShowContents",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ShowContents"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21976]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7251],

Cell[TextData[ButtonBox["String\[Hyphen]Oriented Output Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringOrientedOutputFormats"]], "Tutorials",
 CellID->140352686]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->608780],

Cell[TextData[ButtonBox["Mathematical Typesetting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalTypesetting"]], "MoreAbout",
 CellID->200576170],

Cell[TextData[ButtonBox["Textual Elements in Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TextualElementsInNotebooks"]], "MoreAbout",
 CellID->219886745],

Cell[TextData[ButtonBox["New in 6.0: Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60FormattingAndStyling"]], "MoreAbout",
 CellID->32208246]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Invisible - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 51, 10.8091326}", "context" -> "System`", 
    "keywords" -> {"invisible content", "size of boxes"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Invisible[expr] displays as space that is the same size as the formatted \
version of expr.", "synonyms" -> {"\\phantom"}, "title" -> "Invisible", 
    "type" -> "Symbol", "uri" -> "ref/Invisible"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6658, 205, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->159501406]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15161, 514}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2371, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2994, 83, 1574, 37, 70, "ObjectNameGrid"],
Cell[4571, 122, 594, 19, 70, "Usage",
 CellID->785]
}, Open  ]],
Cell[CellGroupData[{
Cell[5202, 146, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5680, 163, 344, 12, 70, "Notes",
 CellID->23893],
Cell[6027, 177, 326, 12, 70, "Notes",
 CellID->18080],
Cell[6356, 191, 265, 9, 70, "Notes",
 CellID->32742]
}, Closed]],
Cell[CellGroupData[{
Cell[6658, 205, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->159501406],
Cell[CellGroupData[{
Cell[7043, 219, 148, 5, 70, "ExampleSection",
 CellID->293198368],
Cell[7194, 226, 133, 4, 70, "ExampleText",
 CellID->397610484],
Cell[CellGroupData[{
Cell[7352, 234, 382, 12, 28, "Input",
 CellID->801539716],
Cell[7737, 248, 351, 10, 70, "Output",
 Evaluatable->False,
 CellID->2997688]
}, Open  ]],
Cell[8103, 261, 82, 1, 70, "ExampleText",
 CellID->825112979],
Cell[CellGroupData[{
Cell[8210, 266, 338, 11, 70, "Input",
 CellID->106834265],
Cell[8551, 279, 413, 15, 70, "Output",
 CellID->491309768]
}, Open  ]],
Cell[8979, 297, 125, 3, 70, "ExampleDelimiter",
 CellID->293129727],
Cell[9107, 302, 232, 8, 70, "ExampleText",
 CellID->3367364],
Cell[CellGroupData[{
Cell[9364, 314, 524, 16, 47, "Input",
 CellID->451990286],
Cell[9891, 332, 598, 14, 72, "Output",
 Evaluatable->False,
 CellID->767068423]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10538, 352, 233, 7, 70, "ExampleSection",
 CellID->15962],
Cell[10774, 361, 252, 8, 70, "ExampleText",
 CellID->269402137],
Cell[CellGroupData[{
Cell[11051, 373, 186, 6, 70, "Input",
 CellID->690690949],
Cell[11240, 381, 349, 10, 70, "Output",
 Evaluatable->False,
 CellID->239026024]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11650, 398, 309, 9, 70, "SeeAlsoSection",
 CellID->451],
Cell[11962, 409, 700, 26, 70, "SeeAlso",
 CellID->21976]
}, Open  ]],
Cell[CellGroupData[{
Cell[12699, 440, 313, 9, 70, "TutorialsSection",
 CellID->7251],
Cell[13015, 451, 180, 3, 70, "Tutorials",
 CellID->140352686]
}, Open  ]],
Cell[CellGroupData[{
Cell[13232, 459, 316, 9, 70, "MoreAboutSection",
 CellID->608780],
Cell[13551, 470, 159, 3, 70, "MoreAbout",
 CellID->200576170],
Cell[13713, 475, 167, 3, 70, "MoreAbout",
 CellID->219886745],
Cell[13883, 480, 170, 3, 70, "MoreAbout",
 CellID->32208246]
}, Open  ]],
Cell[14068, 486, 27, 0, 70, "History"],
Cell[14098, 488, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

