(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     31440,       1179]
NotebookOptionsPosition[     24489,        940]
NotebookOutlinePosition[     25920,        980]
CellTagsIndexPosition[     25835,        975]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Root Isolation" :> 
          Documentation`HelpLookup["paclet:tutorial/RootIsolation"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Root Isolation\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RootIntervals" :> 
          Documentation`HelpLookup["paclet:ref/RootIntervals"], "FindRoot" :> 
          Documentation`HelpLookup["paclet:ref/FindRoot"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"RootIntervals\"\>", 
       2->"\<\"FindRoot\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Numbers" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicNumbers"], 
          "Polynomial Equations" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialEquations"], 
          "New in 6.0: Symbolic Computation" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60AlgebraicComputing"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Algebraic Numbers\"\>", 
       2->"\<\"Polynomial Equations\"\>", 
       3->"\<\"New in 6.0: Symbolic Computation\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["IsolatingInterval", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["IsolatingInterval",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/IsolatingInterval"], "[", 
       StyleBox["a", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a rational isolating interval for the algebraic \
number ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["IsolatingInterval",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/IsolatingInterval"], "[", 
       RowBox[{
        StyleBox["a", "TI"], ",", 
        StyleBox["dx", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives an isolating interval of width at most ",
     Cell[BoxData[
      StyleBox["dx", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->23277]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["IsolatingInterval",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IsolatingInterval"], "[", 
   StyleBox["a", "TI"], "]"}]], "InlineFormula"],
 " gives an interval that does not contain any other root with the same \
minimal polynomial as ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->475911994],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " is complex, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["IsolatingInterval",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IsolatingInterval"], "[", 
   StyleBox["a", "TI"], "]"}]], "InlineFormula"],
 " gives a pair of Gaussian rationals defining an isolating rectangle in the \
complex plane."
}], "Notes",
 CellID->354229847]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->556161],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->115639433],

Cell[TextData[{
 "Find an isolating interval of ",
 Cell[BoxData[
  FormBox[
   SqrtBox["2"], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->12044793],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IsolatingInterval", "[", 
  RowBox[{"Sqrt", "[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->943423331],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["45", "32"], ",", 
   FractionBox["91", "64"]}], "}"}]], "Output",
 ImageSize->{66, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->255815188]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->138221],

Cell[TextData[{
 "Find an isolating interval of ",
 Cell[BoxData[
  FormBox[
   SqrtBox["2"], TraditionalForm]], "InlineMath"],
 "with width less than ",
 Cell[BoxData[
  FormBox[
   FractionBox["1", 
    SuperscriptBox["10", "10"]], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->20791071],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b"}], "}"}], "=", 
  RowBox[{"IsolatingInterval", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", "2", "]"}], ",", 
    RowBox[{"10", "^", 
     RowBox[{"-", "10"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->146886124],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["3109888511975", "2199023255552"], ",", 
   FractionBox["388736063997", "274877906944"]}], "}"}]], "Output",
 ImageSize->{228, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->347487100]
}, Open  ]],

Cell[TextData[{
 "Check that ",
 Cell[BoxData[
  FormBox[
   SqrtBox["2"], TraditionalForm]], "InlineMath"],
 " belongs to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["[", "TI"], 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"]}], 
   StyleBox["]", "TI"]}]], "InlineFormula"],
 " and the width of ",
 Cell[BoxData[
  RowBox[{
   StyleBox["[", "TI"], 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"]}], 
   StyleBox["]", "TI"]}]], "InlineFormula"],
 " is less than ",
 Cell[BoxData[
  FormBox[
   FractionBox["1", 
    SuperscriptBox["10", "10"]], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->177135146],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "\[LessEqual]", 
   RowBox[{"Sqrt", "[", "2", "]"}], "\[LessEqual]", "b"}], "&&", 
  RowBox[{
   RowBox[{"b", "-", "a"}], "<", 
   RowBox[{"10", "^", 
    RowBox[{"-", "10"}]}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->46255647],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->888663828]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18536021],

Cell["Isolating interval of a rational number:", "ExampleText",
 CellID->358052694],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IsolatingInterval", "[", 
  RowBox[{"1", "/", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->249122375],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "2"], ",", 
   FractionBox["1", "2"]}], "}"}]], "Output",
 ImageSize->{52, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->130770535]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->277336511],

Cell["Isolating interval of a Gaussian rational number:", "ExampleText",
 CellID->123719745],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IsolatingInterval", "[", 
  RowBox[{
   RowBox[{"1", "/", "2"}], "+", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->447816229],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["31", "64"], "+", 
    FractionBox[
     RowBox[{"127", " ", "\[ImaginaryI]"}], "128"]}], ",", 
   RowBox[{
    FractionBox["33", "64"], "+", 
    FractionBox[
     RowBox[{"129", " ", "\[ImaginaryI]"}], "128"]}]}], "}"}]], "Output",
 ImageSize->{163, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->191655965]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14910783],

Cell["Isolating interval of a radical:", "ExampleText",
 CellID->164458901],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IsolatingInterval", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"-", "2"}], ")"}], "^", 
   RowBox[{"(", 
    RowBox[{"2", "/", "3"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->389684121],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "4"}], ",", 
   RowBox[{"4", "+", 
    RowBox[{"4", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",
 ImageSize->{82, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->493953906]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->549672638],

Cell[TextData[{
 "Isolating interval of a ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " object:"
}], "ExampleText",
 CellID->382484753],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IsolatingInterval", "[", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"#", "^", "5"}], "-", 
      RowBox[{"2", "#"}], "+", "11"}], "&"}], ",", "1"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->300732663],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "2"}], ",", "0"}], "}"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->297029890]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->156243858],

Cell[TextData[{
 "Isolating interval of an ",
 Cell[BoxData[
  ButtonBox["AlgebraicNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFormula"],
 " object:"
}], "ExampleText",
 CellID->184632028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IsolatingInterval", "[", 
  RowBox[{"AlgebraicNumber", "[", 
   RowBox[{
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"#", "^", "5"}], "-", 
        RowBox[{"2", "#"}], "+", "11"}], "&"}], ",", "1"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->310325035],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"25", ",", "47"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->274042400]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->287407028],

Cell["\<\
Isolating interval of an algebraic combination of algebraic numbers:\
\>", "ExampleText",
 CellID->197559304],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IsolatingInterval", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], "+", 
   RowBox[{
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"#", "^", "5"}], "-", 
         RowBox[{"2", "#"}], "+", "11"}], "&"}], ",", "1"}], "]"}], "^", 
     "2"}], "/", "7"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->39815699],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->454469884]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->173118799],

Cell[TextData[{
 "Isolating interval with width less than ",
 Cell[BoxData[
  FormBox[
   FractionBox["1", 
    SuperscriptBox["2", "100"]], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->360440591],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IsolatingInterval", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sqrt", "[", "2", "]"}], "+", 
    RowBox[{
     RowBox[{
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"#", "^", "5"}], "-", 
          RowBox[{"2", "#"}], "+", "11"}], "&"}], ",", "1"}], "]"}], "^", 
      "2"}], "/", "7"}]}], ",", 
   RowBox[{"2", "^", 
    RowBox[{"-", "100"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->161958079],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["593713098975679202781859784061185", 
    "324518553658426726783156020576256"], ",", 
   FractionBox["296856549487839601390929892030593", 
    "162259276829213363391578010288128"]}], "}"}]], "Output",
 ImageSize->{542, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->420774854]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->73675547],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["RootIntervals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootIntervals"]], "InlineFormula"],
 " to find isolating intervals for all real roots of a polynomial:"
}], "ExampleText",
 CellID->431972761],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootIntervals", "[", 
  RowBox[{
   RowBox[{"x", "^", "5"}], "-", 
   RowBox[{"2", "x"}], "+", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->51659408],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "1", "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{291, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->807566002]
}, Open  ]],

Cell["\<\
Find isolating intervals for all complex roots of a polynomial:\
\>", "ExampleText",
 CellID->301194504],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootIntervals", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "5"}], "-", 
    RowBox[{"2", "x"}], "+", "1"}], ",", "Complexes"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->588319224],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWM1uwjAMDu1Kt7LR0hNHnmDaXmI77SEqNAkOaBPj/bumJKx8ODiGMloJ
JEqd2I5/PjsJH8Vm8bkqNst5MXtfF9+L5fxn9va1robCgVJBppRKp6p6L6u3
+ms/efVV6k4/w904S2dApwz/COgHoXzSsvzLmfIToJ+F8UN9OI/+SePRdX6k
Q/3YPgVSOgtBRWI2QjOOqEsYfvRCyv8q5M/NOKKRig4lz1WZS64rfFx+g/IU
VGjsReqwp8XVQ5ORhzx6Q8kNHesgfU94Rcmdqm9k7JuYX60nVodx8/XfpR/l
rD7kHzJ2SP2jUNFm3Psq1161qGhH1zq2a+sKjp2zqJOq9+Cobp894j/4EtLK
lByNG7LK1IQ8Tn4WHM9BDDoib3vbiuWl9PRFjq/FQCilazciOua4pHKLuRwT
2hy4Rtw06CdmXipvfUK82nGMfFOftjenvDphPbTbd/0hkzNcH+cxPtJ4d52f
w/SgjqN0V8KTYm0V21/xVkrvP9xdr+15rEu8HXCIxy7C6ecqlEM8l2HOf46W
yneN/zLnsEeK7inite2BQbL+bZ5wtT2ZGef2FqsnI/To19ih/4bgayAYd466
h/cUwVzPtqeHtnu1a50boq+BaPpu3OeziOSuO/Xy028FOmb0uuf6fG0sdgPr
UimN9dBEPyTyTHU6y0/t5djJgnJ/L+f4k3L/X008tY4ddrr0pIw+rjegXirq
kjh0hc/nP4m/As2FlBr8AjLIg+M=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{528, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->437763163]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->337273315],

Cell["Find an isolating interval of a real algebraic number:", "ExampleText",
 CellID->55108812],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"alg", "=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"2", "+", 
     RowBox[{"Sqrt", "[", "3", "]"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b"}], "}"}], "=", 
  RowBox[{"IsolatingInterval", "[", "alg", "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->636373492],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "4"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->388602294]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["MinimalPolynomial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MinimalPolynomial"]], "InlineFormula"],
 " to find the minimal polynomial of the algebraic number:"
}], "ExampleText",
 CellID->258501544],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"poly", "=", 
  RowBox[{"MinimalPolynomial", "[", 
   RowBox[{"alg", ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->238983065],

Cell[BoxData[
 RowBox[{"1", "-", 
  RowBox[{"4", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  SuperscriptBox["x", "4"]}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->38648435]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " to find an approximation of the root of ",
 Cell[BoxData[
  StyleBox["poly", "TI"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  RowBox[{
   StyleBox["[", "TI"], 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"]}], 
   StyleBox["]", "TI"]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->188149963],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"poly", "\[Equal]", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "a", ",", "b"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", "\"\<Brent\>\""}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->648572898],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", "1.931851652578137`"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->46517255]
}, Open  ]],

Cell[TextData[{
 "Compute an approximation of ",
 Cell[BoxData[
  StyleBox["alg", "TI"]], "InlineFormula"],
 " directly:"
}], "ExampleText",
 CellID->323290115],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "alg", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->20869165],

Cell[BoxData["1.9318516525781366`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->398141690]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18382],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RootIntervals",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RootIntervals"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindRoot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindRoot"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20169]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6125],

Cell[TextData[ButtonBox["Root Isolation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RootIsolation"]], "Tutorials",
 CellID->11798]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->456227325],

Cell[TextData[ButtonBox["Algebraic Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicNumbers"]], "MoreAbout",
 CellID->171661009],

Cell[TextData[ButtonBox["Polynomial Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialEquations"]], "MoreAbout",
 CellID->17447842],

Cell[TextData[ButtonBox["New in 6.0: Symbolic Computation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60AlgebraicComputing"]], "MoreAbout",
 CellID->295535063]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"IsolatingInterval - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 51, 11.1528914}", "context" -> "System`", 
    "keywords" -> {
     "algebraic number isolating interval", "polynomial root isolation", 
      "root isolation"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "IsolatingInterval[a] gives a rational isolating interval for the \
algebraic number a. IsolatingInterval[a, dx] gives an isolating interval of \
width at most dx.", "synonyms" -> {"isolating interval"}, "title" -> 
    "IsolatingInterval", "type" -> "Symbol", "uri" -> 
    "ref/IsolatingInterval"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6784, 208, 357, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->556161]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 25695, 968}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2159, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2782, 80, 1582, 37, 70, "ObjectNameGrid"],
Cell[4367, 119, 1051, 33, 70, "Usage",
 CellID->23277]
}, Open  ]],
Cell[CellGroupData[{
Cell[5455, 157, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5933, 174, 397, 13, 70, "Notes",
 CellID->475911994],
Cell[6333, 189, 414, 14, 70, "Notes",
 CellID->354229847]
}, Closed]],
Cell[CellGroupData[{
Cell[6784, 208, 357, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->556161],
Cell[CellGroupData[{
Cell[7166, 222, 148, 5, 70, "ExampleSection",
 CellID->115639433],
Cell[7317, 229, 170, 7, 70, "ExampleText",
 CellID->12044793],
Cell[CellGroupData[{
Cell[7512, 240, 144, 4, 28, "Input",
 CellID->943423331],
Cell[7659, 246, 251, 9, 51, "Output",
 CellID->255815188]
}, Open  ]],
Cell[7925, 258, 122, 3, 70, "ExampleDelimiter",
 CellID->138221],
Cell[8050, 263, 310, 12, 70, "ExampleText",
 CellID->20791071],
Cell[CellGroupData[{
Cell[8385, 279, 288, 10, 70, "Input",
 CellID->146886124],
Cell[8676, 291, 294, 9, 51, "Output",
 CellID->347487100]
}, Open  ]],
Cell[8985, 303, 659, 28, 70, "ExampleText",
 CellID->177135146],
Cell[CellGroupData[{
Cell[9669, 335, 272, 9, 70, "Input",
 CellID->46255647],
Cell[9944, 346, 161, 5, 36, "Output",
 CellID->888663828]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10154, 357, 219, 7, 70, "ExampleSection",
 CellID->18536021],
Cell[10376, 366, 83, 1, 70, "ExampleText",
 CellID->358052694],
Cell[CellGroupData[{
Cell[10484, 371, 136, 4, 70, "Input",
 CellID->249122375],
Cell[10623, 377, 247, 9, 51, "Output",
 CellID->130770535]
}, Open  ]],
Cell[10885, 389, 125, 3, 70, "ExampleDelimiter",
 CellID->277336511],
Cell[11013, 394, 92, 1, 70, "ExampleText",
 CellID->123719745],
Cell[CellGroupData[{
Cell[11130, 399, 160, 5, 70, "Input",
 CellID->447816229],
Cell[11293, 406, 432, 15, 51, "Output",
 CellID->191655965]
}, Open  ]],
Cell[11740, 424, 124, 3, 70, "ExampleDelimiter",
 CellID->14910783],
Cell[11867, 429, 75, 1, 70, "ExampleText",
 CellID->164458901],
Cell[CellGroupData[{
Cell[11967, 434, 229, 8, 70, "Input",
 CellID->389684121],
Cell[12199, 444, 283, 10, 36, "Output",
 CellID->493953906]
}, Open  ]],
Cell[12497, 457, 125, 3, 70, "ExampleDelimiter",
 CellID->549672638],
Cell[12625, 462, 206, 8, 70, "ExampleText",
 CellID->382484753],
Cell[CellGroupData[{
Cell[12856, 474, 277, 10, 70, "Input",
 CellID->300732663],
Cell[13136, 486, 222, 8, 36, "Output",
 CellID->297029890]
}, Open  ]],
Cell[13373, 497, 125, 3, 70, "ExampleDelimiter",
 CellID->156243858],
Cell[13501, 502, 229, 8, 70, "ExampleText",
 CellID->184632028],
Cell[CellGroupData[{
Cell[13755, 514, 436, 14, 70, "Input",
 CellID->310325035],
Cell[14194, 530, 205, 7, 36, "Output",
 CellID->274042400]
}, Open  ]],
Cell[14414, 540, 125, 3, 70, "ExampleDelimiter",
 CellID->287407028],
Cell[14542, 545, 119, 3, 70, "ExampleText",
 CellID->197559304],
Cell[CellGroupData[{
Cell[14686, 552, 401, 14, 70, "Input",
 CellID->39815699],
Cell[15090, 568, 203, 7, 36, "Output",
 CellID->454469884]
}, Open  ]],
Cell[15308, 578, 125, 3, 70, "ExampleDelimiter",
 CellID->173118799],
Cell[15436, 583, 218, 8, 70, "ExampleText",
 CellID->360440591],
Cell[CellGroupData[{
Cell[15679, 595, 482, 17, 70, "Input",
 CellID->161958079],
Cell[16164, 614, 386, 11, 51, "Output",
 CellID->420774854]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16599, 631, 236, 7, 70, "ExampleSection",
 CellID->73675547],
Cell[16838, 640, 260, 8, 70, "ExampleText",
 CellID->431972761],
Cell[CellGroupData[{
Cell[17123, 652, 184, 6, 70, "Input",
 CellID->51659408],
Cell[17310, 660, 582, 21, 36, "Output",
 CellID->807566002]
}, Open  ]],
Cell[17907, 684, 114, 3, 70, "ExampleText",
 CellID->301194504],
Cell[CellGroupData[{
Cell[18046, 691, 219, 7, 70, "Input",
 CellID->588319224],
Cell[18268, 700, 972, 20, 70, "Output",
 Evaluatable->False,
 CellID->437763163]
}, Open  ]],
Cell[19255, 723, 125, 3, 70, "ExampleDelimiter",
 CellID->337273315],
Cell[19383, 728, 96, 1, 70, "ExampleText",
 CellID->55108812],
Cell[CellGroupData[{
Cell[19504, 733, 331, 11, 70, "Input",
 CellID->636373492],
Cell[19838, 746, 203, 7, 36, "Output",
 CellID->388602294]
}, Open  ]],
Cell[20056, 756, 260, 8, 70, "ExampleText",
 CellID->258501544],
Cell[CellGroupData[{
Cell[20341, 768, 165, 5, 70, "Input",
 CellID->238983065],
Cell[20509, 775, 261, 9, 36, "Output",
 CellID->38648435]
}, Open  ]],
Cell[20785, 787, 469, 19, 70, "ExampleText",
 CellID->188149963],
Cell[CellGroupData[{
Cell[21279, 810, 277, 8, 70, "Input",
 CellID->648572898],
Cell[21559, 820, 225, 7, 36, "Output",
 CellID->46517255]
}, Open  ]],
Cell[21799, 830, 160, 6, 70, "ExampleText",
 CellID->323290115],
Cell[CellGroupData[{
Cell[21984, 840, 98, 3, 70, "Input",
 CellID->20869165],
Cell[22085, 845, 176, 5, 36, "Output",
 CellID->398141690]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22322, 857, 311, 9, 70, "SeeAlsoSection",
 CellID->18382],
Cell[22636, 868, 461, 17, 70, "SeeAlso",
 CellID->20169]
}, Open  ]],
Cell[CellGroupData[{
Cell[23134, 890, 313, 9, 70, "TutorialsSection",
 CellID->6125],
Cell[23450, 901, 138, 3, 70, "Tutorials",
 CellID->11798]
}, Open  ]],
Cell[CellGroupData[{
Cell[23625, 909, 319, 9, 70, "MoreAboutSection",
 CellID->456227325],
Cell[23947, 920, 145, 3, 70, "MoreAbout",
 CellID->171661009],
Cell[24095, 925, 150, 3, 70, "MoreAbout",
 CellID->17447842],
Cell[24248, 930, 169, 3, 70, "MoreAbout",
 CellID->295535063]
}, Open  ]],
Cell[24432, 936, 27, 0, 70, "History"],
Cell[24462, 938, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

