(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    134723,       3572]
NotebookOptionsPosition[    122682,       3149]
NotebookOutlinePosition[    123996,       3187]
CellTagsIndexPosition[    123909,       3182]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals and Elliptic Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals and Elliptic Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"InverseJacobiCN" :> 
          Documentation`HelpLookup["paclet:ref/InverseJacobiCN"], "JacobiCS" :> 
          Documentation`HelpLookup["paclet:ref/JacobiCS"], "JacobiCD" :> 
          Documentation`HelpLookup["paclet:ref/JacobiCD"], "JacobiSC" :> 
          Documentation`HelpLookup["paclet:ref/JacobiSC"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"InverseJacobiCN\"\>", 
       2->"\<\"JacobiCS\"\>", 3->"\<\"JacobiCD\"\>", 
       4->"\<\"JacobiSC\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Functions" :> 
          Documentation`HelpLookup["paclet:guide/EllipticFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Elliptic Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["JacobiCN", "ObjectName",
 CellID->31448],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["JacobiCN",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/JacobiCN"]], "InlineFormula"],
     Cell[BoxData[
      RowBox[{"[", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Jacobi elliptic function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"cn", "(", 
        RowBox[{"u", "|", "m"}], ")"}], TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18764]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"cn", "(", 
     RowBox[{"u", "|", "m"}], ")"}], "=", 
    RowBox[{"cos", "(", "\[Phi]", ")"}]}], TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Phi]", "=", 
    RowBox[{"am", "(", 
     RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->294558602],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"cn", "(", 
    RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " is a doubly periodic function in ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " with periods ",
 Cell[BoxData[
  FormBox[
   RowBox[{"4", " ", 
    RowBox[{"K", "(", "m", ")"}]}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"4", " ", "\[ImaginaryI]", " ", 
    RowBox[{"K", "(", 
     RowBox[{"1", "-", "m"}], ")"}]}], TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox["K", TraditionalForm]], "InlineMath"],
 " is the elliptic integral ",
 Cell[BoxData[
  ButtonBox["EllipticK",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticK"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->17328219],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiCN",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiCN"]], "InlineFormula"],
 " is a meromorphic function in both arguments."
}], "Notes",
 CellID->8656038],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["JacobiCN",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiCN"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->9797447],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiCN",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiCN"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiCN",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiCN"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->389420242],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->73357939],

Cell["Evaluate numerically:", "ExampleText",
 CellID->814676922],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiCN", "[", 
  RowBox[{"2.5", ",", "0.3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27188654],

Cell[BoxData[
 RowBox[{"-", "0.6260319784808547`"}]], "Output",
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->245118267]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->191905672],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"JacobiCN", "[", 
    RowBox[{"x", ",", 
     RowBox[{"1", "/", "3"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12000150],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->461333708]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->390091798],

Cell["Series expansions about the origin:", "ExampleText",
 CellID->38477304],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"JacobiCN", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "7"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->200709323],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "-", 
   FractionBox[
    SuperscriptBox["z", "2"], "2"], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox["1", "24"], "+", 
      FractionBox["m", "6"]}], ")"}], " ", 
    SuperscriptBox["z", "4"]}], "+", 
   RowBox[{
    FractionBox["1", "720"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "-", 
      RowBox[{"44", " ", "m"}], "-", 
      RowBox[{"16", " ", 
       SuperscriptBox["m", "2"]}]}], ")"}], " ", 
    SuperscriptBox["z", "6"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "8"],
    SeriesData[$CellContext`z, 0, {}, 0, 8, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {1, 0, 
    Rational[-1, 2], 0, Rational[1, 24] + Rational[1, 6] $CellContext`m, 0, 
    Rational[1, 720] (-1 - 44 $CellContext`m - 16 $CellContext`m^2)}, 0, 8, 
   1],
  Editable->False]], "Output",
 ImageSize->{335, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->465919806]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"JacobiCN", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->260356113],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"Cos", "[", "z", "]"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       FractionBox["1", "4"], " ", "z", " ", 
       RowBox[{"Sin", "[", "z", "]"}]}], "-", 
      RowBox[{
       FractionBox["1", "8"], " ", 
       RowBox[{"Sin", "[", "z", "]"}], " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "z"}], "]"}]}]}], ")"}], " ", "m"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "m", "]"}], "2"],
    SeriesData[$CellContext`m, 0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`m, 0, {
    Cos[$CellContext`z], Rational[1, 4] $CellContext`z Sin[$CellContext`z] + 
    Rational[-1, 8] Sin[$CellContext`z] Sin[2 $CellContext`z]}, 0, 2, 1],
  Editable->False]], "Output",
 ImageSize->{319, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->597965661]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32127],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->257841689],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiCN", "[", 
  RowBox[{
   RowBox[{"2.5", "+", "I"}], ",", 
   RowBox[{"1", "-", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->325910105],

Cell[BoxData[
 RowBox[{"1.2122395261486343`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.034229286370217604`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->330130693]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25415347],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->856906711],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"JacobiCN", "[", 
    RowBox[{"2", ",", 
     RowBox[{"1", "/", "3"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->69210409],

Cell[BoxData[
 RowBox[{"-", 
  "0.2163783690674577417482595796091624424227197242440160233166042919246`50."}\
]], "Output",
 ImageSize->{376, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->577803752]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->200525529],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->372977787],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiCN", "[", 
  RowBox[{"2", ",", "0.333333333333333333333333333333333333333333"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2714330],

Cell[BoxData[
 RowBox[{"-", 
  "0.2163783690674577417482595796091624424227197242440160233172`40.\
53273729480376"}]], "Output",
 ImageSize->{313, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->88897454]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->182528140],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiCN",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiCN"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->747487832],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiCN", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u1", ",", "u2"}], "}"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->536864854],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiCN", "[", 
    RowBox[{"u1", ",", "m"}], "]"}], ",", 
   RowBox[{"JacobiCN", "[", 
    RowBox[{"u2", ",", "m"}], "]"}]}], "}"}]], "Output",
 ImageSize->{234, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28615096]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->259414736],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellID->18087730],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiCN", "[", 
    RowBox[{"z", ",", "0"}], "]"}], ",", 
   RowBox[{"JacobiCN", "[", 
    RowBox[{"z", ",", "1"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->365032203],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Cos", "[", "z", "]"}], ",", 
   RowBox[{"Sech", "[", "z", "]"}]}], "}"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->73416409]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiCN", "[", 
    RowBox[{"0", ",", "m"}], "]"}], ",", 
   RowBox[{"JacobiCN", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"EllipticK", "[", "m", "]"}], "/", "2"}], ",", "m"}], "]"}], 
   ",", 
   RowBox[{"JacobiCN", "[", 
    RowBox[{
     RowBox[{"EllipticK", "[", "m", "]"}], ",", "m"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->175336906],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", "m"}], ")"}], 
     RowBox[{"1", "/", "4"}]], 
    SqrtBox[
     RowBox[{"1", "+", 
      SqrtBox[
       RowBox[{"1", "-", "m"}]]}]]], ",", "0"}], "}"}]], "Output",
 ImageSize->{141, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->70631779]
}, Open  ]],

Cell["\<\
Parity transformations and periodicity relations are automatically applied:\
\>", "ExampleText",
 CellID->336727663],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiCN", "[", 
  RowBox[{
   RowBox[{"-", "u"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->614178488],

Cell[BoxData[
 RowBox[{"JacobiCN", "[", 
  RowBox[{"u", ",", "m"}], "]"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->50207533]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiCN", "[", 
  RowBox[{
   RowBox[{"u", "+", 
    RowBox[{"4", " ", 
     RowBox[{"EllipticK", "[", "m", "]"}]}], "+", 
    RowBox[{"4", "I", " ", 
     RowBox[{"EllipticK", "[", 
      RowBox[{"1", "-", "m"}], "]"}]}]}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->674473773],

Cell[BoxData[
 RowBox[{"JacobiCN", "[", 
  RowBox[{"u", ",", "m"}], "]"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->578596852]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->215688415],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->178560258],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"JacobiCN", "[", 
   RowBox[{"z", ",", "m"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->292152639],

Cell[BoxData[
 FormBox[
  RowBox[{"cn", "(", 
   RowBox[{"z", "\[VerticalSeparator]", "m"}], ")"}], 
  TraditionalForm]], "Output",
 ImageSize->{47, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->79574470]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30795],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiCN",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiCN"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText",
 CellID->541124796],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiCN", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcTanh", "[", "x", "]"}], "+", 
    RowBox[{
     RowBox[{"O", "[", "x", "]"}], "^", "8"}]}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->271512446],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "-", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["7", "24"]}], "+", 
      FractionBox["m", "6"]}], ")"}], " ", 
    SuperscriptBox["x", "4"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["37", "144"]}], "+", 
      RowBox[{
       FractionBox["4", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox["1", "24"], "+", 
         FractionBox["m", "6"]}], ")"}]}], "-", 
      FractionBox[
       RowBox[{"11", " ", "m"}], "180"], "-", 
      FractionBox[
       SuperscriptBox["m", "2"], "45"]}], ")"}], " ", 
    SuperscriptBox["x", "6"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "7"],
    SeriesData[$CellContext`x, 0, {}, 0, 7, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[-1, 2], 0, Rational[-7, 24] + Rational[1, 6] $CellContext`m, 0, 
    Rational[-37, 144] + 
    Rational[4, 3] (Rational[1, 24] + Rational[1, 6] $CellContext`m) + 
    Rational[-11, 180] $CellContext`m + Rational[-1, 45] $CellContext`m^2}, 0,
    7, 1],
  Editable->False]], "Output",
 ImageSize->{408, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->67226296]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6852],

Cell["Cnoidal solution of the KdV equation:", "ExampleText",
 CellID->10412801],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"u", "[", 
    RowBox[{"x_", ",", " ", "t_"}], "]"}], "=", 
   RowBox[{"2", 
    FractionBox["a", "m"], 
    RowBox[{"(", 
     RowBox[{"1", "-", "m", "+", 
      FractionBox[
       RowBox[{"m", " ", "\[Beta]"}], 
       RowBox[{"2", "a"}]], "-", 
      FractionBox[
       RowBox[{" ", 
        RowBox[{"EllipticE", "[", "m", "]"}]}], 
       RowBox[{"EllipticK", "[", "m", "]"}]], "+", 
      RowBox[{"m", " ", 
       RowBox[{
        RowBox[{"JacobiCN", "[", 
         RowBox[{
          RowBox[{
           SqrtBox[
            FractionBox["a", "m"]], " ", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"12", " ", "a", " ", "t", " ", 
               RowBox[{"EllipticE", "[", "m", "]"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"4", " ", "a", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "2"}], "+", "m"}], ")"}], " ", "t"}], "+", 
                 RowBox[{"m", " ", 
                  RowBox[{"(", 
                   RowBox[{"x", "-", 
                    RowBox[{"6", " ", "t", " ", "\[Beta]"}]}], ")"}]}]}], 
                ")"}], " ", 
               RowBox[{"EllipticK", "[", "m", "]"}]}]}], ")"}], "/", 
            RowBox[{"(", 
             RowBox[{"m", " ", 
              RowBox[{"EllipticK", "[", "m", "]"}]}], ")"}]}]}], ",", "m"}], 
         "]"}], "^", "2"}]}]}], ")"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->459924020],

Cell["A numeric check of the solution:", "ExampleText",
 CellID->584973588],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"x", ",", "t"}], "]"}], ",", "t"}], "]"}], "+", 
   RowBox[{"6", " ", 
    RowBox[{"u", "[", 
     RowBox[{"x", ",", " ", "t"}], "]"}], " ", 
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "t"}], "]"}], ",", "x"}], "]"}]}], "+", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"x", ",", "t"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "3"}], "}"}]}], "]"}]}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "3"}], ",", 
    RowBox[{"t", "\[Rule]", 
     RowBox[{"1", "/", "7"}]}], ",", 
    RowBox[{"\[Beta]", "\[Rule]", "3"}], ",", 
    RowBox[{"a", "\[Rule]", "2"}], ",", 
    RowBox[{"m", "\[Rule]", 
     RowBox[{"N", "[", 
      RowBox[{
       RowBox[{"1", "/", "4"}], ",", "100"}], "]"}]}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->257691509],

Cell[BoxData["0``93.62387385495325"], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->9656815]
}, Open  ]],

Cell["Plot the solution:", "ExampleText",
 CellID->488141566],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"x", ",", "t"}], "]"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Beta]", "\[Rule]", "1"}], ",", 
       RowBox[{"a", "\[Rule]", "2"}], ",", 
       RowBox[{"m", "\[Rule]", 
        RowBox[{"1", "/", "4"}]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->797754078],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->24796614]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->228220110],

Cell["Conformal map from a unit triangle to the unit disk:", "ExampleText",
 CellID->223864426],

Cell[BoxData[
 RowBox[{
  RowBox[{"w", "[", "z_", "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Zeta]", "=", 
       FractionBox[
        RowBox[{"z", " ", 
         RowBox[{
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "/", "3"}], "]"}], "^", "3"}]}], 
        RowBox[{
         SuperscriptBox["2", 
          RowBox[{"1", "/", "3"}]], 
         SuperscriptBox["3", 
          RowBox[{"1", "/", "4"}]], "\[Pi]"}]]}], ",", 
      RowBox[{"m", "=", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"\[Pi]", "/", "12"}], "]"}], "^", "2"}]}]}], "}"}], ",", 
    RowBox[{
     SuperscriptBox["2", 
      RowBox[{"11", "/", "6"}]], 
     RowBox[{"Cos", "[", 
      RowBox[{"\[Pi]", "/", "12"}], "]"}], 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"JacobiCN", "[", 
        RowBox[{"\[Zeta]", ",", "m"}], "]"}]}], ")"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         RowBox[{"Tan", "[", 
          RowBox[{"\[Pi]", "/", "12"}], "]"}], 
         RowBox[{"JacobiCN", "[", 
          RowBox[{"\[Zeta]", ",", "m"}], "]"}]}]}], ")"}], "/", 
      "\[IndentingNewLine]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["3", 
          RowBox[{"1", "/", "4"}]], 
         RowBox[{"JacobiSN", "[", 
          RowBox[{"\[Zeta]", ",", "m"}], "]"}], 
         RowBox[{"JacobiDN", "[", 
          RowBox[{"\[Zeta]", ",", "m"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"JacobiCN", "[", 
            RowBox[{"\[Zeta]", ",", "m"}], "]"}]}], ")"}], "^", "2"}]}], 
       ")"}]}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16049754],

Cell["Show points before and after the map:", "ExampleText",
 CellID->84846121],

Cell[BoxData[
 RowBox[{
  RowBox[{"trianglePoints", "=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", "=", 
       RowBox[{"E", "^", 
        RowBox[{"(", 
         RowBox[{"2", "Pi", " ", 
          RowBox[{"I", "/", "3"}]}], ")"}]}]}], "}"}], ",", 
     RowBox[{"Flatten", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"s", "/", "8."}], " ", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"#1", "+", 
              RowBox[{
               RowBox[{"j", "/", "16"}], 
               RowBox[{"(", 
                RowBox[{"#2", "-", "#1"}], ")"}]}]}], ",", 
             RowBox[{"{", 
              RowBox[{"j", ",", "0", ",", "16"}], "}"}]}], "]"}]}], "&"}], "@@@",
          
         RowBox[{"(", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1", ",", "t"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", 
               RowBox[{"1", "/", "t"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"1", "/", "t"}], ",", "1"}], "}"}]}], "}"}], "/", 
           SqrtBox["3"]}], ")"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"s", ",", "8"}], "}"}]}], "]"}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->272616709],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Re", "[", "#", "]"}], ",", 
          RowBox[{"Im", "[", "#", "]"}]}], "}"}], "]"}], "&"}], "/@", 
      "trianglePoints"}], ",", 
     RowBox[{"Frame", " ", "\[Rule]", " ", "True"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Re", "[", "#", "]"}], ",", 
          RowBox[{"Im", "[", "#", "]"}]}], "}"}], "]"}], "&"}], "/@", 
      RowBox[{"w", "[", "trianglePoints", "]"}]}], ",", 
     RowBox[{"Frame", " ", "\[Rule]", " ", "True"}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->126582686],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 197},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->228573801]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->598905019],

Cell[TextData[{
 "Solution of an anharmonic oscillator ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Phi]", "\[Prime]\[Prime]",
      MultilineFunction->None], "(", "\[CurlyPhi]", ")"}], "\[LongEqual]", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"\[Phi]", "(", "\[CurlyPhi]", ")"}], "3"]}], "-", 
     RowBox[{"\[Phi]", "(", "\[CurlyPhi]", ")"}]}]}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->68991450],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Phi]", "[", 
    RowBox[{"k_", ",", "\[CurlyPhi]_"}], "]"}], "=", 
   RowBox[{
    SqrtBox[
     FractionBox[
      RowBox[{"2", "k"}], 
      RowBox[{"1", "-", 
       RowBox[{"2", "k"}]}]]], 
    RowBox[{"JacobiCN", "[", 
     RowBox[{
      RowBox[{
       SqrtBox[
        RowBox[{"1", "+", 
         FractionBox[
          RowBox[{"2", "k"}], 
          RowBox[{"1", "-", 
           RowBox[{"2", "k"}]}]]}]], "\[CurlyPhi]"}], ",", "k"}], "]"}]}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->587523086],

Cell["Plot various solutions:", "ExampleText",
 CellID->1296360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"\[Phi]", "[", 
       RowBox[{"k", ",", "\[Phi]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "0.1", ",", "0.4", ",", "0.1"}], "}"}]}], "]"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Phi]", ",", "0", ",", 
     RowBox[{"12", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->520336049],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->413058674]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->374689701],

Cell["Elliptic parametrization of an ellipse:", "ExampleText",
 CellID->431447185],

Cell[BoxData[
 RowBox[{
  RowBox[{"ellipse", "[", 
   RowBox[{"\[Phi]_", ",", 
    RowBox[{"{", 
     RowBox[{"a_", ",", "b_"}], "}"}]}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"u", "=", 
      RowBox[{"a", "  ", 
       RowBox[{"EllipticE", "[", 
        RowBox[{"\[Phi]", ",", 
         RowBox[{"1", "-", 
          FractionBox[
           SuperscriptBox["b", "2"], 
           SuperscriptBox["a", "2"]]}]}], "]"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a", "  ", 
       RowBox[{"JacobiCN", "[", 
        RowBox[{"u", ",", 
         SqrtBox[
          RowBox[{"1", "-", 
           FractionBox[
            SuperscriptBox["b", "2"], 
            SuperscriptBox["a", "2"]]}]]}], "]"}]}], ",", 
      RowBox[{"b", " ", 
       RowBox[{"JacobiSN", "[", 
        RowBox[{"u", ",", 
         SqrtBox[
          RowBox[{"1", "-", 
           FractionBox[
            SuperscriptBox["b", "2"], 
            SuperscriptBox["a", "2"]]}]]}], "]"}]}]}], "}"}]}], "]"}], 
  " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->434656425],

Cell["\<\
Plot using elliptic parametrization and circular parametrization:\
\>", "ExampleText",
 CellID->199645768],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"b", "=", "1"}], ",", 
     RowBox[{"a", "=", "2"}]}], "}"}], ",", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"a", " ", 
           RowBox[{"Cos", "[", "\[Phi]", "]"}]}], ",", 
          RowBox[{"b", " ", 
           RowBox[{"Sin", "[", "\[Phi]", "]"}]}]}], "}"}], ",", 
        RowBox[{"ellipse", "[", 
         RowBox[{"\[Phi]", ",", 
          RowBox[{"{", 
           RowBox[{"a", ",", "b"}], "}"}]}], "]"}]}], "}"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Black", ",", "Thick"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"White", ",", 
          RowBox[{"Dashing", "[", "0.1", "]"}]}], "}"}]}], "}"}]}]}], "]"}]}],
   "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->504511624],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 98},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->126374219]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->852495579],

Cell["Solution of Nahm equations:", "ExampleText",
 CellID->46361833],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    SubscriptBox["T", "1"], "[", "z_", "]"}], " ", "=", " ", 
   RowBox[{
    RowBox[{"-", 
     SqrtBox[
      RowBox[{"m", " "}]]}], 
    RowBox[{"JacobiSN", "[", 
     RowBox[{"z", ",", "m"}], "]"}], " ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}], "/", 
     RowBox[{"Sqrt", "[", "2", "]"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    SubscriptBox["T", "2"], " ", "[", "z_", "]"}], " ", "=", " ", 
   RowBox[{"I", " ", 
    SqrtBox["m"], " ", 
    RowBox[{"JacobiCN", "[", 
     RowBox[{"z", ",", "m"}], "]"}], " ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "I", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "I"}], ",", "0", ",", "I"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "I"}], ",", "0"}], "}"}]}], "}"}], "/", 
     RowBox[{"Sqrt", "[", "2", "]"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    SubscriptBox["T", "3"], "[", "z_", "]"}], "  ", "=", " ", 
   RowBox[{"I", "  ", 
    RowBox[{"JacobiDN", "[", 
     RowBox[{"z", ",", "m"}], "]"}], " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "}"}]}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->385040697],

Cell["Check that the solutions fulfill the Nahm equations:", "ExampleText",
 CellID->50816325],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubsuperscriptBox["T", "1", "\[Prime]"], "[", "z", "]"}], "-", " ", 
  RowBox[{"I", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["T", "2"], "[", "z", "]"}], ".", " ", 
      RowBox[{
       SubscriptBox["T", "3"], "[", "z", "]"}]}], "-", 
     RowBox[{
      RowBox[{
       SubscriptBox["T", "3"], "[", "z", "]"}], ".", 
      RowBox[{
       SubscriptBox["T", "2"], "[", "z", "]"}]}]}], ")"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->760118834],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->943541092]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubsuperscriptBox["T", "2", "\[Prime]"], "[", "z", "]"}], "-", " ", 
  RowBox[{"I", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["T", "3"], "[", "z", "]"}], ".", 
      RowBox[{
       SubscriptBox["T", "1"], "[", "z", "]"}]}], "-", 
     RowBox[{
      RowBox[{
       SubscriptBox["T", "1"], "[", "z", "]"}], ".", " ", 
      RowBox[{
       SubscriptBox["T", "3"], "[", "z", "]"}]}]}], ")"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->69019748],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->571997565]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubsuperscriptBox["T", "3", "\[Prime]"], "[", "z", "]"}], "-", " ", 
  RowBox[{"I", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["T", "1"], "[", "z", "]"}], ".", " ", 
      RowBox[{
       SubscriptBox["T", "2"], "[", "z", "]"}]}], "-", 
     RowBox[{
      RowBox[{
       SubscriptBox["T", "2"], "[", "z", "]"}], ".", 
      RowBox[{
       SubscriptBox["T", "1"], "[", "z", "]"}]}]}], ")"}]}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->371259714],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->46107172]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->112142597],

Cell["\<\
Parametrization of a mylar balloon (two flat sheets of plastic sewn together \
at their circumference and then inflated):\
\>", "ExampleText",
 CellID->220319908],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"x", "[", "u_", "]"}], ":=", 
   RowBox[{"JacobiCN", "[", 
    RowBox[{"u", ",", 
     RowBox[{"1", "/", 
      RowBox[{"Sqrt", "[", "2", "]"}]}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"y", "[", "u_", "]"}], ":=", 
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"EllipticE", "[", 
      RowBox[{
       RowBox[{"JacobiSN", "[", 
        RowBox[{"u", ",", 
         RowBox[{"1", "/", 
          RowBox[{"Sqrt", "[", "2", "]"}]}]}], "]"}], ",", 
       RowBox[{"1", "/", 
        RowBox[{"Sqrt", "[", "2", "]"}]}]}], "]"}], "-", 
     RowBox[{
      RowBox[{"EllipticF", "[", 
       RowBox[{
        RowBox[{"JacobiSN", "[", 
         RowBox[{"u", ",", 
          RowBox[{"1", "/", 
           RowBox[{"Sqrt", "[", "2", "]"}]}]}], "]"}], ",", 
        RowBox[{"1", "/", 
         RowBox[{"Sqrt", "[", "2", "]"}]}]}], "]"}], "/", "2"}]}], 
    ")"}]}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->92049699],

Cell["Plot the inflated balloon:", "ExampleText",
 CellID->24027191],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "[", "u", "]"}], 
      RowBox[{"Cos", "[", "v", "]"}]}], ",", 
     RowBox[{
      RowBox[{"x", "[", "u", "]"}], 
      RowBox[{"Sin", "[", "v", "]"}]}], ",", 
     RowBox[{"y", "[", "u", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{"-", 
      RowBox[{"EllipticK", "[", 
       RowBox[{"1", "/", 
        RowBox[{"Sqrt", "[", "2", "]"}]}], "]"}]}], ",", 
     RowBox[{"EllipticK", "[", 
      RowBox[{"1", "/", 
       RowBox[{"Sqrt", "[", "2", "]"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"MaxRecursion", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30295536],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNvWd4HMeV740LUNGKli3Zkrz27l77eq9vg6QSFS1RsqI1zEGkKFIUhwAD
SIIAAZBgTiBA5JxzzjnnnNMMMBjknHNO83/eW1XdA0IDSOLu3Q8vn+ZMT3d1
dZ3fOXXqVOiG6OiFE8fPHL1w8tjRP32ud1T3xMlj+n/67JweOaTxP9TU1BLI
f+vfqZH9/4/ssf8JAMiJNZ9nyKcGSaBOf9EdsH9q6mT3A5birMoZDfqx4cFv
NbX3/3+e7qmfkfEvKxTor0eF72d+Mc8/s69r5JMe1njI9Hf/m9PtEsq7+v5q
VFLy/1VB6icfMq+da44/pnLli4K0LIvjx4/T3cdVyP3lIfP6zaqS04RvP+R1
zwvpH2XHSSEEibf8xPWPCPf5tfDNaGzgr+NTvPUzV66+8zMCz6dW5aDG/r31
I108Jnw/JXw/S88+snJH4ao32beWkOfzq6Shu6qW+hpLLRZy/M1DpT4q5P3i
jyUWjr7O0ryDtfYDoWa8Kpz7vcrdNqik3cRyensNvw1rjvxOuPcr/205vvgT
5f+dyh1Udbnxoe/wglDmf1XJUUO48+aHzuk5Iaf/+Qtle3IdmZR1+uWHvpvS
Wv+icrdHVe72+JorVWvcS1htKcp6rvSp/7GONOpC7WG+4hE+15XsfyJ/kZDf
31TyU0392EOW9yshP02V/B5XSf3omvyUEvCs//VntPEH4Rx/kj/1X7vf6hSs
vqn96aHkXKnJKhresMozK/0Rn+8rD62X364jneq9VNuW/3jIsv9aKLtqzd/8
X8xfqbMXhO/31smHHv/fP3P96vs8K5TvA5V8nlhzJV8ipZUoWT8tfH+kcv1T
Kvf5X+zqt4S7fayS+mmV1Hzb+oaQ96c/kzdVG5/3r/DTsQ/18FSYz1RyUo1+
+PhAtexr4wilf/8LlDZ2kBOTL21OrMOJz5L9R85xYnVdTvyImtAurrrrsyr5
Mz+54kd+OcJStgWr7VWpF7VXdnDivZyYlOd7TnyclUePle0yJ77GiW9x4juc
2IQT3+PEppzYjBObc2ILTmzJia04sTUntuHEtmyHHLnPia+Ta2m+v1pHY6u9
5Hrt6osPSVPZ8qjWkVeUMj2+nRPvXiXTaU58nhMbcuIX2NlQThzMiYM4cQAn
9meyunFiO8J/pT7+NHv1NaVZ28L89iHleF4or6oF/kEpxyNEjn2c+BAnPsaJ
tamV0KO/vc20Yc6ok9+OnNiFE7tzYk9O7M2JfZlQgURGTXGopjh8ozhyozh6
kzh2kzh+kzhhk1jtUZrLhihOHMoQePOSb1CRnLbK7IZQ/lNbr7b8l6VXtsP/
przPTk68hxN/w+Rll6r9iViiESe+zMzqNjPD+8zu7DmxM5Pdi8kbwLQZoikO
2yiO2CiO2iSO2SyO2yxOeE2c9Jo45XVx2hvijDfEmWR7U5y1RZy9RZzzhjh3
s5ivi+ma4kTCaqPYU1P8QMYf28CKzT6U7n+lYu1K6/83ZXoRKz2RmMn5H2JO
fIoTExdgwImNldKu6JhI68Qdd+O0PDltkjpAUxy8UTt086mI109GvXky5q2T
cW+dSHjrRNKWEylbtNPe1s58Wzv7ba3cd7Ty39EqfOd40bvi4vfEJe+LSz4Q
l35A71v2jrj0XXHJO+LitwTSG+I3i4M3iR1IdTl+/IU1Uj2s1v8I3ieteJfX
eUH5f99y4qPMjnkfQzR7lTqY4yac9n3uhCV30pY75cCdduF03Lkz3twp/40n
yVWhr52NeP181FvnY98+H//O+cT3dJM/0E39UDf9o3OZH53L+ehc3tazBVvP
Fm09W/LxmbKPz5R/olP5yemqf5ys/seJmk8pMMmnYsk/xJJPxLX/ENdsFVf/
XVz5Hu+l1DZkvU4lDthIS/nrVVL+Z2xdWV+pX1YXCTp9hxjyYVZxTzLNXuCO
X+K0r3Inb3Gn73FnzLmz1tw5O07XiTvvyul5crq+G3UDNuuFvK5PLo5662Ls
2xfj37uU9P6llL9fTPvoYsbHF7P+YZTzqVHe54aFXxoWf2lY+pVB+VcGlf80
qP7nhZp/6ku+1pN+fb5OdE627QzJQb79hHybduM2rcZtxxtF4savxQ1fiusJ
iI/FNR+K+S5qxpu0qqgJLY7SE622W94jvyzU1DXth4j3HGov7mJa/pb5Wy3q
b7XOcScucKcucTrXuLO3Od17nJ4Fd8GGM3TgjJy5i+6coffGi36bLwW9bhz6
5pXILVefYMUo/OpaydfXyrZdq9hxtWrn1ZrdVyW7r9TtuSLbc7lhr7F8n1HT
vgvN+/VI0tZvzqmpt+0/q/Z0274zbft02vedatuj3bZb3LJD3PQ1FbD+M7H0
Y1qsoi1MxqfXaI/1XFjbvNI/f4G31x2s/djPmhDy8yinrcWdPM2d1uXOGHC6
lzi9a9yF25yhKXfRkjO25a44clfVmASPJ281Tf3ENOMzs6wvTHO/NM3/p2mh
6F7xtntP0bPPdxy50vm9Mdnr+v5i9xGj7iMGPUf0e46c7/nubPeh010HT3R9
o0WK3q4Uo+EL3k6fU7HEf2Elfwlr23XmYZ5fqXW7WeNOBDnAHT/EnVCjIcfZ
05yuLqdnwF0w5oyuc5duc5dNSfmZL/yD5xsmPm+ZBrxtFvzu/bAPzCM/tIjd
apXwiTU5l/aFTeZXNtki27xttgU7bIp22ZTsti7ba12537r6gFXtQSvpIav6
w5byI5ZNRy1ajlm0ic3bj9/v1DLt0rrHt1zPDJy4MnjCeFD74qCWwcBxvf5j
5/p+0CEC9x3W7v1O3HNQ3LlP3LaLWutqr/mnFWmVDKj9/rtS+qeItnaxtmMf
d3w/d+JbTucod46c0OEMznNGhtwlY+4yk+4vtpr3HDeZub5h4bnFyudda//3
bYI/tA3bah/5D4fYzxwTvnBK/sqZpMvc7pqz0zVvt2vhXtfi/a6lB1zKD7pU
HXKuOewsOeJcd9RJdsxJLnZs1nJsPeHYftKh85R912m7Hh3bvjPW/WetBs9Z
kkyGdE2HdU3YfX81dtZ4VMdw5LQ+KfiQ9tkhrdOD4hODP2gNHhX3HhJ37OW1
rBpd/mGtloXBlT8qjz1BNE2ChJ3UXo/v4U7s405/y507yulrc0Y8c83bmndN
NU0tNO/baFo6vGbt8pad5zsOPu87+X/oHPyxS9inrpGfu8d85ZEg8kze7p2+
04dck7PPN/8b38KDfiWHfMsO+1Yc8a066lN7zEcq9q7X8m444d140qv5tFfb
Gc+Os55dup495z169dz69V0HLrgMGTiNGDqSTEYNbceMrMaNLCaM7k8Z3Zsy
ustra/LCZSLF+PkLY+fOj505N3ZaZ/TUqdET2sPHqc227havQ+JVRkLZb9NQ
RgxQ/mPN+Jqj1EpYTfkV3+KSbRsn3sFp7eRO7uZ09nLnDnJ633OGWpwx3xps
NdC8Y6xpck3T7Jam+T1NK3NNG+tN9vZvOLpscfF4z83nQ0//j72CP/UO+9w3
8iu/GJF/wo6A5F2BaXuDMr8JIdfnfxdadCSs9GhY+bGwyuOh1VqhtSdC606F
yE6HyM8EN50LbtENbtML6tQP6jYI7DUK7L8YMHDJf8jYd9jYZ/Sy1/hVT5LJ
5DW3yavOU1cdpq/ZzVyzmb1mOXv1/uxVE3KKd9szFy9NGxpOGehP6etOnj87
cfYUtbbj4q5vWaVXjq7xPmLtqIDqOIdqK8dH5g+iH9bbf3KFoIg7vo07uYPT
2cWd28PpHeQMv+cuMXpv6WrSQl7StLiqaX1L09ZE0+G+ppPVa652b7o7v+Pl
/oGP91Z//38EBn8eHPZVSKQoNGZHWMKu8OS9EWnfRGV+G51zOIZ662OxpVpx
5SfiKk/GVZ+OrT0TW3c2RqYbI9eLadKPbjWIbjeK7rwY1W0c1XslauBq5OD1
iOHr4aM3QsduhkzcCp68HUgymb7jN3PHZ+aO5+wdt7m7LvN3Hefv2M3ftlKn
BJ9euHmH947z14znrhjNGV+YNTpPfk7pnhg7Le7/Qdz2zQpJ1f4F30auP06w
AQ96ZMqRntUk2djbE6tIaok4ne3cuR2c3m7O4AB3ibfCN09qmpzVvK+vSZ3u
FU3Hm5rOdze6mW3ysHzD226Lr9N7AW4fBnl9HOL3WXjQV5FhoujIHTExu2Pj
98UlHYhPPZSQcSQx54fk/OMp5PKSU6nlOqmVZ1OrdVNrz6fW6afKDFLlhilN
F5NbLiW3XU7uvJrUfS2p90ZS/63EwduJw3cTRk3ix+/FTpjGTJlFz9yPJJnM
mYfNm4fMmwcumPsvmvsykdQeWTKzXzKzIbvL98yWTe7yceTjSzeNFq/RBnrG
4OSkrtbwSXH3EfE6LF/+Cetc3adTMlVGJKtZssjksVUstUXcGRGnt50z4Evy
xjHNuyc075/RtNLTtDfaSN36jY2edzb6mL7mZ/FmoO07wY4fhLpujfD8NMr3
i5iAr+NCdiRG7EmK3p8SdzA16bu01O/TM45lZGtl5p3MKjydTS4v082p1Mut
vpBba5grNcqVXcqRX85puprTci2n7UZ2x82srttZvXey+k0yB00zh+9njJqn
j1ukTVqmTlmlzFgnUXuzSViwjV20jWYEf6WwC1LY+itsvRU2HrB2gZUjlc/S
Chb3YXEP5rd5SR5dunFu/vLpaQPtCV1xH/OST+Kne9P0EuU45HqElSNCqr1n
VcLKeQi1DYzvCRF3VsTpsyN/2q9545Dm3aOaZlqaVqc17XQ3OhtsdDfe6E3O
3d4UdO+NEPMtYdbvRdp/GO38Saz75/He/0z0354SvDstfH9G1MGsuMPZiUdz
U8R56dr5WScLcnUKC84VFZ8vJpdXGJZUXyxhcj8vv17SdLOk5XZJ292SDpPi
LtPiXrOiPvPCQYvCYauCUZuCcdv8Sbu8KfvcGYfsOccs1khSsr9bdklUuMQr
XGLhEgWXcDiHwDkATr5w9ISDG5XR3h521rCzgM09WN8mFy6bXVy4c2Hu+rkZ
41OTBlp9WpTzr9bzlT87fvfEQ1Cn34+r0FbOwqj9gdE+KeLOibgL5PcOzRt7
Ne8c1DQ7omkp1rQ7qel0dqO7/kbvixv9r26kjY7JW1H3342x+nuc3ccJjp8l
uX6Z6ilK992ZGbg3O/RAbuR3BTFHixLExcyFq2lIb9TU36puuF2t9oyS1gtL
nvlLnrnLntnLnpkKrzSFVwq8kuAVD88YeEbAMxQeQXD3o4V1c4erC1wc4GwD
J3OlfZoZzN/Rnb2uM2Wk1au9wu0Xxw5UxxZ5dqtHZ3+unVIlyGLkV9SUfWsR
d0rE6Yo4Q7K/jbu9S9Nsv6blIU3bo5pOWppupzW9dTf6G2wMubwp4sYbtN0x
+yDRcmuKzadpDl9muoiyPXbm+uwtCDhQxEdRv089U52hW5OtV5trICm4KC02
riu7Wk9OVN+S1d6R1Zk0yExlcjNZk7ms1aK+3aq+06a+27au176u36Fu0Klu
2EU65iadcJdOeUjUaCvEcn1l2b9o2b9AEZCnCMhBQCb80+CfAv8E+MXCLwp+
YfANphL6+MDbE14u8HCgAFzM4HiL2qyV4YKZ3twtncmLx3sYeMZw/bGK9S1V
OTb4pApNNu7F13xtRvM8s07Ss7i7gzPfo2l7QNPpsKbbMU2vE5r+ZzYG628K
v/RazLU3E269m0zSmX+Saf15tv3Xec47CviexSthx6ojtWpjT0kSztQl69an
6ckyDRqyL8rzjBsLrzaV3Ggqu9VM0tXca5WYtdaZtzZYtjZatzbbtLTatbQ7
tHQ6Nvc4N/e5NA+4NQ95NI14NvHW+9iMX8Ocv2whsH4xqI5crwiuVYRU8/d8
HqGFCM1DaDZCMxCSipBEBMchOBrBEVTUoEAE+sLfg0LxtoXHfbjeEcYFFi31
Z++cnrh0vOuE+FdrWK4XM/3Y567nlTVWxQZPqfBeGdEm8RWJCvhSPCfirou4
e9s5y12cwz5Nt281vb7X9D+uGXx6U/j516INX0+4vCX5xvvpd7dS32f1VQGr
j696Hqj0+a464GhtiFgafqI+Wqch7lxjon5TikFz2sWWTOPWnKtt+TfaC291
lNztLDftotQte6TWPfW2PQ12PY0O3c1O3W3O3R2uXV3uXT0eXX1enYz1M2MB
HROBHVNB7TPBbXMhrQuhLUvhVGmKCLkiUqaIrFNESRRRNYroalaS3yK6AFG5
iMpCZBoikxARTyWOiER4KMJooIZAN/jbw8cCniZwu0GOLFqfn717atxY3EZa
uicfivzq30xXvzCXpKa2dvxZVR8snxeU8YUOiSzY/k0RZ7aNs97JOe3hPL7R
9DusGXxsU/jJ16LPvh5/4c3kS2+nX/sg+/bHebxnfNVhT5XzNzXuhyTeR+r8
jsmCtBtCTzVGnm2O0WuNN2hPutSZerkr41p31o2e3Nu9+Xf7ikz7S80HKiwH
ycW1dkNSh6F6pyG5y1CT21CL+1Cb52CH1yDTxG8GAgeGgvpHQvrHQvsnwvqm
wvtmInrnInsWorqXoqlGl2PbFXGtirhmRXyjIr4BCfVIkCKhBgmVrGwvICEf
cVmIS0dcCpU7JgbRERRIhB9CPRDshABr+JrCi3qaRRvdmbsnxy4zH0Pte4Pa
g9Eipb3z7JWjEco4ZG2cvF4PRNn/pb6R5fO8Murgwd8WcfdFnO0Oznk357Vf
M/DbjWFHN0drvR6v82by+S3pRu9mX/4wn7/fq2bbKsmX3X6J48E618Myzx/k
PsebAk62BJ9pCz/fEXWhK/ZiT8LlvuRr/Wk3BzPvDGWbDOeZjRSYjxZbjZXZ
jFfYT1D8LpN1bpMyj0m552ST9ySj/nJ34Hhv8Hh/yPhg2Nhw+NhI5NhY1NhE
9OhUzMhM7PBc3NBC/OBSAtXeclKfIqlHkdylSOlQpLQhpQUpjUiVIbUOqbVI
qUJqBdPDc0jORnIG1UAiXZ2EuDDEBCDSC2EuCLFFoDl8blIN2J6bNjk5dkWs
GpP89icsnvn7NW2w6noKlupZhliLxRzGjLWFiLPfzrnu4nz2aQYd3BhxeHOc
+I3kU2+ln3s7m7ftV259VXlve435bqn1NzLy2/n7Zndxq9eJdj+dzsBz3aH6
vRFG/dHGA3FXhxJvjqTcGUu/N55lNpFjMZlvPVVoO13iMFPuNFvpOkeulXjO
13kv8P78T61B8+3B852hc91hc70Rc/2Rs4PRs8Mxs6NxM+PxMxMJM1OJ0zNJ
U3PJkwspE4up4xR2+ogifUiRMaDI6FNk9iCzC5ntyGxFZhMyG5BZj0wJMquR
WYmscmYjzyIjm0JITUJyLBLDER+EWB9EuSHCHkFm8L1OEi3YnZm+R8fM1sy2
/izzDauZq6/DnF33NHP0p5XGbSniHLdx7js5v72aIQc2RX23Of7oa6lab2bx
Nv2K4dayy59VXv+q5vZ2qekemcWBRtvDreSEq3aXx6lun7O9/nr9wYaDYZeG
I6+MxtwYj789mWQynXp/JsNyLtt6PtduocBhsch5qdR1qdxjucprmaf9RkPQ
sjxkuSl0uSV8uS1iuSNquSt6uSd2uS9ueTBheThxeTR5eTxleSJ1aSptcSZ9
YS5jfj6T6mwpe2Y5e0qRM6nIGVfkjipyh5E3gLw+5HUjrwN5bchrRp4ceTLk
SZFXi7wq5JWpsUEMZGUiMwXp8UiNRHIIEv0Q54FIO4SYwu8aJW9/ZuTGcWUv
58WfoL129kXVq6uSZ1f8lTE/yT6viThzQl6Nxtn+ezaGfrMp+tDmxO9fTxe/
kUMOnvugTH9rhdFn1Vf+Kb2xQ3Z3b6PZwRarIx124m5y1u3MgNf5Id8LI4EX
x0IuT4Rfn4q6NRN7dzbBbD7ZYjHNeinTbinbcTnPZbnAbbnYY5kR31IbpCDX
1ocpZOEKeaSiKUrRHK1ojVW0xyk64xXdiYreJEV/yvJg6vJw+vJoxvJ41vJk
9vJ0zvJs7vJ83jJFX7C0VLCwXDivKJxVFE0riiZRNI6iERQNoqgfRT0o6kRR
O4paUNSE4gYU16GoFkWVAv28bOSkISsRGdFIC0NqABLcEWWL0HsIuELSzNrq
rOmvszmhFU+/ut+53rorpodfKUNH4lLuiTgHEUeHt3ZtDN+7KfbA5qTvXsvg
bft3pz+o0P24+sLnkktfy67ubLy1r8Xk2/b733dbH++zP0WdqYf+uLfRpL/x
dNC1mdCbcxF3FqJNF+PMlxKtlpJtl9McljNdlnPceL4aZYGKimBFdSipYjT3
vw1kKYayFSO5irE8xUS+YqpAMVOomCuiIBdKlhdLlpZKl5bLlhRliyhfQPks
yqdQPoHyUZQPo3wA5b0o70Z5B8pbUd6McjnKaJyJknJ+OA4FGchLRk4sssKR
5o9EV8RYI+wuAi+Ts/3XxWt6kTzL36gcZb//l8pqOBZ6GDIPYUP4iTgaNO3U
jN+jmbp/Ix2UOLqlVPuDqjOfSM5/UW8oajTe1XJtf/vtQ133jvZZaA3anB5x
1B13NZgmKX2uzvvfWAy6vRhqshhxfynacinOZjnRfjnZifcFbFb46epoeltp
HOoTIEuEPBlNKWhORWs62jPQkYmubPTk8MNYahvmKxQLlcuLlctLlcvqiqol
tVdRtYTqRVTPoXoG1ZOoHkP1CKoHUd2P6h5Ud6K6jcpc1YBKCSoqBYbFWShM
QX4ccsKR7ockF8RaIeIOgownbE6v9r5qSmv72ZUEtJ7TQ8xPP7XClLjcVbXe
RcQFiLgIVvfTmCX+9vCWsmPvV5/8pO7cl3L9bS0Xd7df+abrxnd9d38YNNMe
sdIZtzs/5WQ45355gaT2vbUYYLIUZLYUarEcYb3Moko25Ex2Mn2RHYC8YBSE
ojgCJVEoi0ZFLKriqQS1yZCmoD4VDemQZ6ApEy1ZaMtBey4689BdgN5C9Bdj
sATDpRgtw3gFJisxXcWPO25YrlUoyCZZJps6JEukNZMuQroA6SykU5BOQDoK
6RCkA5D2UDCSVtTKUVNHQVSW8bXucZSkojAOuaEghU1xRpwlIulAiOraGuZD
+SDuP+l9md9+QlgO+yNH4CviwkVcPF+SF/a8VnTgzfIj79Uc/7j+9BdNutvb
DPZ0GR/ou3Z48PaxkXsnxs3PTNnozTkYLbheWfS4uUSu8TNdDjRfZtezMd0/
x7kjwRPJPkj1R0YQskORG478SBRGozgWpfEoT0RFMi1lTTokGajLRH02GnLQ
mIvmfLQUoK0QHUXoLEF3KXrL0F+BwUoMV2GkGmM19MIpCWYkmJNioY4XXO1V
hUwB2TLbltCwiIYFyOcgn4F8Eg1jaBimMGTdqG9DXROk9VQBtRWopiNdKEtF
USzyQpDljVRHJJgrQi+N2pxcvXbgp9YnafyXdcJm0R5n2jBY5VZCRFyciONr
wXN7Xq/89l3J0a0N2l80n9nWobe3x+jbwSvfkxZ5/O6pKbNzc5YX5u0uLTpd
W3K7texpsqyutPy/Rboi2gNx3kjwQ3IgUkOQEY6sSOREIzcW+fEoTEBxEkpT
UJZGS1eViZps1OZAmof6fDQUQF6IpmK0lKCtFO3l6KxAdyV6qtBXjYEaDNVi
WEIvHK/DZD2mZZiVYb4Biw1YkkMh50VV+z2aFGhaRtMSmhfRvICWeTTPUAhN
o2gchLwHDR1oaIZMRjVSV4naInq2IgXF0cgPQo4X0h0QfUttnfqgOm66dqRF
/f9NOy8pfRQJwl2Zj4oWcXQwf9vGEvK5/13pd1vl4i9aT27rPLun78K3Q5eO
jl/Tmrp1eu6e7ry5wYKN8aLDDb5uMK1sDHJEiAvC3WmnIsYXcQFIDEYyafgj
kB6FzBhkEb+bgNxE5CejkFhlOkoyafEqclCVh+p81BZAWoT6YshKIC9DUzma
K9BaifYqdFSjswbdteiRoE+KgTp64YgMYw2YkGOqETNNmGvCQjOWmqFoJvar
aOFHOl9CmwJty2hbQvsi2qlLRds0WsfQMoTmPjR1orEVjXKqovoKSAtpgsoU
lEahMBC5nki6vxxquP4TCf9N+lH2TNkK0ReZXkyUDixCxCWxI8XbN9PI6sBH
jUc+bzu+rfvUnn7dgyMG309c1p69oTN3R2/BzGjR8sqSUh+ve9nC14FmH+SO
UC+E+yDSHzFBiAtBQjiSIpESg7RYGh5nJiIrCTkpyE1DfgYKslCUQy8sy0d5
ASqLiCdBbQkkZagrh6wCDZVorEJTNVpq0FqLdgk6JOiqQ3c9emX0wkE5hhsx
2oTxZkw2Y7oFs62Yb8NiG5bbqG7a6TLbDmX/naDoWmafC+icR+cMOibQPoK2
frR2o6WNqqaxFg3lqCtgrXoiyiJQFIAMe0UM7UKtzEaqjvX+v2plzZr2F1jz
Yq30ZvFMNYXbNlXs3CLd8/dG8vMHUY/27gGdg6N6308Zac1e0Zm/qbd412iJ
18oWx/twsYK7Lbwc4euKAA96qxA/hJPOeDCiwxAbgYRoJMUimfRbEpCWhIwU
ZKYiOx05mcjNRn4uCvPoVSVFKC1GeSlpbFFVjpoKSCohrUJ9NWQ1kNeiUYJm
CVqkaK1Dez06mG565OhtRH8TBpsx3ILRVky0YaodM+2Y68BCJ5Y6qYa6oI5u
2rj2CFpC7zJ6F9Ezj55ZdE+haxSdg+joRlsr1U9TDa2yMqafatIOhiHfHcmm
i2H6qjVn3bG1dXSkjLxUewFMD88z8LeU4VUM+5kn0izd8Vbt7g/k+/7RTo4c
2z104sDY2e+n9Y/PXjw9z2vgA/ObsDaBnTkcreBiB3cneLnCxwP+PkwVQQgL
QWQ4oqMQG4P4OCQkICkJKclITUV6OjIykJmF7Bzk5CEvH/mF9KqiUpSUobQc
ZRUk2kRlFaqrUVMDSS2kEtRL0CCFvA6N9WiWoaUBrXJ6VUcTuprR04K+Vgy0
YagNI+0Y68BEJ6a7MNuF+W4s9mC5F4peyq2P9w7oV6qkfxH98+ibRd80esfR
PYjOLrS3UH20VKOpFPJ8mqwmFiV+yLRZir2i9uDJgYf1YC+s13o8w4DfF3Fe
zEUli7gc4qJ2vFG16z3Z3o9bv/my58guGpacOjLNqNMZk1tXcO8WzO/B2pzO
ijnaw8UJbq7w9KQzD37+CAymdw2LQEQ0ouIQE4+4RMQnIzEVSWlIyUBqFtKz
kZGLrHzeBNReamiAXI7GRjQ10YtbW4j86GxFdxt629HfgcFODHditAvj3Zjs
wXQv5nqx0IelfigGgAFhzmiQdpiG2Aji4BIGFzAwh4EZ9I2hdwDdnRQpqUKt
VWguocFcXTIqQ1HgupxyV9l60whRdWWbxhqCfJME5WoROxHnT4Iitl+w/bWK
Xe9I92xt3v9F18HtQ8Iso+6pZV7d167g9k2YmsDCAtbWsLOHgxOcXeHmCQ8f
ePvDLxgBYfQOoTGIiEdkIqKTEJOCuDQkZID1vJ7PLEZ2KXLKkVtBU+ZXoqAK
hdUoqkFxDUpqUSpBuRSVdaiqR40MkgbwK3mfb2lDWzvaO9DZQYCgtwsD3Rjq
xkgPxnox0YupPsz0Y64fiwyqYohGMcMQRsKGFzE0j8FpDIyirx89HRRpB3FM
lWhhYVFtNEp9FFlWNDnti/H9bKysRnpmxXP/0qwH8xCPs9CTRDahvG/Ytql0
59u1ez6Us3xfOnpoWuvYAg/W0ACXL+P6DdwxgZk5LG1gbQ87Jzi4wdkTbj7w
CIB3MHzDEBCFoFhmpEmISBHi8z/E5yAxF0n5SC5EahHSSpBeioxyZFYgq5Km
zqlGbjXyapBfiwIJCqUoktLhktJ6lMtQ0YAqOaobUdsESQtNX9+KhjYh92c7
utDVjZ5u9PVgsBfDvRjtw3g/JgcwPYC5QXrB0jCWR4ARSnyUH2nFyCJG5jE8
hcER9PehjwHvkqK9DM25rBkNQiFdsMDGWygV1ZUk/DzT2pbxl2Y5mH0/IuKu
MPLRajSmLOKt+aX9X/Ue2Dly6MD0D0fnT5yg0Yq+AYyMceUGbprAxBz3bWBp
D2tn2LnReXRnX7gFwDME3uF0rjIgDsGJQvz954gMRGYiKhvROYjNQ1wBEgqR
WIzkEqSUIbUcaRVIq0R6FS1lZg2yapEtQY4EuVLk1SG/HgX1KJLRsasSOcoa
Ud6EymZUMR3UtkJK+lPtkLVD3kHDRP6uT3f3orcXA30Y6sfIAMYGMMF0MDOM
+REsjGBpFIoxqolx3k9ibAmjcxiZxPAI1WB/O0XcWYU21lpKIlDmORmlz57E
JGdUZ5x/SgsqI5WrY0gNEUfXHlHgrN/60o53pLs+at7zWdc+0dCBvZOHD8+J
tSj7c/o0p0s3cM0Et+7DxBrmDrB0ho0b7Dzh6AuXALiFwDMcPtGC/H8LSWUV
IBPhWYjIQWQuovIRU4DYIsQVI74UCWVILEdSBZIr2QxENU2fVov0WjpAniVF
dh1y6pFbT0dt8xtQIEehHEWNKG5CSTNNXN6CylZUt6GmHZJ21HVA1gl5Fxq7
0NIjlOOpvgEMDGCIsR8fxuQwpkcwO4r5MSyOY2kcigloYIIfoMP4IsZmMTaJ
kWEM9VK6pCfRUYKWbFYV/CcTLjPoqjN0P0V/7dqLl4U2QO13zOyLRG/WbH9f
vvOTjt1f9u/dMX7w4MyRY4vk1Gk96F6E4XV6zfX7uG2Ne/Ywd4alO2y8YO8L
xwC4hMA9nPecm/0SEZCCwDQEZyCEdZjCchGeh4gCRBUiuhgxJYgtRVwZ4soR
X4EEslUisQpJDHxKLVIlSJMiXYqMOjpLkSVDdgNyGpArp0Pn+Y0oaEQhaz5L
WlDaivI2VLSjqh01HZB0oq4Lsi40dKOpB6196OgXNPDk4BCGhzE6gvFRTI1i
egyz45ifwNIkFJOE/STBRwlNLGJiBuMTGB3EIO+GSKeOhSa1wdOpt1SfRPpZ
5us8zaPxgHo4+ywTbakTfdi649PeXV+P7Ns39e331NNrnYOOIc5fheFtXDal
Gd6xh6kLzN1h5QUbX9gHwimEp/6mZxx8EuGXQhdLBGQgKAvBrE8Umo+wAoQX
IaIYUSWILkVMGWLKEVuBOLJVIr4K8dV0BpQkTqxFkgTJUjodl1aP9HpkyOhU
UVYDsuXIIVsjchuRx9gXtKCoFcWtKG1DeTsqOlDViZouSLpQ1w1ZDxp70dKP
tgF0DPKyqz3ZP0K9+8goxsYwMY6pCcxMYH4Si1NQTBMNTPNxBqYWMDlD1UQa
64Em5n6K0ZoBaehslumaJ8F+iv8v95F+LWiD+jJmI38RcVWidxpEW7u2fTG0
a+fE/m/prM5RHWjrQ8cY52/AyASXLXDDlmZn5g5zb1j5wTYQ9iH0iEsU3GLh
mQjvFPimwS8D/lkIzEFQLoLzmT6KEFaM8BJElCKyDFHlUI8mkc2GmErEViG2
GnE1YKviX8yUI6uRbrRBbkJuM/JbUNCKojYUt6O0A+WdqOhEVRdquiHpQV0v
GvrQyGKZtiF0CpHMEwNjGB7D6Dg16KlJzExhfgqL01DM0Bh6hl/Fiul5TE7S
xmG4Df1sRK6DNrrz+Vbr01bGNT813vysQFZ5nvRENxaIOInovWbRJ72ir8d2
7qNDT9+exFFdaBtB5yrO34ahGa5Y44Yj7rpTMcz9YBUo2M6vHaPgEgu3BHgk
wzsNPhnwzYJfDvxzEZiPoAIEFzHAJQgrRXgZIsoRUcFHkRqxtYiV8JFznBRq
j8XXIaEOifVIkiFZhtQGpMmFuPHV7BbktiKvFQVtdLqouAOlnSjvQmU3qnpQ
0wNJH82pYQBNg3RMpn0YnaP0SP84hiYwMoHxSUxOYWYa8zNYnIFillj2LL8u
E9MzmByh4f1QI3Ms/Oz8+ox/rcL0KYEpG/n/NfUcm2gkKnq/XfTpoGj75LaD
1G18q4Oj+tA2hs4NnDeBoQUu2+GmC0y8YOrH6+I5m3DYRcExFs4JcEuGRxq8
MuCdBZ9s+ObCLw/+BQgoRFAx62KW8iPsj4ZXIqIKkdV0i6pBVC2xXQlfwhgp
yKamHltHanBcPeLrkSBDUgOSySZHCus/pjYhrQnpzYI/fjm3DfntKOxAUQdK
OlHWhYpuVLIOfG0fpP2QDUA+iOZhtI2ggzHuG8fgJA1NxqYwOY2ZGczNYnEW
ijnS/58TGM8uYGocE30YIf1UKYsqfpLx8yqxoTKSZ+ObrNe+uUT0Op3KF30x
ItpFbXaPNg7p4qgRtK9C5zbOm8HQGpcdccMdJr7KqMsmCvaxcEyASzLc0uCR
Ac8seGXDOwc+efDLh38hAoqE1BuCyxFSQbfQSqiHkfhvQ3g1wmsQUUs39UiB
cpQUUZRydB3UY+qJCLEyxMlA17E0IJExTmpEciNSmpDaTElntPB+7aWCDjr9
WdyFki4WsfSgshc1fZD0o24QDUNoGkYroTzGKE9QyiQUH5umfnh6FnNzWCR4
NRTz/Dg5te6pIYx1YrAO3YX8bMZzKoT5lS/KXs76zyesXvlJL2V5/JHifq1M
9HaD6O+9dH/fPPnce0pxSB9HjaF1AzomOG8BIztcccFNL+aLg2ERBqsoum+f
AKdkuKTBLQMeWfDMhlcOvPPgkw/fQsGfbAgoRWAZgspZuxBM+j2PBFchhGzV
CK1BGGkQ1cMI+3CBfYQUEZR9JGEfRdg/G12PGBndYhtoFnFyJMiR2AiqgSal
BlroeotsZd/oN5R/N8p6UNFLp/5qByAdhGwIjSNoGUU7g987iYEpDE9jbAYT
s5ieo/CX5qG+rGRPfs+M0cGBoXr00EkTJbc17NeuzP2l5xw2CHpYedpR9FqJ
6J1G0Uf9fL941zHF/jOKQ4b44Qq0b0HHFHpWMHLEVeaw7wXBLBQWkbCOgW2C
QPpRl3S4ZcI9G5458MqDd77wPLJfMfxLEVCGgHIEViCQ9T2DqqAeTCJBjeAa
hJCtluyGko/HQ5kDD5MinGx1iKgDUUVkvaCNKBmi2XhhTANi5SDaiG9EQiMS
m5BEtNGMtBZktCKrDdntQrl+k9+Fwi4Ud6O0B+V9qOxHzQCdIZQNKxUyzhQy
hYFpDM/QgHySoJ/DPNHG0gIp0/KCgjmcScVUH4Yb0Fvyn9OG6rMR6gJ9NkfI
Vu1uLhS92yzaOijaNkV+7tRS7NVVHLqEH65D+y50zKFnCyNnXPWkuZmEwCwc
FtGwjoNtEhxS4MTmk9yy4Z4LjzylPrwL4VMM3xL4lcG/HAEVUA8g7B8LZB3P
wGoEka0GRAHBlD5RAZ3XVies1Z6jXoihJpxj5Ax1I0PdRFEnN9MlXWmtrAPb
juwOYfU2IV3Ug5JehnkANYOQDKF+BPJRNI+hbYJhnqYDWMOk0zPHMM9jYQGL
C1hijBWzU4qpfsVoI/rLeYLU56j69J/jrPr8BEtxXPnv90rvJNqcL3pHLvpk
SLRjmuf1/B59HLqMH27hxD2csYSePYxcaTa3AmASBrNIWMTCOgG2ybBPhWMG
nLMEv/64ZwG8iuBdDJ8S+JTCtxx+FfAnvP0J7w0BjHdANQhyemuNYAlfqhAJ
QqQIlZK2gHib8Hqh/aXgGXUKvpGCV49v4gn/S0or0tqQ3o7MDmR3sqGybhQy
5mX9lHn1ECTDjPkYmsfRNsmYz2BgFsNzlPnUPG04FxextMiAz00rpgcUo00P
nsVXaTsfgvuPn6pQeXqKPaeyKUf0dj2hTfcPL20/peCZv3TsDk7cxxkb6DnR
jK744mYQTMJhFg2LeFglwiYFdmlwzIRzNrNxFl17FMGzGF4l8C6FTxmxd18a
WxPmfpVsq+Jbww0BNQgkWy2CarEhSMJrntCnm5SyV1MPJZGMRhibtwsjhk+1
oPa/I2QP5oCoHhqpHsg+UUNCM5JakNyKVKaGjA5k8WroQWEvSvpQNoCKQaqG
2mHUjUI+juYJtE8xNczS4duROYzP067P3CIWFhWLC3QcdXmaLvVZ6ClStqCq
1P8TWlAdL2NaeFm0MVO0RSr6aICq4MjSttOK3QY4eI1eeMISZ+yg58I04I+b
ITCJhFkszBNgmQSbVNilwyGL9Xvy4FYA90LeGh/zKoV3GXzK4VMBogJfRp/X
rAZRgn81H4v71xDPQ1zMo0QTgRJho22ABOpBxPqJLtRD6vhWj+gjtB5EFUQR
4TIQTUQ28Np8kqqhCXFNiG9GItNBShvSlDrgew9FfSjppwuXKodQPQzJCOrH
IJ9AM6sHXTPom8PgHB2BnFjA9CJmFxXzCwq+xIujjZNtaVDOOfyiBpTeXLX/
r1oLmM95QqSZJnqzRvT3Psr/+yXRGcVuQxy8jh9MBS/ynJEPrgTiZhjuRsM0
jtFPhnUqbDOU9PPhVgj3IngUw7NUeC7Wm9H3UXJ/lHD3qxY2f9bdV/evZfzV
A2iMw6MPlNJdKePPljMF14FsRAsh9UoFEPoNQkTzrwL7Zso+oQVJK+w7kd2F
XBbMU/YDKBtExRBd9iQZRf04GifRwoy/e5ayH5rHKOn0LxL2ijnm8RenB2cG
JWrr2K0qddYf4p/MUnpyNlvxRpXovW5m1YsiHUr1wHV8bwptG5xxEqg8cyUY
NyNwNwam8bifCMsUWKdRsOScYy4IWFcCthgeJVD3JA7lca/yBx6AsPWtgi8j
qu5HkD5CuBKm5BT59KdQCdnHmDYoV2LY1LMEEYv+82qm5ATPlFh0JIvi16fa
gUxCtZsNvvTRNY081cph1IxCOgbZBBoZ0s5Z9MzRqbahBYxRqoJX1Zib6h/r
LmLmsB7DNUxfVDnKRsqfEm0uFr3byTz2ougUdRcUrBm07OjNz3vByJ+3wefv
xsIsAeZJsEyFdToLzbPhmAfnArgWwY1wLYVHGQhZT8bVq0LpJXwYWLKpMbIa
frWULIX7CO/BmbWST7KpBwhGK+iF9TYo5ceDmf+mlGUIkyG8gVGWC1GJgLiF
bokEcTtFnNElIM7vQyFBPIjyIVSOoGYMdeNomETzNPMYc+idx8ACnSciPycX
6PD0xFhrX0vamrflrM/2JZWjjDWbp3y7lX4eWhSdVOzSx4GrOGL6gK2hPy6H
4mYU7/ues2QRnm0W7HOUYIvhVgL3UriXUbbkrGcFCFivSnhXCc8u+taAAOU3
wSvzZksDEH+hx8PDVWN0aWUn34FsYzX/jwRwcD1+xFZO2UaxFjGmGbHNiGtB
QisS25BM2HZStlk9AtuiAZQM0cWkVaOQjKN+Eo0MbMccuucFK3hkZBFj83RQ
Y2iAeQLVuYYn1iWr+jY/RpZGrqLP6ByvSFuxSw/fXMERExy3offU9YJBAMV6
PQq343AvEeapPN9n7XPhmA/nwh9hpUzL4alkSmzVh9hqDY9pA0WpwcOkKNX9
hfiC/+3Pj0NtYFR5mw1kVsr8wsvrIG1chZTZakIbktqR0sGQMlvN6UN+P13o
XDqMilFqq9IJNEzxMjxKDLV/gfgC6lWHJ/u7O4tULVKVK8/x94JHZWPWzNpE
xxU7dfGNMQ7fwTEreudzXrgQgEuhuBaFW3EwSYQZm2+xyoJNjvBEuGsp3Fa4
0RpOsJH2iVHzof1sgo6t6SPkNPwEWn6raWn4C5ExPSQFYcei0kDGsE6o94Sf
OsGn9mIIodfwgB45Fd0kWGM8b40dSO1EOhsJye5FXj8KBlE8hLIRVI1BMiFE
Ma2zINbI1/T+OVrB+0ba1sS+69b2Ne+sZKtzXxRtoo+kiY4u7TiLvRdx8BaO
WNBC6HhCzx8XQ3ElCjdicScRpikPKNrlwaEATkVwKWH9BNKvqIRXFbyrBYK+
rDknn+q+fH3eQOg9sQKOYKMOklDToLB+S1nVr6q8hJUcEY0CK97M4loR34bE
dsaqCxms2ub2I39QaPmfqGNNTfMsCKZOUmnn0DNLq6qsMeMhGb26HqOXRe93
8vrcaYh9N/CtGYtE3aHrD8MQGEfiWixuJcCEAbLMgvUqQM7FlBGxN3LKvRwe
wvgv9XeEDL9RK+NXDPsxNvynup9kpdYq2xBGjzc35gXVKb3ng5i9CQBlCOXp
rVhaM2JaBIAJ7Uhi9HhiTxUOoXgEZWOomoCE0ZPPoGUWbRSgonN6rmOs55lf
IMc/n/qH9ci9Sk1LvMTD++YezV/sCh0fXAjBpQhcicGNeNxhq33NM2GVA9s8
2BfAsQhOxXAuocddy+BWDvcKeCgNTJ2Y16NKPo+t4FrZoZ9CCyJRtiDq/g9Y
+kuVLUhAHQLZxnxdPR1vkyFklfmxMF/tmXRmajn9yBtEwRB9gKN0FBXjqGHE
ZDNo4qHNLK83qqsa1/C8/kXwZIzTBtG7dLG9SAfbL/N+7eWT3tANglEEjKNx
LQ63ktiIYgYssmGdB7sCOBTBsRhOayB5MkjeNcyPkYiQ7NSyWqhsUem/JwV+
qlzYkxgvRbDZtKhmRLcgphVxpNZ1ILkLaYxDVj9yBpA/hMIRlIyinI1I1U6h
fgYNDEXzJB2TXvNMj2rMzHP4k8pRNsPARj1+WNymhx03sc9cmAf57Y1ENqKX
jvtZsCTGkv8jCC4/huBVLXBYgaC2QkGwGLb+6TG+OtFNaQuBtHdN7eFlag8N
CJMjnFWlyCasUIltQ3wHkrqQwtq7zD5kDyBvCAUjKB5FGaNCDEQ6jfpp0vDR
eetfPxQR1ff0sqvYe11OY/sl7GTV6Hs3nPCFbggMI3E5Fq8I+qT6UycCMfv+
4wOByE49qINYI09kM6JaEK2UJ5GNEKT2IqMPWQPIHUL+CIrGUMrkqZpCzSQk
rIO65lki1b4kL82/rScNHU3fdk6x4zp2WdK8fvDEqQDohcMoGlficZN5hHuZ
MM+BVR5sCmBfBIdiOCr17FoOtwq4r+iZKZk3+Qd69lW6hR95A1XvsJ63YP2j
3wvQZBRa6CpoEQxaJA+tHXEdSGDQUnqR3ofMAWQPIY9BIwfLJlAxueqtmarP
Xq3h9e+CX2Cj3f8iOjSz7bxixy3FHja7e9wXZ0KgH4mLsbiaiFssrjHLhnku
rPJhW8g4lcCRtTYu5XCtgFslPKrgWa3KiX9PHGHkt6p1eXyFyeqGiHzS1Bv8
mc9k9YT8JJ/MOz4V3oQIJY8YxoMcTexGci/S+pHBeLDWRoMYUdnILJS9tlWy
q47m8Sz+rHKUeZTfi47MbtNX7LxNY8fDHtDyx9kwXIjCpThcY4ZjkgnCxIIw
KYBtEeyLKRNy3LkMPBN3xoQAYa2g+op/9F0R+omV9sV/pQ/HYhZedtJ+0EdL
AuqVFtIA9RDhoYYw5jxZd1/tkTw2RVg4hsJRFA7NrXkT+fpyq77xmsn9G9H3
s9sMFLvvMLk9oRWAs+HQj8bFeFxlct8lcufAIg/WK3KXCnLzUS+1ghq68VbA
S07PbKBxiAS8/Kvj3RVLIEeJV/Hno1wNKv3viOiBMgQ1UOmD2RhBaCNCmxDW
jPAWRLYiuh0xzBgSupHYi+Q+pBJ7GETWMIvcRpA7jKy+KdW4VJUJ6wnw7wJW
YcLK/vRORuQQIRKIsxHQj6FErjAidzJhyhMpFCKeR53L4VIB10paMdxZxVD3
4muDhg+zgVoBA/EitG1c5SVYPObH7IF+qvvxNNSe9FfG+wE8EtkDJCGNUCdM
1J4VqLRRKuR4XBfieyiVpD6kDCCNrcHKHELmIBWGj6YeWZEW/NwCH6P+VfAQ
1JM+w7RnVQjbYtiVwF4YaXvUeZWIHtVUSn7VgQ+LAHyUxk61zOtdcAQblKom
mqZSqROJaCL1YOL6ngtpQmgzQlsQ3oqINhaZdyK2G3E9iO9FQh+S2FKP1AGi
azpS/EfWLKxIoVwnwL/Det03whwZE12nAPa744cA6ETgfAwM42HMtHk7EyY5
uJ8PywJYF8G2hIrswPpwRF5Bq2wCg4pM7ZuaugaxdG8+8GFRj6+Ur6dESF6L
pI/mX09aTBlfS54NakRwE0KYoGGtrJnsQFQnYroR24O4XsSx1RYJvYrYrkW+
tV5HRtW3wLM6zN4pZrS0zZzVYT9oh+JcNC7E41Ky0Ao9RiQ0zYN5AayKYKNU
Kq+Xx3n53KupSj1qqIh8Xd5A5FP3EdRHvn2YPjVWJK2DH9WlXz3fpw1ooGNT
cgQ28v1++vFEeDsiOhDZhahuRLM4L6ZXEdXFYvd/XyXLAzv8P+u17EzCO1T5
B7xxLBg6UTgfB6MkXElTjqDcy4VZPiwKYV1MdcjHdo+6VlHZ3KqpeFSDpOdI
5FP3oqZKxPMWvBD5Vvch9c5XeLTPr16oeup+MqJHOgjsL0dAIwKb6Ea98F+E
+sKXmsOquJuV1pIq47sAaIfjbCz0E3AxBVfThdI+YZIn3ICWthR2ZbAvg0M5
HCv46qNOiqz2qHsNVYhHLTzJxoq6wUvC94w1fOrhSzYZjUtktOI1wE8O/0b+
DuoBLXSesxVBbQjuQAgLJfzb2IL1v/6o5BtVeCvfrq32yOFAaEfgbBz0k3Ax
Vbm28E4u7uXjfiEsi2Fdoix8ORwq4FjJew4NUlZPKd1IXanjVeFdD7rJ4N0A
H2Fc8gnfJvg2w6+Fbv6t8GOV36ORWcffhFLybdcmlVJSzrzv0UuEQQoupQnW
/IxZEcyLYVkC61LYlMGODbc6VNLCOZGtCs5kq4YL8dCuNbxQbrVwo57YnViB
uxQaHnU840e85PBqhFcT3TyalBGdrYQu0qCloB5nZZ3Smnf0r4wmPXY4FCdi
cC4BeskwTINxBq5lC+V92pwtPbIshVUZrMtgUw67CthXwr4KDlVwJBs/h6Th
REvrVAtnCd0YVHVXqnnXBjg3wEnGC0PLtEG5rof9xRPlXAG732PHo3EmEfqp
MEqHcRau5uBmHv+qGw07Uis22ElgL4WdFLb8+Od/CPnxzwG/oSKjasTF7vGc
dhzOsJ6lUSYuZeNyDq7m4loebuTjZgFuF+JOMUxKcK8UpszPqt+vgIZ5JdTN
iZ/VuF8F00pe5lX359+58eY6jFX7Pix+fOx8BvQzcSELhjm4mItLeTDO52Pw
/yNojf+7D2+p5PBbld+fCPfn30G6ReCpmupDIRX/rtp31vNhq36/J6Tm3+T/
7no+fdXvLULqv7LUqn/BQXUFxutCauZH2V+CUl9nncZGIRX/F2X+rnL2aZXf
fxNSM+0zWX9ujvyvAl/+Lxd9JJRANdX/FPJk8qz5Cw+q491/ElKzezOd/Nyo
7qtCapZO7R8qZ1VHmn4npP6cpf5UKK9qqt8Iqf7JUn2ucna9t+fT1NtZ6i9U
zqr20Z4WiO1mqb9UObteNE/z3sdSf4UHTzip1gSa6iBL9fWqs8eFx3fo2cPs
LP0bMzQs/IH9Uvsf/xdrkbdk\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->112451805]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26532],

Cell["Compose with inverse functions:", "ExampleText",
 CellID->60474188],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiCN", "[", 
    RowBox[{
     RowBox[{"InverseJacobiCN", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], ",", 
   RowBox[{"InverseJacobiCN", "[", 
    RowBox[{
     RowBox[{"JacobiCN", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10346836],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", 
   RowBox[{"InverseJacobiCN", "[", 
    RowBox[{
     RowBox[{"JacobiCN", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}]}], "}"}]], "Output",
 ImageSize->{269, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->325933589]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " to disregard multivaluedness of the inverse function:"
}], "ExampleText",
 CellID->785308763],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->261361129],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", "z"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->637344735]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1057110923],

Cell[TextData[{
 "Evaluate as a result of applying ",
 Cell[BoxData[
  ButtonBox["Cos",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cos"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["JacobiAmplitude",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiAmplitude"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->75877325],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cos", "[", 
  RowBox[{"JacobiAmplitude", "[", 
   RowBox[{"z", ",", "m"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->183159778],

Cell[BoxData[
 RowBox[{"JacobiCN", "[", 
  RowBox[{"z", ",", "m"}], "]"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->320052567]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26733726],

Cell["Solve a transcendental equation:", "ExampleText",
 CellID->359994467],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"JacobiCN", "[", 
       RowBox[{"x", ",", "m"}], "]"}], "2"], "+", 
     RowBox[{"2", 
      RowBox[{"JacobiCN", "[", 
       RowBox[{"x", ",", "m"}], "]"}]}]}], "\[Equal]", "a"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->68486567],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->294415501],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"InverseJacobiCN", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], "-", 
        SqrtBox[
         RowBox[{"1", "+", "a"}]]}], ",", "m"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"InverseJacobiCN", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SqrtBox[
         RowBox[{"1", "+", "a"}]]}], ",", "m"}], "]"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{520, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->374393636]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->152043587],

Cell["Integrals:", "ExampleText",
 CellID->492528614],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"JacobiCN", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", " ", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->38096870],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"ArcCos", "[", 
    RowBox[{"JacobiDN", "[", 
     RowBox[{"z", ",", "m"}], "]"}], "]"}], " ", 
   RowBox[{"JacobiSN", "[", 
    RowBox[{"z", ",", "m"}], "]"}]}], 
  SqrtBox[
   RowBox[{"1", "-", 
    SuperscriptBox[
     RowBox[{"JacobiDN", "[", 
      RowBox[{"z", ",", "m"}], "]"}], "2"]}]]]], "Output",
 ImageSize->{258, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->53497402]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"JacobiCN", "[", 
     RowBox[{"z", ",", "m"}], "]"}], "^", "3"}], ",", " ", "z"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->85410578],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"JacobiDN", "[", 
      RowBox[{"z", ",", "m"}], "]"}], "+", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{"2", " ", "m"}]}], ")"}], " ", 
       RowBox[{"ArcCos", "[", 
        RowBox[{"JacobiDN", "[", 
         RowBox[{"z", ",", "m"}], "]"}], "]"}]}], 
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox[
         RowBox[{"JacobiDN", "[", 
          RowBox[{"z", ",", "m"}], "]"}], "2"]}]]]}], ")"}], " ", 
   RowBox[{"JacobiSN", "[", 
    RowBox[{"z", ",", "m"}], "]"}]}], 
  RowBox[{"2", " ", "m"}]]], "Output",
 ImageSize->{379, 55},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->401108972]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20728],

Cell["\<\
Machine-precision input is insufficient to give the correct answer:\
\>", "ExampleText",
 CellID->185729643],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiCN", "[", 
  RowBox[{
   RowBox[{"10.", "^", "20"}], ",", "E"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->286079947],

Cell[BoxData[
 RowBox[{"1.`", "\[InvisibleSpace]", "+", 
  RowBox[{"1.2874900798265365`*^-17", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18162427]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"JacobiCN", "[", 
    RowBox[{
     RowBox[{"10", "^", "20"}], ",", "E"}], "]"}], ",", "20"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->57974428],

Cell[BoxData[
 RowBox[{"0.80608758429307731217662480851447232483`20.15051499783199", "+", 
  RowBox[{"0``20.244132765817643", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{237, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->267145158]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->51763701],

Cell["\<\
Currently only simple simplification rules are built in for Jacobi functions:\
\
\>", "ExampleText",
 CellID->350342914],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"JacobiSN", "[", 
     RowBox[{"z", ",", "m"}], "]"}], "^", "2"}], "+", 
   RowBox[{
    RowBox[{"JacobiCN", "[", 
     RowBox[{"z", ",", "m"}], "]"}], "^", "2"}], "-", "1"}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->307497241],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  SuperscriptBox[
   RowBox[{"JacobiCN", "[", 
    RowBox[{"z", ",", "m"}], "]"}], "2"], "+", 
  SuperscriptBox[
   RowBox[{"JacobiSN", "[", 
    RowBox[{"z", ",", "m"}], "]"}], "2"]}]], "Output",
 ImageSize->{246, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->288079688]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"JacobiCN", "[", 
    RowBox[{"u", ",", "m"}], "]"}], 
   RowBox[{"JacobiND", "[", 
    RowBox[{"u", ",", "m"}], "]"}], 
   RowBox[{"JacobiDC", "[", 
    RowBox[{"u", ",", "m"}], "]"}]}], "//", "FullSimplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15030758],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->135763994]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19291],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseJacobiCN",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseJacobiCN"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiCS",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiCS"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiCD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiCD"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiSC",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiSC"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27623]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19052],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "Tutorials",
 CellID->2360]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->42532639],

Cell[TextData[ButtonBox["Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticFunctions"]], "MoreAbout",
 CellID->182819087]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"JacobiCN - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 51, 26.4032818}", "context" -> "System`", 
    "keywords" -> {
     "cn", "cnoid", "doubly periodic function", "elliptic Jacobi function", 
      "Jacobi elliptic function cn"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "JacobiCN[u, m] gives the Jacobi elliptic function cn(u | m).", 
    "synonyms" -> {"Jacobi CN"}, "title" -> "JacobiCN", "type" -> "Symbol", 
    "uri" -> "ref/JacobiCN"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6326, 223, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->389420242]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 123766, 3175}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2123, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2746, 79, 46, 1, 70, "ObjectName",
 CellID->31448],
Cell[2795, 82, 710, 23, 70, "Usage",
 CellID->18764]
}, Open  ]],
Cell[CellGroupData[{
Cell[3542, 110, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4020, 127, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4143, 133, 421, 16, 70, "Notes",
 CellID->294558602],
Cell[4567, 151, 831, 30, 70, "Notes",
 CellID->17328219],
Cell[5401, 183, 214, 7, 70, "Notes",
 CellID->8656038],
Cell[5618, 192, 246, 8, 70, "Notes",
 CellID->9797447],
Cell[5867, 202, 218, 7, 70, "Notes",
 CellID->31226],
Cell[6088, 211, 201, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6326, 223, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->389420242],
Cell[CellGroupData[{
Cell[6711, 237, 147, 5, 70, "ExampleSection",
 CellID->73357939],
Cell[6861, 244, 64, 1, 70, "ExampleText",
 CellID->814676922],
Cell[CellGroupData[{
Cell[6950, 249, 130, 4, 28, "Input",
 CellID->27188654],
Cell[7083, 255, 193, 6, 36, "Output",
 CellID->245118267]
}, Open  ]],
Cell[7291, 264, 125, 3, 70, "ExampleDelimiter",
 CellID->191905672],
Cell[CellGroupData[{
Cell[7441, 271, 291, 10, 28, "Input",
 CellID->12000150],
Cell[7735, 283, 3929, 68, 136, "Output",
 Evaluatable->False,
 CellID->461333708]
}, Open  ]],
Cell[11679, 354, 125, 3, 70, "ExampleDelimiter",
 CellID->390091798],
Cell[11807, 359, 77, 1, 70, "ExampleText",
 CellID->38477304],
Cell[CellGroupData[{
Cell[11909, 364, 245, 8, 70, "Input",
 CellID->200709323],
Cell[12157, 374, 1055, 34, 54, "Output",
 CellID->465919806]
}, Open  ]],
Cell[CellGroupData[{
Cell[13249, 413, 245, 8, 70, "Input",
 CellID->260356113],
Cell[13497, 423, 933, 28, 51, "Output",
 CellID->597965661]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14479, 457, 216, 7, 70, "ExampleSection",
 CellID->32127],
Cell[14698, 466, 74, 1, 70, "ExampleText",
 CellID->257841689],
Cell[CellGroupData[{
Cell[14797, 471, 177, 6, 70, "Input",
 CellID->325910105],
Cell[14977, 479, 275, 7, 36, "Output",
 CellID->330130693]
}, Open  ]],
Cell[15267, 489, 124, 3, 70, "ExampleDelimiter",
 CellID->25415347],
Cell[15394, 494, 70, 1, 70, "ExampleText",
 CellID->856906711],
Cell[CellGroupData[{
Cell[15489, 499, 207, 7, 70, "Input",
 CellID->69210409],
Cell[15699, 508, 253, 8, 36, "Output",
 CellID->577803752]
}, Open  ]],
Cell[15967, 519, 125, 3, 70, "ExampleDelimiter",
 CellID->200525529],
Cell[16095, 524, 113, 3, 70, "ExampleText",
 CellID->372977787],
Cell[CellGroupData[{
Cell[16233, 531, 171, 5, 70, "Input",
 CellID->2714330],
Cell[16407, 538, 257, 8, 36, "Output",
 CellID->88897454]
}, Open  ]],
Cell[16679, 549, 125, 3, 70, "ExampleDelimiter",
 CellID->182528140],
Cell[16807, 554, 210, 7, 70, "ExampleText",
 CellID->747487832],
Cell[CellGroupData[{
Cell[17042, 565, 178, 6, 70, "Input",
 CellID->536864854],
Cell[17223, 573, 327, 11, 36, "Output",
 CellID->28615096]
}, Open  ]],
Cell[17565, 587, 125, 3, 70, "ExampleDelimiter",
 CellID->259414736],
Cell[17693, 592, 90, 1, 70, "ExampleText",
 CellID->18087730],
Cell[CellGroupData[{
Cell[17808, 597, 237, 8, 70, "Input",
 CellID->365032203],
Cell[18048, 607, 266, 9, 36, "Output",
 CellID->73416409]
}, Open  ]],
Cell[CellGroupData[{
Cell[18351, 621, 420, 15, 70, "Input",
 CellID->175336906],
Cell[18774, 638, 424, 16, 65, "Output",
 CellID->70631779]
}, Open  ]],
Cell[19213, 657, 126, 3, 70, "ExampleText",
 CellID->336727663],
Cell[CellGroupData[{
Cell[19364, 664, 146, 5, 70, "Input",
 CellID->614178488],
Cell[19513, 671, 215, 7, 36, "Output",
 CellID->50207533]
}, Open  ]],
Cell[CellGroupData[{
Cell[19765, 683, 321, 10, 70, "Input",
 CellID->674473773],
Cell[20089, 695, 216, 7, 36, "Output",
 CellID->578596852]
}, Open  ]],
Cell[20320, 705, 125, 3, 70, "ExampleDelimiter",
 CellID->215688415],
Cell[20448, 710, 203, 7, 70, "ExampleText",
 CellID->178560258],
Cell[CellGroupData[{
Cell[20676, 721, 166, 5, 70, "Input",
 CellID->292152639],
Cell[20845, 728, 277, 9, 50, "Output",
 CellID->79574470]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21171, 743, 239, 7, 70, "ExampleSection",
 CellID->30795],
Cell[21413, 752, 209, 7, 70, "ExampleText",
 CellID->541124796],
Cell[CellGroupData[{
Cell[21647, 763, 243, 8, 70, "Input",
 CellID->271512446],
Cell[21893, 773, 1379, 44, 54, "Output",
 CellID->67226296]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23321, 823, 222, 7, 70, "ExampleSection",
 CellID->6852],
Cell[23546, 832, 79, 1, 70, "ExampleText",
 CellID->10412801],
Cell[23628, 835, 1571, 46, 70, "Input",
 CellID->459924020],
Cell[25202, 883, 75, 1, 70, "ExampleText",
 CellID->584973588],
Cell[CellGroupData[{
Cell[25302, 888, 966, 32, 70, "Input",
 CellID->257691509],
Cell[26271, 922, 175, 5, 36, "Output",
 CellID->9656815]
}, Open  ]],
Cell[26461, 930, 61, 1, 70, "ExampleText",
 CellID->488141566],
Cell[CellGroupData[{
Cell[26547, 935, 594, 19, 70, "Input",
 CellID->797754078],
Cell[27144, 956, 14514, 242, 70, "Output",
 Evaluatable->False,
 CellID->24796614]
}, Open  ]],
Cell[41673, 1201, 125, 3, 70, "ExampleDelimiter",
 CellID->228220110],
Cell[41801, 1206, 95, 1, 70, "ExampleText",
 CellID->223864426],
Cell[41899, 1209, 1760, 56, 70, "Input",
 CellID->16049754],
Cell[43662, 1267, 79, 1, 70, "ExampleText",
 CellID->84846121],
Cell[43744, 1270, 1417, 45, 70, "Input",
 CellID->272616709],
Cell[CellGroupData[{
Cell[45186, 1319, 868, 28, 70, "Input",
 CellID->126582686],
Cell[46057, 1349, 8671, 146, 70, "Output",
 Evaluatable->False,
 CellID->228573801]
}, Open  ]],
Cell[54743, 1498, 125, 3, 70, "ExampleDelimiter",
 CellID->598905019],
Cell[54871, 1503, 488, 16, 70, "ExampleText",
 CellID->68991450],
Cell[55362, 1521, 566, 22, 70, "Input",
 CellID->587523086],
Cell[55931, 1545, 64, 1, 70, "ExampleText",
 CellID->1296360],
Cell[CellGroupData[{
Cell[56020, 1550, 462, 15, 70, "Input",
 CellID->520336049],
Cell[56485, 1567, 19301, 320, 70, "Output",
 Evaluatable->False,
 CellID->413058674]
}, Open  ]],
Cell[75801, 1890, 125, 3, 70, "ExampleDelimiter",
 CellID->374689701],
Cell[75929, 1895, 82, 1, 70, "ExampleText",
 CellID->431447185],
Cell[76014, 1898, 1092, 37, 70, "Input",
 CellID->434656425],
Cell[77109, 1937, 116, 3, 70, "ExampleText",
 CellID->199645768],
Cell[CellGroupData[{
Cell[77250, 1944, 1106, 35, 70, "Input",
 CellID->504511624],
Cell[78359, 1981, 3782, 66, 70, "Output",
 Evaluatable->False,
 CellID->126374219]
}, Open  ]],
Cell[82156, 2050, 125, 3, 70, "ExampleDelimiter",
 CellID->852495579],
Cell[82284, 2055, 69, 1, 70, "ExampleText",
 CellID->46361833],
Cell[82356, 2058, 1756, 58, 70, "Input",
 CellID->385040697],
Cell[84115, 2118, 94, 1, 70, "ExampleText",
 CellID->50816325],
Cell[CellGroupData[{
Cell[84234, 2123, 530, 18, 70, "Input",
 CellID->760118834],
Cell[84767, 2143, 391, 13, 36, "Output",
 CellID->943541092]
}, Open  ]],
Cell[CellGroupData[{
Cell[85195, 2161, 529, 18, 70, "Input",
 CellID->69019748],
Cell[85727, 2181, 391, 13, 36, "Output",
 CellID->571997565]
}, Open  ]],
Cell[CellGroupData[{
Cell[86155, 2199, 530, 18, 70, "Input",
 CellID->371259714],
Cell[86688, 2219, 390, 13, 36, "Output",
 CellID->46107172]
}, Open  ]],
Cell[87093, 2235, 125, 3, 70, "ExampleDelimiter",
 CellID->112142597],
Cell[87221, 2240, 172, 4, 70, "ExampleText",
 CellID->220319908],
Cell[87396, 2246, 1003, 33, 70, "Input",
 CellID->92049699],
Cell[88402, 2281, 68, 1, 70, "ExampleText",
 CellID->24027191],
Cell[CellGroupData[{
Cell[88495, 2286, 827, 26, 70, "Input",
 CellID->30295536],
Cell[89325, 2314, 21709, 360, 70, "Output",
 Evaluatable->False,
 CellID->112451805]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[111083, 2680, 233, 7, 70, "ExampleSection",
 CellID->26532],
Cell[111319, 2689, 73, 1, 70, "ExampleText",
 CellID->60474188],
Cell[CellGroupData[{
Cell[111417, 2694, 380, 12, 70, "Input",
 CellID->10346836],
Cell[111800, 2708, 337, 11, 36, "Output",
 CellID->325933589]
}, Open  ]],
Cell[112152, 2722, 246, 8, 70, "ExampleText",
 CellID->785308763],
Cell[CellGroupData[{
Cell[112423, 2734, 107, 3, 70, "Input",
 CellID->261361129],
Cell[112533, 2739, 203, 7, 36, "Output",
 CellID->637344735]
}, Open  ]],
Cell[112751, 2749, 126, 3, 70, "ExampleDelimiter",
 CellID->1057110923],
Cell[112880, 2754, 347, 13, 70, "ExampleText",
 CellID->75877325],
Cell[CellGroupData[{
Cell[113252, 2771, 165, 5, 70, "Input",
 CellID->183159778],
Cell[113420, 2778, 216, 7, 36, "Output",
 CellID->320052567]
}, Open  ]],
Cell[113651, 2788, 124, 3, 70, "ExampleDelimiter",
 CellID->26733726],
Cell[113778, 2793, 75, 1, 70, "ExampleText",
 CellID->359994467],
Cell[CellGroupData[{
Cell[113878, 2798, 364, 13, 70, "Input",
 CellID->68486567],
Cell[114245, 2813, 453, 8, 70, "Message",
 CellID->294415501],
Cell[114701, 2823, 661, 24, 43, "Output",
 CellID->374393636]
}, Open  ]],
Cell[115377, 2850, 125, 3, 70, "ExampleDelimiter",
 CellID->152043587],
Cell[115505, 2855, 53, 1, 70, "ExampleText",
 CellID->492528614],
Cell[CellGroupData[{
Cell[115583, 2860, 193, 6, 70, "Input",
 CellID->38096870],
Cell[115779, 2868, 486, 17, 62, "Output",
 CellID->53497402]
}, Open  ]],
Cell[CellGroupData[{
Cell[116302, 2890, 222, 8, 70, "Input",
 CellID->85410578],
Cell[116527, 2900, 819, 28, 76, "Output",
 CellID->401108972]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[117395, 2934, 226, 7, 70, "ExampleSection",
 CellID->20728],
Cell[117624, 2943, 118, 3, 70, "ExampleText",
 CellID->185729643],
Cell[CellGroupData[{
Cell[117767, 2950, 154, 5, 70, "Input",
 CellID->286079947],
Cell[117924, 2957, 261, 7, 36, "Output",
 CellID->18162427]
}, Open  ]],
Cell[CellGroupData[{
Cell[118222, 2969, 212, 8, 70, "Input",
 CellID->57974428],
Cell[118437, 2979, 293, 7, 36, "Output",
 CellID->267145158]
}, Open  ]],
Cell[118745, 2989, 124, 3, 70, "ExampleDelimiter",
 CellID->51763701],
Cell[118872, 2994, 130, 4, 70, "ExampleText",
 CellID->350342914],
Cell[CellGroupData[{
Cell[119027, 3002, 314, 11, 70, "Input",
 CellID->307497241],
Cell[119344, 3015, 379, 13, 36, "Output",
 CellID->288079688]
}, Open  ]],
Cell[CellGroupData[{
Cell[119760, 3033, 309, 10, 70, "Input",
 CellID->15030758],
Cell[120072, 3045, 158, 5, 36, "Output",
 CellID->135763994]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[120291, 3057, 311, 9, 70, "SeeAlsoSection",
 CellID->19291],
Cell[120605, 3068, 955, 35, 70, "SeeAlso",
 CellID->27623]
}, Open  ]],
Cell[CellGroupData[{
Cell[121597, 3108, 314, 9, 70, "TutorialsSection",
 CellID->19052],
Cell[121914, 3119, 191, 4, 70, "Tutorials",
 CellID->2360]
}, Open  ]],
Cell[CellGroupData[{
Cell[122142, 3128, 318, 9, 70, "MoreAboutSection",
 CellID->42532639],
Cell[122463, 3139, 147, 3, 70, "MoreAbout",
 CellID->182819087]
}, Open  ]],
Cell[122625, 3145, 27, 0, 70, "History"],
Cell[122655, 3147, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

