(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    167250,       3966]
NotebookOptionsPosition[    156683,       3594]
NotebookOutlinePosition[    157988,       3632]
CellTagsIndexPosition[    157901,       3627]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals and Elliptic Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals and Elliptic Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"InverseJacobiCS" :> 
          Documentation`HelpLookup["paclet:ref/InverseJacobiCS"], "JacobiCN" :> 
          Documentation`HelpLookup["paclet:ref/JacobiCN"], "JacobiCD" :> 
          Documentation`HelpLookup["paclet:ref/JacobiCD"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"InverseJacobiCS\"\>", 
       2->"\<\"JacobiCN\"\>", 3->"\<\"JacobiCD\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Functions" :> 
          Documentation`HelpLookup["paclet:guide/EllipticFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Elliptic Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["JacobiCS", "ObjectName",
 CellID->10512],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["JacobiCS",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/JacobiCS"], "[", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Jacobi elliptic function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"cs", "(", 
        RowBox[{"u", "|", "m"}], ")"}], TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29706]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"cs", "(", "u", ")"}], "=", 
    RowBox[{"cot", "(", "\[Phi]", ")"}]}], TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Phi]", "=", 
    RowBox[{"am", "(", 
     RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->4365],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"cs", "(", 
    RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " is a doubly periodic function in ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " with periods ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", " ", 
    RowBox[{"K", "(", "m", ")"}]}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"4", " ", "\[ImaginaryI]", " ", 
    RowBox[{"K", "(", 
     RowBox[{"1", "-", "m"}], ")"}]}], TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox["K", TraditionalForm]], "InlineMath"],
 " is the elliptic integral ",
 Cell[BoxData[
  ButtonBox["EllipticK",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticK"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->287578035],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiCS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiCS"]], "InlineFormula"],
 " is a meromorphic function in both arguments."
}], "Notes",
 CellID->99960195],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["JacobiCS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiCS"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->216313340],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiCS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiCS"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiCS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiCS"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->621835333],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->42455164],

Cell["Evaluate numerically:", "ExampleText",
 CellID->400288940],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiCS", "[", 
  RowBox[{"0.2", ",", "0.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->77957898],

Cell[BoxData["4.949949500079164`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->729537414]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->470866374],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"JacobiCS", "[", 
    RowBox[{"u", ",", 
     RowBox[{"1", "/", "3"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{"-", "6"}], ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->175933317],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7937784]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->137230538],

Cell["Series expansions:", "ExampleText",
 CellID->55901019],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"JacobiCS", "[", 
    RowBox[{"u", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->461811558],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", "u"], "+", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "+", "m"}], ")"}], " ", "u"}], "+", 
   RowBox[{
    FractionBox["1", "360"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "8"}], "+", 
      RowBox[{"8", " ", "m"}], "+", 
      RowBox[{"7", " ", 
       SuperscriptBox["m", "2"]}]}], ")"}], " ", 
    SuperscriptBox["u", "3"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "u", "]"}], "5"],
    SeriesData[$CellContext`u, 0, {}, -1, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`u, 0, {
   1, 0, Rational[1, 6] (-2 + $CellContext`m), 0, 
    Rational[1, 360] (-8 + 8 $CellContext`m + 7 $CellContext`m^2)}, -1, 5, 1],
  
  Editable->False]], "Output",
 ImageSize->{296, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->169667]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"JacobiCS", "[", 
    RowBox[{"u", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->240753544],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"Cot", "[", "u", "]"}], "+", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "u"}], "+", 
      RowBox[{"2", " ", "u", " ", 
       SuperscriptBox[
        RowBox[{"Cot", "[", "u", "]"}], "2"]}], "-", 
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "u"}], "]"}], "-", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"Cot", "[", "u", "]"}], "2"], " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "u"}], "]"}]}]}], ")"}], " ", "m"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "m", "]"}], "2"],
    SeriesData[$CellContext`m, 0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`m, 0, {
    Cot[$CellContext`u], 
    Rational[1, 8] (2 $CellContext`u + 2 $CellContext`u Cot[$CellContext`u]^2 - 
     Sin[2 $CellContext`u] - Cot[$CellContext`u]^2 Sin[2 $CellContext`u])}, 0,
    2, 1],
  Editable->False]], "Output",
 ImageSize->{420, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1103233]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13835],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->136651426],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiCS", "[", 
  RowBox[{
   RowBox[{"5.2", "-", 
    RowBox[{"2.5", "I"}]}], ",", 
   RowBox[{"0.3", "+", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->374527875],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.40266756108962554`"}], "-", 
  RowBox[{"1.2141224294753756`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{141, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->210289191]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->525378932],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->239493914],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"JacobiCS", "[", 
    RowBox[{
     RowBox[{"Pi", "/", "3"}], ",", 
     RowBox[{"1", "/", "3"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18845098],

Cell[BoxData["0.\
6474463502940618119577644828424467670563161541051633176376847482098`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->97372085]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->550009612],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->864577637],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiCS", "[", 
  RowBox[{
   RowBox[{"Pi", "/", "3"}], ",", "0.3333333333333333333333333333333333"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->446034805],

Cell[BoxData["0.647446350294061811957764482842446767056316154104`32.\
78156591015722"], "Output",
 ImageSize->{242, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->556301836]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->128417124],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiCS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiCS"]], "InlineFormula"],
 " threads element\[Hyphen]wise over lists:"
}], "ExampleText",
 CellID->97071841],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiCS", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->815460718],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiCS", "[", 
    RowBox[{"1", ",", "m"}], "]"}], ",", 
   RowBox[{"JacobiCS", "[", 
    RowBox[{"2", ",", "m"}], "]"}]}], "}"}]], "Output",
 ImageSize->{220, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->527450587]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6259999],

Cell["Simple exact results are generated automatically:", "ExampleText",
 CellID->495463307],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiCS", "[", 
    RowBox[{"z", ",", "0"}], "]"}], ",", 
   RowBox[{"JacobiCS", "[", 
    RowBox[{"z", ",", "1"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->65054936],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Cot", "[", "z", "]"}], ",", 
   RowBox[{"Csch", "[", "z", "]"}]}], "}"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->33306841]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiCS", "[", 
    RowBox[{"0", ",", "m"}], "]"}], ",", 
   RowBox[{"JacobiCS", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"EllipticK", "[", "m", "]"}], "/", "2"}], ",", "m"}], "]"}], 
   ",", 
   RowBox[{"JacobiCS", "[", 
    RowBox[{
     RowBox[{"EllipticK", "[", "m", "]"}], ",", "m"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->366415397],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"ComplexInfinity", ",", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", "m"}], ")"}], 
    RowBox[{"1", "/", "4"}]], ",", "0"}], "}"}]], "Output",
 ImageSize->{209, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->399542165]
}, Open  ]],

Cell["\<\
Parity transformation and periodicity relations are automatically applied:\
\>", "ExampleText",
 CellID->26118627],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiCS", "[", 
  RowBox[{
   RowBox[{"-", "u"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->74535809],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"JacobiCS", "[", 
   RowBox[{"u", ",", "m"}], "]"}]}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->157489238]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiCS", "[", 
  RowBox[{
   RowBox[{"u", "+", 
    RowBox[{"2", " ", 
     RowBox[{"EllipticK", "[", "m", "]"}]}], "+", 
    RowBox[{"4", "I", " ", 
     RowBox[{"EllipticK", "[", 
      RowBox[{"1", "-", "m"}], "]"}]}]}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->67735372],

Cell[BoxData[
 RowBox[{"JacobiCS", "[", 
  RowBox[{"u", ",", "m"}], "]"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->126172108]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->263264396],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->804604370],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"JacobiCS", "[", 
   RowBox[{"z", ",", "m"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->280453414],

Cell[BoxData[
 FormBox[
  RowBox[{"cs", "(", 
   RowBox[{"z", "\[VerticalSeparator]", "m"}], ")"}], 
  TraditionalForm]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->84394862]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22654],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiCS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiCS"]], "InlineFormula"],
 " can be applied to a power series:"
}], "ExampleText",
 CellID->774412347],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiCS", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"EllipticK", "[", "m", "]"}], "+", 
    RowBox[{"ArcSin", "[", "x", "]"}], "+", 
    RowBox[{
     RowBox[{"O", "[", "x", "]"}], "^", "8"}]}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->85485078],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    RowBox[{
     SqrtBox[
      RowBox[{"1", "-", "m"}]], " ", "x"}]}], "+", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    SqrtBox[
     RowBox[{"1", "-", "m"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "+", "m"}], ")"}], " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{
    FractionBox["1", "120"], " ", 
    SqrtBox[
     RowBox[{"1", "-", "m"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "45"}], "+", 
      RowBox[{"26", " ", "m"}], "-", 
      SuperscriptBox["m", "2"]}], ")"}], " ", 
    SuperscriptBox["x", "5"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "7"],
    SeriesData[$CellContext`x, 0, {}, 1, 7, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 
   0, {-(1 - $CellContext`m)^Rational[1, 2], 0, 
    Rational[1, 6] (1 - $CellContext`m)^Rational[1, 2] (-3 + $CellContext`m), 
    0, Rational[1, 120] (1 - $CellContext`m)^Rational[1, 2] (-45 + 
     26 $CellContext`m - $CellContext`m^2)}, 1, 7, 1],
  Editable->False]], "Output",
 ImageSize->{449, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->385095780]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11057],

Cell[TextData[{
 "Hierarchy of solutions of the nonlinear diffusion equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox[
     RowBox[{"\[PartialD]", 
      RowBox[{"u", "(", 
       RowBox[{"t", ",", "x"}], ")"}]}], 
     RowBox[{"\[PartialD]", "t"}],
     MultilineFunction->None], "=", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["\[PartialD]", "2"], 
       RowBox[{"u", "(", 
        RowBox[{"t", ",", "x"}], ")"}]}], 
      RowBox[{
       RowBox[{"\[PartialD]", "x"}], "\[ThinSpace]", 
       RowBox[{"\[PartialD]", "x"}]}],
      MultilineFunction->None], "-", 
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"u", "(", 
        RowBox[{"t", ",", "x"}], ")"}], "3"]}]}]}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->16727206],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[CurlyPhi]", "[", 
    RowBox[{"0", ",", "y_"}], "]"}], ":=", 
   RowBox[{"JacobiDS", "[", 
    RowBox[{"y", ",", 
     RowBox[{"1", "/", "2"}]}], "]"}]}], ";", 
  RowBox[{
   RowBox[{"\[CurlyPhi]", "[", 
    RowBox[{"n_", ",", "y_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"\[CurlyPhi]", "[", 
       RowBox[{
        RowBox[{"n", "-", "1"}], ",", "y"}], "]"}], ",", "y"}], "]"}], "/", 
    RowBox[{"\[CurlyPhi]", "[", 
     RowBox[{
      RowBox[{"n", "-", "1"}], ",", "y"}], "]"}]}]}], ";", 
  RowBox[{
   RowBox[{"u", "[", 
    RowBox[{"n_", ",", 
     RowBox[{"{", 
      RowBox[{"t_", ",", "x_"}], "}"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"2", " ", "x", " ", 
     RowBox[{"\[CurlyPhi]", "[", 
      RowBox[{"n", ",", "y"}], "]"}]}], "/.", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      RowBox[{"6", " ", "t"}]}]}]}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->49891886],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"u", "[", 
     RowBox[{"k", ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "x"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "0", ",", "2"}], "}"}]}], "]"}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->93222723],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", " ", "x", " ", 
    RowBox[{"JacobiDS", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"6", " ", "t"}], "+", 
       SuperscriptBox["x", "2"]}], ",", 
      FractionBox["1", "2"]}], "]"}]}], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", "x", " ", 
      RowBox[{"JacobiCS", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"6", " ", "t"}], "+", 
         SuperscriptBox["x", "2"]}], ",", 
        FractionBox["1", "2"]}], "]"}], " ", 
      RowBox[{"JacobiNS", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"6", " ", "t"}], "+", 
         SuperscriptBox["x", "2"]}], ",", 
        FractionBox["1", "2"]}], "]"}]}], 
     RowBox[{"JacobiDS", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"6", " ", "t"}], "+", 
        SuperscriptBox["x", "2"]}], ",", 
       FractionBox["1", "2"]}], "]"}]]}], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", "x", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"JacobiDN", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"6", " ", "t"}], "+", 
            SuperscriptBox["x", "2"]}], ",", 
           FractionBox["1", "2"]}], "]"}], "2"], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"JacobiCN", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"6", " ", "t"}], "+", 
             SuperscriptBox["x", "2"]}], ",", 
            FractionBox["1", "2"]}], "]"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox[
            RowBox[{"JacobiDN", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"6", " ", "t"}], "+", 
               SuperscriptBox["x", "2"]}], ",", 
              FractionBox["1", "2"]}], "]"}], "2"]}], ")"}]}]}], ")"}]}], 
     RowBox[{
      RowBox[{"JacobiCN", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"6", " ", "t"}], "+", 
         SuperscriptBox["x", "2"]}], ",", 
        FractionBox["1", "2"]}], "]"}], " ", 
      RowBox[{"JacobiDN", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"6", " ", "t"}], "+", 
         SuperscriptBox["x", "2"]}], ",", 
        FractionBox["1", "2"]}], "]"}], " ", 
      RowBox[{"JacobiSN", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"6", " ", "t"}], "+", 
         SuperscriptBox["x", "2"]}], ",", 
        FractionBox["1", "2"]}], "]"}]}]]}]}], "}"}]], "Output",
 ImageSize->{538, 96},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->51190852]
}, Open  ]],

Cell["Check:", "ExampleText",
 CellID->223231126],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"t", ",", "x"}], "]"}], ",", "t"}], "]"}], "-", 
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"t", ",", "x"}], "]"}], ",", "x", ",", "x"}], "]"}], "+", 
    RowBox[{"2", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"t", ",", "x"}], "]"}], "^", "3"}]}]}], "/.", 
   RowBox[{"u", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"t", ",", "x"}], "}"}], ",", 
      RowBox[{"Evaluate", "[", "%", "]"}]}], "]"}]}]}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"t", "\[Rule]", 
     RowBox[{"RandomReal", "[", 
      RowBox[{"WorkingPrecision", "\[Rule]", "20"}], "]"}]}], ",", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"RandomReal", "[", 
      RowBox[{"WorkingPrecision", "\[Rule]", "20"}], "]"}]}]}], 
   "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->499750724],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0``16.732940681058174", ",", "0``16.295164217157115", ",", 
   "0``15.876873372863958"}], "}"}]], "Output",
 ImageSize->{205, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->601751405]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->544679293],

Cell["\<\
Flow lines in a rectangular region with a current flowing from the lower\
\[Hyphen]right to the upper\[Hyphen]left corner:\
\>", "ExampleText",
 CellID->695240112],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"m", "=", "0.4"}], ",", 
     RowBox[{"\[CurlyEpsilon]", "=", 
      RowBox[{"1", "/", 
       RowBox[{"10", "^", "6"}]}]}]}], "}"}], ",", 
   RowBox[{"ContourPlot", "[", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"JacobiDN", "[", 
        RowBox[{"x", ",", " ", "m"}], "]"}], 
       RowBox[{"JacobiDN", "[", 
        RowBox[{"y", ",", 
         RowBox[{"1", "-", " ", "m"}]}], "]"}]}], 
      RowBox[{
       RowBox[{"JacobiCS", "[", 
        RowBox[{"x", ",", " ", "m"}], "]"}], 
       RowBox[{"JacobiCS", "[", 
        RowBox[{"y", ",", 
         RowBox[{"1", "-", " ", "m"}]}], "]"}]}]], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "\[CurlyEpsilon]", ",", 
       RowBox[{"EllipticK", "[", "m", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "\[CurlyEpsilon]", ",", 
       RowBox[{"EllipticK", "[", 
        RowBox[{"1", "-", "m"}], "]"}]}], "}"}], ",", 
     RowBox[{"ContourShading", " ", "\[Rule]", " ", "False"}]}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->98575801],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyEnXVwVUm3t3EGd3d3d124O8HdZXAIg0NwdwYZ3F2De4AggQAJBBIgkEBC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   "], {{{}, {}, {}, {}, {}, {}, {}, {}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV1XmQz3Ucx/EPVlFZiiVn1gqV5GyNW+OIRcjYMCFHJq1FiJp2mnFlHQmb
kiu51mJp0h8kdh2h3DOazdlMGyaSaKbYosfnj+e8Pu/35319Pt/f9/tLHjG+
f2apEELV0iHUfDyE2dVCmI+PrNclhbAaXa0H0MGYbt2HpqGRdVHVEC5gtHW3
KmLRxHpU5RDGYKG9HHyI7+TcVfswfTj2qhTCVvYi66N87dmfWnemc+jSGIPC
2ItvhnVDOpM+hRzUqxjC6/RJmq73IAzTtwl7N52QGMIe+hZdRHPw0mMh5Mrp
jv7WRWqew4vs03qdQpa4buxPrE/iBIqQLe4nOpeOltuLjqRzaA+a4ZyZOCNm
AzbGO1PrM7WWYas5ltB8MVvRhv2CWYvcw1n8iFl8XdCd/zi7GO3YaewOdK38
HtY79GxEP2c/i37s6ewN1jNpC9qFbw19DuceDeE8uvEdj88qxpvv1wrunb+y
nAN8Vegy9mm99ovbzf7e2U7gJPrE5yLvAxxjZ9M52CVuPl2ABMyL94TL6i9X
7wodSw/pMY5m4Iwee+XtccZd9tP4vqF72fv4C1BG/O/s0rQE5bDRDOVpgv5l
kK9PBru6ux5Ht7EPqn3Y/AfVqMt/gB5il4059p7gq4Whar+KdL7F6k7zXKYi
gd1EbFl6xH6iuj+zU82Yy1dAC9EKLZFl7ix924p7j06WMwl5YpPUq4q9YqqL
LaB/xvn4bsX6tC7NMONXcmbbby1uU/wtmDmJv7dZ+6AG3xi+mrS9mA7xmZqr
K7bwtWPfpg3E/EUb0oHqp2OwmCHINGOBPoX6rBB/i30b1fTpq0c/9MfHzpET
UeMi+1K8R/kH8bXcd+y1ju9kfO/kzqDD6Sy6Kr5X4tfGuxJfiH2oaL+z/R3y
vzVDJ+v9/BfEVnL/5+kSvilqvx3vEZPQkz9R7s74vOUmmvsBZyobnxVW6XOM
VhDTUf4jtJGYlfy58TeDBuzJ7HR72/VO0u9yfAfwvtxiWofWju+wHini62Og
+GSaqfd4BHH341n57tC7+Ad3xJXENb1HS+h/cZ/u0n8nLsXnrndJ/A2w79JD
7Iv8x5Gifn0MU3so/rY/wJyb9MxDLrZgM3aI367+lyjvfrbRfNyWV479IBJw
Q/+b/IX63aDX2P/qcQ/38Yf4mxhlf4VetdGVXYsuj99B8UtRjOtm/YVeNNdZ
/S+xz9OjuCbnOgYhX910Ohu91VgpfnP89iLPDJuwWJ0JzjERF9jjaSZ6iW/K
boZSaM5uTo/oMUu9UvIG0EBn0ulYr+46rMEC/i/Ez6Pj4jfIfmM1VqOlMzal
99VaRVPQ1369OCNK+JvRKXLX06vOdwU95D3D/sH6IXs9xeXJ24Lf7E11z1fp
y/F/BU/bf41O5J9Ls5GGdLyC9fLetNdQ3MD4H0ZH+N2N5Vtk5oXxN89/Slxr
Wqx2Kj3G7kdbiWuBpmgT8+P3WExb50+hk8R1tJfK7mQ/C3X536V14jeKVsFw
DMUQjHWuN+jzSFavWvxWW9eyroFk65HOPwbT4v8LXyd0tE6l7eK7Gp8VbYxR
+B9dOzKe
         "]],
        "12"],
       Annotation[#, 12, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV1XmQz3UYwPGvdRWtZdf+iMSaxbSLlUToMoyrHGWUGLfZbDnKukJZx2ai
pLZVyTTFDpOjcZ+tM8y4EstKqAlJJuXcIatenz/e836ez+f5PJ9nv9/f77cp
Q0a/OKpMFEWN46JoaHIUpeNRjKkZRW25JZ4WP8PtMUGcWSOKhqCe+EFrtTFC
HKtqTfy4eDiyEqKoL/fHQCRhMuqoe4vrcsvEKOoWc4bbJbkLY6pFUX17bawd
5FQ9W6vPsNccLdBTflDdYZxTc4R/QBfrc9XPQ5a6wXqnVomi3tYbcoGaIizF
SZxAM3MOrB5Fg/CGM9l4RO0weTqPl18Ks6pbHu6wdr94v2eQpm9ne5fE2dYK
5GN5srpp5p/Eb+OOMz34LufwPs7Q/x6X6l/KTeWX9coy+2s4Lh/Br2O2nl/L
F+MrfZfgi3h36DUDvdAbf+Ai9utXTm15xGGX57ATZ5w5K/8Fp3FG31/5I17C
ebxU72+wDO31Wskr0Ef8if1+3Bc3rd3AVfzsvvuc32H+i3xBXYn1O/gXV9TX
84xSsNz+SqzAWudeDr3RSU1H3DJjivwmNzFzqfiy2j9xSH08V0FZz608KuCK
ezPUNkUl+Rl1CWo2Wt+E6+a5Kb/Bt/gfvs7X+Cpf5Wvc3/179NiLRHl1JKGH
fpn2uvPf+lWzVhVHzVguvNfwrLlEnwX2S+TT7Y00+wjUD8/O2a2cz1fM+B3/
xVt5Eee4c7B4tfoC+WJM1SfemQ3W1mMdFqhZ4o7Z+hepWSg/xidwHOPlU9SN
4+3ykygO36vw3XRunL2xyMYA8053R19ez6t5La/idVzR3a28s3XyzfL1vIW/
5U3h/fEGXsMbuZX+E/WdgIVhFu4R3pPvRUVUwEPh++hvnWCeiYjpn4xJeqS7
Lw2znHs39LHeVc9X1Q9HhrMdrDcLf7O8CD8i5uxR3uaZrArvBw3c2xCN0MyZ
ys6kitvqv1zcwLxF1mvJc+StuQ1imGyuZH4MuXoW6DfMHWfVD+X3nG1p75S9
gWYchBrOJKiryZU5xvFcnR/gZJ6i/mNxJdQ2Sx08jO16tTV/G6TIk9QmolBd
AldFTeu1EGfWNHOU4bv2S9FYno6Xwm+T2kphfrWt9IusxdnbY+adZo9Z3817
5bvtfc/b5EnWC3lo+I20Poov8F79z3OW/La4vN731JXl/7gCb+YdoT8Ouusw
NvtbuziziRPNccDaNvuFOKbfcHu79FvAu/lTno/z4XdNzxk4pDaXZ2KaO6Zy
DvLCb5Mz74jnhnPyfHwezoXfNGvj3PmC843k3bhh+Iw7sxadxYt8Fp8yR1fx
Oe/vNxxCR3l76zNxXP4TitHOemtrt/RdhRu4hjX6jQ7/OzDNM5yJJ9Rlh+8D
dzLXSHWdeQgG47nweeJMzBEXm/sEDmM+jrjvs/B50etY+B/gfAu9isTNuadz
p5zrje7i58PfrzYP8/CmmkIeHX5zuInZB3AfM/Xj9z2f1PAM+Kge/fVN4072
toi3YwdyPaN8zMKz4R3xk3zA3gozLkNu+Dxb32fttnwPf2DePMzDRj0z8bt4
ELqYoa67hzlzWl6MRuKuznUL71n8CvdCB/GXvBgfiueE+1BL/D+wvjoc
         "]],
        "10"],
       Annotation[#, 10, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV1XmQz3Ucx/HPWjnXWlerzNhkMphxFZttWncl1hGbLMrYZnM1WCTHukrJ
tSShZkQIDUZqJmcpyRTCSs7KhLCiZFWrCT0+fzzn9b7fn+/39/1+f/VyR/Ya
kRBCSC0TQm6tEBqjOfJrh/AIbYVMdhvaAePYeakhDEIau65YjZQQhrNr0TR+
S/ZgDKkaQg4dgEK5fdVCmEefUFOPPlojhK53h5CFltVDaMfPRL66DH5r7FdX
X30DNJVLR3JyCD3M3K/urHyG2AU6nj8OneX71QyhP4bIvYiGYgvNeAs/qCmU
G+V8a9j59DhtRgeJP0RH6hmNsXiY/xJtTfPkW9Hz6lvSdfSi3ZniFfgZtDJt
Q19wXU3snaB3Iqa6nlfwRhUxfQWYgu6Yir1qT9Jv6B31wYzb9HNzPsNpfcfE
juMojtlzgs6iK+hcutz8lViFtma1w3zxy/xCulpdH7E/+L/jKk7Ylyi+y3X8
Qs/imnhDO/+0s1h93fh74wO5dViLj/RdlttMO9ESPSXq27Ov00b6r4udlC+n
fj+9EOc7x9/ipbiJNNyHi+KX5C/QYnrAjJ52FvOv8C/Tq/QS7S7eA13RDVkY
YG+S/Fh9w8wbim52Voq/CSpijzN9hYNqyqi/IZYY74eZ96tf4h4sjc8zu7eZ
2WiuvgVK9VyTu0l/87tcQTG2xftAC9Q8x55Mp2CF2HJMtuMBO3408zROYbu6
DWatNOuQmsM4iO/wsfxi+SPsd2gRXUqTzBhDp5uX47zT6C17/sM2uY1mbdG7
FWv1rIm72ZNcQwEmYKCdE+lO9Yn6yiABq81rLP6hfDrdxK8inoyquBPvLa2M
ShiqboG6ZTSRlk2NHxHzkIDR+MR5RtF8jES62jbOk4lsM3pjTnxP7JpN82jN
+C64xmZqUtSvj3visxSfY3reNf2Kc1irrrZ4Kr5XfwRF2CA3x+xh8hvZQ2kJ
vYGf5M+gup7J4k3YBTSF/yBaYIY9q+zNdZ7XnesNzEQ1346TcjmupR/6xmcO
/XGX+mT58jSJlqNV6CT1q+Wn8Lfyp9JG8d1ChjO2RqpzlRWvLL+T3mtXHVQX
r4k7ZnRxrtu0Gv9fNU8783CxbFpeXwWkxO+jebfUJcTvp70Z2GXWDteym36p
fifdGn9f9VvoDv4gs3JxTv5r88/SwfxS9iH5InUH6BF6mE6jy+h7WGjXIrxt
b1M9i+ib/J56C+M31Jnamncmfo9oTz29kIUe6I69el6m41EPEzEBY/SOxjxz
HrNznFin+D2OfXSBPfOxR/5Vs0+73lnsUXpm0o5q/mH/hU1oxy+hm50t34zM
+B7FXryGtvyx4ulmdTH3Z3XdkM1+hp5yn/vQd+P/YXw37Vus7xBdQidhN4bZ
8UXU+H+i7qn4PdF3Ms6KM/ld0V5uvrqFyMH2+D1BH31pcs/GZ9l9q+9c79Mi
vQPsbkQfj7Xs3diB6WLHcBQd4veffiu+D+vju40ZYhX9dyahlL9Hbq6zjoj/
j/RTM/PiO8YeiM7OUdfu59XXoafFGrCf1JeFaey+tBc6spfRlShkz477cA/7
fzl+LGA=
         "]],
        "8"],
       Annotation[#, 8, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV1XmQz3Ucx/HPNhPjvlnHSseSkBRDyKRyJBq7JSbHsBEl51SMbUhSaFeh
KVdjl6EkI+So0EHNMNN0qBw5cysWOVI0Pd5/PL3en/f5+Xx8vr+9OW9U7siM
lNJ5/wyqkVJjNMfozJTupS3Rnn0f7YgX2HUrpzS4Vkr12Vl8Va2fZVen26qk
1KRaSlvptxhaKaVD/MPpdusCdmc1XdFO3qM1U6pUMaV7qqZUmY6WM0TseboT
P+EKf9PqKTUL1LRABb7W1qX0bWPdGsf0vso/Tk0X2k/8MF8LOVnsu2l/OtjM
kfIL2eWcozzKoCxOmf16hZSW6HFS3ikMkPcU8tBU3+Vi9eRmYRHfNH3f5puD
uWrb8rVDG5QWa0+H6DPezONqxvK9yfeyM9dVU8HdzdB3Nt84sbfoi3QWzRE/
rWdD9dn4El9gi3PVVl8HPeR0R4m8TOtztJGck+y9euzBevm/ha3vKf4/8GfM
Rz3s5n/Q3nbRh2hunIVOUPcunY952CfelT6MTuiCzthhZmn9t9Nd+v2KVc70
jvrJfGNwVPyg+iP0EK0vJwtN7bUJ7sBh/m76HZOzW+xE3Bme1CtfvC99z7qn
vBI5Z2iyzsANOG/fF+INmbtenyJzu1onZOD7mK/vURxDFRyUkyv3klgOvUwv
yb0Yd8A+HWen68w+acZ6usFe5tBFdDYtop9iI25S1wC91Ey0x8fpvxHjW2ZW
Yq8192d9B6ot1jPf+i/ri7iA/vb/mfz35W+0XqDHUr7p1tlxLuvbaDFtGO8w
3hQdKqeQPk1n0inyD3nTB3EAA/jH8/eR35guoY3oYno7LZDfiq6wbkk/otft
4xo+FtvEN0yPlXpNdY7X4j3a+xasEf9P3mpahn8z30r1a9zBROesJva7usMo
pc+NyOefIu9VTI336i72YKYeH5qzLOr0qh79+KrosSliclbgAwyLb5Juo3fq
2RzNsDzuPfYu/6r4P/gbP8pbrHcxGprZCOXklcVuuTXjd0NODZqJWvja+pza
C/HGUJtvgtyi+D+I+4+7jHvEdXN70wz9e9FEn4hvS/7n7Gvi5fWoiErINr+V
87VEuXjH7icDs+IN0w04Ht9CfLN61KBnaHP7vQsHsB9L7XGBfS3EPEwyZz7N
1SdP30EYiMb8V/gu4xbxs+oa0BJ6Kx1jHwVxRnuug7l8hWbOxBxzm5k1m561
rwK+N+TOQDv1ZeId8K/FNL6xZqyOt4Nv1JzT+3z8/urZwT7G0lHxjuQ+F3th
l2AEu734cNqd5tMe9KU4m/grZm1VM5l+FbPF9pu1D4/ZQ1vrVWbuiN8kdMMj
6BO/Jaiv7hnrLDpdXr84Ay3CIvygT9/4XtBJbBPNNbeq/M3sLfhFzk50NK8D
/Y7vfnZfeWvUXHF3I+SvirPRT+gssXX0KD2BI/H3BV1iL/ac529BHbo3fu/Z
PfXM1nsSuzc7Bw+wF9JiFLKnx3eOTPb/ZLogVQ==
         "]],
        "6"],
       Annotation[#, 6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV1H1M11UUx/FbNqEteRAUKrJQ1npgLqS2spaJ+dBqMaUsS6dF01wBtTKD
Aos/ArRWtqGbIGHlplYoElJgD6vMFMrKrGlLEdd0IYmbpllJr/vHm88953zO
ufd3v98v2Y+WzSq9IISwzp8Fo0K4BuNRlhnCzTQft1pPpVkpITxrfRndjV0Y
K59Jr00LIReXJIXwRWoIO7ATh9S+odPkj9CpND89hBsxkb8AUzCeb6FZj2MR
SpJDqBoZwlHrY/E8es/q3T06hB50I128RP4V3sszQqihb4pXYvWIEMbY4yhP
Fj1Gr6TF+krsN91+S/SU6kmgZTQxzuBLoakYgWQk4TmMUhvm91+EC9FjTjdq
5b90xmozZ4jvwm3Onicu1ZdPn6QTaAld42xdzrEdJ/UN4gTqzKnneUm9DD86
717n+oH+RDPMHI0/1faJ98rvE7foazPrQVpO59AKWshzjh6g/fb9lb6BYnu0
ixvNKXBXQ+JJ4jtwO3p4UsxNRh8O46Dc12qn9AzoqRdvjc9arlturX1eF6+h
jWhAJ47zPaO+mW+mdZverchUy8B+s+fpa3JnFdYPOctJ3jn0Q752fKdvsty3
tICuM69d7zb8497O4W+sNOcj/MbTQa/QOwZF+n6Xm0U7xO/o74jPQTyfb6z1
OJw3Ywjr1f/ie5f+K/4Pq+xVjz+sG/V9zL9J/QzfRlqt9phZL9Pi+Ht4unje
VzvL8x7tFK+Vf159iG+e9Xk6l37K8zDNj3PpDfF9QR6Gq23iW2HGcfv3Y6kZ
G+XephvoOtrozhri+6NnAa2ky1CFT8z4WX9jPAMaUMnTRF+g8919vjkT8KJ4
KW+r2iPO0mx2p3oXtuMz8QnPK5E3ARt4vpfbwX9EX691H61TW44aLJKrpZ/T
NL50jES53gPO1h/v3MwzOI09fM3O8RbS7JmOi/kS0cEbxKnmpWCX9TZzJvIO
mnkLLY93ZUaveIBer97Hex29z3dThHH2GVTLsd6sp4BOwd3y9+BStYXiTHpK
Pck3f5om2i8BRfI7zeyn0+h0zMC9PIWoslcd33KsQG783xS/H8+vVrzMHlW4
Sf9wcav8U/q20KdpC/8H+ErPIXN7cRDZ5h6mefoW04H4neEBs17jv0q9iQ6j
q52/kt6ptsp6ZnyPaYU9UvX/En83itXnxncSk5wlW61Vrg0teCJ+W3QL7tef
a+bsuEaNvbLEe8zZrz/HPRWanxPvwPpqut5zmC23mE6Wa7BuxqvWtXLVyLD+
HyMO9gw=
         "]],
        "4"],
       Annotation[#, 4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV03tM11UYx/GjMzVLESzAdFPBTQu1cqtNA03JP0o3L2nLIi9MktGGZomY
zXKauimJpVwFpya4WVnN/C83r2BeIC/0R+TEVstLuWXg/fI6f7x/n3Oe5/k8
z/me7/c3KHfBtMJOIYQpfmY/GcIQDEdhagh9e4cwMimE5/Facgiv4uknQujo
FcJQ2k6foRkY2scaGTx9xNsSQ7iIzxJCKOevQCVKxcp6hnBXbYu6O/RXOpzv
35QQhtH1+h0RP4oqnhfsX0QXvdrUPELTebLl0ugani+xXN9CJDn7Bvu/5DKd
OQtdrcfQbvSYvnf1+Zkmqm2gCXS1XKP1s7zX5J+jjWal8aVjMB43cxAdiAF4
Sd1o/G3ufLlLtJGvNj6v9Z+et8Z6C6qRK7cJn8j97p5b8Rtu6XUT65zhP/vr
+B8/iH2P+zxZ8czOk0mP01769USrXofEjomt52+1LonPIt5DvoF+wL9Xvx+x
0P6OmqVy+fgOe1ArvtesrbRDXTs+1+cf3qvo71kWyX3L+6b9GzwzcFLsQ/sc
tZXubxKtoBNprX6l9IZeN3HUGZvVP8bXRBfzVUYv3sY+M34Rb1B33Duv0mcq
f5E+U2h37+mPeC/OcBpn0F+uH87yzdL3DH3Kvi++kN+Ict5Fcu9jIabZV+ud
S3fSYrM74p3QIpRZL4nfFd2MTRjibIv13q7vDmxDNf9+nJf/ie6S/4av2fkP
i7XF79G8C3SV+nfVrKR5tF7NHvFb+t5GnX0Gz046jCaIFclXqF+qvpx+ROto
Pb6K7yqen5bEd8dTzDtCbKaZBc7RLvYeTRLfrN+++P7sL6t5hW8Celg300dp
cL+d8IAvLf4H9blIG2gjeutzSm0ibaIpPHPEk+kJnpV655kzD8Vmldpfkhur
9mWMQzbGo7v4fZ4L+t+Ld0W/Ft8dn00uVexjc1LoMlpPd8VvT34m3kKO2e9g
gTkH5A6ZucHsg7RFPpXvXPwW6GV6Bfm+q1H20817HWvVd7avoaf0KYh3hsnx
m0Od9afiM3x3+fH90Ln269zTGvsVSLZ+CJfayAg=
         "]],
        "2"],
       Annotation[#, 2, "Tooltip"]& ]}, {}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->NCache[{{
      Rational[1, 1000000], 1.7775193714912534`}, {
      Rational[1, 1000000], 1.9495677498060258`}}, {{1.*^-6, 
    1.7775193714912534`}, {1.*^-6, 1.9495677498060258`}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 179},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->319049563]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->228220110],

Cell["Conformal map from a unit triangle to the unit disk:", "ExampleText",
 CellID->223864426],

Cell[BoxData[
 RowBox[{
  RowBox[{"w", "[", "z_", "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Zeta]", "=", 
       FractionBox[
        RowBox[{"z", " ", 
         RowBox[{
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "/", "3"}], "]"}], "^", "3"}]}], 
        RowBox[{
         SuperscriptBox["2", 
          RowBox[{"1", "/", "3"}]], 
         SuperscriptBox["3", 
          RowBox[{"1", "/", "4"}]], "\[Pi]"}]]}], ",", 
      RowBox[{"m", "=", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"\[Pi]", "/", "12"}], "]"}], "^", "2"}]}]}], "}"}], ",", 
    RowBox[{
     SuperscriptBox["2", 
      RowBox[{"11", "/", "6"}]], 
     RowBox[{"Cos", "[", 
      RowBox[{"\[Pi]", "/", "12"}], "]"}], 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{
        RowBox[{"JacobiCS", "[", 
         RowBox[{"\[Zeta]", ",", "m"}], "]"}], 
        RowBox[{"JacobiSN", "[", 
         RowBox[{"\[Zeta]", ",", "m"}], "]"}]}]}], ")"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         RowBox[{"Tan", "[", 
          RowBox[{"\[Pi]", "/", "12"}], "]"}], 
         RowBox[{"JacobiCS", "[", 
          RowBox[{"\[Zeta]", ",", "m"}], "]"}], 
         RowBox[{"JacobiSN", "[", 
          RowBox[{"\[Zeta]", ",", "m"}], "]"}]}]}], ")"}], "/", 
      "\[IndentingNewLine]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["3", 
          RowBox[{"1", "/", "4"}]], 
         RowBox[{"JacobiSN", "[", 
          RowBox[{"\[Zeta]", ",", "m"}], "]"}], 
         RowBox[{"JacobiDN", "[", 
          RowBox[{"\[Zeta]", ",", "m"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"JacobiCN", "[", 
            RowBox[{"\[Zeta]", ",", "m"}], "]"}]}], ")"}], "^", "2"}]}], 
       ")"}]}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16049754],

Cell["Show points before and after the map:", "ExampleText",
 CellID->84846121],

Cell[BoxData[
 RowBox[{
  RowBox[{"trianglePoints", "=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", "=", 
       RowBox[{"E", "^", 
        RowBox[{"(", 
         RowBox[{"2", "Pi", " ", 
          RowBox[{"I", "/", "3"}]}], ")"}]}]}], "}"}], ",", 
     RowBox[{"Flatten", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"s", "/", "8."}], " ", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"#1", "+", 
              RowBox[{
               RowBox[{"j", "/", "16"}], 
               RowBox[{"(", 
                RowBox[{"#2", "-", "#1"}], ")"}]}]}], ",", 
             RowBox[{"{", 
              RowBox[{"j", ",", "0", ",", "16"}], "}"}]}], "]"}]}], "&"}], "@@@",
          
         RowBox[{"(", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1", ",", "t"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", 
               RowBox[{"1", "/", "t"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"1", "/", "t"}], ",", "1"}], "}"}]}], "}"}], "/", 
           SqrtBox["3"]}], ")"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"s", ",", "8"}], "}"}]}], "]"}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->272616709],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Re", "[", "#", "]"}], ",", 
          RowBox[{"Im", "[", "#", "]"}]}], "}"}], "]"}], "&"}], "/@", 
      "trianglePoints"}], ",", 
     RowBox[{"Frame", " ", "\[Rule]", " ", "True"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Re", "[", "#", "]"}], ",", 
          RowBox[{"Im", "[", "#", "]"}]}], "}"}], "]"}], "&"}], "/@", 
      RowBox[{"w", "[", "trianglePoints", "]"}]}], ",", 
     RowBox[{"Frame", " ", "\[Rule]", " ", "True"}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->126582686],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 197},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->394088205]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->120139003],

Cell[TextData[{
 "Solution of the sinh\[Hyphen]Gordon equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["\[PartialD]", "2"], 
       RowBox[{"u", "(", 
        RowBox[{"x", ",", "t"}], ")"}]}], 
      RowBox[{
       RowBox[{"\[PartialD]", "x"}], "\[ThinSpace]", 
       RowBox[{"\[PartialD]", "t"}]}],
      MultilineFunction->None], "+", 
     RowBox[{"sinh", "(", 
      RowBox[{"u", "(", 
       RowBox[{"x", ",", "t"}], ")"}], ")"}]}], "\[LongEqual]", "0"}], 
   TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->688353202],

Cell[BoxData[
 RowBox[{
  RowBox[{"u", "[", 
   RowBox[{"x_", ",", "t_"}], "]"}], ":=", 
  RowBox[{"2", 
   RowBox[{"ArcSinh", "[", 
    RowBox[{"JacobiCS", "[", 
     RowBox[{
      RowBox[{"x", "-", "t"}], ",", "m"}], "]"}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->59273105],

Cell["Check the solution:", "ExampleText",
 CellID->123023636],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "t"}], "]"}], ",", "x", ",", "t"}], "]"}], "+", 
    RowBox[{"Sinh", "[", 
     RowBox[{"u", "[", 
      RowBox[{"x", ",", "t"}], "]"}], "]"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"JacobiNS", "[", 
       RowBox[{
        RowBox[{"t", "-", "x"}], ",", "m"}], "]"}], "^", "2"}], "-", 
     RowBox[{
      RowBox[{"JacobiCS", "[", 
       RowBox[{
        RowBox[{"t", "-", "x"}], ",", "m"}], "]"}], "^", "2"}]}], "==", 
    "1"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->107585666],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->278140993]
}, Open  ]],

Cell["Plot the solution:", "ExampleText",
 CellID->1021720479],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"x", ",", "t"}], "]"}], "/.", 
     RowBox[{"m", "\[Rule]", 
      RowBox[{"4", "/", "3"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"5", "/", "2"}]}], "}"}], ",", 
   RowBox[{"MaxRecursion", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->10394245],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->7131602]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13404],

Cell["Compose with inverse functions:", "ExampleText",
 CellID->361783126],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiCS", "[", 
    RowBox[{
     RowBox[{"InverseJacobiCS", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], ",", 
   RowBox[{"InverseJacobiCS", "[", 
    RowBox[{
     RowBox[{"JacobiCS", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->288300512],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", 
   RowBox[{"InverseJacobiCS", "[", 
    RowBox[{
     RowBox[{"JacobiCS", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}]}], "}"}]], "Output",
 ImageSize->{269, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->641386271]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " to disregard multivaluedness of the inverse function:"
}], "ExampleText",
 CellID->785308763],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22979849],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", "z"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->16051240]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->133706258],

Cell["Solve a transcendental equation:", "ExampleText",
 CellID->464846584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"JacobiCS", "[", 
       RowBox[{"x", ",", "m"}], "]"}], "2"], "+", 
     RowBox[{"3", 
      RowBox[{"JacobiCS", "[", 
       RowBox[{"x", ",", "m"}], "]"}]}]}], "\[Equal]", "a"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->132240831],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->149772643],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"InverseJacobiCS", "[", 
      RowBox[{
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "-", 
          SqrtBox[
           RowBox[{"9", "+", 
            RowBox[{"4", " ", "a"}]}]]}], ")"}]}], ",", "m"}], "]"}]}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"InverseJacobiCS", "[", 
      RowBox[{
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "+", 
          SqrtBox[
           RowBox[{"9", "+", 
            RowBox[{"4", " ", "a"}]}]]}], ")"}]}], ",", "m"}], "]"}]}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{302, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->393500133]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->51589583],

Cell["Integrals:", "ExampleText",
 CellID->8022031],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"JacobiCS", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->265886764],

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"JacobiDS", "[", 
     RowBox[{"z", ",", "m"}], "]"}]}], "+", 
   RowBox[{"JacobiNS", "[", 
    RowBox[{"z", ",", "m"}], "]"}]}], "]"}]], "Output",
 ImageSize->{250, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->981920]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26865],

Cell["\<\
Machine-precision input is insufficient to give the correct answer:\
\>", "ExampleText",
 CellID->455054116],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiCS", "[", 
  RowBox[{
   RowBox[{"10.", "^", "15"}], ",", "Pi"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->259473357],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1.5836939579905787`"}], "-", 
  RowBox[{"3.770584105361463`*^-16", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{175, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->266591814]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"JacobiCS", "[", 
    RowBox[{
     RowBox[{"10", "^", "15"}], ",", "Pi"}], "]"}], ",", "20"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->87579626],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1.50054942139779049009840218807021084699`20.15051499783199"}],
   "+", 
  RowBox[{"0``19.974264694114513", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{238, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->53699068]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->34433034],

Cell["\<\
Currently only simple simplification rules are built in for Jacobi functions:\
\
\>", "ExampleText",
 CellID->48769658],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"JacobiCS", "[", 
   RowBox[{"z", ",", "m"}], "]"}], "-", 
  FractionBox[
   RowBox[{"JacobiCN", "[", 
    RowBox[{"z", ",", "m"}], "]"}], 
   RowBox[{"JacobiSN", "[", 
    RowBox[{"z", ",", "m"}], "]"}]]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->566572358],

Cell[BoxData[
 RowBox[{
  RowBox[{"JacobiCS", "[", 
   RowBox[{"z", ",", "m"}], "]"}], "-", 
  FractionBox[
   RowBox[{"JacobiCN", "[", 
    RowBox[{"z", ",", "m"}], "]"}], 
   RowBox[{"JacobiSN", "[", 
    RowBox[{"z", ",", "m"}], "]"}]]}]], "Output",
 ImageSize->{212, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->447423729]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->139217068],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->494024894]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox[
    RowBox[{"JacobiCS", "[", 
     RowBox[{"u", ",", "m"}], "]"}], "2"], "+", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"JacobiCD", "[", 
      RowBox[{"u", ",", "m"}], "]"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "m", "-", 
      SuperscriptBox[
       RowBox[{"JacobiCS", "[", 
        RowBox[{"u", ",", "m"}], "]"}], "2"]}], ")"}]}]}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->475407751],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"JacobiCS", "[", 
    RowBox[{"u", ",", "m"}], "]"}], "2"], "+", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"JacobiCD", "[", 
     RowBox[{"u", ",", "m"}], "]"}], "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "m", "-", 
     SuperscriptBox[
      RowBox[{"JacobiCS", "[", 
       RowBox[{"u", ",", "m"}], "]"}], "2"]}], ")"}]}]}]], "Output",
 ImageSize->{383, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->3195286]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27059],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseJacobiCS",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseJacobiCS"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiCN",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiCN"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiCD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiCD"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21597]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31519],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "Tutorials",
 CellID->2250]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->496413985],

Cell[TextData[ButtonBox["Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticFunctions"]], "MoreAbout",
 CellID->194600486]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"JacobiCS - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 51, 28.0751996}", "context" -> "System`", 
    "keywords" -> {
     "cs", "doubly periodic function", "elliptic Jacobi function", 
      "Jacobi elliptic function cs"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "JacobiCS[u, m] gives the Jacobi elliptic function cs(u | m).", 
    "synonyms" -> {"Jacobi CS"}, "title" -> "JacobiCS", "type" -> "Symbol", 
    "uri" -> "ref/JacobiCS"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6160, 219, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->621835333]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 157758, 3620}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2018, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2641, 77, 46, 1, 70, "ObjectName",
 CellID->10512],
Cell[2690, 80, 676, 22, 70, "Usage",
 CellID->29706]
}, Open  ]],
Cell[CellGroupData[{
Cell[3403, 107, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3881, 124, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4004, 130, 390, 15, 70, "Notes",
 CellID->4365],
Cell[4397, 147, 832, 30, 70, "Notes",
 CellID->287578035],
Cell[5232, 179, 215, 7, 70, "Notes",
 CellID->99960195],
Cell[5450, 188, 248, 8, 70, "Notes",
 CellID->216313340],
Cell[5701, 198, 218, 7, 70, "Notes",
 CellID->31226],
Cell[5922, 207, 201, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6160, 219, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->621835333],
Cell[CellGroupData[{
Cell[6545, 233, 147, 5, 70, "ExampleSection",
 CellID->42455164],
Cell[6695, 240, 64, 1, 70, "ExampleText",
 CellID->400288940],
Cell[CellGroupData[{
Cell[6784, 245, 130, 4, 28, "Input",
 CellID->77957898],
Cell[6917, 251, 175, 5, 36, "Output",
 CellID->729537414]
}, Open  ]],
Cell[7107, 259, 125, 3, 70, "ExampleDelimiter",
 CellID->470866374],
Cell[CellGroupData[{
Cell[7257, 266, 290, 10, 28, "Input",
 CellID->175933317],
Cell[7550, 278, 3435, 60, 131, "Output",
 Evaluatable->False,
 CellID->7937784]
}, Open  ]],
Cell[11000, 341, 125, 3, 70, "ExampleDelimiter",
 CellID->137230538],
Cell[11128, 346, 60, 1, 70, "ExampleText",
 CellID->55901019],
Cell[CellGroupData[{
Cell[11213, 351, 245, 8, 70, "Input",
 CellID->461811558],
Cell[11461, 361, 959, 32, 51, "Output",
 CellID->169667]
}, Open  ]],
Cell[CellGroupData[{
Cell[12457, 398, 245, 8, 70, "Input",
 CellID->240753544],
Cell[12705, 408, 1116, 34, 51, "Output",
 CellID->1103233]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13870, 448, 216, 7, 70, "ExampleSection",
 CellID->13835],
Cell[14089, 457, 74, 1, 70, "ExampleText",
 CellID->136651426],
Cell[CellGroupData[{
Cell[14188, 462, 201, 7, 70, "Input",
 CellID->374527875],
Cell[14392, 471, 271, 8, 36, "Output",
 CellID->210289191]
}, Open  ]],
Cell[14678, 482, 125, 3, 70, "ExampleDelimiter",
 CellID->525378932],
Cell[14806, 487, 70, 1, 70, "ExampleText",
 CellID->239493914],
Cell[CellGroupData[{
Cell[14901, 492, 234, 8, 70, "Input",
 CellID->18845098],
Cell[15138, 502, 234, 7, 36, "Output",
 CellID->97372085]
}, Open  ]],
Cell[15387, 512, 125, 3, 70, "ExampleDelimiter",
 CellID->550009612],
Cell[15515, 517, 113, 3, 70, "ExampleText",
 CellID->864577637],
Cell[CellGroupData[{
Cell[15653, 524, 190, 6, 70, "Input",
 CellID->446034805],
Cell[15846, 532, 228, 6, 36, "Output",
 CellID->556301836]
}, Open  ]],
Cell[16089, 541, 125, 3, 70, "ExampleDelimiter",
 CellID->128417124],
Cell[16217, 546, 217, 7, 70, "ExampleText",
 CellID->97071841],
Cell[CellGroupData[{
Cell[16459, 557, 176, 6, 70, "Input",
 CellID->815460718],
Cell[16638, 565, 326, 11, 36, "Output",
 CellID->527450587]
}, Open  ]],
Cell[16979, 579, 123, 3, 70, "ExampleDelimiter",
 CellID->6259999],
Cell[17105, 584, 92, 1, 70, "ExampleText",
 CellID->495463307],
Cell[CellGroupData[{
Cell[17222, 589, 236, 8, 70, "Input",
 CellID->65054936],
Cell[17461, 599, 266, 9, 36, "Output",
 CellID->33306841]
}, Open  ]],
Cell[CellGroupData[{
Cell[17764, 613, 420, 15, 70, "Input",
 CellID->366415397],
Cell[18187, 630, 329, 11, 39, "Output",
 CellID->399542165]
}, Open  ]],
Cell[18531, 644, 124, 3, 70, "ExampleText",
 CellID->26118627],
Cell[CellGroupData[{
Cell[18680, 651, 145, 5, 70, "Input",
 CellID->74535809],
Cell[18828, 658, 235, 8, 36, "Output",
 CellID->157489238]
}, Open  ]],
Cell[CellGroupData[{
Cell[19100, 671, 320, 10, 70, "Input",
 CellID->67735372],
Cell[19423, 683, 216, 7, 36, "Output",
 CellID->126172108]
}, Open  ]],
Cell[19654, 693, 125, 3, 70, "ExampleDelimiter",
 CellID->263264396],
Cell[19782, 698, 203, 7, 70, "ExampleText",
 CellID->804604370],
Cell[CellGroupData[{
Cell[20010, 709, 166, 5, 70, "Input",
 CellID->280453414],
Cell[20179, 716, 277, 9, 50, "Output",
 CellID->84394862]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20505, 731, 239, 7, 70, "ExampleSection",
 CellID->22654],
Cell[20747, 740, 211, 7, 70, "ExampleText",
 CellID->774412347],
Cell[CellGroupData[{
Cell[20983, 751, 289, 9, 70, "Input",
 CellID->85485078],
Cell[21275, 762, 1239, 40, 51, "Output",
 CellID->385095780]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22563, 808, 223, 7, 70, "ExampleSection",
 CellID->11057],
Cell[22789, 817, 811, 28, 70, "ExampleText",
 CellID->16727206],
Cell[23603, 847, 1013, 34, 70, "Input",
 CellID->49891886],
Cell[CellGroupData[{
Cell[24641, 885, 334, 12, 70, "Input",
 CellID->93222723],
Cell[24978, 899, 2615, 84, 117, "Output",
 CellID->51190852]
}, Open  ]],
Cell[27608, 986, 49, 1, 70, "ExampleText",
 CellID->223231126],
Cell[CellGroupData[{
Cell[27682, 991, 977, 32, 70, "Input",
 CellID->499750724],
Cell[28662, 1025, 281, 9, 39, "Output",
 CellID->601751405]
}, Open  ]],
Cell[28958, 1037, 125, 3, 70, "ExampleDelimiter",
 CellID->544679293],
Cell[29086, 1042, 173, 4, 70, "ExampleText",
 CellID->695240112],
Cell[CellGroupData[{
Cell[29284, 1050, 1130, 34, 70, "Input",
 CellID->98575801],
Cell[30417, 1086, 82507, 1384, 70, "Output",
 CellID->319049563]
}, Open  ]],
Cell[112939, 2473, 125, 3, 70, "ExampleDelimiter",
 CellID->228220110],
Cell[113067, 2478, 95, 1, 70, "ExampleText",
 CellID->223864426],
Cell[113165, 2481, 1946, 61, 70, "Input",
 CellID->16049754],
Cell[115114, 2544, 79, 1, 70, "ExampleText",
 CellID->84846121],
Cell[115196, 2547, 1417, 45, 70, "Input",
 CellID->272616709],
Cell[CellGroupData[{
Cell[116638, 2596, 868, 28, 70, "Input",
 CellID->126582686],
Cell[117509, 2626, 8671, 146, 70, "Output",
 Evaluatable->False,
 CellID->394088205]
}, Open  ]],
Cell[126195, 2775, 125, 3, 70, "ExampleDelimiter",
 CellID->120139003],
Cell[126323, 2780, 613, 21, 70, "ExampleText",
 CellID->688353202],
Cell[126939, 2803, 289, 10, 70, "Input",
 CellID->59273105],
Cell[127231, 2815, 62, 1, 70, "ExampleText",
 CellID->123023636],
Cell[CellGroupData[{
Cell[127318, 2820, 671, 23, 70, "Input",
 CellID->107585666],
Cell[127992, 2845, 158, 5, 36, "Output",
 CellID->278140993]
}, Open  ]],
Cell[128165, 2853, 62, 1, 70, "ExampleText",
 CellID->1021720479],
Cell[CellGroupData[{
Cell[128252, 2858, 529, 17, 70, "Input",
 CellID->10394245],
Cell[128784, 2877, 17441, 290, 70, "Output",
 Evaluatable->False,
 CellID->7131602]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[146274, 3173, 233, 7, 70, "ExampleSection",
 CellID->13404],
Cell[146510, 3182, 74, 1, 70, "ExampleText",
 CellID->361783126],
Cell[CellGroupData[{
Cell[146609, 3187, 381, 12, 70, "Input",
 CellID->288300512],
Cell[146993, 3201, 337, 11, 36, "Output",
 CellID->641386271]
}, Open  ]],
Cell[147345, 3215, 246, 8, 70, "ExampleText",
 CellID->785308763],
Cell[CellGroupData[{
Cell[147616, 3227, 106, 3, 70, "Input",
 CellID->22979849],
Cell[147725, 3232, 202, 7, 36, "Output",
 CellID->16051240]
}, Open  ]],
Cell[147942, 3242, 125, 3, 70, "ExampleDelimiter",
 CellID->133706258],
Cell[148070, 3247, 75, 1, 70, "ExampleText",
 CellID->464846584],
Cell[CellGroupData[{
Cell[148170, 3252, 365, 13, 70, "Input",
 CellID->132240831],
Cell[148538, 3267, 453, 8, 70, "Message",
 CellID->149772643],
Cell[148994, 3277, 917, 33, 81, "Output",
 CellID->393500133]
}, Open  ]],
Cell[149926, 3313, 124, 3, 70, "ExampleDelimiter",
 CellID->51589583],
Cell[150053, 3318, 51, 1, 70, "ExampleText",
 CellID->8022031],
Cell[CellGroupData[{
Cell[150129, 3323, 189, 6, 70, "Input",
 CellID->265886764],
Cell[150321, 3331, 351, 12, 36, "Output",
 CellID->981920]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[150721, 3349, 226, 7, 70, "ExampleSection",
 CellID->26865],
Cell[150950, 3358, 118, 3, 70, "ExampleText",
 CellID->455054116],
Cell[CellGroupData[{
Cell[151093, 3365, 155, 5, 70, "Input",
 CellID->259473357],
Cell[151251, 3372, 274, 8, 36, "Output",
 CellID->266591814]
}, Open  ]],
Cell[CellGroupData[{
Cell[151562, 3385, 213, 8, 70, "Input",
 CellID->87579626],
Cell[151778, 3395, 313, 9, 36, "Output",
 CellID->53699068]
}, Open  ]],
Cell[152106, 3407, 124, 3, 70, "ExampleDelimiter",
 CellID->34433034],
Cell[152233, 3412, 129, 4, 70, "ExampleText",
 CellID->48769658],
Cell[CellGroupData[{
Cell[152387, 3420, 294, 10, 70, "Input",
 CellID->566572358],
Cell[152684, 3432, 383, 13, 53, "Output",
 CellID->447423729]
}, Open  ]],
Cell[CellGroupData[{
Cell[153104, 3450, 108, 3, 70, "Input",
 CellID->139217068],
Cell[153215, 3455, 158, 5, 36, "Output",
 CellID->494024894]
}, Open  ]],
Cell[CellGroupData[{
Cell[153410, 3465, 513, 18, 70, "Input",
 CellID->475407751],
Cell[153926, 3485, 549, 19, 39, "Output",
 CellID->3195286]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[154536, 3511, 311, 9, 70, "SeeAlsoSection",
 CellID->27059],
Cell[154850, 3522, 710, 26, 70, "SeeAlso",
 CellID->21597]
}, Open  ]],
Cell[CellGroupData[{
Cell[155597, 3553, 314, 9, 70, "TutorialsSection",
 CellID->31519],
Cell[155914, 3564, 191, 4, 70, "Tutorials",
 CellID->2250]
}, Open  ]],
Cell[CellGroupData[{
Cell[156142, 3573, 319, 9, 70, "MoreAboutSection",
 CellID->496413985],
Cell[156464, 3584, 147, 3, 70, "MoreAbout",
 CellID->194600486]
}, Open  ]],
Cell[156626, 3590, 27, 0, 70, "History"],
Cell[156656, 3592, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

