(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     62160,       2073]
NotebookOptionsPosition[     52750,       1740]
NotebookOutlinePosition[     54054,       1778]
CellTagsIndexPosition[     53968,       1773]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals and Elliptic Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals and Elliptic Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"InverseJacobiDC" :> 
          Documentation`HelpLookup["paclet:ref/InverseJacobiDC"], "JacobiDN" :> 
          Documentation`HelpLookup["paclet:ref/JacobiDN"], "JacobiDS" :> 
          Documentation`HelpLookup["paclet:ref/JacobiDS"], "JacobiNC" :> 
          Documentation`HelpLookup["paclet:ref/JacobiNC"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"InverseJacobiDC\"\>", 
       2->"\<\"JacobiDN\"\>", 3->"\<\"JacobiDS\"\>", 
       4->"\<\"JacobiNC\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Functions" :> 
          Documentation`HelpLookup["paclet:guide/EllipticFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Elliptic Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["JacobiDC", "ObjectName",
 CellID->30324],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["JacobiDC",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/JacobiDC"], "[", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Jacobi elliptic function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"dc", "(", 
        RowBox[{"u", "|", "m"}], ")"}], TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9581]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"dc", "(", "u", ")"}], "=", 
    FractionBox[
     SqrtBox[
      RowBox[{"1", "-", 
       RowBox[{"m", " ", 
        RowBox[{
         SuperscriptBox["sin", "2"], "(", "\[Phi]", ")"}]}]}]], 
     RowBox[{"cos", "(", "\[Phi]", ")"}]]}], TraditionalForm]], 
  "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Phi]", "=", 
    RowBox[{"am", "(", 
     RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->14677],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"dc", "(", 
    RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " is a doubly periodic function in ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " with periods ",
 Cell[BoxData[
  FormBox[
   RowBox[{"4", " ", 
    RowBox[{"K", "(", "m", ")"}]}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", " ", "\[ImaginaryI]", " ", 
    RowBox[{"K", "(", 
     RowBox[{"1", "-", "m"}], ")"}]}], TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox["K", TraditionalForm]], "InlineMath"],
 " is the elliptic integral ",
 Cell[BoxData[
  ButtonBox["EllipticK",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticK"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->688488616],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiDC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiDC"]], "InlineFormula"],
 " is a meromorphic function in both arguments."
}], "Notes",
 CellID->124193767],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["JacobiDC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiDC"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->545298446],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiDC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiDC"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiDC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiDC"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->292498529],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->75531364],

Cell["Evaluate numerically:", "ExampleText",
 CellID->111594280],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiDC", "[", 
  RowBox[{"3.14", ",", "0.3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->249392632],

Cell[BoxData[
 RowBox[{"-", "1.0299529164888603`"}]], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->495613842]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23818265],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"JacobiDC", "[", 
    RowBox[{"x", ",", 
     RowBox[{"1", "/", "3"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "6"}], ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9979915],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->114132201]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->148195268],

Cell["Series expansions:", "ExampleText",
 CellID->54535256],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"JacobiDC", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->46915731],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", "m"}], ")"}], " ", 
    SuperscriptBox["z", "2"]}], "+", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    RowBox[{"(", 
     RowBox[{"5", "-", 
      RowBox[{"6", " ", "m"}], "+", 
      SuperscriptBox["m", "2"]}], ")"}], " ", 
    SuperscriptBox["z", "4"]}], "+", 
   RowBox[{
    FractionBox["1", "720"], " ", 
    RowBox[{"(", 
     RowBox[{"61", "-", 
      RowBox[{"107", " ", "m"}], "+", 
      RowBox[{"47", " ", 
       SuperscriptBox["m", "2"]}], "-", 
      SuperscriptBox["m", "3"]}], ")"}], " ", 
    SuperscriptBox["z", "6"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "7"],
    SeriesData[$CellContext`z, 0, {}, 0, 7, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   1, 0, Rational[1, 2] (1 - $CellContext`m), 0, 
    Rational[1, 24] (5 - 6 $CellContext`m + $CellContext`m^2), 0, 
    Rational[1, 720] (61 - 107 $CellContext`m + 
     47 $CellContext`m^2 - $CellContext`m^3)}, 0, 7, 1],
  Editable->False]], "Output",
 ImageSize->{461, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->247364426]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"JacobiDC", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->639497532],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"Sec", "[", "z", "]"}], "+", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "z", " ", 
       RowBox[{"Sec", "[", "z", "]"}], " ", 
       RowBox[{"Tan", "[", "z", "]"}]}], "-", 
      RowBox[{"4", " ", 
       RowBox[{"Sin", "[", "z", "]"}], " ", 
       RowBox[{"Tan", "[", "z", "]"}]}], "+", 
      RowBox[{
       RowBox[{"Sec", "[", "z", "]"}], " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "z"}], "]"}], " ", 
       RowBox[{"Tan", "[", "z", "]"}]}]}], ")"}], " ", "m"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "m", "]"}], "2"],
    SeriesData[$CellContext`m, 0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`m, 0, {
    Sec[$CellContext`z], 
    Rational[1, 8] ((-2) $CellContext`z Sec[$CellContext`z] 
      Tan[$CellContext`z] - 4 Sin[$CellContext`z] Tan[$CellContext`z] + 
     Sec[$CellContext`z] Sin[2 $CellContext`z] Tan[$CellContext`z])}, 0, 2, 
   1],
  Editable->False]], "Output",
 ImageSize->{522, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->204597344]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25833],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->112890142],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiDC", "[", 
  RowBox[{
   RowBox[{"2.5", "+", "I"}], ",", 
   RowBox[{"0.2", "-", 
    RowBox[{"0.3", " ", "I"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->353771037],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.6198190991629758`"}], "+", 
  RowBox[{"0.4155408633282876`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{148, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->65654688]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->105790448],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->186564984],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"JacobiDC", "[", 
    RowBox[{"3", ",", 
     RowBox[{"1", "/", "2"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->380979824],

Cell[BoxData[
 RowBox[{"-", 
  "1.152866054482701678131030109675428767483660962365481698924057995866`50."}]\
], "Output",
 ImageSize->{369, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->887196169]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22253048],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->68762940],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiDC", "[", 
  RowBox[{"3", ",", "0.500000000000000000000000000000000000000"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->489102737],

Cell[BoxData[
 RowBox[{"-", 
  "1.152866054482701678131030109675428767483660962364`38.052090433700755"}]], \
"Output",
 ImageSize->{285, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32714185]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->114938765],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiDC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiDC"]], "InlineFormula"],
 " threads element\[Hyphen]wise over lists:"
}], "ExampleText",
 CellID->310520456],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiDC", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->102445170],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiDC", "[", 
    RowBox[{"1", ",", "m"}], "]"}], ",", 
   RowBox[{"JacobiDC", "[", 
    RowBox[{"2", ",", "m"}], "]"}]}], "}"}]], "Output",
 ImageSize->{220, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->173996334]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3359231],

Cell["Simple exact answers are generated automatically:", "ExampleText",
 CellID->259031270],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiDC", "[", 
    RowBox[{"z", ",", "0"}], "]"}], ",", 
   RowBox[{"JacobiDC", "[", 
    RowBox[{"z", ",", "1"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27419542],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Sec", "[", "z", "]"}], ",", "1"}], "}"}]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->184399439]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiDC", "[", 
    RowBox[{"0", ",", "m"}], "]"}], ",", 
   RowBox[{"JacobiDC", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"EllipticK", "[", "m", "]"}], "/", "2"}], ",", "m"}], "]"}], 
   ",", 
   RowBox[{"JacobiDC", "[", 
    RowBox[{
     RowBox[{"EllipticK", "[", "m", "]"}], ",", "m"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->37739192],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   SqrtBox[
    RowBox[{"1", "+", 
     SqrtBox[
      RowBox[{"1", "-", "m"}]]}]], ",", "ComplexInfinity"}], "}"}]], "Output",\

 ImageSize->{235, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->204569947]
}, Open  ]],

Cell["\<\
Parity transformations and periodicity relations are automatically applied:\
\>", "ExampleText",
 CellID->341324251],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiDC", "[", 
  RowBox[{
   RowBox[{"-", "u"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->306710583],

Cell[BoxData[
 RowBox[{"JacobiDC", "[", 
  RowBox[{"u", ",", "m"}], "]"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->73634484]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiDC", "[", 
  RowBox[{
   RowBox[{"u", "+", 
    RowBox[{"4", " ", 
     RowBox[{"EllipticK", "[", "m", "]"}]}], "+", 
    RowBox[{"2", "I", " ", 
     RowBox[{"EllipticK", "[", 
      RowBox[{"1", "-", "m"}], "]"}]}]}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->118650963],

Cell[BoxData[
 RowBox[{"JacobiDC", "[", 
  RowBox[{"u", ",", "m"}], "]"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->911431269]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->116659917],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->337581887],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"JacobiDC", "[", 
   RowBox[{"u", ",", "m"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->122807641],

Cell[BoxData[
 FormBox[
  RowBox[{"dc", "(", 
   RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], 
  TraditionalForm]], "Output",
 ImageSize->{48, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->452571116]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26922],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiDC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiDC"]], "InlineFormula"],
 " can be applied to a power series:"
}], "ExampleText",
 CellID->271403579],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"JacobiDC", "[", 
   RowBox[{"u", ",", 
    RowBox[{"m", "+", 
     RowBox[{"m", "^", "2"}], "+", 
     RowBox[{
      RowBox[{"O", "[", "m", "]"}], "^", "3"}]}]}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->104004036],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"Sec", "[", "u", "]"}], "-", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Sec", "[", "u", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{"u", "+", 
        RowBox[{
         RowBox[{"Cos", "[", "u", "]"}], " ", 
         RowBox[{"Sin", "[", "u", "]"}]}]}], ")"}], " ", 
      RowBox[{"Tan", "[", "u", "]"}]}], ")"}], " ", "m"}], "+", 
   RowBox[{
    FractionBox["1", "512"], " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", "u", "]"}], "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "21"}], "+", 
      RowBox[{"24", " ", 
       SuperscriptBox["u", "2"]}], "-", 
      RowBox[{"8", " ", 
       SuperscriptBox["u", "2"], " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"2", " ", "u"}], "]"}]}], "+", 
      RowBox[{"21", " ", 
       RowBox[{"Cos", "[", 
        RowBox[{"4", " ", "u"}], "]"}]}], "-", 
      RowBox[{"60", " ", "u", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "u"}], "]"}]}], "+", 
      RowBox[{"4", " ", "u", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"4", " ", "u"}], "]"}]}]}], ")"}], " ", 
    SuperscriptBox["m", "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "m", "]"}], "3"],
    SeriesData[$CellContext`m, 0, {}, 0, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`m, 0, {
    Sec[$CellContext`u], Rational[-1, 4] 
    Sec[$CellContext`u] ($CellContext`u + 
     Cos[$CellContext`u] Sin[$CellContext`u]) Tan[$CellContext`u], 
    Rational[1, 512] 
    Sec[$CellContext`u]^3 (-21 + 24 $CellContext`u^2 - 8 $CellContext`u^2 
     Cos[2 $CellContext`u] + 21 Cos[4 $CellContext`u] - 60 $CellContext`u 
     Sin[2 $CellContext`u] + 4 $CellContext`u Sin[4 $CellContext`u])}, 0, 3, 
   1],
  Editable->False]], "Output",
 ImageSize->{578, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->73362633]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24716],

Cell["Conformal map from a unit triangle to the unit disk:", "ExampleText",
 CellID->742868198],

Cell[BoxData[
 RowBox[{
  RowBox[{"w", "[", "z_", "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Zeta]", "=", 
       RowBox[{"z", 
        FractionBox[
         SuperscriptBox[
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "/", "3"}], "]"}], "3"], 
         RowBox[{
          SuperscriptBox["2", 
           RowBox[{"1", "/", "3"}]], " ", 
          SuperscriptBox["3", 
           RowBox[{"1", "/", "4"}]], " ", "\[Pi]"}]]}]}], ",", 
      RowBox[{"m", "=", 
       RowBox[{
        RowBox[{"Sin", "[", 
         FractionBox["\[Pi]", "12"], "]"}], "^", "2"}]}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["2", 
        RowBox[{"11", "/", "6"}]], " ", 
       SqrtBox[
        RowBox[{"1", "-", "m"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"JacobiDC", "[", 
          RowBox[{"\[Zeta]", ",", "m"}], "]"}], "-", " ", 
         RowBox[{"JacobiDN", "[", 
          RowBox[{"\[Zeta]", ",", "m"}], "]"}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"JacobiDC", "[", 
          RowBox[{"\[Zeta]", ",", "m"}], "]"}], "+", 
         RowBox[{
          SqrtBox[
           FractionBox["m", 
            RowBox[{"1", "-", "m"}]]], " ", 
          RowBox[{"JacobiDN", "[", 
           RowBox[{"\[Zeta]", ",", "m"}], "]"}]}]}], ")"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", 
        RowBox[{"JacobiDC", "[", 
         RowBox[{"\[Zeta]", ",", "m"}], "]"}], " ", 
        RowBox[{"JacobiDN", "[", 
         RowBox[{"\[Zeta]", ",", "m"}], "]"}]}], "+", 
       SuperscriptBox[
        RowBox[{"JacobiDN", "[", 
         RowBox[{"\[Zeta]", ",", "m"}], "]"}], "2"], "+", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"JacobiDC", "[", 
          RowBox[{"\[Zeta]", ",", "m"}], "]"}], "2"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["3", 
            RowBox[{"1", "/", "4"}]], " ", 
           RowBox[{"JacobiDN", "[", 
            RowBox[{"\[Zeta]", ",", "m"}], "]"}], " ", 
           RowBox[{"JacobiSN", "[", 
            RowBox[{"\[Zeta]", ",", "m"}], "]"}]}]}], ")"}]}]}], ")"}]}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->36571340],

Cell["Show points before and after the map:", "ExampleText",
 CellID->331249941],

Cell[BoxData[
 RowBox[{
  RowBox[{"trianglePoints", "=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", "=", 
       RowBox[{"E", "^", 
        RowBox[{"(", 
         RowBox[{"2", " ", "Pi", " ", 
          RowBox[{"I", "/", "3"}]}], ")"}]}]}], "}"}], ",", 
     RowBox[{"Flatten", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"\[Alpha]", "/", "8."}], " ", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"N", "[", 
              RowBox[{"#1", "+", 
               RowBox[{
                RowBox[{"j", "/", "16"}], 
                RowBox[{"(", 
                 RowBox[{"#2", "-", "#1"}], ")"}]}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"j", ",", "0", ",", "16"}], "}"}]}], "]"}]}], "&"}], "@@@",
          
         RowBox[{"(", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1", ",", "t"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", 
               RowBox[{"1", "/", "t"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"1", "/", "t"}], ",", "1"}], "}"}]}], "}"}], "/", 
           SqrtBox["3"]}], ")"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Alpha]", ",", "8"}], "}"}]}], "]"}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->492487310],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Re", "[", "#", "]"}], ",", 
          RowBox[{"Im", "[", "#", "]"}]}], "}"}], "]"}], "&"}], "/@", 
      "trianglePoints"}], ",", 
     RowBox[{"Frame", " ", "\[Rule]", " ", "True"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Re", "[", "#", "]"}], ",", 
          RowBox[{"Im", "[", "#", "]"}]}], "}"}], "]"}], "&"}], "/@", 
      RowBox[{"w", "[", "trianglePoints", "]"}]}], ",", 
     RowBox[{"Frame", " ", "\[Rule]", " ", "True"}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->508776826],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 197},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->242891154]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->715667511],

Cell[TextData[{
 "Solution of the Poisson\[Dash]Boltzmann equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["\[PartialD]", "2"], 
       RowBox[{"\[Psi]", "(", 
        RowBox[{"x", ",", "y"}], ")"}]}], 
      RowBox[{
       RowBox[{"\[PartialD]", "x"}], "\[ThinSpace]", 
       RowBox[{"\[PartialD]", "x"}]}],
      MultilineFunction->None], "+", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[PartialD]", "2"], 
       RowBox[{"\[Psi]", "(", 
        RowBox[{"x", ",", "y"}], ")"}]}], 
      RowBox[{
       RowBox[{"\[PartialD]", "y"}], "\[ThinSpace]", 
       RowBox[{"\[PartialD]", "y"}]}],
      MultilineFunction->None]}], "\[LongEqual]", 
    RowBox[{"sinh", "(", 
     RowBox[{"\[Psi]", "(", 
      RowBox[{"x", ",", "y"}], ")"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->311825910],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Psi]", "[", 
    RowBox[{"x_", ",", " ", "y_"}], "]"}], "=", 
   RowBox[{"4", " ", 
    RowBox[{"ArcTanh", "[", 
     RowBox[{
      SqrtBox[
       RowBox[{"1", "+", 
        FractionBox["2", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SuperscriptBox["\[Alpha]", "2"], "+", 
          SuperscriptBox["\[Beta]", "2"]}]]}]], 
      RowBox[{"JacobiDN", "[", 
       RowBox[{
        RowBox[{"x", " ", "\[Alpha]"}], ",", 
        FractionBox[
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             SuperscriptBox["\[Alpha]", "2"]}], ")"}], "2"], "-", 
          SuperscriptBox["\[Beta]", "4"]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["\[Alpha]", "2"]}]]}], "]"}], " ", 
      RowBox[{
       RowBox[{
        RowBox[{"JacobiDN", "[", 
         RowBox[{
          RowBox[{"y", " ", "\[Beta]"}], ",", 
          FractionBox[
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["\[Alpha]", "4"]}], "+", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               SuperscriptBox["\[Beta]", "2"]}], ")"}], "2"]}], 
           RowBox[{"4", " ", 
            SuperscriptBox["\[Beta]", "2"]}]]}], "]"}], "/", " ", 
        RowBox[{"JacobiDC", "[", 
         RowBox[{
          RowBox[{"x", " ", "\[Alpha]"}], ",", 
          FractionBox[
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "+", 
               SuperscriptBox["\[Alpha]", "2"]}], ")"}], "2"], "-", 
            SuperscriptBox["\[Beta]", "4"]}], 
           RowBox[{"4", " ", 
            SuperscriptBox["\[Alpha]", "2"]}]]}], "]"}]}], "/", 
       RowBox[{"JacobiDC", "[", 
        RowBox[{
         RowBox[{"y", " ", "\[Beta]"}], ",", 
         FractionBox[
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["\[Alpha]", "4"]}], "+", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "+", 
              SuperscriptBox["\[Beta]", "2"]}], ")"}], "2"]}], 
          RowBox[{"4", " ", 
           SuperscriptBox["\[Beta]", "2"]}]]}], "]"}]}]}], "]"}]}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->210478124],

Cell["Check solution using series expansion:", "ExampleText",
 CellID->356412923],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["\[PartialD]", 
       RowBox[{"x", ",", "x"}]], 
      RowBox[{"\[Psi]", "[", 
       RowBox[{"x", ",", "y"}], "]"}]}], "+", 
     RowBox[{
      SubscriptBox["\[PartialD]", 
       RowBox[{"y", ",", "y"}]], 
      RowBox[{"\[Psi]", "[", 
       RowBox[{"x", ",", "y"}], "]"}]}], "-", 
     RowBox[{"Sinh", "[", 
      RowBox[{"\[Psi]", "[", 
       RowBox[{"x", ",", "y"}], "]"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "0", ",", "3"}], "}"}]}], "]"}], "//", 
  "Normal"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->331991668],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->59376693]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19653],

Cell["Compose with inverse functions:", "ExampleText",
 CellID->446884639],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiDC", "[", 
    RowBox[{
     RowBox[{"InverseJacobiDC", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], ",", 
   RowBox[{"InverseJacobiDC", "[", 
    RowBox[{
     RowBox[{"JacobiDC", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->150613467],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", 
   RowBox[{"InverseJacobiDC", "[", 
    RowBox[{
     RowBox[{"JacobiDC", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}]}], "}"}]], "Output",
 ImageSize->{269, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->185917550]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " to disregard multivaluedness of the inverse function:"
}], "ExampleText",
 CellID->63042172],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7135577],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", "z"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->129544928]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->113076732],

Cell["Solve a transcendental equation:", "ExampleText",
 CellID->81298353],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"JacobiDC", "[", 
       RowBox[{"x", ",", "m"}], "]"}], "2"], "+", 
     RowBox[{"3", 
      RowBox[{"JacobiDC", "[", 
       RowBox[{"x", ",", "m"}], "]"}]}]}], "==", "a"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->330205070],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->12874465],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"InverseJacobiDC", "[", 
      RowBox[{
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "-", 
          SqrtBox[
           RowBox[{"9", "+", 
            RowBox[{"4", " ", "a"}]}]]}], ")"}]}], ",", "m"}], "]"}]}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"InverseJacobiDC", "[", 
      RowBox[{
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "+", 
          SqrtBox[
           RowBox[{"9", "+", 
            RowBox[{"4", " ", "a"}]}]]}], ")"}]}], ",", "m"}], "]"}]}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{302, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->281439773]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->690585279],

Cell["Integrals:", "ExampleText",
 CellID->243715871],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"JacobiDC", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->223231688],

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{
   RowBox[{"JacobiNC", "[", 
    RowBox[{"z", ",", "m"}], "]"}], "+", 
   RowBox[{"JacobiSC", "[", 
    RowBox[{"z", ",", "m"}], "]"}]}], "]"}]], "Output",
 ImageSize->{242, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9060311]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10090],

Cell["\<\
Machine-precision input is insufficient to give the correct answer:\
\>", "ExampleText",
 CellID->449874585],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiDC", "[", 
  RowBox[{
   RowBox[{"10.", "^", "16"}], ",", "Pi"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->268043320],

Cell[BoxData[
 RowBox[{"1.`", "\[InvisibleSpace]", "-", 
  RowBox[{"1.7428549922704484`*^-17", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->106048111]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"JacobiDC", "[", 
    RowBox[{
     RowBox[{"10", "^", "16"}], ",", "Pi"}], "]"}], ",", "20"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->154941739],

Cell[BoxData[
 RowBox[{"0.48265676537249811268984779676590799751`20.15051499783199", "+", 
  RowBox[{"0``20.46687659978209", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{237, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->458743153]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->777259805],

Cell["\<\
Currently only simple simplification rules are built in for Jacobi functions:\
\
\>", "ExampleText",
 CellID->632184],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"JacobiDC", "[", 
   RowBox[{"z", ",", "m"}], "]"}], "-", 
  FractionBox[
   RowBox[{"JacobiDN", "[", 
    RowBox[{"z", ",", "m"}], "]"}], 
   RowBox[{"JacobiCN", "[", 
    RowBox[{"z", ",", "m"}], "]"}]]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19011457],

Cell[BoxData[
 RowBox[{
  RowBox[{"JacobiDC", "[", 
   RowBox[{"z", ",", "m"}], "]"}], "-", 
  FractionBox[
   RowBox[{"JacobiDN", "[", 
    RowBox[{"z", ",", "m"}], "]"}], 
   RowBox[{"JacobiCN", "[", 
    RowBox[{"z", ",", "m"}], "]"}]]}]], "Output",
 ImageSize->{212, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->95712789]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->72341539],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->211045183]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox[
    RowBox[{"JacobiDC", "[", 
     RowBox[{"u", ",", "m"}], "]"}], "2"], "-", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"JacobiSN", "[", 
      RowBox[{"u", ",", "m"}], "]"}], "2"], 
    SuperscriptBox[
     RowBox[{"JacobiDC", "[", 
      RowBox[{"u", ",", "m"}], "]"}], "2"]}], "+", 
   RowBox[{"m", " ", 
    SuperscriptBox[
     RowBox[{"JacobiSN", "[", 
      RowBox[{"u", ",", "m"}], "]"}], "2"]}]}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->75249245],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"JacobiDC", "[", 
    RowBox[{"u", ",", "m"}], "]"}], "2"], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"m", "-", 
     SuperscriptBox[
      RowBox[{"JacobiDC", "[", 
       RowBox[{"u", ",", "m"}], "]"}], "2"]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"JacobiSN", "[", 
     RowBox[{"u", ",", "m"}], "]"}], "2"]}]}]], "Output",
 ImageSize->{356, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->63342613]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26084],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseJacobiDC",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseJacobiDC"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiDN",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiDN"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiDS",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiDS"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiNC",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiNC"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25945]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12693],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "Tutorials",
 CellID->10655]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->521352012],

Cell[TextData[ButtonBox["Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticFunctions"]], "MoreAbout",
 CellID->344770758]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"JacobiDC - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 51, 29.7627428}", "context" -> "System`", 
    "keywords" -> {
     "dc", "doubly periodic function", "elliptic Jacobi function", 
      "Jacobi elliptic function dc"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "JacobiDC[u, m] gives the Jacobi elliptic function dc(u | m).", 
    "synonyms" -> {"Jacobi DC"}, "title" -> "JacobiDC", "type" -> "Symbol", 
    "uri" -> "ref/JacobiDC"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6435, 228, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->292498529]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 53825, 1766}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2123, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2746, 79, 46, 1, 70, "ObjectName",
 CellID->30324],
Cell[2795, 82, 675, 22, 70, "Usage",
 CellID->9581]
}, Open  ]],
Cell[CellGroupData[{
Cell[3507, 109, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3985, 126, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4108, 132, 560, 22, 70, "Notes",
 CellID->14677],
Cell[4671, 156, 832, 30, 70, "Notes",
 CellID->688488616],
Cell[5506, 188, 216, 7, 70, "Notes",
 CellID->124193767],
Cell[5725, 197, 248, 8, 70, "Notes",
 CellID->545298446],
Cell[5976, 207, 218, 7, 70, "Notes",
 CellID->31226],
Cell[6197, 216, 201, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6435, 228, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->292498529],
Cell[CellGroupData[{
Cell[6820, 242, 147, 5, 70, "ExampleSection",
 CellID->75531364],
Cell[6970, 249, 64, 1, 70, "ExampleText",
 CellID->111594280],
Cell[CellGroupData[{
Cell[7059, 254, 132, 4, 28, "Input",
 CellID->249392632],
Cell[7194, 260, 193, 6, 36, "Output",
 CellID->495613842]
}, Open  ]],
Cell[7402, 269, 124, 3, 70, "ExampleDelimiter",
 CellID->23818265],
Cell[CellGroupData[{
Cell[7551, 276, 288, 10, 28, "Input",
 CellID->9979915],
Cell[7842, 288, 3519, 62, 131, "Output",
 Evaluatable->False,
 CellID->114132201]
}, Open  ]],
Cell[11376, 353, 125, 3, 70, "ExampleDelimiter",
 CellID->148195268],
Cell[11504, 358, 60, 1, 70, "ExampleText",
 CellID->54535256],
Cell[CellGroupData[{
Cell[11589, 363, 244, 8, 70, "Input",
 CellID->46915731],
Cell[11836, 373, 1263, 39, 51, "Output",
 CellID->247364426]
}, Open  ]],
Cell[CellGroupData[{
Cell[13136, 417, 245, 8, 70, "Input",
 CellID->639497532],
Cell[13384, 427, 1226, 36, 51, "Output",
 CellID->204597344]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14659, 469, 216, 7, 70, "ExampleSection",
 CellID->25833],
Cell[14878, 478, 74, 1, 70, "ExampleText",
 CellID->112890142],
Cell[CellGroupData[{
Cell[14977, 483, 206, 7, 70, "Input",
 CellID->353771037],
Cell[15186, 492, 269, 8, 36, "Output",
 CellID->65654688]
}, Open  ]],
Cell[15470, 503, 125, 3, 70, "ExampleDelimiter",
 CellID->105790448],
Cell[15598, 508, 70, 1, 70, "ExampleText",
 CellID->186564984],
Cell[CellGroupData[{
Cell[15693, 513, 208, 7, 70, "Input",
 CellID->380979824],
Cell[15904, 522, 252, 8, 36, "Output",
 CellID->887196169]
}, Open  ]],
Cell[16171, 533, 124, 3, 70, "ExampleDelimiter",
 CellID->22253048],
Cell[16298, 538, 112, 3, 70, "ExampleText",
 CellID->68762940],
Cell[CellGroupData[{
Cell[16435, 545, 170, 5, 70, "Input",
 CellID->489102737],
Cell[16608, 552, 248, 8, 36, "Output",
 CellID->32714185]
}, Open  ]],
Cell[16871, 563, 125, 3, 70, "ExampleDelimiter",
 CellID->114938765],
Cell[16999, 568, 218, 7, 70, "ExampleText",
 CellID->310520456],
Cell[CellGroupData[{
Cell[17242, 579, 176, 6, 70, "Input",
 CellID->102445170],
Cell[17421, 587, 326, 11, 36, "Output",
 CellID->173996334]
}, Open  ]],
Cell[17762, 601, 123, 3, 70, "ExampleDelimiter",
 CellID->3359231],
Cell[17888, 606, 92, 1, 70, "ExampleText",
 CellID->259031270],
Cell[CellGroupData[{
Cell[18005, 611, 236, 8, 70, "Input",
 CellID->27419542],
Cell[18244, 621, 234, 8, 36, "Output",
 CellID->184399439]
}, Open  ]],
Cell[CellGroupData[{
Cell[18515, 634, 419, 15, 70, "Input",
 CellID->37739192],
Cell[18937, 651, 310, 12, 49, "Output",
 CellID->204569947]
}, Open  ]],
Cell[19262, 666, 126, 3, 70, "ExampleText",
 CellID->341324251],
Cell[CellGroupData[{
Cell[19413, 673, 146, 5, 70, "Input",
 CellID->306710583],
Cell[19562, 680, 215, 7, 36, "Output",
 CellID->73634484]
}, Open  ]],
Cell[CellGroupData[{
Cell[19814, 692, 321, 10, 70, "Input",
 CellID->118650963],
Cell[20138, 704, 216, 7, 36, "Output",
 CellID->911431269]
}, Open  ]],
Cell[20369, 714, 125, 3, 70, "ExampleDelimiter",
 CellID->116659917],
Cell[20497, 719, 203, 7, 70, "ExampleText",
 CellID->337581887],
Cell[CellGroupData[{
Cell[20725, 730, 166, 5, 70, "Input",
 CellID->122807641],
Cell[20894, 737, 278, 9, 50, "Output",
 CellID->452571116]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21221, 752, 239, 7, 70, "ExampleSection",
 CellID->26922],
Cell[21463, 761, 211, 7, 70, "ExampleText",
 CellID->271403579],
Cell[CellGroupData[{
Cell[21699, 772, 281, 10, 70, "Input",
 CellID->104004036],
Cell[21983, 784, 1959, 57, 81, "Output",
 CellID->73362633]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23991, 847, 223, 7, 70, "ExampleSection",
 CellID->24716],
Cell[24217, 856, 95, 1, 70, "ExampleText",
 CellID->742868198],
Cell[24315, 859, 2330, 71, 70, "Input",
 CellID->36571340],
Cell[26648, 932, 80, 1, 70, "ExampleText",
 CellID->331249941],
Cell[26731, 935, 1480, 46, 70, "Input",
 CellID->492487310],
Cell[CellGroupData[{
Cell[28236, 985, 868, 28, 70, "Input",
 CellID->508776826],
Cell[29107, 1015, 8671, 146, 70, "Output",
 Evaluatable->False,
 CellID->242891154]
}, Open  ]],
Cell[37793, 1164, 125, 3, 70, "ExampleDelimiter",
 CellID->715667511],
Cell[37921, 1169, 910, 30, 70, "ExampleText",
 CellID->311825910],
Cell[38834, 1201, 2281, 69, 70, "Input",
 CellID->210478124],
Cell[41118, 1272, 81, 1, 70, "ExampleText",
 CellID->356412923],
Cell[CellGroupData[{
Cell[41224, 1277, 724, 24, 70, "Input",
 CellID->331991668],
Cell[41951, 1303, 157, 5, 36, "Output",
 CellID->59376693]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[42157, 1314, 233, 7, 70, "ExampleSection",
 CellID->19653],
Cell[42393, 1323, 74, 1, 70, "ExampleText",
 CellID->446884639],
Cell[CellGroupData[{
Cell[42492, 1328, 381, 12, 70, "Input",
 CellID->150613467],
Cell[42876, 1342, 337, 11, 36, "Output",
 CellID->185917550]
}, Open  ]],
Cell[43228, 1356, 245, 8, 70, "ExampleText",
 CellID->63042172],
Cell[CellGroupData[{
Cell[43498, 1368, 105, 3, 70, "Input",
 CellID->7135577],
Cell[43606, 1373, 203, 7, 36, "Output",
 CellID->129544928]
}, Open  ]],
Cell[43824, 1383, 125, 3, 70, "ExampleDelimiter",
 CellID->113076732],
Cell[43952, 1388, 74, 1, 70, "ExampleText",
 CellID->81298353],
Cell[CellGroupData[{
Cell[44051, 1393, 359, 13, 70, "Input",
 CellID->330205070],
Cell[44413, 1408, 452, 8, 70, "Message",
 CellID->12874465],
Cell[44868, 1418, 917, 33, 81, "Output",
 CellID->281439773]
}, Open  ]],
Cell[45800, 1454, 125, 3, 70, "ExampleDelimiter",
 CellID->690585279],
Cell[45928, 1459, 53, 1, 70, "ExampleText",
 CellID->243715871],
Cell[CellGroupData[{
Cell[46006, 1464, 189, 6, 70, "Input",
 CellID->223231688],
Cell[46198, 1472, 331, 11, 36, "Output",
 CellID->9060311]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[46578, 1489, 226, 7, 70, "ExampleSection",
 CellID->10090],
Cell[46807, 1498, 118, 3, 70, "ExampleText",
 CellID->449874585],
Cell[CellGroupData[{
Cell[46950, 1505, 155, 5, 70, "Input",
 CellID->268043320],
Cell[47108, 1512, 262, 7, 36, "Output",
 CellID->106048111]
}, Open  ]],
Cell[CellGroupData[{
Cell[47407, 1524, 214, 8, 70, "Input",
 CellID->154941739],
Cell[47624, 1534, 292, 7, 36, "Output",
 CellID->458743153]
}, Open  ]],
Cell[47931, 1544, 125, 3, 70, "ExampleDelimiter",
 CellID->777259805],
Cell[48059, 1549, 127, 4, 70, "ExampleText",
 CellID->632184],
Cell[CellGroupData[{
Cell[48211, 1557, 293, 10, 70, "Input",
 CellID->19011457],
Cell[48507, 1569, 382, 13, 53, "Output",
 CellID->95712789]
}, Open  ]],
Cell[CellGroupData[{
Cell[48926, 1587, 107, 3, 70, "Input",
 CellID->72341539],
Cell[49036, 1592, 158, 5, 36, "Output",
 CellID->211045183]
}, Open  ]],
Cell[CellGroupData[{
Cell[49231, 1602, 543, 19, 70, "Input",
 CellID->75249245],
Cell[49777, 1623, 519, 18, 39, "Output",
 CellID->63342613]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[50357, 1648, 311, 9, 70, "SeeAlsoSection",
 CellID->26084],
Cell[50671, 1659, 955, 35, 70, "SeeAlso",
 CellID->25945]
}, Open  ]],
Cell[CellGroupData[{
Cell[51663, 1699, 314, 9, 70, "TutorialsSection",
 CellID->12693],
Cell[51980, 1710, 192, 4, 70, "Tutorials",
 CellID->10655]
}, Open  ]],
Cell[CellGroupData[{
Cell[52209, 1719, 319, 9, 70, "MoreAboutSection",
 CellID->521352012],
Cell[52531, 1730, 147, 3, 70, "MoreAbout",
 CellID->344770758]
}, Open  ]],
Cell[52693, 1736, 27, 0, 70, "History"],
Cell[52723, 1738, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

