(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    142997,       3865]
NotebookOptionsPosition[    129957,       3408]
NotebookOutlinePosition[    131271,       3446]
CellTagsIndexPosition[    131184,       3441]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals and Elliptic Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals and Elliptic Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"InverseJacobiDN" :> 
          Documentation`HelpLookup["paclet:ref/InverseJacobiDN"], "JacobiDC" :> 
          Documentation`HelpLookup["paclet:ref/JacobiDC"], "JacobiDS" :> 
          Documentation`HelpLookup["paclet:ref/JacobiDS"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"InverseJacobiDN\"\>", 
       2->"\<\"JacobiDC\"\>", 3->"\<\"JacobiDS\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Functions" :> 
          Documentation`HelpLookup["paclet:guide/EllipticFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Elliptic Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["JacobiDN", "ObjectName",
 CellID->4394],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["JacobiDN",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/JacobiDN"], "[", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Jacobi elliptic function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"dn", "(", 
        RowBox[{"u", "|", "m"}], ")"}], TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->25798]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"dn", "(", "u", ")"}], "=", 
    SqrtBox[
     RowBox[{"1", "-", 
      RowBox[{"m", " ", 
       RowBox[{
        SuperscriptBox["sin", "2"], "(", "\[Phi]", ")"}]}]}]]}], 
   TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Phi]", "=", 
    RowBox[{"am", "(", 
     RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->22262],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"dn", "(", 
    RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " a is doubly periodic function in ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " with periods ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", " ", 
    RowBox[{"K", "(", "m", ")"}]}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"4", " ", "\[ImaginaryI]", " ", 
    RowBox[{"K", "(", 
     RowBox[{"1", "-", "m"}], ")"}]}], TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox["K", TraditionalForm]], "InlineMath"],
 " is the elliptic integral ",
 Cell[BoxData[
  ButtonBox["EllipticK",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticK"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->154591450],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiDN",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiDN"]], "InlineFormula"],
 " is a meromorphic function in both arguments."
}], "Notes",
 CellID->496066754],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["JacobiDN",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiDN"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->305102371],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiDN",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiDN"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiDN",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiDN"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->276692411],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->266055745],

Cell["Evaluate numerically:", "ExampleText",
 CellID->76990609],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiDN", "[", 
  RowBox[{"4.", ",", 
   RowBox[{"2", "/", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->209198024],

Cell[BoxData["0.9988832842546816`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->536763349]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->773415040],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"JacobiDN", "[", 
    RowBox[{"x", ",", 
     RowBox[{"2", "/", "3"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->51460028],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30321364]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->293891961],

Cell["Series expansions about the origin:", "ExampleText",
 CellID->650576899],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"JacobiDN", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30530267],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "-", 
   FractionBox[
    RowBox[{"m", " ", 
     SuperscriptBox["z", "2"]}], "2"], "+", 
   RowBox[{
    FractionBox["1", "24"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"4", " ", "m"}], "+", 
      SuperscriptBox["m", "2"]}], ")"}], " ", 
    SuperscriptBox["z", "4"]}], "+", 
   RowBox[{
    FractionBox["1", "720"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "16"}], " ", "m"}], "-", 
      RowBox[{"44", " ", 
       SuperscriptBox["m", "2"]}], "-", 
      SuperscriptBox["m", "3"]}], ")"}], " ", 
    SuperscriptBox["z", "6"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "7"],
    SeriesData[$CellContext`z, 0, {}, 0, 7, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   1, 0, Rational[-1, 2] $CellContext`m, 0, 
    Rational[1, 24] (4 $CellContext`m + $CellContext`m^2), 0, 
    Rational[1, 720] ((-16) $CellContext`m - 
     44 $CellContext`m^2 - $CellContext`m^3)}, 0, 7, 1],
  Editable->False]], "Output",
 ImageSize->{371, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18541341]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"JacobiDN", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->63387534],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "z", "]"}], "2"], " ", "m"}], "+", 
   RowBox[{
    FractionBox["1", "32"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"8", " ", "z", " ", 
       RowBox[{"Cos", "[", "z", "]"}], " ", 
       RowBox[{"Sin", "[", "z", "]"}]}], "-", 
      RowBox[{"5", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", "z", "]"}], "2"]}], "-", 
      RowBox[{
       RowBox[{"Sin", "[", "z", "]"}], " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"3", " ", "z"}], "]"}]}]}], ")"}], " ", 
    SuperscriptBox["m", "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "m", "]"}], "3"],
    SeriesData[$CellContext`m, 0, {}, 0, 3, 1],
    Editable->False]}],
  SeriesData[$CellContext`m, 0, {
   1, Rational[-1, 2] Sin[$CellContext`z]^2, 
    Rational[1, 32] (8 $CellContext`z Cos[$CellContext`z] Sin[$CellContext`z] - 
     5 Sin[$CellContext`z]^2 - Sin[$CellContext`z] Sin[3 $CellContext`z])}, 0,
    3, 1],
  Editable->False]], "Output",
 ImageSize->{492, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->221113371]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2850],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->173838922],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiDN", "[", 
  RowBox[{
   RowBox[{"2.5", "-", "I"}], ",", 
   RowBox[{"1", "-", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->54319265],

Cell[BoxData[
 RowBox[{"0.9991672357965011`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.21735921296772737`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->458831513]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4931425],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->773462702],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"JacobiDN", "[", 
    RowBox[{"3", ",", 
     RowBox[{"1", "/", "3"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->396024805],

Cell[BoxData["0.\
9662630521002431898814655120898935113317582162686100368596798558776`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->73822054]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->90109144],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->190007974],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiDN", "[", 
  RowBox[{"3", ",", "0.33333333333333333333333333333333333333"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->72246360],

Cell[BoxData["0.96626305210024318988146551208989351133175821627`37.\
12837281158047"], "Output",
 ImageSize->{277, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27513991]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3330211],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiDN",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiDN"]], "InlineFormula"],
 " threads element\[Hyphen]wise over lists:"
}], "ExampleText",
 CellID->425068119],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiDN", "[", 
  RowBox[{"2", ",", 
   RowBox[{"{", 
    RowBox[{"0.2", ",", "0.8"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->362982229],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.90449084363051`", ",", "0.4590468540247685`"}], "}"}]], "Output",\

 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->547974092]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->344408209],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellID->27863076],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiDN", "[", 
    RowBox[{"z", ",", "0"}], "]"}], ",", 
   RowBox[{"JacobiDN", "[", 
    RowBox[{"z", ",", "1"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->226042640],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"Sech", "[", "z", "]"}]}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->119402878]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiDN", "[", 
    RowBox[{"0", ",", "m"}], "]"}], ",", 
   RowBox[{"JacobiDN", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"EllipticK", "[", "m", "]"}], "/", "2"}], ",", "m"}], "]"}], 
   ",", 
   RowBox[{"JacobiDN", "[", 
    RowBox[{
     RowBox[{"EllipticK", "[", "m", "]"}], ",", "m"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->150160566],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", "m"}], ")"}], 
    RowBox[{"1", "/", "4"}]], ",", 
   SqrtBox[
    RowBox[{"1", "-", "m"}]]}], "}"}]], "Output",
 ImageSize->{147, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->104810188]
}, Open  ]],

Cell["\<\
Parity transformations and periodicity relations are automatically applied:\
\>", "ExampleText",
 CellID->163771543],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiDN", "[", 
  RowBox[{
   RowBox[{"-", "u"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->16826860],

Cell[BoxData[
 RowBox[{"JacobiDN", "[", 
  RowBox[{"u", ",", "m"}], "]"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->464800095]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiDN", "[", 
  RowBox[{
   RowBox[{"u", "+", 
    RowBox[{"2", " ", 
     RowBox[{"EllipticK", "[", "m", "]"}]}], "+", 
    RowBox[{"4", "I", " ", 
     RowBox[{"EllipticK", "[", 
      RowBox[{"1", "-", "m"}], "]"}]}]}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->284029147],

Cell[BoxData[
 RowBox[{"JacobiDN", "[", 
  RowBox[{"u", ",", "m"}], "]"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->91191804]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->327547108],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->40852950],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"JacobiDN", "[", 
   RowBox[{"z", ",", "m"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->580788833],

Cell[BoxData[
 FormBox[
  RowBox[{"dn", "(", 
   RowBox[{"z", "\[VerticalSeparator]", "m"}], ")"}], 
  TraditionalForm]], "Output",
 ImageSize->{48, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->176413927]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1614],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiDN",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiDN"]], "InlineFormula"],
 " can be applied to a power series:"
}], "ExampleText",
 CellID->71074308],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiDN", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcSin", "[", "x", "]"}], "+", 
    RowBox[{
     RowBox[{"O", "[", "x", "]"}], "^", "8"}]}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->627179959],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "-", 
   FractionBox[
    RowBox[{"m", " ", 
     SuperscriptBox["x", "2"]}], "2"], "+", 
   FractionBox[
    RowBox[{
     SuperscriptBox["m", "2"], " ", 
     SuperscriptBox["x", "4"]}], "24"], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["m", "9"]}], "-", 
      FractionBox[
       RowBox[{"11", " ", 
        SuperscriptBox["m", "2"]}], "180"], "-", 
      FractionBox[
       SuperscriptBox["m", "3"], "720"], "+", 
      RowBox[{
       FractionBox["2", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox["m", "6"], "+", 
         FractionBox[
          SuperscriptBox["m", "2"], "24"]}], ")"}]}]}], ")"}], " ", 
    SuperscriptBox["x", "6"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "7"],
    SeriesData[$CellContext`x, 0, {}, 0, 7, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
   1, 0, Rational[-1, 2] $CellContext`m, 0, Rational[1, 24] $CellContext`m^2, 
    0, Rational[-1, 9] $CellContext`m + Rational[-11, 180] $CellContext`m^2 + 
    Rational[-1, 720] $CellContext`m^3 + 
    Rational[2, 3] (Rational[1, 6] $CellContext`m + 
      Rational[1, 24] $CellContext`m^2)}, 0, 7, 1],
  Editable->False]], "Output",
 ImageSize->{369, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->923125420]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32417],

Cell["Cartesian coordinates of a pendulum:", "ExampleText",
 CellID->413685466],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"x", "[", "t_", "]"}], "=", 
   RowBox[{"2", "\[ScriptL]", " ", 
    RowBox[{"Sin", "[", 
     FractionBox["\[CurlyPhi]0", "2"], "]"}], 
    RowBox[{"JacobiSN", "[", 
     RowBox[{
      RowBox[{"t", 
       SqrtBox[
        FractionBox["g", "\[ScriptL]"]]}], " ", ",", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        FractionBox["\[CurlyPhi]0", "2"], "]"}], "2"]}], "]"}], 
    RowBox[{"JacobiDN", "[", 
     RowBox[{
      RowBox[{"t", " ", 
       SqrtBox[
        FractionBox["g", "\[ScriptL]"]]}], " ", ",", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        FractionBox["\[CurlyPhi]0", "2"], "]"}], "2"]}], "]"}]}]}], ";", 
  RowBox[{
   RowBox[{"y", "[", "t_", "]"}], "=", 
   RowBox[{
    RowBox[{"-", "\[ScriptL]"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", 
       RowBox[{
        RowBox[{"JacobiDN", "[", 
         RowBox[{
          RowBox[{"t", 
           SqrtBox[
            FractionBox["g", "\[ScriptL]"]]}], ",", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            FractionBox["\[CurlyPhi]0", "2"], "]"}], "2"]}], "]"}], "^", 
        "2"}]}], " ", "-", " ", "1"}], ")"}]}]}], ";", " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->740998761],

Cell["Plot the time dependence of the coordinates:", "ExampleText",
 CellID->574231334],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "[", "t", "]"}], ",", 
       RowBox[{"y", "[", "t", "]"}]}], "}"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[ScriptL]", "\[Rule]", "1"}], ",", 
       RowBox[{"g", "\[Rule]", "9.81"}], ",", 
       RowBox[{"\[CurlyPhi]0", "\[Rule]", 
        RowBox[{"Pi", "/", "4"}]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->70736255],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->279649266]
}, Open  ]],

Cell["Plot the trajectory:", "ExampleText",
 CellID->61543944],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "[", "t", "]"}], ",", 
       RowBox[{"y", "[", "t", "]"}]}], "}"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[ScriptL]", "\[Rule]", "1"}], ",", 
       RowBox[{"g", "\[Rule]", "9.81"}], ",", 
       RowBox[{"\[CurlyPhi]0", "\[Rule]", 
        RowBox[{"Pi", "/", "2"}]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->112567201],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->715849437]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->249764751],

Cell[TextData[{
 "Uniformization of a Fermat cubic ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"a", "(", "u", ")"}], "3"], "+", 
     SuperscriptBox[
      RowBox[{"b", "(", "u", ")"}], "3"]}], "\[LongEqual]", "1"}], 
   TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->353292525],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "u_", "]"}], ":=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"m", "=", 
       RowBox[{
        RowBox[{"Sin", "[", 
         FractionBox["Pi", "12"], "]"}], "^", "2"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["3", 
          RowBox[{"1", "/", "4"}]], 
         RowBox[{"JacobiDN", "[", 
          RowBox[{"u", ",", "m"}], "]"}], 
         RowBox[{"JacobiSN", "[", 
          RowBox[{"u", ",", "m"}], "]"}]}], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"JacobiCN", "[", 
            RowBox[{"u", ",", "m"}], "]"}]}], ")"}], "2"]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["3", 
          RowBox[{"1", "/", "4"}]], 
         RowBox[{"JacobiDN", "[", 
          RowBox[{"u", ",", "m"}], "]"}], 
         RowBox[{"JacobiSN", "[", 
          RowBox[{"u", ",", "m"}], "]"}]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"JacobiCN", "[", 
            RowBox[{"u", ",", "m"}], "]"}]}], ")"}], "2"]}], ")"}]}]}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->134143926],

Cell[BoxData[
 RowBox[{
  RowBox[{"b", "[", "u_", "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"m", "=", 
      RowBox[{
       RowBox[{"Sin", "[", 
        FractionBox["Pi", "12"], "]"}], "^", "2"}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["2", 
        RowBox[{"11", "/", "6"}]], 
       SqrtBox[
        RowBox[{"1", "-", "m"}]], 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"JacobiCN", "[", 
          RowBox[{"u", ",", "m"}], "]"}]}], ")"}], 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{
          SqrtBox[
           FractionBox["m", 
            RowBox[{"1", "-", "m"}]]], 
          RowBox[{"JacobiCN", "[", 
           RowBox[{"u", ",", "m"}], "]"}]}]}], ")"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["3", 
         RowBox[{"1", "/", "4"}]], 
        RowBox[{"JacobiDN", "[", 
         RowBox[{"u", ",", "m"}], "]"}], 
        RowBox[{"JacobiSN", "[", 
         RowBox[{"u", ",", "m"}], "]"}]}], "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"JacobiCN", "[", 
           RowBox[{"u", ",", "m"}], "]"}]}], ")"}], "2"]}], ")"}]}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->553404245],

Cell["Check:", "ExampleText",
 CellID->100250154],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", "u", "]"}], "^", "3"}], "+", 
   RowBox[{
    RowBox[{"b", "[", "u", "]"}], "^", "3"}]}], "/.", 
  RowBox[{"u", "\[Rule]", 
   RowBox[{"RandomComplex", "[", 
    RowBox[{"WorkingPrecision", "\[Rule]", "20"}], "]"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->278094577],

Cell[BoxData[
 RowBox[{"0.99999999999999999999999999976`15.271570661449006", "+", 
  RowBox[{"0``15.35286674016303", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{202, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->152003936]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->452660956],

Cell["Conformal map from a unit triangle to the unit disk:", "ExampleText",
 CellID->671526214],

Cell[BoxData[
 RowBox[{
  RowBox[{"w", "[", "z_", "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Zeta]", "=", 
       RowBox[{"z", 
        FractionBox[
         SuperscriptBox[
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "/", "3"}], "]"}], "3"], 
         RowBox[{
          SuperscriptBox["2", 
           RowBox[{"1", "/", "3"}]], " ", 
          SuperscriptBox["3", 
           RowBox[{"1", "/", "4"}]], " ", "\[Pi]"}]]}]}], ",", 
      RowBox[{"m", "=", 
       RowBox[{
        RowBox[{"Sin", "[", 
         FractionBox["\[Pi]", "12"], "]"}], "^", "2"}]}]}], "}"}], ",", 
    RowBox[{
     SuperscriptBox["2", 
      RowBox[{"11", "/", "6"}]], 
     SqrtBox[
      RowBox[{"1", "-", "m"}]], 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"JacobiCN", "[", 
        RowBox[{"\[Zeta]", ",", "m"}], "]"}]}], ")"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         SqrtBox[
          FractionBox["m", 
           RowBox[{"1", "-", "m"}]]], 
         RowBox[{"JacobiCN", "[", 
          RowBox[{"\[Zeta]", ",", "m"}], "]"}]}]}], ")"}], "/", 
      "\[IndentingNewLine]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["3", 
          RowBox[{"1", "/", "4"}]], 
         RowBox[{"JacobiDN", "[", 
          RowBox[{"\[Zeta]", ",", "m"}], "]"}], 
         RowBox[{"JacobiSN", "[", 
          RowBox[{"\[Zeta]", ",", "m"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"JacobiCN", "[", 
            RowBox[{"\[Zeta]", ",", "m"}], "]"}]}], ")"}], "^", "2"}]}], 
       ")"}]}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->731004667],

Cell["Show points before and after the map:", "ExampleText",
 CellID->68040226],

Cell[BoxData[
 RowBox[{
  RowBox[{"trianglePoints", "=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", "=", 
       RowBox[{"E", "^", 
        RowBox[{"(", 
         RowBox[{"2", " ", "Pi", " ", 
          RowBox[{"I", "/", "3"}]}], ")"}]}]}], "}"}], ",", 
     RowBox[{"Flatten", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"\[Alpha]", "/", "8."}], " ", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"N", "[", 
              RowBox[{"#1", "+", 
               RowBox[{
                RowBox[{"j", "/", "16"}], 
                RowBox[{"(", 
                 RowBox[{"#2", "-", "#1"}], ")"}]}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"j", ",", "0", ",", "16"}], "}"}]}], "]"}]}], "&"}], "@@@",
          
         RowBox[{"(", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1", ",", "t"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", 
               RowBox[{"1", "/", "t"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"1", "/", "t"}], ",", "1"}], "}"}]}], "}"}], "/", 
           SqrtBox["3"]}], ")"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Alpha]", ",", "1", ",", "8"}], "}"}]}], "]"}], "]"}]}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->228000662],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Re", "[", "#", "]"}], ",", 
          RowBox[{"Im", "[", "#", "]"}]}], "}"}], "]"}], "&"}], "/@", 
      "trianglePoints"}], ",", 
     RowBox[{"Frame", " ", "\[Rule]", " ", "True"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Re", "[", "#", "]"}], ",", 
          RowBox[{"Im", "[", "#", "]"}]}], "}"}], "]"}], "&"}], "/@", 
      RowBox[{"w", "[", "trianglePoints", "]"}]}], ",", 
     RowBox[{"Frame", " ", "\[Rule]", " ", "True"}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->452602994],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 197},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->383595071]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2235510],

Cell["Solution of Nahm equations:", "ExampleText",
 CellID->635697979],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    SubscriptBox["T", "1"], "[", "z_", "]"}], " ", "=", " ", 
   RowBox[{
    RowBox[{"-", 
     SqrtBox[
      RowBox[{"m", " "}]]}], 
    RowBox[{"JacobiSN", "[", 
     RowBox[{"z", ",", "m"}], "]"}], " ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}], "/", 
     RowBox[{"Sqrt", "[", "2", "]"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    SubscriptBox["T", "2"], " ", "[", "z_", "]"}], " ", "=", " ", 
   RowBox[{"I", " ", 
    SqrtBox["m"], " ", 
    RowBox[{"JacobiCN", "[", 
     RowBox[{"z", ",", "m"}], "]"}], " ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "I", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "I"}], ",", "0", ",", "I"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "I"}], ",", "0"}], "}"}]}], "}"}], "/", 
     RowBox[{"Sqrt", "[", "2", "]"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    SubscriptBox["T", "3"], "[", "z_", "]"}], "  ", "=", " ", 
   RowBox[{"I", "  ", 
    RowBox[{"JacobiDN", "[", 
     RowBox[{"z", ",", "m"}], "]"}], " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "}"}]}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->199332200],

Cell["Check that the solutions fulfill the Nahm equations:", "ExampleText",
 CellID->88264601],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubsuperscriptBox["T", "1", "\[Prime]"], "[", "z", "]"}], "-", " ", 
  RowBox[{"I", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["T", "2"], "[", "z", "]"}], ".", " ", 
      RowBox[{
       SubscriptBox["T", "3"], "[", "z", "]"}]}], "-", 
     RowBox[{
      RowBox[{
       SubscriptBox["T", "3"], "[", "z", "]"}], ".", 
      RowBox[{
       SubscriptBox["T", "2"], "[", "z", "]"}]}]}], ")"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->196945766],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->672355840]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubsuperscriptBox["T", "2", "\[Prime]"], "[", "z", "]"}], "-", " ", 
  RowBox[{"I", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["T", "3"], "[", "z", "]"}], ".", 
      RowBox[{
       SubscriptBox["T", "1"], "[", "z", "]"}]}], "-", 
     RowBox[{
      RowBox[{
       SubscriptBox["T", "1"], "[", "z", "]"}], ".", " ", 
      RowBox[{
       SubscriptBox["T", "3"], "[", "z", "]"}]}]}], ")"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->14487075],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->327940089]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SubsuperscriptBox["T", "3", "\[Prime]"], "[", "z", "]"}], "-", " ", 
  RowBox[{"I", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["T", "1"], "[", "z", "]"}], ".", " ", 
      RowBox[{
       SubscriptBox["T", "2"], "[", "z", "]"}]}], "-", 
     RowBox[{
      RowBox[{
       SubscriptBox["T", "2"], "[", "z", "]"}], ".", 
      RowBox[{
       SubscriptBox["T", "1"], "[", "z", "]"}]}]}], ")"}]}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->361198223],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->278916895]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->136427460],

Cell[TextData[{
 "Periodic solution of the nonlinear Schr\[ODoubleDot]dinger equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[ImaginaryI]", " ", 
     RowBox[{
      SubscriptBox["\[PartialD]", "t"], 
      RowBox[{"\[Psi]", "(", 
       RowBox[{"x", ",", "t"}], ")"}]}]}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"-", " ", 
       RowBox[{
        SubscriptBox["\[PartialD]", 
         RowBox[{"x", ",", "x"}]], 
        RowBox[{"\[Psi]", "(", 
         RowBox[{"x", ",", "t"}], ")"}]}]}], "-", 
      RowBox[{"2", 
       SuperscriptBox[
        RowBox[{"\[LeftBracketingBar]", 
         RowBox[{"\[Psi]", "(", 
          RowBox[{"x", ",", "t"}], ")"}], "\[RightBracketingBar]"}], "2"], 
       RowBox[{"\[Psi]", "(", 
        RowBox[{"x", ",", "t"}], ")"}]}]}], "\[Equal]", "0"}]}], 
   TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->418699531],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Psi]", "[", 
   RowBox[{"x_", ",", "t_"}], "]"}], ":=", 
  RowBox[{"r", " ", 
   RowBox[{"Exp", "[", 
    RowBox[{"I", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"p", " ", "x"}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"p", "^", "2"}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"2", "-", 
             RowBox[{"k", "^", "2"}]}], ")"}], 
           RowBox[{"r", "^", "2"}]}]}], ")"}], "t"}]}], ")"}]}], "]"}], 
   RowBox[{"JacobiDN", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"r", " ", "x"}], "-", 
      RowBox[{"2", " ", "p", " ", "r", " ", "t"}]}], ",", 
     RowBox[{"k", "^", "2"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->789859221],

Cell["Plot the solution:", "ExampleText",
 CellID->242091117],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Abs", "[", 
       RowBox[{"\[Psi]", "[", 
        RowBox[{"x", ",", "t"}], "]"}], "]"}], "^", "2"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"r", "\[Rule]", "2"}], ",", 
       RowBox[{"p", "\[Rule]", 
        RowBox[{"1", "/", "3"}]}], ",", 
       RowBox[{"k", "\[Rule]", 
        RowBox[{"1", "/", "2"}]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->357173803],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->823467407]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->117448026],

Cell[TextData[{
 "Parametrize a lemniscate by arc length [",
 ButtonBox["more info",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://mathworld.wolfram.com/Lemniscate.html"], None}],
 "]:"
}], "ExampleText",
 CellID->364332975],

Cell[BoxData[
 RowBox[{
  RowBox[{"lemniscate", "[", "s_", "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"JacobiCN", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Sqrt", "[", "2", "]"}], "s"}], ",", 
       RowBox[{"1", "/", "2"}]}], "]"}], 
     RowBox[{"JacobiDN", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Sqrt", "[", "2", "]"}], "s"}], ",", 
       RowBox[{"1", "/", "2"}]}], "]"}]}], ",", 
    RowBox[{
     RowBox[{"JacobiCN", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Sqrt", "[", "2", "]"}], "s"}], ",", 
       RowBox[{"1", "/", "2"}]}], "]"}], 
     RowBox[{
      RowBox[{"JacobiSN", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sqrt", "[", "2", "]"}], "s"}], ",", 
        RowBox[{"1", "/", "2"}]}], "]"}], "/", 
      RowBox[{"Sqrt", "[", "2", "]"}]}]}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->281536705],

Cell["\<\
Show arc length parametrization and classical parametrization:\
\>", "ExampleText",
 CellID->120899182],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"r", "[", "\[Theta]_", "]"}], ":=", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Cos", "[", 
         RowBox[{"2", "\[Theta]"}], "]"}], ">", "0"}], ",", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"Cos", "[", 
         RowBox[{"2", "\[Theta]"}], "]"}], "]"}], ",", "0"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"ParametricPlot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"r", "[", "\[Theta]", "]"}], 
         RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ",", 
        RowBox[{
         RowBox[{"r", "[", "\[Theta]", "]"}], 
         RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Theta]", ",", 
        RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}]}], "]"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"lemniscate", "[", "s", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"s", ",", "0", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "/", "4"}], "]"}], "^", "2"}], "/", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"2", "Pi"}], "]"}]}]}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->447887484],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 64},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->39800204]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->240816424],

Cell["\<\
Zero modes of the periodic supersymmetric partner potentials:\
\>", "ExampleText",
 CellID->972219022],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["V", "+"], "[", "z_", "]"}], ":=", 
  RowBox[{"2", "-", "m", "+", 
   RowBox[{"2", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"m", "-", "1"}], ")"}], "/", 
     SuperscriptBox[
      RowBox[{"JacobiDN", "[", 
       RowBox[{"z", ",", "m"}], "]"}], "2"]}]}]}]}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["\[Psi]", "+"], "[", "z_", "]"}], ":=", 
  RowBox[{"1", "/", 
   RowBox[{"JacobiDN", "[", 
    RowBox[{"z", ",", "m"}], "]"}]}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->550033252],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   SubscriptBox["V", "-"], "[", "z_", "]"}], ":=", 
  RowBox[{"2", "-", "m", "-", 
   RowBox[{"2", 
    SuperscriptBox[
     RowBox[{"JacobiDN", "[", 
      RowBox[{"z", ",", "m"}], "]"}], "2"]}]}]}], "\n", 
 RowBox[{
  RowBox[{
   SubscriptBox["\[Psi]", "-"], "[", "z_", "]"}], ":=", 
  RowBox[{"JacobiDN", "[", 
   RowBox[{"z", ",", "m"}], "]"}]}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->1563824],

Cell["Plot the zero modes:", "ExampleText",
 CellID->72783326],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SubscriptBox["V", "+"], "[", "z", "]"}], ",", 
         RowBox[{
          SubscriptBox["\[Psi]", "+"], "[", "z", "]"}]}], "}"}], "/.", 
       RowBox[{"m", "\[Rule]", 
        RowBox[{"1", "/", "2"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SubscriptBox["V", "-"], "[", "z", "]"}], ",", 
         RowBox[{
          SubscriptBox["\[Psi]", "-"], "[", "z", "]"}]}], "}"}], "/.", 
       RowBox[{"m", "\[Rule]", 
        RowBox[{"1", "/", "2"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", 
       RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->28368171],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->45687179]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->811154132],

Cell["Complex parametrization of a \"sphere\":", "ExampleText",
 CellID->243390820],

Cell[BoxData[
 RowBox[{
  RowBox[{"ellipticSphere", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\[Alpha]_", ",", "\[Beta]_"}], "}"}], ",", "m_"}], "]"}], ":=", 
  
  RowBox[{"{", " ", 
   RowBox[{
    RowBox[{
     SuperscriptBox["m", 
      RowBox[{"1", "/", "2"}]], 
     RowBox[{"JacobiSN", "[", 
      RowBox[{"\[Alpha]", ",", "m"}], "]"}], 
     RowBox[{"JacobiSN", "[", 
      RowBox[{"\[Beta]", ",", "m"}], "]"}]}], ",", 
    RowBox[{"I", " ", 
     FractionBox[
      SuperscriptBox["m", 
       RowBox[{"1", "/", "2"}]], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", "m"}], ")"}], 
       RowBox[{"1", "/", "2"}]]], " ", 
     RowBox[{"JacobiCN", "[", 
      RowBox[{"\[Alpha]", ",", "m"}], "]"}], 
     RowBox[{"JacobiCN", "[", 
      RowBox[{"\[Beta]", ",", "m"}], "]"}]}], ",", 
    RowBox[{
     FractionBox["1", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", "m"}], ")"}], 
       RowBox[{"1", "/", "2"}]]], " ", 
     RowBox[{"JacobiDN", "[", 
      RowBox[{"\[Alpha]", ",", "m"}], "]"}], 
     RowBox[{"JacobiDN", "[", 
      RowBox[{"\[Beta]", ",", "m"}], "]"}]}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->153656900],

Cell["Plot real and imaginary parts and norm:", "ExampleText",
 CellID->50528397],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"Re", "[", 
       RowBox[{"ellipticSphere", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\[Alpha]", ",", "\[Beta]"}], "}"}], ",", "0.3"}], "]"}], 
       "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Alpha]", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Beta]", ",", "1", ",", "2"}], "}"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{"Im", "[", 
       RowBox[{"ellipticSphere", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\[Alpha]", ",", "\[Beta]"}], "}"}], ",", "0.3"}], "]"}], 
       "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Alpha]", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Beta]", ",", "1", ",", "2"}], "}"}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->183115405],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->386732546]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21951],

Cell["Compose with inverse functions:", "ExampleText",
 CellID->38733992],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiDN", "[", 
    RowBox[{
     RowBox[{"InverseJacobiDN", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], ",", 
   RowBox[{"InverseJacobiDN", "[", 
    RowBox[{
     RowBox[{"JacobiDN", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->91105571],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", 
   RowBox[{"InverseJacobiDN", "[", 
    RowBox[{
     RowBox[{"JacobiDN", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}]}], "}"}]], "Output",
 ImageSize->{269, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->384996679]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " to disregard multivaluedness of the inverse function:"
}], "ExampleText",
 CellID->785308763],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29056615],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", "z"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->583422866]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->41386813],

Cell[TextData[{
 "Evaluate as a result of applying ",
 Cell[BoxData[
  ButtonBox["D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/D"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["JacobiAmplitude",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiAmplitude"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->171326640],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"JacobiAmplitude", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->537033367],

Cell[BoxData[
 RowBox[{"JacobiDN", "[", 
  RowBox[{"z", ",", "m"}], "]"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->41363374]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13124148],

Cell["Solve a transcendental equation:", "ExampleText",
 CellID->174253363],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"JacobiDN", "[", 
       RowBox[{"x", ",", "m"}], "]"}], "2"], "+", 
     RowBox[{"3", 
      RowBox[{"JacobiDN", "[", 
       RowBox[{"x", ",", "m"}], "]"}]}]}], "==", "a"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->135344533],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->74619039],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"InverseJacobiDN", "[", 
      RowBox[{
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "-", 
          SqrtBox[
           RowBox[{"9", "+", 
            RowBox[{"4", " ", "a"}]}]]}], ")"}]}], ",", "m"}], "]"}]}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"InverseJacobiDN", "[", 
      RowBox[{
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "+", 
          SqrtBox[
           RowBox[{"9", "+", 
            RowBox[{"4", " ", "a"}]}]]}], ")"}]}], ",", "m"}], "]"}]}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{302, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->137685779]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->50397331],

Cell["Integrals:", "ExampleText",
 CellID->431065787],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"JacobiDN", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", " ", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->502017555],

Cell[BoxData[
 RowBox[{"JacobiAmplitude", "[", 
  RowBox[{"z", ",", "m"}], "]"}]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->707687918]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"JacobiDN", "[", 
     RowBox[{"z", ",", "m"}], "]"}], "^", "3"}], ",", " ", "z"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17456227],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", "-", "m"}], ")"}], " ", 
     RowBox[{"JacobiAmplitude", "[", 
      RowBox[{"z", ",", "m"}], "]"}]}], "+", 
    RowBox[{"m", " ", 
     RowBox[{"JacobiCN", "[", 
      RowBox[{"z", ",", "m"}], "]"}], " ", 
     RowBox[{"JacobiSN", "[", 
      RowBox[{"z", ",", "m"}], "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{436, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->18847075]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21754],

Cell["\<\
Machine-precision input is insufficient to give the correct answer:\
\>", "ExampleText",
 CellID->93054834],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiDN", "[", 
  RowBox[{
   RowBox[{"10.", "^", "15"}], ",", "Pi"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->179876951],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.3232199991137299`"}], "-", 
  RowBox[{"7.236033061804037`*^-17", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{175, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->277347165]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"JacobiDN", "[", 
    RowBox[{
     RowBox[{"10", "^", "15"}], ",", "Pi"}], "]"}], ",", "20"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->145974042],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.18397333819277250684581866418605013773`20.15051499783199"}],
   "+", 
  RowBox[{"0``20.88576010914174", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{245, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->553070]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25780883],

Cell["\<\
Currently only simple simplification rules are built in for Jacobi functions:\
\
\>", "ExampleText",
 CellID->462276132],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"JacobiDN", "[", 
     RowBox[{"u", ",", "m"}], "]"}], "^", "2"}], "+", 
   RowBox[{"m", " ", 
    RowBox[{
     RowBox[{"JacobiSN", "[", 
      RowBox[{"u", ",", "m"}], "]"}], "^", "2"}]}], "-", "1"}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->378012421],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  SuperscriptBox[
   RowBox[{"JacobiDN", "[", 
    RowBox[{"u", ",", "m"}], "]"}], "2"], "+", 
  RowBox[{"m", " ", 
   SuperscriptBox[
    RowBox[{"JacobiSN", "[", 
     RowBox[{"u", ",", "m"}], "]"}], "2"]}]}]], "Output",
 ImageSize->{256, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->73255821]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"JacobiDN", "[", 
    RowBox[{"u", ",", "m"}], "]"}], 
   RowBox[{"JacobiNS", "[", 
    RowBox[{"u", ",", "m"}], "]"}], 
   RowBox[{"JacobiSD", "[", 
    RowBox[{"u", ",", "m"}], "]"}]}], "//", "FullSimplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->72520131],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->65420492]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1895],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseJacobiDN",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseJacobiDN"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiDC",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiDC"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiDS",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiDS"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3097]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10061],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "Tutorials",
 CellID->14272]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->20696491],

Cell[TextData[ButtonBox["Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticFunctions"]], "MoreAbout",
 CellID->24122086]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"JacobiDN - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 51, 30.7627684}", "context" -> "System`", 
    "keywords" -> {
     "dn", "dnoid", "doubly periodic function", "elliptic Jacobi function", 
      "Jacobi elliptic function dn"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "JacobiDN[u, m] gives the Jacobi elliptic function dn(u | m).", 
    "synonyms" -> {"Jacobi DN"}, "title" -> "JacobiDN", "type" -> "Symbol", 
    "uri" -> "ref/JacobiDN"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6265, 224, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->276692411]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 131041, 3434}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2018, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2641, 77, 45, 1, 70, "ObjectName",
 CellID->4394],
Cell[2689, 80, 676, 22, 70, "Usage",
 CellID->25798]
}, Open  ]],
Cell[CellGroupData[{
Cell[3402, 107, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3880, 124, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4003, 130, 495, 20, 70, "Notes",
 CellID->22262],
Cell[4501, 152, 832, 30, 70, "Notes",
 CellID->154591450],
Cell[5336, 184, 216, 7, 70, "Notes",
 CellID->496066754],
Cell[5555, 193, 248, 8, 70, "Notes",
 CellID->305102371],
Cell[5806, 203, 218, 7, 70, "Notes",
 CellID->31226],
Cell[6027, 212, 201, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6265, 224, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->276692411],
Cell[CellGroupData[{
Cell[6650, 238, 148, 5, 70, "ExampleSection",
 CellID->266055745],
Cell[6801, 245, 63, 1, 70, "ExampleText",
 CellID->76990609],
Cell[CellGroupData[{
Cell[6889, 250, 152, 5, 28, "Input",
 CellID->209198024],
Cell[7044, 257, 176, 5, 36, "Output",
 CellID->536763349]
}, Open  ]],
Cell[7235, 265, 125, 3, 70, "ExampleDelimiter",
 CellID->773415040],
Cell[CellGroupData[{
Cell[7385, 272, 289, 10, 28, "Input",
 CellID->51460028],
Cell[7677, 284, 3961, 69, 168, "Output",
 Evaluatable->False,
 CellID->30321364]
}, Open  ]],
Cell[11653, 356, 125, 3, 70, "ExampleDelimiter",
 CellID->293891961],
Cell[11781, 361, 78, 1, 70, "ExampleText",
 CellID->650576899],
Cell[CellGroupData[{
Cell[11884, 366, 244, 8, 70, "Input",
 CellID->30530267],
Cell[12131, 376, 1191, 38, 54, "Output",
 CellID->18541341]
}, Open  ]],
Cell[CellGroupData[{
Cell[13359, 419, 244, 8, 70, "Input",
 CellID->63387534],
Cell[13606, 429, 1238, 37, 51, "Output",
 CellID->221113371]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14893, 472, 215, 7, 70, "ExampleSection",
 CellID->2850],
Cell[15111, 481, 74, 1, 70, "ExampleText",
 CellID->173838922],
Cell[CellGroupData[{
Cell[15210, 486, 176, 6, 70, "Input",
 CellID->54319265],
Cell[15389, 494, 274, 7, 36, "Output",
 CellID->458831513]
}, Open  ]],
Cell[15678, 504, 123, 3, 70, "ExampleDelimiter",
 CellID->4931425],
Cell[15804, 509, 70, 1, 70, "ExampleText",
 CellID->773462702],
Cell[CellGroupData[{
Cell[15899, 514, 208, 7, 70, "Input",
 CellID->396024805],
Cell[16110, 523, 234, 7, 36, "Output",
 CellID->73822054]
}, Open  ]],
Cell[16359, 533, 124, 3, 70, "ExampleDelimiter",
 CellID->90109144],
Cell[16486, 538, 113, 3, 70, "ExampleText",
 CellID->190007974],
Cell[CellGroupData[{
Cell[16624, 545, 168, 5, 70, "Input",
 CellID->72246360],
Cell[16795, 552, 226, 6, 36, "Output",
 CellID->27513991]
}, Open  ]],
Cell[17036, 561, 123, 3, 70, "ExampleDelimiter",
 CellID->3330211],
Cell[17162, 566, 218, 7, 70, "ExampleText",
 CellID->425068119],
Cell[CellGroupData[{
Cell[17405, 577, 180, 6, 70, "Input",
 CellID->362982229],
Cell[17588, 585, 240, 8, 36, "Output",
 CellID->547974092]
}, Open  ]],
Cell[17843, 596, 125, 3, 70, "ExampleDelimiter",
 CellID->344408209],
Cell[17971, 601, 90, 1, 70, "ExampleText",
 CellID->27863076],
Cell[CellGroupData[{
Cell[18086, 606, 237, 8, 70, "Input",
 CellID->226042640],
Cell[18326, 616, 235, 8, 36, "Output",
 CellID->119402878]
}, Open  ]],
Cell[CellGroupData[{
Cell[18598, 629, 420, 15, 70, "Input",
 CellID->150160566],
Cell[19021, 646, 353, 13, 43, "Output",
 CellID->104810188]
}, Open  ]],
Cell[19389, 662, 126, 3, 70, "ExampleText",
 CellID->163771543],
Cell[CellGroupData[{
Cell[19540, 669, 145, 5, 70, "Input",
 CellID->16826860],
Cell[19688, 676, 216, 7, 36, "Output",
 CellID->464800095]
}, Open  ]],
Cell[CellGroupData[{
Cell[19941, 688, 321, 10, 70, "Input",
 CellID->284029147],
Cell[20265, 700, 215, 7, 36, "Output",
 CellID->91191804]
}, Open  ]],
Cell[20495, 710, 125, 3, 70, "ExampleDelimiter",
 CellID->327547108],
Cell[20623, 715, 202, 7, 70, "ExampleText",
 CellID->40852950],
Cell[CellGroupData[{
Cell[20850, 726, 166, 5, 70, "Input",
 CellID->580788833],
Cell[21019, 733, 278, 9, 50, "Output",
 CellID->176413927]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21346, 748, 238, 7, 70, "ExampleSection",
 CellID->1614],
Cell[21587, 757, 210, 7, 70, "ExampleText",
 CellID->71074308],
Cell[CellGroupData[{
Cell[21822, 768, 242, 8, 70, "Input",
 CellID->627179959],
Cell[22067, 778, 1426, 44, 54, "Output",
 CellID->923125420]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23542, 828, 223, 7, 70, "ExampleSection",
 CellID->32417],
Cell[23768, 837, 79, 1, 70, "ExampleText",
 CellID->413685466],
Cell[23850, 840, 1260, 41, 70, "Input",
 CellID->740998761],
Cell[25113, 883, 87, 1, 70, "ExampleText",
 CellID->574231334],
Cell[CellGroupData[{
Cell[25225, 888, 581, 18, 70, "Input",
 CellID->70736255],
Cell[25809, 908, 5080, 87, 70, "Output",
 Evaluatable->False,
 CellID->279649266]
}, Open  ]],
Cell[30904, 998, 62, 1, 70, "ExampleText",
 CellID->61543944],
Cell[CellGroupData[{
Cell[30991, 1003, 592, 18, 70, "Input",
 CellID->112567201],
Cell[31586, 1023, 2721, 49, 70, "Output",
 Evaluatable->False,
 CellID->715849437]
}, Open  ]],
Cell[34322, 1075, 125, 3, 70, "ExampleDelimiter",
 CellID->249764751],
Cell[34450, 1080, 343, 13, 70, "ExampleText",
 CellID->353292525],
Cell[34796, 1095, 1316, 42, 70, "Input",
 CellID->134143926],
Cell[36115, 1139, 1337, 45, 70, "Input",
 CellID->553404245],
Cell[37455, 1186, 49, 1, 70, "ExampleText",
 CellID->100250154],
Cell[CellGroupData[{
Cell[37529, 1191, 341, 11, 70, "Input",
 CellID->278094577],
Cell[37873, 1204, 284, 7, 36, "Output",
 CellID->152003936]
}, Open  ]],
Cell[38172, 1214, 125, 3, 70, "ExampleDelimiter",
 CellID->452660956],
Cell[38300, 1219, 95, 1, 70, "ExampleText",
 CellID->671526214],
Cell[38398, 1222, 1754, 57, 70, "Input",
 CellID->731004667],
Cell[40155, 1281, 79, 1, 70, "ExampleText",
 CellID->68040226],
Cell[40237, 1284, 1492, 46, 70, "Input",
 CellID->228000662],
Cell[CellGroupData[{
Cell[41754, 1334, 868, 28, 70, "Input",
 CellID->452602994],
Cell[42625, 1364, 8671, 146, 70, "Output",
 Evaluatable->False,
 CellID->383595071]
}, Open  ]],
Cell[51311, 1513, 123, 3, 70, "ExampleDelimiter",
 CellID->2235510],
Cell[51437, 1518, 70, 1, 70, "ExampleText",
 CellID->635697979],
Cell[51510, 1521, 1756, 58, 70, "Input",
 CellID->199332200],
Cell[53269, 1581, 94, 1, 70, "ExampleText",
 CellID->88264601],
Cell[CellGroupData[{
Cell[53388, 1586, 530, 18, 70, "Input",
 CellID->196945766],
Cell[53921, 1606, 391, 13, 36, "Output",
 CellID->672355840]
}, Open  ]],
Cell[CellGroupData[{
Cell[54349, 1624, 529, 18, 70, "Input",
 CellID->14487075],
Cell[54881, 1644, 391, 13, 36, "Output",
 CellID->327940089]
}, Open  ]],
Cell[CellGroupData[{
Cell[55309, 1662, 530, 18, 70, "Input",
 CellID->361198223],
Cell[55842, 1682, 391, 13, 36, "Output",
 CellID->278916895]
}, Open  ]],
Cell[56248, 1698, 125, 3, 70, "ExampleDelimiter",
 CellID->136427460],
Cell[56376, 1703, 890, 28, 70, "ExampleText",
 CellID->418699531],
Cell[57269, 1733, 769, 26, 70, "Input",
 CellID->789859221],
Cell[58041, 1761, 61, 1, 70, "ExampleText",
 CellID->242091117],
Cell[CellGroupData[{
Cell[58127, 1766, 686, 22, 70, "Input",
 CellID->357173803],
Cell[58816, 1790, 22974, 381, 70, "Output",
 Evaluatable->False,
 CellID->823467407]
}, Open  ]],
Cell[81805, 2174, 125, 3, 70, "ExampleDelimiter",
 CellID->117448026],
Cell[81933, 2179, 236, 8, 70, "ExampleText",
 CellID->364332975],
Cell[82172, 2189, 896, 30, 70, "Input",
 CellID->281536705],
Cell[83071, 2221, 113, 3, 70, "ExampleText",
 CellID->120899182],
Cell[CellGroupData[{
Cell[83209, 2228, 1369, 42, 70, "Input",
 CellID->447887484],
Cell[84581, 2272, 5123, 88, 70, "Output",
 Evaluatable->False,
 CellID->39800204]
}, Open  ]],
Cell[89719, 2363, 125, 3, 70, "ExampleDelimiter",
 CellID->240816424],
Cell[89847, 2368, 112, 3, 70, "ExampleText",
 CellID->972219022],
Cell[89962, 2373, 546, 19, 70, "Input",
 CellID->550033252],
Cell[90511, 2394, 438, 15, 70, "Input",
 CellID->1563824],
Cell[90952, 2411, 62, 1, 70, "ExampleText",
 CellID->72783326],
Cell[CellGroupData[{
Cell[91039, 2416, 1069, 35, 70, "Input",
 CellID->28368171],
Cell[92111, 2453, 6852, 116, 70, "Output",
 Evaluatable->False,
 CellID->45687179]
}, Open  ]],
Cell[98978, 2572, 125, 3, 70, "ExampleDelimiter",
 CellID->811154132],
Cell[99106, 2577, 83, 1, 70, "ExampleText",
 CellID->243390820],
Cell[99192, 2580, 1198, 39, 70, "Input",
 CellID->153656900],
Cell[100393, 2621, 81, 1, 70, "ExampleText",
 CellID->50528397],
Cell[CellGroupData[{
Cell[100499, 2626, 1021, 32, 70, "Input",
 CellID->183115405],
Cell[101523, 2660, 17203, 286, 70, "Output",
 Evaluatable->False,
 CellID->386732546]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[118775, 2952, 233, 7, 70, "ExampleSection",
 CellID->21951],
Cell[119011, 2961, 73, 1, 70, "ExampleText",
 CellID->38733992],
Cell[CellGroupData[{
Cell[119109, 2966, 380, 12, 70, "Input",
 CellID->91105571],
Cell[119492, 2980, 337, 11, 36, "Output",
 CellID->384996679]
}, Open  ]],
Cell[119844, 2994, 246, 8, 70, "ExampleText",
 CellID->785308763],
Cell[CellGroupData[{
Cell[120115, 3006, 106, 3, 70, "Input",
 CellID->29056615],
Cell[120224, 3011, 203, 7, 36, "Output",
 CellID->583422866]
}, Open  ]],
Cell[120442, 3021, 124, 3, 70, "ExampleDelimiter",
 CellID->41386813],
Cell[120569, 3026, 344, 13, 70, "ExampleText",
 CellID->171326640],
Cell[CellGroupData[{
Cell[120938, 3043, 188, 6, 70, "Input",
 CellID->537033367],
Cell[121129, 3051, 215, 7, 36, "Output",
 CellID->41363374]
}, Open  ]],
Cell[121359, 3061, 124, 3, 70, "ExampleDelimiter",
 CellID->13124148],
Cell[121486, 3066, 75, 1, 70, "ExampleText",
 CellID->174253363],
Cell[CellGroupData[{
Cell[121586, 3071, 359, 13, 70, "Input",
 CellID->135344533],
Cell[121948, 3086, 452, 8, 70, "Message",
 CellID->74619039],
Cell[122403, 3096, 917, 33, 81, "Output",
 CellID->137685779]
}, Open  ]],
Cell[123335, 3132, 124, 3, 70, "ExampleDelimiter",
 CellID->50397331],
Cell[123462, 3137, 53, 1, 70, "ExampleText",
 CellID->431065787],
Cell[CellGroupData[{
Cell[123540, 3142, 194, 6, 70, "Input",
 CellID->502017555],
Cell[123737, 3150, 223, 7, 36, "Output",
 CellID->707687918]
}, Open  ]],
Cell[CellGroupData[{
Cell[123997, 3162, 222, 8, 70, "Input",
 CellID->17456227],
Cell[124222, 3172, 563, 19, 51, "Output",
 CellID->18847075]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[124834, 3197, 226, 7, 70, "ExampleSection",
 CellID->21754],
Cell[125063, 3206, 117, 3, 70, "ExampleText",
 CellID->93054834],
Cell[CellGroupData[{
Cell[125205, 3213, 155, 5, 70, "Input",
 CellID->179876951],
Cell[125363, 3220, 274, 8, 36, "Output",
 CellID->277347165]
}, Open  ]],
Cell[CellGroupData[{
Cell[125674, 3233, 214, 8, 70, "Input",
 CellID->145974042],
Cell[125891, 3243, 310, 9, 36, "Output",
 CellID->553070]
}, Open  ]],
Cell[126216, 3255, 124, 3, 70, "ExampleDelimiter",
 CellID->25780883],
Cell[126343, 3260, 130, 4, 70, "ExampleText",
 CellID->462276132],
Cell[CellGroupData[{
Cell[126498, 3268, 341, 12, 70, "Input",
 CellID->378012421],
Cell[126842, 3282, 404, 14, 36, "Output",
 CellID->73255821]
}, Open  ]],
Cell[CellGroupData[{
Cell[127283, 3301, 309, 10, 70, "Input",
 CellID->72520131],
Cell[127595, 3313, 157, 5, 36, "Output",
 CellID->65420492]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[127813, 3325, 310, 9, 70, "SeeAlsoSection",
 CellID->1895],
Cell[128126, 3336, 709, 26, 70, "SeeAlso",
 CellID->3097]
}, Open  ]],
Cell[CellGroupData[{
Cell[128872, 3367, 314, 9, 70, "TutorialsSection",
 CellID->10061],
Cell[129189, 3378, 192, 4, 70, "Tutorials",
 CellID->14272]
}, Open  ]],
Cell[CellGroupData[{
Cell[129418, 3387, 318, 9, 70, "MoreAboutSection",
 CellID->20696491],
Cell[129739, 3398, 146, 3, 70, "MoreAbout",
 CellID->24122086]
}, Open  ]],
Cell[129900, 3404, 27, 0, 70, "History"],
Cell[129930, 3406, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

