(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     41404,       1478]
NotebookOptionsPosition[     33738,       1211]
NotebookOutlinePosition[     35022,       1248]
CellTagsIndexPosition[     34936,       1243]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Orthogonal Polynomials" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OrthogonalPolynomials"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Orthogonal Polynomials\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LegendreP" :> Documentation`HelpLookup["paclet:ref/LegendreP"],
           "ZernikeR" :> Documentation`HelpLookup["paclet:ref/ZernikeR"], 
          "ChebyshevT" :> Documentation`HelpLookup["paclet:ref/ChebyshevT"], 
          "ChebyshevU" :> Documentation`HelpLookup["paclet:ref/ChebyshevU"], 
          "GegenbauerC" :> 
          Documentation`HelpLookup["paclet:ref/GegenbauerC"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"LegendreP\"\>", 
       2->"\<\"ZernikeR\"\>", 3->"\<\"ChebyshevT\"\>", 
       4->"\<\"ChebyshevU\"\>", 5->"\<\"GegenbauerC\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functions Used in Quantum Mechanics" :> 
          Documentation`HelpLookup[
           "paclet:guide/FunctionsUsedInQuantumMechanics"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Functions Used in Quantum Mechanics\"\>", 
       2->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["JacobiP", "ObjectName",
 CellID->17862],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["JacobiP",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/JacobiP"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["a", "TI"], ",", 
        StyleBox["b", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Jacobi polynomial ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubsuperscriptBox["P", "n", 
         RowBox[{"(", 
          RowBox[{"a", ",", "b"}], ")"}]], "(", "x", ")"}], TraditionalForm]],
       "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4482]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell["Explicit polynomials are given when possible. ", "Notes",
 CellID->15305],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["P", "n", 
     RowBox[{"(", 
      RowBox[{"a", ",", "b"}], ")"}]], "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 " satisfies the differential equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"]}], ")"}], 
      SuperscriptBox["y", "\[Prime]\[Prime]"]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b", "-", "a", "-", 
        RowBox[{"(", 
         RowBox[{"a", "+", "b", "+", "2"}], ")"}], "x"}], ")"}], 
      SuperscriptBox["y", "\[Prime]"]}], "+", 
     RowBox[{"n", 
      RowBox[{"(", 
       RowBox[{"n", "+", "a", "+", "b", "+", "1"}], ")"}], "y"}]}], "=", 
    "0"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->20909],

Cell[TextData[{
 "The Jacobi polynomials are orthogonal with weight function ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", "x"}], ")"}], "a"], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}], "b"]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->22317],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["JacobiP",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiP"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->67944623],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiP",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiP"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiP",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiP"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["JacobiP",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiP"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " has a branch cut discontinuity in the complex ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " plane running from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->27221]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->302766427],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->317243255],

Cell[TextData[{
 "Compute the 2",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "nd"], TraditionalForm]]],
 " Jacobi polynomial:"
}], "ExampleText",
 CellID->87637193],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiP", "[", 
  RowBox[{"2", ",", "a", ",", "b", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->570954243],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "a"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", "a"}], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", "a"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"3", "+", "a", "+", "b"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "z"}], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", "8"], " ", 
   RowBox[{"(", 
    RowBox[{"3", "+", "a", "+", "b"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"4", "+", "a", "+", "b"}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "z"}], ")"}], "2"]}]}]], "Output",
 ImageSize->{492, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->422437482]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->102805808],

Cell[TextData[{
 "Plot ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["P", "10", 
     RowBox[{"(", 
      RowBox[{"2", ",", "2"}], ")"}]], "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->776150112],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"JacobiP", "[", 
    RowBox[{"10", ",", "2", ",", "2", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->66518959],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32512093]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11058],

Cell["Evaluate for fractional orders:", "ExampleText",
 CellID->204369770],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LegendreP", "[", 
  RowBox[{
   RowBox[{"3", "/", "2"}], ",", "1.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1026262214],

Cell[BoxData["2.034342748581157`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->851969705]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->127540731],

Cell["Evaluate for complex orders and arguments:", "ExampleText",
 CellID->39108213],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiP", "[", 
  RowBox[{
   RowBox[{"3", " ", "+", " ", "I"}], ",", "1", ",", "3", ",", 
   RowBox[{"4.0", "-", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->271117521],

Cell[BoxData[
 RowBox[{"268.52957777035977`", "\[InvisibleSpace]", "+", 
  RowBox[{"1139.2581434471015`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{119, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->141233926]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->369072761],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->636586426],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"JacobiP", "[", " ", 
    RowBox[{
     RowBox[{"3", "+", "I"}], ",", 
     RowBox[{
      RowBox[{"-", "I"}], "/", "2"}], ",", "3", ",", "4"}], "]"}], ",", 
   "30"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->65832899],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "-", "103.22368893777063039324216706237133071323`29.442574924102793"}], "+",
   
  RowBox[{
  "516.67910179989548546500182441034283827193`30.142016444495972", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{470, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->462879634]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->82858706],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->493308527],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiP", "[", 
  RowBox[{
   RowBox[{"3", "+", "I"}], ",", 
   RowBox[{
    RowBox[{"-", "I"}], "/", "2"}], ",", "3", ",", 
   "4.000000000000000000000000000"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70173555],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "-", "103.22368893777063039324216688585669150465`25.193647175806476"}], "+",
   
  RowBox[{
  "516.67910179989548546500182457516101404013`25.893786885590888", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{414, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->47007211]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->162904465],

Cell["Simple cases give exact symbolic results:", "ExampleText",
 CellID->210165858],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiP", "[", 
  RowBox[{
   RowBox[{"1", "/", "2"}], ",", 
   RowBox[{"1", "/", "2"}], ",", 
   RowBox[{"1", "/", "2"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->402693395],

Cell[BoxData[
 FractionBox[
  RowBox[{"4", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"2", " ", "x"}]}], ")"}]}], 
  RowBox[{"3", " ", "\[Pi]", " ", 
   SqrtBox[
    RowBox[{"1", "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "x"}], ")"}]}]}]]}]]], "Output",
 ImageSize->{131, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->295000317]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20532249],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiP",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiP"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->588992016],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiP", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "4", ",", "5", ",", "z"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->63244004],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{"11", " ", "z"}]}], ")"}]}], ",", 
   RowBox[{"15", "+", 
    RowBox[{"36", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "z"}], ")"}]}], "+", 
    RowBox[{
     FractionBox["39", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "z"}], ")"}], "2"]}]}], ",", 
   RowBox[{"35", "+", 
    RowBox[{
     FractionBox["273", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "z"}], ")"}]}], "+", 
    RowBox[{
     FractionBox["637", "4"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "z"}], ")"}], "2"]}], "+", 
    RowBox[{
     FractionBox["455", "8"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", "z"}], ")"}], "3"]}]}]}], "}"}]], "Output",
 ImageSize->{311, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->175592062]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->732587932],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->332702344],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"JacobiP", "[", 
   RowBox[{"n", ",", "\[Alpha]", ",", "\[Beta]", ",", "x"}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->152827211],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubsuperscriptBox["P", "n", 
    RowBox[{"(", 
     RowBox[{"\[Alpha]", ",", "\[Beta]"}], ")"}]], "(", "x", ")"}], 
  TraditionalForm]], "Output",
 ImageSize->{44, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->27796004]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17671],

Cell["\<\
Expected value of the number of real eigenvalues of a complex matrix:\
\>", "ExampleText",
 CellID->175279180],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", " ", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], "^", "n"}]}], ")"}], "/", "2"}], "+", 
     RowBox[{
      SqrtBox["2"], 
      RowBox[{"JacobiP", "[", 
       RowBox[{
        RowBox[{"n", "-", "2"}], ",", 
        RowBox[{"1", "-", "n"}], ",", 
        RowBox[{"3", "/", "2"}], ",", "3"}], "]"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "100"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->221976275],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWNtLFFEYH3d2XUsLM1y3ZMvKSETpQhcKL1uLGmRZhFmk4SqSFrVh0r0k
7J6W4aWyIrtYlA89JAW9BlFPvfbcPzKdM+fMnMt8Z+YUYQnOODPf9/v9vt/3
nbPj7kz3dXcdS/f1dKZLGnrTJ7p7Ok+W1Gd60S0zyzCMGfSbiRvobwv9Zf/O
WBY6e48r0DGMAkLoHELnYnwX37CcH3x3MT2b9LxIuo6js8mhmNzZMHLw0XQx
7WwjQq7do53LR8VFJUBEDB+y+Qg4rlAzLubL6GjEBmfhM6uN1jL18ntt9cOh
wc+a2nGAEXEVUY74f1IV7l8I1WOYdanHNLcIyPRwyc8Fbt3qYo4CGOFPu9TS
/AqVlKyd+PjhB5lDn2qKfDWY4JOiWeiKYWaOv0cFuDgafOpa+NXo3pz9NRTl
FbCVVGiJOwq8PxVz1an2J3lfkvYngZ+MCZp7Y0pwntTy7etP0gDuKe+BjWqy
Gl74RDEmEoW3g2kUFAZzwg4yuoWRs6XnEek66PnvXv9tvH+Cr3CVdaJIep6Q
rpcEXMvxjBXPENHEZug5qIk4wWZo0ieKKZ8UmKJ2cYjpQMtrAvMURIlKKD5R
EaK7/+InquuJwDhXQnoCIs0BkR6BsbkSIokyqY+YM89T5QSJkZDknSpPQlZn
mQ6LR/MDO4duI/aPPHHzJRaSIWuRWeeDbONKhdiHBRLTuOAUn5HvcWwM9N5G
jBDEVPIRVTEidLyAU7qr8RnlHgHxFoJV3QNj7c+bMOEmgcMCb8ypAdER0mEQ
JwZy3gFj4x7OIWW3nE8ZI9vV4Fp0W6vHi0DnSG7Y+QTg4ovBSm7SCWSfrxE6
sQlPNTcCpzWhqOhaYOYSsJprvv4tAyu6AvZmuaeaAXUcUMFlYXpK8VWUV8vm
ux/EXWmxXRtl0DdjFE+fXxDwyxQqLoDYZQHYZ8Gscs8KOC9oqADdJVjQrlBp
Qav9tKWzl1YGVNCnRMGXqxVuqbP46zU+vewNnNt1AcozAoJtEfV3g0J1xp35
ELCKN3BdcdV6WI+AHd8EamXVsizMvMWZj4726bbWNyhBZjkMslQp6oKjq33c
7xL0JAOc7gDxtyrUwNHbfNS0g7OAldWBynoOv6OZbSRF+K9G7ms9PuS4OpPV
Ezz5QQ2EBm4yxka/KFzar0DCQDsUXpEcaM03BvSkWTn9TWK9hMu1bK/vGmjy
rAFkl4d7N9jhPQ4vcUmqlOVg3mattbYD5NkXsNbgLNtp3zW3XVDY6utiPcjR
quVeCsw95OteStntDi0na8B8nr8zwNUad2783py6nCpcl/kqqpQY+LIbVMDW
+mYtBUecPrurXfZioxW84o/iw1ywG66g9Vyq8xOmXcloTcJacBJOaHCvBjNP
arFWCHN+SoOtHGQ7o8W2Csw9Z9H9UGKVs0sFrZegCYlIYsl7poex32HkJxOY
jqUC44CGOwlhbUFvMle1nFqsMZfXNfTEFTgY5paPEuZgYWBFg1D/ADcLNGq6
q1FTvgIH92hEq6Z5gTWNQjqkt4VccLbucwrk9wOmIEeYLPy9vfqtBP42zM6J
Sjz0/zk4Y5JbMfgbLfH7rrfEjKxfyw90iQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->89775588]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->533461590],

Cell["Solve a Jacobi differential equation:", "ExampleText",
 CellID->28906730],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"n", "=", "1"}], "}"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"]}], ")"}], 
     RowBox[{
      SubscriptBox["\[PartialD]", 
       RowBox[{"{", 
        RowBox[{"x", ",", "2"}], "}"}]], 
      RowBox[{"JacobiP", "[", 
       RowBox[{"n", ",", "a", ",", "b", ",", "x"}], "]"}]}]}], " ", "+", " ", 
    
    RowBox[{
     RowBox[{"(", 
      RowBox[{"b", "-", "a", "-", 
       RowBox[{"x", 
        RowBox[{"(", 
         RowBox[{"a", "+", "b", "+", "2"}], ")"}]}]}], ")"}], 
     RowBox[{
      SubscriptBox["\[PartialD]", "x"], 
      RowBox[{"JacobiP", "[", 
       RowBox[{"n", ",", "a", ",", "b", ",", "x"}], "]"}]}]}], " ", "+", 
    RowBox[{"n", 
     RowBox[{"(", 
      RowBox[{"n", "+", "a", "+", "b", "+", "1"}], ")"}], " ", 
     RowBox[{"JacobiP", "[", 
      RowBox[{"n", ",", "a", ",", "b", ",", "x"}], "]"}]}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23602714],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", "a", "+", "b"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "a"}], "+", "b", "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", "a", "+", "b"}], ")"}], " ", "x"}]}], ")"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", "a", "+", "b"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"a", "-", "b", "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", "a", "+", "b"}], ")"}], " ", "x"}]}], 
    ")"}]}]}]], "Output",
 ImageSize->{427, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7813125]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->262721258],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->268384667]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->50084802],

Cell["\<\
Solution of the Schr\[ODoubleDot]dinger equation with a \
P\[ODoubleDot]schl-Teller potential:\
\>", "ExampleText",
 CellID->288850289],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Psi]", "[", 
   RowBox[{"n_", ",", "a_", ",", "b_", ",", "x_"}], "]"}], " ", ":=", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sin", "[", "x", "]"}], 
    RowBox[{"a", "+", 
     FractionBox["1", "2"]}]], " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "x", "]"}], 
    RowBox[{"b", "+", 
     FractionBox["1", "2"]}]], " ", 
   RowBox[{"JacobiP", "[", 
    RowBox[{"n", ",", "a", ",", "b", ",", 
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "x"}], "]"}]}], "]"}]}]}]], "Input",
 GeneratedCell->False,
 CellLabel->"In[1]:=",
 CellID->328019363],

Cell["Calculate energy eigenvalue from the differential equation:", \
"ExampleText",
 CellID->15115752],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"\[Psi]", "[", 
        RowBox[{"3", ",", "a", ",", "b", ",", "x"}], "]"}], ",", "x", ",", 
       "x"}], "]"}]}], "/", 
    RowBox[{"\[Psi]", "[", 
     RowBox[{"3", ",", "a", ",", "b", ",", "x"}], "]"}]}], "+", " ", 
   FractionBox[
    RowBox[{
     SuperscriptBox["a", "2"], "-", 
     FractionBox["1", "4"]}], 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "2"]], "+", 
   FractionBox[
    RowBox[{
     SuperscriptBox["b", "2"], "-", 
     FractionBox["1", "4"]}], 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "2"]]}], " ", "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->66431707],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"7", "+", "a", "+", "b"}], ")"}], "2"]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->632926384]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1576],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " to expand into other functions:"
}], "ExampleText",
 CellID->294058483],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"JacobiP", "[", 
   RowBox[{"n", ",", "a", ",", 
    RowBox[{"-", "n"}], ",", "z"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->134072701],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "z"}], ")"}]}]}], ")"}], "n"], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "+", "a", "+", "n"}], "]"}]}], 
  RowBox[{
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "+", "a"}], "]"}], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "+", "n"}], "]"}]}]]], "Output",
 ImageSize->{207, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->238117615]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30538],

Cell["\<\
Cancellations in the polynomial form may lead to inaccurate numerical \
results:\
\>", "ExampleText",
 CellID->377633235],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"JacobiP", "[", 
   RowBox[{"60", ",", "1", ",", "2", ",", "x"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"N", "[", 
     RowBox[{
      RowBox[{"2", "/", "3"}], ",", "16"}], "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->300499535],

Cell[BoxData["0``-6.110705663681907"], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->49558237]
}, Open  ]],

Cell["Evaluate the function directly:", "ExampleText",
 CellID->370676016],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiP", "[", 
  RowBox[{"60", ",", "1", ",", "2", ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"2", "/", "3"}], ",", "16"}], "]"}]}], " ", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->60075057],

Cell[BoxData["0.30187579769621678191839863597`14.560041093954563"], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->493886627]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->639],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LegendreP",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LegendreP"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ZernikeR",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ZernikeR"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ChebyshevT",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ChebyshevT"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ChebyshevU",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ChebyshevU"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GegenbauerC",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GegenbauerC"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2920]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6734],

Cell[TextData[ButtonBox["Orthogonal Polynomials",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OrthogonalPolynomials"]], "Tutorials",
 CellID->4288]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->4675],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/JacobiPolynomial.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/Polynomials/JacobiP/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
JacobiP"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->17182257],

Cell[TextData[ButtonBox["Functions Used in Quantum Mechanics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInQuantumMechanics"]], "MoreAbout",
 CellID->150909180],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->392665666]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"JacobiP - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 51, 37.2473094}", "context" -> "System`", 
    "keywords" -> {
     "Jacobi functions", "Jacobi polynomial", "Jacobi polynomials"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "JacobiP[n, a, b, x] gives the Jacobi polynomial SubsuperscriptBox[P, n, \
(a, b)](x). ", "synonyms" -> {"Jacobi P"}, "title" -> "JacobiP", "type" -> 
    "Symbol", "uri" -> "ref/JacobiP"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7145, 250, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->302766427]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 34793, 1236}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2378, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3001, 84, 45, 1, 70, "ObjectName",
 CellID->17862],
Cell[3049, 87, 813, 27, 70, "Usage",
 CellID->4482]
}, Open  ]],
Cell[CellGroupData[{
Cell[3899, 119, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4377, 136, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4500, 142, 79, 1, 70, "Notes",
 CellID->15305],
Cell[4582, 145, 848, 30, 70, "Notes",
 CellID->20909],
Cell[5433, 177, 358, 14, 70, "Notes",
 CellID->22317],
Cell[5794, 193, 245, 8, 70, "Notes",
 CellID->67944623],
Cell[6042, 203, 216, 7, 70, "Notes",
 CellID->31226],
Cell[6261, 212, 199, 7, 70, "Notes",
 CellID->28162],
Cell[6463, 221, 645, 24, 70, "Notes",
 CellID->27221]
}, Closed]],
Cell[CellGroupData[{
Cell[7145, 250, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->302766427],
Cell[CellGroupData[{
Cell[7530, 264, 148, 5, 70, "ExampleSection",
 CellID->317243255],
Cell[7681, 271, 176, 7, 70, "ExampleText",
 CellID->87637193],
Cell[CellGroupData[{
Cell[7882, 282, 146, 4, 28, "Input",
 CellID->570954243],
Cell[8031, 288, 868, 31, 51, "Output",
 CellID->422437482]
}, Open  ]],
Cell[8914, 322, 125, 3, 70, "ExampleDelimiter",
 CellID->102805808],
Cell[9042, 327, 253, 11, 70, "ExampleText",
 CellID->776150112],
Cell[CellGroupData[{
Cell[9320, 342, 283, 9, 28, "Input",
 CellID->66518959],
Cell[9606, 353, 3318, 58, 127, "Output",
 Evaluatable->False,
 CellID->32512093]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12973, 417, 216, 7, 70, "ExampleSection",
 CellID->11058],
Cell[13192, 426, 74, 1, 70, "ExampleText",
 CellID->204369770],
Cell[CellGroupData[{
Cell[13291, 431, 155, 5, 70, "Input",
 CellID->1026262214],
Cell[13449, 438, 175, 5, 36, "Output",
 CellID->851969705]
}, Open  ]],
Cell[13639, 446, 125, 3, 70, "ExampleDelimiter",
 CellID->127540731],
Cell[13767, 451, 84, 1, 70, "ExampleText",
 CellID->39108213],
Cell[CellGroupData[{
Cell[13876, 456, 206, 6, 70, "Input",
 CellID->271117521],
Cell[14085, 464, 273, 7, 36, "Output",
 CellID->141233926]
}, Open  ]],
Cell[14373, 474, 125, 3, 70, "ExampleDelimiter",
 CellID->369072761],
Cell[14501, 479, 70, 1, 70, "ExampleText",
 CellID->636586426],
Cell[CellGroupData[{
Cell[14596, 484, 283, 10, 70, "Input",
 CellID->65832899],
Cell[14882, 496, 367, 12, 36, "Output",
 CellID->462879634]
}, Open  ]],
Cell[15264, 511, 124, 3, 70, "ExampleDelimiter",
 CellID->82858706],
Cell[15391, 516, 113, 3, 70, "ExampleText",
 CellID->493308527],
Cell[CellGroupData[{
Cell[15529, 523, 245, 8, 70, "Input",
 CellID->70173555],
Cell[15777, 533, 366, 12, 36, "Output",
 CellID->47007211]
}, Open  ]],
Cell[16158, 548, 125, 3, 70, "ExampleDelimiter",
 CellID->162904465],
Cell[16286, 553, 84, 1, 70, "ExampleText",
 CellID->210165858],
Cell[CellGroupData[{
Cell[16395, 558, 218, 7, 70, "Input",
 CellID->402693395],
Cell[16616, 567, 482, 18, 77, "Output",
 CellID->295000317]
}, Open  ]],
Cell[17113, 588, 124, 3, 70, "ExampleDelimiter",
 CellID->20532249],
Cell[17240, 593, 208, 7, 70, "ExampleText",
 CellID->588992016],
Cell[CellGroupData[{
Cell[17473, 604, 207, 7, 70, "Input",
 CellID->63244004],
Cell[17683, 613, 1141, 42, 81, "Output",
 CellID->175592062]
}, Open  ]],
Cell[18839, 658, 125, 3, 70, "ExampleDelimiter",
 CellID->732587932],
Cell[18967, 663, 203, 7, 70, "ExampleText",
 CellID->332702344],
Cell[CellGroupData[{
Cell[19195, 674, 201, 6, 70, "Input",
 CellID->152827211],
Cell[19399, 682, 330, 11, 54, "Output",
 CellID->27796004]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19778, 699, 223, 7, 70, "ExampleSection",
 CellID->17671],
Cell[20004, 708, 120, 3, 70, "ExampleText",
 CellID->175279180],
Cell[CellGroupData[{
Cell[20149, 715, 619, 21, 70, "Input",
 CellID->221976275],
Cell[20771, 738, 1834, 34, 70, "Output",
 Evaluatable->False,
 CellID->89775588]
}, Open  ]],
Cell[22620, 775, 125, 3, 70, "ExampleDelimiter",
 CellID->533461590],
Cell[22748, 780, 79, 1, 70, "ExampleText",
 CellID->28906730],
Cell[CellGroupData[{
Cell[22852, 785, 1035, 34, 70, "Input",
 CellID->23602714],
Cell[23890, 821, 733, 26, 51, "Output",
 CellID->7813125]
}, Open  ]],
Cell[CellGroupData[{
Cell[24660, 852, 102, 3, 70, "Input",
 CellID->262721258],
Cell[24765, 857, 158, 5, 36, "Output",
 CellID->268384667]
}, Open  ]],
Cell[24938, 865, 124, 3, 70, "ExampleDelimiter",
 CellID->50084802],
Cell[25065, 870, 145, 4, 70, "ExampleText",
 CellID->288850289],
Cell[25213, 876, 587, 19, 70, "Input",
 CellID->328019363],
Cell[25803, 897, 103, 2, 70, "ExampleText",
 CellID->15115752],
Cell[CellGroupData[{
Cell[25931, 903, 751, 26, 70, "Input",
 CellID->66431707],
Cell[26685, 931, 238, 8, 36, "Output",
 CellID->632926384]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26972, 945, 232, 7, 70, "ExampleSection",
 CellID->1576],
Cell[27207, 954, 230, 8, 70, "ExampleText",
 CellID->294058483],
Cell[CellGroupData[{
Cell[27462, 966, 208, 6, 70, "Input",
 CellID->134072701],
Cell[27673, 974, 620, 22, 61, "Output",
 CellID->238117615]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28342, 1002, 226, 7, 70, "ExampleSection",
 CellID->30538],
Cell[28571, 1011, 131, 4, 70, "ExampleText",
 CellID->377633235],
Cell[CellGroupData[{
Cell[28727, 1019, 309, 10, 70, "Input",
 CellID->300499535],
Cell[29039, 1031, 177, 5, 36, "Output",
 CellID->49558237]
}, Open  ]],
Cell[29231, 1039, 74, 1, 70, "ExampleText",
 CellID->370676016],
Cell[CellGroupData[{
Cell[29330, 1044, 232, 7, 70, "Input",
 CellID->60075057],
Cell[29565, 1053, 208, 5, 36, "Output",
 CellID->493886627]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29834, 1065, 309, 9, 70, "SeeAlsoSection",
 CellID->639],
Cell[30146, 1076, 1201, 44, 70, "SeeAlso",
 CellID->2920]
}, Open  ]],
Cell[CellGroupData[{
Cell[31384, 1125, 313, 9, 70, "TutorialsSection",
 CellID->6734],
Cell[31700, 1136, 153, 3, 70, "Tutorials",
 CellID->4288]
}, Open  ]],
Cell[CellGroupData[{
Cell[31890, 1144, 320, 9, 70, "RelatedLinksSection",
 CellID->4675],
Cell[32213, 1155, 187, 4, 70, "RelatedLinks"],
Cell[32403, 1161, 191, 4, 70, "RelatedLinks"],
Cell[32597, 1167, 385, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33019, 1185, 318, 9, 70, "MoreAboutSection",
 CellID->17182257],
Cell[33340, 1196, 178, 3, 70, "MoreAbout",
 CellID->150909180],
Cell[33521, 1201, 145, 3, 70, "MoreAbout",
 CellID->392665666]
}, Open  ]],
Cell[33681, 1207, 27, 0, 70, "History"],
Cell[33711, 1209, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

