(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    161281,       3739]
NotebookOptionsPosition[    151278,       3387]
NotebookOutlinePosition[    152583,       3425]
CellTagsIndexPosition[    152496,       3420]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals and Elliptic Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals and Elliptic Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"InverseJacobiSC" :> 
          Documentation`HelpLookup["paclet:ref/InverseJacobiSC"], "JacobiSD" :> 
          Documentation`HelpLookup["paclet:ref/JacobiSD"], "JacobiSN" :> 
          Documentation`HelpLookup["paclet:ref/JacobiSN"], "JacobiDC" :> 
          Documentation`HelpLookup["paclet:ref/JacobiDC"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"InverseJacobiSC\"\>", 
       2->"\<\"JacobiSD\"\>", 3->"\<\"JacobiSN\"\>", 
       4->"\<\"JacobiDC\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Functions" :> 
          Documentation`HelpLookup["paclet:guide/EllipticFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Elliptic Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["JacobiSC", "ObjectName",
 CellID->10307],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["JacobiSC",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/JacobiSC"], "[", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Jacobi elliptic function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"sc", "(", 
        RowBox[{"u", "|", "m"}], ")"}], TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23855]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"sc", "(", "u", ")"}], "=", 
    RowBox[{"tan", "(", "\[Phi]", ")"}]}], TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Phi]", "=", 
    RowBox[{"am", "(", 
     RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->10528],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"sc", "(", 
    RowBox[{"u", "\[VerticalSeparator]", "m"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " is a doubly periodic function in ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath"],
 " with periods ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", " ", 
    RowBox[{"K", "(", "m", ")"}]}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"4", " ", "\[ImaginaryI]", " ", 
    RowBox[{"K", "(", 
     RowBox[{"1", "-", "m"}], ")"}]}], TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox["K", TraditionalForm]], "InlineMath"],
 " is the elliptic integral ",
 Cell[BoxData[
  ButtonBox["EllipticK",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EllipticK"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->287578035],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiSC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiSC"]], "InlineFormula"],
 " is a meromorphic function in both arguments."
}], "Notes",
 CellID->99960195],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["JacobiSC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiSC"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->191973070],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiSC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiSC"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiSC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiSC"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->387868632],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->150203541],

Cell["Evaluate numerically:", "ExampleText",
 CellID->400288940],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiSC", "[", 
  RowBox[{"0.2", ",", "0.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->77957898],

Cell[BoxData["0.20202226305218002`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->216709183]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->470866374],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"JacobiSC", "[", 
    RowBox[{"u", ",", 
     RowBox[{"1", "/", "3"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{"-", "6"}], ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->175933317],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->335376579]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->137230538],

Cell["Series expansions:", "ExampleText",
 CellID->55901019],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"JacobiSC", "[", 
    RowBox[{"u", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->461811558],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"u", "+", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"(", 
     RowBox[{"2", "-", "m"}], ")"}], " ", 
    SuperscriptBox["u", "3"]}], "+", 
   RowBox[{
    FractionBox["1", "120"], " ", 
    RowBox[{"(", 
     RowBox[{"16", "-", 
      RowBox[{"16", " ", "m"}], "+", 
      SuperscriptBox["m", "2"]}], ")"}], " ", 
    SuperscriptBox["u", "5"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "u", "]"}], "7"],
    SeriesData[$CellContext`u, 0, {}, 1, 7, 1],
    Editable->False]}],
  SeriesData[$CellContext`u, 0, {
   1, 0, Rational[1, 6] (2 - $CellContext`m), 0, 
    Rational[1, 120] (16 - 16 $CellContext`m + $CellContext`m^2)}, 1, 7, 1],
  Editable->False]], "Output",
 ImageSize->{286, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->609850181]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"JacobiSC", "[", 
    RowBox[{"u", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->240753544],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"Tan", "[", "u", "]"}], "+", 
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "u"}], "+", 
      RowBox[{"Sin", "[", 
       RowBox[{"2", " ", "u"}], "]"}], "-", 
      RowBox[{"2", " ", "u", " ", 
       SuperscriptBox[
        RowBox[{"Tan", "[", "u", "]"}], "2"]}], "+", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "u"}], "]"}], " ", 
       SuperscriptBox[
        RowBox[{"Tan", "[", "u", "]"}], "2"]}]}], ")"}], " ", "m"}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "m", "]"}], "2"],
    SeriesData[$CellContext`m, 0, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`m, 0, {
    Tan[$CellContext`u], 
    Rational[1, 8] ((-2) $CellContext`u + Sin[2 $CellContext`u] - 
     2 $CellContext`u Tan[$CellContext`u]^2 + 
     Sin[2 $CellContext`u] Tan[$CellContext`u]^2)}, 0, 2, 1],
  Editable->False]], "Output",
 ImageSize->{428, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->576626763]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->194],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->136651426],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiSC", "[", 
  RowBox[{
   RowBox[{"5.2", "-", 
    RowBox[{"2.5", "I"}]}], ",", 
   RowBox[{"0.3", "+", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->374527875],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.24609405083573355`"}], "+", 
  RowBox[{"0.7420222927111162`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{148, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->407356624]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->525378932],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->239493914],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"JacobiSC", "[", 
    RowBox[{
     RowBox[{"Pi", "/", "3"}], ",", 
     RowBox[{"1", "/", "3"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18845098],

Cell[BoxData["1.\
5445295190031001812268984605305022345236685489013295388809048815167`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->36188065]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->550009612],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->864577637],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiSC", "[", 
  RowBox[{
   RowBox[{"Pi", "/", "3"}], ",", "0.3333333333333333333333333333333333"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->446034805],

Cell[BoxData["1.544529519003100181226898460530502234523668548905`32.\
78156591015722"], "Output",
 ImageSize->{242, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->548079558]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->128417124],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiSC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiSC"]], "InlineFormula"],
 " threads element\[Hyphen]wise over lists:"
}], "ExampleText",
 CellID->97071841],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiSC", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u1", ",", "u2"}], "}"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->815460718],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiSC", "[", 
    RowBox[{"u1", ",", "m"}], "]"}], ",", 
   RowBox[{"JacobiSC", "[", 
    RowBox[{"u2", ",", "m"}], "]"}]}], "}"}]], "Output",
 ImageSize->{234, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->726762564]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6259999],

Cell["Simple exact results are generated automatically:", "ExampleText",
 CellID->495463307],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiSC", "[", 
    RowBox[{"z", ",", "0"}], "]"}], ",", 
   RowBox[{"JacobiSC", "[", 
    RowBox[{"z", ",", "1"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->65054936],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Tan", "[", "z", "]"}], ",", 
   RowBox[{"Sinh", "[", "z", "]"}]}], "}"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16231292]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiSC", "[", 
    RowBox[{"0", ",", "m"}], "]"}], ",", 
   RowBox[{"JacobiSC", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"EllipticK", "[", "m", "]"}], "/", "2"}], ",", "m"}], "]"}], 
   ",", 
   RowBox[{"JacobiSC", "[", 
    RowBox[{
     RowBox[{"EllipticK", "[", "m", "]"}], ",", "m"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->366415397],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   FractionBox["1", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "-", "m"}], ")"}], 
     RowBox[{"1", "/", "4"}]]], ",", "ComplexInfinity"}], "}"}]], "Output",
 ImageSize->{213, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->9216384]
}, Open  ]],

Cell["\<\
Parity transformation and periodicity relations are automatically applied:\
\>", "ExampleText",
 CellID->26118627],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiSC", "[", 
  RowBox[{
   RowBox[{"-", "u"}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->74535809],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"JacobiSC", "[", 
   RowBox[{"u", ",", "m"}], "]"}]}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->17623960]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiSC", "[", 
  RowBox[{
   RowBox[{"u", "+", 
    RowBox[{"2", " ", 
     RowBox[{"EllipticK", "[", "m", "]"}]}], "+", 
    RowBox[{"4", "I", " ", 
     RowBox[{"EllipticK", "[", 
      RowBox[{"1", "-", "m"}], "]"}]}]}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->67735372],

Cell[BoxData[
 RowBox[{"JacobiSC", "[", 
  RowBox[{"u", ",", "m"}], "]"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->221590042]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->263264396],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->804604370],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"JacobiSC", "[", 
   RowBox[{"z", ",", "m"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->280453414],

Cell[BoxData[
 FormBox[
  RowBox[{"sc", "(", 
   RowBox[{"z", "\[VerticalSeparator]", "m"}], ")"}], 
  TraditionalForm]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->352622744]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31208],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["JacobiSC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/JacobiSC"]], "InlineFormula"],
 " can be applied to a power series:"
}], "ExampleText",
 CellID->774412347],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiSC", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcSin", "[", "x", "]"}], "+", 
    RowBox[{
     RowBox[{"O", "[", "x", "]"}], "^", "8"}]}], ",", "m"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->85485078],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"(", 
     RowBox[{"3", "-", "m"}], ")"}], " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{
    FractionBox["1", "120"], " ", 
    RowBox[{"(", 
     RowBox[{"45", "-", 
      RowBox[{"26", " ", "m"}], "+", 
      SuperscriptBox["m", "2"]}], ")"}], " ", 
    SuperscriptBox["x", "5"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "7"],
    SeriesData[$CellContext`x, 0, {}, 1, 7, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
   1, 0, Rational[1, 6] (3 - $CellContext`m), 0, 
    Rational[1, 120] (45 - 26 $CellContext`m + $CellContext`m^2)}, 1, 7, 1],
  Editable->False]], "Output",
 ImageSize->{286, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->567137196]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12626],

Cell["\<\
Flow lines in a rectangular region with a current flowing from the lower\
\[Hyphen]right to the upper\[Hyphen]left corner:\
\>", "ExampleText",
 CellID->695240112],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"m", "=", "0.4"}], ",", 
     RowBox[{"\[CurlyEpsilon]", "=", 
      RowBox[{"1", "/", 
       RowBox[{"10", "^", "6"}]}]}]}], "}"}], ",", 
   RowBox[{"ContourPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"JacobiDN", "[", 
       RowBox[{"x", ",", " ", "m"}], "]"}], 
      RowBox[{"JacobiDN", "[", 
       RowBox[{"y", ",", 
        RowBox[{"1", "-", " ", "m"}]}], "]"}], 
      RowBox[{"JacobiSC", "[", 
       RowBox[{"x", ",", " ", "m"}], "]"}], 
      RowBox[{"JacobiSC", "[", 
       RowBox[{"y", ",", 
        RowBox[{"1", "-", " ", "m"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "\[CurlyEpsilon]", ",", 
       RowBox[{"EllipticK", "[", "m", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "\[CurlyEpsilon]", ",", 
       RowBox[{"EllipticK", "[", 
        RowBox[{"1", "-", "m"}], "]"}]}], "}"}], ",", 
     RowBox[{"ContourShading", " ", "\[Rule]", " ", "False"}]}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->98575801],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyEnXVwVUm3t3EGd3dncIfBFu5OcHcZHIJbCO5ug7trcA8QPEACgQQIJJAQ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   "], {{{}, {}, {}, {}, {}, {}, {}, {}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV1XmQz3Ucx/EPVlFZiiVn1gqV5GyNW+OIRcjYMCFHJq1FiJp2mnFlHQmb
kiu51mJp0h8kdh2h3DOazdlMGyaSaKbYosfnj+e8Pu/35319Pt/f9/tLHjG+
f2apEELV0iHUfDyE2dVCmI+PrNclhbAaXa0H0MGYbt2HpqGRdVHVEC5gtHW3
KmLRxHpU5RDGYKG9HHyI7+TcVfswfTj2qhTCVvYi66N87dmfWnemc+jSGIPC
2ItvhnVDOpM+hRzUqxjC6/RJmq73IAzTtwl7N52QGMIe+hZdRHPw0mMh5Mrp
jv7WRWqew4vs03qdQpa4buxPrE/iBIqQLe4nOpeOltuLjqRzaA+a4ZyZOCNm
AzbGO1PrM7WWYas5ltB8MVvRhv2CWYvcw1n8iFl8XdCd/zi7GO3YaewOdK38
HtY79GxEP2c/i37s6ewN1jNpC9qFbw19DuceDeE8uvEdj88qxpvv1wrunb+y
nAN8Vegy9mm99ovbzf7e2U7gJPrE5yLvAxxjZ9M52CVuPl2ABMyL94TL6i9X
7wodSw/pMY5m4Iwee+XtccZd9tP4vqF72fv4C1BG/O/s0rQE5bDRDOVpgv5l
kK9PBru6ux5Ht7EPqn3Y/AfVqMt/gB5il4059p7gq4Whar+KdL7F6k7zXKYi
gd1EbFl6xH6iuj+zU82Yy1dAC9EKLZFl7ix924p7j06WMwl5YpPUq4q9YqqL
LaB/xvn4bsX6tC7NMONXcmbbby1uU/wtmDmJv7dZ+6AG3xi+mrS9mA7xmZqr
K7bwtWPfpg3E/EUb0oHqp2OwmCHINGOBPoX6rBB/i30b1fTpq0c/9MfHzpET
UeMi+1K8R/kH8bXcd+y1ju9kfO/kzqDD6Sy6Kr5X4tfGuxJfiH2oaL+z/R3y
vzVDJ+v9/BfEVnL/5+kSvilqvx3vEZPQkz9R7s74vOUmmvsBZyobnxVW6XOM
VhDTUf4jtJGYlfy58TeDBuzJ7HR72/VO0u9yfAfwvtxiWofWju+wHini62Og
+GSaqfd4BHH341n57tC7+Ad3xJXENb1HS+h/cZ/u0n8nLsXnrndJ/A2w79JD
7Iv8x5Gifn0MU3so/rY/wJyb9MxDLrZgM3aI367+lyjvfrbRfNyWV479IBJw
Q/+b/IX63aDX2P/qcQ/38Yf4mxhlf4VetdGVXYsuj99B8UtRjOtm/YVeNNdZ
/S+xz9OjuCbnOgYhX910Ohu91VgpfnP89iLPDJuwWJ0JzjERF9jjaSZ6iW/K
boZSaM5uTo/oMUu9UvIG0EBn0ulYr+46rMEC/i/Ez6Pj4jfIfmM1VqOlMzal
99VaRVPQ1369OCNK+JvRKXLX06vOdwU95D3D/sH6IXs9xeXJ24Lf7E11z1fp
y/F/BU/bf41O5J9Ls5GGdLyC9fLetNdQ3MD4H0ZH+N2N5Vtk5oXxN89/Slxr
Wqx2Kj3G7kdbiWuBpmgT8+P3WExb50+hk8R1tJfK7mQ/C3X536V14jeKVsFw
DMUQjHWuN+jzSFavWvxWW9eyroFk65HOPwbT4v8LXyd0tE6l7eK7Gp8VbYxR
+B9dOzKe
         "]],
        "12"],
       Annotation[#, 12, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV1XmQz3UYwPGvdRWtZdf+iMSaxbSLlUToMoyrHGWUGLfZbDnKukJZx2ai
pLZVyTTFDpOjcZ+tM8y4EstKqAlJJuXcIatenz/e836ez+f5PJ9nv9/f77cp
Q0a/OKpMFEWN46JoaHIUpeNRjKkZRW25JZ4WP8PtMUGcWSOKhqCe+EFrtTFC
HKtqTfy4eDiyEqKoL/fHQCRhMuqoe4vrcsvEKOoWc4bbJbkLY6pFUX17bawd
5FQ9W6vPsNccLdBTflDdYZxTc4R/QBfrc9XPQ5a6wXqnVomi3tYbcoGaIizF
SZxAM3MOrB5Fg/CGM9l4RO0weTqPl18Ks6pbHu6wdr94v2eQpm9ne5fE2dYK
5GN5srpp5p/Eb+OOMz34LufwPs7Q/x6X6l/KTeWX9coy+2s4Lh/Br2O2nl/L
F+MrfZfgi3h36DUDvdAbf+Ai9utXTm15xGGX57ATZ5w5K/8Fp3FG31/5I17C
ebxU72+wDO31Wskr0Ef8if1+3Bc3rd3AVfzsvvuc32H+i3xBXYn1O/gXV9TX
84xSsNz+SqzAWudeDr3RSU1H3DJjivwmNzFzqfiy2j9xSH08V0FZz608KuCK
ezPUNkUl+Rl1CWo2Wt+E6+a5Kb/Bt/gfvs7X+Cpf5Wvc3/179NiLRHl1JKGH
fpn2uvPf+lWzVhVHzVguvNfwrLlEnwX2S+TT7Y00+wjUD8/O2a2cz1fM+B3/
xVt5Eee4c7B4tfoC+WJM1SfemQ3W1mMdFqhZ4o7Z+hepWSg/xidwHOPlU9SN
4+3ykygO36vw3XRunL2xyMYA8053R19ez6t5La/idVzR3a28s3XyzfL1vIW/
5U3h/fEGXsMbuZX+E/WdgIVhFu4R3pPvRUVUwEPh++hvnWCeiYjpn4xJeqS7
Lw2znHs39LHeVc9X1Q9HhrMdrDcLf7O8CD8i5uxR3uaZrArvBw3c2xCN0MyZ
ys6kitvqv1zcwLxF1mvJc+StuQ1imGyuZH4MuXoW6DfMHWfVD+X3nG1p75S9
gWYchBrOJKiryZU5xvFcnR/gZJ6i/mNxJdQ2Sx08jO16tTV/G6TIk9QmolBd
AldFTeu1EGfWNHOU4bv2S9FYno6Xwm+T2kphfrWt9IusxdnbY+adZo9Z3817
5bvtfc/b5EnWC3lo+I20Poov8F79z3OW/La4vN731JXl/7gCb+YdoT8Ouusw
NvtbuziziRPNccDaNvuFOKbfcHu79FvAu/lTno/z4XdNzxk4pDaXZ2KaO6Zy
DvLCb5Mz74jnhnPyfHwezoXfNGvj3PmC843k3bhh+Iw7sxadxYt8Fp8yR1fx
Oe/vNxxCR3l76zNxXP4TitHOemtrt/RdhRu4hjX6jQ7/OzDNM5yJJ9Rlh+8D
dzLXSHWdeQgG47nweeJMzBEXm/sEDmM+jrjvs/B50etY+B/gfAu9isTNuadz
p5zrje7i58PfrzYP8/CmmkIeHX5zuInZB3AfM/Xj9z2f1PAM+Kge/fVN4072
toi3YwdyPaN8zMKz4R3xk3zA3gozLkNu+Dxb32fttnwPf2DePMzDRj0z8bt4
ELqYoa67hzlzWl6MRuKuznUL71n8CvdCB/GXvBgfiueE+1BL/D+wvjoc
         "]],
        "10"],
       Annotation[#, 10, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV1XmQz3Ucx/HPWjnXWlerzNhkMphxFZttWncl1hGbLMrYZnM1WCTHukrJ
tSShZkQIDUZqJmcpyRTCSs7KhLCiZFWrCT0+fzzn9b7fn+/39/1+f/VyR/Ya
kRBCSC0TQm6tEBqjOfJrh/AIbYVMdhvaAePYeakhDEIau65YjZQQhrNr0TR+
S/ZgDKkaQg4dgEK5fdVCmEefUFOPPlojhK53h5CFltVDaMfPRL66DH5r7FdX
X30DNJVLR3JyCD3M3K/urHyG2AU6nj8OneX71QyhP4bIvYiGYgvNeAs/qCmU
G+V8a9j59DhtRgeJP0RH6hmNsXiY/xJtTfPkW9Hz6lvSdfSi3ZniFfgZtDJt
Q19wXU3snaB3Iqa6nlfwRhUxfQWYgu6Yir1qT9Jv6B31wYzb9HNzPsNpfcfE
juMojtlzgs6iK+hcutz8lViFtma1w3zxy/xCulpdH7E/+L/jKk7Ylyi+y3X8
Qs/imnhDO/+0s1h93fh74wO5dViLj/RdlttMO9ESPSXq27Ov00b6r4udlC+n
fj+9EOc7x9/ipbiJNNyHi+KX5C/QYnrAjJ52FvOv8C/Tq/QS7S7eA13RDVkY
YG+S/Fh9w8wbim52Voq/CSpijzN9hYNqyqi/IZYY74eZ96tf4h4sjc8zu7eZ
2WiuvgVK9VyTu0l/87tcQTG2xftAC9Q8x55Mp2CF2HJMtuMBO3408zROYbu6
DWatNOuQmsM4iO/wsfxi+SPsd2gRXUqTzBhDp5uX47zT6C17/sM2uY1mbdG7
FWv1rIm72ZNcQwEmYKCdE+lO9Yn6yiABq81rLP6hfDrdxK8inoyquBPvLa2M
ShiqboG6ZTSRlk2NHxHzkIDR+MR5RtF8jES62jbOk4lsM3pjTnxP7JpN82jN
+C64xmZqUtSvj3visxSfY3reNf2Kc1irrrZ4Kr5XfwRF2CA3x+xh8hvZQ2kJ
vYGf5M+gup7J4k3YBTSF/yBaYIY9q+zNdZ7XnesNzEQ1346TcjmupR/6xmcO
/XGX+mT58jSJlqNV6CT1q+Wn8Lfyp9JG8d1ChjO2RqpzlRWvLL+T3mtXHVQX
r4k7ZnRxrtu0Gv9fNU8783CxbFpeXwWkxO+jebfUJcTvp70Z2GXWDteym36p
fifdGn9f9VvoDv4gs3JxTv5r88/SwfxS9iH5InUH6BF6mE6jy+h7WGjXIrxt
b1M9i+ib/J56C+M31Jnamncmfo9oTz29kIUe6I69el6m41EPEzEBY/SOxjxz
HrNznFin+D2OfXSBPfOxR/5Vs0+73lnsUXpm0o5q/mH/hU1oxy+hm50t34zM
+B7FXryGtvyx4ulmdTH3Z3XdkM1+hp5yn/vQd+P/YXw37Vus7xBdQidhN4bZ
8UXU+H+i7qn4PdF3Ms6KM/ld0V5uvrqFyMH2+D1BH31pcs/GZ9l9q+9c79Mi
vQPsbkQfj7Xs3diB6WLHcBQd4veffiu+D+vju40ZYhX9dyahlL9Hbq6zjoj/
j/RTM/PiO8YeiM7OUdfu59XXoafFGrCf1JeFaey+tBc6spfRlShkz477cA/7
fzl+LGA=
         "]],
        "8"],
       Annotation[#, 8, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV1XmQz3Ucx/HPNhPjvlnHSseSkBRDyKRyJBq7JSbHsBEl51SMbUhSaFeh
KVdjl6EkI+So0EHNMNN0qBw5cysWOVI0Pd5/PL3en/f5+Xx8vr+9OW9U7siM
lNJ5/wyqkVJjNMfozJTupS3Rnn0f7YgX2HUrpzS4Vkr12Vl8Va2fZVen26qk
1KRaSlvptxhaKaVD/MPpdusCdmc1XdFO3qM1U6pUMaV7qqZUmY6WM0TseboT
P+EKf9PqKTUL1LRABb7W1qX0bWPdGsf0vso/Tk0X2k/8MF8LOVnsu2l/OtjM
kfIL2eWcozzKoCxOmf16hZSW6HFS3ikMkPcU8tBU3+Vi9eRmYRHfNH3f5puD
uWrb8rVDG5QWa0+H6DPezONqxvK9yfeyM9dVU8HdzdB3Nt84sbfoi3QWzRE/
rWdD9dn4El9gi3PVVl8HPeR0R4m8TOtztJGck+y9euzBevm/ha3vKf4/8GfM
Rz3s5n/Q3nbRh2hunIVOUPcunY952CfelT6MTuiCzthhZmn9t9Nd+v2KVc70
jvrJfGNwVPyg+iP0EK0vJwtN7bUJ7sBh/m76HZOzW+xE3Bme1CtfvC99z7qn
vBI5Z2iyzsANOG/fF+INmbtenyJzu1onZOD7mK/vURxDFRyUkyv3klgOvUwv
yb0Yd8A+HWen68w+acZ6usFe5tBFdDYtop9iI25S1wC91Ey0x8fpvxHjW2ZW
Yq8192d9B6ot1jPf+i/ri7iA/vb/mfz35W+0XqDHUr7p1tlxLuvbaDFtGO8w
3hQdKqeQPk1n0inyD3nTB3EAA/jH8/eR35guoY3oYno7LZDfiq6wbkk/otft
4xo+FtvEN0yPlXpNdY7X4j3a+xasEf9P3mpahn8z30r1a9zBROesJva7usMo
pc+NyOefIu9VTI336i72YKYeH5qzLOr0qh79+KrosSliclbgAwyLb5Juo3fq
2RzNsDzuPfYu/6r4P/gbP8pbrHcxGprZCOXklcVuuTXjd0NODZqJWvja+pza
C/HGUJtvgtyi+D+I+4+7jHvEdXN70wz9e9FEn4hvS/7n7Gvi5fWoiErINr+V
87VEuXjH7icDs+IN0w04Ht9CfLN61KBnaHP7vQsHsB9L7XGBfS3EPEwyZz7N
1SdP30EYiMb8V/gu4xbxs+oa0BJ6Kx1jHwVxRnuug7l8hWbOxBxzm5k1m561
rwK+N+TOQDv1ZeId8K/FNL6xZqyOt4Nv1JzT+3z8/urZwT7G0lHxjuQ+F3th
l2AEu734cNqd5tMe9KU4m/grZm1VM5l+FbPF9pu1D4/ZQ1vrVWbuiN8kdMMj
6BO/Jaiv7hnrLDpdXr84Ay3CIvygT9/4XtBJbBPNNbeq/M3sLfhFzk50NK8D
/Y7vfnZfeWvUXHF3I+SvirPRT+gssXX0KD2BI/H3BV1iL/ac529BHbo3fu/Z
PfXM1nsSuzc7Bw+wF9JiFLKnx3eOTPb/ZLogVQ==
         "]],
        "6"],
       Annotation[#, 6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV1H1M11UUx/FbNqEteRAUKrJQ1npgLqS2spaJ+dBqMaUsS6dF01wBtTKD
Aos/ArRWtqGbIGHlplYoElJgD6vMFMrKrGlLEdd0IYmbpllJr/vHm88953zO
ufd3v98v2Y+WzSq9IISwzp8Fo0K4BuNRlhnCzTQft1pPpVkpITxrfRndjV0Y
K59Jr00LIReXJIXwRWoIO7ATh9S+odPkj9CpND89hBsxkb8AUzCeb6FZj2MR
SpJDqBoZwlHrY/E8es/q3T06hB50I128RP4V3sszQqihb4pXYvWIEMbY4yhP
Fj1Gr6TF+krsN91+S/SU6kmgZTQxzuBLoakYgWQk4TmMUhvm91+EC9FjTjdq
5b90xmozZ4jvwm3Onicu1ZdPn6QTaAld42xdzrEdJ/UN4gTqzKnneUm9DD86
717n+oH+RDPMHI0/1faJ98rvE7foazPrQVpO59AKWshzjh6g/fb9lb6BYnu0
ixvNKXBXQ+JJ4jtwO3p4UsxNRh8O46Dc12qn9AzoqRdvjc9arlturX1eF6+h
jWhAJ47zPaO+mW+mdZverchUy8B+s+fpa3JnFdYPOctJ3jn0Q752fKdvsty3
tICuM69d7zb8497O4W+sNOcj/MbTQa/QOwZF+n6Xm0U7xO/o74jPQTyfb6z1
OJw3Ywjr1f/ie5f+K/4Pq+xVjz+sG/V9zL9J/QzfRlqt9phZL9Pi+Ht4unje
VzvL8x7tFK+Vf159iG+e9Xk6l37K8zDNj3PpDfF9QR6Gq23iW2HGcfv3Y6kZ
G+XephvoOtrozhri+6NnAa2ky1CFT8z4WX9jPAMaUMnTRF+g8919vjkT8KJ4
KW+r2iPO0mx2p3oXtuMz8QnPK5E3ARt4vpfbwX9EX691H61TW44aLJKrpZ/T
NL50jES53gPO1h/v3MwzOI09fM3O8RbS7JmOi/kS0cEbxKnmpWCX9TZzJvIO
mnkLLY93ZUaveIBer97Hex29z3dThHH2GVTLsd6sp4BOwd3y9+BStYXiTHpK
Pck3f5om2i8BRfI7zeyn0+h0zMC9PIWoslcd33KsQG783xS/H8+vVrzMHlW4
Sf9wcav8U/q20KdpC/8H+ErPIXN7cRDZ5h6mefoW04H4neEBs17jv0q9iQ6j
q52/kt6ptsp6ZnyPaYU9UvX/En83itXnxncSk5wlW61Vrg0teCJ+W3QL7tef
a+bsuEaNvbLEe8zZrz/HPRWanxPvwPpqut5zmC23mE6Wa7BuxqvWtXLVyLD+
HyMO9gw=
         "]],
        "4"],
       Annotation[#, 4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV03tM11UYx/GjMzVLESzAdFPBTQu1cqtNA03JP0o3L2nLIi9MktGGZomY
zXKauimJpVwFpya4WVnN/C83r2BeIC/0R+TEVstLuWXg/fI6f7x/n3Oe5/k8
z/me7/c3KHfBtMJOIYQpfmY/GcIQDEdhagh9e4cwMimE5/Facgiv4uknQujo
FcJQ2k6foRkY2scaGTx9xNsSQ7iIzxJCKOevQCVKxcp6hnBXbYu6O/RXOpzv
35QQhtH1+h0RP4oqnhfsX0QXvdrUPELTebLl0ugani+xXN9CJDn7Bvu/5DKd
OQtdrcfQbvSYvnf1+Zkmqm2gCXS1XKP1s7zX5J+jjWal8aVjMB43cxAdiAF4
Sd1o/G3ufLlLtJGvNj6v9Z+et8Z6C6qRK7cJn8j97p5b8Rtu6XUT65zhP/vr
+B8/iH2P+zxZ8czOk0mP01769USrXofEjomt52+1LonPIt5DvoF+wL9Xvx+x
0P6OmqVy+fgOe1ArvtesrbRDXTs+1+cf3qvo71kWyX3L+6b9GzwzcFLsQ/sc
tZXubxKtoBNprX6l9IZeN3HUGZvVP8bXRBfzVUYv3sY+M34Rb1B33Duv0mcq
f5E+U2h37+mPeC/OcBpn0F+uH87yzdL3DH3Kvi++kN+Ict5Fcu9jIabZV+ud
S3fSYrM74p3QIpRZL4nfFd2MTRjibIv13q7vDmxDNf9+nJf/ie6S/4av2fkP
i7XF79G8C3SV+nfVrKR5tF7NHvFb+t5GnX0Gz046jCaIFclXqF+qvpx+ROto
Pb6K7yqen5bEd8dTzDtCbKaZBc7RLvYeTRLfrN+++P7sL6t5hW8Celg300dp
cL+d8IAvLf4H9blIG2gjeutzSm0ibaIpPHPEk+kJnpV655kzD8Vmldpfkhur
9mWMQzbGo7v4fZ4L+t+Ld0W/Ft8dn00uVexjc1LoMlpPd8VvT34m3kKO2e9g
gTkH5A6ZucHsg7RFPpXvXPwW6GV6Bfm+q1H20817HWvVd7avoaf0KYh3hsnx
m0Od9afiM3x3+fH90Ln269zTGvsVSLZ+CJfayAg=
         "]],
        "2"],
       Annotation[#, 2, "Tooltip"]& ]}, {}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->NCache[{{
      Rational[1, 1000000], 1.7775193714912534`}, {
      Rational[1, 1000000], 1.9495677498060258`}}, {{1.*^-6, 
    1.7775193714912534`}, {1.*^-6, 1.9495677498060258`}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 179},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->394962399]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->228220110],

Cell["Conformal map from a unit triangle to the unit disk:", "ExampleText",
 CellID->223864426],

Cell[BoxData[
 RowBox[{
  RowBox[{"w", "[", "z_", "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Zeta]", "=", 
       FractionBox[
        RowBox[{"z", " ", 
         RowBox[{
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "/", "3"}], "]"}], "^", "3"}]}], 
        RowBox[{
         SuperscriptBox["2", 
          RowBox[{"1", "/", "3"}]], 
         SuperscriptBox["3", 
          RowBox[{"1", "/", "4"}]], "\[Pi]"}]]}], ",", 
      RowBox[{"m", "=", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"\[Pi]", "/", "12"}], "]"}], "^", "2"}]}]}], "}"}], ",", 
    RowBox[{
     SuperscriptBox["2", 
      RowBox[{"11", "/", "6"}]], 
     RowBox[{"Cos", "[", 
      RowBox[{"\[Pi]", "/", "12"}], "]"}], 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{
        RowBox[{"JacobiSN", "[", 
         RowBox[{"\[Zeta]", ",", "m"}], "]"}], "/", 
        RowBox[{"JacobiSC", "[", 
         RowBox[{"\[Zeta]", ",", "m"}], "]"}]}]}], ")"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{
         RowBox[{"Tan", "[", 
          RowBox[{"\[Pi]", "/", "12"}], "]"}], 
         RowBox[{
          RowBox[{"JacobiSN", "[", 
           RowBox[{"\[Zeta]", ",", "m"}], "]"}], "/", 
          RowBox[{"JacobiSC", "[", 
           RowBox[{"\[Zeta]", ",", "m"}], "]"}]}]}]}], ")"}], "/", 
      "\[IndentingNewLine]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["3", 
          RowBox[{"1", "/", "4"}]], 
         RowBox[{"JacobiSN", "[", 
          RowBox[{"\[Zeta]", ",", "m"}], "]"}], 
         RowBox[{"JacobiDN", "[", 
          RowBox[{"\[Zeta]", ",", "m"}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"JacobiCN", "[", 
            RowBox[{"\[Zeta]", ",", "m"}], "]"}]}], ")"}], "^", "2"}]}], 
       ")"}]}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16049754],

Cell["Show points before and after the map:", "ExampleText",
 CellID->84846121],

Cell[BoxData[
 RowBox[{
  RowBox[{"trianglePoints", "=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t", "=", 
       RowBox[{"E", "^", 
        RowBox[{"(", 
         RowBox[{"2", "Pi", " ", 
          RowBox[{"I", "/", "3"}]}], ")"}]}]}], "}"}], ",", 
     RowBox[{"Flatten", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"s", "/", "8."}], " ", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"#1", "+", 
              RowBox[{
               RowBox[{"j", "/", "16"}], 
               RowBox[{"(", 
                RowBox[{"#2", "-", "#1"}], ")"}]}]}], ",", 
             RowBox[{"{", 
              RowBox[{"j", ",", "0", ",", "16"}], "}"}]}], "]"}]}], "&"}], "@@@",
          
         RowBox[{"(", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1", ",", "t"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"t", ",", 
               RowBox[{"1", "/", "t"}]}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"1", "/", "t"}], ",", "1"}], "}"}]}], "}"}], "/", 
           SqrtBox["3"]}], ")"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"s", ",", "8"}], "}"}]}], "]"}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->272616709],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Re", "[", "#", "]"}], ",", 
          RowBox[{"Im", "[", "#", "]"}]}], "}"}], "]"}], "&"}], "/@", 
      "trianglePoints"}], ",", 
     RowBox[{"Frame", " ", "\[Rule]", " ", "True"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Re", "[", "#", "]"}], ",", 
          RowBox[{"Im", "[", "#", "]"}]}], "}"}], "]"}], "&"}], "/@", 
      RowBox[{"w", "[", "trianglePoints", "]"}]}], ",", 
     RowBox[{"Frame", " ", "\[Rule]", " ", "True"}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->126582686],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 197},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->3208400]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->120139003],

Cell[TextData[{
 "Solution of the sinh\[Hyphen]Gordon equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["\[PartialD]", "2"], 
       RowBox[{"u", "(", 
        RowBox[{"x", ",", "t"}], ")"}]}], 
      RowBox[{
       RowBox[{"\[PartialD]", "x"}], "\[ThinSpace]", 
       RowBox[{"\[PartialD]", "t"}]}],
      MultilineFunction->None], "+", 
     RowBox[{"sinh", "(", 
      RowBox[{"u", "(", 
       RowBox[{"x", ",", "t"}], ")"}], ")"}]}], "\[LongEqual]", "0"}], 
   TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->688353202],

Cell[BoxData[
 RowBox[{
  RowBox[{"u", "[", 
   RowBox[{"x_", ",", "t_"}], "]"}], ":=", 
  RowBox[{"2", 
   RowBox[{"ArcCsch", "[", 
    RowBox[{"JacobiSC", "[", 
     RowBox[{
      RowBox[{"x", "-", "t"}], ",", "m"}], "]"}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->59273105],

Cell["Check the solution:", "ExampleText",
 CellID->123023636],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "t"}], "]"}], ",", "x", ",", "t"}], "]"}], "+", 
    RowBox[{"Sinh", "[", 
     RowBox[{"u", "[", 
      RowBox[{"x", ",", "t"}], "]"}], "]"}]}], ",", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"JacobiNC", "[", 
        RowBox[{
         RowBox[{"t", "-", "x"}], ",", "m"}], "]"}], "^", "2"}], "-", "1"}], "==",
      
     RowBox[{
      RowBox[{"JacobiSC", "[", 
       RowBox[{
        RowBox[{"t", "-", "x"}], ",", "m"}], "]"}], "^", "2"}]}], " ", "&&", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"JacobiDC", "[", 
        RowBox[{
         RowBox[{"t", "-", "x"}], ",", "m"}], "]"}], "2"], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"JacobiSC", "[", 
         RowBox[{
          RowBox[{"t", "-", "x"}], ",", "m"}], "]"}], "2"]}]}], "\[Equal]", 
     "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->107585666],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->106952733]
}, Open  ]],

Cell["Plot the solution:", "ExampleText",
 CellID->1021720479],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"u", "[", 
     RowBox[{"x", ",", "t"}], "]"}], "/.", 
    RowBox[{"m", "\[Rule]", 
     RowBox[{"4", "/", "3"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"5", "/", "2"}]}], "}"}], ",", 
   RowBox[{"MaxRecursion", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->10394245],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 151},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->123819582]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16389],

Cell["Compose with inverse functions:", "ExampleText",
 CellID->361783126],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"JacobiSC", "[", 
    RowBox[{
     RowBox[{"InverseJacobiSC", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}], ",", 
   RowBox[{"InverseJacobiSC", "[", 
    RowBox[{
     RowBox[{"JacobiSC", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->288300512],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", 
   RowBox[{"InverseJacobiSC", "[", 
    RowBox[{
     RowBox[{"JacobiSC", "[", 
      RowBox[{"z", ",", "m"}], "]"}], ",", "m"}], "]"}]}], "}"}]], "Output",
 ImageSize->{269, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->46909267]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["PowerExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PowerExpand"]], "InlineFormula"],
 " to disregard multivaluedness of the inverse function:"
}], "ExampleText",
 CellID->785308763],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PowerExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22979849],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", "z"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->183795198]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->133706258],

Cell["Solve a transcendental equation:", "ExampleText",
 CellID->464846584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"JacobiSC", "[", 
       RowBox[{"x", ",", "m"}], "]"}], "2"], "+", 
     RowBox[{"3", 
      RowBox[{"JacobiSC", "[", 
       RowBox[{"x", ",", "m"}], "]"}]}]}], "\[Equal]", "a"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->132240831],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->394102448],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"InverseJacobiSC", "[", 
      RowBox[{
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "-", 
          SqrtBox[
           RowBox[{"9", "+", 
            RowBox[{"4", " ", "a"}]}]]}], ")"}]}], ",", "m"}], "]"}]}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"InverseJacobiSC", "[", 
      RowBox[{
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "3"}], "+", 
          SqrtBox[
           RowBox[{"9", "+", 
            RowBox[{"4", " ", "a"}]}]]}], ")"}]}], ",", "m"}], "]"}]}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{302, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->157005520]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->51589583],

Cell["Integrals:", "ExampleText",
 CellID->8022031],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"JacobiSC", "[", 
    RowBox[{"z", ",", "m"}], "]"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->265886764],

Cell[BoxData[
 FractionBox[
  RowBox[{"Log", "[", 
   RowBox[{
    RowBox[{"JacobiDC", "[", 
     RowBox[{"z", ",", "m"}], "]"}], "+", 
    RowBox[{
     SqrtBox[
      RowBox[{"1", "-", "m"}]], " ", 
     RowBox[{"JacobiNC", "[", 
      RowBox[{"z", ",", "m"}], "]"}]}]}], "]"}], 
  SqrtBox[
   RowBox[{"1", "-", "m"}]]]], "Output",
 ImageSize->{293, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->415474607]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9109],

Cell["\<\
Machine-precision input is insufficient to give the correct answer:\
\>", "ExampleText",
 CellID->455054116],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiSC", "[", 
  RowBox[{
   RowBox[{"10.", "^", "16"}], ",", "Pi"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->259473357],

Cell[BoxData[
 RowBox[{"0.`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->103723141]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"JacobiSC", "[", 
    RowBox[{
     RowBox[{"10", "^", "16"}], ",", "Pi"}], "]"}], ",", "20"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->87579626],

Cell[BoxData[
 RowBox[{"0.59846845608781030117151721488589335852`20.15051499783199", "+", 
  RowBox[{"0``20.373473733161454", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{237, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->156414739]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->34433034],

Cell["\<\
Currently only simple simplification rules are built in for Jacobi functions:\
\
\>", "ExampleText",
 CellID->48769658],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"JacobiSC", "[", 
   RowBox[{"z", ",", "m"}], "]"}], "-", 
  FractionBox[
   RowBox[{"JacobiSN", "[", 
    RowBox[{"z", ",", "m"}], "]"}], 
   RowBox[{"JacobiCN", "[", 
    RowBox[{"z", ",", "m"}], "]"}]]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->566572358],

Cell[BoxData[
 RowBox[{
  RowBox[{"JacobiSC", "[", 
   RowBox[{"z", ",", "m"}], "]"}], "-", 
  FractionBox[
   RowBox[{"JacobiSN", "[", 
    RowBox[{"z", ",", "m"}], "]"}], 
   RowBox[{"JacobiCN", "[", 
    RowBox[{"z", ",", "m"}], "]"}]]}]], "Output",
 ImageSize->{212, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->598184372]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->139217068],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->235476127]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox[
    RowBox[{"JacobiDC", "[", 
     RowBox[{"u", ",", "m"}], "]"}], "2"], "+", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"JacobiSC", "[", 
      RowBox[{"u", ",", "m"}], "]"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "m"}], ")"}]}]}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->475407751],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"JacobiDC", "[", 
    RowBox[{"u", ",", "m"}], "]"}], "2"], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"JacobiSC", "[", 
     RowBox[{"u", ",", "m"}], "]"}], "2"]}]}]], "Output",
 ImageSize->{270, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->475615954]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23192],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseJacobiSC",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseJacobiSC"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiSD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiSD"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiSN",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiSN"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiDC",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiDC"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15555]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8474],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "Tutorials",
 CellID->4597]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->73507806],

Cell[TextData[ButtonBox["Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticFunctions"]], "MoreAbout",
 CellID->81722189]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"JacobiSC - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 51, 37.7473222}", "context" -> "System`", 
    "keywords" -> {
     "doubly periodic function", "elliptic Jacobi function", 
      "Jacobi elliptic function sc", "sc"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "JacobiSC[u, m] gives the Jacobi elliptic function sc(u | m).", 
    "synonyms" -> {"Jacobi SC"}, "title" -> "JacobiSC", "type" -> "Symbol", 
    "uri" -> "ref/JacobiSC"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6273, 221, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->387868632]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 152353, 3413}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2123, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2746, 79, 46, 1, 70, "ObjectName",
 CellID->10307],
Cell[2795, 82, 676, 22, 70, "Usage",
 CellID->23855]
}, Open  ]],
Cell[CellGroupData[{
Cell[3508, 109, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3986, 126, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4109, 132, 391, 15, 70, "Notes",
 CellID->10528],
Cell[4503, 149, 839, 30, 70, "Notes",
 CellID->287578035],
Cell[5345, 181, 215, 7, 70, "Notes",
 CellID->99960195],
Cell[5563, 190, 248, 8, 70, "Notes",
 CellID->191973070],
Cell[5814, 200, 218, 7, 70, "Notes",
 CellID->31226],
Cell[6035, 209, 201, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6273, 221, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->387868632],
Cell[CellGroupData[{
Cell[6658, 235, 148, 5, 70, "ExampleSection",
 CellID->150203541],
Cell[6809, 242, 64, 1, 70, "ExampleText",
 CellID->400288940],
Cell[CellGroupData[{
Cell[6898, 247, 130, 4, 28, "Input",
 CellID->77957898],
Cell[7031, 253, 177, 5, 36, "Output",
 CellID->216709183]
}, Open  ]],
Cell[7223, 261, 125, 3, 70, "ExampleDelimiter",
 CellID->470866374],
Cell[CellGroupData[{
Cell[7373, 268, 290, 10, 28, "Input",
 CellID->175933317],
Cell[7666, 280, 3718, 65, 131, "Output",
 Evaluatable->False,
 CellID->335376579]
}, Open  ]],
Cell[11399, 348, 125, 3, 70, "ExampleDelimiter",
 CellID->137230538],
Cell[11527, 353, 60, 1, 70, "ExampleText",
 CellID->55901019],
Cell[CellGroupData[{
Cell[11612, 358, 245, 8, 70, "Input",
 CellID->461811558],
Cell[11860, 368, 889, 28, 51, "Output",
 CellID->609850181]
}, Open  ]],
Cell[CellGroupData[{
Cell[12786, 401, 245, 8, 70, "Input",
 CellID->240753544],
Cell[13034, 411, 1146, 35, 51, "Output",
 CellID->576626763]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14229, 452, 214, 7, 70, "ExampleSection",
 CellID->194],
Cell[14446, 461, 74, 1, 70, "ExampleText",
 CellID->136651426],
Cell[CellGroupData[{
Cell[14545, 466, 201, 7, 70, "Input",
 CellID->374527875],
Cell[14749, 475, 271, 8, 36, "Output",
 CellID->407356624]
}, Open  ]],
Cell[15035, 486, 125, 3, 70, "ExampleDelimiter",
 CellID->525378932],
Cell[15163, 491, 70, 1, 70, "ExampleText",
 CellID->239493914],
Cell[CellGroupData[{
Cell[15258, 496, 234, 8, 70, "Input",
 CellID->18845098],
Cell[15495, 506, 234, 7, 36, "Output",
 CellID->36188065]
}, Open  ]],
Cell[15744, 516, 125, 3, 70, "ExampleDelimiter",
 CellID->550009612],
Cell[15872, 521, 113, 3, 70, "ExampleText",
 CellID->864577637],
Cell[CellGroupData[{
Cell[16010, 528, 190, 6, 70, "Input",
 CellID->446034805],
Cell[16203, 536, 228, 6, 36, "Output",
 CellID->548079558]
}, Open  ]],
Cell[16446, 545, 125, 3, 70, "ExampleDelimiter",
 CellID->128417124],
Cell[16574, 550, 217, 7, 70, "ExampleText",
 CellID->97071841],
Cell[CellGroupData[{
Cell[16816, 561, 178, 6, 70, "Input",
 CellID->815460718],
Cell[16997, 569, 328, 11, 36, "Output",
 CellID->726762564]
}, Open  ]],
Cell[17340, 583, 123, 3, 70, "ExampleDelimiter",
 CellID->6259999],
Cell[17466, 588, 92, 1, 70, "ExampleText",
 CellID->495463307],
Cell[CellGroupData[{
Cell[17583, 593, 236, 8, 70, "Input",
 CellID->65054936],
Cell[17822, 603, 266, 9, 36, "Output",
 CellID->16231292]
}, Open  ]],
Cell[CellGroupData[{
Cell[18125, 617, 420, 15, 70, "Input",
 CellID->366415397],
Cell[18548, 634, 353, 12, 54, "Output",
 CellID->9216384]
}, Open  ]],
Cell[18916, 649, 124, 3, 70, "ExampleText",
 CellID->26118627],
Cell[CellGroupData[{
Cell[19065, 656, 145, 5, 70, "Input",
 CellID->74535809],
Cell[19213, 663, 234, 8, 36, "Output",
 CellID->17623960]
}, Open  ]],
Cell[CellGroupData[{
Cell[19484, 676, 320, 10, 70, "Input",
 CellID->67735372],
Cell[19807, 688, 216, 7, 36, "Output",
 CellID->221590042]
}, Open  ]],
Cell[20038, 698, 125, 3, 70, "ExampleDelimiter",
 CellID->263264396],
Cell[20166, 703, 203, 7, 70, "ExampleText",
 CellID->804604370],
Cell[CellGroupData[{
Cell[20394, 714, 166, 5, 70, "Input",
 CellID->280453414],
Cell[20563, 721, 278, 9, 50, "Output",
 CellID->352622744]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20890, 736, 239, 7, 70, "ExampleSection",
 CellID->31208],
Cell[21132, 745, 211, 7, 70, "ExampleText",
 CellID->774412347],
Cell[CellGroupData[{
Cell[21368, 756, 241, 8, 70, "Input",
 CellID->85485078],
Cell[21612, 766, 889, 28, 51, "Output",
 CellID->567137196]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22550, 800, 223, 7, 70, "ExampleSection",
 CellID->12626],
Cell[22776, 809, 173, 4, 70, "ExampleText",
 CellID->695240112],
Cell[CellGroupData[{
Cell[22974, 817, 1083, 32, 70, "Input",
 CellID->98575801],
Cell[24060, 851, 82503, 1384, 70, "Output",
 CellID->394962399]
}, Open  ]],
Cell[106578, 2238, 125, 3, 70, "ExampleDelimiter",
 CellID->228220110],
Cell[106706, 2243, 95, 1, 70, "ExampleText",
 CellID->223864426],
Cell[106804, 2246, 1980, 62, 70, "Input",
 CellID->16049754],
Cell[108787, 2310, 79, 1, 70, "ExampleText",
 CellID->84846121],
Cell[108869, 2313, 1417, 45, 70, "Input",
 CellID->272616709],
Cell[CellGroupData[{
Cell[110311, 2362, 868, 28, 70, "Input",
 CellID->126582686],
Cell[111182, 2392, 8669, 146, 70, "Output",
 Evaluatable->False,
 CellID->3208400]
}, Open  ]],
Cell[119866, 2541, 125, 3, 70, "ExampleDelimiter",
 CellID->120139003],
Cell[119994, 2546, 613, 21, 70, "ExampleText",
 CellID->688353202],
Cell[120610, 2569, 289, 10, 70, "Input",
 CellID->59273105],
Cell[120902, 2581, 62, 1, 70, "ExampleText",
 CellID->123023636],
Cell[CellGroupData[{
Cell[120989, 2586, 1144, 39, 70, "Input",
 CellID->107585666],
Cell[122136, 2627, 158, 5, 36, "Output",
 CellID->106952733]
}, Open  ]],
Cell[122309, 2635, 62, 1, 70, "ExampleText",
 CellID->1021720479],
Cell[CellGroupData[{
Cell[122396, 2640, 488, 16, 70, "Input",
 CellID->10394245],
Cell[122887, 2658, 17842, 297, 70, "Output",
 Evaluatable->False,
 CellID->123819582]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[140778, 2961, 233, 7, 70, "ExampleSection",
 CellID->16389],
Cell[141014, 2970, 74, 1, 70, "ExampleText",
 CellID->361783126],
Cell[CellGroupData[{
Cell[141113, 2975, 381, 12, 70, "Input",
 CellID->288300512],
Cell[141497, 2989, 336, 11, 36, "Output",
 CellID->46909267]
}, Open  ]],
Cell[141848, 3003, 246, 8, 70, "ExampleText",
 CellID->785308763],
Cell[CellGroupData[{
Cell[142119, 3015, 106, 3, 70, "Input",
 CellID->22979849],
Cell[142228, 3020, 203, 7, 36, "Output",
 CellID->183795198]
}, Open  ]],
Cell[142446, 3030, 125, 3, 70, "ExampleDelimiter",
 CellID->133706258],
Cell[142574, 3035, 75, 1, 70, "ExampleText",
 CellID->464846584],
Cell[CellGroupData[{
Cell[142674, 3040, 365, 13, 70, "Input",
 CellID->132240831],
Cell[143042, 3055, 453, 8, 70, "Message",
 CellID->394102448],
Cell[143498, 3065, 917, 33, 81, "Output",
 CellID->157005520]
}, Open  ]],
Cell[144430, 3101, 124, 3, 70, "ExampleDelimiter",
 CellID->51589583],
Cell[144557, 3106, 51, 1, 70, "ExampleText",
 CellID->8022031],
Cell[CellGroupData[{
Cell[144633, 3111, 189, 6, 70, "Input",
 CellID->265886764],
Cell[144825, 3119, 464, 17, 64, "Output",
 CellID->415474607]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[145338, 3142, 225, 7, 70, "ExampleSection",
 CellID->9109],
Cell[145566, 3151, 118, 3, 70, "ExampleText",
 CellID->455054116],
Cell[CellGroupData[{
Cell[145709, 3158, 155, 5, 70, "Input",
 CellID->259473357],
Cell[145867, 3165, 240, 7, 36, "Output",
 CellID->103723141]
}, Open  ]],
Cell[CellGroupData[{
Cell[146144, 3177, 213, 8, 70, "Input",
 CellID->87579626],
Cell[146360, 3187, 293, 7, 36, "Output",
 CellID->156414739]
}, Open  ]],
Cell[146668, 3197, 124, 3, 70, "ExampleDelimiter",
 CellID->34433034],
Cell[146795, 3202, 129, 4, 70, "ExampleText",
 CellID->48769658],
Cell[CellGroupData[{
Cell[146949, 3210, 294, 10, 70, "Input",
 CellID->566572358],
Cell[147246, 3222, 383, 13, 53, "Output",
 CellID->598184372]
}, Open  ]],
Cell[CellGroupData[{
Cell[147666, 3240, 108, 3, 70, "Input",
 CellID->139217068],
Cell[147777, 3245, 158, 5, 36, "Output",
 CellID->235476127]
}, Open  ]],
Cell[CellGroupData[{
Cell[147972, 3255, 406, 15, 70, "Input",
 CellID->475407751],
Cell[148381, 3272, 447, 16, 36, "Output",
 CellID->475615954]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[148889, 3295, 311, 9, 70, "SeeAlsoSection",
 CellID->23192],
Cell[149203, 3306, 955, 35, 70, "SeeAlso",
 CellID->15555]
}, Open  ]],
Cell[CellGroupData[{
Cell[150195, 3346, 313, 9, 70, "TutorialsSection",
 CellID->8474],
Cell[150511, 3357, 191, 4, 70, "Tutorials",
 CellID->4597]
}, Open  ]],
Cell[CellGroupData[{
Cell[150739, 3366, 318, 9, 70, "MoreAboutSection",
 CellID->73507806],
Cell[151060, 3377, 146, 3, 70, "MoreAbout",
 CellID->81722189]
}, Open  ]],
Cell[151221, 3383, 27, 0, 70, "History"],
Cell[151251, 3385, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

